/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveToBlock;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityJumpHelper;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.client.render.model.ControlledAnimation;
import thebetweenlands.common.entity.ai.EntityAIAttackOnCollide;
import thebetweenlands.common.entity.ai.EntityAIFlyingWander;
import thebetweenlands.common.entity.mobs.EntityAnadia;
import thebetweenlands.common.entity.movement.FlightMoveHelper;
import thebetweenlands.common.entity.movement.PathNavigateFlyingBL;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityPuffin
extends EntityCreature
implements IEntityBL,
IAnimals {
    private static final DataParameter<Boolean> IS_HOVERING = EntityDataManager.func_187226_a(EntityPuffin.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_DIVING = EntityDataManager.func_187226_a(EntityPuffin.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_LANDING = EntityDataManager.func_187226_a(EntityPuffin.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_FLYING = EntityDataManager.func_187226_a(EntityPuffin.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SHOULD_LAND = EntityDataManager.func_187226_a(EntityPuffin.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SHOULD_TAKE_OFF = EntityDataManager.func_187226_a(EntityPuffin.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> FLYING_TIMER = EntityDataManager.func_187226_a(EntityPuffin.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> RESTING_TIMER = EntityDataManager.func_187226_a(EntityPuffin.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IS_FISHING = EntityDataManager.func_187226_a(EntityPuffin.class, (DataSerializer)DataSerializers.field_187198_h);
    public float animTime;
    public float prevAnimTime;
    public int flapTicks;
    public float flapSpeed = 1.0f;
    private int jumpTicks;
    private int jumpDuration;
    private int currentMoveTypeDuration;
    private boolean wasOnGround;
    private EntityMoveHelper moveHelperAir;
    private EntityMoveHelper moveHelperLand;
    private EntityMoveHelper moveHelperWater;
    private PathNavigateFlyingBL pathNavigatorAir;
    private PathNavigateGround pathNavigatorGround;
    private PathNavigateSwimmer pathNavigatorWater;
    public final ControlledAnimation landingTimer = new ControlledAnimation(10);
    public final ControlledAnimation divingTimer = new ControlledAnimation(10);
    public int MAX_RESTING_TIME = 120;
    public int MAX_FLIGHT_TIME = 360;

    public EntityPuffin(World world) {
        super(world);
        this.func_70105_a(0.75f, 0.9f);
        this.field_70138_W = 1.0f;
        this.moveHelperAir = new FlightMoveHelper((EntityLiving)this);
        this.moveHelperLand = new PuffinMoveHelper(this);
        this.moveHelperWater = new PuffinSwimMoveHelper(this);
        this.field_70767_i = new PuffinJumpHelper(this);
        this.pathNavigatorGround = new PathNavigateGround((EntityLiving)this, world);
        this.pathNavigatorGround.func_179693_d(true);
        this.pathNavigatorAir = new PathNavigateFlyingBL((EntityLiving)this, world, 0);
        this.pathNavigatorWater = new PathNavigateSwimmer((EntityLiving)this, world);
        this.func_184644_a(PathNodeType.WATER, 100.0f);
        this.func_184644_a(PathNodeType.BLOCKED, -8.0f);
        this.func_184644_a(PathNodeType.OPEN, 8.0f);
        this.func_184644_a(PathNodeType.FENCE, -8.0f);
        this.func_184644_a(PathNodeType.DANGER_CACTUS, -8.0f);
        this.updateMovementAndPathfinding();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPuffinLandRandomly(this, 0.5));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIPickUpFish(this, 1.0, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFlyingWanderPuffin(this, 0.5, 10));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIPuffinWanderGround(this, 1.0, 10));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIGoFishing<EntityAnadia>(this, EntityAnadia.class, true, 32.0).func_190882_b(160));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_HOVERING, (Object)false);
        this.field_70180_af.func_187214_a(IS_DIVING, (Object)false);
        this.field_70180_af.func_187214_a(IS_LANDING, (Object)false);
        this.field_70180_af.func_187214_a(IS_FLYING, (Object)false);
        this.field_70180_af.func_187214_a(SHOULD_LAND, (Object)false);
        this.field_70180_af.func_187214_a(SHOULD_TAKE_OFF, (Object)true);
        this.field_70180_af.func_187214_a(RESTING_TIMER, (Object)0);
        this.field_70180_af.func_187214_a(FLYING_TIMER, (Object)0);
        this.field_70180_af.func_187214_a(IS_FISHING, (Object)false);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.updateMovementAndPathfinding();
        if (!this.func_130014_f_().field_72995_K) {
            if (this.getIsFlying()) {
                if (this.field_70170_p.func_82737_E() % 120L == 0L && !this.getIsFishing()) {
                    this.setIsFishing(true);
                }
                this.field_70160_al = true;
                this.field_70122_E = false;
                if (this.getFlyingTimer() < this.MAX_FLIGHT_TIME) {
                    this.setFlyingTimer(this.getFlyingTimer() + 1);
                }
                if (this.getFlyingTimer() >= this.MAX_FLIGHT_TIME && !this.getCanLand()) {
                    this.setCanLand(true);
                    this.setRestingTimer(0);
                }
            }
            if (!this.getIsFlying()) {
                if (this.getIsFishing()) {
                    this.setIsFishing(false);
                }
                this.field_70160_al = false;
                this.field_70122_E = true;
                if (this.getRestingTimer() < this.MAX_RESTING_TIME) {
                    this.setRestingTimer(this.getRestingTimer() + 1);
                }
                if (this.getRestingTimer() >= this.MAX_RESTING_TIME && this.getCanLand()) {
                    this.setCanLand(false);
                    this.setFlyingTimer(0);
                }
            }
        }
        if (this.getIsLanding() && this.func_130014_f_().func_175623_d(this.func_180425_c())) {
            this.field_70181_x -= 0.04;
        }
        if (this.field_70181_x >= 0.0 && !this.func_70090_H() && this.getIsDiving()) {
            this.setIsDiving(false);
        }
        if (this.func_130014_f_().field_72995_K) {
            this.landingTimer.updateTimer();
            this.divingTimer.updateTimer();
            if (this.getIsDiving()) {
                this.divingTimer.increaseTimer();
                this.landingTimer.decreaseTimer();
            } else if (!this.getIsFlying()) {
                this.landingTimer.increaseTimer();
                this.divingTimer.decreaseTimer();
            } else if (!this.getIsDiving() && this.getIsFlying()) {
                this.landingTimer.decreaseTimer();
                this.divingTimer.decreaseTimer(5);
            }
        }
    }

    protected void updateMovementAndPathfinding() {
        this.field_70765_h = this.getIsFlying() && !this.func_70090_H() ? this.moveHelperAir : (this.func_70090_H() ? this.moveHelperWater : this.moveHelperLand);
        this.field_70699_by = this.getIsFlying() && !this.func_70090_H() ? this.pathNavigatorAir : (this.func_70090_H() ? this.pathNavigatorWater : this.pathNavigatorGround);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            ++this.flapTicks;
            if (!this.func_174814_R() && this.getIsFlying()) {
                float flapAngle1 = MathHelper.func_76134_b((float)((float)this.flapTicks * this.flapSpeed));
                float flapAngle2 = MathHelper.func_76134_b((float)((float)(this.flapTicks + 1) * this.flapSpeed));
                if (flapAngle1 <= 0.3f && flapAngle2 > 0.3f) {
                    this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getFlySound(), this.func_184176_by(), this.getIsLanding() ? 0.25f : 0.5f, this.getIsLanding() ? 2.5f + this.field_70146_Z.nextFloat() * 0.3f : 1.8f + this.field_70146_Z.nextFloat() * 0.3f, false);
                }
            }
            if (this.jumpTicks != this.jumpDuration) {
                ++this.jumpTicks;
            } else if (this.jumpDuration != 0) {
                this.jumpTicks = 0;
                this.jumpDuration = 0;
                this.func_70637_d(false);
            }
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.currentMoveTypeDuration > 0) {
            --this.currentMoveTypeDuration;
        }
        if (this.field_70122_E) {
            PuffinJumpHelper puffinjumphelper = (PuffinJumpHelper)this.field_70767_i;
            if (!this.wasOnGround) {
                this.func_70637_d(false);
                this.currentMoveTypeDuration = this.field_70765_h.func_75638_b() < 2.2 ? 10 : 1;
                puffinjumphelper.setCanJump(false);
            }
            if (!puffinjumphelper.getIsJumping()) {
                if (this.field_70765_h.func_75640_a() && this.currentMoveTypeDuration == 0) {
                    Path path = this.field_70699_by.func_75505_d();
                    Vec3d vec3d = new Vec3d(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f());
                    if (path != null && path.func_75873_e() < path.func_75874_d()) {
                        vec3d = path.func_75878_a((Entity)this);
                    }
                    this.calculateRotationYaw(vec3d.field_72450_a, vec3d.field_72449_c);
                    this.startJumping();
                }
            } else if (!puffinjumphelper.canJump()) {
                puffinjumphelper.setCanJump(true);
            }
        }
        this.wasOnGround = this.field_70122_E;
    }

    public void setMovementSpeed(double newSpeed) {
        this.func_70661_as().func_75489_a(newSpeed);
        this.field_70765_h.func_75642_a(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f(), newSpeed);
    }

    public void startJumping() {
        this.func_70637_d(true);
        this.jumpDuration = 10;
        this.jumpTicks = 0;
    }

    protected float func_175134_bD() {
        return 0.2f;
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.func_70090_H()) {
            this.func_191958_b(strafe, vertical, forward, 0.02f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.9;
            this.field_70181_x *= 0.9;
            this.field_70179_y *= 0.9;
        } else if (this.func_180799_ab()) {
            this.func_191958_b(strafe, vertical, forward, 0.02f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
        } else if (this.getIsFlying() && !this.func_70090_H()) {
            float f = 0.91f;
            if (this.field_70122_E) {
                BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
                IBlockState underState = this.field_70170_p.func_180495_p(underPos);
                f = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, underPos, (Entity)this) * 0.91f;
            }
            float f1 = 0.16277136f / (f * f * f);
            this.func_191958_b(strafe, vertical, forward, this.field_70122_E ? 0.1f * f1 : 0.02f);
            f = 0.91f;
            if (this.field_70122_E) {
                BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
                IBlockState underState = this.field_70170_p.func_180495_p(underPos);
                f = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, underPos, (Entity)this) * 0.91f;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)f;
            this.field_70181_x *= (double)f;
            this.field_70179_y *= (double)f;
        } else {
            super.func_191986_a(strafe, vertical, forward);
        }
        this.field_184618_aE = this.field_70721_aZ;
        double d1 = this.field_70165_t - this.field_70169_q;
        double d0 = this.field_70161_v - this.field_70166_s;
        float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    private void calculateRotationYaw(double x, double z) {
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)(z - this.field_70161_v), (double)(x - this.field_70165_t)) * 57.29577951308232) - 90.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getJumpCompletion(float partialTicks) {
        return this.jumpDuration == 0 ? 0.0f : ((float)this.jumpTicks + partialTicks) / (float)this.jumpDuration;
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
    }

    public boolean func_70090_H() {
        this.field_70171_ac = this.func_130014_f_().func_72918_a(this.func_174813_aQ(), Material.field_151586_h, (Entity)this);
        return this.field_70171_ac;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean getShouldTakeOff() {
        return (Boolean)this.field_70180_af.func_187225_a(SHOULD_TAKE_OFF);
    }

    private void setShouldTakeOff(boolean take_off) {
        this.field_70180_af.func_187227_b(SHOULD_TAKE_OFF, (Object)take_off);
    }

    public boolean getCanLand() {
        return (Boolean)this.field_70180_af.func_187225_a(SHOULD_LAND);
    }

    private void setCanLand(boolean land) {
        this.field_70180_af.func_187227_b(SHOULD_LAND, (Object)land);
    }

    public boolean getIsFlying() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_FLYING);
    }

    public void setIsFlying(boolean flying) {
        this.field_70180_af.func_187227_b(IS_FLYING, (Object)flying);
    }

    public int getFlyingTimer() {
        return (Integer)this.field_70180_af.func_187225_a(FLYING_TIMER);
    }

    public void setFlyingTimer(int timer) {
        this.field_70180_af.func_187227_b(FLYING_TIMER, (Object)timer);
    }

    public boolean getIsLanding() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_LANDING);
    }

    public void setIsLanding(boolean landing) {
        this.field_70180_af.func_187227_b(IS_LANDING, (Object)landing);
    }

    public int getRestingTimer() {
        return (Integer)this.field_70180_af.func_187225_a(RESTING_TIMER);
    }

    public void setRestingTimer(int timer) {
        this.field_70180_af.func_187227_b(RESTING_TIMER, (Object)timer);
    }

    public boolean getIsFishing() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_FISHING);
    }

    public void setIsFishing(boolean fishing) {
        this.field_70180_af.func_187227_b(IS_FISHING, (Object)fishing);
    }

    public boolean getIsHovering() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_HOVERING);
    }

    public void setIsHovering(boolean hovering) {
        this.field_70180_af.func_187227_b(IS_HOVERING, (Object)hovering);
    }

    public boolean getIsDiving() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_DIVING);
    }

    public void setIsDiving(boolean diving) {
        this.field_70180_af.func_187227_b(IS_DIVING, (Object)diving);
    }

    protected ResourceLocation func_184647_J() {
        return null;
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent getFlySound() {
        return SoundRegistry.CHIROMAW_MATRIARCH_FLAP;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public boolean func_70652_k(Entity entityIn) {
        return EntityAIAttackOnCollide.useStandardAttack((EntityLiving)this, entityIn);
    }

    public int func_70641_bl() {
        return 3;
    }

    public float func_180484_a(BlockPos pos) {
        return 0.5f;
    }

    class PuffinSwimMoveHelper
    extends EntityMoveHelper {
        private final EntityPuffin puffin;

        public PuffinSwimMoveHelper(EntityPuffin puffinIn) {
            super((EntityLiving)puffinIn);
            this.puffin = puffinIn;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO && !this.puffin.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.puffin.field_70165_t;
                double d1 = this.field_75647_c - this.puffin.field_70163_u;
                double d2 = this.field_75644_d - this.puffin.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                d3 = MathHelper.func_76133_a((double)d3);
                d1 /= d3;
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
                this.puffin.field_70761_aq = this.puffin.field_70177_z = this.func_75639_a(this.puffin.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.puffin.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                this.puffin.func_70659_e(this.puffin.func_70689_ay() + (f1 - this.puffin.func_70689_ay()) * 0.125f);
                double d4 = Math.sin((double)(this.puffin.field_70173_aa + this.puffin.func_145782_y()) * 0.5) * 0.05;
                double d5 = Math.cos(this.puffin.field_70177_z * ((float)Math.PI / 180));
                double d6 = Math.sin(this.puffin.field_70177_z * ((float)Math.PI / 180));
                this.puffin.field_70159_w += d4 * d5;
                this.puffin.field_70179_y += d4 * d6;
                d4 = Math.sin((double)(this.puffin.field_70173_aa + this.puffin.func_145782_y()) * 0.75) * 0.05;
                this.puffin.field_70181_x += d4 * (d6 + d5) * 0.25;
                if (Math.abs(this.puffin.field_70181_x) < 0.35) {
                    this.puffin.field_70181_x = this.puffin.field_70181_x + (double)this.puffin.func_70689_ay() * d1 * 0.1 * (2.0 + (d1 > 0.0 ? 0.4 : 0.0) + (double)(this.puffin.field_70123_F ? 20 : 0));
                }
                EntityLookHelper entitylookhelper = this.puffin.func_70671_ap();
                double d7 = this.puffin.field_70165_t + d0 / d3 * 2.0;
                double d8 = (double)this.puffin.func_70047_e() + this.puffin.field_70163_u + d1 / d3;
                double d9 = this.puffin.field_70161_v + d2 / d3 * 2.0;
                double d10 = entitylookhelper.func_180423_e();
                double d11 = entitylookhelper.func_180422_f();
                double d12 = entitylookhelper.func_180421_g();
                if (!entitylookhelper.func_180424_b()) {
                    d10 = d7;
                    d11 = d8;
                    d12 = d9;
                }
                this.puffin.func_70671_ap().func_75650_a(d10 + (d7 - d10) * 0.125, d11 + (d8 - d11) * 0.125, d12 + (d9 - d12) * 0.125, 10.0f, 40.0f);
            } else {
                this.puffin.func_70659_e(0.0f);
            }
        }
    }

    static class PuffinMoveHelper
    extends EntityMoveHelper {
        private final EntityPuffin puffin;
        private double nextJumpSpeed;

        public PuffinMoveHelper(EntityPuffin puffin) {
            super((EntityLiving)puffin);
            this.puffin = puffin;
        }

        public void func_75641_c() {
            if (this.puffin.field_70122_E && !this.puffin.field_70703_bu && !((PuffinJumpHelper)this.puffin.field_70767_i).getIsJumping()) {
                this.puffin.setMovementSpeed(0.0);
            } else if (this.func_75640_a()) {
                this.puffin.setMovementSpeed(this.nextJumpSpeed);
            }
            super.func_75641_c();
        }

        public void func_75642_a(double x, double y, double z, double speedIn) {
            if (this.puffin.func_70090_H()) {
                speedIn = 1.5;
            }
            super.func_75642_a(x, y, z, speedIn);
            if (speedIn > 0.0) {
                this.nextJumpSpeed = speedIn;
            }
        }
    }

    public class PuffinJumpHelper
    extends EntityJumpHelper {
        private final EntityPuffin puffin;
        private boolean canJump;

        public PuffinJumpHelper(EntityPuffin puffin) {
            super((EntityLiving)puffin);
            this.puffin = puffin;
        }

        public boolean getIsJumping() {
            return this.field_75662_b;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean canJumpIn) {
            this.canJump = canJumpIn;
        }

        public void func_75661_b() {
            if (this.field_75662_b) {
                this.puffin.startJumping();
                this.field_75662_b = false;
            }
        }
    }

    class EntityAIPickUpFish
    extends EntityAIBase {
        World world;
        protected int attackTick;
        double speedTowardsTarget;
        boolean longMemory;
        Path path;
        private int delayCounter;
        private double targetX;
        private double targetY;
        private double targetZ;
        protected final int attackInterval = 20;
        private int failedPathFindingPenalty = 0;
        private boolean canPenalize = false;
        private final EntityPuffin puffin;

        public EntityAIPickUpFish(EntityPuffin puffinIn, double speedIn, boolean useLongMemory) {
            this.puffin = puffinIn;
            this.world = this.puffin.field_70170_p;
            this.speedTowardsTarget = speedIn;
            this.longMemory = useLongMemory;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.puffin.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            if (!entitylivingbase.func_70089_S()) {
                return false;
            }
            if (!(entitylivingbase instanceof EntityAnadia)) {
                return false;
            }
            if (!this.puffin.getIsFlying()) {
                return false;
            }
            this.path = this.puffin.func_70661_as().func_75488_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u + 6.0, entitylivingbase.field_70161_v);
            if (this.path != null) {
                return true;
            }
            return this.getAttackReachSqr(entitylivingbase) >= this.puffin.func_70092_e(entitylivingbase.field_70165_t, entitylivingbase.func_174813_aQ().field_72338_b + 6.0, entitylivingbase.field_70161_v);
        }

        public boolean func_75253_b() {
            EntityLivingBase entitylivingbase = this.puffin.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            if (!this.puffin.getIsFishing()) {
                return false;
            }
            if (!entitylivingbase.func_70089_S()) {
                return false;
            }
            if (!this.longMemory) {
                return !this.puffin.func_70661_as().func_75500_f();
            }
            return !(entitylivingbase instanceof EntityAnadia);
        }

        public void func_75249_e() {
            this.puffin.func_70661_as().func_75484_a(this.path, this.speedTowardsTarget);
            this.delayCounter = 0;
        }

        public void func_75251_c() {
            this.puffin.func_70624_b(null);
            this.puffin.func_70661_as().func_75499_g();
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.puffin.func_70638_az();
            if (entitylivingbase == null) {
                return;
            }
            this.puffin.func_70671_ap().func_75651_a((Entity)entitylivingbase, 30.0f, 30.0f);
            double distToEnemySqr = this.puffin.func_70092_e(entitylivingbase.field_70165_t, entitylivingbase.func_174813_aQ().field_72338_b, entitylivingbase.field_70161_v);
            --this.delayCounter;
            if ((this.longMemory || this.puffin.func_70635_at().func_75522_a((Entity)entitylivingbase)) && this.delayCounter <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || entitylivingbase.func_70092_e(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.puffin.func_70681_au().nextFloat() < 0.05f)) {
                this.targetX = entitylivingbase.field_70165_t;
                this.targetY = entitylivingbase.func_174813_aQ().field_72338_b + 6.0;
                this.targetZ = entitylivingbase.field_70161_v;
                this.puffin.func_70661_as().func_75492_a(this.targetX, this.targetY, this.targetZ, this.speedTowardsTarget);
                this.delayCounter = 4 + this.puffin.func_70681_au().nextInt(7);
                if (distToEnemySqr > 1024.0) {
                    this.delayCounter += 10;
                } else if (distToEnemySqr > 256.0) {
                    this.delayCounter += 5;
                }
                if (!this.puffin.func_70661_as().func_75492_a(this.targetX, this.targetY, this.targetZ, this.speedTowardsTarget)) {
                    this.delayCounter += 15;
                }
            }
            if (!this.puffin.func_70090_H() && Math.floor(this.puffin.field_70165_t) == Math.floor(this.targetX) && Math.floor(this.puffin.field_70163_u) >= Math.floor(this.targetY) && Math.floor(this.puffin.field_70161_v) == Math.floor(this.targetZ)) {
                if (!this.puffin.func_70661_as().func_75497_a((Entity)entitylivingbase, this.speedTowardsTarget * 2.0)) {
                    this.puffin.setIsDiving(false);
                    this.puffin.setIsFishing(false);
                } else {
                    this.puffin.setIsDiving(true);
                }
            } else if (this.puffin.func_70090_H() && this.puffin.func_70661_as().func_75497_a((Entity)entitylivingbase, this.speedTowardsTarget * 0.5)) {
                this.puffin.setIsDiving(false);
            }
            double attackReachSq = this.getAttackReachSqr(entitylivingbase);
            if (distToEnemySqr <= attackReachSq && this.attackTick <= 0) {
                this.attackTick = 20;
                if (entitylivingbase instanceof EntityAnadia) {
                    this.puffin.setIsDiving(false);
                    entitylivingbase.func_70106_y();
                    this.puffin.setIsFishing(false);
                    System.out.println("Caught a fish");
                }
                this.func_75251_c();
            }
            this.attackTick = Math.max(this.attackTick - 1, 0);
        }

        protected double getAttackReachSqr(EntityLivingBase attackTarget) {
            return this.puffin.field_70130_N * 2.0f * this.puffin.field_70130_N * 2.0f + attackTarget.field_70130_N;
        }
    }

    public class EntityAIGoFishing<T extends EntityLivingBase>
    extends EntityAINearestAttackableTarget<T> {
        protected double baseRange;
        protected double revengeRange;
        private final EntityPuffin puffin;

        public EntityAIGoFishing(EntityPuffin puffinIn, Class<T> classTarget, boolean checkSight, double rangeIn) {
            super((EntityCreature)puffinIn, classTarget, checkSight);
            this.baseRange = this.revengeRange = rangeIn;
            this.puffin = puffinIn;
            this.func_75248_a(3);
        }

        public EntityAIGoFishing(EntityPuffin puffinIn, Class<T> classTarget, int chance, boolean checkSight, @Nullable boolean onlyNearby, Predicate<? super T> targetSelector) {
            super((EntityCreature)puffinIn, classTarget, chance, checkSight, onlyNearby, targetSelector);
            this.puffin = puffinIn;
        }

        public boolean func_75250_a() {
            if (super.func_75250_a()) {
                return this.puffin.getIsFishing() && this.puffin.getIsFlying() && !this.puffin.getIsDiving();
            }
            return false;
        }

        protected AxisAlignedBB func_188511_a(double targetDistance) {
            return this.puffin.func_174813_aQ().func_72314_b(targetDistance, targetDistance, targetDistance);
        }

        protected double func_111175_f() {
            if (EntityPuffin.this.func_70643_av() != null) {
                EntityPuffin.this.func_70624_b(EntityPuffin.this.func_70643_av());
                this.revengeRange = EntityPuffin.this.func_70032_d((Entity)EntityPuffin.this.func_70643_av());
            }
            return Math.max(this.baseRange, this.revengeRange);
        }
    }

    class EntityAIPuffinLandRandomly
    extends EntityAIMoveToBlock {
        private final EntityPuffin puffin;

        public EntityAIPuffinLandRandomly(EntityPuffin puffinIn, double speed) {
            super((EntityCreature)puffinIn, speed, 16);
            this.puffin = puffinIn;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            return this.puffin.getCanLand() && super.func_75250_a() && !this.puffin.getIsFishing();
        }

        public void func_75249_e() {
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            return this.puffin.getCanLand() && super.func_75253_b();
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        public void func_75246_d() {
            super.func_75246_d();
            if (this.func_179487_f()) {
                if (this.puffin.getIsFlying()) {
                    this.puffin.setIsFlying(false);
                }
                if (!this.puffin.getIsLanding()) {
                    this.puffin.setIsLanding(true);
                }
            }
        }

        protected boolean func_179488_a(World world, BlockPos pos) {
            if (!world.func_175623_d(pos.func_177984_a())) {
                return false;
            }
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            return state.isSideSolid((IBlockAccess)world, pos, EnumFacing.UP);
        }
    }

    class EntityAIFlyingWanderPuffin
    extends EntityAIFlyingWander {
        private final EntityPuffin puffin;

        public EntityAIFlyingWanderPuffin(EntityPuffin puffinIn, double speedIn, int chance) {
            super(puffinIn, speedIn, chance);
            this.puffin = puffinIn;
            this.func_75248_a(3);
        }

        @Override
        public boolean func_75250_a() {
            return super.func_75250_a();
        }

        @Override
        public boolean func_75253_b() {
            return !this.puffin.getCanLand() && super.func_75253_b();
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
        }

        public void func_75246_d() {
            super.func_75246_d();
            if (!this.puffin.getIsFlying()) {
                this.puffin.setIsFlying(true);
            }
            if (this.puffin.getIsLanding()) {
                this.puffin.setIsLanding(false);
            }
        }
    }

    class EntityAIPuffinSwim
    extends EntityAISwimming {
        private final EntityPuffin puffin;

        public EntityAIPuffinSwim(EntityPuffin puffinIn) {
            super((EntityLiving)puffinIn);
            this.puffin = puffinIn;
            this.func_75248_a(4);
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.puffin.getIsDiving();
        }
    }

    class EntityAIPuffinWanderGround
    extends EntityAIWander {
        private final EntityPuffin puffin;

        public EntityAIPuffinWanderGround(EntityPuffin puffinIn, double speedIn, int chance) {
            super((EntityCreature)puffinIn, speedIn, chance);
            this.puffin = puffinIn;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.puffin.getIsFlying();
        }
    }
}

