/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityOlm
extends EntityCreature
implements IEntityBL,
IAnimals {
    public long egg_cooldown;

    public EntityOlm(World world) {
        super(world);
        this.func_70105_a(0.95f, 0.25f);
        this.field_70765_h = new OlmMoveHelper(this);
        this.func_184644_a(PathNodeType.WALKABLE, -8.0f);
        this.func_184644_a(PathNodeType.BLOCKED, -8.0f);
        this.func_184644_a(PathNodeType.WATER, 16.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.4, 20));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.4));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundRegistry.OLM_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.OLM_DEATH;
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187593_cC;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.OLM;
    }

    public boolean func_70601_bi() {
        return this.field_70163_u <= 15.0 && this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c() == BlockRegistry.SWAMP_WATER;
    }

    public PathNavigate func_175447_b(World world) {
        return new PathNavigateSwimmer((EntityLiving)this, world);
    }

    public float func_180484_a(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h ? 10.0f + this.field_70170_p.func_175724_o(pos) - 0.5f : super.func_180484_a(pos);
    }

    public void func_70636_d() {
        if (this.field_70171_ac) {
            this.func_70050_g(300);
        } else if (this.field_70122_E && this.func_130014_f_().func_82737_E() % 20L == 0L) {
            this.func_70665_d(DamageSource.field_76369_e, 0.5f);
        }
        super.func_70636_d();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        player.func_184609_a(hand);
        if (!this.func_130014_f_().field_72995_K && !stack.func_190926_b() && ItemMisc.EnumItemMisc.SNOT.isItemOf(stack) && this.getCanLayEgg()) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
                if (stack.func_190916_E() <= 0) {
                    player.func_184611_a(hand, ItemStack.field_190927_a);
                }
            }
            this.setEggCooldown(this.func_130014_f_().func_82737_E() + 24000L);
            this.func_70099_a(new ItemStack(ItemRegistry.OLM_EGG_RAW), 0.0f);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    private boolean getCanLayEgg() {
        return this.func_130014_f_().func_82737_E() >= this.getEggCooldown();
    }

    public void setEggCooldown(long cooldownTime) {
        this.egg_cooldown = cooldownTime;
    }

    public long getEggCooldown() {
        return this.egg_cooldown;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74772_a("egg_cooldown", this.getEggCooldown());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setEggCooldown(nbt.func_74763_f("egg_cooldown"));
    }

    public void func_191986_a(float strafe, float up, float forward) {
        if (this.func_70613_aW()) {
            if (this.func_70090_H()) {
                this.func_191958_b(strafe, up, forward, 0.1f);
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= 0.75;
                this.field_70181_x *= 0.75;
                this.field_70179_y *= 0.75;
                if (this.func_70638_az() == null) {
                    this.field_70181_x -= 0.003;
                }
            } else {
                super.func_191986_a(strafe, up, forward);
            }
        } else {
            super.func_191986_a(strafe, up, forward);
        }
    }

    public boolean func_70058_J() {
        return this.func_130014_f_().func_72917_a(this.func_174813_aQ(), (Entity)this) && this.func_130014_f_().func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty();
    }

    public boolean func_96092_aw() {
        return false;
    }

    static class OlmMoveHelper
    extends EntityMoveHelper {
        private final EntityOlm olm;

        public OlmMoveHelper(EntityOlm olm) {
            super((EntityLiving)olm);
            this.olm = olm;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO && !this.olm.func_70661_as().func_75500_f()) {
                double targetX = this.field_75646_b - this.olm.field_70165_t;
                double targetY = this.field_75647_c - this.olm.field_70163_u;
                double targetZ = this.field_75644_d - this.olm.field_70161_v;
                double targetDistance = targetX * targetX + targetY * targetY + targetZ * targetZ;
                targetDistance = MathHelper.func_76133_a((double)targetDistance);
                targetY /= targetDistance;
                float targetAngle = (float)(MathHelper.func_181159_b((double)targetZ, (double)targetX) * 57.29577951308232) - 90.0f;
                this.olm.field_70761_aq = this.olm.field_70177_z = this.func_75639_a(this.olm.field_70177_z, targetAngle, 90.0f);
                float travelSpeed = (float)(this.field_75645_e * this.olm.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                this.olm.func_70659_e(this.olm.func_70689_ay() + (travelSpeed - this.olm.func_70689_ay()) * 0.125f);
                double wiggleSpeed = Math.sin((double)(this.olm.field_70173_aa + this.olm.func_145782_y()) * 0.5) * (double)this.olm.field_70131_O * 0.05;
                double wiggleOffsetX = Math.cos(this.olm.field_70177_z * ((float)Math.PI / 180));
                double wiggleOffsetZ = Math.sin(this.olm.field_70177_z * ((float)Math.PI / 180));
                this.olm.field_70159_w += wiggleSpeed * wiggleOffsetX;
                this.olm.field_70179_y += wiggleSpeed * wiggleOffsetZ;
                wiggleSpeed = Math.sin((double)(this.olm.field_70173_aa + this.olm.func_145782_y()) * 0.75) * 0.05;
                this.olm.field_70181_x += wiggleSpeed * (wiggleOffsetZ + wiggleOffsetX) * 0.25;
                this.olm.field_70181_x += (double)this.olm.func_70689_ay() * targetY * 0.1;
                EntityLookHelper entitylookhelper = this.olm.func_70671_ap();
                double targetDirectionX = this.olm.field_70165_t + targetX / targetDistance * 2.0;
                double targetDirectionY = (double)this.olm.func_70047_e() + this.olm.field_70163_u + targetY / targetDistance;
                double targetDirectionZ = this.olm.field_70161_v + targetZ / targetDistance * 2.0;
                double lookX = entitylookhelper.func_180423_e();
                double lookY = entitylookhelper.func_180422_f();
                double lookZ = entitylookhelper.func_180421_g();
                if (!entitylookhelper.func_180424_b()) {
                    lookX = targetDirectionX;
                    lookY = targetDirectionY;
                    lookZ = targetDirectionZ;
                }
                this.olm.func_70671_ap().func_75650_a(lookX + (targetDirectionX - lookX) * 0.125, lookY + (targetDirectionY - lookY) * 0.125, lookZ + (targetDirectionZ - lookZ) * 0.125, 10.0f, 40.0f);
            } else {
                this.olm.func_70659_e(0.0f);
            }
        }
    }
}

