/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.entity.mobs.EntityMovingWallFace;
import thebetweenlands.common.entity.mobs.EntitySludgeWorm;
import thebetweenlands.common.registries.LootTableRegistry;

public class EntityMovingSpawnerHole
extends EntityMovingWallFace
implements IMob {
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite wallSprite;
    protected int spawnCount = 3;
    protected int spawnCooldown = 0;
    protected double maxTargetRange = 6.0;
    protected double countCheckRange = 8.0;
    protected int maxCount = 5;

    public EntityMovingSpawnerHole(World world) {
        super(world);
        this.lookMoveSpeedMultiplier = 4.0f;
        this.field_70728_aV = 5;
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        this.spawnCount = 2 + this.field_70146_Z.nextInt(3);
        return super.func_180482_a(difficulty, livingdata);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null).func_190882_b(120));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityMovingWallFace.AITrackTarget<EntityMovingSpawnerHole>(this, true, 28.0){

            @Override
            protected boolean canMove() {
                return true;
            }
        });
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AISpawnMob(this, 7, 18));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.08);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.spawnCooldown > 0) {
                --this.spawnCooldown;
            }
            if (!this.isSpawningMob() && this.spawnCount <= 0) {
                this.func_70106_y();
            }
        } else {
            this.updateWallSprite();
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("spawnCount", this.spawnCount);
        nbt.func_74768_a("spawnCooldown", this.spawnCooldown);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_150297_b("spawnCount", 3)) {
            this.spawnCount = nbt.func_74762_e("spawnCount");
        }
        if (nbt.func_150297_b("spawnCooldown", 3)) {
            this.spawnCooldown = nbt.func_74762_e("spawnCooldown");
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateWallSprite() {
        this.wallSprite = null;
        BlockPos pos = this.func_180425_c();
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        if ((state = state.func_185899_b((IBlockAccess)this.field_70170_p, pos)).func_185917_h()) {
            this.wallSprite = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
        }
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getWallSprite() {
        return this.wallSprite;
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.MOVING_SPAWNER_HOLE;
    }

    @Override
    public boolean canResideInBlock(BlockPos pos, EnumFacing facing, EnumFacing facingUp) {
        return this.isValidBlockForMovement(pos, this.field_70170_p.func_180495_p(pos)) && facing != EnumFacing.UP;
    }

    @Override
    protected boolean isValidBlockForMovement(BlockPos pos, IBlockState state) {
        return state.func_185914_p() && state.func_185915_l() && state.func_185917_h() && state.func_185887_b(this.field_70170_p, pos) > 0.0f && state.func_185904_a() == Material.field_151576_e;
    }

    @Override
    public Vec3d getOffset(float movementProgress) {
        return super.getOffset(1.0f);
    }

    public float getHoleDepthPercent(float partialTicks) {
        return this.getHalfMovementProgress(partialTicks);
    }

    protected Entity createEntity(Vec3d holeBottom, double frontOffset, EnumFacing facing) {
        EntitySludgeWorm entity = new EntitySludgeWorm(this.field_70170_p);
        entity.func_70012_b(holeBottom.field_72450_a, holeBottom.field_72448_b, holeBottom.field_72449_c, facing.func_185119_l(), 0.0f);
        entity.func_70091_d(MoverType.SELF, (double)facing.func_82601_c() * 0.35, facing == EnumFacing.UP ? 1.0 : 0.0, (double)facing.func_82599_e() * 0.35);
        return entity;
    }

    protected Predicate<Entity> getNearbySpawnedEntitiesPredicate() {
        return entity -> entity instanceof EntitySludgeWorm;
    }

    public void startSpawningMob() {
        BlockPos pos = this.func_180425_c();
        Entity entity = this.createEntity(new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5), 0.55, this.getFacing());
        if (entity != null) {
            if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).func_180482_a(this.field_70170_p.func_175649_E(new BlockPos(entity)), (IEntityLivingData)null);
            }
            this.field_70170_p.func_72838_d(entity);
            this.field_70170_p.func_175718_b(2004, this.func_180425_c(), 0);
        }
        --this.spawnCount;
        this.spawnCooldown = 40;
    }

    public boolean isSpawningMob() {
        return this.spawnCooldown > 0;
    }

    public boolean canSpawnMobs() {
        EntityLivingBase target = this.func_70638_az();
        if (target != null && !this.isSpawningMob() && (double)this.func_70032_d((Entity)target) < this.maxTargetRange && this.func_70685_l((Entity)target)) {
            Predicate<Entity> pred = this.getNearbySpawnedEntitiesPredicate();
            int others = this.field_70170_p.func_175647_a(Entity.class, this.func_174813_aQ().func_186662_g(this.countCheckRange), pred).size();
            return others < this.maxCount;
        }
        return false;
    }

    protected static class AISpawnMob
    extends EntityAIBase {
        protected final EntityMovingSpawnerHole entity;
        protected int minSpawnCooldown;
        protected int maxSpawnCooldown;
        protected int spawnCooldown;

        public AISpawnMob(EntityMovingSpawnerHole entity, int minSpawnCooldown, int maxSpawnCooldown) {
            this.entity = entity;
            this.minSpawnCooldown = minSpawnCooldown;
            this.maxSpawnCooldown = maxSpawnCooldown;
            this.spawnCooldown = minSpawnCooldown + entity.field_70146_Z.nextInt(maxSpawnCooldown - minSpawnCooldown);
        }

        public boolean func_75250_a() {
            if (--this.spawnCooldown <= 0) {
                this.spawnCooldown = this.minSpawnCooldown + this.entity.field_70146_Z.nextInt(this.maxSpawnCooldown - this.minSpawnCooldown);
                return this.entity.func_70089_S() && !this.entity.isMoving() && this.entity.isAnchored() && this.entity.canSpawnMobs();
            }
            return false;
        }

        public void func_75249_e() {
            this.entity.startSpawningMob();
        }

        public boolean func_75253_b() {
            return false;
        }
    }
}

