/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.entity.ai.EntityAvoidEntityFlatPath;
import thebetweenlands.common.entity.movement.PathNavigateAboveWater;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.util.NonNullDelegateList;

public class EntityGreeblingCoracle
extends EntityCreature
implements IEntityBL {
    protected static final byte EVENT_DISAPPEAR = 41;
    protected static final byte EVENT_SPOUT = 42;
    private static final DataParameter<Integer> SINKING_TICKS = EntityDataManager.func_187226_a(EntityGreeblingCoracle.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LOOT_CLICKS = EntityDataManager.func_187226_a(EntityGreeblingCoracle.class, (DataSerializer)DataSerializers.field_187192_b);
    private EntityAvoidEntityFlatPath<EntityPlayer> avoidPlayer;
    private AIWaterWander waterWander;
    private EntityAILookIdle lookIdle;
    private boolean hasSetAIForEmptyBoat = false;
    private boolean looted = false;
    private NonNullList<ItemStack> loot = NonNullList.func_191196_a();
    private int shutUpFFSTime;
    public int rowTicks;
    public float rowSpeed = 0.5f;

    public EntityGreeblingCoracle(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.0f);
        this.func_184644_a(PathNodeType.WALKABLE, -100.0f);
        this.func_184644_a(PathNodeType.BLOCKED, -100.0f);
        this.func_184644_a(PathNodeType.LAVA, -100.0f);
        this.func_184644_a(PathNodeType.WATER, 16.0f);
        this.field_70138_W = 0.0f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SINKING_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(LOOT_CLICKS, (Object)0);
    }

    protected void func_184651_r() {
        this.avoidPlayer = new EntityAvoidEntityFlatPath<EntityPlayer>(this, EntityPlayer.class, 16.0f, 4.0, 8.0);
        this.waterWander = new AIWaterWander(this, 0.5, 30);
        this.lookIdle = new EntityAILookIdle((EntityLiving)this);
        this.field_70714_bg.func_75776_a(0, this.avoidPlayer);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.waterWander);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.lookIdle);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    protected PathNavigate func_175447_b(World world) {
        return new PathNavigateAboveWater((EntityLiving)this, world);
    }

    public float func_180484_a(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h ? 10.0f + this.field_70170_p.func_175724_o(pos) - 0.5f : super.func_180484_a(pos);
    }

    public boolean func_70601_bi() {
        int y = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        if (y <= 121 && y > 110) {
            return this.func_130014_f_().func_72855_b(this.func_174813_aQ()) && this.func_130014_f_().func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && this.func_130014_f_().func_72875_a(this.func_174813_aQ().func_72317_d(0.0, -0.5, 0.0), Material.field_151586_h);
        }
        return false;
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.getSinkingTicks() <= 0) {
            ++this.rowTicks;
            if (!this.func_174814_R() && this.field_70165_t != this.field_70142_S && this.field_70161_v != this.field_70136_U) {
                float rowAngle1 = MathHelper.func_76134_b((float)((float)this.rowTicks * this.rowSpeed));
                float rowAngle2 = MathHelper.func_76134_b((float)((float)(this.rowTicks + 1) * this.rowSpeed));
                if (rowAngle1 <= 0.8f && rowAngle2 > 0.8f) {
                    this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187549_bG, this.func_184176_by(), 0.2f, 0.8f + 0.4f * this.field_70146_Z.nextFloat(), false);
                }
            }
        }
        if (this.shutUpFFSTime > 0) {
            --this.shutUpFFSTime;
            this.field_70757_a = -this.func_70627_aG();
        }
        if (this.func_130014_f_().func_72953_d(this.func_174813_aQ()) && this.getSinkingTicks() <= 200) {
            this.field_70181_x += 0.06;
        }
        if (this.getSinkingTicks() > 0) {
            this.field_70159_w *= 0.975;
            this.field_70179_y *= 0.975;
        }
        if (this.isGreeblingAboveWater() && this.getSinkingTicks() <= 200) {
            if (this.field_70181_x < 0.0) {
                this.field_70181_x = 0.0;
            }
            this.field_70143_R = 0.0f;
        } else {
            this.field_70181_x = -0.0075;
        }
        this.field_184619_aG = (float)((double)this.field_184619_aG + 0.5);
        if (this.field_70165_t != this.field_70142_S && this.field_70161_v != this.field_70136_U) {
            this.field_70721_aZ = (float)((double)this.field_70721_aZ + 0.5);
        }
        if (!this.func_130014_f_().field_72995_K) {
            if (this.getSinkingTicks() == 200 && this.isGreeblingAboveWater()) {
                this.field_70170_p.func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.CORACLE_SINK, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }
            if (this.getSinkingTicks() > 0 && this.getSinkingTicks() < 400) {
                this.setSinkingTicks(this.getSinkingTicks() + 1);
            }
            if (this.getSinkingTicks() == 5) {
                this.func_130014_f_().func_72960_a((Entity)this, (byte)41);
            }
            if (this.getSinkingTicks() >= 200 && this.getSinkingTicks() <= 400 && this.isGreeblingAboveWater()) {
                this.func_130014_f_().func_72960_a((Entity)this, (byte)42);
            }
            if (this.getSinkingTicks() > 0 && !this.hasSetAIForEmptyBoat) {
                this.field_70714_bg.func_85156_a(this.avoidPlayer);
                this.field_70714_bg.func_85156_a((EntityAIBase)this.waterWander);
                this.field_70714_bg.func_85156_a((EntityAIBase)this.lookIdle);
                if (this.func_70661_as().func_75505_d() != null) {
                    this.func_70661_as().func_75499_g();
                }
                this.hasSetAIForEmptyBoat = true;
            }
            if (this.getSinkingTicks() >= 400) {
                this.func_70106_y();
            }
            List nearPlayers = this.func_130014_f_().func_175647_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(2.5, 2.5, 2.5), e -> !e.field_71075_bZ.field_75098_d && !e.func_82150_aj());
            if (this.getSinkingTicks() == 0 && !nearPlayers.isEmpty()) {
                this.setSinkingTicks(this.getSinkingTicks() + 1);
                this.func_130014_f_().func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, (SoundEvent)SoundRegistry.GREEBLING_VANISH, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }
        }
    }

    public boolean isGreeblingAboveWater() {
        AxisAlignedBB floatingBox = new AxisAlignedBB(this.func_174813_aQ().field_72340_a + 0.25, this.func_174813_aQ().field_72338_b + (double)0.12f, this.func_174813_aQ().field_72339_c + 0.25, this.func_174813_aQ().field_72336_d - 0.25, this.func_174813_aQ().field_72338_b + 0.0625, this.func_174813_aQ().field_72334_f - 0.25);
        return this.func_130014_f_().func_72953_d(floatingBox);
    }

    public void setSinkingTicks(int count) {
        this.field_70180_af.func_187227_b(SINKING_TICKS, (Object)count);
    }

    public int getSinkingTicks() {
        return (Integer)this.field_70180_af.func_187225_a(SINKING_TICKS);
    }

    public void setLootClicks(int count) {
        this.field_70180_af.func_187227_b(LOOT_CLICKS, (Object)count);
    }

    public int getLootClicks() {
        return (Integer)this.field_70180_af.func_187225_a(LOOT_CLICKS);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("sinkingTicks", this.getSinkingTicks());
        nbt.func_74757_a("Looted", this.looted);
        nbt.func_74768_a("LootCount", this.loot.size());
        nbt.func_74768_a("LootClicks", this.getLootClicks());
        nbt.func_74782_a("Loot", (NBTBase)ItemStackHelper.func_191281_a((NBTTagCompound)new NBTTagCompound(), this.loot, (boolean)false));
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setSinkingTicks(nbt.func_74762_e("sinkingTicks"));
        this.looted = nbt.func_74767_n("Looted");
        this.loot = NonNullList.func_191197_a((int)nbt.func_74762_e("LootCount"), (Object)ItemStack.field_190927_a);
        this.setLootClicks(nbt.func_74762_e("lootClicks"));
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt.func_74775_l("Loot"), this.loot);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 41) {
            this.doLeafEffects();
        }
        if (id == 42) {
            this.doSpoutEffects();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doSpoutEffects() {
        if (this.func_130014_f_().field_72995_K) {
            int count = this.getSinkingTicks() <= 240 ? 40 : 10;
            float x = (float)this.field_70165_t;
            float y = (float)(this.field_70163_u + 0.25);
            float z = (float)this.field_70161_v;
            while (count-- > 0) {
                float dx = this.func_130014_f_().field_73012_v.nextFloat() * 0.25f - 0.1255f;
                float dy = this.func_130014_f_().field_73012_v.nextFloat() * 0.25f - 0.1255f;
                float dz = this.func_130014_f_().field_73012_v.nextFloat() * 0.25f - 0.1255f;
                float mag = 0.08f + this.func_130014_f_().field_73012_v.nextFloat() * 0.07f;
                int waterColor = BiomeColorHelper.func_180288_c((IBlockAccess)this.field_70170_p, (BlockPos)new BlockPos((Entity)this));
                float r = (float)(waterColor >> 16 & 0xFF) / 255.0f;
                float g = (float)(waterColor >> 8 & 0xFF) / 255.0f;
                float b = (float)(waterColor & 0xFF) / 255.0f;
                if (this.getSinkingTicks() <= 240) {
                    BLParticles.RAIN.spawn(this.func_130014_f_(), x, y, z, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(dx * mag, dy * mag, dz * mag)).withColor(r, g, b + 0.075f, 1.0f));
                    continue;
                }
                if (this.getSinkingTicks() <= 240 || this.getSinkingTicks() > 400 || this.getSinkingTicks() % 5 != 0) continue;
                BLParticles.BUBBLE_WATER.spawn(this.func_130014_f_(), x, y, z, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(dx * mag, dy * mag, dz * mag)).withColor(r + 0.05f, g + 0.15f, b + 0.05f, 1.0f));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doLeafEffects() {
        if (this.func_130014_f_().field_72995_K) {
            int leafCount = 40;
            float x = (float)this.field_70165_t;
            float y = (float)(this.field_70163_u + 0.75);
            float z = (float)this.field_70161_v;
            while (leafCount-- > 0) {
                float dx = this.func_130014_f_().field_73012_v.nextFloat() * 1.0f - 0.5f;
                float dy = this.func_130014_f_().field_73012_v.nextFloat() * 1.0f - 0.1f;
                float dz = this.func_130014_f_().field_73012_v.nextFloat() * 1.0f - 0.5f;
                float mag = 0.08f + this.func_130014_f_().field_73012_v.nextFloat() * 0.07f;
                BLParticles.WEEDWOOD_LEAF.spawn(this.func_130014_f_(), x, y, z, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(dx * mag, dy * mag, dz * mag));
            }
        }
    }

    protected float func_70599_aP() {
        return 0.75f;
    }

    protected SoundEvent func_184639_G() {
        if (this.getSinkingTicks() <= 0) {
            if (this.field_70146_Z.nextInt(4) == 0 && this.shutUpFFSTime <= 0) {
                this.shutUpFFSTime = 120;
                return SoundRegistry.GREEBLING_HUM;
            }
            return SoundRegistry.GREEBLING_GIGGLE;
        }
        return null;
    }

    public int func_70641_bl() {
        return 1;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source.func_76346_g() instanceof EntityLivingBase && this.getSinkingTicks() == 0 && !this.func_130014_f_().field_72995_K) {
            this.setSinkingTicks(this.getSinkingTicks() + 1);
            this.func_130014_f_().func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, (SoundEvent)SoundRegistry.GREEBLING_VANISH, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        }
        return false;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.getSinkingTicks() > 0 && this.getSinkingTicks() < 200 && hand == EnumHand.MAIN_HAND) {
            player.func_184609_a(hand);
            if (!this.func_130014_f_().field_72995_K) {
                this.dropLoot(player);
                this.setLootClicks(this.getLootClicks() + 1);
                if (this.getLootClicks() >= this.loot.size()) {
                    this.setSinkingTicks(200);
                }
                SoundType soundType = SoundType.field_185848_a;
                this.func_130014_f_().func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, soundType.func_185846_f(), SoundCategory.NEUTRAL, (soundType.func_185843_a() + 1.0f) / 4.0f, soundType.func_185847_b() * 0.5f);
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    public void dropLoot(EntityPlayer player) {
        if (!this.func_130014_f_().field_72995_K) {
            ItemStack stack;
            if (!this.looted) {
                this.looted = true;
                LootTable lootTable = this.func_130014_f_().func_184146_ak().func_186521_a(LootTableRegistry.GREEBLING_CORACLE);
                LootContext.Builder builder = new LootContext.Builder((WorldServer)this.func_130014_f_()).func_186472_a((Entity)this).func_186470_a(player).func_186469_a(player.func_184817_da());
                this.loot = new NonNullDelegateList<ItemStack>(lootTable.func_186462_a(this.field_70146_Z, builder.func_186471_a()), ItemStack.field_190927_a);
            }
            if (!(stack = (ItemStack)this.loot.get(this.getLootClicks())).func_190926_b()) {
                this.func_70099_a(stack, 0.0f);
                this.loot.set(this.getLootClicks(), (Object)ItemStack.field_190927_a);
            }
        }
    }

    public class AIWaterWander
    extends EntityAIWander {
        private final EntityGreeblingCoracle coracle;

        public AIWaterWander(EntityGreeblingCoracle coracleIn, double speedIn, int chance) {
            super((EntityCreature)coracleIn, speedIn, chance);
            this.func_75248_a(1);
            this.coracle = coracleIn;
        }

        @Nullable
        protected Vec3d func_190864_f() {
            return RandomPositionGenerator.func_75463_a((EntityCreature)this.coracle, (int)16, (int)0);
        }
    }
}

