/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import thebetweenlands.api.entity.IPullerEntity;
import thebetweenlands.common.entity.ai.EntityAIAttackOnCollide;
import thebetweenlands.common.entity.ai.EntityAIFlyingWander;
import thebetweenlands.common.entity.ai.EntityAINearestAttackableSmellyTarget;
import thebetweenlands.common.entity.draeton.EntityDraeton;
import thebetweenlands.common.entity.mobs.EntityChiromaw;
import thebetweenlands.common.entity.mobs.EntityChiromawMatriarch;
import thebetweenlands.common.entity.mobs.EntityGreeblingVolarpadFloater;
import thebetweenlands.common.entity.movement.FlightMoveHelper;
import thebetweenlands.common.entity.projectiles.EntityBetweenstonePebble;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityChiromawGreeblingRider
extends EntityChiromaw {
    private static final DataParameter<Boolean> IS_SHOOTING = EntityDataManager.func_187226_a(EntityChiromawGreeblingRider.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> RELOAD_TIMER = EntityDataManager.func_187226_a(EntityChiromawGreeblingRider.class, (DataSerializer)DataSerializers.field_187192_b);
    public boolean playPullSound;

    public EntityChiromawGreeblingRider(World world) {
        super(world);
        this.func_70105_a(0.7f, 0.9f);
        this.setIsHanging(false);
        this.field_70765_h = new FlightMoveHelper((EntityLiving)this);
        this.func_184644_a(PathNodeType.WATER, -8.0f);
        this.func_184644_a(PathNodeType.BLOCKED, -8.0f);
        this.func_184644_a(PathNodeType.OPEN, 8.0f);
        this.func_184644_a(PathNodeType.FENCE, -8.0f);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISlingshotAttack(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsTargetWithDistance(this, 1.5, 8.0f, 128.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFlyingWander((EntityCreature)this, 0.75, 5));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIFindNearestTarget<EntityLivingBase>((EntityCreature)this, EntityLivingBase.class, 10, true, false, e -> e instanceof IPullerEntity, 6.0).func_190882_b(160));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIFindNearestTarget<EntityLivingBase>((EntityCreature)this, EntityLivingBase.class, 10, true, false, e -> e instanceof EntityChiromawMatriarch, 0.0).func_190882_b(160));
        this.field_70715_bh.func_75776_a(4, new EntityAINearestAttackableSmellyTarget<EntityPlayer>((EntityCreature)this, EntityPlayer.class, true));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_SHOOTING, (Object)false);
        this.field_70180_af.func_187214_a(RELOAD_TIMER, (Object)0);
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_130014_f_().field_72995_K) {
            if (this.func_70638_az() != null) {
                if (this.getReloadTimer() < 90 && !this.getIsShooting()) {
                    this.setReloadTimer(Math.min(90, this.getReloadTimer() + 2));
                }
                if (this.getReloadTimer() >= 90 && this.getIsShooting() && this.getReloadTimer() < 100) {
                    this.setReloadTimer(Math.min(102, this.getReloadTimer() + 4));
                }
            } else if (this.getReloadTimer() > 0 && !this.getIsShooting()) {
                this.setReloadTimer(Math.max(0, this.getReloadTimer() - 2));
            }
            if (this.getReloadTimer() <= 0) {
                this.playPullSound = true;
            }
            if (this.isPulling() && this.playPullSound) {
                this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.SLINGSHOT_CHARGE, SoundCategory.HOSTILE, 1.0f, 1.0f);
                this.playPullSound = false;
            }
        }
    }

    protected void func_70609_aI() {
        super.func_70609_aI();
        if (!this.field_70170_p.field_72995_K && this.field_70128_L) {
            EntityGreeblingVolarpadFloater floater = new EntityGreeblingVolarpadFloater(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.field_70170_p.func_72838_d((Entity)floater);
        }
    }

    @Override
    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.getIsHanging() && !this.field_70170_p.field_72995_K) {
            this.setIsHanging(false);
        }
    }

    public boolean getIsShooting() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_SHOOTING);
    }

    public void setIsShooting(boolean shooting) {
        this.field_70180_af.func_187227_b(IS_SHOOTING, (Object)shooting);
    }

    public int getReloadTimer() {
        return (Integer)this.field_70180_af.func_187225_a(RELOAD_TIMER);
    }

    public void setReloadTimer(int timer) {
        this.field_70180_af.func_187227_b(RELOAD_TIMER, (Object)timer);
    }

    public boolean isPulling() {
        return (Integer)this.field_70180_af.func_187225_a(RELOAD_TIMER) > 0 && (Integer)this.field_70180_af.func_187225_a(RELOAD_TIMER) < 90;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.CHIROMAW;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundRegistry.CHIROMAW_GREEBLING_RIDER_LIVING;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundRegistry.FLYING_FIEND_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundRegistry.FLYING_FIEND_DEATH;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.095);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        return EntityAIAttackOnCollide.useStandardAttack((EntityLiving)this, entityIn);
    }

    @Override
    public int func_70641_bl() {
        return 3;
    }

    @Override
    public float func_180484_a(BlockPos pos) {
        return 0.5f;
    }

    @Override
    protected boolean func_70814_o() {
        return true;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(ItemRegistry.SIMPLE_SLINGSHOT));
        return livingdata;
    }

    static class EntityAIMoveTowardsTargetWithDistance
    extends EntityAIBase {
        EntityChiromawGreeblingRider chiromawRider;
        EntityLivingBase target;
        double movePosX;
        double movePosY;
        double movePosZ;
        double speed;
        float minTargetDistance;
        float maxTargetDistance;

        public EntityAIMoveTowardsTargetWithDistance(EntityChiromawGreeblingRider chiromawRider, double speedIn, float targetMinDistance, float targetMaxDistance) {
            this.chiromawRider = chiromawRider;
            this.speed = speedIn;
            this.minTargetDistance = targetMinDistance;
            this.maxTargetDistance = targetMaxDistance;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            this.target = this.chiromawRider.func_70638_az();
            if (this.target == null) {
                return false;
            }
            if (this.chiromawRider.func_70068_e((Entity)this.target) > (double)(this.maxTargetDistance * this.maxTargetDistance)) {
                return false;
            }
            if (this.chiromawRider.func_70068_e((Entity)this.target) > (double)(this.minTargetDistance * this.minTargetDistance) && this.chiromawRider.func_70068_e((Entity)this.target) <= (double)(this.maxTargetDistance * this.maxTargetDistance)) {
                Vec3d vec3d = this.findNextPointTowards(8, 3, new Vec3d(this.target.field_70165_t, this.target.field_70163_u, this.target.field_70161_v));
                if (vec3d == null) {
                    return false;
                }
                this.flyToLocation(vec3d);
                return true;
            }
            if (this.chiromawRider.func_70068_e((Entity)this.target) <= (double)(this.minTargetDistance * this.minTargetDistance)) {
                Vec3d vec3d = this.findNextPointAway(16, 2, new Vec3d(this.target.field_70165_t, this.target.field_70163_u, this.target.field_70161_v));
                if (vec3d == null) {
                    return false;
                }
                this.flyToLocation(vec3d);
                return true;
            }
            return false;
        }

        @Nullable
        private Vec3d findNextPointTowards(int xz, int y, Vec3d target) {
            Vec3d newTarget = RandomPositionGenerator.func_75464_a((EntityCreature)this.chiromawRider, (int)xz, (int)y, (Vec3d)target);
            if (newTarget == null) {
                return null;
            }
            newTarget = target.field_72448_b < this.chiromawRider.field_70163_u ? new Vec3d(newTarget.field_72450_a, this.chiromawRider.field_70163_u - Math.abs(newTarget.field_72448_b - this.chiromawRider.field_70163_u), newTarget.field_72449_c) : new Vec3d(newTarget.field_72450_a, this.chiromawRider.field_70163_u + Math.abs(newTarget.field_72448_b - this.chiromawRider.field_70163_u), newTarget.field_72449_c);
            return newTarget;
        }

        @Nullable
        private Vec3d findNextPointAway(int xz, int y, Vec3d target) {
            Vec3d newTarget = RandomPositionGenerator.func_75461_b((EntityCreature)this.chiromawRider, (int)xz, (int)y, (Vec3d)target);
            if (newTarget == null) {
                return null;
            }
            newTarget = target.field_72448_b > this.chiromawRider.field_70163_u ? new Vec3d(newTarget.field_72450_a, this.chiromawRider.field_70163_u - Math.abs(newTarget.field_72448_b - this.chiromawRider.field_70163_u), newTarget.field_72449_c) : new Vec3d(newTarget.field_72450_a, this.chiromawRider.field_70163_u + Math.abs(newTarget.field_72448_b - this.chiromawRider.field_70163_u), newTarget.field_72449_c);
            return newTarget;
        }

        public void flyToLocation(Vec3d vec3d) {
            this.movePosX = vec3d.field_72450_a;
            this.movePosY = vec3d.field_72448_b;
            this.movePosZ = vec3d.field_72449_c;
        }

        public boolean func_75253_b() {
            return !this.chiromawRider.func_70661_as().func_75500_f() && this.target.func_70089_S() && this.target.func_70068_e((Entity)this.chiromawRider) <= (double)(this.maxTargetDistance * this.maxTargetDistance);
        }

        public void func_75251_c() {
            this.target = null;
        }

        public void func_75249_e() {
            this.chiromawRider.func_70661_as().func_75492_a(this.movePosX, this.movePosY, this.movePosZ, this.speed);
        }
    }

    static class EntityAISlingshotAttack
    extends EntityAIBase {
        EntityChiromawGreeblingRider chiromawRider;
        EntityLivingBase target;

        public EntityAISlingshotAttack(EntityChiromawGreeblingRider chiromawRider) {
            this.chiromawRider = chiromawRider;
            this.func_75248_a(5);
        }

        public boolean func_75250_a() {
            this.target = this.chiromawRider.func_70638_az();
            if (this.target == null) {
                return false;
            }
            double distance = this.chiromawRider.func_70068_e((Entity)this.target);
            return distance >= 36.0 && distance <= 576.0 && this.chiromawRider.getReloadTimer() >= 90;
        }

        public boolean func_75253_b() {
            return this.target != null && this.chiromawRider.field_70718_bc <= 40 && this.chiromawRider.getReloadTimer() >= 90;
        }

        public void func_75249_e() {
        }

        public void func_75246_d() {
            if (!this.chiromawRider.getIsShooting()) {
                this.chiromawRider.setIsShooting(true);
            }
            if (this.target != null) {
                this.chiromawRider.func_70625_a((Entity)this.target, 30.0f, 30.0f);
                this.chiromawRider.func_70671_ap().func_75651_a((Entity)this.target, 30.0f, 30.0f);
                if (this.chiromawRider.getReloadTimer() == 90) {
                    double targetX = this.target.field_70165_t - this.chiromawRider.field_70165_t;
                    double targetY = this.target.func_174813_aQ().field_72338_b + (double)(this.target.field_70131_O / 2.0f) - (this.chiromawRider.field_70163_u + (double)(this.chiromawRider.field_70131_O / 2.0f));
                    double targetZ = this.target.field_70161_v - this.chiromawRider.field_70161_v;
                    double targetDistance = MathHelper.func_76133_a((double)(targetX * targetX + targetZ * targetZ));
                    EntityBetweenstonePebble pebble = new EntityBetweenstonePebble(this.chiromawRider.func_130014_f_(), (EntityLivingBase)this.chiromawRider);
                    pebble.setDamage(2.0);
                    pebble.func_70186_c(targetX, targetY + targetDistance * 0.10000000298023223, targetZ, 1.6f, 0.0f);
                    this.chiromawRider.func_130014_f_().func_72838_d((Entity)pebble);
                    this.chiromawRider.func_130014_f_().func_184133_a(null, this.chiromawRider.func_180425_c(), (SoundEvent)SoundRegistry.SLINGSHOT_SHOOT, SoundCategory.HOSTILE, 1.0f, 1.0f + (this.chiromawRider.func_130014_f_().field_73012_v.nextFloat() - this.chiromawRider.func_130014_f_().field_73012_v.nextFloat()) * 0.8f);
                    this.chiromawRider.playPullSound = true;
                }
            }
            if (this.chiromawRider.getReloadTimer() == 102) {
                if (this.chiromawRider.getIsShooting()) {
                    this.chiromawRider.setIsShooting(false);
                    this.chiromawRider.setReloadTimer(0);
                    this.chiromawRider.playPullSound = true;
                }
                this.func_75251_c();
            }
        }

        public void func_75251_c() {
            this.target = null;
        }
    }

    static class EntityAIFindNearestTarget<T extends EntityLivingBase>
    extends EntityAINearestAttackableTarget<T> {
        protected double minHeight;

        public EntityAIFindNearestTarget(EntityCreature creature, Class<T> classTarget, boolean checkSight, double minHeight) {
            super(creature, classTarget, checkSight);
            this.minHeight = minHeight;
        }

        public EntityAIFindNearestTarget(EntityCreature creature, Class<T> classTarget, int chance, boolean checkSight, boolean onlyNearby, @Nullable Predicate<? super T> targetSelector, double minHeight) {
            super(creature, classTarget, chance, checkSight, onlyNearby, targetSelector);
            this.minHeight = minHeight;
        }

        public boolean func_75250_a() {
            if (super.func_75250_a()) {
                if (this.field_75309_a != null) {
                    double distance;
                    if (this.minHeight > 0.0) {
                        BlockPos surface;
                        EntityDraeton carriage;
                        Object checkEntity = this.field_75309_a;
                        if (checkEntity instanceof IPullerEntity && (carriage = ((IPullerEntity)checkEntity).getCarriage()) != null) {
                            checkEntity = carriage;
                        }
                        if (checkEntity.field_70163_u - (double)(surface = this.field_75299_d.field_70170_p.func_175645_m(new BlockPos((Entity)checkEntity))).func_177956_o() < this.minHeight) {
                            this.field_75309_a = null;
                            return false;
                        }
                    }
                    if ((distance = this.field_75299_d.func_70068_e((Entity)this.field_75309_a)) <= 576.0) {
                        this.field_75299_d.func_130014_f_().func_184133_a(null, this.field_75299_d.func_180425_c(), (SoundEvent)SoundRegistry.GREEBLING_HEY, SoundCategory.HOSTILE, 0.5f, 1.0f);
                    }
                }
                return true;
            }
            return false;
        }

        protected AxisAlignedBB func_188511_a(double targetDistance) {
            return this.field_75299_d.func_174813_aQ().func_72314_b(targetDistance, targetDistance, targetDistance);
        }

        protected double func_111175_f() {
            return 90.0;
        }
    }
}

