/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.common.entity.EntityFishBait;
import thebetweenlands.common.entity.mobs.EntityLurker;
import thebetweenlands.common.entity.projectiles.EntityBLFishHook;
import thebetweenlands.common.registries.BiomeRegistry;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.util.TranslationHelper;

public class EntityAnadia
extends EntityCreature
implements IEntityBL,
IAnimals {
    private static final DataParameter<Float> FISH_SIZE = EntityDataManager.func_187226_a(EntityAnadia.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Byte> HEAD_TYPE = EntityDataManager.func_187226_a(EntityAnadia.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> BODY_TYPE = EntityDataManager.func_187226_a(EntityAnadia.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> TAIL_TYPE = EntityDataManager.func_187226_a(EntityAnadia.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> IS_LEAPING = EntityDataManager.func_187226_a(EntityAnadia.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> STAMINA_TICKS = EntityDataManager.func_187226_a(EntityAnadia.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> FISH_COLOUR = EntityDataManager.func_187226_a(EntityAnadia.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> ESCAPE_TICKS = EntityDataManager.func_187226_a(EntityAnadia.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ESCAPE_DELAY = EntityDataManager.func_187226_a(EntityAnadia.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> OBSTRUCTION_TICKS_1 = EntityDataManager.func_187226_a(EntityAnadia.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> OBSTRUCTION_TICKS_2 = EntityDataManager.func_187226_a(EntityAnadia.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> OBSTRUCTION_TICKS_3 = EntityDataManager.func_187226_a(EntityAnadia.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> OBSTRUCTION_TICKS_4 = EntityDataManager.func_187226_a(EntityAnadia.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<ItemStack> HEAD_ITEM = EntityDataManager.func_187226_a(EntityAnadia.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<ItemStack> BODY_ITEM = EntityDataManager.func_187226_a(EntityAnadia.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<ItemStack> TAIL_ITEM = EntityDataManager.func_187226_a(EntityAnadia.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Boolean> IS_TREASURE_FISH = EntityDataManager.func_187226_a(EntityAnadia.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> TREASURE_TICKS = EntityDataManager.func_187226_a(EntityAnadia.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> TREASURE_UNLOCKED = EntityDataManager.func_187226_a(EntityAnadia.class, (DataSerializer)DataSerializers.field_187198_h);
    public AIFindBait aiFindBait;
    public AIFindHook aiFindHook;
    public boolean playAnadiaWonSound = true;
    public int animationFrame = 0;
    public int animationFrameCrab = 0;
    public int netCheck = 0;
    private static final int MAX_NETTABLE_TIME = 20;
    private int nettableTimer = 0;
    private int glowTimer = 0;

    public EntityAnadia(World world) {
        super(world);
        this.func_70105_a(0.8f, 0.8f);
        this.field_70728_aV = 3;
        this.field_70765_h = new AnadiaMoveHelper(this);
        this.func_184644_a(PathNodeType.WALKABLE, -8.0f);
        this.func_184644_a(PathNodeType.BLOCKED, -8.0f);
        this.func_184644_a(PathNodeType.WATER, 16.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackMelee(this, 0.7, true){

            protected double func_179512_a(EntityLivingBase attackTarget) {
                return 0.75 + (double)attackTarget.field_70130_N;
            }
        });
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityLurker.class, 8.0f, 4.0, 8.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.4));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAFishCalledWander(this, 0.5, 20));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIPanicWhenUnhooked(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIPanicWhenHooked(this));
        this.aiFindBait = new AIFindBait(this, 3.0);
        this.aiFindHook = new AIFindHook(this, 3.0);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.aiFindBait);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)this.aiFindHook);
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FISH_SIZE, (Object)Float.valueOf(0.5f));
        this.field_70180_af.func_187214_a(HEAD_TYPE, (Object)((byte)EnumAnadiaHeadParts.HEAD_1.ordinal()));
        this.field_70180_af.func_187214_a(BODY_TYPE, (Object)((byte)EnumAnadiaBodyParts.BODY_1.ordinal()));
        this.field_70180_af.func_187214_a(TAIL_TYPE, (Object)((byte)EnumAnadiaTailParts.TAIL_1.ordinal()));
        this.field_70180_af.func_187214_a(IS_LEAPING, (Object)false);
        this.field_70180_af.func_187214_a(STAMINA_TICKS, (Object)40);
        this.field_70180_af.func_187214_a(ESCAPE_TICKS, (Object)1024);
        this.field_70180_af.func_187214_a(ESCAPE_DELAY, (Object)80);
        this.field_70180_af.func_187214_a(OBSTRUCTION_TICKS_1, (Object)64);
        this.field_70180_af.func_187214_a(OBSTRUCTION_TICKS_2, (Object)128);
        this.field_70180_af.func_187214_a(OBSTRUCTION_TICKS_3, (Object)192);
        this.field_70180_af.func_187214_a(OBSTRUCTION_TICKS_4, (Object)256);
        this.field_70180_af.func_187214_a(FISH_COLOUR, (Object)((byte)EnumAnadiaColor.BASE.ordinal()));
        this.field_70180_af.func_187214_a(HEAD_ITEM, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(BODY_ITEM, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(TAIL_ITEM, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(IS_TREASURE_FISH, (Object)false);
        this.field_70180_af.func_187214_a(TREASURE_TICKS, (Object)256);
        this.field_70180_af.func_187214_a(TREASURE_UNLOCKED, (Object)false);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(12.0);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        if (!this.func_130014_f_().field_72995_K) {
            this.randomizeAnadiaProperties();
            this.randomiseObstructionOrder();
        }
        return super.func_180482_a(difficulty, livingdata);
    }

    public void randomizeAnadiaProperties() {
        this.setHeadType(EnumAnadiaHeadParts.random(this.field_70146_Z));
        this.setBodyType(EnumAnadiaBodyParts.random(this.field_70146_Z));
        this.setTailType(EnumAnadiaTailParts.random(this.field_70146_Z));
        this.setFishSize((float)Math.round(Math.max(0.125f, this.field_70146_Z.nextFloat()) * 16.0f) / 16.0f);
        if (this.func_130014_f_().func_180494_b(this.func_180425_c()) == BiomeRegistry.DEEP_WATERS) {
            this.setFishColour(EnumAnadiaColor.SILVER);
        } else if (this.func_130014_f_().func_180494_b(this.func_180425_c()) == BiomeRegistry.PATCHY_ISLANDS) {
            this.setFishColour(EnumAnadiaColor.GREEN);
        } else if (this.func_130014_f_().func_180494_b(this.func_180425_c()) == BiomeRegistry.COARSE_ISLANDS || this.func_130014_f_().func_180494_b(this.func_180425_c()) == BiomeRegistry.RAISED_ISLES) {
            this.setFishColour(EnumAnadiaColor.PURPLE);
        } else {
            this.setFishColour(EnumAnadiaColor.BASE);
        }
        this.setHeadItem(this.getPartFromLootTable(LootTableRegistry.ANADIA_HEAD));
        this.setBodyItem(this.getPartFromLootTable(LootTableRegistry.ANADIA_BODY));
        this.setTailItem(this.getPartFromLootTable(LootTableRegistry.ANADIA_TAIL));
        if (this.func_130014_f_().func_180494_b(this.func_180425_c()) != BiomeRegistry.DEEP_WATERS) {
            if (this.getStaminaMods() >= 5.0f && this.getFishSize() >= 0.875f) {
                this.setIsTreasureFish(true);
            }
        } else if (this.getStaminaMods() >= 4.5f && this.getFishSize() >= 0.5f) {
            this.setIsTreasureFish(true);
        }
    }

    public float getFishSize() {
        return ((Float)this.field_70180_af.func_187225_a(FISH_SIZE)).floatValue();
    }

    public void setFishSize(float size) {
        this.field_70180_af.func_187227_b(FISH_SIZE, (Object)Float.valueOf(size));
        this.func_70105_a(this.getFishSize(), this.getFishSize() * 0.75f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2 + (double)this.getSpeedMods());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(5.0 + (double)this.getHealthMods());
        this.func_70606_j(this.func_110138_aP());
    }

    public void setAsLootFish(boolean lootFish) {
        if (lootFish) {
            this.setBodyItem(this.getPartFromLootTable(LootTableRegistry.ANADIA_TREASURE));
            this.setTreasureUnlocked(true);
        } else {
            this.setBodyItem(this.getPartFromLootTable(LootTableRegistry.ANADIA_BODY));
            this.setTreasureUnlocked(false);
        }
    }

    public void setHeadType(EnumAnadiaHeadParts type) {
        this.field_70180_af.func_187227_b(HEAD_TYPE, (Object)((byte)type.ordinal()));
    }

    public EnumAnadiaHeadParts getHeadType() {
        return EnumAnadiaHeadParts.get(((Byte)this.field_70180_af.func_187225_a(HEAD_TYPE)).byteValue());
    }

    public void setBodyType(EnumAnadiaBodyParts type) {
        this.field_70180_af.func_187227_b(BODY_TYPE, (Object)((byte)type.ordinal()));
    }

    public EnumAnadiaBodyParts getBodyType() {
        return EnumAnadiaBodyParts.get(((Byte)this.field_70180_af.func_187225_a(BODY_TYPE)).byteValue());
    }

    public void setTailType(EnumAnadiaTailParts type) {
        this.field_70180_af.func_187227_b(TAIL_TYPE, (Object)((byte)type.ordinal()));
    }

    public EnumAnadiaTailParts getTailType() {
        return EnumAnadiaTailParts.get(((Byte)this.field_70180_af.func_187225_a(TAIL_TYPE)).byteValue());
    }

    public void setFishColour(EnumAnadiaColor colour) {
        this.field_70180_af.func_187227_b(FISH_COLOUR, (Object)((byte)colour.ordinal()));
    }

    public EnumAnadiaColor getFishColour() {
        return EnumAnadiaColor.get(((Byte)this.field_70180_af.func_187225_a(FISH_COLOUR)).byteValue());
    }

    private void setIsLeaping(boolean leaping) {
        this.field_70180_af.func_187227_b(IS_LEAPING, (Object)leaping);
    }

    public boolean isLeaping() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_LEAPING);
    }

    public void setStaminaTicks(int count) {
        this.field_70180_af.func_187227_b(STAMINA_TICKS, (Object)count);
    }

    public int getStaminaTicks() {
        return (Integer)this.field_70180_af.func_187225_a(STAMINA_TICKS);
    }

    public void setEscapeTicks(int count) {
        this.field_70180_af.func_187227_b(ESCAPE_TICKS, (Object)count);
    }

    public int getEscapeTicks() {
        return (Integer)this.field_70180_af.func_187225_a(ESCAPE_TICKS);
    }

    public void setEscapeDelay(int count) {
        this.field_70180_af.func_187227_b(ESCAPE_DELAY, (Object)count);
    }

    public int getEscapeDelay() {
        return (Integer)this.field_70180_af.func_187225_a(ESCAPE_DELAY);
    }

    public void setObstruction1Ticks(int count) {
        this.field_70180_af.func_187227_b(OBSTRUCTION_TICKS_1, (Object)count);
    }

    public int getObstruction1Ticks() {
        return (Integer)this.field_70180_af.func_187225_a(OBSTRUCTION_TICKS_1);
    }

    public void setObstruction2Ticks(int count) {
        this.field_70180_af.func_187227_b(OBSTRUCTION_TICKS_2, (Object)count);
    }

    public int getObstruction2Ticks() {
        return (Integer)this.field_70180_af.func_187225_a(OBSTRUCTION_TICKS_2);
    }

    public void setObstruction3Ticks(int count) {
        this.field_70180_af.func_187227_b(OBSTRUCTION_TICKS_3, (Object)count);
    }

    public int getObstruction3Ticks() {
        return (Integer)this.field_70180_af.func_187225_a(OBSTRUCTION_TICKS_3);
    }

    public void setObstruction4Ticks(int count) {
        this.field_70180_af.func_187227_b(OBSTRUCTION_TICKS_4, (Object)count);
    }

    public int getObstruction4Ticks() {
        return (Integer)this.field_70180_af.func_187225_a(OBSTRUCTION_TICKS_4);
    }

    public void setHeadItem(ItemStack itemStack) {
        this.field_70180_af.func_187227_b(HEAD_ITEM, (Object)itemStack);
    }

    public ItemStack getHeadItem() {
        return (ItemStack)this.field_70180_af.func_187225_a(HEAD_ITEM);
    }

    public void setBodyItem(ItemStack itemStack) {
        this.field_70180_af.func_187227_b(BODY_ITEM, (Object)itemStack);
    }

    public ItemStack getBodyItem() {
        return (ItemStack)this.field_70180_af.func_187225_a(BODY_ITEM);
    }

    public void setTailItem(ItemStack itemStack) {
        this.field_70180_af.func_187227_b(TAIL_ITEM, (Object)itemStack);
    }

    public ItemStack getTailItem() {
        return (ItemStack)this.field_70180_af.func_187225_a(TAIL_ITEM);
    }

    public void setIsTreasureFish(boolean treasure) {
        this.field_70180_af.func_187227_b(IS_TREASURE_FISH, (Object)treasure);
    }

    public boolean isTreasureFish() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_TREASURE_FISH);
    }

    public void setTreasureTicks(int count) {
        this.field_70180_af.func_187227_b(TREASURE_TICKS, (Object)count);
    }

    public int getTreasureTicks() {
        return (Integer)this.field_70180_af.func_187225_a(TREASURE_TICKS);
    }

    public void setTreasureUnlocked(boolean unlocked) {
        this.field_70180_af.func_187227_b(TREASURE_UNLOCKED, (Object)unlocked);
    }

    public boolean getTreasureUnlocked() {
        return (Boolean)this.field_70180_af.func_187225_a(TREASURE_UNLOCKED);
    }

    public int getNettableTimer() {
        return this.nettableTimer;
    }

    public void setGlowTimer(int time) {
        this.glowTimer = time;
    }

    public float getGlowTimer() {
        return this.glowTimer;
    }

    public void randomiseObstructionOrder() {
        ArrayList<Integer> obstructionList = new ArrayList<Integer>();
        for (int i = 0; i < 4; ++i) {
            obstructionList.add(i, 64 + i * 64 + this.field_70146_Z.nextInt(32) - this.field_70146_Z.nextInt(32));
        }
        Collections.shuffle(obstructionList);
        this.setObstruction1Ticks((Integer)obstructionList.get(0));
        this.setObstruction2Ticks((Integer)obstructionList.get(1));
        this.setObstruction3Ticks((Integer)obstructionList.get(2));
        this.setObstruction4Ticks((Integer)obstructionList.get(3) * 2);
        this.setEscapeTicks((int)(124.0f + this.getStaminaMods() * 100.0f));
    }

    public void func_184206_a(DataParameter<?> key) {
        if (FISH_SIZE.equals(key)) {
            this.func_70105_a(this.getFishSize(), this.getFishSize());
            this.field_70177_z = this.field_70759_as;
            this.field_70761_aq = this.field_70759_as;
        }
        if (FISH_COLOUR.equals(key)) {
            this.setFishColour(this.getFishColour());
        }
        super.func_184206_a(key);
    }

    public String func_70005_c_() {
        String body = TranslationHelper.translateToLocal("entity.thebetweenlands.anadia_body_" + this.getBodyType().ordinal(), new Object[0]);
        String tail = TranslationHelper.translateToLocal("entity.thebetweenlands.anadia_tail_" + this.getTailType().ordinal(), new Object[0]);
        String head = TranslationHelper.translateToLocal("entity.thebetweenlands.anadia_head_" + this.getHeadType().ordinal(), new Object[0]);
        return body + " " + tail + " " + head;
    }

    public ItemStack getPartFromLootTable(ResourceLocation lootTableIn) {
        LootContext.Builder lootBuilder;
        List loot;
        LootTable lootTable;
        if (this.field_70170_p instanceof WorldServer && (lootTable = this.field_70170_p.func_184146_ak().func_186521_a(lootTableIn)) != null && !(loot = lootTable.func_186462_a(this.field_70170_p.field_73012_v, (lootBuilder = new LootContext.Builder((WorldServer)this.field_70170_p).func_186472_a((Entity)this)).func_186471_a())).isEmpty()) {
            return (ItemStack)loot.get(0);
        }
        return ItemStack.field_190927_a;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a("headType", (byte)this.getHeadType().ordinal());
        nbt.func_74774_a("bodyType", (byte)this.getBodyType().ordinal());
        nbt.func_74774_a("tailType", (byte)this.getTailType().ordinal());
        nbt.func_74776_a("fishSize", this.getFishSize());
        nbt.func_74774_a("fishColour", (byte)this.getFishColour().ordinal());
        nbt.func_74757_a("isTreasureFish", this.isTreasureFish());
        nbt.func_74757_a("isTreasureUnlocked", this.getTreasureUnlocked());
        NBTTagCompound headItem = new NBTTagCompound();
        this.getHeadItem().func_77955_b(headItem);
        nbt.func_74782_a("headItem", (NBTBase)headItem);
        NBTTagCompound bodyItem = new NBTTagCompound();
        this.getBodyItem().func_77955_b(bodyItem);
        nbt.func_74782_a("bodyItem", (NBTBase)bodyItem);
        NBTTagCompound tailItem = new NBTTagCompound();
        this.getTailItem().func_77955_b(tailItem);
        nbt.func_74782_a("tailItem", (NBTBase)tailItem);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setHeadType(EnumAnadiaHeadParts.get(nbt.func_74771_c("headType")));
        this.setBodyType(EnumAnadiaBodyParts.get(nbt.func_74771_c("bodyType")));
        this.setTailType(EnumAnadiaTailParts.get(nbt.func_74771_c("tailType")));
        this.setFishSize(nbt.func_74760_g("fishSize"));
        this.setFishColour(EnumAnadiaColor.get(nbt.func_74771_c("fishColour")));
        this.setIsTreasureFish(nbt.func_74767_n("isTreasureFish"));
        this.setTreasureUnlocked(nbt.func_74767_n("isTreasureUnlocked"));
        NBTBase headItem = nbt.func_74781_a("headItem");
        ItemStack stackHead = ItemStack.field_190927_a;
        if (headItem instanceof NBTTagCompound) {
            stackHead = new ItemStack((NBTTagCompound)headItem);
        }
        this.setHeadItem(stackHead);
        NBTBase bodyItem = nbt.func_74781_a("bodyItem");
        ItemStack stackBody = ItemStack.field_190927_a;
        if (bodyItem instanceof NBTTagCompound) {
            stackBody = new ItemStack((NBTTagCompound)bodyItem);
        }
        this.setBodyItem(stackBody);
        NBTBase tailItem = nbt.func_74781_a("tailItem");
        ItemStack stackTail = ItemStack.field_190927_a;
        if (tailItem instanceof NBTTagCompound) {
            stackTail = new ItemStack((NBTTagCompound)tailItem);
        }
        this.setTailItem(stackTail);
    }

    public float getSpeedMods() {
        float head = this.getHeadType().getSpeedModifier();
        float body = this.getBodyType().getSpeedModifier();
        float tail = this.getTailType().getSpeedModifier();
        return (float)Math.round(this.getFishSize() * 0.5f * head + body + tail * 16.0f) / 16.0f;
    }

    public float getHealthMods() {
        float head = this.getHeadType().getHealthModifier();
        float body = this.getBodyType().getHealthModifier();
        float tail = this.getTailType().getHealthModifier();
        return (float)Math.round(this.getFishSize() * head + body + tail * 2.0f) / 2.0f;
    }

    public float getStrengthMods() {
        float head = this.getHeadType().getStrengthModifier();
        float body = this.getBodyType().getStrengthModifier();
        float tail = this.getTailType().getStrengthModifier();
        return (float)Math.round(this.getFishSize() * 0.5f * head + body + tail * 2.0f) / 2.0f;
    }

    public float getStaminaMods() {
        float head = this.getHeadType().getStaminaModifier();
        float body = this.getBodyType().getStaminaModifier();
        float tail = this.getTailType().getStaminaModifier();
        return Math.max((float)Math.round(this.getFishSize() * head + body + tail * 2.0f) / 2.0f, 3.5f);
    }

    public void playTreasureCollectedSound(EntityPlayer player) {
        this.func_130014_f_().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, (SoundEvent)SoundRegistry.ANADIA_TREASURE_COLLECTED, SoundCategory.PLAYERS, 0.25f, 1.0f);
    }

    public void playAnadiaLostSound(EntityPlayer player) {
        this.func_130014_f_().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, (SoundEvent)SoundRegistry.ANADIA_LOST, SoundCategory.PLAYERS, 0.25f, 1.0f);
    }

    public void playAnadiaWonSound(EntityPlayer player) {
        this.func_130014_f_().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, (SoundEvent)SoundRegistry.ANADIA_WON, SoundCategory.PLAYERS, 0.25f, 1.0f);
    }

    public void playAnadiaCrab(EntityPlayer player) {
        this.func_130014_f_().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, (SoundEvent)SoundRegistry.FISHING_CRAB, SoundCategory.PLAYERS, 0.25f, 1.0f);
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundRegistry.FISH_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.FISH_DEATH;
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187593_cC;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.ANADIA;
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c() == BlockRegistry.SWAMP_WATER && MathHelper.func_76128_c((double)this.field_70163_u) <= 120;
    }

    public boolean isGrounded() {
        return !this.func_70090_H() && this.field_70170_p.func_175623_d(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u + 1.0)), MathHelper.func_76128_c((double)this.field_70161_v))) && this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().func_149703_v();
    }

    protected PathNavigate func_175447_b(World world) {
        return new PathNavigateSwimmer((EntityLiving)this, world);
    }

    public float func_180484_a(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h ? 10.0f + this.field_70170_p.func_175724_o(pos) - 0.5f : super.func_180484_a(pos);
    }

    public void func_70106_y() {
        if (!this.func_130014_f_().field_72995_K && this.func_94060_bK() instanceof EntityLurker) {
            EntityLurker lurker = (EntityLurker)this.func_94060_bK();
            lurker.setHuntingTimer(2400);
        }
        super.func_70106_y();
    }

    public void func_70636_d() {
        if (this.func_130014_f_().field_72995_K && this.func_130014_f_().func_82737_E() % 5L + (long)this.func_130014_f_().field_73012_v.nextInt(5) == 0L && this.func_70090_H()) {
            for (int i = 0; i < 2; ++i) {
                double a = Math.toRadians(this.field_70177_z);
                double offSetX = -Math.sin(a) * (double)this.field_70130_N * 0.5;
                double offSetZ = Math.cos(a) * (double)this.field_70130_N * 0.5;
                this.func_130014_f_().func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t + offSetX, this.field_70163_u + (double)this.field_70131_O * 0.5 + this.field_70146_Z.nextDouble() * 0.5, this.field_70161_v + offSetZ, 0.0, 0.4, 0.0, new int[0]);
            }
        }
        if (this.glowTimer > 0) {
            --this.glowTimer;
        }
        if (this.field_70171_ac) {
            this.func_70050_g(300);
        } else if (this.field_70122_E) {
            this.field_70181_x += 0.5;
            this.field_70159_w += (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.4f);
            this.field_70179_y += (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.4f);
            this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
            if (this.isLeaping()) {
                this.setIsLeaping(false);
            }
            this.field_70122_E = false;
            this.field_70160_al = true;
            if (this.func_130014_f_().func_82737_E() % 5L == 0L) {
                this.func_130014_f_().func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, (SoundEvent)SoundRegistry.FISH_FLOP, SoundCategory.HOSTILE, 1.0f, 1.0f);
            }
            this.func_70665_d(DamageSource.field_76369_e, 0.5f);
        }
        super.func_70636_d();
    }

    public void func_70071_h_() {
        if (this.getStaminaTicks() <= 0 && this.func_184207_aI() && this.func_184188_bt().get(0) instanceof EntityBLFishHook) {
            this.nettableTimer = 20;
        } else if (this.nettableTimer > 0) {
            --this.nettableTimer;
        }
        if (this.func_130014_f_().field_72995_K) {
            this.func_70105_a(this.getFishSize(), this.getFishSize() * 0.75f);
            if (this.func_130014_f_().func_82737_E() % 4L == 0L) {
                this.animationFrame += 16;
            }
            if (this.animationFrame > 48) {
                this.animationFrame = 0;
            }
            this.animationFrameCrab += 16;
            if (this.animationFrameCrab > 48) {
                this.animationFrameCrab = 0;
            }
        }
        if (!this.func_130014_f_().field_72995_K) {
            double distance;
            if (this.func_70638_az() != null && !this.func_130014_f_().func_72953_d(this.func_70638_az().func_174813_aQ()) && (distance = this.func_180425_c().func_185332_f((int)this.func_70638_az().field_70165_t, (int)this.func_70638_az().field_70163_u, (int)this.func_70638_az().field_70161_v)) > 1.0 && distance < 6.0 && this.func_70090_H() && this.func_130014_f_().func_175623_d(new BlockPos((int)this.field_70165_t, (int)this.field_70163_u + 1, (int)this.field_70161_v))) {
                this.leapAtTarget(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v);
            }
            if (!this.func_184207_aI()) {
                this.playAnadiaWonSound = true;
                if (this.getEscapeDelay() < (int)this.getStaminaMods() * 30) {
                    this.setEscapeDelay((int)(this.getStaminaMods() * 30.0f));
                }
                if (this.getStaminaTicks() < (int)(this.getStaminaMods() * 20.0f)) {
                    this.setStaminaTicks(this.getStaminaTicks() + 1);
                }
                if (this.getObstruction1Ticks() < 256) {
                    this.setObstruction1Ticks(256);
                }
                if (this.getObstruction2Ticks() < 256) {
                    this.setObstruction2Ticks(256);
                }
                if (this.getObstruction3Ticks() < 256) {
                    this.setObstruction3Ticks(256);
                }
                if (this.getObstruction4Ticks() < 512) {
                    this.setObstruction4Ticks(512);
                }
                if (this.getTreasureTicks() < 1024) {
                    this.setTreasureTicks(1024);
                }
            }
            if (this.func_184207_aI() && this.func_184188_bt().get(0) instanceof EntityBLFishHook) {
                EntityBLFishHook hook = (EntityBLFishHook)((Object)this.func_184188_bt().get(0));
                if (this.getStaminaTicks() <= 0 && this.playAnadiaWonSound) {
                    if (hook != null && hook.func_190619_l() != null) {
                        this.playAnadiaWonSound(hook.func_190619_l());
                    }
                    this.playAnadiaWonSound = false;
                    this.func_70661_as().func_75499_g();
                }
                if (this.getStaminaTicks() > 0 && this.getEscapeDelay() > 0) {
                    this.setEscapeDelay(this.getEscapeDelay() - 1);
                    if (this.getEscapeDelay() == 10 && hook != null && hook.func_190619_l() != null) {
                        this.playAnadiaCrab(hook.func_190619_l());
                    }
                }
                if (this.getEscapeTicks() > 0 && this.getEscapeDelay() <= 0) {
                    this.setEscapeTicks(this.getEscapeTicks() - 3);
                }
                if (this.getEscapeTicks() * 256 / 1024 < this.getStaminaTicks() * 256 / 180 && this.getEscapeDelay() <= 0 && hook != null && hook.func_190619_l() != null) {
                    this.playAnadiaLostSound(hook.func_190619_l());
                    ((Entity)this.func_184188_bt().get(0)).func_184210_p();
                }
                if (this.getObstruction1Ticks() >= 0) {
                    this.setObstruction1Ticks(this.getObstruction1Ticks() - 1);
                    if (this.getObstruction1Ticks() <= 0) {
                        this.setObstruction1Ticks(256);
                    }
                }
                if (this.getObstruction2Ticks() >= 0) {
                    this.setObstruction2Ticks(this.getObstruction2Ticks() - 2);
                    if (this.getObstruction2Ticks() <= 0) {
                        this.setObstruction2Ticks(256);
                    }
                }
                if (this.getObstruction3Ticks() >= 0) {
                    this.setObstruction3Ticks(this.getObstruction3Ticks() - 1);
                    if (this.getObstruction3Ticks() <= 0) {
                        this.setObstruction3Ticks(256);
                    }
                }
                if (this.getObstruction4Ticks() >= 0) {
                    this.setObstruction4Ticks(this.getObstruction4Ticks() - 1);
                    if (this.getObstruction4Ticks() <= 0) {
                        this.setObstruction4Ticks(512);
                    }
                }
                if (this.isTreasureFish() && this.getTreasureTicks() >= 0) {
                    this.setTreasureTicks(this.getTreasureTicks() - 1);
                    if (this.getTreasureTicks() <= 0) {
                        if (this.getTreasureUnlocked()) {
                            this.setIsTreasureFish(false);
                        }
                        this.setTreasureTicks(1024);
                    }
                }
            }
        }
        super.func_70071_h_();
    }

    public boolean isObstructed() {
        if (256 - this.getObstruction1Ticks() <= this.getStaminaTicks() * 256 / 180 && 256 - this.getObstruction1Ticks() >= this.getStaminaTicks() * 256 / 180 - 16) {
            return true;
        }
        if (256 - this.getObstruction2Ticks() <= this.getStaminaTicks() * 256 / 180 && 256 - this.getObstruction2Ticks() >= this.getStaminaTicks() * 256 / 180 - 16) {
            return true;
        }
        if (256 - this.getObstruction3Ticks() <= this.getStaminaTicks() * 256 / 180 && 256 - this.getObstruction3Ticks() >= this.getStaminaTicks() * 256 / 180 - 16) {
            return true;
        }
        return 512 - this.getObstruction4Ticks() <= this.getStaminaTicks() * 512 / 180 && 512 - this.getObstruction4Ticks() >= this.getStaminaTicks() * 512 / 180 - 16;
    }

    public boolean isObstructedTreasure() {
        return 1024 - this.getTreasureTicks() <= this.getStaminaTicks() * 1024 / 180 + 8 && 1024 - this.getTreasureTicks() >= this.getStaminaTicks() * 1024 / 180 - 16;
    }

    public void func_184232_k(Entity entity) {
        super.func_184232_k(entity);
        if (entity instanceof EntityBLFishHook) {
            double a = Math.toRadians(this.field_70177_z);
            double offSetX = -Math.sin(a) * (double)this.field_70130_N * 0.5;
            double offSetZ = Math.cos(a) * (double)this.field_70130_N * 0.5;
            entity.func_70107_b(this.field_70165_t + offSetX, this.field_70163_u + (double)this.field_70131_O + 0.125, this.field_70161_v + offSetZ);
            this.field_70125_A = -20.0f;
        }
    }

    public void leapAtTarget(double targetX, double targetY, double targetZ) {
        if (!this.isLeaping()) {
            this.setIsLeaping(true);
            this.func_130014_f_().func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187593_cC, SoundCategory.NEUTRAL, 1.0f, 2.0f);
        }
        double distanceX = targetX - this.field_70165_t;
        double distanceZ = targetZ - this.field_70161_v;
        float distanceSqrRoot = MathHelper.func_76133_a((double)(distanceX * distanceX + distanceZ * distanceZ));
        this.field_70159_w = distanceX / (double)distanceSqrRoot * 0.1 + this.field_70159_w * this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
        this.field_70179_y = distanceZ / (double)distanceSqrRoot * 0.1 + this.field_70179_y * this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
        this.field_70181_x = 0.3f;
    }

    public void func_191986_a(float strafe, float up, float forward) {
        if (this.func_70613_aW()) {
            if (this.func_70090_H()) {
                this.func_191958_b(strafe, up, forward, 0.1f);
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= 0.75;
                this.field_70181_x *= 0.75;
                this.field_70179_y *= 0.75;
                if (this.func_70638_az() == null) {
                    this.field_70181_x -= 0.003;
                }
            } else {
                super.func_191986_a(strafe, up, forward);
            }
        } else {
            super.func_191986_a(strafe, up, forward);
        }
    }

    public boolean func_70058_J() {
        return this.func_130014_f_().func_72917_a(this.func_174813_aQ(), (Entity)this) && this.func_130014_f_().func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty();
    }

    public boolean func_96092_aw() {
        return false;
    }

    public static enum EnumAnadiaColor {
        SMOKED(false),
        ROTTEN(false),
        BASE(true),
        SILVER(true),
        PURPLE(true),
        GREEN(true),
        UNKNOWN(false);

        private static final EnumAnadiaColor[] VALUES;
        private final boolean isAlive;

        private EnumAnadiaColor(boolean isAlive) {
            this.isAlive = isAlive;
        }

        public boolean isAlive() {
            return this.isAlive;
        }

        public static EnumAnadiaColor get(int id) {
            if (id >= 0 && id < VALUES.length) {
                return VALUES[id];
            }
            return UNKNOWN;
        }

        static {
            VALUES = EnumAnadiaColor.values();
        }
    }

    public static enum EnumAnadiaTailParts {
        TAIL_1(0.125f, 1.0f, 1.0f, 1.0f),
        TAIL_2(0.25f, 2.0f, 2.0f, 2.0f),
        TAIL_3(0.5f, 3.0f, 3.0f, 3.0f),
        UNKNOWN(0.25f, 1.0f, 1.0f, 1.0f);

        private static final EnumAnadiaTailParts[] VALUES;
        private float speed;
        private float health;
        private float strength;
        private float stamina;

        private EnumAnadiaTailParts(float speedModifier, float healthModifier, float strengthModifier, float staminaModifier) {
            this.speed = speedModifier;
            this.health = healthModifier;
            this.strength = strengthModifier;
            this.stamina = staminaModifier;
        }

        private EnumAnadiaTailParts() {
            this(0.0f, 0.0f, 0.0f, 0.0f);
        }

        public float getSpeedModifier() {
            return this.speed;
        }

        public float getHealthModifier() {
            return this.health;
        }

        public float getStrengthModifier() {
            return this.strength;
        }

        public float getStaminaModifier() {
            return this.stamina;
        }

        public static EnumAnadiaTailParts random(Random rng) {
            return VALUES[rng.nextInt(VALUES.length - 1)];
        }

        public static EnumAnadiaTailParts get(int id) {
            if (id >= 0 && id < VALUES.length) {
                return VALUES[id];
            }
            return UNKNOWN;
        }

        static {
            VALUES = EnumAnadiaTailParts.values();
        }
    }

    public static enum EnumAnadiaBodyParts {
        BODY_1(0.125f, 1.0f, 1.0f, 1.0f),
        BODY_2(0.25f, 2.0f, 2.0f, 2.0f),
        BODY_3(0.5f, 3.0f, 3.0f, 3.0f),
        UNKNOWN(0.25f, 1.0f, 1.0f, 1.0f);

        private static final EnumAnadiaBodyParts[] VALUES;
        float speed;
        float health;
        float strength;
        float stamina;

        private EnumAnadiaBodyParts(float speedModifier, float healthModifier, float strengthModifier, float staminaModifier) {
            this.speed = speedModifier;
            this.health = healthModifier;
            this.strength = strengthModifier;
            this.stamina = staminaModifier;
        }

        private EnumAnadiaBodyParts() {
            this(0.0f, 0.0f, 0.0f, 0.0f);
        }

        public float getSpeedModifier() {
            return this.speed;
        }

        public float getHealthModifier() {
            return this.health;
        }

        public float getStrengthModifier() {
            return this.strength;
        }

        public float getStaminaModifier() {
            return this.stamina;
        }

        public static EnumAnadiaBodyParts random(Random rng) {
            return VALUES[rng.nextInt(VALUES.length - 1)];
        }

        public static EnumAnadiaBodyParts get(int id) {
            if (id >= 0 && id < VALUES.length) {
                return VALUES[id];
            }
            return UNKNOWN;
        }

        static {
            VALUES = EnumAnadiaBodyParts.values();
        }
    }

    public static enum EnumAnadiaHeadParts {
        HEAD_1(0.125f, 1.0f, 1.0f, 1.0f),
        HEAD_2(0.25f, 2.0f, 2.0f, 2.0f),
        HEAD_3(0.5f, 3.0f, 3.0f, 3.0f),
        UNKNOWN(0.25f, 1.0f, 1.0f, 1.0f);

        private static final EnumAnadiaHeadParts[] VALUES;
        float speed;
        float health;
        float strength;
        float stamina;

        private EnumAnadiaHeadParts(float speedModifier, float healthModifier, float strengthModifier, float staminaModifier) {
            this.speed = speedModifier;
            this.health = healthModifier;
            this.strength = strengthModifier;
            this.stamina = staminaModifier;
        }

        private EnumAnadiaHeadParts() {
            this(0.0f, 0.0f, 0.0f, 0.0f);
        }

        public float getSpeedModifier() {
            return this.speed;
        }

        public float getHealthModifier() {
            return this.health;
        }

        public float getStrengthModifier() {
            return this.strength;
        }

        public float getStaminaModifier() {
            return this.stamina;
        }

        public static EnumAnadiaHeadParts random(Random rng) {
            return VALUES[rng.nextInt(VALUES.length - 1)];
        }

        public static EnumAnadiaHeadParts get(int id) {
            if (id >= 0 && id < VALUES.length) {
                return VALUES[id];
            }
            return UNKNOWN;
        }

        static {
            VALUES = EnumAnadiaHeadParts.values();
        }
    }

    public class EntityAIPanicWhenUnhooked
    extends EntityAIPanic {
        private final EntityAnadia anadia;
        private int timeSinceUnhook;

        public EntityAIPanicWhenUnhooked(EntityAnadia entity) {
            super((EntityCreature)entity, 2.0);
            this.timeSinceUnhook = 0;
            this.anadia = entity;
        }

        public boolean func_75250_a() {
            if (this.anadia.func_184207_aI() && this.anadia.getStaminaTicks() > 0) {
                this.timeSinceUnhook = 0;
            } else if (this.anadia.func_184207_aI() && this.anadia.getStaminaTicks() <= 0) {
                this.timeSinceUnhook = 1;
            } else if (this.timeSinceUnhook == 1 && this.anadia.getNettableTimer() <= 0) {
                this.timeSinceUnhook = 2;
            } else if (this.timeSinceUnhook >= 2) {
                this.timeSinceUnhook += 2;
                if (this.anadia.func_184207_aI() || this.timeSinceUnhook >= 60) {
                    this.timeSinceUnhook = 0;
                    return false;
                }
                if (this.func_190863_f()) {
                    return true;
                }
            }
            return false;
        }

        public boolean func_75253_b() {
            ++this.timeSinceUnhook;
            if (this.anadia.func_184207_aI() || this.timeSinceUnhook >= 60) {
                this.timeSinceUnhook = 0;
                return false;
            }
            return !this.anadia.func_70661_as().func_75500_f() && !this.anadia.func_184207_aI();
        }

        public void func_75249_e() {
            this.anadia.func_70661_as().func_75492_a(this.field_75266_c, this.field_75263_d, this.field_75264_e, this.field_75265_b);
        }
    }

    public class EntityAIPanicWhenHooked
    extends EntityAIPanic {
        private final EntityAnadia anadia;

        public EntityAIPanicWhenHooked(EntityAnadia entity) {
            super((EntityCreature)entity, entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 2.0);
            this.anadia = entity;
        }

        public boolean func_75250_a() {
            return this.anadia.func_184207_aI() && this.anadia.getStaminaTicks() >= 1 && this.func_190863_f();
        }

        public boolean func_75253_b() {
            return !this.anadia.func_70661_as().func_75500_f() && this.anadia.func_184207_aI() && this.anadia.getStaminaTicks() >= 1;
        }

        public void func_75249_e() {
            this.anadia.func_70661_as().func_75492_a(this.field_75266_c, this.field_75263_d, this.field_75264_e, this.field_75265_b);
        }
    }

    public class EntityAIAFishCalledWander
    extends EntityAIWander {
        public EntityAIAFishCalledWander(EntityCreature creatureIn, double speedIn, int chance) {
            super(creatureIn, speedIn, chance);
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !EntityAnadia.this.func_184207_aI();
        }

        public boolean func_75253_b() {
            return !this.field_75457_a.func_70661_as().func_75500_f() && !EntityAnadia.this.func_184207_aI();
        }
    }

    public class AIFindHook
    extends EntityAIBase {
        private final EntityAnadia anadia;
        private double searchRange;
        public EntityBLFishHook hook = null;

        public AIFindHook(EntityAnadia anadiaIn, double searchRangeIn) {
            this.anadia = anadiaIn;
            this.searchRange = searchRangeIn;
        }

        public boolean func_75250_a() {
            return this.hook == null;
        }

        public void func_75249_e() {
            if (this.hook == null) {
                this.hook = this.getClosestHook(this.searchRange);
            }
        }

        public boolean func_75253_b() {
            return this.hook != null && !this.hook.field_70128_L && this.hook.getBaited() ? true : this.hook != null && !this.hook.field_70128_L && this.anadia.func_130014_f_().field_73012_v.nextInt(50) == 0 && !this.hook.getBaited();
        }

        public void func_75246_d() {
            if (!this.anadia.field_70170_p.field_72995_K && this.func_75253_b() && this.hook != null && this.hook.field_146043_c == null) {
                float distance = this.hook.func_70032_d((Entity)this.anadia);
                double x = this.hook.field_70165_t;
                double y = this.hook.field_70163_u;
                double z = this.hook.field_70161_v;
                if (distance >= 1.0f) {
                    this.anadia.func_70671_ap().func_75650_a(x, y, z, 20.0f, 8.0f);
                    this.moveToEntity(this.hook);
                }
                if (distance <= 2.0f && this.anadia.func_70090_H() && this.anadia.func_130014_f_().func_175623_d(new BlockPos(x, y + 1.0, z)) && this.anadia.func_70685_l((Entity)this.hook)) {
                    this.anadia.leapAtTarget(x, y, z);
                }
                if (distance <= 1.0f) {
                    this.anadia.func_70605_aq().func_75642_a(x, y, z, this.anadia.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                    this.anadia.setIsLeaping(false);
                    this.hook.field_146043_c = this.anadia;
                    this.anadia.randomiseObstructionOrder();
                    this.hook.func_184205_a((Entity)this.anadia, true);
                    this.hook.setBaited(false);
                }
            }
        }

        public void func_75251_c() {
            this.hook = null;
        }

        public EntityBLFishHook getClosestHook(double distance) {
            List list = this.anadia.func_130014_f_().func_72872_a(EntityBLFishHook.class, this.anadia.func_174813_aQ().func_72314_b(distance, distance, distance));
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                EntityBLFishHook hook = (EntityBLFishHook)((Object)iterator.next());
                if (hook.func_70090_H()) continue;
                iterator.remove();
            }
            if (list.isEmpty()) {
                return null;
            }
            if (!list.isEmpty()) {
                Collections.shuffle(list);
            }
            return (EntityBLFishHook)((Object)list.get(0));
        }

        public void moveToEntity(EntityBLFishHook hook) {
            Path pathentity = this.anadia.func_70661_as().func_75505_d();
            if (pathentity != null) {
                this.anadia.func_70661_as().func_75492_a(hook.field_70165_t, hook.field_70163_u, hook.field_70161_v, this.anadia.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
            }
        }
    }

    public class AIFindBait
    extends EntityAIBase {
        private final EntityAnadia anadia;
        private double searchRange;
        public EntityFishBait bait = null;

        public AIFindBait(EntityAnadia anadiaIn, double searchRangeIn) {
            this.anadia = anadiaIn;
            this.searchRange = searchRangeIn;
        }

        public boolean func_75250_a() {
            return this.bait == null;
        }

        public void func_75249_e() {
            if (this.bait == null) {
                this.bait = this.getClosestBait(this.searchRange);
            }
        }

        public boolean func_75253_b() {
            return this.bait != null && !this.bait.field_70128_L;
        }

        public void func_75246_d() {
            if (!this.anadia.field_70170_p.field_72995_K && this.func_75253_b() && this.bait != null) {
                float distance = this.bait.func_70032_d((Entity)this.anadia);
                double x = this.bait.field_70165_t;
                double y = this.bait.field_70163_u;
                double z = this.bait.field_70161_v;
                if (this.bait.func_174874_s()) {
                    if (distance >= 1.0f) {
                        this.anadia.func_70671_ap().func_75650_a(x, y, z, 20.0f, 8.0f);
                        this.moveToItem(this.bait);
                    }
                    if (distance <= 2.0f && this.anadia.func_70090_H() && this.anadia.func_130014_f_().func_175623_d(new BlockPos(x, y + 1.0, z)) && this.anadia.func_70685_l((Entity)this.bait)) {
                        this.anadia.leapAtTarget(x, y, z);
                    }
                    if (distance <= 1.0f) {
                        this.anadia.func_70605_aq().func_75642_a(x, y, z, this.anadia.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                        this.bait.func_92059_d().func_190918_g(1);
                        if (this.bait.func_92059_d().func_190916_E() <= 0) {
                            this.bait.func_70106_y();
                        }
                        this.anadia.setIsLeaping(false);
                        this.func_75251_c();
                    }
                }
            }
        }

        public void func_75251_c() {
            this.bait = null;
        }

        public EntityFishBait getClosestBait(double distance) {
            List list = this.anadia.func_130014_f_().func_72872_a(EntityFishBait.class, this.anadia.func_174813_aQ().func_72314_b(distance, distance, distance));
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                EntityFishBait bait = (EntityFishBait)((Object)iterator.next());
                if (bait.field_70173_aa < bait.lifespan && bait.func_70090_H()) continue;
                iterator.remove();
            }
            if (list.isEmpty()) {
                return null;
            }
            if (!list.isEmpty()) {
                Collections.shuffle(list);
            }
            return (EntityFishBait)((Object)list.get(0));
        }

        public void moveToItem(EntityFishBait bait) {
            Path pathentity = this.anadia.func_70661_as().func_75505_d();
            if (pathentity != null) {
                this.anadia.func_70661_as().func_75492_a(bait.field_70165_t, bait.field_70163_u, bait.field_70161_v, this.anadia.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
            }
        }
    }

    static class AnadiaMoveHelper
    extends EntityMoveHelper {
        private final EntityAnadia anadia;

        public AnadiaMoveHelper(EntityAnadia anadia) {
            super((EntityLiving)anadia);
            this.anadia = anadia;
        }

        public void func_75641_c() {
            if (this.anadia.getStaminaTicks() <= 0 || this.anadia.getNettableTimer() > 0) {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
                this.anadia.func_70659_e(0.0f);
                return;
            }
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO && !this.anadia.func_70661_as().func_75500_f()) {
                double targetX = this.field_75646_b - this.anadia.field_70165_t;
                double targetY = this.field_75647_c - this.anadia.field_70163_u;
                double targetZ = this.field_75644_d - this.anadia.field_70161_v;
                double targetDistance = targetX * targetX + targetY * targetY + targetZ * targetZ;
                targetDistance = MathHelper.func_76133_a((double)targetDistance);
                targetY /= targetDistance;
                float targetAngle = (float)(MathHelper.func_181159_b((double)targetZ, (double)targetX) * 57.29577951308232) - 90.0f;
                this.anadia.field_70761_aq = this.anadia.field_70177_z = this.func_75639_a(this.anadia.field_70177_z, targetAngle, 90.0f);
                float travelSpeed = (float)(this.field_75645_e * this.anadia.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                this.anadia.func_70659_e(this.anadia.func_70689_ay() + (travelSpeed - this.anadia.func_70689_ay()) * 0.125f);
                double wiggleSpeed = Math.sin((double)(this.anadia.field_70173_aa + this.anadia.func_145782_y()) * 0.5) * (double)this.anadia.getFishSize() * 0.05;
                double wiggleOffsetX = Math.cos(this.anadia.field_70177_z * this.anadia.getFishSize() * 0.01f);
                double wiggleOffsetZ = Math.sin(this.anadia.field_70177_z * this.anadia.getFishSize() * 0.01f);
                this.anadia.field_70159_w += wiggleSpeed * wiggleOffsetX;
                this.anadia.field_70179_y += wiggleSpeed * wiggleOffsetZ;
                wiggleSpeed = Math.sin((double)(this.anadia.field_70173_aa + this.anadia.func_145782_y()) * 0.75) * 0.05;
                this.anadia.field_70181_x += wiggleSpeed * (wiggleOffsetZ + wiggleOffsetX) * 0.25;
                this.anadia.field_70181_x += (double)this.anadia.func_70689_ay() * targetY * 0.1;
                EntityLookHelper entitylookhelper = this.anadia.func_70671_ap();
                double targetDirectionX = this.anadia.field_70165_t + targetX / targetDistance * 2.0;
                double targetDirectionY = (double)this.anadia.func_70047_e() + this.anadia.field_70163_u + targetY / targetDistance;
                double targetDirectionZ = this.anadia.field_70161_v + targetZ / targetDistance * 2.0;
                double lookX = entitylookhelper.func_180423_e();
                double lookY = entitylookhelper.func_180422_f();
                double lookZ = entitylookhelper.func_180421_g();
                if (!entitylookhelper.func_180424_b()) {
                    lookX = targetDirectionX;
                    lookY = targetDirectionY;
                    lookZ = targetDirectionZ;
                }
                this.anadia.func_70671_ap().func_75650_a(lookX + (targetDirectionX - lookX) * 0.125, lookY + (targetDirectionY - lookY) * 0.125, lookZ + (targetDirectionZ - lookZ) * 0.125, 10.0f, 40.0f);
            } else {
                this.anadia.func_70659_e(0.0f);
            }
        }
    }
}

