/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.Pair;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.entity.projectiles.EntityBLArrow;
import thebetweenlands.common.herblore.elixir.ElixirEffectRegistry;
import thebetweenlands.common.item.armor.ItemRubberBoots;
import thebetweenlands.common.network.clientbound.MessageShockArrowHit;

public class EntityShock
extends Entity {
    private final Entity source;
    private final float damage;
    private final Set<EntityLivingBase> targets = new HashSet<EntityLivingBase>();
    private int maxJumps;
    private int jumps;
    private boolean isWet;

    public EntityShock(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.5f);
        this.source = null;
        this.damage = 0.0f;
    }

    public EntityShock(World worldIn, Entity source, EntityLivingBase hit, float damage, boolean isWet) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.5f);
        this.func_70012_b(source.field_70165_t, source.field_70163_u, source.field_70161_v, 0.0f, 0.0f);
        this.source = source;
        if (hit != null) {
            this.targets.add(hit);
        }
        this.damage = damage;
        this.isWet = isWet;
        this.maxJumps = 2 + this.field_70170_p.field_73012_v.nextInt(3);
        if (isWet) {
            this.maxJumps *= 2;
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }

    public boolean func_70039_c(NBTTagCompound compound) {
        return false;
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.source == null) {
                this.func_70106_y();
            } else {
                DamageSource damageSource;
                Entity shootingEntity;
                if (this.source instanceof EntityBLArrow) {
                    shootingEntity = ((EntityBLArrow)this.source).getThrower();
                    damageSource = shootingEntity != null ? DamageSource.func_76353_a((EntityArrow)((EntityBLArrow)this.source), (Entity)shootingEntity) : DamageSource.func_76353_a((EntityArrow)((EntityBLArrow)this.source), (Entity)((EntityBLArrow)this.source));
                } else if (this.source instanceof EntityLivingBase) {
                    shootingEntity = null;
                    damageSource = DamageSource.func_76358_a((EntityLivingBase)((EntityLivingBase)this.source));
                } else {
                    shootingEntity = null;
                    damageSource = DamageSource.field_76377_j;
                }
                ArrayList<Pair<Entity, Entity>> chain = new ArrayList<Pair<Entity, Entity>>();
                if (this.jumps < this.maxJumps) {
                    if (this.field_70173_aa != 0 && this.field_70173_aa % 3 == 0) {
                        HashSet<EntityLivingBase> newTargets = new HashSet<EntityLivingBase>();
                        block0: for (Entity entity : this.targets) {
                            boolean isWet = entity.func_70026_G() || entity.func_70090_H() || this.field_70170_p.func_175727_C(entity.func_180425_c().func_177984_a());
                            List entities = this.field_70170_p.func_175647_a(EntityLivingBase.class, entity.func_174813_aQ().func_186662_g(isWet ? 6.0 : 4.0), e -> {
                                Entity riding = e.func_184208_bv();
                                return riding == e || !(riding instanceof EntityLivingBase);
                            });
                            if (entities.size() <= 1) continue;
                            Collections.sort(entities, (e1, e2) -> Double.compare(e1.func_70068_e(entity), e2.func_70068_e(entity)));
                            for (int j = 1; j < entities.size(); ++j) {
                                EntityLivingBase newTarget = (EntityLivingBase)entities.get(j);
                                if (this.targets.contains(newTarget) || newTargets.contains(newTarget)) continue;
                                newTargets.add(newTarget);
                                chain.add((Pair<Entity, Entity>)Pair.of((Object)entity, (Object)newTarget));
                                float f = MathHelper.func_76133_a((double)(this.source.field_70159_w * this.source.field_70159_w + this.source.field_70181_x * this.source.field_70181_x + this.source.field_70179_y * this.source.field_70179_y));
                                float damage = this.damage;
                                if (this.source instanceof EntityBLArrow) {
                                    damage = MathHelper.func_76143_f((double)((double)f * ((EntityBLArrow)this.source).func_70242_d()));
                                    if (((EntityBLArrow)this.source).func_70241_g()) {
                                        damage += (float)this.field_70146_Z.nextInt((int)damage / 2 + 2);
                                    }
                                }
                                boolean blocked = false;
                                for (ItemStack stack : newTarget.func_184209_aF()) {
                                    if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemRubberBoots)) continue;
                                    stack.func_77972_a(2, newTarget);
                                    blocked = true;
                                }
                                boolean wasShocked = false;
                                if (!blocked) {
                                    wasShocked = newTarget.func_70097_a(damageSource, isWet ? 2.0f * damage : damage);
                                    for (Entity passenger : newTarget.func_184182_bu()) {
                                        if (!(passenger instanceof EntityLivingBase) || this.targets.contains(passenger) || newTargets.contains(passenger)) continue;
                                        passenger.func_70097_a(damageSource, isWet ? 2.0f * damage : damage);
                                        newTargets.add((EntityLivingBase)passenger);
                                    }
                                }
                                if (wasShocked) continue block0;
                                newTarget.func_70690_d(ElixirEffectRegistry.EFFECT_SHOCKED.createEffect(newTarget instanceof EntityPlayer ? 30 : 80, 0, true, true));
                                continue block0;
                            }
                        }
                        this.targets.addAll(newTargets);
                        TheBetweenlands.networkWrapper.sendToAllTracking((IMessage)new MessageShockArrowHit(chain), (Entity)this);
                        ++this.jumps;
                    }
                } else {
                    this.func_70106_y();
                }
            }
        }
    }
}

