/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity;

import io.netty.buffer.ByteBuf;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.util.NonNullDelegateList;

public class EntityGreeblingCorpse
extends Entity
implements IEntityAdditionalSpawnData {
    private static final byte EVENT_FADE = 80;
    private float rotation;
    private boolean looted = false;
    private NonNullList<ItemStack> loot = NonNullList.func_191196_a();
    private boolean fading;
    public int fadeTimer = 0;

    public EntityGreeblingCorpse(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 0.2f);
        this.rotation = this.field_70170_p.field_73012_v.nextFloat() * 360.0f;
    }

    protected void func_70088_a() {
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74757_a("Fading", this.fading);
        nbt.func_74768_a("FadeTimer", this.fadeTimer);
        nbt.func_74757_a("Looted", this.looted);
        nbt.func_74768_a("LootCount", this.loot.size());
        nbt.func_74782_a("Loot", (NBTBase)ItemStackHelper.func_191281_a((NBTTagCompound)new NBTTagCompound(), this.loot, (boolean)false));
        nbt.func_74776_a("Rotation", this.rotation);
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.fading = nbt.func_74767_n("Fading");
        this.fadeTimer = nbt.func_74762_e("FadeTimer");
        this.looted = nbt.func_74767_n("Looted");
        this.loot = NonNullList.func_191197_a((int)nbt.func_74762_e("LootCount"), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt.func_74775_l("Loot"), this.loot);
        if (nbt.func_150297_b("Rotation", 5)) {
            this.rotation = nbt.func_74760_g("Rotation");
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_189652_ae()) {
            this.field_70181_x -= 0.08;
        }
        this.func_70091_d(MoverType.SELF, 0.0, this.field_70181_x, 0.0);
        this.field_70126_B = this.field_70177_z = this.rotation;
        if (this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(40) == 0) {
            this.spawnParticles();
        }
        if (this.fading) {
            ++this.fadeTimer;
        }
        if (!this.field_70170_p.field_72995_K && this.fadeTimer > 50) {
            this.func_70106_y();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 80) {
            this.fading = true;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles() {
        BLParticles.MOSQUITO.spawn(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v);
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnBreakParticles() {
        for (int i = 0; i < 12; ++i) {
            BLParticles.WEEDWOOD_LEAF.spawn(this.field_70170_p, this.field_70165_t + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.5f), this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.5f), (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.1f, this.field_70170_p.field_73012_v.nextFloat() * 0.05f + 0.05f, (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.1f));
        }
    }

    public boolean func_85031_j(Entity entity) {
        if (!this.fading && entity instanceof EntityPlayer) {
            if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73012_v.nextBoolean() && !this.dropLoot((EntityPlayer)entity)) {
                this.fading = true;
                this.field_70170_p.func_72960_a((Entity)this, (byte)80);
            }
            if (this.field_70170_p.field_72995_K) {
                this.spawnBreakParticles();
                SoundType soundType = SoundType.field_185848_a;
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, soundType.func_185846_f(), SoundCategory.NEUTRAL, (soundType.func_185843_a() + 1.0f) / 4.0f, soundType.func_185847_b() * 0.5f, false);
            }
        }
        return true;
    }

    protected boolean dropLoot(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K) {
            if (!this.looted) {
                this.looted = true;
                LootTable lootTable = this.field_70170_p.func_184146_ak().func_186521_a(LootTableRegistry.GREEBLING_CORPSE);
                LootContext.Builder builder = new LootContext.Builder((WorldServer)this.field_70170_p).func_186472_a((Entity)this).func_186470_a(player).func_186469_a(player.func_184817_da());
                this.loot = new NonNullDelegateList<ItemStack>(lootTable.func_186462_a(this.field_70146_Z, builder.func_186471_a()), ItemStack.field_190927_a);
            }
            for (int i = 0; i < this.loot.size(); ++i) {
                ItemStack stack = (ItemStack)this.loot.get(i);
                if (stack.func_190926_b()) continue;
                this.func_70099_a(stack, 0.0f);
                this.loot.set(i, (Object)ItemStack.field_190927_a);
                return true;
            }
        }
        return false;
    }

    public void writeSpawnData(ByteBuf buf) {
        buf.writeFloat(this.rotation);
        buf.writeBoolean(this.fading);
        buf.writeInt(this.fadeTimer);
    }

    public void readSpawnData(ByteBuf buf) {
        this.rotation = buf.readFloat();
        this.fading = buf.readBoolean();
        this.fadeTimer = buf.readInt();
    }
}

