/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity;

import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.entity.mobs.EntityAnadia;
import thebetweenlands.common.registries.ItemRegistry;

public class EntityFishBait
extends EntityItem {
    private static final DataParameter<Integer> SINK_SPEED = EntityDataManager.func_187226_a(EntityFishBait.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DISSOLVE_TIME = EntityDataManager.func_187226_a(EntityFishBait.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> RANGE = EntityDataManager.func_187226_a(EntityFishBait.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final byte EVENT_DEAD = 110;

    public EntityFishBait(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntityFishBait(World world, double x, double y, double z, ItemStack stack) {
        super(world, x, y, z, stack);
    }

    public EntityFishBait(World world) {
        super(world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SINK_SPEED, (Object)3);
        this.field_70180_af.func_187214_a(DISSOLVE_TIME, (Object)200);
        this.field_70180_af.func_187214_a(RANGE, (Object)1);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_130014_f_().field_72995_K && this.field_70173_aa >= this.getBaitDissolveTime() && this.func_174874_s()) {
            this.func_70106_y();
        }
        if (this.func_70090_H()) {
            this.field_70159_w *= 0.9;
            this.field_70181_x = (double)(-((float)this.getBaitSinkSPeed())) * 0.02;
            this.field_70179_y *= 0.9;
            if (!this.func_130014_f_().field_72995_K) {
                if (!this.func_189652_ae()) {
                    this.func_189654_d(true);
                }
                if (this.getBaitRange() >= 1) {
                    this.lureCloseFish();
                }
            }
        } else if (!this.func_130014_f_().field_72995_K && this.func_189652_ae()) {
            this.func_189654_d(false);
        }
    }

    public AxisAlignedBB extendRangeBox() {
        return new AxisAlignedBB(this.field_70165_t - 0.125, this.field_70163_u - 0.125, this.field_70161_v - 0.125, this.field_70165_t + 0.125, this.field_70163_u + 0.125, this.field_70161_v + 0.125).func_72314_b((double)this.getBaitRange() * 0.5, (double)this.getBaitRange() * 0.5, (double)this.getBaitRange() * 0.5);
    }

    public void lureCloseFish() {
        List list = this.func_130014_f_().func_72872_a(EntityAnadia.class, this.extendRangeBox());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EntityAnadia fish = (EntityAnadia)iterator.next();
            if (fish.func_70090_H() && fish.func_70685_l((Entity)this)) continue;
            iterator.remove();
        }
        if (list.isEmpty()) {
            return;
        }
        if (!list.isEmpty()) {
            EntityAnadia foundFish = (EntityAnadia)list.get(0);
            if (foundFish.aiFindBait != null) {
                foundFish.aiFindBait.bait = this;
                foundFish.aiFindBait.func_75246_d();
            }
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (!this.func_130014_f_().field_72995_K) {
            this.func_130014_f_().func_72960_a((Entity)this, (byte)110);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 110) {
            for (int count = 0; count <= 10; ++count) {
                BLParticles.ITEM_BREAKING.spawn(this.func_130014_f_(), this.field_70165_t + (this.func_130014_f_().field_73012_v.nextDouble() - 0.5), this.field_70163_u + (this.func_130014_f_().field_73012_v.nextDouble() - 0.5), this.field_70161_v + (this.func_130014_f_().field_73012_v.nextDouble() - 0.5), (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withData(new ItemStack(ItemRegistry.FISH_BAIT)));
            }
        }
    }

    public boolean func_96092_aw() {
        return false;
    }

    public int getBaitSinkSPeed() {
        return (Integer)this.field_70180_af.func_187225_a(SINK_SPEED);
    }

    public void setBaitSinkSpeed(int weight) {
        this.field_70180_af.func_187227_b(SINK_SPEED, (Object)weight);
    }

    public int getBaitDissolveTime() {
        return (Integer)this.field_70180_af.func_187225_a(DISSOLVE_TIME);
    }

    public void setBaitDissolveTime(int life) {
        this.field_70180_af.func_187227_b(DISSOLVE_TIME, (Object)life);
    }

    public int getBaitRange() {
        return (Integer)this.field_70180_af.func_187225_a(RANGE);
    }

    public void setBaitRange(int range) {
        this.field_70180_af.func_187227_b(RANGE, (Object)range);
    }

    public void shoot(Entity shooter, float pitch, float yaw, float pitchOffset, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, velocity, inaccuracy);
        this.field_70159_w += shooter.field_70159_w;
        this.field_70179_y += shooter.field_70179_y;
        if (!shooter.field_70122_E) {
            this.field_70181_x += shooter.field_70181_x;
        }
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }
}

