/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.capability.pheromonebrew;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import thebetweenlands.api.capability.IInfestationIgnoreCapability;
import thebetweenlands.api.capability.ISerializableCapability;
import thebetweenlands.common.capability.base.EntityCapability;
import thebetweenlands.common.registries.CapabilityRegistry;

public class InfestationIgnoreEntityCapability
extends EntityCapability<InfestationIgnoreEntityCapability, IInfestationIgnoreCapability, EntityPlayer>
implements IInfestationIgnoreCapability,
ISerializableCapability {
    private long immunityTime = -1L;

    @Override
    public ResourceLocation getID() {
        return new ResourceLocation("thebetweenlands", "infestation_ignore");
    }

    @Override
    protected Capability<IInfestationIgnoreCapability> getCapability() {
        return CapabilityRegistry.CAPABILITY_INFESTATION_IGNORE;
    }

    @Override
    protected Class<IInfestationIgnoreCapability> getCapabilityClass() {
        return IInfestationIgnoreCapability.class;
    }

    @Override
    protected InfestationIgnoreEntityCapability getDefaultCapabilityImplementation() {
        return new InfestationIgnoreEntityCapability();
    }

    @Override
    public boolean isApplicable(Entity entity) {
        return entity instanceof EntityPlayer;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74772_a("immunityTime", this.immunityTime);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.immunityTime = nbt.func_74763_f("immunityTime");
    }

    @Override
    public boolean isImmune() {
        return this.getRemainingImmunityTicks() > 0;
    }

    @Override
    public int getRemainingImmunityTicks() {
        return this.immunityTime >= 0L ? Math.max(0, (int)(this.immunityTime - ((EntityPlayer)this.getEntity()).field_70170_p.func_82737_E())) : 0;
    }

    @Override
    public void setImmune(int duration) {
        if (duration <= 0) {
            this.setNotImmune();
        } else {
            this.immunityTime = ((EntityPlayer)this.getEntity()).field_70170_p.func_82737_E() + (long)duration;
            this.markDirty();
        }
    }

    @Override
    public void setNotImmune() {
        if (this.immunityTime != -1L) {
            this.immunityTime = -1L;
            this.markDirty();
        }
    }

    @Override
    public void writeTrackingDataToNBT(NBTTagCompound nbt) {
        this.writeToNBT(nbt);
    }

    @Override
    public void readTrackingDataFromNBT(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }

    @Override
    public int getTrackingTime() {
        return 20;
    }
}

