/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.capability.mud_walker;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import thebetweenlands.api.capability.IMudWalkerCapability;
import thebetweenlands.api.capability.ISerializableCapability;
import thebetweenlands.common.capability.base.EntityCapability;
import thebetweenlands.common.registries.CapabilityRegistry;

public class MudWalkerCapability
extends EntityCapability<MudWalkerCapability, IMudWalkerCapability, EntityPlayer>
implements IMudWalkerCapability,
ISerializableCapability {
    private long reductionTime = -1L;

    @Override
    public ResourceLocation getID() {
        return new ResourceLocation("thebetweenlands", "mud_walker");
    }

    @Override
    protected Capability<IMudWalkerCapability> getCapability() {
        return CapabilityRegistry.CAPABILITY_MUD_WALKER;
    }

    @Override
    protected Class<IMudWalkerCapability> getCapabilityClass() {
        return IMudWalkerCapability.class;
    }

    @Override
    protected MudWalkerCapability getDefaultCapabilityImplementation() {
        return new MudWalkerCapability();
    }

    @Override
    public boolean isApplicable(Entity entity) {
        return entity instanceof EntityPlayer;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74772_a("reductionTime", this.reductionTime);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.reductionTime = nbt.func_74763_f("reductionTime");
    }

    @Override
    public boolean isActive() {
        return this.getRemainingActiveTicks() > 0;
    }

    @Override
    public int getRemainingActiveTicks() {
        return this.reductionTime >= 0L ? Math.max(0, (int)(this.reductionTime - ((EntityPlayer)this.getEntity()).field_70170_p.func_82737_E())) : 0;
    }

    @Override
    public void setActive(int duration) {
        if (duration <= 0) {
            this.setNotActive();
        } else {
            this.reductionTime = ((EntityPlayer)this.getEntity()).field_70170_p.func_82737_E() + (long)duration;
            this.markDirty();
        }
    }

    @Override
    public void setNotActive() {
        if (this.reductionTime != -1L) {
            this.reductionTime = -1L;
            this.markDirty();
        }
    }

    @Override
    public void writeTrackingDataToNBT(NBTTagCompound nbt) {
        this.writeToNBT(nbt);
    }

    @Override
    public void readTrackingDataFromNBT(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }

    @Override
    public int getTrackingTime() {
        return 20;
    }
}

