/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.terrain;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.api.block.IFarmablePlant;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.block.ITintedBlock;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.util.AdvancedStateMap;

public class BlockPuddle
extends Block
implements ITintedBlock,
BlockRegistry.IStateMappedBlock {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
    public static final PropertyInteger AMOUNT = PropertyInteger.func_177719_a((String)"amount", (int)0, (int)15);
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");

    public BlockPuddle() {
        super(Material.field_151578_c);
        this.func_149711_c(0.1f);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)AMOUNT, (Comparable)Integer.valueOf(0)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AMOUNT, NORTH, EAST, SOUTH, WEST});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AMOUNT, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AMOUNT);
    }

    @Override
    public void setStateMapper(AdvancedStateMap.Builder builder) {
        builder.ignore(new IProperty[]{AMOUNT});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        BlockPos.PooledMutableBlockPos offset = BlockPos.PooledMutableBlockPos.func_185346_s();
        BlockPos.PooledMutableBlockPos offsetDown = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            PropertyBool prop;
            offset.func_181079_c(pos.func_177958_n() + facing.func_82601_c(), pos.func_177956_o(), pos.func_177952_p() + facing.func_82599_e());
            IBlockState offsetState = worldIn.func_180495_p((BlockPos)offset);
            offsetDown.func_181079_c(pos.func_177958_n() + facing.func_82601_c(), pos.func_177956_o() - 1, pos.func_177952_p() + facing.func_82599_e());
            IBlockState offsetDownState = worldIn.func_180495_p((BlockPos)offsetDown);
            switch (facing) {
                default: {
                    prop = NORTH;
                    break;
                }
                case EAST: {
                    prop = EAST;
                    break;
                }
                case SOUTH: {
                    prop = SOUTH;
                    break;
                }
                case WEST: {
                    prop = WEST;
                }
            }
            state = state.func_177226_a((IProperty)prop, (Comparable)Boolean.valueOf(!(offsetState.func_177230_c() instanceof BlockPuddle) && offsetDownState.isSideSolid(worldIn, (BlockPos)offsetDown, EnumFacing.UP) && offsetDownState.func_193401_d(worldIn, (BlockPos)offsetDown, EnumFacing.UP) == BlockFaceShape.SOLID));
        }
        offset.func_185344_t();
        offsetDown.func_185344_t();
        return state;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            int amount = (Integer)state.func_177229_b((IProperty)AMOUNT);
            if (!BetweenlandsWorldStorage.forWorld((World)world).getEnvironmentEventRegistry().heavyRain.isActive()) {
                world.func_175698_g(pos);
                amount = 0;
            } else if (world.func_175710_j(pos)) {
                amount = Math.min(amount + rand.nextInt(6), 15);
                world.func_180501_a(pos, state.func_177226_a((IProperty)AMOUNT, (Comparable)Integer.valueOf(amount)), 2);
            }
            if (amount > 2) {
                amount = Math.max(0, amount - 3);
                world.func_180501_a(pos, state.func_177226_a((IProperty)AMOUNT, (Comparable)Integer.valueOf(amount)), 2);
                for (int xo = -1; xo <= 1; ++xo) {
                    for (int zo = -1; zo <= 1; ++zo) {
                        BlockPos newPos = pos.func_177982_a(xo, 0, zo);
                        if (xo == 0 && zo == 0 || xo * xo == zo * zo) continue;
                        IBlockState offsetState = world.func_180495_p(newPos);
                        if ((world.func_175623_d(newPos) || offsetState.func_177230_c() instanceof IFarmablePlant && ((IFarmablePlant)offsetState.func_177230_c()).canBeDestroyedByPuddles(world, newPos, offsetState)) && this.func_176196_c(world, newPos)) {
                            world.func_175656_a(newPos, this.func_176223_P());
                            continue;
                        }
                        if (world.func_180495_p(newPos).func_177230_c() != BlockRegistry.PUDDLE) continue;
                        world.func_180501_a(newPos, state.func_177226_a((IProperty)AMOUNT, (Comparable)Integer.valueOf(Math.min(amount + rand.nextInt(6), 15))), 2);
                    }
                }
            }
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() == this) {
            return false;
        }
        return side == EnumFacing.UP || side == EnumFacing.DOWN || super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        return (block.func_176200_f((IBlockAccess)world, pos) || block instanceof IFarmablePlant && ((IFarmablePlant)block).canBeDestroyedByPuddles(world, pos, state)) && world.isSideSolid(pos.func_177977_b(), EnumFacing.UP) && world.func_180495_p(pos.func_177977_b()).func_193401_d((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) == BlockFaceShape.SOLID;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos, EnumFacing.UP)) {
            world.func_175698_g(pos);
        }
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    @Override
    public int getColorMultiplier(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
        if (worldIn == null || pos == null) {
            return -1;
        }
        int avgRed = 0;
        int avgGreen = 0;
        int avgBlue = 0;
        for (int xOff = -1; xOff <= 1; ++xOff) {
            for (int yOff = -1; yOff <= 1; ++yOff) {
                int colorMultiplier = worldIn.func_180494_b(pos.func_177982_a(xOff, 0, yOff)).getWaterColorMultiplier();
                avgRed += (colorMultiplier & 0xFF0000) >> 16;
                avgGreen += (colorMultiplier & 0xFF00) >> 8;
                avgBlue += colorMultiplier & 0xFF;
            }
        }
        return (avgRed / 9 & 0xFF) << 16 | (avgGreen / 9 & 0xFF) << 8 | avgBlue / 9 & 0xFF;
    }

    public boolean func_176209_a(IBlockState state, boolean hitIfLiquid) {
        return false;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, Entity entity) {
        IBlockState stateBelow = world.func_180495_p(pos.func_177977_b());
        return stateBelow.func_177230_c().getSoundType(stateBelow, world, pos.func_177977_b(), entity);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        float strength;
        if (entityIn.field_70170_p.field_72995_K && entityIn instanceof EntityPlayer && entityIn.field_70163_u <= (double)((float)pos.func_177956_o() + 0.01f) && entityIn.field_70173_aa % 5 == 0 && (strength = MathHelper.func_76133_a((double)(entityIn.field_70159_w * entityIn.field_70159_w * 0.2 + entityIn.field_70181_x * entityIn.field_70181_x + entityIn.field_70179_y * entityIn.field_70179_y * 0.2)) * 0.2f) > 0.01f) {
            entityIn.func_184185_a(SoundEvents.field_187549_bG, strength * 8.0f, 1.0f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.4f);
            int j = 0;
            while ((float)j < 10.0f + entityIn.field_70130_N * 20.0f) {
                float rx = (worldIn.field_73012_v.nextFloat() * 2.0f - 1.0f) * entityIn.field_70130_N;
                float rz = (worldIn.field_73012_v.nextFloat() * 2.0f - 1.0f) * entityIn.field_70130_N;
                worldIn.func_175688_a(EnumParticleTypes.WATER_SPLASH, entityIn.field_70165_t + (double)rx, (double)((float)pos.func_177956_o() + 0.1f), entityIn.field_70161_v + (double)rz, entityIn.field_70159_w + (double)((worldIn.field_73012_v.nextFloat() - 0.5f) * strength * 20.0f), entityIn.field_70181_x, entityIn.field_70179_y + (double)((worldIn.field_73012_v.nextFloat() - 0.5f) * strength * 20.0f), new int[0]);
                ++j;
            }
        }
    }
}

