/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.structure;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.block.structure.BlockMudTiles;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.tile.TileEntityPuffshroom;

public class BlockPuffshroom
extends Block
implements ITileEntityProvider {
    public BlockPuffshroom() {
        super(Material.field_151576_e);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(8.0f);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityPuffshroom();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.tryHarvestWithShears(world, pos, state, player, player.func_184586_b(hand), true);
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World worldIn, BlockPos pos) {
        ItemStack stack = player.func_184614_ca();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemShears) {
            return 1.0f;
        }
        return super.func_180647_a(state, player, worldIn, pos);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.tryHarvestWithShears(worldIn, pos, state, player, player.func_184614_ca(), false);
    }

    protected boolean tryHarvestWithShears(World world, BlockPos pos, IBlockState state, EntityPlayer player, ItemStack stack, boolean effects) {
        TileEntity tile;
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemShears && (tile = world.func_175625_s(pos)) instanceof TileEntityPuffshroom) {
            TileEntityPuffshroom puffshroom = (TileEntityPuffshroom)tile;
            if (puffshroom.animation_1 >= 1) {
                if (!world.field_72995_K && world instanceof WorldServer) {
                    LootTable lootTable = ((WorldServer)world).func_184146_ak().func_186521_a(LootTableRegistry.PUFFSHROOM);
                    LootContext.Builder lootBuilder = new LootContext.Builder((WorldServer)world);
                    List loot = lootTable.func_186462_a(((WorldServer)world).field_73012_v, lootBuilder.func_186471_a());
                    for (ItemStack lootStack : loot) {
                        BlockPuffshroom.func_180635_a((World)world, (BlockPos)pos.func_177984_a(), (ItemStack)lootStack);
                    }
                    world.func_180501_a(pos, BlockRegistry.MUD_TILES.func_176223_P().func_177226_a(BlockMudTiles.VARIANT, (Comparable)((Object)BlockMudTiles.EnumMudTileType.MUD_TILES_CRACKED)), 3);
                    if (effects) {
                        world.func_180498_a(null, 2001, pos, Block.func_149682_b((Block)this));
                    }
                    world.func_184138_a(pos, state, state, 3);
                    stack.func_77972_a(1, (EntityLivingBase)player);
                }
                return true;
            }
        }
        return false;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.func_176208_a(world, pos, state, player);
        return world.func_180501_a(pos, BlockRegistry.MUD_TILES.func_176223_P().func_177226_a(BlockMudTiles.VARIANT, (Comparable)((Object)BlockMudTiles.EnumMudTileType.MUD_TILES_CRACKED)), world.field_72995_K ? 11 : 3);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return 0;
    }
}

