/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.structure;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.block.IConnectedTextureBlock;

public class BlockDiagonalEnergyBarrier
extends Block
implements IConnectedTextureBlock {
    public static final PropertyBool FLIPPED = PropertyBool.func_177716_a((String)"flipped");
    public static final AxisAlignedBB CORNER_NW_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.25, 1.0, 0.25);
    public static final AxisAlignedBB CORNER_SW_AABB = new AxisAlignedBB(0.0, 0.0, 0.75, 0.25, 1.0, 1.0);
    public static final AxisAlignedBB CORNER_NE_AABB = new AxisAlignedBB(0.75, 0.0, 0.0, 1.0, 1.0, 0.25);
    public static final AxisAlignedBB CORNER_SE_AABB = new AxisAlignedBB(0.75, 0.0, 0.75, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB MID_NW_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.5, 1.0, 0.5);
    public static final AxisAlignedBB MID_SW_AABB = new AxisAlignedBB(0.25, 0.0, 0.5, 0.5, 1.0, 0.75);
    public static final AxisAlignedBB MID_NE_AABB = new AxisAlignedBB(0.5, 0.0, 0.25, 0.75, 1.0, 0.5);
    public static final AxisAlignedBB MID_SE_AABB = new AxisAlignedBB(0.5, 0.0, 0.5, 0.75, 1.0, 0.75);

    public BlockDiagonalEnergyBarrier() {
        super(Material.field_151592_s);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)FLIPPED, (Comparable)Boolean.valueOf(false)));
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.func_149722_s();
        this.func_149752_b(6000000.0f);
        this.func_149715_a(0.8f);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() != this && super.func_176225_a(blockState, blockAccess, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return field_185505_j.func_186670_a(pos);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FLIPPED, (Comparable)Boolean.valueOf(meta > 0));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)FLIPPED) != false ? 1 : 0;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FLIPPED, (Comparable)Boolean.valueOf(BlockDiagonalEnergyBarrier.getFacingFromEntity(pos, placer)));
    }

    public static boolean getFacingFromEntity(BlockPos pos, EntityLivingBase entity) {
        EnumFacing facing = entity.func_174811_aO();
        return facing == EnumFacing.EAST || facing == EnumFacing.WEST;
    }

    protected BlockStateContainer func_180661_e() {
        return this.getConnectedTextureBlockStateContainer(new ExtendedBlockState((Block)this, new IProperty[]{FLIPPED}, new IUnlistedProperty[0]));
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean flipped = (Boolean)state.func_177229_b((IProperty)FLIPPED);
        return this.getExtendedConnectedTextureState((IExtendedBlockState)state, world, pos, p -> {
            int xzSteps = Math.abs(p.func_177958_n() - pos.func_177958_n()) + Math.abs(p.func_177952_p() - pos.func_177952_p());
            IBlockState otherState = world.func_180495_p(p);
            if (p.func_177956_o() != pos.func_177956_o() && xzSteps == 0 || xzSteps > 1) {
                return otherState.func_177230_c() instanceof BlockDiagonalEnergyBarrier && (Boolean)otherState.func_177229_b((IProperty)FLIPPED) == flipped;
            }
            return false;
        }, false);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (!isActualState) {
            state = state.func_185899_b((IBlockAccess)world, pos);
        }
        if (((Boolean)state.func_177229_b((IProperty)FLIPPED)).booleanValue()) {
            BlockDiagonalEnergyBarrier.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CORNER_NW_AABB);
            BlockDiagonalEnergyBarrier.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)MID_NW_AABB);
            BlockDiagonalEnergyBarrier.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)MID_SE_AABB);
            BlockDiagonalEnergyBarrier.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CORNER_SE_AABB);
        }
        if (!((Boolean)state.func_177229_b((IProperty)FLIPPED)).booleanValue()) {
            BlockDiagonalEnergyBarrier.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CORNER_NE_AABB);
            BlockDiagonalEnergyBarrier.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)MID_NE_AABB);
            BlockDiagonalEnergyBarrier.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)MID_SW_AABB);
            BlockDiagonalEnergyBarrier.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CORNER_SW_AABB);
        }
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        RayTraceResult result = super.func_180636_a(blockState, worldIn, pos, start, end);
        if (result != null) {
            Vec3d diff = end.func_178788_d(start);
            Vec3d dir = diff.func_72432_b();
            Vec3d p0 = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            Vec3d n = (Boolean)blockState.func_177229_b((IProperty)FLIPPED) != false ? new Vec3d(0.70710678118, 0.0, -0.70710678118) : new Vec3d(0.70710678118, 0.0, 0.70710678118);
            double d = p0.func_178788_d(start).func_72430_b(n) / dir.func_72430_b(n);
            Vec3d intercept = start.func_178787_e(dir.func_186678_a(d));
            if (intercept.field_72450_a >= (double)pos.func_177958_n() && intercept.field_72450_a <= (double)(pos.func_177958_n() + 1) && intercept.field_72448_b >= (double)pos.func_177956_o() && intercept.field_72448_b <= (double)(pos.func_177956_o() + 1) && intercept.field_72449_c >= (double)pos.func_177952_p() && intercept.field_72449_c <= (double)(pos.func_177952_p() + 1)) {
                return new RayTraceResult(intercept, result.field_178784_b, result.func_178782_a());
            }
        }
        return null;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

