/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.plant;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.block.ISickleHarvestable;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.block.ITintedBlock;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.util.OpenSimplexNoise;

public class BlockMoss
extends BlockDirectional
implements IShearable,
ISickleHarvestable,
ITintedBlock {
    protected static final AxisAlignedBB MOSS_UP_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.2, 1.0);
    protected static final AxisAlignedBB MOSS_DOWN_AABB = new AxisAlignedBB(0.0, 0.8, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB MOSS_WEST_AABB = new AxisAlignedBB(0.8, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB MOSS_EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.2, 1.0, 1.0);
    protected static final AxisAlignedBB MOSS_SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.2);
    protected static final AxisAlignedBB MOSS_NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.8, 1.0, 1.0, 1.0);
    protected ItemStack sickleHarvestableDrop;
    protected boolean isReplaceable = false;
    public final boolean spreading;
    private final OpenSimplexNoise spreadingClusterNoise1 = new OpenSimplexNoise(1337L);
    private final OpenSimplexNoise spreadingClusterNoise2 = new OpenSimplexNoise(42L);

    public BlockMoss(boolean spreading) {
        super(Material.field_151585_k);
        this.spreading = spreading;
        this.func_149711_c(0.2f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149647_a(BLCreativeTabs.PLANTS);
        this.func_149675_a(true);
    }

    public BlockMoss setSickleDrop(ItemStack drop) {
        this.sickleHarvestableDrop = drop;
        return this;
    }

    public BlockMoss setReplaceable(boolean replaceable) {
        this.isReplaceable = replaceable;
        return this;
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return this.isReplaceable;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)).func_176745_a();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        if (this.canPlaceAt(world, pos, facing)) {
            return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)facing);
        }
        for (EnumFacing enumfacing : EnumFacing.field_82609_l) {
            if (!world.isSideSolid(pos.func_177972_a(enumfacing.func_176734_d()), enumfacing, true)) continue;
            return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)enumfacing);
        }
        return this.func_176223_P();
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : field_176387_N.func_177700_c()) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    private boolean canPlaceAt(World worldIn, BlockPos pos, EnumFacing facing) {
        BlockPos blockPos = pos.func_177972_a(facing.func_176734_d());
        boolean flag = facing.func_176740_k().func_176722_c();
        return flag && worldIn.isSideSolid(blockPos, facing, true) || (facing.equals((Object)EnumFacing.DOWN) || facing.equals((Object)EnumFacing.UP)) && this.canPlaceOn(worldIn, blockPos);
    }

    private boolean canPlaceOn(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        return state.isSideSolid((IBlockAccess)worldIn, pos, EnumFacing.UP);
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return item.func_77973_b() == ItemRegistry.SYRMORITE_SHEARS || item.func_77973_b() == ItemRegistry.SILT_CRAB_CLAW;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return ImmutableList.of((Object)new ItemStack(Item.func_150898_a((Block)this)));
    }

    @Override
    public boolean isHarvestable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Override
    public List<ItemStack> getHarvestableDrops(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return this.sickleHarvestableDrop != null ? ImmutableList.of((Object)this.sickleHarvestableDrop.func_77946_l()) : ImmutableList.of();
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (this.checkForDrop(worldIn, pos, state)) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)field_176387_N);
            EnumFacing.Axis axis = facing.func_176740_k();
            EnumFacing oppositeFacing = facing.func_176734_d();
            boolean shouldDrop = false;
            if (axis.func_176722_c() && !worldIn.isSideSolid(pos.func_177972_a(oppositeFacing), facing, true)) {
                shouldDrop = true;
            } else if (axis.func_176720_b() && !this.canPlaceOn(worldIn, pos.func_177972_a(oppositeFacing))) {
                shouldDrop = true;
            }
            if (shouldDrop) {
                this.func_176226_b(worldIn, pos, state, 0);
                worldIn.func_175698_g(pos);
            }
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.checkForDrop(worldIn, pos, state);
    }

    protected boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this && this.canPlaceAt(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)field_176387_N))) {
            return true;
        }
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
        return false;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_176387_N, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176387_N});
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)) {
            default: {
                return MOSS_EAST_AABB;
            }
            case WEST: {
                return MOSS_WEST_AABB;
            }
            case SOUTH: {
                return MOSS_SOUTH_AABB;
            }
            case NORTH: {
                return MOSS_NORTH_AABB;
            }
            case UP: {
                return MOSS_UP_AABB;
            }
            case DOWN: 
        }
        return MOSS_DOWN_AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (this.spreading) {
            int yy;
            double noiseScale = 0.06;
            double ridgedNoise = Math.min(Math.abs(this.spreadingClusterNoise1.eval(((double)pos.func_177958_n() + 0.5) * noiseScale, ((double)pos.func_177956_o() + 0.5) * noiseScale, ((double)pos.func_177952_p() + 0.5) * noiseScale)), Math.abs(this.spreadingClusterNoise2.eval(((double)pos.func_177958_n() + 0.5) * noiseScale, ((double)pos.func_177956_o() + 0.5) * noiseScale, ((double)pos.func_177952_p() + 0.5) * noiseScale)));
            boolean spread = ridgedNoise >= 0.065;
            BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
            int radius = 2;
            int attempt = 0;
            for (int xx = pos.func_177958_n() - radius; xx <= pos.func_177958_n() + radius; ++xx) {
                for (int zz = pos.func_177952_p() - radius; zz <= pos.func_177952_p() + radius; ++zz) {
                    for (yy = pos.func_177956_o() - radius; yy <= pos.func_177956_o() + radius; ++yy) {
                        if (world.func_175667_e((BlockPos)checkPos.func_181079_c(xx, yy, zz))) continue;
                        return;
                    }
                }
            }
            if (rand.nextInt(3) == 0) {
                if (spread) {
                    int xx;
                    int maxNearbyMossBlocks = 6;
                    for (xx = pos.func_177958_n() - radius; xx <= pos.func_177958_n() + radius; ++xx) {
                        for (int zz = pos.func_177952_p() - radius; zz <= pos.func_177952_p() + radius; ++zz) {
                            for (int yy2 = pos.func_177956_o() - radius; yy2 <= pos.func_177956_o() + radius; ++yy2) {
                                if (world.func_180495_p((BlockPos)checkPos.func_181079_c(xx, yy2, zz)).func_177230_c() != this || --maxNearbyMossBlocks > 0) continue;
                                return;
                            }
                        }
                    }
                    for (attempt = 0; attempt < 30; ++attempt) {
                        BlockPos offsetPos;
                        xx = pos.func_177958_n() + rand.nextInt(3) - 1;
                        yy = pos.func_177956_o() + rand.nextInt(3) - 1;
                        int zz = pos.func_177952_p() + rand.nextInt(3) - 1;
                        int offsetDir = 0;
                        if (xx != pos.func_177958_n()) {
                            ++offsetDir;
                        }
                        if (yy != pos.func_177956_o()) {
                            ++offsetDir;
                        }
                        if (zz != pos.func_177952_p()) {
                            ++offsetDir;
                        }
                        if (offsetDir > 1 || !world.func_175623_d(offsetPos = new BlockPos(xx, yy, zz))) continue;
                        EnumFacing facing = EnumFacing.func_82600_a((int)rand.nextInt(EnumFacing.field_82609_l.length));
                        EnumFacing.Axis axis = facing.func_176740_k();
                        EnumFacing oppositeFacing = facing.func_176734_d();
                        boolean isInvalid = false;
                        if (axis.func_176722_c() && !world.isSideSolid(offsetPos.func_177972_a(oppositeFacing), facing, true)) {
                            isInvalid = true;
                        } else if (axis.func_176720_b() && !this.canPlaceOn(world, offsetPos.func_177972_a(oppositeFacing))) {
                            isInvalid = true;
                        }
                        if (isInvalid) continue;
                        world.func_175656_a(offsetPos, this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)facing));
                        break;
                    }
                }
            } else if (rand.nextInt(27) == 0) {
                world.func_175698_g(pos);
            }
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public int getColorMultiplier(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
        return worldIn != null && pos != null ? BiomeColorHelper.func_180287_b((IBlockAccess)worldIn, (BlockPos)pos) : ColorizerFoliage.func_77468_c();
    }
}

