/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.misc;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.block.BlockStateContainerHelper;
import thebetweenlands.common.block.terrain.BlockSwampWater;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.FluidRegistry;

public class BlockGlowingGoopUnderwater
extends BlockSwampWater {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");

    public BlockGlowingGoopUnderwater() {
        super(FluidRegistry.SWAMP_WATER, Material.field_151586_h);
        this.setUnderwaterBlock(true);
        this.func_180632_j(this.func_176194_O().func_177621_b());
        this.func_149715_a(1.0f);
        this.func_149711_c(0.025f);
        this.func_149752_b(2.0f);
        this.func_149672_a(SoundType.field_185859_l);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
    }

    @Override
    @Nullable
    public ItemBlock getItemBlock() {
        return null;
    }

    public int func_149745_a(Random rng) {
        return 1;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)BlockRegistry.GLOWING_GOOP);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    @Override
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        float widthMin = 0.0f;
        float heightMin = 0.0f;
        float depthMin = 0.0f;
        float widthMax = 0.0f;
        float heightMax = 0.0f;
        float depthMax = 0.0f;
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case UP: {
                widthMin = 0.125f;
                heightMin = 0.0f;
                depthMin = 0.125f;
                widthMax = 0.125f;
                heightMax = 0.75f;
                depthMax = 0.125f;
                break;
            }
            case DOWN: {
                widthMin = 0.125f;
                heightMin = 0.75f;
                depthMin = 0.125f;
                widthMax = 0.125f;
                heightMax = 0.0f;
                depthMax = 0.125f;
                break;
            }
            case NORTH: {
                widthMin = 0.125f;
                heightMin = 0.125f;
                depthMin = 0.75f;
                widthMax = 0.125f;
                heightMax = 0.125f;
                depthMax = 0.0f;
                break;
            }
            case WEST: {
                widthMin = 0.75f;
                heightMin = 0.125f;
                depthMin = 0.125f;
                widthMax = 0.0f;
                heightMax = 0.125f;
                depthMax = 0.125f;
                break;
            }
            case SOUTH: {
                widthMin = 0.125f;
                heightMin = 0.125f;
                depthMin = 0.0f;
                widthMax = 0.125f;
                heightMax = 0.125f;
                depthMax = 0.75f;
                break;
            }
            case EAST: {
                widthMin = 0.0f;
                heightMin = 0.125f;
                depthMin = 0.125f;
                widthMax = 0.75f;
                heightMax = 0.125f;
                depthMax = 0.125f;
            }
        }
        return new AxisAlignedBB((double)(0.0f + widthMin), (double)(0.0f + heightMin), (double)(0.0f + depthMin), (double)(1.0f - widthMax), (double)(1.0f - heightMax), (double)(1.0f - depthMax));
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return this.canPlaceBlock(world, pos, side);
    }

    @Override
    public boolean func_176196_c(World world, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!this.canPlaceBlock(world, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    public boolean canPlaceBlock(World world, BlockPos pos, EnumFacing direction) {
        BlockPos blockpos = pos.func_177972_a(direction.func_176734_d());
        IBlockState state = world.func_180495_p(blockpos);
        boolean isSolid = state.func_193401_d((IBlockAccess)world, blockpos, direction) == BlockFaceShape.SOLID;
        return world.func_175677_d(blockpos, true) && state.func_185914_p() && isSolid;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return BlockStateContainerHelper.extendBlockstateContainer((ExtendedBlockState)super.func_180661_e(), new IProperty[]{FACING}, new IUnlistedProperty[0]);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        super.func_189540_a(state, world, fromPos, block, fromPos);
        boolean shouldStay = false;
        if (world.isSideSolid(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d()), (EnumFacing)state.func_177229_b((IProperty)FACING))) {
            shouldStay = true;
        }
        if (!shouldStay) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
        super.func_189540_a(state, world, pos, block, fromPos);
    }

    @Override
    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.func_176208_a(world, pos, state, player);
        return world.func_180501_a(pos, BlockRegistry.SWAMP_WATER.func_176223_P(), world.field_72995_K ? 11 : 3);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(BlockRegistry.GLOWING_GOOP);
    }
}

