/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.misc;

import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import thebetweenlands.common.block.IConnectedTextureBlock;
import thebetweenlands.common.block.misc.BlockFilteredSiltGlass;
import thebetweenlands.common.item.EnumBLDyeColor;
import thebetweenlands.common.item.ItemBlockEnum;
import thebetweenlands.common.registries.BlockRegistry;

public class BlockFilteredSiltGlassStained
extends BlockFilteredSiltGlass
implements BlockRegistry.ICustomItemBlock,
BlockRegistry.ISubtypeItemBlockModelDefinition {
    public static final PropertyEnum<EnumBLDyeColor> COLOR = PropertyEnum.func_177709_a((String)"color", EnumBLDyeColor.class);

    public BlockFilteredSiltGlassStained() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(COLOR, (Comparable)((Object)EnumBLDyeColor.DULL_LAVENDER)));
    }

    @Override
    public ItemBlock getItemBlock() {
        return ItemBlockEnum.create((Block)this, EnumBLDyeColor.class);
    }

    @Override
    public IBlockState getExtendedState(IBlockState oldState, IBlockAccess worldIn, BlockPos pos) {
        IExtendedBlockState state = (IExtendedBlockState)oldState;
        return this.getExtendedConnectedTextureState(state, worldIn, pos, new IConnectedTextureBlock.IConnectionRules(){

            @Override
            public boolean canConnectTo(IBlockAccess world, BlockPos pos, EnumFacing face, BlockPos to) {
                EnumFacing.Axis axis = face.func_176740_k();
                boolean onSamePlane = !(axis == EnumFacing.Axis.X && to.func_177958_n() - pos.func_177958_n() != 0 || axis == EnumFacing.Axis.Y && to.func_177956_o() - pos.func_177956_o() != 0 || axis == EnumFacing.Axis.Z && to.func_177952_p() - pos.func_177952_p() != 0);
                return onSamePlane && world.func_180495_p(to).func_177230_c() instanceof BlockFilteredSiltGlassStained;
            }

            @Override
            public boolean canConnectThrough(IBlockAccess world, BlockPos pos, EnumFacing face, BlockPos to) {
                EnumFacing.Axis axis = face.func_176740_k();
                if (axis == EnumFacing.Axis.X && to.func_177958_n() - pos.func_177958_n() != 0 || axis == EnumFacing.Axis.Y && to.func_177956_o() - pos.func_177956_o() != 0 || axis == EnumFacing.Axis.Z && to.func_177952_p() - pos.func_177952_p() != 0) {
                    return !world.isSideSolid(to, face.func_176734_d(), false) && !(world.func_180495_p(to).func_177230_c() instanceof BlockFilteredSiltGlassStained);
                }
                return false;
            }
        });
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumBLDyeColor)((Object)state.func_177229_b(COLOR))).getMetadata();
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (EnumBLDyeColor enumdyecolor : EnumBLDyeColor.values()) {
            items.add((Object)new ItemStack((Block)this, 1, enumdyecolor.getMetadata()));
        }
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this, 1, ((EnumBLDyeColor)((Object)state.func_177229_b(COLOR))).getMetadata());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(COLOR, (Comparable)((Object)EnumBLDyeColor.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumBLDyeColor)((Object)state.func_177229_b(COLOR))).getMetadata();
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return this.getConnectedTextureBlockStateContainer(new ExtendedBlockState((Block)this, new IProperty[]{COLOR}, new IUnlistedProperty[0]));
    }

    @Override
    public int getSubtypeNumber() {
        return EnumBLDyeColor.values().length;
    }

    @Override
    public String getSubtypeName(int meta) {
        return "filtered_silt_glass_stained_" + EnumBLDyeColor.values()[meta].name().toLowerCase(Locale.ENGLISH);
    }
}

