/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.farming;

import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.block.farming.BlockBarnacle_3_4;
import thebetweenlands.common.block.terrain.BlockHearthgroveLog;
import thebetweenlands.common.block.terrain.BlockSwampWater;
import thebetweenlands.common.item.ItemBlockBarnacle;
import thebetweenlands.common.item.tools.ItemBLBucket;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.FluidRegistry;
import thebetweenlands.util.AdvancedStateMap;

public class BlockBarnacle_1_2
extends BlockSwampWater
implements BlockRegistry.IStateMappedBlock,
BlockRegistry.ICustomItemBlock {
    public static final PropertyEnum<EnumBarnacleTypeEarly> BARNACLE_TYPE_EARLY = PropertyEnum.func_177709_a((String)"barnacle_type_early", EnumBarnacleTypeEarly.class);

    public BlockBarnacle_1_2() {
        this(FluidRegistry.SWAMP_WATER, Material.field_151586_h);
        this.func_149711_c(0.2f);
    }

    public BlockBarnacle_1_2(Fluid fluid, Material materialIn) {
        super(fluid, materialIn);
        this.func_149675_a(true);
        this.func_149711_c(0.2f);
        this.setUnderwaterBlock(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(BARNACLE_TYPE_EARLY, (Comparable)((Object)EnumBarnacleTypeEarly.BARNACLE_DOWN_ONE)).func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(0)));
        this.func_149647_a(BLCreativeTabs.ITEMS);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setStateMapper(AdvancedStateMap.Builder builder) {
        super.setStateMapper(builder);
        builder.ignore(new IProperty[]{LEVEL});
    }

    @Override
    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, EnumBarnacleTypeEarly.BARNACLE_DOWN_ONE.ordinal()));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.TRANSLUCENT || layer == BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        float widthMin = 0.0f;
        float heightMin = 0.0f;
        float depthMin = 0.0f;
        float widthMax = 0.0f;
        float heightMax = 0.0f;
        float depthMax = 0.0f;
        switch (this.getFacingForAttachedSide((EnumBarnacleTypeEarly)((Object)state.func_177229_b(BARNACLE_TYPE_EARLY)))) {
            case DOWN: {
                widthMin = 0.125f;
                heightMin = 0.0f;
                depthMin = 0.125f;
                widthMax = 0.125f;
                heightMax = 0.75f;
                depthMax = 0.125f;
                break;
            }
            case UP: {
                widthMin = 0.125f;
                heightMin = 0.75f;
                depthMin = 0.125f;
                widthMax = 0.125f;
                heightMax = 0.0f;
                depthMax = 0.125f;
                break;
            }
            case SOUTH: {
                widthMin = 0.125f;
                heightMin = 0.125f;
                depthMin = 0.75f;
                widthMax = 0.125f;
                heightMax = 0.125f;
                depthMax = 0.0f;
                break;
            }
            case EAST: {
                widthMin = 0.75f;
                heightMin = 0.125f;
                depthMin = 0.125f;
                widthMax = 0.0f;
                heightMax = 0.125f;
                depthMax = 0.125f;
                break;
            }
            case NORTH: {
                widthMin = 0.125f;
                heightMin = 0.125f;
                depthMin = 0.0f;
                widthMax = 0.125f;
                heightMax = 0.125f;
                depthMax = 0.75f;
                break;
            }
            case WEST: {
                widthMin = 0.0f;
                heightMin = 0.125f;
                depthMin = 0.125f;
                widthMax = 0.75f;
                heightMax = 0.125f;
                depthMax = 0.125f;
            }
        }
        return new AxisAlignedBB((double)(0.0f + widthMin), (double)(0.0f + heightMin), (double)(0.0f + depthMin), (double)(1.0f - widthMax), (double)(1.0f - heightMax), (double)(1.0f - depthMax));
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return BlockBarnacle_1_2.canPlaceBlock(world, pos, side);
    }

    @Override
    public boolean func_176196_c(World world, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!BlockBarnacle_1_2.canPlaceBlock(world, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    protected static boolean canPlaceBlock(World world, BlockPos pos, EnumFacing direction) {
        BlockPos blockpos = pos.func_177972_a(direction.func_176734_d());
        IBlockState iblockstate = world.func_180495_p(blockpos);
        boolean flag = iblockstate.func_193401_d((IBlockAccess)world, blockpos, direction) == BlockFaceShape.SOLID;
        Block block = iblockstate.func_177230_c();
        return world.func_175677_d(blockpos, true) && block.func_149662_c(iblockstate) && flag && world.func_180495_p(pos).func_185904_a() == Material.field_151586_h;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumBarnacleTypeEarly newFacing = EnumBarnacleTypeEarly.BARNACLE_DOWN_ONE;
        switch (facing) {
            case DOWN: {
                newFacing = EnumBarnacleTypeEarly.BARNACLE_UP_ONE;
                break;
            }
            case UP: {
                newFacing = EnumBarnacleTypeEarly.BARNACLE_DOWN_ONE;
                break;
            }
            case SOUTH: {
                newFacing = EnumBarnacleTypeEarly.BARNACLE_NORTH_ONE;
                break;
            }
            case EAST: {
                newFacing = EnumBarnacleTypeEarly.BARNACLE_WEST_ONE;
                break;
            }
            case NORTH: {
                newFacing = EnumBarnacleTypeEarly.BARNACLE_SOUTH_ONE;
                break;
            }
            case WEST: {
                newFacing = EnumBarnacleTypeEarly.BARNACLE_EAST_ONE;
            }
        }
        return this.func_176223_P().func_177226_a(BARNACLE_TYPE_EARLY, (Comparable)((Object)newFacing));
    }

    public static EnumBarnacleTypeEarly getTypeFromFacing(EnumFacing facing) {
        switch (facing) {
            case UP: {
                return EnumBarnacleTypeEarly.BARNACLE_UP_ONE;
            }
            case DOWN: {
                return EnumBarnacleTypeEarly.BARNACLE_DOWN_ONE;
            }
            case NORTH: {
                return EnumBarnacleTypeEarly.BARNACLE_NORTH_ONE;
            }
            case WEST: {
                return EnumBarnacleTypeEarly.BARNACLE_WEST_ONE;
            }
            case SOUTH: {
                return EnumBarnacleTypeEarly.BARNACLE_SOUTH_ONE;
            }
            case EAST: {
                return EnumBarnacleTypeEarly.BARNACLE_EAST_ONE;
            }
        }
        return EnumBarnacleTypeEarly.BARNACLE_UP_ONE;
    }

    public EnumFacing getFacingForAttachedSide(EnumBarnacleTypeEarly type) {
        switch (type) {
            case BARNACLE_UP_ONE: 
            case BARNACLE_UP_TWO: {
                return EnumFacing.UP;
            }
            case BARNACLE_DOWN_ONE: 
            case BARNACLE_DOWN_TWO: {
                return EnumFacing.DOWN;
            }
            case BARNACLE_NORTH_ONE: 
            case BARNACLE_NORTH_TWO: {
                return EnumFacing.NORTH;
            }
            case BARNACLE_WEST_ONE: 
            case BARNACLE_WEST_TWO: {
                return EnumFacing.WEST;
            }
            case BARNACLE_SOUTH_ONE: 
            case BARNACLE_SOUTH_TWO: {
                return EnumFacing.SOUTH;
            }
            case BARNACLE_EAST_ONE: 
            case BARNACLE_EAST_TWO: {
                return EnumFacing.EAST;
            }
        }
        return EnumFacing.DOWN;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        return !(stack.func_77973_b() instanceof ItemBucket) || !(stack.func_77973_b() instanceof ItemBLBucket);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        boolean flag = false;
        if (world.isSideSolid(pos.func_177972_a(this.getFacingForAttachedSide((EnumBarnacleTypeEarly)((Object)state.func_177229_b(BARNACLE_TYPE_EARLY)))), this.getFacingForAttachedSide((EnumBarnacleTypeEarly)((Object)state.func_177229_b(BARNACLE_TYPE_EARLY))).func_176734_d())) {
            flag = true;
        }
        if (!flag) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
        super.func_189540_a(state, world, pos, block, fromPos);
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public int func_149745_a(Random rand) {
        return 1;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{LEVEL}).add(new IProperty[]{BARNACLE_TYPE_EARLY}).add((IUnlistedProperty[])FLUID_RENDER_PROPS.toArray((Object[])new IUnlistedProperty[0])).build();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(BARNACLE_TYPE_EARLY, (Comparable)((Object)EnumBarnacleTypeEarly.byMetadata(meta)));
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K && this.checkForLog(world, pos, state)) {
            world.func_175684_a(pos, (Block)this, 100);
        }
    }

    private boolean checkForLog(World world, BlockPos pos, IBlockState state) {
        IBlockState offsetState = world.func_180495_p(pos.func_177972_a(this.getFacingForAttachedSide((EnumBarnacleTypeEarly)((Object)state.func_177229_b(BARNACLE_TYPE_EARLY)))));
        Block offsetBlock = offsetState.func_177230_c();
        return offsetBlock instanceof BlockHearthgroveLog && (Boolean)offsetState.func_177229_b((IProperty)BlockHearthgroveLog.TARRED) != false;
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        if (world.field_72995_K) {
            return;
        }
        if (this.checkForLog(world, pos, state)) {
            this.func_180645_a(world, pos, state, random);
            world.func_175684_a(pos, (Block)this, 100);
        }
    }

    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random random) {
        if (world.field_72995_K) {
            return;
        }
        if (world.field_73012_v.nextInt(4) == 0) {
            IBlockState LATE_BARNACLE_BLOCK = BlockRegistry.BARNACLE_3_4.func_176223_P();
            EnumBarnacleTypeEarly stage = (EnumBarnacleTypeEarly)((Object)state.func_177229_b(BARNACLE_TYPE_EARLY));
            switch (stage) {
                case BARNACLE_DOWN_ONE: {
                    world.func_180501_a(pos, this.func_176223_P().func_177226_a(BARNACLE_TYPE_EARLY, (Comparable)((Object)EnumBarnacleTypeEarly.BARNACLE_DOWN_TWO)), 2);
                    break;
                }
                case BARNACLE_DOWN_TWO: {
                    world.func_180501_a(pos, LATE_BARNACLE_BLOCK.func_177226_a(BlockBarnacle_3_4.BARNACLE_TYPE_LATE, (Comparable)((Object)BlockBarnacle_3_4.EnumBarnacleTypeLate.BARNACLE_DOWN_THREE)), 2);
                    break;
                }
                case BARNACLE_UP_ONE: {
                    world.func_180501_a(pos, this.func_176223_P().func_177226_a(BARNACLE_TYPE_EARLY, (Comparable)((Object)EnumBarnacleTypeEarly.BARNACLE_UP_TWO)), 2);
                    break;
                }
                case BARNACLE_UP_TWO: {
                    world.func_180501_a(pos, LATE_BARNACLE_BLOCK.func_177226_a(BlockBarnacle_3_4.BARNACLE_TYPE_LATE, (Comparable)((Object)BlockBarnacle_3_4.EnumBarnacleTypeLate.BARNACLE_UP_THREE)), 2);
                    break;
                }
                case BARNACLE_EAST_ONE: {
                    world.func_180501_a(pos, this.func_176223_P().func_177226_a(BARNACLE_TYPE_EARLY, (Comparable)((Object)EnumBarnacleTypeEarly.BARNACLE_EAST_TWO)), 2);
                    break;
                }
                case BARNACLE_EAST_TWO: {
                    world.func_175656_a(pos, LATE_BARNACLE_BLOCK.func_177226_a(BlockBarnacle_3_4.BARNACLE_TYPE_LATE, (Comparable)((Object)BlockBarnacle_3_4.EnumBarnacleTypeLate.BARNACLE_EAST_THREE)));
                    break;
                }
                case BARNACLE_NORTH_ONE: {
                    world.func_180501_a(pos, this.func_176223_P().func_177226_a(BARNACLE_TYPE_EARLY, (Comparable)((Object)EnumBarnacleTypeEarly.BARNACLE_NORTH_TWO)), 2);
                    break;
                }
                case BARNACLE_NORTH_TWO: {
                    world.func_175656_a(pos, LATE_BARNACLE_BLOCK.func_177226_a(BlockBarnacle_3_4.BARNACLE_TYPE_LATE, (Comparable)((Object)BlockBarnacle_3_4.EnumBarnacleTypeLate.BARNACLE_NORTH_THREE)));
                    break;
                }
                case BARNACLE_SOUTH_ONE: {
                    world.func_180501_a(pos, this.func_176223_P().func_177226_a(BARNACLE_TYPE_EARLY, (Comparable)((Object)EnumBarnacleTypeEarly.BARNACLE_SOUTH_TWO)), 2);
                    break;
                }
                case BARNACLE_SOUTH_TWO: {
                    world.func_175656_a(pos, LATE_BARNACLE_BLOCK.func_177226_a(BlockBarnacle_3_4.BARNACLE_TYPE_LATE, (Comparable)((Object)BlockBarnacle_3_4.EnumBarnacleTypeLate.BARNACLE_SOUTH_THREE)));
                    break;
                }
                case BARNACLE_WEST_ONE: {
                    world.func_180501_a(pos, this.func_176223_P().func_177226_a(BARNACLE_TYPE_EARLY, (Comparable)((Object)EnumBarnacleTypeEarly.BARNACLE_WEST_TWO)), 2);
                    break;
                }
                case BARNACLE_WEST_TWO: {
                    world.func_175656_a(pos, LATE_BARNACLE_BLOCK.func_177226_a(BlockBarnacle_3_4.BARNACLE_TYPE_LATE, (Comparable)((Object)BlockBarnacle_3_4.EnumBarnacleTypeLate.BARNACLE_WEST_THREE)));
                    break;
                }
            }
        }
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumBarnacleTypeEarly)((Object)state.func_177229_b(BARNACLE_TYPE_EARLY))).getMetadata();
    }

    @Override
    public ItemBlock getItemBlock() {
        return new ItemBlockBarnacle((Block)this);
    }

    public static enum EnumBarnacleTypeEarly implements IStringSerializable
    {
        BARNACLE_DOWN_ONE,
        BARNACLE_UP_ONE,
        BARNACLE_NORTH_ONE,
        BARNACLE_SOUTH_ONE,
        BARNACLE_WEST_ONE,
        BARNACLE_EAST_ONE,
        BARNACLE_DOWN_TWO,
        BARNACLE_UP_TWO,
        BARNACLE_NORTH_TWO,
        BARNACLE_SOUTH_TWO,
        BARNACLE_WEST_TWO,
        BARNACLE_EAST_TWO;

        private final String name = this.name().toLowerCase(Locale.ENGLISH);

        public int getMetadata() {
            return this.ordinal();
        }

        public String toString() {
            return this.name;
        }

        public static EnumBarnacleTypeEarly byMetadata(int metadata) {
            if (metadata < 0 || metadata >= EnumBarnacleTypeEarly.values().length) {
                metadata = 0;
            }
            return EnumBarnacleTypeEarly.values()[metadata];
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

