/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.container;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.environment.IEnvironmentEvent;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.tile.TileEntityWindChime;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;

public class BlockWindChime
extends BlockContainer {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.15, 0.0, 0.15, 0.85, 1.0, 0.85);

    public BlockWindChime() {
        super(Material.field_151575_d);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.func_149711_c(0.5f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityWindChime();
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkAndDropBlock(worldIn, pos, state);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && (worldIn.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN) || worldIn.func_180495_p(pos.func_177984_a()).func_193401_d((IBlockAccess)worldIn, pos.func_177984_a(), EnumFacing.DOWN) != BlockFaceShape.UNDEFINED);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        this.checkAndDropBlock(worldIn, pos, state);
    }

    protected void checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN) && worldIn.func_180495_p(pos.func_177984_a()).func_193401_d((IBlockAccess)worldIn, pos.func_177984_a(), EnumFacing.DOWN) == BlockFaceShape.UNDEFINED) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.MAIN_HAND && playerIn.func_70093_af()) {
            TileEntity tile;
            if (!worldIn.field_72995_K && (tile = worldIn.func_175625_s(pos)) instanceof TileEntityWindChime) {
                TileEntityWindChime chime = (TileEntityWindChime)tile;
                ResourceLocation newAttunement = chime.cycleAttunedEvent();
                IEnvironmentEvent attunedEvent = newAttunement != null ? BetweenlandsWorldStorage.forWorld(worldIn).getEnvironmentEventRegistry().getEvent(newAttunement) : null;
                if (newAttunement != null) {
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("chat.wind_chime.changed_attunement", new Object[]{new TextComponentTranslation(attunedEvent.getLocalizationEventName(), new Object[0])}), true);
                } else {
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("chat.wind_chime.removed_attunement", new Object[0]), true);
                }
            }
            playerIn.func_184609_a(hand);
            return true;
        }
        return false;
    }
}

