/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.container;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.handler.ItemTooltipHandler;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.block.BasicBlock;
import thebetweenlands.common.registries.AdvancementCriterionRegistry;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.tile.TileEntitySiltGlassJar;

public class BlockSiltGlassJar
extends BasicBlock
implements ITileEntityProvider,
BlockRegistry.ICustomItemBlock {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125);

    public BlockSiltGlassJar() {
        super(Material.field_151592_s);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149711_c(1.0f);
        this.func_149752_b(5.0f);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntitySiltGlassJar();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!world.field_72995_K && stack.func_77942_o() && stack.func_77978_p().func_74764_b("Items") && world.func_175625_s(pos) instanceof TileEntitySiltGlassJar) {
            TileEntitySiltGlassJar tile = (TileEntitySiltGlassJar)world.func_175625_s(pos);
            NBTTagList tags = stack.func_77978_p().func_150295_c("Items", 10);
            tile.inventory = NonNullList.func_191197_a((int)tile.func_70302_i_(), (Object)ItemStack.field_190927_a);
            for (int i = 0; i < tags.func_74745_c(); ++i) {
                NBTTagCompound data = tags.func_150305_b(i);
                int j = data.func_74771_c("Slot") & 0xFF;
                if (j < 0 || j >= tile.inventory.size()) continue;
                tile.inventory.set(j, (Object)new ItemStack(data));
            }
            tile.updateItemCount();
        }
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (!world.field_72995_K && world.func_175625_s(pos) instanceof TileEntitySiltGlassJar) {
            TileEntitySiltGlassJar tile = (TileEntitySiltGlassJar)world.func_175625_s(pos);
            if (!player.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == ItemRegistry.WEEDWOOD_FISHING_ROD) {
                ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
                if (stack.func_77952_i() == stack.func_77958_k()) {
                    return;
                }
                for (int i = 0; i < tile.getItems().size(); ++i) {
                    if (((ItemStack)tile.getItems().get(i)).func_190926_b() || stack.func_77973_b() != ItemRegistry.WEEDWOOD_FISHING_ROD || !stack.func_77942_o()) continue;
                    if (stack.func_77978_p().func_74767_n("baited")) {
                        return;
                    }
                    stack.func_77978_p().func_74757_a("baited", true);
                    tile.getItems().set(i, (Object)ItemStack.field_190927_a);
                    tile.updateItemCount();
                    if (player instanceof EntityPlayerMP) {
                        AdvancementCriterionRegistry.USED_ROD_ON_JAR.trigger((EntityPlayerMP)player);
                    }
                    return;
                }
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.func_175625_s(pos) instanceof TileEntitySiltGlassJar) {
            TileEntitySiltGlassJar tile = (TileEntitySiltGlassJar)world.func_175625_s(pos);
            if (!(player.func_184586_b(hand).func_190926_b() || player.func_184586_b(hand).func_77973_b() != ItemRegistry.TINY_SLUDGE_WORM && player.func_184586_b(hand).func_77973_b() != ItemRegistry.TINY_SLUDGE_WORM_HELPER)) {
                if (!world.field_72995_K) {
                    for (int i = 0; i < tile.getItems().size(); ++i) {
                        ItemStack stack;
                        if (!((ItemStack)tile.getItems().get(i)).func_190926_b() || (stack = player.func_184586_b(hand).func_77979_a(1)).func_190926_b()) continue;
                        if (player.func_184812_l_()) {
                            player.func_184611_a(hand, stack.func_77946_l());
                        }
                        tile.getItems().set(i, (Object)stack);
                        tile.updateItemCount();
                        break;
                    }
                }
                return true;
            }
            if (player.func_70093_af() && hand == EnumHand.MAIN_HAND) {
                for (int i = tile.getItems().size() - 1; i >= 0; --i) {
                    if (((ItemStack)tile.getItems().get(i)).func_190926_b()) continue;
                    if (!world.field_72995_K) {
                        ItemStack extracted = (ItemStack)tile.getItems().get(i);
                        EntityItem item = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, extracted);
                        item.field_70179_y = 0.0;
                        item.field_70181_x = 0.0;
                        item.field_70159_w = 0.0;
                        world.func_72838_d((Entity)item);
                        tile.getItems().set(i, (Object)ItemStack.field_190927_a);
                        tile.updateItemCount();
                    }
                    player.func_184609_a(hand);
                    return true;
                }
            }
        }
        return false;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d && world.func_175625_s(pos) instanceof TileEntitySiltGlassJar) {
            TileEntitySiltGlassJar tile = (TileEntitySiltGlassJar)world.func_175625_s(pos);
            NBTTagCompound nbt = new NBTTagCompound();
            tile.func_189515_b(nbt);
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)this), 1, 0);
            if (tile.func_70302_i_() > 0) {
                stack.func_77982_d(nbt);
            }
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
            world.func_175713_t(pos);
        }
    }

    @Override
    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    @Override
    public ItemBlock getItemBlock() {
        ItemBlock item = new ItemBlock(BlockRegistry.SILT_GLASS_JAR){

            @SideOnly(value=Side.CLIENT)
            public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
                list.addAll(ItemTooltipHandler.splitTooltip(I18n.func_135052_a((String)"tooltip.bl.silt_glass_jar_item", (Object[])new Object[0]), 0));
                if (stack.func_77942_o() && stack.func_77978_p().func_150295_c("Items", 10) != null) {
                    NBTTagList tags = stack.func_77978_p().func_150295_c("Items", 10);
                    LinkedHashMap<String, Integer> counts = new LinkedHashMap<String, Integer>();
                    for (int i = 0; i < tags.func_74745_c(); ++i) {
                        NBTTagCompound data = tags.func_150305_b(i);
                        int j = data.func_74771_c("Slot") & 0xFF;
                        if (i < 0 || i > 7) continue;
                        ItemStack content = new ItemStack(data);
                        String name = content.func_82833_r();
                        if (!counts.containsKey(name)) {
                            counts.put(name, content.func_190916_E());
                            continue;
                        }
                        counts.put(name, (Integer)counts.get(name) + content.func_190916_E());
                    }
                    int j = 0;
                    for (Map.Entry entry : counts.entrySet()) {
                        list.add(I18n.func_135052_a((String)"tooltip.bl.silt_glass_jar_content", (Object[])new Object[]{++j, entry.getKey(), entry.getValue()}));
                    }
                }
            }
        };
        return item;
    }
}

