/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.container;

import javax.annotation.Nullable;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.tile.TileEntityGrubHub;

public class BlockGrubHub
extends BlockContainer {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375);

    public BlockGrubHub() {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityGrubHub();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        IFluidHandler fluidHandler;
        if (world.func_175625_s(pos) instanceof TileEntityGrubHub) {
            TileEntityGrubHub tile = (TileEntityGrubHub)world.func_175625_s(pos);
            if (FluidUtil.getFluidHandler((ItemStack)player.func_184586_b(hand)) == null && hand == EnumHand.MAIN_HAND && !tile.func_70301_a(0).func_190926_b()) {
                if (!world.field_72995_K) {
                    ItemStack extracted = tile.func_70301_a(0).func_77946_l();
                    if (!player.func_70093_af()) {
                        extracted.func_190920_e(1);
                    }
                    EntityItem item = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, extracted);
                    item.field_70179_y = 0.0;
                    item.field_70181_x = 0.0;
                    item.field_70159_w = 0.0;
                    world.func_72838_d((Entity)item);
                    if (!player.func_70093_af()) {
                        tile.func_70301_a(0).func_190918_g(1);
                    } else {
                        tile.func_70299_a(0, ItemStack.field_190927_a);
                    }
                    tile.markForUpdate();
                }
                player.func_184609_a(hand);
                return true;
            }
        }
        if ((fluidHandler = this.getFluidHandler((IBlockAccess)world, pos)) != null) {
            FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (World)world, (BlockPos)pos, (EnumFacing)side);
            return FluidUtil.getFluidHandler((ItemStack)player.func_184586_b(hand)) != null;
        }
        return false;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityGrubHub tile = (TileEntityGrubHub)world.func_175625_s(pos);
        if (tile != null) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)tile);
            world.func_175713_t(pos);
        }
        super.func_180663_b(world, pos, state);
    }

    @Nullable
    private IFluidHandler getFluidHandler(IBlockAccess world, BlockPos pos) {
        TileEntityGrubHub tileentity = (TileEntityGrubHub)world.func_175625_s(pos);
        return (IFluidHandler)tileentity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
    }
}

