/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.container;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.handler.ItemTooltipHandler;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.block.container.BlockCrabPotFilter;
import thebetweenlands.common.block.terrain.BlockSwampWater;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.FluidRegistry;
import thebetweenlands.common.tile.TileEntityCrabPot;
import thebetweenlands.util.AdvancedStateMap;

public class BlockCrabPot
extends BlockSwampWater
implements ITileEntityProvider,
BlockRegistry.IStateMappedBlock {
    public BlockCrabPot() {
        this(FluidRegistry.SWAMP_WATER, Material.field_151586_h);
        this.func_149711_c(0.5f);
    }

    public BlockCrabPot(Fluid fluid, Material materialIn) {
        super(fluid, materialIn);
        this.func_149711_c(0.5f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.setUnderwaterBlock(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setStateMapper(AdvancedStateMap.Builder builder) {
        super.setStateMapper(builder);
        builder.ignore(new IProperty[]{LEVEL});
    }

    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.addAll(ItemTooltipHandler.splitTooltip(I18n.func_74837_a((String)"tooltip.bl.crab_pot_item", (Object[])new Object[0]), 0));
        super.func_190948_a(stack, player, tooltip, advanced);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!world.field_72995_K && world.func_175625_s(pos) instanceof TileEntityCrabPot) {
            TileEntityCrabPot tile = (TileEntityCrabPot)world.func_175625_s(pos);
            tile.setRotation(placer.func_174811_aO().func_176735_f().func_176736_b());
            if (placer instanceof EntityPlayer) {
                tile.setPlacer((EntityPlayer)placer);
            }
            tile.markForUpdate();
        }
    }

    @Override
    public boolean func_176196_c(World world, BlockPos pos) {
        return super.func_176196_c(world, pos) && !(world.func_180495_p(pos).func_177230_c() instanceof BlockCrabPotFilter);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityCrabPot();
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (!world.field_72995_K) {
            // empty if block
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (!world.field_72995_K && world.func_175625_s(pos) instanceof TileEntityCrabPot) {
            ItemStack extracted;
            TileEntityCrabPot tile = (TileEntityCrabPot)world.func_175625_s(pos);
            if (!player.func_184586_b(hand).func_190926_b() && tile.func_70301_a(0).func_190926_b()) {
                ItemStack stack = player.func_184586_b(hand).func_77979_a(1);
                if (!stack.func_190926_b()) {
                    tile.func_70299_a(0, stack);
                    tile.markForUpdate();
                    return true;
                }
            } else if (!tile.func_70301_a(0).func_190926_b() && !(extracted = tile.func_70301_a(0)).func_190926_b()) {
                EntityItem item = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, extracted);
                item.field_70179_y = 0.0;
                item.field_70181_x = 0.0;
                item.field_70159_w = 0.0;
                world.func_72838_d((Entity)item);
                tile.func_70299_a(0, ItemStack.field_190927_a);
                tile.markForUpdate();
                return true;
            }
        }
        return false;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityCrabPot tile = (TileEntityCrabPot)world.func_175625_s(pos);
        if (tile != null) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)tile);
        }
        super.func_180663_b(world, pos, state);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        TileEntityCrabPot tile = (TileEntityCrabPot)world.func_175625_s(pos);
        if (tile != null && !tile.hasBaitItem() && !tile.func_70301_a(0).func_190926_b() && tile.getEntity() != null) {
            if (rand.nextInt(3) == 0) {
                world.func_175688_a(EnumParticleTypes.WATER_BUBBLE, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5 + (double)((float)tile.fallCounter * 0.03125f), (double)pos.func_177952_p() + 0.5, 0.0, 0.3, 0.0, new int[0]);
            }
            if (tile.fallCounter >= 1 && tile.fallCounter < 16) {
                for (int count = 0; count < 10; ++count) {
                    BLParticles.ITEM_BREAKING.spawn(world, (double)pos.func_177958_n() + 0.5 + (world.field_73012_v.nextDouble() - 0.5), (double)pos.func_177956_o() + 0.5 + world.field_73012_v.nextDouble(), (double)pos.func_177952_p() + 0.5 + (world.field_73012_v.nextDouble() - 0.5), (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withData(ItemMisc.EnumItemMisc.ANADIA_REMAINS.create(1)));
                }
            }
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.TRANSLUCENT || layer == BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    @Override
    public ItemBlock getItemBlock() {
        return BlockRegistry.ICustomItemBlock.getDefaultItemBlock((Block)this);
    }
}

