/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.advancments;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;

public class BlockPredicate {
    public static final BlockPredicate ANY = new BlockPredicate();
    private final Block block;
    private final Map<IProperty<?>, Object> map;

    public BlockPredicate() {
        this.block = null;
        this.map = null;
    }

    public BlockPredicate(Block block, Map<IProperty<?>, Object> map) {
        this.block = block;
        this.map = map;
    }

    public boolean test(IBlockState state) {
        if (this.block != null && state.func_177230_c() != this.block) {
            return false;
        }
        if (this.map != null) {
            for (Map.Entry<IProperty<?>, Object> entry : this.map.entrySet()) {
                if (state.func_177229_b(entry.getKey()) == entry.getValue()) continue;
                return false;
            }
        }
        return true;
    }

    public static BlockPredicate deserialize(@Nullable JsonElement element) {
        if (element != null && !element.isJsonNull()) {
            JsonObject json = JsonUtils.func_151210_l((JsonElement)element, (String)"block");
            Block block = null;
            HashMap map = null;
            if (json.has("block")) {
                ResourceLocation resourcelocation = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)json, (String)"block"));
                if (!Block.field_149771_c.func_148741_d((Object)resourcelocation)) {
                    throw new JsonSyntaxException("Unknown block type '" + resourcelocation + "'");
                }
                block = (Block)Block.field_149771_c.func_82594_a((Object)resourcelocation);
            }
            if (json.has("state")) {
                if (block == null) {
                    throw new JsonSyntaxException("Can't define block state without a specific block type");
                }
                BlockStateContainer blockstatecontainer = block.func_176194_O();
                for (Map.Entry entry : JsonUtils.func_152754_s((JsonObject)json, (String)"state").entrySet()) {
                    IProperty iproperty = blockstatecontainer.func_185920_a((String)entry.getKey());
                    if (iproperty == null) {
                        throw new JsonSyntaxException("Unknown block state property '" + (String)entry.getKey() + "' for block '" + Block.field_149771_c.func_177774_c((Object)block) + "'");
                    }
                    String s = JsonUtils.func_151206_a((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()));
                    Optional optional = iproperty.func_185929_b(s);
                    if (!optional.isPresent()) {
                        throw new JsonSyntaxException("Invalid block state value '" + s + "' for property '" + (String)entry.getKey() + "' on block '" + Block.field_149771_c.func_177774_c((Object)block) + "'");
                    }
                    if (map == null) {
                        map = Maps.newHashMap();
                    }
                    map.put(iproperty, optional.get());
                }
            }
            return new BlockPredicate(block, map);
        }
        return ANY;
    }

    public static BlockPredicate[] deserializeArray(@Nullable JsonElement element) {
        if (element != null && !element.isJsonNull()) {
            JsonArray jsonarray = JsonUtils.func_151207_m((JsonElement)element, (String)"blocks");
            BlockPredicate[] aitempredicate = new BlockPredicate[jsonarray.size()];
            for (int i = 0; i < aitempredicate.length; ++i) {
                aitempredicate[i] = BlockPredicate.deserialize(jsonarray.get(i));
            }
            return aitempredicate;
        }
        return new BlockPredicate[0];
    }
}

