/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.tile;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import thebetweenlands.client.render.model.tile.ModelSunkenLootPot1;
import thebetweenlands.client.render.model.tile.ModelSunkenLootPot2;
import thebetweenlands.client.render.model.tile.ModelSunkenLootPot3;
import thebetweenlands.common.block.container.BlockLootPot;
import thebetweenlands.common.block.container.BlockTarLootPot;
import thebetweenlands.common.tile.TileEntityLootPot;
import thebetweenlands.util.StatePropertyHelper;

public abstract class RenderTarLootPot
extends TileEntitySpecialRenderer<TileEntityLootPot> {
    private static final ModelSunkenLootPot1 LOOT_POT = new ModelSunkenLootPot1();
    private static final ModelSunkenLootPot2 LOOT_POT_2 = new ModelSunkenLootPot2();
    private static final ModelSunkenLootPot3 LOOT_POT_3 = new ModelSunkenLootPot3();
    private static final ResourceLocation TEXTURE_1 = new ResourceLocation("thebetweenlands:textures/tiles/tar_loot_pot_1.png");
    private static final ResourceLocation TEXTURE_2 = new ResourceLocation("thebetweenlands:textures/tiles/tar_loot_pot_2.png");
    private static final ResourceLocation TEXTURE_3 = new ResourceLocation("thebetweenlands:textures/tiles/tar_loot_pot_3.png");

    public abstract BlockLootPot.EnumLootPot getType();

    public void render(TileEntityLootPot te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        BlockLootPot.EnumLootPot type = this.getType();
        EnumFacing rotation = StatePropertyHelper.getStatePropertySafely(te, BlockTarLootPot.class, BlockLootPot.FACING, EnumFacing.NORTH);
        boolean offset = false;
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        switch (type) {
            default: {
                this.func_147499_a(TEXTURE_1);
                break;
            }
            case POT_2: {
                this.func_147499_a(TEXTURE_2);
                break;
            }
            case POT_3: {
                this.func_147499_a(TEXTURE_3);
            }
        }
        switch (rotation) {
            default: {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
                GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
                GlStateManager.func_179114_b((float)((float)offset), (float)0.0f, (float)1.0f, (float)0.0f);
                this.renderType(type);
                GlStateManager.func_179121_F();
                break;
            }
            case EAST: {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
                GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
                GlStateManager.func_179114_b((float)((float)offset + 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                this.renderType(type);
                GlStateManager.func_179121_F();
                break;
            }
            case SOUTH: {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
                GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
                GlStateManager.func_179114_b((float)((float)offset + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                this.renderType(type);
                GlStateManager.func_179121_F();
                break;
            }
            case WEST: {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
                GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
                GlStateManager.func_179114_b((float)((float)offset + 270.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                this.renderType(type);
                GlStateManager.func_179121_F();
            }
        }
    }

    private void renderType(BlockLootPot.EnumLootPot type) {
        switch (type) {
            case POT_1: {
                LOOT_POT.render();
                break;
            }
            case POT_2: {
                LOOT_POT_2.render();
                break;
            }
            case POT_3: {
                LOOT_POT_3.render();
            }
        }
    }
}

