/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.tile;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.block.container.BlockSteepingPot;
import thebetweenlands.common.registries.FluidRegistry;
import thebetweenlands.common.tile.TileEntitySteepingPot;
import thebetweenlands.util.StatePropertyHelper;

@SideOnly(value=Side.CLIENT)
public class RenderSteepingPot
extends TileEntitySpecialRenderer<TileEntitySteepingPot> {
    public void render(TileEntitySteepingPot tile, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        if (tile == null || !tile.func_145830_o()) {
            return;
        }
        GlStateManager.func_179094_E();
        if (StatePropertyHelper.getStatePropertySafely(tile, BlockSteepingPot.class, BlockSteepingPot.HANGING, false, true, false).booleanValue()) {
            GlStateManager.func_179137_b((double)0.0, (double)-0.247, (double)0.0);
        }
        float fluidLevel = tile.tank.getFluidAmount();
        float height = 0.0625f;
        if (fluidLevel > 0.0f) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            FluidStack fluidStack = tile.tank.getFluid();
            height = 0.375f / (float)tile.tank.getCapacity() * (float)tile.tank.getFluidAmount();
            TextureAtlasSprite fluidStillSprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluidStack.getFluid().getStill().toString());
            if (tile.getHeatProgress() > 0 && tile.tank.getFluid().getFluid() == FluidRegistry.DYE_FLUID || tile.tank.getFluid().getFluid() == FluidRegistry.DRINKABLE_BREW) {
                fluidStillSprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluidStack.getFluid().getFlowing().toString());
            }
            int fluidColor = fluidStack.getFluid().getColor(fluidStack);
            int fluidColorTemp = tile.tempFluidColour;
            float fade = tile.getHeatProgress() > 50 && tile.hasBundle() ? (float)(-50 + tile.getHeatProgress()) * 0.025f : 0.0f;
            GlStateManager.func_179140_f();
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.func_147499_a(TextureMap.field_110575_b);
            GlStateManager.func_179137_b((double)x, (double)(y + 0.25), (double)z);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            float yMin = 0.0f;
            float xMax = 1.5f;
            float zMax = 1.5f;
            float xMin = 0.5f;
            float zMin = 0.5f;
            yMin = 0.0f;
            this.setGLColorFromInt(fluidColor, 1.0f - fade);
            this.renderCuboid(buffer, xMax, xMin, yMin, height, zMin, zMax, fluidStillSprite);
            tessellator.func_78381_a();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
            GlStateManager.func_179145_e();
            GlStateManager.func_179140_f();
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.func_147499_a(TextureMap.field_110575_b);
            GlStateManager.func_179137_b((double)x, (double)(y + 0.25), (double)z);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            this.setGLColorFromInt(fluidColorTemp, 0.0f + fade);
            this.renderCuboid(buffer, xMax, xMin, yMin, height + 0.01f, zMin, zMax, fluidStillSprite);
            tessellator.func_78381_a();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
            GlStateManager.func_179145_e();
        }
        if (!tile.func_70301_a(0).func_190926_b()) {
            int itemBob = tile.itemBob;
            int prevItemBob = tile.prevItemBob;
            int stirProgress = tile.itemRotate;
            int prevStirProgress = tile.prevItemRotate;
            float stirTicks = (float)stirProgress + (float)(stirProgress - prevStirProgress) * partialTick;
            float bobTicks = (float)itemBob + (float)(itemBob - prevItemBob) * partialTick;
            double itemY = y + 0.25 + (double)height;
            Random rand = new Random();
            rand.setSeed(tile.func_174877_v().func_177958_n() + tile.func_174877_v().func_177956_o() + tile.func_174877_v().func_177952_p());
            float randRot = rand.nextFloat() * 360.0f;
            double xo = -0.1 + (double)rand.nextFloat() * 0.2;
            double zo = -0.1 + (double)rand.nextFloat() * 0.2;
            double rot = stirTicks < 180.0f && fluidLevel > 0.0f ? (double)stirTicks * 2.0 + 90.0 + (double)randRot : 90.0 + (double)randRot;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(x + 0.5), (double)0.0, (double)(z + 0.5));
            GlStateManager.func_179114_b((float)((float)(-rot)), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)xo, (double)0.0, (double)zo);
            this.renderItemInSlot(tile, 0, 0.0, itemY, 0.0, fluidLevel > 0.0f ? (double)bobTicks : 0.0, -rot);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }

    private void renderItemInSlot(TileEntitySteepingPot tile, int slotIndex, double x, double y, double z, double itemBob, double rotation) {
        if (!tile.func_70301_a(slotIndex).func_190926_b()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_179139_a((double)0.4, (double)0.4, (double)0.4);
            GlStateManager.func_179137_b((double)0.0, (double)(itemBob * (double)0.0025f), (double)0.0);
            GlStateManager.func_179114_b((float)((float)rotation), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(tile.getHeatProgress() < 20 ? 0.0f : (float)itemBob * 0.2f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(tile.getHeatProgress() < 40 ? 0.0f : (float)itemBob * 0.2f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(tile.getHeatProgress() < 60 ? 0.0f : (float)itemBob * 0.4f), (float)0.0f, (float)-1.0f, (float)0.0f);
            Minecraft.func_71410_x().func_175599_af().func_181564_a(tile.func_70301_a(slotIndex), ItemCameraTransforms.TransformType.FIXED);
            GlStateManager.func_179121_F();
        }
    }

    private void setGLColorFromInt(int color, float alpha) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
    }

    private void renderCuboid(BufferBuilder buffer, float xMax, float xMin, float yMin, float height, float zMin, float zMax, TextureAtlasSprite textureAtlasSprite) {
        double uMin = textureAtlasSprite.func_94209_e();
        double uMax = textureAtlasSprite.func_94212_f();
        double vMin = textureAtlasSprite.func_94206_g();
        double vMax = textureAtlasSprite.func_94210_h();
        this.addVertexWithUV(buffer, xMax, height, zMax, uMax, vMin);
        this.addVertexWithUV(buffer, xMax, height, zMin, uMin, vMin);
        this.addVertexWithUV(buffer, xMin, height, zMin, uMin, vMax);
        this.addVertexWithUV(buffer, xMin, height, zMax, uMax, vMax);
    }

    private void addVertexWithUV(BufferBuilder buffer, float x, float y, float z, double u, double v) {
        buffer.func_181662_b((double)(x / 2.0f), (double)y, (double)(z / 2.0f)).func_187315_a(u, v).func_181675_d();
    }

    private void addVertexWithColor(BufferBuilder buffer, float x, float y, float z, float red, float green, float blue, float alpha) {
        buffer.func_181662_b((double)(x / 2.0f), (double)y, (double)(z / 2.0f)).func_181666_a(red, green, blue, alpha).func_181675_d();
    }
}

