/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.tile;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class RenderItemStackAsTileEntity
extends TileEntityItemStackRenderer {
    private TileEntitySpecialRenderer<?> renderer;
    private Int2ObjectMap<TileEntitySpecialRenderer<?>> map;

    public RenderItemStackAsTileEntity(Class<? extends TileEntity> te) {
        this.renderer = TileEntityRendererDispatcher.field_147556_a.func_147546_a(te);
        this.map = null;
        Preconditions.checkNotNull(this.renderer, (String)"TileEntity %s for ItemStack renderer does not have a renderer!", (Object)te.getName());
    }

    public RenderItemStackAsTileEntity(Map<Integer, Class<? extends TileEntity>> map) {
        this.renderer = null;
        for (Map.Entry<Integer, Class<? extends TileEntity>> entry : map.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    public RenderItemStackAsTileEntity() {
        this.renderer = null;
        this.map = null;
    }

    public RenderItemStackAsTileEntity(Consumer<RenderItemStackAsTileEntity> constructor) {
        constructor.accept(this);
    }

    public RenderItemStackAsTileEntity add(int meta, Class<? extends TileEntity> te) {
        if (this.map == null) {
            this.map = new Int2ObjectOpenHashMap();
        }
        TileEntitySpecialRenderer renderer = TileEntityRendererDispatcher.field_147556_a.func_147546_a(te);
        Preconditions.checkNotNull((Object)renderer, (String)"TileEntity %s for ItemStack renderer does not have a renderer!", (Object)te.getName());
        this.map.put(meta, (Object)renderer);
        return this;
    }

    public void func_192838_a(ItemStack stack, float partialTicks) {
        TileEntitySpecialRenderer renderer;
        if (this.renderer != null) {
            this.renderer.func_192841_a(null, 0.0, 0.0, 0.0, partialTicks, -1, 1.0f);
        } else if (this.map != null && (renderer = (TileEntitySpecialRenderer)this.map.get(stack.func_77960_j())) != null) {
            renderer.func_192841_a(null, 0.0, 0.0, 0.0, partialTicks, -1, 1.0f);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
    }
}

