/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.tile;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import thebetweenlands.api.aspect.IAspectType;
import thebetweenlands.client.render.model.tile.ModelGeckoCage;
import thebetweenlands.client.render.model.tile.ModelGeckoCorrupted;
import thebetweenlands.client.render.model.tile.ModelGeckoGreen;
import thebetweenlands.client.render.model.tile.ModelGeckoNormal;
import thebetweenlands.common.block.container.BlockGeckoCage;
import thebetweenlands.common.registries.AspectRegistry;
import thebetweenlands.common.tile.TileEntityGeckoCage;
import thebetweenlands.util.StatePropertyHelper;

public class RenderGeckoCage
extends TileEntitySpecialRenderer<TileEntityGeckoCage> {
    private static final ModelGeckoCage MODEL = new ModelGeckoCage();
    private static final ModelGeckoNormal MODEL_GECKO_NORMAL = new ModelGeckoNormal();
    private static final ModelGeckoCorrupted MODEL_GECKO_CORRUPTED = new ModelGeckoCorrupted();
    private static final ModelGeckoGreen MODEL_GECKO_GREEN = new ModelGeckoGreen();
    private static final ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands:textures/tiles/gecko_cage.png");
    private static final ResourceLocation GECKO_TEXTURE_NORMAL = new ResourceLocation("thebetweenlands:textures/entity/gecko.png");
    private static final ResourceLocation GECKO_TEXTURE_CORRUPTED = new ResourceLocation("thebetweenlands:textures/entity/gecko_corrupted.png");
    private static final ResourceLocation GECKO_TEXTURE_GREEN = new ResourceLocation("thebetweenlands:textures/entity/gecko_green.png");
    private static final ResourceLocation GECKO_TEXTURE_PALE = new ResourceLocation("thebetweenlands:textures/entity/gecko_pale.png");
    private static final ResourceLocation GECKO_TEXTURE_RED = new ResourceLocation("thebetweenlands:textures/entity/gecko_red.png");
    private static final ResourceLocation GECKO_TEXTURE_TAN = new ResourceLocation("thebetweenlands:textures/entity/gecko_tan.png");

    public void render(TileEntityGeckoCage cage, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (destroyStage < 0) {
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        EnumFacing facing = StatePropertyHelper.getStatePropertySafely(cage, BlockGeckoCage.class, BlockGeckoCage.FACING, EnumFacing.NORTH);
        GlStateManager.func_179114_b((float)facing.func_185119_l(), (float)0.0f, (float)1.0f, (float)0.0f);
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.func_179128_n((int)5888);
        } else {
            this.func_147499_a(TEXTURE);
        }
        GlStateManager.func_179129_p();
        MODEL.render();
        GlStateManager.func_179089_o();
        if (destroyStage >= 0) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (cage != null && cage.hasGecko()) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.3f, (float)0.0f);
            GlStateManager.func_179152_a((float)0.6f, (float)0.6f, (float)0.6f);
            float speed = 0.0f;
            float swing = 0.0f;
            IAspectType aspect = cage.getAspectType();
            if (aspect == AspectRegistry.FERGALAZ) {
                this.func_147499_a(GECKO_TEXTURE_TAN);
                MODEL_GECKO_NORMAL.render(cage.getTicks(), partialTicks, swing, speed);
            } else if (aspect == AspectRegistry.FIRNALAZ) {
                this.func_147499_a(GECKO_TEXTURE_RED);
                MODEL_GECKO_NORMAL.render(cage.getTicks(), partialTicks, swing, speed);
            } else if (aspect == AspectRegistry.GEOLIIRGAZ) {
                this.func_147499_a(GECKO_TEXTURE_PALE);
                MODEL_GECKO_NORMAL.render(cage.getTicks(), partialTicks, swing, speed);
            } else if (aspect == AspectRegistry.YIHINREN) {
                this.func_147499_a(GECKO_TEXTURE_GREEN);
                MODEL_GECKO_GREEN.render(cage.getTicks(), partialTicks, swing, speed);
            } else if (aspect == AspectRegistry.BYARIIS) {
                this.func_147499_a(GECKO_TEXTURE_CORRUPTED);
                MODEL_GECKO_CORRUPTED.render(cage.getTicks(), partialTicks);
            } else {
                this.func_147499_a(GECKO_TEXTURE_NORMAL);
                MODEL_GECKO_NORMAL.render(cage.getTicks(), partialTicks, swing, speed);
            }
        }
        GlStateManager.func_179121_F();
    }
}

