/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.particle.entity;

import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import thebetweenlands.client.handler.TextureStitchHandler;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.render.particle.ParticleTextureStitcher;
import thebetweenlands.client.render.particle.entity.ParticleBug;
import thebetweenlands.client.render.particle.entity.ParticleSwarm;
import thebetweenlands.client.render.sprite.TextureAnimation;

public class ParticleEmissiveBug
extends ParticleBug {
    private TextureAnimation emissiveAnimation = new TextureAnimation();

    protected ParticleEmissiveBug(World world, double x, double y, double z, double mx, double my, double mz, int maxAge, float speed, float jitter, float scale, boolean underwater) {
        super(world, x, y, z, mx, my, mz, maxAge, speed, jitter, scale, underwater);
    }

    @Override
    public void setStitchedSprites(TextureStitchHandler.Frame[][] frames) {
        if (this.animation != null && frames != null) {
            if (frames.length % 2 != 0) {
                throw new IllegalStateException("Emissive particle requires a multiple of two number of sprites");
            }
            int variant = this.field_187136_p.nextInt(frames.length / 2);
            this.animation.setFrames(frames[variant * 2]);
            this.emissiveAnimation.setFrames(frames[variant * 2 + 1]);
            ResourceLocation location = frames[variant * 2][0].getLocation();
            if (location instanceof ParticleSwarm.ResourceLocationWithScale) {
                this.field_70544_f *= ((ParticleSwarm.ResourceLocationWithScale)location).scale;
            }
            if (this.field_70547_e < 0) {
                this.field_70547_e = this.animation.getTotalDuration() - 1;
            }
            if (this.field_187119_C == null) {
                this.func_187117_a(frames[variant * 2][0].getSprite());
            }
        }
    }

    @Override
    public void func_189213_a() {
        super.func_189213_a();
        this.emissiveAnimation.update();
        if (this.field_70546_d > this.field_70547_e - 10) {
            this.field_82339_as = (float)(this.field_70547_e - this.field_70546_d) / 10.0f;
        }
    }

    public void func_180434_a(BufferBuilder buff, Entity entityIn, float partialTicks, float rx, float rz, float ryz, float rxy, float rxz) {
        if (this.field_70546_d < 10) {
            this.field_82339_as = (float)this.field_70546_d / 10.0f;
        }
        this.func_187117_a(this.animation.getCurrentSprite());
        super.func_180434_a(buff, entityIn, partialTicks, rx, rz, ryz, rxy, rxz);
        this.func_187117_a(this.emissiveAnimation.getCurrentSprite());
        super.func_180434_a(buff, entityIn, partialTicks, rx, rz, ryz, rxy, rxz);
    }

    public int func_189214_a(float partialTick) {
        if (this.field_187119_C == this.emissiveAnimation.getCurrentSprite()) {
            return 0xF000F0;
        }
        return super.func_189214_a(partialTick);
    }

    public static final class Swarm
    extends ParticleFactory<Swarm, ParticleEmissiveBug> {
        public Swarm() {
            super(ParticleEmissiveBug.class, ParticleTextureStitcher.create(ParticleEmissiveBug.class, new ParticleSwarm.ResourceLocationWithScale("thebetweenlands:particle/swarm_5", 2.0f), new ParticleSwarm.ResourceLocationWithScale("thebetweenlands:particle/swarm_5_emissive", 2.0f)).setSplitAnimations(true));
        }

        @Override
        public ParticleEmissiveBug createParticle(ParticleFactory.ImmutableParticleArgs args) {
            return new ParticleEmissiveBug(args.world, args.x, args.y, args.z, args.motionX, args.motionY, args.motionZ, args.data.getInt(0), args.data.getFloat(1), args.data.getFloat(2), args.scale, args.data.getBool(3));
        }

        @Override
        protected void setBaseArguments(ParticleFactory.ParticleArgs<?> args) {
            ((ParticleFactory.ParticleArgs)args.withScale(0.5f)).withData(40, Float.valueOf(0.01f), Float.valueOf(0.0025f), false);
        }
    }
}

