/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model.loader.extension;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import org.apache.commons.io.IOUtils;
import thebetweenlands.client.render.model.loader.extension.LoaderExtensionException;

public abstract class LoaderExtension {
    private IModel dummyModel = null;

    public abstract String getName();

    public final ResourceLocation getLocationWithExtension(ResourceLocation location, String arg) {
        return new ResourceLocation(location.func_110624_b(), location.func_110623_a() + "$" + this.getName() + "(" + arg + ")");
    }

    @Nullable
    public abstract IModel loadModel(IModel var1, ResourceLocation var2, String var3);

    @Nullable
    public IBakedModel getModelReplacement(ModelResourceLocation location, IBakedModel original) {
        return null;
    }

    protected final void throwLoaderException(@Nullable String reason) {
        this.throwLoaderException(reason, null);
    }

    protected final void throwLoaderException(@Nullable Throwable cause) {
        this.throwLoaderException(null, cause);
    }

    protected final void throwLoaderException(@Nullable String reason, @Nullable Throwable cause) {
        reason = reason != null ? String.format("Model loader extension %s failed loading a model. Reason: %s", this.getName(), reason) : String.format("Model loader extension %s failed loading a model", this.getName());
        throw new LoaderExtensionException(reason, cause);
    }

    protected final IModel getItemDummyModel() {
        if (this.dummyModel == null) {
            try {
                this.dummyModel = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("thebetweenlands:item/dummy"));
            }
            catch (Exception ex) {
                this.throwLoaderException("Failed to load dummy item model", ex);
            }
        }
        return this.dummyModel;
    }

    protected ImmutableMap<String, String> parseMetadata(JsonParser parser, ResourceLocation location) {
        return LoaderExtension.parseJsonElementList(parser, this.readMetadata(location), location.toString() + " model metadata");
    }

    protected String readMetadata(String metadata) {
        if (metadata.startsWith("mlmeta:")) {
            metadata = this.readMetadata(new ResourceLocation(metadata.substring("mlmeta:".length())));
        }
        return metadata;
    }

    protected String readMetadata(ResourceLocation location) {
        location = new ResourceLocation(location.func_110624_b(), location.func_110623_a() + ".mlmeta");
        IResourceManager manager = Minecraft.func_71410_x().func_110442_L();
        try {
            IResource metadataResource = manager.func_110536_a(location);
            return IOUtils.toString((InputStream)metadataResource.func_110527_b());
        }
        catch (IOException ex) {
            this.throwLoaderException("Failed to load file " + location, ex);
            return "";
        }
    }

    public static ImmutableMap<String, String> parseJsonElementList(JsonParser parser, String json, String member) {
        return LoaderExtension.parseJsonElementList(JsonUtils.func_151210_l((JsonElement)parser.parse(json), (String)member));
    }

    public static ImmutableMap<String, String> parseJsonElementList(JsonObject jsonObj) {
        ImmutableMap.Builder parsedElements = ImmutableMap.builder();
        for (Map.Entry elementEntry : jsonObj.entrySet()) {
            parsedElements.put(elementEntry.getKey(), (Object)((JsonElement)elementEntry.getValue()).toString());
        }
        return parsedElements.build();
    }
}

