/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model.baked;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;
import thebetweenlands.common.block.plant.BlockWeedwoodBush;
import thebetweenlands.util.QuadBuilder;
import thebetweenlands.util.StatePropertyHelper;

public class ModelWeedwoodBush
implements IModel {
    private final ResourceLocation leavesTexture;
    private final ResourceLocation sticksTexture;
    private final int leavesTintIndex;

    public ModelWeedwoodBush() {
        this.leavesTexture = new ResourceLocation("thebetweenlands", "blocks/leaves_weedwood_bush");
        this.sticksTexture = new ResourceLocation("thebetweenlands", "items/weedwood_stick");
        this.leavesTintIndex = 0;
    }

    public ModelWeedwoodBush(ResourceLocation leaves, ResourceLocation sticks, int leavesTintIndex) {
        this.leavesTexture = leaves;
        this.sticksTexture = sticks;
        this.leavesTintIndex = leavesTintIndex;
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    public Collection<ResourceLocation> getTextures() {
        return Collections.unmodifiableCollection(Arrays.asList(this.leavesTexture, this.sticksTexture));
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap map = PerspectiveMapWrapper.getTransforms((IModelState)state);
        return new ModelBakedWeedwoodBush(format, state.apply(Optional.empty()), map, bakedTextureGetter.apply(this.leavesTexture), bakedTextureGetter.apply(this.sticksTexture), this.leavesTintIndex);
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public ModelWeedwoodBush process(ImmutableMap<String, String> customData) {
        JsonParser parser = new JsonParser();
        ResourceLocation leaves = this.leavesTexture;
        if (customData.containsKey((Object)"texture_leaves")) {
            leaves = new ResourceLocation(JsonUtils.func_151206_a((JsonElement)parser.parse((String)customData.get((Object)"texture_leaves")), (String)"texture_leaves"));
        }
        if (leaves == null) {
            leaves = TextureMap.field_174945_f;
        }
        ResourceLocation sticks = this.sticksTexture;
        if (customData.containsKey((Object)"texture_sticks")) {
            sticks = new ResourceLocation(JsonUtils.func_151206_a((JsonElement)parser.parse((String)customData.get((Object)"texture_sticks")), (String)"texture_sticks"));
        }
        if (sticks == null) {
            sticks = TextureMap.field_174945_f;
        }
        int leavesTintIndex = this.leavesTintIndex;
        if (customData.containsKey((Object)"tint_index_leaves")) {
            leavesTintIndex = JsonUtils.func_151215_f((JsonElement)parser.parse((String)customData.get((Object)"tint_index_leaves")), (String)"tint_index_leaves");
        }
        return new ModelWeedwoodBush(leaves, sticks, leavesTintIndex);
    }

    private static class CompositeList<E>
    extends AbstractList<E> {
        private final List<E> list1;
        private final List<E> list2;

        public CompositeList(List<E> list1, List<E> list2) {
            this.list1 = list1;
            this.list2 = list2;
        }

        @Override
        public E get(int index) {
            if (index < this.list1.size()) {
                return this.list1.get(index);
            }
            return this.list2.get(index - this.list1.size());
        }

        @Override
        public int size() {
            return this.list1.size() + this.list2.size();
        }
    }

    public static class ModelBakedWeedwoodBush
    implements IBakedModel {
        protected final TRSRTransformation transformation;
        protected final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        private final VertexFormat format;
        private final TextureAtlasSprite textureLeaves;
        private final TextureAtlasSprite textureSticks;
        private final int leavesTintIndex;
        private final List<BakedQuad> baseQuads;
        private final List<BakedQuad> fancyQuads;
        private final LoadingCache<Long, ModelBakedWeedwoodBush> modelCache = CacheBuilder.newBuilder().maximumSize(128L).build((CacheLoader)new CacheLoader<Long, ModelBakedWeedwoodBush>(){

            public ModelBakedWeedwoodBush load(Long key) throws Exception {
                return new ModelBakedWeedwoodBush(format, Optional.ofNullable(transformation), transforms, textureLeaves, textureSticks, leavesTintIndex, key);
            }
        });

        private ModelBakedWeedwoodBush(VertexFormat format, Optional<TRSRTransformation> transformation, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, TextureAtlasSprite textureLeaves, TextureAtlasSprite textureSticks, int leavesTintIndex) {
            this(format, transformation, transforms, textureLeaves, textureSticks, leavesTintIndex, -1L);
        }

        private ModelBakedWeedwoodBush(VertexFormat format, Optional<TRSRTransformation> transformation, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, TextureAtlasSprite textureLeaves, TextureAtlasSprite textureSticks, int leavesTintIndex, long index) {
            this.transformation = transformation.isPresent() ? transformation.get() : null;
            this.transforms = transforms;
            this.format = format;
            this.textureLeaves = textureLeaves;
            this.textureSticks = textureSticks;
            this.leavesTintIndex = leavesTintIndex;
            if (index != -1L) {
                QuadBuilder builder = new QuadBuilder(this.format).setTransformation(this.transformation);
                builder.setTintIndex(leavesTintIndex);
                builder.setSprite(this.textureLeaves);
                float mini = (index & 1L) != 0L ? -0.25f : 0.0f;
                float maxi = (index & 2L) != 0L ? 0.25f : 0.0f;
                float minj = (index & 4L) != 0L ? -0.25f : 0.0f;
                float maxj = (index & 8L) != 0L ? 0.25f : 0.0f;
                float mink = (index & 0x10L) != 0L ? -0.25f : 0.0f;
                float maxk = (index & 0x20L) != 0L ? 0.25f : 0.0f;
                builder.addVertex(0.0, 0.25 + (double)minj, 0.75 + (double)maxk, 0.0f, 0.0f);
                builder.addVertex(0.0, 0.75 + (double)maxj, 0.75 + (double)maxk, 0.0f, 16.0f);
                builder.addVertex(0.0, 0.75 + (double)maxj, 0.25 + (double)mink, 16.0f, 16.0f);
                builder.addVertex(0.0, 0.25 + (double)minj, 0.25 + (double)mink, 16.0f, 0.0f);
                builder.addVertex(0.0, 0.75, 0.75 + (double)maxk, 0.0f, 0.0f);
                builder.addVertex(0.25, 1.0, 0.75 + (double)maxk, 0.0f, 16.0f);
                builder.addVertex(0.25, 1.0, 0.25 + (double)mink, 16.0f, 16.0f);
                builder.addVertex(0.0, 0.75, 0.25 + (double)mink, 16.0f, 0.0f);
                builder.addVertex(0.25, 0.0, 0.75 + (double)maxk, 0.0f, 0.0f);
                builder.addVertex(0.0, 0.25, 0.75 + (double)maxk, 0.0f, 16.0f);
                builder.addVertex(0.0, 0.25, 0.25 + (double)mink, 16.0f, 16.0f);
                builder.addVertex(0.25, 0.0, 0.25 + (double)mink, 16.0f, 0.0f);
                builder.addVertex(1.0, 0.25 + (double)minj, 0.25 + (double)mink, 0.0f, 0.0f);
                builder.addVertex(1.0, 0.75 + (double)maxj, 0.25 + (double)mink, 0.0f, 16.0f);
                builder.addVertex(1.0, 0.75 + (double)maxj, 0.75 + (double)maxk, 16.0f, 16.0f);
                builder.addVertex(1.0, 0.25 + (double)minj, 0.75 + (double)maxk, 16.0f, 0.0f);
                builder.addVertex(0.75, 1.0, 0.75 + (double)maxk, 0.0f, 0.0f);
                builder.addVertex(1.0, 0.75, 0.75 + (double)maxk, 0.0f, 16.0f);
                builder.addVertex(1.0, 0.75, 0.25 + (double)mink, 16.0f, 16.0f);
                builder.addVertex(0.75, 1.0, 0.25 + (double)mink, 16.0f, 0.0f);
                builder.addVertex(1.0, 0.25, 0.75 + (double)maxk, 0.0f, 0.0f);
                builder.addVertex(0.75, 0.0, 0.75 + (double)maxk, 0.0f, 16.0f);
                builder.addVertex(0.75, 0.0, 0.25 + (double)mink, 16.0f, 16.0f);
                builder.addVertex(1.0, 0.25, 0.25 + (double)mink, 16.0f, 0.0f);
                builder.addVertex(0.25 + (double)mini, 0.25 + (double)minj, 0.0, 0.0f, 0.0f);
                builder.addVertex(0.25 + (double)mini, 0.75 + (double)maxj, 0.0, 0.0f, 16.0f);
                builder.addVertex(0.75 + (double)maxi, 0.75 + (double)maxj, 0.0, 16.0f, 16.0f);
                builder.addVertex(0.75 + (double)maxi, 0.25 + (double)minj, 0.0, 16.0f, 0.0f);
                builder.addVertex(0.0, 0.25 + (double)minj, 0.25, 0.0f, 0.0f);
                builder.addVertex(0.0, 0.75 + (double)maxj, 0.25, 0.0f, 16.0f);
                builder.addVertex(0.25, 0.75 + (double)maxj, 0.0, 16.0f, 16.0f);
                builder.addVertex(0.25, 0.25 + (double)minj, 0.0, 16.0f, 0.0f);
                builder.addVertex(0.75, 0.25 + (double)minj, 0.0, 0.0f, 0.0f);
                builder.addVertex(0.75, 0.75 + (double)maxj, 0.0, 0.0f, 16.0f);
                builder.addVertex(1.0, 0.75 + (double)maxj, 0.25, 16.0f, 16.0f);
                builder.addVertex(1.0, 0.25 + (double)minj, 0.25, 16.0f, 0.0f);
                builder.addVertex(0.25 + (double)mini, 0.75, 0.0, 0.0f, 0.0f);
                builder.addVertex(0.25 + (double)mini, 1.0, 0.25, 0.0f, 16.0f);
                builder.addVertex(0.75 + (double)maxi, 1.0, 0.25, 16.0f, 16.0f);
                builder.addVertex(0.75 + (double)maxi, 0.75, 0.0, 16.0f, 0.0f);
                builder.addVertex(0.25 + (double)mini, 0.0, 0.25, 0.0f, 0.0f);
                builder.addVertex(0.25 + (double)mini, 0.25, 0.0, 0.0f, 16.0f);
                builder.addVertex(0.75 + (double)maxi, 0.25, 0.0, 16.0f, 16.0f);
                builder.addVertex(0.75 + (double)maxi, 0.0, 0.25, 16.0f, 0.0f);
                builder.addVertex(0.75 + (double)maxi, 0.25 + (double)minj, 1.0, 0.0f, 0.0f);
                builder.addVertex(0.75 + (double)maxi, 0.75 + (double)maxj, 1.0, 0.0f, 16.0f);
                builder.addVertex(0.25 + (double)mini, 0.75 + (double)maxj, 1.0, 16.0f, 16.0f);
                builder.addVertex(0.25 + (double)mini, 0.25 + (double)minj, 1.0, 16.0f, 0.0f);
                builder.addVertex(0.25 + (double)mini, 0.75, 1.0, 0.0f, 0.0f);
                builder.addVertex(0.75 + (double)maxi, 0.75, 1.0, 0.0f, 16.0f);
                builder.addVertex(0.75 + (double)maxi, 1.0, 0.75, 16.0f, 16.0f);
                builder.addVertex(0.25 + (double)mini, 1.0, 0.75, 16.0f, 0.0f);
                builder.addVertex(1.0, 0.25 + (double)minj, 0.75, 0.0f, 0.0f);
                builder.addVertex(1.0, 0.75 + (double)maxj, 0.75, 0.0f, 16.0f);
                builder.addVertex(0.75, 0.75 + (double)maxj, 1.0, 16.0f, 16.0f);
                builder.addVertex(0.75, 0.25 + (double)minj, 1.0, 16.0f, 0.0f);
                builder.addVertex(0.25, 0.25 + (double)minj, 1.0, 0.0f, 0.0f);
                builder.addVertex(0.25, 0.75 + (double)maxj, 1.0, 0.0f, 16.0f);
                builder.addVertex(0.0, 0.75 + (double)maxj, 0.75, 16.0f, 16.0f);
                builder.addVertex(0.0, 0.25 + (double)minj, 0.75, 16.0f, 0.0f);
                builder.addVertex(0.25 + (double)mini, 0.0, 0.75, 0.0f, 0.0f);
                builder.addVertex(0.75 + (double)maxi, 0.0, 0.75, 0.0f, 16.0f);
                builder.addVertex(0.75 + (double)maxi, 0.25, 1.0, 16.0f, 16.0f);
                builder.addVertex(0.25 + (double)mini, 0.25, 1.0, 16.0f, 0.0f);
                builder.addVertex(0.25 + (double)mini, 1.0, 0.75 + (double)maxk, 0.0f, 0.0f);
                builder.addVertex(0.75 + (double)maxi, 1.0, 0.75 + (double)maxk, 0.0f, 16.0f);
                builder.addVertex(0.75 + (double)maxi, 1.0, 0.25 + (double)mink, 16.0f, 16.0f);
                builder.addVertex(0.25 + (double)mini, 1.0, 0.25 + (double)mink, 16.0f, 0.0f);
                builder.addVertex(0.75 + (double)maxi, 0.0, 0.75 + (double)maxk, 0.0f, 0.0f);
                builder.addVertex(0.25 + (double)mini, 0.0, 0.75 + (double)maxk, 0.0f, 16.0f);
                builder.addVertex(0.25 + (double)mini, 0.0, 0.25 + (double)mink, 16.0f, 16.0f);
                builder.addVertex(0.75 + (double)maxi, 0.0, 0.25 + (double)mink, 16.0f, 0.0f);
                builder.addVertex(1.0, 0.25, 0.25, 0.0f, 0.0f);
                builder.addVertex(0.75, 0.0, 0.25, 0.0f, 16.0f);
                builder.addVertex(0.75, 0.25, 0.0, 16.0f, 16.0f);
                builder.addVertex(0.75, 0.25, 0.0, 16.0f, 0.0f);
                builder.addVertex(0.75, 0.25, 1.0, 0.0f, 0.0f);
                builder.addVertex(0.75, 0.0, 0.75, 0.0f, 16.0f);
                builder.addVertex(1.0, 0.25, 0.75, 16.0f, 16.0f);
                builder.addVertex(1.0, 0.25, 0.75, 16.0f, 0.0f);
                builder.addVertex(0.75, 1.0, 0.75, 0.0f, 0.0f);
                builder.addVertex(0.75, 0.75, 1.0, 0.0f, 16.0f);
                builder.addVertex(1.0, 0.75, 0.75, 16.0f, 16.0f);
                builder.addVertex(1.0, 0.75, 0.75, 16.0f, 0.0f);
                builder.addVertex(0.75, 0.75, 0.0, 0.0f, 0.0f);
                builder.addVertex(0.75, 1.0, 0.25, 0.0f, 16.0f);
                builder.addVertex(1.0, 0.75, 0.25, 16.0f, 16.0f);
                builder.addVertex(0.75, 0.75, 0.0, 16.0f, 0.0f);
                builder.addVertex(0.0, 0.25, 0.25, 0.0f, 0.0f);
                builder.addVertex(0.25, 0.25, 0.0, 0.0f, 16.0f);
                builder.addVertex(0.25, 0.0, 0.25, 16.0f, 16.0f);
                builder.addVertex(0.25, 0.0, 0.25, 16.0f, 0.0f);
                builder.addVertex(0.25, 1.0, 0.75, 0.0f, 0.0f);
                builder.addVertex(0.0, 0.75, 0.75, 0.0f, 16.0f);
                builder.addVertex(0.25, 0.75, 1.0, 16.0f, 16.0f);
                builder.addVertex(0.25, 0.75, 1.0, 16.0f, 0.0f);
                builder.addVertex(0.25, 0.25, 1.0, 0.0f, 0.0f);
                builder.addVertex(0.0, 0.25, 0.75, 0.0f, 16.0f);
                builder.addVertex(0.25, 0.0, 0.75, 16.0f, 16.0f);
                builder.addVertex(0.25, 0.0, 0.75, 16.0f, 0.0f);
                builder.addVertex(0.25, 1.0, 0.25, 0.0f, 0.0f);
                builder.addVertex(0.25, 0.75, 0.0, 0.0f, 16.0f);
                builder.addVertex(0.0, 0.75, 0.25, 16.0f, 16.0f);
                builder.addVertex(0.0, 0.75, 0.25, 16.0f, 0.0f);
                this.baseQuads = builder.build().nonCulledQuads;
                builder.addVertex(0.1, 0.5, -0.1, 0.0f, 0.0f);
                builder.addVertex(0.5, 1.1, 0.5, 16.0f, 0.0f);
                builder.addVertex(0.9, 0.5, 1.1, 16.0f, 16.0f);
                builder.addVertex(0.5, -0.1, 0.5, 0.0f, 16.0f);
                builder.addVertex(0.9, 0.5, 1.1, 0.0f, 0.0f);
                builder.addVertex(0.5, 1.1, 0.5, 16.0f, 0.0f);
                builder.addVertex(0.1, 0.5, -0.1, 16.0f, 16.0f);
                builder.addVertex(0.5, -0.1, 0.5, 0.0f, 16.0f);
                builder.addVertex(0.1, 0.5, 0.7, 0.0f, 0.0f);
                builder.addVertex(0.5, 1.1, 0.5, 16.0f, 0.0f);
                builder.addVertex(0.9, 0.5, 0.3, 16.0f, 16.0f);
                builder.addVertex(0.5, -0.1, 0.5, 0.0f, 16.0f);
                builder.addVertex(0.9, 0.5, 0.3, 0.0f, 0.0f);
                builder.addVertex(0.3, 1.1, 0.5, 16.0f, 0.0f);
                builder.addVertex(0.1, 0.5, 0.7, 16.0f, 16.0f);
                builder.addVertex(0.5, -0.1, 0.5, 0.0f, 16.0f);
                builder.addVertex(0.3, 0.5, 1.1, 0.0f, 0.0f);
                builder.addVertex(0.5, 1.1, 0.5, 16.0f, 0.0f);
                builder.addVertex(0.9, 0.5, -0.1, 16.0f, 16.0f);
                builder.addVertex(0.5, -0.1, 0.5, 0.0f, 16.0f);
                builder.addVertex(0.9, 0.5, -0.1, 0.0f, 0.0f);
                builder.addVertex(0.5, 1.1, 0.5, 16.0f, 0.0f);
                builder.addVertex(0.3, 0.5, 1.1, 16.0f, 16.0f);
                builder.addVertex(0.5, -0.1, 0.5, 0.0f, 16.0f);
                this.fancyQuads = builder.build().nonCulledQuads;
            } else {
                this.fancyQuads = Collections.emptyList();
                this.baseQuads = this.fancyQuads;
            }
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            if (side == null) {
                int posX = 0;
                int posY = 0;
                int posZ = 0;
                long index = 0L;
                if (StatePropertyHelper.getPropertyOptional(state, BlockWeedwoodBush.WEST).orElse(false).booleanValue()) {
                    index |= 1L;
                }
                if (StatePropertyHelper.getPropertyOptional(state, BlockWeedwoodBush.EAST).orElse(false).booleanValue()) {
                    index |= 2L;
                }
                if (StatePropertyHelper.getPropertyOptional(state, BlockWeedwoodBush.DOWN).orElse(false).booleanValue()) {
                    index |= 4L;
                }
                if (StatePropertyHelper.getPropertyOptional(state, BlockWeedwoodBush.UP).orElse(false).booleanValue()) {
                    index |= 8L;
                }
                if (StatePropertyHelper.getPropertyOptional(state, BlockWeedwoodBush.NORTH).orElse(false).booleanValue()) {
                    index |= 0x10L;
                }
                if (StatePropertyHelper.getPropertyOptional(state, BlockWeedwoodBush.SOUTH).orElse(false).booleanValue()) {
                    index |= 0x20L;
                }
                posX = StatePropertyHelper.getPropertyOptional(state, BlockWeedwoodBush.POS_X).orElse(0);
                posY = StatePropertyHelper.getPropertyOptional(state, BlockWeedwoodBush.POS_Y).orElse(0);
                posZ = StatePropertyHelper.getPropertyOptional(state, BlockWeedwoodBush.POS_Z).orElse(0);
                ModelBakedWeedwoodBush model = (ModelBakedWeedwoodBush)this.modelCache.getUnchecked((Object)index);
                List<BakedQuad> quads = model.baseQuads;
                if (Minecraft.func_71375_t()) {
                    quads = new CompositeList<BakedQuad>(quads, model.fancyQuads);
                    int cSticks = 5;
                    Random rnd = new Random();
                    long seed = (long)posX * 3129871L ^ (long)posY * 116129781L ^ (long)posZ;
                    rnd.setSeed(seed * seed * 42317861L + seed * 11L);
                    QuadBuilder builder = new QuadBuilder(this.format).setTransformation(this.transformation);
                    builder.setSprite(this.textureSticks);
                    builder.setTintIndex(-1);
                    for (int i = 0; i < cSticks; ++i) {
                        double rotation = Math.PI * 2 / (double)cSticks * (double)i;
                        double xp1 = Math.sin(rotation) * (double)0.4f;
                        double zp1 = Math.cos(rotation) * (double)0.4f;
                        double xp2 = Math.sin(rotation + 1.5707963267948966) * (double)0.4f;
                        double zp2 = Math.cos(rotation + 1.5707963267948966) * (double)0.4f;
                        double xp3 = Math.sin(rotation + Math.PI) * (double)0.4f;
                        double zp3 = Math.cos(rotation + Math.PI) * (double)0.4f;
                        double xp4 = Math.sin(rotation + Math.PI + 1.5707963267948966) * (double)0.4f;
                        double zp4 = Math.cos(rotation + Math.PI + 1.5707963267948966) * (double)0.4f;
                        float xOff = (rnd.nextFloat() * 2.0f - 1.0f) * 0.4f + 0.5f;
                        float yOff = (rnd.nextFloat() * 2.0f - 1.0f) * 0.4f;
                        float zOff = (rnd.nextFloat() * 2.0f - 1.0f) * 0.4f + 0.5f;
                        builder.addVertex(xp1 + (double)xOff, 0.8 + (double)yOff, zp1 + (double)zOff, 0.0f, 0.0f);
                        builder.addVertex(xp2 + (double)xOff, 0.8 + (double)yOff, zp2 + (double)zOff, 16.0f, 0.0f);
                        builder.addVertex(xp3 + (double)xOff, 0.2 + (double)yOff, zp3 + (double)zOff, 16.0f, 16.0f);
                        builder.addVertex(xp4 + (double)xOff, 0.2 + (double)yOff, zp4 + (double)zOff, 0.0f, 16.0f);
                        builder.addVertex(xp1 + (double)xOff, 0.8 + (double)yOff, zp1 + (double)zOff, 0.0f, 0.0f);
                        builder.addVertex(xp4 + (double)xOff, 0.2 + (double)yOff, zp4 + (double)zOff, 0.0f, 16.0f);
                        builder.addVertex(xp3 + (double)xOff, 0.2 + (double)yOff, zp3 + (double)zOff, 16.0f, 16.0f);
                        builder.addVertex(xp2 + (double)xOff, 0.8 + (double)yOff, zp2 + (double)zOff, 16.0f, 0.0f);
                    }
                    quads = new CompositeList<BakedQuad>(quads, (List<BakedQuad>)builder.build().nonCulledQuads);
                }
                return quads;
            }
            return Collections.emptyList();
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return true;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.textureLeaves;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)type);
        }
    }
}

