/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model;

import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class Model3DTexture
extends ModelBox {
    private int textureOffsetX;
    private int textureOffsetY;
    private int width;
    private int height;
    private float u1;
    private float v1;
    private float u2;
    private float v2;

    public Model3DTexture(ModelRenderer model, int textureOffsetX, int textureOffsetY, float posX, float posY, float posZ, int width, int height) {
        super(model, 0, 0, posX, posY, posZ, 0, 0, 0, 0.0f);
        this.textureOffsetX = textureOffsetX;
        this.textureOffsetY = textureOffsetY;
        this.width = width;
        this.height = height;
        this.u1 = (float)textureOffsetX / model.field_78801_a;
        this.v1 = (float)textureOffsetY / model.field_78799_b;
        this.u2 = (float)(textureOffsetX + width) / model.field_78801_a;
        this.v2 = (float)(textureOffsetY + height) / model.field_78799_b;
    }

    public Model3DTexture(ModelRenderer model, int textureOffsetX, int textureOffsetY, int width, int height) {
        this(model, textureOffsetX, textureOffsetY, 0.0f, 0.0f, 0.0f, width, height);
    }

    public void func_178780_a(BufferBuilder renderer, float scale) {
        float mirroredPixelPos;
        float pixelUV;
        float pixelPos;
        int pixel;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.field_78252_a, (float)this.field_78250_b, (float)this.field_78251_c);
        GlStateManager.func_179152_a((float)((float)this.width / 16.0f), (float)((float)this.height / 16.0f), (float)1.0f);
        float depth = 0.0625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        renderer.func_181662_b(0.0, 0.0, 0.0).func_187315_a((double)this.u1, (double)this.v2).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        renderer.func_181662_b(1.0, 0.0, 0.0).func_187315_a((double)this.u2, (double)this.v2).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        renderer.func_181662_b(1.0, 1.0, 0.0).func_187315_a((double)this.u2, (double)this.v1).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        renderer.func_181662_b(0.0, 1.0, 0.0).func_187315_a((double)this.u1, (double)this.v1).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        renderer.func_181662_b(0.0, 1.0, (double)(0.0f - depth)).func_187315_a((double)this.u1, (double)this.v1).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        renderer.func_181662_b(1.0, 1.0, (double)(0.0f - depth)).func_187315_a((double)this.u2, (double)this.v1).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        renderer.func_181662_b(1.0, 0.0, (double)(0.0f - depth)).func_187315_a((double)this.u2, (double)this.v2).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        renderer.func_181662_b(0.0, 0.0, (double)(0.0f - depth)).func_187315_a((double)this.u1, (double)this.v2).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        tessellator.func_78381_a();
        float halfU = 0.5f * (this.u1 - this.u2) / (float)this.width;
        float halfV = 0.5f * (this.v2 - this.v1) / (float)this.height;
        renderer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        for (pixel = 0; pixel < this.width; ++pixel) {
            pixelPos = (float)pixel / (float)this.width;
            pixelUV = this.u1 + (this.u2 - this.u1) * pixelPos - halfU;
            renderer.func_181662_b((double)pixelPos, 0.0, (double)(0.0f - depth)).func_187315_a((double)pixelUV, (double)this.v2).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
            renderer.func_181662_b((double)pixelPos, 0.0, 0.0).func_187315_a((double)pixelUV, (double)this.v2).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
            renderer.func_181662_b((double)pixelPos, 1.0, 0.0).func_187315_a((double)pixelUV, (double)this.v1).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
            renderer.func_181662_b((double)pixelPos, 1.0, (double)(0.0f - depth)).func_187315_a((double)pixelUV, (double)this.v1).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        }
        tessellator.func_78381_a();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        for (pixel = 0; pixel < this.width; ++pixel) {
            pixelPos = (float)pixel / (float)this.width;
            pixelUV = this.u1 + (this.u2 - this.u1) * pixelPos - halfU;
            mirroredPixelPos = pixelPos + 1.0f / (float)this.width;
            renderer.func_181662_b((double)mirroredPixelPos, 1.0, (double)(0.0f - depth)).func_187315_a((double)pixelUV, (double)this.v1).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
            renderer.func_181662_b((double)mirroredPixelPos, 1.0, 0.0).func_187315_a((double)pixelUV, (double)this.v1).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
            renderer.func_181662_b((double)mirroredPixelPos, 0.0, 0.0).func_187315_a((double)pixelUV, (double)this.v2).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
            renderer.func_181662_b((double)mirroredPixelPos, 0.0, (double)(0.0f - depth)).func_187315_a((double)pixelUV, (double)this.v2).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        }
        tessellator.func_78381_a();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        for (pixel = 0; pixel < this.height; ++pixel) {
            pixelPos = (float)pixel / (float)this.height;
            pixelUV = this.v2 + (this.v1 - this.v2) * pixelPos - halfV;
            renderer.func_181662_b(1.0, (double)pixelPos, 0.0).func_187315_a((double)this.u2, (double)pixelUV).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
            renderer.func_181662_b(0.0, (double)pixelPos, 0.0).func_187315_a((double)this.u1, (double)pixelUV).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
            renderer.func_181662_b(0.0, (double)pixelPos, (double)(0.0f - depth)).func_187315_a((double)this.u1, (double)pixelUV).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
            renderer.func_181662_b(1.0, (double)pixelPos, (double)(0.0f - depth)).func_187315_a((double)this.u2, (double)pixelUV).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        }
        tessellator.func_78381_a();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        for (pixel = 0; pixel < this.height; ++pixel) {
            pixelPos = (float)pixel / (float)this.height;
            pixelUV = this.v2 + (this.v1 - this.v2) * pixelPos - halfV;
            mirroredPixelPos = pixelPos + 1.0f / (float)this.height;
            renderer.func_181662_b(0.0, (double)mirroredPixelPos, 0.0).func_187315_a((double)this.u1, (double)pixelUV).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            renderer.func_181662_b(1.0, (double)mirroredPixelPos, 0.0).func_187315_a((double)this.u2, (double)pixelUV).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            renderer.func_181662_b(1.0, (double)mirroredPixelPos, (double)(0.0f - depth)).func_187315_a((double)this.u2, (double)pixelUV).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            renderer.func_181662_b(0.0, (double)mirroredPixelPos, (double)(0.0f - depth)).func_187315_a((double)this.u1, (double)pixelUV).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }
}

