/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.RenderItemFrame;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.item.ItemCompass;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.client.event.RenderItemInFrameEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.entity.RenderDraeton;
import thebetweenlands.common.entity.EntityBLItemFrame;
import thebetweenlands.common.entity.mobs.EntityAnadia;
import thebetweenlands.common.item.EnumBLDyeColor;
import thebetweenlands.common.item.misc.ItemMob;

@SideOnly(value=Side.CLIENT)
public class RenderBLItemFrame
extends RenderItemFrame {
    private static final ResourceLocation MAP_BACKGROUND_TEXTURES = new ResourceLocation("textures/map/map_background.png");
    private final Minecraft mc = Minecraft.func_71410_x();
    public static final ModelResourceLocation FRAME_MODEL = new ModelResourceLocation(new ResourceLocation("thebetweenlands", "item_frame"), "normal");
    public static final ModelResourceLocation FRAME_BG_MODEL = new ModelResourceLocation(new ResourceLocation("thebetweenlands", "item_frame"), "background");
    protected final RenderItem field_177074_h = Minecraft.func_71410_x().func_175599_af();

    public RenderBLItemFrame(RenderManager renderManager) {
        super(renderManager, Minecraft.func_71410_x().func_175599_af());
    }

    @Nullable
    protected ResourceLocation func_110775_a(EntityItemFrame entity) {
        return null;
    }

    public void func_76986_a(EntityItemFrame entity, double x, double y, double z, float entityYaw, float partialTicks) {
        EntityBLItemFrame blItemFrame = (EntityBLItemFrame)entity;
        GlStateManager.func_179094_E();
        BlockPos blockpos = entity.func_174857_n();
        double d0 = (double)blockpos.func_177958_n() - entity.field_70165_t + x;
        double d1 = (double)blockpos.func_177956_o() - entity.field_70163_u + y;
        double d2 = (double)blockpos.func_177952_p() - entity.field_70161_v + z;
        GlStateManager.func_179137_b((double)(d0 + 0.5), (double)(d1 + 0.5), (double)(d2 + 0.5));
        if (blItemFrame.realFacingDirection.func_176740_k() == EnumFacing.Axis.Y) {
            GlStateManager.func_179114_b((float)(blItemFrame.realFacingDirection == EnumFacing.DOWN ? -90.0f : 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(blItemFrame.realFacingDirection == EnumFacing.UP ? 180.0f : 0.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        } else {
            GlStateManager.func_179114_b((float)(180.0f - entity.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        this.field_76990_c.field_78724_e.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        if (this.field_188301_f) {
            GlStateManager.func_179142_g();
            GlStateManager.func_187431_e((int)this.func_188298_c((Entity)entity));
        }
        this.renderModel(entity, this.mc);
        if (this.field_188301_f) {
            GlStateManager.func_187417_n();
            GlStateManager.func_179119_h();
        }
        if (blItemFrame.IsFrameGlowing()) {
            GlStateManager.func_179145_e();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.4375f);
        boolean flipItem = blItemFrame.realFacingDirection == EnumFacing.DOWN && !blItemFrame.func_82335_i().func_190926_b() && blItemFrame.func_82335_i().func_77973_b() instanceof ItemCompass;
        GlStateManager.func_179114_b((float)(flipItem ? -180.0f : 0.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderItem(entity);
        GlStateManager.func_179121_F();
    }

    private void renderItem(EntityItemFrame itemFrame) {
        EntityBLItemFrame blItemFrame = (EntityBLItemFrame)itemFrame;
        ItemStack itemstack = itemFrame.func_82335_i();
        if (!itemstack.func_190926_b()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179140_f();
            boolean flag = itemstack.func_77973_b() instanceof ItemMap;
            int i = flag ? itemFrame.func_82333_j() % 4 * 2 : itemFrame.func_82333_j();
            GlStateManager.func_179114_b((float)((float)i * 360.0f / 8.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            RenderItemInFrameEvent event = new RenderItemInFrameEvent(itemFrame, (RenderItemFrame)this);
            if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                if (flag) {
                    this.field_76990_c.field_78724_e.func_110577_a(MAP_BACKGROUND_TEXTURES);
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    float f = 0.0078125f;
                    GlStateManager.func_179152_a((float)0.0078125f, (float)0.0078125f, (float)0.0078125f);
                    GlStateManager.func_179109_b((float)-64.0f, (float)-64.0f, (float)0.0f);
                    MapData mapdata = ((ItemMap)itemstack.func_77973_b()).func_77873_a(itemstack, itemFrame.field_70170_p);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
                    if (mapdata != null) {
                        this.mc.field_71460_t.func_147701_i().func_148250_a(mapdata, true);
                    }
                } else {
                    GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                    GlStateManager.func_179123_a();
                    RenderHelper.func_74519_b();
                    if (itemstack.func_77973_b() instanceof ItemMob) {
                        ItemMob itemMob = (ItemMob)itemstack.func_77973_b();
                        Entity entity = itemMob.createCapturedEntity(itemFrame.field_70170_p, 0.0, 0.0, 0.0, itemstack, false);
                        if (entity != null && !(entity instanceof IEntityMultiPart)) {
                            float horizontalOffset = 0.0f;
                            if (entity instanceof EntityAnadia) {
                                horizontalOffset = entity.field_70130_N / 4.0f;
                            }
                            entity.func_70080_a(0.0, 0.0, 0.0, 0.0f, 0.0f);
                            if (blItemFrame.realFacingDirection.func_176740_k().equals((Object)EnumFacing.Axis.Y)) {
                                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                            } else {
                                GlStateManager.func_179137_b((double)horizontalOffset, (double)((double)(-entity.field_70131_O) / 2.0), (double)-0.05);
                            }
                            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                            entity.field_70125_A = 0.0f;
                            entity.field_70173_aa = 0;
                            Minecraft.func_71410_x().func_175598_ae().func_188391_a(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, true);
                        } else {
                            this.field_177074_h.func_181564_a(itemstack, ItemCameraTransforms.TransformType.FIXED);
                        }
                    } else {
                        this.field_177074_h.func_181564_a(itemstack, ItemCameraTransforms.TransformType.FIXED);
                    }
                    RenderHelper.func_74518_a();
                    GlStateManager.func_179099_b();
                }
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
        }
    }

    protected void renderModel(EntityItemFrame entity, Minecraft mc) {
        EntityBLItemFrame itemFrame = (EntityBLItemFrame)entity;
        if (itemFrame.IsFrameInvisible() && !itemFrame.func_82335_i().func_190926_b()) {
            if (itemFrame.IsFrameGlowing()) {
                GlStateManager.func_179140_f();
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            }
            return;
        }
        BlockRendererDispatcher blockrendererdispatcher = this.mc.func_175602_ab();
        ModelManager modelmanager = blockrendererdispatcher.func_175023_a().func_178126_b();
        if (entity.func_82335_i().func_77973_b() instanceof ItemMap) {
            if (itemFrame.IsFrameGlowing()) {
                GlStateManager.func_179140_f();
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            }
            IBakedModel model = modelmanager.func_174953_a(RenderDraeton.FRAME_MAP_MODEL);
            blockrendererdispatcher.func_175019_b().func_178262_a(model, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            IBakedModel woodModel = modelmanager.func_174953_a(FRAME_MODEL);
            IBakedModel coloredModel = modelmanager.func_174953_a(FRAME_BG_MODEL);
            blockrendererdispatcher.func_175019_b().func_178262_a(woodModel, 1.0f, 1.0f, 1.0f, 1.0f);
            int color = EnumBLDyeColor.byMetadata(((EntityBLItemFrame)entity).getColor()).getColorValue();
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            if (itemFrame.IsFrameGlowing()) {
                GlStateManager.func_179140_f();
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            }
            blockrendererdispatcher.func_175019_b().func_178262_a(coloredModel, 1.0f, r, g, b);
        }
    }
}

