/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.handler;

import java.util.ArrayDeque;
import java.util.concurrent.FutureTask;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MouseHelper;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.entity.rowboat.EntityWeedwoodRowboat;
import thebetweenlands.util.Matrix;

public final class WeedwoodRowboatHandler {
    public static final WeedwoodRowboatHandler INSTANCE = new WeedwoodRowboatHandler();
    private static final Minecraft MC = Minecraft.func_71410_x();
    private boolean isPlayerInRowboat;
    private MouseHelper lastMouseHelper;
    private View view = View.ROWBOAT;
    private View changedTo = null;
    private Entity prevRenderViewEntity = null;

    private WeedwoodRowboatHandler() {
    }

    public void init() {
        try {
            WeedwoodRowboatHandler.MC.field_152351_aB = new ArrayDeque<FutureTask<?>>(){

                @Override
                public boolean isEmpty() {
                    if (super.isEmpty()) {
                        WeedwoodRowboatHandler.this.onMacgyveredGameLoop();
                        return true;
                    }
                    return false;
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException("Any problem can be solved with a little ingenuity, he said...", e);
        }
    }

    public void onPilotEnterWeedwoodRowboat(Entity pilot) {
        if (pilot == WeedwoodRowboatHandler.MC.field_71439_g) {
            if (WeedwoodRowboatHandler.MC.field_71474_y.field_74320_O > 0) {
                this.changedTo = View.ROWBOAT;
            }
            if (this.changedTo != null && this.changedTo == View.ROWBOAT || BetweenlandsConfig.GENERAL.rowboatView) {
                this.enterRowboatPerspective();
            } else {
                this.leaveRowboatPerspective();
            }
        }
    }

    public void onPilotExitWeedwoodRowboat(EntityWeedwoodRowboat rowboat, Entity pilot) {
        if (pilot == WeedwoodRowboatHandler.MC.field_71439_g) {
            float yaw;
            double dx = rowboat.field_70165_t - pilot.field_70165_t;
            double dy = rowboat.field_70163_u + (double)rowboat.field_70131_O - (pilot.field_70163_u + (double)pilot.func_70047_e());
            double dz = rowboat.field_70161_v - pilot.field_70161_v;
            double h = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
            pilot.field_70125_A = (float)(-Math.toDegrees(MathHelper.func_181159_b((double)dy, (double)h)));
            pilot.field_70177_z = yaw = (float)Math.toDegrees(MathHelper.func_181159_b((double)dz, (double)dx)) - 90.0f;
            pilot.func_70034_d(yaw);
            pilot.func_181013_g(yaw);
            this.leaveRowboatPerspective();
            if (this.changedTo != null && this.changedTo == View.ROWBOAT) {
                WeedwoodRowboatHandler.MC.field_71474_y.field_74320_O = 1;
            }
            this.changedTo = null;
        }
    }

    @SubscribeEvent
    public void onRender(TickEvent.RenderTickEvent event) {
        Entity entity;
        if (event.phase == TickEvent.Phase.START && (entity = MC.func_175606_aa()) instanceof RowboatCam && this.isPlayerInRowboat && (!WeedwoodRowboatHandler.MC.field_71415_G || !Display.isActive())) {
            ((RowboatCam)entity).update(WeedwoodRowboatHandler.MC.field_71439_g.func_184187_bx(), event.renderTickTime);
        }
    }

    @SubscribeEvent
    public void onOverlayRender(RenderGameOverlayEvent event) {
        if (this.isPlayerInRowboat) {
            if (event instanceof RenderGameOverlayEvent.Pre && event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
                this.prevRenderViewEntity = MC.func_175606_aa();
                MC.func_175607_a((Entity)WeedwoodRowboatHandler.MC.field_71439_g);
                GuiIngameForge.renderFood = true;
            } else if (event instanceof RenderGameOverlayEvent.Post && event.getType() == RenderGameOverlayEvent.ElementType.ALL && (MC.func_175606_aa() == WeedwoodRowboatHandler.MC.field_71439_g || this.prevRenderViewEntity instanceof RowboatCam)) {
                MC.func_175607_a(this.prevRenderViewEntity);
            }
        }
    }

    @SubscribeEvent
    public void onMouseInput(MouseEvent event) {
        Entity entity = MC.func_175606_aa();
        if (entity instanceof RowboatCam) {
            RowboatCam cam = (RowboatCam)entity;
            cam.dolly = MathHelper.func_151237_a((double)(cam.dolly - (double)Math.signum(event.getDwheel()) * (cam.dolly - 1.0) * 0.1), (double)1.0, (double)10.0);
            event.setCanceled(true);
            int key = event.getButton() - 100;
            KeyBinding.func_74510_a((int)key, (boolean)Mouse.getEventButtonState());
            if (Mouse.getEventButtonState()) {
                KeyBinding.func_74507_a((int)key);
            }
        }
    }

    @SubscribeEvent
    public void onTickAfterKeyboard(InputEvent.KeyInputEvent event) {
        int press;
        if (this.isPlayerInRowboat && Keyboard.getEventKeyState() && (press = WeedwoodRowboatHandler.MC.field_71474_y.field_151457_aa.field_151474_i) > 0) {
            if (this.view == View.FIRST_PERSON) {
                this.enterRowboatPerspective();
                this.view = View.ROWBOAT;
                BetweenlandsConfig.GENERAL.rowboatView = true;
            } else {
                this.leaveRowboatPerspective();
                this.view = View.FIRST_PERSON;
                BetweenlandsConfig.GENERAL.rowboatView = false;
            }
            WeedwoodRowboatHandler.MC.field_71474_y.field_74320_O = 2;
            this.changedTo = this.view;
        }
    }

    @SubscribeEvent
    public void onHandRender(RenderHandEvent event) {
        if (MC.func_175606_aa() instanceof RowboatCam) {
            event.setCanceled(true);
        }
    }

    private void enterRowboatPerspective() {
        Entity entity = WeedwoodRowboatHandler.MC.field_71439_g.func_184187_bx();
        MC.func_175607_a((Entity)new RowboatCam((World)WeedwoodRowboatHandler.MC.field_71441_e, entity == null ? 0.0f : entity.field_70177_z, 30.0f));
        this.lastMouseHelper = WeedwoodRowboatHandler.MC.field_71417_B;
        WeedwoodRowboatHandler.MC.field_71417_B = new RowboatCamUpdater();
        this.view = View.ROWBOAT;
        WeedwoodRowboatHandler.MC.field_71474_y.field_74320_O = 0;
    }

    private void leaveRowboatPerspective() {
        MC.func_175607_a(null);
        if (WeedwoodRowboatHandler.MC.field_71417_B instanceof RowboatCamUpdater) {
            WeedwoodRowboatHandler.MC.field_71417_B = this.lastMouseHelper == null ? new MouseHelper() : this.lastMouseHelper;
        }
        this.lastMouseHelper = null;
        GuiIngameForge.renderCrosshairs = true;
        this.view = View.FIRST_PERSON;
        WeedwoodRowboatHandler.MC.field_71474_y.field_74320_O = 0;
    }

    private void onMacgyveredGameLoop() {
        EntityPlayerSP player = WeedwoodRowboatHandler.MC.field_71439_g;
        if (player == null) {
            this.isPlayerInRowboat = false;
            return;
        }
        Entity riding = player.func_184187_bx();
        if (riding instanceof EntityWeedwoodRowboat && riding.func_184179_bs() == player) {
            if (!this.isPlayerInRowboat) {
                player.field_70125_A = 0.0f;
                player.field_70127_C = 0.0f;
                player.field_70126_B = player.field_70177_z = MathHelper.func_76142_g((float)(riding.field_70177_z - 180.0f));
                player.field_70759_as = player.field_70177_z;
                player.field_70758_at = player.field_70177_z;
                riding.func_184232_k((Entity)player);
                player.field_70760_ar = player.field_70761_aq;
                player.field_70169_q = player.field_70142_S = player.field_70165_t;
                player.field_70167_r = player.field_70137_T = player.field_70163_u;
                player.field_70166_s = player.field_70136_U = player.field_70161_v;
                this.isPlayerInRowboat = true;
            }
        } else {
            this.isPlayerInRowboat = false;
        }
    }

    private class RowboatCam
    extends Entity {
        private final Matrix mat;
        public double dolly;

        public RowboatCam(World world, float yaw, float pitch) {
            super(world);
            this.mat = new Matrix();
            this.dolly = 5.0;
            this.field_70126_B = this.field_70177_z = yaw;
            this.field_70127_C = this.field_70125_A = pitch;
        }

        public float func_70047_e() {
            return 0.0f;
        }

        protected void func_70088_a() {
        }

        public void update(Entity rowboat, float delta) {
            double x = rowboat.field_70142_S + (rowboat.field_70165_t - rowboat.field_70142_S) * (double)delta;
            double y = rowboat.field_70137_T + (rowboat.field_70163_u - rowboat.field_70137_T) * (double)delta;
            double z = rowboat.field_70136_U + (rowboat.field_70161_v - rowboat.field_70136_U) * (double)delta;
            double offsetY = 1.12;
            this.mat.setIdentity();
            this.mat.translate(x, y + 1.12, z);
            this.mat.rotate(-this.field_70177_z * ((float)Math.PI / 180), 0.0, 1.0, 0.0);
            this.mat.rotate(this.field_70125_A * ((float)Math.PI / 180), 1.0, 0.0, 0.0);
            this.mat.translate(0.0, 0.0, -this.getDistance(this.field_70170_p, x, y + 1.12, z, this.field_70177_z, this.field_70125_A));
            Vec3d point = this.mat.transform(Vec3d.field_186680_a);
            this.field_70169_q = this.field_70165_t = point.field_72450_a;
            this.field_70142_S = this.field_70165_t;
            this.field_70167_r = this.field_70163_u = point.field_72448_b;
            this.field_70137_T = this.field_70163_u;
            this.field_70166_s = this.field_70161_v = point.field_72449_c;
            this.field_70136_U = this.field_70161_v;
        }

        private double getDistance(World world, double x, double y, double z, float yaw, float pitch) {
            double extent = this.dolly;
            float cosPitch = MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
            double extentX = (double)(-MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * cosPitch) * extent;
            double extentZ = (double)(MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * cosPitch) * extent;
            double extentY = (double)(-MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)))) * extent;
            for (int zyx = 0; zyx < 8; ++zyx) {
                double distance;
                float dx = (float)((zyx & 1) * 2 - 1) * 0.1f;
                float dy = (float)((zyx >> 1 & 1) * 2 - 1) * 0.1f;
                float dz = (float)((zyx >> 2 & 1) * 2 - 1) * 0.1f;
                RayTraceResult vector = world.func_147447_a(new Vec3d(x + (double)dx, y + (double)dy, z + (double)dz), new Vec3d(x - extentX + (double)dx, y - extentY + (double)dy, z - extentZ + (double)dz), false, true, false);
                if (vector == null || !((distance = vector.field_72307_f.func_72438_d(new Vec3d(x, y, z))) < extent)) continue;
                extent = distance;
            }
            return extent;
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }
    }

    private class RowboatCamUpdater
    extends MouseHelper {
        private RowboatCamUpdater() {
        }

        public void func_74374_c() {
            boolean reset = true;
            Entity entity = MC.func_175606_aa();
            if (entity instanceof RowboatCam) {
                RowboatCam cam = (RowboatCam)entity;
                EntityPlayerSP player = MC.field_71439_g;
                Entity riding = player.func_184187_bx();
                if (riding instanceof EntityWeedwoodRowboat) {
                    int deltaX = Mouse.getDX();
                    int deltaY = Mouse.getDY();
                    cam.field_70126_B = cam.field_70177_z = MathHelper.func_76142_g((float)(cam.field_70177_z + (float)deltaX * 0.15f));
                    cam.field_70127_C = cam.field_70125_A = MathHelper.func_76131_a((float)(cam.field_70125_A - (float)deltaY * 0.15f), (float)0.0f, (float)90.0f);
                    cam.update(riding, MC.func_184121_ak());
                    GuiIngameForge.renderCrosshairs = false;
                    reset = false;
                }
            }
            if (reset) {
                WeedwoodRowboatHandler.this.leaveRowboatPerspective();
            }
        }
    }

    private static enum View {
        FIRST_PERSON,
        ROWBOAT;

    }
}

