/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.handler;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thebetweenlands.common.item.BLMaterialRegistry;
import thebetweenlands.common.registries.BlockRegistry;

public class OverlayHandler {
    private static final ResourceLocation TAR_OVERLAY = new ResourceLocation("thebetweenlands", "textures/gui/overlay/tar.png");
    private static final ResourceLocation STAGNANT_WATER_OVERLAY = new ResourceLocation("thebetweenlands", "textures/gui/overlay/stagnant_water.png");

    private OverlayHandler() {
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderBlockOverlayEvent event) {
        if (event.getOverlayType() == RenderBlockOverlayEvent.OverlayType.WATER) {
            Minecraft mc = Minecraft.func_71410_x();
            IBlockState state = mc.field_71441_e.func_180495_p(new BlockPos((Entity)mc.field_71439_g));
            EntityPlayerSP player = mc.field_71439_g;
            for (int i = 0; i < 8; ++i) {
                double x = player.field_70165_t + (double)(((float)((i >> 0) % 2) - 0.5f) * player.field_70130_N * 0.8f);
                double y = player.field_70163_u + (double)(((float)((i >> 1) % 2) - 0.5f) * 0.1f);
                double z = player.field_70161_v + (double)(((float)((i >> 2) % 2) - 0.5f) * player.field_70130_N * 0.8f);
                BlockPos checkPos = new BlockPos(x, y + (double)player.func_70047_e(), z);
                IBlockState checkState = mc.field_71441_e.func_180495_p(checkPos);
                if (checkState.func_185904_a() != BLMaterialRegistry.TAR && checkState.func_185904_a() != Material.field_151586_h) continue;
                state = checkState;
            }
            if (state.func_177230_c() == BlockRegistry.TAR) {
                event.setCanceled(true);
                float brightness = mc.field_71439_g.func_70013_c();
                GlStateManager.func_179131_c((float)brightness, (float)brightness, (float)brightness, (float)0.99f);
                OverlayHandler.renderOverlay(TAR_OVERLAY);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else if (state.func_177230_c() == BlockRegistry.STAGNANT_WATER) {
                event.setCanceled(true);
                float brightness = mc.field_71439_g.func_70013_c();
                GlStateManager.func_179131_c((float)brightness, (float)brightness, (float)brightness, (float)0.99f);
                OverlayHandler.renderOverlay(STAGNANT_WATER_OVERLAY);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    private static void renderOverlay(ResourceLocation texture) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179094_E();
        float xOffset = -Minecraft.func_71410_x().field_71439_g.field_70177_z / 64.0f;
        float yOffset = Minecraft.func_71410_x().field_71439_g.field_70125_A / 64.0f;
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b(-1.0, -1.0, -0.5).func_187315_a((double)(4.0f + xOffset), (double)(4.0f + yOffset)).func_181675_d();
        vertexbuffer.func_181662_b(1.0, -1.0, -0.5).func_187315_a((double)(0.0f + xOffset), (double)(4.0f + yOffset)).func_181675_d();
        vertexbuffer.func_181662_b(1.0, 1.0, -0.5).func_187315_a((double)(0.0f + xOffset), (double)(0.0f + yOffset)).func_181675_d();
        vertexbuffer.func_181662_b(-1.0, 1.0, -0.5).func_187315_a((double)(4.0f + xOffset), (double)(0.0f + yOffset)).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
    }
}

