/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.gui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import thebetweenlands.api.capability.ISwarmedCapability;
import thebetweenlands.client.audio.SwarmAttackSound;
import thebetweenlands.client.gui.GuiCrawler;
import thebetweenlands.common.registries.CapabilityRegistry;

public class SwarmOverlayRenderer {
    private static final ResourceLocation SWARM_INDICATOR_OVERLAY_TEXTURE = new ResourceLocation("thebetweenlands:textures/gui/overlay/swarm_indicator_overlay.png");
    private final List<GuiCrawler> crawlers = new ArrayList<GuiCrawler>();
    private Random rand = new Random();
    private float prevSwarmStrength;
    private float swarmStrength;
    private int activeCrawlers;
    private int hurtTicks = 0;
    private ISound swarmAttackSound = null;

    public void update() {
        ISwarmedCapability cap;
        Entity view = Minecraft.func_71410_x().func_175606_aa();
        this.prevSwarmStrength = this.swarmStrength;
        this.swarmStrength = 0.0f;
        if (view != null && (cap = (ISwarmedCapability)view.getCapability(CapabilityRegistry.CAPABILITY_SWARMED, null)) != null) {
            this.swarmStrength = cap.getSwarmedStrength();
            if (this.swarmStrength > 0.05f) {
                SoundHandler soundHandler = Minecraft.func_71410_x().func_147118_V();
                if (this.swarmAttackSound == null || !soundHandler.func_147692_c(this.swarmAttackSound)) {
                    this.swarmAttackSound = new SwarmAttackSound();
                    soundHandler.func_147682_a(this.swarmAttackSound);
                }
            }
            if (this.hurtTicks == -1 && cap.getHurtTimer() > 0) {
                this.hurtTicks = 10;
            }
        }
        int maxAge = 80;
        int maxSpawns = (int)((this.swarmStrength <= 0.5f ? 2.0f / ((0.5f - this.swarmStrength) / 0.5f * 20.0f + 1.0f) : 0.5f * ((this.swarmStrength - 0.5f) / 0.5f * 20.0f + 1.0f)) * (float)maxAge);
        int prevActiveCrawlers = this.activeCrawlers;
        this.activeCrawlers = 0;
        int exceeding = prevActiveCrawlers - maxSpawns;
        Iterator<GuiCrawler> crawlersIt = this.crawlers.iterator();
        while (crawlersIt.hasNext()) {
            GuiCrawler crawler = crawlersIt.next();
            crawler.update(this.hurtTicks);
            if (crawler.dead) {
                crawlersIt.remove();
                continue;
            }
            if (crawler.dropping) continue;
            ++this.activeCrawlers;
            if (!(crawler.updateCounter < 70.0f) || this.rand.nextInt(20) != 0 || exceeding-- <= 0) continue;
            crawler.dropping = true;
        }
        if (this.swarmStrength > 0.01f) {
            int numSpawns = this.swarmStrength <= 0.5f ? (this.rand.nextInt((int)((0.5f - this.swarmStrength) / 0.5f * 20.0f + 1.0f)) == 0 ? 1 : 0) : (int)(this.rand.nextFloat() * (this.swarmStrength - 0.5f) / 0.5f * 20.0f) + 1;
            block7: for (int i = 0; i < numSpawns; ++i) {
                if (this.crawlers.size() >= maxSpawns) continue;
                ScaledResolution resolution = new ScaledResolution(Minecraft.func_71410_x());
                float margin = 20.0f;
                float speed = (1.0f + this.rand.nextFloat() * 3.0f) * 0.002f;
                switch (this.rand.nextInt(4)) {
                    case 0: {
                        this.crawlers.add(new GuiCrawler(-margin, this.rand.nextFloat() * (float)resolution.func_78328_b(), speed * (float)resolution.func_78326_a(), 0.0f));
                        continue block7;
                    }
                    case 1: {
                        this.crawlers.add(new GuiCrawler((float)resolution.func_78326_a() + margin, this.rand.nextFloat() * (float)resolution.func_78328_b(), -speed * (float)resolution.func_78326_a(), 0.0f));
                        continue block7;
                    }
                    case 2: {
                        this.crawlers.add(new GuiCrawler(this.rand.nextFloat() * (float)resolution.func_78326_a(), -margin, 0.0f, speed * (float)resolution.func_78328_b()));
                        continue block7;
                    }
                    case 3: {
                        this.crawlers.add(new GuiCrawler(this.rand.nextFloat() * (float)resolution.func_78326_a(), (float)resolution.func_78328_b() + margin, 0.0f, -speed * (float)resolution.func_78328_b()));
                    }
                }
            }
        }
        if (this.hurtTicks > -1) {
            --this.hurtTicks;
        }
    }

    public void render(float partialTicks) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-100.0f);
        if (this.crawlers.size() > 0) {
            ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
            float alpha = (this.prevSwarmStrength + (this.swarmStrength - this.prevSwarmStrength) * partialTicks) * 0.4f;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            GlStateManager.func_179092_a((int)516, (float)0.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(SWARM_INDICATOR_OVERLAY_TEXTURE);
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vertexbuffer.func_181662_b(0.0, res.func_78324_d(), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            vertexbuffer.func_181662_b(res.func_78327_c(), res.func_78324_d(), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            vertexbuffer.func_181662_b(res.func_78327_c(), 0.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
            vertexbuffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (GuiCrawler crawler : this.crawlers) {
            crawler.drawCrawler(Minecraft.func_71410_x(), vertexbuffer, partialTicks);
        }
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }
}

