/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.gui;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.handler.gallery.GalleryEntry;
import thebetweenlands.client.handler.gallery.GalleryManager;
import thebetweenlands.client.render.entity.RenderGalleryFrame;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.entity.EntityGalleryFrame;
import thebetweenlands.common.network.serverbound.MessageSetGalleryUrl;

public class GuiGalleryFrame
extends GuiScreen {
    protected static final double WIDTH = 200.0;
    protected static final double HEIGHT = 200.0;
    protected int xStart;
    protected int yStart;
    protected EntityGalleryFrame frame;
    protected GuiTextField searchField;
    protected int sourceUrlClickX;
    protected int sourceUrlClickWidth;
    protected int sourceUrlClickY;
    protected int sourceUrlClickHeight;
    protected int twitterUrlClickX;
    protected int twitterUrlClickWidth;
    protected int twitterUrlClickY;
    protected int twitterUrlClickHeight;
    protected int discordUrlClickX;
    protected int discordUrlClickWidth;
    protected int discordUrlClickY;
    protected int discordUrlClickHeight;
    protected String discordName = "Discord";
    protected String twitterName = "@BetweenlandsDev";
    protected String discordUrl = "https://discord.gg/5RwFZgT57p";
    protected String twitterUrl = "https://twitter.com/BetweenlandsDev";

    public GuiGalleryFrame(EntityGalleryFrame frame) {
        this.frame = frame;
    }

    public void func_73866_w_() {
        this.xStart = (this.field_146294_l - 200) / 2 - 100;
        this.yStart = (this.field_146295_m - 200) / 2;
        this.field_146292_n.add(new GuiButton(0, this.xStart - 60, this.yStart + 100, 30, 20, "<-"));
        this.field_146292_n.add(new GuiButton(1, this.xStart + 200 + 30, this.yStart + 100, 30, 20, "->"));
        this.field_146292_n.add(new GuiButton(2, this.xStart + 200 + 30, this.yStart + 200 - 40, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        GuiButton randomizeButton = new GuiButton(4, this.xStart + 200 + 30, this.yStart + 26 + 14, I18n.func_135052_a((String)"gui.gallery.random", (Object[])new Object[0]));
        this.field_146292_n.add(randomizeButton);
        this.searchField = new GuiTextField(3, this.field_146297_k.field_71466_p, this.xStart + 200 + 32, this.yStart + 14, 196, 20);
        this.searchField.func_146203_f(128);
        if (this.frame.getUrl().length() == 0) {
            try {
                this.func_146284_a(randomizeButton);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.searchField.func_146178_a();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        this.searchField.func_146201_a(typedChar, keyCode);
        if (this.searchField.func_146206_l()) {
            this.switchPicture(false, false);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.searchField.func_146192_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            if (mouseX >= this.sourceUrlClickX && mouseX < this.sourceUrlClickX + this.sourceUrlClickWidth && mouseY >= this.sourceUrlClickY && mouseY < this.sourceUrlClickY + this.sourceUrlClickHeight) {
                GalleryEntry entry = GalleryManager.INSTANCE.getEntries().get(this.frame.getUrl());
                if (entry != null && entry.getSourceUrl() != null) {
                    this.func_175276_a(new TextComponentString("").func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, entry.getSourceUrl()))));
                }
            } else if (mouseX >= this.discordUrlClickX && mouseX < this.discordUrlClickX + this.discordUrlClickWidth && mouseY >= this.discordUrlClickY && mouseY < this.discordUrlClickY + this.discordUrlClickHeight) {
                this.func_175276_a(new TextComponentString("").func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, this.discordUrl))));
            } else if (mouseX >= this.twitterUrlClickX && mouseX < this.twitterUrlClickX + this.twitterUrlClickWidth && mouseY >= this.twitterUrlClickY && mouseY < this.twitterUrlClickY + this.twitterUrlClickHeight) {
                this.func_175276_a(new TextComponentString("").func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, this.twitterUrl))));
            }
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        Map<String, GalleryEntry> available;
        super.func_146284_a(button);
        if (button.field_146127_k == 0 || button.field_146127_k == 1) {
            this.switchPicture(button.field_146127_k == 0, button.field_146127_k == 1);
        } else if (button.field_146127_k == 2) {
            this.field_146297_k.func_147108_a(null);
        } else if (button.field_146127_k == 4 && !(available = GalleryManager.INSTANCE.getEntries()).isEmpty()) {
            TheBetweenlands.networkWrapper.sendToServer((IMessage)new MessageSetGalleryUrl(this.frame, available.values().stream().skip(this.frame.field_70170_p.field_73012_v.nextInt(available.values().size())).findFirst().get().getUrl()));
        }
    }

    private boolean searchEntryText(GalleryEntry entry, String searchText) {
        return entry.getTitle().toLowerCase().contains(searchText) || entry.getAuthor().toLowerCase().contains(searchText) || entry.getDescription() != null && entry.getDescription().replaceAll("\n", " ").toLowerCase().contains(searchText) || entry.getSourceUrl() != null && entry.getSourceUrl().toLowerCase().contains(searchText) || entry.getSha256().toLowerCase().contains(searchText);
    }

    private void switchPicture(boolean prev, boolean next) {
        Map<String, GalleryEntry> available = GalleryManager.INSTANCE.getEntries();
        if (!available.isEmpty()) {
            GalleryEntry entry = available.get(this.frame.getUrl());
            GalleryEntry selectedEntry = null;
            ArrayList<GalleryEntry> availableList = new ArrayList<GalleryEntry>(available.values());
            String searchText = this.searchField.func_146179_b().toLowerCase();
            Collections.sort(availableList, (e1, e2) -> {
                boolean search1 = searchText.length() > 0 && this.searchEntryText((GalleryEntry)e1, searchText);
                boolean search2 = searchText.length() > 0 && this.searchEntryText((GalleryEntry)e2, searchText);
                return e1.getTitle().compareTo(e2.getTitle()) + (search1 ? -1000 : 0) + (search2 ? 1000 : 0);
            });
            if (entry == null || !prev && !next) {
                selectedEntry = (GalleryEntry)availableList.get(0);
            } else {
                int currentIndex = availableList.indexOf(entry);
                if (currentIndex >= 0) {
                    int newIndex;
                    int n = next ? currentIndex + 1 : (newIndex = prev ? currentIndex - 1 : currentIndex);
                    if (newIndex < 0) {
                        newIndex = availableList.size() + newIndex;
                    }
                    selectedEntry = (GalleryEntry)availableList.get(newIndex %= availableList.size());
                } else {
                    selectedEntry = (GalleryEntry)availableList.get(0);
                }
            }
            if (selectedEntry != null) {
                TheBetweenlands.networkWrapper.sendToServer((IMessage)new MessageSetGalleryUrl(this.frame, selectedEntry.getUrl()));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_73863_a(int mouseX, int mouseY, float renderPartials) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, renderPartials);
        this.searchField.func_146194_f();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        String searchStr = I18n.func_135052_a((String)"gui.gallery.search", (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(searchStr, this.xStart + 200 + 30 + 100 - this.field_146289_q.func_78256_a(searchStr) / 2, this.yStart, -1);
        GalleryEntry entry = GalleryManager.INSTANCE.getEntries().get(this.frame.getUrl());
        ResourceLocation pictureLocation = entry != null ? entry.loadTextureAndGetLocation(RenderGalleryFrame.GALLERY_FRAME_EMPTY_BACKGROUND) : RenderGalleryFrame.GALLERY_FRAME_EMPTY_BACKGROUND;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(pictureLocation);
        float relWidthMargin = 0.0f;
        float relHeightMargin = 0.0f;
        if (entry != null) {
            int maxDim = Math.max(entry.getWidth(), entry.getHeight());
            relWidthMargin = (float)(maxDim - entry.getWidth()) / (float)maxDim / 2.0f;
            relHeightMargin = (float)(maxDim - entry.getHeight()) / (float)maxDim / 2.0f;
        }
        this.drawTexture(this.xStart + (int)(200.0 * (double)relWidthMargin), this.yStart + (int)(200.0 * (double)relHeightMargin), 200 - (int)(200.0 * (double)relWidthMargin * 2.0), 200 - (int)(200.0 * (double)relHeightMargin * 2.0), 200.0, 200.0, 0.0, 200.0, 0.0, 200.0);
        if (entry != null) {
            this.field_146289_q.func_78276_b(TextFormatting.UNDERLINE.toString() + TextFormatting.BOLD.toString() + entry.getTitle(), this.xStart + 100 - this.field_146289_q.func_78256_a(TextFormatting.UNDERLINE.toString() + TextFormatting.BOLD.toString() + entry.getTitle()) / 2, this.yStart - 20, -1);
            int maxLineWidth = 0;
            String authorLine = I18n.func_135052_a((String)"gui.gallery.author", (Object[])new Object[0]);
            String authorText = authorLine + TextFormatting.RESET.toString() + entry.getAuthor();
            maxLineWidth = Math.max(maxLineWidth, this.field_146289_q.func_78256_a(authorText));
            String descName = I18n.func_135052_a((String)"gui.gallery.description", (Object[])new Object[0]);
            int descNameWidth = this.field_146289_q.func_78256_a(descName);
            String desc = entry.getDescription();
            String[] descLines = null;
            if (desc != null) {
                descLines = desc.split("\\n");
                for (int i = 0; i < descLines.length; ++i) {
                    maxLineWidth = i == 0 ? Math.max(maxLineWidth, this.field_146289_q.func_78256_a(descName + descLines[0])) : Math.max(maxLineWidth, this.field_146289_q.func_78256_a(descLines[i]) + descNameWidth);
                }
            }
            String sourceLine = null;
            if (entry.getSourceUrl() != null) {
                sourceLine = I18n.func_135052_a((String)"gui.gallery.source_url", (Object[])new Object[0]) + TextFormatting.RESET.toString() + I18n.func_135052_a((String)"gui.gallery.source_url_click", (Object[])new Object[0]);
                maxLineWidth = Math.max(maxLineWidth, this.field_146289_q.func_78256_a(sourceLine));
            }
            this.field_146289_q.func_78276_b(authorText, this.xStart + 100 - maxLineWidth / 2, this.yStart + 200 + 8, -1);
            int yOff = 0;
            if (descLines != null) {
                for (int i = 0; i < descLines.length; ++i) {
                    if (i == 0) {
                        this.field_146289_q.func_78276_b(descName + TextFormatting.RESET.toString() + descLines[0], this.xStart + 100 - maxLineWidth / 2, this.yStart + 200 + 23 + yOff, -1);
                    } else {
                        this.field_146289_q.func_78276_b(descLines[i], this.xStart + descNameWidth + 100 - maxLineWidth / 2, this.yStart + 200 + 23 + yOff, -1);
                    }
                    yOff += 12;
                }
            }
            if (sourceLine != null) {
                this.field_146289_q.func_78276_b(sourceLine, this.xStart + 100 - maxLineWidth / 2, this.yStart + 200 + 26 + yOff, -1);
                this.sourceUrlClickX = this.xStart + 100 - maxLineWidth / 2 + this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"gui.gallery.source_url", (Object[])new Object[0]));
                this.sourceUrlClickY = this.yStart + 200 + 26 + yOff;
                this.sourceUrlClickWidth = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"gui.gallery.source_url_click", (Object[])new Object[0]));
                this.sourceUrlClickHeight = 10;
            }
            yOff = 0;
            String submissionText = I18n.func_135052_a((String)"gui.gallery.submission", (Object[])new Object[0]);
            if (submissionText.contains("{twitter}") && submissionText.contains("{discord}")) {
                String[] lines;
                for (String line : lines = submissionText.split("\\\\n")) {
                    String[] sp1;
                    ArrayList<String> segments = new ArrayList<String>();
                    for (String s1 : sp1 = line.split("((?<=\\{twitter\\})|(?=\\{twitter\\}))")) {
                        String[] sp2;
                        for (String s2 : sp2 = s1.split("((?<=\\{discord\\})|(?=\\{discord\\}))")) {
                            segments.add(s2);
                        }
                    }
                    int xOff = 0;
                    Iterator iterator = segments.iterator();
                    while (iterator.hasNext()) {
                        String segment;
                        String segmentTxt = segment = (String)iterator.next();
                        int sx = this.xStart + 100 + xOff;
                        int sy = this.yStart - 90 + yOff;
                        if (segmentTxt.equals("{twitter}")) {
                            segmentTxt = ChatFormatting.BLUE.toString() + ChatFormatting.UNDERLINE.toString() + ChatFormatting.ITALIC.toString() + this.twitterName;
                            this.twitterUrlClickX = sx;
                            this.twitterUrlClickY = sy;
                            this.twitterUrlClickWidth = this.field_146289_q.func_78256_a(segmentTxt);
                            this.twitterUrlClickHeight = 10;
                        } else if (segmentTxt.equals("{discord}")) {
                            segmentTxt = ChatFormatting.BLUE.toString() + ChatFormatting.UNDERLINE.toString() + ChatFormatting.ITALIC.toString() + this.discordName;
                            this.discordUrlClickX = sx;
                            this.discordUrlClickY = sy;
                            this.discordUrlClickWidth = this.field_146289_q.func_78256_a(segmentTxt);
                            this.discordUrlClickHeight = 10;
                        }
                        this.field_146289_q.func_78276_b(segmentTxt, sx, sy, -1);
                        xOff += this.field_146289_q.func_78256_a(segmentTxt);
                    }
                    yOff += 12;
                }
            }
        } else {
            String notFoundText = I18n.func_135052_a((String)"gui.gallery.info_not_found", (Object[])new Object[0]);
            this.field_146289_q.func_78276_b(notFoundText, this.xStart + 100 - this.field_146289_q.func_78256_a(notFoundText) / 2, this.yStart + 200 + 12, -1);
        }
    }

    private void drawTexture(int xStart, int yStart, int width, int height, double textureWidth, double textureHeight, double textureXStart, double textureXEnd, double textureYStart, double textureYEnd) {
        double umin = 1.0 / textureWidth * textureXStart;
        double umax = 1.0 / textureWidth * textureXEnd;
        double vmin = 1.0 / textureHeight * textureYStart;
        double vmax = 1.0 / textureHeight * textureYEnd;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)xStart, (double)yStart, 0.0).func_187315_a(umin, vmin).func_181675_d();
        buffer.func_181662_b((double)xStart, (double)(yStart + height), 0.0).func_187315_a(umin, vmax).func_181675_d();
        buffer.func_181662_b((double)(xStart + width), (double)(yStart + height), 0.0).func_187315_a(umax, vmax).func_181675_d();
        buffer.func_181662_b((double)(xStart + width), (double)yStart, 0.0).func_187315_a(umax, vmin).func_181675_d();
        tessellator.func_78381_a();
    }

    public boolean func_73868_f() {
        return false;
    }
}

