/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import thebetweenlands.common.entity.mobs.EntityAnadia;
import thebetweenlands.common.entity.projectiles.EntityBLFishHook;
import thebetweenlands.util.Stencil;

@SideOnly(value=Side.CLIENT)
public class GuiFishStaminaBar
extends Gui {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("thebetweenlands:textures/gui/fish_stamina_bar.png");
    public static final ResourceLocation GUI_FISHING_LINE = new ResourceLocation("thebetweenlands:textures/gui/fishing_line.png");

    @SubscribeEvent
    public void onRenderHUD(RenderGameOverlayEvent.Post event) {
        EntityPlayerSP player;
        Minecraft mc = Minecraft.func_71410_x();
        if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.HOTBAR) && (player = mc.field_71439_g) != null && player.field_71104_cf != null && player.field_71104_cf instanceof EntityBLFishHook && player.field_71104_cf.func_184218_aH() && player.field_71104_cf.func_184187_bx() instanceof EntityAnadia) {
            int fishpos = ((EntityAnadia)player.field_71104_cf.func_184187_bx()).getStaminaTicks() * 256 / 180;
            int escapepos = ((EntityAnadia)player.field_71104_cf.func_184187_bx()).getEscapeTicks() * 256 / 1024;
            int helpMe = (int)((EntityAnadia)player.field_71104_cf.func_184187_bx()).getStaminaMods() * 30;
            int escapeDelay = ((EntityAnadia)player.field_71104_cf.func_184187_bx()).getEscapeDelay();
            int obstructpos1 = ((EntityAnadia)player.field_71104_cf.func_184187_bx()).getObstruction1Ticks();
            int obstructpos2 = ((EntityAnadia)player.field_71104_cf.func_184187_bx()).getObstruction2Ticks();
            int obstructpos3 = ((EntityAnadia)player.field_71104_cf.func_184187_bx()).getObstruction3Ticks();
            int obstructpos4 = ((EntityAnadia)player.field_71104_cf.func_184187_bx()).getObstruction4Ticks() * 256 / 512;
            int treasurePos = ((EntityAnadia)player.field_71104_cf.func_184187_bx()).getTreasureTicks() * 256 / 1024;
            boolean showTreasure = ((EntityAnadia)player.field_71104_cf.func_184187_bx()).isTreasureFish();
            boolean treasureUnlocked = ((EntityAnadia)player.field_71104_cf.func_184187_bx()).getTreasureUnlocked();
            int aniFrame = ((EntityAnadia)player.field_71104_cf.func_184187_bx()).animationFrame;
            int aniFrameCrab = ((EntityAnadia)player.field_71104_cf.func_184187_bx()).animationFrameCrab;
            mc.field_71446_o.func_110577_a(GUI_TEXTURE);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ScaledResolution res = new ScaledResolution(mc);
            if (((EntityAnadia)player.field_71104_cf.func_184187_bx()).getStaminaTicks() <= 0) {
                this.renderNetBar((float)res.func_78326_a() * 0.5f - 128.0f, (float)res.func_78328_b() * 0.5f - 120.0f, 240, 4, aniFrame);
            } else {
                this.renderStaminaBar(-256 + fishpos, -256 + Math.min(256, escapepos), escapeDelay < 10 ? escapeDelay : 10, 0 - obstructpos1, 0 - obstructpos2, 0 - obstructpos3, 0 - obstructpos4, 0 - treasurePos, showTreasure, treasureUnlocked, (float)res.func_78326_a() * 0.5f - 128.0f, (float)res.func_78328_b() * 0.5f - 120.0f, aniFrame, aniFrameCrab);
            }
        }
    }

    private void renderNetBar(float posX, float posY, int netIconX, int netIconY, int netframe) {
        this.func_175174_a(posX + (float)netIconX, posY + (float)netIconY, 0 + netframe * 2, 160, 32, 16);
    }

    private void renderStaminaBar(int staminaTicks, int escapeTicks, int escapeDelay, int obstructionTicks1, int obstructionTicks2, int obstructionTicks3, int obstructionTicks4, int treasureTick, boolean hasTreasure, boolean treasureUnlocked, float posX, float posY, int aniFrame, int aniFrameCrab) {
        Minecraft mc = Minecraft.func_71410_x();
        Framebuffer fbo = mc.func_147110_a();
        this.func_175174_a(posX, posY + 2.0f, 0, 0, 256, 25);
        try (Stencil stencil = Stencil.reserve(fbo);){
            if (stencil.valid()) {
                GL11.glEnable((int)2960);
                stencil.clear(false);
                stencil.func(519, true);
                stencil.op(7681, 7680, 7681);
                GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                this.func_175174_a(posX + 4.0f, posY, 4, 25, 248, 19);
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                stencil.func(514, true);
                stencil.op(7680);
            }
            if (hasTreasure) {
                this.func_175174_a(posX - (float)treasureTick, posY + 1.0f, treasureUnlocked ? 16 : 0, 128, 16, 16);
            }
            GuiFishStaminaBar.drawHangingRope(staminaTicks, posX - (float)staminaTicks + 7.0f, posY + 12.0f, posX + 256.0f + 16.0f, posY, 0.5f, 0.0);
            mc.field_71446_o.func_110577_a(GUI_TEXTURE);
            this.func_175174_a(posX - (float)staminaTicks - 8.0f, posY + 1.0f, 0 + aniFrame, 48, 16, 16);
            this.func_175174_a(posX - (float)obstructionTicks4 - 8.0f, posY + 2.0f, 0 + aniFrame, 112, 16, 16);
            this.func_175174_a(posX - (float)escapeTicks - 8.0f, posY + 2.0f + (float)escapeDelay, escapeDelay < 10 ? aniFrameCrab : aniFrame, 144, 16, 16);
            this.func_175174_a(posX - (float)obstructionTicks1 - 8.0f, posY, 0 + aniFrame, 64, 16, 16);
            this.func_175174_a(posX - (float)obstructionTicks3 - 8.0f, posY, 0 + aniFrame, 96, 16, 16);
            this.func_175174_a(posX - (float)obstructionTicks2 - 8.0f, posY, 0 + aniFrame, 80, 16, 16);
            GL11.glDisable((int)2960);
        }
    }

    public static void drawHangingRope(int updateCounter, float sx, float sy, float ex, float ey, float hang, double zLevel) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(GUI_FISHING_LINE);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        float x1 = sx;
        float y1 = sy;
        float x3 = ex;
        float y3 = ey;
        if (x1 - x3 >= 0.0f && x1 - x3 < 1.0f) {
            x3 = x1 + 1.0f;
        } else if (x1 - x3 < 0.0f && x1 - x3 > -1.0f) {
            x3 = x1 - 1.0f;
        }
        float x2 = (x1 + x3) / 2.0f;
        float y2 = Math.max(y1, y3) + hang + (float)Math.sin(((float)updateCounter + mc.func_184121_ak()) / 25.0f) * 1.5f;
        float a1 = -x1 * x1 + x2 * x2;
        float b1 = -x1 + x2;
        float d1 = -y1 + y2;
        float a2 = -x2 * x2 + x3 * x3;
        float b2 = -x2 + x3;
        float d2 = -y2 + y3;
        float b3 = -b2 / b1;
        float a3 = b3 * a1 + a2;
        float d = b3 * d1 + d2;
        float a = d / a3;
        float b = (d1 - a1 * a) / b1;
        float c = y1 - a * x1 * x1 - b * x1;
        float px = x1;
        float py = y1;
        float width = 0.75f;
        float pxc1 = x1 - width;
        float pyc1 = y1;
        float pxc2 = x1 + width;
        float pyc2 = y1;
        boolean isTowardsRight = x1 < x3;
        float ropeV1 = isTowardsRight ? 0.0f : 0.5f;
        float ropeV2 = isTowardsRight ? 0.5f : 0.0f;
        float endV1 = isTowardsRight ? 0.5f : 1.0f;
        float endV2 = isTowardsRight ? 1.0f : 0.5f;
        float endU11 = isTowardsRight ? 0.0f : 1.0f;
        float endU12 = isTowardsRight ? 0.5f : 0.5f;
        float endU21 = isTowardsRight ? 0.5f : 0.5f;
        float endU22 = isTowardsRight ? 1.0f : 0.0f;
        float u = 0.0f;
        buffer.func_181668_a(5, DefaultVertexFormats.field_181707_g);
        int pieces = 32;
        for (int i = -1; i <= pieces; ++i) {
            float offY;
            float offX;
            float x = x1 + (x3 - x1) / (float)(pieces - 1) * (float)i;
            float y = a * x * x + b * x + c;
            float sideX = y - py;
            float sideY = -(x - px);
            float sideDirLength = (float)Math.sqrt(sideX * sideX + sideY * sideY);
            float xc1 = x - (sideX *= width / sideDirLength);
            float yc1 = y - (sideY *= width / sideDirLength);
            float xc2 = x + sideX;
            float yc2 = y + sideY;
            if (i == 1) {
                offX = -sideY / width * 8.0f;
                offY = sideX / width * 8.0f;
                buffer.func_181662_b((double)(pxc2 - offX), (double)(pyc2 - offY), zLevel).func_187315_a((double)endU11, (double)endV1).func_181675_d();
                buffer.func_181662_b((double)(pxc1 - offX), (double)(pyc1 - offY), zLevel).func_187315_a((double)endU11, (double)endV2).func_181675_d();
                buffer.func_181662_b((double)pxc2, (double)pyc2, zLevel).func_187315_a((double)endU12, (double)endV1).func_181675_d();
                buffer.func_181662_b((double)pxc1, (double)pyc1, zLevel).func_187315_a((double)endU12, (double)endV2).func_181675_d();
            }
            if (i > 0) {
                buffer.func_181662_b((double)pxc2, (double)pyc2, zLevel).func_187315_a((double)u, (double)ropeV1).func_181675_d();
                buffer.func_181662_b((double)pxc1, (double)pyc1, zLevel).func_187315_a((double)u, (double)ropeV2).func_181675_d();
                u += (float)Math.sqrt((x - px) * (x - px) + (y - py) * (y - py)) / 16.0f;
            }
            if (i == pieces) {
                offX = -sideY / width * 8.0f;
                offY = sideX / width * 8.0f;
                buffer.func_181662_b((double)pxc2, (double)pyc2, zLevel).func_187315_a((double)endU21, (double)endV1).func_181675_d();
                buffer.func_181662_b((double)pxc1, (double)pyc1, zLevel).func_187315_a((double)endU21, (double)endV2).func_181675_d();
                buffer.func_181662_b((double)(pxc2 + offX), (double)(pyc2 + offY), zLevel).func_187315_a((double)endU22, (double)endV1).func_181675_d();
                buffer.func_181662_b((double)(pxc1 + offX), (double)(pyc1 + offY), zLevel).func_187315_a((double)endU22, (double)endV2).func_181675_d();
            }
            px = x;
            py = y;
            pxc1 = xc1;
            pyc1 = yc1;
            pxc2 = xc2;
            pyc2 = yc2;
        }
        tessellator.func_78381_a();
    }
}

