/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.api.storage;

import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import thebetweenlands.api.storage.ILocalStorageHandle;
import thebetweenlands.api.storage.LocalRegion;
import thebetweenlands.api.storage.StorageID;

public class LocalStorageReference {
    private final ChunkPos chunkPos;
    private final StorageID id;
    private final LocalRegion region;
    private final ILocalStorageHandle handle;

    public LocalStorageReference(ChunkPos chunkPos, StorageID id, @Nullable LocalRegion region) {
        this.id = id;
        this.chunkPos = chunkPos;
        this.region = region;
        this.handle = null;
    }

    public LocalStorageReference(ILocalStorageHandle handle, StorageID id, @Nullable LocalRegion region) {
        this.id = id;
        this.chunkPos = new ChunkPos(0, 0);
        this.region = region;
        this.handle = handle;
    }

    public static LocalStorageReference readFromNBT(NBTTagCompound nbt) {
        ChunkPos pos = new ChunkPos(nbt.func_74762_e("x"), nbt.func_74762_e("z"));
        LocalRegion region = null;
        if (nbt.func_74764_b("region")) {
            region = LocalRegion.readFromNBT(nbt.func_74775_l("region"));
        }
        return new LocalStorageReference(pos, StorageID.readFromNBT(nbt), region);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        this.id.writeToNBT(nbt);
        nbt.func_74768_a("x", this.chunkPos.field_77276_a);
        nbt.func_74768_a("z", this.chunkPos.field_77275_b);
        if (this.region != null) {
            nbt.func_74782_a("region", (NBTBase)this.region.writeToNBT(new NBTTagCompound()));
        }
        return nbt;
    }

    @Nullable
    public ILocalStorageHandle getHandle() {
        return this.handle;
    }

    public StorageID getID() {
        return this.id;
    }

    @Nullable
    public LocalRegion getRegion() {
        return this.region;
    }

    public boolean hasRegion() {
        return this.region != null;
    }

    public ChunkPos getChunk() {
        return this.chunkPos;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.chunkPos == null ? 0 : this.chunkPos.hashCode());
        result = 31 * result + (this.handle == null ? 0 : this.handle.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocalStorageReference other = (LocalStorageReference)obj;
        if (this.chunkPos == null ? other.chunkPos != null : !this.chunkPos.equals((Object)other.chunkPos)) {
            return false;
        }
        if (this.handle == null ? other.handle != null : !this.handle.equals(other.handle)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.region == null ? other.region != null : !this.region.equals(other.region));
    }
}

