@echo off
set FORGE_VERSION=47.4.9
:: To use a specific Java runtime, set an environment variable named IRR_JAVA to the full path of java.exe.
:: To disable automatic restarts, set an environment variable named IRR_RESTART to false.
:: To install the pack without starting the server, set an environment variable named IRR_INSTALL_ONLY to true.

set INSTALLER="%~dp0forge-1.20.1-%FORGE_VERSION%-installer.jar"
set FORGE_URL="https://maven.minecraftforge.net/net/minecraftforge/forge/1.20.1-%FORGE_VERSION%/forge-1.20.1-%FORGE_VERSION%-installer.jar"

:JAVA
if not defined IRR_JAVA (
    set IRR_JAVA=java
)

"%IRR_JAVA%" -version 1>nul 2>nul || (
   echo Minecraft 1.20.1 requires Java 17 - Java not found
   pause
   exit /b 1
)

:FORGE
setlocal
cd /D "%~dp0"
if not exist "libraries" (
    echo Forge not installed, installing now.
    if not exist %INSTALLER% (
        echo No Forge installer found, downloading from %FORGE_URL%
        bitsadmin.exe /rawreturn /nowrap /transfer forgeinstaller /download /priority FOREGROUND %FORGE_URL% %INSTALLER%
    )
    
    echo Running Forge installer.
    "%IRR_JAVA%" -jar %INSTALLER% -installServer
)

if not exist "server.properties" (
    (
        echo allow-flight=true
	echo difficulty=normal
        echo motd=The Immersive Revolution: Rebirth Server
        echo max-tick-time=60000
	echo max-players=20
    )> "server.properties"
)

if "%IRR_INSTALL_ONLY%" == "true" (
    echo INSTALL_ONLY: complete
    goto:EOF
)

for /f tokens^=2-5^ delims^=.-_^" %%j in ('"%IRR_JAVA%" -fullversion 2^>^&1') do set "jver=%%j"
if not %jver% geq 17  (
    echo Minecraft 1.20.1 requires Java 17 - found Java %jver%
    pause
    exit /b 1
) 

:START
"%IRR_JAVA%" @user_jvm_args.txt @libraries/net/minecraftforge/forge/1.20.1-%FORGE_VERSION%/win_args.txt nogui

if "%IRR_RESTART%" == "false" ( 
    goto:EOF 
)

echo Restarting automatically in 30 seconds (press Ctrl + C to cancel)
timeout /t 30 /nobreak > NUL
goto:START
