/// <reference path="./internal_*.d.ts" />
declare namespace net.blay09.mods.netherportalfix.mixin {
    interface EntityAccessor {
        abstract getIsInsidePortal(): boolean;
        get isInsidePortal(): boolean
        (): boolean;
    }
    type EntityAccessor_ = EntityAccessor | (()=> boolean);
}
declare namespace Internal {
    abstract class WorldCarver <C extends Internal.CarverConfiguration> {
        constructor(arg0: Internal.Codec_<C>)
        getClass(): typeof any;
        toString(): string;
        notifyAll(): void;
        configuredCodec(): Internal.Codec<Internal.ConfiguredWorldCarver<C>>;
        getRange(): number;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        hashCode(): number;
        configured(arg0: C): Internal.ConfiguredWorldCarver<C>;
        wait(): void;
        abstract isStartChunk(arg0: C, arg1: Internal.RandomSource_): boolean;
        wait(arg0: number): void;
        abstract carve(arg0: Internal.CarvingContext_, arg1: C, arg2: Internal.ChunkAccess_, arg3: Internal.Function_<BlockPos, Internal.Holder<Internal.Biome>>, arg4: Internal.RandomSource_, arg5: Internal.Aquifer_, arg6: Internal.ChunkPos_, arg7: Internal.CarvingMask_): boolean;
        equals(arg0: any): boolean;
        get class(): typeof any
        get range(): number
        static readonly CANYON: (Internal.CanyonWorldCarver) & (Internal.WorldCarver<Internal.CanyonCarverConfiguration>);
        static readonly NETHER_CAVE: (Internal.NetherWorldCarver) & (Internal.WorldCarver<Internal.CaveCarverConfiguration>);
        static readonly CAVE: (Internal.CaveWorldCarver) & (Internal.WorldCarver<Internal.CaveCarverConfiguration>);
    }
    type WorldCarver_<C extends Internal.CarverConfiguration> = WorldCarver<C> | Special.Carver;
    class TransformRecipeSerializer implements Internal.RecipeSerializer<Internal.TransformRecipe> {
        getClass(): typeof any;
        toNetwork(arg0: Internal.FriendlyByteBuf_, arg1: Internal.TransformRecipe_): void;
        "fromNetwork(net.minecraft.resources.ResourceLocation,net.minecraft.network.FriendlyByteBuf)"(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): Internal.Recipe<any>;
        toString(): string;
        "toNetwork(net.minecraft.network.FriendlyByteBuf,net.minecraft.world.item.crafting.Recipe)"(arg0: Internal.FriendlyByteBuf_, arg1: Internal.Recipe_<any>): void;
        notifyAll(): void;
        fromNetwork(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): Internal.TransformRecipe;
        "toNetwork(net.minecraft.network.FriendlyByteBuf,appeng.recipes.transform.TransformRecipe)"(arg0: Internal.FriendlyByteBuf_, arg1: Internal.TransformRecipe_): void;
        toNetwork(arg0: Internal.FriendlyByteBuf_, arg1: Internal.Recipe_<any>): void;
        notify(): void;
        "fromJson(net.minecraft.resources.ResourceLocation,com.google.gson.JsonObject)"(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
        wait(arg0: number, arg1: number): void;
        "fromNetwork(net.minecraft.resources.ResourceLocation,net.minecraft.network.FriendlyByteBuf)"(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): Internal.TransformRecipe;
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>(arg0: string, arg1: S): S;
        hashCode(): number;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
        wait(): void;
        wait(arg0: number): void;
        "fromJson(net.minecraft.resources.ResourceLocation,com.google.gson.JsonObject)"(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.TransformRecipe;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.TransformRecipe;
        equals(arg0: any): boolean;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_, arg2: Internal.ICondition$IContext_): Internal.TransformRecipe;
        fromNetwork(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): Internal.Recipe<any>;
        get class(): typeof any
        static readonly INSTANCE: (Internal.TransformRecipeSerializer) & (Internal.TransformRecipeSerializer);
    }
    type TransformRecipeSerializer_ = TransformRecipeSerializer;
    abstract class Sensor <E extends Internal.LivingEntity> {
        constructor()
        constructor(arg0: number)
        getClass(): typeof any;
        toString(): string;
        static isEntityTargetable(arg0: Internal.LivingEntity_, arg1: Internal.LivingEntity_): boolean;
        notifyAll(): void;
        static isEntityAttackableIgnoringLineOfSight(arg0: Internal.LivingEntity_, arg1: Internal.LivingEntity_): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        hashCode(): number;
        wait(): void;
        static isEntityAttackable(arg0: Internal.LivingEntity_, arg1: Internal.LivingEntity_): boolean;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        abstract requires(): Internal.Set<Internal.MemoryModuleType<any>>;
        tick(arg0: Internal.ServerLevel_, arg1: E): void;
        get class(): typeof any
    }
    type Sensor_<E extends Internal.LivingEntity> = Sensor<E>;
    class DensityFunctions$ShiftedNoise extends Internal.Record implements Internal.DensityFunction {
        getClass(): typeof any;
        abs(): Internal.DensityFunction;
        compute(arg0: Internal.DensityFunction$FunctionContext_): number;
        squeeze(): Internal.DensityFunction;
        square(): Internal.DensityFunction;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        mapAll(arg0: Internal.DensityFunction$Visitor_): Internal.DensityFunction;
        clamp(arg0: number, arg1: number): Internal.DensityFunction;
        quarterNegative(): Internal.DensityFunction;
        shiftX(): Internal.DensityFunction;
        cube(): Internal.DensityFunction;
        shiftZ(): Internal.DensityFunction;
        fillArray(arg0: number[], arg1: Internal.DensityFunction$ContextProvider_): void;
        shiftY(): Internal.DensityFunction;
        halfNegative(): Internal.DensityFunction;
        toString(): string;
        maxValue(): number;
        notifyAll(): void;
        codec(): Internal.KeyDispatchDataCodec<Internal.DensityFunction>;
        xzScale(): number;
        hashCode(): number;
        wait(): void;
        noise(): Internal.DensityFunction$NoiseHolder;
        wait(arg0: number): void;
        yScale(): number;
        minValue(): number;
        equals(arg0: any): boolean;
        get class(): typeof any
        static readonly CODEC: Internal.KeyDispatchDataCodec<Internal.DensityFunctions$ShiftedNoise>;
    }
    type DensityFunctions$ShiftedNoise_ = DensityFunctions$ShiftedNoise;
    class VirtualScreen implements Internal.AutoCloseable {
        constructor(arg0: Internal.Minecraft_)
        getClass(): typeof any;
        hashCode(): number;
        newWindow(arg0: Internal.DisplayData_, arg1: string, arg2: string): com.mojang.blaze3d.platform.Window;
        toString(): string;
        wait(): void;
        close(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        get class(): typeof any
    }
    type VirtualScreen_ = VirtualScreen;
    class ServerboundPongPacket implements Internal.Packet<Internal.ServerGamePacketListener> {
        constructor(arg0: Internal.FriendlyByteBuf_)
        constructor(arg0: number)
        handle(arg0: Internal.PacketListener_): void;
        getClass(): typeof any;
        write(arg0: Internal.FriendlyByteBuf_): void;
        handle(arg0: Internal.ServerGamePacketListener_): void;
        toString(): string;
        notifyAll(): void;
        notify(): void;
        isSkippable(): boolean;
        wait(arg0: number, arg1: number): void;
        "handle(net.minecraft.network.protocol.game.ServerGamePacketListener)"(arg0: Internal.ServerGamePacketListener_): void;
        hashCode(): number;
        wait(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        "handle(net.minecraft.network.PacketListener)"(arg0: Internal.PacketListener_): void;
        getId(): number;
        get class(): typeof any
        get skippable(): boolean
        get id(): number
    }
    type ServerboundPongPacket_ = ServerboundPongPacket;
    class Options implements Internal.AccessOptions {
        constructor(arg0: Internal.Minecraft_, arg1: Internal.File_)
        panoramaSpeed(): Internal.OptionInstance<number>;
        touchscreen(): Internal.OptionInstance<boolean>;
        biomeBlendRadius(): Internal.OptionInstance<number>;
        handler$zib000$loadSelectedResourcePacks(arg0: Internal.PackRepository_, arg1: Internal.CallbackInfo_): void;
        cloudStatus(): Internal.OptionInstance<Internal.CloudStatus>;
        guiScale(): Internal.OptionInstance<number>;
        chatOpacity(): Internal.OptionInstance<number>;
        hideLightningFlash(): Internal.OptionInstance<boolean>;
        chatColors(): Internal.OptionInstance<boolean>;
        notificationDisplayTime(): Internal.OptionInstance<number>;
        glintSpeed(): Internal.OptionInstance<number>;
        ambientOcclusion(): Internal.OptionInstance<boolean>;
        chatWidth(): Internal.OptionInstance<number>;
        simulationDistance(): Internal.OptionInstance<number>;
        chatDelay(): Internal.OptionInstance<number>;
        soundDevice(): Internal.OptionInstance<string>;
        chatLinks(): Internal.OptionInstance<boolean>;
        getSoundSourceVolume(arg0: Internal.SoundSource_): number;
        getCloudsType(): Internal.CloudStatus;
        autoSuggestions(): Internal.OptionInstance<boolean>;
        gamma(): Internal.OptionInstance<number>;
        screenEffectScale(): Internal.OptionInstance<number>;
        textBackgroundOpacity(): Internal.OptionInstance<number>;
        toggleSprint(): Internal.OptionInstance<boolean>;
        getClass(): typeof any;
        setCameraType(arg0: Internal.CameraType_): void;
        showAutosaveIndicator(): Internal.OptionInstance<boolean>;
        autoJump(): Internal.OptionInstance<boolean>;
        reducedDebugInfo(): Internal.OptionInstance<boolean>;
        useNativeTransport(): boolean;
        bobView(): Internal.OptionInstance<boolean>;
        getEffectiveRenderDistance(): number;
        operatorItemsTab(): Internal.OptionInstance<boolean>;
        chatHeightFocused(): Internal.OptionInstance<number>;
        load(): void;
        glintStrength(): Internal.OptionInstance<number>;
        setKey(arg0: Internal.KeyMapping_, arg1: Internal.InputConstants$Key_): void;
        toString(): string;
        fov(): Internal.OptionInstance<number>;
        static "genericValueLabel(net.minecraft.network.chat.Component,net.minecraft.network.chat.Component)"(arg0: net.minecraft.network.chat.Component_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        getSoundSourceOptionInstance(arg0: Internal.SoundSource_): Internal.OptionInstance<number>;
        notifyAll(): void;
        mipmapLevels(): Internal.OptionInstance<number>;
        chatHeightUnfocused(): Internal.OptionInstance<number>;
        updateResourcePacks(arg0: Internal.PackRepository_): void;
        save(): void;
        rawMouseInput(): Internal.OptionInstance<boolean>;
        wait(arg0: number): void;
        fovEffectScale(): Internal.OptionInstance<number>;
        invertYMouse(): Internal.OptionInstance<boolean>;
        dumpOptionsForReport(): string;
        chatLinksPrompt(): Internal.OptionInstance<boolean>;
        getBackgroundColor(arg0: number): number;
        backgroundForChatOnly(): Internal.OptionInstance<boolean>;
        entityShadows(): Internal.OptionInstance<boolean>;
        damageTiltStrength(): Internal.OptionInstance<number>;
        mouseWheelSensitivity(): Internal.OptionInstance<number>;
        notify(): void;
        telemetryOptInExtra(): Internal.OptionInstance<boolean>;
        attackIndicator(): Internal.OptionInstance<Internal.AttackIndicatorStatus>;
        framerateLimit(): Internal.OptionInstance<number>;
        chatScale(): Internal.OptionInstance<number>;
        darknessEffectScale(): Internal.OptionInstance<number>;
        setServerRenderDistance(arg0: number): void;
        highContrast(): Internal.OptionInstance<boolean>;
        broadcastOptions(): void;
        mainHand(): Internal.OptionInstance<Internal.HumanoidArm>;
        "getBackgroundColor(int)"(arg0: number): number;
        tipthescales$setGuiScale(arg0: Internal.OptionInstance_<any>): void;
        particles(): Internal.OptionInstance<Internal.ParticleStatus>;
        static genericValueLabel(arg0: net.minecraft.network.chat.Component_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        handler$zok001$init(arg0: Internal.CallbackInfo_): void;
        onlyShowSecureChat(): Internal.OptionInstance<boolean>;
        realmsNotifications(): Internal.OptionInstance<boolean>;
        getFile(): Internal.File;
        prioritizeChunkUpdates(): Internal.OptionInstance<Internal.PrioritizeChunkUpdates>;
        static "genericValueLabel(net.minecraft.network.chat.Component,int)"(arg0: net.minecraft.network.chat.Component_, arg1: number): net.minecraft.network.chat.Component;
        getBackgroundColor(arg0: number): number;
        loadSelectedResourcePacks(arg0: Internal.PackRepository_): void;
        wait(): void;
        entityDistanceScaling(): Internal.OptionInstance<number>;
        enableVsync(): Internal.OptionInstance<boolean>;
        fullscreen(): Internal.OptionInstance<boolean>;
        showSubtitles(): Internal.OptionInstance<boolean>;
        discreteMouseScroll(): Internal.OptionInstance<boolean>;
        isModelPartEnabled(arg0: Internal.PlayerModelPart_): boolean;
        load(arg0: boolean): void;
        static genericValueLabel(arg0: net.minecraft.network.chat.Component_, arg1: number): net.minecraft.network.chat.Component;
        narrator(): Internal.OptionInstance<Internal.NarratorStatus>;
        wait(arg0: number, arg1: number): void;
        chatLineSpacing(): Internal.OptionInstance<number>;
        forceUnicodeFont(): Internal.OptionInstance<boolean>;
        renderDistance(): Internal.OptionInstance<number>;
        allowServerListing(): Internal.OptionInstance<boolean>;
        directionalAudio(): Internal.OptionInstance<boolean>;
        toggleCrouch(): Internal.OptionInstance<boolean>;
        handler$efl000$addAutomaticDebugOption(client: Internal.Minecraft_, optionsFile: Internal.File_, ci: Internal.CallbackInfo_): void;
        hideMatchedNames(): Internal.OptionInstance<boolean>;
        getBackgroundOpacity(arg0: number): number;
        toggleModelPart(arg0: Internal.PlayerModelPart_, arg1: boolean): void;
        getCameraType(): Internal.CameraType;
        "getBackgroundColor(float)"(arg0: number): number;
        hashCode(): number;
        chatVisibility(): Internal.OptionInstance<Internal.ChatVisiblity>;
        sensitivity(): Internal.OptionInstance<number>;
        graphicsMode(): Internal.OptionInstance<Internal.GraphicsStatus>;
        equals(arg0: any): boolean;
        darkMojangStudiosBackground(): Internal.OptionInstance<boolean>;
        get cloudsType(): Internal.CloudStatus
        get class(): typeof any
        set cameraType(arg0: Internal.CameraType_)
        get effectiveRenderDistance(): number
        set serverRenderDistance(arg0: number)
        get file(): Internal.File
        get cameraType(): Internal.CameraType
        readonly keySwapOffhand: Internal.KeyMapping;
        readonly keyDown: Internal.KeyMapping;
        static readonly RENDER_DISTANCE_NORMAL: (8) & (number);
        static readonly RENDER_DISTANCE_FAR: (12) & (number);
        hideBundleTutorial: boolean;
        readonly keyUp: Internal.KeyMapping;
        static readonly RENDER_DISTANCE_EXTREME: (32) & (number);
        skipMultiplayerWarning: boolean;
        readonly keyShift: Internal.KeyMapping;
        hideGui: boolean;
        readonly keyScreenshot: Internal.KeyMapping;
        pauseOnLostFocus: boolean;
        languageCode: string;
        readonly keyPlayerList: Internal.KeyMapping;
        static readonly AUTO_GUI_SCALE: (0) & (number);
        readonly keyRight: Internal.KeyMapping;
        smoothCamera: boolean;
        readonly keyCommand: Internal.KeyMapping;
        readonly keyAttack: Internal.KeyMapping;
        renderFpsChart: boolean;
        gamma: Internal.OptionInstance<number>;
        readonly keyChat: Internal.KeyMapping;
        readonly keyPickItem: Internal.KeyMapping;
        joinedFirstServer: boolean;
        static readonly RENDER_DISTANCE_TINY: (2) & (number);
        incompatibleResourcePacks: Internal.List<string>;
        readonly keyFullscreen: Internal.KeyMapping;
        skipRealms32bitWarning: boolean;
        fullscreenVideoModeString: string;
        useNativeTransport: boolean;
        glDebugVerbosity: number;
        readonly keyTogglePerspective: Internal.KeyMapping;
        static readonly RENDER_DISTANCE_REALLY_FAR: (16) & (number);
        readonly optionsFile: Internal.File;
        readonly keySmoothCamera: Internal.KeyMapping;
        static readonly UNLIMITED_FRAMERATE_CUTOFF: (260) & (number);
        overrideWidth: number;
        readonly keySaveHotbarActivator: Internal.KeyMapping;
        static readonly RENDER_DISTANCE_SHORT: (4) & (number);
        overrideHeight: number;
        renderDebug: boolean;
        lastMpIp: string;
        readonly keyAdvancements: Internal.KeyMapping;
        readonly keyLeft: Internal.KeyMapping;
        readonly keyJump: Internal.KeyMapping;
        readonly keyUse: Internal.KeyMapping;
        readonly keyDrop: Internal.KeyMapping;
        onboardAccessibility: boolean;
        resourcePacks: Internal.List<string>;
        readonly fullscreen: Internal.OptionInstance<boolean>;
        readonly keySocialInteractions: Internal.KeyMapping;
        readonly keySpectatorOutlines: Internal.KeyMapping;
        readonly keySprint: Internal.KeyMapping;
        readonly keyInventory: Internal.KeyMapping;
        readonly keyLoadHotbarActivator: Internal.KeyMapping;
        advancedItemTooltips: boolean;
        renderDebugCharts: boolean;
        syncWrites: boolean;
        readonly keyHotbarSlots: Internal.KeyMapping[];
        hideServerAddress: boolean;
        tutorialStep: Internal.TutorialSteps;
        keyMappings: Internal.KeyMapping[];
        static readonly DEFAULT_SOUND_DEVICE: ("") & (string);
    }
    type Options_ = Options;
    interface Weighted <T> {
        abstract getSound(arg0: Internal.RandomSource_): T;
        abstract getWeight(): number;
        abstract preloadIfRequired(arg0: Internal.SoundEngine_): void;
        get weight(): number
    }
    type Weighted_<T> = Weighted<T>;
    class SecurityMode extends Internal.Enum<Internal.SecurityMode> implements Internal.IHasTextComponent, Internal.IIncrementalEnum<Internal.SecurityMode> {
        getClass(): typeof any;
        adjust(arg0: number, arg1: Internal.Predicate_<Internal.SecurityMode>): this;
        getNext(arg0: Internal.Predicate_<Internal.SecurityMode>): this;
        getPrevious(arg0: Internal.Predicate_<Internal.SecurityMode>): this;
        compareTo(arg0: Internal.SecurityMode_): number;
        describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<Internal.SecurityMode>>;
        getTextComponent(): net.minecraft.network.chat.Component;
        adjust(arg0: number): this;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        compareTo(arg0: any): number;
        static byIndexStatic(arg0: number): Internal.SecurityMode;
        getNext(): this;
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        getDeclaringClass(): typeof Internal.SecurityMode;
        toString(): string;
        static values(): Internal.SecurityMode[];
        notifyAll(): void;
        getPrevious(): this;
        name(): string;
        static valueOf(arg0: string): Internal.SecurityMode;
        hashCode(): number;
        abstract ordinal(): number;
        wait(): void;
        "compareTo(mekanism.api.security.SecurityMode)"(arg0: Internal.SecurityMode_): number;
        wait(arg0: number): void;
        "compareTo(java.lang.Object)"(arg0: any): number;
        byIndex(arg0: number): this;
        equals(arg0: any): boolean;
        get class(): typeof any
        get textComponent(): net.minecraft.network.chat.Component
        get next(): Internal.SecurityMode
        get declaringClass(): typeof Internal.SecurityMode
        get previous(): Internal.SecurityMode
        static readonly PUBLIC: (Internal.SecurityMode) & (Internal.SecurityMode);
        static readonly PRIVATE: (Internal.SecurityMode) & (Internal.SecurityMode);
        static readonly TRUSTED: (Internal.SecurityMode) & (Internal.SecurityMode);
    }
    type SecurityMode_ = SecurityMode | "public" | "trusted" | "private";
    class Heightmap implements Internal.HeightmapAccessor {
        constructor(arg0: Internal.ChunkAccess_, arg1: Internal.Heightmap$Types_)
        getClass(): typeof any;
        getHighestTaken(arg0: number, arg1: number): number;
        toString(): string;
        notifyAll(): void;
        getFirstAvailable(arg0: number, arg1: number): number;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        update(arg0: number, arg1: number, arg2: number, arg3: Internal.BlockState_): boolean;
        setRawData(arg0: Internal.ChunkAccess_, arg1: Internal.Heightmap$Types_, arg2: number[]): void;
        hashCode(): number;
        static primeHeightmaps(arg0: Internal.ChunkAccess_, arg1: Internal.Set_<Internal.Heightmap$Types>): void;
        wait(): void;
        wait(arg0: number): void;
        getRawData(): number[];
        equals(arg0: any): boolean;
        getBlockPredicate(): Internal.Predicate<any>;
        callSet(arg0: number, arg1: number, arg2: number): void;
        get class(): typeof any
        get rawData(): number[]
        get blockPredicate(): Internal.Predicate<any>
    }
    type Heightmap_ = Heightmap;
    interface InterfaceLogicHost extends Internal.IUpgradeableObject, Internal.IConfigurableObject, Internal.IPriorityHost, Internal.IConfigInvHost {
        abstract saveChanges(): void;
        abstract getInterfaceLogic(): Internal.InterfaceLogic;
        abstract getMainMenuIcon(): Internal.ItemStack;
        getConfig(): Internal.GenericStackInv;
        getConfigManager(): Internal.IConfigManager;
        getStorage(): Internal.GenericStackInv;
        returnToMainMenu(arg0: Internal.Player_, arg1: Internal.ISubMenu_): void;
        isUpgradedWith(arg0: Internal.ItemLike_): boolean;
        getInstalledUpgrades(arg0: Internal.ItemLike_): number;
        openMenu(arg0: Internal.Player_, arg1: Internal.MenuLocator_): void;
        setPriority(arg0: number): void;
        abstract getBlockEntity(): Internal.BlockEntity;
        getPriority(): number;
        getUpgrades(): Internal.IUpgradeInventory;
        get interfaceLogic(): Internal.InterfaceLogic
        get mainMenuIcon(): Internal.ItemStack
        get config(): Internal.GenericStackInv
        get configManager(): Internal.IConfigManager
        get storage(): Internal.GenericStackInv
        set priority(arg0: number)
        get blockEntity(): Internal.BlockEntity
        get priority(): number
        get upgrades(): Internal.IUpgradeInventory
    }
    type InterfaceLogicHost_ = InterfaceLogicHost;
    class CustomCommandEventJS extends Internal.EntityEventJS {
        constructor(l: Internal.Level_, e: Internal.Entity_, p: BlockPos_, i: string)
        getClass(): typeof any;
        /**
         * Stops the event with default exit value. Execution will be stopped **immediately**.
         * 
         * `exit` denotes a `default` outcome.
        */
        exit(): any;
        /**
         * Cancels the event with the given exit value. Execution will be stopped **immediately**.
         * 
         * `cancel` denotes a `false` outcome.
        */
        cancel(value: any): any;
        toString(): string;
        notifyAll(): void;
        /**
         * Stops the event with the given exit value. Execution will be stopped **immediately**.
         * 
         * `exit` denotes a `default` outcome.
        */
        exit(value: any): any;
        getId(): string;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        getLevel(): Internal.Level;
        /**
         * Stops the event with the given exit value. Execution will be stopped **immediately**.
         * 
         * `success` denotes a `true` outcome.
        */
        success(value: any): any;
        hashCode(): number;
        getEntity(): Internal.Entity;
        wait(): void;
        /**
         * Cancels the event with default exit value. Execution will be stopped **immediately**.
         * 
         * `cancel` denotes a `false` outcome.
        */
        cancel(): any;
        wait(arg0: number): void;
        getPlayer(): Internal.Player;
        /**
         * Stops the event with default exit value. Execution will be stopped **immediately**.
         * 
         * `success` denotes a `true` outcome.
        */
        success(): any;
        equals(arg0: any): boolean;
        getServer(): Internal.MinecraftServer;
        getBlock(): Internal.BlockContainerJS;
        get class(): typeof any
        get id(): string
        get level(): Internal.Level
        get entity(): Internal.Entity
        get player(): Internal.Player
        get server(): Internal.MinecraftServer
        get block(): Internal.BlockContainerJS
    }
    type CustomCommandEventJS_ = CustomCommandEventJS;
    interface RepeatedDelayStrategy {
        abstract delayCyclesAfterSuccess(): number;
        exponentialBackoff(arg0: number): this;
        abstract delayCyclesAfterFailure(): number;
        readonly CONSTANT: Internal.RepeatedDelayStrategy;
    }
    type RepeatedDelayStrategy_ = RepeatedDelayStrategy;
    abstract class AbstractWidget implements Internal.LayoutElement, Internal.NarratableEntry, Internal.GuiEventListener, Internal.Renderable {
        constructor(arg0: number, arg1: number, arg2: number, arg3: number, arg4: net.minecraft.network.chat.Component_)
        charTyped(arg0: string, arg1: number): boolean;
        onRelease(arg0: number, arg1: number): void;
        getY(): number;
        setFocused(arg0: boolean): void;
        mouseClicked(arg0: number, arg1: number, arg2: number): boolean;
        keyReleased(arg0: number, arg1: number, arg2: number): boolean;
        notify(): void;
        getTooltip(): Internal.Tooltip;
        onClick(arg0: number, arg1: number): void;
        setTooltip(arg0: Internal.Tooltip_): void;
        clearFGColor(): void;
        setX(arg0: number): void;
        setAlpha(arg0: number): void;
        mouseMoved(arg0: number, arg1: number): void;
        getRectangle(): Internal.ScreenRectangle;
        nextFocusPath(arg0: Internal.FocusNavigationEvent_): Internal.ComponentPath;
        isHovered(): boolean;
        getWidth(): number;
        setPosition(arg0: number, arg1: number): void;
        visitWidgets(arg0: Internal.Consumer_<Internal.AbstractWidget>): void;
        keyPressed(arg0: number, arg1: number, arg2: number): boolean;
        wait(): void;
        isHoveredOrFocused(): boolean;
        render(arg0: Internal.GuiGraphics_, arg1: number, arg2: number, arg3: number): void;
        setMessage(arg0: net.minecraft.network.chat.Component_): void;
        isMouseOver(arg0: number, arg1: number): boolean;
        getClass(): typeof any;
        isFocused(): boolean;
        getX(): number;
        isActive(): boolean;
        getTabOrderGroup(): number;
        mouseScrolled(arg0: number, arg1: number, arg2: number): boolean;
        wait(arg0: number, arg1: number): void;
        setTooltipDelay(arg0: number): void;
        getMessage(): net.minecraft.network.chat.Component;
        setY(arg0: number): void;
        mouseDragged(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): boolean;
        setWidth(arg0: number): void;
        getHeight(): number;
        setTabOrderGroup(arg0: number): void;
        getFGColor(): number;
        toString(): string;
        renderTexture(arg0: Internal.GuiGraphics_, arg1: ResourceLocation_, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number): void;
        narrationPriority(): Internal.NarratableEntry$NarrationPriority;
        notifyAll(): void;
        mouseReleased(arg0: number, arg1: number, arg2: number): boolean;
        playDownSound(arg0: Internal.SoundManager_): void;
        hashCode(): number;
        static wrapDefaultNarrationMessage(arg0: net.minecraft.network.chat.Component_): Internal.MutableComponent;
        getCurrentFocusPath(): Internal.ComponentPath;
        setFGColor(arg0: number): void;
        updateNarration(arg0: Internal.NarrationElementOutput_): void;
        wait(arg0: number): void;
        setHeight(arg0: number): void;
        equals(arg0: any): boolean;
        get y(): number
        set focused(arg0: boolean)
        get tooltip(): Internal.Tooltip
        set tooltip(arg0: Internal.Tooltip_)
        set x(arg0: number)
        set alpha(arg0: number)
        get rectangle(): Internal.ScreenRectangle
        get hovered(): boolean
        get width(): number
        get hoveredOrFocused(): boolean
        set message(arg0: net.minecraft.network.chat.Component_)
        get class(): typeof any
        get focused(): boolean
        get x(): number
        get active(): boolean
        get tabOrderGroup(): number
        set tooltipDelay(arg0: number)
        get message(): net.minecraft.network.chat.Component
        set y(arg0: number)
        set width(arg0: number)
        get height(): number
        set tabOrderGroup(arg0: number)
        get FGColor(): number
        get currentFocusPath(): Internal.ComponentPath
        set FGColor(arg0: number)
        set height(arg0: number)
        visible: boolean;
        static readonly WIDGETS_LOCATION: (ResourceLocation) & (ResourceLocation);
        height: number;
        static readonly ACCESSIBILITY_TEXTURE: (ResourceLocation) & (ResourceLocation);
        x: number;
        y: number;
        static readonly UNSET_FG_COLOR: (-1) & (number);
        active: boolean;
    }
    type AbstractWidget_ = AbstractWidget;
    class QIOCraftingTransferHelper$SingularHashedItemSource {
        constructor(qioSource: Internal.UUID_, used: number)
        constructor(slot: number, used: number)
        getClass(): typeof any;
        getQioSource(): Internal.UUID;
        toString(): string;
        setUsed(used: number): void;
        notifyAll(): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        getSlot(): number;
        hashCode(): number;
        wait(): void;
        wait(arg0: number): void;
        getUsed(): number;
        equals(arg0: any): boolean;
        get class(): typeof any
        get qioSource(): Internal.UUID
        set used(used: number)
        get slot(): number
        get used(): number
    }
    type QIOCraftingTransferHelper$SingularHashedItemSource_ = QIOCraftingTransferHelper$SingularHashedItemSource;
    class EntityEvent extends net.minecraftforge.eventbus.api.Event {
        constructor()
        constructor(arg0: Internal.Entity_)
        getResult(): Internal.Event$Result;
        setCanceled(arg0: boolean): void;
        getClass(): typeof any;
        toString(): string;
        setPhase(arg0: Internal.EventPriority_): void;
        notifyAll(): void;
        isCanceled(): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        hasResult(): boolean;
        setResult(arg0: Internal.Event$Result_): void;
        hashCode(): number;
        isCancelable(): boolean;
        getEntity(): Internal.Entity;
        wait(): void;
        getListenerList(): Internal.ListenerList;
        wait(arg0: number): void;
        getPhase(): Internal.EventPriority;
        equals(arg0: any): boolean;
        get result(): Internal.Event$Result
        set canceled(arg0: boolean)
        get class(): typeof any
        set phase(arg0: Internal.EventPriority_)
        get canceled(): boolean
        set result(arg0: Internal.Event$Result_)
        get cancelable(): boolean
        get entity(): Internal.Entity
        get listenerList(): Internal.ListenerList
        get phase(): Internal.EventPriority
    }
    type EntityEvent_ = EntityEvent;
    class Realms32BitWarningStatus {
        constructor(arg0: Internal.Minecraft_)
        showRealms32BitWarningIfNeeded(arg0: Internal.Screen_): void;
        getClass(): typeof any;
        hashCode(): number;
        toString(): string;
        wait(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        get class(): typeof any
    }
    type Realms32BitWarningStatus_ = Realms32BitWarningStatus;
    class EntityTravelToDimensionEvent extends Internal.EntityEvent {
        constructor()
        constructor(arg0: Internal.Entity_, arg1: Internal.ResourceKey_<Internal.Level>)
        getResult(): Internal.Event$Result;
        setCanceled(arg0: boolean): void;
        getClass(): typeof any;
        toString(): string;
        setPhase(arg0: Internal.EventPriority_): void;
        notifyAll(): void;
        isCanceled(): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        hasResult(): boolean;
        setResult(arg0: Internal.Event$Result_): void;
        hashCode(): number;
        getDimension(): Internal.ResourceKey<Internal.Level>;
        isCancelable(): boolean;
        getEntity(): Internal.Entity;
        wait(): void;
        getListenerList(): Internal.ListenerList;
        wait(arg0: number): void;
        getPhase(): Internal.EventPriority;
        equals(arg0: any): boolean;
        get result(): Internal.Event$Result
        set canceled(arg0: boolean)
        get class(): typeof any
        set phase(arg0: Internal.EventPriority_)
        get canceled(): boolean
        set result(arg0: Internal.Event$Result_)
        get dimension(): Internal.ResourceKey<Internal.Level>
        get cancelable(): boolean
        get entity(): Internal.Entity
        get listenerList(): Internal.ListenerList
        get phase(): Internal.EventPriority
    }
    type EntityTravelToDimensionEvent_ = EntityTravelToDimensionEvent;
    class ModelQuadFacing extends Internal.Enum<Internal.ModelQuadFacing> {
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        getClass(): typeof any;
        toString(): string;
        notifyAll(): void;
        static values(): Internal.ModelQuadFacing[];
        notify(): void;
        wait(arg0: number, arg1: number): void;
        compareTo(arg0: any): number;
        getOpposite(): this;
        name(): string;
        describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<Internal.ModelQuadFacing>>;
        hashCode(): number;
        "compareTo(me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing)"(arg0: Internal.ModelQuadFacing_): number;
        getDeclaringClass(): typeof Internal.ModelQuadFacing;
        compareTo(arg0: Internal.ModelQuadFacing_): number;
        ordinal(): number;
        wait(): void;
        static fromDirection(arg0: Internal.Direction_): Internal.ModelQuadFacing;
        wait(arg0: number): void;
        "compareTo(java.lang.Object)"(arg0: any): number;
        static valueOf(arg0: string): Internal.ModelQuadFacing;
        equals(arg0: any): boolean;
        get class(): typeof any
        get opposite(): Internal.ModelQuadFacing
        get declaringClass(): typeof Internal.ModelQuadFacing
        static readonly NEG_X: (Internal.ModelQuadFacing) & (Internal.ModelQuadFacing);
        static readonly UNASSIGNED: (Internal.ModelQuadFacing) & (Internal.ModelQuadFacing);
        static readonly NONE: (0) & (number);
        static readonly NEG_Y: (Internal.ModelQuadFacing) & (Internal.ModelQuadFacing);
        static readonly COUNT: (7) & (number);
        static readonly POS_Z: (Internal.ModelQuadFacing) & (Internal.ModelQuadFacing);
        static readonly NEG_Z: (Internal.ModelQuadFacing) & (Internal.ModelQuadFacing);
        static readonly POS_X: (Internal.ModelQuadFacing) & (Internal.ModelQuadFacing);
        static readonly VALUES: Internal.ModelQuadFacing[];
        static readonly ALL: (127) & (number);
        static readonly POS_Y: (Internal.ModelQuadFacing) & (Internal.ModelQuadFacing);
    }
    type ModelQuadFacing_ = "unassigned" | "pos_z" | "neg_z" | "pos_y" | "neg_y" | "pos_x" | "neg_x" | ModelQuadFacing;
    class PrivacyMode extends Internal.Enum<Internal.PrivacyMode> implements Internal.StringRepresentable {
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        getClass(): typeof any;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>(arg0: Internal.Supplier_<E[]>, arg1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        "compareTo(dev.ftb.mods.ftbteams.api.property.PrivacyMode)"(arg0: Internal.PrivacyMode_): number;
        static values(): Internal.PrivacyMode[];
        toString(): string;
        getSerializedName(): string;
        notifyAll(): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        compareTo(arg0: any): number;
        name(): string;
        hashCode(): number;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>(arg0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys(arg0: Internal.StringRepresentable_[]): Internal.Keyable;
        compareTo(arg0: Internal.PrivacyMode_): number;
        ordinal(): number;
        wait(): void;
        wait(arg0: number): void;
        "compareTo(java.lang.Object)"(arg0: any): number;
        equals(arg0: any): boolean;
        static valueOf(name: string): Internal.PrivacyMode;
        describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<Internal.PrivacyMode>>;
        getDeclaringClass(): typeof Internal.PrivacyMode;
        get class(): typeof any
        get serializedName(): string
        get declaringClass(): typeof Internal.PrivacyMode
        readonly name: string;
        static readonly ALLIES: (Internal.PrivacyMode) & (Internal.PrivacyMode);
        static readonly PUBLIC: (Internal.PrivacyMode) & (Internal.PrivacyMode);
        static readonly NAME_MAP: Internal.NameMap<Internal.PrivacyMode>;
        static readonly PRIVATE: (Internal.PrivacyMode) & (Internal.PrivacyMode);
        static readonly VALUES: Internal.PrivacyMode[];
    }
    type PrivacyMode_ = "public" | "allies" | PrivacyMode | "private";
    class InteractionResultHolder <T> {
        constructor(arg0: Internal.InteractionResult_, arg1: T)
        getClass(): typeof any;
        toString(): string;
        static fail<T>(arg0: T): Internal.InteractionResultHolder<T>;
        notifyAll(): void;
        notify(): void;
        static pass<T>(arg0: T): Internal.InteractionResultHolder<T>;
        wait(arg0: number, arg1: number): void;
        getResult(): Internal.InteractionResult;
        hashCode(): number;
        static consume<T>(arg0: T): Internal.InteractionResultHolder<T>;
        wait(): void;
        wait(arg0: number): void;
        getObject(): T;
        static success<T>(arg0: T): Internal.InteractionResultHolder<T>;
        equals(arg0: any): boolean;
        static sidedSuccess<T>(arg0: T, arg1: boolean): Internal.InteractionResultHolder<T>;
        get class(): typeof any
        get result(): Internal.InteractionResult
        get object(): T
    }
    type InteractionResultHolder_<T> = InteractionResultHolder<T>;
    interface ITimeTrackingServer {
        abstract mfix$getLastTickStartTime(): number;
        (): number;
    }
    type ITimeTrackingServer_ = ITimeTrackingServer | (()=> number);
    class StoringChunkProgressListener implements Internal.ChunkProgressListener {
        constructor(arg0: number)
        getProgress(): number;
        getClass(): typeof any;
        getFullDiameter(): number;
        toString(): string;
        getDiameter(): number;
        notifyAll(): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        start(): void;
        hashCode(): number;
        getStatus(arg0: number, arg1: number): Internal.ChunkStatus;
        wait(): void;
        stop(): void;
        wait(arg0: number): void;
        onStatusChange(arg0: Internal.ChunkPos_, arg1: Internal.ChunkStatus_): void;
        updateSpawnPos(arg0: Internal.ChunkPos_): void;
        equals(arg0: any): boolean;
        get progress(): number
        get class(): typeof any
        get fullDiameter(): number
        get diameter(): number
    }
    type StoringChunkProgressListener_ = StoringChunkProgressListener;
    class RopeAndNailBlock extends Internal.Block implements Internal.SimpleWaterloggedBlock {
        constructor()
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        getBlacklistedEnchantments(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Set<Internal.Enchantment>;
        getTypeData(): Internal.CompoundTag;
        setFriction(arg0: number): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        needsDynamicNodeTypeCheck(): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        spawnTableParticle(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: BlockPos_): void;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        /**
         * @deprecated
        */
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        static byItem(arg0: Internal.Item_): Internal.Block;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        allowsTreasure(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        placeLiquid(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.FluidState_): boolean;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(shape: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        getPickupSound(arg0: Internal.BlockState_): Internal.Optional<Internal.SoundEvent>;
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        handler$dmk000$friendsandfoes_onUse(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, hand: Internal.InteractionHand_, hit: Internal.BlockHitResult_, cir: Internal.CallbackInfoReturnable_<any>): void;
        getMaxEnchantingPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        /**
         * @deprecated
        */
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        /**
         * @deprecated
        */
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        /**
         * @deprecated
        */
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        getTableParticle(arg0: Internal.BlockState_): Internal.ParticleOptions;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        needsDynamicBurningCheck(): boolean;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        getArcanaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        handler$dmk000$friendsandfoes_randomTick(state: Internal.BlockState_, world: Internal.ServerLevel_, pos: BlockPos_, random: Internal.RandomSource_, ci: Internal.CallbackInfo_): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        pickupBlock(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        getQuantaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        handler$bdh000$postConstruct(p_i241196_1_: Internal.BlockBehaviour$Properties_, ci: Internal.CallbackInfo_): void;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        getQuantaRectification(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        handler$dml000$friendsandfoes_hasRandomTicks(state: Internal.BlockState_, cir: Internal.CallbackInfoReturnable_<any>): void;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        canPlaceLiquid(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Fluid_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        getBonusClues(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        get typeData(): Internal.CompoundTag
        set friction(arg0: number)
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get descriptionId(): string
        get jumpFactor(): number
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
        static readonly HORIZONTAL_FACING: (Internal.DirectionProperty) & (Internal.DirectionProperty);
        static readonly SUPPORTING: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    }
    type RopeAndNailBlock_ = RopeAndNailBlock;
    class BuilderType <T> extends Internal.Record {
        constructor(type: string, builderClass: Internal.BuilderBase<T>, factory: Internal.BuilderFactory_)
        factory(): Internal.BuilderFactory;
        getClass(): typeof any;
        type(): string;
        hashCode(): number;
        builderClass(): Internal.BuilderBase<T>;
        toString(): string;
        wait(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        equals(o: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        get class(): typeof any
    }
    type BuilderType_<T> = BuilderType<T>;
    class TileEntityThermodynamicConductor extends Internal.TileEntityTransmitter {
        constructor(blockProvider: Internal.IBlockProvider_, pos: BlockPos_, state: Internal.BlockState_)
        emf$hasVehicle(): boolean;
        requestModelDataUpdate(): void;
        etf$getType(): Internal.EntityType<any>;
        emf$getVelocity(): Vec3d;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityDispatcher)"(arg0: Internal.CapabilityDispatcher_): boolean;
        sideChanged(side: Internal.Direction_, old: Internal.ConnectionType_, type: Internal.ConnectionType_): void;
        etf$isBlockEntity(): boolean;
        /**
         * @deprecated
        */
        setBlockState(arg0: Internal.BlockState_): void;
        handler$dbg000$setLevel(arg0: Internal.Level_, arg1: Internal.CallbackInfo_): void;
        load(nbt: Internal.CompoundTag_): void;
        setForceUpdate(): void;
        setChanged(): void;
        setCulled(value: boolean): void;
        "invalidateCapabilities(java.util.Collection,net.minecraft.core.Direction)"(capabilities: Internal.Collection_<Internal.Capability<any>>, side: Internal.Direction_): void;
        saveWithoutMetadata(): Internal.CompoundTag;
        setTimeout(): void;
        handler$bkf000$injectUnload(arg0: boolean, arg1: Internal.CallbackInfo_): void;
        getReducedUpdateTag(): Internal.CompoundTag;
        isOutOfCamera(): boolean;
        "getUpdatePacket()"(): Internal.Packet<any>;
        emf$prevZ(): number;
        etf$canBeBright(): boolean;
        onSneakRightClick(player: Internal.Player_, side: Internal.Direction_): Internal.InteractionResult;
        setRemoved(): void;
        onNeighborTileChange(side: Internal.Direction_): void;
        invalidateCapability(capability: Internal.Capability_<any>, ...sides: Internal.Direction_[]): void;
        emf$isOnGround(): boolean;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        invalidateCapabilities(capabilities: Internal.Collection_<Internal.Capability<any>>, ...sides: Internal.Direction_[]): void;
        etf$getPose(): Internal.Pose;
        etf$getEntityKey(): string;
        isCulled(): boolean;
        getType(): Internal.BlockEntityType<any>;
        onSneakRightClick(player: Internal.Player_): Internal.InteractionResult;
        etf$getOptifineId(): number;
        "invalidateCapability(net.minecraftforge.common.capabilities.Capability,net.minecraft.core.Direction)"(capability: Internal.Capability_<any>, side: Internal.Direction_): void;
        onAdded(): void;
        "getUpdatePacket()"(): Internal.ClientboundBlockEntityDataPacket;
        getRenderBoundingBox(): Internal.AABB;
        markDirtyComparator(): void;
        getClass(): typeof any;
        emf$isInvisible(): boolean;
        sendUpdatePacket(): void;
        static getPosFromTag(arg0: Internal.CompoundTag_): BlockPos;
        handler$bkf000$injectSaveCover(arg0: Internal.CallbackInfoReturnable_<any>): void;
        etf$distanceTo(entity: Internal.Entity_): number;
        emf$isSprinting(): boolean;
        isLoaded(): boolean;
        hasAnyComparatorNearby(): boolean;
        onChunkUnloaded(): void;
        saveToItem(arg0: Internal.ItemStack_): void;
        "deserializeNBT(net.minecraft.nbt.CompoundTag)"(arg0: Internal.CompoundTag_): void;
        static addEntityType(arg0: Internal.CompoundTag_, arg1: Internal.BlockEntityType_<any>): void;
        emf$isInLava(): boolean;
        "deserializeNBT(net.minecraft.nbt.Tag)"(arg0: Internal.Tag_): void;
        onComparatorAdded(direction: Internal.Direction_, offset: number): void;
        getTransmitterType(): Internal.TransmitterType;
        mekanism_covers$setCoverState(arg0: Internal.BlockState_): void;
        clearRemoved(): void;
        emf$isWet(): boolean;
        getUpdatePacket(): Internal.Packet<any>;
        getTileChunk(): Internal.Chunk3D;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityProvider)"(arg0: Internal.CapabilityProvider_<Internal.BlockEntity>): boolean;
        handler$dbg000$setRemoved(arg0: Internal.CallbackInfo_): void;
        getPersistentData(): Internal.CompoundTag;
        toString(): string;
        triggerEvent(arg0: number, arg1: number): boolean;
        emf$isGlowing(): boolean;
        hasLevel(): boolean;
        notifyAll(): void;
        getTileWorld(): Internal.Level;
        etf$getScoreboardTeam(): Internal.Team;
        emf$getZ(): number;
        invalidateCapabilities(capabilities: Internal.Collection_<Internal.Capability<any>>, side: Internal.Direction_): void;
        invalidateCachedCapabilities(): void;
        mekanism_covers$onUpdateClient(): void;
        setType_HammerLib(arg0: Internal.BlockEntityType_<any>): void;
        wait(arg0: number): void;
        etf$getItemsEquipped(): Internal.Iterable<any>;
        etf$getVelocity(): Vec3d;
        reviveCaps(): void;
        handleUpdatePacket(tag: Internal.CompoundTag_): void;
        etf$getWorld(): Internal.Level;
        handleUpdateTag(tag: Internal.CompoundTag_): void;
        getSideLookingAt(player: Internal.Player_): Internal.Direction;
        getUpdateTag(): Internal.CompoundTag;
        emf$getYaw(): number;
        setLevel(world: Internal.Level_): void;
        notify(): void;
        chunkAccessibilityChange(loaded: boolean): void;
        getBlockPos(): BlockPos;
        etf$getNbt(): Internal.CompoundTag;
        isRemoved(): boolean;
        emf$isSneaking(): boolean;
        static tickServer(level: Internal.Level_, pos: BlockPos_, state: Internal.BlockState_, transmitter: Internal.TileEntityTransmitter_): void;
        etf$getBlockPos(): BlockPos;
        onLoad(): void;
        fillCrashReportCategory(arg0: Internal.CrashReportCategory_): void;
        emf$prevPitch(): number;
        "invalidateCapability(net.minecraftforge.common.capabilities.Capability,net.minecraft.core.Direction[])"(capability: Internal.Capability_<any>, ...sides: Internal.Direction_[]): void;
        etf$getBlockY(): number;
        markForSave(): void;
        etf$getHandItems(): Internal.Iterable<any>;
        invalidateCaps(): void;
        getTilePos(): BlockPos;
        etf$getArmorItems(): Internal.Iterable<any>;
        emf$getY(): number;
        emf$prevX(): number;
        getTileCoord(): Internal.Coord4D;
        getBlockState(): Internal.BlockState;
        emf$age(): number;
        etf$hasCustomName(): boolean;
        getSideLookingAt(player: Internal.Player_, fallback: Internal.Direction_): Internal.Direction;
        static loadStatic(arg0: BlockPos_, arg1: Internal.BlockState_, arg2: Internal.CompoundTag_): Internal.BlockEntity;
        wait(): void;
        sendUpdatePacket(tracking: Internal.BlockEntity_): void;
        emf$isTouchingWater(): boolean;
        m_183515_(nbtTags: Internal.CompoundTag_): void;
        emf$getVariableMap(): Internal.Object2FloatOpenHashMap<any>;
        areCapsCompatible(arg0: Internal.CapabilityDispatcher_): boolean;
        etf$getCustomName(): net.minecraft.network.chat.Component;
        getCapability<T>(capability: Internal.Capability_<T>, side: Internal.Direction_): Internal.LazyOptional<T>;
        saveWithId(): Internal.CompoundTag;
        getCollisionBoxes(): Internal.List<Internal.VoxelShape>;
        setOutOfCamera(value: boolean): void;
        onRightClick(player: Internal.Player_, side: Internal.Direction_): Internal.InteractionResult;
        wait(arg0: number, arg1: number): void;
        getLevel(): Internal.Level;
        onRightClick(player: Internal.Player_): Internal.InteractionResult;
        onlyOpCanSetNbt(): boolean;
        isRemote(): boolean;
        serializeNBT(): Internal.Tag;
        onNeighborBlockChange(side: Internal.Direction_): void;
        handler$bkf000$injectLoad(arg0: Internal.CompoundTag_, arg1: Internal.CallbackInfo_): void;
        onDataPacket(net: Internal.Connection_, pkt: Internal.ClientboundBlockEntityDataPacket_): void;
        saveWithFullMetadata(): Internal.CompoundTag;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        "invalidateCapabilities(java.util.Collection,net.minecraft.core.Direction[])"(capabilities: Internal.Collection_<Internal.Capability<any>>, ...sides: Internal.Direction_[]): void;
        emf$prevY(): number;
        getTransmitter(): Internal.ThermodynamicConductor;
        emf$getX(): number;
        areCapsCompatible(arg0: Internal.CapabilityProvider_<Internal.BlockEntity>): boolean;
        emf$isOnFire(): boolean;
        deserializeNBT(arg0: Internal.Tag_): void;
        mekanism_covers$getCoverState(): Internal.BlockState;
        onAlloyInteraction(player: Internal.Player_, stack: Internal.ItemStack_, tier: Internal.AlloyTier_): void;
        etf$getUuid(): Internal.UUID;
        invalidateCapability(capability: Internal.Capability_<any>, side: Internal.Direction_): void;
        handler$bkf000$injectCoverModel(arg0: Internal.CallbackInfoReturnable_<any>): void;
        redstoneChanged(powered: boolean): void;
        getUpdatePacket(): Internal.ClientboundBlockEntityDataPacket;
        isForcedVisible(): boolean;
        emf$hasPassengers(): boolean;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        hashCode(): number;
        emf$getTypeString(): string;
        blockRemoved(): void;
        getModelData(): Internal.ModelData;
        emf$getPitch(): number;
        emf$isAlive(): boolean;
        handler$bkf000$injectUpdateTag(arg0: Internal.CompoundTag_, arg1: Internal.CallbackInfo_): void;
        handler$bkf000$injectSaveCover(arg0: Internal.CompoundTag_, arg1: Internal.CallbackInfo_): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        set blockState(arg0: Internal.BlockState_)
        set culled(value: boolean)
        get reducedUpdateTag(): Internal.CompoundTag
        get outOfCamera(): boolean
        get "updatePacket()"(): Internal.Packet<any>
        get culled(): boolean
        get type(): Internal.BlockEntityType<any>
        get "updatePacket()"(): Internal.ClientboundBlockEntityDataPacket
        get renderBoundingBox(): Internal.AABB
        get class(): typeof any
        get loaded(): boolean
        get transmitterType(): Internal.TransmitterType
        get updatePacket(): Internal.Packet<any>
        get tileChunk(): Internal.Chunk3D
        get persistentData(): Internal.CompoundTag
        get tileWorld(): Internal.Level
        set type_HammerLib(arg0: Internal.BlockEntityType_<any>)
        get updateTag(): Internal.CompoundTag
        set level(world: Internal.Level_)
        get blockPos(): BlockPos
        get removed(): boolean
        get tilePos(): BlockPos
        get tileCoord(): Internal.Coord4D
        get blockState(): Internal.BlockState
        get collisionBoxes(): Internal.List<Internal.VoxelShape>
        set outOfCamera(value: boolean)
        get level(): Internal.Level
        get remote(): boolean
        get transmitter(): Internal.ThermodynamicConductor
        get updatePacket(): Internal.ClientboundBlockEntityDataPacket
        get forcedVisible(): boolean
        get modelData(): Internal.ModelData
    }
    type TileEntityThermodynamicConductor_ = TileEntityThermodynamicConductor;
    class BlockContainerJS implements Internal.SpecialEquality {
        constructor(blockEntity: Internal.BlockEntity_)
        constructor(w: Internal.Level_, p: BlockPos_)
        getTags(): Internal.Collection<ResourceLocation>;
        getWest(): this;
        getY(): number;
        static checkSpecialEquality(o: any, o1: any, shallow: boolean): boolean;
        getNorth(): this;
        getBlockLight(): number;
        notify(): void;
        spawnLightning(): void;
        spawnFireworks(fireworks: Internal.FireworksJS_): void;
        getPos(): BlockPos;
        getDown(): this;
        getLight(): number;
        getDrops(): Internal.List<Internal.ItemStack>;
        getSouth(): this;
        getSkyLight(): number;
        mergeEntityData(tag: Internal.CompoundTag_): void;
        getCanSeeSky(): boolean;
        getDimension(): ResourceLocation;
        getBlockState(): Internal.BlockState;
        specialEquals(o: any, shallow: boolean): boolean;
        hasTag(tag: ResourceLocation_): boolean;
        getTypeData(): Internal.CompoundTag;
        getInventory(): Internal.InventoryKJS;
        wait(): void;
        offset(x: number, y: number, z: number): this;
        offset(f: Internal.Direction_): this;
        getClass(): typeof any;
        offset(f: Internal.Direction_, d: number): this;
        getEast(): this;
        getEntityId(): string;
        spawnLightning(effectOnly: boolean, player: Internal.ServerPlayer_): void;
        getX(): number;
        createEntity(type: Internal.EntityType_<any>): Internal.Entity;
        getDrops(entity: Internal.Entity_, heldItem: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        set(id: Special.Block, properties: Internal.Map_<any, any>): void;
        popItem(item: Internal.ItemStack_): void;
        set(id: Special.Block, properties: Internal.Map_<any, any>, flags: number): void;
        wait(arg0: number, arg1: number): void;
        getLevel(): Internal.Level;
        setBlockState(state: Internal.BlockState_, flags: number): void;
        popItemFromFace(item: Internal.ItemStack_, dir: Internal.Direction_): void;
        getEntity(): Internal.BlockEntity;
        getPlayersInRadius(radius: number): Internal.EntityArrayList;
        clearCache(): void;
        getUp(): this;
        getZ(): number;
        getEntityData(): Internal.CompoundTag;
        spawnLightning(effectOnly: boolean): void;
        toString(): string;
        getItem(): Internal.ItemStack;
        notifyAll(): void;
        getInventory(facing: Internal.Direction_): Internal.InventoryKJS;
        getId(): Special.Block&`${string}:${string}`;
        canSeeSkyFromBelowWater(): boolean;
        hashCode(): number;
        getProperties(): Internal.Map<string, string>;
        createExplosion(): Internal.ExplosionJS;
        setEntityData(tag: Internal.CompoundTag_): void;
        set(id: Special.Block): void;
        getPlayersInRadius(): Internal.EntityArrayList;
        wait(arg0: number): void;
        equals(obj: any): boolean;
        getBiomeId(): ResourceLocation;
        get tags(): Internal.Collection<ResourceLocation>
        get west(): Internal.BlockContainerJS
        get y(): number
        get north(): Internal.BlockContainerJS
        get blockLight(): number
        get pos(): BlockPos
        get down(): Internal.BlockContainerJS
        get light(): number
        get drops(): Internal.List<Internal.ItemStack>
        get south(): Internal.BlockContainerJS
        get skyLight(): number
        get canSeeSky(): boolean
        get dimension(): ResourceLocation
        get blockState(): Internal.BlockState
        get typeData(): Internal.CompoundTag
        get inventory(): Internal.InventoryKJS
        get class(): typeof any
        get east(): Internal.BlockContainerJS
        get entityId(): string
        get x(): number
        get level(): Internal.Level
        get entity(): Internal.BlockEntity
        get up(): Internal.BlockContainerJS
        get z(): number
        get entityData(): Internal.CompoundTag
        get item(): Internal.ItemStack
        get id(): Special.Block&`${string}:${string}`
        get properties(): Internal.Map<string, string>
        set entityData(tag: Internal.CompoundTag_)
        get playersInRadius(): Internal.EntityArrayList
        get biomeId(): ResourceLocation
        readonly minecraftLevel: Internal.Level;
    }
    type BlockContainerJS_ = BlockContainerJS;
    interface IStashStorageItem {
        abstract getItemStashable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): Internal.IStashStorageItem$StashResult;
        abstract getInventoryTooltip(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
    }
    type IStashStorageItem_ = IStashStorageItem;
    class EnderDragon extends Internal.Mob implements Internal.Enemy {
        constructor(arg0: Internal.EntityType_<Internal.EnderDragon>, arg1: Internal.Level_)
        etf$getType(): Internal.EntityType<any>;
        getUpVector(arg0: number): Vec3d;
        gameEvent(arg0: Internal.GameEvent_, arg1: Internal.Entity_): void;
        static checkMobSpawnRules(arg0: Internal.EntityType_<Internal.Mob>, arg1: Internal.LevelAccessor_, arg2: Internal.MobSpawnType_, arg3: BlockPos_, arg4: Internal.RandomSource_): boolean;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isSuppressingBounce(): boolean;
        setTarget(arg0: Internal.LivingEntity_): void;
        setCulled(value: boolean): void;
        isOnFire(): boolean;
        getPositionCodec(): Internal.VecDeltaCodec;
        getPickedResult(arg0: Internal.HitResult_): Internal.ItemStack;
        setMaxUpStep(arg0: number): void;
        /**
         * @deprecated
        */
        updateFluidHeightAndDoFluidPushing(arg0: Internal.TagKey_<Internal.Fluid>, arg1: number): boolean;
        convertTo<T extends Internal.Mob>(arg0: Internal.EntityType_<T>, arg1: boolean): T;
        getFallFlyingTicks(): number;
        runCommandSilent(command: string): number;
        setPosition(x: number, y: number, z: number): void;
        chunkPosition(): Internal.ChunkPos;
        emf$isOnGround(): boolean;
        dropLeash(arg0: boolean, arg1: boolean): void;
        gameEvent(arg0: Internal.GameEvent_): void;
        handler$dmc000$friendsandfoes_onDeath(damageSource: DamageSource_, ci: Internal.CallbackInfo_): void;
        setXxa(arg0: number): void;
        setDelayedLeashHolderId(arg0: number): void;
        isShiftKeyDown(): boolean;
        isInFluidType(arg0: Internal.FluidState_): boolean;
        setUUID(arg0: Internal.UUID_): void;
        checkBelowWorld(): void;
        setMotionZ(z: number): void;
        callCheckTotemDeathProtection(arg0: DamageSource_): boolean;
        "deserializeNBT(net.minecraft.nbt.Tag)"(arg0: Internal.Tag_): void;
        canFreeze(): boolean;
        ignoreExplosion(): boolean;
        getIsInsideStructureTracker(): Internal.IsInsideStructureTracker;
        getBlockY(): number;
        redirect$bbh000$apoth_sunderingApplyEffect(arg0: number, arg1: number, arg2: DamageSource_, arg3: number): number;
        isSpectator(): boolean;
        onTick(): void;
        setMainHandItem(item: Internal.ItemStack_): void;
        removeEffectNoUpdate(arg0: Internal.MobEffect_): Internal.MobEffectInstance;
        handler$zzn000$variantsandventures$skeleton$onSpawnPacket(packet: Internal.ClientboundAddEntityPacket_, ci: Internal.CallbackInfo_): void;
        spawnAtLocation(arg0: Internal.ItemLike_, arg1: number): Internal.ItemEntity;
        getPersistentData(): Internal.CompoundTag;
        getHealth(): number;
        getMaxHealth(): number;
        emf$isGlowing(): boolean;
        setPathfindingMalus(arg0: Internal.BlockPathTypes_, arg1: number): void;
        isRegisteredToWorld(): boolean;
        getRandomZ(arg0: number): number;
        setAggressive(arg0: boolean): void;
        getFusionModel(layerIndex: number): Internal.Triple<any, any, any>;
        setRemoved(arg0: Internal.Entity$RemovalReason_): void;
        isInWaterRainOrBubble(): boolean;
        getDistanceSq(arg0: number, arg1: number, arg2: number): number;
        getRemovalReason(): Internal.Entity$RemovalReason;
        etf$getVelocity(): Vec3d;
        onFlap(): void;
        resetFallDistance(): void;
        canSprint(): boolean;
        blockPosition(): BlockPos;
        setLevel(arg0: Internal.Level_): void;
        setBoundingBox(arg0: Internal.AABB_): void;
        isAmbientCreature(): boolean;
        getGUID(): Internal.UUID;
        handler$ban000$curio$canFreeze(arg0: Internal.CallbackInfoReturnable_<any>): void;
        setZza(arg0: number): void;
        getBlock(): Internal.BlockContainerJS;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        etf$getHandItems(): Internal.Iterable<any>;
        invalidateCaps(): void;
        randomTeleport(arg0: number, arg1: number, arg2: number, arg3: boolean): boolean;
        getName(): net.minecraft.network.chat.Component;
        playAmbientSound(): void;
        onGround(): boolean;
        getControlledVehicle(): Internal.Entity;
        isOnSameTeam(arg0: Internal.Entity_): boolean;
        getArmorValue(): number;
        isInFluidType(arg0: Internal.BiPredicate_<Internal.FluidType, number>): boolean;
        tick(): void;
        getKillCredit(): Internal.LivingEntity;
        emf$isTouchingWater(): boolean;
        isPushedByFluid(arg0: Internal.FluidType_): boolean;
        emf$getVariableMap(): Internal.Object2FloatOpenHashMap<any>;
        sinkInFluid(arg0: Internal.FluidType_): void;
        hasPermissions(arg0: number): boolean;
        getTargetPitch(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): number;
        onTravel(arg0: Vec3d_, arg1: boolean): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        bo$refreshEntityData(data: number): void;
        setOutOfCamera(value: boolean): void;
        localvar$bbe000$apoth_checkFallDamageWithGravity(arg0: number): number;
        static createMobAttributes(): Internal.AttributeSupplier$Builder;
        isAutoSpinAttack(): boolean;
        getRemainingFireTicks(): number;
        onlyOpCanSetNbt(): boolean;
        fireImmune(): boolean;
        addMotion(arg0: number, arg1: number, arg2: number): void;
        getMaxFallDistance(): number;
        isHolding(arg0: Internal.Item_): boolean;
        getZ(arg0: number): number;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        static areAllEffectsAmbient(arg0: Internal.Collection_<Internal.MobEffectInstance>): boolean;
        doHurtTarget(arg0: Internal.Entity_): boolean;
        getTicksFrozen(): number;
        getRandomX(arg0: number): number;
        create$callSpawnItemParticles(arg0: Internal.ItemStack_, arg1: number): void;
        spawnAtLocation(arg0: Internal.ItemStack_, arg1: number): Internal.ItemEntity;
        pick(arg0: number, arg1: number, arg2: boolean): Internal.HitResult;
        getVoicePitch(): number;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        setSleepingPos(arg0: BlockPos_): void;
        isDescending(): boolean;
        getAttributeBaseValue(arg0: Internal.Attribute_): number;
        emf$getPitch(): number;
        sendEffectToPassengers(arg0: Internal.MobEffectInstance_): void;
        getHeadRotSpeed(): number;
        getYHeadRot(): number;
        getProjectile(arg0: Internal.ItemStack_): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        syncPacketPositionCodec(arg0: number, arg1: number, arg2: number): void;
        setAbsorptionAmount(arg0: number): void;
        handler$bbh000$apoth_onEffectUpdateAddAttribute(arg0: Internal.MobEffectInstance_, arg1: boolean, arg2: Internal.Entity_, arg3: Internal.CallbackInfo_): void;
        shouldRenderAtSqrDistance(arg0: number): boolean;
        damageSources(): Internal.DamageSources;
        removeAllGoals(arg0: Internal.Predicate_<Internal.Goal>): void;
        swing(): void;
        recreateFromPacket(arg0: Internal.ClientboundAddEntityPacket_): void;
        getTargetHeadYaw(arg0: number, arg1: number): number;
        canStartSwimming(): boolean;
        setDeltaMovement(arg0: Vec3d_): void;
        getLeashOffset(arg0: number): Vec3d;
        isBaby(): boolean;
        isCulled(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        isGlowing(): boolean;
        "isInFluidType(net.minecraft.world.level.material.FluidState)"(arg0: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        canBreatheUnderwater(): boolean;
        die(arg0: DamageSource_): void;
        etf$getOptifineId(): number;
        removeAllEffects(): boolean;
        getLeashOffset(): Vec3d;
        hasLineOfSight(arg0: Internal.Entity_): boolean;
        onClimbable(): boolean;
        isAttackable(): boolean;
        getSlot(arg0: number): Internal.SlotAccess;
        "deserializeNBT(net.minecraft.nbt.CompoundTag)"(arg0: Internal.CompoundTag_): void;
        emf$isInLava(): boolean;
        stopSeenByPlayer(arg0: Internal.ServerPlayer_): void;
        isUnderWater(): boolean;
        stopRiding(): void;
        getLeashHolder(): Internal.Entity;
        getX(arg0: number): number;
        getSensing(): Internal.Sensing;
        getLegsArmorItem(): Internal.ItemStack;
        captureDrops(arg0: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        getSelfAndPassengers(): Internal.Stream<any>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getDeltaMovement(): Vec3d;
        canTakeItem(arg0: Internal.ItemStack_): boolean;
        shouldDropExperience(): boolean;
        hasPassenger(arg0: Internal.Entity_): boolean;
        setSecondsOnFire(arg0: number): void;
        moveTo(arg0: number, arg1: number, arg2: number): void;
        emf$getZ(): number;
        "getDisplayName()"(): net.minecraft.network.chat.Component;
        getLootTable(): ResourceLocation;
        getTicksUsingItem(): number;
        findClosestNode(arg0: number, arg1: number, arg2: number): number;
        getArrowCount(): number;
        create$callSetLevel(arg0: Internal.Level_): void;
        getMoveControl(): Internal.MoveControl;
        setMotion(arg0: number, arg1: number, arg2: number): void;
        playSound(arg0: Internal.SoundEvent_): void;
        getDefaultMovementSpeed(): number;
        restoreFrom(arg0: Internal.Entity_): void;
        isPeacefulCreature(): boolean;
        setOnGround(arg0: boolean): void;
        addEffect(arg0: Internal.MobEffectInstance_, arg1: Internal.Entity_): boolean;
        emf$getYaw(): number;
        ate(): void;
        setPos(arg0: number, arg1: number, arg2: number): void;
        notify(): void;
        getFirstTick(): boolean;
        setPersistenceRequired(): void;
        getLastHurtByMobTimestamp(): number;
        getVehicle(): Internal.Entity;
        isEffectiveAi(): boolean;
        startRiding(arg0: Internal.Entity_, arg1: boolean): boolean;
        setSpawnCancelled(arg0: boolean): void;
        getStringUuid(): string;
        setSwimming(arg0: boolean): void;
        canHydrateInFluidType(arg0: Internal.FluidType_): boolean;
        getMainArm(): Internal.HumanoidArm;
        checkSpawnRules(arg0: Internal.LevelAccessor_, arg1: Internal.MobSpawnType_): boolean;
        getRotationVector(): Internal.Vec2;
        getHurtDir(): number;
        etf$getBlockY(): number;
        isSprinting(): boolean;
        isMaxGroupSizeReached(arg0: number): boolean;
        getMotionY(): number;
        getOffhandItem(): Internal.ItemStack;
        canCollideWith(arg0: Internal.Entity_): boolean;
        getBlockExplosionResistance(arg0: Internal.Explosion_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.FluidState_, arg5: number): number;
        getFluidFallDistanceModifier(arg0: Internal.FluidType_): number;
        getIsInsidePortal(): boolean;
        clearSleepingPos(): void;
        canSpawnSprintParticle(): boolean;
        "moveTo(net.minecraft.core.BlockPos,float,float)"(arg0: BlockPos_, arg1: number, arg2: number): void;
        getLastHurtMob(): Internal.LivingEntity;
        moveRelative(arg0: number, arg1: Vec3d_): void;
        isAddedToWorld(): boolean;
        saveAsPassenger(arg0: Internal.CompoundTag_): boolean;
        getSoundSource(): Internal.SoundSource;
        getLastDamageSource(): DamageSource;
        setNoActionTime(arg0: number): void;
        setMovementSpeedAddition(speed: number): void;
        equipmentHasChanged(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getPose(): Internal.Pose;
        callActuallyHurt(arg0: DamageSource_, arg1: number): void;
        getAttribute(arg0: Internal.Attribute_): Internal.AttributeInstance;
        setPositionAndRotation(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): void;
        canBeAffected(arg0: Internal.MobEffectInstance_): boolean;
        callGetSoundVolume(): number;
        getPhaseManager(): Internal.EnderDragonPhaseManager;
        getRestrictCenter(): BlockPos;
        isLeftHanded(): boolean;
        etf$getUuid(): Internal.UUID;
        removeVehicle(): void;
        shouldFusionRecomputeModel(layerIndex: number): boolean;
        setZ(z: number): void;
        getY(): number;
        hashCode(): number;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        eat(arg0: Internal.Level_, arg1: Internal.ItemStack_): Internal.ItemStack;
        bookshelf$makePoofParticles(): void;
        isWithinMeleeAttackRange(arg0: Internal.LivingEntity_): boolean;
        broadcastBreakEvent(arg0: Internal.EquipmentSlot_): void;
        showVehicleHealth(): boolean;
        getDistance(pos: BlockPos_): number;
        isBlocking(): boolean;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        emf$getVelocity(): Vec3d;
        etf$isBlockEntity(): boolean;
        /**
         * @deprecated
        */
        isPushedByFluid(): boolean;
        getArmorCoverPercentage(): number;
        handleRelativeFrictionAndCalculateMovement(arg0: Vec3d_, arg1: number): Vec3d;
        turn(arg0: number, arg1: number): void;
        getAirSupply(): number;
        handler$bgc000$tryShortcutFluidPushing(ci: Internal.CallbackInfo_, box: Internal.AABB_, x1: number, x2: number, y1: number, y2: number, z1: number, z2: number, zero: number): void;
        moveTo(arg0: BlockPos_, arg1: number, arg2: number): void;
        isPlayer(): boolean;
        isAnimal(): boolean;
        readAdditionalSaveData(arg0: Internal.CompoundTag_): void;
        canBeCollidedWith(): boolean;
        getMotionDirection(): Internal.Direction;
        lavaHurt(): void;
        handleDamageEvent(arg0: DamageSource_): void;
        getFabricBalmData(): Internal.CompoundTag;
        canChangeDimensions(): boolean;
        jumpInFluid(arg0: Internal.FluidType_): void;
        getCommandSenderWorld(): Internal.Level;
        getTotalMovementSpeed(): number;
        changeDimension(arg0: Internal.ServerLevel_): Internal.Entity;
        moveInFluid(arg0: Internal.FluidState_, arg1: Vec3d_, arg2: number): boolean;
        updatingUsingItem(): void;
        onRead(arg0: Internal.CompoundTag_): void;
        attack(hp: number): void;
        canSwimInFluidType(arg0: Internal.FluidType_): boolean;
        getAttributes(): Internal.AttributeMap;
        isSpawnCancelled(): boolean;
        "hasPassenger(java.util.function.Predicate)"(arg0: Internal.Predicate_<Internal.Entity>): boolean;
        getDimensions(arg0: Internal.Pose_): Internal.EntityDimensions;
        isSwimming(): boolean;
        setSprinting(arg0: boolean): void;
        mayInteract(arg0: Internal.Level_, arg1: BlockPos_): boolean;
        setPortalCooldown(): void;
        getAttackAnim(arg0: number): number;
        setX(x: number): void;
        getBlockStateOn(): Internal.BlockState;
        getPortalWaitTime(): number;
        getItemBySlot(arg0: Internal.EquipmentSlot_): Internal.ItemStack;
        wantsToPickUp(arg0: Internal.ItemStack_): boolean;
        getFluidJumpThreshold(): number;
        handler$ded000$jammies$setRecordPlayingNearby(arg0: BlockPos_, arg1: boolean, arg2: Internal.CallbackInfo_): void;
        "setPositionAndRotation(double,double,double,float,float)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): void;
        isInvisibleTo(arg0: Internal.Player_): boolean;
        stopSleeping(): void;
        setAirSupply(arg0: number): void;
        getOnPos(): BlockPos;
        etf$getWorld(): Internal.Level;
        isUndead(): boolean;
        static createLivingAttributes(): Internal.AttributeSupplier$Builder;
        handler$dmc000$friendsandfoes_readCustomDataFromNbt(nbt: Internal.CompoundTag_, ci: Internal.CallbackInfo_): void;
        getStepHeight(): number;
        setRegisteredToWorld(navigation: Internal.PathNavigation_): void;
        isSleeping(): boolean;
        stopUsingItem(): void;
        etf$getNbt(): Internal.CompoundTag;
        acceptsFailure(): boolean;
        etf$getBlockPos(): BlockPos;
        setOnGroundWithKnownMovement(arg0: boolean, arg1: Vec3d_): void;
        getFluidFallingAdjustedMovement(arg0: number, arg1: boolean, arg2: Vec3d_): Vec3d;
        setOldPosAndRot(): void;
        isFree(arg0: number, arg1: number, arg2: number): boolean;
        getDismountPoses(): Internal.ImmutableList<Internal.Pose>;
        getLastHurtMobTimestamp(): number;
        lithiumOnEquipmentChanged(): void;
        "moveTo(double,double,double)"(arg0: number, arg1: number, arg2: number): void;
        setRemainingFireTicks(arg0: number): void;
        emf$age(): number;
        etf$hasCustomName(): boolean;
        /**
         * @deprecated
        */
        getOnPosLegacy(): BlockPos;
        handler$zpn000$baseTick(arg0: Internal.CallbackInfo_): void;
        setPos(arg0: Vec3d_): void;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setCanPickUpLoot(arg0: boolean): void;
        getMainHandItem(): Internal.ItemStack;
        areCapsCompatible(arg0: Internal.CapabilityDispatcher_): boolean;
        setSilent(arg0: boolean): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        hasExactlyOnePlayerPassenger(): boolean;
        canBeSeenAsEnemy(): boolean;
        setLeftHanded(arg0: boolean): void;
        getActiveEffects(): Internal.Collection<Internal.MobEffectInstance>;
        isOnPortalCooldown(): boolean;
        canAttack(arg0: Internal.LivingEntity_, arg1: Internal.TargetingConditions_): boolean;
        getAttributeValue(arg0: Internal.Holder_<Internal.Attribute>): number;
        handler$ehl000$create$onFireImmune(arg0: Internal.CallbackInfoReturnable_<any>): void;
        setPitch(arg0: number): void;
        isMultipartEntity(): boolean;
        setPosRaw(arg0: number, arg1: number, arg2: number): void;
        getParts(): Internal.PartEntity<any>[];
        handleEntityEvent(arg0: number): void;
        isUsingItem(): boolean;
        isAlwaysTicking(): boolean;
        interactAt(arg0: Internal.Player_, arg1: Vec3d_, arg2: Internal.InteractionHand_): Internal.InteractionResult;
        emf$getX(): number;
        lerpTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): void;
        onPassengerTurned(arg0: Internal.Entity_): void;
        spawnAtLocation(arg0: Internal.ItemLike_): Internal.ItemEntity;
        emf$hasPassengers(): boolean;
        serializeNBT(): Internal.CompoundTag;
        handler$dio000$yungscavebiomes_buffetEntitiesInSandstorm(arg0: Internal.CallbackInfo_): void;
        getForgePersistentData(): Internal.CompoundTag;
        lithiumOnBlockCacheDeleted(): void;
        "spawnAtLocation(net.minecraft.world.level.ItemLike,int)"(arg0: Internal.ItemLike_, arg1: number): Internal.ItemEntity;
        setInvulnerable(arg0: boolean): void;
        push(arg0: Internal.Entity_): void;
        isInFluidType(): boolean;
        emf$hasVehicle(): boolean;
        maxUpStep(): number;
        setGlowing(arg0: boolean): void;
        load(arg0: Internal.CompoundTag_): void;
        "broadcastBreakEvent(net.minecraft.world.entity.EquipmentSlot)"(arg0: Internal.EquipmentSlot_): void;
        setLeashedTo(arg0: Internal.Entity_, arg1: boolean): void;
        isAlive(): boolean;
        startSleeping(arg0: BlockPos_): void;
        hurt(arg0: Internal.EnderDragonPart_, arg1: DamageSource_, arg2: number): boolean;
        getBbHeight(): number;
        getMeleeAttackRangeSqr(arg0: Internal.LivingEntity_): number;
        bookshelf$getDrinkingSound(arg0: Internal.ItemStack_): Internal.SoundEvent;
        handler$zzn000$variantsandventures$skeleton$isImmuneToExplosion(cir: Internal.CallbackInfoReturnable_<any>): void;
        getViewVector(arg0: number): Vec3d;
        getTags(): Internal.Set<string>;
        getLastAttacker(): Internal.LivingEntity;
        hasControllingPassenger(): boolean;
        closerThan(arg0: Internal.Entity_, arg1: number, arg2: number): boolean;
        absMoveTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): void;
        getGoalSelector(): Internal.GoalSelector;
        getSubEntities(): Internal.EnderDragonPart[];
        onPathfindingStart(): void;
        getPercentFrozen(): number;
        setPortalCooldown(arg0: number): void;
        hasGlowingTag(): boolean;
        shouldBlockExplode(arg0: Internal.Explosion_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: number): boolean;
        emf$isInvisible(): boolean;
        setPosition(block: Internal.BlockContainerJS_): void;
        isLeashed(): boolean;
        addEffect(arg0: Internal.MobEffectInstance_): boolean;
        emf$isSprinting(): boolean;
        getViewXRot(arg0: number): number;
        canRiderInteract(): boolean;
        setPose(arg0: Internal.Pose_): void;
        getReachDistance(): number;
        getEntityType(): Internal.EntityType<any>;
        isWaterCreature(): boolean;
        toString(): string;
        etf$getScoreboardTeam(): Internal.Team;
        setLastHurtByPlayer(arg0: Internal.Player_): void;
        "getServer()"(): Internal.MinecraftServer;
        wasExperienceConsumed(): boolean;
        isPushable(): boolean;
        setYBodyRot(arg0: number): void;
        foodEaten(is: Internal.ItemStack_): void;
        onClientRemoval(): void;
        self(): Internal.LivingEntity;
        reviveCaps(): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        setRotation(yaw: number, pitch: number): void;
        setFightOrigin(arg0: BlockPos_): void;
        static same(arg0: any, arg1: any): boolean;
        calculateEntityAnimation(arg0: boolean): void;
        forceAddEffect(arg0: Internal.MobEffectInstance_, arg1: Internal.Entity_): void;
        handler$zzo000$variantsandventures$onSpawnPacket(packet: Internal.ClientboundAddEntityPacket_, ci: Internal.CallbackInfo_): void;
        setChestArmorItem(item: Internal.ItemStack_): void;
        bookshelf$getHurtSound(arg0: DamageSource_): Internal.SoundEvent;
        onAboveBubbleCol(arg0: boolean): void;
        handler$zzo000$isImmuneToExplosion(cir: Internal.CallbackInfoReturnable_<any>): void;
        "playSound(net.minecraft.sounds.SoundEvent,float,float)"(arg0: Internal.SoundEvent_, arg1: number, arg2: number): void;
        isPassenger(): boolean;
        hasPose(arg0: Internal.Pose_): boolean;
        redirect$bbh000$apoth_sunderingGetAmplifier(arg0: Internal.MobEffectInstance_): number;
        /**
         * @deprecated
        */
        isEyeInFluid(arg0: Internal.TagKey_<Internal.Fluid>): boolean;
        isInvulnerableTo(arg0: DamageSource_): boolean;
        makeStuckInBlock(arg0: Internal.BlockState_, arg1: Vec3d_): void;
        isSensitiveToWater(): boolean;
        skipAttackInteraction(arg0: Internal.Entity_): boolean;
        lerpMotion(arg0: number, arg1: number, arg2: number): void;
        "getAttributeValue(net.minecraft.core.Holder)"(arg0: Internal.Holder_<Internal.Attribute>): number;
        shouldRender(arg0: number, arg1: number, arg2: number): boolean;
        getJumpControl(): Internal.JumpControl;
        isFlapping(): boolean;
        getFeetArmorItem(): Internal.ItemStack;
        handler$zzn000$variantsandventures$skeleton$isPushable(cir: Internal.CallbackInfoReturnable_<any>): void;
        static getViewScale(): number;
        handler$zzn000$variantsandventures$skeleton$createSpawnPacket(cir: Internal.CallbackInfoReturnable_<any>): void;
        getVisualRotationYInDegrees(): number;
        setSpeed(arg0: number): void;
        requiresCustomPersistence(): boolean;
        isDiscrete(): boolean;
        unRide(): void;
        getLevel(): Internal.Level;
        "spawnAtLocation(net.minecraft.world.item.ItemStack)"(arg0: Internal.ItemStack_): Internal.ItemEntity;
        getCombatTracker(): Internal.CombatTracker;
        updateDynamicGameEventListener(arg0: Internal.BiConsumer_<Internal.DynamicGameEventListener<any>, Internal.ServerLevel>): void;
        "onSyncedDataUpdated(net.minecraft.network.syncher.EntityDataAccessor)"(arg0: Internal.EntityDataAccessor_<any>): void;
        emf$prevY(): number;
        isNoAi(): boolean;
        areCapsCompatible(arg0: Internal.CapabilityProvider_<Internal.Entity>): boolean;
        extinguishFire(): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getEyeHeightForge(arg0: Internal.Pose_, arg1: Internal.EntityDimensions_): number;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        closerThan(arg0: Internal.Entity_, arg1: number): boolean;
        onRegisterGoals(): void;
        getDistanceSq(pos: BlockPos_): number;
        indicateDamage(arg0: number, arg1: number): void;
        canBeSeenByAnyone(): boolean;
        emf$getTypeString(): string;
        getDragonFight(): Internal.EndDragonFight;
        isFullyFrozen(): boolean;
        getHeadLookVector(arg0: number): Vec3d;
        getLastPos(): BlockPos;
        isInWall(): boolean;
        getAllSlots(): Internal.Iterable<Internal.ItemStack>;
        remove(arg0: Internal.Entity$RemovalReason_): void;
        getScale(): number;
        isSuppressingSlidingDownLadder(): boolean;
        getBlockZ(): number;
        dampensVibrations(): boolean;
        isSilent(): boolean;
        "playSound(net.minecraft.sounds.SoundEvent)"(arg0: Internal.SoundEvent_): void;
        getPitch(): number;
        getPathfindingMalus(arg0: Internal.BlockPathTypes_): number;
        getRandom(): Internal.RandomSource;
        canReplaceEqualItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        rotate(arg0: Internal.Rotation_): number;
        shouldRiderFaceForward(arg0: Internal.Player_): boolean;
        getPassengersAndSelf(): Internal.Stream<any>;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        "getAttributeBaseValue(net.minecraft.core.Holder)"(arg0: Internal.Holder_<Internal.Attribute>): number;
        onLookAt(arg0: Internal.EntityAnchorArgument$Anchor_, arg1: Vec3d_): Vec3d;
        clearRestriction(): void;
        callGetDeathSound(): Internal.SoundEvent;
        "self()"(): Internal.LivingEntity;
        rayTrace(): Internal.RayTraceResultJS;
        alwaysAccepts(): boolean;
        "isHolding(java.util.function.Predicate)"(arg0: Internal.Predicate_<Internal.ItemStack>): boolean;
        getNoActionTime(): number;
        isVisuallyCrawling(): boolean;
        isAggressive(): boolean;
        setYya(arg0: number): void;
        redirect$bbh000$apoth_applyArmorPen(arg0: number, arg1: number, arg2: number, arg3: DamageSource_, arg4: number): number;
        shouldUpdateFluidWhileBoating(arg0: Internal.FluidState_, arg1: Internal.Boat_): boolean;
        setDropChance(arg0: Internal.EquipmentSlot_, arg1: number): void;
        "broadcastBreakEvent(net.minecraft.world.InteractionHand)"(arg0: Internal.InteractionHand_): void;
        teleportRelative(arg0: number, arg1: number, arg2: number): void;
        setBaby(arg0: boolean): void;
        getLastHurtByMob(): Internal.LivingEntity;
        isInWaterOrBubble(): boolean;
        handler$bbh000$apoth_onEffectUpdateRemoveAttribute(arg0: Internal.MobEffectInstance_, arg1: boolean, arg2: Internal.Entity_, arg3: Internal.CallbackInfo_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        updateFluidHeightAndDoFluidPushing(): void;
        getPortalCooldown(): number;
        getItem(): Internal.ItemStack;
        causeFallDamage(arg0: number, arg1: number, arg2: DamageSource_): boolean;
        releaseUsingItem(): void;
        getPosition(arg0: number): Vec3d;
        removeFreeWill(): void;
        removeWhenFarAway(arg0: number): boolean;
        wait(arg0: number): void;
        isIgnoringBlockTriggers(): boolean;
        setRecordPlayingNearby(arg0: BlockPos_, arg1: boolean): void;
        isInRain(): boolean;
        etf$getItemsEquipped(): Internal.Iterable<any>;
        getHandHoldingItemAngle(arg0: Internal.Item_): Vec3d;
        hasItemInSlot(arg0: Internal.EquipmentSlot_): boolean;
        canUpdate(arg0: boolean): void;
        distanceToSqr(arg0: Vec3d_): number;
        getEyeInFluidType(): Internal.FluidType;
        isSteppingCarefully(): boolean;
        getSoundFromFluidType(arg0: Internal.FluidType_, arg1: Internal.SoundAction_): Internal.SoundEvent;
        "spawnAtLocation(net.minecraft.world.item.ItemStack,float)"(arg0: Internal.ItemStack_, arg1: number): Internal.ItemEntity;
        addAdditionalSaveData(arg0: Internal.CompoundTag_): void;
        /**
         * @deprecated
        */
        getLightLevelDependentMagicValue(): number;
        getBlockX(): number;
        redirect$bbh000$apoth_sunderingHasEffect(arg0: Internal.LivingEntity_, arg1: Internal.MobEffect_): boolean;
        isFallFlying(): boolean;
        getEncodeId(): string;
        getY(arg0: number): number;
        emf$prevPitch(): number;
        getMaxHeadXRot(): number;
        getNbt(): Internal.CompoundTag;
        setInvisible(arg0: boolean): void;
        etf$getArmorItems(): Internal.Iterable<any>;
        getEffect(arg0: Internal.MobEffect_): Internal.MobEffectInstance;
        setTotalMovementSpeedMultiplier(speed: number): void;
        setHealth(arg0: number): void;
        attack(arg0: DamageSource_, arg1: number): boolean;
        onInsideBubbleColumn(arg0: boolean): void;
        getEyePosition(): Vec3d;
        getEyeHeight(): number;
        setDiscardFriction(arg0: boolean): void;
        hasPassenger(arg0: Internal.Predicate_<Internal.Entity>): boolean;
        getYaw(): number;
        swing(arg0: Internal.InteractionHand_, arg1: boolean): void;
        getUsedItemHand(): Internal.InteractionHand;
        setDefaultMovementSpeed(speed: number): void;
        canAttackType(arg0: Internal.EntityType_<any>): boolean;
        getCapability<T>(arg0: Internal.Capability_<T>, arg1: Internal.Direction_): Internal.LazyOptional<T>;
        onLivingTick(): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        getBrain(): Internal.Brain<any>;
        setCustomNameVisible(arg0: boolean): void;
        bo$getRenderer(): Internal.EntityRenderer<any>;
        isAlliedTo(arg0: Internal.Team_): boolean;
        getControllingPassenger(): Internal.LivingEntity;
        canFireProjectileWeapon(arg0: Internal.ProjectileWeaponItem_): boolean;
        getScriptType(): Internal.ScriptType;
        onWrite(arg0: Internal.CompoundTag_): void;
        shouldDiscardFriction(): boolean;
        startRiding(arg0: Internal.Entity_): boolean;
        saveWithoutId(arg0: Internal.CompoundTag_): Internal.CompoundTag;
        getForward(): Vec3d;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        getId(): number;
        canBeHitByProjectile(): boolean;
        findPath(arg0: number, arg1: number, arg2: Internal.Node_): net.minecraft.world.level.pathfinder.Path;
        onMove(arg0: Internal.MoverType_, arg1: Vec3d_, arg2: boolean): boolean;
        getEyeY(): number;
        handler$bbh000$apoth_ownedAttrMap(arg0: Internal.EntityType_<any>, arg1: Internal.Level_, arg2: Internal.CallbackInfo_): void;
        skipDropExperience(): void;
        getBoundingBox(): Internal.AABB;
        isInWaterOrRain(): boolean;
        setItemSlot(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): void;
        equals(arg0: any): boolean;
        getViewYRot(arg0: number): number;
        dismountsUnderwater(): boolean;
        isAffectedByPotions(): boolean;
        addTag(arg0: string): boolean;
        playerTouch(arg0: Internal.Player_): void;
        getCitadelEntityData(): Internal.CompoundTag;
        getEyeHeight(arg0: Internal.Pose_): number;
        getAddEntityPacket(): Internal.Packet<Internal.ClientGamePacketListener>;
        static getEquipmentForSlot(arg0: Internal.EquipmentSlot_, arg1: number): Internal.Item;
        isWithinRestriction(arg0: BlockPos_): boolean;
        getTeam(): Internal.Team;
        setTicksFrozen(arg0: number): void;
        getUseItem(): Internal.ItemStack;
        getMyRidingOffset(): number;
        dismountTo(arg0: number, arg1: number, arg2: number): void;
        redirect$doc000$bop(arg0: Internal.Entity$MovementEmission_): boolean;
        etf$getPose(): Internal.Pose;
        etf$getEntityKey(): string;
        hasCustomName(): boolean;
        getSwimAmount(arg0: number): number;
        isLiving(): boolean;
        getX(): number;
        isVehicle(): boolean;
        spawnAtLocation(arg0: Internal.ItemStack_): Internal.ItemEntity;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        thunderHit(arg0: Internal.ServerLevel_, arg1: Internal.LightningBolt_): void;
        setIsInPowderSnow(arg0: boolean): void;
        etf$distanceTo(entity: Internal.Entity_): number;
        doEnchantDamageEffects(arg0: Internal.LivingEntity_, arg1: Internal.Entity_): void;
        setCustomName(arg0: net.minecraft.network.chat.Component_): void;
        getTeamId(): string;
        canBeRiddenUnderFluidType(arg0: Internal.FluidType_, arg1: Internal.Entity_): boolean;
        setStingerCount(arg0: number): void;
        getMaxHeadYRot(): number;
        isCustomNameVisible(): boolean;
        isSupportedBy(arg0: BlockPos_): boolean;
        getPistonPushReaction(): Internal.PushReaction;
        shouldRiderSit(): boolean;
        lookAt(arg0: Internal.EntityAnchorArgument$Anchor_, arg1: Vec3d_): void;
        getLootTableSeed(): number;
        isInFluidType(arg0: Internal.FluidType_): boolean;
        collide(arg0: Vec3d_): Vec3d;
        getFluidMotionScale(arg0: Internal.FluidType_): number;
        getMotionX(): number;
        "onSyncedDataUpdated(java.util.List)"(arg0: Internal.List_<Internal.SynchedEntityData$DataValue<any>>): void;
        canBeLeashed(arg0: Internal.Player_): boolean;
        hasIndirectPassenger(arg0: Internal.Entity_): boolean;
        getEntityData(): Internal.SynchedEntityData;
        bookshelf$getFallDamageSound(arg0: number): Internal.SoundEvent;
        handleInsidePortal(arg0: BlockPos_): void;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        absMoveTo(arg0: number, arg1: number, arg2: number): void;
        updateFluidHeightAndDoFluidPushing(arg0: Internal.Predicate_<Internal.FluidState>): void;
        isOnRails(): boolean;
        getStingerCount(): number;
        markFusionRecomputeModels(): void;
        getFallSounds(): Internal.LivingEntity$Fallsounds;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        getDimensionChangingDelay(): number;
        setYaw(arg0: number): void;
        getPickRadius(): number;
        isRemoved(): boolean;
        emf$isSneaking(): boolean;
        teleportToWithTicket(arg0: number, arg1: number, arg2: number): void;
        spawnAnim(): void;
        getJumpBoostPower(): number;
        fillCrashReportCategory(arg0: Internal.CrashReportCategory_): void;
        self(): Internal.Entity;
        refreshDimensions(): void;
        bookshelf$getAmbientSound(): Internal.SoundEvent;
        "isHolding(net.minecraft.world.item.Item)"(arg0: Internal.Item_): boolean;
        "spawnAtLocation(net.minecraft.world.level.ItemLike)"(arg0: Internal.ItemLike_): Internal.ItemEntity;
        "getAttributeValue(net.minecraft.world.entity.ai.attributes.Attribute)"(arg0: Internal.Attribute_): number;
        getEyePosition(arg0: number): Vec3d;
        setShiftKeyDown(arg0: boolean): void;
        getPassengers(): Internal.EntityArrayList;
        getAdjustedOnPosition(arg0: BlockPos_): BlockPos;
        getMaxHeightFluidType(): Internal.FluidType;
        getZ(): number;
        teleportTo(arg0: number, arg1: number, arg2: number): void;
        getAttributeBaseValue(arg0: Internal.Holder_<Internal.Attribute>): number;
        getServer(): Internal.MinecraftServer;
        getExperienceReward(): number;
        getFirstPassenger(): Internal.Entity;
        heal(arg0: number): void;
        getSpawnType(): Internal.MobSpawnType;
        setLastHurtMob(arg0: Internal.Entity_): void;
        setLastHurtByMob(arg0: Internal.LivingEntity_): void;
        interact(arg0: Internal.Player_, arg1: Internal.InteractionHand_): Internal.InteractionResult;
        getDismountLocationForPassenger(arg0: Internal.LivingEntity_): Vec3d;
        checkSlowFallDistance(): void;
        canStandOnFluid(arg0: Internal.FluidState_): boolean;
        setFabricBalmData(arg0: Internal.CompoundTag_): void;
        getSleepingPos(): Internal.Optional<any>;
        touchingUnloadedChunk(): boolean;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        getLookAngle(): Vec3d;
        getAmbientSoundInterval(): number;
        emf$isOnFire(): boolean;
        handler$dmc000$friendsandfoes_writeCustomDataToNbt(nbt: Internal.CompoundTag_, ci: Internal.CallbackInfo_): void;
        setArrowCount(arg0: number): void;
        getMotionZ(): number;
        onNotifyDataManagerChange(arg0: Internal.EntityDataAccessor_<any>): void;
        handler$ded000$jammies$aiStep(arg0: Internal.CallbackInfo_): void;
        isPersistenceRequired(): boolean;
        isInvisible(): boolean;
        is(arg0: Internal.Entity_): boolean;
        getBedOrientation(): Internal.Direction;
        ejectPassengers(): void;
        removeEffect(arg0: Internal.MobEffect_): boolean;
        getProfile(): Internal.GameProfile;
        isDeadOrDying(): boolean;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        static setViewScale(arg0: number): void;
        emf$isAlive(): boolean;
        take(arg0: Internal.Entity_, arg1: number): void;
        setLevelCallback(arg0: Internal.EntityInLevelCallback_): void;
        getLookControl(): Internal.LookControl;
        playSound(arg0: Internal.SoundEvent_, arg1: number, arg2: number): void;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityDispatcher)"(arg0: Internal.CapabilityDispatcher_): boolean;
        canAttack(arg0: Internal.LivingEntity_): boolean;
        getOffHandItem(): Internal.ItemStack;
        startSeenByPlayer(arg0: Internal.ServerPlayer_): void;
        isOnScoreboardTeam(teamId: string): boolean;
        startUsingItem(arg0: Internal.InteractionHand_): void;
        setTimeout(): void;
        position(): Vec3d;
        static getEquipmentSlotForItem(arg0: Internal.ItemStack_): Internal.EquipmentSlot;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        getAdjustedCanTriggerWalking(arg0: boolean): boolean;
        displayFireAnimation(): boolean;
        isOutOfCamera(): boolean;
        getRopeHoldPosition(arg0: number): Vec3d;
        copyPosition(arg0: Internal.Entity_): void;
        onAddedToWorld(): void;
        "hasPassenger(net.minecraft.world.entity.Entity)"(arg0: Internal.Entity_): boolean;
        isCrouching(): boolean;
        etf$canBeBright(): boolean;
        "getAttributeBaseValue(net.minecraft.world.entity.ai.attributes.Attribute)"(arg0: Internal.Attribute_): number;
        onLeaveCombat(): void;
        handler$zzo000$variantsandventures$createSpawnPacket(cir: Internal.CallbackInfoReturnable_<any>): void;
        setY(y: number): void;
        getAttributeValue(arg0: Internal.Attribute_): number;
        getFeetBlockState(): Internal.BlockState;
        handler$zzn000$variantsandventures$skeleton$isInvulnerableTo(damageSource: DamageSource_, cir: Internal.CallbackInfoReturnable_<any>): void;
        isWithinRestriction(): boolean;
        changeDimension(arg0: Internal.ServerLevel_, arg1: Internal.ITeleporter_): Internal.Entity;
        positionRider(arg0: Internal.Entity_): void;
        baseTick(): void;
        broadcastToPlayer(arg0: Internal.ServerPlayer_): boolean;
        setSharedFlag(arg0: number, arg1: boolean): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getEyeHeightAccess(arg0: Internal.Pose_, arg1: Internal.EntityDimensions_): number;
        damageHeldItem(): void;
        getCustomName(): net.minecraft.network.chat.Component;
        getClass(): typeof any;
        "self()"(): Internal.Entity;
        isVisuallySwimming(): boolean;
        getMaxAirSupply(): number;
        canTrample(arg0: Internal.BlockState_, arg1: BlockPos_, arg2: number): boolean;
        setItemInHand(arg0: Internal.InteractionHand_, arg1: Internal.ItemStack_): void;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        emf$isWet(): boolean;
        onCrystalDestroyed(arg0: Internal.EndCrystal_, arg1: BlockPos_, arg2: DamageSource_): void;
        isPassengerOfSameVehicle(arg0: Internal.Entity_): boolean;
        getBoundingBoxForCulling(): Internal.AABB;
        abstract invokeSetSharedFlag(arg0: number, arg1: boolean): void;
        getTarget(): Internal.LivingEntity;
        static collideBoundingBox(entity: Internal.Entity_, movement: Vec3d_, entityBoundingBox: Internal.AABB_, world: Internal.Level_, collisions: Internal.List_<any>): Vec3d;
        onJump(): boolean;
        restrictTo(arg0: BlockPos_, arg1: number): void;
        getTargetYaw(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): number;
        trackingPosition(): Vec3d;
        getNameTagOffsetY(): number;
        getCurrentSwingDuration(): number;
        isInvulnerable(): boolean;
        isInLava(): boolean;
        awardKillScore(arg0: Internal.Entity_, arg1: number, arg2: DamageSource_): void;
        isInWater(): boolean;
        /**
         * @deprecated
        */
        finalizeSpawn(arg0: Internal.ServerLevelAccessor_, arg1: Internal.DifficultyInstance_, arg2: Internal.MobSpawnType_, arg3: Internal.SpawnGroupData_, arg4: Internal.CompoundTag_): Internal.SpawnGroupData;
        swing(arg0: Internal.InteractionHand_): void;
        hasEffect(arg0: Internal.MobEffect_): boolean;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        setFusionModel(layerIndex: number, model: Internal.Triple_<any, any, any>): void;
        getRootVehicle(): Internal.Entity;
        onPathfindingDone(): void;
        save(arg0: Internal.CompoundTag_): boolean;
        getLocalBoundsForPose(arg0: Internal.Pose_): Internal.AABB;
        isNoGravity(): boolean;
        curePotionEffects(arg0: Internal.ItemStack_): boolean;
        onItemPickup(arg0: Internal.ItemEntity_): void;
        setCitadelEntityData(arg0: Internal.CompoundTag_): void;
        emf$getY(): number;
        bookshelf$createHoverEvent(): Internal.HoverEvent;
        updateSwimming(): void;
        isHolding(arg0: Internal.Predicate_<Internal.ItemStack>): boolean;
        getSpeed(): number;
        abstract getCachedFeetBlockState(): Internal.BlockState;
        shouldInformAdmins(): boolean;
        canFluidExtinguish(arg0: Internal.FluidType_): boolean;
        rideTick(): void;
        wait(): void;
        getUuid(): Internal.UUID;
        setOffHandItem(item: Internal.ItemStack_): void;
        spawn(): void;
        setNoAi(arg0: boolean): void;
        teleportTo(arg0: Internal.ServerLevel_, arg1: number, arg2: number, arg3: number, arg4: Internal.Set_<Internal.RelativeMovement>, arg5: number, arg6: number): boolean;
        etf$getCustomName(): net.minecraft.network.chat.Component;
        shouldShowName(): boolean;
        getArmorSlots(): Internal.Iterable<Internal.ItemStack>;
        canPickUpLoot(): boolean;
        kill(): void;
        onEnterCombat(): void;
        updateNavigationRegistration(): void;
        animateHurt(arg0: number): void;
        static resetForwardDirectionOfRelativePortalPosition(arg0: Vec3d_): Vec3d;
        setDragonFight(arg0: Internal.EndDragonFight_): void;
        hasRestriction(): boolean;
        getHeadArmorItem(): Internal.ItemStack;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getDimensionsForge(arg0: Internal.Pose_): Internal.EntityDimensions;
        deserializeNBT(arg0: Internal.Tag_): void;
        revive(): void;
        getBbWidth(): number;
        handler$bpk000$onLavaHurt(arg0: Internal.CallbackInfo_): void;
        isEyeInFluidType(arg0: Internal.FluidType_): boolean;
        addDeltaMovement(arg0: Vec3d_): void;
        canDrownInFluidType(arg0: Internal.FluidType_): boolean;
        "getName()"(): net.minecraft.network.chat.Component;
        mirror(arg0: Internal.Mirror_): number;
        canUpdate(): boolean;
        knockback(arg0: number, arg1: number, arg2: number): void;
        getTicksRequiredToFreeze(): number;
        getLatencyPos(arg0: number, arg1: number): number[];
        getVisibilityPercent(arg0: Internal.Entity_): number;
        getMaxSpawnClusterSize(): number;
        emf$prevZ(): number;
        getUsername(): string;
        move(arg0: Internal.MoverType_, arg1: Vec3d_): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        onRemovedFromWorld(): void;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        isPickable(): boolean;
        isInFluidType(predicate: Internal.BiPredicate_<any, any>, forAllTypes: boolean): boolean;
        setYHeadRot(arg0: number): void;
        setJumping(arg0: boolean): void;
        getPickResult(): Internal.ItemStack;
        "getMainHandItem()"(): Internal.ItemStack;
        getAbsorptionAmount(): number;
        findClosestNode(): number;
        getRandomY(): number;
        onEffectRemoved(arg0: Internal.MobEffectInstance_): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        getMobType(): Internal.MobType;
        travel(arg0: Vec3d_): void;
        maxhealthfix$setRestorePoint(arg0: number): void;
        getItemInHand(arg0: Internal.InteractionHand_): Internal.ItemStack;
        getFightOrigin(): BlockPos;
        handler$zzo000$isPushable(cir: Internal.CallbackInfoReturnable_<any>): void;
        shouldBeSaved(): boolean;
        getFluidTypeHeight(arg0: Internal.FluidType_): number;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityProvider)"(arg0: Internal.CapabilityProvider_<Internal.Entity>): boolean;
        removeTag(arg0: string): boolean;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        /**
         * @deprecated
        */
        getFluidHeight(arg0: Internal.TagKey_<Internal.Fluid>): number;
        canSpawnSoulSpeedParticle(): boolean;
        notifyAll(): void;
        aiStep(): void;
        getPassengersRidingOffset(): number;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        "isInFluidType(java.util.function.BiPredicate)"(arg0: Internal.BiPredicate_<Internal.FluidType, number>): boolean;
        distanceToEntitySqr(arg0: Internal.Entity_): number;
        isFrame(): boolean;
        broadcastBreakEvent(arg0: Internal.InteractionHand_): void;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        discard(): void;
        sendSystemMessage(arg0: net.minecraft.network.chat.Component_): void;
        acceptsSuccess(): boolean;
        setNoGravity(arg0: boolean): void;
        getUseItemRemainingTicks(): number;
        getIndirectPassengers(): Internal.Iterable<any>;
        attackable(): boolean;
        createCommandSourceStack(): Internal.CommandSourceStack;
        getNavigation(): Internal.PathNavigation;
        isControlledByLocalInstance(): boolean;
        isMonster(): boolean;
        getLastClimbablePos(): Internal.Optional<BlockPos>;
        getEatingSound(arg0: Internal.ItemStack_): Internal.SoundEvent;
        setId(arg0: number): void;
        getPerceivedTargetDistanceSquareForMeleeAttack(arg0: Internal.LivingEntity_): number;
        getHorizontalFacing(): Internal.Direction;
        onSyncedDataUpdated(arg0: Internal.List_<Internal.SynchedEntityData$DataValue<any>>): void;
        getType(): string;
        isDamageSourceBlocked(arg0: DamageSource_): boolean;
        handler$zzo000$variantsandventures$isInvulnerableTo(damageSource: DamageSource_, cir: Internal.CallbackInfoReturnable_<any>): void;
        getLightProbePosition(arg0: number): Vec3d;
        getActiveEffectsMap(): Internal.Map<Internal.MobEffect, Internal.MobEffectInstance>;
        emf$prevX(): number;
        onEquipItem(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_): void;
        checkDespawn(): void;
        lookAt(arg0: Internal.Entity_, arg1: number, arg2: number): void;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        equipItemIfPossible(arg0: Internal.ItemStack_): Internal.ItemStack;
        onSyncedDataUpdated(arg0: Internal.EntityDataAccessor_<any>): void;
        redirect$dpc000$fixSpawnAnimX(instance: Internal.Mob_, v: number): number;
        lerpHeadTo(arg0: number, arg1: number): void;
        redirect$bbh000$apoth_applyProtPen(arg0: number, arg1: number, arg2: DamageSource_, arg3: number): number;
        getHeadPartYOffset(arg0: number, arg1: number[], arg2: number[]): number;
        canDisableShield(): boolean;
        setMotionX(x: number): void;
        getHandSlots(): Internal.Iterable<Internal.ItemStack>;
        distanceToEntity(arg0: Internal.Entity_): number;
        bookshelf$getDeathSound(): Internal.SoundEvent;
        wait(arg0: number, arg1: number): void;
        getTeamColor(): number;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listenForCachedBlockChanges: boolean): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        "isInFluidType(net.minecraftforge.fluids.FluidType)"(arg0: Internal.FluidType_): boolean;
        checkSpawnObstruction(arg0: Internal.LevelReader_): boolean;
        extinguish(): void;
        getRestrictRadius(): number;
        moveTo(arg0: Vec3d_): void;
        isColliding(arg0: BlockPos_, arg1: Internal.BlockState_): boolean;
        "swing(net.minecraft.world.InteractionHand)"(hand: Internal.InteractionHand_): void;
        getRegisteredNavigation(): Internal.PathNavigation;
        isForcedVisible(): boolean;
        isInvertedHealAndHarm(): boolean;
        canHoldItem(arg0: Internal.ItemStack_): boolean;
        killedEntity(arg0: Internal.ServerLevel_, arg1: Internal.LivingEntity_): boolean;
        getClassification(arg0: boolean): Internal.MobCategory;
        isFreezing(): boolean;
        runCommand(command: string): number;
        setGuaranteedDrop(arg0: Internal.EquipmentSlot_): void;
        handler$bpk000$onFire(arg0: Internal.CallbackInfoReturnable_<any>): void;
        setSharedFlagOnFire(arg0: boolean): void;
        set defaultMovementSpeedMultiplier(speed: number)
        get suppressingBounce(): boolean
        set target(arg0: Internal.LivingEntity_)
        set culled(value: boolean)
        get onFire(): boolean
        get positionCodec(): Internal.VecDeltaCodec
        set maxUpStep(arg0: number)
        get fallFlyingTicks(): number
        set xxa(arg0: number)
        set delayedLeashHolderId(arg0: number)
        get shiftKeyDown(): boolean
        set UUID(arg0: Internal.UUID_)
        set motionZ(z: number)
        get isInsideStructureTracker(): Internal.IsInsideStructureTracker
        get blockY(): number
        get spectator(): boolean
        set mainHandItem(item: Internal.ItemStack_)
        get persistentData(): Internal.CompoundTag
        get health(): number
        get maxHealth(): number
        get registeredToWorld(): boolean
        set aggressive(arg0: boolean)
        set removed(arg0: Internal.Entity$RemovalReason_)
        get inWaterRainOrBubble(): boolean
        get removalReason(): Internal.Entity$RemovalReason
        set level(arg0: Internal.Level_)
        set boundingBox(arg0: Internal.AABB_)
        get ambientCreature(): boolean
        get GUID(): Internal.UUID
        set zza(arg0: number)
        get block(): Internal.BlockContainerJS
        get name(): net.minecraft.network.chat.Component
        get controlledVehicle(): Internal.Entity
        get armorValue(): number
        get killCredit(): Internal.LivingEntity
        set outOfCamera(value: boolean)
        get autoSpinAttack(): boolean
        get remainingFireTicks(): number
        get maxFallDistance(): number
        get ticksFrozen(): number
        get voicePitch(): number
        set statusMessage(message: net.minecraft.network.chat.Component_)
        set sleepingPos(arg0: BlockPos_)
        get descending(): boolean
        get headRotSpeed(): number
        get YHeadRot(): number
        set absorptionAmount(arg0: number)
        set deltaMovement(arg0: Vec3d_)
        get baby(): boolean
        get culled(): boolean
        get glowing(): boolean
        get leashOffset(): Vec3d
        get attackable(): boolean
        get underWater(): boolean
        get leashHolder(): Internal.Entity
        get sensing(): Internal.Sensing
        get legsArmorItem(): Internal.ItemStack
        get selfAndPassengers(): Internal.Stream<any>
        get deltaMovement(): Vec3d
        set secondsOnFire(arg0: number)
        get "displayName()"(): net.minecraft.network.chat.Component
        get lootTable(): ResourceLocation
        get ticksUsingItem(): number
        get arrowCount(): number
        get moveControl(): Internal.MoveControl
        get defaultMovementSpeed(): number
        get peacefulCreature(): boolean
        set onGround(arg0: boolean)
        get firstTick(): boolean
        get lastHurtByMobTimestamp(): number
        get vehicle(): Internal.Entity
        get effectiveAi(): boolean
        set spawnCancelled(arg0: boolean)
        get stringUuid(): string
        set swimming(arg0: boolean)
        get mainArm(): Internal.HumanoidArm
        get rotationVector(): Internal.Vec2
        get hurtDir(): number
        get sprinting(): boolean
        get motionY(): number
        get offhandItem(): Internal.ItemStack
        get isInsidePortal(): boolean
        get lastHurtMob(): Internal.LivingEntity
        get addedToWorld(): boolean
        get soundSource(): Internal.SoundSource
        get lastDamageSource(): DamageSource
        set noActionTime(arg0: number)
        set movementSpeedAddition(speed: number)
        get pose(): Internal.Pose
        get phaseManager(): Internal.EnderDragonPhaseManager
        get restrictCenter(): BlockPos
        get leftHanded(): boolean
        set z(z: number)
        get y(): number
        get blocking(): boolean
        /**
         * @deprecated
        */
        get pushedByFluid(): boolean
        get armorCoverPercentage(): number
        get airSupply(): number
        get player(): boolean
        get animal(): boolean
        get motionDirection(): Internal.Direction
        get fabricBalmData(): Internal.CompoundTag
        get commandSenderWorld(): Internal.Level
        get totalMovementSpeed(): number
        get attributes(): Internal.AttributeMap
        get spawnCancelled(): boolean
        get swimming(): boolean
        set sprinting(arg0: boolean)
        set x(x: number)
        get blockStateOn(): Internal.BlockState
        get portalWaitTime(): number
        get fluidJumpThreshold(): number
        set airSupply(arg0: number)
        get onPos(): BlockPos
        get undead(): boolean
        get stepHeight(): number
        set registeredToWorld(navigation: Internal.PathNavigation_)
        get sleeping(): boolean
        get dismountPoses(): Internal.ImmutableList<Internal.Pose>
        get lastHurtMobTimestamp(): number
        set remainingFireTicks(arg0: number)
        /**
         * @deprecated
        */
        get onPosLegacy(): BlockPos
        set pos(arg0: Vec3d_)
        set canPickUpLoot(arg0: boolean)
        get mainHandItem(): Internal.ItemStack
        set silent(arg0: boolean)
        set leftHanded(arg0: boolean)
        get activeEffects(): Internal.Collection<Internal.MobEffectInstance>
        get onPortalCooldown(): boolean
        set pitch(arg0: number)
        get multipartEntity(): boolean
        get parts(): Internal.PartEntity<any>[]
        get usingItem(): boolean
        get alwaysTicking(): boolean
        get forgePersistentData(): Internal.CompoundTag
        set invulnerable(arg0: boolean)
        get inFluidType(): boolean
        set glowing(arg0: boolean)
        get alive(): boolean
        get bbHeight(): number
        get tags(): Internal.Set<string>
        get lastAttacker(): Internal.LivingEntity
        get goalSelector(): Internal.GoalSelector
        get subEntities(): Internal.EnderDragonPart[]
        get percentFrozen(): number
        set portalCooldown(arg0: number)
        set position(block: Internal.BlockContainerJS_)
        get leashed(): boolean
        set pose(arg0: Internal.Pose_)
        get reachDistance(): number
        get entityType(): Internal.EntityType<any>
        get waterCreature(): boolean
        set lastHurtByPlayer(arg0: Internal.Player_)
        get "server()"(): Internal.MinecraftServer
        get pushable(): boolean
        set YBodyRot(arg0: number)
        set motionY(y: number)
        set fightOrigin(arg0: BlockPos_)
        set chestArmorItem(item: Internal.ItemStack_)
        get passenger(): boolean
        get sensitiveToWater(): boolean
        get jumpControl(): Internal.JumpControl
        get flapping(): boolean
        get feetArmorItem(): Internal.ItemStack
        get viewScale(): number
        get visualRotationYInDegrees(): number
        set speed(arg0: number)
        get discrete(): boolean
        get level(): Internal.Level
        get combatTracker(): Internal.CombatTracker
        get noAi(): boolean
        get chestArmorItem(): Internal.ItemStack
        get dragonFight(): Internal.EndDragonFight
        get fullyFrozen(): boolean
        get lastPos(): BlockPos
        get inWall(): boolean
        get allSlots(): Internal.Iterable<Internal.ItemStack>
        get scale(): number
        get suppressingSlidingDownLadder(): boolean
        get blockZ(): number
        get silent(): boolean
        get pitch(): number
        get random(): Internal.RandomSource
        get passengersAndSelf(): Internal.Stream<any>
        get noActionTime(): number
        get visuallyCrawling(): boolean
        get aggressive(): boolean
        set yya(arg0: number)
        set baby(arg0: boolean)
        get lastHurtByMob(): Internal.LivingEntity
        get inWaterOrBubble(): boolean
        get portalCooldown(): number
        get item(): Internal.ItemStack
        get ignoringBlockTriggers(): boolean
        get inRain(): boolean
        get eyeInFluidType(): Internal.FluidType
        get steppingCarefully(): boolean
        /**
         * @deprecated
        */
        get lightLevelDependentMagicValue(): number
        get blockX(): number
        get fallFlying(): boolean
        get encodeId(): string
        get maxHeadXRot(): number
        get nbt(): Internal.CompoundTag
        set invisible(arg0: boolean)
        set totalMovementSpeedMultiplier(speed: number)
        set health(arg0: number)
        get eyePosition(): Vec3d
        get eyeHeight(): number
        set discardFriction(arg0: boolean)
        get yaw(): number
        get usedItemHand(): Internal.InteractionHand
        set defaultMovementSpeed(speed: number)
        get brain(): Internal.Brain<any>
        set customNameVisible(arg0: boolean)
        get controllingPassenger(): Internal.LivingEntity
        get scriptType(): Internal.ScriptType
        get forward(): Vec3d
        set feetArmorItem(item: Internal.ItemStack_)
        get id(): number
        get eyeY(): number
        get boundingBox(): Internal.AABB
        get inWaterOrRain(): boolean
        get affectedByPotions(): boolean
        get citadelEntityData(): Internal.CompoundTag
        get addEntityPacket(): Internal.Packet<Internal.ClientGamePacketListener>
        get team(): Internal.Team
        set ticksFrozen(arg0: number)
        get useItem(): Internal.ItemStack
        get myRidingOffset(): number
        get living(): boolean
        get x(): number
        get vehicle(): boolean
        set isInPowderSnow(arg0: boolean)
        set customName(arg0: net.minecraft.network.chat.Component_)
        get teamId(): string
        set stingerCount(arg0: number)
        get maxHeadYRot(): number
        get customNameVisible(): boolean
        get pistonPushReaction(): Internal.PushReaction
        get lootTableSeed(): number
        get motionX(): number
        get entityData(): Internal.SynchedEntityData
        get potionEffects(): Internal.EntityPotionEffectsJS
        get onRails(): boolean
        get stingerCount(): number
        get fallSounds(): Internal.LivingEntity$Fallsounds
        get dimensionChangingDelay(): number
        set yaw(arg0: number)
        get pickRadius(): number
        get removed(): boolean
        get jumpBoostPower(): number
        set shiftKeyDown(arg0: boolean)
        get passengers(): Internal.EntityArrayList
        get maxHeightFluidType(): Internal.FluidType
        get z(): number
        get server(): Internal.MinecraftServer
        get experienceReward(): number
        get firstPassenger(): Internal.Entity
        get spawnType(): Internal.MobSpawnType
        set lastHurtMob(arg0: Internal.Entity_)
        set lastHurtByMob(arg0: Internal.LivingEntity_)
        set fabricBalmData(arg0: Internal.CompoundTag_)
        get sleepingPos(): Internal.Optional<any>
        get lookAngle(): Vec3d
        get ambientSoundInterval(): number
        set arrowCount(arg0: number)
        get motionZ(): number
        get persistenceRequired(): boolean
        get invisible(): boolean
        get bedOrientation(): Internal.Direction
        get profile(): Internal.GameProfile
        get deadOrDying(): boolean
        set headArmorItem(item: Internal.ItemStack_)
        set viewScale(arg0: number)
        set levelCallback(arg0: Internal.EntityInLevelCallback_)
        get lookControl(): Internal.LookControl
        get offHandItem(): Internal.ItemStack
        get outOfCamera(): boolean
        get crouching(): boolean
        set y(y: number)
        get feetBlockState(): Internal.BlockState
        get withinRestriction(): boolean
        get customName(): net.minecraft.network.chat.Component
        get class(): typeof any
        get visuallySwimming(): boolean
        get maxAirSupply(): number
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get boundingBoxForCulling(): Internal.AABB
        get target(): Internal.LivingEntity
        get nameTagOffsetY(): number
        get currentSwingDuration(): number
        get invulnerable(): boolean
        get inLava(): boolean
        get inWater(): boolean
        get rootVehicle(): Internal.Entity
        get noGravity(): boolean
        set citadelEntityData(arg0: Internal.CompoundTag_)
        get speed(): number
        get cachedFeetBlockState(): Internal.BlockState
        get uuid(): Internal.UUID
        set offHandItem(item: Internal.ItemStack_)
        set noAi(arg0: boolean)
        get armorSlots(): Internal.Iterable<Internal.ItemStack>
        set dragonFight(arg0: Internal.EndDragonFight_)
        get headArmorItem(): Internal.ItemStack
        get bbWidth(): number
        get "name()"(): net.minecraft.network.chat.Component
        get ticksRequiredToFreeze(): number
        get maxSpawnClusterSize(): number
        get username(): string
        get pickable(): boolean
        set YHeadRot(arg0: number)
        set jumping(arg0: boolean)
        get pickResult(): Internal.ItemStack
        get "mainHandItem()"(): Internal.ItemStack
        get absorptionAmount(): number
        get randomY(): number
        get displayName(): net.minecraft.network.chat.Component
        get mobType(): Internal.MobType
        get fightOrigin(): BlockPos
        get passengersRidingOffset(): number
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        set noGravity(arg0: boolean)
        get useItemRemainingTicks(): number
        get indirectPassengers(): Internal.Iterable<any>
        get navigation(): Internal.PathNavigation
        get controlledByLocalInstance(): boolean
        get monster(): boolean
        get lastClimbablePos(): Internal.Optional<BlockPos>
        set id(arg0: number)
        get horizontalFacing(): Internal.Direction
        get type(): string
        get activeEffectsMap(): Internal.Map<Internal.MobEffect, Internal.MobEffectInstance>
        set motionX(x: number)
        get handSlots(): Internal.Iterable<Internal.ItemStack>
        get teamColor(): number
        set nbt(nbt: Internal.CompoundTag_)
        get restrictRadius(): number
        get registeredNavigation(): Internal.PathNavigation
        get forcedVisible(): boolean
        get invertedHealAndHarm(): boolean
        get freezing(): boolean
        set guaranteedDrop(arg0: Internal.EquipmentSlot_)
        set sharedFlagOnFire(arg0: boolean)
        oFlapTime: number;
        nearestCrystal: Internal.EndCrystal;
        flapTime: number;
        static readonly DATA_PHASE: Internal.EntityDataAccessor<number>;
        yRotA: number;
        readonly head: Internal.EnderDragonPart;
        dragonDeathTime: number;
        readonly positions: number[][];
        posPointer: number;
        inWall: boolean;
    }
    type EnderDragon_ = EnderDragon;
    interface IConveyorType <T extends Internal.IConveyorBelt> {
        abstract acceptsCovers(): boolean;
        abstract isTicking(): boolean;
        abstract canBeDyed(): boolean;
        abstract getId(): ResourceLocation;
        abstract makeInstance(arg0: Internal.BlockEntity_): T;
        abstract initClientData(arg0: Internal.Consumer_<Internal.IConveyorModelRender<T>>): void;
        get ticking(): boolean
        get id(): ResourceLocation
    }
    type IConveyorType_<T extends Internal.IConveyorBelt> = IConveyorType<T>;
    abstract class KeyFrameData {
        constructor(arg0: number)
        getClass(): typeof any;
        hashCode(): number;
        getStartTick(): number;
        toString(): string;
        wait(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        get class(): typeof any
        get startTick(): number
    }
    type KeyFrameData_ = KeyFrameData;
    class TileEntityMechanicalPipe extends Internal.TileEntityTransmitter implements Internal.IComputerTile {
        constructor(blockProvider: Internal.IBlockProvider_, pos: BlockPos_, state: Internal.BlockState_)
        emf$hasVehicle(): boolean;
        requestModelDataUpdate(): void;
        etf$getType(): Internal.EntityType<any>;
        emf$getVelocity(): Vec3d;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityDispatcher)"(arg0: Internal.CapabilityDispatcher_): boolean;
        sideChanged(side: Internal.Direction_, old: Internal.ConnectionType_, type: Internal.ConnectionType_): void;
        etf$isBlockEntity(): boolean;
        getComputerName(): string;
        hasComputerSupport(): boolean;
        /**
         * @deprecated
        */
        setBlockState(arg0: Internal.BlockState_): void;
        handler$dbg000$setLevel(arg0: Internal.Level_, arg1: Internal.CallbackInfo_): void;
        load(nbt: Internal.CompoundTag_): void;
        setForceUpdate(): void;
        setChanged(): void;
        setCulled(value: boolean): void;
        "invalidateCapabilities(java.util.Collection,net.minecraft.core.Direction)"(capabilities: Internal.Collection_<Internal.Capability<any>>, side: Internal.Direction_): void;
        saveWithoutMetadata(): Internal.CompoundTag;
        setTimeout(): void;
        handler$bkf000$injectUnload(arg0: boolean, arg1: Internal.CallbackInfo_): void;
        getReducedUpdateTag(): Internal.CompoundTag;
        isOutOfCamera(): boolean;
        "getUpdatePacket()"(): Internal.Packet<any>;
        emf$prevZ(): number;
        etf$canBeBright(): boolean;
        onSneakRightClick(player: Internal.Player_, side: Internal.Direction_): Internal.InteractionResult;
        setRemoved(): void;
        onNeighborTileChange(side: Internal.Direction_): void;
        invalidateCapability(capability: Internal.Capability_<any>, ...sides: Internal.Direction_[]): void;
        emf$isOnGround(): boolean;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        invalidateCapabilities(capabilities: Internal.Collection_<Internal.Capability<any>>, ...sides: Internal.Direction_[]): void;
        etf$getPose(): Internal.Pose;
        etf$getEntityKey(): string;
        isCulled(): boolean;
        getType(): Internal.BlockEntityType<any>;
        onSneakRightClick(player: Internal.Player_): Internal.InteractionResult;
        etf$getOptifineId(): number;
        "invalidateCapability(net.minecraftforge.common.capabilities.Capability,net.minecraft.core.Direction)"(capability: Internal.Capability_<any>, side: Internal.Direction_): void;
        onAdded(): void;
        "getUpdatePacket()"(): Internal.ClientboundBlockEntityDataPacket;
        getRenderBoundingBox(): Internal.AABB;
        markDirtyComparator(): void;
        getClass(): typeof any;
        emf$isInvisible(): boolean;
        sendUpdatePacket(): void;
        static getPosFromTag(arg0: Internal.CompoundTag_): BlockPos;
        handler$bkf000$injectSaveCover(arg0: Internal.CallbackInfoReturnable_<any>): void;
        etf$distanceTo(entity: Internal.Entity_): number;
        emf$isSprinting(): boolean;
        isLoaded(): boolean;
        hasAnyComparatorNearby(): boolean;
        onChunkUnloaded(): void;
        saveToItem(arg0: Internal.ItemStack_): void;
        "deserializeNBT(net.minecraft.nbt.CompoundTag)"(arg0: Internal.CompoundTag_): void;
        static addEntityType(arg0: Internal.CompoundTag_, arg1: Internal.BlockEntityType_<any>): void;
        emf$isInLava(): boolean;
        "deserializeNBT(net.minecraft.nbt.Tag)"(arg0: Internal.Tag_): void;
        onComparatorAdded(direction: Internal.Direction_, offset: number): void;
        getTransmitterType(): Internal.TransmitterType;
        getComputerMethods(holder: Internal.BoundMethodHolder_): void;
        mekanism_covers$setCoverState(arg0: Internal.BlockState_): void;
        clearRemoved(): void;
        emf$isWet(): boolean;
        getUpdatePacket(): Internal.Packet<any>;
        getTileChunk(): Internal.Chunk3D;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityProvider)"(arg0: Internal.CapabilityProvider_<Internal.BlockEntity>): boolean;
        handler$dbg000$setRemoved(arg0: Internal.CallbackInfo_): void;
        getPersistentData(): Internal.CompoundTag;
        toString(): string;
        triggerEvent(arg0: number, arg1: number): boolean;
        emf$isGlowing(): boolean;
        hasLevel(): boolean;
        notifyAll(): void;
        getTileWorld(): Internal.Level;
        etf$getScoreboardTeam(): Internal.Team;
        emf$getZ(): number;
        invalidateCapabilities(capabilities: Internal.Collection_<Internal.Capability<any>>, side: Internal.Direction_): void;
        invalidateCachedCapabilities(): void;
        mekanism_covers$onUpdateClient(): void;
        setType_HammerLib(arg0: Internal.BlockEntityType_<any>): void;
        wait(arg0: number): void;
        etf$getItemsEquipped(): Internal.Iterable<any>;
        etf$getVelocity(): Vec3d;
        isComputerCapabilityPersistent(): boolean;
        reviveCaps(): void;
        handleUpdatePacket(tag: Internal.CompoundTag_): void;
        etf$getWorld(): Internal.Level;
        getUpdateTag(): Internal.CompoundTag;
        handleUpdateTag(tag: Internal.CompoundTag_): void;
        getSideLookingAt(player: Internal.Player_): Internal.Direction;
        emf$getYaw(): number;
        setLevel(world: Internal.Level_): void;
        notify(): void;
        chunkAccessibilityChange(loaded: boolean): void;
        getBlockPos(): BlockPos;
        etf$getNbt(): Internal.CompoundTag;
        isRemoved(): boolean;
        emf$isSneaking(): boolean;
        static tickServer(level: Internal.Level_, pos: BlockPos_, state: Internal.BlockState_, transmitter: Internal.TileEntityTransmitter_): void;
        etf$getBlockPos(): BlockPos;
        onLoad(): void;
        fillCrashReportCategory(arg0: Internal.CrashReportCategory_): void;
        emf$prevPitch(): number;
        "invalidateCapability(net.minecraftforge.common.capabilities.Capability,net.minecraft.core.Direction[])"(capability: Internal.Capability_<any>, ...sides: Internal.Direction_[]): void;
        etf$getBlockY(): number;
        markForSave(): void;
        etf$getHandItems(): Internal.Iterable<any>;
        invalidateCaps(): void;
        getTilePos(): BlockPos;
        etf$getArmorItems(): Internal.Iterable<any>;
        emf$getY(): number;
        emf$prevX(): number;
        getTileCoord(): Internal.Coord4D;
        getBlockState(): Internal.BlockState;
        emf$age(): number;
        etf$hasCustomName(): boolean;
        getSideLookingAt(player: Internal.Player_, fallback: Internal.Direction_): Internal.Direction;
        static loadStatic(arg0: BlockPos_, arg1: Internal.BlockState_, arg2: Internal.CompoundTag_): Internal.BlockEntity;
        wait(): void;
        sendUpdatePacket(tracking: Internal.BlockEntity_): void;
        emf$isTouchingWater(): boolean;
        m_183515_(nbtTags: Internal.CompoundTag_): void;
        emf$getVariableMap(): Internal.Object2FloatOpenHashMap<any>;
        areCapsCompatible(arg0: Internal.CapabilityDispatcher_): boolean;
        etf$getCustomName(): net.minecraft.network.chat.Component;
        getCapability<T>(capability: Internal.Capability_<T>, side: Internal.Direction_): Internal.LazyOptional<T>;
        saveWithId(): Internal.CompoundTag;
        getCollisionBoxes(): Internal.List<Internal.VoxelShape>;
        setOutOfCamera(value: boolean): void;
        onRightClick(player: Internal.Player_, side: Internal.Direction_): Internal.InteractionResult;
        wait(arg0: number, arg1: number): void;
        getLevel(): Internal.Level;
        onRightClick(player: Internal.Player_): Internal.InteractionResult;
        onlyOpCanSetNbt(): boolean;
        isRemote(): boolean;
        serializeNBT(): Internal.Tag;
        onNeighborBlockChange(side: Internal.Direction_): void;
        handler$bkf000$injectLoad(arg0: Internal.CompoundTag_, arg1: Internal.CallbackInfo_): void;
        onDataPacket(net: Internal.Connection_, pkt: Internal.ClientboundBlockEntityDataPacket_): void;
        saveWithFullMetadata(): Internal.CompoundTag;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        "invalidateCapabilities(java.util.Collection,net.minecraft.core.Direction[])"(capabilities: Internal.Collection_<Internal.Capability<any>>, ...sides: Internal.Direction_[]): void;
        emf$prevY(): number;
        emf$getX(): number;
        areCapsCompatible(arg0: Internal.CapabilityProvider_<Internal.BlockEntity>): boolean;
        emf$isOnFire(): boolean;
        deserializeNBT(arg0: Internal.Tag_): void;
        mekanism_covers$getCoverState(): Internal.BlockState;
        onAlloyInteraction(player: Internal.Player_, stack: Internal.ItemStack_, tier: Internal.AlloyTier_): void;
        etf$getUuid(): Internal.UUID;
        invalidateCapability(capability: Internal.Capability_<any>, side: Internal.Direction_): void;
        handler$bkf000$injectCoverModel(arg0: Internal.CallbackInfoReturnable_<any>): void;
        redstoneChanged(powered: boolean): void;
        getUpdatePacket(): Internal.ClientboundBlockEntityDataPacket;
        isForcedVisible(): boolean;
        emf$hasPassengers(): boolean;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        hashCode(): number;
        emf$getTypeString(): string;
        blockRemoved(): void;
        getTransmitter(): Internal.MechanicalPipe;
        getModelData(): Internal.ModelData;
        emf$getPitch(): number;
        emf$isAlive(): boolean;
        handler$bkf000$injectUpdateTag(arg0: Internal.CompoundTag_, arg1: Internal.CallbackInfo_): void;
        handler$bkf000$injectSaveCover(arg0: Internal.CompoundTag_, arg1: Internal.CallbackInfo_): void;
        equals(arg0: any): boolean;
        get computerName(): string
        /**
         * @deprecated
        */
        set blockState(arg0: Internal.BlockState_)
        set culled(value: boolean)
        get reducedUpdateTag(): Internal.CompoundTag
        get outOfCamera(): boolean
        get "updatePacket()"(): Internal.Packet<any>
        get culled(): boolean
        get type(): Internal.BlockEntityType<any>
        get "updatePacket()"(): Internal.ClientboundBlockEntityDataPacket
        get renderBoundingBox(): Internal.AABB
        get class(): typeof any
        get loaded(): boolean
        get transmitterType(): Internal.TransmitterType
        get updatePacket(): Internal.Packet<any>
        get tileChunk(): Internal.Chunk3D
        get persistentData(): Internal.CompoundTag
        get tileWorld(): Internal.Level
        set type_HammerLib(arg0: Internal.BlockEntityType_<any>)
        get computerCapabilityPersistent(): boolean
        get updateTag(): Internal.CompoundTag
        set level(world: Internal.Level_)
        get blockPos(): BlockPos
        get removed(): boolean
        get tilePos(): BlockPos
        get tileCoord(): Internal.Coord4D
        get blockState(): Internal.BlockState
        get collisionBoxes(): Internal.List<Internal.VoxelShape>
        set outOfCamera(value: boolean)
        get level(): Internal.Level
        get remote(): boolean
        get updatePacket(): Internal.ClientboundBlockEntityDataPacket
        get forcedVisible(): boolean
        get transmitter(): Internal.MechanicalPipe
        get modelData(): Internal.ModelData
    }
    type TileEntityMechanicalPipe_ = TileEntityMechanicalPipe;
    interface Delayed extends Internal.Comparable<Internal.Delayed> {
        abstract getDelay(arg0: Internal.TimeUnit_): number;
        abstract compareTo(arg0: Internal.Delayed_): number;
    }
    type Delayed_ = Delayed;
    interface TemplateAccessor {
        abstract repurposedstructures_getPalettes(): Internal.List<Internal.StructureTemplate$Palette>;
        (): Internal.List_<Internal.StructureTemplate$Palette>;
    }
    type TemplateAccessor_ = TemplateAccessor | (()=> Internal.List_<Internal.StructureTemplate$Palette>);
    class WrenchResult extends Internal.Enum<Internal.WrenchResult> {
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        getClass(): typeof any;
        static valueOf(name: string): Internal.WrenchResult;
        toString(): string;
        notifyAll(): void;
        "compareTo(mekanism.common.tile.base.WrenchResult)"(arg0: Internal.WrenchResult_): number;
        describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<Internal.WrenchResult>>;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        compareTo(arg0: any): number;
        name(): string;
        static values(): Internal.WrenchResult[];
        hashCode(): number;
        ordinal(): number;
        wait(): void;
        wait(arg0: number): void;
        getDeclaringClass(): typeof Internal.WrenchResult;
        "compareTo(java.lang.Object)"(arg0: any): number;
        equals(arg0: any): boolean;
        compareTo(arg0: Internal.WrenchResult_): number;
        get class(): typeof any
        get declaringClass(): typeof Internal.WrenchResult
        static readonly PASS: (Internal.WrenchResult) & (Internal.WrenchResult);
        static readonly SUCCESS: (Internal.WrenchResult) & (Internal.WrenchResult);
        static readonly NO_SECURITY: (Internal.WrenchResult) & (Internal.WrenchResult);
        static readonly DISMANTLED: (Internal.WrenchResult) & (Internal.WrenchResult);
    }
    type WrenchResult_ = WrenchResult | "pass" | "no_security" | "success" | "dismantled";
    /**
     * @deprecated
     * This class is marked to be removed in future!
    */
    interface DomainCombiner {
        abstract combine(arg0: Internal.ProtectionDomain_[], arg1: Internal.ProtectionDomain_[]): Internal.ProtectionDomain[];
        (arg0: Internal.ProtectionDomain[], arg1: Internal.ProtectionDomain[]): Internal.ProtectionDomain_[];
    }
    type DomainCombiner_ = DomainCombiner | ((arg0: Internal.ProtectionDomain[], arg1: Internal.ProtectionDomain[])=> Internal.ProtectionDomain_[]);
    class FilterMask {
        constructor(arg0: number)
        getClass(): typeof any;
        static read(arg0: Internal.FriendlyByteBuf_): Internal.FilterMask;
        toString(): string;
        notifyAll(): void;
        isEmpty(): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        apply(arg0: string): string;
        hashCode(): number;
        applyWithFormatting(arg0: string): net.minecraft.network.chat.Component;
        wait(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        setFiltered(arg0: number): void;
        static write(arg0: Internal.FriendlyByteBuf_, arg1: Internal.FilterMask_): void;
        isFullyFiltered(): boolean;
        get class(): typeof any
        get empty(): boolean
        set filtered(arg0: number)
        get fullyFiltered(): boolean
        static readonly CODEC: Internal.Codec<Internal.FilterMask>;
        static readonly FILTERED_STYLE: (Internal.Style) & (Internal.Style);
        static readonly PASS_THROUGH: (Internal.FilterMask) & (Internal.FilterMask);
        static readonly FULLY_FILTERED: (Internal.FilterMask) & (Internal.FilterMask);
    }
    type FilterMask_ = FilterMask;
    class ChargerBlockEntity extends Internal.AENetworkPowerBlockEntity implements Internal.IGridTickable {
        constructor(arg0: Internal.BlockEntityType_<any>, arg1: BlockPos_, arg2: Internal.BlockState_)
        emf$hasVehicle(): boolean;
        injectAEPower(arg0: number, arg1: Internal.Actionable_): number;
        requestModelDataUpdate(): void;
        etf$getType(): Internal.EntityType<any>;
        emf$getVelocity(): Vec3d;
        disassembleWithWrench(arg0: Internal.Player_, arg1: Internal.Level_, arg2: Internal.BlockHitResult_, arg3: Internal.ItemStack_): Internal.InteractionResult;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityDispatcher)"(arg0: Internal.CapabilityDispatcher_): boolean;
        etf$isBlockEntity(): boolean;
        isWorking(): boolean;
        exportSettings(arg0: Internal.SettingsFrom_, arg1: Internal.CompoundTag_, arg2: Internal.Player_): void;
        setBlockState(arg0: Internal.BlockState_): void;
        handler$dbg000$setLevel(arg0: Internal.Level_, arg1: Internal.CallbackInfo_): void;
        load(arg0: Internal.CompoundTag_): void;
        setChanged(): void;
        setName(arg0: string): void;
        setCulled(value: boolean): void;
        getMainNode(): Internal.IManagedGridNode;
        saveWithoutMetadata(): Internal.CompoundTag;
        setTimeout(): void;
        isOutOfCamera(): boolean;
        getGridNode(arg0: Internal.Direction_): Internal.IGridNode;
        emf$prevZ(): number;
        getPowerFlow(): Internal.AccessRestriction;
        abstract isClientSide(): boolean;
        etf$canBeBright(): boolean;
        setRemoved(): void;
        emf$isOnGround(): boolean;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        etf$getPose(): Internal.Pose;
        etf$getEntityKey(): string;
        hasCustomName(): boolean;
        isCulled(): boolean;
        getSubInventory(arg0: ResourceLocation_): Internal.InternalInventory;
        getType(): Internal.BlockEntityType<any>;
        setInternalPublicPowerStorage(arg0: boolean): void;
        getActionableNode(): Internal.IGridNode;
        etf$getOptifineId(): number;
        setOwner(arg0: Internal.Player_): void;
        addAdditionalDrops(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.List_<Internal.ItemStack>): void;
        getCustomName(): net.minecraft.network.chat.Component;
        getRenderBoundingBox(): Internal.AABB;
        getAEMaxPower(): number;
        getDisplayName(): net.minecraft.network.chat.Component;
        getClass(): typeof any;
        emf$isInvisible(): boolean;
        ifGridPresent(arg0: Internal.Consumer_<Internal.IGrid>): boolean;
        static getPosFromTag(arg0: Internal.CompoundTag_): BlockPos;
        injectExternalPower(arg0: Internal.PowerUnits_, arg1: number, arg2: Internal.Actionable_): number;
        markForUpdate(): void;
        getTop(): Internal.Direction;
        etf$distanceTo(entity: Internal.Entity_): number;
        emf$isSprinting(): boolean;
        hasAnyComparatorNearby(): boolean;
        loadTag(arg0: Internal.CompoundTag_): void;
        onChunkUnloaded(): void;
        saveToItem(arg0: Internal.ItemStack_): void;
        "deserializeNBT(net.minecraft.nbt.CompoundTag)"(arg0: Internal.CompoundTag_): void;
        static addEntityType(arg0: Internal.CompoundTag_, arg1: Internal.BlockEntityType_<any>): void;
        emf$isInLava(): boolean;
        "deserializeNBT(net.minecraft.nbt.Tag)"(arg0: Internal.Tag_): void;
        onComparatorAdded(direction: Internal.Direction_, offset: number): void;
        getGlobalPos(): Internal.GlobalPos;
        getUpdatePacket(): Internal.Packet<Internal.ClientGamePacketListener>;
        clearRemoved(): void;
        importSettings(arg0: Internal.SettingsFrom_, arg1: Internal.CompoundTag_, arg2: Internal.Player_): void;
        emf$isWet(): boolean;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityProvider)"(arg0: Internal.CapabilityProvider_<Internal.BlockEntity>): boolean;
        handler$dbg000$setRemoved(arg0: Internal.CallbackInfo_): void;
        getReadyInvoked(): number;
        setInternalCurrentPower(arg0: number): void;
        getCableConnectionType(arg0: Internal.Direction_): Internal.AECableType;
        getPersistentData(): Internal.CompoundTag;
        toString(): string;
        triggerEvent(arg0: number, arg1: number): boolean;
        emf$isGlowing(): boolean;
        hasLevel(): boolean;
        notifyAll(): void;
        etf$getScoreboardTeam(): Internal.Team;
        emf$getZ(): number;
        getExternalPowerDemand(arg0: Internal.PowerUnits_, arg1: number): number;
        getGridConnectableSides(arg0: Internal.BlockOrientation_): Internal.Set<Internal.Direction>;
        onReady(): void;
        setType_HammerLib(arg0: Internal.BlockEntityType_<any>): void;
        wait(arg0: number): void;
        tickingRequest(arg0: Internal.IGridNode_, arg1: number): Internal.TickRateModulation;
        etf$getItemsEquipped(): Internal.Iterable<any>;
        onChangeInventory(arg0: Internal.InternalInventory_, arg1: number): void;
        static registerBlockEntityItem(arg0: Internal.BlockEntityType_<any>, arg1: Internal.Item_): void;
        etf$getVelocity(): Vec3d;
        clearContent(): void;
        reviveCaps(): void;
        static tryClear(arg0: any): void;
        etf$getWorld(): Internal.Level;
        getUpdateTag(): Internal.CompoundTag;
        emf$getYaw(): number;
        handleUpdateTag(arg0: Internal.CompoundTag_): void;
        getAECurrentPower(): number;
        setLevel(arg0: Internal.Level_): void;
        notify(): void;
        onMainNodeStateChanged(arg0: Internal.IGridNodeListener$State_): void;
        getBlockPos(): BlockPos;
        etf$getNbt(): Internal.CompoundTag;
        isRemoved(): boolean;
        getInternalMaxPower(): number;
        emf$isSneaking(): boolean;
        etf$getBlockPos(): BlockPos;
        onLoad(): void;
        getInternalCurrentPower(): number;
        fillCrashReportCategory(arg0: Internal.CrashReportCategory_): void;
        emf$prevPitch(): number;
        getGridNode(): Internal.IGridNode;
        etf$getBlockY(): number;
        getTickingRequest(arg0: Internal.IGridNode_): Internal.TickingRequest;
        etf$getHandItems(): Internal.Iterable<any>;
        etf$getArmorItems(): Internal.Iterable<any>;
        emf$getY(): number;
        invalidateCaps(): void;
        notLoaded(): boolean;
        getName(): net.minecraft.network.chat.Component;
        emf$prevX(): number;
        getBlockState(): Internal.BlockState;
        getBlockEntity(): Internal.BlockEntity;
        emf$age(): number;
        etf$hasCustomName(): boolean;
        getPriority(): number;
        static loadStatic(arg0: BlockPos_, arg1: Internal.BlockState_, arg2: Internal.CompoundTag_): Internal.BlockEntity;
        wait(): void;
        emf$isTouchingWater(): boolean;
        m_183515_(arg0: Internal.CompoundTag_): void;
        emf$getVariableMap(): Internal.Object2FloatOpenHashMap<any>;
        areCapsCompatible(arg0: Internal.CapabilityDispatcher_): boolean;
        setInternalMaxPower(arg0: number): void;
        abstract saveChanges(): void;
        etf$getCustomName(): net.minecraft.network.chat.Component;
        getCapability<T>(arg0: Internal.Capability_<T>, arg1: Internal.Direction_): Internal.LazyOptional<T>;
        saveWithId(): Internal.CompoundTag;
        setOutOfCamera(value: boolean): void;
        wait(arg0: number, arg1: number): void;
        getLevel(): Internal.Level;
        onlyOpCanSetNbt(): boolean;
        getOrientation(): Internal.BlockOrientation;
        serializeNBT(): Internal.Tag;
        getInternalInventory(): Internal.InternalInventory;
        saveWithFullMetadata(): Internal.CompoundTag;
        onDataPacket(arg0: Internal.Connection_, arg1: Internal.ClientboundBlockEntityDataPacket_): void;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        emf$prevY(): number;
        activate(arg0: Internal.Player_): void;
        emf$getX(): number;
        areCapsCompatible(arg0: Internal.CapabilityProvider_<Internal.BlockEntity>): boolean;
        emf$isOnFire(): boolean;
        deserializeNBT(arg0: Internal.Tag_): void;
        isAEPublicPowerStorage(): boolean;
        etf$getUuid(): Internal.UUID;
        setInternalPowerFlow(arg0: Internal.AccessRestriction_): void;
        extractAEPower(arg0: number, arg1: Internal.Actionable_, arg2: Internal.PowerMultiplier_): number;
        isForcedVisible(): boolean;
        getQueuedForReady(): number;
        emf$hasPassengers(): boolean;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        hashCode(): number;
        getFront(): Internal.Direction;
        emf$getTypeString(): string;
        getCrankable(arg0: Internal.Direction_): Internal.ICrankable;
        getModelData(): Internal.ModelData;
        emf$getPitch(): number;
        emf$isAlive(): boolean;
        equals(arg0: any): boolean;
        get working(): boolean
        set blockState(arg0: Internal.BlockState_)
        set name(arg0: string)
        set culled(value: boolean)
        get mainNode(): Internal.IManagedGridNode
        get outOfCamera(): boolean
        get powerFlow(): Internal.AccessRestriction
        get clientSide(): boolean
        get culled(): boolean
        get type(): Internal.BlockEntityType<any>
        set internalPublicPowerStorage(arg0: boolean)
        get actionableNode(): Internal.IGridNode
        set owner(arg0: Internal.Player_)
        get customName(): net.minecraft.network.chat.Component
        get renderBoundingBox(): Internal.AABB
        get AEMaxPower(): number
        get displayName(): net.minecraft.network.chat.Component
        get class(): typeof any
        get top(): Internal.Direction
        get globalPos(): Internal.GlobalPos
        get updatePacket(): Internal.Packet<Internal.ClientGamePacketListener>
        get readyInvoked(): number
        set internalCurrentPower(arg0: number)
        get persistentData(): Internal.CompoundTag
        set type_HammerLib(arg0: Internal.BlockEntityType_<any>)
        get updateTag(): Internal.CompoundTag
        get AECurrentPower(): number
        set level(arg0: Internal.Level_)
        get blockPos(): BlockPos
        get removed(): boolean
        get internalMaxPower(): number
        get internalCurrentPower(): number
        get gridNode(): Internal.IGridNode
        get name(): net.minecraft.network.chat.Component
        get blockState(): Internal.BlockState
        get blockEntity(): Internal.BlockEntity
        get priority(): number
        set internalMaxPower(arg0: number)
        set outOfCamera(value: boolean)
        get level(): Internal.Level
        get orientation(): Internal.BlockOrientation
        get internalInventory(): Internal.InternalInventory
        get AEPublicPowerStorage(): boolean
        set internalPowerFlow(arg0: Internal.AccessRestriction_)
        get forcedVisible(): boolean
        get queuedForReady(): number
        get front(): Internal.Direction
        get modelData(): Internal.ModelData
        static readonly POWER_MAXIMUM_AMOUNT: (1600) & (number);
    }
    type ChargerBlockEntity_ = ChargerBlockEntity;
    class LavaFluid$Flowing extends Internal.LavaFluid {
        constructor()
        getStateDefinition(): Internal.StateDefinition<Internal.Fluid, Internal.FluidState>;
        getFlow(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.FluidState_): Vec3d;
        isSource(arg0: Internal.FluidState_): boolean;
        getOwnHeight(arg0: Internal.FluidState_): number;
        notify(): void;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getShape(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        defaultFluidState(): Internal.FluidState;
        arch$holder(): Internal.Holder<Internal.Fluid>;
        getDripParticle(): Internal.ParticleOptions;
        getSlopeFindDistance(arg0: Internal.LevelReader_): number;
        getSource(arg0: boolean): Internal.FluidState;
        getExplosionResistance(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBucket(): Internal.Item;
        isSame(arg0: Internal.Fluid_): boolean;
        animateTick(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.FluidState_, arg3: Internal.RandomSource_): void;
        getAdjacentBlockPathType(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        canHydrate(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: BlockPos_): boolean;
        wait(): void;
        getFlowing(arg0: number, arg1: boolean): Internal.FluidState;
        supportsBoating(arg0: Internal.FluidState_, arg1: Internal.Boat_): boolean;
        /**
         * @deprecated
        */
        is(arg0: Internal.TagKey_<Internal.Fluid>): boolean;
        getClass(): typeof any;
        tick(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.FluidState_): void;
        getHeight(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        canBeReplacedWith(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Fluid_, arg4: Internal.Direction_): boolean;
        isEmpty(): boolean;
        getFluidType(): Internal.FluidType;
        wait(arg0: number, arg1: number): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Fluid>;
        getTickDelay(arg0: Internal.LevelReader_): number;
        getSpreadDelay(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.FluidState_, arg3: Internal.FluidState_): number;
        canConvertToSource(arg0: Internal.FluidState_, arg1: Internal.Level_, arg2: BlockPos_): boolean;
        arch$registryName(): ResourceLocation;
        getAmount(arg0: Internal.FluidState_): number;
        toString(): string;
        getFlowing(): Internal.Fluid;
        notifyAll(): void;
        getBlockPathType(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: boolean): Internal.BlockPathTypes;
        callCanPassThroughWall(arg0: Internal.Direction_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: BlockPos_, arg5: Internal.BlockState_): boolean;
        move(arg0: Internal.FluidState_, arg1: Internal.LivingEntity_, arg2: Vec3d_, arg3: number): boolean;
        canExtinguish(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        shouldUpdateWhileBoating(arg0: Internal.FluidState_, arg1: Internal.Boat_, arg2: Internal.Entity_): boolean;
        hashCode(): number;
        randomTick(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.FluidState_, arg3: Internal.RandomSource_): void;
        getDropOff(arg0: Internal.LevelReader_): number;
        createLegacyBlock(arg0: Internal.FluidState_): Internal.BlockState;
        wait(arg0: number): void;
        getSource(): Internal.Fluid;
        equals(arg0: any): boolean;
        get stateDefinition(): Internal.StateDefinition<Internal.Fluid, Internal.FluidState>
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get dripParticle(): Internal.ParticleOptions
        get bucket(): Internal.Item
        get class(): typeof any
        get empty(): boolean
        get fluidType(): Internal.FluidType
        get flowing(): Internal.Fluid
        get source(): Internal.Fluid
    }
    type LavaFluid$Flowing_ = LavaFluid$Flowing;
    class GameRules implements Internal.GameRulesKJS {
        constructor()
        constructor(arg0: Internal.DynamicLike_<any>)
        getClass(): typeof any;
        set(rule: string, value: string): void;
        toString(): string;
        kjs$getBoolean(rule: string): boolean;
        createTag(): Internal.CompoundTag;
        kjs$getInt(rule: string): number;
        notifyAll(): void;
        getRule<T extends Internal.GameRules$Value<T>>(arg0: Internal.GameRules$Key_<T>): T;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        static register<T extends Internal.GameRules$Value<T>>(arg0: string, arg1: Internal.GameRules$Category_, arg2: Internal.GameRules$Type_<T>): Internal.GameRules$Key<T>;
        get(rule: string): Internal.GameRules$Value<any>;
        hashCode(): number;
        static visitGameRuleTypes(arg0: Internal.GameRules$GameRuleTypeVisitor_): void;
        getBoolean(arg0: Internal.GameRules$Key_<Internal.GameRules$BooleanValue>): boolean;
        assignFrom(arg0: Internal.GameRules_, arg1: Internal.MinecraftServer_): void;
        wait(): void;
        wait(arg0: number): void;
        kjs$getString(rule: string): string;
        getInt(arg0: Internal.GameRules$Key_<Internal.GameRules$IntegerValue>): number;
        copy(): this;
        equals(arg0: any): boolean;
        get class(): typeof any
        static readonly RULE_DO_WARDEN_SPAWNING: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_MAX_COMMAND_CHAIN_LENGTH: Internal.GameRules$Key<Internal.GameRules$IntegerValue>;
        static readonly RULE_MOBGRIEFING: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_DISABLE_ELYTRA_MOVEMENT_CHECK: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_FREEZE_DAMAGE: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_DOINSOMNIA: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_COMMAND_MODIFICATION_BLOCK_LIMIT: Internal.GameRules$Key<Internal.GameRules$IntegerValue>;
        static readonly RULE_DAYLIGHT: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_DO_TRADER_SPAWNING: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_REDUCEDDEBUGINFO: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_DO_IMMEDIATE_RESPAWN: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_DOMOBSPAWNING: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_DOBLOCKDROPS: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_COMMANDBLOCKOUTPUT: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_TNT_EXPLOSION_DROP_DECAY: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_WEATHER_CYCLE: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_NATURAL_REGENERATION: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_FIRE_DAMAGE: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_FORGIVE_DEAD_PLAYERS: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_SHOWDEATHMESSAGES: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_PLAYERS_SLEEPING_PERCENTAGE: Internal.GameRules$Key<Internal.GameRules$IntegerValue>;
        static readonly RULE_WATER_SOURCE_CONVERSION: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_FALL_DAMAGE: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_MOB_EXPLOSION_DROP_DECAY: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_DISABLE_RAIDS: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_BLOCK_EXPLOSION_DROP_DECAY: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_LOGADMINCOMMANDS: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_SPAWN_RADIUS: Internal.GameRules$Key<Internal.GameRules$IntegerValue>;
        static readonly RULE_SENDCOMMANDFEEDBACK: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_SNOW_ACCUMULATION_HEIGHT: Internal.GameRules$Key<Internal.GameRules$IntegerValue>;
        static readonly RULE_ANNOUNCE_ADVANCEMENTS: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_DOENTITYDROPS: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_LAVA_SOURCE_CONVERSION: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_DO_PATROL_SPAWNING: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_DO_VINES_SPREAD: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly DEFAULT_RANDOM_TICK_SPEED: (3) & (number);
        static readonly RULE_DOFIRETICK: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_LIMITED_CRAFTING: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_SPECTATORSGENERATECHUNKS: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_MAX_ENTITY_CRAMMING: Internal.GameRules$Key<Internal.GameRules$IntegerValue>;
        static readonly RULE_DROWNING_DAMAGE: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_UNIVERSAL_ANGER: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_GLOBAL_SOUND_EVENTS: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_KEEPINVENTORY: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_DOMOBLOOT: Internal.GameRules$Key<Internal.GameRules$BooleanValue>;
        static readonly RULE_RANDOMTICKING: Internal.GameRules$Key<Internal.GameRules$IntegerValue>;
    }
    type GameRules_ = GameRules;
    interface CraftingContainerKJS {
        getMenu(): Internal.AbstractContainerMenu;
        get menu(): Internal.AbstractContainerMenu
    }
    type CraftingContainerKJS_ = CraftingContainerKJS;
    abstract class AndesiteExoskeletonItem extends Internal.ArmorItem {
        constructor(arg0: Internal.ArmorItem$Type_, arg1: Internal.Item$Properties_)
        getDrinkingSound(): Internal.SoundEvent;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        getType(): Internal.ArmorItem$Type;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        moonlight$addAdditionalBehavior(placementOverride: Internal.AdditionalItemPlacement_): void;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isComplex(): boolean;
        forciblyAllowsTableEnchantment(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        moonlight$getClientAnimationExtension(): any;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getTypeData(): Internal.CompoundTag;
        getDefaultInstance(): Internal.ItemStack;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setBurnTime(i: number): void;
        setMaxStackSize(arg0: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getItem(): Internal.Item;
        getBarColor(arg0: Internal.ItemStack_): number;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        asIngredient(): Internal.Ingredient;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        static byId(arg0: number): Internal.Item;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        static get(arg0: Internal.ItemStack_): Internal.Equipable;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        kjs$getAttributeMap(): Internal.Multimap<any, any>;
        moonlight$getAdditionalBehavior(): Internal.AdditionalItemPlacement;
        moonlight$setClientAnimationExtension(obj: any): void;
        getDefense(): number;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        selectEnchantments(arg0: Internal.List_<Internal.EnchantmentInstance>, arg1: Internal.RandomSource_, arg2: Internal.ItemStack_, arg3: number, arg4: number, arg5: number, arg6: boolean): Internal.List<Internal.EnchantmentInstance>;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: Internal.EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        getEquipmentSlot(): Internal.EquipmentSlot;
        toString(): string;
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        handler$eba000$initializeClient(consumer: Internal.Consumer_<any>, ci: Internal.CallbackInfo_): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        static dispenseArmor(arg0: Internal.BlockSource_, arg1: Internal.ItemStack_): boolean;
        getMaterial(): Internal.ArmorMaterial;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        getEquipSound(): Internal.SoundEvent;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: Internal.EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        onEnchantment(arg0: Internal.ItemStack_, arg1: Internal.List_<Internal.EnchantmentInstance>): Internal.ItemStack;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): Internal.EquipmentSlot;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        getDefaultAttributeModifiers(arg0: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getToughness(): number;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        getTypeItemStackKey(): Internal.ItemStackKey;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isTreasureAllowed(arg0: Internal.ItemStack_, arg1: boolean): boolean;
        kjs$setAttributeMap(arg0: Internal.Multimap_<any, any>): void;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        swapWithEquipmentSlot(arg0: Internal.Item_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get type(): Internal.ArmorItem$Type
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get typeData(): Internal.CompoundTag
        get defaultInstance(): Internal.ItemStack
        set burnTime(i: number)
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        get defense(): number
        set itemBuilder(b: Internal.ItemBuilder_)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        get equipmentSlot(): Internal.EquipmentSlot
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        get material(): Internal.ArmorMaterial
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        get equipSound(): Internal.SoundEvent
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        set nameKey(arg0: string)
        get toughness(): number
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
    }
    type AndesiteExoskeletonItem_ = AndesiteExoskeletonItem;
    class Instant implements Internal.Comparable<Internal.Instant>, Internal.Temporal, Internal.TemporalAdjuster, Internal.Serializable {
        plus(arg0: number, arg1: Internal.TemporalUnit_): Internal.Temporal;
        notify(): void;
        compareTo(arg0: any): number;
        static ofEpochSecond(arg0: number, arg1: number): Internal.Instant;
        plusSeconds(arg0: number): this;
        "compareTo(java.time.Instant)"(arg0: Internal.Instant_): number;
        "with"(arg0: Internal.TemporalField_, arg1: number): Internal.Temporal;
        isSupported(arg0: Internal.TemporalField_): boolean;
        truncatedTo(arg0: Internal.TemporalUnit_): this;
        "isSupported(java.time.temporal.TemporalField)"(arg0: Internal.TemporalField_): boolean;
        static now(arg0: Internal.Clock_): Internal.Instant;
        minus(arg0: number, arg1: Internal.TemporalUnit_): this;
        atOffset(arg0: Internal.ZoneOffset_): Internal.OffsetDateTime;
        range(arg0: Internal.TemporalField_): Internal.ValueRange;
        plusMillis(arg0: number): this;
        isAfter(arg0: Internal.Instant_): boolean;
        toEpochMilli(): number;
        get(arg0: Internal.TemporalField_): number;
        wait(): void;
        compareTo(arg0: Internal.Instant_): number;
        "compareTo(java.lang.Object)"(arg0: any): number;
        "isSupported(java.time.temporal.TemporalUnit)"(arg0: Internal.TemporalUnit_): boolean;
        minusMillis(arg0: number): this;
        getClass(): typeof any;
        minusSeconds(arg0: number): this;
        static parse(arg0: Internal.CharSequence_): Internal.Instant;
        isBefore(arg0: Internal.Instant_): boolean;
        wait(arg0: number, arg1: number): void;
        static ofEpochSecond(arg0: number): Internal.Instant;
        getLong(arg0: Internal.TemporalField_): number;
        static now(): Internal.Instant;
        static from(arg0: Internal.TemporalAccessor_): Internal.Instant;
        minusNanos(arg0: number): this;
        toString(): string;
        adjustInto(arg0: Internal.Temporal_): Internal.Temporal;
        notifyAll(): void;
        "with"(arg0: Internal.TemporalAdjuster_): this;
        query<R>(arg0: Internal.TemporalQuery_<R>): R;
        until(arg0: Internal.Temporal_, arg1: Internal.TemporalUnit_): number;
        isSupported(arg0: Internal.TemporalUnit_): boolean;
        getNano(): number;
        getEpochSecond(): number;
        plus(arg0: Internal.TemporalAmount_): Internal.Temporal;
        hashCode(): number;
        atZone(arg0: Internal.ZoneId_): Internal.ZonedDateTime;
        wait(arg0: number): void;
        plusNanos(arg0: number): this;
        equals(arg0: any): boolean;
        static ofEpochMilli(arg0: number): Internal.Instant;
        minus(arg0: Internal.TemporalAmount_): Internal.Temporal;
        get class(): typeof any
        get nano(): number
        get epochSecond(): number
        static readonly EPOCH: (Internal.Instant) & (Internal.Instant);
        static readonly MAX: (Internal.Instant) & (Internal.Instant);
        static readonly MIN: (Internal.Instant) & (Internal.Instant);
    }
    type Instant_ = Instant;
    class SlabBlockItem extends Internal.BlockItem implements Internal.IDoItem {
        constructor(arg0: com.ldtteam.domumornamentum.block.vanilla.SlabBlock_, arg1: Internal.Item$Properties_)
        getDrinkingSound(): Internal.SoundEvent;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        static setBlockEntityData(arg0: Internal.ItemStack_, arg1: Internal.BlockEntityType_<any>, arg2: Internal.CompoundTag_): void;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        handler$cmd000$place(arg0: Internal.BlockPlaceContext_, arg1: Internal.CallbackInfoReturnable_<any>, arg2: Internal.BlockPlaceContext_, arg3: Internal.BlockState_): void;
        abstract moonlight$addAdditionalBehavior(arg0: Internal.AdditionalItemPlacement_): void;
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isComplex(): boolean;
        forciblyAllowsTableEnchantment(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        renderPreview(): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getDescriptionId(): string;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        abstract moonlight$getClientAnimationExtension(): any;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getTypeData(): Internal.CompoundTag;
        getDefaultInstance(): Internal.ItemStack;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setBurnTime(i: number): void;
        setMaxStackSize(arg0: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getItem(): Internal.Item;
        getBarColor(arg0: Internal.ItemStack_): number;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        asIngredient(): Internal.Ingredient;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        static byId(arg0: number): Internal.Item;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        abstract moonlight$getAdditionalBehavior(): Internal.AdditionalItemPlacement;
        abstract moonlight$setClientAnimationExtension(arg0: any): void;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getInputIds(): Internal.List<ResourceLocation>;
        selectEnchantments(arg0: Internal.List_<Internal.EnchantmentInstance>, arg1: Internal.RandomSource_, arg2: Internal.ItemStack_, arg3: number, arg4: number, arg5: number, arg6: boolean): Internal.List<Internal.EnchantmentInstance>;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: Internal.EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        static getBlockEntityData(arg0: Internal.ItemStack_): Internal.CompoundTag;
        toString(): string;
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        handler$eba000$initializeClient(consumer: Internal.Consumer_<any>, ci: Internal.CallbackInfo_): void;
        getId(): string;
        getGroup(): ResourceLocation;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        removeFromBlockToItemMap(arg0: Internal.Map_<Internal.Block, Internal.Item>, arg1: Internal.Item_): void;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        static updateCustomBlockEntityTag(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.ItemStack_): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        place(arg0: Internal.BlockPlaceContext_): Internal.InteractionResult;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: Internal.EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        getBlock(): Internal.Block;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        updatePlacementContext(arg0: Internal.BlockPlaceContext_): Internal.BlockPlaceContext;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        registerBlocks(arg0: Internal.Map_<Internal.Block, Internal.Item>, arg1: Internal.Item_): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        onEnchantment(arg0: Internal.ItemStack_, arg1: Internal.List_<Internal.EnchantmentInstance>): Internal.ItemStack;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): Internal.EquipmentSlot;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        getTypeItemStackKey(): Internal.ItemStackKey;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isTreasureAllowed(arg0: Internal.ItemStack_, arg1: boolean): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        puzzleslib$setBlock(arg0: Internal.Block_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get typeData(): Internal.CompoundTag
        get defaultInstance(): Internal.ItemStack
        set burnTime(i: number)
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        set itemBuilder(b: Internal.ItemBuilder_)
        get inputIds(): Internal.List<ResourceLocation>
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        get group(): ResourceLocation
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        get block(): Internal.Block
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
    }
    type SlabBlockItem_ = SlabBlockItem;
    class GridFlags extends Internal.Enum<Internal.GridFlags> {
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        getClass(): typeof any;
        toString(): string;
        notifyAll(): void;
        notify(): void;
        compareTo(arg0: Internal.GridFlags_): number;
        wait(arg0: number, arg1: number): void;
        compareTo(arg0: any): number;
        name(): string;
        "compareTo(appeng.api.networking.GridFlags)"(arg0: Internal.GridFlags_): number;
        hashCode(): number;
        getDeclaringClass(): typeof Internal.GridFlags;
        static valueOf(arg0: string): Internal.GridFlags;
        describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<Internal.GridFlags>>;
        ordinal(): number;
        wait(): void;
        wait(arg0: number): void;
        "compareTo(java.lang.Object)"(arg0: any): number;
        static values(): Internal.GridFlags[];
        equals(arg0: any): boolean;
        get class(): typeof any
        get declaringClass(): typeof Internal.GridFlags
        static readonly REQUIRE_CHANNEL: (Internal.GridFlags) & (Internal.GridFlags);
        static readonly COMPRESSED_CHANNEL: (Internal.GridFlags) & (Internal.GridFlags);
        static readonly DENSE_CAPACITY: (Internal.GridFlags) & (Internal.GridFlags);
        static readonly PREFERRED: (Internal.GridFlags) & (Internal.GridFlags);
        static readonly MULTIBLOCK: (Internal.GridFlags) & (Internal.GridFlags);
        static readonly CANNOT_CARRY: (Internal.GridFlags) & (Internal.GridFlags);
        static readonly CANNOT_CARRY_COMPRESSED: (Internal.GridFlags) & (Internal.GridFlags);
    }
    type GridFlags_ = "compressed_channel" | GridFlags | "preferred" | "multiblock" | "cannot_carry_compressed" | "cannot_carry" | "dense_capacity" | "require_channel";
    interface ImmutableStringReader {
        abstract getTotalLength(): number;
        abstract peek(): string;
        abstract getCursor(): number;
        abstract getRead(): string;
        abstract canRead(): boolean;
        abstract getRemainingLength(): number;
        abstract getRemaining(): string;
        abstract canRead(arg0: number): boolean;
        abstract peek(arg0: number): string;
        abstract getString(): string;
        get totalLength(): number
        get cursor(): number
        get read(): string
        get remainingLength(): number
        get remaining(): string
        get string(): string
    }
    type ImmutableStringReader_ = ImmutableStringReader;
    abstract class AbstractTexture implements Internal.AutoCloseable {
        constructor()
        getClass(): typeof any;
        bind(): void;
        toString(): string;
        notifyAll(): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        setBlurMipmap(arg0: boolean, arg1: boolean): void;
        hashCode(): number;
        restoreLastBlurMipmap(): void;
        abstract load(arg0: Internal.ResourceManager_): void;
        wait(): void;
        close(): void;
        wait(arg0: number): void;
        setFilter(arg0: boolean, arg1: boolean): void;
        releaseId(): void;
        reset(arg0: Internal.TextureManager_, arg1: Internal.ResourceManager_, arg2: ResourceLocation_, arg3: Internal.Executor_): void;
        equals(arg0: any): boolean;
        getId(): number;
        get class(): typeof any
        get id(): number
        static readonly NOT_ASSIGNED: (-1) & (number);
    }
    type AbstractTexture_ = AbstractTexture;
    class CabinetBlock extends Internal.CounterBlock {
        constructor()
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        getBlacklistedEnchantments(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Set<Internal.Enchantment>;
        getTypeData(): Internal.CompoundTag;
        setFriction(arg0: number): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        newBlockEntity(arg0: BlockPos_, arg1: Internal.BlockState_): Internal.BlockEntity;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        needsDynamicNodeTypeCheck(): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        spawnTableParticle(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: BlockPos_): void;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        /**
         * @deprecated
        */
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        /**
         * @deprecated
        */
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static createTickerHelper<E extends Internal.BlockEntity, A extends Internal.BlockEntity>(arg0: Internal.BlockEntityType_<A>, arg1: Internal.BlockEntityType_<E>, arg2: Internal.BlockEntityTicker_<E>): Internal.BlockEntityTicker<A>;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        getTicker<T extends Internal.BlockEntity>(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        static byItem(arg0: Internal.Item_): Internal.Block;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        allowsTreasure(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(shape: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        shouldBePlacedFlipped(arg0: Internal.BlockPlaceContext_, arg1: Internal.Direction_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        handler$dmk000$friendsandfoes_onUse(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, hand: Internal.InteractionHand_, hit: Internal.BlockHitResult_, cir: Internal.CallbackInfoReturnable_<any>): void;
        getMaxEnchantingPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        /**
         * @deprecated
        */
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        /**
         * @deprecated
        */
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        getTableParticle(arg0: Internal.BlockState_): Internal.ParticleOptions;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        needsDynamicBurningCheck(): boolean;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        getArcanaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        handler$dmk000$friendsandfoes_randomTick(state: Internal.BlockState_, world: Internal.ServerLevel_, pos: BlockPos_, random: Internal.RandomSource_, ci: Internal.CallbackInfo_): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        getQuantaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        handler$bdh000$postConstruct(p_i241196_1_: Internal.BlockBehaviour$Properties_, ci: Internal.CallbackInfo_): void;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        getQuantaRectification(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        tryRecolorBlock(arg0: Internal.BlockState_, arg1: Internal.ItemStack_, arg2: Internal.Level_, arg3: BlockPos_, arg4: Internal.Player_, arg5: Internal.BlockHitResult_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        static shouldBlockRenderLowered(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        /**
         * @deprecated
        */
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getListener<T extends Internal.BlockEntity>(arg0: Internal.ServerLevel_, arg1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        handler$dml000$friendsandfoes_hasRandomTicks(state: Internal.BlockState_, cir: Internal.CallbackInfoReturnable_<any>): void;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        getBonusClues(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        get typeData(): Internal.CompoundTag
        set friction(arg0: number)
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get descriptionId(): string
        get jumpFactor(): number
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
    }
    type CabinetBlock_ = CabinetBlock;
    abstract class GrowingPlantHeadBlock extends Internal.GrowingPlantBlock implements Internal.BonemealableBlock {
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        performBonemeal(arg0: Internal.ServerLevel_, arg1: Internal.RandomSource_, arg2: BlockPos_, arg3: Internal.BlockState_): void;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        getBlacklistedEnchantments(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Set<Internal.Enchantment>;
        getTypeData(): Internal.CompoundTag;
        setFriction(arg0: number): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        needsDynamicNodeTypeCheck(): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        isMaxAge(arg0: Internal.BlockState_): boolean;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        spawnTableParticle(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: BlockPos_): void;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        /**
         * @deprecated
        */
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        "getStateForPlacement(net.minecraft.world.level.LevelAccessor)"(arg0: Internal.LevelAccessor_): Internal.BlockState;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        isBonemealSuccess(arg0: Internal.Level_, arg1: Internal.RandomSource_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        static byItem(arg0: Internal.Item_): Internal.Block;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        allowsTreasure(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(shape: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        handler$dmk000$friendsandfoes_onUse(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, hand: Internal.InteractionHand_, hit: Internal.BlockHitResult_, cir: Internal.CallbackInfoReturnable_<any>): void;
        getMaxEnchantingPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        /**
         * @deprecated
        */
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        /**
         * @deprecated
        */
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        getMaxAgeState(arg0: Internal.BlockState_): Internal.BlockState;
        getTableParticle(arg0: Internal.BlockState_): Internal.ParticleOptions;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        needsDynamicBurningCheck(): boolean;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        getArcanaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        handler$dmk000$friendsandfoes_randomTick(state: Internal.BlockState_, world: Internal.ServerLevel_, pos: BlockPos_, random: Internal.RandomSource_, ci: Internal.CallbackInfo_): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        getStateForPlacement(arg0: Internal.LevelAccessor_): Internal.BlockState;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        getQuantaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        isValidBonemealTarget(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: boolean): boolean;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        handler$bdh000$postConstruct(p_i241196_1_: Internal.BlockBehaviour$Properties_, ci: Internal.CallbackInfo_): void;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        getQuantaRectification(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        handler$dml000$friendsandfoes_hasRandomTicks(state: Internal.BlockState_, cir: Internal.CallbackInfoReturnable_<any>): void;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        "getStateForPlacement(net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        /**
         * @deprecated
        */
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        getBonusClues(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        get typeData(): Internal.CompoundTag
        set friction(arg0: number)
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get descriptionId(): string
        get jumpFactor(): number
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
        static readonly AGE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
        static readonly MAX_AGE: (25) & (number);
    }
    type GrowingPlantHeadBlock_ = GrowingPlantHeadBlock;
    class ModifiableBiomeInfo$BiomeInfo$Builder {
        getClimateSettings(): Internal.ClimateSettingsBuilder;
        getClass(): typeof any;
        toString(): string;
        getMobSpawnSettings(): Internal.MobSpawnSettingsBuilder;
        notifyAll(): void;
        static copyOf(arg0: Internal.ModifiableBiomeInfo$BiomeInfo_): Internal.ModifiableBiomeInfo$BiomeInfo$Builder;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        hashCode(): number;
        wait(): void;
        wait(arg0: number): void;
        getGenerationSettings(): Internal.BiomeGenerationSettingsBuilder;
        equals(arg0: any): boolean;
        getSpecialEffects(): Internal.BiomeSpecialEffectsBuilder;
        build(): Internal.ModifiableBiomeInfo$BiomeInfo;
        get climateSettings(): Internal.ClimateSettingsBuilder
        get class(): typeof any
        get mobSpawnSettings(): Internal.MobSpawnSettingsBuilder
        get generationSettings(): Internal.BiomeGenerationSettingsBuilder
        get specialEffects(): Internal.BiomeSpecialEffectsBuilder
    }
    type ModifiableBiomeInfo$BiomeInfo$Builder_ = ModifiableBiomeInfo$BiomeInfo$Builder;
    class IRecipeTransferError$Type extends Internal.Enum<Internal.IRecipeTransferError$Type> {
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        getClass(): typeof any;
        static valueOf(arg0: string): Internal.IRecipeTransferError$Type;
        toString(): string;
        notifyAll(): void;
        getDeclaringClass(): typeof Internal.IRecipeTransferError$Type;
        compareTo(arg0: Internal.IRecipeTransferError$Type_): number;
        notify(): void;
        "compareTo(mezz.jei.api.recipe.transfer.IRecipeTransferError$Type)"(arg0: Internal.IRecipeTransferError$Type_): number;
        wait(arg0: number, arg1: number): void;
        compareTo(arg0: any): number;
        name(): string;
        describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<Internal.IRecipeTransferError$Type>>;
        hashCode(): number;
        ordinal(): number;
        wait(): void;
        static values(): Internal.IRecipeTransferError$Type[];
        wait(arg0: number): void;
        "compareTo(java.lang.Object)"(arg0: any): number;
        equals(arg0: any): boolean;
        get class(): typeof any
        get declaringClass(): typeof Internal.IRecipeTransferError$Type
        static readonly INTERNAL: (Internal.IRecipeTransferError$Type) & (Internal.IRecipeTransferError$Type);
        static readonly COSMETIC: (Internal.IRecipeTransferError$Type) & (Internal.IRecipeTransferError$Type);
        static readonly USER_FACING: (Internal.IRecipeTransferError$Type) & (Internal.IRecipeTransferError$Type);
        readonly allowsTransfer: boolean;
    }
    type IRecipeTransferError$Type_ = IRecipeTransferError$Type | "internal" | "user_facing" | "cosmetic";
    class RealmsNotification {
        getClass(): typeof any;
        dismissable(): boolean;
        toString(): string;
        notifyAll(): void;
        uuid(): Internal.UUID;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        static parseList(arg0: string): Internal.List<Internal.RealmsNotification>;
        hashCode(): number;
        wait(): void;
        seen(): boolean;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        get class(): typeof any
    }
    type RealmsNotification_ = RealmsNotification;
    interface IDrawable {
        abstract draw(arg0: Internal.GuiGraphics_, arg1: number, arg2: number): void;
        abstract getWidth(): number;
        abstract getHeight(): number;
        draw(arg0: Internal.GuiGraphics_): void;
        get width(): number
        get height(): number
    }
    type IDrawable_ = IDrawable;
    interface BucketPickup extends Internal.IForgeBucketPickup {
        getPickupSound(arg0: Internal.BlockState_): Internal.Optional<Internal.SoundEvent>;
        abstract pickupBlock(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        /**
         * @deprecated
        */
        abstract getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        /**
         * @deprecated
        */
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
    }
    type BucketPickup_ = BucketPickup;
    class EnumGetMethod extends Internal.Enum<Internal.EnumGetMethod> {
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        getClass(): typeof any;
        describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<Internal.EnumGetMethod>>;
        "compareTo(com.electronwill.nightconfig.core.EnumGetMethod)"(arg0: Internal.EnumGetMethod_): number;
        toString(): string;
        isCaseSensitive(): boolean;
        notifyAll(): void;
        static valueOf(arg0: string): Internal.EnumGetMethod;
        validate<T extends Internal.Enum<T>>(arg0: any, arg1: T): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        get<T extends Internal.Enum<T>>(arg0: any, arg1: T): T;
        compareTo(arg0: any): number;
        name(): string;
        static values(): Internal.EnumGetMethod[];
        hashCode(): number;
        compareTo(arg0: Internal.EnumGetMethod_): number;
        ordinal(): number;
        wait(): void;
        isOrdinalOk(): boolean;
        wait(arg0: number): void;
        "compareTo(java.lang.Object)"(arg0: any): number;
        equals(arg0: any): boolean;
        getDeclaringClass(): typeof Internal.EnumGetMethod;
        get class(): typeof any
        get caseSensitive(): boolean
        get ordinalOk(): boolean
        get declaringClass(): typeof Internal.EnumGetMethod
        static readonly ORDINAL_OR_NAME: (Internal.EnumGetMethod) & (Internal.EnumGetMethod);
        static readonly NAME: (Internal.EnumGetMethod) & (Internal.EnumGetMethod);
        static readonly NAME_IGNORECASE: (Internal.EnumGetMethod) & (Internal.EnumGetMethod);
        static readonly ORDINAL_OR_NAME_IGNORECASE: (Internal.EnumGetMethod) & (Internal.EnumGetMethod);
    }
    type EnumGetMethod_ = "name" | "ordinal_or_name" | EnumGetMethod | "ordinal_or_name_ignorecase" | "name_ignorecase";
    class TileEntityUniversalCable extends Internal.TileEntityTransmitter implements Internal.IComputerTile {
        constructor(blockProvider: Internal.IBlockProvider_, pos: BlockPos_, state: Internal.BlockState_)
        emf$hasVehicle(): boolean;
        requestModelDataUpdate(): void;
        etf$getType(): Internal.EntityType<any>;
        emf$getVelocity(): Vec3d;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityDispatcher)"(arg0: Internal.CapabilityDispatcher_): boolean;
        sideChanged(side: Internal.Direction_, old: Internal.ConnectionType_, type: Internal.ConnectionType_): void;
        etf$isBlockEntity(): boolean;
        getComputerName(): string;
        hasComputerSupport(): boolean;
        /**
         * @deprecated
        */
        setBlockState(arg0: Internal.BlockState_): void;
        handler$dbg000$setLevel(arg0: Internal.Level_, arg1: Internal.CallbackInfo_): void;
        load(nbt: Internal.CompoundTag_): void;
        setForceUpdate(): void;
        setChanged(): void;
        setCulled(value: boolean): void;
        "invalidateCapabilities(java.util.Collection,net.minecraft.core.Direction)"(capabilities: Internal.Collection_<Internal.Capability<any>>, side: Internal.Direction_): void;
        saveWithoutMetadata(): Internal.CompoundTag;
        setTimeout(): void;
        handler$bkf000$injectUnload(arg0: boolean, arg1: Internal.CallbackInfo_): void;
        getReducedUpdateTag(): Internal.CompoundTag;
        isOutOfCamera(): boolean;
        "getUpdatePacket()"(): Internal.Packet<any>;
        emf$prevZ(): number;
        etf$canBeBright(): boolean;
        onSneakRightClick(player: Internal.Player_, side: Internal.Direction_): Internal.InteractionResult;
        setRemoved(): void;
        onNeighborTileChange(side: Internal.Direction_): void;
        invalidateCapability(capability: Internal.Capability_<any>, ...sides: Internal.Direction_[]): void;
        emf$isOnGround(): boolean;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        invalidateCapabilities(capabilities: Internal.Collection_<Internal.Capability<any>>, ...sides: Internal.Direction_[]): void;
        etf$getPose(): Internal.Pose;
        etf$getEntityKey(): string;
        isCulled(): boolean;
        getType(): Internal.BlockEntityType<any>;
        getTransmitter(): Internal.UniversalCable;
        onSneakRightClick(player: Internal.Player_): Internal.InteractionResult;
        etf$getOptifineId(): number;
        "invalidateCapability(net.minecraftforge.common.capabilities.Capability,net.minecraft.core.Direction)"(capability: Internal.Capability_<any>, side: Internal.Direction_): void;
        onAdded(): void;
        "getUpdatePacket()"(): Internal.ClientboundBlockEntityDataPacket;
        getRenderBoundingBox(): Internal.AABB;
        markDirtyComparator(): void;
        getClass(): typeof any;
        emf$isInvisible(): boolean;
        sendUpdatePacket(): void;
        static getPosFromTag(arg0: Internal.CompoundTag_): BlockPos;
        handler$bkf000$injectSaveCover(arg0: Internal.CallbackInfoReturnable_<any>): void;
        etf$distanceTo(entity: Internal.Entity_): number;
        emf$isSprinting(): boolean;
        isLoaded(): boolean;
        hasAnyComparatorNearby(): boolean;
        onChunkUnloaded(): void;
        saveToItem(arg0: Internal.ItemStack_): void;
        "deserializeNBT(net.minecraft.nbt.CompoundTag)"(arg0: Internal.CompoundTag_): void;
        static addEntityType(arg0: Internal.CompoundTag_, arg1: Internal.BlockEntityType_<any>): void;
        emf$isInLava(): boolean;
        "deserializeNBT(net.minecraft.nbt.Tag)"(arg0: Internal.Tag_): void;
        onComparatorAdded(direction: Internal.Direction_, offset: number): void;
        getTransmitterType(): Internal.TransmitterType;
        getComputerMethods(holder: Internal.BoundMethodHolder_): void;
        mekanism_covers$setCoverState(arg0: Internal.BlockState_): void;
        clearRemoved(): void;
        emf$isWet(): boolean;
        getUpdatePacket(): Internal.Packet<any>;
        getTileChunk(): Internal.Chunk3D;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityProvider)"(arg0: Internal.CapabilityProvider_<Internal.BlockEntity>): boolean;
        handler$dbg000$setRemoved(arg0: Internal.CallbackInfo_): void;
        getPersistentData(): Internal.CompoundTag;
        toString(): string;
        triggerEvent(arg0: number, arg1: number): boolean;
        emf$isGlowing(): boolean;
        hasLevel(): boolean;
        notifyAll(): void;
        getTileWorld(): Internal.Level;
        etf$getScoreboardTeam(): Internal.Team;
        emf$getZ(): number;
        invalidateCapabilities(capabilities: Internal.Collection_<Internal.Capability<any>>, side: Internal.Direction_): void;
        invalidateCachedCapabilities(): void;
        mekanism_covers$onUpdateClient(): void;
        setType_HammerLib(arg0: Internal.BlockEntityType_<any>): void;
        wait(arg0: number): void;
        etf$getItemsEquipped(): Internal.Iterable<any>;
        etf$getVelocity(): Vec3d;
        isComputerCapabilityPersistent(): boolean;
        reviveCaps(): void;
        handleUpdatePacket(tag: Internal.CompoundTag_): void;
        etf$getWorld(): Internal.Level;
        getUpdateTag(): Internal.CompoundTag;
        handleUpdateTag(tag: Internal.CompoundTag_): void;
        getSideLookingAt(player: Internal.Player_): Internal.Direction;
        emf$getYaw(): number;
        setLevel(world: Internal.Level_): void;
        notify(): void;
        chunkAccessibilityChange(loaded: boolean): void;
        getBlockPos(): BlockPos;
        etf$getNbt(): Internal.CompoundTag;
        isRemoved(): boolean;
        emf$isSneaking(): boolean;
        static tickServer(level: Internal.Level_, pos: BlockPos_, state: Internal.BlockState_, transmitter: Internal.TileEntityTransmitter_): void;
        etf$getBlockPos(): BlockPos;
        onLoad(): void;
        fillCrashReportCategory(arg0: Internal.CrashReportCategory_): void;
        emf$prevPitch(): number;
        "invalidateCapability(net.minecraftforge.common.capabilities.Capability,net.minecraft.core.Direction[])"(capability: Internal.Capability_<any>, ...sides: Internal.Direction_[]): void;
        etf$getBlockY(): number;
        markForSave(): void;
        etf$getHandItems(): Internal.Iterable<any>;
        invalidateCaps(): void;
        getTilePos(): BlockPos;
        etf$getArmorItems(): Internal.Iterable<any>;
        emf$getY(): number;
        emf$prevX(): number;
        getTileCoord(): Internal.Coord4D;
        getBlockState(): Internal.BlockState;
        emf$age(): number;
        etf$hasCustomName(): boolean;
        getSideLookingAt(player: Internal.Player_, fallback: Internal.Direction_): Internal.Direction;
        static loadStatic(arg0: BlockPos_, arg1: Internal.BlockState_, arg2: Internal.CompoundTag_): Internal.BlockEntity;
        wait(): void;
        sendUpdatePacket(tracking: Internal.BlockEntity_): void;
        emf$isTouchingWater(): boolean;
        m_183515_(nbtTags: Internal.CompoundTag_): void;
        emf$getVariableMap(): Internal.Object2FloatOpenHashMap<any>;
        areCapsCompatible(arg0: Internal.CapabilityDispatcher_): boolean;
        etf$getCustomName(): net.minecraft.network.chat.Component;
        getCapability<T>(capability: Internal.Capability_<T>, side: Internal.Direction_): Internal.LazyOptional<T>;
        saveWithId(): Internal.CompoundTag;
        getCollisionBoxes(): Internal.List<Internal.VoxelShape>;
        setOutOfCamera(value: boolean): void;
        onRightClick(player: Internal.Player_, side: Internal.Direction_): Internal.InteractionResult;
        wait(arg0: number, arg1: number): void;
        getLevel(): Internal.Level;
        onRightClick(player: Internal.Player_): Internal.InteractionResult;
        onlyOpCanSetNbt(): boolean;
        isRemote(): boolean;
        serializeNBT(): Internal.Tag;
        onNeighborBlockChange(side: Internal.Direction_): void;
        handler$bkf000$injectLoad(arg0: Internal.CompoundTag_, arg1: Internal.CallbackInfo_): void;
        onDataPacket(net: Internal.Connection_, pkt: Internal.ClientboundBlockEntityDataPacket_): void;
        saveWithFullMetadata(): Internal.CompoundTag;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        "invalidateCapabilities(java.util.Collection,net.minecraft.core.Direction[])"(capabilities: Internal.Collection_<Internal.Capability<any>>, ...sides: Internal.Direction_[]): void;
        emf$prevY(): number;
        emf$getX(): number;
        areCapsCompatible(arg0: Internal.CapabilityProvider_<Internal.BlockEntity>): boolean;
        emf$isOnFire(): boolean;
        deserializeNBT(arg0: Internal.Tag_): void;
        mekanism_covers$getCoverState(): Internal.BlockState;
        onAlloyInteraction(player: Internal.Player_, stack: Internal.ItemStack_, tier: Internal.AlloyTier_): void;
        etf$getUuid(): Internal.UUID;
        invalidateCapability(capability: Internal.Capability_<any>, side: Internal.Direction_): void;
        handler$bkf000$injectCoverModel(arg0: Internal.CallbackInfoReturnable_<any>): void;
        redstoneChanged(powered: boolean): void;
        getUpdatePacket(): Internal.ClientboundBlockEntityDataPacket;
        isForcedVisible(): boolean;
        emf$hasPassengers(): boolean;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        hashCode(): number;
        emf$getTypeString(): string;
        blockRemoved(): void;
        getModelData(): Internal.ModelData;
        emf$getPitch(): number;
        emf$isAlive(): boolean;
        handler$bkf000$injectUpdateTag(arg0: Internal.CompoundTag_, arg1: Internal.CallbackInfo_): void;
        handler$bkf000$injectSaveCover(arg0: Internal.CompoundTag_, arg1: Internal.CallbackInfo_): void;
        equals(arg0: any): boolean;
        get computerName(): string
        /**
         * @deprecated
        */
        set blockState(arg0: Internal.BlockState_)
        set culled(value: boolean)
        get reducedUpdateTag(): Internal.CompoundTag
        get outOfCamera(): boolean
        get "updatePacket()"(): Internal.Packet<any>
        get culled(): boolean
        get type(): Internal.BlockEntityType<any>
        get transmitter(): Internal.UniversalCable
        get "updatePacket()"(): Internal.ClientboundBlockEntityDataPacket
        get renderBoundingBox(): Internal.AABB
        get class(): typeof any
        get loaded(): boolean
        get transmitterType(): Internal.TransmitterType
        get updatePacket(): Internal.Packet<any>
        get tileChunk(): Internal.Chunk3D
        get persistentData(): Internal.CompoundTag
        get tileWorld(): Internal.Level
        set type_HammerLib(arg0: Internal.BlockEntityType_<any>)
        get computerCapabilityPersistent(): boolean
        get updateTag(): Internal.CompoundTag
        set level(world: Internal.Level_)
        get blockPos(): BlockPos
        get removed(): boolean
        get tilePos(): BlockPos
        get tileCoord(): Internal.Coord4D
        get blockState(): Internal.BlockState
        get collisionBoxes(): Internal.List<Internal.VoxelShape>
        set outOfCamera(value: boolean)
        get level(): Internal.Level
        get remote(): boolean
        get updatePacket(): Internal.ClientboundBlockEntityDataPacket
        get forcedVisible(): boolean
        get modelData(): Internal.ModelData
    }
    type TileEntityUniversalCable_ = TileEntityUniversalCable;
    class GirderEncasedShaftBlock extends Internal.HorizontalAxisKineticBlock implements Internal.ISpecialBlockItemRequirement, Internal.IBE<Internal.KineticBlockEntity>, com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.SimpleWaterloggedBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        getBlockEntity(arg0: Internal.BlockGetter_, arg1: BlockPos_): Internal.KineticBlockEntity;
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getRotationAxis(arg0: Internal.BlockState_): Internal.Direction$Axis;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        getBlockEntityClass(): typeof Internal.KineticBlockEntity;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        static getPreferredHorizontalAxis(arg0: Internal.BlockPlaceContext_): Internal.Direction$Axis;
        getBlacklistedEnchantments(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Set<Internal.Enchantment>;
        getTypeData(): Internal.CompoundTag;
        setFriction(arg0: number): void;
        playRemoveSound(arg0: Internal.Level_, arg1: BlockPos_): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        newBlockEntity(arg0: BlockPos_, arg1: Internal.BlockState_): Internal.BlockEntity;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        needsDynamicNodeTypeCheck(): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        spawnTableParticle(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: BlockPos_): void;
        getRotatedBlockState(arg0: Internal.BlockState_, arg1: Internal.Direction_): Internal.BlockState;
        getParticleInitialRadius(): number;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        /**
         * @deprecated
        */
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        withBlockEntityDo(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.Consumer_<Internal.KineticBlockEntity>): void;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        static byItem(arg0: Internal.Item_): Internal.Block;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        allowsTreasure(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        placeLiquid(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.FluidState_): boolean;
        getTicker<S extends Internal.BlockEntity>(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        wait(): void;
        playRotateSound(arg0: Internal.Level_, arg1: BlockPos_): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(shape: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        getPickupSound(arg0: Internal.BlockState_): Internal.Optional<Internal.SoundEvent>;
        setIsRandomlyTicking(arg0: boolean): void;
        static onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        getBlockEntityType(): Internal.BlockEntityType<Internal.KineticBlockEntity>;
        setNameKey(arg0: string): void;
        hideStressImpact(): boolean;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        handler$dmk000$friendsandfoes_onUse(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, hand: Internal.InteractionHand_, hit: Internal.BlockHitResult_, cir: Internal.CallbackInfoReturnable_<any>): void;
        getMaxEnchantingPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        /**
         * @deprecated
        */
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRequiredItems(arg0: Internal.BlockState_, arg1: Internal.BlockEntity_): Internal.ItemRequirement;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        /**
         * @deprecated
        */
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        getTableParticle(arg0: Internal.BlockState_): Internal.ParticleOptions;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        needsDynamicBurningCheck(): boolean;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        getArcanaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        handler$dmk000$friendsandfoes_randomTick(state: Internal.BlockState_, world: Internal.ServerLevel_, pos: BlockPos_, random: Internal.RandomSource_, ci: Internal.CallbackInfo_): void;
        onWrenched(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        pickupBlock(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        getQuantaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        onSneakWrenched(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        getParticleTargetRadius(): number;
        updateAfterWrenched(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_): Internal.BlockState;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        handler$bdh000$postConstruct(p_i241196_1_: Internal.BlockBehaviour$Properties_, ci: Internal.CallbackInfo_): void;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        getQuantaRectification(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getListener<T extends Internal.BlockEntity>(arg0: Internal.ServerLevel_, arg1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        handler$dml000$friendsandfoes_hasRandomTicks(state: Internal.BlockState_, cir: Internal.CallbackInfoReturnable_<any>): void;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        getBlockEntityOptional(arg0: Internal.BlockGetter_, arg1: BlockPos_): Internal.Optional<Internal.KineticBlockEntity>;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        canPlaceLiquid(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Fluid_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        getBonusClues(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        onBlockEntityUse(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.Function_<Internal.KineticBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        showCapacityWithAnnotation(): boolean;
        static stateById(arg0: number): Internal.BlockState;
        hasShaftTowards(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Direction_): boolean;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        get blockEntityClass(): typeof Internal.KineticBlockEntity
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        get typeData(): Internal.CompoundTag
        set friction(arg0: number)
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get particleInitialRadius(): number
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        get blockEntityType(): Internal.BlockEntityType<Internal.KineticBlockEntity>
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get descriptionId(): string
        get jumpFactor(): number
        set speedFactor(arg0: number)
        get particleTargetRadius(): number
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
        static readonly TOP: (Internal.BooleanProperty) & (Internal.BooleanProperty);
        static readonly BOTTOM: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    }
    type GirderEncasedShaftBlock_ = GirderEncasedShaftBlock;
    interface ISlurryTracker extends Internal.IContentsListener {
        abstract getSlurryTanks(side: Internal.Direction_): Internal.List<Internal.ISlurryTank>;
        abstract onContentsChanged(): void;
    }
    type ISlurryTracker_ = ISlurryTracker;
    class PlaySoundEvent extends net.minecraftforge.client.event.sound.SoundEvent {
        constructor()
        constructor(arg0: Internal.SoundEngine_, arg1: Internal.SoundInstance_)
        getResult(): Internal.Event$Result;
        setCanceled(arg0: boolean): void;
        getClass(): typeof any;
        setSound(arg0: Internal.SoundInstance_): void;
        toString(): string;
        setPhase(arg0: Internal.EventPriority_): void;
        notifyAll(): void;
        isCanceled(): boolean;
        getOriginalSound(): Internal.SoundInstance;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        hasResult(): boolean;
        setResult(arg0: Internal.Event$Result_): void;
        getSound(): Internal.SoundInstance;
        hashCode(): number;
        isCancelable(): boolean;
        wait(): void;
        getName(): string;
        getListenerList(): Internal.ListenerList;
        wait(arg0: number): void;
        getPhase(): Internal.EventPriority;
        equals(arg0: any): boolean;
        getEngine(): Internal.SoundEngine;
        get result(): Internal.Event$Result
        set canceled(arg0: boolean)
        get class(): typeof any
        set sound(arg0: Internal.SoundInstance_)
        set phase(arg0: Internal.EventPriority_)
        get canceled(): boolean
        get originalSound(): Internal.SoundInstance
        set result(arg0: Internal.Event$Result_)
        get sound(): Internal.SoundInstance
        get cancelable(): boolean
        get name(): string
        get listenerList(): Internal.ListenerList
        get phase(): Internal.EventPriority
        get engine(): Internal.SoundEngine
    }
    type PlaySoundEvent_ = PlaySoundEvent;
    interface IEventBus {
        abstract unregister(arg0: any): void;
        abstract addListener<T extends net.minecraftforge.eventbus.api.Event>(arg0: Internal.EventPriority_, arg1: boolean, arg2: Internal.Consumer_<T>): void;
        abstract post(arg0: net.minecraftforge.eventbus.api.Event_): boolean;
        abstract addGenericListener<T extends Internal.GenericEvent<any>, F>(arg0: F, arg1: Internal.EventPriority_, arg2: Internal.Consumer_<T>): void;
        abstract addGenericListener<T extends Internal.GenericEvent<any>, F>(arg0: F, arg1: Internal.Consumer_<T>): void;
        abstract post(arg0: net.minecraftforge.eventbus.api.Event_, arg1: Internal.IEventBusInvokeDispatcher_): boolean;
        abstract register(arg0: any): void;
        abstract addGenericListener<T extends Internal.GenericEvent<any>, F>(arg0: F, arg1: Internal.EventPriority_, arg2: boolean, arg3: Internal.Consumer_<T>): void;
        abstract addGenericListener<T extends Internal.GenericEvent<any>, F>(arg0: F, arg1: Internal.EventPriority_, arg2: boolean, arg3: T, arg4: Internal.Consumer_<T>): void;
        abstract shutdown(): void;
        abstract start(): void;
        abstract addListener<T extends net.minecraftforge.eventbus.api.Event>(arg0: Internal.EventPriority_, arg1: Internal.Consumer_<T>): void;
        abstract addListener<T extends net.minecraftforge.eventbus.api.Event>(arg0: Internal.EventPriority_, arg1: boolean, arg2: T, arg3: Internal.Consumer_<T>): void;
        abstract addListener<T extends net.minecraftforge.eventbus.api.Event>(arg0: Internal.Consumer_<T>): void;
    }
    type IEventBus_ = IEventBus;
    class CAFluids$NoColorFluidAttributes extends Internal.AllFluids$TintedFluidType {
        constructor(arg0: Internal.FluidType$Properties_, arg1: ResourceLocation_, arg2: ResourceLocation_)
        canSwim(arg0: Internal.Entity_): boolean;
        isVaporizedOnPlacement(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.FluidStack_): boolean;
        getDescriptionId(arg0: Internal.FluidStack_): string;
        canBePlacedInLevel(arg0: Internal.BlockAndTintGetter_, arg1: BlockPos_, arg2: Internal.FluidState_): boolean;
        "canBePlacedInLevel(net.minecraft.world.level.BlockAndTintGetter,net.minecraft.core.BlockPos,net.minecraft.world.level.material.FluidState)"(arg0: Internal.BlockAndTintGetter_, arg1: BlockPos_, arg2: Internal.FluidState_): boolean;
        getLightLevel(arg0: Internal.FluidState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_): number;
        notify(): void;
        getDensity(arg0: Internal.FluidState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_): number;
        getSound(arg0: Internal.Entity_, arg1: Internal.SoundAction_): Internal.SoundEvent;
        canExtinguish(arg0: Internal.Entity_): boolean;
        canConvertToSource(arg0: Internal.FluidStack_): boolean;
        getDensity(): number;
        "canBePlacedInLevel(net.minecraft.world.level.BlockAndTintGetter,net.minecraft.core.BlockPos,net.minecraftforge.fluids.FluidStack)"(arg0: Internal.BlockAndTintGetter_, arg1: BlockPos_, arg2: Internal.FluidStack_): boolean;
        getTemperature(arg0: Internal.FluidStack_): number;
        getTintColor(arg0: Internal.FluidState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_): number;
        getRarity(): Internal.Rarity;
        getDescriptionId(): string;
        getFallDistanceModifier(arg0: Internal.Entity_): number;
        getBlockForFluidState(arg0: Internal.BlockAndTintGetter_, arg1: BlockPos_, arg2: Internal.FluidState_): Internal.BlockState;
        getBucket(arg0: Internal.FluidStack_): Internal.ItemStack;
        "getSound(net.minecraftforge.fluids.FluidStack,net.minecraftforge.common.SoundAction)"(arg0: Internal.FluidStack_, arg1: Internal.SoundAction_): Internal.SoundEvent;
        getRarity(arg0: Internal.FluidStack_): Internal.Rarity;
        "canHydrate(net.minecraft.world.entity.Entity)"(arg0: Internal.Entity_): boolean;
        canBePlacedInLevel(arg0: Internal.BlockAndTintGetter_, arg1: BlockPos_, arg2: Internal.FluidStack_): boolean;
        "getSound(net.minecraft.world.entity.Entity,net.minecraftforge.common.SoundAction)"(arg0: Internal.Entity_, arg1: Internal.SoundAction_): Internal.SoundEvent;
        getAdjacentBlockPathType(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        onVaporize(arg0: Internal.Player_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.FluidStack_): void;
        "canHydrate(net.minecraftforge.fluids.FluidStack)"(arg0: Internal.FluidStack_): boolean;
        canHydrate(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: BlockPos_): boolean;
        wait(): void;
        getTemperature(): number;
        supportsBoating(arg0: Internal.FluidState_, arg1: Internal.Boat_): boolean;
        getDescription(): net.minecraft.network.chat.Component;
        getViscosity(): number;
        getSound(arg0: Internal.FluidStack_, arg1: Internal.SoundAction_): Internal.SoundEvent;
        getClass(): typeof any;
        motionScale(arg0: Internal.Entity_): number;
        isVanilla(): boolean;
        getRenderPropertiesInternal(): any;
        isAir(): boolean;
        getLightLevel(arg0: Internal.FluidStack_): number;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientFluidTypeExtensions>): void;
        canDrownIn(arg0: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        getDensity(arg0: Internal.FluidStack_): number;
        getSound(arg0: Internal.SoundAction_): Internal.SoundEvent;
        canPushEntity(arg0: Internal.Entity_): boolean;
        isLighterThanAir(): boolean;
        toString(): string;
        canHydrate(arg0: Internal.Entity_): boolean;
        canRideVehicleUnder(arg0: Internal.Entity_, arg1: Internal.Entity_): boolean;
        supportsBoating(arg0: Internal.Boat_): boolean;
        getLightLevel(): number;
        notifyAll(): void;
        getDescription(arg0: Internal.FluidStack_): net.minecraft.network.chat.Component;
        getViscosity(arg0: Internal.FluidStack_): number;
        getStateForPlacement(arg0: Internal.BlockAndTintGetter_, arg1: BlockPos_, arg2: Internal.FluidStack_): Internal.FluidState;
        getBlockPathType(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: boolean): Internal.BlockPathTypes;
        setItemMovement(arg0: Internal.ItemEntity_): void;
        move(arg0: Internal.FluidState_, arg1: Internal.LivingEntity_, arg2: Vec3d_, arg3: number): boolean;
        canExtinguish(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        shouldUpdateWhileBoating(arg0: Internal.FluidState_, arg1: Internal.Boat_, arg2: Internal.Entity_): boolean;
        getSound(arg0: Internal.Player_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SoundAction_): Internal.SoundEvent;
        canConvertToSource(arg0: Internal.FluidState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        canHydrate(arg0: Internal.FluidStack_): boolean;
        hashCode(): number;
        wait(arg0: number): void;
        getViscosity(arg0: Internal.FluidState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_): number;
        getTemperature(arg0: Internal.FluidState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_): number;
        equals(arg0: any): boolean;
        get density(): number
        get rarity(): Internal.Rarity
        get descriptionId(): string
        get temperature(): number
        get description(): net.minecraft.network.chat.Component
        get viscosity(): number
        get class(): typeof any
        get vanilla(): boolean
        get renderPropertiesInternal(): any
        get air(): boolean
        get lighterThanAir(): boolean
        get lightLevel(): number
        set itemMovement(arg0: Internal.ItemEntity_)
    }
    type CAFluids$NoColorFluidAttributes_ = CAFluids$NoColorFluidAttributes;
    class Proxy$Type extends Internal.Enum<Internal.Proxy$Type> {
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        getClass(): typeof any;
        compareTo(arg0: Internal.Proxy$Type_): number;
        toString(): string;
        notifyAll(): void;
        "compareTo(java.net.Proxy$Type)"(arg0: Internal.Proxy$Type_): number;
        describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<Internal.Proxy$Type>>;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        compareTo(arg0: any): number;
        name(): string;
        hashCode(): number;
        static valueOf(arg0: string): Internal.Proxy$Type;
        ordinal(): number;
        wait(): void;
        wait(arg0: number): void;
        static values(): Internal.Proxy$Type[];
        getDeclaringClass(): typeof Internal.Proxy$Type;
        "compareTo(java.lang.Object)"(arg0: any): number;
        equals(arg0: any): boolean;
        get class(): typeof any
        get declaringClass(): typeof Internal.Proxy$Type
        static readonly SOCKS: (Internal.Proxy$Type) & (Internal.Proxy$Type);
        static readonly HTTP: (Internal.Proxy$Type) & (Internal.Proxy$Type);
        static readonly DIRECT: (Internal.Proxy$Type) & (Internal.Proxy$Type);
    }
    type Proxy$Type_ = Proxy$Type | "http" | "socks" | "direct";
    class EntityAttributeCreationEvent extends net.minecraftforge.eventbus.api.Event implements Internal.IModBusEvent {
        constructor()
        constructor(arg0: Internal.Map_<Internal.EntityType<Internal.LivingEntity>, Internal.AttributeSupplier>)
        getResult(): Internal.Event$Result;
        setCanceled(arg0: boolean): void;
        getClass(): typeof any;
        toString(): string;
        setPhase(arg0: Internal.EventPriority_): void;
        notifyAll(): void;
        isCanceled(): boolean;
        put(arg0: Internal.EntityType_<Internal.LivingEntity>, arg1: Internal.AttributeSupplier_): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        hasResult(): boolean;
        setResult(arg0: Internal.Event$Result_): void;
        hashCode(): number;
        isCancelable(): boolean;
        wait(): void;
        getListenerList(): Internal.ListenerList;
        wait(arg0: number): void;
        getPhase(): Internal.EventPriority;
        equals(arg0: any): boolean;
        get result(): Internal.Event$Result
        set canceled(arg0: boolean)
        get class(): typeof any
        set phase(arg0: Internal.EventPriority_)
        get canceled(): boolean
        set result(arg0: Internal.Event$Result_)
        get cancelable(): boolean
        get listenerList(): Internal.ListenerList
        get phase(): Internal.EventPriority
    }
    type EntityAttributeCreationEvent_ = EntityAttributeCreationEvent;
    class BaseFunction extends Internal.IdScriptableObject implements dev.latvian.mods.rhino.Function {
        constructor()
        constructor(scope: Internal.Scriptable_, prototype: Internal.Scriptable_)
        constructor(isGenerator: boolean)
        preventExtensions(): void;
        static getFunctionPrototype(scope: Internal.Scriptable_, cx: Internal.Context_): Internal.Scriptable;
        static "hasProperty(dev.latvian.mods.rhino.Scriptable,java.lang.String,dev.latvian.mods.rhino.Context)"(obj: Internal.Scriptable_, name: string, cx: Internal.Context_): boolean;
        setImmunePrototypeProperty(value: any): void;
        static getArrayPrototype(scope: Internal.Scriptable_, cx: Internal.Context_): Internal.Scriptable;
        static putProperty(obj: Internal.Scriptable_, key: Internal.Symbol_, value: any, cx: Internal.Context_): void;
        "get(dev.latvian.mods.rhino.Context,java.lang.String,dev.latvian.mods.rhino.Scriptable)"(cx: Internal.Context_, name: string, start: Internal.Scriptable_): any;
        static putProperty(obj: Internal.Scriptable_, name: string, value: any, cx: Internal.Context_): void;
        static "putProperty(dev.latvian.mods.rhino.Scriptable,int,java.lang.Object,dev.latvian.mods.rhino.Context)"(obj: Internal.Scriptable_, index: number, value: any, cx: Internal.Context_): void;
        abstract get(arg0: Internal.Context_, arg1: number, arg2: Internal.Scriptable_): any;
        abstract setParentScope(arg0: Internal.Scriptable_): void;
        "setAttributes(dev.latvian.mods.rhino.Context,int,int)"(cx: Internal.Context_, index: number, attributes: number): void;
        "put(dev.latvian.mods.rhino.Context,dev.latvian.mods.rhino.Symbol,dev.latvian.mods.rhino.Scriptable,java.lang.Object)"(cx: Internal.Context_, key: Internal.Symbol_, start: Internal.Scriptable_, value: any): void;
        getTypeOf(): Internal.MemberType;
        abstract getIds(arg0: Internal.Context_): any[];
        defineOwnProperties(cx: Internal.Context_, props: Internal.ScriptableObject_): void;
        static getTopScopeValue(scope: Internal.Scriptable_, key: any, cx: Internal.Context_): any;
        static deleteProperty(obj: Internal.Scriptable_, index: number, cx: Internal.Context_): boolean;
        "delete(dev.latvian.mods.rhino.Context,dev.latvian.mods.rhino.Symbol)"(cx: Internal.Context_, key: Internal.Symbol_): void;
        setAttributes(cx: Internal.Context_, name: string, attributes: number): void;
        associateValue(key: any, value: any): any;
        abstract getParentScope(): Internal.Scriptable;
        setAttributes(cx: Internal.Context_, key: Internal.Symbol_, attributes: number): void;
        static defineClass<T extends Internal.Scriptable>(scope: Internal.Scriptable_, clazz: T, cx: Internal.Context_): void;
        "delete(dev.latvian.mods.rhino.Context,java.lang.String)"(cx: Internal.Context_, name: string): void;
        getLength(): number;
        avoidObjectDetection(): boolean;
        static getClassPrototype(scope: Internal.Scriptable_, className: string, cx: Internal.Context_): Internal.Scriptable;
        put(cx: Internal.Context_, name: string, start: Internal.Scriptable_, value: any): void;
        static getProperty(obj: Internal.Scriptable_, key: Internal.Symbol_, cx: Internal.Context_): any;
        getClass(): typeof any;
        static hasProperty(obj: Internal.Scriptable_, name: string, cx: Internal.Context_): boolean;
        abstract "delete(dev.latvian.mods.rhino.Context,int)"(arg0: Internal.Context_, arg1: number): void;
        call(cx: Internal.Context_, scope: Internal.Scriptable_, thisObj: Internal.Scriptable_, args: any[]): any;
        hasInstance(cx: Internal.Context_, instance: Internal.Scriptable_): boolean;
        getExternalArrayData(): Internal.ExternalArrayData;
        abstract put(arg0: Internal.Context_, arg1: number, arg2: Internal.Scriptable_, arg3: any): void;
        static "getProperty(dev.latvian.mods.rhino.Scriptable,java.lang.String,dev.latvian.mods.rhino.Context)"(obj: Internal.Scriptable_, name: string, cx: Internal.Context_): any;
        "defineProperty(dev.latvian.mods.rhino.Context,dev.latvian.mods.rhino.Symbol,java.lang.Object,int)"(cx: Internal.Context_, key: Internal.Symbol_, value: any, attributes: number): void;
        "initPrototypeMethod(java.lang.Object,int,java.lang.String,java.lang.String,int,dev.latvian.mods.rhino.Context)"(tag: any, id: number, propertyName: string, functionName: string, arity: number, cx: Internal.Context_): Internal.IdFunctionObject;
        static defineConstProperty(destination: Internal.Scriptable_, propertyName: string, cx: Internal.Context_): void;
        sealObject(cx: Internal.Context_): void;
        initPrototypeMethod(tag: any, id: number, name: string, arity: number, cx: Internal.Context_): Internal.IdFunctionObject;
        abstract has(arg0: Internal.Context_, arg1: number, arg2: Internal.Scriptable_): boolean;
        createObject(cx: Internal.Context_, scope: Internal.Scriptable_): Internal.Scriptable;
        static deleteProperty(obj: Internal.Scriptable_, name: string, cx: Internal.Context_): boolean;
        "initPrototypeValue(int,dev.latvian.mods.rhino.Symbol,java.lang.Object,int)"(id: number, key: Internal.Symbol_, value: any, attributes: number): void;
        "get(dev.latvian.mods.rhino.Context,dev.latvian.mods.rhino.Symbol,dev.latvian.mods.rhino.Scriptable)"(cx: Internal.Context_, key: Internal.Symbol_, start: Internal.Scriptable_): any;
        static defineProperty(destination: Internal.Scriptable_, propertyName: string, value: any, attributes: number, cx: Internal.Context_): void;
        getAttributes(cx: Internal.Context_, index: number): number;
        static "deleteProperty(dev.latvian.mods.rhino.Scriptable,int,dev.latvian.mods.rhino.Context)"(obj: Internal.Scriptable_, index: number, cx: Internal.Context_): boolean;
        getArity(): number;
        toString(): string;
        notifyAll(): void;
        "initPrototypeValue(int,java.lang.String,java.lang.Object,int)"(id: number, name: string, value: any, attributes: number): void;
        setGetterOrSetter(cx: Internal.Context_, name: string, index: number, getterOrSetter: dev.latvian.mods.rhino.Callable_, isSetter: boolean): void;
        enumerationIteratorNext(cx: Internal.Context_, currentId: Internal.Consumer_<any>): boolean;
        static defineClass<T extends Internal.Scriptable>(scope: Internal.Scriptable_, clazz: T, sealed: boolean, mapInheritance: boolean, cx: Internal.Context_): string;
        has(cx: Internal.Context_, key: Internal.Symbol_, start: Internal.Scriptable_): boolean;
        static getProperty(obj: Internal.Scriptable_, name: string, cx: Internal.Context_): any;
        size(): number;
        static "putProperty(dev.latvian.mods.rhino.Scriptable,java.lang.String,java.lang.Object,dev.latvian.mods.rhino.Context)"(obj: Internal.Scriptable_, name: string, value: any, cx: Internal.Context_): void;
        execIdCall(f: Internal.IdFunctionObject_, cx: Internal.Context_, scope: Internal.Scriptable_, thisObj: Internal.Scriptable_, args: any[]): any;
        static getObjectPrototype(scope: Internal.Scriptable_, cx: Internal.Context_): Internal.Scriptable;
        wait(arg0: number): void;
        construct(cx: Internal.Context_, scope: Internal.Scriptable_, args: any[]): Internal.Scriptable;
        initPrototypeValue(id: number, key: Internal.Symbol_, value: any, attributes: number): void;
        defineProperty(cx: Internal.Context_, propertyName: string, value: any, attributes: number): void;
        initPrototypeValue(id: number, name: string, value: any, attributes: number): void;
        setAttributes(cx: Internal.Context_, index: number, attributes: number): void;
        putConst(cx: Internal.Context_, name: string, start: Internal.Scriptable_, value: any): void;
        static "getProperty(dev.latvian.mods.rhino.Scriptable,dev.latvian.mods.rhino.Symbol,dev.latvian.mods.rhino.Context)"(obj: Internal.Scriptable_, key: Internal.Symbol_, cx: Internal.Context_): any;
        defineProperty(cx: Internal.Context_, propertyName: string, delegateTo: any, getter: Internal.WrappedExecutable_, setter: Internal.WrappedExecutable_, attributes: number): void;
        getClassName(): string;
        defineFunctionProperties(cx: Internal.Context_, names: string[], clazz: typeof any, attributes: number): void;
        "delete"(cx: Internal.Context_, name: string): void;
        static putProperty(obj: Internal.Scriptable_, index: number, value: any, cx: Internal.Context_): void;
        abstract "delete"(arg0: Internal.Context_, arg1: number): void;
        "initPrototypeMethod(java.lang.Object,int,dev.latvian.mods.rhino.Symbol,java.lang.String,int,dev.latvian.mods.rhino.Context)"(tag: any, id: number, key: Internal.Symbol_, functionName: string, arity: number, cx: Internal.Context_): Internal.IdFunctionObject;
        static getGeneratorFunctionPrototype(scope: Internal.Scriptable_, cx: Internal.Context_): Internal.Scriptable;
        "put(dev.latvian.mods.rhino.Context,java.lang.String,dev.latvian.mods.rhino.Scriptable,java.lang.Object)"(cx: Internal.Context_, name: string, start: Internal.Scriptable_, value: any): void;
        static defineClass<T extends Internal.Scriptable>(scope: Internal.Scriptable_, clazz: T, sealed: boolean, cx: Internal.Context_): void;
        notify(): void;
        initPrototypeMethod(tag: any, id: number, propertyName: string, functionName: string, arity: number, cx: Internal.Context_): Internal.IdFunctionObject;
        static putConstProperty(obj: Internal.Scriptable_, name: string, value: any, cx: Internal.Context_): void;
        hasPrototypeMap(): boolean;
        static redefineProperty(obj: Internal.Scriptable_, name: string, isConst: boolean, cx: Internal.Context_): void;
        static "putProperty(dev.latvian.mods.rhino.Scriptable,dev.latvian.mods.rhino.Symbol,java.lang.Object,dev.latvian.mods.rhino.Context)"(obj: Internal.Scriptable_, key: Internal.Symbol_, value: any, cx: Internal.Context_): void;
        get(cx: Internal.Context_, key: any): any;
        get(cx: Internal.Context_, name: string, start: Internal.Scriptable_): any;
        abstract getPrototype(arg0: Internal.Context_): Internal.Scriptable;
        static getDefaultValue(object: Internal.Scriptable_, typeHint: typeof any, cx: Internal.Context_): any;
        abstract "put(dev.latvian.mods.rhino.Context,int,dev.latvian.mods.rhino.Scriptable,java.lang.Object)"(arg0: Internal.Context_, arg1: number, arg2: Internal.Scriptable_, arg3: any): void;
        enumerationIteratorHasNext(cx: Internal.Context_, currentId: Internal.Consumer_<any>): boolean;
        static "getProperty(dev.latvian.mods.rhino.Scriptable,int,dev.latvian.mods.rhino.Context)"(obj: Internal.Scriptable_, index: number, cx: Internal.Context_): any;
        abstract "has(dev.latvian.mods.rhino.Context,int,dev.latvian.mods.rhino.Scriptable)"(arg0: Internal.Context_, arg1: number, arg2: Internal.Scriptable_): boolean;
        isConst(name: string): boolean;
        getAttributes(cx: Internal.Context_, key: Internal.Symbol_): number;
        initPrototypeConstructor(f: Internal.IdFunctionObject_, cx: Internal.Context_): void;
        static "deleteProperty(dev.latvian.mods.rhino.Scriptable,java.lang.String,dev.latvian.mods.rhino.Context)"(obj: Internal.Scriptable_, name: string, cx: Internal.Context_): boolean;
        "getAttributes(dev.latvian.mods.rhino.Context,int)"(cx: Internal.Context_, index: number): number;
        isExtensible(): boolean;
        wait(): void;
        abstract setPrototype(arg0: Internal.Scriptable_): void;
        getGetterOrSetter(name: string, index: number, isSetter: boolean): any;
        getAttributes(cx: Internal.Context_, name: string): number;
        activatePrototypeMap(maxPrototypeId: number): void;
        defineProperty(cx: Internal.Context_, key: Internal.Symbol_, value: any, attributes: number): void;
        static getPropertyIds(cx: Internal.Context_, obj: Internal.Scriptable_): any[];
        getAssociatedValue(key: any): any;
        "defineProperty(dev.latvian.mods.rhino.Context,java.lang.String,java.lang.Object,int)"(cx: Internal.Context_, propertyName: string, value: any, attributes: number): void;
        "delete"(cx: Internal.Context_, key: Internal.Symbol_): void;
        initPrototypeMethod(tag: any, id: number, key: Internal.Symbol_, functionName: string, arity: number, cx: Internal.Context_): Internal.IdFunctionObject;
        static "hasProperty(dev.latvian.mods.rhino.Scriptable,int,dev.latvian.mods.rhino.Context)"(obj: Internal.Scriptable_, index: number, cx: Internal.Context_): boolean;
        static getProperty(obj: Internal.Scriptable_, index: number, cx: Internal.Context_): any;
        "has(dev.latvian.mods.rhino.Context,java.lang.String,dev.latvian.mods.rhino.Scriptable)"(cx: Internal.Context_, name: string, start: Internal.Scriptable_): boolean;
        isEmpty(): boolean;
        wait(arg0: number, arg1: number): void;
        has(cx: Internal.Context_, name: string, start: Internal.Scriptable_): boolean;
        defineConst(cx: Internal.Context_, name: string, start: Internal.Scriptable_): void;
        "defineProperty(dev.latvian.mods.rhino.Context,java.lang.String,java.lang.Class,int)"(cx: Internal.Context_, propertyName: string, clazz: typeof any, attributes: number): void;
        defineOwnProperty(cx: Internal.Context_, key: any, desc: Internal.ScriptableObject_): void;
        getFunctionName(): string;
        abstract getDefaultValue(arg0: Internal.Context_, arg1: typeof any): any;
        setExternalArrayData(cx: Internal.Context_, array: Internal.ExternalArrayData_): void;
        "getAttributes(dev.latvian.mods.rhino.Context,java.lang.String)"(cx: Internal.Context_, name: string): number;
        get(cx: Internal.Context_, key: Internal.Symbol_, start: Internal.Scriptable_): any;
        static hasProperty(obj: Internal.Scriptable_, key: Internal.Symbol_, cx: Internal.Context_): boolean;
        "setAttributes(dev.latvian.mods.rhino.Context,java.lang.String,int)"(cx: Internal.Context_, name: string, attributes: number): void;
        isSealed(cx: Internal.Context_): boolean;
        getAllIds(cx: Internal.Context_): any[];
        "has(dev.latvian.mods.rhino.Context,dev.latvian.mods.rhino.Symbol,dev.latvian.mods.rhino.Scriptable)"(cx: Internal.Context_, key: Internal.Symbol_, start: Internal.Scriptable_): boolean;
        defineProperty(cx: Internal.Context_, propertyName: string, clazz: typeof any, attributes: number): void;
        static hasProperty(obj: Internal.Scriptable_, index: number, cx: Internal.Context_): boolean;
        exportAsJSClass(maxPrototypeId: number, scope: Internal.Scriptable_, sealed: boolean, cx: Internal.Context_): Internal.IdFunctionObject;
        abstract "get(dev.latvian.mods.rhino.Context,int,dev.latvian.mods.rhino.Scriptable)"(arg0: Internal.Context_, arg1: number, arg2: Internal.Scriptable_): any;
        "setAttributes(dev.latvian.mods.rhino.Context,dev.latvian.mods.rhino.Symbol,int)"(cx: Internal.Context_, key: Internal.Symbol_, attributes: number): void;
        static "hasProperty(dev.latvian.mods.rhino.Scriptable,dev.latvian.mods.rhino.Symbol,dev.latvian.mods.rhino.Context)"(obj: Internal.Scriptable_, key: Internal.Symbol_, cx: Internal.Context_): boolean;
        hashCode(): number;
        getExternalArrayLength(): any;
        "getAttributes(dev.latvian.mods.rhino.Context,dev.latvian.mods.rhino.Symbol)"(cx: Internal.Context_, key: Internal.Symbol_): number;
        static getTopLevelScope(obj: Internal.Scriptable_): Internal.Scriptable;
        put(cx: Internal.Context_, key: Internal.Symbol_, start: Internal.Scriptable_, value: any): void;
        equals(arg0: any): boolean;
        set immunePrototypeProperty(value: any)
        set parentScope(arg0: Internal.Scriptable_)
        get typeOf(): Internal.MemberType
        get parentScope(): Internal.Scriptable
        get length(): number
        get class(): typeof any
        get externalArrayData(): Internal.ExternalArrayData
        get arity(): number
        get className(): string
        get extensible(): boolean
        set prototype(arg0: Internal.Scriptable_)
        get empty(): boolean
        get functionName(): string
        get externalArrayLength(): any
    }
    type BaseFunction_ = BaseFunction;
    class HierarchyEvent extends Internal.AWTEvent {
        constructor(arg0: Internal.Component_, arg1: number, arg2: Internal.Component_, arg3: Internal.Container_, arg4: number)
        constructor(arg0: Internal.Component_, arg1: number, arg2: Internal.Component_, arg3: Internal.Container_)
        getClass(): typeof any;
        getChangedParent(): Internal.Container;
        toString(): string;
        paramString(): string;
        notifyAll(): void;
        getChanged(): Internal.Component;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        hashCode(): number;
        wait(): void;
        wait(arg0: number): void;
        setSource(arg0: any): void;
        getComponent(): Internal.Component;
        getSource(): any;
        getChangeFlags(): number;
        equals(arg0: any): boolean;
        getID(): number;
        get class(): typeof any
        get changedParent(): Internal.Container
        get changed(): Internal.Component
        set source(arg0: any)
        get component(): Internal.Component
        get source(): any
        get changeFlags(): number
        get ID(): number
        static readonly ANCESTOR_RESIZED: (1402) & (number);
        static readonly PARENT_CHANGED: (1) & (number);
        static readonly ANCESTOR_MOVED: (1401) & (number);
        static readonly HIERARCHY_LAST: (1402) & (number);
        static readonly HIERARCHY_FIRST: (1400) & (number);
        static readonly HIERARCHY_CHANGED: (1400) & (number);
        static readonly DISPLAYABILITY_CHANGED: (2) & (number);
        static readonly SHOWING_CHANGED: (4) & (number);
    }
    type HierarchyEvent_ = HierarchyEvent;
    class NbtDungeonConfig implements Internal.FeatureConfiguration {
        constructor(replaceAir: boolean, minAirSpace: number, maxAirSpace: number, maxNumOfChests: number, airRequirementIsNowWater: boolean, structureYOffset: number, lootBlock: Internal.Block_, chestIdentifier: ResourceLocation_, rsSpawnerIdentifier: ResourceLocation_, processor: ResourceLocation_, postProcessor: ResourceLocation_, nbtIdentifiersAndWeights: Internal.List_<Internal.Pair<ResourceLocation, number>>, chanceOfSpawningLootBlockAtSpot: Internal.Optional_<number>)
        getClass(): typeof any;
        hashCode(): number;
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        toString(): string;
        wait(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        get class(): typeof any
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        readonly structureYOffset: number;
        readonly replaceAir: boolean;
        readonly processor: ResourceLocation;
        readonly maxNumOfChests: number;
        readonly postProcessor: ResourceLocation;
        readonly chestResourcelocation: ResourceLocation;
        readonly chanceOfSpawningLootBlockAtSpot: Internal.Optional<number>;
        static readonly CODEC: Internal.Codec<Internal.NbtDungeonConfig>;
        readonly maxAirSpace: number;
        readonly nbtResourcelocationsAndWeights: Internal.List<Internal.Pair<ResourceLocation, number>>;
        readonly minAirSpace: number;
        readonly rsSpawnerResourcelocation: ResourceLocation;
        readonly airRequirementIsNowWater: boolean;
        readonly lootBlock: Internal.Block;
    }
    type NbtDungeonConfig_ = NbtDungeonConfig;
    interface EnumEntries <E extends Internal.Enum<E>> extends Internal.List<E>, Internal.KMappedMarker {
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.List<E>;
        copyOf<E>(arg0: Internal.Collection_<E>): Internal.List<E>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.List<E>;
        sort(arg0: Internal.Comparator_<E>): void;
        of<E>(arg0: E): Internal.List<E>;
        of<E>(): Internal.List<E>;
        abstract retainAll(arg0: Internal.Collection_<any>): boolean;
        abstract "remove(int)"(arg0: number): E;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        abstract addAll(arg0: number, arg1: Internal.Collection_<E>): boolean;
        abstract addAll(arg0: Internal.Collection_<E>): boolean;
        of<E>(arg0: E, arg1: E, arg2: E): Internal.List<E>;
        abstract subList(arg0: number, arg1: number): Internal.List<E>;
        abstract indexOf(arg0: any): number;
        abstract add(arg0: number, arg1: E): void;
        forEach(arg0: Internal.Consumer_<E>): void;
        abstract toArray<T>(arg0: T[]): T[];
        abstract remove(arg0: any): boolean;
        abstract "remove(java.lang.Object)"(arg0: any): boolean;
        abstract listIterator(arg0: number): Internal.ListIterator<E>;
        abstract iterator(): Internal.Iterator<E>;
        of<E>(arg0: E, arg1: E): Internal.List<E>;
        stream(): Internal.Stream<E>;
        abstract removeAll(arg0: Internal.Collection_<any>): boolean;
        removeIf(arg0: Internal.Predicate_<E>): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.List<E>;
        "of(java.lang.Object[])"<E>(...arg0: E[]): Internal.List<E>;
        abstract lastIndexOf(arg0: any): number;
        abstract get(arg0: number): E;
        abstract add(arg0: E): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.List<E>;
        abstract listIterator(): Internal.ListIterator<E>;
        parallelStream(): Internal.Stream<E>;
        abstract isEmpty(): boolean;
        abstract set(arg0: number, arg1: E): E;
        of<E>(...arg0: E[]): Internal.List<E>;
        abstract containsAll(arg0: Internal.Collection_<any>): boolean;
        abstract remove(arg0: number): E;
        abstract contains(arg0: any): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.List<E>;
        "of(java.lang.Object)"<E>(arg0: E): Internal.List<E>;
        replaceAll(arg0: Internal.UnaryOperator_<E>): void;
        abstract "toArray(java.lang.Object[])"<T>(arg0: T[]): T[];
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.List<E>;
        "toArray(java.util.function.IntFunction)"<T>(arg0: Internal.IntFunction_<T[]>): T[];
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.List<E>;
        abstract toArray(): any[];
        abstract hashCode(): number;
        abstract size(): number;
        abstract clear(): void;
        spliterator(): Internal.Spliterator<E>;
        abstract equals(arg0: any): boolean;
        get empty(): boolean
    }
    type EnumEntries_<E extends Internal.Enum<E>> = EnumEntries<E>;
    class ArmBlockEntity extends Internal.KineticBlockEntity implements Internal.ITransformableBlockEntity {
        constructor(arg0: Internal.BlockEntityType_<any>, arg1: BlockPos_, arg2: Internal.BlockState_)
        clearKineticInformation(): void;
        static switchToBlockState(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        emf$hasVehicle(): boolean;
        requestModelDataUpdate(): void;
        etf$getType(): Internal.EntityType<any>;
        emf$getVelocity(): Vec3d;
        destroy(): void;
        containedFluidTooltip(arg0: Internal.List_<net.minecraft.network.chat.Component>, arg1: boolean, arg2: Internal.LazyOptional_<Internal.IFluidHandler>): boolean;
        write(arg0: Internal.CompoundTag_, arg1: boolean): void;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityDispatcher)"(arg0: Internal.CapabilityDispatcher_): boolean;
        getGeneratedSpeed(): number;
        etf$isBlockEntity(): boolean;
        isCustomConnection(arg0: Internal.KineticBlockEntity_, arg1: Internal.BlockState_, arg2: Internal.BlockState_): boolean;
        readClient(arg0: Internal.CompoundTag_): void;
        isVirtual(): boolean;
        /**
         * @deprecated
        */
        setBlockState(arg0: Internal.BlockState_): void;
        handler$dbg000$setLevel(arg0: Internal.Level_, arg1: Internal.CallbackInfo_): void;
        transform(arg0: Internal.StructureTransform_): void;
        remove(): void;
        load(arg0: Internal.CompoundTag_): void;
        award(arg0: Internal.CreateAdvancement_): void;
        setChanged(): void;
        setCulled(value: boolean): void;
        getFlickerScore(): number;
        saveWithoutMetadata(): Internal.CompoundTag;
        setTimeout(): void;
        static convertToAngular(arg0: number): number;
        isOutOfCamera(): boolean;
        "getUpdatePacket()"(): Internal.Packet<any>;
        packetTarget(): Internal.PacketDistributor$PacketTarget;
        emf$prevZ(): number;
        writeInteractionPoints(arg0: Internal.CompoundTag_): void;
        etf$canBeBright(): boolean;
        setRemoved(): void;
        emf$isOnGround(): boolean;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        etf$getPose(): Internal.Pose;
        etf$getEntityKey(): string;
        writeSafe(arg0: Internal.CompoundTag_): void;
        isCulled(): boolean;
        attachKinetics(): void;
        getType(): Internal.BlockEntityType<any>;
        static convertToDirection(arg0: number, arg1: Internal.Direction_): number;
        writeClient(arg0: Internal.CompoundTag_): Internal.CompoundTag;
        etf$getOptifineId(): number;
        setNetwork(arg0: number): void;
        onSpeedChanged(arg0: number): void;
        "getUpdatePacket()"(): Internal.ClientboundBlockEntityDataPacket;
        refreshBlockState(): void;
        getRenderBoundingBox(): Internal.AABB;
        getOrCreateNetwork(): Internal.KineticNetwork;
        getClass(): typeof any;
        sendToMenu(arg0: Internal.FriendlyByteBuf_): void;
        emf$isInvisible(): boolean;
        static getPosFromTag(arg0: Internal.CompoundTag_): BlockPos;
        etf$distanceTo(entity: Internal.Entity_): number;
        emf$isSprinting(): boolean;
        addBehaviours(arg0: Internal.List_<Internal.BlockEntityBehaviour>): void;
        hasAnyComparatorNearby(): boolean;
        static getRange(): number;
        onChunkUnloaded(): void;
        setSource(arg0: BlockPos_): void;
        saveToItem(arg0: Internal.ItemStack_): void;
        "deserializeNBT(net.minecraft.nbt.CompoundTag)"(arg0: Internal.CompoundTag_): void;
        static addEntityType(arg0: Internal.CompoundTag_, arg1: Internal.BlockEntityType_<any>): void;
        emf$isInLava(): boolean;
        "deserializeNBT(net.minecraft.nbt.Tag)"(arg0: Internal.Tag_): void;
        onComparatorAdded(direction: Internal.Direction_, offset: number): void;
        clearRemoved(): void;
        emf$isWet(): boolean;
        getUpdatePacket(): Internal.Packet<any>;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityProvider)"(arg0: Internal.CapabilityProvider_<Internal.BlockEntity>): boolean;
        setLazyTickRate(arg0: number): void;
        handler$dbg000$setRemoved(arg0: Internal.CallbackInfo_): void;
        needsSpeedUpdate(): boolean;
        awardIfNear(arg0: Internal.CreateAdvancement_, arg1: number): void;
        containedChunk(): Internal.LevelChunk;
        getPersistentData(): Internal.CompoundTag;
        toString(): string;
        markVirtual(): void;
        triggerEvent(arg0: number, arg1: number): boolean;
        emf$isGlowing(): boolean;
        hasLevel(): boolean;
        notifyAll(): void;
        forEachBehaviour(arg0: Internal.Consumer_<Internal.BlockEntityBehaviour>): void;
        redstoneUpdate(): void;
        invalidate(): void;
        etf$getScoreboardTeam(): Internal.Team;
        emf$getZ(): number;
        tickAudio(): void;
        removeSource(): void;
        setType_HammerLib(arg0: Internal.BlockEntityType_<any>): void;
        wait(arg0: number): void;
        addPropagationLocations(arg0: Internal.IRotate_, arg1: Internal.BlockState_, arg2: Internal.List_<BlockPos>): Internal.List<BlockPos>;
        etf$getItemsEquipped(): Internal.Iterable<any>;
        etf$getVelocity(): Vec3d;
        reviveCaps(): void;
        sendData(): void;
        getBehaviour<T extends Internal.BlockEntityBehaviour>(arg0: Internal.BehaviourType_<T>): T;
        etf$getWorld(): Internal.Level;
        getUpdateTag(): Internal.CompoundTag;
        handleUpdateTag(arg0: Internal.CompoundTag_): void;
        emf$getYaw(): number;
        setLevel(arg0: Internal.Level_): void;
        calculateStressApplied(): number;
        notify(): void;
        addBehavioursDeferred(arg0: Internal.List_<Internal.BlockEntityBehaviour>): void;
        getBlockPos(): BlockPos;
        etf$getNbt(): Internal.CompoundTag;
        isRemoved(): boolean;
        updateFromNetwork(arg0: number, arg1: number, arg2: number): void;
        emf$isSneaking(): boolean;
        etf$getBlockPos(): BlockPos;
        onLoad(): void;
        calculateAddedStressCapacity(): number;
        fillCrashReportCategory(arg0: Internal.CrashReportCategory_): void;
        hasSource(): boolean;
        emf$prevPitch(): number;
        etf$getBlockY(): number;
        initialize(): void;
        etf$getHandItems(): Internal.Iterable<any>;
        etf$getArmorItems(): Internal.Iterable<any>;
        emf$getY(): number;
        invalidateCaps(): void;
        emf$prevX(): number;
        isOverStressed(): boolean;
        getBlockState(): Internal.BlockState;
        warnOfMovement(): void;
        getSpeed(): number;
        tick(): void;
        canPlayerUse(arg0: Internal.Player_): boolean;
        static convertToLinear(arg0: number): number;
        lazyTick(): void;
        emf$age(): number;
        etf$hasCustomName(): boolean;
        static loadStatic(arg0: BlockPos_, arg1: Internal.BlockState_, arg2: Internal.CompoundTag_): Internal.BlockEntity;
        wait(): void;
        emf$isTouchingWater(): boolean;
        addToTooltip(arg0: Internal.List_<net.minecraft.network.chat.Component>, arg1: boolean): boolean;
        m_183515_(arg0: Internal.CompoundTag_): void;
        emf$getVariableMap(): Internal.Object2FloatOpenHashMap<any>;
        areCapsCompatible(arg0: Internal.CapabilityDispatcher_): boolean;
        isSource(): boolean;
        etf$getCustomName(): net.minecraft.network.chat.Component;
        getCapability<T>(arg0: Internal.Capability_<T>, arg1: Internal.Direction_): Internal.LazyOptional<T>;
        saveWithId(): Internal.CompoundTag;
        detachKinetics(): void;
        notifyUpdate(): void;
        isSpeedRequirementFulfilled(): boolean;
        setSpeed(arg0: number): void;
        setOutOfCamera(value: boolean): void;
        wait(arg0: number, arg1: number): void;
        isChunkUnloaded(): boolean;
        getLevel(): Internal.Level;
        getRequiredItems(arg0: Internal.BlockState_): Internal.ItemRequirement;
        onlyOpCanSetNbt(): boolean;
        serializeNBT(): Internal.Tag;
        onDataPacket(arg0: Internal.Connection_, arg1: Internal.ClientboundBlockEntityDataPacket_): void;
        saveWithFullMetadata(): Internal.CompoundTag;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        getTheoreticalSpeed(): number;
        getIcon(arg0: boolean): Internal.ItemStack;
        emf$prevY(): number;
        propagateRotationTo(arg0: Internal.KineticBlockEntity_, arg1: Internal.BlockState_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: boolean, arg5: boolean): number;
        emf$getX(): number;
        areCapsCompatible(arg0: Internal.CapabilityProvider_<Internal.BlockEntity>): boolean;
        emf$isOnFire(): boolean;
        deserializeNBT(arg0: Internal.Tag_): void;
        blockHolderGetter(): Internal.HolderGetter<Internal.Block>;
        etf$getUuid(): Internal.UUID;
        hasNetwork(): boolean;
        getAllBehaviours(): Internal.Collection<Internal.BlockEntityBehaviour>;
        getUpdatePacket(): Internal.ClientboundBlockEntityDataPacket;
        isForcedVisible(): boolean;
        emf$hasPassengers(): boolean;
        registerAwardables(arg0: Internal.List_<Internal.BlockEntityBehaviour>, ...arg1: Internal.CreateAdvancement_[]): void;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        hashCode(): number;
        emf$getTypeString(): string;
        getModelData(): Internal.ModelData;
        addToGoggleTooltip(arg0: Internal.List_<net.minecraft.network.chat.Component>, arg1: boolean): boolean;
        emf$getPitch(): number;
        emf$isAlive(): boolean;
        getRotationAngleOffset(arg0: Internal.Direction$Axis_): number;
        equals(arg0: any): boolean;
        get generatedSpeed(): number
        get virtual(): boolean
        /**
         * @deprecated
        */
        set blockState(arg0: Internal.BlockState_)
        set culled(value: boolean)
        get flickerScore(): number
        get outOfCamera(): boolean
        get "updatePacket()"(): Internal.Packet<any>
        get culled(): boolean
        get type(): Internal.BlockEntityType<any>
        set network(arg0: number)
        get "updatePacket()"(): Internal.ClientboundBlockEntityDataPacket
        get renderBoundingBox(): Internal.AABB
        get orCreateNetwork(): Internal.KineticNetwork
        get class(): typeof any
        get range(): number
        set source(arg0: BlockPos_)
        get updatePacket(): Internal.Packet<any>
        set lazyTickRate(arg0: number)
        get persistentData(): Internal.CompoundTag
        set type_HammerLib(arg0: Internal.BlockEntityType_<any>)
        get updateTag(): Internal.CompoundTag
        set level(arg0: Internal.Level_)
        get blockPos(): BlockPos
        get removed(): boolean
        get overStressed(): boolean
        get blockState(): Internal.BlockState
        get speed(): number
        get source(): boolean
        get speedRequirementFulfilled(): boolean
        set speed(arg0: number)
        set outOfCamera(value: boolean)
        get chunkUnloaded(): boolean
        get level(): Internal.Level
        get theoreticalSpeed(): number
        get allBehaviours(): Internal.Collection<Internal.BlockEntityBehaviour>
        get updatePacket(): Internal.ClientboundBlockEntityDataPacket
        get forcedVisible(): boolean
        get modelData(): Internal.ModelData
    }
    type ArmBlockEntity_ = ArmBlockEntity;
    class ClientRecipeTracker$Serializer implements Internal.RecipeSerializer<Internal.ClientRecipeTracker> {
        constructor()
        getClass(): typeof any;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_, arg2: Internal.ICondition$IContext_): Internal.ClientRecipeTracker;
        "fromNetwork(net.minecraft.resources.ResourceLocation,net.minecraft.network.FriendlyByteBuf)"(recipeId: ResourceLocation_, buffer: Internal.FriendlyByteBuf_): Internal.ClientRecipeTracker;
        "fromNetwork(net.minecraft.resources.ResourceLocation,net.minecraft.network.FriendlyByteBuf)"(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): Internal.Recipe<any>;
        toString(): string;
        "toNetwork(net.minecraft.network.FriendlyByteBuf,net.minecraft.world.item.crafting.Recipe)"(arg0: Internal.FriendlyByteBuf_, arg1: Internal.Recipe_<any>): void;
        notifyAll(): void;
        fromJson(recipeId: ResourceLocation_, json: Internal.JsonObject_): Internal.ClientRecipeTracker;
        toNetwork(arg0: Internal.FriendlyByteBuf_, arg1: Internal.Recipe_<any>): void;
        notify(): void;
        "fromJson(net.minecraft.resources.ResourceLocation,com.google.gson.JsonObject)"(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
        wait(arg0: number, arg1: number): void;
        fromNetwork(recipeId: ResourceLocation_, buffer: Internal.FriendlyByteBuf_): Internal.ClientRecipeTracker;
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>(arg0: string, arg1: S): S;
        hashCode(): number;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
        wait(): void;
        wait(arg0: number): void;
        toNetwork(buffer: Internal.FriendlyByteBuf_, recipe: Internal.ClientRecipeTracker_): void;
        "toNetwork(net.minecraft.network.FriendlyByteBuf,com.almostreliable.unified.recipe.ClientRecipeTracker)"(buffer: Internal.FriendlyByteBuf_, recipe: Internal.ClientRecipeTracker_): void;
        equals(arg0: any): boolean;
        fromNetwork(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): Internal.Recipe<any>;
        "fromJson(net.minecraft.resources.ResourceLocation,com.google.gson.JsonObject)"(recipeId: ResourceLocation_, json: Internal.JsonObject_): Internal.ClientRecipeTracker;
        get class(): typeof any
    }
    type ClientRecipeTracker$Serializer_ = ClientRecipeTracker$Serializer;
    class BoxedPressurizedTube extends Internal.BufferedTransmitter<Internal.BoxedChemicalHandler, Internal.BoxedChemicalNetwork, Internal.BoxedChemicalStack, Internal.BoxedPressurizedTube> implements Internal.IInfusionTracker, Internal.IPigmentTracker, Internal.IGasTracker, Internal.ISlurryTracker, Internal.IUpgradeableTransmitter<Internal.PressurizedTubeUpgradeData> {
        constructor(blockProvider: Internal.IBlockProvider_, tile: Internal.TileEntityTransmitter_)
        markDirtyAcceptor(side: Internal.Direction_): void;
        getConnections(type: Internal.ConnectionType_): Internal.Set<Internal.Direction>;
        setConnectionTypeRaw(side: Internal.Direction_, type: Internal.ConnectionType_): void;
        hasTransmitterNetwork(): boolean;
        getNewOrphanValidator(): Internal.CompatibleTransmitterValidator<Internal.BoxedChemicalHandler, Internal.BoxedChemicalNetwork, Internal.BoxedPressurizedTube>;
        handleUpdateTag(tag: Internal.CompoundTag_): void;
        supportsTransmissionType(transmitter: Internal.TileEntityTransmitter_): boolean;
        getBufferWithFallback(): Internal.BoxedChemicalStack;
        notify(): void;
        takeShare(): void;
        getUpgradeData(): Internal.TransmitterUpgradeData;
        pullFromAcceptors(): void;
        requestsUpdate(): void;
        remove(): void;
        "supportsTransmissionType(mekanism.common.content.network.transmitter.Transmitter)"(transmitter: Internal.Transmitter_<any, any, any>): boolean;
        getGasTank(): Internal.IGasTank;
        refreshConnections(side: Internal.Direction_): void;
        noBufferOrFallback(): boolean;
        canConnectMutual(side: Internal.Direction_, cachedTransmitter: Internal.BoxedPressurizedTube_): boolean;
        canConnect(side: Internal.Direction_): boolean;
        isValid(): boolean;
        getTilePos(): BlockPos;
        getTileCoord(): Internal.Coord4D;
        getConnectionTypeRaw(side: Internal.Direction_): Internal.ConnectionType;
        onNeighborTileChange(side: Internal.Direction_): void;
        supportsTransmissionType(transmitter: Internal.Transmitter_<any, any, any>): boolean;
        getGasTanks(side: Internal.Direction_): Internal.List<Internal.IGasTank>;
        getAcceptor(side: Internal.Direction_): Internal.LazyOptional<Internal.BoxedChemicalHandler>;
        refreshConnections(): void;
        getSlurryTanks(side: Internal.Direction_): Internal.List<Internal.ISlurryTank>;
        getTier(): Internal.TubeTier;
        handlesRedstone(): boolean;
        wait(): void;
        getShare(): Internal.BoxedChemicalStack;
        isValidAcceptor(tile: Internal.BlockEntity_, side: Internal.Direction_): boolean;
        setOrphan(nowOrphaned: boolean): void;
        getTransmitterTile(): Internal.TileEntityTransmitter;
        createEmptyNetworkWithID(networkID: Internal.UUID_): Internal.DynamicNetwork<any, any, any>;
        getCapacity(): number;
        getClass(): typeof any;
        "canConnectMutual(net.minecraft.core.Direction,mekanism.common.content.network.transmitter.BoxedPressurizedTube)"(side: Internal.Direction_, cachedTransmitter: Internal.BoxedPressurizedTube_): boolean;
        "parseUpgradeData(mekanism.common.upgrade.transmitter.PressurizedTubeUpgradeData)"(data: Internal.PressurizedTubeUpgradeData_): void;
        setConnectionTypesRaw(connectionTypes: Internal.ConnectionType_[]): void;
        "supportsTransmissionType(mekanism.common.tile.transmitter.TileEntityTransmitter)"(transmitter: Internal.TileEntityTransmitter_): boolean;
        onConfigure(player: Internal.Player_, side: Internal.Direction_): Internal.InteractionResult;
        onModeChange(side: Internal.Direction_): void;
        getPossibleAcceptorConnections(): number;
        onRightClick(player: Internal.Player_, side: Internal.Direction_): Internal.InteractionResult;
        canConnectToAcceptor(side: Internal.Direction_): boolean;
        wait(arg0: number, arg1: number): void;
        getInfusionTanks(side: Internal.Direction_): Internal.List<Internal.IInfusionTank>;
        setTransmitterNetwork(network: Internal.BoxedChemicalNetwork_, requestNow: boolean): boolean;
        startUpgrading(): void;
        getSupportedTransmissionTypes(): Internal.Set<Internal.TransmissionType>;
        getAllCurrentConnections(): number;
        write(nbtTags: Internal.CompoundTag_): Internal.CompoundTag;
        dataTypeMatches(data: Internal.TransmitterUpgradeData_): boolean;
        isRemote(): boolean;
        isValidTransmitter(transmitter: Internal.TileEntityTransmitter_, side: Internal.Direction_): boolean;
        getConnectionTypesRaw(): Internal.ConnectionType[];
        isOrphan(): boolean;
        "parseUpgradeData(mekanism.common.upgrade.transmitter.TransmitterUpgradeData)"(data: Internal.TransmitterUpgradeData_): void;
        getTransmitterNetwork(): Internal.BoxedChemicalNetwork;
        getTileChunk(): Internal.Chunk3D;
        onNeighborBlockChange(side: Internal.Direction_): void;
        notifyTileChange(): void;
        setTransmitterNetwork(network: Internal.BoxedChemicalNetwork_): void;
        parseUpgradeData(data: Internal.TransmitterUpgradeData_): void;
        onContentsChanged(): void;
        parseUpgradeData(data: Internal.PressurizedTubeUpgradeData_): void;
        canUpgrade(alloyTier: Internal.AlloyTier_): boolean;
        validateAndTakeShare(): void;
        getReducedUpdateTag(updateTag: Internal.CompoundTag_): Internal.CompoundTag;
        isValidTransmitterBasic(transmitter: Internal.TileEntityTransmitter_, side: Internal.Direction_): boolean;
        releaseShare(): Internal.BoxedChemicalStack;
        toString(): string;
        getSlurryTank(): Internal.ISlurryTank;
        getAcceptorCache(): Internal.BoxedChemicalAcceptorCache;
        getPigmentTank(): Internal.IPigmentTank;
        notifyAll(): void;
        createNetworkByMerging(toMerge: Internal.Collection_<any>): Internal.DynamicNetwork<any, any, any>;
        getTileWorld(): Internal.Level;
        canConnectMutual(side: Internal.Direction_, cachedTile: Internal.BlockEntity_): boolean;
        isRedstoneActivated(): boolean;
        takeChemical(stack: Internal.BoxedChemicalStack_, action: Internal.Action_): void;
        "canConnectMutual(net.minecraft.core.Direction,net.minecraft.world.level.block.entity.BlockEntity)"(side: Internal.Direction_, cachedTile: Internal.BlockEntity_): boolean;
        hashCode(): number;
        read(nbtTags: Internal.CompoundTag_): void;
        static connectionMapContainsSide(connections: number, side: Internal.Direction_): boolean;
        isUpgrading(): boolean;
        getPigmentTanks(side: Internal.Direction_): Internal.List<Internal.IPigmentTank>;
        getConnectionType(side: Internal.Direction_): Internal.ConnectionType;
        getPossibleTransmitterConnections(): number;
        wait(arg0: number): void;
        getInfusionTank(): Internal.IInfusionTank;
        equals(arg0: any): boolean;
        get newOrphanValidator(): Internal.CompatibleTransmitterValidator<Internal.BoxedChemicalHandler, Internal.BoxedChemicalNetwork, Internal.BoxedPressurizedTube>
        get bufferWithFallback(): Internal.BoxedChemicalStack
        get upgradeData(): Internal.TransmitterUpgradeData
        get gasTank(): Internal.IGasTank
        get valid(): boolean
        get tilePos(): BlockPos
        get tileCoord(): Internal.Coord4D
        get tier(): Internal.TubeTier
        get share(): Internal.BoxedChemicalStack
        set orphan(nowOrphaned: boolean)
        get transmitterTile(): Internal.TileEntityTransmitter
        get capacity(): number
        get class(): typeof any
        set connectionTypesRaw(connectionTypes: Internal.ConnectionType_[])
        get possibleAcceptorConnections(): number
        get supportedTransmissionTypes(): Internal.Set<Internal.TransmissionType>
        get allCurrentConnections(): number
        get remote(): boolean
        get connectionTypesRaw(): Internal.ConnectionType[]
        get orphan(): boolean
        get transmitterNetwork(): Internal.BoxedChemicalNetwork
        get tileChunk(): Internal.Chunk3D
        set transmitterNetwork(network: Internal.BoxedChemicalNetwork_)
        get slurryTank(): Internal.ISlurryTank
        get acceptorCache(): Internal.BoxedChemicalAcceptorCache
        get pigmentTank(): Internal.IPigmentTank
        get tileWorld(): Internal.Level
        get redstoneActivated(): boolean
        get upgrading(): boolean
        get possibleTransmitterConnections(): number
        get infusionTank(): Internal.IInfusionTank
        readonly chemicalTank: Internal.MergedChemicalTank;
        readonly tier: Internal.TubeTier;
        saveShare: Internal.BoxedChemicalStack;
    }
    type BoxedPressurizedTube_ = BoxedPressurizedTube;
    interface IModeItem {
        abstract changeMode(player: Internal.Player_, stack: Internal.ItemStack_, shift: number, displayChange: Internal.IModeItem$DisplayChange_): void;
        displayModeChange(player: Internal.Player_): void;
        "isModeItem(net.minecraft.world.item.ItemStack,net.minecraft.world.entity.EquipmentSlot)"(stack: Internal.ItemStack_, slotType: Internal.EquipmentSlot_): boolean;
        supportsSlotType(stack: Internal.ItemStack_, slotType: Internal.EquipmentSlot_): boolean;
        "isModeItem(net.minecraft.world.item.ItemStack,net.minecraft.world.entity.EquipmentSlot,boolean)"(stack: Internal.ItemStack_, slotType: Internal.EquipmentSlot_, allowRadial: boolean): boolean;
        getScrollTextComponent(stack: Internal.ItemStack_): net.minecraft.network.chat.Component;
        isModeItem(stack: Internal.ItemStack_, slotType: Internal.EquipmentSlot_, allowRadial: boolean): boolean;
        isModeItem(player: Internal.Player_, slotType: Internal.EquipmentSlot_): boolean;
        isModeItem(player: Internal.Player_, slotType: Internal.EquipmentSlot_, allowRadial: boolean): boolean;
        isModeItem(stack: Internal.ItemStack_, slotType: Internal.EquipmentSlot_): boolean;
        "isModeItem(net.minecraft.world.entity.player.Player,net.minecraft.world.entity.EquipmentSlot,boolean)"(player: Internal.Player_, slotType: Internal.EquipmentSlot_, allowRadial: boolean): boolean;
        "isModeItem(net.minecraft.world.entity.player.Player,net.minecraft.world.entity.EquipmentSlot)"(player: Internal.Player_, slotType: Internal.EquipmentSlot_): boolean;
        (player: Internal.Player, stack: Internal.ItemStack, shift: number, displayChange: Internal.IModeItem$DisplayChange): void;
    }
    type IModeItem_ = ((player: Internal.Player, stack: Internal.ItemStack, shift: number, displayChange: Internal.IModeItem$DisplayChange)=> void) | IModeItem;
    interface Appendable {
        abstract append(arg0: Internal.CharSequence_): this;
        abstract append(arg0: Internal.CharSequence_, arg1: number, arg2: number): this;
        abstract append(arg0: string): this;
        abstract "append(java.lang.CharSequence)"(arg0: Internal.CharSequence_): this;
        abstract "append(char)"(arg0: string): this;
    }
    type Appendable_ = Appendable;
    class WrappedDeferredRegister <T> {
        getClass(): typeof any;
        toString(): string;
        notifyAll(): void;
        createAndRegister(bus: Internal.IEventBus_, builder: Internal.UnaryOperator_<Internal.RegistryBuilder<T>>): Internal.Supplier<Internal.IForgeRegistry<T>>;
        notify(): void;
        createAndRegister(bus: Internal.IEventBus_): Internal.Supplier<Internal.IForgeRegistry<T>>;
        wait(arg0: number, arg1: number): void;
        hashCode(): number;
        wait(): void;
        wait(arg0: number): void;
        createAndRegisterChemical(bus: Internal.IEventBus_): Internal.Supplier<Internal.IForgeRegistry<T>>;
        equals(arg0: any): boolean;
        register(bus: Internal.IEventBus_): void;
        get class(): typeof any
    }
    type WrappedDeferredRegister_<T> = WrappedDeferredRegister<T>;
    class MekanismContainerType <T, CONTAINER extends Internal.AbstractContainerMenu> extends Internal.BaseMekanismContainerType<T, CONTAINER, Internal.MekanismContainerType$IMekanismContainerFactory<T, CONTAINER>> {
        getClass(): typeof any;
        static "create(net.minecraftforge.network.IContainerFactory)"<T extends Internal.AbstractContainerMenu>(arg0: Internal.IContainerFactory_<T>): Internal.MenuType<T>;
        static register<T extends Internal.AbstractContainerMenu>(arg0: string, arg1: Internal.MenuType$MenuSupplier_<T>): Internal.MenuType<T>;
        create(arg0: number, arg1: Internal.Inventory_): CONTAINER;
        static "tile(java.lang.Class,mekanism.common.inventory.container.type.MekanismContainerType$IMekanismSidedContainerFactory)"<TILE extends Internal.TileEntityMekanism, CONTAINER extends Internal.AbstractContainerMenu>(type: TILE, constructor_: Internal.MekanismContainerType$IMekanismSidedContainerFactory_<TILE, CONTAINER>): Internal.MekanismContainerType<TILE, CONTAINER>;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        static "entity(java.lang.Class,mekanism.common.inventory.container.type.MekanismContainerType$IMekanismContainerFactory)"<ENTITY extends Internal.Entity, CONTAINER extends Internal.AbstractContainerMenu & Internal.IEntityContainer<ENTITY>>(type: ENTITY, constructor_: Internal.MekanismContainerType$IMekanismContainerFactory_<ENTITY, CONTAINER>): Internal.MekanismContainerType<ENTITY, CONTAINER>;
        create(id: number, inv: Internal.Inventory_, data: any): CONTAINER;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        static "tile(java.lang.Class,mekanism.common.inventory.container.type.MekanismContainerType$IMekanismContainerFactory)"<TILE extends Internal.TileEntityMekanism, CONTAINER extends Internal.AbstractContainerMenu>(type: TILE, constructor_: Internal.MekanismContainerType$IMekanismContainerFactory_<TILE, CONTAINER>): Internal.MekanismContainerType<TILE, CONTAINER>;
        static create<T extends Internal.AbstractContainerMenu>(arg0: Internal.IContainerFactory_<T>): Internal.MenuType<T>;
        create(arg0: number, arg1: Internal.Inventory_, arg2: Internal.FriendlyByteBuf_): any;
        static "entity(java.lang.Class,mekanism.common.inventory.container.type.MekanismContainerType$IMekanismSidedContainerFactory)"<ENTITY extends Internal.Entity, CONTAINER extends Internal.AbstractContainerMenu & Internal.IEntityContainer<ENTITY>>(type: ENTITY, constructor_: Internal.MekanismContainerType$IMekanismSidedContainerFactory_<ENTITY, CONTAINER>): Internal.MekanismContainerType<ENTITY, CONTAINER>;
        static tile<TILE extends Internal.TileEntityMekanism, CONTAINER extends Internal.AbstractContainerMenu>(type: TILE, constructor_: Internal.MekanismContainerType$IMekanismContainerFactory_<TILE, CONTAINER>): Internal.MekanismContainerType<TILE, CONTAINER>;
        "create(int,net.minecraft.world.entity.player.Inventory,java.lang.Object)"(id: number, inv: Internal.Inventory_, data: any): CONTAINER;
        static entity<ENTITY extends Internal.Entity, CONTAINER extends Internal.AbstractContainerMenu & Internal.IEntityContainer<ENTITY>>(type: ENTITY, constructor_: Internal.MekanismContainerType$IMekanismSidedContainerFactory_<ENTITY, CONTAINER>): Internal.MekanismContainerType<ENTITY, CONTAINER>;
        static register<T extends Internal.AbstractContainerMenu>(arg0: string, arg1: Internal.MenuType$MenuSupplier_<T>, ...arg2: Internal.FeatureFlag_[]): Internal.MenuType<T>;
        toString(): string;
        notifyAll(): void;
        static entity<ENTITY extends Internal.Entity, CONTAINER extends Internal.AbstractContainerMenu & Internal.IEntityContainer<ENTITY>>(type: ENTITY, constructor_: Internal.MekanismContainerType$IMekanismContainerFactory_<ENTITY, CONTAINER>): Internal.MekanismContainerType<ENTITY, CONTAINER>;
        static tile<TILE extends Internal.TileEntityMekanism, CONTAINER extends Internal.AbstractContainerMenu>(type: TILE, constructor_: Internal.MekanismContainerType$IMekanismSidedContainerFactory_<TILE, CONTAINER>): Internal.MekanismContainerType<TILE, CONTAINER>;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        "create(java.lang.Object)"(data: any): Internal.MenuConstructor;
        wait(): void;
        wait(arg0: number): void;
        create(data: any): Internal.MenuConstructor;
        equals(arg0: any): boolean;
        "create(int,net.minecraft.world.entity.player.Inventory,net.minecraft.network.FriendlyByteBuf)"(arg0: number, arg1: Internal.Inventory_, arg2: Internal.FriendlyByteBuf_): any;
        get class(): typeof any
    }
    type MekanismContainerType_<T, CONTAINER extends Internal.AbstractContainerMenu> = MekanismContainerType<T, CONTAINER>;
    interface AccessEditBox {
        abstract searchables$getFilter(): Internal.Predicate<string>;
        abstract searchables$getResponder(): Internal.Consumer<string>;
    }
    type AccessEditBox_ = AccessEditBox;
    class PlayerEvent$ItemCraftedEvent extends Internal.PlayerEvent {
        constructor()
        constructor(arg0: Internal.Player_, arg1: Internal.ItemStack_, arg2: net.minecraft.world.Container_)
        getResult(): Internal.Event$Result;
        setCanceled(arg0: boolean): void;
        getClass(): typeof any;
        toString(): string;
        setPhase(arg0: Internal.EventPriority_): void;
        notifyAll(): void;
        isCanceled(): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        getInventory(): net.minecraft.world.Container;
        hasResult(): boolean;
        setResult(arg0: Internal.Event$Result_): void;
        getCrafting(): Internal.ItemStack;
        hashCode(): number;
        isCancelable(): boolean;
        getEntity(): Internal.Entity;
        wait(): void;
        getListenerList(): Internal.ListenerList;
        wait(arg0: number): void;
        getPhase(): Internal.EventPriority;
        equals(arg0: any): boolean;
        get result(): Internal.Event$Result
        set canceled(arg0: boolean)
        get class(): typeof any
        set phase(arg0: Internal.EventPriority_)
        get canceled(): boolean
        get inventory(): net.minecraft.world.Container
        set result(arg0: Internal.Event$Result_)
        get crafting(): Internal.ItemStack
        get cancelable(): boolean
        get entity(): Internal.Entity
        get listenerList(): Internal.ListenerList
        get phase(): Internal.EventPriority
    }
    type PlayerEvent$ItemCraftedEvent_ = PlayerEvent$ItemCraftedEvent;
    class StreamTagVisitor$EntryResult extends Internal.Enum<Internal.StreamTagVisitor$EntryResult> {
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        getClass(): typeof any;
        toString(): string;
        compareTo(arg0: Internal.StreamTagVisitor$EntryResult_): number;
        notifyAll(): void;
        "compareTo(net.minecraft.nbt.StreamTagVisitor$EntryResult)"(arg0: Internal.StreamTagVisitor$EntryResult_): number;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        compareTo(arg0: any): number;
        describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<Internal.StreamTagVisitor$EntryResult>>;
        name(): string;
        hashCode(): number;
        static valueOf(arg0: string): Internal.StreamTagVisitor$EntryResult;
        getDeclaringClass(): typeof Internal.StreamTagVisitor$EntryResult;
        ordinal(): number;
        wait(): void;
        wait(arg0: number): void;
        "compareTo(java.lang.Object)"(arg0: any): number;
        static values(): Internal.StreamTagVisitor$EntryResult[];
        equals(arg0: any): boolean;
        get class(): typeof any
        get declaringClass(): typeof Internal.StreamTagVisitor$EntryResult
        static readonly BREAK: (Internal.StreamTagVisitor$EntryResult) & (Internal.StreamTagVisitor$EntryResult);
        static readonly SKIP: (Internal.StreamTagVisitor$EntryResult) & (Internal.StreamTagVisitor$EntryResult);
        static readonly ENTER: (Internal.StreamTagVisitor$EntryResult) & (Internal.StreamTagVisitor$EntryResult);
        static readonly HALT: (Internal.StreamTagVisitor$EntryResult) & (Internal.StreamTagVisitor$EntryResult);
    }
    type StreamTagVisitor$EntryResult_ = StreamTagVisitor$EntryResult | "break" | "halt" | "skip" | "enter";
    class DispenserBlock extends Internal.BaseEntityBlock implements com.simibubi.create.foundation.mixin.accessor.DispenserBlockAccessor, Internal.DispenserBlockAccessor {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        getBlacklistedEnchantments(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Set<Internal.Enchantment>;
        getTypeData(): Internal.CompoundTag;
        setFriction(arg0: number): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        newBlockEntity(arg0: BlockPos_, arg1: Internal.BlockState_): Internal.BlockEntity;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        needsDynamicNodeTypeCheck(): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        spawnTableParticle(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: BlockPos_): void;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        /**
         * @deprecated
        */
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static createTickerHelper<E extends Internal.BlockEntity, A extends Internal.BlockEntity>(arg0: Internal.BlockEntityType_<A>, arg1: Internal.BlockEntityType_<E>, arg2: Internal.BlockEntityTicker_<E>): Internal.BlockEntityTicker<A>;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        getTicker<T extends Internal.BlockEntity>(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        static byItem(arg0: Internal.Item_): Internal.Block;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        allowsTreasure(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static getDispenserRegistry_$md$760ce0$0(): Internal.Map<any, any>;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        wait(): void;
        getMaxHorizontalOffset(): number;
        static getDispensePosition(arg0: Internal.BlockSource_): Internal.Position;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(shape: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        handler$dmk000$friendsandfoes_onUse(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, hand: Internal.InteractionHand_, hit: Internal.BlockHitResult_, cir: Internal.CallbackInfoReturnable_<any>): void;
        getMaxEnchantingPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        static getDispenserRegistry(): Internal.Map<Internal.Item, Internal.DispenseItemBehavior>;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        /**
         * @deprecated
        */
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        /**
         * @deprecated
        */
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        getTableParticle(arg0: Internal.BlockState_): Internal.ParticleOptions;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        needsDynamicBurningCheck(): boolean;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        getArcanaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        handler$dmk000$friendsandfoes_randomTick(state: Internal.BlockState_, world: Internal.ServerLevel_, pos: BlockPos_, random: Internal.RandomSource_, ci: Internal.CallbackInfo_): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        getQuantaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        handler$bdh000$postConstruct(p_i241196_1_: Internal.BlockBehaviour$Properties_, ci: Internal.CallbackInfo_): void;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        getQuantaRectification(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        getFriction(): number;
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        static registerBehavior(arg0: Internal.ItemLike_, arg1: Internal.DispenseItemBehavior_): void;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        create$callGetDispenseMethod(arg0: Internal.ItemStack_): Internal.DispenseItemBehavior;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getListener<T extends Internal.BlockEntity>(arg0: Internal.ServerLevel_, arg1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        handler$dml000$friendsandfoes_hasRandomTicks(state: Internal.BlockState_, cir: Internal.CallbackInfoReturnable_<any>): void;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        getBonusClues(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        /**
         * @deprecated
        */
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        get typeData(): Internal.CompoundTag
        set friction(arg0: number)
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get dispenserRegistry_$md$760ce0$0(): Internal.Map<any, any>
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        get dispenserRegistry(): Internal.Map<Internal.Item, Internal.DispenseItemBehavior>
        set soundType(arg0: SoundType_)
        get descriptionId(): string
        get jumpFactor(): number
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
        static readonly DISPENSER_REGISTRY: ({[key: Internal.DankItemForge]: any, [key: Internal.DispenserAddedSpawnEgg]: any, [key: Internal.BlockItem]: any, [key: Internal.ArmorItem]: any, [key: Internal.IEFluids$FluidEntry$2]: any, [key: Internal.CopperExoskeletonItem$Chestplate]: any, [key: Internal.ItemMekanismArmor]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.ArmorItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.ItemMekanismShield]: any, [key: Internal.BucketItem]: any, [key: Internal.ExperienceBottleItem]: any, [key: Internal.MobBucketItem]: any, [key: Internal.DispenserAddedSpawnEgg]: any, [key: Internal.ArmorItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.BucketItem]: any, [key: Internal.Item]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.MobBucketItem]: any, [key: Internal.BlockItem]: any, [key: Internal.ItemMekanismShield]: any, [key: Internal.LingeringPotionItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.BroadheadArrowItem]: any, [key: Internal.BackpackItem]: any, [key: Internal.BottleItem]: any, [key: Internal.CopperItem$Chestplate]: any, [key: Internal.AEBaseBlockItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.ItemMekanismArmor]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.BlockItem]: any, [key: Internal.BucketItem]: any, [key: Internal.ItemRefinedGlowstoneArmor]: any, [key: Internal.HorseArmorItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.FaradaySuitItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.DankItemForge]: any, [key: Internal.BoneMealItem]: any, [key: Internal.BlockItem]: any, [key: Internal.BlockItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.ItemMekanismArmor]: any, [key: Internal.DivingHelmetItem]: any, [key: Internal.BoatItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.ArmorItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.BlockItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.BlockItem]: any, [key: Internal.MinecartItem]: any, [key: Internal.SlimeItem$Boots]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.ZincItem$Boots]: any, [key: Internal.BowlFoodItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.QuantumBoots]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.ArmorItem]: any, [key: Internal.MatterCannonItem]: any, [key: Internal.GliderItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.ArmorItem]: any, [key: Internal.CopperJetpackItem$Chestplate]: any, [key: Internal.ItemMekanismArmor]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.FireworkRocketItem]: any, [key: Internal.ItemFreeRunners]: any, [key: Internal.IEFluids$FluidEntry$2]: any, [key: Internal.IEFluids$FluidEntry$2]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.BlockItem]: any, [key: Internal.BoatItem]: any, [key: Internal.SaddleItem]: any, [key: Internal.DankItemForge]: any, [key: Internal.StandingAndWallBlockItem]: any, [key: Internal.HoodItem]: any, [key: Internal.SuspiciousStewItem]: any, [key: Internal.ColorApplicatorItem]: any, [key: Internal.HoodItem]: any, [key: Internal.ItemMekanismArmor]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.MinecartItem]: any, [key: Internal.BlockItem]: any, [key: Internal.ItemHazmatSuitArmor]: any, [key: Internal.CaughtMobWithVariantsItem]: any, [key: Internal.ItemMekanismArmor]: any, [key: Internal.BucketItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.BucketItem]: any, [key: Internal.ItemMekanismArmor]: any, [key: Internal.DyeableArmorItem]: any, [key: Internal.BucketItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.BlockItem]: any, [key: com.faboslav.variantsandventures.common.items.DispenserAddedSpawnEgg]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.ItemMekanismArmor]: any, [key: Internal.BucketItem]: any, [key: Internal.Item]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.SnowballItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.HoneyBottleItem]: any, [key: Internal.ItemRefinedGlowstoneArmor]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.FaradaySuitItem]: any, [key: Internal.MobBucketItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.BoatItem]: any, [key: Internal.MinecartContraptionItem]: any, [key: Internal.ItemMekaSuitArmor]: any, [key: Internal.PotionItem]: any, [key: Internal.BucketItem]: any, [key: Internal.EntropyManipulatorItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.BlockItem]: any, [key: Internal.BlockItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.ItemMekanismArmor]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.BucketItem]: any, [key: Internal.ItemScubaTank]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.BoatItem]: any, [key: Internal.NeptuniumArmor]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.ArmorItem]: any, [key: Internal.ArmorItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.BoatItem]: any, [key: Internal.PotionBucketItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.MilkBucketItem]: any, [key: Internal.IEMinecartItem]: any, [key: Internal.ItemMekanismArmor]: any, [key: Internal.ItemNutritionalPasteBucket]: any, [key: Internal.IEFluids$FluidEntry$2]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.BucketItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.ItemHazmatSuitArmor]: any, [key: Internal.BlockItem]: any, [key: Internal.DankItemForge]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.StandingAndWallBlockItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.BlockItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.BowlFoodItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.IEFluids$FluidEntry$2]: any, [key: Internal.ArmorItem]: any, [key: Internal.BlockItem]: any, [key: Internal.BowlFoodItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.DivingBootsItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.MinecartItem]: any, [key: Internal.DispenserAddedSpawnEgg]: any, [key: Internal.ArmorItem]: any, [key: Internal.Item]: any, [key: Internal.BlockItem]: any, [key: Internal.BoatItem]: any, [key: Internal.SlimeItem$Helmet]: any, [key: Internal.MobBucketItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.ModularChestpiece]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.BlockItem]: any, [key: Internal.BlockItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.CopperItem$Helmet]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.BlockItem]: any, [key: Internal.IEFluids$FluidEntry$2]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.ItemMekanismShield]: any, [key: Internal.ArmorItem]: any, [key: Internal.NeptuniumArmor]: any, [key: Internal.BucketItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.BoatItem]: any, [key: com.faboslav.variantsandventures.common.items.DispenserAddedSpawnEgg]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.BlockItem]: any, [key: Internal.IEFluids$FluidEntry$2]: any, [key: Internal.DivingHelmetItem]: any, [key: Internal.MiningArrowItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.DankItemForge]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.CopperItem$Boots]: any, [key: Internal.DispenserAddedSpawnEgg]: any, [key: Internal.QuantumChestplate]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.ArmorItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.DispenserAddedSpawnEgg]: any, [key: Internal.HorseArmorItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.JetpackItem$Layered]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.BlockItem]: any, [key: Internal.ItemMekanismShield]: any, [key: Internal.BucketItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.BlockItem]: any, [key: Internal.ModularChestpiece]: any, [key: Internal.ItemMekanismArmor]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.Item]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.SteelArmorItem]: any, [key: Internal.ArmorItem]: any, [key: Internal.ItemMekanismArmor]: any, [key: Internal.BoatItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.BucketItem]: any, [key: Internal.ItemMekanismArmor]: any, [key: Internal.MobBucketItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.MinecartContraptionItem]: any, [key: Internal.CorruptedShieldItem]: any, [key: Internal.BucketItem]: any, [key: Internal.BucketItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.BoatItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.DankItemForge]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.BlockItem]: any, [key: Internal.IEMinecartItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.BlockItem]: any, [key: Internal.BackpackItem]: any, [key: Internal.DyeableArmorItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.BoatItem]: any, [key: Internal.NeptuniumArmor]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.ItemScubaMask]: any, [key: Internal.BoatItem]: any, [key: Internal.ArmorItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.DispenserAddedSpawnEgg]: any, [key: Internal.PlayerHeadItem]: any, [key: Internal.BlockItem]: any, [key: Internal.DyeableArmorItem]: any, [key: Internal.SteelArmorItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.ItemRefinedGlowstoneArmor]: any, [key: Internal.ElytraItem]: any, [key: Internal.Item]: any, [key: Internal.BlockItem]: any, [key: Internal.BlockItem]: any, [key: Internal.BrassItem$Helmet]: any, [key: Internal.NoFluidMobBucketWithVariantsItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.BlockItem]: any, [key: Internal.BrassExoskeletonItem$Chestplate]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.BrassItem$Chestplate]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.ItemMekanismArmor]: any, [key: Internal.ItemMekaTool]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.ShieldItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.ItemMekanismArmor]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.MinecartItem]: any, [key: Internal.DispenserAddedSpawnEgg]: any, [key: Internal.ArmorItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.BucketItem]: any, [key: Internal.ZincItem$Chestplate]: any, [key: Internal.BackpackItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.MiningArrowItem]: any, [key: Internal.ItemMekaSuitArmor]: any, [key: Internal.HorseArmorItem]: any, [key: Internal.StandingAndWallBlockItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.HoneycombItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.AndesiteExoskeletonItem$Chestplate]: any, [key: Internal.ItemMekanismArmor]: any, [key: Internal.ArmorItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.ItemMekanismArmor]: any, [key: Internal.ItemHDPEElytra]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.ItemArmoredJetpack]: any, [key: Internal.JetpackItem]: any, [key: Internal.DispenserAddedSpawnEgg]: any, [key: Internal.BacktankItem$Layered]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.CopperItem$Leggings]: any, [key: Internal.BackpackItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.ItemJetpack]: any, [key: Internal.SplashPotionItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.DispenserAddedSpawnEgg]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.StandingAndWallBlockItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.QuantumHelmet]: any, [key: Internal.BoatItem]: any, [key: Internal.DuckEggItem]: any, [key: Internal.BoatItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.DankItemForge]: any, [key: Internal.BoatItem]: any, [key: Internal.ItemHazmatSuitArmor]: any, [key: com.faboslav.variantsandventures.common.items.DispenserAddedSpawnEgg]: any, [key: com.faboslav.variantsandventures.common.items.DispenserAddedSpawnEgg]: any, [key: Internal.ArmorStandItem]: any, [key: Internal.NeptuniumArmor]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.SteelArmorItem]: any, [key: Internal.DyeableArmorItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.BlockItem]: any, [key: Internal.GogglesItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.StandingAndWallBlockItem]: any, [key: Internal.BucketItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.BrassItem$Boots]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.DispenserAddedSpawnEgg]: any, [key: Internal.MinecartContraptionItem]: any, [key: Internal.TippedArrowItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.ItemMekanismArmor]: any, [key: Internal.BacktankItem]: any, [key: Internal.BucketItem]: any, [key: Internal.BackpackItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.ArrowItem]: any, [key: Internal.ArmorItem]: any, [key: Internal.ItemMekanismShield]: any, [key: Internal.ArmorItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.BoatItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.ArmorItem]: any, [key: Internal.QuantumLeggings]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.SolidBucketItem]: any, [key: Internal.DivingBootsItem]: any, [key: Internal.BrassJetpackItem$Chestplate]: any, [key: Internal.StandingAndWallBlockItem]: any, [key: Internal.FaradaySuitItem]: any, [key: Internal.MobBucketItem]: any, [key: Internal.BucketItem]: any, [key: Internal.ItemMekanismArmor]: any, [key: Internal.MobBucketItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.BlockItem]: any, [key: Internal.MobBucketItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.ItemHazmatSuitArmor]: any, [key: Internal.BucketItem]: any, [key: Internal.SpectralArrowItem]: any, [key: Internal.IEFluids$FluidEntry$2]: any, [key: Internal.BucketItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.ItemRefinedGlowstoneArmor]: any, [key: Internal.BoatItem]: any, [key: Internal.BrassItem$Leggings]: any, [key: Internal.HoodItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.ExplosiveArrowItem]: any, [key: Internal.MinecartItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.AndesiteJetpackItem$Chestplate]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.BlockItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.BlockItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.ArmorItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.BucketItem]: any, [key: Internal.SteelArmorItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.FlintAndSteelItem]: any, [key: Internal.IEFluids$FluidEntry$2]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.BucketItem]: any, [key: Internal.ItemMekaSuitArmor]: any, [key: Internal.ArmorItem]: any, [key: Internal.BucketItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.BucketItem]: any, [key: Internal.ShearsItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.BucketItem]: any, [key: Internal.ItemMekanismShield]: any, [key: Internal.ArmorItem]: any, [key: Internal.BlockItem]: any, [key: Internal.ZincItem$Helmet]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.FireChargeItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.MobBucketItem]: any, [key: Internal.ObsidianArrowItem]: any, [key: Internal.ItemMekaSuitArmor]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.MinecartItem]: any, [key: Internal.BlockItem]: any, [key: Internal.BlockItem]: any, [key: Internal.IEMinecartItem]: any, [key: Internal.ModularChestpiece]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.BucketItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.BoatItem]: any, [key: Internal.ShulkerBoxItem]: any, [key: Internal.IEMinecartItem]: any, [key: Internal.BucketItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.ZincItem$Leggings]: any, [key: Internal.ItemMekanismArmor]: any, [key: Internal.IEShieldItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.BlockItem]: any, [key: Internal.EggItem]: any, [key: Internal.FaradaySuitItem]: any, [key: Internal.BlockItem]: any, [key: Internal.DyeableHorseArmorItem]: any, [key: Internal.BackpackItem]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.ForgeSpawnEggItem]: any, [key: Internal.BoatItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.ItemArmoredFreeRunners]: any, [key: Internal.SpawnEggItem]: any, [key: Internal.BWGBoatItem]: any, [key: Internal.BlockItem]: any}) & (Internal.Map<Internal.Item, Internal.DispenseItemBehavior>);
        static readonly TRIGGERED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
        static readonly FACING: (Internal.DirectionProperty) & (Internal.DirectionProperty);
    }
    type DispenserBlock_ = DispenserBlock;
    class FogShape extends Internal.Enum<Internal.FogShape> {
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        getClass(): typeof any;
        toString(): string;
        notifyAll(): void;
        getIndex(): number;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        compareTo(arg0: any): number;
        static valueOf(arg0: string): Internal.FogShape;
        name(): string;
        hashCode(): number;
        describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<Internal.FogShape>>;
        "compareTo(com.mojang.blaze3d.shaders.FogShape)"(arg0: Internal.FogShape_): number;
        ordinal(): number;
        wait(): void;
        wait(arg0: number): void;
        static values(): Internal.FogShape[];
        "compareTo(java.lang.Object)"(arg0: any): number;
        equals(arg0: any): boolean;
        compareTo(arg0: Internal.FogShape_): number;
        getDeclaringClass(): typeof Internal.FogShape;
        get class(): typeof any
        get index(): number
        get declaringClass(): typeof Internal.FogShape
        static readonly CYLINDER: (Internal.FogShape) & (Internal.FogShape);
        static readonly SPHERE: (Internal.FogShape) & (Internal.FogShape);
    }
    type FogShape_ = FogShape | "cylinder" | "sphere";
    class TileComponentFrequency implements Internal.ITileComponent {
        constructor(tile: Internal.TileEntityMekanism_)
        getClass(): typeof any;
        readConfiguredFrequencies(player: Internal.Player_, data: Internal.CompoundTag_): void;
        write(nbtTags: Internal.CompoundTag_): void;
        trackForMainContainer(container: Internal.MekanismContainer_): void;
        notify(): void;
        getPublicCache<FREQ extends Internal.Frequency>(type: Internal.FrequencyType_<FREQ>): Internal.List<FREQ>;
        wait(arg0: number, arg1: number): void;
        hasCustomFrequencies(): boolean;
        unsetFrequency<FREQ extends Internal.Frequency>(type: Internal.FrequencyType_<FREQ>): void;
        getFrequency<FREQ extends Internal.Frequency>(type: Internal.FrequencyType_<FREQ>): FREQ;
        setFrequencyFromData<FREQ extends Internal.Frequency>(type: Internal.FrequencyType_<FREQ>, data: Internal.Frequency$FrequencyIdentity_, player: Internal.UUID_): void;
        writeConfiguredFrequencies(data: Internal.CompoundTag_): void;
        getPrivateCache<FREQ extends Internal.Frequency>(type: Internal.FrequencyType_<FREQ>): Internal.List<FREQ>;
        removeFrequencyFromData(type: Internal.FrequencyType_<any>, data: Internal.Frequency$FrequencyIdentity_, player: Internal.UUID_): void;
        readFromUpdateTag(updateTag: Internal.CompoundTag_): void;
        track(type: Internal.FrequencyType_<any>, needsSync: boolean, needsListCache: boolean, notifyNeighbors: boolean): void;
        tickServer(): void;
        toString(): string;
        addToUpdateTag(updateTag: Internal.CompoundTag_): void;
        notifyAll(): void;
        invalidate(): void;
        hashCode(): number;
        read(nbtTags: Internal.CompoundTag_): void;
        removed(): void;
        wait(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        get class(): typeof any
    }
    type TileComponentFrequency_ = TileComponentFrequency;
    interface NoiseChunkAccessor {
        abstract callCachedClimateSampler(arg0: Internal.NoiseRouter_, arg1: Internal.List_<Internal.Climate$ParameterPoint>): Internal.Climate$Sampler;
        (arg0: Internal.NoiseRouter, arg1: Internal.List<Internal.Climate$ParameterPoint>): Internal.Climate$Sampler_;
    }
    type NoiseChunkAccessor_ = NoiseChunkAccessor | ((arg0: Internal.NoiseRouter, arg1: Internal.List<Internal.Climate$ParameterPoint>)=> Internal.Climate$Sampler_);
    interface IReaperItem {
        abstract getReaperLevel(arg0: Internal.ItemStack_): number;
        (arg0: Internal.ItemStack): number;
    }
    type IReaperItem_ = IReaperItem | ((arg0: Internal.ItemStack)=> number);
    class GeodeLayerSettings {
        constructor(arg0: number, arg1: number, arg2: number, arg3: number)
        getClass(): typeof any;
        hashCode(): number;
        toString(): string;
        wait(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        get class(): typeof any
        readonly innerLayer: number;
        readonly middleLayer: number;
        static readonly CODEC: Internal.Codec<Internal.GeodeLayerSettings>;
        readonly outerLayer: number;
        readonly filling: number;
    }
    type GeodeLayerSettings_ = GeodeLayerSettings;
    interface CompositeContext {
        abstract compose(arg0: Internal.Raster_, arg1: Internal.Raster_, arg2: Internal.WritableRaster_): void;
        abstract dispose(): void;
    }
    type CompositeContext_ = CompositeContext;
    class MetricSampler$MetricSamplerBuilder <T> {
        constructor(arg0: string, arg1: Internal.MetricCategory_, arg2: Internal.ToDoubleFunction_<T>, arg3: T)
        getClass(): typeof any;
        withBeforeTick(arg0: Internal.Consumer_<T>): this;
        hashCode(): number;
        toString(): string;
        withThresholdAlert(arg0: Internal.MetricSampler$ThresholdTest_): this;
        wait(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        build(): Internal.MetricSampler;
        equals(arg0: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        get class(): typeof any
    }
    type MetricSampler$MetricSamplerBuilder_<T> = MetricSampler$MetricSamplerBuilder<T>;
    interface RegistrySupplier <T> extends Internal.DeferredSupplier<T> {
        abstract getRegistrarManager(): Internal.RegistrarManager;
        getKey(): Internal.ResourceKey<T>;
        stream(): Internal.Stream<T>;
        ifPresent(action: Internal.Consumer_<T>): void;
        orElseGet(supplier: Internal.Supplier_<T>): T;
        ifPresentOrElse(action: Internal.Consumer_<T>, emptyAction: Internal.Runnable_): void;
        getRegistryKey(): Internal.ResourceKey<Internal.Registry<T>>;
        abstract getRegistrar(): Internal.Registrar<T>;
        getOrNull(): T;
        orElse(other: T): T;
        abstract getId(): ResourceLocation;
        abstract isPresent(): boolean;
        abstract getRegistryId(): ResourceLocation;
        abstract get(): T;
        listen(callback: Internal.Consumer_<T>): void;
        toOptional(): Internal.Optional<T>;
        get registrarManager(): Internal.RegistrarManager
        get key(): Internal.ResourceKey<T>
        get registryKey(): Internal.ResourceKey<Internal.Registry<T>>
        get registrar(): Internal.Registrar<T>
        get orNull(): T
        get id(): ResourceLocation
        get present(): boolean
        get registryId(): ResourceLocation
    }
    type RegistrySupplier_<T> = RegistrySupplier<T>;
    interface ResultConsumer <S> {
        abstract onCommandComplete(arg0: Internal.CommandContext_<S>, arg1: boolean, arg2: number): void;
        (arg0: Internal.CommandContext<S>, arg1: boolean, arg2: number): void;
    }
    type ResultConsumer_<S> = ((arg0: Internal.CommandContext<S>, arg1: boolean, arg2: number)=> void) | ResultConsumer<S>;
    class JAOPCAItem extends Internal.Item implements Internal.IMaterialFormItem {
        constructor(form: Internal.IForm_, material: Internal.IMaterial_, settings: any_)
        getDrinkingSound(): Internal.SoundEvent;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getBurnTime(itemStack: Internal.ItemStack_, recipeType: Internal.RecipeType_<any>): number;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        moonlight$addAdditionalBehavior(placementOverride: Internal.AdditionalItemPlacement_): void;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isComplex(): boolean;
        forciblyAllowsTableEnchantment(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        moonlight$getClientAnimationExtension(): any;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getTypeData(): Internal.CompoundTag;
        getDefaultInstance(): Internal.ItemStack;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setBurnTime(i: number): void;
        setMaxStackSize(arg0: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getItem(): Internal.Item;
        getBarColor(arg0: Internal.ItemStack_): number;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        getForm(): Internal.IForm;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        getMaterial(): Internal.IMaterial;
        asIngredient(): Internal.Ingredient;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        toItem(): Internal.Item;
        static byId(arg0: number): Internal.Item;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        moonlight$getAdditionalBehavior(): Internal.AdditionalItemPlacement;
        moonlight$setClientAnimationExtension(obj: any): void;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(stack: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        selectEnchantments(arg0: Internal.List_<Internal.EnchantmentInstance>, arg1: Internal.RandomSource_, arg2: Internal.ItemStack_, arg3: number, arg4: number, arg5: number, arg6: boolean): Internal.List<Internal.EnchantmentInstance>;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: Internal.EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        toString(): string;
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        handler$eba000$initializeClient(consumer: Internal.Consumer_<any>, ci: Internal.CallbackInfo_): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        isFoil(stack: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        addToCreativeModeTab(parameters: Internal.CreativeModeTab$ItemDisplayParameters_, output: Internal.CreativeModeTab$Output_): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: Internal.EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        onEnchantment(arg0: Internal.ItemStack_, arg1: Internal.List_<Internal.EnchantmentInstance>): Internal.ItemStack;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): Internal.EquipmentSlot;
        getName(stack: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        getTypeItemStackKey(): Internal.ItemStackKey;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        getMaxStackSize(stack: Internal.ItemStack_): number;
        shouldOverrideMultiplayerNbt(): boolean;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isTreasureAllowed(arg0: Internal.ItemStack_, arg1: boolean): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get typeData(): Internal.CompoundTag
        get defaultInstance(): Internal.ItemStack
        set burnTime(i: number)
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get form(): Internal.IForm
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get material(): Internal.IMaterial
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        set itemBuilder(b: Internal.ItemBuilder_)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
    }
    type JAOPCAItem_ = JAOPCAItem;
    class ImageCapabilities implements Internal.Cloneable {
        constructor(arg0: boolean)
        clone(): any;
        isAccelerated(): boolean;
        getClass(): typeof any;
        hashCode(): number;
        isTrueVolatile(): boolean;
        toString(): string;
        wait(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        get accelerated(): boolean
        get class(): typeof any
        get trueVolatile(): boolean
    }
    type ImageCapabilities_ = ImageCapabilities;
    class TripWireBlock extends Internal.Block {
        constructor(arg0: Internal.TripWireHookBlock_, arg1: Internal.BlockBehaviour$Properties_)
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        getBlacklistedEnchantments(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Set<Internal.Enchantment>;
        getTypeData(): Internal.CompoundTag;
        setFriction(arg0: number): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        needsDynamicNodeTypeCheck(): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        spawnTableParticle(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: BlockPos_): void;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        /**
         * @deprecated
        */
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        static byItem(arg0: Internal.Item_): Internal.Block;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        allowsTreasure(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(shape: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        handler$dmk000$friendsandfoes_onUse(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, hand: Internal.InteractionHand_, hit: Internal.BlockHitResult_, cir: Internal.CallbackInfoReturnable_<any>): void;
        getMaxEnchantingPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        /**
         * @deprecated
        */
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        /**
         * @deprecated
        */
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        getTableParticle(arg0: Internal.BlockState_): Internal.ParticleOptions;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        shouldConnectTo(arg0: Internal.BlockState_, arg1: Internal.Direction_): boolean;
        getDescriptionId(): string;
        needsDynamicBurningCheck(): boolean;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        getArcanaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        handler$dmk000$friendsandfoes_randomTick(state: Internal.BlockState_, world: Internal.ServerLevel_, pos: BlockPos_, random: Internal.RandomSource_, ci: Internal.CallbackInfo_): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        getQuantaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        handler$bdh000$postConstruct(p_i241196_1_: Internal.BlockBehaviour$Properties_, ci: Internal.CallbackInfo_): void;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        getQuantaRectification(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        handler$dml000$friendsandfoes_hasRandomTicks(state: Internal.BlockState_, cir: Internal.CallbackInfoReturnable_<any>): void;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        getBonusClues(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        get typeData(): Internal.CompoundTag
        set friction(arg0: number)
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get descriptionId(): string
        get jumpFactor(): number
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
        static readonly ATTACHED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
        static readonly NORTH: (Internal.BooleanProperty) & (Internal.BooleanProperty);
        static readonly SOUTH: (Internal.BooleanProperty) & (Internal.BooleanProperty);
        static readonly WEST: (Internal.BooleanProperty) & (Internal.BooleanProperty);
        static readonly POWERED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
        static readonly DISARMED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
        static readonly EAST: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    }
    type TripWireBlock_ = TripWireBlock;
    class DecoratedPotRecipe extends Internal.CustomRecipe {
        constructor(arg0: ResourceLocation_, arg1: Internal.CraftingBookCategory_)
        getClass(): typeof any;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        matches(arg0: Internal.CraftingContainer_, arg1: Internal.Level_): boolean;
        getSchema(): Internal.RecipeSchema;
        "assemble(net.minecraft.world.Container,net.minecraft.core.RegistryAccess)"(arg0: net.minecraft.world.Container_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        "matches(net.minecraft.world.inventory.CraftingContainer,net.minecraft.world.level.Level)"(arg0: Internal.CraftingContainer_, arg1: Internal.Level_): boolean;
        notify(): void;
        getRemainingItems(arg0: Internal.CraftingContainer_): Internal.NonNullList<Internal.ItemStack>;
        wait(arg0: number, arg1: number): void;
        assemble(arg0: Internal.CraftingContainer_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        category(): Internal.CraftingBookCategory;
        assemble(arg0: net.minecraft.world.Container_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        getSerializer(): Internal.RecipeSerializer<any>;
        getId(): ResourceLocation;
        matches(arg0: net.minecraft.world.Container_, arg1: Internal.Level_): boolean;
        getMod(): string;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getResultItem(arg0: Internal.RegistryAccess_): Internal.ItemStack;
        toString(): string;
        "assemble(net.minecraft.world.inventory.CraftingContainer,net.minecraft.core.RegistryAccess)"(arg0: Internal.CraftingContainer_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        notifyAll(): void;
        canCraftInDimensions(arg0: number, arg1: number): boolean;
        "matches(net.minecraft.world.Container,net.minecraft.world.level.Level)"(arg0: net.minecraft.world.Container_, arg1: Internal.Level_): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        hashCode(): number;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        wait(): void;
        isIncomplete(): boolean;
        wait(arg0: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        equals(arg0: any): boolean;
        static createDecoratedPotItem(arg0: Internal.DecoratedPotBlockEntity$Decorations_): Internal.ItemStack;
        get class(): typeof any
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
    }
    type DecoratedPotRecipe_ = DecoratedPotRecipe;
    interface AccessibleSelection {
        abstract clearAccessibleSelection(): void;
        abstract getAccessibleSelection(arg0: number): Internal.Accessible;
        abstract addAccessibleSelection(arg0: number): void;
        abstract removeAccessibleSelection(arg0: number): void;
        abstract selectAllAccessibleSelection(): void;
        abstract isAccessibleChildSelected(arg0: number): boolean;
        abstract getAccessibleSelectionCount(): number;
        get accessibleSelectionCount(): number
    }
    type AccessibleSelection_ = AccessibleSelection;
    class ProjectileImpactEvent extends Internal.EntityEvent {
        constructor()
        constructor(arg0: Internal.Projectile_, arg1: Internal.HitResult_)
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        setCanceled(arg0: boolean): void;
        getResult(): Internal.Event$Result;
        getClass(): typeof any;
        toString(): string;
        getImpactResult(): Internal.ProjectileImpactEvent$ImpactResult;
        setPhase(arg0: Internal.EventPriority_): void;
        notifyAll(): void;
        getProjectile(): Internal.Projectile;
        isCanceled(): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        hasResult(): boolean;
        setResult(arg0: Internal.Event$Result_): void;
        hashCode(): number;
        isCancelable(): boolean;
        getEntity(): Internal.Entity;
        wait(): void;
        getListenerList(): Internal.ListenerList;
        setImpactResult(arg0: Internal.ProjectileImpactEvent$ImpactResult_): void;
        wait(arg0: number): void;
        getPhase(): Internal.EventPriority;
        getRayTraceResult(): Internal.HitResult;
        equals(arg0: any): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        set canceled(arg0: boolean)
        get result(): Internal.Event$Result
        get class(): typeof any
        get impactResult(): Internal.ProjectileImpactEvent$ImpactResult
        set phase(arg0: Internal.EventPriority_)
        get projectile(): Internal.Projectile
        get canceled(): boolean
        set result(arg0: Internal.Event$Result_)
        get cancelable(): boolean
        get entity(): Internal.Entity
        get listenerList(): Internal.ListenerList
        set impactResult(arg0: Internal.ProjectileImpactEvent$ImpactResult_)
        get phase(): Internal.EventPriority
        get rayTraceResult(): Internal.HitResult
    }
    type ProjectileImpactEvent_ = ProjectileImpactEvent;
    class ModuleDescriptor$Exports$Modifier extends Internal.Enum<Internal.ModuleDescriptor$Exports$Modifier> {
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        getDeclaringClass(): typeof Internal.ModuleDescriptor$Exports$Modifier;
        getClass(): typeof any;
        describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<Internal.ModuleDescriptor$Exports$Modifier>>;
        toString(): string;
        notifyAll(): void;
        compareTo(arg0: Internal.ModuleDescriptor$Exports$Modifier_): number;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        compareTo(arg0: any): number;
        static valueOf(arg0: string): Internal.ModuleDescriptor$Exports$Modifier;
        static values(): Internal.ModuleDescriptor$Exports$Modifier[];
        name(): string;
        hashCode(): number;
        ordinal(): number;
        wait(): void;
        wait(arg0: number): void;
        "compareTo(java.lang.Object)"(arg0: any): number;
        "compareTo(java.lang.module.ModuleDescriptor$Exports$Modifier)"(arg0: Internal.ModuleDescriptor$Exports$Modifier_): number;
        equals(arg0: any): boolean;
        get declaringClass(): typeof Internal.ModuleDescriptor$Exports$Modifier
        get class(): typeof any
        static readonly SYNTHETIC: (Internal.ModuleDescriptor$Exports$Modifier) & (Internal.ModuleDescriptor$Exports$Modifier);
        static readonly MANDATED: (Internal.ModuleDescriptor$Exports$Modifier) & (Internal.ModuleDescriptor$Exports$Modifier);
    }
    type ModuleDescriptor$Exports$Modifier_ = "mandated" | "synthetic" | ModuleDescriptor$Exports$Modifier;
    class DynamicRecipeComponent extends Internal.Record {
        constructor(desc: Internal.TypeDescJS_, factory: Internal.DynamicRecipeComponent$Factory_)
        desc(): Internal.TypeDescJS;
        getClass(): typeof any;
        hashCode(): number;
        toString(): string;
        factory(): Internal.DynamicRecipeComponent$Factory;
        wait(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        equals(o: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        get class(): typeof any
    }
    type DynamicRecipeComponent_ = DynamicRecipeComponent;
    interface BandsContext {
        abstract getBandsState(arg0: Internal.BandsRuleSource_, arg1: Internal.SimpleWeightedRandomList_<Internal.BlockState>, arg2: Internal.IntProvider_, arg3: Internal.IntProvider_, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): Internal.BlockState;
        (arg0: Internal.BandsRuleSource, arg1: Internal.SimpleWeightedRandomList<Internal.BlockState>, arg2: Internal.IntProvider, arg3: Internal.IntProvider, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): Internal.BlockState_;
    }
    type BandsContext_ = ((arg0: Internal.BandsRuleSource, arg1: Internal.SimpleWeightedRandomList<Internal.BlockState>, arg2: Internal.IntProvider, arg3: Internal.IntProvider, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number)=> Internal.BlockState_) | BandsContext;
    class Item implements Internal.FeatureElement, Internal.ItemFTBL, Internal.ItemLike, Internal.IForgeItem, Internal.ItemKJS, Internal.AccessorItem, Internal.DelegateHolder<any>, Internal.IEnchantableItem, Internal.IExtendedItem, Internal.ItemForgeAccessor, Internal.InjectedItemExtension {
        constructor(arg0: Internal.Item$Properties_)
        getDrinkingSound(): Internal.SoundEvent;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        moonlight$addAdditionalBehavior(placementOverride: Internal.AdditionalItemPlacement_): void;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isComplex(): boolean;
        forciblyAllowsTableEnchantment(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        moonlight$getClientAnimationExtension(): any;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): this;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getTypeData(): Internal.CompoundTag;
        getDefaultInstance(): Internal.ItemStack;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setBurnTime(i: number): void;
        setMaxStackSize(arg0: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getItem(): this;
        getBarColor(arg0: Internal.ItemStack_): number;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        asIngredient(): Internal.Ingredient;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        static byId(arg0: number): Internal.Item;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        moonlight$getAdditionalBehavior(): Internal.AdditionalItemPlacement;
        moonlight$setClientAnimationExtension(obj: any): void;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        selectEnchantments(arg0: Internal.List_<Internal.EnchantmentInstance>, arg1: Internal.RandomSource_, arg2: Internal.ItemStack_, arg3: number, arg4: number, arg5: number, arg6: boolean): Internal.List<Internal.EnchantmentInstance>;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: Internal.EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        toString(): string;
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): Special.Item&`${string}:${string}`;
        handler$eba000$initializeClient(consumer: Internal.Consumer_<any>, ci: Internal.CallbackInfo_): void;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: Internal.EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        onEnchantment(arg0: Internal.ItemStack_, arg1: Internal.List_<Internal.EnchantmentInstance>): Internal.ItemStack;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): Internal.EquipmentSlot;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): this;
        getTypeItemStackKey(): Internal.ItemStackKey;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isTreasureAllowed(arg0: Internal.ItemStack_, arg1: boolean): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get typeData(): Internal.CompoundTag
        get defaultInstance(): Internal.ItemStack
        set burnTime(i: number)
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        set itemBuilder(b: Internal.ItemBuilder_)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): Special.Item&`${string}:${string}`
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        static readonly BY_BLOCK: ({[key: Internal.TintedGlassBlock]: Internal.BlockItem, [key: Internal.EnderChestBlock]: Internal.BlockItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.GlassBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.GaugeBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: com.supermartijn642.chunkloaders.ChunkLoaderBlock]: Internal.BaseBlockItem, [key: Internal.IEEntityBlock<any>]: Internal.BlockItemIE$BlockItemIENoInventory, [key: Internal.DemagnetizationCoilBlock]: Internal.BaseBlockItem, [key: Internal.BWGWallSignBlock]: Internal.SignItem, [key: Internal.BWGWallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.BlockOre]: Internal.ItemBlockTooltip<any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockTurbineRotor]: Internal.ItemBlockTooltip<any>, [key: Internal.CushionBlock]: Internal.BlockItemIE, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.TreasureShelfBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CACakeBlock]: Internal.BlockItem, [key: Internal.EnderGateBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.FallingDamageBlock]: Internal.BlockItem, [key: Internal.EnderGateBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.BlockMechanicalPipe]: Internal.ItemBlockMechanicalPipe, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.PlayerTransmitterBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.BlockFluidTank]: Internal.ItemBlockFluidTank, [key: Internal.EnergizingRodBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.IEStairsBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: blusunrize.immersiveengineering.common.blocks.generic.ScaffoldingBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.ToolboxBlock]: Internal.UncontainableBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.SteamEngineBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.TypedShelfBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CherryLeavesBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CalibratedSculkSensorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.IronBarsBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.NetherSproutsBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SnadBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.BWGStandingSignBlock]: Internal.SignItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FallingDamageBlock]: Internal.BlockItem, [key: owmii.powah.lib.block.AbstractBlock<any, any>]: Internal.ItemBlock<any, any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.HugeMushroomBlock]: Internal.BlockItem, [key: Internal.ConcretePowderBlock]: Internal.BlockItem, [key: Internal.BuddingCrystalBlock]: Internal.CrystalBlockItem, [key: Internal.IcicleBlock]: Internal.BlockItem, [key: Internal.BlockTile<any, any>]: Internal.ItemBlockMachine, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: owmii.powah.lib.block.AbstractBlock<any, any>]: Internal.ItemBlock<any, any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DimTank]: Internal.ItemDimBase, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BarbedWireBlock]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.HammockBlock]: Internal.HammockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.WarpPlateBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: blusunrize.immersiveengineering.common.blocks.metal.ChuteBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SolicitingCarpet]: Internal.BlockItem, [key: Internal.BWGCeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlidingDoorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BuddingCrystalBlock]: Internal.CrystalBlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.AEDecorativeBlock]: Internal.AEBaseBlockItem, [key: Internal.BlockBasicMultiblock<any>]: Internal.ItemBlockTooltip<any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.ElevatorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TaskScreenBlock]: Internal.ScreenBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockResource]: Internal.ItemBlockResource, [key: owmii.powah.lib.block.AbstractBlock<any, any>]: Internal.ItemBlock<any, any>, [key: Internal.CrystalResonanceGeneratorBlock]: Internal.AEBaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LimitedBarrelBlock]: Internal.BarrelBlockItem, [key: Internal.EnergyHopperBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.ConnectedGlassBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.HorizontalFacingEntityBlock<any>]: Internal.BlockItemIE, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.BlockDirtStairs]: Internal.BlockItem, [key: Internal.ToolRackBlock]: Internal.BlockItem, [key: Internal.WoolCarpetBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ToolboxBlock]: Internal.UncontainableBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBannerBlock]: Internal.BannerItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGLeavesBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.SpongeBlock]: Internal.BlockItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.BWGFruitLeavesBlock]: Internal.BlockItem, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockWindGenerator, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DoublePlantBlock]: Internal.DoubleHighBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.TurretBlock<any>]: Internal.BlockItemIE, [key: Internal.WoolCarpetBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ExtraBlock]: Internal.ExtraBlockItem, [key: Internal.GantryCarriageBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ToolboxBlock]: Internal.UncontainableBlockItem, [key: Internal.WeatheringCopperStairBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.ElevatorBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.FarmlandMoistBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.BWGCeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.SharestoneBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.EnderGateBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ExtraBlock]: Internal.ExtraBlockItem, [key: Internal.WWGBarrelBlock]: Internal.ForgeBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.TypedShelfBlock]: Internal.BlockItem, [key: Internal.CraftingUnitBlock]: Internal.CraftingBlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: com.ldtteam.domumornamentum.block.vanilla.WallBlock]: Internal.WallBlockItem, [key: Internal.TypedShelfBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TypedShelfBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockEnergyCube]: Internal.ItemBlockEnergyCube, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FallingDamageBlock]: Internal.BlockItem, [key: Internal.LimitedBarrelBlock]: Internal.BarrelBlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.SmartFluidPipeBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.GlazedTerracottaBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ConnectedPillarBlock]: Internal.BlockItem, [key: Internal.WWGChestBlock]: Internal.ForgeChestItem, [key: Internal.SleepingBagBlock]: Internal.SleepingBagItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FloatingCarpetBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BeehiveBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.SleepingBagBlock]: Internal.SleepingBagItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.TrainTrapdoorBlock]: Internal.BlockItem, [key: Internal.FramedLightBlock]: Internal.FramedLightBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.MagmatorBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.StairBlock]: Internal.BlockItem, [key: com.simibubi.create.content.decoration.MetalLadderBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.StainedGlassBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.StationBlock]: Internal.TrackTargetingBlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockCustomStairs]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AzaleaBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CoralPlantBlock]: Internal.BlockItem, [key: Internal.BWGStandingSignBlock]: Internal.SignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.TripWireHookBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.EndPortalFrameBlock]: Internal.BlockItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.Block]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WeepingVinesBlock]: Internal.BlockItem, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.HammockBlock]: Internal.HammockItem, [key: Internal.HammockBlock]: Internal.HammockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockChemicalTank, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.NetherrackBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockCompressedStone]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WitherRoseBlock]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ShulkerBoxBlock]: Internal.BlockItem, [key: Internal.ExtraBlock]: Internal.ExtraBlockItem, [key: Internal.EnergyPylon]: Internal.ItemBlockBCore, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: com.mrh0.createaddition.blocks.tesla_coil.TeslaCoilBlock]: Internal.AssemblyOperatorBlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.CraftingInjector]: Internal.ItemBlockBCore, [key: Internal.SolarBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.LimitedBarrelBlock]: Internal.BarrelBlockItem, [key: Internal.FloatingCarpetBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StainedGlassPaneBlock]: Internal.BlockItem, [key: Internal.BlockFactoryMachine<any, any>]: Internal.ItemBlockMachine, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PitcherCropBlock]: Internal.ItemNameBlockItem, [key: Internal.ExtraBlock]: Internal.ExtraBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CGColoredTintedGlassBlock]: Internal.BaseBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.BWGWallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CattailSproutBlock]: Internal.CampfireExplodingBlockItem, [key: Internal.MetalScaffoldingBlock]: Internal.MetalScaffoldingBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.EnergyCrystal]: Internal.ItemBlockBCore, [key: Internal.WallSkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CraftingStationBlock]: Internal.BlockItem, [key: Internal.ReactorComponent]: Internal.ItemBlockBCore, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockMechanicalPipe]: Internal.ItemBlockMechanicalPipe, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SculkVeinBlock]: Internal.BlockItem, [key: Internal.BellBlock]: Internal.BlockItem, [key: Internal.ConcretePowderBlock]: Internal.BlockItem, [key: Internal.ElevatorBlock]: Internal.BlockItem, [key: Internal.BuddingCrystalBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SweetBerryBushBlock]: Internal.ItemNameBlockItem, [key: Internal.PaintSplotchesBlock]: Internal.AEBaseBlockItem, [key: Internal.HammockBlock]: Internal.HammockItem, [key: Internal.PortalBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BarrelCactusBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.BWGWallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.CandleBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.SlidingDoorBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: owmii.powah.lib.block.AbstractBlock<any, any>]: Internal.ItemBlock<any, any>, [key: Internal.SolicitingCarpet]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.SkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BuddingCrystalBlock]: Internal.CrystalBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TerminalBlock<any>]: Internal.AEBaseBlockItem, [key: Internal.CoralPlantBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.BlockResource]: Internal.ItemBlockResource, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AllBrickBlock]: Internal.AllBrickBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StainedGlassBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CoralPlantBlock]: Internal.BlockItem, [key: Internal.BeehiveBlock]: Internal.BlockItem, [key: Internal.StainedGlassBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock]: Internal.BarrelBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.NetherrackBlock]: Internal.BlockItem, [key: Internal.BWGStandingSignBlock]: Internal.SignItem, [key: Internal.FloatingCarpetBlock]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.IceSheetBlock]: Internal.BlockItem, [key: Internal.BWGCeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.MultiblockPartBlock<any>]: Internal.MultiblockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CGPaneBlock]: Internal.BaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockTile<any, any>]: Internal.ItemBlockTooltip<any>, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BWGCeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TurntableBlock]: Internal.BlockItemIE, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.ConcretePowderBlock]: Internal.BlockItem, [key: Internal.FallingDamageBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.GlassBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FloatingCarpetBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.LanternBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockBin]: Internal.ItemBlockBin, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.HayBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.NetherrackBlock]: Internal.BlockItem, [key: Internal.DoorBlock]: Internal.BlockItem, [key: Internal.BWGCeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.JAOPCABlock]: Internal.JAOPCABlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.CraftingUnitBlock]: Internal.MEGACraftingBlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.WWGChestBlock]: Internal.ForgeChestItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.DropExperienceBlock]: Internal.BlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGChangingLeavesBlock]: Internal.BlockItem, [key: Internal.StemBlock]: Internal.ItemNameBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallSignBlock]: Internal.SignItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.WWGTrappedChestBlock]: Internal.ForgeChestItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AngelBlock]: Internal.AngelBlockItem, [key: Internal.LimitedBarrelBlock]: Internal.BarrelBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MobFarmBlockWrapper]: Internal.MobFarmBlockItem, [key: Internal.BeehiveBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.IEEntityBlock<any>]: Internal.BlockItemIE$BlockItemIENoInventory, [key: Internal.LadderBlock]: Internal.ForgeBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CGPaneBlock]: Internal.BaseBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SolicitingCarpet]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.SeatBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.CraftingInjector]: Internal.ItemBlockBCore, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MetalScaffoldingBlock]: Internal.MetalScaffoldingBlockItem, [key: Internal.LightningRodBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.BWGCraftingTable]: Internal.BlockItem, [key: Internal.SharestoneBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: blusunrize.immersiveengineering.common.blocks.metal.ChuteBlock]: Internal.BlockItemIE, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.SolarBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.BlockRotatable]: Internal.ItemBlockWoodenCrate, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.DisplayLinkBlock]: Internal.DisplayLinkBlockItem, [key: Internal.MysteriousCubeBlock]: Internal.AEBaseBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGCraftingTable]: Internal.BlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.PortableStorageInterfaceBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockResource]: Internal.ItemBlockResource, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.DoorBlock]: Internal.DoubleHighBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGCraftingTable]: Internal.BlockItem, [key: Internal.WindmillBlock]: Internal.BlockItemIE, [key: Internal.HorizontalFacingBlock]: Internal.BlockItemIE, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.BWGCraftingTable]: Internal.BlockItem, [key: Internal.BWGFruitLeavesBlock]: Internal.BlockItem, [key: Internal.PoweredRailBlock]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.QuestBarrierBlock]: Internal.QuestBarrierBlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SharestoneBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MultiblockPartBlock$WithMirrorState<any>]: Internal.MultiblockItem, [key: Internal.SlagGravelBlock]: Internal.BlockItemIE, [key: Internal.BedBlock]: Internal.BedItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RequesterBlock]: Internal.AEBaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.WeatheringCopperSlabBlock]: Internal.BlockItem, [key: Internal.FloatingCarpetBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ConnectedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.GardenBlock]: Internal.BlockItem, [key: Internal.BWGCraftingTable]: Internal.BlockItem, [key: Internal.PoweredLatchBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.RedstoneRelayBlock]: Internal.BlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.SolicitingCarpet]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.ApothAnvilBlock]: Internal.ApothAnvilItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FertilizedFarmlandBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.DyedOvenBlock]: Internal.BlockItem, [key: Internal.BlockTestMachine]: Internal.BlockItem, [key: blusunrize.immersiveengineering.common.blocks.generic.ScaffoldingBlock]: Internal.BlockItemIE, [key: Internal.WallTorchBlock]: Internal.StandingAndWallBlockItem, [key: Internal.BlockFactoryMachine<any, any>]: Internal.ItemBlockMachine, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.TypedShelfBlock$SculkShelfBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.EnergyCrystal]: Internal.ItemBlockBCore, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock]: Internal.ChestBlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.CartographyTableBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BannerBlock]: Internal.BannerItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StainedGlassBlock]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.PlayerTransmitterBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockMachine, [key: Internal.DropExperienceBlock]: Internal.BlockItem, [key: Internal.NonMirrorableWithActiveBlock<any>]: Internal.MultiblockItem, [key: Internal.DemagnetizationCoilBlock]: Internal.BaseBlockItem, [key: Internal.SeatBlock]: Internal.BlockItem, [key: Internal.CandleBlock]: Internal.BlockItem, [key: Internal.BWGStandingSignBlock]: Internal.SignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LinearChassisBlock]: Internal.BlockItem, [key: Internal.ConveyorBlock]: Internal.BlockItemIE, [key: Internal.ConcretePowderBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PlayerTransmitterBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CounterBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: owmii.powah.lib.block.AbstractBlock<any, any>]: Internal.ItemBlock<any, any>, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.SharestoneBlock]: Internal.BlockItem, [key: Internal.BlockGrassSlab]: Internal.BlockItem, [key: Internal.CableBusBlock]: Internal.AEBaseBlockItem, [key: Internal.LootrBarrelBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.WindowBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.NetherrackBlock]: Internal.BlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.WallmountBlock]: Internal.BlockItemIE, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.StandingSignBlock]: Internal.SignItem, [key: Internal.DeadBushBlock]: Internal.BlockItem, [key: appeng.block.networking.EnergyCellBlock]: Internal.EnergyCellBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: owmii.powah.lib.block.AbstractBlock<any, any>]: Internal.ItemBlock<any, any>, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WWGBarrelBlock]: Internal.ForgeBlockItem, [key: Internal.BlockBasicMultiblock<any>]: Internal.ItemBlockTooltip<any>, [key: Internal.ConnectedGlassPaneBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockTile<any, any>]: Internal.ItemBlockInductionCell, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.WallBannerBlock]: Internal.BannerItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.WallBannerBlock]: Internal.BannerItem, [key: Internal.CogWheelBlock]: Internal.CogwheelBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SolicitingCarpet]: Internal.BlockItem, [key: Internal.ChainGearshiftBlock]: Internal.BlockItem, [key: Internal.BrickBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.BWGLeavesBlock]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.GlowLichenBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ConcretePowderBlock]: Internal.BlockItem, [key: Internal.DoorBlock]: Internal.DoubleHighBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.AnvilBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DraconiumOre]: Internal.ItemBlockBCore, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.BlockFactoryMachine$BlockFactoryMachineModel<any, any>]: Internal.ItemBlockMachine, [key: Internal.WWGTrappedChestBlock]: Internal.ForgeChestItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.SleepingBagBlock]: Internal.SleepingBagItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MultiblockPartBlock$WithMirrorState<any>]: Internal.MultiblockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WWGTrappedChestBlock]: Internal.ForgeChestItem, [key: Internal.EquipableCarvedPumpkinBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.ShulkerBoxBlock]: Internal.BlockItem, [key: Internal.GrassBlock]: Internal.BlockItem, [key: Internal.BaseCoralFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGCeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGWallSignBlock]: Internal.SignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.CertusQuartzClusterBlock]: Internal.AEBaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGWallSignBlock]: Internal.SignItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BasicConnectorBlock<any>]: Internal.BlockItemIE, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.CableBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ConcretePowderBlock]: Internal.BlockItem, [key: Internal.BoneMealGrassBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DaylightDetectorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Grinder]: Internal.ItemBlockBCore, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.FloatingCarpetBlock]: Internal.BlockItem, [key: Internal.WWGChestBlock]: Internal.ForgeChestItem, [key: Internal.AEDecorativeBlock]: Internal.AEBaseBlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: blusunrize.immersiveengineering.common.blocks.generic.PostBlock]: Internal.BlockItemIE, [key: Internal.DoorBlock]: Internal.BlockItem, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BuddingCrystalBlock]: Internal.CrystalBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WoolCarpetBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockBasicMultiblock<any>]: Internal.ItemBlockTooltip<any>, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.FallingDamageBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallTorchBlock]: Internal.StandingAndWallBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MetalLadderBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DraconiumOre]: Internal.ItemBlockBCore, [key: Internal.SharestoneBlock]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WoolCarpetBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGWallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.WWGChestBlock]: Internal.ForgeChestItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ConnectedGlassPaneBlock]: Internal.BlockItem, [key: Internal.ReactorComponent]: Internal.ItemBlockBCore, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DropExperienceBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.CoralWallFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.FletchingTableBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.BlockRotatableHorizontalShaped]: Internal.ItemPalletOfBricks, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.CarrotBlock]: Internal.ItemNameBlockItem, [key: Internal.VineBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WhitePuffballBlock]: Internal.ItemNameBlockItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.EnergyCellBlock]: Internal.EnergyCellItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.EnergyHopperBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.IceBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.HandCrankBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WWGBarrelBlock]: Internal.ForgeBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.PotatoBlock]: Internal.ItemNameBlockItem, [key: com.ldtteam.domumornamentum.block.vanilla.FenceGateBlock]: Internal.FenceGateBlockItem, [key: Internal.GlazedTerracottaBlock]: Internal.BlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.CarvedBarrelCactusBlock]: Internal.BlockItem, [key: Internal.ExtraBlock]: Internal.ExtraBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.BWGCraftingTable]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.BWGDoublePlantBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockMachine, [key: Internal.BWGTallFlowerBlock]: Internal.BlockItem, [key: Internal.AnalogLeverBlock]: Internal.BlockItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockResource]: Internal.ItemBlockResource, [key: Internal.SoulSandBlock]: Internal.BlockItem, [key: Internal.DyedOvenBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.KelpBlock]: Internal.BlockItem, [key: Internal.SleepingBagBlock]: Internal.SleepingBagItem, [key: Internal.EnergyTransfuser]: Internal.ItemBlockBCore, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LimitedBarrelBlock]: Internal.BarrelBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.DeployerBlock]: Internal.AssemblyOperatorBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.BlockFactoryMachine<any, any>]: Internal.ItemBlockMachine, [key: Internal.EnergyCoreStabilizer]: Internal.ItemBlockBCore, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.ShulkerBoxBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FallingDamageBlock]: Internal.BlockItem, [key: Internal.PowderSnowBlock]: Internal.SolidBucketItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WWGTrappedChestBlock]: Internal.ForgeChestItem, [key: Internal.BWGCraftingTable]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.ShulkerBoxBlock]: Internal.BlockItem, [key: Internal.DoorBlock]: Internal.DoubleHighBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.ElevatorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.SailBlock]: Internal.BlankSailBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BaseCoralWallFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.MultiblockPartBlock$WithMirrorState<any>]: Internal.MultiblockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.CandleBlock]: Internal.BlockItem, [key: Internal.EnderCellBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: com.simibubi.create.content.kinetics.turntable.TurntableBlock]: Internal.BlockItem, [key: Internal.ConnectedPillarBlock]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.PowderSnowCauldronBlock]: Internal.Items$1, [key: Internal.RopeAndNailBlock]: Internal.RopeAndNailItem, [key: Internal.ElevatorBlock]: Internal.BlockItem, [key: Internal.BWGStandingSignBlock]: Internal.SignItem, [key: Internal.EnderGateBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBannerBlock]: Internal.BannerItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.CreativeMotorBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.GrrassBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BedBlock]: Internal.BedItem, [key: Internal.PlayerWallHeadBlock]: Internal.PlayerHeadItem, [key: Internal.BrickBlock]: Internal.BlockItem, [key: Internal.CandleBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CasingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: blusunrize.immersiveengineering.common.blocks.metal.ChuteBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.JAOPCABlock]: Internal.JAOPCABlockItem, [key: Internal.BWGStandingSignBlock]: Internal.SignItem, [key: Internal.WWGTrappedChestBlock]: Internal.ForgeChestItem, [key: Internal.InfestedRotatedPillarBlock]: Internal.BlockItem, [key: Internal.BlockThermodynamicConductor]: Internal.ItemBlockThermodynamicConductor, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RootsBlock]: Internal.BlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.SharestoneBlock]: Internal.BlockItem, [key: Internal.TimberFrameBlock]: Internal.TimberFrameBlockItem, [key: Internal.ShingleSlabBlock]: Internal.ShingleSlabBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SailBlock]: Internal.BlankSailBlockItem, [key: Internal.DigitalAdapterBlock]: Internal.DigitalAdapterBlockItem, [key: Internal.RareIceBlock]: Internal.BlockItem, [key: Internal.BuddingCrystalBlock]: Internal.CrystalBlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.ItemBatcherBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.SolicitingCarpet]: Internal.BlockItem, [key: Internal.ChiseledBookShelfBlock]: Internal.BlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.CDockBlock]: Internal.BlockItem, [key: Internal.LadderBlock]: Internal.ForgeBlockItem, [key: Internal.SculkCatalystBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.AndesiteFunnelBlock]: Internal.FunnelItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.WebBlock]: Internal.BlockItem, [key: Internal.SharestoneBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CraftingStationSlabBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.WoolCarpetBlock]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGSpreadableBlock]: Internal.BlockItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.PatternProviderBlock]: Internal.AEBaseBlockItem, [key: Internal.CGGlassBlock]: Internal.BaseBlockItem, [key: Internal.LadderBlock]: Internal.ForgeBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.ReactorBlock]: Internal.ReactorItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.EntityDetector]: Internal.ItemBlockBCore, [key: Internal.BlockUniversalCable]: Internal.ItemBlockUniversalCable, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.MangroveRootsBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.IronBarsBlock]: Internal.BlockItem, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockChemicalTank, [key: Internal.TypedShelfBlock]: Internal.GlowyBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockLaserFocusMatrix]: Internal.ItemBlockTooltip<any>, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.IEEntityBlock<any>]: Internal.BlockItemCapacitor, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockIndustrialAlarm]: Internal.ItemBlockTooltip<any>, [key: Internal.SharestoneBlock]: Internal.BlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.CableBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.BWGCraftingTable]: Internal.BlockItem, [key: Internal.BannerBlock]: Internal.BannerItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TallGrassBlock]: Internal.BlockItem, [key: Internal.WWGBarrelBlock]: Internal.ForgeBlockItem, [key: Internal.IEStairsBlock]: Internal.BlockItemIE, [key: Internal.TransformerBlock]: Internal.TransformerBlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockMachine, [key: Internal.BasicConnectorBlock<any>]: Internal.BlockItemIE, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ValveHandleBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.BlockRotatable]: Internal.ItemBlockWoodenCrate, [key: Internal.BlockThermodynamicConductor]: Internal.ItemBlockThermodynamicConductor, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.KitchenFloorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.BedBlock]: Internal.BedItem, [key: Internal.BWGPlacementBushBlock]: Internal.BlockItem, [key: Internal.BlockTile<any, any>]: Internal.ItemBlockInductionCell, [key: Internal.WeatheringCopperFullBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.FloodlightBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.GlazedTerracottaBlock]: Internal.BlockItem, [key: Internal.CopycatPanelBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGWallSignBlock]: Internal.SignItem, [key: Internal.TypedShelfBlock]: Internal.GlowyBlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.BlockCompressedObsidian]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGCeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WaterlilyBlock]: Internal.PlaceOnWaterBlockItem, [key: Internal.BWGDirtPathBlock]: Internal.BlockItem, [key: Internal.BlockPressurizedTube]: Internal.ItemBlockPressurizedTube, [key: Internal.BWGWallSignBlock]: Internal.SignItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockChemicalTank, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.WWGChestBlock]: Internal.ForgeChestItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.BWGCraftingTable]: Internal.BlockItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.BlockCompressedStone]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.NotSoMysteriousCubeBlock]: Internal.AEBaseBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.EncasedCogwheelBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.SleepingBagBlock]: Internal.SleepingBagItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MagmatorBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.BedBlock]: Internal.BedItem, [key: Internal.ThermoBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PloughBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WWGBarrelBlock]: Internal.ForgeBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.TimberFrameBlock]: Internal.TimberFrameBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.MagmatorBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SleepingBagBlock]: Internal.SleepingBagItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WindowBlock]: Internal.BlockItem, [key: Internal.DyedOvenBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AdvPatternProviderBlock]: Internal.AEBaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FurnatorBlock]: Internal.EnergyBlockItem<any, any>, [key: com.ldtteam.domumornamentum.block.vanilla.FenceBlock]: Internal.FenceBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.BWGWallSignBlock]: Internal.SignItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.KitchenStationBlock]: Internal.KitchenStationBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.HydrangeaHedgeBlock]: Internal.BlockItem, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockMachine, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RepeaterBlock]: Internal.BlockItem, [key: Internal.SailBlock]: Internal.BlankSailBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.PartialConcreteBlock]: Internal.BlockItemIE, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.BWGCeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WitherWallSkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.BWGWallSignBlock]: Internal.SignItem, [key: Internal.SandBlock]: Internal.BlockItem, [key: Internal.InfestedBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TrophyBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: owmii.powah.lib.block.AbstractBlock<any, any>]: Internal.ItemBlock<any, any>, [key: Internal.EnergyDischargerBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CactusBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AEDecorativeBlock]: Internal.AEBaseBlockItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.BlockBasicMultiblock<any>]: Internal.ItemBlockTooltip<any>, [key: Internal.BlockResource]: Internal.ItemBlockResource, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.ApothSpawnerBlock]: Internal.ApothSpawnerItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.DoorBlock]: Internal.BlockItem, [key: Internal.StainedGlassPaneBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WindowBlock]: Internal.BlockItem, [key: Internal.SeaPickleBlock]: Internal.BlockItem, [key: Internal.NetherrackBlock]: Internal.BlockItem, [key: Internal.FallingDamageBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.SeatBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.EnergyCellBlock]: Internal.EnergyCellItem, [key: Internal.ObserverBlock]: Internal.BlockItem, [key: Internal.FlapDisplayBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.CGColoredTintedGlassBlock]: Internal.BaseBlockItem, [key: Internal.DoorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.NonMirrorableWithActiveBlock<any>]: Internal.MultiblockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.HugeMushroomBlock]: Internal.BlockItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.CarpetBlock]: Internal.BlockItem, [key: Internal.RedStoneOreBlock]: Internal.BlockItem, [key: Internal.WWGBarrelBlock]: Internal.ForgeBlockItem, [key: Internal.WeatheringCopperFullBlock]: Internal.BlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.JAOPCABlock]: Internal.JAOPCABlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.DetectorRailBlock]: Internal.BlockItem, [key: Internal.TypedShelfBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.BuddingCrystalBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SpawnerBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SmithingTableBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.MagmatorBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.HugeMushroomBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ExtraBlock]: Internal.ExtraBlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.AEDecorativeBlock]: Internal.AEBaseBlockItem, [key: Internal.SeatBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RedstoneTorchBlock]: Internal.StandingAndWallBlockItem, [key: Internal.CGColoredTintedGlassBlock]: Internal.BaseBlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockFluidTank]: Internal.ItemBlockFluidTank, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGStandingSignBlock]: Internal.SignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.IronBarsBlock]: Internal.BlockItem, [key: Internal.WWGBarrelBlock]: Internal.ForgeBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.IEStairsBlock]: Internal.BlockItemIE, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ElevatorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TrashCanBlock]: Internal.BaseBlockItem, [key: Internal.MobFarmBlockWrapper]: Internal.MobFarmBlockItem, [key: Internal.IEEntityBlock<any>]: Internal.BlockItemIE, [key: Internal.BacktankBlock]: Internal.BacktankItem$BacktankBlockItem, [key: Internal.DoorBlock]: Internal.DoubleHighBlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.IEEntityBlock<any>]: Internal.BlockItemIE, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.WaterlilyBlock]: Internal.PlaceOnWaterBlockItem, [key: Internal.LimitedBarrelBlock]: Internal.BarrelBlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.BWGCraftingTable]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.SolicitingCarpet]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BeehiveBlock]: Internal.BlockItem, [key: Internal.BlockTile<any, any>]: Internal.ItemBlockMachine, [key: Internal.WWGChestBlock]: Internal.ForgeChestItem, [key: Internal.CGColoredTintedGlassBlock]: Internal.BaseBlockItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.CoralBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.ConcretePowderBlock]: Internal.BlockItem, [key: Internal.SpoutBlock]: Internal.AssemblyOperatorBlockItem, [key: Internal.CertusQuartzClusterBlock]: Internal.AEBaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SolicitingCarpet]: Internal.BlockItem, [key: Internal.ModBlocks$2]: Internal.BlockItemBase, [key: Internal.FurnatorBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ConnectedPillarBlock]: Internal.BlockItem, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockChemicalTank, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.WoolCarpetBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DraconiumBlock]: Internal.ItemBlockBCore, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RollerBlock]: Internal.RollerBlockItem, [key: Internal.AAECraftingUnitBlock]: Internal.AAECraftingBlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TypedShelfBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.IEStairsBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.StorageIOBlock]: Internal.BlockItemBase, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.ToolboxBlock]: Internal.UncontainableBlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TargetBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlidingDoorBlock]: Internal.BlockItem, [key: Internal.RollingMillBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.WWGChestBlock]: Internal.ForgeChestItem, [key: Internal.SkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.SailBlock]: Internal.BlankSailBlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.TallFlowerBlock]: Internal.DoubleHighBlockItem, [key: Internal.BWGWallSignBlock]: Internal.SignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RedstonePillarBlock]: Internal.BlockItem, [key: Internal.AlternatorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.ModBlocks$1]: Internal.BlockItemBase, [key: Internal.KitchenFloorBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.CoralFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.WallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.LightDetectorBlock]: Internal.AEBaseBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.BWGTallFlowerBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ExtraBlock]: Internal.ExtraBlockItem, [key: Internal.SoulSandBlock]: Internal.BlockItem, [key: Internal.LadderBlock]: Internal.ForgeBlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.GlowGoopBlock]: Internal.GlowGoopItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.BWGWallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ConcretePowderBlock]: Internal.BlockItem, [key: Internal.BlockBin]: Internal.ItemBlockBin, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock]: Internal.BarrelBlockItem, [key: Internal.LadderBlock]: Internal.ForgeBlockItem, [key: Internal.JAOPCABlock]: Internal.JAOPCABlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BlockBasicMultiblock<any>]: Internal.ItemBlockTooltip<any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WeatheringCopperFullBlock]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.CGColoredTintedGlassBlock]: Internal.BaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ThermoBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.RequesterTerminalBlock]: Internal.RequesterTerminalBlockItem, [key: Internal.WeatheringCopperFullBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.BlastFurnacePreheaterBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.HugeMushroomBlock]: Internal.BlockItem, [key: Internal.OxidizableButtonBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.SoulSandBlock]: Internal.BlockItem, [key: Internal.JAOPCABlock]: Internal.JAOPCABlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.CableBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.ExtraBlock]: Internal.ExtraBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SailBlock]: Internal.BlankSailBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockThermodynamicConductor]: Internal.ItemBlockThermodynamicConductor, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.WWGChestBlock]: Internal.ForgeChestItem, [key: Internal.PhantomNodeBlock]: Internal.AEBaseBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.LimitedBarrelBlock]: Internal.BarrelBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CraftingUnitBlock]: Internal.MEGACraftingBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.LootrShulkerBlock]: Internal.LootrShulkerBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: com.ldtteam.domumornamentum.block.vanilla.DoorBlock]: Internal.DoorBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.RedstoneClockBlock]: Internal.BlockItem, [key: Internal.WaterlilyBlock]: Internal.PlaceOnWaterBlockItem, [key: Internal.BWGChangingLeavesBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.ExtraBlock]: Internal.ExtraBlockItem, [key: Internal.BlockTile<any, any>]: Internal.ItemBlockTooltip<any>, [key: Internal.AmethystBlock]: Internal.BlockItem, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockMachine, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SeatBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.WallSignBlock]: Internal.SignItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.BlockTile<any, any>]: Internal.ItemBlockTeleporter, [key: Internal.Block]: Internal.BlockItem, [key: owmii.powah.lib.block.AbstractBlock<any, any>]: Internal.ItemBlock<any, any>, [key: Internal.BuddingCrystalBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.SharestoneBlock]: Internal.BlockItem, [key: Internal.ItemGenBlock]: Internal.AEBaseBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.BWGSpreadableBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.ElevatorBlock]: Internal.BlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.BWGChangingLeavesBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.MobFarmBlockWrapper]: Internal.MobFarmBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.FlowerableBushBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.BrickBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ToolboxBlock]: Internal.UncontainableBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SandBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.MobFarmBlockWrapper]: Internal.MobFarmBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TrapdoorBlock]: Internal.TrapdoorBlockItem, [key: Internal.BlockBasicMultiblock<any>]: Internal.ItemBlockTooltip<any>, [key: Internal.FlywheelBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.FloatingCarpetBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WitchHazelBlossomBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.DirtPathBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.EjectorBlock]: Internal.EjectorItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CoralWallFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.ValveHandleBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.DesertPlantBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AEDecorativeBlock]: Internal.AEBaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LightningRodBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.WWGBarrelBlock]: Internal.ForgeBlockItem, [key: Internal.WoolCarpetBlock]: Internal.BlockItem, [key: Internal.TeddyBearBlock]: Internal.BlockItem, [key: Internal.DoorBlock]: Internal.DoubleHighBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockResource]: Internal.ItemBlockResource, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.MobFarmTemplateBlock]: Internal.MobFarmTemplateItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.WeatheringCopperFullBlock]: Internal.BlockItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.TypedShelfBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SculkShriekerBlock]: Internal.BlockItem, [key: Internal.OverworldPortalBlock]: Internal.BlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.SolicitingCarpet]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BaseCoralFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: com.simibubi.create.content.decoration.MetalLadderBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MagmaBlock]: Internal.BlockItem, [key: Internal.FallingDamageBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BuddingCrystalBlock]: Internal.CrystalBlockItem, [key: Internal.SolicitingCarpet]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.BuddingCrystalBlock]: Internal.CrystalBlockItem, [key: Internal.BaseCoralWallFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.ConnectedGlassPaneBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ToolboxBlock]: Internal.UncontainableBlockItem, [key: Internal.SawdustBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RedStoneOreBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGWallSignBlock]: Internal.SignItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.DislocationInhibitor]: Internal.ItemBlockBCore, [key: Internal.MechanicalPistonBlock]: Internal.BlockItem, [key: Internal.BlockCustomWall]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.BasicConnectorBlock<any>]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ExtraBlock]: Internal.ExtraBlockItem, [key: Internal.ExtraBlock]: Internal.ExtraBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.PropellerRenderPropBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBannerBlock]: Internal.BannerItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.BWGStandingSignBlock]: Internal.SignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.ShingleBlock]: Internal.ShingleBlockItem, [key: Internal.QuantumLinkChamberBlock]: Internal.AEBaseBlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.DoorBlock]: Internal.BlockItem, [key: Internal.DropExperienceBlock]: Internal.BlockItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.BlockBase<any>]: Internal.ItemBlockTooltip<any>, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.FancyDoorBlock]: Internal.FancyDoorBlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.BWGTallFlowerBlock]: Internal.BlockItem, [key: Internal.DropExperienceBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.BWGBonemealableFlowerBlock]: Internal.BlockItem, [key: Internal.BWGWallSignBlock]: Internal.SignItem, [key: Internal.WallSignBlock]: Internal.SignItem, [key: Internal.BlockEnergyCube]: Internal.ItemBlockEnergyCube, [key: Internal.Block]: Internal.BlockItem, [key: Internal.NoSolicitingBanner]: Internal.BannerItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MetalLadderBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.EntityDetector]: Internal.ItemBlockBCore, [key: Internal.BeehiveBlock]: Internal.BlockItem, [key: Internal.ElevatorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.EnergyGeneratorBlock]: Internal.AEBaseBlockItem, [key: Internal.ValveHandleBlock]: Internal.BlockItem, [key: Internal.ConnectedGlassPaneBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.SoulSandBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.ValveHandleBlock]: Internal.BlockItem, [key: Internal.EncasedCogwheelBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BWGLeavesBlock]: Internal.BlockItem, [key: Internal.WWGChestBlock]: Internal.ForgeChestItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.ElevatorBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FallingDamageBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.GlazedTerracottaBlock]: Internal.BlockItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItemIE, [key: Internal.GrowthAcceleratorBlock]: Internal.AEBaseBlockItem, [key: Internal.EnergyHopperBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.ExtraBlock]: Internal.ExtraBlockItem, [key: Internal.BlockTile<any, any>]: Internal.ItemBlockTooltip<any>, [key: Internal.ToolboxBlock]: Internal.UncontainableBlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGWallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.BuddingCrystalBlock]: Internal.CrystalBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.FurnatorBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.RazorWireBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: com.simibubi.create.content.decoration.MetalLadderBlock]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.FlowerableBushBlock]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.KitchenFloorBlock]: Internal.BlockItem, [key: Internal.CoralFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.BrickBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.RedstonePillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: blusunrize.immersiveengineering.common.blocks.generic.ScaffoldingBlock]: Internal.BlockItemIE, [key: Internal.BaseCoralWallFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.LadderBlock]: Internal.ForgeBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBannerBlock]: Internal.BannerItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.EnergyCrystal]: Internal.ItemBlockBCore, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FurnatorBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.CandleBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SmallAdvPatternProviderBlock]: Internal.AEBaseBlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FeedingTroughBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DropExperienceBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.NonMirrorableWithActiveBlock<any>]: Internal.MultiblockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.BlockCableExport]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.JAOPCABlock]: Internal.JAOPCABlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.ConveyorBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SinkBlock]: Internal.BlockItem, [key: cy.jdkdigital.utilitarian.common.block.SnadBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CryingObsidianBlock]: Internal.BlockItem, [key: Internal.HugeMushroomBlock]: Internal.BlockItem, [key: Internal.WeatheringCopperFullBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.EnergyCrystal]: Internal.ItemBlockBCore, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.ToolboxBlock]: Internal.UncontainableBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.HammockBlock]: Internal.HammockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.WaterlilyBlock]: Internal.PlaceOnWaterBlockItem, [key: Internal.FluidPipeBlock]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.BrittleSandstoneBlock]: Internal.BlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.EnergizingRodBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ConcretePowderBlock]: Internal.BlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: blusunrize.immersiveengineering.common.blocks.generic.ScaffoldingBlock]: Internal.BlockItemIE, [key: Internal.WWGTrappedChestBlock]: Internal.ForgeChestItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FallingDamageBlock]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.PillarBlock]: Internal.PillarBlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ConduitBlock]: Internal.BlockItem, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.BambooStalkBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.WWGBarrelBlock]: Internal.ForgeBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WeatheringCopperStairBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MultiblockPartBlock$WithMirrorState<any>]: Internal.MultiblockItem, [key: Internal.ElevatorPulleyBlock]: Internal.BlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.CampfireBlock]: Internal.BlockItem, [key: Internal.FusionCraftingCore]: Internal.ItemBlockBCore, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.MudBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.StainedGlassBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FallingDamageBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WeatheringCopperFullBlock]: Internal.BlockItem, [key: Internal.BlockLogisticalTransporter]: Internal.ItemBlockLogisticalTransporter, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.ConcretePowderBlock]: Internal.BlockItem, [key: Internal.PlayerTransmitterBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.ApothSugarcaneBlock]: Internal.PlaceboUtil$1, [key: Internal.Block]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FramedLightBlock]: Internal.FramedLightBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.WWGBarrelBlock]: Internal.ForgeBlockItem, [key: Internal.MonitorBlock<any>]: Internal.AEBaseBlockItem, [key: Internal.IceBlock]: Internal.BlockItem, [key: Internal.TrackBlock]: Internal.TrackBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BuddingCrystalBlock]: Internal.CrystalBlockItem, [key: Internal.LavaCauldronBlock]: Internal.Items$1, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.WWGBarrelBlock]: Internal.ForgeBlockItem, [key: Internal.BlockBasicMultiblock<any>]: Internal.ItemBlockTooltip<any>, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.WeatheringCopperFullBlock]: Internal.BlockItem, [key: Internal.BasicConnectorBlock<any>]: Internal.BlockItemIE, [key: Internal.IEWallBlock]: Internal.BlockItemIE, [key: Internal.DoorBlock]: Internal.BlockItem, [key: Internal.ShulkerBoxBlock]: Internal.BlockItem, [key: Internal.BWGCeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MechanicalPistonBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ChainBlock]: Internal.BlockItem, [key: Internal.DoorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ToolboxBlock]: Internal.UncontainableBlockItem, [key: Internal.HammockBlock]: Internal.HammockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SailBlock]: Internal.BlankSailBlockItem, [key: Internal.TimberFrameBlock]: Internal.TimberFrameBlockItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.NetherrackBlock]: Internal.BlockItem, [key: Internal.SandBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGCraftingTable]: Internal.BlockItem, [key: Internal.ApothEnchantBlock]: Internal.PlaceboUtil$1, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.MolecularAssemblerBlock]: Internal.AEBaseBlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ShulkerBoxBlock]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.BeaconBlock]: Internal.BlockItem, [key: Internal.StandingSignBlock]: Internal.SignItem, [key: Internal.CandleBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.BWGCeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MechanicalCrafterBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DrillBlock]: Internal.MultiBlockItem, [key: Internal.EnergyCellBlock]: Internal.EnergyCellItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.AnvilBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.BedBlock]: Internal.BedItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.EnchantmentTableBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BuddingAmethystBlock]: Internal.BlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.ShulkerBoxBlock]: Internal.BlockItem, [key: Internal.AquaticTorchBlock]: Internal.StandingAndWallBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.SkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.WWGBarrelBlock]: Internal.ForgeBlockItem, [key: Internal.BaseCoralFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BrickBlock]: Internal.BlockItem, [key: Internal.CopperButtonBlock]: Internal.BlockItem, [key: Internal.ThermoBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SolicitingCarpet]: Internal.BlockItem, [key: Internal.SkyChestBlock]: Internal.AEBaseBlockItem, [key: Internal.SoulSandBlock]: Internal.BlockItem, [key: Internal.BlockTile<any, any>]: Internal.ItemBlockMachine, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.BuddingCrystalBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.InfestedBlock]: Internal.BlockItem, [key: Internal.ElectricLanternBlock]: Internal.BlockItemIE, [key: Internal.IEStairsBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGCraftingTable]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.BaseCoralPlantBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SporeBlossomBlock]: Internal.BlockItem, [key: Internal.BeehiveBlock]: Internal.BlockItem, [key: Internal.BlockRotatableHorizontalShaped]: Internal.ItemBundleOfTimber, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PoweredRailBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: blusunrize.immersiveengineering.common.blocks.metal.FluidPipeBlock]: Internal.BlockItemIE, [key: Internal.CorruptedSoulSand]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockMachine, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.MobFarmTemplateBlock]: Internal.MobFarmTemplateItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TimberFrameBlock]: Internal.TimberFrameBlockItem, [key: Internal.CandleBlock]: Internal.BlockItem, [key: Internal.LightningRodBlock]: Internal.BlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.WallBannerBlock]: Internal.BannerItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.BWGStandingSignBlock]: Internal.SignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.GardenBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StainedGlassPaneBlock]: Internal.BlockItem, [key: Internal.BWGQuickSand]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AEDecorativeBlock]: Internal.AEBaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBannerBlock]: Internal.BannerItem, [key: Internal.DepotBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.BWGStandingSignBlock]: Internal.SignItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.WeatheringCopperStairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.InfestedBlock]: Internal.BlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LadderBlock]: Internal.ForgeBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGStandingSignBlock]: Internal.SignItem, [key: Internal.MultiblockPartBlock$WithMirrorState<any>]: Internal.MultiblockItem, [key: Internal.PiglinWallSkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.SlidingDoorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.IEEntityBlock<any>]: Internal.BlockItemCapacitor, [key: Internal.CeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.WWGTrappedChestBlock]: Internal.ForgeChestItem, [key: Internal.StainedGlassPaneBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WWGChestBlock]: Internal.ForgeChestItem, [key: Internal.CoralWallFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.DropperBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ConnectedGlassBlock]: Internal.BlockItem, [key: Internal.LimitedBarrelBlock]: Internal.BarrelBlockItem, [key: Internal.BWGCeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.ElevatorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FloatingCarpetBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.ExtraBlock]: Internal.ExtraBlockItem, [key: Internal.ConnectedGlassPaneBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.HayBlock]: Internal.BlockItem, [key: Internal.ReactorBlock]: Internal.ReactorItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CertusQuartzClusterBlock]: Internal.AEBaseBlockItem, [key: Internal.DritBlock]: Internal.BlockItem, [key: Internal.WallSkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.BWGForgeFarmLandBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.BuddingCrystalBlock]: Internal.CrystalBlockItem, [key: Internal.ChainDriveBlock]: Internal.BlockItem, [key: Internal.ApothAnvilBlock]: Internal.ApothAnvilItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.SnailEggBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.BWGWallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.CraftingUnitBlock]: Internal.MEGACraftingBlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.ShulkerBoxBlock]: Internal.BlockItem, [key: Internal.JAOPCABlock]: Internal.JAOPCABlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CampfireBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FallingDamageBlock]: Internal.BlockItem, [key: Internal.OvenBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.TimberFrameBlock]: Internal.TimberFrameBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WeatheringCopperStairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBannerBlock]: Internal.BannerItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.BWGCraftingTable]: Internal.BlockItem, [key: Internal.TrainTrapdoorBlock]: Internal.BlockItem, [key: Internal.ConnectedGlassPaneBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.NonMirrorableWithActiveBlock<any>]: Internal.MultiblockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockBasicMultiblock<any>]: Internal.ItemBlockTooltip<any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SleepingBagBlock]: Internal.SleepingBagItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StainedGlassBlock]: Internal.BlockItem, [key: Internal.TypedShelfBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGSpreadableBlock]: Internal.BlockItem, [key: Internal.SeatBlock]: Internal.BlockItem, [key: Internal.MultiblockPartBlock<any>]: Internal.MultiblockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockCardboardBox]: Internal.ItemBlockCardboardBox, [key: Internal.SeatBlock]: Internal.BlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.CoralWallFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.MagmatorBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.BlockFactoryMachine<any, any>]: Internal.ItemBlockMachine, [key: Internal.DyedOvenBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CableBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.BeltBlock]: Internal.BeltConnectorItem, [key: Internal.WindowBlock]: Internal.BlockItem, [key: Internal.TripWireBlock]: Internal.ItemNameBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DropExperienceBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallSignBlock]: Internal.SignItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CraftingMonitorBlock]: Internal.CraftingBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.BedBlock]: Internal.BedItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.CandleBlock]: Internal.BlockItem, [key: Internal.SolicitingCarpet]: Internal.BlockItem, [key: Internal.JAOPCABlock]: Internal.JAOPCABlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BreakerSwitchBlock<any>]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FilteringShelfBlock]: Internal.BlockItem, [key: Internal.OxidizableButtonBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SnadBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: blusunrize.immersiveengineering.common.blocks.metal.SampleDrillBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.EnergyHopperBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.BlockFactoryMachine<any, any>]: Internal.ItemBlockMachine, [key: Internal.FancyTrapdoorBlock]: Internal.FancyTrapdoorBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.CGPaneBlock]: Internal.BaseBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BWGCraftingTable]: Internal.BlockItem, [key: Internal.BWGLeavesBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BuddingCertusQuartzBlock]: Internal.AEBaseBlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.LadderBlock]: Internal.ForgeBlockItem, [key: Internal.CoralFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.FramedLightBlock]: Internal.FramedLightBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.FallingDamageBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.ShrubBlock]: Internal.BlockItem, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockQIOComponent, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.ToolboxBlock]: Internal.UncontainableBlockItem, [key: Internal.ShulkerBoxBlock]: Internal.BlockItem, [key: Internal.GlazedTerracottaBlock]: Internal.BlockItem, [key: Internal.BlockBase<any>]: Internal.ItemBlockTooltip<any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CocoaBlock]: Internal.ItemNameBlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BasicConnectorBlock<any>]: Internal.BlockItemIE, [key: Internal.MossBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Generator]: Internal.ItemBlockBCore, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.TemplateManager]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CandleBlock]: Internal.BlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BuddingCrystalBlock]: Internal.CrystalBlockItem, [key: Internal.SolicitingCarpet]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WeatheringCopperSlabBlock]: Internal.BlockItem, [key: Internal.WWGTrappedChestBlock]: Internal.ForgeChestItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CuckooClockBlock]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.WWGBarrelBlock]: Internal.ForgeBlockItem, [key: Internal.CGColoredTintedGlassBlock]: Internal.BaseBlockItem, [key: Internal.ExtraBlock]: Internal.ExtraBlockItem, [key: Internal.DeskBlock<any>]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGBonemealableFlowerBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.BlockResource]: Internal.ItemBlockResource, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WoolCarpetBlock]: Internal.BlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.BedBlock]: Internal.BedItem, [key: Internal.SoulSandBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockTile<any, any>]: Internal.ItemBlockInductionProvider, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: com.ldtteam.domumornamentum.block.decorative.BarrelBlock]: Internal.BlockItem, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockQIOComponent, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBannerBlock]: Internal.BannerItem, [key: Internal.WetSpongeBlock]: Internal.BlockItem, [key: Internal.BaseCoralWallFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.StandingSignBlock]: Internal.SignItem, [key: Internal.ReactorBlock]: Internal.ReactorItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.InterfaceBlock]: Internal.AEBaseBlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.FenceBlock]: Internal.BlockItemIE, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock]: Internal.ChestBlockItem, [key: Internal.NetherWartBlock]: Internal.ItemNameBlockItem, [key: Internal.WWGChestBlock]: Internal.ForgeChestItem, [key: Internal.EncasedShaftBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGWallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WeatheringCopperFullBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PortableEnergyInterfaceBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.ValveHandleBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockRotatableHorizontalShaped]: Internal.ItemBundleOfTimber, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockBasicMultiblock<any>]: Internal.ItemBlockTooltip<any>, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: com.supermartijn642.chunkloaders.ChunkLoaderBlock]: Internal.BaseBlockItem, [key: Internal.BuddingCrystalBlock]: Internal.CrystalBlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.RedstoneLampBlock]: Internal.BlockItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.CopperButtonBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BlockTile<any, any>]: Internal.ItemBlockInductionProvider, [key: Internal.LadderBlock]: Internal.ForgeBlockItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.BuddingCertusQuartzBlock]: Internal.AEBaseBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.EncasedCogwheelBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LoomBlock]: Internal.BlockItem, [key: net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock]: Internal.ChestBlockItem, [key: Internal.DoorBlock]: Internal.BlockItem, [key: Internal.LadderBlock]: Internal.ForgeBlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TypedShelfBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.LadderBlock]: Internal.ForgeBlockItem, [key: Internal.DropExperienceBlock]: Internal.BlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.BWGWallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockTile<any, any>]: Internal.ItemBlockMachine, [key: Internal.EnergyCrystal]: Internal.ItemBlockBCore, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.ValveHandleBlock]: Internal.BlockItem, [key: Internal.WallBannerBlock]: Internal.BannerItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.WaterWheelBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.BlockCustomStairs]: Internal.BlockItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.WWGChestBlock]: Internal.ForgeChestItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPressurizedTube]: Internal.ItemBlockPressurizedTube, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.WindowBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SeatBlock]: Internal.BlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.WoolCarpetBlock]: Internal.BlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.AEDecorativeBlock]: Internal.AEBaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FloweringBushBlock]: Internal.BlockItem, [key: Internal.LadderBlock]: Internal.ForgeBlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.SharestoneBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StainedGlassBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.EnergyDischargerBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.StainedGlassPaneBlock]: Internal.BlockItem, [key: Internal.BlockBounding]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.MobFarmTemplateBlock]: Internal.MobFarmTemplateItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ValveHandleBlock]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DoorBlock]: Internal.DoubleHighBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPaperLantern]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.LimitedBarrelBlock]: Internal.BarrelBlockItem, [key: Internal.BlockTile<any, any>]: Internal.ItemBlockInductionProvider, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CraftingUnitBlock]: Internal.AEBaseBlockItem, [key: Internal.MobFarmBlockWrapper]: Internal.MobFarmBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TransformerHVBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WeatheringCopperFullBlock]: Internal.BlockItem, [key: Internal.DoorBlock]: Internal.DoubleHighBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.StageBarrierBlock]: Internal.StageBarrierBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SharestoneBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.IEStairsBlock]: Internal.BlockItemIE, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.JAOPCABlock]: Internal.JAOPCABlockItem, [key: Internal.AAECraftingUnitBlock]: Internal.AAECraftingBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StainedGlassPaneBlock]: Internal.BlockItem, [key: Internal.WormFarmBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.ShingleBlock]: Internal.ShingleBlockItem, [key: Internal.PinkPetalsBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BannerBlock]: Internal.BannerItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.CasingBlock]: Internal.BlockItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.PillarBlock]: Internal.PillarBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGWallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.FurnatorBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.ThermoBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WWGBarrelBlock]: Internal.ForgeBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.FallingDamageBlock]: Internal.BlockItem, [key: Internal.BWGCraftingTable]: Internal.BlockItem, [key: Internal.BasicConnectorBlock<any>]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WWGChestBlock]: Internal.ForgeChestItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PortableStorageInterfaceBlock]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BrickBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BuddingCertusQuartzBlock]: Internal.AEBaseBlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.BlockCompressedStone]: Internal.BlockItem, [key: Internal.SequencedGearshiftBlock]: Internal.BlockItem, [key: Internal.BWGCraftingTable]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ValveHandleBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CubeGeneratorBlock]: Internal.AEBaseBlockItem, [key: Internal.WeatheringCopperSlabBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockCompressedStone]: Internal.BlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ChorusFlowerBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallSignBlock]: Internal.SignItem, [key: Internal.ElevatorBlock]: Internal.BlockItem, [key: Internal.BlastFurnaceBlock]: Internal.BlockItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: com.simibubi.create.content.kinetics.drill.DrillBlock]: Internal.BlockItem, [key: Internal.CoralBlock]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGTallFlowerBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.DoorBlock]: Internal.DoubleHighBlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockThermodynamicConductor]: Internal.ItemBlockThermodynamicConductor, [key: Internal.LimitedBarrelBlock]: Internal.BarrelBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DropExperienceBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ConnectedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.QuartzGlassBlock]: Internal.BlockItem, [key: Internal.BlockCable]: Internal.BlockItem, [key: Internal.ClockworkBearingBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.SpatialPylonBlock]: Internal.AEBaseBlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.StainedGlassPaneBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.TrackObserverBlock]: Internal.TrackTargetingBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.FertilizedFarmlandBlock]: Internal.BlockItem, [key: Internal.WeatheringCopperStairBlock]: Internal.BlockItem, [key: Internal.NetherrackBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.BrushableBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ClocheBlock]: Internal.BlockItemIE, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FallingDamageBlock]: Internal.BlockItem, [key: Internal.LimitedBarrelBlock]: Internal.BarrelBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PistonBaseBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.HammockBlock]: Internal.HammockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RedstoneLinkBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CommandBlock]: Internal.GameMasterBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AllBrickStairBlock]: Internal.AllBrickStairBlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGWallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.GardenBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockGlassSlab]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ExtraBlock]: Internal.ExtraBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DropExperienceBlock]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StandingSignBlock]: Internal.SignItem, [key: Internal.ElevatorContactBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.FungusBlock]: Internal.BlockItem, [key: Internal.ShulkerBoxBlock]: Internal.BlockItem, [key: Internal.BWGPlacementBushBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BWGTallFlowerBlockTreeGrower]: Internal.BlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WeatheringCopperStairBlock]: Internal.BlockItem, [key: Internal.IEStairsBlock]: Internal.BlockItemIE, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.WWGTrappedChestBlock]: Internal.ForgeChestItem, [key: Internal.WWGChestBlock]: Internal.ForgeChestItem, [key: Internal.CarvedPumpkinBlock]: Internal.BlockItem, [key: Internal.InfestedBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.ItemDrainBlock]: Internal.BlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.BoneMealGrassBlock]: Internal.BlockItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.SolicitingCarpet]: Internal.BlockItem, [key: Internal.BlockBin]: Internal.ItemBlockBin, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.HugeMushroomBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BannerBlock]: Internal.BannerItem, [key: Internal.AmethystClusterBlock]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.EnergyDischargerBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.GlassBlock]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.GirderBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CabinetBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockLightSwitch]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.GlazedTerracottaBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LargeWaterWheelBlock]: Internal.LargeWaterWheelBlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.WWGTrappedChestBlock]: Internal.ForgeChestItem, [key: Internal.BaseCoralFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MillstoneBlock]: Internal.BlockItem, [key: Internal.BrassDiodeBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.SleepingBagBlock]: Internal.SleepingBagItem, [key: net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock]: Internal.ChestBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.SoulSnadBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.PoisonIvyBlock]: Internal.BlockItem, [key: Internal.StainedGlassPaneBlock]: Internal.BlockItem, [key: net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock]: Internal.ChestBlockItem, [key: Internal.StandingSignBlock]: Internal.SignItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PricklyPeachCactusBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.SolicitingCarpet]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SculkSensorBlock]: Internal.BlockItem, [key: Internal.SandBlock]: Internal.BlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.StorageLinkBlock]: Internal.BlockItemBase, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGWallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGCeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.StainedGlassPaneBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AAECraftingUnitBlock]: Internal.AAECraftingBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.MEGAPatternProviderBlock]: Internal.MEGAPatternProviderBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.EnderCellBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.IEStairsBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AAECraftingUnitBlock]: Internal.AAECraftingBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.BlockTile<any, any>]: Internal.ItemBlockMachine, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PlacardBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.BlockOre]: Internal.ItemBlockTooltip<any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CondenserBlock]: Internal.AEBaseBlockItem, [key: Internal.RoseQuartzLampBlock]: Internal.BlockItem, [key: Internal.GlassPaneBlock]: Internal.BlockItem, [key: Internal.AAECraftingUnitBlock]: Internal.AAECraftingBlockItem, [key: Internal.CookingTableBlock]: Internal.BlockItem, [key: Internal.LimitedBarrelBlock]: Internal.BarrelBlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.SoulSandBlock]: Internal.BlockItem, [key: Internal.FallingDamageBlock]: Internal.BlockItem, [key: Internal.BWGStandingSignBlock]: Internal.SignItem, [key: Internal.StructuralArmBlock]: Internal.BlockItemIE, [key: Internal.DriveBlock]: Internal.AEBaseBlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.BrassFunnelBlock]: Internal.FunnelItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BiomassPelletBlock, [key: Internal.BannerBlock]: Internal.BannerItem, [key: Internal.RootsBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MushroomBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.LargeConnectorBlock]: Internal.BlockItem, [key: Internal.MangrovePropaguleBlock]: Internal.BlockItem, [key: Internal.DoorBlock]: Internal.DoubleHighBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PistonBaseBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.BWGLeavesBlock]: Internal.BlockItem, [key: Internal.ExperienceBlock]: Internal.BlockItem, [key: Internal.WeatheringCopperStairBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.GantryShaftBlock]: Internal.BlockItem, [key: Internal.BannerBlock]: Internal.BannerItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DragonEggBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.CandleBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SandBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.NyliumBlock]: Internal.BlockItem, [key: Internal.LayeredCauldronBlock]: Internal.Items$1, [key: Internal.EncasedCogwheelBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: appeng.block.storage.ChestBlock]: Internal.AEBaseBlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.LadderBlock]: Internal.ForgeBlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.GlazedTerracottaBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.EnderCellBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MultiblockPartBlock$WithMirrorState<any>]: Internal.MultiblockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.StabilizedSpawner]: Internal.ItemBlockBCore, [key: Internal.BWGWallSignBlock]: Internal.SignItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SkyChestBlock]: Internal.AEBaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ExtraBlock]: Internal.ExtraBlockItem, [key: Internal.HempBlock]: Internal.IESeedItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.FloatingCarpetBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockEnergyCube]: Internal.ItemBlockEnergyCube, [key: Internal.WindowBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.SailBlock]: Internal.BlankSailBlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.HangingRootsBlock]: Internal.BlockItem, [key: com.ldtteam.domumornamentum.block.vanilla.SlabBlock]: Internal.SlabBlockItem, [key: Internal.ReactorCore]: Internal.ItemBlockBCore, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RootedDirtBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.WallBannerBlock]: Internal.BannerItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: blusunrize.immersiveengineering.common.blocks.generic.ScaffoldingBlock]: Internal.BlockItemIE, [key: Internal.TypedShelfBlock]: Internal.BlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.StainedGlassBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.BWGCraftingTable]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.BuddingCrystalBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockSecurityDesk, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BWGCeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.InfestedBlock]: Internal.BlockItem, [key: Internal.LightningRodBlock]: Internal.BlockItem, [key: Internal.SolicitingCarpet]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.WindowBlock]: Internal.BlockItem, [key: Internal.ConnectedPillarBlock]: Internal.BlockItem, [key: net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock]: Internal.BarrelBlockItem, [key: Internal.DoorBlock]: Internal.BlockItem, [key: Internal.WindmillBearingBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.RespawnAnchorBlock]: Internal.BlockItem, [key: Internal.LimitedBarrelBlock]: Internal.BarrelBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.CertusQuartzClusterBlock]: Internal.AEBaseBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.InfestedBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.BedBlock]: Internal.BedItem, [key: Internal.MEGAInterfaceBlock]: Internal.AEBaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SolicitingCarpet]: Internal.BlockItem, [key: Internal.FrostLilyBlock]: Internal.BlockItem, [key: Internal.OxidizableLightningRodBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.CattailBlock]: Internal.BlockItem, [key: Internal.EnergyCrystal]: Internal.ItemBlockBCore, [key: Internal.Block]: Internal.BlockItem, [key: Internal.GlassBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock]: Internal.ChestBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockLogisticalSorter]: Internal.ItemBlockMachine, [key: Internal.Block]: Internal.BlockItem, [key: Internal.EnergizingRodBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.KitchenFloorBlock]: Internal.BlockItem, [key: Internal.ModularAccumulatorBlock]: Internal.ModularAccumulatorBlockItem, [key: Internal.BWGCeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.WeatheringCopperSlabBlock]: Internal.BlockItem, [key: Internal.SolarBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.MetalLadderBlock]: Internal.BlockItemIE, [key: Internal.ApothCactusBlock]: Internal.PlaceboUtil$1, [key: Internal.JAOPCABlock]: Internal.JAOPCABlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockMachine, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.GlazedTerracottaBlock]: Internal.BlockItem, [key: Internal.HalfTransparentBlock]: Internal.BlockItem, [key: net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock]: Internal.ShulkerBoxItem, [key: Internal.BWGStandingSignBlock]: Internal.SignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.WWGTrappedChestBlock]: Internal.ForgeChestItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SeatBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.ChrysalisBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FloatingCarpetBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BrassCubeBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.BWGStandingSignBlock]: Internal.SignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WeatheringCopperFullBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.BlockLogisticalTransporter]: Internal.ItemBlockLogisticalTransporter, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ToolboxBlock]: Internal.UncontainableBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.BuddingCrystalBlock]: Internal.CrystalBlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.BlockCompressedStone]: Internal.BlockItem, [key: Internal.IEStairsBlock]: Internal.BlockItemIE, [key: Internal.TorchflowerCropBlock]: Internal.ItemNameBlockItem, [key: Internal.HangingCornerBlock]: Internal.BlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.HauntedBellBlock]: Internal.BlockItem, [key: Internal.WoolCarpetBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.BlockOre]: Internal.ItemBlockTooltip<any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGCeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.BWGStandingSignBlock]: Internal.SignItem, [key: Internal.SleepingBagBlock]: Internal.SleepingBagItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BaseCoralFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.BlockDiversionTransporter]: Internal.ItemBlockDiversionTransporter, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBannerBlock]: Internal.BannerItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ScaffoldingBlock]: Internal.ScaffoldingBlockItem, [key: Internal.SailBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.BlockFactoryMachine<any, any>]: Internal.ItemBlockMachine, [key: Internal.SchematicTableBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BeetrootBlock]: Internal.ItemNameBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BWGWallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.IEEntityBlock<any>]: Internal.BlockItemIE, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.ValveHandleBlock]: Internal.BlockItem, [key: Internal.HorizontalFacingEntityBlock<any>]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PlayerTransmitterBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.RainSensor]: Internal.ItemBlockBCore, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.TerminalBlock<any>]: Internal.AEBaseBlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.CogWheelBlock]: Internal.CogwheelBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TimberFrameBlock]: Internal.TimberFrameBlockItem, [key: Internal.BaseCoralPlantBlock]: Internal.BlockItem, [key: Internal.DimChest]: Internal.ItemDimBase, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WWGChestBlock]: Internal.ForgeChestItem, [key: Internal.MobFarmBlockWrapper]: Internal.MobFarmBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.OxidizableLightningRodBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.NoSolicitingWallBanner]: Internal.BannerItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CraftingUnitBlock]: Internal.MEGACraftingBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockMachine, [key: Internal.IEEntityBlock<any>]: Internal.BlockItemIE, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.ArchitectsCutterBlock]: Internal.BlockItem, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockLaserAmplifier, [key: Internal.HammockBlock]: Internal.HammockItem, [key: Internal.LootrChestBlock]: Internal.LootrChestBlockItem, [key: Internal.LadderBlock]: Internal.ForgeBlockItem, [key: Internal.KitchenFloorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BrassTunnelBlock]: Internal.BeltTunnelItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.ConnectedGlassBlock]: Internal.BlockItem, [key: Internal.EnergyCrystal]: Internal.ItemBlockBCore, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.MultiblockPartBlock<any>]: Internal.MultiblockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CraftingUnitBlock]: Internal.MEGACraftingBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.LadderBlock]: Internal.ForgeBlockItem, [key: Internal.MobFarmBlockWrapper]: Internal.MobFarmBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.SmartChuteBlock]: Internal.BlockItem, [key: Internal.BWGDirtPathBlock]: Internal.BlockItem, [key: Internal.IronBarsBlock]: Internal.BlockItem, [key: Internal.LightBlock]: Internal.BlockItem, [key: Internal.BasicConnectorBlock<any>]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.SmallLightConnectorBlock]: Internal.BlockItem, [key: Internal.EncasedShaftBlock]: Internal.BlockItem, [key: Internal.DetectorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SailBlock]: Internal.BlankSailBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FluidTankBlock]: Internal.FluidTankItem, [key: Internal.TaskScreenBlock]: Internal.ScreenBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TorchBlock]: Internal.StandingAndWallBlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.ElevatorBlock]: Internal.BlockItem, [key: Internal.StandingSignBlock]: Internal.SignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StainedGlassBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: blusunrize.immersiveengineering.common.blocks.wooden.CraftingTableBlock]: Internal.BlockItemIE, [key: Internal.ConnectedGlassPaneBlock]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.WeatheringCopperFullBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.BlockCompressedStone]: Internal.BlockItem, [key: Internal.SeatBlock]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.SeatBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.AAECraftingUnitBlock]: Internal.AAECraftingBlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.BrickBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGWallSignBlock]: Internal.SignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WeatheringCopperStairBlock]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.WallSignBlock]: Internal.SignItem, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockMachine, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.FallingDamageBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.HammockBlock]: Internal.HammockItem, [key: Internal.CraftingInjector]: Internal.ItemBlockBCore, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGWallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.CeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.BlockCableImportFilter]: Internal.BlockItem, [key: Internal.ShulkerBoxBlock]: Internal.BlockItem, [key: Internal.PartialConcreteBlock]: Internal.BlockItemIE, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.ChestBlock]: Internal.BlockItem, [key: Internal.MetalScaffoldingBlock]: Internal.MetalScaffoldingBlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MultiblockPartBlock<any>]: Internal.MultiblockItem, [key: Internal.ExtraBlock]: Internal.ExtraBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DropExperienceBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.NetherrackBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CreativeCrateBlock]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SpatialIOPortBlock]: Internal.AEBaseBlockItem, [key: Internal.BuddingCrystalBlock]: Internal.CrystalBlockItem, [key: Internal.BlockGrassStairs]: Internal.BlockItem, [key: Internal.WaystoneBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.CGColoredTintedGlassBlock]: Internal.BaseBlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.BlockLogisticalTransporter]: Internal.ItemBlockLogisticalTransporter, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DoublePlantBlock]: Internal.BlockItem, [key: Internal.BuddingCrystalBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.IEStairsBlock]: Internal.BlockItemIE, [key: owmii.powah.lib.block.AbstractBlock<any, any>]: Internal.ItemBlock<any, any>, [key: Internal.BigDripleafStemBlock]: Internal.Items$1, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ComposterBlock]: Internal.BlockItem, [key: Internal.SolicitingCarpet]: Internal.BlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.CelestialManipulator]: Internal.ItemBlockBCore, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPressurizedTube]: Internal.ItemBlockPressurizedTube, [key: Internal.FloatingCarpetBlock]: Internal.BlockItem, [key: Internal.IEStairsBlock]: Internal.BlockItemIE, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.IronBarsBlock]: Internal.BlockItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.BWGCeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.SharestoneBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.FluidValveBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WWGTrappedChestBlock]: Internal.ForgeChestItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SleepingBagBlock]: Internal.SleepingBagItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MultiblockPartBlock$WithMirrorState<any>]: Internal.MultiblockItem, [key: Internal.EnergyDischargerBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.BWGMushroomBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WeatheringCopperStairBlock]: Internal.BlockItem, [key: Internal.TPSMeter]: Internal.TPSMeterItem, [key: Internal.CasingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LadderBlock]: Internal.ForgeBlockItem, [key: Internal.SailBlock]: Internal.BlankSailBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.IEStairsBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.StainedGlassBlock]: Internal.BlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.BaseCoralPlantBlock]: Internal.BlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.EnergyHopperBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SolicitingCarpet]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.DoorBlock]: Internal.BlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.WeatheringCopperStairBlock]: Internal.BlockItem, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.LadderBlock]: Internal.ForgeBlockItem, [key: Internal.BWGTallFlowerBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBannerBlock]: Internal.BannerItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.NetherrackBlock]: Internal.BlockItem, [key: Internal.ComparatorBlock]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.BWGWallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.BlockBasicMultiblock<any>]: Internal.ItemBlockTooltip<any>, [key: Internal.WaystoneBlock]: Internal.BlockItem, [key: Internal.WallSkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockQIOComponent$ItemBlockQIOInventoryComponent, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.BuddingCrystalBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ToolboxBlock]: Internal.UncontainableBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.EnergizingRodBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.ExtraBlock]: Internal.ExtraBlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGStandingSignBlock]: Internal.SignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MushroomBlock]: Internal.BlockItem, [key: Internal.QuantumCrafterBlock]: Internal.AEBaseBlockItem, [key: Internal.EnergyDischargerBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.BlockCustomWall]: Internal.BlockItem, [key: Internal.DoorBlock]: Internal.BlockItem, [key: Internal.EnergyAcceptorBlock]: Internal.AEBaseBlockItem, [key: Internal.FramedLightBlock]: Internal.FramedLightBlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DropExperienceBlock]: Internal.BlockItem, [key: Internal.BarrelBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock]: Internal.ShulkerBoxItem, [key: Internal.IceBlock]: Internal.BlockItem, [key: Internal.BWGWallSignBlock]: Internal.SignItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.GlazedTerracottaBlock]: Internal.BlockItem, [key: Internal.DyedOvenBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.DyedOvenBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.BWGForgeFarmLandBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockMachine, [key: Internal.WWGChestBlock]: Internal.ForgeChestItem, [key: Internal.EnderCellBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.DyedOvenBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MechanicalBearingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.SolicitingCarpet]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.DesertPlantBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.StainedGlassPaneBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WWGChestBlock]: Internal.ForgeChestItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: net.p3pp3rf1y.sophisticatedstorage.block.ControllerBlock]: Internal.BlockItemBase, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.PlayerTransmitterBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TortoiseEggBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: owmii.powah.lib.block.AbstractBlock<any, any>]: Internal.ItemBlock<any, any>, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DoorBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.ChorusPlantBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.EnergyDischargerBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.ReactorBlock]: Internal.ReactorItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockResource]: Internal.ItemBlockResource, [key: Internal.OxidizableLightningRodBlock]: Internal.BlockItem, [key: Internal.KitchenFloorBlock]: Internal.BlockItem, [key: Internal.LadderBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.BarrelCactusBlock]: Internal.BlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.CandleBlock]: Internal.BlockItem, [key: Internal.WWGTrappedChestBlock]: Internal.ForgeChestItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.ShingleBlock]: Internal.ShingleBlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.DoorBlock]: Internal.BlockItem, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockMachine, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BrickBlock]: Internal.BlockItem, [key: Internal.HosePulleyBlock]: Internal.BlockItem, [key: Internal.SolicitingCarpet]: Internal.BlockItem, [key: Internal.WeatheringCopperSlabBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.DyedOvenBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.IronBarsBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ConcretePowderBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WWGBarrelBlock]: Internal.ForgeBlockItem, [key: Internal.WoolCarpetBlock]: Internal.BlockItem, [key: Internal.BlockResource]: Internal.ItemBlockResource, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StainedGlassBlock]: Internal.BlockItem, [key: Internal.ConnectedPillarBlock]: Internal.BlockItem, [key: Internal.GrindstoneBlock]: Internal.BlockItem, [key: Internal.CuckooClockBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SolicitingCarpet]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SailBlock]: Internal.BlankSailBlockItem, [key: com.ldtteam.domumornamentum.block.decorative.BarrelBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGWallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.DislocatorPedestal]: Internal.ItemBlockBCore, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.JAOPCABlock]: Internal.JAOPCABlockItem, [key: Internal.FallingDamageBlock]: Internal.BlockItem, [key: Internal.SolarBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.Disenchanter]: Internal.ItemBlockBCore, [key: Internal.WoolCarpetBlock]: Internal.BlockItem, [key: Internal.BWGWallSignBlock]: Internal.SignItem, [key: Internal.AlligatorEggBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TypedShelfBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WindowBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.TimberFrameBlock]: Internal.TimberFrameBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.CakeBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BedBlock]: Internal.BedItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.BlockResource]: Internal.ItemBlockResource, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.BuddingCrystalBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.SchematicannonBlock]: Internal.BlockItem, [key: Internal.TallFlowerBlock]: Internal.DoubleHighBlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.FallingDamageBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.WaystoneBlock]: Internal.BlockItem, [key: Internal.CasingBlock]: Internal.BlockItem, [key: Internal.BlockCableLink]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AEDecorativeBlock]: Internal.BlockItem, [key: Internal.PistonExtensionPoleBlock]: Internal.BlockItem, [key: Internal.LimitedBarrelBlock]: Internal.BarrelBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.AnyFacingEntityBlock<any>]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockCompressedStone]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CGColoredTintedGlassBlock]: Internal.BaseBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.WWGTrappedChestBlock]: Internal.ForgeChestItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.BlockFactoryMachine<any, any>]: Internal.ItemBlockMachine, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BuddingCrystalBlock]: Internal.CrystalBlockItem, [key: Internal.ValveHandleBlock]: Internal.BlockItem, [key: Internal.WatermillBlock]: Internal.BlockItemIE, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.BlockRotatable]: Internal.ItemBlockWoodenCrate, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SolicitingCarpet]: Internal.BlockItem, [key: Internal.BlockMechanicalPipe]: Internal.ItemBlockMechanicalPipe, [key: com.brandon3055.draconicevolution.blocks.StructureBlock]: Internal.ItemBlockBCore, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: com.supermartijn642.chunkloaders.ChunkLoaderBlock]: Internal.BaseBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ReactorBlock]: Internal.ReactorItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.IEStairsBlock]: Internal.BlockItemIE, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.KitchenFloorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CrabEggBlock]: Internal.BlockItem, [key: Internal.BrickBlock]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.JetpackBlock]: Internal.BacktankItem$BacktankBlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SolicitingCarpet]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.CopperButtonBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.ExtraBlock]: Internal.ExtraBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGCraftingTable]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MagmatorBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.TreeBranchBlock]: Internal.BlockItem, [key: Internal.BuddingCrystalBlock]: Internal.CrystalBlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.SleepingBagBlock]: Internal.SleepingBagItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: com.ldtteam.domumornamentum.block.vanilla.StairBlock]: Internal.StairsBlockItem, [key: Internal.OxidizableButtonBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.FertilizedFarmlandBlock]: Internal.BlockItem, [key: Internal.IEEntityBlock<any>]: Internal.BlockItemCapacitor, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BigDripleafBlock]: Internal.Items$1, [key: Internal.BeehiveBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BlockPamLogFruit]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BlockPamLogFruit]: Internal.BlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StandingSignBlock]: Internal.SignItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.FruitBasketBlock]: Internal.BlockItem, [key: Internal.WWGTrappedChestBlock]: Internal.ForgeChestItem, [key: Internal.FluidHopperBlock]: Internal.BlockItem, [key: Internal.BWGStandingSignBlock]: Internal.SignItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.JukeboxBlock]: Internal.BlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.CGColoredTintedGlassBlock]: Internal.BaseBlockItem, [key: Internal.HammockBlock]: Internal.HammockItem, [key: Internal.AEDecorativeBlock]: Internal.AEBaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.EnchLibraryBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BeehiveBlock]: Internal.BlockItem, [key: Internal.FramedLightBlock]: Internal.FramedLightBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockResource]: Internal.ItemBlockResource, [key: Internal.DesertPlantBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.FloatingCarpetBlock]: Internal.BlockItem, [key: Internal.ConveyorBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TorchBlock]: Internal.StandingAndWallBlockItem, [key: Internal.NozzleBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGWallSignBlock]: Internal.SignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ConcretePowderBlock]: Internal.BlockItem, [key: Internal.TypedShelfBlock]: Internal.BlockItem, [key: Internal.SkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock]: Internal.BarrelBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.BrewingStandBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WWGBarrelBlock]: Internal.ForgeBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CableBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ShulkerBoxBlock]: Internal.BlockItem, [key: Internal.BWGTallFlowerBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGStandingSignBlock]: Internal.SignItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.GlazedTerracottaBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.BrassDiodeBlock]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.BlockBoundary]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AEDecorativeBlock]: Internal.AEBaseBlockItem, [key: Internal.HydrangeaBushBlock]: Internal.BlockItem, [key: Internal.DraconiumBlock]: Internal.ItemBlockBCore, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.ReactorBlock]: Internal.ReactorItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.MultiblockPartBlock$WithMirrorState<any>]: Internal.MultiblockItem, [key: Internal.AzaleaBlock]: Internal.BlockItem, [key: Internal.StandingSignBlock]: Internal.SignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ElevatorBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.ValveHandleBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PillarBlock]: Internal.PillarBlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockResource]: Internal.ItemBlockResource, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.SeagrassBlock]: Internal.BlockItem, [key: Internal.BedBlock]: Internal.BedItem, [key: Internal.AAECraftingUnitBlock]: Internal.AAECraftingBlockItem, [key: Internal.TrashCanBlock]: Internal.BaseBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DispenserBlock]: Internal.BlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MonitorBlock<any>]: Internal.AEBaseBlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockStructuralGlass<any>]: Internal.ItemBlockTooltip<any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DraconiumOre]: Internal.ItemBlockBCore, [key: Internal.CowJarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.SpeedControllerBlock]: Internal.BlockItem, [key: owmii.powah.lib.block.AbstractBlock<any, any>]: Internal.ItemBlock<any, any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LadderBlock]: Internal.ForgeBlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGFruitLeavesBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.TallFlowerBlock]: Internal.DoubleHighBlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.DoublePlantBlock]: Internal.DoubleHighBlockItem, [key: Internal.HammockBlock]: Internal.HammockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.WoolCarpetBlock]: Internal.BlockItem, [key: Internal.CandleBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockQIOComponent$ItemBlockQIOInventoryComponent, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WeatheringCopperFullBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.IEEntityBlock<any>]: Internal.BlockItemIE, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.BlockBin]: Internal.ItemBlockBin, [key: Internal.HammockBlock]: Internal.HammockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ValveHandleBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.WallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.IronBarsBlock]: Internal.BlockItem, [key: Internal.StainedGlassPaneBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.IEStairsBlock]: Internal.BlockItemIE, [key: Internal.StandingSignBlock]: Internal.SignItem, [key: Internal.WitherSkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.JAOPCABlock]: Internal.JAOPCABlockItem, [key: Internal.StainedGlassBlock]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockQuantumEntangloporter, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.WallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockRotatableHorizontalShaped]: Internal.ItemPileOfBricks, [key: Internal.DyedOvenBlock]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ParticleGenerator]: Internal.ItemBlockBCore, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.ShulkerBoxBlock]: Internal.BlockItem, [key: Internal.BedBlock]: Internal.BedItem, [key: Internal.TypedShelfBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.BlockBasicMultiblock<any>]: Internal.ItemBlockTooltip<any>, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.ExtraBlock]: Internal.ExtraBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WWGBarrelBlock]: Internal.ForgeBlockItem, [key: Internal.BlockFluidTank]: Internal.ItemBlockFluidTank, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BeehiveBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LootrTrappedChestBlock]: Internal.LootrChestBlockItem, [key: Internal.HugeMushroomBlock]: Internal.BlockItem, [key: Internal.ExtraBlock]: Internal.ExtraBlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.TypedShelfBlock$SculkShelfBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.DyedOvenBlock]: Internal.BlockItem, [key: Internal.PanelBlock]: Internal.PanelBlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.BlockUniversalCable]: Internal.ItemBlockUniversalCable, [key: Internal.BlockCableIO]: Internal.BlockItem, [key: Internal.CreativeEnergyBlock]: Internal.BlockItem, [key: Internal.LinearChassisBlock]: Internal.BlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.WWGChestBlock]: Internal.ForgeChestItem, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.LadderBlock]: Internal.ForgeBlockItem, [key: Internal.WallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SailBlock]: Internal.BlankSailBlockItem, [key: Internal.BlockFluidTank]: Internal.ItemBlockFluidTank, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockTile<any, any>]: Internal.ItemBlockInductionCell, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.SleepingBagBlock]: Internal.SleepingBagItem, [key: Internal.DeskBlock<any>]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MatrixFrameBlock]: Internal.AEBaseBlockItem, [key: Internal.CraftingUnitBlock]: Internal.CraftingBlockItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.IEStairsBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.HammockBlock]: Internal.HammockItem, [key: Internal.SolicitingCarpet]: Internal.BlockItem, [key: Internal.EnergizingRodBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockTooltip<any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.NyliumBlock]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FertilizedFarmlandBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WWGBarrelBlock]: Internal.ForgeBlockItem, [key: Internal.BrushableBlock]: Internal.BlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.BWGStandingSignBlock]: Internal.SignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BannerBlock]: Internal.BannerItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.SharestoneBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.BlockPhasing]: Internal.BlockItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.CeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.OddionCrop]: Internal.ItemNameBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallSignBlock]: Internal.SignItem, [key: Internal.BracketBlock]: Internal.BracketBlockItem, [key: Internal.ConnectedPillarBlock]: Internal.BlockItem, [key: Internal.DropExperienceBlock]: Internal.BlockItem, [key: Internal.CopperButtonBlock]: Internal.BlockItem, [key: Internal.WeightedPressurePlateBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ConnectedGlassPaneBlock]: Internal.BlockItem, [key: Internal.ExtraBlock]: Internal.ExtraBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.ConnectedGlassPaneBlock]: Internal.BlockItem, [key: net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock]: Internal.ShulkerBoxItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.EnergyCrystal]: Internal.ItemBlockBCore, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockTile<any, any>]: Internal.ItemBlockMachine, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BannerBlock]: Internal.BannerItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MarketBlock]: Internal.BlockItem, [key: Internal.SeatBlock]: Internal.BlockItem, [key: Internal.BalloonBlock]: Internal.BlockItemBalloon, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.NetherrackBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ConcretePowderBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ReactionChamberBlock]: Internal.AEBaseBlockItem, [key: Internal.CoralFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.LootCrateOpenerBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ExtraBlock]: Internal.ExtraBlockItem, [key: Internal.MultiblockPartBlock$WithMirrorState<any>]: Internal.MultiblockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.SailBlock]: Internal.BlankSailBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MultiblockPartBlock<any>]: Internal.MultiblockItem, [key: Internal.CGColoredTintedGlassBlock]: Internal.BaseBlockItem, [key: Internal.CGGlassBlock]: Internal.BaseBlockItem, [key: Internal.ConveyorBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.BedBlock]: Internal.BedItem, [key: Internal.WallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ConnectedPillarBlock]: Internal.BlockItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.ExtraBlock]: Internal.ExtraBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DoorBlock]: Internal.BlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.EnergyCellBlock]: Internal.EnergyCellItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LadderBlock]: Internal.ForgeBlockItem, [key: Internal.RedstoneWallTorchBlock]: Internal.StandingAndWallBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockTooltip<any>, [key: Internal.BedBlock]: Internal.BedItem, [key: Internal.ValveHandleBlock]: Internal.BlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGMushroomBlock]: Internal.BlockItem, [key: Internal.BlockGlassStairs]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.BWGCeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockMachine, [key: Internal.ElevatorBlock]: Internal.BlockItem, [key: Internal.IEEntityBlock<any>]: Internal.BlockItemIE, [key: Internal.ConnectedGlassPaneBlock]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.WaterlilyBlock]: Internal.PlaceOnWaterBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockUniversalCable]: Internal.ItemBlockUniversalCable, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.DyedOvenBlock]: Internal.BlockItem, [key: Internal.StainedGlassPaneBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.QuartzFixtureBlock]: Internal.AEBaseBlockItem, [key: Internal.DoorBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.CGColoredTintedGlassBlock]: Internal.BaseBlockItem, [key: Internal.StainedGlassPaneBlock]: Internal.BlockItem, [key: Internal.CoralFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.SolarBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.SailBlock]: Internal.BlankSailBlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StandingSignBlock]: Internal.SignItem, [key: Internal.NeptunesBountyBlock]: Internal.BlockItemWithoutLevelRenderer, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBannerBlock]: Internal.BannerItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DraconiumOre]: Internal.ItemBlockBCore, [key: Internal.TypedShelfBlock]: Internal.BlockItem, [key: Internal.TypedShelfBlock]: Internal.BlockItem, [key: Internal.BWGChangingLeavesBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.ImbuedBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WWGChestBlock]: Internal.ForgeChestItem, [key: Internal.BWGWallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.TurtleEggBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.DislocatorReceptacle]: Internal.ItemBlockBCore, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.BWGWallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.MilkJarBlock]: Internal.BlockItem, [key: Internal.DoorBlock]: Internal.BlockItem, [key: Internal.FallingDamageBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.EntityBlockingLightBlock]: Internal.TMItemBlock, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockMachine, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.MechanicalMixerBlock]: Internal.AssemblyOperatorBlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.AnvilBlock]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.DropExperienceBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.GardenBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WWGBarrelBlock]: Internal.ForgeBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockBasicMultiblock<any>]: Internal.ItemBlockTooltip<any>, [key: Internal.ShulkerBoxBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LeverBlock]: Internal.BlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.TwistingVinesBlock]: Internal.BlockItem, [key: Internal.SandBlock]: Internal.BlockItem, [key: Internal.ConnectedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.CGColoredTintedGlassBlock]: Internal.BaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.MobFarmBlockWrapper]: Internal.MobFarmBlockItem, [key: Internal.LimitedBarrelBlock]: Internal.BarrelBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.GravelBlock]: Internal.BlockItem, [key: Internal.BannerBlock]: Internal.BannerItem, [key: Internal.BWGCeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.BlockBasicMultiblock<any>]: Internal.ItemBlockTooltip<any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FloatingCarpetBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.BlockResource]: Internal.ItemBlockResource, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockBCore]: Internal.ItemBlockBCore, [key: Internal.FurnaceHeaterBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LimitedBarrelBlock]: Internal.BarrelBlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.EncasedFanBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StainedGlassBlock]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.PricklyVinesBlock]: Internal.BlockItem, [key: Internal.TimberFrameBlock]: Internal.TimberFrameBlockItem, [key: Internal.SandBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RadialChassisBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TinySkullBlock]: Internal.BlockItem, [key: Internal.CGColoredTintedGlassBlock]: Internal.BaseBlockItem, [key: Internal.BlockUniversalCable]: Internal.ItemBlockUniversalCable, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.ChuteBlock]: Internal.ChuteItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.BaseCoralWallFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItemIE, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockMachine, [key: Internal.StainedGlassPaneBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.WeatheringCopperSlabBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.WWGTrappedChestBlock]: Internal.ForgeChestItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.BlockBasicMultiblock<any>]: Internal.ItemBlockTooltip<any>, [key: Internal.ExtraBlock]: Internal.ExtraBlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.MobFarmTemplateBlock]: Internal.MobFarmTemplateItem, [key: cy.jdkdigital.utilitarian.common.block.SnadBlock]: Internal.BlockItem, [key: Internal.CraftingUnitBlock]: Internal.AEBaseBlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockBasicMultiblock<any>]: Internal.ItemBlockTooltip<any>, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.CACakeBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ConnectedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ApothAnvilBlock]: Internal.ApothAnvilItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.BlockPamLogFruit]: Internal.BlockItem, [key: Internal.BannerBlock]: Internal.BannerItem, [key: Internal.ExtraBlock]: Internal.ExtraBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SmallConnectorBlock]: Internal.BlockItem, [key: Internal.BlockFactoryMachine<any, any>]: Internal.ItemBlockMachine, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.MobFarmBlockWrapper]: Internal.MobFarmBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.WoolCarpetBlock]: Internal.BlockItem, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.DoorBlock]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.AquaticWallTorchBlock]: Internal.StandingAndWallBlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.WWGTrappedChestBlock]: Internal.ForgeChestItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.WeightedPressurePlateBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.VineBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.BeehiveBlock]: Internal.BlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SolicitingCarpet]: Internal.BlockItem, [key: Internal.FramedLightBlock]: Internal.FramedLightBlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.HoneyBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGTallFlowerBlockTreeGrower]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FridgeBlock]: Internal.BlockItem, [key: Internal.EnergizingRodBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.IEWallBlock]: Internal.BlockItemIE, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.BWGCeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockMachine, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.LimitedBarrelBlock]: Internal.BarrelBlockItem, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockMachine, [key: Internal.WallSignBlock]: Internal.SignItem, [key: Internal.WWGChestBlock]: Internal.ForgeChestItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AllBrickStairBlock]: Internal.AllBrickStairBlockItem, [key: Internal.NixieTubeBlock]: Internal.BlockItem, [key: Internal.BWGCraftingTable]: Internal.BlockItem, [key: Internal.WWGBarrelBlock]: Internal.ForgeBlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockTile<any, any>]: Internal.ItemBlockMachine, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockCollection]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CraftingMonitorBlock]: Internal.MEGACraftingBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.EntityBlockingLightBlock]: Internal.TMItemBlock, [key: Internal.BlockRadioactiveWasteBarrel]: Internal.ItemBlockRadioactiveWasteBarrel, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DoorBlock]: Internal.BlockItem, [key: Internal.GlazedTerracottaBlock]: Internal.BlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.EndRodBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CrankBlock]: Internal.AEBaseBlockItem, [key: Internal.FertilizedFarmlandBlock]: Internal.BlockItem, [key: Internal.FlowGate]: Internal.ItemBlockBCore, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.BannerBlock]: Internal.BannerItem, [key: Internal.ElevatorBlock]: Internal.BlockItem, [key: Internal.WWGChestBlock]: Internal.ForgeChestItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.EnergyCellBlock]: Internal.EnergyCellItem, [key: Internal.WallmountBlock]: Internal.BlockItemIE, [key: Internal.BWGWallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.EnderGateBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.PaperWallBlock]: Internal.PaperwallBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WWGBarrelBlock]: Internal.ForgeBlockItem, [key: Internal.BlockBasicMultiblock<any>]: Internal.ItemBlockTooltip<any>, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock]: Internal.ShulkerBoxItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.WindowBlock]: Internal.BlockItem, [key: Internal.ThermoBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.StemBlock]: Internal.ItemNameBlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.BWGLeavesBlock]: Internal.BlockItem, [key: Internal.ItemVaultBlock]: Internal.ItemVaultItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGBerryBush]: Internal.ItemNameBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.MechanicalPressBlock]: Internal.AssemblyOperatorBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.BuddingCrystalBlock]: Internal.CrystalBlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LimitedBarrelBlock]: Internal.BarrelBlockItem, [key: Internal.DoorBlock]: Internal.DoubleHighBlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.CrushingWheelBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.QuantumRingBlock]: Internal.AEBaseBlockItem, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockMachine, [key: Internal.ConnectedGlassPaneBlock]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.BlockInventory]: Internal.BlockItem, [key: Internal.LadderBlock]: Internal.ForgeBlockItem, [key: Internal.PulleyBlock]: Internal.BlockItem, [key: Internal.PumpkinBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.CraftingTableBlock]: Internal.BlockItem, [key: blusunrize.immersiveengineering.common.blocks.metal.ChuteBlock]: Internal.BlockItemIE, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.WeatheringCopperSlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CopycatStepBlock]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.DoorBlock]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.BlockMain]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.RailBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockMachine, [key: Internal.Block]: Internal.BlockItem, [key: Internal.GardenBlock]: Internal.BlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockInventoryExpanded]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SandBlock]: Internal.BlockItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockChemicalTank, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SugarCaneBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.WeatheringCopperSlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockMachine, [key: Internal.BarrierBlock]: Internal.BlockItem, [key: Internal.TrashCanBlock]: Internal.BaseBlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.GlazedTerracottaBlock]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.IceBlock]: Internal.BlockItem, [key: Internal.CableBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.SoulSandBlock]: Internal.BlockItem, [key: Internal.EnergyCellBlock]: Internal.EnergyCellItem, [key: Internal.ShulkerBoxBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StainedGlassBlock]: Internal.BlockItem, [key: Internal.HammockBlock]: Internal.HammockItem, [key: Internal.CasingBlock]: Internal.BlockItem, [key: Internal.IronBarsBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WeatheringCopperFullBlock]: Internal.BlockItem, [key: Internal.BlockStructuralGlass<any>]: Internal.ItemBlockTooltip<any>, [key: Internal.BlazeBurnerBlock]: Internal.BlazeBurnerBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CraftingInjector]: Internal.ItemBlockBCore, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.BaseCoralPlantBlock]: Internal.BlockItem, [key: net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock]: Internal.BarrelBlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.FurnatorBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ConnectedGlassPaneBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BWGPlacementBushBlock]: Internal.BlockItem, [key: Internal.ArmBlock]: Internal.ArmItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.VibrationChamberBlock]: Internal.AEBaseBlockItem, [key: Internal.BlockCompressedStone]: Internal.BlockItem, [key: Internal.TrashCanBlock]: Internal.BaseBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.BWGMushroomBlock]: Internal.BlockItem, [key: Internal.PumpBlock]: Internal.BlockItem, [key: Internal.CoralBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGPlacementBushBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BuddingCrystalBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ControllerBlock]: Internal.AEBaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SeatBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGCraftingTable]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockRequest]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BrickBlock]: Internal.BlockItem, [key: Internal.WWGTrappedChestBlock]: Internal.ForgeChestItem, [key: Internal.ShulkerBoxBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CandleBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RedStoneWireBlock]: Internal.ItemNameBlockItem, [key: Internal.FallingDamageBlock]: Internal.BlockItem, [key: Internal.LadderBlock]: Internal.ForgeBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.ContraptionControlsBlock]: Internal.BlockItem, [key: Internal.WWGTrappedChestBlock]: Internal.ForgeChestItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.BracketBlock]: Internal.BracketBlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.SandBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SoulSandBlock]: Internal.BlockItem, [key: Internal.GearboxBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MyceliumBlock]: Internal.BlockItem, [key: Internal.BlockRotatable]: Internal.ItemBlockWoodenCrate, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.HopperBlock]: Internal.BlockItem, [key: Internal.ElevatorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ConcretePowderBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.BWGCeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.BWGStandingSignBlock]: Internal.SignItem, [key: Internal.SculkBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SawBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.GaugeBlock]: Internal.BlockItem, [key: Internal.MultiblockPartBlock$WithMirrorState<any>]: Internal.MultiblockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StripCurtainBlock]: Internal.BlockItemIE, [key: Internal.LimitedBarrelBlock]: Internal.BarrelBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGWallSignBlock]: Internal.SignItem, [key: Internal.ToasterBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PeculiarBellBlock]: Internal.BlockItem, [key: appeng.block.networking.EnergyCellBlock]: Internal.EnergyCellBlockItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.BlockExchange]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.TurretBlock<any>]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGCeilingHangingSignBlock]: Internal.HangingSignItem, [key: blusunrize.immersiveengineering.common.blocks.generic.PostBlock]: Internal.BlockItemIE, [key: Internal.FrogspawnBlock]: Internal.PlaceOnWaterBlockItem, [key: Internal.TallFlowerBlock]: Internal.DoubleHighBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.AAECraftingUnitBlock]: Internal.AAECraftingBlockItem, [key: Internal.CeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Potentiometer]: Internal.ItemBlockBCore, [key: Internal.EnergyDischargerBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DecorationTableBlock]: Internal.BlockItemBase, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.StructureBlock]: Internal.GameMasterBlockItem, [key: Internal.BlockFluidTank]: Internal.ItemBlockFluidTank, [key: Internal.ApothFletchingBlock]: Internal.PlaceboUtil$1, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LadderBlock]: Internal.ForgeBlockItem, [key: Internal.CoralPlantBlock]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.ValveHandleBlock]: Internal.BlockItem, [key: Internal.BWGWallSignBlock]: Internal.SignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.GlassBlock]: Internal.BlockItem, [key: Internal.StructuralArmBlock]: Internal.BlockItemIE, [key: Internal.TrappedChestBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.CGColoredTintedGlassBlock]: Internal.BaseBlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.BlockItem, [key: Internal.BlockCompressedObsidian]: Internal.BlockItem, [key: Internal.MobFarmBlockWrapper]: Internal.MobFarmBlockItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.TinyTNTBlock]: Internal.AEBaseBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.FallingDamageBlock]: Internal.BlockItem, [key: Internal.ValveHandleBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FluidPumpBlock]: Internal.BlockItemIE, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.ConnectedGlassPaneBlock]: Internal.BlockItem, [key: Internal.PlayerTransmitterBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LimitedBarrelBlock]: Internal.BarrelBlockItem, [key: Internal.ChickenNestBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TallGrassBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.BlockRestrictiveTransporter]: Internal.ItemBlockRestrictiveTransporter, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGDoublePlantBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockBin]: Internal.ItemBlockBin, [key: Internal.CGTintedGlassBlock]: Internal.BaseBlockItem, [key: Internal.TerminalBlock<any>]: Internal.AEBaseBlockItem, [key: Internal.BWGWallSignBlock]: Internal.SignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.PortstoneBlock]: Internal.BlockItem, [key: Internal.TaskScreenBlock]: Internal.ScreenBlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockTooltip<any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.SleepingBagBlock]: Internal.SleepingBagItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StainedGlassBlock]: Internal.BlockItem, [key: Internal.EnergizingOrbBlock]: Internal.ItemBlock<any, any>, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ToolboxBlock]: Internal.UncontainableBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ImbuedBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.ThermoBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockTooltip<any>, [key: Internal.ApothBambooBlock]: Internal.PlaceboUtil$1, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.CartAssemblerBlock]: Internal.CartAssemblerBlockItem, [key: Internal.FallingDamageBlock]: Internal.BlockItem, [key: Internal.LanternBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BrittleSandstoneBlock]: Internal.BlockItem, [key: Internal.CraftingUnitBlock]: Internal.MEGACraftingBlockItem, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.HarvesterBlock]: Internal.BlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.BuddingCrystalBlock]: Internal.CrystalBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.SampleDrillBlock]: Internal.BlockItem, [key: Internal.FloatingCarpetBlock]: Internal.BlockItem, [key: Internal.EnergyHopperBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ClutchBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LightningRodBlock]: Internal.BlockItem, [key: Internal.BlockBasicMultiblock<any>]: Internal.ItemBlockTooltip<any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallSkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.CeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.BannerBlock]: Internal.BannerItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockOre]: Internal.ItemBlockTooltip<any>, [key: Internal.FlatVegetationBlock]: Internal.BlockItem, [key: Internal.CreativeOPSource]: Internal.ItemBlockBCore, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BasicConnectorBlock<any>]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SkyStoneTankBlock]: Internal.AEBaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DyedOvenBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: appeng.block.networking.EnergyCellBlock]: Internal.EnergyCellBlockItem, [key: Internal.LootrInventoryBlock]: Internal.LootrChestBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CauldronBlock]: Internal.Items$1, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.CGGlassBlock]: Internal.BaseBlockItem, [key: Internal.BWGStandingSignBlock]: Internal.SignItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.JetpackBlock]: Internal.BacktankItem$BacktankBlockItem, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WWGChestBlock]: Internal.ForgeChestItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.BlockOre]: Internal.ItemBlockTooltip<any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SolicitingCarpet]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WeatheringCopperFullBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FarmBlock]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.BannerBlock]: Internal.BannerItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.IEStairsBlock]: Internal.BlockItemIE, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.ShrubBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.EnderCellBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.LadderBlock]: Internal.ForgeBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.CeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BWGStandingSignBlock]: Internal.SignItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.DoorBlock]: Internal.BlockItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.BWGCraftingTable]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.KitchenFloorBlock]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.QuartzLampBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.BeehiveBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PinkPetalsBlock]: Internal.BlockItem, [key: Internal.EnderGateBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.SleepingBagBlock]: Internal.SleepingBagItem, [key: Internal.WWGTrappedChestBlock]: Internal.ForgeChestItem, [key: Internal.SpatialAnchorBlock]: Internal.AEBaseBlockItem, [key: Internal.CandleBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DoorBlock]: Internal.BlockItem, [key: Internal.PinkPetalsBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlagGravelBlock]: Internal.BlockItemIE, [key: Internal.ShaftBlock]: Internal.BlockItem, [key: Internal.BuddingCrystalBlock]: Internal.CrystalBlockItem, [key: Internal.IOPortBlock]: Internal.AEBaseBlockItem, [key: Internal.BWGFireCrackerLeaves]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.CraftingUnitBlock]: Internal.CraftingBlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.FloweringBushBlock]: Internal.BlockItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DecoratedPotBlock]: Internal.BlockItem, [key: Internal.MelonBlock]: Internal.BlockItem, [key: Internal.ExtraBlock]: Internal.ExtraBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockLogisticalTransporter]: Internal.ItemBlockLogisticalTransporter, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGWallSignBlock]: Internal.SignItem, [key: Internal.TypedShelfBlock]: Internal.GlowyBlockItem, [key: Internal.FramedLightBlock]: Internal.FramedLightBlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.TeslaCoilBlock]: Internal.BlockItemIE, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WWGChestBlock]: Internal.ForgeChestItem, [key: Internal.BWGCeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.ToolboxBlock]: Internal.UncontainableBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.SoulSandBlock]: Internal.BlockItem, [key: Internal.CandleBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.MagmatorBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.BWGCraftingTable]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.HorizontalFacingEntityBlock<any>]: Internal.BlockItemIE, [key: Internal.ShulkerBoxBlock]: Internal.BlockItem, [key: Internal.BlockMechanicalPipe]: Internal.ItemBlockMechanicalPipe, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.LimitedBarrelBlock]: Internal.BarrelBlockItem, [key: Internal.CellWorkbenchBlock]: Internal.AEBaseBlockItem, [key: Internal.BuddingCrystalBlock]: Internal.CrystalBlockItem, [key: Internal.BWGWallSignBlock]: Internal.SignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.EnderCellBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockTile<any, any>]: Internal.ItemBlockTooltip<any>, [key: Internal.ExtractorBlock]: Internal.MultiBlockItem, [key: blusunrize.immersiveengineering.common.blocks.generic.ScaffoldingBlock]: Internal.BlockItemIE, [key: Internal.EnchLibraryBlock]: Internal.BlockItem, [key: Internal.EnergyMeterBlock]: Internal.BlockItemIE, [key: Internal.WoolCarpetBlock]: Internal.BlockItem, [key: Internal.WindowBlock]: Internal.BlockItem, [key: Internal.KitchenFloorBlock]: Internal.BlockItem, [key: Internal.BlockCompressedStone]: Internal.BlockItem, [key: Internal.TypedShelfBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WWGTrappedChestBlock]: Internal.ForgeChestItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FlowGate]: Internal.ItemBlockBCore, [key: Internal.BWGQuickSand]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.EnergyCrystal]: Internal.ItemBlockBCore, [key: Internal.GlazedTerracottaBlock]: Internal.BlockItem, [key: Internal.WoolCarpetBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.SeatBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PlayerHeadBlock]: Internal.PlayerHeadItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.EnergyHopperBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.SailBlock]: Internal.BlankSailBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CoralBlock]: Internal.BlockItem, [key: Internal.TntBlock]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.SmallDripleafBlock]: Internal.DoubleHighBlockItem, [key: Internal.StainedGlassBlock]: Internal.BlockItem, [key: Internal.BlockBasicMultiblock<any>]: Internal.ItemBlockTooltip<any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallSignBlock]: Internal.SignItem, [key: Internal.SharestoneBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.TimberFrameBlock]: Internal.TimberFrameBlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.SandBlock]: Internal.BlockItem, [key: Internal.BeehiveBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ChunkLoaderBlock]: Internal.AEBaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: com.unrealdinnerbone.jamd.block.NetherPortalBlock]: Internal.BlockItem, [key: Internal.SnowyDirtBlock]: Internal.BlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.SolicitingCarpet]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.KitchenFloorBlock]: Internal.BlockItem, [key: net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock]: Internal.ShulkerBoxItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.CeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.Block]: Internal.BlockItem, [key: net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock]: Internal.ShulkerBoxItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.KitchenFloorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BuddingCrystalBlock]: Internal.CrystalBlockItem, [key: Internal.ClipboardBlock]: Internal.ClipboardBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CreativeMobFarmBlockWrapper]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StonecutterBlock]: Internal.BlockItem, [key: Internal.BreakerSwitchBlock<any>]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BasinBlock]: Internal.BlockItem, [key: Internal.EnderGateBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.AEDecorativeBlock]: Internal.AEBaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.EnderCellBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.ToolboxBlock]: Internal.UncontainableBlockItem, [key: Internal.BlockOre]: Internal.ItemBlockTooltip<any>, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.BlockBasicMultiblock<any>]: Internal.ItemBlockTooltip<any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SeatBlock]: Internal.BlockItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.StandingSignBlock]: Internal.SignItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.ValveHandleBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.SharestoneBlock]: Internal.BlockItem, [key: Internal.SolicitingCarpet]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ReactorBlock]: Internal.ReactorItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.BWGCraftingTable]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LecternBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SnowyDirtBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CraftingUnitBlock]: Internal.CraftingBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.ControlsBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CropBlock]: Internal.ItemNameBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BedBlock]: Internal.BedItem, [key: com.supermartijn642.chunkloaders.ChunkLoaderBlock]: Internal.BaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockRotatableHorizontalShaped]: Internal.ItemBundleOfTimber, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.RedstoneContactBlock]: Internal.RedstoneContactItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.BannerBlock]: Internal.BannerItem, [key: Internal.TypedShelfBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.FeedthroughBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallmountBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FlatVegetationBlock]: Internal.BlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.WWGChestBlock]: Internal.ForgeChestItem, [key: Internal.BlockPersonalBarrel]: Internal.ItemBlockPersonalStorage<any>, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BWGWallSignBlock]: Internal.SignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MangroveLeavesBlock]: Internal.BlockItem, [key: Internal.BlockOre]: Internal.ItemBlockTooltip<any>, [key: Internal.SmartObserverBlock]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGCeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DoorBlock]: Internal.BlockItem, [key: Internal.EnergyCore]: Internal.ItemBlockBCore, [key: Internal.BlockDarkLamp]: Internal.BlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SnowLayerBlock]: Internal.BlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.KitchenFloorBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.IceBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.WallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.KitchenFloorBlock]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CommandBlock]: Internal.GameMasterBlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FluidTankBlock]: Internal.FluidTankItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.IEEntityBlock<any>]: Internal.BlockItemIE, [key: Internal.BWGWallSignBlock]: Internal.SignItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ValveHandleBlock]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.CandleBlock]: Internal.BlockItem, [key: Internal.PostBlock]: Internal.PostBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.BlockChargepad]: Internal.ItemBlockTooltip<any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.OxidizableButtonBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WWGBarrelBlock]: Internal.ForgeBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ConnectedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ThresholdSwitchBlock]: Internal.BlockItem, [key: Internal.CaveVinesBlock]: Internal.ItemNameBlockItem, [key: Internal.FlatVegetationBlock]: Internal.BlockItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockMachine, [key: Internal.BlockTile<any, any>]: Internal.ItemBlockMachine, [key: Internal.AloeVeraBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CableBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.SpiceRackBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: cy.jdkdigital.utilitarian.common.block.SoulSnadBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItemIE, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.TypedShelfBlock]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.FeralFlareLanternBlock]: Internal.TMItemBlock, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.HammockBlock]: Internal.HammockItem, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.LimitedBarrelBlock]: Internal.BarrelBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FallingDamageBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.SandBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.KitchenFloorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.InscriberBlock]: Internal.AEBaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.ConcretePowderBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FloatingCarpetBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BaseCoralPlantBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WeatheringCopperStairBlock]: Internal.BlockItem, [key: Internal.WeatheringCopperSlabBlock]: Internal.BlockItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGWallSignBlock]: Internal.SignItem, [key: Internal.ConveyorBlock]: Internal.BlockItemIE, [key: Internal.BlockTile<any, any>]: Internal.ItemBlockInductionProvider, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.BlockBasicMultiblock<any>]: Internal.ItemBlockTooltip<any>, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: owmii.powah.lib.block.AbstractBlock<any, any>]: Internal.ItemBlock<any, any>, [key: Internal.CGColoredTintedGlassBlock]: Internal.BaseBlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.DropExperienceBlock]: Internal.BlockItem, [key: Internal.BlockPressurizedTube]: Internal.ItemBlockPressurizedTube, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WeatheringCopperFullBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TypedShelfBlock]: Internal.BlockItem, [key: Internal.BWGSaplingBlock]: Internal.BlockItem, [key: Internal.DoorBlock]: Internal.DoubleHighBlockItem, [key: Internal.DraconiumChest]: Internal.ItemBlockBCore, [key: Internal.StructureVoidBlock]: Internal.BlockItem, [key: Internal.CraftingUnitBlock]: Internal.CraftingBlockItem, [key: Internal.BlockFactoryMachine$BlockFactory<any>]: Internal.ItemBlockFactory, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FloatingCarpetBlock]: Internal.BlockItem, [key: Internal.BuddingCrystalBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SnifferEggBlock]: Internal.BlockItem, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockOre]: Internal.ItemBlockTooltip<any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.CasingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockTile<any, any>]: Internal.ItemBlockTooltip<any>, [key: Internal.DyedOvenBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FallingDamageBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TypedShelfBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.NoteBlock]: Internal.BlockItem, [key: Internal.GardenBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.TimberFrameBlock]: Internal.TimberFrameBlockItem, [key: Internal.CommandBlock]: Internal.GameMasterBlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.CornerBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock]: Internal.BarrelBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SolarBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.BasicConnectorBlock<any>]: Internal.BlockItemIE, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.WallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.BacktankBlock]: Internal.BacktankItem$BacktankBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGCraftingTable]: Internal.BlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.SailBlock]: Internal.BlankSailBlockItem, [key: Internal.SignalBlock]: Internal.TrackTargetingBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockRotatable]: Internal.ItemBlockWoodenCrate, [key: Internal.BlockEnergyCube]: Internal.ItemBlockEnergyCube, [key: Internal.KitchenFloorBlock]: Internal.BlockItem, [key: Internal.LimitedBarrelBlock]: Internal.BarrelBlockItem, [key: Internal.BuddingCrystalBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockLaserTractorBeam, [key: Internal.ConnectedPillarBlock]: Internal.BlockItem, [key: Internal.BlockDirtSlab]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BannerBlock]: Internal.BannerItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.BeltTunnelBlock]: Internal.BeltTunnelItem, [key: Internal.WWGBarrelBlock]: Internal.ForgeBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WoolCarpetBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.KitchenFloorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ConcretePowderBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.BWGStandingSignBlock]: Internal.SignItem, [key: Internal.HammockBlock]: Internal.HammockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.SolicitingCarpet]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.BWGWallSignBlock]: Internal.SignItem, [key: Internal.WallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.SleepingBagBlock]: Internal.SleepingBagItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.DoorBlock]: Internal.BlockItem, [key: Internal.CeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.CraftingUnitBlock]: Internal.CraftingBlockItem, [key: owmii.powah.lib.block.AbstractBlock<any, any>]: Internal.ItemBlock<any, any>, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGWallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.ConveyorBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.BedBlock]: Internal.BedItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.EnergyCellBlock]: Internal.EnergyCellItem, [key: Internal.PartialConcreteBlock]: Internal.BlockItemIE, [key: Internal.CoralPlantBlock]: Internal.BlockItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.SeatBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.WWGBarrelBlock]: Internal.ForgeBlockItem, [key: Internal.BlockTile<any, any>]: Internal.ItemBlockInductionCell, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGWallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.BlockIESlab<any>]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ChargerBlock]: Internal.AEBaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ConnectedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.EnergyCellBlock]: Internal.EnergyCellItem, [key: Internal.SharestoneBlock]: Internal.BlockItem, [key: Internal.WWGTrappedChestBlock]: Internal.ForgeChestItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.AEDecorativeBlock]: Internal.AEBaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TerminalBlock<any>]: Internal.AEBaseBlockItem, [key: Internal.FungusBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockMachine, [key: Internal.SolicitingCarpet]: Internal.BlockItem, [key: Internal.BWGFruitLeavesBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: blusunrize.immersiveengineering.common.blocks.generic.PostBlock]: Internal.BlockItemIE, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.CGColoredTintedGlassBlock]: Internal.BaseBlockItem, [key: Internal.StainedGlassPaneBlock]: Internal.BlockItem, [key: Internal.ForgeDiagonalFenceBlock]: Internal.BlockItem, [key: Internal.BlockEnergyCube]: Internal.ItemBlockEnergyCube, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TackleBoxBlock]: Internal.BlockItemWithoutLevelRenderer, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.WallBannerBlock]: Internal.BannerItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LimitedBarrelBlock]: Internal.BarrelBlockItem, [key: Internal.SolicitingCarpet]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BWGCeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.DyedOvenBlock]: Internal.BlockItem, [key: Internal.CeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.ToolboxBlock]: Internal.UncontainableBlockItem, [key: Internal.BWGStandingSignBlock]: Internal.SignItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.EnergizingRodBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.WeatheringCopperSlabBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGTallFlowerBlockTreeGrower]: Internal.BlockItem, [key: Internal.TreeBranchBlock]: Internal.BlockItem, [key: Internal.WhistleBlock]: Internal.BlockItem, [key: Internal.BlockBasicMultiblock<any>]: Internal.ItemBlockTooltip<any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.SlidingDoorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockPamCrop]: Internal.ItemPamSeed, [key: Internal.BrittleSandstoneBlock]: Internal.BlockItem, [key: Internal.HugeMushroomBlock]: Internal.BlockItem, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockMachine, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WeatheringCopperSlabBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.GunpowderBarrelBlock]: Internal.BlockItemIE, [key: Internal.SmokerBlock]: Internal.BlockItem, [key: Internal.BasicConnectorBlock<any>]: Internal.BlockItemIE, [key: Internal.FlowerPotBlock]: Internal.BlockItem, [key: Internal.BWGWallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.WirelessAccessPointBlock]: Internal.AEBaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallSignBlock]: Internal.SignItem, [key: Internal.BedBlock]: Internal.BedItem, [key: Internal.BlockOre]: Internal.ItemBlockTooltip<any>, [key: Internal.DyedOvenBlock]: Internal.BlockItem, [key: Internal.JigsawBlock]: Internal.GameMasterBlockItem, [key: Internal.WallSignBlock]: Internal.SignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CoralBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.ElectricMotorBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.GlazedTerracottaBlock]: Internal.BlockItem, [key: Internal.CreativeEnergyCellBlock]: Internal.AEBaseBlockItem, [key: Internal.BWGWallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGFlowerBlock]: Internal.BlockItem, [key: Internal.MultiblockPartBlock$WithMirrorState<any>]: Internal.MultiblockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.BannerBlock]: Internal.BannerItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.BlockPamFruit]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WeatheringCopperSlabBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.SlimeBlock]: Internal.BlockItem, [key: Internal.DoorBlock]: Internal.BlockItem, [key: Internal.PointedDripstoneBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DoorBlock]: Internal.DoubleHighBlockItem, [key: Internal.FallingDamageBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.AllBrickBlock]: Internal.AllBrickBlockItem, [key: Internal.WWGTrappedChestBlock]: Internal.ForgeChestItem, [key: Internal.GlazedTerracottaBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.DropExperienceBlock]: Internal.BlockItem, [key: Internal.SleepingBagBlock]: Internal.SleepingBagItem, [key: Internal.BuddingCrystalBlock]: Internal.CrystalBlockItem, [key: Internal.BlockOre]: Internal.ItemBlockTooltip<any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SolarBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BWGBonemealableFlowerBlock]: Internal.BlockItem, [key: Internal.FurnatorBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.WeatheringCopperStairBlock]: Internal.BlockItem, [key: com.unrealdinnerbone.jamd.block.EndPortalBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CandleBlock]: Internal.BlockItem, [key: Internal.MultiblockPartBlock$WithMirrorState<any>]: Internal.MultiblockItem, [key: Internal.SailBlock]: Internal.BlankSailBlockItem, [key: blusunrize.immersiveengineering.common.blocks.generic.ScaffoldingBlock]: Internal.BlockItemIE, [key: Internal.StickerBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockTile$BlockTileModel<any, any>]: Internal.ItemBlockQIOComponent, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CoralWallFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.BuddingCertusQuartzBlock]: Internal.AEBaseBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.ControllerRailBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockBotanyPot]: Internal.BlockItem, [key: Internal.BWGWallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StainedGlassPaneBlock]: Internal.BlockItem, [key: Internal.WWGTrappedChestBlock]: Internal.ForgeChestItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.GlazedTerracottaBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockResource]: Internal.ItemBlockResource, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FallingDamageBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: blusunrize.immersiveengineering.common.blocks.metal.LanternBlock]: Internal.BlockItemIE, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ThermoBlock]: Internal.EnergyBlockItem<any, any>, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TaskScreenBlock]: Internal.ScreenBlockItem, [key: Internal.CGColoredPaneBlock]: Internal.BaseBlockItem, [key: Internal.FurnaceBlock]: Internal.BlockItem, [key: Internal.GearshiftBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.WallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.IEBaseBlock]: Internal.BlockItemIE, [key: Internal.CGColoredGlassBlock]: Internal.BaseBlockItem, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.SharestoneBlock]: Internal.BlockItem, [key: Internal.BlockCableFilter]: Internal.BlockItem, [key: Internal.BlockPersonalChest]: Internal.ItemBlockPersonalStorage<any>, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.IEStairsBlock]: Internal.BlockItemIE, [key: Internal.AmethystClusterBlock]: Internal.CrystalBlockItem, [key: Internal.ToggleLatchBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BuddingCrystalBlock]: Internal.CrystalBlockItem}) & (Internal.Map<Internal.Block, Internal.Item>);
        static readonly EAT_DURATION: (32) & (number);
        static readonly BASE_ATTACK_DAMAGE_UUID: (Internal.UUID) & (Internal.UUID);
        static readonly MAX_STACK_SIZE: (64) & (number);
        static readonly MAX_BAR_WIDTH: (13) & (number);
        static readonly BASE_ATTACK_SPEED_UUID: (Internal.UUID) & (Internal.UUID);
        renderProperties: any;
    }
    type Item_ = Item | Special.Item;
    class RedstoneLinkBlockEntity extends Internal.SmartBlockEntity {
        constructor(arg0: Internal.BlockEntityType_<any>, arg1: BlockPos_, arg2: Internal.BlockState_)
        emf$hasVehicle(): boolean;
        requestModelDataUpdate(): void;
        etf$getType(): Internal.EntityType<any>;
        emf$getVelocity(): Vec3d;
        destroy(): void;
        write(arg0: Internal.CompoundTag_, arg1: boolean): void;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityDispatcher)"(arg0: Internal.CapabilityDispatcher_): boolean;
        etf$isBlockEntity(): boolean;
        readClient(arg0: Internal.CompoundTag_): void;
        isVirtual(): boolean;
        /**
         * @deprecated
        */
        setBlockState(arg0: Internal.BlockState_): void;
        handler$dbg000$setLevel(arg0: Internal.Level_, arg1: Internal.CallbackInfo_): void;
        remove(): void;
        load(arg0: Internal.CompoundTag_): void;
        award(arg0: Internal.CreateAdvancement_): void;
        setChanged(): void;
        setCulled(value: boolean): void;
        saveWithoutMetadata(): Internal.CompoundTag;
        setTimeout(): void;
        isOutOfCamera(): boolean;
        "getUpdatePacket()"(): Internal.Packet<any>;
        packetTarget(): Internal.PacketDistributor$PacketTarget;
        emf$prevZ(): number;
        etf$canBeBright(): boolean;
        setRemoved(): void;
        emf$isOnGround(): boolean;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        etf$getPose(): Internal.Pose;
        etf$getEntityKey(): string;
        writeSafe(arg0: Internal.CompoundTag_): void;
        isCulled(): boolean;
        transmit(arg0: number): void;
        getType(): Internal.BlockEntityType<any>;
        writeClient(arg0: Internal.CompoundTag_): Internal.CompoundTag;
        etf$getOptifineId(): number;
        "getUpdatePacket()"(): Internal.ClientboundBlockEntityDataPacket;
        refreshBlockState(): void;
        getRenderBoundingBox(): Internal.AABB;
        getClass(): typeof any;
        sendToMenu(arg0: Internal.FriendlyByteBuf_): void;
        emf$isInvisible(): boolean;
        static getPosFromTag(arg0: Internal.CompoundTag_): BlockPos;
        etf$distanceTo(entity: Internal.Entity_): number;
        emf$isSprinting(): boolean;
        addBehaviours(arg0: Internal.List_<Internal.BlockEntityBehaviour>): void;
        hasAnyComparatorNearby(): boolean;
        onChunkUnloaded(): void;
        saveToItem(arg0: Internal.ItemStack_): void;
        "deserializeNBT(net.minecraft.nbt.CompoundTag)"(arg0: Internal.CompoundTag_): void;
        static addEntityType(arg0: Internal.CompoundTag_, arg1: Internal.BlockEntityType_<any>): void;
        emf$isInLava(): boolean;
        "deserializeNBT(net.minecraft.nbt.Tag)"(arg0: Internal.Tag_): void;
        onComparatorAdded(direction: Internal.Direction_, offset: number): void;
        clearRemoved(): void;
        emf$isWet(): boolean;
        getUpdatePacket(): Internal.Packet<any>;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityProvider)"(arg0: Internal.CapabilityProvider_<Internal.BlockEntity>): boolean;
        setLazyTickRate(arg0: number): void;
        handler$dbg000$setRemoved(arg0: Internal.CallbackInfo_): void;
        awardIfNear(arg0: Internal.CreateAdvancement_, arg1: number): void;
        containedChunk(): Internal.LevelChunk;
        getPersistentData(): Internal.CompoundTag;
        toString(): string;
        markVirtual(): void;
        triggerEvent(arg0: number, arg1: number): boolean;
        emf$isGlowing(): boolean;
        hasLevel(): boolean;
        notifyAll(): void;
        forEachBehaviour(arg0: Internal.Consumer_<Internal.BlockEntityBehaviour>): void;
        invalidate(): void;
        etf$getScoreboardTeam(): Internal.Team;
        emf$getZ(): number;
        setType_HammerLib(arg0: Internal.BlockEntityType_<any>): void;
        wait(arg0: number): void;
        etf$getItemsEquipped(): Internal.Iterable<any>;
        etf$getVelocity(): Vec3d;
        reviveCaps(): void;
        sendData(): void;
        getBehaviour<T extends Internal.BlockEntityBehaviour>(arg0: Internal.BehaviourType_<T>): T;
        etf$getWorld(): Internal.Level;
        getUpdateTag(): Internal.CompoundTag;
        handleUpdateTag(arg0: Internal.CompoundTag_): void;
        emf$getYaw(): number;
        setLevel(arg0: Internal.Level_): void;
        notify(): void;
        addBehavioursDeferred(arg0: Internal.List_<Internal.BlockEntityBehaviour>): void;
        getBlockPos(): BlockPos;
        etf$getNbt(): Internal.CompoundTag;
        isRemoved(): boolean;
        emf$isSneaking(): boolean;
        etf$getBlockPos(): BlockPos;
        onLoad(): void;
        fillCrashReportCategory(arg0: Internal.CrashReportCategory_): void;
        emf$prevPitch(): number;
        etf$getBlockY(): number;
        initialize(): void;
        etf$getHandItems(): Internal.Iterable<any>;
        etf$getArmorItems(): Internal.Iterable<any>;
        emf$getY(): number;
        invalidateCaps(): void;
        emf$prevX(): number;
        getBlockState(): Internal.BlockState;
        tick(): void;
        canPlayerUse(arg0: Internal.Player_): boolean;
        lazyTick(): void;
        emf$age(): number;
        etf$hasCustomName(): boolean;
        static loadStatic(arg0: BlockPos_, arg1: Internal.BlockState_, arg2: Internal.CompoundTag_): Internal.BlockEntity;
        wait(): void;
        emf$isTouchingWater(): boolean;
        m_183515_(arg0: Internal.CompoundTag_): void;
        emf$getVariableMap(): Internal.Object2FloatOpenHashMap<any>;
        areCapsCompatible(arg0: Internal.CapabilityDispatcher_): boolean;
        etf$getCustomName(): net.minecraft.network.chat.Component;
        getCapability<T>(arg0: Internal.Capability_<T>, arg1: Internal.Direction_): Internal.LazyOptional<T>;
        saveWithId(): Internal.CompoundTag;
        notifyUpdate(): void;
        setOutOfCamera(value: boolean): void;
        wait(arg0: number, arg1: number): void;
        isChunkUnloaded(): boolean;
        getLevel(): Internal.Level;
        getRequiredItems(arg0: Internal.BlockState_): Internal.ItemRequirement;
        onlyOpCanSetNbt(): boolean;
        serializeNBT(): Internal.Tag;
        getSignal(): number;
        onDataPacket(arg0: Internal.Connection_, arg1: Internal.ClientboundBlockEntityDataPacket_): void;
        saveWithFullMetadata(): Internal.CompoundTag;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        setSignal(arg0: number): void;
        emf$prevY(): number;
        emf$getX(): number;
        areCapsCompatible(arg0: Internal.CapabilityProvider_<Internal.BlockEntity>): boolean;
        emf$isOnFire(): boolean;
        deserializeNBT(arg0: Internal.Tag_): void;
        blockHolderGetter(): Internal.HolderGetter<Internal.Block>;
        etf$getUuid(): Internal.UUID;
        getReceivedSignal(): number;
        getAllBehaviours(): Internal.Collection<Internal.BlockEntityBehaviour>;
        getUpdatePacket(): Internal.ClientboundBlockEntityDataPacket;
        isForcedVisible(): boolean;
        emf$hasPassengers(): boolean;
        registerAwardables(arg0: Internal.List_<Internal.BlockEntityBehaviour>, ...arg1: Internal.CreateAdvancement_[]): void;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        hashCode(): number;
        emf$getTypeString(): string;
        getModelData(): Internal.ModelData;
        emf$getPitch(): number;
        emf$isAlive(): boolean;
        equals(arg0: any): boolean;
        get virtual(): boolean
        /**
         * @deprecated
        */
        set blockState(arg0: Internal.BlockState_)
        set culled(value: boolean)
        get outOfCamera(): boolean
        get "updatePacket()"(): Internal.Packet<any>
        get culled(): boolean
        get type(): Internal.BlockEntityType<any>
        get "updatePacket()"(): Internal.ClientboundBlockEntityDataPacket
        get renderBoundingBox(): Internal.AABB
        get class(): typeof any
        get updatePacket(): Internal.Packet<any>
        set lazyTickRate(arg0: number)
        get persistentData(): Internal.CompoundTag
        set type_HammerLib(arg0: Internal.BlockEntityType_<any>)
        get updateTag(): Internal.CompoundTag
        set level(arg0: Internal.Level_)
        get blockPos(): BlockPos
        get removed(): boolean
        get blockState(): Internal.BlockState
        set outOfCamera(value: boolean)
        get chunkUnloaded(): boolean
        get level(): Internal.Level
        get signal(): number
        set signal(arg0: number)
        get receivedSignal(): number
        get allBehaviours(): Internal.Collection<Internal.BlockEntityBehaviour>
        get updatePacket(): Internal.ClientboundBlockEntityDataPacket
        get forcedVisible(): boolean
        get modelData(): Internal.ModelData
    }
    type RedstoneLinkBlockEntity_ = RedstoneLinkBlockEntity;
    interface ScoreboardNameProvider {
        abstract getReferencedContextParams(): Internal.Set<Internal.LootContextParam<any>>;
        abstract getType(): Internal.LootScoreProviderType;
        abstract getScoreboardName(arg0: Internal.LootContext_): string;
        get referencedContextParams(): Internal.Set<Internal.LootContextParam<any>>
        get type(): Internal.LootScoreProviderType
    }
    type ScoreboardNameProvider_ = ScoreboardNameProvider;
    class Tuple18$Mutable18 <A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R> extends Internal.Tuple18<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R> {
        constructor(arg0: A, arg1: B, arg2: C, arg3: D, arg4: E, arg5: F, arg6: G, arg7: H, arg8: I, arg9: J, arg10: K, arg11: L, arg12: M, arg13: N, arg14: O, arg15: P, arg16: Q, arg17: R)
        strip13R(): Internal.Tuple5<any, any, any, any, any>;
        acceptR(arg0: Internal.Consumer12_<G, H, I, J, K, L, M, N, O, P, Q, R>): void;
        mutable(): this;
        "applyR(org.zeith.hammerlib.util.java.functions.Function3)"<RES>(arg0: Internal.Function3_<P, Q, R, RES>): RES;
        insert(arg0: any, arg1: any, arg2: any, arg3: any, arg4: any, arg5: any, arg6: any, arg7: any): Internal.Tuple26<any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any>;
        setC(arg0: C): this;
        e(): E;
        apply<RES>(arg0: Internal.Function18_<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, RES>): RES;
        "acceptR(org.zeith.hammerlib.util.java.consumers.Consumer12)"(arg0: Internal.Consumer12_<G, H, I, J, K, L, M, N, O, P, Q, R>): void;
        "applyL(org.zeith.hammerlib.util.java.functions.Function9)"<RES>(arg0: Internal.Function9_<A, B, C, D, E, F, G, H, I, RES>): RES;
        "applyL(org.zeith.hammerlib.util.java.functions.Function11)"<RES>(arg0: org.zeith.hammerlib.util.java_.functions.Function11_<A, B, C, D, E, F, G, H, I, J, K, RES>): RES;
        m(): M;
        "applyL(org.zeith.hammerlib.util.java.functions.Function3)"<RES>(arg0: Internal.Function3_<A, B, C, RES>): RES;
        applyL<RES>(arg0: org.zeith.hammerlib.util.java_.functions.Function1_<A, RES>): RES;
        strip7R(): Internal.Tuple11$Mutable11<A, B, C, D, E, F, G, H, I, J, K>;
        "acceptL(org.zeith.hammerlib.util.java.consumers.Consumer8)"(arg0: Internal.Consumer8_<A, B, C, D, E, F, G, H>): void;
        "acceptR(org.zeith.hammerlib.util.java.consumers.Consumer3)"(arg0: Internal.Consumer3_<P, Q, R>): void;
        strip3L(): Internal.Tuple15$Mutable15<D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R>;
        strip3R(): Internal.Tuple15$Mutable15<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O>;
        setD(arg0: D): this;
        "applyR(org.zeith.hammerlib.util.java.functions.Function16)"<RES>(arg0: org.zeith.hammerlib.util.java_.functions.Function16_<C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, RES>): RES;
        applyL<RES>(arg0: Internal.Function9_<A, B, C, D, E, F, G, H, I, RES>): RES;
        "applyR(org.zeith.hammerlib.util.java.functions.Function11)"<RES>(arg0: org.zeith.hammerlib.util.java_.functions.Function11_<H, I, J, K, L, M, N, O, P, Q, R, RES>): RES;
        applyL<RES>(arg0: Internal.Function17_<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, RES>): RES;
        "acceptR(org.zeith.hammerlib.util.java.consumers.Consumer11)"(arg0: Internal.Consumer11_<H, I, J, K, L, M, N, O, P, Q, R>): void;
        acceptR(arg0: Internal.Consumer13_<F, G, H, I, J, K, L, M, N, O, P, Q, R>): void;
        acceptR(arg0: Internal.Consumer2_<Q, R>): void;
        applyL<RES>(arg0: org.zeith.hammerlib.util.java_.functions.Function16_<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, RES>): RES;
        applyR<RES>(arg0: org.zeith.hammerlib.util.java_.functions.Function12_<G, H, I, J, K, L, M, N, O, P, Q, R, RES>): RES;
        getClass(): typeof any;
        acceptR(arg0: Internal.Consumer11_<H, I, J, K, L, M, N, O, P, Q, R>): void;
        d(): D;
        "applyL(org.zeith.hammerlib.util.java.functions.Function6)"<RES>(arg0: Internal.Function6_<A, B, C, D, E, F, RES>): RES;
        setE(arg0: E): this;
        applyR<RES>(arg0: org.zeith.hammerlib.util.java_.functions.Function11_<H, I, J, K, L, M, N, O, P, Q, R, RES>): RES;
        "acceptL(org.zeith.hammerlib.util.java.consumers.Consumer2)"(arg0: Internal.Consumer2_<A, B>): void;
        "acceptR(org.zeith.hammerlib.util.java.consumers.Consumer6)"(arg0: Internal.Consumer6_<M, N, O, P, Q, R>): void;
        add<S, T, U, V>(arg0: S, arg1: T, arg2: U, arg3: V): Internal.Tuple22$Mutable22<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V>;
        applyL<RES>(arg0: org.zeith.hammerlib.util.java_.functions.Function12_<A, B, C, D, E, F, G, H, I, J, K, L, RES>): RES;
        strip4L(): Internal.Tuple14$Mutable14<E, F, G, H, I, J, K, L, M, N, O, P, Q, R>;
        applyL<RES>(arg0: org.zeith.hammerlib.util.java_.functions.Function10_<A, B, C, D, E, F, G, H, I, J, RES>): RES;
        strip12L(): Internal.Tuple6$Mutable6<M, N, O, P, Q, R>;
        "acceptL(org.zeith.hammerlib.util.java.consumers.Consumer7)"(arg0: Internal.Consumer7_<A, B, C, D, E, F, G>): void;
        strip1L(): Internal.Tuple17$Mutable17<B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R>;
        applyL<RES>(arg0: Internal.Function4_<A, B, C, D, RES>): RES;
        applyR<RES>(arg0: Internal.Function17_<B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, RES>): RES;
        insert(arg0: any, arg1: any): Internal.Tuple20<any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any>;
        "acceptR(org.zeith.hammerlib.util.java.consumers.Consumer14)"(arg0: Internal.Consumer14_<E, F, G, H, I, J, K, L, M, N, O, P, Q, R>): void;
        add<S, T, U, V, W>(arg0: S, arg1: T, arg2: U, arg3: V, arg4: W): Internal.Tuple23$Mutable23<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V, W>;
        "applyR(org.zeith.hammerlib.util.java.functions.Function15)"<RES>(arg0: org.zeith.hammerlib.util.java_.functions.Function15_<D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, RES>): RES;
        l(): L;
        "acceptL(org.zeith.hammerlib.util.java.consumers.Consumer15)"(arg0: Internal.Consumer15_<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O>): void;
        strip13L(): Internal.Tuple5$Mutable5<N, O, P, Q, R>;
        acceptL(arg0: Internal.Consumer3_<A, B, C>): void;
        "applyL(org.zeith.hammerlib.util.java.functions.Function14)"<RES>(arg0: org.zeith.hammerlib.util.java_.functions.Function14_<A, B, C, D, E, F, G, H, I, J, K, L, M, N, RES>): RES;
        applyL<RES>(arg0: org.zeith.hammerlib.util.java_.functions.Function14_<A, B, C, D, E, F, G, H, I, J, K, L, M, N, RES>): RES;
        strip6R(): Internal.Tuple12<any, any, any, any, any, any, any, any, any, any, any, any>;
        applyL<RES>(arg0: Internal.Function3_<A, B, C, RES>): RES;
        "applyL(org.zeith.hammerlib.util.java.functions.Function7)"<RES>(arg0: Internal.Function7_<A, B, C, D, E, F, G, RES>): RES;
        "applyR(org.zeith.hammerlib.util.java.functions.Function1)"<RES>(arg0: org.zeith.hammerlib.util.java_.functions.Function1_<R, RES>): RES;
        applyL<RES>(arg0: Internal.Function5_<A, B, C, D, E, RES>): RES;
        strip4R(): Internal.Tuple14<any, any, any, any, any, any, any, any, any, any, any, any, any, any>;
        acceptL(arg0: Internal.Consumer13_<A, B, C, D, E, F, G, H, I, J, K, L, M>): void;
        setF(arg0: F): this;
        strip2L(): Internal.Tuple16<any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any>;
        acceptR(arg0: Internal.Consumer5_<N, O, P, Q, R>): void;
        "applyL(org.zeith.hammerlib.util.java.functions.Function5)"<RES>(arg0: Internal.Function5_<A, B, C, D, E, RES>): RES;
        acceptR(arg0: Internal.Consumer7_<L, M, N, O, P, Q, R>): void;
        "acceptL(org.zeith.hammerlib.util.java.consumers.Consumer13)"(arg0: Internal.Consumer13_<A, B, C, D, E, F, G, H, I, J, K, L, M>): void;
        wait(arg0: number): void;
        add<S, T>(arg0: S, arg1: T): Internal.Tuple20$Mutable20<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T>;
        applyR<RES>(arg0: org.zeith.hammerlib.util.java_.functions.Function10_<I, J, K, L, M, N, O, P, Q, R, RES>): RES;
        "acceptL(org.zeith.hammerlib.util.java.consumers.Consumer1)"(arg0: Internal.Consumer1_<A>): void;
        c(): C;
        setO(arg0: O): this;
        "applyL(org.zeith.hammerlib.util.java.functions.Function17)"<RES>(arg0: Internal.Function17_<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, RES>): RES;
        "applyR(org.zeith.hammerlib.util.java.functions.Function5)"<RES>(arg0: Internal.Function5_<N, O, P, Q, R, RES>): RES;
        k(): K;
        acceptR(arg0: Internal.Consumer17_<B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R>): void;
        applyR<RES>(arg0: Internal.Function5_<N, O, P, Q, R, RES>): RES;
        applyR<RES>(arg0: Internal.Function4_<O, P, Q, R, RES>): RES;
        "acceptR(org.zeith.hammerlib.util.java.consumers.Consumer1)"(arg0: Internal.Consumer1_<R>): void;
        acceptL(arg0: Internal.Consumer5_<A, B, C, D, E>): void;
        "applyR(org.zeith.hammerlib.util.java.functions.Function6)"<RES>(arg0: Internal.Function6_<M, N, O, P, Q, R, RES>): RES;
        applyR<RES>(arg0: Internal.Function2_<Q, R, RES>): RES;
        insert(arg0: any, arg1: any, arg2: any): Internal.Tuple21<any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any>;
        setP(arg0: P): this;
        acceptR(arg0: Internal.Consumer8_<K, L, M, N, O, P, Q, R>): void;
        "acceptR(org.zeith.hammerlib.util.java.consumers.Consumer2)"(arg0: Internal.Consumer2_<Q, R>): void;
        acceptL(arg0: Internal.Consumer12_<A, B, C, D, E, F, G, H, I, J, K, L>): void;
        strip10R(): Internal.Tuple8$Mutable8<A, B, C, D, E, F, G, H>;
        "acceptL(org.zeith.hammerlib.util.java.consumers.Consumer9)"(arg0: Internal.Consumer9_<A, B, C, D, E, F, G, H, I>): void;
        wait(): void;
        acceptL(arg0: Internal.Consumer15_<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O>): void;
        "acceptL(org.zeith.hammerlib.util.java.consumers.Consumer5)"(arg0: Internal.Consumer5_<A, B, C, D, E>): void;
        strip15R(): Internal.Tuple3<any, any, any>;
        applyR<RES>(arg0: org.zeith.hammerlib.util.java_.functions.Function15_<D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, RES>): RES;
        "acceptR(org.zeith.hammerlib.util.java.consumers.Consumer5)"(arg0: Internal.Consumer5_<N, O, P, Q, R>): void;
        strip17R(): Internal.Tuple1<any>;
        b(): B;
        "acceptR(org.zeith.hammerlib.util.java.consumers.Consumer9)"(arg0: Internal.Consumer9_<J, K, L, M, N, O, P, Q, R>): void;
        "applyL(org.zeith.hammerlib.util.java.functions.Function13)"<RES>(arg0: org.zeith.hammerlib.util.java_.functions.Function13_<A, B, C, D, E, F, G, H, I, J, K, L, M, RES>): RES;
        add<S, T, U, V, W, X, Y, Z>(arg0: S, arg1: T, arg2: U, arg3: V, arg4: W, arg5: X, arg6: Y, arg7: Z): Internal.Tuple26$Mutable26<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V, W, X, Y, Z>;
        setA(arg0: A): this;
        setQ(arg0: Q): this;
        "acceptL(org.zeith.hammerlib.util.java.consumers.Consumer4)"(arg0: Internal.Consumer4_<A, B, C, D>): void;
        insert(arg0: any, arg1: any, arg2: any, arg3: any, arg4: any): Internal.Tuple23<any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any>;
        applyR<RES>(arg0: Internal.Function3_<P, Q, R, RES>): RES;
        "applyL(org.zeith.hammerlib.util.java.functions.Function10)"<RES>(arg0: org.zeith.hammerlib.util.java_.functions.Function10_<A, B, C, D, E, F, G, H, I, J, RES>): RES;
        strip16L(): Internal.Tuple2<any, any>;
        applyR<RES>(arg0: org.zeith.hammerlib.util.java_.functions.Function13_<F, G, H, I, J, K, L, M, N, O, P, Q, R, RES>): RES;
        j(): J;
        applyL<RES>(arg0: org.zeith.hammerlib.util.java_.functions.Function15_<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, RES>): RES;
        insert(arg0: any): Internal.Tuple19<any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any>;
        acceptR(arg0: Internal.Consumer1_<R>): void;
        strip14L(): Internal.Tuple4<any, any, any, any>;
        strip11L(): Internal.Tuple7<any, any, any, any, any, any, any>;
        strip1R(): Internal.Tuple17<any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any>;
        r(): R;
        applyL<RES>(arg0: Internal.Function6_<A, B, C, D, E, F, RES>): RES;
        strip9L(): Internal.Tuple9<any, any, any, any, any, any, any, any, any>;
        strip10L(): Internal.Tuple8<any, any, any, any, any, any, any, any>;
        setB(arg0: B): this;
        setR(arg0: R): this;
        "acceptL(org.zeith.hammerlib.util.java.consumers.Consumer11)"(arg0: Internal.Consumer11_<A, B, C, D, E, F, G, H, I, J, K>): void;
        acceptR(arg0: Internal.Consumer16_<C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R>): void;
        applyR<RES>(arg0: org.zeith.hammerlib.util.java_.functions.Function16_<C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, RES>): RES;
        "acceptL(org.zeith.hammerlib.util.java.consumers.Consumer17)"(arg0: Internal.Consumer17_<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q>): void;
        "acceptR(org.zeith.hammerlib.util.java.consumers.Consumer16)"(arg0: Internal.Consumer16_<C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R>): void;
        "applyR(org.zeith.hammerlib.util.java.functions.Function9)"<RES>(arg0: Internal.Function9_<J, K, L, M, N, O, P, Q, R, RES>): RES;
        strip2R(): Internal.Tuple16<any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any>;
        "applyR(org.zeith.hammerlib.util.java.functions.Function14)"<RES>(arg0: org.zeith.hammerlib.util.java_.functions.Function14_<E, F, G, H, I, J, K, L, M, N, O, P, Q, R, RES>): RES;
        stream(): Internal.Stream<any>;
        equals(arg0: any): boolean;
        acceptL(arg0: Internal.Consumer16_<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P>): void;
        "applyR(org.zeith.hammerlib.util.java.functions.Function10)"<RES>(arg0: org.zeith.hammerlib.util.java_.functions.Function10_<I, J, K, L, M, N, O, P, Q, R, RES>): RES;
        a(): A;
        "applyR(org.zeith.hammerlib.util.java.functions.Function12)"<RES>(arg0: org.zeith.hammerlib.util.java_.functions.Function12_<G, H, I, J, K, L, M, N, O, P, Q, R, RES>): RES;
        setK(arg0: K): this;
        insert(arg0: any, arg1: any, arg2: any, arg3: any, arg4: any, arg5: any, arg6: any): Internal.Tuple25<any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any>;
        "applyR(org.zeith.hammerlib.util.java.functions.Function13)"<RES>(arg0: org.zeith.hammerlib.util.java_.functions.Function13_<F, G, H, I, J, K, L, M, N, O, P, Q, R, RES>): RES;
        "applyL(org.zeith.hammerlib.util.java.functions.Function1)"<RES>(arg0: org.zeith.hammerlib.util.java_.functions.Function1_<A, RES>): RES;
        acceptL(arg0: Internal.Consumer7_<A, B, C, D, E, F, G>): void;
        acceptL(arg0: Internal.Consumer1_<A>): void;
        applyL<RES>(arg0: Internal.Function2_<A, B, RES>): RES;
        i(): I;
        insert(arg0: any, arg1: any, arg2: any, arg3: any, arg4: any, arg5: any): Internal.Tuple24<any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any>;
        applyL<RES>(arg0: Internal.Function7_<A, B, C, D, E, F, G, RES>): RES;
        q(): Q;
        strip7L(): Internal.Tuple11$Mutable11<H, I, J, K, L, M, N, O, P, Q, R>;
        setL(arg0: L): this;
        "applyR(org.zeith.hammerlib.util.java.functions.Function8)"<RES>(arg0: Internal.Function8_<K, L, M, N, O, P, Q, R, RES>): RES;
        acceptL(arg0: Internal.Consumer8_<A, B, C, D, E, F, G, H>): void;
        strip5R(): Internal.Tuple13$Mutable13<A, B, C, D, E, F, G, H, I, J, K, L, M>;
        strip8L(): Internal.Tuple10<any, any, any, any, any, any, any, any, any, any>;
        "applyL(org.zeith.hammerlib.util.java.functions.Function15)"<RES>(arg0: org.zeith.hammerlib.util.java_.functions.Function15_<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, RES>): RES;
        add<S, T, U>(arg0: S, arg1: T, arg2: U): Internal.Tuple21$Mutable21<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U>;
        acceptR(arg0: Internal.Consumer6_<M, N, O, P, Q, R>): void;
        applyR<RES>(arg0: org.zeith.hammerlib.util.java_.functions.Function1_<R, RES>): RES;
        setM(arg0: M): this;
        h(): H;
        applyR<RES>(arg0: Internal.Function9_<J, K, L, M, N, O, P, Q, R, RES>): RES;
        strip5L(): Internal.Tuple13<any, any, any, any, any, any, any, any, any, any, any, any, any>;
        acceptR(arg0: Internal.Consumer10_<I, J, K, L, M, N, O, P, Q, R>): void;
        acceptR(arg0: Internal.Consumer9_<J, K, L, M, N, O, P, Q, R>): void;
        insert(arg0: any, arg1: any, arg2: any, arg3: any): Internal.Tuple22<any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any>;
        applyL<RES>(arg0: Internal.Function8_<A, B, C, D, E, F, G, H, RES>): RES;
        applyR<RES>(arg0: Internal.Function6_<M, N, O, P, Q, R, RES>): RES;
        p(): P;
        applyL<RES>(arg0: org.zeith.hammerlib.util.java_.functions.Function13_<A, B, C, D, E, F, G, H, I, J, K, L, M, RES>): RES;
        toString(): string;
        accept(arg0: Internal.Consumer18_<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R>): void;
        setN(arg0: N): this;
        "acceptR(org.zeith.hammerlib.util.java.consumers.Consumer4)"(arg0: Internal.Consumer4_<O, P, Q, R>): void;
        acceptL(arg0: Internal.Consumer10_<A, B, C, D, E, F, G, H, I, J>): void;
        notifyAll(): void;
        strip16R(): Internal.Tuple2$Mutable2<A, B>;
        acceptL(arg0: Internal.Consumer4_<A, B, C, D>): void;
        "acceptL(org.zeith.hammerlib.util.java.consumers.Consumer14)"(arg0: Internal.Consumer14_<A, B, C, D, E, F, G, H, I, J, K, L, M, N>): void;
        strip9R(): Internal.Tuple9<any, any, any, any, any, any, any, any, any>;
        "applyR(org.zeith.hammerlib.util.java.functions.Function2)"<RES>(arg0: Internal.Function2_<Q, R, RES>): RES;
        "acceptL(org.zeith.hammerlib.util.java.consumers.Consumer3)"(arg0: Internal.Consumer3_<A, B, C>): void;
        immutable(): Internal.Tuple18<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R>;
        strip11R(): Internal.Tuple7$Mutable7<A, B, C, D, E, F, G>;
        applyL<RES>(arg0: org.zeith.hammerlib.util.java_.functions.Function11_<A, B, C, D, E, F, G, H, I, J, K, RES>): RES;
        "applyL(org.zeith.hammerlib.util.java.functions.Function8)"<RES>(arg0: Internal.Function8_<A, B, C, D, E, F, G, H, RES>): RES;
        "applyL(org.zeith.hammerlib.util.java.functions.Function16)"<RES>(arg0: org.zeith.hammerlib.util.java_.functions.Function16_<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, RES>): RES;
        strip15L(): Internal.Tuple3$Mutable3<P, Q, R>;
        copy(): Internal.Tuple18<any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any, any>;
        setG(arg0: G): this;
        "acceptR(org.zeith.hammerlib.util.java.consumers.Consumer13)"(arg0: Internal.Consumer13_<F, G, H, I, J, K, L, M, N, O, P, Q, R>): void;
        "applyL(org.zeith.hammerlib.util.java.functions.Function12)"<RES>(arg0: org.zeith.hammerlib.util.java_.functions.Function12_<A, B, C, D, E, F, G, H, I, J, K, L, RES>): RES;
        g(): G;
        notify(): void;
        acceptL(arg0: Internal.Consumer17_<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q>): void;
        acceptR(arg0: Internal.Consumer4_<O, P, Q, R>): void;
        o(): O;
        acceptR(arg0: Internal.Consumer15_<D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R>): void;
        applyR<RES>(arg0: Internal.Function7_<L, M, N, O, P, Q, R, RES>): RES;
        "acceptR(org.zeith.hammerlib.util.java.consumers.Consumer10)"(arg0: Internal.Consumer10_<I, J, K, L, M, N, O, P, Q, R>): void;
        "applyR(org.zeith.hammerlib.util.java.functions.Function7)"<RES>(arg0: Internal.Function7_<L, M, N, O, P, Q, R, RES>): RES;
        strip17L(): Internal.Tuple1$Mutable1<R>;
        acceptR(arg0: Internal.Consumer14_<E, F, G, H, I, J, K, L, M, N, O, P, Q, R>): void;
        strip8R(): Internal.Tuple10<any, any, any, any, any, any, any, any, any, any>;
        "applyL(org.zeith.hammerlib.util.java.functions.Function2)"<RES>(arg0: Internal.Function2_<A, B, RES>): RES;
        setH(arg0: H): this;
        "acceptL(org.zeith.hammerlib.util.java.consumers.Consumer10)"(arg0: Internal.Consumer10_<A, B, C, D, E, F, G, H, I, J>): void;
        acceptL(arg0: Internal.Consumer2_<A, B>): void;
        "acceptR(org.zeith.hammerlib.util.java.consumers.Consumer17)"(arg0: Internal.Consumer17_<B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R>): void;
        "acceptL(org.zeith.hammerlib.util.java.consumers.Consumer12)"(arg0: Internal.Consumer12_<A, B, C, D, E, F, G, H, I, J, K, L>): void;
        add<S, T, U, V, W, X>(arg0: S, arg1: T, arg2: U, arg3: V, arg4: W, arg5: X): Internal.Tuple24$Mutable24<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V, W, X>;
        acceptL(arg0: Internal.Consumer14_<A, B, C, D, E, F, G, H, I, J, K, L, M, N>): void;
        "applyR(org.zeith.hammerlib.util.java.functions.Function17)"<RES>(arg0: Internal.Function17_<B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, RES>): RES;
        acceptL(arg0: Internal.Consumer6_<A, B, C, D, E, F>): void;
        applyR<RES>(arg0: Internal.Function8_<K, L, M, N, O, P, Q, R, RES>): RES;
        acceptR(arg0: Internal.Consumer3_<P, Q, R>): void;
        setI(arg0: I): this;
        f(): F;
        strip12R(): Internal.Tuple6<any, any, any, any, any, any>;
        acceptL(arg0: Internal.Consumer9_<A, B, C, D, E, F, G, H, I>): void;
        wait(arg0: number, arg1: number): void;
        acceptL(arg0: Internal.Consumer11_<A, B, C, D, E, F, G, H, I, J, K>): void;
        strip6L(): Internal.Tuple12<any, any, any, any, any, any, any, any, any, any, any, any>;
        "applyR(org.zeith.hammerlib.util.java.functions.Function4)"<RES>(arg0: Internal.Function4_<O, P, Q, R, RES>): RES;
        n(): N;
        add<S, T, U, V, W, X, Y>(arg0: S, arg1: T, arg2: U, arg3: V, arg4: W, arg5: X, arg6: Y): Internal.Tuple25$Mutable25<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V, W, X, Y>;
        setJ(arg0: J): this;
        "applyL(org.zeith.hammerlib.util.java.functions.Function4)"<RES>(arg0: Internal.Function4_<A, B, C, D, RES>): RES;
        arity(): number;
        add<S>(arg0: S): Internal.Tuple19$Mutable19<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S>;
        applyR<RES>(arg0: org.zeith.hammerlib.util.java_.functions.Function14_<E, F, G, H, I, J, K, L, M, N, O, P, Q, R, RES>): RES;
        hashCode(): number;
        strip14R(): Internal.Tuple4$Mutable4<A, B, C, D>;
        "acceptL(org.zeith.hammerlib.util.java.consumers.Consumer6)"(arg0: Internal.Consumer6_<A, B, C, D, E, F>): void;
        "acceptR(org.zeith.hammerlib.util.java.consumers.Consumer8)"(arg0: Internal.Consumer8_<K, L, M, N, O, P, Q, R>): void;
        "acceptL(org.zeith.hammerlib.util.java.consumers.Consumer16)"(arg0: Internal.Consumer16_<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P>): void;
        "acceptR(org.zeith.hammerlib.util.java.consumers.Consumer15)"(arg0: Internal.Consumer15_<D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R>): void;
        "acceptR(org.zeith.hammerlib.util.java.consumers.Consumer7)"(arg0: Internal.Consumer7_<L, M, N, O, P, Q, R>): void;
        set c(arg0: C)
        set d(arg0: D)
        get class(): typeof any
        set e(arg0: E)
        set f(arg0: F)
        set o(arg0: O)
        set p(arg0: P)
        set a(arg0: A)
        set q(arg0: Q)
        set b(arg0: B)
        set r(arg0: R)
        set k(arg0: K)
        set l(arg0: L)
        set m(arg0: M)
        set n(arg0: N)
        set g(arg0: G)
        set h(arg0: H)
        set i(arg0: I)
        set j(arg0: J)
    }
    type Tuple18$Mutable18_<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R> = Tuple18$Mutable18<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R>;
    interface ITrackedContentsItemHandler extends Internal.IItemHandlerSimpleInserter {
        count(ingredient: Internal.Ingredient_): number;
        count(): number;
        "insertItem(net.minecraft.world.item.ItemStack,boolean)"(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        abstract setStackInSlot(arg0: number, arg1: Internal.ItemStack_): void;
        isEmpty(): boolean;
        abstract unregisterStackKeyListeners(): void;
        clear(ingredient: Internal.Ingredient_): void;
        "extractItem(int,int,boolean)"(i: number, i1: number, b: boolean): Internal.ItemStack;
        find(): number;
        abstract getSlots(): number;
        abstract extractItem(arg0: number, arg1: number, arg2: boolean): Internal.ItemStack;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        setChanged(): void;
        "getSlots()"(): number;
        kjs$self(): Internal.IItemHandler;
        abstract registerTrackingListeners(arg0: Internal.Consumer_<net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey>, arg1: Internal.Consumer_<net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey>, arg2: Internal.Runnable_, arg3: Internal.Runnable_): void;
        getStackInSlot(i: number): Internal.ItemStack;
        abstract hasEmptySlots(): boolean;
        getHeight(): number;
        countNonEmpty(): number;
        "insertItem(int,net.minecraft.world.item.ItemStack,boolean)"(i: number, itemStack: Internal.ItemStack_, b: boolean): Internal.ItemStack;
        abstract "getStackInSlot(int)"(arg0: number): Internal.ItemStack;
        asContainer(): net.minecraft.world.Container;
        abstract "getSlotLimit(int)"(arg0: number): number;
        getWidth(): number;
        abstract getSlotLimit(arg0: number): number;
        getAllItems(): Internal.List<Internal.ItemStack>;
        abstract getTrackedStacks(): Internal.Set<net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey>;
        abstract getInternalSlotLimit(arg0: number): number;
        abstract insertItem(arg0: Internal.ItemStack_, arg1: boolean): Internal.ItemStack;
        abstract insertItem(arg0: number, arg1: Internal.ItemStack_, arg2: boolean): Internal.ItemStack;
        "isItemValid(int,net.minecraft.world.item.ItemStack)"(i: number, itemStack: Internal.ItemStack_): boolean;
        "setStackInSlot(int,net.minecraft.world.item.ItemStack)"(slot: number, stack: Internal.ItemStack_): void;
        isMutable(): boolean;
        clear(): void;
        find(ingredient: Internal.Ingredient_): number;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        abstract isItemValid(arg0: number, arg1: Internal.ItemStack_): boolean;
        get empty(): boolean
        get slots(): number
        get "slots()"(): number
        get height(): number
        get width(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get trackedStacks(): Internal.Set<net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey>
        get mutable(): boolean
    }
    type ITrackedContentsItemHandler_ = ITrackedContentsItemHandler;
    interface ItemSupplier {
        abstract getItem(): Internal.ItemStack;
        get item(): Internal.ItemStack
        (): Internal.ItemStack_;
    }
    type ItemSupplier_ = ItemSupplier | (()=> Internal.ItemStack_);
    interface ChestMenuInventoryClickEvent$Callback {
        abstract onClick(arg0: Internal.ChestMenuInventoryClickEvent_): void;
        (arg0: Internal.ChestMenuInventoryClickEvent): void;
    }
    type ChestMenuInventoryClickEvent$Callback_ = ChestMenuInventoryClickEvent$Callback | ((arg0: Internal.ChestMenuInventoryClickEvent)=> void);
    interface Boolean2ObjectFunction <V> extends it.unimi.dsi.fastutil.Function<boolean, V> {
        put(arg0: boolean, arg1: V): V;
        andThenShort(arg0: Internal.Object2ShortFunction_<V>): Internal.Boolean2ShortFunction;
        andThenObject<T>(arg0: Internal.Object2ObjectFunction_<V, T>): Internal.Boolean2ObjectFunction<T>;
        composeFloat(arg0: Internal.Float2BooleanFunction_): Internal.Float2ObjectFunction<V>;
        composeReference<T>(arg0: Internal.Reference2BooleanFunction_<T>): Internal.Reference2ObjectFunction<T, V>;
        /**
         * @deprecated
        */
        "getOrDefault(java.lang.Object,java.lang.Object)"(arg0: any, arg1: V): V;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: V): V;
        /**
         * @deprecated
        */
        "put(java.lang.Object,java.lang.Object)"(arg0: any, arg1: any): any;
        andThenDouble(arg0: Internal.Object2DoubleFunction_<V>): Internal.Boolean2DoubleFunction;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        andThenFloat(arg0: Internal.Object2FloatFunction_<V>): Internal.Boolean2FloatFunction;
        "remove(boolean)"(arg0: boolean): V;
        composeLong(arg0: Internal.Long2BooleanFunction_): Internal.Long2ObjectFunction<V>;
        andThenInt(arg0: Internal.Object2IntFunction_<V>): Internal.Boolean2IntFunction;
        /**
         * @deprecated
        */
        put(arg0: boolean, arg1: V): V;
        /**
         * @deprecated
        */
        "get(java.lang.Object)"(arg0: any): V;
        /**
         * @deprecated
        */
        get(arg0: any): V;
        /**
         * @deprecated
        */
        "put(java.lang.Boolean,java.lang.Object)"(arg0: boolean, arg1: V): V;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        /**
         * @deprecated
        */
        remove(arg0: any): V;
        andThenLong(arg0: Internal.Object2LongFunction_<V>): Internal.Boolean2LongFunction;
        "containsKey(boolean)"(arg0: boolean): boolean;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, boolean>): Internal.Function<T, V>;
        apply(arg0: boolean): V;
        "getOrDefault(boolean,java.lang.Object)"(arg0: boolean, arg1: V): V;
        abstract get(arg0: boolean): V;
        abstract "get(boolean)"(arg0: boolean): V;
        andThenByte(arg0: Internal.Object2ByteFunction_<V>): Internal.Boolean2ByteFunction;
        andThen<V>(arg0: Internal.Function_<V, V>): Internal.Function<boolean, V>;
        composeShort(arg0: Internal.Short2BooleanFunction_): Internal.Short2ObjectFunction<V>;
        composeInt(arg0: Internal.Int2BooleanFunction_): Internal.Int2ObjectFunction<V>;
        composeChar(arg0: Internal.Char2BooleanFunction_): Internal.Char2ObjectFunction<V>;
        "put(boolean,java.lang.Object)"(arg0: boolean, arg1: V): V;
        containsKey(arg0: boolean): boolean;
        andThenReference<T>(arg0: Internal.Object2ReferenceFunction_<V, T>): Internal.Boolean2ReferenceFunction<T>;
        composeObject<T>(arg0: Internal.Object2BooleanFunction_<T>): Internal.Object2ObjectFunction<T, V>;
        remove(arg0: boolean): V;
        size(): number;
        composeDouble(arg0: Internal.Double2BooleanFunction_): Internal.Double2ObjectFunction<V>;
        clear(): void;
        composeByte(arg0: Internal.Byte2BooleanFunction_): Internal.Byte2ObjectFunction<V>;
        defaultReturnValue(): V;
        getOrDefault(arg0: boolean, arg1: V): V;
        identity<T>(): Internal.Function<T, T>;
        defaultReturnValue(arg0: V): void;
        /**
         * @deprecated
        */
        "remove(java.lang.Object)"(arg0: any): V;
        andThenChar(arg0: Internal.Object2CharFunction_<V>): Internal.Boolean2CharFunction;
        /**
         * @deprecated
        */
        "containsKey(java.lang.Object)"(arg0: any): boolean;
    }
    type Boolean2ObjectFunction_<V> = Boolean2ObjectFunction<V>;
    class CaughtMobWithVariantsItem extends Internal.CaughtMobItem {
        constructor(entitySupplier: Internal.Supplier_<Internal.EntityType<any>>, fluidSupplier: Internal.Supplier_<Internal.Fluid>, soundSupplier: Internal.Supplier_<Internal.SoundEvent>, variantCount: number, properties: Internal.Item$Properties_)
        getDrinkingSound(): Internal.SoundEvent;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        moonlight$addAdditionalBehavior(placementOverride: Internal.AdditionalItemPlacement_): void;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isComplex(): boolean;
        forciblyAllowsTableEnchantment(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        appendHoverText(stack: Internal.ItemStack_, worldIn: Internal.Level_, tooltip: Internal.List_<net.minecraft.network.chat.Component>, flagIn: Internal.TooltipFlag_): void;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        moonlight$getClientAnimationExtension(): any;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getTypeData(): Internal.CompoundTag;
        getDefaultInstance(): Internal.ItemStack;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setBurnTime(i: number): void;
        setMaxStackSize(arg0: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getItem(): Internal.Item;
        getBarColor(arg0: Internal.ItemStack_): number;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        asIngredient(): Internal.Ingredient;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        static byId(arg0: number): Internal.Item;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        moonlight$getAdditionalBehavior(): Internal.AdditionalItemPlacement;
        moonlight$setClientAnimationExtension(obj: any): void;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        static getEmptySuccessItem(bucketStack: Internal.ItemStack_, player: Internal.Player_): Internal.ItemStack;
        selectEnchantments(arg0: Internal.List_<Internal.EnchantmentInstance>, arg1: Internal.RandomSource_, arg2: Internal.ItemStack_, arg3: number, arg4: number, arg5: number, arg6: boolean): Internal.List<Internal.EnchantmentInstance>;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: Internal.EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(pLevel: Internal.Level_, pPlayer: Internal.Player_, pHand: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        toString(): string;
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        handler$eba000$initializeClient(consumer: Internal.Consumer_<any>, ci: Internal.CallbackInfo_): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        /**
         * @deprecated
        */
        emptyContents(arg0: Internal.Player_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockHitResult_): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        getFluid(): Internal.Fluid;
        canEquip(arg0: Internal.ItemStack_, arg1: Internal.EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        checkExtraContent(player: Internal.Player_, level: Internal.Level_, containerStack: Internal.ItemStack_, pos: BlockPos_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        arch$getFluid(): Internal.Fluid;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        onEnchantment(arg0: Internal.ItemStack_, arg1: Internal.List_<Internal.EnchantmentInstance>): Internal.ItemStack;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): Internal.EquipmentSlot;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        emptyContents(arg0: Internal.Player_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockHitResult_, arg4: Internal.ItemStack_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        getTypeItemStackKey(): Internal.ItemStackKey;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isTreasureAllowed(arg0: Internal.ItemStack_, arg1: boolean): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        static "getEmptySuccessItem(net.minecraft.world.item.ItemStack,net.minecraft.world.entity.player.Player)"(arg0: Internal.ItemStack_, arg1: Internal.Player_): Internal.ItemStack;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get typeData(): Internal.CompoundTag
        get defaultInstance(): Internal.ItemStack
        set burnTime(i: number)
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        set itemBuilder(b: Internal.ItemBuilder_)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        get fluid(): Internal.Fluid
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
    }
    type CaughtMobWithVariantsItem_ = CaughtMobWithVariantsItem;
    class ExperienceNuggetItem extends Internal.Item {
        constructor(arg0: Internal.Item$Properties_)
        getDrinkingSound(): Internal.SoundEvent;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        moonlight$addAdditionalBehavior(placementOverride: Internal.AdditionalItemPlacement_): void;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isComplex(): boolean;
        forciblyAllowsTableEnchantment(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        moonlight$getClientAnimationExtension(): any;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getTypeData(): Internal.CompoundTag;
        getDefaultInstance(): Internal.ItemStack;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setBurnTime(i: number): void;
        setMaxStackSize(arg0: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getItem(): Internal.Item;
        getBarColor(arg0: Internal.ItemStack_): number;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        asIngredient(): Internal.Ingredient;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        static byId(arg0: number): Internal.Item;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        moonlight$getAdditionalBehavior(): Internal.AdditionalItemPlacement;
        moonlight$setClientAnimationExtension(obj: any): void;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        selectEnchantments(arg0: Internal.List_<Internal.EnchantmentInstance>, arg1: Internal.RandomSource_, arg2: Internal.ItemStack_, arg3: number, arg4: number, arg5: number, arg6: boolean): Internal.List<Internal.EnchantmentInstance>;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: Internal.EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        toString(): string;
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        handler$eba000$initializeClient(consumer: Internal.Consumer_<any>, ci: Internal.CallbackInfo_): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: Internal.EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        onEnchantment(arg0: Internal.ItemStack_, arg1: Internal.List_<Internal.EnchantmentInstance>): Internal.ItemStack;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): Internal.EquipmentSlot;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        getTypeItemStackKey(): Internal.ItemStackKey;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isTreasureAllowed(arg0: Internal.ItemStack_, arg1: boolean): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get typeData(): Internal.CompoundTag
        get defaultInstance(): Internal.ItemStack
        set burnTime(i: number)
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        set itemBuilder(b: Internal.ItemBuilder_)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
    }
    type ExperienceNuggetItem_ = ExperienceNuggetItem;
    class HoeItemBuilder extends Internal.HandheldItemBuilder {
        constructor(i: ResourceLocation_)
        static toToolTier(o: any): Internal.Tier;
        /**
         * Adds subtypes to the item. The function should return a collection of item stacks, each with a different subtype.
         * 
         * Each subtype will appear as a separate item in JEI and the creative inventory.
        */
        subtypes(fn: Internal.Function_<Internal.ItemStack, Internal.Collection<Internal.ItemStack>>): Internal.ItemBuilder;
        createAdditionalObjects(): void;
        /**
         * Gets called when the item is used to hurt an entity.
         * 
         * For example, when using a sword to hit a mob, this is called.
        */
        hurtEnemy(context: Internal.Predicate_<Internal.ItemBuilder$HurtEnemyContext>): Internal.ItemBuilder;
        getTranslationKeyGroup(): string;
        notify(): void;
        get(): Internal.Item;
        /**
         * Makes the item not stackable, equivalent to setting the item's max stack size to 1.
        */
        unstackable(): Internal.ItemBuilder;
        /**
         * Colorizes item's texture of the given index. Index is used when you have multiple layers, e.g. a crushed ore (of rock + ore).
        */
        color(index: number, color: Internal.ItemTintFunction_): Internal.ItemBuilder;
        /**
         * When players finish using the item.
         * 
         * This is called only when `useDuration` ticks have passed.
         * 
         * For example, when eating food, this is called when the player has finished eating the food, so hunger is restored.
        */
        finishUsing(finishUsing: Internal.ItemBuilder$FinishUsingCallback_): Internal.ItemBuilder;
        getRegistryType(): Internal.RegistryInfo<any>;
        /**
         * Modifies the tool tier.
        */
        modifyTier(callback: Internal.Consumer_<Internal.MutableToolTier>): Internal.HandheldItemBuilder;
        /**
         * Adds an attribute modifier to the item.
         * 
         * An attribute modifier is something like a damage boost or a speed boost.
         * On tools, they're applied when the item is held, on armor, they're
         * applied when the item is worn.
         * @param attribute The resource location of the attribute, e.g. 'generic.attack_damage'
         * @param identifier A unique identifier for the modifier. Modifiers are considered the same if they have the same identifier.
         * @param d The amount of the modifier.
         * @param operation The operation to apply the modifier with. Can be ADDITION, MULTIPLY_BASE, or MULTIPLY_TOTAL.
        */
        modifyAttribute(attribute: ResourceLocation_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): Internal.ItemBuilder;
        /**
         * Sets the item's model (parent).
        */
        parentModel(m: string): Internal.ItemBuilder;
        /**
         * Colorizes item's texture of the given index. Useful for coloring items, like GT ores ore dusts.
        */
        color(callback: Internal.ItemTintFunction_): Internal.ItemBuilder;
        /**
         * Sets the item's max stack size. Default is 64.
        */
        maxStackSize(v: number): Internal.ItemBuilder;
        /**
         * Adds a tooltip to the item.
        */
        tooltip(text: net.minecraft.network.chat.Component_): Internal.ItemBuilder;
        "transformObject(net.minecraft.world.item.Item)"(obj: Internal.Item_): Internal.Item;
        /**
         * Determines the width of the item's durability bar. Defaulted to vanilla behavior.
         * 
         * The function should return a value between 0 and 13 (max width of the bar).
        */
        barWidth(barWidth: Internal.ToIntFunction_<Internal.ItemStack>): Internal.ItemBuilder;
        /**
         * Combined method of formattedDisplayName().displayName(name).
        */
        formattedDisplayName(name: net.minecraft.network.chat.Component_): Internal.BuilderBase<Internal.Item>;
        /**
         * Sets the base attack speed of the tool. Different tools have different baselines.
         * 
         * For example, a sword has a baseline of -2.4, while an axe has a baseline of -3.1.
         * 
         * The actual speed is the sum of the baseline and the speed from tier + 4 (bare hand).
        */
        speedBaseline(f: number): Internal.HandheldItemBuilder;
        /**
         * Sets the item's rarity.
        */
        rarity(v: Internal.Rarity_): Internal.ItemBuilder;
        /**
         * Makes the item fire resistant like netherite tools.
        */
        fireResistant(): Internal.ItemBuilder;
        /**
         * Sets the display name for this object, e.g. `Stone`.
         * 
         * This will be overridden by a lang file if it exists.
        */
        displayName(name: net.minecraft.network.chat.Component_): Internal.BuilderBase<Internal.Item>;
        /**
         * Determines the animation of the item when used, e.g. eating food.
        */
        useAnimation(animation: Internal.UseAnim_): Internal.ItemBuilder;
        tier(t: Internal.Tier_): Internal.HandheldItemBuilder;
        getBuilderTranslationKey(): string;
        /**
         * Determines if player will start using the item.
         * 
         * For example, when eating food, returning true will make the player start eating the food.
        */
        use(use: Internal.ItemBuilder$UseCallback_): Internal.ItemBuilder;
        /**
         * When players did not finish using the item but released the right mouse button halfway through.
         * 
         * An example is the bow, where the arrow is shot when the player releases the right mouse button.
         * 
         * To ensure the bow won't finish using, Minecraft sets the `useDuration` to a very high number (1h).
        */
        releaseUsing(releaseUsing: Internal.ItemBuilder$ReleaseUsingCallback_): Internal.ItemBuilder;
        /**
         * Sets the item's container item, e.g. a bucket for a milk bucket.
        */
        containerItem(id: ResourceLocation_): Internal.ItemBuilder;
        wait(): void;
        /**
         * Sets the item's burn time. Default is 0 (Not a fuel).
        */
        burnTime(v: number): Internal.ItemBuilder;
        /**
         * Directlys set the item's texture json.
        */
        textureJson(json: Internal.JsonObject_): Internal.ItemBuilder;
        static toArmorMaterial(o: any): Internal.ArmorMaterial;
        generateLang(lang: Internal.LangEventJS_): void;
        /**
         * The duration when the item is used.
         * 
         * For example, when eating food, this is the time it takes to eat the food.
         * This can change the eating speed, or be used for other things (like making a custom bow).
        */
        useDuration(useDuration: Internal.ToIntFunction_<Internal.ItemStack>): Internal.ItemBuilder;
        /**
         * Sets the attack speed of the tool.
        */
        speed(f: number): Internal.HandheldItemBuilder;
        getClass(): typeof any;
        /**
         * Makes the item fire resistant like netherite tools (or not).
        */
        fireResistant(isFireResistant: boolean): Internal.ItemBuilder;
        /**
         * Sets the item's texture by given key.
        */
        texture(key: string, tex: string): Internal.ItemBuilder;
        /**
         * Sets the item's max damage. Default is 0 (No durability).
        */
        maxDamage(v: number): Internal.ItemBuilder;
        "transformObject(java.lang.Object)"(arg0: any): any;
        wait(arg0: number, arg1: number): void;
        /**
         * Sets the item's name dynamically.
        */
        name(name: Internal.ItemBuilder$NameCallback_): Internal.ItemBuilder;
        createItemProperties(): Internal.Item$Properties;
        generateDataJsons(generator: Internal.DataJsonGenerator_): void;
        createObject(): Internal.Item;
        /**
         * Sets the base attack damage of the tool. Different tools have different baselines.
         * 
         * For example, a sword has a baseline of 3, while an axe has a baseline of 6.
         * 
         * The actual damage is the sum of the baseline and the attackDamageBonus from tier.
        */
        attackDamageBaseline(f: number): Internal.HandheldItemBuilder;
        /**
         * Makes the item glow like enchanted, even if it's not enchanted.
        */
        glow(v: boolean): Internal.ItemBuilder;
        transformObject(arg0: any): any;
        /**
         * Directly set the item's model json.
        */
        modelJson(json: Internal.JsonObject_): Internal.ItemBuilder;
        toString(): string;
        /**
         * Set the food properties of the item.
        */
        food(b: Internal.Consumer_<Internal.FoodBuilder>): Internal.ItemBuilder;
        notifyAll(): void;
        /**
         * Makes displayName() override language files.
        */
        formattedDisplayName(): Internal.BuilderBase<Internal.Item>;
        hashCode(): number;
        /**
         * Sets the item's texture (layer0).
        */
        texture(tex: string): Internal.ItemBuilder;
        transformObject(obj: Internal.Item_): Internal.Item;
        wait(arg0: number): void;
        /**
         * Determines the color of the item's durability bar. Defaulted to vanilla behavior.
        */
        barColor(barColor: Internal.Function_<Internal.ItemStack, dev.latvian.mods.rhino.mod.util.color.Color>): Internal.ItemBuilder;
        /**
         * Adds a tag to this object, e.g. `minecraft:stone`.
        */
        tag(tag: ResourceLocation_): Internal.BuilderBase<Internal.Item>;
        /**
         * Sets the translation key for this object, e.g. `block.minecraft.stone`.
        */
        translationKey(key: string): Internal.BuilderBase<Internal.Item>;
        /**
         * Sets the attack damage bonus of the tool.
        */
        attackDamageBonus(f: number): Internal.HandheldItemBuilder;
        equals(arg0: any): boolean;
        newID(pre: string, post: string): ResourceLocation;
        /**
         * @deprecated
        */
        group(g: string): Internal.ItemBuilder;
        generateAssetJsons(generator: Internal.AssetJsonGenerator_): void;
        get translationKeyGroup(): string
        get registryType(): Internal.RegistryInfo<any>
        get builderTranslationKey(): string
        get class(): typeof any
    }
    type HoeItemBuilder_ = HoeItemBuilder;
    class ManagedBool extends Internal.AbstractManagedData<boolean> {
        constructor(arg0: string, arg1: boolean, ...arg2: Internal.DataFlags_[])
        constructor(arg0: string, ...arg1: Internal.DataFlags_[])
        getClass(): typeof any;
        toNBT(arg0: Internal.CompoundTag_): void;
        getIndex(): number;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        set(arg0: boolean): boolean;
        fromNBT(arg0: Internal.CompoundTag_): void;
        getName(): string;
        validate(): void;
        invert(): boolean;
        markDirty(): void;
        toString(): string;
        init(arg0: Internal.IDataManager_, arg1: number): void;
        addFlags(...arg0: Internal.DataFlags_[]): void;
        notifyAll(): void;
        addValueListener(arg0: Internal.Consumer_<boolean>): void;
        get(): boolean;
        setValidator(arg0: Internal.Function_<boolean, boolean>): this;
        removeValueListener(arg0: Internal.Consumer_<boolean>): void;
        isDirty(arg0: boolean): boolean;
        fromBytes(arg0: Internal.MCDataInput_): void;
        hashCode(): number;
        wait(): void;
        setCCSCS(): void;
        wait(arg0: number): void;
        getDataManager(): Internal.IDataManager;
        flags(): Internal.DataFlags;
        toBytes(arg0: Internal.MCDataOutput_): void;
        equals(arg0: any): boolean;
        get class(): typeof any
        get index(): number
        get name(): string
        set validator(arg0: Internal.Function_<boolean, boolean>)
        get dataManager(): Internal.IDataManager
    }
    type ManagedBool_ = ManagedBool;
    class CustomTask extends Internal.Task {
        constructor(id: number, quest: Internal.Quest_)
        getRelativeProgressFromChildren(data: Internal.TeamData_): number;
        isCompletedRaw(data: Internal.TeamData_): boolean;
        submitTask(teamData: Internal.TeamData_, player: Internal.ServerPlayer_, craftedItem: Internal.ItemStack_): void;
        writeData(nbt: Internal.CompoundTag_): void;
        getMutableTitle(): Internal.MutableComponent;
        readData(nbt: Internal.CompoundTag_): void;
        getType(): Internal.TaskType;
        getMaxProgress(): number;
        editedFromGUI(): void;
        consumesResources(): boolean;
        getQuest(): Internal.Quest;
        formatMaxProgress(): string;
        notify(): void;
        compareTo(arg0: any): number;
        clearCachedData(): void;
        canInsertItem(): boolean;
        setCheckTimer(checkTimer: number): void;
        getRawTitle(): string;
        getProgressColor(data: Internal.TeamData_): Internal.Color4I;
        static isNull(object: Internal.QuestObjectBase_): boolean;
        hideProgressNumbers(): boolean;
        cacheProgress(): boolean;
        deleteSelf(): void;
        componentsToRefresh(): Internal.Set<Internal.RecipeModHelper$Components>;
        static getID(object: Internal.QuestObjectBase_): number;
        hasUnclaimedRewardsRaw(teamData: Internal.TeamData_, player: Internal.UUID_): boolean;
        isValid(): boolean;
        onCompleted(data: Internal.QuestProgressEventData_<any>): void;
        static parseCodeString(id: string): number;
        getButtonText(): Internal.MutableComponent;
        onButtonClicked(button: dev.ftb.mods.ftblibrary.ui.Button_, canClick: boolean): void;
        deleteChildren(): void;
        addTitleInMouseOverText(): boolean;
        static getRelativeProgressFromChildren(progressSum: number, count: number): number;
        getTags(): Internal.Set<string>;
        forceProgress(teamData: Internal.TeamData_, progressChange: Internal.ProgressChange_): void;
        getChildren(): Internal.Collection<Internal.QuestObject>;
        static "getCodeString(dev.ftb.mods.ftbquests.quest.QuestObjectBase)"(object: Internal.QuestObjectBase_): string;
        autoSubmitOnPlayerTick(): number;
        wait(): void;
        getTitle(): net.minecraft.network.chat.Component;
        setRawIcon(rawIcon: Internal.ItemStack_): void;
        static shouldSendNotifications(): boolean;
        "compareTo(java.lang.Object)"(arg0: any): number;
        drawGUI(teamData: Internal.TeamData_, graphics: Internal.GuiGraphics_, x: number, y: number, w: number, h: number): void;
        getAltIcon(): Internal.Icon;
        onEditButtonClicked(gui: Internal.Runnable_): void;
        static titleToID(s: string): Internal.Optional<string>;
        getClass(): typeof any;
        getProgressColor(data: Internal.TeamData_, dim: boolean): Internal.Color4I;
        static getCodeString(object: Internal.QuestObjectBase_): string;
        static copy<T extends Internal.QuestObjectBase>(orig: T, factory: Internal.Supplier_<T>): T;
        getCodeString(): string;
        static getCodeString(id: number): string;
        setEnableButton(enableButton: boolean): void;
        createSubGroup(group: Internal.ConfigGroup_): Internal.ConfigGroup;
        isOptionalForProgression(): boolean;
        getParentID(): number;
        wait(arg0: number, arg1: number): void;
        fillConfigGroup(config: Internal.ConfigGroup_): void;
        getIcon(): Internal.Icon;
        addMouseOverText(list: Internal.TooltipList_, teamData: Internal.TeamData_): void;
        setMaxProgress(maxProgress: number): void;
        addMouseOverHeader(list: Internal.TooltipList_, teamData: Internal.TeamData_, advanced: boolean): void;
        getAltTitle(): net.minecraft.network.chat.Component;
        static "getCodeString(long)"(id: number): string;
        "compareTo(dev.ftb.mods.ftbquests.quest.QuestObjectBase)"(other: Internal.QuestObjectBase_): number;
        readNetData(buffer: Internal.FriendlyByteBuf_): void;
        hasTag(tag: string): boolean;
        compareTo(other: Internal.QuestObjectBase_): number;
        setRawTitle(rawTitle: string): void;
        toString(): string;
        onStarted(data: Internal.QuestProgressEventData_<any>): void;
        getIngredient(widget: Internal.Widget_): Internal.Optional<Internal.PositionedIngredient>;
        setCheck(check: Internal.CustomTask$Check_): void;
        getQuestChapter(): Internal.Chapter;
        notifyAll(): void;
        submitItemsOnInventoryChange(): boolean;
        getObjectType(): Internal.QuestObjectType;
        getQuestFile(): Internal.BaseQuestFile;
        submitTask(teamData: Internal.TeamData_, player: Internal.ServerPlayer_): void;
        forceProgressRaw(teamData: Internal.TeamData_, progressChange: Internal.ProgressChange_): void;
        static parseHexId(id: string): Internal.Optional<number>;
        hashCode(): number;
        checkOnLogin(): boolean;
        getPath(): Internal.Optional<string>;
        writeNetData(buffer: Internal.FriendlyByteBuf_): void;
        isVisible(data: Internal.TeamData_): boolean;
        editedFromGUIOnServer(): void;
        onCreated(): void;
        wait(arg0: number): void;
        formatProgress(teamData: Internal.TeamData_, progress: number): string;
        equals(object: any): boolean;
        get mutableTitle(): Internal.MutableComponent
        get type(): Internal.TaskType
        get maxProgress(): number
        get quest(): Internal.Quest
        set checkTimer(checkTimer: number)
        get rawTitle(): string
        get valid(): boolean
        get buttonText(): Internal.MutableComponent
        get tags(): Internal.Set<string>
        get children(): Internal.Collection<Internal.QuestObject>
        get title(): net.minecraft.network.chat.Component
        set rawIcon(rawIcon: Internal.ItemStack_)
        get altIcon(): Internal.Icon
        get class(): typeof any
        get codeString(): string
        set enableButton(enableButton: boolean)
        get optionalForProgression(): boolean
        get parentID(): number
        get icon(): Internal.Icon
        set maxProgress(maxProgress: number)
        get altTitle(): net.minecraft.network.chat.Component
        set rawTitle(rawTitle: string)
        set check(check: Internal.CustomTask$Check_)
        get questChapter(): Internal.Chapter
        get objectType(): Internal.QuestObjectType
        get questFile(): Internal.BaseQuestFile
        get path(): Internal.Optional<string>
        static readonly PREDICATE: Internal.Predicate<Internal.QuestObjectBase>;
    }
    type CustomTask_ = CustomTask;
    class SwampPillarFeature extends Internal.AbstractSwampFeature<Internal.ResourceLocationFeatureConfiguration> {
        constructor()
        getClass(): typeof any;
        place(arg0: Internal.FeaturePlaceContext_<Internal.ResourceLocationFeatureConfiguration>): boolean;
        toString(): string;
        static checkNeighbors(arg0: Internal.Function_<BlockPos, Internal.BlockState>, arg1: BlockPos_, arg2: Internal.Predicate_<Internal.BlockState>): boolean;
        notifyAll(): void;
        notify(): void;
        static isAdjacentToAir(arg0: Internal.Function_<BlockPos, Internal.BlockState>, arg1: BlockPos_): boolean;
        wait(arg0: number, arg1: number): void;
        place(arg0: Internal.ResourceLocationFeatureConfiguration_, arg1: Internal.WorldGenLevel_, arg2: Internal.ChunkGenerator_, arg3: Internal.RandomSource_, arg4: BlockPos_): boolean;
        static isGrassOrDirt(arg0: Internal.LevelSimulatedReader_, arg1: BlockPos_): boolean;
        hashCode(): number;
        wait(): void;
        wait(arg0: number): void;
        configuredCodec(): Internal.Codec<Internal.ConfiguredFeature<Internal.ResourceLocationFeatureConfiguration, Internal.Feature<Internal.ResourceLocationFeatureConfiguration>>>;
        static isDirt(arg0: Internal.BlockState_): boolean;
        equals(arg0: any): boolean;
        static isReplaceable(arg0: Internal.TagKey_<Internal.Block>): Internal.Predicate<Internal.BlockState>;
        get class(): typeof any
    }
    type SwampPillarFeature_ = SwampPillarFeature;
    class MinersFervorEnchant extends Internal.DiggingEnchantment {
        constructor()
        getClass(): typeof any;
        getFullname(arg0: number): net.minecraft.network.chat.Component;
        breakSpeed(arg0: Internal.PlayerEvent$BreakSpeed_): void;
        getDamageProtection(arg0: number, arg1: DamageSource_): number;
        getRarity(): Internal.Enchantment$Rarity;
        isCompatibleWith(arg0: Internal.Enchantment_): boolean;
        isTradeable(): boolean;
        isTreasureOnly(): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        getMaxCost(arg0: number): number;
        isDiscoverable(): boolean;
        getMinCost(arg0: number): number;
        static byId(arg0: number): Internal.Enchantment;
        handler$zii000$apoth_modifyEnchColorForAboveMaxLevel(arg0: number, arg1: Internal.CallbackInfoReturnable_<any>): void;
        doPostHurt(arg0: Internal.LivingEntity_, arg1: Internal.Entity_, arg2: number): void;
        getDescriptionId(): string;
        toString(): string;
        getMaxLevel(): number;
        doPostAttack(arg0: Internal.LivingEntity_, arg1: Internal.Entity_, arg2: number): void;
        notifyAll(): void;
        getMinLevel(): number;
        getSlotItems(arg0: Internal.LivingEntity_): Internal.Map<Internal.EquipmentSlot, Internal.ItemStack>;
        /**
         * @deprecated
        */
        getDamageBonus(arg0: number, arg1: Internal.MobType_): number;
        hashCode(): number;
        isCurse(): boolean;
        allowedInCreativeTab(arg0: Internal.Item_, arg1: Internal.Set_<Internal.EnchantmentCategory>): boolean;
        wait(): void;
        getDamageBonus(arg0: number, arg1: Internal.MobType_, arg2: Internal.ItemStack_): number;
        wait(arg0: number): void;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_): boolean;
        equals(arg0: any): boolean;
        canEnchant(arg0: Internal.ItemStack_): boolean;
        isAllowedOnBooks(): boolean;
        get class(): typeof any
        get rarity(): Internal.Enchantment$Rarity
        get tradeable(): boolean
        get treasureOnly(): boolean
        get discoverable(): boolean
        get descriptionId(): string
        get maxLevel(): number
        get minLevel(): number
        get curse(): boolean
        get allowedOnBooks(): boolean
    }
    type MinersFervorEnchant_ = MinersFervorEnchant;
    abstract class HangingEntity extends Internal.Entity {
        isInWall(): boolean;
        etf$getType(): Internal.EntityType<any>;
        getAllSlots(): Internal.Iterable<Internal.ItemStack>;
        getUpVector(arg0: number): Vec3d;
        gameEvent(arg0: Internal.GameEvent_, arg1: Internal.Entity_): void;
        remove(arg0: Internal.Entity$RemovalReason_): void;
        getBlockZ(): number;
        isSuppressingBounce(): boolean;
        dampensVibrations(): boolean;
        isSilent(): boolean;
        "playSound(net.minecraft.sounds.SoundEvent)"(arg0: Internal.SoundEvent_): void;
        getPitch(): number;
        setCulled(value: boolean): void;
        isOnFire(): boolean;
        rotate(arg0: Internal.Rotation_): number;
        getPositionCodec(): Internal.VecDeltaCodec;
        getPassengersAndSelf(): Internal.Stream<any>;
        getPickedResult(arg0: Internal.HitResult_): Internal.ItemStack;
        setMaxUpStep(arg0: number): void;
        /**
         * @deprecated
        */
        updateFluidHeightAndDoFluidPushing(arg0: Internal.TagKey_<Internal.Fluid>, arg1: number): boolean;
        runCommandSilent(command: string): number;
        setPosition(x: number, y: number, z: number): void;
        chunkPosition(): Internal.ChunkPos;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        emf$isOnGround(): boolean;
        gameEvent(arg0: Internal.GameEvent_): void;
        alwaysAccepts(): boolean;
        isShiftKeyDown(): boolean;
        isInFluidType(arg0: Internal.FluidState_): boolean;
        setUUID(arg0: Internal.UUID_): void;
        checkBelowWorld(): void;
        isVisuallyCrawling(): boolean;
        shouldUpdateFluidWhileBoating(arg0: Internal.FluidState_, arg1: Internal.Boat_): boolean;
        setMotionZ(z: number): void;
        "deserializeNBT(net.minecraft.nbt.Tag)"(arg0: Internal.Tag_): void;
        canFreeze(): boolean;
        ignoreExplosion(): boolean;
        teleportRelative(arg0: number, arg1: number, arg2: number): void;
        getIsInsideStructureTracker(): Internal.IsInsideStructureTracker;
        getBlockY(): number;
        isSpectator(): boolean;
        isInWaterOrBubble(): boolean;
        handler$zzn000$variantsandventures$skeleton$onSpawnPacket(packet: Internal.ClientboundAddEntityPacket_, ci: Internal.CallbackInfo_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        updateFluidHeightAndDoFluidPushing(): void;
        spawnAtLocation(arg0: Internal.ItemLike_, arg1: number): Internal.ItemEntity;
        getPersistentData(): Internal.CompoundTag;
        getPortalCooldown(): number;
        emf$isGlowing(): boolean;
        getItem(): Internal.ItemStack;
        causeFallDamage(arg0: number, arg1: number, arg2: DamageSource_): boolean;
        getRandomZ(arg0: number): number;
        getFusionModel(layerIndex: number): Internal.Triple<any, any, any>;
        getPosition(arg0: number): Vec3d;
        setRemoved(arg0: Internal.Entity$RemovalReason_): void;
        isInWaterRainOrBubble(): boolean;
        getDistanceSq(arg0: number, arg1: number, arg2: number): number;
        getRemovalReason(): Internal.Entity$RemovalReason;
        wait(arg0: number): void;
        isIgnoringBlockTriggers(): boolean;
        isInRain(): boolean;
        etf$getItemsEquipped(): Internal.Iterable<any>;
        getHandHoldingItemAngle(arg0: Internal.Item_): Vec3d;
        etf$getVelocity(): Vec3d;
        canUpdate(arg0: boolean): void;
        distanceToSqr(arg0: Vec3d_): number;
        getEyeInFluidType(): Internal.FluidType;
        resetFallDistance(): void;
        canSprint(): boolean;
        blockPosition(): BlockPos;
        isSteppingCarefully(): boolean;
        setLevel(arg0: Internal.Level_): void;
        setBoundingBox(arg0: Internal.AABB_): void;
        isAmbientCreature(): boolean;
        getGUID(): Internal.UUID;
        getSoundFromFluidType(arg0: Internal.FluidType_, arg1: Internal.SoundAction_): Internal.SoundEvent;
        "spawnAtLocation(net.minecraft.world.item.ItemStack,float)"(arg0: Internal.ItemStack_, arg1: number): Internal.ItemEntity;
        getPos(): BlockPos;
        addAdditionalSaveData(arg0: Internal.CompoundTag_): void;
        /**
         * @deprecated
        */
        getLightLevelDependentMagicValue(): number;
        getBlockX(): number;
        getEncodeId(): string;
        getY(arg0: number): number;
        emf$prevPitch(): number;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        setInvisible(arg0: boolean): void;
        etf$getHandItems(): Internal.Iterable<any>;
        etf$getArmorItems(): Internal.Iterable<any>;
        invalidateCaps(): void;
        getName(): net.minecraft.network.chat.Component;
        abstract dropItem(arg0: Internal.Entity_): void;
        onGround(): boolean;
        getControlledVehicle(): Internal.Entity;
        isOnSameTeam(arg0: Internal.Entity_): boolean;
        attack(arg0: DamageSource_, arg1: number): boolean;
        onInsideBubbleColumn(arg0: boolean): void;
        isInFluidType(arg0: Internal.BiPredicate_<Internal.FluidType, number>): boolean;
        tick(): void;
        getEyePosition(): Vec3d;
        getEyeHeight(): number;
        hasPassenger(arg0: Internal.Predicate_<Internal.Entity>): boolean;
        getYaw(): number;
        emf$isTouchingWater(): boolean;
        isPushedByFluid(arg0: Internal.FluidType_): boolean;
        emf$getVariableMap(): Internal.Object2FloatOpenHashMap<any>;
        hasPermissions(arg0: number): boolean;
        getCapability<T>(arg0: Internal.Capability_<T>, arg1: Internal.Direction_): Internal.LazyOptional<T>;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        setCustomNameVisible(arg0: boolean): void;
        bo$getRenderer(): Internal.EntityRenderer<any>;
        isAlliedTo(arg0: Internal.Team_): boolean;
        setOutOfCamera(value: boolean): void;
        localvar$bbe000$apoth_checkFallDamageWithGravity(arg0: number): number;
        bo$refreshEntityData(data: number): void;
        getRemainingFireTicks(): number;
        getControllingPassenger(): Internal.LivingEntity;
        getScriptType(): Internal.ScriptType;
        onWrite(arg0: Internal.CompoundTag_): void;
        onlyOpCanSetNbt(): boolean;
        startRiding(arg0: Internal.Entity_): boolean;
        saveWithoutId(arg0: Internal.CompoundTag_): Internal.CompoundTag;
        getForward(): Vec3d;
        addMotion(arg0: number, arg1: number, arg2: number): void;
        fireImmune(): boolean;
        getMaxFallDistance(): number;
        getZ(arg0: number): number;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        getId(): number;
        canBeHitByProjectile(): boolean;
        onMove(arg0: Internal.MoverType_, arg1: Vec3d_, arg2: boolean): boolean;
        getTicksFrozen(): number;
        getRandomX(arg0: number): number;
        getEyeY(): number;
        spawnAtLocation(arg0: Internal.ItemStack_, arg1: number): Internal.ItemEntity;
        pick(arg0: number, arg1: number, arg2: boolean): Internal.HitResult;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getBoundingBox(): Internal.AABB;
        isInWaterOrRain(): boolean;
        isDescending(): boolean;
        emf$getPitch(): number;
        setItemSlot(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): void;
        getYHeadRot(): number;
        equals(arg0: any): boolean;
        getViewYRot(arg0: number): number;
        dismountsUnderwater(): boolean;
        addTag(arg0: string): boolean;
        playerTouch(arg0: Internal.Player_): void;
        getEyeHeight(arg0: Internal.Pose_): number;
        getAddEntityPacket(): Internal.Packet<Internal.ClientGamePacketListener>;
        syncPacketPositionCodec(arg0: number, arg1: number, arg2: number): void;
        getTeam(): Internal.Team;
        shouldRenderAtSqrDistance(arg0: number): boolean;
        damageSources(): Internal.DamageSources;
        setTicksFrozen(arg0: number): void;
        recreateFromPacket(arg0: Internal.ClientboundAddEntityPacket_): void;
        abstract getWidth(): number;
        getMyRidingOffset(): number;
        canStartSwimming(): boolean;
        dismountTo(arg0: number, arg1: number, arg2: number): void;
        setDeltaMovement(arg0: Vec3d_): void;
        redirect$doc000$bop(arg0: Internal.Entity$MovementEmission_): boolean;
        getLeashOffset(arg0: number): Vec3d;
        etf$getPose(): Internal.Pose;
        etf$getEntityKey(): string;
        hasCustomName(): boolean;
        isCulled(): boolean;
        isLiving(): boolean;
        getX(): number;
        isGlowing(): boolean;
        "isInFluidType(net.minecraft.world.level.material.FluidState)"(arg0: Internal.FluidState_): boolean;
        isVehicle(): boolean;
        etf$getOptifineId(): number;
        getLeashOffset(): Vec3d;
        isAttackable(): boolean;
        spawnAtLocation(arg0: Internal.ItemStack_): Internal.ItemEntity;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        thunderHit(arg0: Internal.ServerLevel_, arg1: Internal.LightningBolt_): void;
        setIsInPowderSnow(arg0: boolean): void;
        etf$distanceTo(entity: Internal.Entity_): number;
        doEnchantDamageEffects(arg0: Internal.LivingEntity_, arg1: Internal.Entity_): void;
        setCustomName(arg0: net.minecraft.network.chat.Component_): void;
        getSlot(arg0: number): Internal.SlotAccess;
        "deserializeNBT(net.minecraft.nbt.CompoundTag)"(arg0: Internal.CompoundTag_): void;
        emf$isInLava(): boolean;
        getTeamId(): string;
        stopSeenByPlayer(arg0: Internal.ServerPlayer_): void;
        canBeRiddenUnderFluidType(arg0: Internal.FluidType_, arg1: Internal.Entity_): boolean;
        isUnderWater(): boolean;
        stopRiding(): void;
        isCustomNameVisible(): boolean;
        isSupportedBy(arg0: BlockPos_): boolean;
        getPistonPushReaction(): Internal.PushReaction;
        getX(arg0: number): number;
        shouldRiderSit(): boolean;
        lookAt(arg0: Internal.EntityAnchorArgument$Anchor_, arg1: Vec3d_): void;
        captureDrops(arg0: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        getSelfAndPassengers(): Internal.Stream<any>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getDeltaMovement(): Vec3d;
        isInFluidType(arg0: Internal.FluidType_): boolean;
        collide(arg0: Vec3d_): Vec3d;
        getFluidMotionScale(arg0: Internal.FluidType_): number;
        getMotionX(): number;
        "onSyncedDataUpdated(java.util.List)"(arg0: Internal.List_<Internal.SynchedEntityData$DataValue<any>>): void;
        hasPassenger(arg0: Internal.Entity_): boolean;
        hasIndirectPassenger(arg0: Internal.Entity_): boolean;
        getEntityData(): Internal.SynchedEntityData;
        setSecondsOnFire(arg0: number): void;
        moveTo(arg0: number, arg1: number, arg2: number): void;
        emf$getZ(): number;
        "getDisplayName()"(): net.minecraft.network.chat.Component;
        handleInsidePortal(arg0: BlockPos_): void;
        create$callSetLevel(arg0: Internal.Level_): void;
        setMotion(arg0: number, arg1: number, arg2: number): void;
        playSound(arg0: Internal.SoundEvent_): void;
        absMoveTo(arg0: number, arg1: number, arg2: number): void;
        updateFluidHeightAndDoFluidPushing(arg0: Internal.Predicate_<Internal.FluidState>): void;
        isOnRails(): boolean;
        restoreFrom(arg0: Internal.Entity_): void;
        markFusionRecomputeModels(): void;
        getDimensionChangingDelay(): number;
        isPeacefulCreature(): boolean;
        setOnGround(arg0: boolean): void;
        emf$getYaw(): number;
        setPos(arg0: number, arg1: number, arg2: number): void;
        setYaw(arg0: number): void;
        getPickRadius(): number;
        notify(): void;
        getFirstTick(): boolean;
        getVehicle(): Internal.Entity;
        isEffectiveAi(): boolean;
        startRiding(arg0: Internal.Entity_, arg1: boolean): boolean;
        getStringUuid(): string;
        isRemoved(): boolean;
        setSwimming(arg0: boolean): void;
        emf$isSneaking(): boolean;
        canHydrateInFluidType(arg0: Internal.FluidType_): boolean;
        teleportToWithTicket(arg0: number, arg1: number, arg2: number): void;
        fillCrashReportCategory(arg0: Internal.CrashReportCategory_): void;
        getRotationVector(): Internal.Vec2;
        refreshDimensions(): void;
        self(): Internal.Entity;
        etf$getBlockY(): number;
        isSprinting(): boolean;
        "spawnAtLocation(net.minecraft.world.level.ItemLike)"(arg0: Internal.ItemLike_): Internal.ItemEntity;
        getMotionY(): number;
        canCollideWith(arg0: Internal.Entity_): boolean;
        getEyePosition(arg0: number): Vec3d;
        setShiftKeyDown(arg0: boolean): void;
        getPassengers(): Internal.EntityArrayList;
        getBlockExplosionResistance(arg0: Internal.Explosion_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.FluidState_, arg5: number): number;
        getAdjustedOnPosition(arg0: BlockPos_): BlockPos;
        getFluidFallDistanceModifier(arg0: Internal.FluidType_): number;
        getMaxHeightFluidType(): Internal.FluidType;
        getZ(): number;
        getIsInsidePortal(): boolean;
        canSpawnSprintParticle(): boolean;
        "moveTo(net.minecraft.core.BlockPos,float,float)"(arg0: BlockPos_, arg1: number, arg2: number): void;
        teleportTo(arg0: number, arg1: number, arg2: number): void;
        getServer(): Internal.MinecraftServer;
        moveRelative(arg0: number, arg1: Vec3d_): void;
        isAddedToWorld(): boolean;
        getFirstPassenger(): Internal.Entity;
        saveAsPassenger(arg0: Internal.CompoundTag_): boolean;
        interact(arg0: Internal.Player_, arg1: Internal.InteractionHand_): Internal.InteractionResult;
        getDismountLocationForPassenger(arg0: Internal.LivingEntity_): Vec3d;
        checkSlowFallDistance(): void;
        getSoundSource(): Internal.SoundSource;
        setFabricBalmData(arg0: Internal.CompoundTag_): void;
        getPose(): Internal.Pose;
        touchingUnloadedChunk(): boolean;
        getLookAngle(): Vec3d;
        setPositionAndRotation(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): void;
        emf$isOnFire(): boolean;
        getMotionZ(): number;
        etf$getUuid(): Internal.UUID;
        removeVehicle(): void;
        isInvisible(): boolean;
        shouldFusionRecomputeModel(layerIndex: number): boolean;
        is(arg0: Internal.Entity_): boolean;
        setZ(z: number): void;
        getY(): number;
        ejectPassengers(): void;
        hashCode(): number;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        getProfile(): Internal.GameProfile;
        static setViewScale(arg0: number): void;
        emf$isAlive(): boolean;
        setLevelCallback(arg0: Internal.EntityInLevelCallback_): void;
        showVehicleHealth(): boolean;
        getDistance(pos: BlockPos_): number;
        playSound(arg0: Internal.SoundEvent_, arg1: number, arg2: number): void;
        emf$getVelocity(): Vec3d;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityDispatcher)"(arg0: Internal.CapabilityDispatcher_): boolean;
        etf$isBlockEntity(): boolean;
        startSeenByPlayer(arg0: Internal.ServerPlayer_): void;
        isOnScoreboardTeam(teamId: string): boolean;
        /**
         * @deprecated
        */
        isPushedByFluid(): boolean;
        setTimeout(): void;
        position(): Vec3d;
        getAdjustedCanTriggerWalking(arg0: boolean): boolean;
        displayFireAnimation(): boolean;
        turn(arg0: number, arg1: number): void;
        isOutOfCamera(): boolean;
        getAirSupply(): number;
        handler$bgc000$tryShortcutFluidPushing(ci: Internal.CallbackInfo_, box: Internal.AABB_, x1: number, x2: number, y1: number, y2: number, z1: number, z2: number, zero: number): void;
        getRopeHoldPosition(arg0: number): Vec3d;
        copyPosition(arg0: Internal.Entity_): void;
        onAddedToWorld(): void;
        "hasPassenger(net.minecraft.world.entity.Entity)"(arg0: Internal.Entity_): boolean;
        isCrouching(): boolean;
        etf$canBeBright(): boolean;
        moveTo(arg0: BlockPos_, arg1: number, arg2: number): void;
        isPlayer(): boolean;
        isAnimal(): boolean;
        readAdditionalSaveData(arg0: Internal.CompoundTag_): void;
        survives(): boolean;
        handler$zzo000$variantsandventures$createSpawnPacket(cir: Internal.CallbackInfoReturnable_<any>): void;
        canBeCollidedWith(): boolean;
        getMotionDirection(): Internal.Direction;
        setY(y: number): void;
        lavaHurt(): void;
        getFeetBlockState(): Internal.BlockState;
        handler$zzn000$variantsandventures$skeleton$isInvulnerableTo(damageSource: DamageSource_, cir: Internal.CallbackInfoReturnable_<any>): void;
        handleDamageEvent(arg0: DamageSource_): void;
        getFabricBalmData(): Internal.CompoundTag;
        canChangeDimensions(): boolean;
        changeDimension(arg0: Internal.ServerLevel_, arg1: Internal.ITeleporter_): Internal.Entity;
        getCommandSenderWorld(): Internal.Level;
        positionRider(arg0: Internal.Entity_): void;
        baseTick(): void;
        broadcastToPlayer(arg0: Internal.ServerPlayer_): boolean;
        changeDimension(arg0: Internal.ServerLevel_): Internal.Entity;
        setSharedFlag(arg0: number, arg1: boolean): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getEyeHeightAccess(arg0: Internal.Pose_, arg1: Internal.EntityDimensions_): number;
        getCustomName(): net.minecraft.network.chat.Component;
        getClass(): typeof any;
        isVisuallySwimming(): boolean;
        getMaxAirSupply(): number;
        canTrample(arg0: Internal.BlockState_, arg1: BlockPos_, arg2: number): boolean;
        onRead(arg0: Internal.CompoundTag_): void;
        attack(hp: number): void;
        canSwimInFluidType(arg0: Internal.FluidType_): boolean;
        getFacing(): Internal.Direction;
        emf$isWet(): boolean;
        "hasPassenger(java.util.function.Predicate)"(arg0: Internal.Predicate_<Internal.Entity>): boolean;
        getDimensions(arg0: Internal.Pose_): Internal.EntityDimensions;
        abstract getHeight(): number;
        isPassengerOfSameVehicle(arg0: Internal.Entity_): boolean;
        getBoundingBoxForCulling(): Internal.AABB;
        isSwimming(): boolean;
        invokeSetSharedFlag(arg0: number, arg1: boolean): void;
        static collideBoundingBox(entity: Internal.Entity_, movement: Vec3d_, entityBoundingBox: Internal.AABB_, world: Internal.Level_, collisions: Internal.List_<any>): Vec3d;
        setSprinting(arg0: boolean): void;
        mayInteract(arg0: Internal.Level_, arg1: BlockPos_): boolean;
        setPortalCooldown(): void;
        setX(x: number): void;
        trackingPosition(): Vec3d;
        getNameTagOffsetY(): number;
        isInvulnerable(): boolean;
        isInLava(): boolean;
        getBlockStateOn(): Internal.BlockState;
        awardKillScore(arg0: Internal.Entity_, arg1: number, arg2: DamageSource_): void;
        isInWater(): boolean;
        getPortalWaitTime(): number;
        getFluidJumpThreshold(): number;
        "setPositionAndRotation(double,double,double,float,float)"(x: number, y: number, z: number, yaw: number, pitch: number): void;
        isInvisibleTo(arg0: Internal.Player_): boolean;
        setFusionModel(layerIndex: number, model: Internal.Triple_<any, any, any>): void;
        setAirSupply(arg0: number): void;
        getOnPos(): BlockPos;
        getRootVehicle(): Internal.Entity;
        save(arg0: Internal.CompoundTag_): boolean;
        etf$getWorld(): Internal.Level;
        isNoGravity(): boolean;
        getStepHeight(): number;
        etf$getNbt(): Internal.CompoundTag;
        acceptsFailure(): boolean;
        etf$getBlockPos(): BlockPos;
        setOnGroundWithKnownMovement(arg0: boolean, arg1: Vec3d_): void;
        setOldPosAndRot(): void;
        emf$getY(): number;
        bookshelf$createHoverEvent(): Internal.HoverEvent;
        isFree(arg0: number, arg1: number, arg2: number): boolean;
        updateSwimming(): void;
        "moveTo(double,double,double)"(arg0: number, arg1: number, arg2: number): void;
        setRemainingFireTicks(arg0: number): void;
        getCachedFeetBlockState(): Internal.BlockState;
        shouldInformAdmins(): boolean;
        canFluidExtinguish(arg0: Internal.FluidType_): boolean;
        rideTick(): void;
        emf$age(): number;
        etf$hasCustomName(): boolean;
        /**
         * @deprecated
        */
        getOnPosLegacy(): BlockPos;
        setPos(arg0: Vec3d_): void;
        wait(): void;
        getUuid(): Internal.UUID;
        spawn(): void;
        areCapsCompatible(arg0: Internal.CapabilityDispatcher_): boolean;
        teleportTo(arg0: Internal.ServerLevel_, arg1: number, arg2: number, arg3: number, arg4: Internal.Set_<Internal.RelativeMovement>, arg5: number, arg6: number): boolean;
        etf$getCustomName(): net.minecraft.network.chat.Component;
        shouldShowName(): boolean;
        setSilent(arg0: boolean): void;
        getArmorSlots(): Internal.Iterable<Internal.ItemStack>;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        hasExactlyOnePlayerPassenger(): boolean;
        kill(): void;
        isOnPortalCooldown(): boolean;
        animateHurt(arg0: number): void;
        handler$ehl000$create$onFireImmune(arg0: Internal.CallbackInfoReturnable_<any>): void;
        setPitch(arg0: number): void;
        isMultipartEntity(): boolean;
        setPosRaw(arg0: number, arg1: number, arg2: number): void;
        handleEntityEvent(arg0: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getDimensionsForge(arg0: Internal.Pose_): Internal.EntityDimensions;
        getParts(): Internal.PartEntity<any>[];
        isAlwaysTicking(): boolean;
        interactAt(arg0: Internal.Player_, arg1: Vec3d_, arg2: Internal.InteractionHand_): Internal.InteractionResult;
        emf$getX(): number;
        deserializeNBT(arg0: Internal.Tag_): void;
        lerpTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): void;
        onPassengerTurned(arg0: Internal.Entity_): void;
        spawnAtLocation(arg0: Internal.ItemLike_): Internal.ItemEntity;
        revive(): void;
        emf$hasPassengers(): boolean;
        serializeNBT(): Internal.CompoundTag;
        getBbWidth(): number;
        handler$bpk000$onLavaHurt(arg0: Internal.CallbackInfo_): void;
        isEyeInFluidType(arg0: Internal.FluidType_): boolean;
        getForgePersistentData(): Internal.CompoundTag;
        addDeltaMovement(arg0: Vec3d_): void;
        lithiumOnBlockCacheDeleted(): void;
        "spawnAtLocation(net.minecraft.world.level.ItemLike,int)"(arg0: Internal.ItemLike_, arg1: number): Internal.ItemEntity;
        setInvulnerable(arg0: boolean): void;
        "getName()"(): net.minecraft.network.chat.Component;
        push(arg0: Internal.Entity_): void;
        isInFluidType(): boolean;
        emf$hasVehicle(): boolean;
        mirror(arg0: Internal.Mirror_): number;
        canUpdate(): boolean;
        getTicksRequiredToFreeze(): number;
        /**
         * @deprecated
        */
        maxUpStep(): number;
        setGlowing(arg0: boolean): void;
        load(arg0: Internal.CompoundTag_): void;
        isAlive(): boolean;
        emf$prevZ(): number;
        getBbHeight(): number;
        getUsername(): string;
        handler$zzn000$variantsandventures$skeleton$isImmuneToExplosion(cir: Internal.CallbackInfoReturnable_<any>): void;
        move(arg0: Internal.MoverType_, arg1: Vec3d_): void;
        getViewVector(arg0: number): Vec3d;
        getTags(): Internal.Set<string>;
        onRemovedFromWorld(): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        isPickable(): boolean;
        isInFluidType(predicate: Internal.BiPredicate_<any, any>, forAllTypes: boolean): boolean;
        setYHeadRot(arg0: number): void;
        hasControllingPassenger(): boolean;
        closerThan(arg0: Internal.Entity_, arg1: number, arg2: number): boolean;
        absMoveTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): void;
        getPercentFrozen(): number;
        getPickResult(): Internal.ItemStack;
        setPortalCooldown(arg0: number): void;
        getRandomY(): number;
        getDisplayName(): net.minecraft.network.chat.Component;
        hasGlowingTag(): boolean;
        shouldBlockExplode(arg0: Internal.Explosion_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: number): boolean;
        emf$isInvisible(): boolean;
        setPosition(block: Internal.BlockContainerJS_): void;
        emf$isSprinting(): boolean;
        handler$zzo000$isPushable(cir: Internal.CallbackInfoReturnable_<any>): void;
        shouldBeSaved(): boolean;
        getFluidTypeHeight(arg0: Internal.FluidType_): number;
        getViewXRot(arg0: number): number;
        canRiderInteract(): boolean;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityProvider)"(arg0: Internal.CapabilityProvider_<Internal.Entity>): boolean;
        removeTag(arg0: string): boolean;
        setPose(arg0: Internal.Pose_): void;
        /**
         * @deprecated
        */
        getFluidHeight(arg0: Internal.TagKey_<Internal.Fluid>): number;
        getEntityType(): Internal.EntityType<any>;
        isWaterCreature(): boolean;
        toString(): string;
        notifyAll(): void;
        getPassengersRidingOffset(): number;
        etf$getScoreboardTeam(): Internal.Team;
        "isInFluidType(java.util.function.BiPredicate)"(arg0: Internal.BiPredicate_<Internal.FluidType, number>): boolean;
        distanceToEntitySqr(arg0: Internal.Entity_): number;
        "getServer()"(): Internal.MinecraftServer;
        isFrame(): boolean;
        discard(): void;
        isPushable(): boolean;
        setYBodyRot(arg0: number): void;
        onClientRemoval(): void;
        sendSystemMessage(arg0: net.minecraft.network.chat.Component_): void;
        acceptsSuccess(): boolean;
        reviveCaps(): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        setNoGravity(arg0: boolean): void;
        getIndirectPassengers(): Internal.Iterable<any>;
        setRotation(yaw: number, pitch: number): void;
        createCommandSourceStack(): Internal.CommandSourceStack;
        isControlledByLocalInstance(): boolean;
        isMonster(): boolean;
        static same(arg0: any, arg1: any): boolean;
        getHorizontalFacing(): Internal.Direction;
        setId(arg0: number): void;
        onSyncedDataUpdated(arg0: Internal.List_<Internal.SynchedEntityData$DataValue<any>>): void;
        getType(): string;
        handler$zzo000$variantsandventures$onSpawnPacket(packet: Internal.ClientboundAddEntityPacket_, ci: Internal.CallbackInfo_): void;
        handler$zzo000$variantsandventures$isInvulnerableTo(damageSource: DamageSource_, cir: Internal.CallbackInfoReturnable_<any>): void;
        getLightProbePosition(arg0: number): Vec3d;
        onAboveBubbleCol(arg0: boolean): void;
        handler$zzo000$isImmuneToExplosion(cir: Internal.CallbackInfoReturnable_<any>): void;
        emf$prevX(): number;
        "playSound(net.minecraft.sounds.SoundEvent,float,float)"(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        isPassenger(): boolean;
        hasPose(arg0: Internal.Pose_): boolean;
        checkDespawn(): void;
        /**
         * @deprecated
        */
        isEyeInFluid(arg0: Internal.TagKey_<Internal.Fluid>): boolean;
        isInvulnerableTo(arg0: DamageSource_): boolean;
        makeStuckInBlock(arg0: Internal.BlockState_, arg1: Vec3d_): void;
        skipAttackInteraction(arg0: Internal.Entity_): boolean;
        lerpMotion(arg0: number, arg1: number, arg2: number): void;
        shouldRender(arg0: number, arg1: number, arg2: number): boolean;
        onSyncedDataUpdated(arg0: Internal.EntityDataAccessor_<any>): void;
        lerpHeadTo(arg0: number, arg1: number): void;
        handler$zzn000$variantsandventures$skeleton$isPushable(cir: Internal.CallbackInfoReturnable_<any>): void;
        static getViewScale(): number;
        handler$zzn000$variantsandventures$skeleton$createSpawnPacket(cir: Internal.CallbackInfoReturnable_<any>): void;
        setMotionX(x: number): void;
        getHandSlots(): Internal.Iterable<Internal.ItemStack>;
        distanceToEntity(arg0: Internal.Entity_): number;
        getVisualRotationYInDegrees(): number;
        abstract playPlacementSound(): void;
        wait(arg0: number, arg1: number): void;
        getTeamColor(): number;
        isDiscrete(): boolean;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        unRide(): void;
        getLevel(): Internal.Level;
        "spawnAtLocation(net.minecraft.world.item.ItemStack)"(arg0: Internal.ItemStack_): Internal.ItemEntity;
        "isInFluidType(net.minecraftforge.fluids.FluidType)"(arg0: Internal.FluidType_): boolean;
        extinguish(): void;
        updateDynamicGameEventListener(arg0: Internal.BiConsumer_<Internal.DynamicGameEventListener<any>, Internal.ServerLevel>): void;
        moveTo(arg0: Vec3d_): void;
        isColliding(arg0: BlockPos_, arg1: Internal.BlockState_): boolean;
        "onSyncedDataUpdated(net.minecraft.network.syncher.EntityDataAccessor)"(arg0: Internal.EntityDataAccessor_<any>): void;
        emf$prevY(): number;
        areCapsCompatible(arg0: Internal.CapabilityProvider_<Internal.Entity>): boolean;
        extinguishFire(): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getEyeHeightForge(arg0: Internal.Pose_, arg1: Internal.EntityDimensions_): number;
        tell(message: net.minecraft.network.chat.Component_): void;
        isForcedVisible(): boolean;
        closerThan(arg0: Internal.Entity_, arg1: number): boolean;
        getDistanceSq(pos: BlockPos_): number;
        killedEntity(arg0: Internal.ServerLevel_, arg1: Internal.LivingEntity_): boolean;
        emf$getTypeString(): string;
        getClassification(arg0: boolean): Internal.MobCategory;
        isFreezing(): boolean;
        isFullyFrozen(): boolean;
        runCommand(command: string): number;
        handler$bpk000$onFire(arg0: Internal.CallbackInfoReturnable_<any>): void;
        setSharedFlagOnFire(arg0: boolean): void;
        get inWall(): boolean
        get allSlots(): Internal.Iterable<Internal.ItemStack>
        get blockZ(): number
        get suppressingBounce(): boolean
        get silent(): boolean
        get pitch(): number
        set culled(value: boolean)
        get onFire(): boolean
        get positionCodec(): Internal.VecDeltaCodec
        get passengersAndSelf(): Internal.Stream<any>
        set maxUpStep(arg0: number)
        get shiftKeyDown(): boolean
        set UUID(arg0: Internal.UUID_)
        get visuallyCrawling(): boolean
        set motionZ(z: number)
        get isInsideStructureTracker(): Internal.IsInsideStructureTracker
        get blockY(): number
        get spectator(): boolean
        get inWaterOrBubble(): boolean
        get persistentData(): Internal.CompoundTag
        get portalCooldown(): number
        get item(): Internal.ItemStack
        set removed(arg0: Internal.Entity$RemovalReason_)
        get inWaterRainOrBubble(): boolean
        get removalReason(): Internal.Entity$RemovalReason
        get ignoringBlockTriggers(): boolean
        get inRain(): boolean
        get eyeInFluidType(): Internal.FluidType
        get steppingCarefully(): boolean
        set level(arg0: Internal.Level_)
        set boundingBox(arg0: Internal.AABB_)
        get ambientCreature(): boolean
        get GUID(): Internal.UUID
        get pos(): BlockPos
        /**
         * @deprecated
        */
        get lightLevelDependentMagicValue(): number
        get blockX(): number
        get encodeId(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        set invisible(arg0: boolean)
        get name(): net.minecraft.network.chat.Component
        get controlledVehicle(): Internal.Entity
        get eyePosition(): Vec3d
        get eyeHeight(): number
        get yaw(): number
        set customNameVisible(arg0: boolean)
        set outOfCamera(value: boolean)
        get remainingFireTicks(): number
        get controllingPassenger(): Internal.LivingEntity
        get scriptType(): Internal.ScriptType
        get forward(): Vec3d
        get maxFallDistance(): number
        get id(): number
        get ticksFrozen(): number
        get eyeY(): number
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get boundingBox(): Internal.AABB
        get inWaterOrRain(): boolean
        get descending(): boolean
        get YHeadRot(): number
        get addEntityPacket(): Internal.Packet<Internal.ClientGamePacketListener>
        get team(): Internal.Team
        set ticksFrozen(arg0: number)
        get width(): number
        get myRidingOffset(): number
        set deltaMovement(arg0: Vec3d_)
        get culled(): boolean
        get living(): boolean
        get x(): number
        get glowing(): boolean
        get vehicle(): boolean
        get leashOffset(): Vec3d
        get attackable(): boolean
        set isInPowderSnow(arg0: boolean)
        set customName(arg0: net.minecraft.network.chat.Component_)
        get teamId(): string
        get underWater(): boolean
        get customNameVisible(): boolean
        get pistonPushReaction(): Internal.PushReaction
        get selfAndPassengers(): Internal.Stream<any>
        get deltaMovement(): Vec3d
        get motionX(): number
        get entityData(): Internal.SynchedEntityData
        set secondsOnFire(arg0: number)
        get "displayName()"(): net.minecraft.network.chat.Component
        get onRails(): boolean
        get dimensionChangingDelay(): number
        get peacefulCreature(): boolean
        set onGround(arg0: boolean)
        set yaw(arg0: number)
        get pickRadius(): number
        get firstTick(): boolean
        get vehicle(): Internal.Entity
        get effectiveAi(): boolean
        get stringUuid(): string
        get removed(): boolean
        set swimming(arg0: boolean)
        get rotationVector(): Internal.Vec2
        get sprinting(): boolean
        get motionY(): number
        set shiftKeyDown(arg0: boolean)
        get passengers(): Internal.EntityArrayList
        get maxHeightFluidType(): Internal.FluidType
        get z(): number
        get isInsidePortal(): boolean
        get server(): Internal.MinecraftServer
        get addedToWorld(): boolean
        get firstPassenger(): Internal.Entity
        get soundSource(): Internal.SoundSource
        set fabricBalmData(arg0: Internal.CompoundTag_)
        get pose(): Internal.Pose
        get lookAngle(): Vec3d
        get motionZ(): number
        get invisible(): boolean
        set z(z: number)
        get y(): number
        get profile(): Internal.GameProfile
        set viewScale(arg0: number)
        set levelCallback(arg0: Internal.EntityInLevelCallback_)
        /**
         * @deprecated
        */
        get pushedByFluid(): boolean
        get outOfCamera(): boolean
        get airSupply(): number
        get crouching(): boolean
        get player(): boolean
        get animal(): boolean
        get motionDirection(): Internal.Direction
        set y(y: number)
        get feetBlockState(): Internal.BlockState
        get fabricBalmData(): Internal.CompoundTag
        get commandSenderWorld(): Internal.Level
        get customName(): net.minecraft.network.chat.Component
        get class(): typeof any
        get visuallySwimming(): boolean
        get maxAirSupply(): number
        get facing(): Internal.Direction
        get height(): number
        get boundingBoxForCulling(): Internal.AABB
        get swimming(): boolean
        set sprinting(arg0: boolean)
        set x(x: number)
        get nameTagOffsetY(): number
        get invulnerable(): boolean
        get inLava(): boolean
        get blockStateOn(): Internal.BlockState
        get inWater(): boolean
        get portalWaitTime(): number
        get fluidJumpThreshold(): number
        set airSupply(arg0: number)
        get onPos(): BlockPos
        get rootVehicle(): Internal.Entity
        get noGravity(): boolean
        get stepHeight(): number
        set remainingFireTicks(arg0: number)
        get cachedFeetBlockState(): Internal.BlockState
        /**
         * @deprecated
        */
        get onPosLegacy(): BlockPos
        set pos(arg0: Vec3d_)
        get uuid(): Internal.UUID
        set silent(arg0: boolean)
        get armorSlots(): Internal.Iterable<Internal.ItemStack>
        get onPortalCooldown(): boolean
        set pitch(arg0: number)
        get multipartEntity(): boolean
        get parts(): Internal.PartEntity<any>[]
        get alwaysTicking(): boolean
        get bbWidth(): number
        get forgePersistentData(): Internal.CompoundTag
        set invulnerable(arg0: boolean)
        get "name()"(): net.minecraft.network.chat.Component
        get inFluidType(): boolean
        get ticksRequiredToFreeze(): number
        set glowing(arg0: boolean)
        get alive(): boolean
        get bbHeight(): number
        get username(): string
        get tags(): Internal.Set<string>
        get pickable(): boolean
        set YHeadRot(arg0: number)
        get percentFrozen(): number
        get pickResult(): Internal.ItemStack
        set portalCooldown(arg0: number)
        get randomY(): number
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set pose(arg0: Internal.Pose_)
        get entityType(): Internal.EntityType<any>
        get waterCreature(): boolean
        get passengersRidingOffset(): number
        get "server()"(): Internal.MinecraftServer
        get frame(): boolean
        get pushable(): boolean
        set YBodyRot(arg0: number)
        set motionY(y: number)
        set noGravity(arg0: boolean)
        get indirectPassengers(): Internal.Iterable<any>
        get controlledByLocalInstance(): boolean
        get monster(): boolean
        get horizontalFacing(): Internal.Direction
        set id(arg0: number)
        get type(): string
        get passenger(): boolean
        get viewScale(): number
        set motionX(x: number)
        get handSlots(): Internal.Iterable<Internal.ItemStack>
        get visualRotationYInDegrees(): number
        get teamColor(): number
        get discrete(): boolean
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get forcedVisible(): boolean
        get freezing(): boolean
        get fullyFrozen(): boolean
        set sharedFlagOnFire(arg0: boolean)
    }
    type HangingEntity_ = HangingEntity;
    class GoalSelectorDebugRenderer$DebugGoal {
        constructor(arg0: BlockPos_, arg1: number, arg2: string, arg3: boolean)
        getClass(): typeof any;
        hashCode(): number;
        toString(): string;
        wait(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        get class(): typeof any
        readonly name: string;
        readonly priority: number;
        readonly isRunning: boolean;
        readonly pos: BlockPos;
    }
    type GoalSelectorDebugRenderer$DebugGoal_ = GoalSelectorDebugRenderer$DebugGoal;
    class BundleDelimiterPacket <T extends Internal.PacketListener> implements Internal.Packet<T> {
        constructor()
        getClass(): typeof any;
        write(arg0: Internal.FriendlyByteBuf_): void;
        hashCode(): number;
        toString(): string;
        wait(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        notify(): void;
        isSkippable(): boolean;
        wait(arg0: number, arg1: number): void;
        handle(arg0: T): void;
        get class(): typeof any
        get skippable(): boolean
    }
    type BundleDelimiterPacket_<T extends Internal.PacketListener> = BundleDelimiterPacket<T>;
    class TurntableBlock extends Internal.IEEntityBlock<any> {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        fillCreativeTab(arg0: Internal.CreativeModeTab$Output_): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        getBlacklistedEnchantments(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Set<Internal.Enchantment>;
        getTypeData(): Internal.CompoundTag;
        setFriction(arg0: number): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        canIEBlockBePlaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMaxVerticalOffset(): number;
        newBlockEntity(arg0: BlockPos_, arg1: Internal.BlockState_): Internal.BlockEntity;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        needsDynamicNodeTypeCheck(): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        setHasFlavour(arg0: boolean): Internal.IEBaseBlock;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        static areAllReplaceable(arg0: BlockPos_, arg1: BlockPos_, arg2: Internal.BlockPlaceContext_): boolean;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        spawnTableParticle(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: BlockPos_): void;
        getTicker<T2 extends Internal.BlockEntity>(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockEntityType_<T2>): Internal.BlockEntityTicker<T2>;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        fitsIntoContainer(): boolean;
        /**
         * @deprecated
        */
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        hasCustomBlockColours(): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        static byItem(arg0: Internal.Item_): Internal.Block;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        allowsTreasure(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        placeLiquid(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.FluidState_): boolean;
        hasFlavour(): boolean;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        onIEBlockPlacedBy(arg0: Internal.BlockPlaceContext_, arg1: Internal.BlockState_): void;
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(shape: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        getPickupSound(arg0: Internal.BlockState_): Internal.Optional<Internal.SoundEvent>;
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        screwdriverUseSide(arg0: Internal.Direction_, arg1: Internal.Player_, arg2: Internal.InteractionHand_, arg3: Internal.Level_, arg4: BlockPos_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        setHasColours(): Internal.IEEntityBlock<any>;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        isSignalSource(arg0: Internal.BlockState_): boolean;
        handler$dmk000$friendsandfoes_onUse(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, hand: Internal.InteractionHand_, hit: Internal.BlockHitResult_, cir: Internal.CallbackInfoReturnable_<any>): void;
        getRenderColour(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: number): number;
        getMaxEnchantingPower(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        /**
         * @deprecated
        */
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        getTableParticle(arg0: Internal.BlockState_): Internal.ParticleOptions;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        needsDynamicBurningCheck(): boolean;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        getArcanaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        handler$dmk000$friendsandfoes_randomTick(state: Internal.BlockState_, world: Internal.ServerLevel_, pos: BlockPos_, random: Internal.RandomSource_, ci: Internal.CallbackInfo_): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        pickupBlock(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        getQuantaBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        handler$bdh000$postConstruct(p_i241196_1_: Internal.BlockBehaviour$Properties_, ci: Internal.CallbackInfo_): void;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        getQuantaRectification(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        getFriction(): number;
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        setHidden(arg0: boolean): Internal.IEBaseBlock;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        getNameForFlavour(): string;
        static applyLocationalWaterlogging(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.BlockState;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        setLightOpacity(arg0: number): Internal.IEBaseBlock;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getListener<T extends Internal.BlockEntity>(arg0: Internal.ServerLevel_, arg1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        handler$dml000$friendsandfoes_hasRandomTicks(state: Internal.BlockState_, cir: Internal.CallbackInfoReturnable_<any>): void;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        canPlaceLiquid(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Fluid_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        getBonusClues(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPa