/// <reference path="./internals/internal_*.d.ts" />
declare class BlockPos extends Vec3i {
    constructor(arg0: Vec3i_)
    constructor(arg0: number, arg1: number, arg2: number)
    south(): this;
    mutable(): Internal.BlockPos$MutableBlockPos;
    above(): this;
    offset(arg0: number, arg1: number, arg2: number): this;
    offset(arg0: Vec3i_): this;
    getY(): number;
    static offsetCodec(arg0: number): Internal.Codec<Vec3i>;
    static getY(arg0: number): number;
    static betweenClosed(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.Iterable<BlockPos>;
    toShortString(): string;
    static betweenClosedStream(arg0: BlockPos_, arg1: BlockPos_): Internal.Stream<BlockPos>;
    notify(): void;
    static "betweenClosedStream(net.minecraft.world.level.levelgen.structure.BoundingBox)"(arg0: Internal.BoundingBox_): Internal.Stream<BlockPos>;
    compareTo(arg0: any): number;
    multiply(arg0: number): this;
    relative(arg0: Internal.Direction_): Vec3i;
    static offset(arg0: number, arg1: number, arg2: number, arg3: number): number;
    asLong(): number;
    west(): this;
    static spiralAround(arg0: BlockPos_, arg1: number, arg2: Internal.Direction_, arg3: Internal.Direction_): Internal.Iterable<Internal.BlockPos$MutableBlockPos>;
    closerThan(arg0: Vec3i_, arg1: number): boolean;
    below(distance: number): this;
    "compareTo(net.minecraft.core.Vec3i)"(arg0: Vec3i_): number;
    static betweenClosedStream(arg0: Internal.BoundingBox_): Internal.Stream<BlockPos>;
    static randomInCube(arg0: Internal.RandomSource_, arg1: number, arg2: BlockPos_, arg3: number): Internal.Iterable<BlockPos>;
    static breadthFirstTraversal(arg0: BlockPos_, arg1: number, arg2: number, arg3: Internal.BiConsumer_<BlockPos, Internal.Consumer<BlockPos>>, arg4: Internal.Predicate_<BlockPos>): number;
    "relative(net.minecraft.core.Direction$Axis,int)"(arg0: Internal.Direction$Axis_, arg1: number): this;
    static betweenClosed(arg0: BlockPos_, arg1: BlockPos_): Internal.Iterable<BlockPos>;
    distSqr(arg0: Vec3i_): number;
    static offset(arg0: number, arg1: Internal.Direction_): number;
    getCenter(): Vec3d;
    wait(): void;
    static containing(arg0: Internal.Position_): BlockPos;
    cross(arg0: Vec3i_): this;
    east(distance: number): this;
    "compareTo(java.lang.Object)"(arg0: any): number;
    above(distance: number): this;
    distToCenterSqr(arg0: number, arg1: number, arg2: number): number;
    north(): Vec3i;
    getClass(): typeof any;
    distToCenterSqr(arg0: Internal.Position_): number;
    getX(): number;
    below(): this;
    south(arg0: number): Vec3i;
    east(): this;
    static getX(arg0: number): number;
    static getZ(arg0: number): number;
    static findClosestMatch(arg0: BlockPos_, arg1: number, arg2: number, arg3: Internal.Predicate_<BlockPos>): Internal.Optional<BlockPos>;
    atY(arg0: number): this;
    west(arg0: number): Vec3i;
    wait(arg0: number, arg1: number): void;
    distToLowCornerSqr(arg0: number, arg1: number, arg2: number): number;
    rotate(arg0: Internal.Rotation_): this;
    static "betweenClosedStream(net.minecraft.world.phys.AABB)"(arg0: Internal.AABB_): Internal.Stream<BlockPos>;
    static betweenClosedStream(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.Stream<BlockPos>;
    getZ(): number;
    static randomBetweenClosed(arg0: Internal.RandomSource_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): Internal.Iterable<BlockPos>;
    static withinManhattanStream(arg0: BlockPos_, arg1: number, arg2: number, arg3: number): Internal.Stream<BlockPos>;
    immutable(): this;
    toString(): string;
    north(arg0: number): Vec3i;
    static asLong(arg0: number, arg1: number, arg2: number): number;
    notifyAll(): void;
    distManhattan(arg0: Vec3i_): number;
    static getFlatIndex(arg0: number): number;
    static of(arg0: number): BlockPos;
    get(arg0: Internal.Direction$Axis_): number;
    static withinManhattan(arg0: BlockPos_, arg1: number, arg2: number, arg3: number): Internal.Iterable<BlockPos>;
    /**
     * @deprecated
    */
    static squareOutSouthEast(arg0: BlockPos_): Internal.Stream<BlockPos>;
    static containing(arg0: number, arg1: number, arg2: number): BlockPos;
    static betweenClosedStream(arg0: Internal.AABB_): Internal.Stream<BlockPos>;
    hashCode(): number;
    relative(arg0: Internal.Direction_, arg1: number): Vec3i;
    wait(arg0: number): void;
    relative(arg0: Internal.Direction$Axis_, arg1: number): this;
    compareTo(arg0: Vec3i_): number;
    subtract(arg0: Vec3i_): this;
    equals(arg0: any): boolean;
    closerToCenterThan(arg0: Internal.Position_, arg1: number): boolean;
    "relative(net.minecraft.core.Direction,int)"(arg0: Internal.Direction_, arg1: number): Vec3i;
    get y(): number
    get center(): Vec3d
    get class(): typeof any
    get x(): number
    get z(): number
    static readonly PACKED_Y_LENGTH: (12) & (number);
    static readonly CODEC: Internal.Codec<BlockPos>;
    static readonly ZERO: (BlockPos) & (BlockPos);
}
type BlockPos_ = Vec3d_ | [number, number, number] | BlockPos;
/**
 * Various block related helper functions
*/
declare class Block {
    constructor()
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    static id(id: ResourceLocation_): Internal.BlockIDPredicate;
    static entity(id: ResourceLocation_): Internal.BlockEntityPredicate;
    /**
     * Gets a blocks id from the Block
    */
    static getId(block: Internal.Block_): ResourceLocation;
    /**
     * Get a map of direction name to Direction. Functionally identical to Direction.ALL
    */
    static getFacing(): Internal.Map<string, Internal.Direction>;
    notify(): void;
    static id(id: ResourceLocation_, properties: Internal.Map_<string, any>): Internal.BlockIDPredicate;
    wait(arg0: number, arg1: number): void;
    /**
     * Gets a list of all blocks with tags
    */
    static getTaggedIds(tag: ResourceLocation_): Internal.List<ResourceLocation>;
    hashCode(): number;
    /**
     * Gets a Block from a block id
    */
    static getBlock(id: ResourceLocation_): Internal.Block;
    wait(): void;
    wait(arg0: number): void;
    static custom(predicate: Internal.BlockPredicate_): Internal.BlockPredicate;
    /**
     * Gets a list of the classname of all registered blocks
    */
    static getTypeList(): Internal.List<string>;
    equals(arg0: any): boolean;
    get class(): typeof any
    /**
     * Get a map of direction name to Direction. Functionally identical to Direction.ALL
    */
    get facing(): Internal.Map<string, Internal.Direction>
    /**
     * Gets a list of the classname of all registered blocks
    */
    get typeList(): Internal.List<string>
}
type Block_ = Block;
declare class Vec3d implements Internal.Position {
    constructor(arg0: number, arg1: number, arg2: number)
    constructor(arg0: Vec3f_)
    lengthSqr(): number;
    distanceToSqr(arg0: Vec3d_): number;
    notify(): void;
    yRot(arg0: number): this;
    z(): number;
    xRot(arg0: number): this;
    align(arg0: Internal.EnumSet_<Internal.Direction$Axis>): this;
    x(): number;
    closerThan(arg0: Internal.Position_, arg1: number): boolean;
    static atLowerCornerWithOffset(arg0: Vec3i_, arg1: number, arg2: number, arg3: number): Vec3d;
    subtract(arg0: Vec3d_): this;
    static upFromBottomCenterOf(arg0: Vec3i_, arg1: number): Vec3d;
    reverse(): this;
    scale(arg0: number): this;
    wait(): void;
    length(): number;
    distanceToSqr(arg0: number, arg1: number, arg2: number): number;
    subtract(arg0: number, arg1: number, arg2: number): this;
    zRot(arg0: number): this;
    normalize(): this;
    horizontalDistance(): number;
    lerp(arg0: Vec3d_, arg1: number): this;
    get(arg0: Internal.Direction$Axis_): number;
    getClass(): typeof any;
    relative(arg0: Internal.Direction_, arg1: number): this;
    add(arg0: number, arg1: number, arg2: number): this;
    static atCenterOf(arg0: Vec3i_): Vec3d;
    cross(arg0: Vec3d_): this;
    static directionFromRotation(arg0: Internal.Vec2_): Vec3d;
    add(arg0: Vec3d_): this;
    wait(arg0: number, arg1: number): void;
    "with"(arg0: Internal.Direction$Axis_, arg1: number): this;
    static atBottomCenterOf(arg0: Vec3i_): Vec3d;
    horizontalDistanceSqr(): number;
    dot(arg0: Vec3d_): number;
    multiply(arg0: number, arg1: number, arg2: number): this;
    y(): number;
    vectorTo(arg0: Vec3d_): this;
    offsetRandom(arg0: Internal.RandomSource_, arg1: number): this;
    toString(): string;
    static atLowerCornerOf(arg0: Vec3i_): Vec3d;
    notifyAll(): void;
    static fromRGB24(arg0: number): Vec3d;
    multiply(arg0: Vec3d_): this;
    distanceTo(arg0: Vec3d_): number;
    hashCode(): number;
    toVector3f(): Vec3f;
    wait(arg0: number): void;
    static directionFromRotation(arg0: number, arg1: number): Vec3d;
    equals(arg0: any): boolean;
    get class(): typeof any
    readonly z: number;
    static readonly ZERO: (Vec3d) & (Vec3d);
    static readonly CODEC: Internal.Codec<Vec3d>;
    readonly x: number;
    readonly y: number;
}
type Vec3d_ = [number, number, number] | Vec3d;
declare class RotationAxis extends Internal.Enum<RotationAxis> {
    deg(f: number): Quaternionf;
    static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    static valueOf(name: string): RotationAxis;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    compareTo(arg0: any): number;
    name(): string;
    static values(): RotationAxis[];
    hashCode(): number;
    rad(f: number): Quaternionf;
    getDeclaringClass(): typeof RotationAxis;
    ordinal(): number;
    wait(): void;
    "compareTo(dev.latvian.mods.kubejs.util.RotationAxis)"(arg0: RotationAxis_): number;
    wait(arg0: number): void;
    compareTo(arg0: RotationAxis_): number;
    "compareTo(java.lang.Object)"(arg0: any): number;
    equals(arg0: any): boolean;
    describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<RotationAxis>>;
    get class(): typeof any
    get declaringClass(): typeof RotationAxis
    static readonly XN: (RotationAxis) & (RotationAxis);
    static readonly ZP: (RotationAxis) & (RotationAxis);
    static readonly YN: (RotationAxis) & (RotationAxis);
    static readonly XP: (RotationAxis) & (RotationAxis);
    static readonly YP: (RotationAxis) & (RotationAxis);
    static readonly ZN: (RotationAxis) & (RotationAxis);
    readonly vec: Vec3f;
}
type RotationAxis_ = "yp" | "xp" | "yn" | "xn" | "zp" | RotationAxis | "zn";
declare class ResourceLocation implements Internal.ResourceLocationAccess, Internal.SpecialEquality, Internal.Comparable<ResourceLocation> {
    constructor(arg0: string, arg1: string)
    constructor(arg0: string)
    static isValidNamespace(arg0: string): boolean;
    getClass(): typeof any;
    compareTo(arg0: ResourceLocation_): number;
    toLanguageKey(arg0: string): string;
    static checkSpecialEquality(o: any, o1: any, shallow: boolean): boolean;
    static validNamespaceChar(arg0: string): boolean;
    static read(arg0: string): Internal.DataResult<ResourceLocation>;
    toShortLanguageKey(): string;
    static isValidPath(arg0: string): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    compareTo(arg0: any): number;
    setPath(arg0: string): void;
    static tryBuild(arg0: string, arg1: string): ResourceLocation;
    "withPath(java.lang.String)"(arg0: string): this;
    static isAllowedInResourceLocation(arg0: string): boolean;
    static tryParse(arg0: string): ResourceLocation;
    withPath(arg0: string): this;
    static validPathChar(arg0: string): boolean;
    toLanguageKey(arg0: string, arg1: string): string;
    toDebugFileName(): string;
    getPath(): string;
    getNamespace(): string;
    static of(arg0: string, arg1: string): ResourceLocation;
    compareNamespaced(arg0: ResourceLocation_): number;
    "compareTo(net.minecraft.resources.ResourceLocation)"(arg0: ResourceLocation_): number;
    toString(): string;
    withSuffix(arg0: string): this;
    notifyAll(): void;
    specialEquals(o: any, shallow: boolean): boolean;
    static read(arg0: Internal.StringReader_): ResourceLocation;
    toLanguageKey(): string;
    static isValidResourceLocation(arg0: string): boolean;
    "withPath(java.util.function.UnaryOperator)"(arg0: Internal.UnaryOperator_<string>): this;
    static "read(com.mojang.brigadier.StringReader)"(arg0: Internal.StringReader_): ResourceLocation;
    hashCode(): number;
    static "read(java.lang.String)"(arg0: string): Internal.DataResult<ResourceLocation>;
    setNamespace(arg0: string): void;
    wait(): void;
    withPath(arg0: Internal.UnaryOperator_<string>): this;
    wait(arg0: number): void;
    withPrefix(arg0: string): this;
    "compareTo(java.lang.Object)"(arg0: any): number;
    equals(arg0: any): boolean;
    get class(): typeof any
    set path(arg0: string)
    get path(): string
    get namespace(): string
    set namespace(arg0: string)
    static readonly REALMS_NAMESPACE: ("realms") & (string);
    static readonly CODEC: Internal.Codec<ResourceLocation>;
    static readonly NAMESPACE_SEPARATOR: (":") & (string);
    static readonly DEFAULT_NAMESPACE: ("minecraft") & (string);
}
type ResourceLocation_ = string | ResourceLocation | Special.CustomStat;
declare class Stats {
    constructor()
    getClass(): typeof any;
    hashCode(): number;
    toString(): string;
    wait(): void;
    notifyAll(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    get class(): typeof any
    static readonly SWIM_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly FLY_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly CLEAN_SHULKER_BOX: (ResourceLocation) & (ResourceLocation);
    static readonly TOTAL_WORLD_TIME: (ResourceLocation) & (ResourceLocation);
    static readonly TUNE_NOTEBLOCK: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_RESISTED: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_DROPPED: Internal.StatType<Internal.Item>;
    static readonly PLAYER_KILLS: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_BREWINGSTAND: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_CAMPFIRE: (ResourceLocation) & (ResourceLocation);
    static readonly INSPECT_DISPENSER: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_FURNACE: (ResourceLocation) & (ResourceLocation);
    static readonly OPEN_ENDERCHEST: (ResourceLocation) & (ResourceLocation);
    static readonly ANIMALS_BRED: (ResourceLocation) & (ResourceLocation);
    static readonly POT_FLOWER: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_STONECUTTER: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_PICKED_UP: Internal.StatType<Internal.Item>;
    static readonly FALL_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_ABSORBED: (ResourceLocation) & (ResourceLocation);
    static readonly FISH_CAUGHT: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_ANVIL: (ResourceLocation) & (ResourceLocation);
    static readonly BOAT_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly PLAY_RECORD: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_DEALT_RESISTED: (ResourceLocation) & (ResourceLocation);
    static readonly RAID_WIN: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_DEALT: (ResourceLocation) & (ResourceLocation);
    static readonly DEATHS: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_SMOKER: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_USED: Internal.StatType<Internal.Item>;
    static readonly BELL_RING: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_SMITHING_TABLE: (ResourceLocation) & (ResourceLocation);
    static readonly INSPECT_DROPPER: (ResourceLocation) & (ResourceLocation);
    static readonly DROP: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_LECTERN: (ResourceLocation) & (ResourceLocation);
    static readonly PLAY_TIME: (ResourceLocation) & (ResourceLocation);
    static readonly WALK_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly CLIMB_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly TRADED_WITH_VILLAGER: (ResourceLocation) & (ResourceLocation);
    static readonly RAID_TRIGGER: (ResourceLocation) & (ResourceLocation);
    static readonly STRIDER_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_BROKEN: Internal.StatType<Internal.Item>;
    static readonly BLOCK_MINED: Internal.StatType<Internal.Block>;
    static readonly TIME_SINCE_REST: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_BEACON: (ResourceLocation) & (ResourceLocation);
    static readonly INSPECT_HOPPER: (ResourceLocation) & (ResourceLocation);
    static readonly PLAY_NOTEBLOCK: (ResourceLocation) & (ResourceLocation);
    static readonly CUSTOM: Internal.StatType<ResourceLocation>;
    static readonly CROUCH_TIME: (ResourceLocation) & (ResourceLocation);
    static readonly JUMP: (ResourceLocation) & (ResourceLocation);
    static readonly ENTITY_KILLED: Internal.StatType<Internal.EntityType<any>>;
    static readonly ENTITY_KILLED_BY: Internal.StatType<Internal.EntityType<any>>;
    static readonly INTERACT_WITH_CARTOGRAPHY_TABLE: (ResourceLocation) & (ResourceLocation);
    static readonly MOB_KILLS: (ResourceLocation) & (ResourceLocation);
    static readonly OPEN_CHEST: (ResourceLocation) & (ResourceLocation);
    static readonly SLEEP_IN_BED: (ResourceLocation) & (ResourceLocation);
    static readonly CLEAN_ARMOR: (ResourceLocation) & (ResourceLocation);
    static readonly CROUCH_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly TALKED_TO_VILLAGER: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_DEALT_ABSORBED: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_LOOM: (ResourceLocation) & (ResourceLocation);
    static readonly LEAVE_GAME: (ResourceLocation) & (ResourceLocation);
    static readonly HORSE_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly WALK_ON_WATER_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly MINECART_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly ENCHANT_ITEM: (ResourceLocation) & (ResourceLocation);
    static readonly TIME_SINCE_DEATH: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_TAKEN: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_BLAST_FURNACE: (ResourceLocation) & (ResourceLocation);
    static readonly TRIGGER_TRAPPED_CHEST: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_GRINDSTONE: (ResourceLocation) & (ResourceLocation);
    static readonly OPEN_BARREL: (ResourceLocation) & (ResourceLocation);
    static readonly SPRINT_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_BLOCKED_BY_SHIELD: (ResourceLocation) & (ResourceLocation);
    static readonly EAT_CAKE_SLICE: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_CRAFTING_TABLE: (ResourceLocation) & (ResourceLocation);
    static readonly CLEAN_BANNER: (ResourceLocation) & (ResourceLocation);
    static readonly TARGET_HIT: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_CRAFTED: Internal.StatType<Internal.Item>;
    static readonly WALK_UNDER_WATER_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly PIG_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly OPEN_SHULKER_BOX: (ResourceLocation) & (ResourceLocation);
    static readonly USE_CAULDRON: (ResourceLocation) & (ResourceLocation);
    static readonly AVIATE_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly FILL_CAULDRON: (ResourceLocation) & (ResourceLocation);
}
type Stats_ = Stats;
declare class Fluid {
    constructor()
    static of(o: Internal.FluidStackJS_): Internal.FluidStackJS;
    getClass(): typeof any;
    static getEmpty(): Internal.FluidStackJS;
    static getType(id: ResourceLocation_): Internal.Fluid;
    static of(o: Internal.FluidStackJS_, nbt: Internal.CompoundTag_): Internal.FluidStackJS;
    toString(): string;
    static of(o: Internal.FluidStackJS_, amount: number, nbt: Internal.CompoundTag_): Internal.FluidStackJS;
    static "of(dev.latvian.mods.kubejs.fluid.FluidStackJS,net.minecraft.nbt.CompoundTag)"(o: Internal.FluidStackJS_, nbt: Internal.CompoundTag_): Internal.FluidStackJS;
    notifyAll(): void;
    static of(o: Internal.FluidStackJS_, amount: number): Internal.FluidStackJS;
    static lava(amount: number): Internal.FluidStackJS;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    hashCode(): number;
    static lava(): Internal.FluidStackJS;
    static getTypes(): Internal.List<string>;
    static "of(dev.latvian.mods.kubejs.fluid.FluidStackJS,int)"(o: Internal.FluidStackJS_, amount: number): Internal.FluidStackJS;
    wait(): void;
    static getId(fluid: Internal.Fluid_): ResourceLocation;
    wait(arg0: number): void;
    static water(amount: number): Internal.FluidStackJS;
    static exists(id: ResourceLocation_): boolean;
    equals(arg0: any): boolean;
    static water(): Internal.FluidStackJS;
    get class(): typeof any
    get empty(): Internal.FluidStackJS
    get types(): Internal.List<string>
    static readonly LAVA_ID: (ResourceLocation) & (ResourceLocation);
    static readonly WATER_ID: (ResourceLocation) & (ResourceLocation);
}
type Fluid_ = Fluid;
declare class InputItem implements Internal.InputReplacement, Internal.IngredientSupplierKJS, Internal.JsonSerializable {
    replaceInput(recipe: Internal.RecipeJS_, match: Internal.ReplacementMatch_, original: Internal.InputReplacement_): any;
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    isEmpty(): boolean;
    notify(): void;
    toJson(): Internal.JsonElement;
    withCount(count: number): this;
    wait(arg0: number, arg1: number): void;
    static of(o: InputItem_): InputItem;
    static of(ingredient: Internal.Ingredient_, count: number): InputItem;
    toJson(alwaysNest: boolean): Internal.JsonElement;
    validForMatching(): boolean;
    hashCode(): number;
    unwrap(): Internal.List<InputItem>;
    wait(): void;
    wait(arg0: number): void;
    transform(transformer: Internal.InputReplacementTransformer_): Internal.InputReplacementTransformer$Replacement;
    equals(arg0: any): boolean;
    kjs$asIngredient(): Internal.Ingredient;
    get class(): typeof any
    get empty(): boolean
    readonly ingredient: Internal.Ingredient;
    readonly count: number;
    static readonly EMPTY: (InputItem) & (InputItem);
    static readonly PARSE_CACHE: ({}) & (Internal.Map<string, InputItem>);
}
type InputItem_ = Internal.Ingredient_ | InputItem;
declare interface Color {
    of(o: any): dev.latvian.mods.rhino.mod.util.color.Color;
    rgba(r: number, g: number, b: number, a: number): dev.latvian.mods.rhino.mod.util.color.Color;
    createMapped(o: any, ...names: string[]): dev.latvian.mods.rhino.mod.util.color.Color;
    readonly DARK_PURPLE: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly YELLOW: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly CYAN_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly GRAY: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly BROWN_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly LIGHT_PURPLE: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly PURPLE_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly DARK_AQUA: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly GREEN: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly LIGHT_GRAY_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly WHITE: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly MAGENTA_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly RED: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly BLACK_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly TEXT: ({"dark_red": Internal.ChatFormatting, "green": Internal.ChatFormatting, "underline": Internal.ChatFormatting, "dark_green": Internal.ChatFormatting, "black": Internal.ChatFormatting, "yellow": Internal.ChatFormatting, "bold": Internal.ChatFormatting, "italic": Internal.ChatFormatting, "dark_blue": Internal.ChatFormatting, "dark_purple": Internal.ChatFormatting, "gold": Internal.ChatFormatting, "red": Internal.ChatFormatting, "aqua": Internal.ChatFormatting, "gray": Internal.ChatFormatting, "light_purple": Internal.ChatFormatting, "blue": Internal.ChatFormatting, "white": Internal.ChatFormatting, "dark_aqua": Internal.ChatFormatting, "dark_gray": Internal.ChatFormatting, "reset": Internal.ChatFormatting, "strikethrough": Internal.ChatFormatting, "obfuscated": Internal.ChatFormatting}) & (Internal.Map<string, Internal.ChatFormatting>);
    readonly RED_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly GRAY_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly DARK_GRAY: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly NONE: (Internal.NoColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly ORANGE_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly WHITE_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly DYE: ({"magenta": Internal.DyeColor, "pink": Internal.DyeColor, "green": Internal.DyeColor, "lime": Internal.DyeColor, "light_gray": Internal.DyeColor, "yellow": Internal.DyeColor, "black": Internal.DyeColor, "light_blue": Internal.DyeColor, "brown": Internal.DyeColor, "cyan": Internal.DyeColor, "orange": Internal.DyeColor, "red": Internal.DyeColor, "gray": Internal.DyeColor, "white": Internal.DyeColor, "blue": Internal.DyeColor, "purple": Internal.DyeColor}) & (Internal.Map<string, Internal.DyeColor>);
    readonly BLACK: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly BLUE: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly DARK_GREEN: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly DARK_RED: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly GOLD: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly MAP: ({"": Internal.NoColor, "light_blue_dye": Internal.DyeColor, "BLUE_DYE": Internal.DyeColor, "purple_dye": Internal.DyeColor, "dark_red": Internal.ChatFormatting, "lightGrayDye": Internal.DyeColor, "DARK_AQUA": Internal.ChatFormatting, "none": Internal.NoColor, "green_dye": Internal.DyeColor, "blackDye": Internal.DyeColor, "dark_blue": Internal.ChatFormatting, "red": Internal.ChatFormatting, "pink_dye": Internal.DyeColor, "aqua": Internal.ChatFormatting, "white": Internal.ChatFormatting, "WHITE_DYE": Internal.DyeColor, "dark_gray": Internal.ChatFormatting, "LIGHT_PURPLE": Internal.ChatFormatting, "BROWN_DYE": Internal.DyeColor, "BLACK": Internal.ChatFormatting, "darkPurple": Internal.ChatFormatting, "NONE": Internal.NoColor, "LIGHT_BLUE_DYE": Internal.DyeColor, "AQUA": Internal.ChatFormatting, "lightBlueDye": Internal.DyeColor, "limeDye": Internal.DyeColor, "PURPLE_DYE": Internal.DyeColor, "GREEN_DYE": Internal.DyeColor, "magenta_dye": Internal.DyeColor, "-": Internal.NoColor, "lime_dye": Internal.DyeColor, "yellowDye": Internal.DyeColor, "grayDye": Internal.DyeColor, "purpleDye": Internal.DyeColor, "DARK_PURPLE": Internal.ChatFormatting, "ORANGE_DYE": Internal.DyeColor, "darkGray": Internal.ChatFormatting, "brownDye": Internal.DyeColor, "YELLOW": Internal.ChatFormatting, "LIME_DYE": Internal.DyeColor, "blueDye": Internal.DyeColor, "white_dye": Internal.DyeColor, "pinkDye": Internal.DyeColor, "blue_dye": Internal.DyeColor, "cyanDye": Internal.DyeColor, "GOLD": Internal.ChatFormatting, "GRAY": Internal.ChatFormatting, "MAGENTA_DYE": Internal.DyeColor, "BLUE": Internal.ChatFormatting, "yellow": Internal.ChatFormatting, "darkBlue": Internal.ChatFormatting, "transparent": Internal.NoColor, "orange_dye": Internal.DyeColor, "red_dye": Internal.DyeColor, "dark_purple": Internal.ChatFormatting, "gold": Internal.ChatFormatting, "gray": Internal.ChatFormatting, "light_purple": Internal.ChatFormatting, "darkRed": Internal.ChatFormatting, "greenDye": Internal.DyeColor, "DARK_RED": Internal.ChatFormatting, "redDye": Internal.DyeColor, "GRAY_DYE": Internal.DyeColor, "orangeDye": Internal.DyeColor, "yellow_dye": Internal.DyeColor, "black_dye": Internal.DyeColor, "magentaDye": Internal.DyeColor, "WHITE": Internal.ChatFormatting, "green": Internal.ChatFormatting, "LIGHT_GRAY_DYE": Internal.DyeColor, "BLACK_DYE": Internal.DyeColor, "darkGreen": Internal.ChatFormatting, "RED_DYE": Internal.DyeColor, "dark_green": Internal.ChatFormatting, "black": Internal.ChatFormatting, "lightPurple": Internal.ChatFormatting, "PINK_DYE": Internal.DyeColor, "DARK_BLUE": Internal.ChatFormatting, "GREEN": Internal.ChatFormatting, "darkAqua": Internal.ChatFormatting, "gray_dye": Internal.DyeColor, "CYAN_DYE": Internal.DyeColor, "RED": Internal.ChatFormatting, "brown_dye": Internal.DyeColor, "cyan_dye": Internal.DyeColor, "blue": Internal.ChatFormatting, "whiteDye": Internal.DyeColor, "dark_aqua": Internal.ChatFormatting, "YELLOW_DYE": Internal.DyeColor, "DARK_GREEN": Internal.ChatFormatting, "DARK_GRAY": Internal.ChatFormatting}) & (Internal.Map<string, dev.latvian.mods.rhino.mod.util.color.Color>);
    readonly GREEN_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly LIGHT_BLUE_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly AQUA: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly DARK_BLUE: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly PINK_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly BLUE_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly YELLOW_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly LIME_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
}
type Color_ = Color;
declare const Color: Color;
declare class JsonIO {
    constructor()
    getClass(): typeof any;
    static readJson(path: Internal.Path_): Internal.JsonElement;
    static toPrettyString(json: Internal.JsonElement_): string;
    static getJsonHashString(json: Internal.JsonElement_): string;
    notify(): void;
    static toObject(json: Internal.JsonElement_): any;
    wait(arg0: number, arg1: number): void;
    static primitiveOf(o: any): Internal.JsonPrimitive;
    static readString(path: Internal.Path_): string;
    static writeJsonHash(stream: Internal.DataOutputStream_, element: Internal.JsonElement_): void;
    static parseRaw(string: string): Internal.JsonElement;
    static write(path: Internal.Path_, json: Internal.JsonObject_): void;
    static read(path: Internal.Path_): Internal.Map<any, any>;
    toString(): string;
    notifyAll(): void;
    static toArray(element: Internal.JsonElement_): Internal.JsonArray;
    static parse(string: string): any;
    static toPrimitive(element: Internal.JsonElement_): any;
    hashCode(): number;
    static copy(element: Internal.JsonElement_): Internal.JsonElement;
    wait(): void;
    wait(arg0: number): void;
    static toString(json: Internal.JsonElement_): string;
    static getJsonHashBytes(json: Internal.JsonElement_): number[];
    equals(arg0: any): boolean;
    static of(o: any): Internal.JsonElement;
    get class(): typeof any
}
type JsonIO_ = JsonIO;
/**
 * Various item related helper methods
*/
declare interface Item {
    /**
     * Returns an ItemStack of the input
    */
    of(in_: Internal.ItemStack_): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified count and NBT data
    */
    of(in_: Internal.ItemStack_, count: number, nbt: Internal.CompoundTag_): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified count
    */
    of(in_: Internal.ItemStack_, count: number): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified NBT data
    */
    withNBT(in_: Internal.ItemStack_, nbt: Internal.CompoundTag_): Internal.ItemStack;
    getTypeToStackMap(): Internal.Map<ResourceLocation, Internal.Collection<Internal.ItemStack>>;
    playerHeadFromSkinHash(hash: string): Internal.ItemStack;
    /**
     * Get the item that represents air/an empty slot
    */
    getEmpty(): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified count
    */
    "of(net.minecraft.world.item.ItemStack,int)"(in_: Internal.ItemStack_, count: number): Internal.ItemStack;
    /**
     * Gets an Item from an item id
    */
    getItem(id: ResourceLocation_): Internal.Item;
    getVariants(item: Internal.ItemStack_): Internal.Collection<Internal.ItemStack>;
    /**
     * Get a list of most items in the game. Items not in a creative tab are ignored
    */
    getList(): Internal.List<Internal.ItemStack>;
    /**
     * Returns a Firework with the input properties
    */
    fireworks(properties: Internal.Map_<string, any>): Internal.FireworksJS;
    /**
     * Returns an ItemStack of the input, with the specified NBT data
    */
    "of(net.minecraft.world.item.ItemStack,net.minecraft.nbt.CompoundTag)"(in_: Internal.ItemStack_, tag: Internal.CompoundTag_): Internal.ItemStack;
    playerHead(name: string): Internal.ItemStack;
    playerHeadFromUrl(url: string): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified NBT data
    */
    of(in_: Internal.ItemStack_, tag: Internal.CompoundTag_): Internal.ItemStack;
    /**
     * Get a list of all the item ids in the game
    */
    getTypeList(): Internal.List<string>;
    /**
     * Checks if the provided item id exists in the registry
    */
    exists(id: ResourceLocation_): boolean;
    playerHead(uuid: Internal.UUID_, textureBase64: string): Internal.ItemStack;
    /**
     * Checks if the passed in object is an ItemStack.
     * Note that this does not mean it will not function as an ItemStack if passed to something that requests one.
    */
    isItem(o: any): boolean;
    /**
     * Gets an items id from the Item
    */
    getId(item: Internal.Item_): ResourceLocation;
    get typeToStackMap(): Internal.Map<ResourceLocation, Internal.Collection<Internal.ItemStack>>
    /**
     * Get the item that represents air/an empty slot
    */
    get empty(): Internal.ItemStack
    /**
     * Get a list of most items in the game. Items not in a creative tab are ignored
    */
    get list(): Internal.List<Internal.ItemStack>
    /**
     * Get a list of all the item ids in the game
    */
    get typeList(): Internal.List<string>
    readonly KJS_ARMOR_MODIFIER_UUID_PER_SLOT: Internal.UUID[];
    readonly KJS_BASE_ATTACK_SPEED_UUID: (Internal.UUID) & (Internal.UUID);
    readonly KJS_BASE_ATTACK_DAMAGE_UUID: (Internal.UUID) & (Internal.UUID);
}
type Item_ = Item;
declare const Item: Item;
declare abstract class number implements Internal.Serializable {
    constructor()
    abstract longValue(): number;
    getClass(): typeof any;
    abstract doubleValue(): number;
    toString(): string;
    abstract floatValue(): number;
    notifyAll(): void;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    shortValue(): number;
    hashCode(): number;
    abstract intValue(): number;
    wait(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    byteValue(): number;
    get class(): typeof any
}
type number_ = number;
declare class Notification {
    constructor()
    constructor(buf: Internal.FriendlyByteBuf_)
    getClass(): typeof any;
    write(buf: Internal.FriendlyByteBuf_): void;
    toString(): string;
    static make(consumer: Internal.Consumer_<Notification>): Notification;
    notifyAll(): void;
    static of(cx: Internal.Context_, object: any): Notification;
    setIcon(icon: string): void;
    show(): void;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    hashCode(): number;
    setAtlasIcon(icon: string): void;
    wait(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    setItemIcon(stack: Internal.ItemStack_): void;
    get class(): typeof any
    set icon(icon: string)
    set atlasIcon(icon: string)
    set itemIcon(stack: Internal.ItemStack_)
    duration: Duration;
    static readonly DEFAULT_DURATION: (Duration) & (Duration);
    backgroundColor: dev.latvian.mods.rhino.mod.util.color.Color;
    iconSize: number;
    static readonly DEFAULT_BACKGROUND_COLOR: (Internal.SimpleColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    static readonly DEFAULT_BORDER_COLOR: (Internal.SimpleColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    borderColor: dev.latvian.mods.rhino.mod.util.color.Color;
    text: net.minecraft.network.chat.Component;
    outlineColor: dev.latvian.mods.rhino.mod.util.color.Color;
    textShadow: boolean;
    static readonly NO_TEXT: net.minecraft.network.chat.Component[];
}
type Notification_ = Notification;
declare interface Facing {
    readonly south: (Internal.Direction) & (Internal.Direction);
    readonly up: (Internal.Direction) & (Internal.Direction);
    readonly UP: (Internal.Direction) & (Internal.Direction);
    readonly NORTH: (Internal.Direction) & (Internal.Direction);
    readonly east: (Internal.Direction) & (Internal.Direction);
    readonly DOWN: (Internal.Direction) & (Internal.Direction);
    readonly EAST: (Internal.Direction) & (Internal.Direction);
    readonly west: (Internal.Direction) & (Internal.Direction);
    readonly north: (Internal.Direction) & (Internal.Direction);
    readonly down: (Internal.Direction) & (Internal.Direction);
    readonly ALL: ({"east": Internal.Direction, "south": Internal.Direction, "north": Internal.Direction, "west": Internal.Direction, "up": Internal.Direction, "down": Internal.Direction}) & (Internal.Map<string, Internal.Direction>);
    readonly WEST: (Internal.Direction) & (Internal.Direction);
    readonly SOUTH: (Internal.Direction) & (Internal.Direction);
}
type Facing_ = Facing;
declare const Facing: Facing;
declare class Quaternionf implements Internal.Cloneable, Internal.Externalizable, Internal.Quaternionfc {
    constructor()
    constructor(arg0: Internal.AxisAngle4d_)
    constructor(arg0: Internal.Quaternionfc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number)
    constructor(arg0: Internal.AxisAngle4f_)
    constructor(arg0: Internal.Quaterniondc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number)
    "transform(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    slerp(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): this;
    transformInverse(arg0: Internal.Vector4d_): Internal.Vector4d;
    invert(): this;
    transformPositiveY(arg0: Vec3f_): Vec3f;
    transformPositiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
    mul(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transformUnit(arg0: Internal.Vector4d_): Internal.Vector4d;
    getEulerAnglesXYZ(arg0: Vec3f_): Vec3f;
    "getAsMatrix3f(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    "transformInverse(float,float,float,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "transformUnit(double,double,double,org.joml.Vector4d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    setFromUnnormalized(arg0: Internal.Matrix3fc_): this;
    get(arg0: Internal.Matrix4d_): Internal.Matrix4d;
    conjugate(arg0: Quaternionf_): this;
    transform(arg0: Internal.Vector4d_): Internal.Vector4d;
    rotateXYZ(arg0: number, arg1: number, arg2: number): this;
    fromAxisAngleDeg(arg0: Internal.Vector3fc_, arg1: number): this;
    "transformUnitPositiveZ(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    rotateLocalZ(arg0: number): this;
    scale(arg0: number): this;
    premul(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotationZ(arg0: number): this;
    transformInverse(arg0: Internal.Vector3d_): Internal.Vector3d;
    transformPositiveY(arg0: Vec4f_): Vec4f;
    transformPositiveX(arg0: Internal.Vector4d_): Internal.Vector4d;
    "set(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): this;
    premul(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transformUnit(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    "transformUnitPositiveY(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    invert(arg0: Quaternionf_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "get(org.joml.Quaternionf)"(arg0: Quaternionf_): this;
    transform(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transform(double,double,double,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "transformInverse(org.joml.Vector4dc,org.joml.Vector4d)"(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    positiveZ(arg0: Vec3f_): Vec3f;
    difference(arg0: Quaternionf_): this;
    div(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    setFromNormalized(arg0: Internal.Matrix3dc_): this;
    normalize(): this;
    getClass(): typeof any;
    transformPositiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
    rotateZ(arg0: number): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    transformPositiveZ(arg0: Vec3f_): Vec3f;
    transformUnit(arg0: Vec4f_): Vec4f;
    "setAngleAxis(double,double,double,double)"(arg0: number, arg1: number, arg2: number, arg3: number): this;
    scale(arg0: number, arg1: Quaternionf_): this;
    nlerp(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): this;
    "transformInverse(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    mul(arg0: number): this;
    "transformUnitPositiveX(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Quaternionf_): this;
    static slerp(arg0: Quaternionf_[], arg1: number[], arg2: Quaternionf_): Internal.Quaternionfc;
    "transformPositiveY(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    get(arg0: Matrix4f_): Matrix4f;
    setAngleAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transform(arg0: Vec4f_): Vec4f;
    transformUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    setFromNormalized(arg0: Internal.Matrix4fc_): this;
    "setFromNormalized(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    getAsMatrix3f(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "get(org.joml.Matrix4x3f)"(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
    "transformInverseUnit(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    normalize(arg0: Quaternionf_): this;
    transformInverseUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    rotationAxis(arg0: Internal.AxisAngle4f_): this;
    mul(arg0: number, arg1: Quaternionf_): this;
    "transformPositiveZ(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    "transformUnit(float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    w(): number;
    transform(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    transformPositiveY(arg0: Internal.Vector4d_): Internal.Vector4d;
    rotateTo(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Quaternionf_): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "transformInverse(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    transformPositiveZ(arg0: Vec4f_): Vec4f;
    conjugateBy(arg0: Internal.Quaternionfc_): this;
    "transformInverse(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    transformInverse(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    get(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
    transform(arg0: Vec3f_): Vec3f;
    "get(org.joml.Matrix3d)"(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
    wait(arg0: number): void;
    "nlerp(org.joml.Quaternionfc,float,org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number): this;
    get(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
    slerp(arg0: Internal.Quaternionfc_, arg1: number): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    fromAxisAngleRad(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transformPositiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
    "get(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    "transformUnit(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    rotationTo(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotateLocalY(arg0: number, arg1: Quaternionf_): this;
    div(arg0: Internal.Quaternionfc_): this;
    transformInverseUnit(arg0: Internal.Vector4d_): Internal.Vector4d;
    "transformPositiveY(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    isFinite(): boolean;
    setFromUnnormalized(arg0: Internal.Matrix3dc_): this;
    "nlerpIterative(org.joml.Quaternionfc,float,float,org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: Quaternionf_): this;
    transformUnitPositiveX(arg0: Vec3f_): Vec3f;
    rotateLocalX(arg0: number): this;
    get(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
    x(): number;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "transform(double,double,double,org.joml.Vector4d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    transformPositiveZ(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformUnit(arg0: Vec3f_): Vec3f;
    "transformPositiveX(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    "transform(float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    "transform(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    "setFromUnnormalized(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    transformInverseUnit(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "transformUnitPositiveZ(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    "mul(float,org.joml.Quaternionf)"(arg0: number, arg1: Quaternionf_): this;
    "transformInverseUnit(float,float,float,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    setFromUnnormalized(arg0: Internal.Matrix4fc_): this;
    fromAxisAngleRad(arg0: Internal.Vector3fc_, arg1: number): this;
    wait(): void;
    setFromNormalized(arg0: Internal.Matrix3fc_): this;
    premul(arg0: Internal.Quaternionfc_): this;
    nlerp(arg0: Internal.Quaternionfc_, arg1: number): this;
    integrate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    "transformPositiveX(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transform(float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    get(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
    "getAsMatrix4f(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    "transformUnit(org.joml.Vector4dc,org.joml.Vector4d)"(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    "transformInverse(float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    static "nlerpIterative(org.joml.Quaternionf[],float[],float,org.joml.Quaternionf)"(arg0: Quaternionf_[], arg1: number[], arg2: number, arg3: Quaternionf_): Internal.Quaternionfc;
    transformInverse(arg0: Vec4f_): Vec4f;
    getEulerAnglesZXY(arg0: Vec3f_): Vec3f;
    nlerpIterative(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: Quaternionf_): this;
    transform(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    "get(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
    transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    add(arg0: Internal.Quaternionfc_): this;
    rotateLocalZ(arg0: number, arg1: Quaternionf_): this;
    getAsMatrix4f(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    "transformUnit(float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    rotationYXZ(arg0: number, arg1: number, arg2: number): this;
    add(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    dot(arg0: Quaternionf_): number;
    "getAsMatrix4f(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "transformUnitPositiveY(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    equals(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
    rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): this;
    rotateAxis(arg0: number, arg1: Internal.Vector3fc_): this;
    static "nlerp(org.joml.Quaternionfc[],float[],org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_[], arg1: number[], arg2: Quaternionf_): Internal.Quaternionfc;
    rotateAxis(arg0: number, arg1: Internal.Vector3fc_, arg2: Quaternionf_): this;
    rotateLocalY(arg0: number): this;
    "transformInverse(double,double,double,org.joml.Vector4d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    y(): number;
    transformInverse(arg0: Vec3f_): Vec3f;
    "setFromNormalized(org.joml.Matrix4x3dc)"(arg0: Internal.Matrix4x3dc_): this;
    "transformUnitPositiveX(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    set(arg0: number, arg1: number, arg2: number, arg3: number): this;
    setFromNormalized(arg0: Internal.Matrix4x3fc_): this;
    "get(org.joml.Matrix4d)"(arg0: Internal.Matrix4d_): Internal.Matrix4d;
    static nlerp(arg0: Internal.Quaternionfc_[], arg1: number[], arg2: Quaternionf_): Internal.Quaternionfc;
    getAsMatrix4x3f(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    setFromUnnormalized(arg0: Internal.Matrix4x3dc_): this;
    "transformInverse(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    "transformPositiveZ(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    "mul(float)"(arg0: number): this;
    conjugate(): this;
    transformInverse(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    equals(arg0: any): boolean;
    rotateYXZ(arg0: number, arg1: number, arg2: number): this;
    "transformInverseUnit(org.joml.Vector4dc,org.joml.Vector4d)"(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    "transformInverseUnit(float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    "setFromNormalized(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    rotationZYX(arg0: number, arg1: number, arg2: number): this;
    "transformInverse(float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    "transform(org.joml.Vector4dc,org.joml.Vector4d)"(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    fromAxisAngleDeg(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "setFromUnnormalized(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_): this;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "getAsMatrix4x3f(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    transformUnitPositiveZ(arg0: Vec3f_): Vec3f;
    "setFromNormalized(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    transformUnitPositiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transformUnitPositiveZ(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transform(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    transformUnit(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    z(): number;
    "transformUnitPositiveY(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    normalizedPositiveX(arg0: Vec3f_): Vec3f;
    rotationAxis(arg0: number, arg1: Internal.Vector3fc_): this;
    "setAngleAxis(float,float,float,float)"(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "set(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    "get(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    getAsMatrix3f(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    toString(arg0: Internal.NumberFormat_): string;
    transformInverseUnit(arg0: Vec3f_): Vec3f;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    lengthSquared(): number;
    setFromUnnormalized(arg0: Internal.Matrix4dc_): this;
    getEulerAnglesYXZ(arg0: Vec3f_): Vec3f;
    get(arg0: Quaternionf_): this;
    transformUnitPositiveX(arg0: Internal.Vector4d_): Internal.Vector4d;
    rotateX(arg0: number, arg1: Quaternionf_): this;
    transformUnitPositiveY(arg0: Vec4f_): Vec4f;
    identity(): this;
    "transformInverseUnit(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    clone(): any;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    "mul(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    "setFromUnnormalized(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    "transformUnitPositiveX(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): this;
    rotateLocalX(arg0: number, arg1: Quaternionf_): this;
    "transformPositiveY(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    transformUnit(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    static "slerp(org.joml.Quaternionf[],float[],org.joml.Quaternionf)"(arg0: Quaternionf_[], arg1: number[], arg2: Quaternionf_): Internal.Quaternionfc;
    transform(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    set(arg0: Internal.Quaternionfc_): this;
    transformInverseUnit(arg0: Vec4f_): Vec4f;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    "set(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_): this;
    setFromNormalized(arg0: Internal.Matrix4x3dc_): this;
    "get(org.joml.Matrix4x3d)"(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
    transformInverseUnit(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    transformUnitPositiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transformInverseUnit(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformUnitPositiveY(arg0: Vec3f_): Vec3f;
    rotationAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "transformUnit(org.joml.Vector3dc,org.joml.Vector3d)"(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    rotateTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "transformInverseUnit(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "transformUnit(double,double,double,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    get(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    toString(): string;
    "transformPositiveZ(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    normalizedPositiveY(arg0: Vec3f_): Vec3f;
    notifyAll(): void;
    "setFromNormalized(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_): this;
    "transformInverse(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    transform(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    equals(arg0: Internal.Quaternionfc_, arg1: number): boolean;
    scaling(arg0: number): this;
    transformInverse(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    "slerp(org.joml.Quaternionfc,float,org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    setFromUnnormalized(arg0: Internal.Matrix4x3fc_): this;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    rotationTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "transform(org.joml.Vector3dc,org.joml.Vector3d)"(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    transformUnitPositiveX(arg0: Vec4f_): Vec4f;
    premul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    getAsMatrix4x3f(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mul(arg0: Internal.Quaternionfc_): this;
    rotateY(arg0: number): this;
    "transformInverse(double,double,double,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "transformUnit(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    notify(): void;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Quaternionf_): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    rotationX(arg0: number): this;
    "transformPositiveY(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transformInverseUnit(double,double,double,org.joml.Vector4d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    integrate(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    "getAsMatrix4x3f(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    normalizedPositiveZ(arg0: Vec3f_): Vec3f;
    set(arg0: Internal.AxisAngle4f_): this;
    "getAsMatrix3f(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    conjugateBy(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    "transform(float,float,float,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    angle(): number;
    getEulerAnglesZYX(arg0: Vec3f_): Vec3f;
    "transformPositiveX(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformInverseUnit(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    "transform(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    "transformInverseUnit(float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    get(arg0: Matrix3f_): Matrix3f;
    "setFromNormalized(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_): this;
    "transformUnitPositiveZ(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    rotateZ(arg0: number, arg1: Quaternionf_): this;
    "transformInverseUnit(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    positiveX(arg0: Vec3f_): Vec3f;
    rotateZYX(arg0: number, arg1: number, arg2: number): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): this;
    transformUnitPositiveZ(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    "transformPositiveX(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    getAsMatrix4f(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    rotateX(arg0: number): this;
    "transformInverseUnit(double,double,double,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    difference(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transformPositiveX(arg0: Vec3f_): Vec3f;
    "set(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    "transformInverse(org.joml.Vector3dc,org.joml.Vector3d)"(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    "get(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    wait(arg0: number, arg1: number): void;
    "setFromUnnormalized(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_): this;
    set(arg0: Internal.Quaterniondc_): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    "transformUnit(float,float,float,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "mul(org.joml.Quaternionfc,org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transform(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    nlerpIterative(arg0: Internal.Quaternionfc_, arg1: number, arg2: number): this;
    "transformUnitPositiveY(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformUnitPositiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    "transformUnit(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "transform(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    "transformUnit(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    setFromNormalized(arg0: Internal.Matrix4dc_): this;
    static nlerpIterative(arg0: Quaternionf_[], arg1: number[], arg2: number, arg3: Quaternionf_): Internal.Quaternionfc;
    rotationY(arg0: number): this;
    rotationXYZ(arg0: number, arg1: number, arg2: number): this;
    transformInverse(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    rotateTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Quaternionf_): this;
    "transformInverseUnit(org.joml.Vector3dc,org.joml.Vector3d)"(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    transformPositiveX(arg0: Vec4f_): Vec4f;
    "get(org.joml.Matrix4f)"(arg0: Matrix4f_): Matrix4f;
    set(arg0: Internal.AxisAngle4d_): this;
    hashCode(): number;
    setAngleAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    positiveY(arg0: Vec3f_): Vec3f;
    "transformInverse(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    rotateTo(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "setFromUnnormalized(org.joml.Matrix4x3dc)"(arg0: Internal.Matrix4x3dc_): this;
    transformUnitPositiveZ(arg0: Vec4f_): Vec4f;
    get(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    "transformPositiveZ(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    "transform(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "transformUnitPositiveX(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    transformUnitPositiveY(arg0: Internal.Vector4d_): Internal.Vector4d;
    rotateY(arg0: number, arg1: Quaternionf_): this;
    "transformUnit(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    "setFromUnnormalized(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    set fromUnnormalized(arg0: Internal.Matrix3fc_)
    set "(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_)
    set fromNormalized(arg0: Internal.Matrix3dc_)
    get class(): typeof any
    set fromNormalized(arg0: Internal.Matrix4fc_)
    set "fromNormalized(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_)
    get finite(): boolean
    set fromUnnormalized(arg0: Internal.Matrix3dc_)
    set "fromUnnormalized(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set fromUnnormalized(arg0: Internal.Matrix4fc_)
    set fromNormalized(arg0: Internal.Matrix3fc_)
    set "fromNormalized(org.joml.Matrix4x3dc)"(arg0: Internal.Matrix4x3dc_)
    set fromNormalized(arg0: Internal.Matrix4x3fc_)
    set fromUnnormalized(arg0: Internal.Matrix4x3dc_)
    set "fromNormalized(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set "fromUnnormalized(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_)
    set "fromNormalized(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_)
    set "(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_)
    set fromUnnormalized(arg0: Internal.Matrix4dc_)
    set "fromUnnormalized(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_)
    set "(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_)
    set fromNormalized(arg0: Internal.Matrix4x3dc_)
    set "fromNormalized(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_)
    set fromUnnormalized(arg0: Internal.Matrix4x3fc_)
    set "fromNormalized(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_)
    set "(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_)
    set "fromUnnormalized(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_)
    set fromNormalized(arg0: Internal.Matrix4dc_)
    set "fromUnnormalized(org.joml.Matrix4x3dc)"(arg0: Internal.Matrix4x3dc_)
    set "fromUnnormalized(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_)
    z: number;
    y: number;
    x: number;
    w: number;
}
type Quaternionf_ = Quaternionf;
declare class BlockProperties {
    constructor()
    getClass(): typeof any;
    hashCode(): number;
    toString(): string;
    wait(): void;
    notifyAll(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    get class(): typeof any
    static readonly LEVEL_FLOWING: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly PERSISTENT: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly HORIZONTAL_FACING: (Internal.DirectionProperty) & (Internal.DirectionProperty);
    static readonly WEST_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly CHISELED_BOOKSHELF_SLOT_5_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly NOTE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly AGE_5: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly EGGS: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly NORTH: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly HAS_RECORD: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SCULK_SENSOR_PHASE: Internal.EnumProperty<Internal.SculkSensorPhase>;
    static readonly EAST_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly HALF: Internal.EnumProperty<Internal.Half>;
    static readonly RESPAWN_ANCHOR_CHARGES: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly HANGING: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly TILT: Internal.EnumProperty<Internal.Tilt>;
    static readonly STABILITY_DISTANCE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_4_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly HAS_BOTTLE_2: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly LAYERS: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly SOUTH_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly CRACKED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CONDITIONAL: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly LOCKED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly POWER: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly EYE: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SOUTH_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly MAX_AGE_1: (1) & (number);
    static readonly ATTACHED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MAX_LEVEL_15: (15) & (number);
    static readonly BELL_ATTACHMENT: Internal.EnumProperty<Internal.BellAttachType>;
    static readonly MAX_DISTANCE: (7) & (number);
    static readonly FLOWER_AMOUNT: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly EXTENDED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly INVERTED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MODE_COMPARATOR: Internal.EnumProperty<Internal.ComparatorMode>;
    static readonly MOISTURE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly LIT: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly DISTANCE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly NORTH_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly AGE_3: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly STAIRS_SHAPE: Internal.EnumProperty<Internal.StairsShape>;
    static readonly MAX_LEVEL_8: (8) & (number);
    static readonly MIN_RESPAWN_ANCHOR_CHARGES: (0) & (number);
    static readonly BAMBOO_LEAVES: Internal.EnumProperty<Internal.BambooLeaves>;
    static readonly HORIZONTAL_AXIS: Internal.EnumProperty<Internal.Direction$Axis>;
    static readonly FALLING: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly ENABLED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly ATTACH_FACE: Internal.EnumProperty<Internal.AttachFace>;
    static readonly OPEN: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly UNSTABLE: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_4: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly EAST: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly ORIENTATION: Internal.EnumProperty<Internal.FrontAndTop>;
    static readonly DOUBLE_BLOCK_HALF: Internal.EnumProperty<Internal.DoubleBlockHalf>;
    static readonly MAX_RESPAWN_ANCHOR_CHARGES: (4) & (number);
    static readonly CHEST_TYPE: Internal.EnumProperty<Internal.ChestType>;
    static readonly MAX_AGE_7: (7) & (number);
    static readonly DOWN: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_2_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_15: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly STRUCTUREBLOCK_MODE: Internal.EnumProperty<Internal.StructureMode>;
    static readonly SLAB_TYPE: Internal.EnumProperty<Internal.SlabType>;
    static readonly EAST_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly WATERLOGGED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly BLOOM: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SHRIEKING: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_1: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly FACING_HOPPER: (Internal.DirectionProperty) & (Internal.DirectionProperty);
    static readonly VERTICAL_DIRECTION: (Internal.DirectionProperty) & (Internal.DirectionProperty);
    static readonly PICKLES: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MAX_AGE_25: (25) & (number);
    static readonly LEVEL_HONEY: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly DUSTED: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MAX_AGE_4: (4) & (number);
    static readonly PISTON_TYPE: Internal.EnumProperty<Internal.PistonType>;
    static readonly HATCH: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly SNOWY: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly TRIGGERED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_1_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SIGNAL_FIRE: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly LEVEL_CAULDRON: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly AXIS: Internal.EnumProperty<Internal.Direction$Axis>;
    static readonly AGE_2: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly DRAG: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CAN_SUMMON: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly LEVEL: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly STAGE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MAX_AGE_5: (5) & (number);
    static readonly NORTH_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly UP: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_0_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly BITES: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly IN_WALL: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_25: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly STABILITY_MAX_DISTANCE: (7) & (number);
    static readonly HAS_BOTTLE_1: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_7: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_3_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SOUTH: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MAX_AGE_15: (15) & (number);
    static readonly DISARMED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly RAIL_SHAPE: Internal.EnumProperty<Internal.RailShape>;
    static readonly DOOR_HINGE: Internal.EnumProperty<Internal.DoorHingeSide>;
    static readonly LEVEL_COMPOSTER: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly DELAY: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MIN_LEVEL: (0) & (number);
    static readonly RAIL_SHAPE_STRAIGHT: Internal.EnumProperty<Internal.RailShape>;
    static readonly MIN_LEVEL_CAULDRON: (1) & (number);
    static readonly BOTTOM: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly HAS_BOOK: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CANDLES: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly NOTEBLOCK_INSTRUMENT: Internal.EnumProperty<Internal.NoteBlockInstrument>;
    static readonly WEST: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SHORT: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly BERRIES: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MAX_AGE_2: (2) & (number);
    static readonly HAS_BOTTLE_0: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly WEST_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly ROTATION_16: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MAX_LEVEL_3: (3) & (number);
    static readonly BED_PART: Internal.EnumProperty<Internal.BedPart>;
    static readonly POWERED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MAX_AGE_3: (3) & (number);
    static readonly OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly DRIPSTONE_THICKNESS: Internal.EnumProperty<Internal.DripstoneThickness>;
    static readonly FACING: (Internal.DirectionProperty) & (Internal.DirectionProperty);
}
type BlockProperties_ = BlockProperties;
declare class Vec3i implements Internal.Comparable<Vec3i> {
    constructor(arg0: number, arg1: number, arg2: number)
    north(): this;
    getClass(): typeof any;
    distToCenterSqr(arg0: Internal.Position_): number;
    getX(): number;
    getY(): number;
    static offsetCodec(arg0: number): Internal.Codec<Vec3i>;
    south(arg0: number): this;
    toShortString(): string;
    above(arg0: number): this;
    notify(): void;
    west(arg0: number): this;
    wait(arg0: number, arg1: number): void;
    compareTo(arg0: any): number;
    east(arg0: number): this;
    distToLowCornerSqr(arg0: number, arg1: number, arg2: number): number;
    "relative(net.minecraft.core.Direction$Axis,int)"(arg0: Internal.Direction$Axis_, arg1: number): this;
    relative(arg0: Internal.Direction_): this;
    multiply(arg0: number): this;
    getZ(): number;
    closerThan(arg0: Vec3i_, arg1: number): boolean;
    below(arg0: number): this;
    above(): this;
    offset(arg0: number, arg1: number, arg2: number): this;
    toString(): string;
    "compareTo(net.minecraft.core.Vec3i)"(arg0: Vec3i_): number;
    north(arg0: number): this;
    east(): this;
    below(): this;
    notifyAll(): void;
    west(): this;
    distManhattan(arg0: Vec3i_): number;
    relative(arg0: Internal.Direction$Axis_, arg1: number): this;
    get(arg0: Internal.Direction$Axis_): number;
    offset(arg0: Vec3i_): this;
    cross(arg0: Vec3i_): this;
    south(): this;
    hashCode(): number;
    distSqr(arg0: Vec3i_): number;
    subtract(arg0: Vec3i_): this;
    relative(arg0: Internal.Direction_, arg1: number): this;
    wait(): void;
    wait(arg0: number): void;
    compareTo(arg0: Vec3i_): number;
    "compareTo(java.lang.Object)"(arg0: any): number;
    equals(arg0: any): boolean;
    closerToCenterThan(arg0: Internal.Position_, arg1: number): boolean;
    "relative(net.minecraft.core.Direction,int)"(arg0: Internal.Direction_, arg1: number): this;
    distToCenterSqr(arg0: number, arg1: number, arg2: number): number;
    get class(): typeof any
    get x(): number
    get y(): number
    get z(): number
    static readonly ZERO: (Vec3i) & (Vec3i);
    static readonly CODEC: Internal.Codec<Vec3i>;
}
type Vec3i_ = Vec3i;
declare class Blocks {
    constructor()
    static never(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.EntityType_<any>): boolean;
    getClass(): typeof any;
    static never(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
    toString(): string;
    notifyAll(): void;
    static always(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
    static rebuildCache(): void;
    notify(): void;
    static woodenButton(arg0: Internal.BlockSetType_, ...arg1: Internal.FeatureFlag_[]): Internal.ButtonBlock;
    wait(arg0: number, arg1: number): void;
    static log(arg0: Internal.MapColor_, arg1: Internal.MapColor_): Internal.RotatedPillarBlock;
    static register(arg0: string, arg1: Internal.Block_): Internal.Block;
    hashCode(): number;
    wait(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    get class(): typeof any
    static MANGROVE_PROPAGULE: (Internal.MangrovePropaguleBlock) & (Internal.Block);
    static STONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static POTTED_CRIMSON_FUNGUS: (Internal.FlowerPotBlock) & (Internal.Block);
    static DEEPSLATE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CHERRY_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static POLISHED_ANDESITE: (Internal.Block) & (Internal.Block);
    static RED_NETHER_BRICKS: (Internal.Block) & (Internal.Block);
    static TORCH: (Internal.TorchBlock) & (Internal.Block);
    static COAL_BLOCK: (Internal.Block) & (Internal.Block);
    static STRIPPED_CRIMSON_STEM: (Internal.RotatedPillarBlock) & (Internal.Block);
    static FIRE_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static WEEPING_VINES_PLANT: (Internal.WeepingVinesPlantBlock) & (Internal.Block);
    static PEONY: (Internal.TallFlowerBlock) & (Internal.Block);
    static CARROTS: (Internal.CarrotBlock) & (Internal.Block);
    static YELLOW_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static CYAN_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static BLUE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static TUBE_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static SMITHING_TABLE: (Internal.SmithingTableBlock) & (Internal.Block);
    static ACACIA_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static MAGENTA_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static POTTED_CHERRY_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static PLAYER_WALL_HEAD: (Internal.PlayerWallHeadBlock) & (Internal.Block);
    static DEAD_HORN_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static MANGROVE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static SPRUCE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static IRON_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static TRIPWIRE: (Internal.TripWireBlock) & (Internal.Block);
    static BLACK_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static LIGHT_BLUE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static ACACIA_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CRIMSON_FUNGUS: (Internal.FungusBlock) & (Internal.Block);
    static BUBBLE_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static LIGHT_BLUE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static PRISMARINE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static DEAD_TUBE_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static PURPLE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static RED_NETHER_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static SCULK_SENSOR: (Internal.SculkSensorBlock) & (Internal.Block);
    static YELLOW_WOOL: (Internal.Block) & (Internal.Block);
    static MAGENTA_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static SAND: (Internal.SandBlock) & (Internal.Block);
    static MYCELIUM: (Internal.MyceliumBlock) & (Internal.Block);
    static LIGHT_GRAY_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static ORANGE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static CORNFLOWER: (Internal.FlowerBlock) & (Internal.Block);
    static DARK_OAK_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static GRANITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static REDSTONE_LAMP: (Internal.RedstoneLampBlock) & (Internal.Block);
    static LIGHT: (Internal.LightBlock) & (Internal.Block);
    static TUBE_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static WARPED_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static DANDELION: (Internal.FlowerBlock) & (Internal.Block);
    static PINK_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static WARPED_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static RED_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static SOUL_SOIL: (Internal.Block) & (Internal.Block);
    static ACACIA_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static CRIMSON_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static HEAVY_WEIGHTED_PRESSURE_PLATE: (Internal.WeightedPressurePlateBlock) & (Internal.Block);
    static PRISMARINE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static TWISTING_VINES_PLANT: (Internal.TwistingVinesPlantBlock) & (Internal.Block);
    static DEEPSLATE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static WARPED_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static OAK_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PINK_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static RED_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static WARPED_WART_BLOCK: (Internal.Block) & (Internal.Block);
    static EXPOSED_CUT_COPPER_STAIRS: (Internal.WeatheringCopperStairBlock) & (Internal.Block);
    static COARSE_DIRT: (Internal.Block) & (Internal.Block);
    static DEEPSLATE_REDSTONE_ORE: (Internal.RedStoneOreBlock) & (Internal.Block);
    static TUFF: (Internal.Block) & (Internal.Block);
    static CHISELED_BOOKSHELF: (Internal.ChiseledBookShelfBlock) & (Internal.Block);
    static ACACIA_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DEEPSLATE_IRON_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static PURPLE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static LIGHTNING_ROD: (Internal.LightningRodBlock) & (Internal.Block);
    static COBBLED_DEEPSLATE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static CHERRY_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static LILY_PAD: (Internal.WaterlilyBlock) & (Internal.Block);
    static GREEN_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static BARRIER: (Internal.BarrierBlock) & (Internal.Block);
    static PINK_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static DRAGON_HEAD: (Internal.SkullBlock) & (Internal.Block);
    static YELLOW_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static DEAD_BUBBLE_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static STRIPPED_BIRCH_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static SEAGRASS: (Internal.SeagrassBlock) & (Internal.Block);
    static CHERRY_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static HORN_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static MOSSY_STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static SPRUCE_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static WAXED_COPPER_BLOCK: (Internal.Block) & (Internal.Block);
    static STONE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static GRANITE_WALL: (Internal.WallBlock) & (Internal.Block);
    static NETHER_BRICK_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static MOSS_CARPET: (Internal.CarpetBlock) & (Internal.Block);
    static DARK_OAK_PLANKS: (Internal.Block) & (Internal.Block);
    static MAGENTA_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static ANDESITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_NETHER_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static BIRCH_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static BAMBOO_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static BROWN_CONCRETE: (Internal.Block) & (Internal.Block);
    static DEEPSLATE_DIAMOND_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static BEETROOTS: (Internal.BeetrootBlock) & (Internal.Block);
    static POTTED_BAMBOO: (Internal.FlowerPotBlock) & (Internal.Block);
    static FERN: (Internal.TallGrassBlock) & (Internal.Block);
    static CRIMSON_HYPHAE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static WAXED_CUT_COPPER: (Internal.Block) & (Internal.Block);
    static ACACIA_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static BLACK_WOOL: (Internal.Block) & (Internal.Block);
    static POLISHED_BLACKSTONE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static BRAIN_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static VINE: (Internal.VineBlock) & (Internal.Block);
    static CHERRY_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static ANDESITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static INFESTED_DEEPSLATE: (Internal.InfestedRotatedPillarBlock) & (Internal.Block);
    static ACACIA_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static SPONGE: (Internal.SpongeBlock) & (Internal.Block);
    static REDSTONE_ORE: (Internal.RedStoneOreBlock) & (Internal.Block);
    static STRIPPED_ACACIA_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static REDSTONE_WALL_TORCH: (Internal.RedstoneWallTorchBlock) & (Internal.Block);
    static CYAN_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static BLACK_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static CAMPFIRE: (Internal.CampfireBlock) & (Internal.Block);
    static OCHRE_FROGLIGHT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static COBBLESTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DRAGON_WALL_HEAD: (Internal.WallSkullBlock) & (Internal.Block);
    static POTTED_WITHER_ROSE: (Internal.FlowerPotBlock) & (Internal.Block);
    static BLACKSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static GRAY_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static CYAN_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static BAMBOO_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static BIRCH_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static POTTED_CORNFLOWER: (Internal.FlowerPotBlock) & (Internal.Block);
    static STICKY_PISTON: (Internal.PistonBaseBlock) & (Internal.Block);
    static LIGHT_BLUE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static WEATHERED_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static CYAN_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static RAW_GOLD_BLOCK: (Internal.Block) & (Internal.Block);
    static STRIPPED_BIRCH_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static LARGE_AMETHYST_BUD: (Internal.AmethystClusterBlock) & (Internal.Block);
    static POLISHED_ANDESITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static NETHER_PORTAL: (Internal.NetherPortalBlock) & (Internal.Block);
    static JUNGLE_PLANKS: (Internal.Block) & (Internal.Block);
    static PINK_TULIP: (Internal.FlowerBlock) & (Internal.Block);
    static OAK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static STRIPPED_WARPED_HYPHAE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static POTTED_OAK_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static MANGROVE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static DARK_OAK_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static EXPOSED_CUT_COPPER_SLAB: (Internal.WeatheringCopperSlabBlock) & (Internal.Block);
    static ORANGE_CONCRETE: (Internal.Block) & (Internal.Block);
    static BLUE_ORCHID: (Internal.FlowerBlock) & (Internal.Block);
    static STRIPPED_BAMBOO_BLOCK: (Internal.RotatedPillarBlock) & (Internal.Block);
    static BIRCH_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static GRAY_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static DEEPSLATE_TILES: (Internal.Block) & (Internal.Block);
    static CRIMSON_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static WHITE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static KELP: (Internal.KelpBlock) & (Internal.Block);
    static BROWN_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static INFESTED_CRACKED_STONE_BRICKS: (Internal.InfestedBlock) & (Internal.Block);
    static JUNGLE_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static LIGHT_GRAY_CONCRETE: (Internal.Block) & (Internal.Block);
    static RED_MUSHROOM_BLOCK: (Internal.HugeMushroomBlock) & (Internal.Block);
    static GRAY_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static MOSS_BLOCK: (Internal.MossBlock) & (Internal.Block);
    static LIME_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static CRIMSON_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CARVED_PUMPKIN: (Internal.EquipableCarvedPumpkinBlock) & (Internal.Block);
    static POTATOES: (Internal.PotatoBlock) & (Internal.Block);
    static PURPUR_PILLAR: (Internal.RotatedPillarBlock) & (Internal.Block);
    static MUD_BRICKS: (Internal.Block) & (Internal.Block);
    static DEAD_FIRE_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static MANGROVE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CHERRY_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static NOTE_BLOCK: (Internal.NoteBlock) & (Internal.Block);
    static ENDER_CHEST: (Internal.EnderChestBlock) & (Internal.Block);
    static CYAN_BED: (Internal.BedBlock) & (Internal.Block);
    static DEAD_TUBE_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static BIRCH_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static YELLOW_CONCRETE: (Internal.Block) & (Internal.Block);
    static DEAD_TUBE_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static STRIPPED_WARPED_STEM: (Internal.RotatedPillarBlock) & (Internal.Block);
    static LEVER: (Internal.LeverBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE: (Internal.Block) & (Internal.Block);
    static LIGHT_BLUE_CONCRETE: (Internal.Block) & (Internal.Block);
    static POTTED_MANGROVE_PROPAGULE: (Internal.FlowerPotBlock) & (Internal.Block);
    static DROPPER: (Internal.DropperBlock) & (Internal.Block);
    static SPRUCE_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static RED_SANDSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CRAFTING_TABLE: (Internal.CraftingTableBlock) & (Internal.Block);
    static SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static GRASS: (Internal.TallGrassBlock) & (Internal.Block);
    static CHERRY_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MEDIUM_AMETHYST_BUD: (Internal.AmethystClusterBlock) & (Internal.Block);
    static CRIMSON_ROOTS: (Internal.RootsBlock) & (Internal.Block);
    static WITHER_ROSE: (Internal.WitherRoseBlock) & (Internal.Block);
    static OXEYE_DAISY: (Internal.FlowerBlock) & (Internal.Block);
    static OAK_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static EMERALD_BLOCK: (Internal.Block) & (Internal.Block);
    static BUDDING_AMETHYST: (Internal.BuddingAmethystBlock) & (Internal.Block);
    static RAIL: (Internal.RailBlock) & (Internal.Block);
    static JUNGLE_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static BROWN_MUSHROOM_BLOCK: (Internal.HugeMushroomBlock) & (Internal.Block);
    static DARK_OAK_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static DIAMOND_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static LADDER: (Internal.LadderBlock) & (Internal.Block);
    static OAK_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static MELON: (Internal.MelonBlock) & (Internal.Block);
    static CRIMSON_PLANKS: (Internal.Block) & (Internal.Block);
    static GLOW_LICHEN: (Internal.GlowLichenBlock) & (Internal.Block);
    static REDSTONE_WIRE: (Internal.RedStoneWireBlock) & (Internal.Block);
    static HORN_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static DARK_PRISMARINE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CAVE_VINES_PLANT: (Internal.CaveVinesPlantBlock) & (Internal.Block);
    static ACACIA_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static YELLOW_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static SMOOTH_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static COBBLED_DEEPSLATE_WALL: (Internal.WallBlock) & (Internal.Block);
    static CRIMSON_NYLIUM: (Internal.NyliumBlock) & (Internal.Block);
    static POTTED_BLUE_ORCHID: (Internal.FlowerPotBlock) & (Internal.Block);
    static CYAN_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static SCULK_CATALYST: (Internal.SculkCatalystBlock) & (Internal.Block);
    static STRIPPED_MANGROVE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DISPENSER: (Internal.DispenserBlock) & (Internal.Block);
    static PRISMARINE_WALL: (Internal.WallBlock) & (Internal.Block);
    static ORANGE_TULIP: (Internal.FlowerBlock) & (Internal.Block);
    static COMMAND_BLOCK: (Internal.CommandBlock) & (Internal.Block);
    static BLACK_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static SPORE_BLOSSOM: (Internal.SporeBlossomBlock) & (Internal.Block);
    static OXIDIZED_CUT_COPPER_STAIRS: (Internal.WeatheringCopperStairBlock) & (Internal.Block);
    static DEEPSLATE_TILE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static JUNGLE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DIRT_PATH: (Internal.DirtPathBlock) & (Internal.Block);
    static BLUE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static GREEN_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static HONEYCOMB_BLOCK: (Internal.Block) & (Internal.Block);
    static ICE: (Internal.IceBlock) & (Internal.Block);
    static BAMBOO_MOSAIC_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static POTTED_BIRCH_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static WHITE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static WATER: (Internal.LiquidBlock) & (Internal.Block);
    static CRACKED_NETHER_BRICKS: (Internal.Block) & (Internal.Block);
    static WATER_CAULDRON: (Internal.LayeredCauldronBlock) & (Internal.Block);
    static MUD_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static WAXED_CUT_COPPER_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static POLISHED_DEEPSLATE_WALL: (Internal.WallBlock) & (Internal.Block);
    static OAK_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static OAK_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static POTTED_BROWN_MUSHROOM: (Internal.FlowerPotBlock) & (Internal.Block);
    static WARPED_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static JUKEBOX: (Internal.JukeboxBlock) & (Internal.Block);
    static MANGROVE_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static NETHER_BRICKS: (Internal.Block) & (Internal.Block);
    static PLAYER_HEAD: (Internal.PlayerHeadBlock) & (Internal.Block);
    static PURPLE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static DEAD_TUBE_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static BIRCH_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static POWDER_SNOW_CAULDRON: (Internal.PowderSnowCauldronBlock) & (Internal.Block);
    static BROWN_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static BREWING_STAND: (Internal.BrewingStandBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static REDSTONE_TORCH: (Internal.RedstoneTorchBlock) & (Internal.Block);
    static BAMBOO_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static BLACK_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static POLISHED_GRANITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static MAGENTA_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static DEAD_BRAIN_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static BLACK_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static NETHER_SPROUTS: (Internal.NetherSproutsBlock) & (Internal.Block);
    static GREEN_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static SPRUCE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PURPLE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static CONDUIT: (Internal.ConduitBlock) & (Internal.Block);
    static ORANGE_WOOL: (Internal.Block) & (Internal.Block);
    static POTTED_WHITE_TULIP: (Internal.FlowerPotBlock) & (Internal.Block);
    static PRISMARINE_BRICKS: (Internal.Block) & (Internal.Block);
    static POLISHED_BLACKSTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static SEA_LANTERN: (Internal.Block) & (Internal.Block);
    static MAGENTA_BED: (Internal.BedBlock) & (Internal.Block);
    static POLISHED_DEEPSLATE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static STONE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static SCAFFOLDING: (Internal.ScaffoldingBlock) & (Internal.Block);
    static NETHER_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DIORITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static PISTON_HEAD: (Internal.PistonHeadBlock) & (Internal.Block);
    static BLACK_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static PURPLE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static LIME_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static OAK_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static CUT_RED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static DEAD_FIRE_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static LIME_BED: (Internal.BedBlock) & (Internal.Block);
    static SPAWNER: (Internal.ApothSpawnerBlock) & (Internal.Block);
    static FROSTED_ICE: (Internal.FrostedIceBlock) & (Internal.Block);
    static IRON_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static WARPED_ROOTS: (Internal.RootsBlock) & (Internal.Block);
    static STONE: (Internal.Block) & (Internal.Block);
    static MUD_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static SOUL_LANTERN: (Internal.LanternBlock) & (Internal.Block);
    static COPPER_BLOCK: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static WAXED_OXIDIZED_COPPER: (Internal.Block) & (Internal.Block);
    static WARPED_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static POLISHED_BASALT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DAYLIGHT_DETECTOR: (Internal.DaylightDetectorBlock) & (Internal.Block);
    static CRIMSON_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CHERRY_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static GOLD_BLOCK: (Internal.Block) & (Internal.Block);
    static POTTED_LILY_OF_THE_VALLEY: (Internal.FlowerPotBlock) & (Internal.Block);
    static LIGHT_BLUE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static LIGHT_GRAY_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static DRIPSTONE_BLOCK: (Internal.Block) & (Internal.Block);
    static COBBLED_DEEPSLATE: (Internal.Block) & (Internal.Block);
    static BIG_DRIPLEAF: (Internal.BigDripleafBlock) & (Internal.Block);
    static MANGROVE_LEAVES: (Internal.MangroveLeavesBlock) & (Internal.Block);
    static GRAY_WOOL: (Internal.Block) & (Internal.Block);
    static INFESTED_CHISELED_STONE_BRICKS: (Internal.InfestedBlock) & (Internal.Block);
    static GRAY_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static CHERRY_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static REPEATING_COMMAND_BLOCK: (Internal.CommandBlock) & (Internal.Block);
    static WARPED_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static RED_BED: (Internal.BedBlock) & (Internal.Block);
    static CHERRY_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static POTTED_DANDELION: (Internal.FlowerPotBlock) & (Internal.Block);
    static POTTED_CACTUS: (Internal.FlowerPotBlock) & (Internal.Block);
    static DIORITE_WALL: (Internal.WallBlock) & (Internal.Block);
    static HOPPER: (Internal.HopperBlock) & (Internal.Block);
    static SPRUCE_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static BARREL: (Internal.BarrelBlock) & (Internal.Block);
    static MELON_STEM: (Internal.StemBlock) & (Internal.Block);
    static ROOTED_DIRT: (Internal.RootedDirtBlock) & (Internal.Block);
    static LIGHT_BLUE_WOOL: (Internal.Block) & (Internal.Block);
    static SOUL_WALL_TORCH: (Internal.WallTorchBlock) & (Internal.Block);
    static LAPIS_BLOCK: (Internal.Block) & (Internal.Block);
    static ANDESITE: (Internal.Block) & (Internal.Block);
    static YELLOW_BED: (Internal.BedBlock) & (Internal.Block);
    static END_STONE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BLAST_FURNACE: (Internal.BlastFurnaceBlock) & (Internal.Block);
    static SMALL_DRIPLEAF: (Internal.SmallDripleafBlock) & (Internal.Block);
    static KELP_PLANT: (Internal.KelpPlantBlock) & (Internal.Block);
    static RED_SAND: (Internal.SandBlock) & (Internal.Block);
    static JUNGLE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static QUARTZ_BRICKS: (Internal.Block) & (Internal.Block);
    static CRIMSON_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static ZOMBIE_WALL_HEAD: (Internal.WallSkullBlock) & (Internal.Block);
    static LIME_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static RAW_COPPER_BLOCK: (Internal.Block) & (Internal.Block);
    static CHERRY_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static ORANGE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static LOOM: (Internal.LoomBlock) & (Internal.Block);
    static GREEN_WOOL: (Internal.Block) & (Internal.Block);
    static BROWN_WOOL: (Internal.Block) & (Internal.Block);
    static LIGHT_GRAY_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static PIGLIN_WALL_HEAD: (Internal.PiglinWallSkullBlock) & (Internal.Block);
    static BLUE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static PINK_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static SMOKER: (Internal.SmokerBlock) & (Internal.Block);
    static ANVIL: (Internal.ApothAnvilBlock) & (Internal.Block);
    static BROWN_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static FLOWER_POT: (Internal.FlowerPotBlock) & (Internal.Block);
    static LIGHT_BLUE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static STONECUTTER: (Internal.StonecutterBlock) & (Internal.Block);
    static CUT_RED_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_CONCRETE: (Internal.Block) & (Internal.Block);
    static DARK_OAK_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static GREEN_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static BAMBOO: (Internal.ApothBambooBlock) & (Internal.Block);
    static DEAD_HORN_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static DARK_OAK_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static MAGENTA_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static DARK_OAK_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static CHISELED_RED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static CRIMSON_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static PITCHER_CROP: (Internal.PitcherCropBlock) & (Internal.Block);
    static CHERRY_LEAVES: (Internal.CherryLeavesBlock) & (Internal.Block);
    static RED_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static QUARTZ_PILLAR: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CHISELED_POLISHED_BLACKSTONE: (Internal.Block) & (Internal.Block);
    static DEAD_FIRE_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static PURPLE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static RED_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static AMETHYST_CLUSTER: (Internal.AmethystClusterBlock) & (Internal.Block);
    static DARK_PRISMARINE: (Internal.Block) & (Internal.Block);
    static MANGROVE_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static SCULK_VEIN: (Internal.SculkVeinBlock) & (Internal.Block);
    static JUNGLE_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static YELLOW_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static OBSERVER: (Internal.ObserverBlock) & (Internal.Block);
    static END_STONE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static SPRUCE_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static MANGROVE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static WAXED_EXPOSED_CUT_COPPER: (Internal.Block) & (Internal.Block);
    static STONE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static BAMBOO_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static SPRUCE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static NETHER_WART: (Internal.NetherWartBlock) & (Internal.Block);
    static WAXED_OXIDIZED_CUT_COPPER_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static OBSIDIAN: (Internal.Block) & (Internal.Block);
    static PURPLE_CONCRETE: (Internal.Block) & (Internal.Block);
    static BLACK_CONCRETE: (Internal.Block) & (Internal.Block);
    static WARPED_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static REINFORCED_DEEPSLATE: (Internal.Block) & (Internal.Block);
    static DRAGON_EGG: (Internal.DragonEggBlock) & (Internal.Block);
    static PACKED_MUD: (Internal.Block) & (Internal.Block);
    static ACACIA_PLANKS: (Internal.Block) & (Internal.Block);
    static RED_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static DARK_OAK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static MOSSY_STONE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static LIGHT_WEIGHTED_PRESSURE_PLATE: (Internal.WeightedPressurePlateBlock) & (Internal.Block);
    static FIRE_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static QUARTZ_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static PURPUR_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static STONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static STRIPPED_JUNGLE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static RED_WOOL: (Internal.Block) & (Internal.Block);
    static FARMLAND: (Internal.FarmBlock) & (Internal.Block);
    static DARK_OAK_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static ORANGE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static DEEPSLATE_GOLD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static LIGHT_BLUE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static BRICKS: (Internal.Block) & (Internal.Block);
    static WAXED_EXPOSED_CUT_COPPER_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MOSSY_COBBLESTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CAKE: (Internal.CakeBlock) & (Internal.Block);
    static GREEN_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static JUNGLE_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static BLUE_BED: (Internal.BedBlock) & (Internal.Block);
    static OAK_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static MANGROVE_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static DEEPSLATE_BRICKS: (Internal.Block) & (Internal.Block);
    static BASALT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static REPEATER: (Internal.RepeaterBlock) & (Internal.Block);
    static PURPLE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static AZURE_BLUET: (Internal.FlowerBlock) & (Internal.Block);
    static LILY_OF_THE_VALLEY: (Internal.FlowerBlock) & (Internal.Block);
    static STONE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static BIRCH_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static BIRCH_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static LIGHT_BLUE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static BROWN_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static FIRE_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static SANDSTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static RESPAWN_ANCHOR: (Internal.RespawnAnchorBlock) & (Internal.Block);
    static PRISMARINE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static NETHER_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static NETHERRACK: (Internal.NetherrackBlock) & (Internal.Block);
    static CAVE_VINES: (Internal.CaveVinesBlock) & (Internal.Block);
    static WARPED_NYLIUM: (Internal.NyliumBlock) & (Internal.Block);
    static POTTED_POPPY: (Internal.FlowerPotBlock) & (Internal.Block);
    static POINTED_DRIPSTONE: (Internal.PointedDripstoneBlock) & (Internal.Block);
    static ORANGE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static LIGHT_GRAY_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static WAXED_WEATHERED_CUT_COPPER_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BRICKS: (Internal.Block) & (Internal.Block);
    static GLASS: (Internal.GlassBlock) & (Internal.Block);
    static WARPED_PLANKS: (Internal.Block) & (Internal.Block);
    static WET_SPONGE: (Internal.WetSpongeBlock) & (Internal.Block);
    static GRASS_BLOCK: (Internal.GrassBlock) & (Internal.Block);
    static COAL_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static PURPUR_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static WARPED_STEM: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DEEPSLATE_COPPER_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static POLISHED_DIORITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static ANCIENT_DEBRIS: (Internal.Block) & (Internal.Block);
    static GRAY_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static DEAD_BRAIN_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static WHITE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static END_STONE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static PODZOL: (Internal.SnowyDirtBlock) & (Internal.Block);
    static CHERRY_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static COMPARATOR: (Internal.ComparatorBlock) & (Internal.Block);
    static ACACIA_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static CHISELED_STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static WAXED_WEATHERED_COPPER: (Internal.Block) & (Internal.Block);
    static SUGAR_CANE: (Internal.ApothSugarcaneBlock) & (Internal.Block);
    static DEAD_BRAIN_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static NETHERITE_BLOCK: (Internal.Block) & (Internal.Block);
    static OAK_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static WHITE_CONCRETE: (Internal.Block) & (Internal.Block);
    static POTTED_AZURE_BLUET: (Internal.FlowerPotBlock) & (Internal.Block);
    static SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static ORANGE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static ORANGE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static BRAIN_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static PINK_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static OXIDIZED_CUT_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static GRAY_BED: (Internal.BedBlock) & (Internal.Block);
    static GLASS_PANE: (Internal.IronBarsBlock) & (Internal.Block);
    static GRAVEL: (Internal.GravelBlock) & (Internal.Block);
    static BAMBOO_MOSAIC: (Internal.Block) & (Internal.Block);
    static SUSPICIOUS_GRAVEL: (Internal.BrushableBlock) & (Internal.Block);
    static ENCHANTING_TABLE: (Internal.ApothEnchantBlock) & (Internal.Block);
    static LILAC: (Internal.TallFlowerBlock) & (Internal.Block);
    static STRIPPED_SPRUCE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static MANGROVE_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static RED_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static STRIPPED_JUNGLE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static ALLIUM: (Internal.FlowerBlock) & (Internal.Block);
    static MUD_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DEAD_BRAIN_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static LIGHT_GRAY_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static ZOMBIE_HEAD: (Internal.SkullBlock) & (Internal.Block);
    static WHITE_TULIP: (Internal.FlowerBlock) & (Internal.Block);
    static PINK_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static MOSSY_COBBLESTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static CRACKED_DEEPSLATE_BRICKS: (Internal.Block) & (Internal.Block);
    static WHITE_WOOL: (Internal.Block) & (Internal.Block);
    static GREEN_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static GRAY_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static BLACK_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static TUBE_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static JUNGLE_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static CUT_SANDSTONE: (Internal.Block) & (Internal.Block);
    static POLISHED_GRANITE: (Internal.Block) & (Internal.Block);
    static DARK_OAK_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static SKELETON_WALL_SKULL: (Internal.WallSkullBlock) & (Internal.Block);
    static TALL_GRASS: (Internal.DoublePlantBlock) & (Internal.Block);
    static POTTED_JUNGLE_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static YELLOW_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static PEARLESCENT_FROGLIGHT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DARK_OAK_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static MAGENTA_WOOL: (Internal.Block) & (Internal.Block);
    static PUMPKIN_STEM: (Internal.StemBlock) & (Internal.Block);
    static MUD: (Internal.MudBlock) & (Internal.Block);
    static GRINDSTONE: (Internal.GrindstoneBlock) & (Internal.Block);
    static LIGHT_BLUE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static BAMBOO_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static BLUE_ICE: (Internal.HalfTransparentBlock) & (Internal.Block);
    static BROWN_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static FLOWERING_AZALEA: (Internal.AzaleaBlock) & (Internal.Block);
    static CHERRY_PLANKS: (Internal.Block) & (Internal.Block);
    static PACKED_ICE: (Internal.Block) & (Internal.Block);
    static ACACIA_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static GRAY_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static DARK_OAK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static BLUE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static ORANGE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static BEEHIVE: (Internal.BeehiveBlock) & (Internal.Block);
    static PURPLE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static BLUE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static BLACK_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static WHITE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static NETHER_GOLD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static LODESTONE: (Internal.Block) & (Internal.Block);
    static WEEPING_VINES: (Internal.WeepingVinesBlock) & (Internal.Block);
    static MAGENTA_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static OAK_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static END_PORTAL: (Internal.EndPortalBlock) & (Internal.Block);
    static TINTED_GLASS: (Internal.TintedGlassBlock) & (Internal.Block);
    static LIME_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static SKELETON_SKULL: (Internal.SkullBlock) & (Internal.Block);
    static LIME_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static END_STONE: (Internal.Block) & (Internal.Block);
    static JUNGLE_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static TWISTING_VINES: (Internal.TwistingVinesBlock) & (Internal.Block);
    static END_PORTAL_FRAME: (Internal.EndPortalFrameBlock) & (Internal.Block);
    static CRIMSON_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static SPRUCE_PLANKS: (Internal.Block) & (Internal.Block);
    static POLISHED_GRANITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static YELLOW_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static SNIFFER_EGG: (Internal.SnifferEggBlock) & (Internal.Block);
    static MOSSY_COBBLESTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CHERRY_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static ORANGE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static LIGHT_BLUE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static ACACIA_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static GRAY_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static GRAY_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static BIRCH_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CRACKED_DEEPSLATE_TILES: (Internal.Block) & (Internal.Block);
    static HANGING_ROOTS: (Internal.HangingRootsBlock) & (Internal.Block);
    static TURTLE_EGG: (Internal.TurtleEggBlock) & (Internal.Block);
    static BLACKSTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static SMOOTH_RED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static BAMBOO_SAPLING: (Internal.BambooSaplingBlock) & (Internal.Block);
    static WAXED_OXIDIZED_CUT_COPPER_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static WHITE_BED: (Internal.BedBlock) & (Internal.Block);
    static CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static DETECTOR_RAIL: (Internal.DetectorRailBlock) & (Internal.Block);
    static COPPER_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static CAULDRON: (Internal.CauldronBlock) & (Internal.Block);
    static LANTERN: (Internal.LanternBlock) & (Internal.Block);
    static GLOWSTONE: (Internal.Block) & (Internal.Block);
    static YELLOW_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static VOID_AIR: (Internal.AirBlock) & (Internal.Block);
    static PURPUR_BLOCK: (Internal.Block) & (Internal.Block);
    static INFESTED_STONE: (Internal.InfestedBlock) & (Internal.Block);
    static CHAIN: (Internal.ChainBlock) & (Internal.Block);
    static STRIPPED_SPRUCE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static OAK_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static OAK_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static MAGMA_BLOCK: (Internal.MagmaBlock) & (Internal.Block);
    static DIORITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static RED_SANDSTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static LAPIS_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static SPRUCE_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static SMOOTH_STONE: (Internal.Block) & (Internal.Block);
    static BUBBLE_COLUMN: (Internal.BubbleColumnBlock) & (Internal.Block);
    static CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static POLISHED_DIORITE: (Internal.Block) & (Internal.Block);
    static BIRCH_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static AIR: (Internal.AirBlock) & (Internal.Block);
    static AZALEA_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static WHITE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static CAVE_AIR: (Internal.AirBlock) & (Internal.Block);
    static MOSSY_COBBLESTONE: (Internal.Block) & (Internal.Block);
    static OAK_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static BAMBOO_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static EMERALD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static CYAN_WOOL: (Internal.Block) & (Internal.Block);
    static BIRCH_PLANKS: (Internal.Block) & (Internal.Block);
    static POTTED_ORANGE_TULIP: (Internal.FlowerPotBlock) & (Internal.Block);
    static POTTED_WARPED_ROOTS: (Internal.FlowerPotBlock) & (Internal.Block);
    static SPRUCE_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static DARK_PRISMARINE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static SMALL_AMETHYST_BUD: (Internal.AmethystClusterBlock) & (Internal.Block);
    static SPRUCE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static WITHER_SKELETON_SKULL: (Internal.WitherSkullBlock) & (Internal.Block);
    static BUBBLE_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static CREEPER_WALL_HEAD: (Internal.WallSkullBlock) & (Internal.Block);
    static STRIPPED_OAK_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static ACACIA_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CHAIN_COMMAND_BLOCK: (Internal.CommandBlock) & (Internal.Block);
    static PIGLIN_HEAD: (Internal.SkullBlock) & (Internal.Block);
    static MANGROVE_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static INFESTED_MOSSY_STONE_BRICKS: (Internal.InfestedBlock) & (Internal.Block);
    static BROWN_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static BLUE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static ACACIA_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static CYAN_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static FLETCHING_TABLE: (Internal.ApothFletchingBlock) & (Internal.Block);
    static TORCHFLOWER_CROP: (Internal.TorchflowerCropBlock) & (Internal.Block);
    static GRAY_CONCRETE: (Internal.Block) & (Internal.Block);
    static WARPED_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static HORN_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static BROWN_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static END_GATEWAY: (Internal.EndGatewayBlock) & (Internal.Block);
    static DEEPSLATE_TILE_WALL: (Internal.WallBlock) & (Internal.Block);
    static POTTED_ALLIUM: (Internal.FlowerPotBlock) & (Internal.Block);
    static COBBLESTONE: (Internal.Block) & (Internal.Block);
    static OAK_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static CALCITE: (Internal.Block) & (Internal.Block);
    static MANGROVE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static POTTED_OXEYE_DAISY: (Internal.FlowerPotBlock) & (Internal.Block);
    static FIRE_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static OAK_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static STRIPPED_CRIMSON_HYPHAE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static BIRCH_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static TERRACOTTA: (Internal.Block) & (Internal.Block);
    static JUNGLE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static NETHER_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static CYAN_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static BAMBOO_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static END_ROD: (Internal.EndRodBlock) & (Internal.Block);
    static LIGHT_BLUE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static SMOOTH_QUARTZ: (Internal.Block) & (Internal.Block);
    static PRISMARINE: (Internal.Block) & (Internal.Block);
    static SMOOTH_QUARTZ_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static NETHER_QUARTZ_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static MUDDY_MANGROVE_ROOTS: (Internal.RotatedPillarBlock) & (Internal.Block);
    static LIGHT_GRAY_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static MANGROVE_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static DEEPSLATE_TILE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static ATTACHED_PUMPKIN_STEM: (Internal.AttachedStemBlock) & (Internal.Block);
    static CYAN_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static OXIDIZED_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static POLISHED_DEEPSLATE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static POLISHED_DEEPSLATE: (Internal.Block) & (Internal.Block);
    static COCOA: (Internal.CocoaBlock) & (Internal.Block);
    static JUNGLE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static BIRCH_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static SPRUCE_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static POTTED_RED_MUSHROOM: (Internal.FlowerPotBlock) & (Internal.Block);
    static MAGENTA_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static JUNGLE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static WARPED_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static CRIMSON_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static CHEST: (Internal.ChestBlock) & (Internal.Block);
    static SPRUCE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PINK_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static BLACKSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static LIME_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static GILDED_BLACKSTONE: (Internal.Block) & (Internal.Block);
    static SUNFLOWER: (Internal.TallFlowerBlock) & (Internal.Block);
    static ORANGE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static VERDANT_FROGLIGHT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PETRIFIED_OAK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_NETHER_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DRIED_KELP_BLOCK: (Internal.Block) & (Internal.Block);
    static BONE_BLOCK: (Internal.RotatedPillarBlock) & (Internal.Block);
    static WHITE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static POTTED_SPRUCE_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static DEAD_HORN_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static BUBBLE_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static GREEN_CONCRETE: (Internal.Block) & (Internal.Block);
    static CHORUS_FLOWER: (Internal.ChorusFlowerBlock) & (Internal.Block);
    static GRAY_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static SMOOTH_SANDSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static RED_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static YELLOW_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static LIGHT_GRAY_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static PINK_WOOL: (Internal.Block) & (Internal.Block);
    static PINK_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static CYAN_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static DARK_OAK_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static POWERED_RAIL: (Internal.PoweredRailBlock) & (Internal.Block);
    static LIGHT_BLUE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static POWDER_SNOW: (Internal.PowderSnowBlock) & (Internal.Block);
    static ORANGE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static PINK_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static BLACK_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static SPRUCE_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static GRAY_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static WARPED_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static JIGSAW: (Internal.JigsawBlock) & (Internal.Block);
    static WHITE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static SPRUCE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static LIGHT_GRAY_WOOL: (Internal.Block) & (Internal.Block);
    static PISTON: (Internal.PistonBaseBlock) & (Internal.Block);
    static SMOOTH_RED_SANDSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CUT_COPPER_STAIRS: (Internal.WeatheringCopperStairBlock) & (Internal.Block);
    static DIRT: (Internal.Block) & (Internal.Block);
    static BLUE_CONCRETE: (Internal.Block) & (Internal.Block);
    static RED_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static DEAD_BUBBLE_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static OXIDIZED_CUT_COPPER_SLAB: (Internal.WeatheringCopperSlabBlock) & (Internal.Block);
    static TALL_SEAGRASS: (Internal.TallSeagrassBlock) & (Internal.Block);
    static CHORUS_PLANT: (Internal.ChorusPlantBlock) & (Internal.Block);
    static PINK_CONCRETE: (Internal.Block) & (Internal.Block);
    static WHITE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static MOVING_PISTON: (Internal.MovingPistonBlock) & (Internal.Block);
    static CHERRY_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static MANGROVE_ROOTS: (Internal.MangroveRootsBlock) & (Internal.Block);
    static POTTED_ACACIA_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static MANGROVE_PLANKS: (Internal.Block) & (Internal.Block);
    static ACACIA_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static WAXED_OXIDIZED_CUT_COPPER: (Internal.Block) & (Internal.Block);
    static BAMBOO_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static RED_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static BLUE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static BELL: (Internal.BellBlock) & (Internal.Block);
    static MUSHROOM_STEM: (Internal.HugeMushroomBlock) & (Internal.Block);
    static EXPOSED_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static CYAN_CONCRETE: (Internal.Block) & (Internal.Block);
    static POTTED_CRIMSON_ROOTS: (Internal.FlowerPotBlock) & (Internal.Block);
    static GREEN_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static CHISELED_QUARTZ_BLOCK: (Internal.Block) & (Internal.Block);
    static JUNGLE_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static FROGSPAWN: (Internal.FrogspawnBlock) & (Internal.Block);
    static SOUL_TORCH: (Internal.TorchBlock) & (Internal.Block);
    static BOOKSHELF: (Internal.Block) & (Internal.Block);
    static WAXED_EXPOSED_COPPER: (Internal.Block) & (Internal.Block);
    static CRIMSON_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static DIAMOND_BLOCK: (Internal.Block) & (Internal.Block);
    static RED_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static CRIMSON_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static SANDSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static MAGENTA_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static STRIPPED_DARK_OAK_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DEAD_BUBBLE_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static SPRUCE_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static BLUE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static STRIPPED_CHERRY_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CALIBRATED_SCULK_SENSOR: (Internal.CalibratedSculkSensorBlock) & (Internal.Block);
    static AMETHYST_BLOCK: (Internal.AmethystBlock) & (Internal.Block);
    static STRUCTURE_BLOCK: (Internal.StructureBlock) & (Internal.Block);
    static BAMBOO_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static BRAIN_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static BAMBOO_MOSAIC_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static STRIPPED_DARK_OAK_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static SMOOTH_SANDSTONE: (Internal.Block) & (Internal.Block);
    static WAXED_EXPOSED_CUT_COPPER_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BLUE_WOOL: (Internal.Block) & (Internal.Block);
    static IRON_BARS: (Internal.IronBarsBlock) & (Internal.Block);
    static IRON_BLOCK: (Internal.Block) & (Internal.Block);
    static SUSPICIOUS_SAND: (Internal.BrushableBlock) & (Internal.Block);
    static HORN_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static MAGENTA_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static HONEY_BLOCK: (Internal.HoneyBlock) & (Internal.Block);
    static END_STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static JACK_O_LANTERN: (Internal.CarvedPumpkinBlock) & (Internal.Block);
    static TARGET: (Internal.TargetBlock) & (Internal.Block);
    static BRAIN_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static DEAD_FIRE_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static MOSSY_STONE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static BLUE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static WITHER_SKELETON_WALL_SKULL: (Internal.WitherWallSkullBlock) & (Internal.Block);
    static CUT_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static BIRCH_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static ROSE_BUSH: (Internal.TallFlowerBlock) & (Internal.Block);
    static YELLOW_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static LECTERN: (Internal.LecternBlock) & (Internal.Block);
    static CRIMSON_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static DAMAGED_ANVIL: (Internal.ApothAnvilBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static POLISHED_DIORITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static HAY_BLOCK: (Internal.HayBlock) & (Internal.Block);
    static WARPED_HYPHAE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CHERRY_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static MANGROVE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static WEATHERED_CUT_COPPER_SLAB: (Internal.WeatheringCopperSlabBlock) & (Internal.Block);
    static LIME_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static TRIPWIRE_HOOK: (Internal.TripWireHookBlock) & (Internal.Block);
    static CLAY: (Internal.Block) & (Internal.Block);
    static SNOW: (Internal.SnowLayerBlock) & (Internal.Block);
    static WHEAT: (Internal.CropBlock) & (Internal.Block);
    static CYAN_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static WEATHERED_CUT_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static BROWN_MUSHROOM: (Internal.MushroomBlock) & (Internal.Block);
    static SHROOMLIGHT: (Internal.Block) & (Internal.Block);
    static CRIMSON_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static PRISMARINE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static POPPY: (Internal.FlowerBlock) & (Internal.Block);
    static STRUCTURE_VOID: (Internal.StructureVoidBlock) & (Internal.Block);
    static ORANGE_BED: (Internal.BedBlock) & (Internal.Block);
    static DEEPSLATE_COAL_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static PURPLE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static CUT_COPPER_SLAB: (Internal.WeatheringCopperSlabBlock) & (Internal.Block);
    static REDSTONE_BLOCK: (Internal.PoweredBlock) & (Internal.Block);
    static BLACK_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static WAXED_CUT_COPPER_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static GREEN_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static POTTED_AZALEA: (Internal.FlowerPotBlock) & (Internal.Block);
    static LIME_CONCRETE: (Internal.Block) & (Internal.Block);
    static BAMBOO_BLOCK: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PURPLE_WOOL: (Internal.Block) & (Internal.Block);
    static SOUL_FIRE: (Internal.SoulFireBlock) & (Internal.Block);
    static CHISELED_NETHER_BRICKS: (Internal.Block) & (Internal.Block);
    static CRACKED_POLISHED_BLACKSTONE_BRICKS: (Internal.Block) & (Internal.Block);
    static PINK_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static CARTOGRAPHY_TABLE: (Internal.CartographyTableBlock) & (Internal.Block);
    static BLACK_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static GREEN_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static CYAN_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static QUARTZ_BLOCK: (Internal.Block) & (Internal.Block);
    static BAMBOO_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static WHITE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static WAXED_WEATHERED_CUT_COPPER: (Internal.Block) & (Internal.Block);
    static WARPED_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static COMPOSTER: (Internal.ComposterBlock) & (Internal.Block);
    static DARK_OAK_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static ACACIA_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static PITCHER_PLANT: (Internal.DoublePlantBlock) & (Internal.Block);
    static CHISELED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static POTTED_PINK_TULIP: (Internal.FlowerPotBlock) & (Internal.Block);
    static LARGE_FERN: (Internal.DoublePlantBlock) & (Internal.Block);
    static TNT: (Internal.TntBlock) & (Internal.Block);
    static COBBLED_DEEPSLATE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static WARPED_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static SMOOTH_QUARTZ_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static LAVA_CAULDRON: (Internal.LavaCauldronBlock) & (Internal.Block);
    static SCULK_SHRIEKER: (Internal.SculkShriekerBlock) & (Internal.Block);
    static BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static CHISELED_DEEPSLATE: (Internal.Block) & (Internal.Block);
    static AZALEA: (Internal.AzaleaBlock) & (Internal.Block);
    static SMOOTH_STONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static JUNGLE_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static LIME_WOOL: (Internal.Block) & (Internal.Block);
    static LIME_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static GREEN_BED: (Internal.BedBlock) & (Internal.Block);
    static ACTIVATOR_RAIL: (Internal.PoweredRailBlock) & (Internal.Block);
    static SEA_PICKLE: (Internal.SeaPickleBlock) & (Internal.Block);
    static PINK_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static BLUE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static WEATHERED_CUT_COPPER_STAIRS: (Internal.WeatheringCopperStairBlock) & (Internal.Block);
    static CRACKED_STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static FURNACE: (Internal.FurnaceBlock) & (Internal.Block);
    static COBBLESTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MANGROVE_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static CHERRY_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BAMBOO_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static LIGHT_GRAY_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static MANGROVE_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static COBBLESTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static BEDROCK: (Internal.Block) & (Internal.Block);
    static BIRCH_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static PURPLE_BED: (Internal.BedBlock) & (Internal.Block);
    static LIME_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static RED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static GOLD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static SCULK: (Internal.SculkBlock) & (Internal.Block);
    static ACACIA_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static COBWEB: (Internal.WebBlock) & (Internal.Block);
    static CRIMSON_STEM: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PINK_BED: (Internal.BedBlock) & (Internal.Block);
    static STRIPPED_ACACIA_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static BEE_NEST: (Internal.BeehiveBlock) & (Internal.Block);
    static LAVA: (Internal.LiquidBlock) & (Internal.Block);
    static POTTED_WARPED_FUNGUS: (Internal.FlowerPotBlock) & (Internal.Block);
    static NETHER_WART_BLOCK: (Internal.Block) & (Internal.Block);
    static TORCHFLOWER: (Internal.FlowerBlock) & (Internal.Block);
    static ATTACHED_MELON_STEM: (Internal.AttachedStemBlock) & (Internal.Block);
    static DEEPSLATE_EMERALD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static BROWN_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static POTTED_DARK_OAK_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static POTTED_FERN: (Internal.FlowerPotBlock) & (Internal.Block);
    static PUMPKIN: (Internal.PumpkinBlock) & (Internal.Block);
    static EXPOSED_CUT_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static RED_MUSHROOM: (Internal.MushroomBlock) & (Internal.Block);
    static BROWN_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static PURPLE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static ORANGE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static RAW_IRON_BLOCK: (Internal.Block) & (Internal.Block);
    static WALL_TORCH: (Internal.WallTorchBlock) & (Internal.Block);
    static CACTUS: (Internal.ApothCactusBlock) & (Internal.Block);
    static FIRE: (Internal.FireBlock) & (Internal.Block);
    static SLIME_BLOCK: (Internal.SlimeBlock) & (Internal.Block);
    static CHIPPED_ANVIL: (Internal.ApothAnvilBlock) & (Internal.Block);
    static QUARTZ_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static LIGHT_BLUE_BED: (Internal.BedBlock) & (Internal.Block);
    static GREEN_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static JUNGLE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static SOUL_SAND: (Internal.SoulSandBlock) & (Internal.Block);
    static CUT_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MAGENTA_CONCRETE: (Internal.Block) & (Internal.Block);
    static GRANITE: (Internal.Block) & (Internal.Block);
    static LIGHT_GRAY_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static SMOOTH_BASALT: (Internal.Block) & (Internal.Block);
    static DEAD_BUSH: (Internal.DeadBushBlock) & (Internal.Block);
    static DARK_OAK_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static SOUL_CAMPFIRE: (Internal.CampfireBlock) & (Internal.Block);
    static MAGENTA_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static SPRUCE_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static CREEPER_HEAD: (Internal.SkullBlock) & (Internal.Block);
    static BROWN_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static YELLOW_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static DEAD_BUBBLE_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static BLUE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static JUNGLE_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static LIME_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static ACACIA_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static MOSSY_STONE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static TUBE_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static BROWN_BED: (Internal.BedBlock) & (Internal.Block);
    static PURPLE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static LIGHT_GRAY_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static BIG_DRIPLEAF_STEM: (Internal.BigDripleafStemBlock) & (Internal.Block);
    static LIME_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static WARPED_FUNGUS: (Internal.FungusBlock) & (Internal.Block);
    static WHITE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static DARK_OAK_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static STRIPPED_MANGROVE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CRYING_OBSIDIAN: (Internal.CryingObsidianBlock) & (Internal.Block);
    static WAXED_WEATHERED_CUT_COPPER_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MAGENTA_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static POTTED_TORCHFLOWER: (Internal.FlowerPotBlock) & (Internal.Block);
    static STONE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static IRON_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static TRAPPED_CHEST: (Internal.TrappedChestBlock) & (Internal.Block);
    static LIGHT_GRAY_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static OAK_PLANKS: (Internal.Block) & (Internal.Block);
    static FLOWERING_AZALEA_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static POTTED_FLOWERING_AZALEA: (Internal.FlowerPotBlock) & (Internal.Block);
    static POLISHED_ANDESITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BUBBLE_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static ANDESITE_WALL: (Internal.WallBlock) & (Internal.Block);
    static YELLOW_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static BIRCH_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static DEEPSLATE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static SMOOTH_RED_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static BLACKSTONE: (Internal.Block) & (Internal.Block);
    static LIGHT_GRAY_BED: (Internal.BedBlock) & (Internal.Block);
    static STRIPPED_OAK_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PINK_PETALS: (Internal.PinkPetalsBlock) & (Internal.Block);
    static DIORITE: (Internal.Block) & (Internal.Block);
    static SWEET_BERRY_BUSH: (Internal.SweetBerryBushBlock) & (Internal.Block);
    static DECORATED_POT: (Internal.DecoratedPotBlock) & (Internal.Block);
    static INFESTED_STONE_BRICKS: (Internal.InfestedBlock) & (Internal.Block);
    static POTTED_RED_TULIP: (Internal.FlowerPotBlock) & (Internal.Block);
    static RED_TULIP: (Internal.FlowerBlock) & (Internal.Block);
    static BAMBOO_PLANKS: (Internal.Block) & (Internal.Block);
    static BIRCH_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static JUNGLE_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static GREEN_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static BEACON: (Internal.BeaconBlock) & (Internal.Block);
    static DEEPSLATE_LAPIS_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static OAK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BIRCH_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static SANDSTONE: (Internal.Block) & (Internal.Block);
    static SNOW_BLOCK: (Internal.Block) & (Internal.Block);
    static BLACK_BED: (Internal.BedBlock) & (Internal.Block);
    static BROWN_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static POTTED_DEAD_BUSH: (Internal.FlowerPotBlock) & (Internal.Block);
    static STRIPPED_CHERRY_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static GRANITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DEEPSLATE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DARK_OAK_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static WHITE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static DEAD_HORN_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static BAMBOO_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static INFESTED_COBBLESTONE: (Internal.InfestedBlock) & (Internal.Block);
}
type Blocks_ = Blocks;
declare interface BlockStatePredicate extends Internal.ReplacementMatch, Internal.Predicate<Internal.BlockState> {
    fromString(s: string): this;
    ruleTestOf(o: any): Internal.RuleTest;
    asRuleTest(): Internal.RuleTest;
    getBlockIds(): Internal.Set<ResourceLocation>;
    not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
    check(targetStates: Internal.List_<Internal.OreConfiguration$TargetBlockState>): boolean;
    abstract test(arg0: Internal.BlockState_): boolean;
    getBlockStates(): Internal.Collection<Internal.BlockState>;
    getBlocks(): Internal.Collection<Internal.Block>;
    isEqual<T>(arg0: any): Internal.Predicate<T>;
    testBlock(block: Internal.Block_): boolean;
    of(o: BlockStatePredicate_): this;
    test(arg0: any): boolean;
    and(arg0: Internal.Predicate_<Internal.BlockState>): Internal.Predicate<Internal.BlockState>;
    abstract "test(net.minecraft.world.level.block.state.BlockState)"(arg0: Internal.BlockState_): boolean;
    or(arg0: Internal.Predicate_<Internal.BlockState>): Internal.Predicate<Internal.BlockState>;
    negate(): Internal.Predicate<Internal.BlockState>;
    "test(java.lang.Object)"(arg0: any): boolean;
    get blockIds(): Internal.Set<ResourceLocation>
    get blockStates(): Internal.Collection<Internal.BlockState>
    get blocks(): Internal.Collection<Internal.Block>
    readonly AIR_ID: (ResourceLocation) & (ResourceLocation);
}
type BlockStatePredicate_ = RegExp | "-" | `#${Special.BlockTag}` | BlockStatePredicate_[] | Internal.Block_ | Internal.BlockState_ | "*" | BlockStatePredicate | {not?: BlockStatePredicate_, or?: BlockStatePredicate_};
declare const BlockStatePredicate: BlockStatePredicate;
declare class KMath {
    constructor()
    getClass(): typeof any;
    static block(x: number, y: number, z: number): BlockPos;
    static deg(value: number): number;
    static v3d(x: number, y: number, z: number): Internal.Vector3d;
    static ceil(value: number): number;
    static map(value: number, min0: number, max0: number, min1: number, max1: number): number;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    static clamp(value: number, min: number, max: number): number;
    static v4f(x: number, y: number, z: number, w: number): Vec4f;
    static rad(value: number): number;
    static degreesDifference(current: number, target: number): number;
    static floor(value: number): number;
    static lerp(value: number, min: number, max: number): number;
    static v3f(x: number, y: number, z: number): Vec3f;
    toString(): string;
    notifyAll(): void;
    static rotateIfNecessary(current: number, target: number, max: number): number;
    static m4f(): Matrix4f;
    static v3(x: number, y: number, z: number): Vec3d;
    static quaternion(x: number, y: number, z: number, w: number): Quaternionf;
    hashCode(): number;
    static wrapDegrees(d: number): number;
    static m3f(): Matrix3f;
    wait(): void;
    static approachDegrees(current: number, target: number, speed: number): number;
    static clampedLerp(value: number, min: number, max: number): number;
    wait(arg0: number): void;
    static approach(current: number, target: number, speed: number): number;
    equals(arg0: any): boolean;
    static isPowerOfTwo(value: number): boolean;
    get class(): typeof any
    static readonly PI: (3.141592653589793) & (number);
    static readonly RADIANS_TO_DEGREES: (57.29577951308232) & (number);
    static readonly DEGREES_TO_RADIANS: (0.017453292519943295) & (number);
    static readonly E: (2.718281828459045) & (number);
}
type KMath_ = KMath;
declare class Items {
    constructor()
    getClass(): typeof any;
    toString(): string;
    static registerBlock(arg0: Internal.Block_, ...arg1: Internal.Block_[]): Internal.Item;
    notifyAll(): void;
    static "registerItem(net.minecraft.resources.ResourceKey,net.minecraft.world.item.Item)"(arg0: Internal.ResourceKey_<Internal.Item>, arg1: Internal.Item_): Internal.Item;
    static "registerItem(net.minecraft.resources.ResourceLocation,net.minecraft.world.item.Item)"(arg0: ResourceLocation_, arg1: Internal.Item_): Internal.Item;
    static registerBlock(arg0: Internal.Block_): Internal.Item;
    static "registerBlock(net.minecraft.world.level.block.Block,net.minecraft.world.item.Item)"(arg0: Internal.Block_, arg1: Internal.Item_): Internal.Item;
    static "registerBlock(net.minecraft.world.item.BlockItem)"(arg0: Internal.BlockItem_): Internal.Item;
    static registerItem(arg0: Internal.ResourceKey_<Internal.Item>, arg1: Internal.Item_): Internal.Item;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    hashCode(): number;
    static "registerBlock(net.minecraft.world.level.block.Block)"(arg0: Internal.Block_): Internal.Item;
    static registerItem(arg0: ResourceLocation_, arg1: Internal.Item_): Internal.Item;
    static "registerItem(java.lang.String,net.minecraft.world.item.Item)"(arg0: string, arg1: Internal.Item_): Internal.Item;
    wait(): void;
    static registerBlock(arg0: Internal.Block_, arg1: Internal.Item_): Internal.Item;
    wait(arg0: number): void;
    static registerItem(arg0: string, arg1: Internal.Item_): Internal.Item;
    equals(arg0: any): boolean;
    static registerBlock(arg0: Internal.BlockItem_): Internal.Item;
    static "registerBlock(net.minecraft.world.level.block.Block,net.minecraft.world.level.block.Block[])"(arg0: Internal.Block_, ...arg1: Internal.Block_[]): Internal.Item;
    get class(): typeof any
    static POWERED_RAIL: (Internal.BlockItem) & (Internal.Item);
    static GUARDIAN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static QUARTZ: (Internal.Item) & (Internal.Item);
    static TUBE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static TURTLE_EGG: (Internal.BlockItem) & (Internal.Item);
    static HANGING_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static CYAN_DYE: (Internal.DyeItem) & (Internal.Item);
    static WAXED_WEATHERED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CRACKED_DEEPSLATE_TILES: (Internal.BlockItem) & (Internal.Item);
    static OAK_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static BLAZE_ROD: (Internal.Item) & (Internal.Item);
    static GRASS_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static DRIED_KELP: (Internal.Item) & (Internal.Item);
    static TURTLE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GRAY_BANNER: (Internal.BannerItem) & (Internal.Item);
    static MAGENTA_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static WARPED_FUNGUS: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static BEETROOT: (Internal.Item) & (Internal.Item);
    static LIGHT_GRAY_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static GRAY_BED: (Internal.BedItem) & (Internal.Item);
    static MUDDY_MANGROVE_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static OAK_SIGN: (Internal.SignItem) & (Internal.Item);
    static ACACIA_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CHAIN: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_DYE: (Internal.DyeItem) & (Internal.Item);
    static STRIPPED_SPRUCE_LOG: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static PURPUR_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static DEBUG_STICK: (Internal.DebugStickItem) & (Internal.Item);
    static DUNE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static MUSIC_DISC_CAT: (Internal.RecordItem) & (Internal.Item);
    static GOLDEN_SWORD: (Internal.SwordItem) & (Internal.Item);
    static VERDANT_FROGLIGHT: (Internal.BlockItem) & (Internal.Item);
    static WARPED_NYLIUM: (Internal.BlockItem) & (Internal.Item);
    static TIPPED_ARROW: (Internal.TippedArrowItem) & (Internal.Item);
    static MILK_BUCKET: (Internal.MilkBucketItem) & (Internal.Item);
    static LAPIS_ORE: (Internal.BlockItem) & (Internal.Item);
    static WEEPING_VINES: (Internal.BlockItem) & (Internal.Item);
    static BLAZE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static TORCHFLOWER: (Internal.BlockItem) & (Internal.Item);
    static LODESTONE: (Internal.BlockItem) & (Internal.Item);
    static IRON_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static MANGROVE_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static INFESTED_STONE: (Internal.BlockItem) & (Internal.Item);
    static OAK_LOG: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_QUARTZ: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BRUSH: (Internal.BrushItem) & (Internal.Item);
    static END_PORTAL_FRAME: (Internal.BlockItem) & (Internal.Item);
    static AZURE_BLUET: (Internal.BlockItem) & (Internal.Item);
    static NETHER_QUARTZ_ORE: (Internal.BlockItem) & (Internal.Item);
    static COBBLESTONE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static SPRUCE_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static PUMPKIN: (Internal.BlockItem) & (Internal.Item);
    static COBWEB: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_WOOD: (Internal.BlockItem) & (Internal.Item);
    static BLUE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static CARROT: (Internal.ItemNameBlockItem) & (Internal.Item);
    static GOLDEN_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static BLACKSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static SUNFLOWER: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static COPPER_ORE: (Internal.BlockItem) & (Internal.Item);
    static CHEST: (Internal.BlockItem) & (Internal.Item);
    static DEAD_HORN_CORAL: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_GRANITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static SKELETON_SKULL: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static RESPAWN_ANCHOR: (Internal.BlockItem) & (Internal.Item);
    static BUCKET: (Internal.BucketItem) & (Internal.Item);
    static ZOMBIFIED_PIGLIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GLASS: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static FIRE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static LAVA_BUCKET: (Internal.BucketItem) & (Internal.Item);
    static ENDER_PEARL: (Internal.EnderpearlItem) & (Internal.Item);
    static DRIED_KELP_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static WILD_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static JUNGLE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BOOKSHELF: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static COBBLESTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static TWISTING_VINES: (Internal.BlockItem) & (Internal.Item);
    static GRINDSTONE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static PHANTOM_MEMBRANE: (Internal.Item) & (Internal.Item);
    static BRICK: (Internal.Item) & (Internal.Item);
    static ARCHER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static JUNGLE_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static TINTED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static OAK_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static GOLD_ORE: (Internal.BlockItem) & (Internal.Item);
    static FLOWERING_AZALEA: (Internal.BlockItem) & (Internal.Item);
    static POPPED_CHORUS_FRUIT: (Internal.Item) & (Internal.Item);
    static PRISMARINE_CRYSTALS: (Internal.Item) & (Internal.Item);
    static LAPIS_LAZULI: (Internal.Item) & (Internal.Item);
    static SQUID_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_INGOT: (Internal.Item) & (Internal.Item);
    static DEEPSLATE_EMERALD_ORE: (Internal.BlockItem) & (Internal.Item);
    static CHAINMAIL_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static NETHERITE_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static CHICKEN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BEEHIVE: (Internal.BlockItem) & (Internal.Item);
    static SPYGLASS: (Internal.SpyglassItem) & (Internal.Item);
    static NETHERITE_AXE: (Internal.AxeItem) & (Internal.Item);
    static ELDER_GUARDIAN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DARK_OAK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BLUE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static MULE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ORANGE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static FIREWORK_STAR: (Internal.FireworkStarItem) & (Internal.Item);
    static SPIDER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DARK_OAK_LOG: (Internal.BlockItem) & (Internal.Item);
    static SKULL_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static FROG_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DEAD_BRAIN_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static DIRT: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static WOODEN_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static GLOWSTONE_DUST: (Internal.Item) & (Internal.Item);
    static ITEM_FRAME: (Internal.ItemFrameItem) & (Internal.Item);
    static MUSIC_DISC_RELIC: (Internal.RecordItem) & (Internal.Item);
    static SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_FENCE: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_COBBLESTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static REDSTONE: (Internal.ItemNameBlockItem) & (Internal.Item);
    static CARROT_ON_A_STICK: Internal.Item;
    static SOUL_TORCH: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static LIME_CARPET: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static SUGAR_CANE: (Internal.PlaceboUtil$1) & (Internal.Item);
    static COMMAND_BLOCK_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static SMOOTH_SANDSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CHEST_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static DEAD_BUBBLE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static SCUTE: (Internal.Item) & (Internal.Item);
    static FEATHER: (Internal.Item) & (Internal.Item);
    static JUNGLE_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static CUT_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_QUARTZ_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static WHITE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static COPPER_INGOT: (Internal.Item) & (Internal.Item);
    static SWEET_BERRIES: (Internal.ItemNameBlockItem) & (Internal.Item);
    static GREEN_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static BUBBLE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static BELL: (Internal.BlockItem) & (Internal.Item);
    static WAXED_EXPOSED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static WHITE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static PITCHER_POD: (Internal.ItemNameBlockItem) & (Internal.Item);
    static BLACK_DYE: (Internal.DyeItem) & (Internal.Item);
    static WHITE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static DETECTOR_RAIL: (Internal.BlockItem) & (Internal.Item);
    static TIDE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static LIME_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static PIGLIN_HEAD: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static CHORUS_FLOWER: (Internal.BlockItem) & (Internal.Item);
    static WARPED_HYPHAE: (Internal.BlockItem) & (Internal.Item);
    static WARDEN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CHISELED_NETHER_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static SNOWBALL: (Internal.SnowballItem) & (Internal.Item);
    static LANTERN: (Internal.BlockItem) & (Internal.Item);
    static CYAN_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static MAP: (Internal.EmptyMapItem) & (Internal.Item);
    static WHITE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_COPPER_ORE: (Internal.BlockItem) & (Internal.Item);
    static CUT_STANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BLACK_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static BLAST_FURNACE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static QUARTZ_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static CYAN_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static IRON_INGOT: (Internal.Item) & (Internal.Item);
    static PINK_BANNER: (Internal.BannerItem) & (Internal.Item);
    static MAGMA_CUBE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static WHITE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_RED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static TRADER_LLAMA_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static TNT: (Internal.BlockItem) & (Internal.Item);
    static OAK_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static CHERRY_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static GREEN_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_FENCE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_BANNER: (Internal.BannerItem) & (Internal.Item);
    static ROTTEN_FLESH: (Internal.Item) & (Internal.Item);
    static RIB_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WRITTEN_BOOK: (Internal.WrittenBookItem) & (Internal.Item);
    static DISC_FRAGMENT_5: (Internal.DiscFragmentItem) & (Internal.Item);
    static SNIFFER_EGG: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_DYE: (Internal.DyeItem) & (Internal.Item);
    static CLAY: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static BRAIN_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static SPAWNER: (Internal.ApothSpawnerItem) & (Internal.Item);
    static LIME_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_SCRAP: (Internal.Item) & (Internal.Item);
    static NETHER_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static STONE: (Internal.BlockItem) & (Internal.Item);
    static WITHER_SKELETON_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static AMETHYST_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static HOGLIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ZOGLIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static LIME_DYE: (Internal.DyeItem) & (Internal.Item);
    static IRON_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static MAGENTA_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static PETRIFIED_OAK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PRISMARINE_SHARD: (Internal.Item) & (Internal.Item);
    static NETHER_GOLD_ORE: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BASALT: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static CHERRY_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static SANDSTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static ENDER_DRAGON_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static STRIPPED_OAK_LOG: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_GRANITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_GOLD_ORE: (Internal.BlockItem) & (Internal.Item);
    static OBSERVER: (Internal.BlockItem) & (Internal.Item);
    static GRAY_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_SWORD: (Internal.SwordItem) & (Internal.Item);
    static FOX_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CHERRY_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_WOOL: (Internal.BlockItem) & (Internal.Item);
    static CALCITE: (Internal.BlockItem) & (Internal.Item);
    static PUMPKIN_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static FERMENTED_SPIDER_EYE: (Internal.Item) & (Internal.Item);
    static HEART_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static PURPLE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static MUTTON: (Internal.Item) & (Internal.Item);
    static PURPLE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static GOLDEN_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static ZOMBIE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static MUSIC_DISC_PIGSTEP: (Internal.RecordItem) & (Internal.Item);
    static REDSTONE_TORCH: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static LEATHER_LEGGINGS: (Internal.DyeableArmorItem) & (Internal.Item);
    static PIGLIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static RED_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static COD: (Internal.Item) & (Internal.Item);
    static MUSIC_DISC_11: (Internal.RecordItem) & (Internal.Item);
    static AZALEA_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static NETHER_WART: (Internal.ItemNameBlockItem) & (Internal.Item);
    static NAME_TAG: (Internal.NameTagItem) & (Internal.Item);
    static CYAN_CARPET: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_COBBLESTONE: (Internal.BlockItem) & (Internal.Item);
    static NETHER_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static JACK_O_LANTERN: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static WARPED_SLAB: (Internal.BlockItem) & (Internal.Item);
    static FURNACE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RED_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_CARPET: (Internal.BlockItem) & (Internal.Item);
    static POWDER_SNOW_BUCKET: (Internal.SolidBucketItem) & (Internal.Item);
    static BUBBLE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static WHITE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static BOOK: (Internal.BookItem) & (Internal.Item);
    static RED_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static DARK_PRISMARINE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static CRIMSON_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_BED: (Internal.BedItem) & (Internal.Item);
    static EMERALD_ORE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static CRACKED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static COD_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DIAMOND: (Internal.Item) & (Internal.Item);
    static AZALEA: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_BOAT: (Internal.BoatItem) & (Internal.Item);
    static SPRUCE_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static MELON_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static WEATHERED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CANDLE: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static PILLAGER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static MUSIC_DISC_13: (Internal.RecordItem) & (Internal.Item);
    static LIGHT_GRAY_CARPET: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_WOOD: (Internal.BlockItem) & (Internal.Item);
    static FLOWER_POT: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_WOOD: (Internal.BlockItem) & (Internal.Item);
    static WARPED_FENCE: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_POLISHED_BLACKSTONE: (Internal.BlockItem) & (Internal.Item);
    static SEA_PICKLE: (Internal.BlockItem) & (Internal.Item);
    static LARGE_FERN: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static AMETHYST_SHARD: (Internal.Item) & (Internal.Item);
    static CHICKEN: (Internal.Item) & (Internal.Item);
    static GRAY_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static TOTEM_OF_UNDYING: (Internal.Item) & (Internal.Item);
    static STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static GREEN_BED: (Internal.BedItem) & (Internal.Item);
    static DROPPER: (Internal.BlockItem) & (Internal.Item);
    static LIME_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static KNOWLEDGE_BOOK: (Internal.KnowledgeBookItem) & (Internal.Item);
    static LOOM: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static FISHING_ROD: (Internal.FishingRodItem) & (Internal.Item);
    static BROWN_DYE: (Internal.DyeItem) & (Internal.Item);
    static MEDIUM_AMETHYST_BUD: (Internal.BlockItem) & (Internal.Item);
    static ROOTED_DIRT: (Internal.BlockItem) & (Internal.Item);
    static SHAPER_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static WARPED_STEM: (Internal.BlockItem) & (Internal.Item);
    static SHEAF_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static RED_SAND: (Internal.BlockItem) & (Internal.Item);
    static END_STONE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SHEARS: (Internal.ShearsItem) & (Internal.Item);
    static PANDA_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static POTATO: (Internal.ItemNameBlockItem) & (Internal.Item);
    static LAPIS_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static COMPOSTER: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static TROPICAL_FISH: (Internal.Item) & (Internal.Item);
    static POTION: (Internal.PotionItem) & (Internal.Item);
    static MANGROVE_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static JIGSAW: (Internal.GameMasterBlockItem) & (Internal.Item);
    static PRISMARINE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static TROPICAL_FISH_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static WARPED_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static RED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static BROWN_CARPET: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static LIGHT_BLUE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static LEATHER_CHESTPLATE: (Internal.DyeableArmorItem) & (Internal.Item);
    static RED_BED: (Internal.BedItem) & (Internal.Item);
    static STONE_HOE: (Internal.HoeItem) & (Internal.Item);
    static JUNGLE_LOG: (Internal.BlockItem) & (Internal.Item);
    static GLOW_SQUID_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static EYE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static BROWN_WOOL: (Internal.BlockItem) & (Internal.Item);
    static PUFFERFISH_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static CHAINMAIL_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static GREEN_WOOL: (Internal.BlockItem) & (Internal.Item);
    static BREAD: (Internal.Item) & (Internal.Item);
    static COOKED_CHICKEN: (Internal.Item) & (Internal.Item);
    static BIRCH_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_SLAB: (Internal.BlockItem) & (Internal.Item);
    static GOLD_NUGGET: (Internal.Item) & (Internal.Item);
    static PHANTOM_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static QUARTZ_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WHITE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static WAXED_WEATHERED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static BLUE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static WHEAT_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static DEEPSLATE_TILES: (Internal.BlockItem) & (Internal.Item);
    static PORKCHOP: (Internal.Item) & (Internal.Item);
    static SCAFFOLDING: (Internal.ScaffoldingBlockItem) & (Internal.Item);
    static END_ROD: (Internal.BlockItem) & (Internal.Item);
    static ANDESITE: (Internal.BlockItem) & (Internal.Item);
    static PACKED_MUD: (Internal.BlockItem) & (Internal.Item);
    static STONE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static REINFORCED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static LILY_OF_THE_VALLEY: (Internal.BlockItem) & (Internal.Item);
    static VILLAGER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static STONE_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static PARROT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static WHEAT: (Internal.Item) & (Internal.Item);
    static JUNGLE_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static BROWN_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DEEPSLATE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_AXE: (Internal.AxeItem) & (Internal.Item);
    static WAXED_WEATHERED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WARPED_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static NETHERRACK: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static GRAY_WOOL: (Internal.BlockItem) & (Internal.Item);
    static COPPER_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static WEATHERED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static PURPUR_PILLAR: (Internal.BlockItem) & (Internal.Item);
    static STONE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static RED_NETHER_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CAKE: (Internal.BlockItem) & (Internal.Item);
    static COBBLED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_FENCE: (Internal.BlockItem) & (Internal.Item);
    static FARMLAND: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static PUMPKIN_PIE: (Internal.Item) & (Internal.Item);
    static SHULKER_SHELL: (Internal.Item) & (Internal.Item);
    static OAK_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static RABBIT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static LIGHT_WEIGHTED_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static APPLE: (Internal.Item) & (Internal.Item);
    static DIAMOND_HORSE_ARMOR: (Internal.HorseArmorItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WARPED_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_LOG: (Internal.BlockItem) & (Internal.Item);
    static ELYTRA: (Internal.ElytraItem) & (Internal.Item);
    static WARPED_SIGN: (Internal.SignItem) & (Internal.Item);
    static GREEN_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static BEE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static PINK_DYE: (Internal.DyeItem) & (Internal.Item);
    static PLAYER_HEAD: (Internal.PlayerHeadItem) & (Internal.Item);
    static GLOW_LICHEN: (Internal.BlockItem) & (Internal.Item);
    static STONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static ROSE_BUSH: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static GLOW_ITEM_FRAME: (Internal.ItemFrameItem) & (Internal.Item);
    static WHITE_TULIP: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static OBSIDIAN: (Internal.BlockItem) & (Internal.Item);
    static BLADE_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static BROWN_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static EGG: (Internal.EggItem) & (Internal.Item);
    static WITCH_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static OXIDIZED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WAXED_EXPOSED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static OCELOT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static HORN_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static NETHER_SPROUTS: (Internal.BlockItem) & (Internal.Item);
    static MUD_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static DEAD_BRAIN_CORAL: (Internal.BlockItem) & (Internal.Item);
    static TALL_GRASS: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BLACK_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static SPIDER_EYE: (Internal.Item) & (Internal.Item);
    static FILLED_MAP: (Internal.MapItem) & (Internal.Item);
    static MUD_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static AXOLOTL_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static ZOMBIE_HORSE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DARK_PRISMARINE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_SIGN: (Internal.SignItem) & (Internal.Item);
    static STRIPPED_JUNGLE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static MUSHROOM_STEM: (Internal.BlockItem) & (Internal.Item);
    static LILAC: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BAMBOO_RAFT: (Internal.BoatItem) & (Internal.Item);
    static SUSPICIOUS_STEW: (Internal.SuspiciousStewItem) & (Internal.Item);
    static SUSPICIOUS_GRAVEL: (Internal.BlockItem) & (Internal.Item);
    static GOLDEN_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static IRON_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static WAXED_OXIDIZED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static CRACKED_DEEPSLATE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static SHULKER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SENTRY_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static LIGHT_GRAY_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static MELON_SLICE: (Internal.Item) & (Internal.Item);
    static HONEYCOMB_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DIORITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static PEARLESCENT_FROGLIGHT: (Internal.BlockItem) & (Internal.Item);
    static GOLDEN_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static ANCIENT_DEBRIS: (Internal.BlockItem) & (Internal.Item);
    static HOPPER_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static MAGMA_CREAM: (Internal.Item) & (Internal.Item);
    static ZOMBIE_HEAD: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static POLISHED_GRANITE: (Internal.BlockItem) & (Internal.Item);
    static PINK_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static HONEYCOMB: (Internal.HoneycombItem) & (Internal.Item);
    static NOTE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static RED_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static FURNACE_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static DRAGON_BREATH: (Internal.Item) & (Internal.Item);
    static CYAN_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static CHORUS_PLANT: (Internal.BlockItem) & (Internal.Item);
    static WAXED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static TURTLE_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static DARK_OAK_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static COAL_ORE: (Internal.BlockItem) & (Internal.Item);
    static COAL: (Internal.Item) & (Internal.Item);
    static COAST_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static GRAY_CARPET: (Internal.BlockItem) & (Internal.Item);
    static OXIDIZED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static DANGER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static GREEN_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static BARREL: (Internal.BlockItem) & (Internal.Item);
    static RED_SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WHITE_DYE: (Internal.DyeItem) & (Internal.Item);
    static ORANGE_DYE: (Internal.DyeItem) & (Internal.Item);
    static ENCHANTED_BOOK: (Internal.EnchantedBookItem) & (Internal.Item);
    static SOUL_SOIL: (Internal.BlockItem) & (Internal.Item);
    static IRON_NUGGET: (Internal.Item) & (Internal.Item);
    static ENDERMITE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static NETHERITE_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static LEVER: (Internal.BlockItem) & (Internal.Item);
    static COOKED_SALMON: (Internal.Item) & (Internal.Item);
    static CAULDRON: (Internal.Items$1) & (Internal.Item);
    static ALLIUM: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static EXPLORER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static POISONOUS_POTATO: (Internal.Item) & (Internal.Item);
    static FLOWER_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static SMOOTH_STONE: (Internal.BlockItem) & (Internal.Item);
    static WHITE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static SNORT_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static BROWN_MUSHROOM_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static GHAST_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static NETHER_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static IRON_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static AXOLOTL_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ORANGE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static SEA_LANTERN: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_RED_SANDSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static STONE_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static LIME_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static SHIELD: (Internal.ShieldItem) & (Internal.Item);
    static DIORITE_WALL: (Internal.BlockItem) & (Internal.Item);
    static STONE_SWORD: (Internal.SwordItem) & (Internal.Item);
    static GOLDEN_HOE: (Internal.HoeItem) & (Internal.Item);
    static BLACK_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_ORE: (Internal.BlockItem) & (Internal.Item);
    static BLACK_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_DYE: (Internal.DyeItem) & (Internal.Item);
    static REPEATER: (Internal.BlockItem) & (Internal.Item);
    static SPECTRAL_ARROW: (Internal.SpectralArrowItem) & (Internal.Item);
    static CHERRY_SLAB: (Internal.BlockItem) & (Internal.Item);
    static LEAD: (Internal.LeadItem) & (Internal.Item);
    static WHITE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static DEAD_TUBE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static BROWN_BANNER: (Internal.BannerItem) & (Internal.Item);
    static WAXED_OXIDIZED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static PINK_WOOL: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_BOAT: (Internal.BoatItem) & (Internal.Item);
    static BLACK_CARPET: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static BREWING_STAND: (Internal.BlockItem) & (Internal.Item);
    static BIG_DRIPLEAF: (Internal.Items$1) & (Internal.Item);
    static CARVED_PUMPKIN: (Internal.BlockItem) & (Internal.Item);
    static OAK_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static PINK_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DIORITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_BOAT: (Internal.BoatItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_WOOD: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_QUARTZ_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static END_STONE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_BED: (Internal.BedItem) & (Internal.Item);
    static LIGHT: (Internal.BlockItem) & (Internal.Item);
    static BONE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static DRIPSTONE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static WET_SPONGE: (Internal.BlockItem) & (Internal.Item);
    static FLINT: (Internal.Item) & (Internal.Item);
    static INFESTED_CHISELED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static GRAY_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_COBBLESTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static HUSK_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static PINK_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_ICE: (Internal.BlockItem) & (Internal.Item);
    static JUKEBOX: (Internal.BlockItem) & (Internal.Item);
    static FIRE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static FIRE_CHARGE: (Internal.FireChargeItem) & (Internal.Item);
    static COOKED_MUTTON: (Internal.Item) & (Internal.Item);
    static BASALT: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static PIG_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static MUSHROOM_STEW: (Internal.BowlFoodItem) & (Internal.Item);
    static PURPLE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static HOWL_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static SMALL_AMETHYST_BUD: (Internal.BlockItem) & (Internal.Item);
    static DEAD_HORN_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static WEATHERED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static RED_WOOL: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_PROPAGULE: (Internal.BlockItem) & (Internal.Item);
    static PURPUR_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static PAPER: (Internal.Item) & (Internal.Item);
    static IRON_HOE: (Internal.HoeItem) & (Internal.Item);
    static MAGENTA_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static STICKY_PISTON: (Internal.BlockItem) & (Internal.Item);
    static COMPASS: (Internal.CompassItem) & (Internal.Item);
    static RED_SANDSTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static DARK_PRISMARINE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_FENCE: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static CLAY_BALL: (Internal.Item) & (Internal.Item);
    static CYAN_WOOL: (Internal.BlockItem) & (Internal.Item);
    static STONECUTTER: (Internal.BlockItem) & (Internal.Item);
    static MINECART: (Internal.MinecartItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static RED_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static GREEN_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static SHELTER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static AIR: (Internal.AirItem) & (Internal.Item);
    static SEAGRASS: (Internal.BlockItem) & (Internal.Item);
    static GLOWSTONE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_BED: (Internal.BedItem) & (Internal.Item);
    static ANVIL: (Internal.ApothAnvilItem) & (Internal.Item);
    static YELLOW_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static RAW_COPPER_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DIORITE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_SIGN: (Internal.SignItem) & (Internal.Item);
    static MAGENTA_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static NETHER_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static WITHER_SKELETON_SKULL: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static DONKEY_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static STONE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WARPED_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static WAXED_COPPER_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static ENCHANTED_GOLDEN_APPLE: (Internal.EnchantedGoldenAppleItem) & (Internal.Item);
    static MANGROVE_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static MUD: (Internal.BlockItem) & (Internal.Item);
    static OAK_FENCE: (Internal.BlockItem) & (Internal.Item);
    static GOAT_HORN: (Internal.InstrumentItem) & (Internal.Item);
    static HOST_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static CAVE_SPIDER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static QUARTZ_PILLAR: (Internal.BlockItem) & (Internal.Item);
    static DEAD_FIRE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static SUGAR: (Internal.Item) & (Internal.Item);
    static WAXED_EXPOSED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static BROWN_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static SCULK_VEIN: (Internal.BlockItem) & (Internal.Item);
    static FLETCHING_TABLE: (Internal.PlaceboUtil$1) & (Internal.Item);
    static INFESTED_MOSSY_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static WARPED_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static BROWN_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static PINK_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static STONE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PLENTY_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static RED_CARPET: (Internal.BlockItem) & (Internal.Item);
    static CLOCK: (Internal.Item) & (Internal.Item);
    static GRAY_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static EMERALD: (Internal.Item) & (Internal.Item);
    static DEEPSLATE_DIAMOND_ORE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BROWN_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static KELP: (Internal.BlockItem) & (Internal.Item);
    static WITHER_ROSE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static TADPOLE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static OAK_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static SNOUT_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static SPRUCE_FENCE: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static CRAFTING_TABLE: (Internal.BlockItem) & (Internal.Item);
    static BAKED_POTATO: (Internal.Item) & (Internal.Item);
    static MANGROVE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CYAN_BED: (Internal.BedItem) & (Internal.Item);
    static CHISELED_BOOKSHELF: (Internal.BlockItem) & (Internal.Item);
    static NAUTILUS_SHELL: (Internal.Item) & (Internal.Item);
    static SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static STICK: (Internal.Item) & (Internal.Item);
    static HEAVY_WEIGHTED_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static COARSE_DIRT: (Internal.BlockItem) & (Internal.Item);
    static QUARTZ_SLAB: (Internal.BlockItem) & (Internal.Item);
    static SPIRE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static COBBLED_DEEPSLATE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static LIGHTNING_ROD: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_FENCE: (Internal.BlockItem) & (Internal.Item);
    static POLAR_BEAR_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ACACIA_LOG: (Internal.BlockItem) & (Internal.Item);
    static MOJANG_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static DEEPSLATE_REDSTONE_ORE: (Internal.BlockItem) & (Internal.Item);
    static INFESTED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static ENCHANTING_TABLE: (Internal.PlaceboUtil$1) & (Internal.Item);
    static POLISHED_ANDESITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static PINK_CARPET: (Internal.BlockItem) & (Internal.Item);
    static BREWER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static DIORITE: (Internal.BlockItem) & (Internal.Item);
    static RED_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static GRAY_DYE: (Internal.DyeItem) & (Internal.Item);
    static LIGHT_GRAY_BED: (Internal.BedItem) & (Internal.Item);
    static BAMBOO_SIGN: (Internal.SignItem) & (Internal.Item);
    static IRON_ORE: (Internal.BlockItem) & (Internal.Item);
    static SCULK_SENSOR: (Internal.BlockItem) & (Internal.Item);
    static BUNDLE: (Internal.BundleItem) & (Internal.Item);
    static STRING: (Internal.ItemNameBlockItem) & (Internal.Item);
    static STRIPPED_JUNGLE_LOG: (Internal.BlockItem) & (Internal.Item);
    static END_CRYSTAL: (Internal.EndCrystalItem) & (Internal.Item);
    static LEATHER_BOOTS: (Internal.DyeableArmorItem) & (Internal.Item);
    static SLIME_BALL: (Internal.Item) & (Internal.Item);
    static ORANGE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_IRON_ORE: (Internal.BlockItem) & (Internal.Item);
    static BOW: (Internal.BowItem) & (Internal.Item);
    static ORANGE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_ORCHID: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static LLAMA_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CAMPFIRE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static EXPOSED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BUBBLE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static RED_MUSHROOM: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BLACK_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static SAND: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_HOE: (Internal.HoeItem) & (Internal.Item);
    static RED_MUSHROOM_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static MYCELIUM: (Internal.BlockItem) & (Internal.Item);
    static PINK_TULIP: (Internal.BlockItem) & (Internal.Item);
    static PINK_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static GOAT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static INFESTED_CRACKED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static RABBIT: (Internal.Item) & (Internal.Item);
    static PRISMARINE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static REDSTONE_LAMP: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static TUBE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static MANGROVE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static LIME_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static STRIPPED_ACACIA_WOOD: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static ARMOR_STAND: (Internal.ArmorStandItem) & (Internal.Item);
    static CHERRY_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static BROWN_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static STONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static MANGROVE_BOAT: (Internal.BoatItem) & (Internal.Item);
    static PRISMARINE_WALL: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_BANNER: (Internal.BannerItem) & (Internal.Item);
    static RED_NETHER_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WAXED_OXIDIZED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static IRON_GOLEM_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CRIMSON_NYLIUM: (Internal.BlockItem) & (Internal.Item);
    static FIRE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static EXPERIENCE_BOTTLE: (Internal.ExperienceBottleItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static RED_NETHER_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static BLACK_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static SMITHING_TABLE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_SIGN: (Internal.SignItem) & (Internal.Item);
    static YELLOW_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static VEX_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static PIGLIN_BRUTE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GRAY_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static COBBLESTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BLAZE_POWDER: (Internal.Item) & (Internal.Item);
    static MUSIC_DISC_MALL: (Internal.RecordItem) & (Internal.Item);
    static LARGE_AMETHYST_BUD: (Internal.BlockItem) & (Internal.Item);
    static BRICKS: (Internal.BlockItem) & (Internal.Item);
    static BUDDING_AMETHYST: (Internal.BlockItem) & (Internal.Item);
    static RABBIT_FOOT: (Internal.Item) & (Internal.Item);
    static BAMBOO_MOSAIC: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_COBBLESTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SKULL_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static ACACIA_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static BURN_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static COMMAND_BLOCK: (Internal.GameMasterBlockItem) & (Internal.Item);
    static BEACON: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_SPRUCE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static OAK_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_CRIMSON_STEM: (Internal.BlockItem) & (Internal.Item);
    static GLOW_INK_SAC: (Internal.GlowInkSacItem) & (Internal.Item);
    static CYAN_BANNER: (Internal.BannerItem) & (Internal.Item);
    static CAMEL_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static POLISHED_BLACKSTONE: (Internal.BlockItem) & (Internal.Item);
    static GRASS: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_RED_SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BROWN_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_CHIRP: (Internal.RecordItem) & (Internal.Item);
    static MUSIC_DISC_FAR: (Internal.RecordItem) & (Internal.Item);
    static RED_SANDSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static COBBLED_DEEPSLATE_WALL: (Internal.BlockItem) & (Internal.Item);
    static BLUE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static WOODEN_AXE: (Internal.AxeItem) & (Internal.Item);
    static SPORE_BLOSSOM: (Internal.BlockItem) & (Internal.Item);
    static DEAD_BRAIN_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static DEEPSLATE_TILE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CROSSBOW: (Internal.CrossbowItem) & (Internal.Item);
    static BAMBOO_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static HORN_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static ORANGE_TULIP: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static GREEN_CARPET: (Internal.BlockItem) & (Internal.Item);
    static SILENCE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static OXIDIZED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static RABBIT_HIDE: (Internal.Item) & (Internal.Item);
    static COOKED_COD: (Internal.Item) & (Internal.Item);
    static BLACK_BED: (Internal.BedItem) & (Internal.Item);
    static PUFFERFISH: (Internal.Item) & (Internal.Item);
    static ENDER_EYE: (Internal.EnderEyeItem) & (Internal.Item);
    static INFESTED_COBBLESTONE: (Internal.BlockItem) & (Internal.Item);
    static GOLD_INGOT: (Internal.Item) & (Internal.Item);
    static VEX_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static STRIPPED_MANGROVE_LOG: (Internal.BlockItem) & (Internal.Item);
    static ICE: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_MOSAIC_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BLACK_BANNER: (Internal.BannerItem) & (Internal.Item);
    static OAK_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static LIME_BANNER: (Internal.BannerItem) & (Internal.Item);
    static PINK_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static SMALL_DRIPLEAF: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static LILY_PAD: (Internal.PlaceOnWaterBlockItem) & (Internal.Item);
    static CREEPER_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static GLOW_BERRIES: (Internal.ItemNameBlockItem) & (Internal.Item);
    static HOPPER: (Internal.BlockItem) & (Internal.Item);
    static PUFFERFISH_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static PURPLE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static HAY_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static HEART_OF_THE_SEA: (Internal.Item) & (Internal.Item);
    static WARD_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static MOSSY_STONE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static EXPOSED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WARPED_WART_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_SWORD: (Internal.SwordItem) & (Internal.Item);
    static SHEEP_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ANGLER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static PODZOL: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_HOE: (Internal.HoeItem) & (Internal.Item);
    static GRAY_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_WARPED_STEM: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_SIGN: (Internal.SignItem) & (Internal.Item);
    static RABBIT_STEW: (Internal.BowlFoodItem) & (Internal.Item);
    static DEAD_TUBE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static DECORATED_POT: (Internal.BlockItem) & (Internal.Item);
    static OAK_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static CHAINMAIL_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static CRACKED_POLISHED_BLACKSTONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static LIME_BED: (Internal.BedItem) & (Internal.Item);
    static TUFF: (Internal.BlockItem) & (Internal.Item);
    static GRAVEL: (Internal.BlockItem) & (Internal.Item);
    static BARRIER: (Internal.BlockItem) & (Internal.Item);
    static DRAGON_HEAD: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static MUSIC_DISC_MELLOHI: (Internal.RecordItem) & (Internal.Item);
    static IRON_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BAT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static VINDICATOR_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SMOOTH_BASALT: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static DEAD_HORN_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static DROWNED_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static NETHER_STAR: (Internal.SimpleFoiledItem) & (Internal.Item);
    static CRIMSON_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static FLINT_AND_STEEL: (Internal.FlintAndSteelItem) & (Internal.Item);
    static MAGENTA_BED: (Internal.BedItem) & (Internal.Item);
    static BONE: (Internal.Item) & (Internal.Item);
    static BROWN_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static END_STONE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CALIBRATED_SCULK_SENSOR: (Internal.BlockItem) & (Internal.Item);
    static COMPARATOR: (Internal.BlockItem) & (Internal.Item);
    static LEATHER_HORSE_ARMOR: (Internal.DyeableHorseArmorItem) & (Internal.Item);
    static STRIPPED_BAMBOO_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DIORITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MUD_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static MOSS_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CREEPER_HEAD: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static JUNGLE_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BLACK_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static COOKIE: (Internal.Item) & (Internal.Item);
    static GRANITE: (Internal.BlockItem) & (Internal.Item);
    static LEATHER: (Internal.Item) & (Internal.Item);
    static SALMON_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static DANDELION: (Internal.BlockItem) & (Internal.Item);
    static WARPED_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static PRISMARINE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RED_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static IRON_HORSE_ARMOR: (Internal.HorseArmorItem) & (Internal.Item);
    static IRON_SWORD: (Internal.SwordItem) & (Internal.Item);
    static BONE_MEAL: (Internal.BoneMealItem) & (Internal.Item);
    static GRAY_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static DEAD_FIRE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POINTED_DRIPSTONE: (Internal.BlockItem) & (Internal.Item);
    static PURPUR_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static ALLAY_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static COW_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ARMS_UP_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static BLUE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_WARD: (Internal.RecordItem) & (Internal.Item);
    static PINK_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static BLUE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static ANDESITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CHORUS_FRUIT: (Internal.ChorusFruitItem) & (Internal.Item);
    static VINE: (Internal.BlockItem) & (Internal.Item);
    static COAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DEEPSLATE_WALL: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_OTHERSIDE: (Internal.RecordItem) & (Internal.Item);
    static MOSSY_STONE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SNOW_GOLEM_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SCULK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_ANDESITE: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_SIGN: (Internal.SignItem) & (Internal.Item);
    static COCOA_BEANS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static CYAN_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_DYE: (Internal.DyeItem) & (Internal.Item);
    static CYAN_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static BLACKSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static GLOBE_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static SPRUCE_LOG: (Internal.BlockItem) & (Internal.Item);
    static TUBE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static EXPOSED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static GREEN_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static CONDUIT: (Internal.BlockItem) & (Internal.Item);
    static GLISTERING_MELON_SLICE: (Internal.Item) & (Internal.Item);
    static RAVAGER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SKELETON_HORSE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BRAIN_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO: (Internal.PlaceboUtil$1) & (Internal.Item);
    static COOKED_PORKCHOP: (Internal.Item) & (Internal.Item);
    static GOLDEN_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static CUT_RED_SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static BAMBOO_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_STONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static IRON_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static SMOKER: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_BIRCH_WOOD: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_BOAT: (Internal.BoatItem) & (Internal.Item);
    static MOSS_CARPET: (Internal.BlockItem) & (Internal.Item);
    static FIREWORK_ROCKET: (Internal.FireworkRocketItem) & (Internal.Item);
    static OCHRE_FROGLIGHT: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static NETHER_BRICK_FENCE: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_RED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static TADPOLE_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static DRAGON_EGG: (Internal.BlockItem) & (Internal.Item);
    static PRIZE_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static DARK_OAK_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static COOKED_RABBIT: (Internal.Item) & (Internal.Item);
    static CHERRY_BOAT: (Internal.BoatItem) & (Internal.Item);
    static END_STONE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static GREEN_DYE: (Internal.DyeItem) & (Internal.Item);
    static MUSIC_DISC_WAIT: (Internal.RecordItem) & (Internal.Item);
    static RED_NETHER_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static PITCHER_PLANT: (Internal.BlockItem) & (Internal.Item);
    static LIME_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static PRISMARINE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static AMETHYST_CLUSTER: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_COAL_ORE: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_MANGROVE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static STONE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static RED_DYE: (Internal.DyeItem) & (Internal.Item);
    static SPLASH_POTION: (Internal.SplashPotionItem) & (Internal.Item);
    static PURPLE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static STRIDER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static OXEYE_DAISY: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PINK_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_CHERRY_WOOD: (Internal.BlockItem) & (Internal.Item);
    static REPEATING_COMMAND_BLOCK: (Internal.GameMasterBlockItem) & (Internal.Item);
    static CHERRY_SIGN: (Internal.SignItem) & (Internal.Item);
    static CRYING_OBSIDIAN: (Internal.BlockItem) & (Internal.Item);
    static RAISER_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static CREEPER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BAMBOO_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static SCULK_SHRIEKER: (Internal.BlockItem) & (Internal.Item);
    static GOLDEN_HORSE_ARMOR: (Internal.HorseArmorItem) & (Internal.Item);
    static POLISHED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_WOOL: (Internal.BlockItem) & (Internal.Item);
    static PINK_PETALS: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_DYE: (Internal.DyeItem) & (Internal.Item);
    static CRIMSON_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static PURPLE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static WITHER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BEETROOT_SOUP: (Internal.BowlFoodItem) & (Internal.Item);
    static CRIMSON_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static BLACKSTONE: (Internal.BlockItem) & (Internal.Item);
    static FLOWERING_AZALEA_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static OAK_BOAT: (Internal.BoatItem) & (Internal.Item);
    static POLISHED_ANDESITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BROWN_BED: (Internal.BedItem) & (Internal.Item);
    static BLUE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_CRIMSON_HYPHAE: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DEEPSLATE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static TARGET: (Internal.BlockItem) & (Internal.Item);
    static SOUL_SAND: (Internal.BlockItem) & (Internal.Item);
    static DAYLIGHT_DETECTOR: (Internal.BlockItem) & (Internal.Item);
    static MOOSHROOM_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static LIGHT_BLUE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static PRISMARINE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static DAMAGED_ANVIL: (Internal.ApothAnvilItem) & (Internal.Item);
    static YELLOW_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static RAW_IRON_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static TROPICAL_FISH_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BAMBOO_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static INK_SAC: (Internal.InkSacItem) & (Internal.Item);
    static LINGERING_POTION: (Internal.LingeringPotionItem) & (Internal.Item);
    static BRAIN_CORAL: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static GILDED_BLACKSTONE: (Internal.BlockItem) & (Internal.Item);
    static PRISMARINE: (Internal.BlockItem) & (Internal.Item);
    static SOUL_CAMPFIRE: (Internal.BlockItem) & (Internal.Item);
    static LECTERN: (Internal.BlockItem) & (Internal.Item);
    static SHROOMLIGHT: (Internal.BlockItem) & (Internal.Item);
    static GOLD_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MUD_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_FENCE: (Internal.BlockItem) & (Internal.Item);
    static SNIFFER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CHERRY_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static PAINTING: (Internal.HangingEntityItem) & (Internal.Item);
    static MANGROVE_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static IRON_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static ARROW: (Internal.ArrowItem) & (Internal.Item);
    static DEAD_BUBBLE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_DARK_OAK_LOG: (Internal.BlockItem) & (Internal.Item);
    static WHITE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_STEM: (Internal.BlockItem) & (Internal.Item);
    static SOUL_LANTERN: (Internal.BlockItem) & (Internal.Item);
    static BLUE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static WRITABLE_BOOK: (Internal.WritableBookItem) & (Internal.Item);
    static PURPLE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static CUT_RED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static LIME_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static STRAY_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static STRIPPED_BIRCH_LOG: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_TILE_WALL: (Internal.BlockItem) & (Internal.Item);
    static SLIME_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static NETHER_WART_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_TILE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_MOSAIC_SLAB: (Internal.BlockItem) & (Internal.Item);
    static END_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static SKELETON_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CRIMSON_FENCE: (Internal.BlockItem) & (Internal.Item);
    static SUSPICIOUS_SAND: (Internal.BlockItem) & (Internal.Item);
    static CRACKED_NETHER_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static STRUCTURE_BLOCK: (Internal.GameMasterBlockItem) & (Internal.Item);
    static CAT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static IRON_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static STRIPPED_OAK_WOOD: (Internal.BlockItem) & (Internal.Item);
    static PISTON: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_UPGRADE_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static DEEPSLATE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static COD_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static HONEY_BOTTLE: (Internal.HoneyBottleItem) & (Internal.Item);
    static EXPOSED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_STRAD: (Internal.RecordItem) & (Internal.Item);
    static GREEN_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static PINK_BED: (Internal.BedItem) & (Internal.Item);
    static LADDER: (Internal.BlockItem) & (Internal.Item);
    static SCULK_CATALYST: (Internal.BlockItem) & (Internal.Item);
    static BLUE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static SNOW_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_CHEST_RAFT: (Internal.BoatItem) & (Internal.Item);
    static SALMON: (Internal.Item) & (Internal.Item);
    static DISPENSER: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static OAK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static RED_BANNER: (Internal.BannerItem) & (Internal.Item);
    static IRON_AXE: (Internal.AxeItem) & (Internal.Item);
    static DEEPSLATE_LAPIS_ORE: (Internal.BlockItem) & (Internal.Item);
    static SILVERFISH_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ENDERMAN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GOLDEN_AXE: (Internal.AxeItem) & (Internal.Item);
    static OAK_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static GRANITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CHARCOAL: (Internal.Item) & (Internal.Item);
    static WOODEN_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static MELON: (Internal.BlockItem) & (Internal.Item);
    static ECHO_SHARD: (Internal.Item) & (Internal.Item);
    static BAMBOO_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static DIRT_PATH: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static WAYFINDER_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static WHITE_BED: (Internal.BedItem) & (Internal.Item);
    static DIORITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static RECOVERY_COMPASS: (Internal.Item) & (Internal.Item);
    static SNOW: (Internal.BlockItem) & (Internal.Item);
    static GRAY_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static GHAST_TEAR: (Internal.Item) & (Internal.Item);
    static GOLDEN_CARROT: (Internal.Item) & (Internal.Item);
    static FERN: (Internal.BlockItem) & (Internal.Item);
    static CORNFLOWER: (Internal.BlockItem) & (Internal.Item);
    static CHAIN_COMMAND_BLOCK: (Internal.GameMasterBlockItem) & (Internal.Item);
    static ZOMBIE_VILLAGER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static LIME_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static GREEN_BANNER: (Internal.BannerItem) & (Internal.Item);
    static TRIPWIRE_HOOK: (Internal.BlockItem) & (Internal.Item);
    static EVOKER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SALMON_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DEEPSLATE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RAW_GOLD: (Internal.Item) & (Internal.Item);
    static BIRCH_SIGN: (Internal.SignItem) & (Internal.Item);
    static FROGSPAWN: (Internal.PlaceOnWaterBlockItem) & (Internal.Item);
    static SADDLE: (Internal.SaddleItem) & (Internal.Item);
    static YELLOW_WOOL: (Internal.BlockItem) & (Internal.Item);
    static TRIDENT: (Internal.TridentItem) & (Internal.Item);
    static LIGHT_BLUE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static WARPED_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static SLIME_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static OAK_WOOD: (Internal.BlockItem) & (Internal.Item);
    static ENDER_CHEST: (Internal.BlockItem) & (Internal.Item);
    static REDSTONE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_BED: (Internal.BedItem) & (Internal.Item);
    static CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WANDERING_TRADER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static WAXED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static WAXED_WEATHERED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static WAXED_OXIDIZED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static QUARTZ_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RAIL: (Internal.BlockItem) & (Internal.Item);
    static EMERALD_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static POPPY: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static ANDESITE_WALL: (Internal.BlockItem) & (Internal.Item);
    static LEATHER_HELMET: (Internal.DyeableArmorItem) & (Internal.Item);
    static ACACIA_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static CARTOGRAPHY_TABLE: (Internal.BlockItem) & (Internal.Item);
    static RED_TULIP: (Internal.BlockItem) & (Internal.Item);
    static TRAPPED_CHEST: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_LOG: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_LOG: (Internal.BlockItem) & (Internal.Item);
    static CHIPPED_ANVIL: (Internal.ApothAnvilItem) & (Internal.Item);
    static MAGMA_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static GUNPOWDER: (Internal.Item) & (Internal.Item);
    static OXIDIZED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static BLACK_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static BLUE_DYE: (Internal.DyeItem) & (Internal.Item);
    static PACKED_ICE: (Internal.BlockItem) & (Internal.Item);
    static PEONY: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static CRIMSON_FUNGUS: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static BEETROOT_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static IRON_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static GOLDEN_APPLE: (Internal.Item) & (Internal.Item);
    static LIGHT_BLUE_BED: (Internal.BedItem) & (Internal.Item);
    static WARPED_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static CACTUS: (Internal.PlaceboUtil$1) & (Internal.Item);
    static TORCH: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static GLASS_BOTTLE: (Internal.BottleItem) & (Internal.Item);
    static MAGENTA_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static STRUCTURE_VOID: (Internal.BlockItem) & (Internal.Item);
    static DEAD_TUBE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static GREEN_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_BLOCKS: (Internal.RecordItem) & (Internal.Item);
    static COOKED_BEEF: (Internal.Item) & (Internal.Item);
    static DIAMOND_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static WOODEN_SWORD: (Internal.SwordItem) & (Internal.Item);
    static CRIMSON_SIGN: (Internal.SignItem) & (Internal.Item);
    static NETHER_BRICK: (Internal.Item) & (Internal.Item);
    static STONE_AXE: (Internal.AxeItem) & (Internal.Item);
    static DEAD_BUSH: (Internal.BlockItem) & (Internal.Item);
    static CYAN_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static DEEPSLATE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WHITE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static GRANITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_STONE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static OAK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static DEAD_BUBBLE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static WARPED_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static MINER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static BROWN_MUSHROOM: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static WOLF_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static MAGENTA_BANNER: (Internal.BannerItem) & (Internal.Item);
    static CYAN_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static WAXED_EXPOSED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static RAW_IRON: (Internal.Item) & (Internal.Item);
    static WEATHERED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_DARK_OAK_WOOD: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_FENCE: (Internal.BlockItem) & (Internal.Item);
    static INFESTED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static IRON_BARS: (Internal.BlockItem) & (Internal.Item);
    static SANDSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BEDROCK: (Internal.BlockItem) & (Internal.Item);
    static MOURNER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static STRIPPED_CHERRY_LOG: (Internal.BlockItem) & (Internal.Item);
    static TNT_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static BEE_NEST: (Internal.BlockItem) & (Internal.Item);
    static ACTIVATOR_RAIL: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_5: (Internal.RecordItem) & (Internal.Item);
    static DEAD_FIRE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static GOLDEN_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static STRIPPED_WARPED_HYPHAE: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_CARPET: (Internal.BlockItem) & (Internal.Item);
    static TORCHFLOWER_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static HONEY_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_ACACIA_LOG: (Internal.BlockItem) & (Internal.Item);
    static FRIEND_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static RAW_GOLD_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static WARPED_FUNGUS_ON_A_STICK: Internal.Item;
    static SMOOTH_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static DOLPHIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static NETHERITE_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static GRANITE_WALL: (Internal.BlockItem) & (Internal.Item);
    static BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static LIME_WOOL: (Internal.BlockItem) & (Internal.Item);
    static CHAINMAIL_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static WOODEN_HOE: (Internal.HoeItem) & (Internal.Item);
    static HORSE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static WATER_BUCKET: (Internal.BucketItem) & (Internal.Item);
    static SMOOTH_QUARTZ_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WAXED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static HORN_CORAL: (Internal.BlockItem) & (Internal.Item);
    static BLACKSTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_STAL: (Internal.RecordItem) & (Internal.Item);
    static SPONGE: (Internal.BlockItem) & (Internal.Item);
    static PIGLIN_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static RAW_COPPER: (Internal.Item) & (Internal.Item);
    static DARK_OAK_BOAT: (Internal.BoatItem) & (Internal.Item);
    static REDSTONE_ORE: (Internal.BlockItem) & (Internal.Item);
    static ANDESITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BOWL: (Internal.Item) & (Internal.Item);
    static BLACK_WOOL: (Internal.BlockItem) & (Internal.Item);
    static COBBLED_DEEPSLATE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BEEF: (Internal.Item) & (Internal.Item);
    static COBBLESTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CYAN_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static SPRUCE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static HEARTBREAK_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static CRIMSON_HYPHAE: (Internal.BlockItem) & (Internal.Item);
}
type Items_ = Items;
declare interface NBTIO {
    write(path: Internal.Path_, nbt: Internal.CompoundTag_): void;
    read(path: Internal.Path_): Internal.CompoundTag;
}
type NBTIO_ = NBTIO;
declare const NBTIO: NBTIO;
declare class SoundType {
    constructor(arg0: number, arg1: number, arg2: Internal.SoundEvent_, arg3: Internal.SoundEvent_, arg4: Internal.SoundEvent_, arg5: Internal.SoundEvent_, arg6: Internal.SoundEvent_)
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    getHitSound(): Internal.SoundEvent;
    getStepSound(): Internal.SoundEvent;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    getFallSound(): Internal.SoundEvent;
    getPlaceSound(): Internal.SoundEvent;
    getVolume(): number;
    hashCode(): number;
    getPitch(): number;
    wait(): void;
    wait(arg0: number): void;
    getBreakSound(): Internal.SoundEvent;
    equals(arg0: any): boolean;
    get class(): typeof any
    get hitSound(): Internal.SoundEvent
    get stepSound(): Internal.SoundEvent
    get fallSound(): Internal.SoundEvent
    get placeSound(): Internal.SoundEvent
    get volume(): number
    get pitch(): number
    get breakSound(): Internal.SoundEvent
    static readonly EMPTY: (SoundType) & (SoundType);
    static readonly SAND: (SoundType) & (SoundType);
    static readonly DECORATED_POT: (SoundType) & (SoundType);
    static readonly TUFF: (SoundType) & (SoundType);
    static readonly GRAVEL: (SoundType) & (SoundType);
    static readonly SHROOMLIGHT: (SoundType) & (SoundType);
    static readonly MOSS: (SoundType) & (SoundType);
    readonly pitch: number;
    static readonly GRASS: (SoundType) & (SoundType);
    static readonly SOUL_SOIL: (SoundType) & (SoundType);
    static readonly WEEPING_VINES: (SoundType) & (SoundType);
    static readonly ANCIENT_DEBRIS: (SoundType) & (SoundType);
    static readonly SCULK_SENSOR: (SoundType) & (SoundType);
    static readonly POINTED_DRIPSTONE: (SoundType) & (SoundType);
    static readonly ROOTED_DIRT: (SoundType) & (SoundType);
    static readonly FROGSPAWN: (SoundType) & (SoundType);
    static readonly NETHER_ORE: (SoundType) & (SoundType);
    static readonly COPPER: (SoundType) & (SoundType);
    static readonly LANTERN: (SoundType) & (SoundType);
    static readonly BONE_BLOCK: (SoundType) & (SoundType);
    static readonly FROGLIGHT: (SoundType) & (SoundType);
    static readonly SNOW: (SoundType) & (SoundType);
    static readonly SCULK_VEIN: (SoundType) & (SoundType);
    static readonly CHERRY_WOOD: (SoundType) & (SoundType);
    static readonly POLISHED_DEEPSLATE: (SoundType) & (SoundType);
    static readonly NYLIUM: (SoundType) & (SoundType);
    static readonly DEEPSLATE: (SoundType) & (SoundType);
    static readonly SPORE_BLOSSOM: (SoundType) & (SoundType);
    static readonly BASALT: (SoundType) & (SoundType);
    static readonly CHERRY_WOOD_HANGING_SIGN: (SoundType) & (SoundType);
    static readonly SMALL_AMETHYST_BUD: (SoundType) & (SoundType);
    static readonly CANDLE: (SoundType) & (SoundType);
    static readonly FLOWERING_AZALEA: (SoundType) & (SoundType);
    static readonly ANVIL: (SoundType) & (SoundType);
    static readonly SCAFFOLDING: (SoundType) & (SoundType);
    static readonly DEEPSLATE_BRICKS: (SoundType) & (SoundType);
    static readonly CORAL_BLOCK: (SoundType) & (SoundType);
    static readonly BAMBOO_SAPLING: (SoundType) & (SoundType);
    static readonly LILY_PAD: (SoundType) & (SoundType);
    static readonly MOSS_CARPET: (SoundType) & (SoundType);
    static readonly LADDER: (SoundType) & (SoundType);
    static readonly LARGE_AMETHYST_BUD: (SoundType) & (SoundType);
    static readonly GLOW_LICHEN: (SoundType) & (SoundType);
    static readonly CROP: (SoundType) & (SoundType);
    static readonly PINK_PETALS: (SoundType) & (SoundType);
    static readonly AZALEA_LEAVES: (SoundType) & (SoundType);
    static readonly POWDER_SNOW: (SoundType) & (SoundType);
    static readonly METAL: (SoundType) & (SoundType);
    static readonly HONEY_BLOCK: (SoundType) & (SoundType);
    static readonly NETHER_BRICKS: (SoundType) & (SoundType);
    static readonly SUSPICIOUS_SAND: (SoundType) & (SoundType);
    static readonly GILDED_BLACKSTONE: (SoundType) & (SoundType);
    static readonly HARD_CROP: (SoundType) & (SoundType);
    static readonly SCULK_CATALYST: (SoundType) & (SoundType);
    static readonly DEEPSLATE_TILES: (SoundType) & (SoundType);
    static readonly PACKED_MUD: (SoundType) & (SoundType);
    static readonly SCULK: (SoundType) & (SoundType);
    static readonly VINE: (SoundType) & (SoundType);
    static readonly BAMBOO: (SoundType) & (SoundType);
    static readonly GLASS: (SoundType) & (SoundType);
    static readonly DRIPSTONE_BLOCK: (SoundType) & (SoundType);
    static readonly CHERRY_SAPLING: (SoundType) & (SoundType);
    static readonly CALCITE: (SoundType) & (SoundType);
    static readonly MUD_BRICKS: (SoundType) & (SoundType);
    static readonly STEM: (SoundType) & (SoundType);
    static readonly BAMBOO_WOOD: (SoundType) & (SoundType);
    static readonly SOUL_SAND: (SoundType) & (SoundType);
    static readonly MUD: (SoundType) & (SoundType);
    static readonly BIG_DRIPLEAF: (SoundType) & (SoundType);
    static readonly BAMBOO_WOOD_HANGING_SIGN: (SoundType) & (SoundType);
    static readonly TWISTING_VINES: (SoundType) & (SoundType);
    static readonly NETHERRACK: (SoundType) & (SoundType);
    static readonly AMETHYST_CLUSTER: (SoundType) & (SoundType);
    static readonly SLIME_BLOCK: (SoundType) & (SoundType);
    static readonly SCULK_SHRIEKER: (SoundType) & (SoundType);
    static readonly CHAIN: (SoundType) & (SoundType);
    static readonly WOOD: (SoundType) & (SoundType);
    static readonly AZALEA: (SoundType) & (SoundType);
    static readonly MANGROVE_ROOTS: (SoundType) & (SoundType);
    static readonly CHISELED_BOOKSHELF: (SoundType) & (SoundType);
    static readonly NETHER_GOLD_ORE: (SoundType) & (SoundType);
    static readonly CHERRY_LEAVES: (SoundType) & (SoundType);
    static readonly AMETHYST: (SoundType) & (SoundType);
    static readonly DECORATED_POT_CRACKED: (SoundType) & (SoundType);
    static readonly CAVE_VINES: (SoundType) & (SoundType);
    static readonly SUSPICIOUS_GRAVEL: (SoundType) & (SoundType);
    static readonly LODESTONE: (SoundType) & (SoundType);
    readonly volume: number;
    static readonly FUNGUS: (SoundType) & (SoundType);
    static readonly SMALL_DRIPLEAF: (SoundType) & (SoundType);
    static readonly HANGING_ROOTS: (SoundType) & (SoundType);
    static readonly SWEET_BERRY_BUSH: (SoundType) & (SoundType);
    static readonly NETHER_WOOD: (SoundType) & (SoundType);
    static readonly NETHER_WART: (SoundType) & (SoundType);
    static readonly STONE: (SoundType) & (SoundType);
    static readonly NETHER_WOOD_HANGING_SIGN: (SoundType) & (SoundType);
    static readonly HANGING_SIGN: (SoundType) & (SoundType);
    static readonly WET_GRASS: (SoundType) & (SoundType);
    static readonly NETHERITE_BLOCK: (SoundType) & (SoundType);
    static readonly MEDIUM_AMETHYST_BUD: (SoundType) & (SoundType);
    static readonly MUDDY_MANGROVE_ROOTS: (SoundType) & (SoundType);
    static readonly WOOL: (SoundType) & (SoundType);
    static readonly ROOTS: (SoundType) & (SoundType);
    static readonly WART_BLOCK: (SoundType) & (SoundType);
    static readonly NETHER_SPROUTS: (SoundType) & (SoundType);
}
type SoundType_ = SoundType;
declare class AlmostUnified {
    static getPreferredItemForTag(tag: ResourceLocation_): Internal.ItemStack;
    getClass(): typeof any;
    toString(): string;
    static getReplacementForItem(stack: Internal.ItemStack_): Internal.ItemStack;
    notifyAll(): void;
    static getUnifyConfig(): Internal.UnifyConfig;
    static getTags(): Internal.Set<string>;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    hashCode(): number;
    wait(): void;
    wait(arg0: number): void;
    static getItemIds(tag: ResourceLocation_): Internal.Set<string>;
    static getPreferredTagForItem(stack: Internal.ItemStack_): string;
    equals(arg0: any): boolean;
    get class(): typeof any
    get unifyConfig(): Internal.UnifyConfig
    get tags(): Internal.Set<string>
}
type AlmostUnified_ = AlmostUnified;
declare class JAOPCA {
    constructor()
    static containsForm(formName: string): boolean;
    getClass(): typeof any;
    static containsMaterial(materialName: string): boolean;
    static getModule(moduleName: string): thelm.jaopca.compat.kubejs.utils.Module;
    static getAllMaterials(): Internal.List<thelm.jaopca.compat.kubejs.utils.Material>;
    toString(): string;
    static getMaterial(materialName: string): thelm.jaopca.compat.kubejs.utils.Material;
    notifyAll(): void;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    static getForm(formName: string): Internal.Form;
    hashCode(): number;
    static getMaterialsForType(materialType: string): Internal.List<thelm.jaopca.compat.kubejs.utils.Material>;
    static containsModule(moduleName: string): boolean;
    wait(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    get class(): typeof any
    get allMaterials(): Internal.List<thelm.jaopca.compat.kubejs.utils.Material>
}
type JAOPCA_ = JAOPCA;
declare class Duration implements Internal.TemporalAmount, Internal.Comparable<Duration>, Internal.Serializable {
    "dividedBy(java.time.Duration)"(arg0: Duration_): number;
    static parse(arg0: Internal.CharSequence_): Duration;
    notify(): void;
    compareTo(arg0: any): number;
    minusHours(arg0: number): this;
    plusMillis(arg0: number): this;
    toNanosPart(): number;
    getUnits(): Internal.List<Internal.TemporalUnit>;
    multipliedBy(arg0: number): this;
    dividedBy(arg0: number): this;
    get(arg0: Internal.TemporalUnit_): number;
    minusNanos(arg0: number): this;
    static ofSeconds(arg0: number): Duration;
    isNegative(): boolean;
    static ofMinutes(arg0: number): Duration;
    minus(arg0: Duration_): this;
    static ofNanos(arg0: number): Duration;
    toDays(): number;
    toHoursPart(): number;
    minusDays(arg0: number): this;
    toSecondsPart(): number;
    static ofMillis(arg0: number): Duration;
    wait(): void;
    plusNanos(arg0: number): this;
    "compareTo(java.lang.Object)"(arg0: any): number;
    minusSeconds(arg0: number): this;
    toMinutes(): number;
    plus(arg0: number, arg1: Internal.TemporalUnit_): this;
    getClass(): typeof any;
    toMillis(): number;
    toHours(): number;
    getSeconds(): number;
    static ofSeconds(arg0: number, arg1: number): Duration;
    toMinutesPart(): number;
    isZero(): boolean;
    wait(arg0: number, arg1: number): void;
    static of(arg0: number, arg1: Internal.TemporalUnit_): Duration;
    withSeconds(arg0: number): this;
    static between(arg0: Internal.Temporal_, arg1: Internal.Temporal_): Duration;
    plusSeconds(arg0: number): this;
    plusMinutes(arg0: number): this;
    toNanos(): number;
    negated(): this;
    static ofDays(arg0: number): Duration;
    addTo(arg0: Internal.Temporal_): Internal.Temporal;
    compareTo(arg0: Duration_): number;
    toString(): string;
    minus(arg0: number, arg1: Internal.TemporalUnit_): this;
    plus(arg0: Duration_): this;
    notifyAll(): void;
    toDaysPart(): number;
    "compareTo(java.time.Duration)"(arg0: Duration_): number;
    plusDays(arg0: number): this;
    static from(arg0: Internal.TemporalAmount_): Duration;
    getNano(): number;
    plusHours(arg0: number): this;
    truncatedTo(arg0: Internal.TemporalUnit_): this;
    subtractFrom(arg0: Internal.Temporal_): Internal.Temporal;
    hashCode(): number;
    minusMillis(arg0: number): this;
    wait(arg0: number): void;
    dividedBy(arg0: Duration_): number;
    equals(arg0: any): boolean;
    abs(): this;
    static ofHours(arg0: number): Duration;
    minusMinutes(arg0: number): this;
    withNanos(arg0: number): this;
    "dividedBy(long)"(arg0: number): this;
    toSeconds(): number;
    toMillisPart(): number;
    get units(): Internal.List<Internal.TemporalUnit>
    get negative(): boolean
    get class(): typeof any
    get seconds(): number
    get zero(): boolean
    get nano(): number
    static readonly ZERO: (Duration) & (Duration);
}
type Duration_ = Duration;
declare class OutputItem implements Internal.OutputReplacement {
    getClass(): typeof any;
    getCount(): number;
    withRolls(rolls: Internal.IntProvider_): this;
    static of(from: any): OutputItem;
    isEmpty(): boolean;
    notify(): void;
    withCount(count: number): this;
    wait(arg0: number, arg1: number): void;
    weakNBT(): InputItem;
    strongNBT(): InputItem;
    replaceOutput(recipe: Internal.RecipeJS_, match: Internal.ReplacementMatch_, original: Internal.OutputReplacement_): any;
    withChance(chance: number): this;
    withRolls(min: number, max: number): this;
    getNbt(): Internal.CompoundTag;
    toString(): string;
    transform(transformer: Internal.OutputReplacementTransformer_): Internal.OutputReplacementTransformer$Replacement;
    notifyAll(): void;
    getChance(): number;
    static of(item: Internal.ItemStack_, chance: number): OutputItem;
    hashCode(): number;
    wait(): void;
    wait(arg0: number): void;
    hasChance(): boolean;
    equals(arg0: any): boolean;
    /**
     * @deprecated
    */
    ignoreNBT(): InputItem;
    get class(): typeof any
    get count(): number
    get empty(): boolean
    get nbt(): Internal.CompoundTag
    get chance(): number
    static readonly EMPTY: (OutputItem) & (OutputItem);
    readonly item: Internal.ItemStack;
    readonly rolls: Internal.IntProvider;
    readonly chance: number;
}
type OutputItem_ = Internal.ItemStack_ | OutputItem;
declare class DamageSource implements Internal.DamageSourceExtension {
    constructor(arg0: Internal.Holder_<Internal.DamageType>)
    constructor(arg0: Internal.Holder_<Internal.DamageType>, arg1: Internal.Entity_, arg2: Internal.Entity_)
    constructor(arg0: Internal.Holder_<Internal.DamageType>, arg1: Internal.Entity_)
    constructor(arg0: Internal.Holder_<Internal.DamageType>, arg1: Vec3d_)
    constructor(arg0: Internal.Holder_<Internal.DamageType>, arg1: Internal.Entity_, arg2: Internal.Entity_, arg3: Vec3d_)
    handler$zig000$apoth_isSourceInExtraTags(arg0: Internal.TagKey_<any>, arg1: Internal.CallbackInfoReturnable_<any>): void;
    getClass(): typeof any;
    getSourcePosition(): Vec3d;
    scalesWithDifficulty(): boolean;
    typeHolder(): Internal.Holder<Internal.DamageType>;
    removeTag(arg0: Internal.TagKey_<any>): void;
    "is(net.minecraft.tags.TagKey)"(arg0: Internal.TagKey_<Internal.DamageType>): boolean;
    notify(): void;
    getLocalizedDeathMessage(arg0: Internal.LivingEntity_): net.minecraft.network.chat.Component;
    wait(arg0: number, arg1: number): void;
    is(arg0: Internal.TagKey_<Internal.DamageType>): boolean;
    type(): Internal.DamageType;
    "is(net.minecraft.resources.ResourceKey)"(arg0: Internal.ResourceKey_<Internal.DamageType>): boolean;
    getType(): string;
    getActual(): Internal.Entity;
    getPlayer(): Internal.Player;
    toString(): string;
    isIndirect(): boolean;
    getImmediate(): Internal.Entity;
    notifyAll(): void;
    getFoodExhaustion(): number;
    sourcePositionRaw(): Vec3d;
    is(arg0: Internal.ResourceKey_<Internal.DamageType>): boolean;
    hashCode(): number;
    isCreativePlayer(): boolean;
    wait(): void;
    addTag(arg0: Internal.TagKey_<any>): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    get class(): typeof any
    get sourcePosition(): Vec3d
    get type(): string
    get actual(): Internal.Entity
    get player(): Internal.Player
    get indirect(): boolean
    get immediate(): Internal.Entity
    get foodExhaustion(): number
    get creativePlayer(): boolean
}
type DamageSource_ = DamageSource;
declare class Platform {
    constructor()
    getClass(): typeof any;
    static getMcVersion(): string;
    static isForge(): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    static isFabric(): boolean;
    static isGeneratingData(): boolean;
    static getInfo(modID: string): Internal.PlatformWrapper$ModInfo;
    static isLoaded(modId: string): boolean;
    static getName(): string;
    static setModName(modId: string, name: string): void;
    static getMinecraftVersion(): number;
    static isDevelopmentEnvironment(): boolean;
    static getList(): Internal.Set<string>;
    toString(): string;
    notifyAll(): void;
    static isClientEnvironment(): boolean;
    static getModVersion(): string;
    static breakpoint(...args: any[]): void;
    hashCode(): number;
    static getMinecraftVersionString(): string;
    static getMods(): Internal.Map<string, Internal.PlatformWrapper$ModInfo>;
    wait(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    get class(): typeof any
    get mcVersion(): string
    get forge(): boolean
    get fabric(): boolean
    get generatingData(): boolean
    get name(): string
    get minecraftVersion(): number
    get developmentEnvironment(): boolean
    get list(): Internal.Set<string>
    get clientEnvironment(): boolean
    get modVersion(): string
    get minecraftVersionString(): string
    get mods(): Internal.Map<string, Internal.PlatformWrapper$ModInfo>
}
type Platform_ = Platform;
declare class Vec3f implements Internal.Cloneable, Internal.Vector3fc, Internal.Externalizable {
    constructor()
    constructor(arg0: Internal.Vector3fc_)
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: number, arg1: Internal.FloatBuffer_)
    constructor(arg0: number[])
    constructor(arg0: number)
    constructor(arg0: Internal.Vector2fc_, arg1: number)
    constructor(arg0: Internal.Vector2ic_, arg1: number)
    constructor(arg0: Internal.ByteBuffer_)
    constructor(arg0: number, arg1: Internal.ByteBuffer_)
    constructor(arg0: number, arg1: number, arg2: number)
    constructor(arg0: Internal.Vector3ic_)
    "set(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    "get(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    set(arg0: number, arg1: number, arg2: number): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    div(arg0: number, arg1: number, arg2: number): this;
    rotateY(arg0: number): this;
    "mul(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    angleCos(arg0: Internal.Vector3fc_): number;
    "fma(float,org.joml.Vector3fc)"(arg0: number, arg1: Internal.Vector3fc_): this;
    set(arg0: number): this;
    "set(float)"(arg0: number): this;
    static length(arg0: number, arg1: number, arg2: number): number;
    mulAdd(arg0: number, arg1: Internal.Vector3fc_): this;
    normalize(arg0: number, arg1: Vec3f_): this;
    sub(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    half(arg0: number, arg1: number, arg2: number): this;
    round(): this;
    "fma(org.joml.Vector3fc,org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    "mulAdd(org.joml.Vector3fc,org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    orthogonalizeUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    "get(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "div(float)"(arg0: number): this;
    add(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    get(arg0: number): number;
    "mulAdd(float,org.joml.Vector3fc,org.joml.Vector3f)"(arg0: number, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    mul(arg0: number, arg1: number, arg2: number): this;
    ceil(arg0: Vec3f_): this;
    negate(): this;
    getClass(): typeof any;
    "mulPosition(org.joml.Matrix4x3fc,org.joml.Vector3f)"(arg0: Internal.Matrix4x3fc_, arg1: Vec3f_): this;
    add(arg0: Internal.Vector3fc_): this;
    static lengthSquared(arg0: number, arg1: number, arg2: number): number;
    ceil(): this;
    div(arg0: number, arg1: Vec3f_): this;
    distanceSquared(arg0: number, arg1: number, arg2: number): number;
    "mulDirection(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_): this;
    "div(float,org.joml.Vector3f)"(arg0: number, arg1: Vec3f_): this;
    add(arg0: number, arg1: number, arg2: number): this;
    mulTransposeDirection(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    rotateZ(arg0: number): this;
    distanceSquared(arg0: Internal.Vector3fc_): number;
    set(arg0: number[]): this;
    equals(arg0: Internal.Vector3fc_, arg1: number): boolean;
    "normalize(float)"(arg0: number): this;
    "set(double)"(arg0: number): this;
    mulAdd(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    div(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    max(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    lerp(arg0: Internal.Vector3fc_, arg1: number, arg2: Vec3f_): this;
    "mulAdd(org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    mulPositionW(arg0: Internal.Matrix4fc_): number;
    mulPosition(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    rotationTo(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): Quaternionf;
    "mul(org.joml.Matrix3x2fc,org.joml.Vector3f)"(arg0: Internal.Matrix3x2fc_, arg1: Vec3f_): this;
    mul(arg0: Internal.Matrix3x2fc_): this;
    "set(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    mulDirection(arg0: Internal.Matrix4x3fc_, arg1: Vec3f_): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    "mulDirection(org.joml.Matrix4fc,org.joml.Vector3f)"(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    wait(arg0: number): void;
    rotateZ(arg0: number, arg1: Vec3f_): this;
    mul(arg0: Internal.Matrix3fc_): this;
    "mulDirection(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    absolute(arg0: Vec3f_): this;
    angleSigned(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): number;
    normalize(arg0: Vec3f_): this;
    normalize(arg0: number): this;
    normalize(): this;
    mulProject(arg0: Internal.Matrix4fc_, arg1: number, arg2: Vec3f_): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    mul(arg0: Internal.Vector3fc_): this;
    isFinite(): boolean;
    mulTransposePosition(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    getToAddress(arg0: number): Internal.Vector3fc;
    "mulDirection(org.joml.Matrix4dc,org.joml.Vector3f)"(arg0: Internal.Matrix4dc_, arg1: Vec3f_): this;
    "mul(org.joml.Matrix3dc,org.joml.Vector3f)"(arg0: Internal.Matrix3dc_, arg1: Vec3f_): this;
    "mulDirection(org.joml.Matrix4x3fc,org.joml.Vector3f)"(arg0: Internal.Matrix4x3fc_, arg1: Vec3f_): this;
    x(): number;
    absolute(): this;
    mulDirection(arg0: Internal.Matrix4dc_): this;
    "set(float,float,float)"(arg0: number, arg1: number, arg2: number): this;
    "set(org.joml.Vector2dc,float)"(arg0: Internal.Vector2dc_, arg1: number): this;
    mulDirection(arg0: Internal.Matrix4dc_, arg1: Vec3f_): this;
    mulAdd(arg0: number, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    "mul(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    fma(arg0: number, arg1: Internal.Vector3fc_): this;
    wait(): void;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    sub(arg0: Internal.Vector3fc_): this;
    minComponent(): number;
    set(arg0: Internal.Vector3fc_): this;
    orthogonalize(arg0: Internal.Vector3fc_): this;
    rotate(arg0: Internal.Quaternionfc_, arg1: Vec3f_): this;
    "set(org.joml.Vector2ic,float)"(arg0: Internal.Vector2ic_, arg1: number): this;
    set(arg0: Internal.ByteBuffer_): this;
    "mul(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    "set(org.joml.Vector3dc)"(arg0: Internal.Vector3dc_): this;
    rotateX(arg0: number): this;
    round(arg0: Vec3f_): this;
    half(arg0: Internal.Vector3fc_): this;
    mul(arg0: Internal.Matrix3dc_, arg1: Vec3f_): this;
    static distance(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
    mul(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    "normalize(org.joml.Vector3f)"(arg0: Vec3f_): this;
    "set(float[])"(arg0: number[]): this;
    y(): number;
    mul(arg0: Internal.Matrix3x2fc_, arg1: Vec3f_): this;
    "get(int,org.joml.Vector3i)"(arg0: number, arg1: Internal.Vector3i_): Internal.Vector3i;
    set(arg0: Internal.Vector2fc_, arg1: number): this;
    distance(arg0: Internal.Vector3fc_): number;
    "mul(org.joml.Matrix3fc,org.joml.Vector3f)"(arg0: Internal.Matrix3fc_, arg1: Vec3f_): this;
    "mulPosition(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    max(arg0: Internal.Vector3fc_): this;
    equals(arg0: any): boolean;
    setFromAddress(arg0: number): this;
    "mul(float)"(arg0: number): this;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    "mul(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_): this;
    "get(org.joml.Vector3f)"(arg0: Vec3f_): this;
    equals(arg0: number, arg1: number, arg2: number): boolean;
    add(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    mulPosition(arg0: Internal.Matrix4x3fc_, arg1: Vec3f_): this;
    mulTransposeDirection(arg0: Internal.Matrix4fc_): this;
    set(arg0: Internal.FloatBuffer_): this;
    "set(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): this;
    z(): number;
    "get(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    mulPositionW(arg0: Internal.Matrix4fc_, arg1: Vec3f_): number;
    mulDirection(arg0: Internal.Matrix4fc_): this;
    "fma(org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    toString(arg0: Internal.NumberFormat_): string;
    "get(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    "div(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    lengthSquared(): number;
    mulAdd(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "set(double,double,double)"(arg0: number, arg1: number, arg2: number): this;
    "set(org.joml.Vector2fc,float)"(arg0: Internal.Vector2fc_, arg1: number): this;
    mulTranspose(arg0: Internal.Matrix3fc_, arg1: Vec3f_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec3f_): this;
    clone(): any;
    cross(arg0: Internal.Vector3fc_): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    maxComponent(): number;
    "get(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.Vector3dc_): this;
    mul(arg0: number): this;
    static distanceSquared(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
    dot(arg0: number, arg1: number, arg2: number): number;
    mulTranspose(arg0: Internal.Matrix3fc_): this;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    floor(): this;
    zero(): this;
    reflect(arg0: number, arg1: number, arg2: number): this;
    mulProject(arg0: Internal.Matrix4fc_): this;
    sub(arg0: number, arg1: number, arg2: number): this;
    mulPosition(arg0: Internal.Matrix4x3fc_): this;
    length(): number;
    toString(): string;
    notifyAll(): void;
    "mulPosition(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    "mulPosition(org.joml.Matrix4fc,org.joml.Vector3f)"(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    setComponent(arg0: number, arg1: number): this;
    "mul(org.joml.Matrix3x2fc)"(arg0: Internal.Matrix3x2fc_): this;
    div(arg0: number): this;
    orthogonalize(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    cross(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    div(arg0: Internal.Vector3fc_): this;
    fma(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    set(arg0: number): this;
    rotate(arg0: Internal.Quaternionfc_): this;
    set(arg0: Internal.Vector3ic_): this;
    "mul(float,org.joml.Vector3f)"(arg0: number, arg1: Vec3f_): this;
    min(arg0: Internal.Vector3fc_): this;
    half(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    cross(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    notify(): void;
    "mulAdd(float,org.joml.Vector3fc)"(arg0: number, arg1: Internal.Vector3fc_): this;
    floor(arg0: Vec3f_): this;
    mul(arg0: Internal.Matrix3fc_, arg1: Vec3f_): this;
    half(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    smoothStep(arg0: Internal.Vector3fc_, arg1: number, arg2: Vec3f_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    set(arg0: Internal.Vector2dc_, arg1: number): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    negate(arg0: Vec3f_): this;
    mul(arg0: number, arg1: Vec3f_): this;
    hermite(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: number, arg4: Vec3f_): this;
    mulPosition(arg0: Internal.Matrix4fc_): this;
    get(arg0: Internal.Vector3d_): Internal.Vector3d;
    "set(org.joml.Vector3ic)"(arg0: Internal.Vector3ic_): this;
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotateY(arg0: number, arg1: Vec3f_): this;
    "get(int)"(arg0: number): number;
    distance(arg0: number, arg1: number, arg2: number): number;
    "set(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): this;
    dot(arg0: Internal.Vector3fc_): number;
    "set(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    div(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    cross(arg0: number, arg1: number, arg2: number): this;
    orthogonalizeUnit(arg0: Internal.Vector3fc_): this;
    min(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    set(arg0: number, arg1: number, arg2: number): this;
    wait(arg0: number, arg1: number): void;
    "mulDirection(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    set(arg0: Internal.Vector2ic_, arg1: number): this;
    lerp(arg0: Internal.Vector3fc_, arg1: number): this;
    "div(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    sub(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    rotationTo(arg0: Internal.Vector3fc_, arg1: Quaternionf_): Quaternionf;
    mulTransposePosition(arg0: Internal.Matrix4fc_): this;
    angle(arg0: Internal.Vector3fc_): number;
    mulProject(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    "fma(float,org.joml.Vector3fc,org.joml.Vector3f)"(arg0: number, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    get(arg0: number, arg1: Internal.Vector3i_): Internal.Vector3i;
    fma(arg0: number, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    angleSigned(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
    mulDirection(arg0: Internal.Matrix4x3fc_): this;
    mulDirection(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    hashCode(): number;
    fma(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    get(arg0: Vec3f_): this;
    rotateX(arg0: number, arg1: Vec3f_): this;
    reflect(arg0: Internal.Vector3fc_): this;
    mul(arg0: Internal.Matrix3dc_): this;
    set "(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set "(float)"(arg0: number)
    get class(): typeof any
    set "(double)"(arg0: number)
    set "(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    get finite(): boolean
    set "(org.joml.Vector3dc)"(arg0: Internal.Vector3dc_)
    set "(float[])"(arg0: number[])
    set fromAddress(arg0: number)
    set "(org.joml.Vector3ic)"(arg0: Internal.Vector3ic_)
    set "(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_)
    z: number;
    y: number;
    x: number;
}
type Vec3f_ = Vec3f;
declare class Vec4f implements Internal.Cloneable, Internal.Vector4fc, Internal.Externalizable {
    constructor()
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: number, arg1: Internal.FloatBuffer_)
    constructor(arg0: Internal.Vector2fc_, arg1: number, arg2: number)
    constructor(arg0: Internal.Vector3fc_, arg1: number)
    constructor(arg0: number[])
    constructor(arg0: number)
    constructor(arg0: Internal.ByteBuffer_)
    constructor(arg0: Internal.Vector2ic_, arg1: number, arg2: number)
    constructor(arg0: number, arg1: Internal.ByteBuffer_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number)
    constructor(arg0: Internal.Vector4fc_)
    constructor(arg0: Internal.Vector3ic_, arg1: number)
    constructor(arg0: Internal.Vector4ic_)
    min(arg0: Internal.Vector4fc_): this;
    set(arg0: Internal.Vector4ic_): this;
    div(arg0: Internal.Vector4fc_): this;
    "fma(float,org.joml.Vector4fc,org.joml.Vector4f)"(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    normalize3(arg0: Vec4f_): this;
    static distanceSquared(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): number;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    rotateAbout(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "set(float,float,float,float)"(arg0: number, arg1: number, arg2: number, arg3: number): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mul(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "div(float)"(arg0: number): this;
    mul(arg0: Internal.Vector4fc_): this;
    dot(arg0: number, arg1: number, arg2: number, arg3: number): number;
    setComponent(arg0: number, arg1: number): this;
    "set(double,double,double,double)"(arg0: number, arg1: number, arg2: number, arg3: number): this;
    fma(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    rotateZ(arg0: number, arg1: Vec4f_): this;
    mulAdd(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    "mul(org.joml.Matrix4fc,org.joml.Vector4f)"(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    z(): number;
    "set(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): this;
    min(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    div(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    "mul(float)"(arg0: number): this;
    "get(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.Vector2ic_, arg1: number, arg2: number): this;
    dot(arg0: Internal.Vector4fc_): number;
    set(arg0: number, arg1: number, arg2: number): this;
    mulAffine(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    "set(org.joml.Vector2fc,float,float)"(arg0: Internal.Vector2fc_, arg1: number, arg2: number): this;
    toString(arg0: Internal.NumberFormat_): string;
    rotateZ(arg0: number): this;
    "mul(float,org.joml.Vector4f)"(arg0: number, arg1: Vec4f_): this;
    "get(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    "get(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    fma(arg0: number, arg1: Internal.Vector4fc_): this;
    normalize3(): this;
    round(arg0: Vec4f_): this;
    div(arg0: number, arg1: number, arg2: number, arg3: number): this;
    lengthSquared(): number;
    mul(arg0: Internal.Matrix4x3fc_): this;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    get(arg0: number): number;
    distanceSquared(arg0: Internal.Vector4fc_): number;
    set(arg0: number[]): this;
    sub(arg0: Internal.Vector4fc_): this;
    mulAdd(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_): this;
    set(arg0: Internal.Vector3ic_, arg1: number): this;
    sub(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    clone(): any;
    getClass(): typeof any;
    mul(arg0: number, arg1: number, arg2: number, arg3: number): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    maxComponent(): number;
    "set(org.joml.Vector4ic)"(arg0: Internal.Vector4ic_): this;
    "get(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.Vector4fc_): this;
    "mul(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    negate(arg0: Vec4f_): this;
    "set(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    "fma(float,org.joml.Vector4fc)"(arg0: number, arg1: Internal.Vector4fc_): this;
    get(arg0: Internal.Vector4d_): Internal.Vector4d;
    getToAddress(arg0: number): Internal.Vector4fc;
    rotateY(arg0: number, arg1: Vec4f_): this;
    "get(int,org.joml.Vector4i)"(arg0: number, arg1: Internal.Vector4i_): Internal.Vector4i;
    set(arg0: Internal.Vector3fc_, arg1: number): this;
    "mul(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    "fma(org.joml.Vector4fc,org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    static lengthSquared(arg0: number, arg1: number, arg2: number, arg3: number): number;
    ceil(arg0: Vec4f_): this;
    "fma(org.joml.Vector4fc,org.joml.Vector4fc)"(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_): this;
    "mul(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    "set(org.joml.Vector4fc)"(arg0: Internal.Vector4fc_): this;
    negate(): this;
    mulAffineTranspose(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    "mulAdd(float,org.joml.Vector4fc)"(arg0: number, arg1: Internal.Vector4fc_): this;
    w(): number;
    rotate(arg0: Internal.Quaternionfc_): this;
    "set(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    length(): number;
    toString(): string;
    normalize(arg0: number): this;
    distanceSquared(arg0: number, arg1: number, arg2: number, arg3: number): number;
    mul(arg0: number): this;
    notifyAll(): void;
    ceil(): this;
    smoothStep(arg0: Internal.Vector4fc_, arg1: number, arg2: Vec4f_): this;
    lerp(arg0: Internal.Vector4fc_, arg1: number): this;
    "mul(org.joml.Matrix4x3fc,org.joml.Vector4f)"(arg0: Internal.Matrix4x3fc_, arg1: Vec4f_): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    floor(arg0: Vec4f_): this;
    mul(arg0: Internal.Matrix4x3fc_, arg1: Vec4f_): this;
    "get(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    div(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    "set(org.joml.Vector3ic,float)"(arg0: Internal.Vector3ic_, arg1: number): this;
    floor(): this;
    angle(arg0: Internal.Vector4fc_): number;
    wait(arg0: number): void;
    static "lengthSquared(int,int,int,int)"(arg0: number, arg1: number, arg2: number, arg3: number): number;
    "set(org.joml.Vector3fc,float)"(arg0: Internal.Vector3fc_, arg1: number): this;
    max(arg0: Internal.Vector4fc_): this;
    sub(arg0: number, arg1: number, arg2: number, arg3: number): this;
    set(arg0: Internal.FloatBuffer_): this;
    "get(org.joml.Vector4f)"(arg0: Vec4f_): this;
    angleCos(arg0: Internal.Vector4fc_): number;
    "set(float)"(arg0: number): this;
    get(arg0: number, arg1: Internal.Vector4i_): Internal.Vector4i;
    hermite(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Internal.Vector4fc_, arg3: number, arg4: Vec4f_): this;
    "set(float,float,float)"(arg0: number, arg1: number, arg2: number): this;
    absolute(): this;
    mul(arg0: number, arg1: Vec4f_): this;
    distance(arg0: Internal.Vector4fc_): number;
    notify(): void;
    fma(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_): this;
    normalize(): this;
    isFinite(): boolean;
    "normalize(org.joml.Vector4f)"(arg0: Vec4f_): this;
    get(arg0: Vec4f_): this;
    static length(arg0: number, arg1: number, arg2: number, arg3: number): number;
    set(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateX(arg0: number, arg1: Vec4f_): this;
    "mul(org.joml.Vector4fc)"(arg0: Internal.Vector4fc_): this;
    lerp(arg0: Internal.Vector4fc_, arg1: number, arg2: Vec4f_): this;
    static distance(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): number;
    div(arg0: number): this;
    setFromAddress(arg0: number): this;
    "div(org.joml.Vector4fc)"(arg0: Internal.Vector4fc_): this;
    mulAdd(arg0: number, arg1: Internal.Vector4fc_): this;
    "div(float,org.joml.Vector4f)"(arg0: number, arg1: Vec4f_): this;
    x(): number;
    absolute(arg0: Vec4f_): this;
    div(arg0: number, arg1: Vec4f_): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    mulTranspose(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    static lengthSquared(arg0: number, arg1: number, arg2: number, arg3: number): number;
    set(arg0: Internal.ByteBuffer_): this;
    "mulProject(org.joml.Matrix4fc,org.joml.Vector4f)"(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    "set(double)"(arg0: number): this;
    "div(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    wait(): void;
    fma(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    set(arg0: number, arg1: number, arg2: number, arg3: number): this;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    zero(): this;
    mulProject(arg0: Internal.Matrix4fc_): this;
    "get(int)"(arg0: number): number;
    static "lengthSquared(float,float,float,float)"(arg0: number, arg1: number, arg2: number, arg3: number): number;
    mulAdd(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    mulProject(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    "normalize(float)"(arg0: number): this;
    add(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    rotateX(arg0: number): this;
    minComponent(): number;
    round(): this;
    set(arg0: Internal.Vector4dc_): this;
    "mulAdd(org.joml.Vector4fc,org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    "mulProject(org.joml.Matrix4fc,org.joml.Vector3f)"(arg0: Internal.Matrix4fc_, arg1: Vec3f_): Vec3f;
    add(arg0: Internal.Vector4fc_): this;
    "mulAdd(org.joml.Vector4fc,org.joml.Vector4fc)"(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_): this;
    equals(arg0: Internal.Vector4fc_, arg1: number): boolean;
    wait(arg0: number, arg1: number): void;
    "set(org.joml.Vector2ic,float,float)"(arg0: Internal.Vector2ic_, arg1: number, arg2: number): this;
    sub(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    mulTranspose(arg0: Internal.Matrix4fc_): this;
    max(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    equals(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
    "mulAdd(float,org.joml.Vector4fc,org.joml.Vector4f)"(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    mulProject(arg0: Internal.Matrix4fc_, arg1: Vec3f_): Vec3f;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    y(): number;
    rotate(arg0: Internal.Quaternionfc_, arg1: Vec4f_): this;
    mul(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    normalize(arg0: Vec4f_): this;
    set(arg0: number): this;
    rotateY(arg0: number): this;
    hashCode(): number;
    set(arg0: Internal.Vector2fc_, arg1: number, arg2: number): this;
    distance(arg0: number, arg1: number, arg2: number, arg3: number): number;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    "set(org.joml.Vector4dc)"(arg0: Internal.Vector4dc_): this;
    set(arg0: number): this;
    equals(arg0: any): boolean;
    mul(arg0: Internal.Matrix4fc_): this;
    "set(float[])"(arg0: number[]): this;
    "set(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): this;
    normalize(arg0: number, arg1: Vec4f_): this;
    get class(): typeof any
    set "(org.joml.Vector4ic)"(arg0: Internal.Vector4ic_)
    set "(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    set "(org.joml.Vector4fc)"(arg0: Internal.Vector4fc_)
    set "(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set "(float)"(arg0: number)
    get finite(): boolean
    set fromAddress(arg0: number)
    set "(double)"(arg0: number)
    set "(org.joml.Vector4dc)"(arg0: Internal.Vector4dc_)
    set "(float[])"(arg0: number[])
    z: number;
    y: number;
    x: number;
    w: number;
}
type Vec4f_ = Vec4f;
declare interface UUID {
    toString(id: Internal.UUID_): string;
    digits(sb: Internal.StringBuilder_, val: number, digits: number): void;
    fromString(o: any): Internal.UUID;
}
type UUID_ = UUID;
declare const UUID: UUID;
/**
 * Various Ingredient related helper methods
*/
declare interface Ingredient {
    static of(ingredient: Internal.Ingredient_, count: number): Internal.Ingredient;
    /**
     * Returns an ingredient of the input
    */
    of(ingredient: Internal.Ingredient_): Internal.Ingredient;
    /**
     * Returns an ingredient of the input, with the specified count
    */
    of(ingredient: Internal.Ingredient_, count: number): InputItem;
    /**
     * Make a custom ingredient where a match must match the provided predicate function
    */
    custom(predicate: Internal.Predicate_<Internal.ItemStack>): Internal.Ingredient;
    /**
     * Register a custom ingredient action for use in recipes with Recipe#customIngredientAction
    */
    registerCustomIngredientAction(id: string, callback: Internal.CustomIngredientActionCallback_): void;
    /**
     * Make a custom ingredient where items must match both the parent ingredient and the custom predicate function
    */
    custom(parent: Internal.Ingredient_, predicate: Internal.Predicate_<Internal.ItemStack>): Internal.Ingredient;
    static of(ingredient: Internal.Ingredient_): Internal.Ingredient;
    /**
     * Checks if the passed in object is an Ingredient.
     * Note that this does not mean it will not function as an Ingredient if passed to something that requests one.
    */
    isIngredient(o: any): boolean;
    /**
     * Make a custom ingredient where an item must match both the parent ingredient and the item's nbt must match the custom predicate function
    */
    customNBT(in_: Internal.Ingredient_, predicate: Internal.Predicate_<Internal.CompoundTag>): Internal.Ingredient;
    /**
     * An ingredient that matches everything
    */
    readonly all: (Internal.WildcardIngredient) & (Internal.Ingredient);
    /**
     * A completely empty ingredient that will only match air
    */
    readonly none: (Internal.Ingredient) & (Internal.Ingredient);
}
type Ingredient_ = Ingredient;
declare const Ingredient: Ingredient;
declare class JavaMath {
    static "nextUp(float)"(arg0: number): number;
    static asin(arg0: number): number;
    static expm1(arg0: number): number;
    static ceil(arg0: number): number;
    static nextAfter(arg0: number, arg1: number): number;
    static exp(arg0: number): number;
    static "decrementExact(long)"(arg0: number): number;
    static "floorMod(long,int)"(arg0: number, arg1: number): number;
    static "incrementExact(int)"(arg0: number): number;
    static copySign(arg0: number, arg1: number): number;
    static ulp(arg0: number): number;
    static max(arg0: number, arg1: number): number;
    static "copySign(float,float)"(arg0: number, arg1: number): number;
    static "abs(float)"(arg0: number): number;
    static "negateExact(int)"(arg0: number): number;
    static "fma(double,double,double)"(arg0: number, arg1: number, arg2: number): number;
    static "min(double,double)"(arg0: number, arg1: number): number;
    static fma(arg0: number, arg1: number, arg2: number): number;
    static round(arg0: number): number;
    static round(arg0: number): number;
    static hypot(arg0: number, arg1: number): number;
    static "scalb(float,int)"(arg0: number, arg1: number): number;
    static abs(arg0: number): number;
    static "subtractExact(long,long)"(arg0: number, arg1: number): number;
    static "floorDiv(long,long)"(arg0: number, arg1: number): number;
    static floorMod(arg0: number, arg1: number): number;
    static log(arg0: number): number;
    static signum(arg0: number): number;
    static "max(float,float)"(arg0: number, arg1: number): number;
    static "nextAfter(double,double)"(arg0: number, arg1: number): number;
    static cos(arg0: number): number;
    getClass(): typeof any;
    static min(arg0: number, arg1: number): number;
    static nextUp(arg0: number): number;
    static "min(int,int)"(arg0: number, arg1: number): number;
    static "floorMod(int,int)"(arg0: number, arg1: number): number;
    static "max(long,long)"(arg0: number, arg1: number): number;
    static "fma(float,float,float)"(arg0: number, arg1: number, arg2: number): number;
    static "nextDown(double)"(arg0: number): number;
    static atan2(arg0: number, arg1: number): number;
    static cosh(arg0: number): number;
    static "round(float)"(arg0: number): number;
    static toIntExact(arg0: number): number;
    static decrementExact(arg0: number): number;
    static "floorDiv(int,int)"(arg0: number, arg1: number): number;
    static sinh(arg0: number): number;
    static toDegrees(arg0: number): number;
    static "multiplyExact(long,long)"(arg0: number, arg1: number): number;
    static max(arg0: number, arg1: number): number;
    static nextAfter(arg0: number, arg1: number): number;
    static "scalb(double,int)"(arg0: number, arg1: number): number;
    static "decrementExact(int)"(arg0: number): number;
    static tanh(arg0: number): number;
    toString(): string;
    static "negateExact(long)"(arg0: number): number;
    static "nextUp(double)"(arg0: number): number;
    notifyAll(): void;
    static floorMod(arg0: number, arg1: number): number;
    static "min(long,long)"(arg0: number, arg1: number): number;
    static nextDown(arg0: number): number;
    static "absExact(long)"(arg0: number): number;
    static "addExact(int,int)"(arg0: number, arg1: number): number;
    static pow(arg0: number, arg1: number): number;
    static absExact(arg0: number): number;
    static scalb(arg0: number, arg1: number): number;
    wait(arg0: number): void;
    static "abs(int)"(arg0: number): number;
    static addExact(arg0: number, arg1: number): number;
    static atan(arg0: number): number;
    static "addExact(long,long)"(arg0: number, arg1: number): number;
    static min(arg0: number, arg1: number): number;
    notify(): void;
    static multiplyExact(arg0: number, arg1: number): number;
    static "ulp(float)"(arg0: number): number;
    static floorDiv(arg0: number, arg1: number): number;
    static random(): number;
    static "ulp(double)"(arg0: number): number;
    static nextUp(arg0: number): number;
    static sqrt(arg0: number): number;
    static "multiplyExact(int,int)"(arg0: number, arg1: number): number;
    static "copySign(double,double)"(arg0: number, arg1: number): number;
    static "abs(double)"(arg0: number): number;
    static "subtractExact(int,int)"(arg0: number, arg1: number): number;
    static min(arg0: number, arg1: number): number;
    static fma(arg0: number, arg1: number, arg2: number): number;
    static addExact(arg0: number, arg1: number): number;
    static multiplyExact(arg0: number, arg1: number): number;
    static abs(arg0: number): number;
    static "floorMod(long,long)"(arg0: number, arg1: number): number;
    static floor(arg0: number): number;
    static subtractExact(arg0: number, arg1: number): number;
    static "abs(long)"(arg0: number): number;
    static rint(arg0: number): number;
    static "min(float,float)"(arg0: number, arg1: number): number;
    static "max(int,int)"(arg0: number, arg1: number): number;
    static signum(arg0: number): number;
    static absExact(arg0: number): number;
    wait(): void;
    static log10(arg0: number): number;
    static abs(arg0: number): number;
    static floorDiv(arg0: number, arg1: number): number;
    static floorDiv(arg0: number, arg1: number): number;
    static tan(arg0: number): number;
    static floorMod(arg0: number, arg1: number): number;
    static ulp(arg0: number): number;
    static sin(arg0: number): number;
    static min(arg0: number, arg1: number): number;
    wait(arg0: number, arg1: number): void;
    static max(arg0: number, arg1: number): number;
    static "max(double,double)"(arg0: number, arg1: number): number;
    static toRadians(arg0: number): number;
    static "multiplyExact(long,int)"(arg0: number, arg1: number): number;
    static incrementExact(arg0: number): number;
    static negateExact(arg0: number): number;
    static max(arg0: number, arg1: number): number;
    static incrementExact(arg0: number): number;
    static decrementExact(arg0: number): number;
    static copySign(arg0: number, arg1: number): number;
    static negateExact(arg0: number): number;
    static "getExponent(float)"(arg0: number): number;
    static "incrementExact(long)"(arg0: number): number;
    static "signum(float)"(arg0: number): number;
    static nextDown(arg0: number): number;
    static "nextAfter(float,double)"(arg0: number, arg1: number): number;
    static IEEEremainder(arg0: number, arg1: number): number;
    static "round(double)"(arg0: number): number;
    static abs(arg0: number): number;
    static getExponent(arg0: number): number;
    static "getExponent(double)"(arg0: number): number;
    static scalb(arg0: number, arg1: number): number;
    static multiplyHigh(arg0: number, arg1: number): number;
    static multiplyFull(arg0: number, arg1: number): number;
    hashCode(): number;
    static multiplyExact(arg0: number, arg1: number): number;
    static getExponent(arg0: number): number;
    static "floorDiv(long,int)"(arg0: number, arg1: number): number;
    static cbrt(arg0: number): number;
    static acos(arg0: number): number;
    static log1p(arg0: number): number;
    static "nextDown(float)"(arg0: number): number;
    equals(arg0: any): boolean;
    static "signum(double)"(arg0: number): number;
    static "absExact(int)"(arg0: number): number;
    static subtractExact(arg0: number, arg1: number): number;
    get class(): typeof any
    static readonly PI: (3.141592653589793) & (number);
    static readonly E: (2.718281828459045) & (number);
}
type JavaMath_ = JavaMath;
declare interface NBT {
    accessTagMap(tag: Internal.CompoundTag_): Internal.Map<string, Internal.Tag>;
    read(buf: Internal.FriendlyByteBuf_): Internal.OrderedCompoundTag;
    toJson(t: Internal.Tag_): Internal.JsonElement;
    toTagCollection(c: Internal.Collection_<any>): Internal.CollectionTag<any>;
    l(v: number): Internal.Tag;
    quoteAndEscapeForJS(stringBuilder: Internal.StringBuilder_, string: string): void;
    b(v: number): Internal.Tag;
    byteArrayTag(v: number[]): Internal.Tag;
    listTag(): Internal.Tag;
    floatTag(v: number): Internal.Tag;
    s(v: number): Internal.Tag;
    byteTag(v: number): Internal.Tag;
    listTag(list: Internal.List_<any>): Internal.Tag;
    ia(v: number[]): Internal.Tag;
    d(v: number): Internal.Tag;
    longArrayTag(v: number[]): Internal.Tag;
    isTagCollection(o: any): boolean;
    "toTagCollection(java.util.Collection)"(c: Internal.Collection_<any>): Internal.CollectionTag<any>;
    longTag(v: number): Internal.Tag;
    compoundTag(): Internal.Tag;
    intTag(v: number): Internal.Tag;
    shortTag(v: number): Internal.Tag;
    la(v: number[]): Internal.Tag;
    stringTag(v: string): Internal.Tag;
    convertType(tagType: Internal.TagType_<any>): Internal.TagType<any>;
    toTagCollection(v: any): Internal.CollectionTag<any>;
    f(v: number): Internal.Tag;
    toTag(v: any): Internal.Tag;
    fromTag(t: Internal.Tag_): any;
    toTagList(list: any): Internal.ListTag;
    toTagCompound(v: any): Internal.CompoundTag;
    isTagCompound(o: any): boolean;
    doubleTag(v: number): Internal.Tag;
    intArrayTag(v: number[]): Internal.Tag;
    compoundTag(map: Internal.Map_<any, any>): Internal.Tag;
    ba(v: number[]): Internal.Tag;
    i(v: number): Internal.Tag;
    "toTagCollection(java.lang.Object)"(v: any): Internal.CollectionTag<any>;
    readonly VALUE_UNWRAPPER: Internal.ValueUnwrapper;
    readonly LIST_TYPE: Internal.TagType<Internal.ListTag>;
    readonly COMPOUND_TYPE: Internal.TagType<Internal.OrderedCompoundTag>;
}
type NBT_ = NBT;
declare const NBT: NBT;
declare interface FluidAmounts {
    readonly MILLIBUCKET: (1) & (number);
    readonly MB: (1) & (number);
    readonly INGOT: (90) & (number);
    readonly BOTTLE: (250) & (number);
    readonly B: (1000) & (number);
    readonly NUGGET: (10) & (number);
    readonly METAL_BLOCK: (810) & (number);
    readonly BUCKET: (1000) & (number);
}
type FluidAmounts_ = FluidAmounts;
declare const FluidAmounts: FluidAmounts;
declare class Matrix3f implements Internal.Cloneable, Internal.Matrix3fc, Internal.Externalizable {
    constructor(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_)
    constructor()
    constructor(arg0: Internal.Matrix3fc_)
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: Internal.Matrix2fc_)
    constructor(arg0: Internal.Matrix4fc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number)
    rotateLocalY(arg0: number, arg1: Matrix3f_): this;
    setColumn(arg0: number, arg1: Internal.Vector3fc_): this;
    mapnZnXY(): this;
    rotate(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    getEulerAnglesXYZ(arg0: Vec3f_): Vec3f;
    mapZXnY(): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapYXnZ(arg0: Matrix3f_): this;
    "getUnnormalizedRotation(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    mapnYnXZ(arg0: Matrix3f_): this;
    "scale(float)"(arg0: number): this;
    "getTransposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix3f_): this;
    mapYnXnZ(arg0: Matrix3f_): this;
    "getNormalizedRotation(org.joml.Quaternionf)"(arg0: Quaternionf_): Quaternionf;
    "set(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): this;
    getUnnormalizedRotation(arg0: Quaternionf_): Quaternionf;
    negateZ(arg0: Matrix3f_): this;
    "get(int,int)"(arg0: number, arg1: number): number;
    mapXnYnZ(): this;
    mapnYnZX(): this;
    m20(arg0: number): this;
    set(arg0: Internal.Matrix4fc_): this;
    rotationZ(arg0: number): this;
    mapnYnXnZ(arg0: Matrix3f_): this;
    transformTranspose(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZYnX(): this;
    sub(arg0: Internal.Matrix3fc_): this;
    setLookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "rotate(float,org.joml.Vector3fc)"(arg0: number, arg1: Internal.Vector3fc_): this;
    getNormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    "get(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    setColumn(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnYnZnX(): this;
    getRowColumn(arg0: number, arg1: number): number;
    positiveZ(arg0: Vec3f_): Vec3f;
    mapnYZX(arg0: Matrix3f_): this;
    mapnXnZY(arg0: Matrix3f_): this;
    rotateZ(arg0: number, arg1: Matrix3f_): this;
    mapXZY(arg0: Matrix3f_): this;
    mapYZnX(): this;
    mapnZnYX(arg0: Matrix3f_): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    rotateLocalZ(arg0: number, arg1: Matrix3f_): this;
    getClass(): typeof any;
    rotateLocal(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    setLookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    mapZYX(): this;
    mapYnZnX(): this;
    mapnXnYnZ(): this;
    obliqueZ(arg0: number, arg1: number, arg2: Matrix3f_): this;
    scale(arg0: number): this;
    set(arg0: Internal.Matrix3fc_): this;
    m20(): number;
    reflect(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    mapnXnYZ(): this;
    "rotate(org.joml.AxisAngle4f,org.joml.Matrix3f)"(arg0: Internal.AxisAngle4f_, arg1: Matrix3f_): this;
    get(arg0: Matrix4f_): Matrix4f;
    rotation(arg0: number, arg1: Internal.Vector3fc_): this;
    set(arg0: Internal.AxisAngle4d_): this;
    mul(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    rotate(arg0: Internal.AxisAngle4f_): this;
    rotationXYZ(arg0: number, arg1: number, arg2: number): this;
    m21(arg0: number): this;
    rotationY(arg0: number): this;
    "get3x4(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnXYnZ(): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number): this;
    getTransposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapZnYX(): this;
    cofactor(arg0: Matrix3f_): this;
    mapnYZnX(arg0: Matrix3f_): this;
    set(arg0: Internal.ByteBuffer_): this;
    setTransposed(arg0: Internal.Matrix3fc_): this;
    getScale(arg0: Vec3f_): Vec3f;
    mapXnZY(arg0: Matrix3f_): this;
    transform(arg0: Vec3f_): Vec3f;
    rotateY(arg0: number, arg1: Matrix3f_): this;
    mapYnZX(): this;
    "scale(org.joml.Vector3fc,org.joml.Matrix3f)"(arg0: Internal.Vector3fc_, arg1: Matrix3f_): this;
    mapnXZY(arg0: Matrix3f_): this;
    "scale(float,org.joml.Matrix3f)"(arg0: number, arg1: Matrix3f_): this;
    wait(arg0: number): void;
    set(arg0: Internal.Quaterniondc_): this;
    scale(arg0: Internal.Vector3fc_): this;
    normal(arg0: Matrix3f_): this;
    mapZYnX(): this;
    rotation(arg0: number, arg1: number, arg2: number, arg3: number): this;
    setRow(arg0: number, arg1: Internal.Vector3fc_): this;
    scaling(arg0: number, arg1: number, arg2: number): this;
    set(arg0: number, arg1: number, arg2: number): this;
    reflect(arg0: Internal.Quaternionfc_): this;
    rotateLocalY(arg0: number): this;
    "get(org.joml.Matrix3f)"(arg0: Matrix3f_): this;
    rotationTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    set(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    m21(): number;
    sub(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    set(arg0: Internal.AxisAngle4f_): this;
    isFinite(): boolean;
    get3x4(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnYZX(): this;
    mapZnYX(arg0: Matrix3f_): this;
    transpose(arg0: Matrix3f_): this;
    rotation(arg0: Internal.Quaternionfc_): this;
    mapnXnYZ(arg0: Matrix3f_): this;
    mapnXnZnY(): this;
    "set(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    m10(): number;
    mapXnZnY(): this;
    "set(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    mapZXY(arg0: Matrix3f_): this;
    rotationX(arg0: number): this;
    rotate(arg0: Internal.AxisAngle4f_, arg1: Matrix3f_): this;
    mapYnXZ(): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Matrix3f_): this;
    reflect(arg0: number, arg1: number, arg2: number): this;
    getToAddress(arg0: number): Internal.Matrix3fc;
    get(arg0: number, arg1: number): number;
    setRow(arg0: number, arg1: number, arg2: number, arg3: number): this;
    wait(): void;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    get3x4(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.FloatBuffer_): this;
    mapnZnXnY(arg0: Matrix3f_): this;
    mapXZnY(arg0: Matrix3f_): this;
    rotateLocalX(arg0: number, arg1: Matrix3f_): this;
    mulLocal(arg0: Internal.Matrix3fc_): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    transform(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    mapnYXnZ(arg0: Matrix3f_): this;
    transformTranspose(arg0: Vec3f_): Vec3f;
    "rotation(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    rotateLocalZ(arg0: number): this;
    m22(): number;
    lerp(arg0: Internal.Matrix3fc_, arg1: number, arg2: Matrix3f_): this;
    mapYXnZ(): this;
    mapZnYnX(arg0: Matrix3f_): this;
    "rotation(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    mapYXZ(arg0: Matrix3f_): this;
    reflection(arg0: number, arg1: number, arg2: number): this;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "getTransposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapnZXnY(): this;
    invert(): this;
    m11(): number;
    getTransposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapZnXnY(arg0: Matrix3f_): this;
    rotateXYZ(arg0: Vec3f_): this;
    rotate(arg0: number, arg1: Internal.Vector3fc_): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnXnZY(): this;
    getNormalizedRotation(arg0: Quaternionf_): Quaternionf;
    negateZ(): this;
    mapnZnYnX(arg0: Matrix3f_): this;
    equals(arg0: any): boolean;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix3f_): this;
    mapXZY(): this;
    m00(): number;
    mapYnZX(arg0: Matrix3f_): this;
    "set(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_): this;
    "scaling(float)"(arg0: number): this;
    get3x4(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnZXY(): this;
    "scaling(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    scale(arg0: number, arg1: number, arg2: number): this;
    "reflect(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    identity(): this;
    scaling(arg0: Internal.Vector3fc_): this;
    mulLocal(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    mapXZnY(): this;
    "get3x4(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    reflect(arg0: Internal.Vector3fc_): this;
    "getNormalizedRotation(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    mul(arg0: Internal.Matrix3fc_): this;
    setFromAddress(arg0: number): this;
    mapnZnYnX(): this;
    m01(arg0: number): this;
    "set(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    rotate(arg0: Internal.Quaternionfc_): this;
    m12(): number;
    get3x4(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapZnYnX(): this;
    mapnZYnX(arg0: Matrix3f_): this;
    normal(): this;
    mapZYnX(arg0: Matrix3f_): this;
    scaleLocal(arg0: number, arg1: number, arg2: number): this;
    mapnXZY(): this;
    "get(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    normalizedPositiveX(arg0: Vec3f_): Vec3f;
    "rotate(org.joml.Quaternionfc,org.joml.Matrix3f)"(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    get(arg0: number[]): number[];
    getColumn(arg0: number, arg1: Vec3f_): Vec3f;
    negateY(): this;
    toString(arg0: Internal.NumberFormat_): string;
    "get(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnXYnZ(arg0: Matrix3f_): this;
    mapnYXnZ(): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number): this;
    get(arg0: number[], arg1: number): number[];
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix3f_): this;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    mapnXnYnZ(arg0: Matrix3f_): this;
    mapZYX(arg0: Matrix3f_): this;
    "scale(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    m12(arg0: number): this;
    clone(): any;
    m01(): number;
    mapnYnZX(arg0: Matrix3f_): this;
    quadraticFormProduct(arg0: Internal.Vector3fc_): number;
    setRowColumn(arg0: number, arg1: number, arg2: number): this;
    "set(int,int,float)"(arg0: number, arg1: number, arg2: number): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    getRotation(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    "get(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    reflection(arg0: Internal.Quaternionfc_): this;
    mapnYnZnX(arg0: Matrix3f_): this;
    transformTranspose(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    rotateZYX(arg0: Vec3f_): this;
    rotateLocalX(arg0: number): this;
    mapnZnXnY(): this;
    "reflection(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    m02(arg0: number): this;
    getTransposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    scale(arg0: Internal.Vector3fc_, arg1: Matrix3f_): this;
    rotationTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZnXY(arg0: Matrix3f_): this;
    mapnYnXZ(): this;
    mapnXZnY(): this;
    mapYZX(): this;
    "get3x4(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapnYXZ(): this;
    mulComponentWise(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    mapZXnY(arg0: Matrix3f_): this;
    rotationYXZ(arg0: number, arg1: number, arg2: number): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    negateX(): this;
    "set(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    "set(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): this;
    toString(): string;
    rotateLocal(arg0: Internal.Quaternionfc_): this;
    mapnZYX(arg0: Matrix3f_): this;
    normalizedPositiveY(arg0: Vec3f_): Vec3f;
    notifyAll(): void;
    mapYZnX(arg0: Matrix3f_): this;
    mapnZnYX(): this;
    "set(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    getRow(arg0: number, arg1: Vec3f_): Vec3f;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix3f_): this;
    mapnZXnY(arg0: Matrix3f_): this;
    mapZnXY(arg0: Matrix3f_): this;
    "reflect(org.joml.Vector3fc,org.joml.Matrix3f)"(arg0: Internal.Vector3fc_, arg1: Matrix3f_): this;
    reflection(arg0: Internal.Vector3fc_): this;
    rotateX(arg0: number): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix3f_): this;
    mapnXZnY(arg0: Matrix3f_): this;
    "rotate(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    mapYXZ(): this;
    setSkewSymmetric(arg0: number, arg1: number, arg2: number): this;
    "rotate(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    rotateZYX(arg0: number, arg1: number, arg2: number): this;
    notify(): void;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number): this;
    m02(): number;
    mapZnXnY(): this;
    "set(org.joml.Vector3fc,org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "set(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    negateX(arg0: Matrix3f_): this;
    mapnYZnX(): this;
    m22(arg0: number): this;
    mulComponentWise(arg0: Internal.Matrix3fc_): this;
    normalizedPositiveZ(arg0: Vec3f_): Vec3f;
    invert(arg0: Matrix3f_): this;
    reflect(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    "getTransposed(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    readExternal(arg0: Internal.ObjectInput_): void;
    mapnZYX(): this;
    scaleLocal(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    getEulerAnglesZYX(arg0: Vec3f_): Vec3f;
    get(arg0: Matrix3f_): this;
    "get(float[],int)"(arg0: number[], arg1: number): number[];
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotateX(arg0: number, arg1: Matrix3f_): this;
    positiveX(arg0: Vec3f_): Vec3f;
    "getTransposed(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    rotateYXZ(arg0: Vec3f_): this;
    determinant(): number;
    add(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    transpose(): this;
    "set(float[])"(arg0: number[]): this;
    "reflect(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    m10(arg0: number): this;
    mapYnZnX(arg0: Matrix3f_): this;
    "set(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): this;
    rotateY(arg0: number): this;
    rotation(arg0: Internal.AxisAngle4f_): this;
    "reflect(org.joml.Quaternionfc,org.joml.Matrix3f)"(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    add(arg0: Internal.Matrix3fc_): this;
    scale(arg0: number, arg1: Matrix3f_): this;
    lerp(arg0: Internal.Matrix3fc_, arg1: number): this;
    rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    mapYnXZ(arg0: Matrix3f_): this;
    mapnZXY(arg0: Matrix3f_): this;
    "get3x4(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    scale(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    mapZnXY(): this;
    wait(arg0: number, arg1: number): void;
    cofactor(): this;
    mapnYnXnZ(): this;
    quadraticFormProduct(arg0: number, arg1: number, arg2: number): number;
    "get(float[])"(arg0: number[]): number[];
    "set(org.joml.Matrix2fc)"(arg0: Internal.Matrix2fc_): this;
    "set(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix3f_): this;
    swap(arg0: Matrix3f_): this;
    mapXnZnY(arg0: Matrix3f_): this;
    set(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "reflection(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    obliqueZ(arg0: number, arg1: number): this;
    negateY(arg0: Matrix3f_): this;
    getUnnormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    rotate(arg0: number, arg1: Internal.Vector3fc_, arg2: Matrix3f_): this;
    getTransposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    m00(arg0: number): this;
    mapXnYnZ(arg0: Matrix3f_): this;
    mapXnZY(): this;
    "get(org.joml.Matrix4f)"(arg0: Matrix4f_): Matrix4f;
    equals(arg0: Internal.Matrix3fc_, arg1: number): boolean;
    mapYZX(arg0: Matrix3f_): this;
    set(arg0: Internal.Matrix4x3fc_): this;
    set(arg0: Internal.Matrix2fc_): this;
    mapnXnZnY(arg0: Matrix3f_): this;
    rotateZ(arg0: number): this;
    "getUnnormalizedRotation(org.joml.Quaternionf)"(arg0: Quaternionf_): Quaternionf;
    hashCode(): number;
    rotationZYX(arg0: number, arg1: number, arg2: number): this;
    positiveY(arg0: Vec3f_): Vec3f;
    mapYnXnZ(): this;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    mapZXY(): this;
    mapnYXZ(arg0: Matrix3f_): this;
    scaling(arg0: number): this;
    set(arg0: number[]): this;
    zero(): this;
    set(arg0: Internal.Quaternionfc_): this;
    m11(arg0: number): this;
    set "(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_)
    get class(): typeof any
    set transposed(arg0: Internal.Matrix3fc_)
    get finite(): boolean
    set "(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_)
    set "(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set "(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_)
    set fromAddress(arg0: number)
    set "(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_)
    set "(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set "(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_)
    set "(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_)
    set "(float[])"(arg0: number[])
    set "(org.joml.Matrix2fc)"(arg0: Internal.Matrix2fc_)
    set "(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    m10: number;
    m21: number;
    m20: number;
    m01: number;
    m12: number;
    m00: number;
    m11: number;
    m22: number;
    m02: number;
}
type Matrix3f_ = Matrix3f;
declare class Matrix4f implements Internal.Cloneable, Internal.Matrix4fc, Internal.Externalizable {
    constructor()
    constructor(arg0: Internal.Matrix3fc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number)
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: Internal.Matrix4dc_)
    constructor(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Internal.Vector4fc_, arg3: Internal.Vector4fc_)
    constructor(arg0: Internal.Matrix4fc_)
    constructor(arg0: Internal.Matrix4x3fc_)
    scaleXY(arg0: number, arg1: number, arg2: Matrix4f_): this;
    setLookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    rotateAffineXYZ(arg0: number, arg1: number, arg2: number): this;
    translationRotateScale(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
    transformProject(arg0: Internal.Vector4fc_, arg1: Vec3f_): Vec3f;
    testSphere(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
    zero(): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number): this;
    m32(arg0: number): this;
    "get4x3(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    obliqueZ(arg0: number, arg1: number, arg2: Matrix4f_): this;
    "orthoLH(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    setTransposedFromAddress(arg0: number): this;
    mapYXnZ(arg0: Matrix4f_): this;
    "get(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "perspectiveRect(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    getRowColumn(arg0: number, arg1: number): number;
    "normalize3x3(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    "unprojectInv(float,float,float,int[],org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    "set(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    billboardSpherical(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "set(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): this;
    lookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: Matrix4f_): this;
    "mulPerspectiveAffine(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    "normal(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    "project(org.joml.Vector3fc,int[],org.joml.Vector4f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    rotateX(arg0: number, arg1: Matrix4f_): this;
    mul0(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    m10(arg0: number): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    mapZYnX(): this;
    rotateLocalY(arg0: number, arg1: Matrix4f_): this;
    set(arg0: Internal.Matrix3fc_): this;
    invertAffine(arg0: Matrix4f_): this;
    arcball(arg0: number, arg1: Internal.Vector3fc_, arg2: number, arg3: number, arg4: Matrix4f_): this;
    m32(): number;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number): this;
    unproject(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    "frustumLH(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapZnYX(): this;
    mapYnXnZ(arg0: Matrix4f_): this;
    shadow(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number): this;
    normal(arg0: Matrix3f_): Matrix3f;
    m21(arg0: number): this;
    lerp(arg0: Internal.Matrix4fc_, arg1: number, arg2: Matrix4f_): this;
    rotationY(arg0: number): this;
    getRotation(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
    rotate(arg0: Internal.AxisAngle4f_, arg1: Matrix4f_): this;
    tile(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "unproject(org.joml.Vector3fc,int[],org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    "ortho(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    m21(): number;
    isFinite(): boolean;
    transformProject(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    m30(arg0: number): this;
    setRotationYXZ(arg0: number, arg1: number, arg2: number): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    mul(arg0: Internal.Matrix4fc_): this;
    m10(): number;
    rotateAffineZYX(arg0: number, arg1: number, arg2: number): this;
    set(arg0: number, arg1: number, arg2: number): this;
    mapnZnXnY(): this;
    setPerspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    "get3x3(org.joml.Matrix3d)"(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    mapYXZ(arg0: Matrix4f_): this;
    "get4x3Transposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotation(arg0: Internal.Quaternionfc_): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    rotateAffine(arg0: Internal.Quaternionfc_): this;
    get4x3Transposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    transpose3x3(arg0: Matrix3f_): Matrix3f;
    translate(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): this;
    "transformProject(org.joml.Vector4fc,org.joml.Vector3f)"(arg0: Internal.Vector4fc_, arg1: Vec3f_): Vec3f;
    ortho2DLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    "set4x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    rotateTranslation(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    mapYZnX(): this;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    scaleLocal(arg0: number): this;
    rotateZ(arg0: number, arg1: Matrix4f_): this;
    setTransposed(arg0: Internal.FloatBuffer_): this;
    set(arg0: Internal.FloatBuffer_): this;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    unprojectInv(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    "getRow(int,org.joml.Vector4f)"(arg0: number, arg1: Vec4f_): Vec4f;
    perspectiveInvOrigin(arg0: Vec3f_): Vec3f;
    transformTranspose(arg0: Vec4f_): Vec4f;
    rotationTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    mapnYnXZ(arg0: Matrix4f_): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapZnYX(arg0: Matrix4f_): this;
    mapnZXnY(): this;
    "shadow(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    getToAddress(arg0: number): Internal.Matrix4fc;
    mapnXZY(): this;
    rotateAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number): this;
    transformProject(arg0: Vec4f_): Vec4f;
    "set(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    negateZ(): this;
    m23(): number;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    equals(arg0: Internal.Matrix4fc_, arg1: number): boolean;
    lookAtPerspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    lookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: Matrix4f_): this;
    setOrthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    "get4x3Transposed(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    m12(): number;
    mapnYnZX(arg0: Matrix4f_): this;
    "getColumn(int,org.joml.Vector4f)"(arg0: number, arg1: Vec4f_): Vec4f;
    translationRotate(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_): this;
    "reflect(org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "orthoSymmetricLH(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    normalizedPositiveX(arg0: Vec3f_): Vec3f;
    setFrustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    mapXZY(): this;
    transformDirection(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    getColumn(arg0: number, arg1: Vec3f_): Vec3f;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number): this;
    unprojectRay(arg0: Internal.Vector2fc_, arg1: number[], arg2: Vec3f_, arg3: Vec3f_): this;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    reflection(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "transformProject(float,float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    "mul(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    m01(arg0: number): this;
    mapYXnZ(): this;
    m01(): number;
    "get(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mul(arg0: Internal.Matrix3x2fc_, arg1: Matrix4f_): this;
    mapYZnX(arg0: Matrix4f_): this;
    "translationRotateScaleInvert(org.joml.Vector3fc,org.joml.Quaternionfc,float)"(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: number): this;
    translate(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    mapnZXnY(arg0: Matrix4f_): this;
    mapZnXY(arg0: Matrix4f_): this;
    transformAab(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Vec3f_, arg7: Vec3f_): this;
    invertOrtho(): this;
    "scaling(float)"(arg0: number): this;
    transform(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "get4x3Transposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    rotateLocalY(arg0: number): this;
    billboardCylindrical(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "scaling(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    getRow(arg0: number, arg1: Vec3f_): Vec3f;
    rotationTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    setPerspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "ortho(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    mapnYXZ(): this;
    setFromIntrinsic(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    negateX(): this;
    setColumn(arg0: number, arg1: Internal.Vector4fc_): this;
    fma4x3(arg0: Internal.Matrix4fc_, arg1: number, arg2: Matrix4f_): this;
    notify(): void;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    get4x3(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    translationRotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): this;
    rotateYXZ(arg0: Vec3f_): this;
    mapnYXZ(arg0: Matrix4f_): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "reflection(org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    normalizedPositiveZ(arg0: Vec3f_): Vec3f;
    cofactor3x3(arg0: Matrix4f_): this;
    setLookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "rotate(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    scale(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    translationRotateScaleMulAffine(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_, arg3: Matrix4f_): this;
    "orthoSymmetric(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    rotate(arg0: Internal.Quaternionfc_): this;
    invertOrtho(arg0: Matrix4f_): this;
    mapYZX(arg0: Matrix4f_): this;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    m03(): number;
    "get(float[])"(arg0: number[]): number[];
    translationRotateScaleMulAffine(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: Matrix4f_): this;
    unprojectInv(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    rotateYXZ(arg0: number, arg1: number, arg2: number): this;
    rotationZYX(arg0: number, arg1: number, arg2: number): this;
    cofactor3x3(): this;
    scaleXY(arg0: number, arg1: number): this;
    m12(arg0: number): this;
    rotation(arg0: Internal.AxisAngle4f_): this;
    translateLocal(arg0: Internal.Vector3fc_): this;
    rotateAffineYXZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    scaling(arg0: number): this;
    mapZnXY(): this;
    "setTransposed(float[])"(arg0: number[]): this;
    "unprojectInv(org.joml.Vector3fc,int[],org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    "transformProject(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    project(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    hashCode(): number;
    positiveY(arg0: Vec3f_): Vec3f;
    negateX(arg0: Matrix4f_): this;
    setOrtho2D(arg0: number, arg1: number, arg2: number, arg3: number): this;
    translation(arg0: Internal.Vector3fc_): this;
    translationRotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    m23(arg0: number): this;
    "set(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    "orthoSymmetric(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mul3x3(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    setRow(arg0: number, arg1: Internal.Vector4fc_): this;
    project(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    getEulerAnglesXYZ(arg0: Vec3f_): Vec3f;
    trapezoidCrop(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    transformPosition(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    translationRotate(arg0: number, arg1: number, arg2: number, arg3: Internal.Quaternionfc_): this;
    unprojectInvRay(arg0: number, arg1: number, arg2: number[], arg3: Vec3f_, arg4: Vec3f_): this;
    setOrtho2DLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapnZnYnX(arg0: Matrix4f_): this;
    "getNormalizedRotation(org.joml.Quaternionf)"(arg0: Quaternionf_): Quaternionf;
    "get(int,int)"(arg0: number, arg1: number): number;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    get4x3(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number, arg16: Matrix4f_): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4fc_): this;
    "transformProject(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    mapZYX(): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    get3x3(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
    mapnXnYnZ(): this;
    setTransposed(arg0: Internal.ByteBuffer_): this;
    getNormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    "frustum(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapZnYnX(arg0: Matrix4f_): this;
    positiveZ(arg0: Vec3f_): Vec3f;
    arcball(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    invertPerspective(): this;
    mapnYnZX(): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number): this;
    mapXnZY(arg0: Matrix4f_): this;
    translate(arg0: number, arg1: number, arg2: number): this;
    lerp(arg0: Internal.Matrix4fc_, arg1: number): this;
    "rotate(org.joml.Quaternionfc,org.joml.Matrix4f)"(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    mapnXYnZ(): this;
    lookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    mulLocal(arg0: Internal.Matrix4fc_): this;
    rotateXYZ(arg0: Internal.Vector3fc_): this;
    rotateLocal(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    shadow(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: Matrix4f_): this;
    mulLocalAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    set(arg0: number[], arg1: number): this;
    get3x3(arg0: Matrix3f_): Matrix3f;
    "mulPerspectiveAffine(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "set3x3(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    mapXnYnZ(): this;
    negateZ(arg0: Matrix4f_): this;
    transformProject(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    setOrtho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "set(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    "getColumn(int,org.joml.Vector3f)"(arg0: number, arg1: Vec3f_): Vec3f;
    mul(arg0: Internal.Matrix4x3fc_): this;
    setPerspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "project(float,float,float,int[],org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotateTowardsXY(arg0: number, arg1: number): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: Matrix4f_): this;
    setLookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    sub(arg0: Internal.Matrix4fc_): this;
    rotateLocalZ(arg0: number): this;
    scale(arg0: number): this;
    "transformProject(float,float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec3f_): Vec3f;
    m03(arg0: number): this;
    get(arg0: number, arg1: number): number;
    mapnYZX(): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    "translationRotateScale(org.joml.Vector3fc,org.joml.Quaternionfc,float)"(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: number): this;
    get3x4(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    setPerspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    invert(): this;
    transformTranspose(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    "setTransposed(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "get4x3Transposed(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    perspectiveNear(): number;
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapnYZX(arg0: Matrix4f_): this;
    mulLocalAffine(arg0: Internal.Matrix4fc_): this;
    "getTransposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotateAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number): this;
    shadow(arg0: Vec4f_, arg1: Matrix4f_): this;
    "scale(org.joml.Vector3fc,org.joml.Matrix4f)"(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    perspectiveOrigin(arg0: Vec3f_): Vec3f;
    frustumAabb(arg0: Vec3f_, arg1: Vec3f_): this;
    "set(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_): this;
    getNormalizedRotation(arg0: Quaternionf_): Quaternionf;
    "rotation(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    mulLocal(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    "set(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    "mul(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    setTranslation(arg0: Internal.Vector3fc_): this;
    mapXnYnZ(arg0: Matrix4f_): this;
    setPerspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    isAffine(): boolean;
    "scale(float,org.joml.Matrix4f)"(arg0: number, arg1: Matrix4f_): this;
    get3x4(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    arcball(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapYnXnZ(): this;
    "get3x4(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Internal.Vector4fc_, arg3: Internal.Vector4fc_): this;
    mul4x3ComponentWise(arg0: Internal.Matrix4fc_): this;
    rotateAffine(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "getNormalizedRotation(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    rotateX(arg0: number): this;
    invertFrustum(): this;
    rotateAffineYXZ(arg0: number, arg1: number, arg2: number): this;
    "set(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    mapnYnZnX(arg0: Matrix4f_): this;
    "get(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    "invertPerspectiveView(org.joml.Matrix4x3fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    mapnYnXnZ(): this;
    identity(): this;
    set4x3(arg0: Internal.Matrix4x3fc_): this;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number): this;
    translateLocal(arg0: number, arg1: number, arg2: number): this;
    clone(): any;
    mul4x3ComponentWise(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    invert(arg0: Matrix4f_): this;
    mapZnYnX(): this;
    frustumRayDir(arg0: number, arg1: number, arg2: Vec3f_): Vec3f;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZnYX(): this;
    "mulPerspectiveAffine(org.joml.Matrix4x3fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    translationRotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "mul(org.joml.Matrix3x2fc,org.joml.Matrix4f)"(arg0: Internal.Matrix3x2fc_, arg1: Matrix4f_): this;
    getTransposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    sub4x3(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4x3fc_): this;
    transformProject(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    properties(): number;
    translationRotateScaleInvert(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: number): this;
    "unproject(float,float,float,int[],org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    toString(): string;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    translationRotateInvert(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_): this;
    mapnYnXZ(): this;
    mulOrthoAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    mapnZnXY(arg0: Matrix4f_): this;
    "perspectiveOffCenterFovLH(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    translateLocal(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    unproject(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    mapnZnYnX(): this;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    pick(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number[]): this;
    normalize3x3(arg0: Matrix3f_): Matrix3f;
    scaleLocal(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    unproject(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    scaleLocal(arg0: number, arg1: Matrix4f_): this;
    reflect(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
    "perspectiveOffCenter(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    rotateZ(arg0: number): this;
    rotateLocalZ(arg0: number, arg1: Matrix4f_): this;
    scale(arg0: number, arg1: Matrix4f_): this;
    "get3x3(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    "invertPerspectiveView(org.joml.Matrix4fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    scale(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    "rotate(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    ortho2D(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapYnZnX(): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    "set(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    arcball(arg0: number, arg1: Internal.Vector3fc_, arg2: number, arg3: number): this;
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    reflection(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
    testPoint(arg0: number, arg1: number, arg2: number): boolean;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    perspectiveFov(): number;
    "get4x3(org.joml.Matrix4x3f)"(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
    mapZYnX(arg0: Matrix4f_): this;
    mapZXY(): this;
    "get4x3(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    "get4x3(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "transpose3x3(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    mapnXYnZ(arg0: Matrix4f_): this;
    withLookAtUp(arg0: number, arg1: number, arg2: number): this;
    withLookAtUp(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    mapnYnZnX(): this;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    mapYnZnX(arg0: Matrix4f_): this;
    mapnXnYnZ(arg0: Matrix4f_): this;
    mapnZnYX(arg0: Matrix4f_): this;
    origin(arg0: Vec3f_): Vec3f;
    getTransposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    determinantAffine(): number;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    rotateAroundLocal(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number): this;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    obliqueZ(arg0: number, arg1: number): this;
    "mul(org.joml.Matrix4x3fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    "perspective(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    ortho2DLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnZYnX(): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    lookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    mul3x3(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    get(arg0: Internal.Matrix4d_): Internal.Matrix4d;
    pick(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number[], arg5: Matrix4f_): this;
    tile(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    rotateY(arg0: number, arg1: Matrix4f_): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    "orthoLH(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    getUnnormalizedRotation(arg0: Quaternionf_): Quaternionf;
    rotateAffine(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    mapXZnY(arg0: Matrix4f_): this;
    rotateLocalX(arg0: number, arg1: Matrix4f_): this;
    reflection(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZXY(arg0: Matrix4f_): this;
    mapnYXnZ(arg0: Matrix4f_): this;
    mapZXnY(): this;
    m31(): number;
    transformAffine(arg0: Vec4f_): Vec4f;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    get4x3Transposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "scale(float)"(arg0: number): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    m20(arg0: number): this;
    reflection(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotationZ(arg0: number): this;
    static perspectiveOffCenterViewFromRectangle(arg0: Vec3f_, arg1: Vec3f_, arg2: Vec3f_, arg3: Vec3f_, arg4: number, arg5: boolean, arg6: Matrix4f_, arg7: Matrix4f_): void;
    mapZXY(arg0: Matrix4f_): this;
    cofactor3x3(arg0: Matrix3f_): Matrix3f;
    mapnYnXnZ(arg0: Matrix4f_): this;
    "getRotation(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    m20(): number;
    get(arg0: Matrix4f_): this;
    transform(arg0: Vec4f_): Vec4f;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    normal(arg0: Matrix4f_): this;
    m33(arg0: number): this;
    "get3x4(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    set3x3(arg0: Internal.Matrix3fc_): this;
    translationRotateScale(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: number): this;
    unprojectRay(arg0: number, arg1: number, arg2: number[], arg3: Vec3f_, arg4: Vec3f_): this;
    "translationRotateScale(org.joml.Vector3fc,org.joml.Quaternionfc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
    normalize3x3(arg0: Matrix4f_): this;
    "frustumLH(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    "shadow(org.joml.Vector4f,float,float,float,float)"(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number): this;
    getScale(arg0: Vec3f_): Vec3f;
    rotation(arg0: number, arg1: Internal.Vector3fc_): this;
    setRotationXYZ(arg0: number, arg1: number, arg2: number): this;
    mapZnXnY(): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    invertFrustum(arg0: Matrix4f_): this;
    transformProject(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    wait(arg0: number): void;
    lookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "transformProject(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    rotationTowardsXY(arg0: number, arg1: number): this;
    "normalize3x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    orthoCrop(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    "shadow(org.joml.Vector4f,float,float,float,float,org.joml.Matrix4f)"(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: Matrix4f_): this;
    scaling(arg0: number, arg1: number, arg2: number): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    lookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    unprojectInvRay(arg0: Internal.Vector2fc_, arg1: number[], arg2: Vec3f_, arg3: Vec3f_): this;
    transpose3x3(arg0: Matrix4f_): this;
    mul(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setLookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    "reflect(org.joml.Quaternionfc,org.joml.Vector3fc,org.joml.Matrix4f)"(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    "unprojectInv(float,float,float,int[],org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    m33(): number;
    transpose(arg0: Matrix4f_): this;
    setPerspective(arg0: number, arg1: number, arg2: number, arg3: number): this;
    unprojectInv(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    set(arg0: Internal.Matrix4fc_): this;
    rotationX(arg0: number): this;
    "set(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    m22(): number;
    m31(arg0: number): this;
    mapZYX(arg0: Matrix4f_): this;
    mulAffineR(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setOrthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    m11(): number;
    mapYnZX(arg0: Matrix4f_): this;
    mulOrthoAffine(arg0: Internal.Matrix4fc_): this;
    mapnZnXY(): this;
    setTransposed(arg0: Internal.Matrix4fc_): this;
    setRotationZYX(arg0: number, arg1: number, arg2: number): this;
    assume(arg0: number): this;
    "unproject(float,float,float,int[],org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    transformAab(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_, arg3: Vec3f_): this;
    mul0(arg0: Internal.Matrix4fc_): this;
    rotateTowardsXY(arg0: number, arg1: number, arg2: Matrix4f_): this;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    equals(arg0: any): boolean;
    rotateAroundLocal(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    "perspectiveOffCenterFov(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    scaleLocal(arg0: number, arg1: number, arg2: number): this;
    mapnZYnX(arg0: Matrix4f_): this;
    m00(): number;
    rotationYXZ(arg0: number, arg1: number, arg2: number): this;
    rotateLocal(arg0: Internal.Quaternionfc_): this;
    "cofactor3x3(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    mul(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    setOrthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    m13(arg0: number): this;
    invertPerspective(arg0: Matrix4f_): this;
    get3x4(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "get(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapnZXY(): this;
    rotateZYX(arg0: Vec3f_): this;
    rotateLocalX(arg0: number): this;
    "normal(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    translationRotateScaleInvert(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number): this;
    get(arg0: number[], arg1: number): number[];
    mapXZnY(): this;
    "setTransposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    set(arg0: Internal.Matrix4dc_): this;
    negateY(): this;
    withLookAtUp(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    mapnZYX(arg0: Matrix4f_): this;
    sub(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    "perspectiveRect(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    getRow(arg0: number, arg1: Vec4f_): Vec4f;
    "getRotation(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
    "perspectiveLH(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    getColumn(arg0: number, arg1: Vec4f_): Vec4f;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    mapnYXnZ(): this;
    transpose3x3(): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateAroundAffine(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    setFrustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    setRowColumn(arg0: number, arg1: number, arg2: number): this;
    transformProject(arg0: Vec3f_): Vec3f;
    normalizedPositiveY(arg0: Vec3f_): Vec3f;
    sub4x3(arg0: Matrix4f_): this;
    translationRotateInvert(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): this;
    setPerspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    testAab(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): boolean;
    "reflect(org.joml.Quaternionfc,org.joml.Vector3fc)"(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
    m13(): number;
    reflect(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    mapYZX(): this;
    "get4x3(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    "getRow(int,org.joml.Vector3f)"(arg0: number, arg1: Vec3f_): Vec3f;
    "unprojectInv(org.joml.Vector3fc,int[],org.joml.Vector4f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    setFromAddress(arg0: number): this;
    m02(arg0: number): this;
    "mulPerspectiveAffine(org.joml.Matrix4fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    transformAffine(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    mapnYZnX(arg0: Matrix4f_): this;
    m02(): number;
    project(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    transformTranspose(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    transpose(): this;
    "perspectiveOffCenterFov(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    "set(float[])"(arg0: number[]): this;
    set(arg0: number[]): this;
    m11(arg0: number): this;
    mulAffine(arg0: Internal.Matrix4fc_): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    getEulerAnglesZYX(arg0: Vec3f_): Vec3f;
    rotateZYX(arg0: number, arg1: number, arg2: number): this;
    "project(float,float,float,int[],org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    positiveX(arg0: Vec3f_): Vec3f;
    setTranslation(arg0: number, arg1: number, arg2: number): this;
    m22(arg0: number): this;
    mapXnZY(): this;
    originAffine(arg0: Vec3f_): Vec3f;
    "set4x3(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    mapnZYX(): this;
    fma4x3(arg0: Internal.Matrix4fc_, arg1: number): this;
    "get3x4(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    setPerspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    set(arg0: Internal.Matrix4x3fc_): this;
    normal(): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    setLookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    mulTranslationAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setPerspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    "reflection(org.joml.Quaternionfc,org.joml.Vector3fc)"(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
    lookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    "set(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_): this;
    billboardSpherical(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "unproject(org.joml.Vector3fc,int[],org.joml.Vector4f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    mul(arg0: Internal.Matrix3x2fc_): this;
    scale(arg0: number, arg1: number, arg2: number): this;
    "perspectiveOffCenterFovLH(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    scaling(arg0: Internal.Vector3fc_): this;
    unprojectInv(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    mapnYZnX(): this;
    m00(arg0: number): this;
    setFrustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    get4x3Transposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    mulComponentWise(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    "rotate(float,org.joml.Vector3fc)"(arg0: number, arg1: Internal.Vector3fc_): this;
    set(arg0: Internal.ByteBuffer_): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    "getUnnormalizedRotation(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    set3x3(arg0: Matrix4f_): this;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    "getTransposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnXZY(arg0: Matrix4f_): this;
    set(arg0: Internal.Quaterniondc_): this;
    setPerspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnXnZY(arg0: Matrix4f_): this;
    mapXZY(arg0: Matrix4f_): this;
    setOrtho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    mulComponentWise(arg0: Internal.Matrix4fc_): this;
    rotate(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    "perspectiveLH(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    add(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    swap(arg0: Matrix4f_): this;
    transformDirection(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    negateY(arg0: Matrix4f_): this;
    translationRotateScale(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number): this;
    getClass(): typeof any;
    "transformProject(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    add(arg0: Internal.Matrix4fc_): this;
    determineProperties(): this;
    mapXnZnY(): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    "set(float[],int)"(arg0: number[], arg1: number): this;
    rotation(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "shadow(float,float,float,float,org.joml.Matrix4fc,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4fc_, arg5: Matrix4f_): this;
    getTransposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    withLookAtUp(arg0: Internal.Vector3fc_): this;
    mapYnZX(): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapnXnYZ(): this;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateAffineZYX(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    set(arg0: Internal.AxisAngle4d_): this;
    mapnXnZnY(): this;
    rotationXYZ(arg0: number, arg1: number, arg2: number): this;
    rotate(arg0: Internal.AxisAngle4f_): this;
    lookAtPerspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    setTransposed(arg0: number[], arg1: number): this;
    mapZnXnY(arg0: Matrix4f_): this;
    rotateAffineXYZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    setOrthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    "translationRotateScaleInvert(org.joml.Vector3fc,org.joml.Quaternionfc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
    get3x4(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    get4x3Transposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    get4x3(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
    scale(arg0: Internal.Vector3fc_): this;
    "mul(org.joml.Matrix4fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    "cofactor3x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    lookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    transformPosition(arg0: Vec3f_): Vec3f;
    "rotation(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    set(arg0: Internal.AxisAngle4f_): this;
    affineSpan(arg0: Vec3f_, arg1: Vec3f_, arg2: Vec3f_, arg3: Vec3f_): this;
    perspectiveFrustumSlice(arg0: number, arg1: number, arg2: Matrix4f_): this;
    transformDirection(arg0: Vec3f_): Vec3f;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    determinant3x3(): number;
    wait(): void;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "frustum(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    projectedGridRange(arg0: Internal.Matrix4fc_, arg1: number, arg2: number, arg3: Matrix4f_): this;
    mulAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    setFrustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZnXnY(arg0: Matrix4f_): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4fc_, arg5: Matrix4f_): this;
    rotationAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number): this;
    set4x3(arg0: Matrix4f_): this;
    project(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    getTransposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "get(org.joml.Matrix4d)"(arg0: Internal.Matrix4d_): Internal.Matrix4d;
    "setTransposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    get4x3(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    translateLocal(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnXnYZ(arg0: Matrix4f_): this;
    normalize3x3(): this;
    translationRotateScaleInvert(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
    mapnXnZY(): this;
    translationRotateScale(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): this;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    rotate(arg0: number, arg1: Internal.Vector3fc_): this;
    translation(arg0: number, arg1: number, arg2: number): this;
    "transpose3x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    setOrthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    frustumPlane(arg0: number, arg1: Vec4f_): Vec4f;
    transformPosition(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    invertAffine(): this;
    frustumCorner(arg0: number, arg1: Vec3f_): Vec3f;
    "project(org.joml.Vector3fc,int[],org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    get(arg0: number[]): number[];
    shadow(arg0: Vec4f_, arg1: Internal.Matrix4fc_, arg2: Matrix4f_): this;
    set(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number): this;
    toString(arg0: Internal.NumberFormat_): string;
    rotateAffine(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    transformProject(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec3f_): Vec3f;
    mapZXnY(arg0: Matrix4f_): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    setPerspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    getRotation(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    get4x3(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    "get3x4(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapYnXZ(): this;
    setTransposed(arg0: number[]): this;
    unproject(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    "scale(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    rotateY(arg0: number): this;
    rotateTranslation(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    invertPerspectiveView(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    setPerspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    notifyAll(): void;
    add4x3(arg0: Internal.Matrix4fc_): this;
    mapnXZnY(): this;
    mulAffineR(arg0: Internal.Matrix4fc_): this;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    ortho2D(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "orthoSymmetricLH(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    transformAffine(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    perspectiveFar(): number;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "set(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    mapnXnZnY(arg0: Matrix4f_): this;
    set(arg0: Internal.Quaternionfc_): this;
    "rotate(org.joml.AxisAngle4f,org.joml.Matrix4f)"(arg0: Internal.AxisAngle4f_, arg1: Matrix4f_): this;
    mapYnXZ(arg0: Matrix4f_): this;
    "getTransposed(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    "perspective(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    "get(float[],int)"(arg0: number[], arg1: number): number[];
    "getTransposed(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapXnZnY(arg0: Matrix4f_): this;
    mapYXZ(): this;
    determinant(): number;
    "reflect(org.joml.Vector3fc,org.joml.Vector3fc,org.joml.Matrix4f)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    add4x3(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setLookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    wait(arg0: number, arg1: number): void;
    setOrthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "perspectiveOffCenter(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    getUnnormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    mapnXZnY(arg0: Matrix4f_): this;
    rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    translate(arg0: Internal.Vector3fc_): this;
    "get(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    m30(): number;
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "getUnnormalizedRotation(org.joml.Quaternionf)"(arg0: Quaternionf_): Quaternionf;
    "set3x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    "mul(org.joml.Matrix3x2fc)"(arg0: Internal.Matrix3x2fc_): this;
    rotate(arg0: number, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    getTranslation(arg0: Vec3f_): Vec3f;
    invertPerspectiveView(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    set transposedFromAddress(arg0: number)
    set "(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_)
    get finite(): boolean
    set transposed(arg0: Internal.FloatBuffer_)
    set "(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set "transposed(float[])"(arg0: number[])
    set "(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    set transposed(arg0: Internal.ByteBuffer_)
    set "(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_)
    set "transposed(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set "(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_)
    set "(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_)
    set translation(arg0: Internal.Vector3fc_)
    get affine(): boolean
    set "(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_)
    set "(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_)
    set "(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set transposed(arg0: Internal.Matrix4fc_)
    set "transposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set fromAddress(arg0: number)
    set "(float[])"(arg0: number[])
    set "(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_)
    get class(): typeof any
    set "transposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    set transposed(arg0: number[])
}
type Matrix4f_ = Matrix4f;
/**
 * The hub for all things text components. Format text to your hearts content!
*/
declare class Component {
    constructor()
    getClass(): typeof any;
    /**
     * Returns a component of the input, colored light purple
    */
    static lightPurple(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored blue
    */
    static blue(text: any): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key
    */
    static translatable(key: string): Internal.MutableComponent;
    /**
     * Returns a ClickEvent of the input
    */
    static clickEventOf(o: any): Internal.ClickEvent;
    /**
     * Returns a colorful representation of the input nbt. Useful for displaying NBT to the player
    */
    static prettyPrintNbt(tag: Internal.Tag_): net.minecraft.network.chat.Component;
    /**
     * Returns an empty component
    */
    static empty(): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key, with args of the objects
    */
    static translatable(key: string, ...objects: any[]): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored white
    */
    static white(text: any): Internal.MutableComponent;
    /**
     * Returns a plain component of the string, or empty if it is an empty string
    */
    static ofString(s: string): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key, with args of the objects
    */
    static translate(key: string, ...objects: any[]): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key
    */
    static translate(key: string): Internal.MutableComponent;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    /**
     * Returns a component displaying all entities matching the input selector
    */
    static selector(selector: string): Internal.MutableComponent;
    /**
     * Checks if the passed in component, and all its children are empty
    */
    static isEmpty(component: net.minecraft.network.chat.Component_): boolean;
    /**
     * Returns a component of the input, colored dark purple
    */
    static darkPurple(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored yellow
    */
    static yellow(text: any): Internal.MutableComponent;
    /**
     * Returns a Component of the input
    */
    static of(o: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored gray
    */
    static gray(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark blue
    */
    static darkBlue(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark red
    */
    static darkRed(text: any): Internal.MutableComponent;
    toString(): string;
    /**
     * Returns a component of the input, colored gold
    */
    static gold(text: any): Internal.MutableComponent;
    notifyAll(): void;
    /**
     * Returns a component of the input, colored red
    */
    static red(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark green
    */
    static darkGreen(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored green
    */
    static green(text: any): Internal.MutableComponent;
    /**
     * Returns a keybinding component of the input keybinding descriptor
    */
    static keybind(keybind: string): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark aqua
    */
    static darkAqua(text: any): Internal.MutableComponent;
    /**
     * Joins all components
    */
    static join(...texts: net.minecraft.network.chat.Component_[]): Internal.MutableComponent;
    hashCode(): number;
    /**
     * Returns a score component of the input objective, for the provided selector
    */
    static score(selector: string, objective: string): Internal.MutableComponent;
    /**
     * Returns a plain component of the passed in string, even if empty
    */
    static string(text: string): Internal.MutableComponent;
    wait(): void;
    /**
     * Joins all components in the list with the separator component
    */
    static join(separator: Internal.MutableComponent_, texts: Internal.Iterable_<net.minecraft.network.chat.Component>): Internal.MutableComponent;
    /**
     * Returns a component displaying all entities matching the input selector, with a custom separator
    */
    static selector(selector: string, separator: net.minecraft.network.chat.Component_): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored aqua
    */
    static aqua(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored black
    */
    static black(text: any): Internal.MutableComponent;
    wait(arg0: number): void;
    /**
     * Returns a component of the input, colored dark gray
    */
    static darkGray(text: any): Internal.MutableComponent;
    /**
     * Returns a plain component of the input
    */
    static literal(text: string): Internal.MutableComponent;
    equals(arg0: any): boolean;
    get class(): typeof any
}
type Component_ = Component;
/**
 * A collection of utilities
*/
declare interface Utils {
    /**
     * Capitalises the first letter of the string unless it is "a", "an", "the", "of", "on", "in", "and", "or", "but" or "for"
    */
    toTitleCase(s: string): string;
    /**
     * Returns a Stat of the passed in ResourceLocation.
     * Note that this requires the same ResourceLocation to get the same stat, so should not be used unless you want to make your own stat, and are storing an actual ResourceLocation somewhere to access it.
    */
    getStat(id: ResourceLocation_): Internal.Stat<ResourceLocation>;
    /**
     * Returns the provided snake_case_string in Title Case
    */
    snakeCaseToTitleCase(string: string): string;
    /**
     * Returns a new counting map
    */
    newCountingMap(): Internal.CountingMap;
    /**
     * Capitalises the first letter of the string. If ignoreSpecial is true, it will also capitalise articles and prepositions
    */
    toTitleCase(s: string, ignoreSpecial: boolean): string;
    /**
     * Tries to parse the first parameter as a double and returns that. The second parameter is returned if parsing fails
    */
    parseDouble(object: any, def: number): number;
    /**
     * Get a Random, for generating random numbers. Note this will always return the same Random instance
    */
    getRandom(): Internal.Random;
    /**
     * Returns a new mutable list
    */
    newList(): Internal.List<any>;
    /**
     * Get a new random with the specified seed
    */
    newRandom(seed: number): Internal.Random;
    /**
     * Gets all ids from the registry with the specified id
    */
    getRegistryIds(id: ResourceLocation_): Internal.List<ResourceLocation>;
    /**
     * Returns the results of rolling the specified loot table (it does not have to be a chest loot table)
    */
    rollChestLoot(id: ResourceLocation_): Internal.List<Internal.ItemStack>;
    /**
     * Get an immutable empty list
    */
    emptyList<T>(): Internal.List<T>;
    /**
     * Gets the current system time, in milliseconds
    */
    getSystemTime(): number;
    /**
     * Runs the provided supplier function in KubeJS' background thread and returns its CompletableFuture
    */
    supplyAsync(task: Internal.Supplier_<any>): Internal.CompletableFuture<any>;
    /**
     * Returns a ResourceLocation with the specified namepsace and path
    */
    id(namespace: string, path: string): ResourceLocation;
    /**
     * Returns a lazy value with the supplier function as its value factory
    */
    lazy<T>(supplier: Internal.Supplier_<T>): Internal.Lazy<T>;
    /**
     * Checks if the passed in object is an instance of WrappedJS
    */
    isWrapped(o: any): boolean;
    /**
     * Returns the provided snake_case_string in camelCase
    */
    snakeCaseToCamelCase(string: string): string;
    /**
     * Returns the creative tab associated with the id
    */
    findCreativeTab(id: ResourceLocation_): Internal.CreativeModeTab;
    /**
     * Get an immutable empty map
    */
    emptyMap<K, V>(): Internal.Map<K, V>;
    /**
     * Gets a SoundEvent from the id
    */
    getSound(id: ResourceLocation_): Internal.SoundEvent;
    /**
     * Returns a lazy value with the supplier function as its value factory, that will expire after the specified number of milliseconds
    */
    expiringLazy<T>(supplier: Internal.Supplier_<T>, time: number): Internal.Lazy<T>;
    /**
     * Gets a random object from the list using the passed in random
    */
    randomOf(random: Internal.Random_, objects: Internal.Collection_<any>): any;
    /**
     * Returns a new mutable map
    */
    newMap(): Internal.Map<any, any>;
    /**
     * Gets the specified registry
    */
    getRegistry(id: ResourceLocation_): Internal.RegistryInfo<any>;
    particleOptions(o: any): Internal.ParticleOptions;
    /**
     * Returns a copy the object if possible, or the object itself if not
    */
    copy(o: any): any;
    /**
     * Returns a regex pattern of the input with the specified flags
    */
    regex(pattern: string, flags: number): Internal.Pattern;
    /**
     * Typewraps the input string to a ResourceLocation. Format should be namespace:path
    */
    id(id: ResourceLocation_): ResourceLocation;
    /**
     * Returns a regex pattern of the input
    */
    regex(s: any): Internal.Pattern;
    /**
     * Runs the provided runnable function in KubeJS' background thread and returns its CompletableFuture
    */
    runAsync(task: Internal.Runnable_): Internal.CompletableFuture<void>;
    /**
     * Parses a block state from the input string. May throw for invalid inputs!
    */
    parseBlockState(o: any): Internal.BlockState;
    /**
     * Immediately run the passed runnable function in a try-catch block, and log the exception if it throws
    */
    queueIO(runnable: Internal.Runnable_): void;
    /**
     * Tries to parse the first parameter as an integer, and returns that. The second parameter is returned if parsing fails
    */
    parseInt(object: any, def: number): number;
    /**
     * Get the server. Null if there is no server (startup or client)
    */
    getServer(): Internal.MinecraftServer;
    /**
     * Returns the results of rolling the specified loot table with the entity as a parameter (it does not have to be a chest loot table)
    */
    rollChestLoot(id: ResourceLocation_, entity: Internal.Entity_): Internal.List<Internal.ItemStack>;
    /**
     * Get a Random, for generating random numbers. Note this will always return the same Random instance
    */
    get random(): Internal.Random
    /**
     * Gets the current system time, in milliseconds
    */
    get systemTime(): number
    /**
     * Get the server. Null if there is no server (startup or client)
    */
    get server(): Internal.MinecraftServer
    readonly ERROR_PARTICLE: (Internal.DustParticleOptions) & (Internal.DustParticleOptions);
}
type Utils_ = Utils;
declare const Utils: Utils;
declare interface AABB {
    ofSize(vec3: Vec3d_, x: number, y: number, z: number): Internal.AABB;
    ofBlock(pos: BlockPos_): Internal.AABB;
    of(x0: number, y0: number, z0: number, x1: number, y1: number, z1: number): Internal.AABB;
    ofSize(x: number, y: number, z: number): Internal.AABB;
    ofBlocks(pos1: BlockPos_, pos2: BlockPos_): Internal.AABB;
    wrap(o: any): Internal.AABB;
    readonly CUBE: (Internal.AABB) & (Internal.AABB);
    readonly EMPTY: (Internal.AABB) & (Internal.AABB);
}
type AABB_ = AABB;
declare const AABB: AABB;
declare namespace Special {
    type Mod = "betterdungeons" | "almanac" | "ftbessentials" | "supermartijn642configlib" | "simplemagnets" | "variantsandventures" | "botarium" | "prefab" | "javd" | "hammerlib" | "create_jetpack" | "neat" | "forgeendertech" | "ctm" | "modernfix" | "fabric_command_api_v2" | "yungsapi" | "powah" | "angrymobs" | "maxhealthfix" | "wstweaks" | "resourcepackoverrides" | "kubejspowah" | "forgivingvoid" | "apotheosis" | "pickupnotifier" | "balm" | "betterfortresses" | "cloth_config" | "stackrefill" | "revampedwolf" | "embeddium" | "rubidium" | "athena" | "lmft" | "glodium" | "torchmaster" | "tipthescales" | "repurposed_structures" | "bcc" | "botanytrees" | "blockrunner" | "aquatictorches" | "amplified_nether" | "supermartijn642corelib" | "yungsbridges" | "resourcefulconfig" | "curios" | "searchables" | "yungsextras" | "attributeslib" | "noisium" | "biomeinfo" | "emiffect" | "flib" | "betterendisland" | "flightlib" | "unilib" | "jadeaddons" | "codechickenlib" | "bettermineshafts" | "randombonemealflowers" | "crafting_on_a_stick" | "betterjungletemples" | "elytraslot" | "radium" | "effectdescriptions" | "betteranimationscollection" | "doubledoors" | "mekanismcovers" | "protectmobsfromdaylight" | "harvest_with_ease" | "treeharvester" | "universalbonemeal" | "attributefix" | "caelus" | "fabric_rendering_v1" | "fallingleaves" | "naturescompass" | "smarterfarmers" | "catjammies" | "sneak_through_berries" | "botanypots" | "farmingforblockheads" | "snowundertrees" | "fusion" | "edivadlib" | "puzzlesaccessapi" | "forge" | "logbegone" | "minecraft" | "logprot" | "terrablender" | "fabric_api_base" | "mousetweaks" | "necronomicon" | "pamhc2crops" | "ohthetreesyoullgrow" | "mindfuldarkness" | "alltheleaks" | "cleanswing" | "adlods" | "spectrelib" | "corgilib" | "ding" | "obsidianboat" | "domum_ornamentum" | "kotlinforforge" | "notenoughanimations" | "flywheel" | "createoreexcavation" | "mantle" | "pamhc2foodcore" | "polymorph" | "leavemybarsalone" | "almostunified" | "emi" | "jei" | "mekanism" | "gravitationalmodulatingunittweaks" | "entityculling" | "ambientenvironment" | "immediatelyfast" | "fastfurnace" | "appleskin" | "lootr" | "connectedglass" | "puzzleslib" | "aquaculture" | "friendlyfire" | "datamancy" | "emi_ores" | "extremesoundmuffler" | "cosmeticarmorreworked" | "step" | "ae2ct" | "defaultoptions" | "cristellib" | "cyclopscore" | "kuma_api" | "embeddiumplus" | "betterwitchhuts" | "netherportalfix" | "restrictedportals" | "geckolib" | "naturalist" | "betteroceanmonuments" | "sophisticatedcore" | "kleeslabs" | "insanelib" | "realisticbees" | "controlling" | "placebo" | "jumpoverfences" | "dankstorage" | "citadel" | "mixinextras" | "emitrades" | "cobweb" | "bookshelf" | "ibicf" | "sophisticatedbackpacks" | "waddles" | "progressivebosses" | "mekanismgenerators" | "utilitarian" | "fbp" | "create_jetpack_curios" | "fzzy_config" | "trenzalore" | "konkrete" | "diagonalblocks" | "jamd" | "entity_model_features" | "entity_texture_features" | "compressium" | "fuelgoeshere" | "colorfulhearts" | "hangglider" | "pamhc2foodextended" | "cullleaves" | "midnightlib" | "collective" | "seamless_loading_screen" | "elevatorid" | "ftbultimine" | "betterstrongholds" | "resourcefullib" | "starterkit" | "mekanismtools" | "bridgingmod" | "boatbreakfix" | "architectury" | "nerb" | "justhammers" | "ftblibrary" | "ftbfiltersystem" | "findme" | "squatgrow" | "ftbteams" | "ftbquests" | "aiimprovements" | "jammies" | "cupboard" | "lightoverlay" | "trashcans" | "clearwater" | "chunkloaders" | "fabric_networking_api_v1" | "bwncr" | "probejs" | "t_and_t" | "letmedespawn" | "yeetusexperimentus" | "crawlondemand" | "betteradvancements" | "easy_mob_farm" | "craftpresence" | "inventorysorter" | "rhino" | "kubejs" | "kubejs_mekanism" | "trashslot" | "pamhc2trees" | "flatbedrock" | "craftingstation" | "sophisticatedstorage" | "snad" | "octolib" | "biomeswevegone" | "obscure_tooltips_fix" | "create" | "kubejs_create" | "waystones" | "illagerwarship" | "fastsuite" | "clumps" | "yungscavebiomes" | "comforts" | "storagenetwork" | "configured" | "dimstorage" | "creeperconfetti" | "betterdeserttemples" | "explorerscompass" | "toastcontrol" | "ichunutil" | "txnilib" | "ftbchunks" | "ftbxmodcompat" | "toofast" | "fasterladderclimbing" | "brandonscore" | "draconicevolution" | "jeimultiblocks" | "immersiveengineering" | "kubejs_immersive_engineering" | "friendsandfoes" | "nyfsspiders" | "craftingtweaks" | "tmtcmoe" | "itlt" | "enchdesc" | "dynamic_asset_generator" | "buddingcrystals" | "sebastrnlib" | "appliedcooking" | "cookingforblockheads" | "patchouli" | "moonlight" | "endermanoverhaul" | "eccentrictome" | "toolbelt" | "distraction_free_recipes" | "enigmaticgraves" | "mixinsquared" | "jade" | "ae2" | "aeinfinitybooster" | "ae2netanalyser" | "merequester" | "fulleng" | "ae2wtlib" | "megacells" | "advanced_ae" | "obscure_tooltips" | "mutil" | "jaopca" | "create_sa" | "polyeng" | "fastbench" | "diagonalfences" | "jei_mekanism_multiblocks" | "buildinggadgets2" | "flowerpatch" | "emi_enchanting" | "ferritecore" | "chisel" | "yet_another_config_lib_v3" | "solcarrot" | "justzoom" | "charmofundying" | "betterf3" | "allarrowsinfinityfix" | "woodwevegot" | "badoptimizations" | "overloadedarmorbar" | "healingcampfire" | "fabric_events_interaction_v0" | "createaddition"
    type Ingredient = "codechickenlib:conditional" | "draconicevolution:ingredient_stack" | "moonlight:block_type_swap" | "jaopca:empty" | "jaopca:wrapped" | "kubejs:wildcard" | "kubejs:custom" | "kubejs:custom_predicate" | "kubejs:mod" | "kubejs:regex" | "kubejs:creative_tab" | "immersiveengineering:fluid" | "toolbelt:belt_upgrade_level" | "forge:compound" | "forge:nbt" | "forge:partial_nbt" | "forge:difference" | "forge:intersection" | "minecraft:item" | "mantle:fluid_container" | "sophisticatedstorage:base_tier_wooden_storage" | "create:block_tag_ingredient";
    type Advancement = "minecraft:recipes/building_blocks/weathered_cut_copper_stairs_from_weathered_copper_stonecutting" | "connectedglass:recipes/misc/vanilla_yellow_stained_glass_pane" | "yungscavebiomes:recipes/building_blocks/ancient_sandstone_slab_from_stonecutting" | "immersiveengineering:recipes/misc/stonecutting/slab_hempcrete" | "minecraft:recipes/redstone/acacia_button" | "minecraft:recipes/decorations/brick_wall" | "ae2:recipes/misc/tools/paintballs_lumen_blue" | "minecraft:recipes/building_blocks/stone_bricks" | "minecraft:recipes/building_blocks/polished_deepslate" | "biomeswevegone:biomeswevegone/adventure/forgotten_fae" | "create:recipes/building_blocks/cut_scorchia_brick_slab_from_stone_types_scorchia_stonecutting" | "minecraft:husbandry/allay_deliver_item_to_player" | "minecraft:recipes/combat/leather_helmet" | "minecraft:recipes/building_blocks/polished_blackstone_brick_slab" | "ae2:recipes/misc/misc/tank_sky_stone" | "biomeswevegone:recipes/redstone/holly_fence_gate" | "biomeswevegone:recipes/building_blocks/florus_slab" | "immersiveengineering:recipes/misc/crafting/connector_mv" | "biomeswevegone:recipes/decorations/zelkova_sign" | "ae2:recipes/misc/block_cutter/stairs/smooth_quartz_stairs" | "create:recipes/misc/crafting/kinetics/white_sailfrom_conversion" | "compressium:recipes/building_blocks/endstone_3" | "compressium:recipes/building_blocks/soulsand_4_uncraft" | "compressium:recipes/building_blocks/endstone_2" | "minecraft:recipes/decorations/blast_furnace" | "compressium:recipes/building_blocks/endstone_1" | "minecraft:recipes/decorations/ladder" | "minecraft:recipes/decorations/red_nether_brick_wall" | "compressium:recipes/building_blocks/endstone_7" | "compressium:recipes/building_blocks/endstone_6" | "minecraft:recipes/decorations/magenta_stained_glass_pane" | "compressium:recipes/building_blocks/endstone_5" | "compressium:recipes/building_blocks/endstone_4" | "create:recipes/misc/crafting/kinetics/mechanical_saw" | "compressium:recipes/building_blocks/endstone_9" | "compressium:recipes/building_blocks/endstone_8" | "minecraft:recipes/building_blocks/stripped_mangrove_wood" | "sophisticatedstorage:recipes/misc/spruce_chest_from_quark_spruce_chest" | "immersiveengineering:recipes/misc/crafting/storage_steel_to_slab" | "create:recipes/building_blocks/cut_tuff_from_stone_types_tuff_stonecutting" | "biomeswevegone:recipes/redstone/skyris_fence_gate" | "justhammers:recipes/tools/diamond_reinforced_hammer" | "megacells:recipes/misc/crafting/16m_crafting_storage" | "compressium:recipes/building_blocks/netherrack_7_uncraft" | "create:recipes/building_blocks/small_ochrum_brick_slab_recycling" | "sophisticatedstorage:recipes/misc/netherite_shulker_box" | "create:recipes/misc/smelting/ingot_osmium_compat_mekanism" | "naturalist:recipes/food/cake" | "create:recipes/building_blocks/birch_window" | "domum_ornamentum:recipes/tools/roan_bricks" | "immersiveengineering:main/creosote" | "create:recipes/building_blocks/cut_deepslate_brick_stairs" | "sophisticatedstorage:recipes/misc/shulker_box" | "immersiveengineering:recipes/misc/smoking/clinker_brick" | "compressium:recipes/building_blocks/cobblestone_5_uncraft" | "immersiveengineering:recipes/misc/crafting/connector_lv" | "connectedglass:recipes/misc/borderless_glass_light_blue_pane1" | "connectedglass:recipes/misc/borderless_glass_light_blue_pane2" | "ae2:recipes/misc/decorative/smooth_quartz_block" | "biomeswevegone:recipes/building_blocks/cika_slab" | "compressium:recipes/building_blocks/iron_9_uncraft" | "minecraft:recipes/decorations/brown_banner" | "immersiveengineering:recipes/misc/crafting/toolupgrade_powerpack_magnet" | "immersiveengineering:multiblocks/mb_improvedblastfurnace" | "compressium:recipes/building_blocks/diamond_7_uncraft" | "create:recipes/building_blocks/cut_andesite_brick_stairs" | "ae2:recipes/misc/network/cables/dense_smart_fluix_clean" | "biomeswevegone:recipes/redstone/rainbow_eucalyptus_trapdoor" | "compressium:recipes/building_blocks/netherite_7_uncraft" | "chunkloaders:recipes/misc/ultimate_chunk_loader" | "buddingcrystals:recipes/misc/budding_nickel" | "immersiveengineering:recipes/misc/crafting/turntable" | "create:recipes/misc/crafting/kinetics/vertical_gearboxfrom_conversion" | "create:recipes/misc/crafting/kinetics/rotation_speed_controller" | "biomeswevegone:recipes/decorations/holly_hanging_sign" | "biomeswevegone:recipes/redstone/willow_pressure_plate" | "connectedglass:recipes/misc/borderless_glass_light_blue_pane3" | "ae2:recipes/misc/network/parts/import_bus" | "minecraft:recipes/building_blocks/deepslate_tile_stairs_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/decorations/purple_sandstone_wall_from_purple_sandstone_stonecutting" | "minecraft:recipes/building_blocks/mangrove_planks" | "create:recipes/decorations/brass_bars_from_ingots_brass_stonecutting" | "ae2:recipes/misc/network/cables/glass_blue" | "advanced_ae:recipes/misc/quantumstorage128" | "create:recipes/building_blocks/small_veridium_brick_slab" | "ae2:recipes/misc/network/parts/annihilation_plane_alt2" | "compressium:recipes/building_blocks/andesite_9_uncraft" | "minecraft:recipes/misc/lapis_lazuli_from_smelting_deepslate_lapis_ore" | "create:recipes/building_blocks/small_ochrum_bricks_from_stone_types_ochrum_stonecutting" | "create:recipes/misc/smelting/zinc_ingot_from_ore" | "minecraft:recipes/misc/emerald" | "betterdungeons:small_nether_dungeon" | "immersiveengineering:recipes/misc/crafting/treated_wood_horizontal" | "biomeswevegone:recipes/decorations/red_rock_brick_wall" | "ae2:recipes/misc/decorative/quartz_fixture" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_stairs_from_waxed_oxidized_cut_copper_stonecutting" | "sophisticatedstorage:recipes/misc/backpack_magnet_upgrade_from_storage_magnet_upgrade" | "minecraft:recipes/building_blocks/brick_stairs" | "create:recipes/building_blocks/cut_deepslate_brick_wall_from_stone_types_deepslate_stonecutting" | "minecraft:recipes/decorations/deepslate_brick_wall_from_deepslate_bricks_stonecutting" | "create:recipes/building_blocks/scoria_from_stone_types_scoria_stonecutting" | "minecraft:recipes/misc/storage_io_from_output" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_stairs_from_waxed_oxidized_copper_stonecutting" | "create:recipes/misc/crafting/kinetics/light_gray_valve_handle_from_other_valve_handle" | "biomeswevegone:recipes/redstone/baobab_button" | "biomeswevegone:recipes/building_blocks/smooth_black_sandstone" | "minecraft:recipes/building_blocks/deepslate_tile_stairs_from_deepslate_tiles_stonecutting" | "immersiveengineering:recipes/misc/crafting/stairs_concrete_leaded" | "create:recipes/building_blocks/crafting/kinetics/yellow_seat_from_other_seat" | "minecraft:recipes/misc/eye_armor_trim_smithing_template_smithing_trim" | "create:recipes/building_blocks/cut_scorchia_stairs_from_stone_types_scorchia_stonecutting" | "immersiveengineering:recipes/misc/crafting/armor_faraday_chestplate" | "utilitarian:recipes/misc/no_soliciting/soliciting_carpets/magenta_soliciting_carpet" | "minecraft:recipes/decorations/lime_stained_glass_pane_from_glass_pane" | "minecraft:adventure/trim_with_all_exclusive_armor_patterns" | "minecraft:recipes/misc/copper_ingot_from_blasting_deepslate_copper_ore" | "create:recipes/misc/crafting/kinetics/chute" | "create:recipes/combat/crafting/appliances/netherite_diving_boots" | "immersiveengineering:multiblocks/mb_mixer" | "create:recipes/misc/crafting/kinetics/brown_valve_handle_from_other_valve_handle" | "compressium:recipes/building_blocks/dirt_9" | "compressium:recipes/building_blocks/dirt_8" | "ae2:recipes/misc/shaped/walls/sky_stone_brick" | "compressium:recipes/building_blocks/dirt_7" | "create:recipes/building_blocks/small_calcite_brick_wall_from_stone_types_calcite_stonecutting" | "minecraft:recipes/building_blocks/smooth_quartz_slab" | "compressium:recipes/building_blocks/dirt_2" | "ae2:recipes/misc/shaped/slabs/sky_stone_small_brick" | "compressium:recipes/building_blocks/dirt_1" | "sophisticatedbackpacks:recipes/misc/advanced_feeding_upgrade" | "minecraft:recipes/building_blocks/end_stone_brick_slab" | "compressium:recipes/building_blocks/dirt_6" | "connectedglass:recipes/misc/borderless_glass_pink_pane1" | "domum_ornamentum:recipes/tools/brick_extra" | "compressium:recipes/building_blocks/dirt_5" | "compressium:recipes/building_blocks/dirt_4" | "connectedglass:recipes/misc/borderless_glass_pink_pane3" | "ae2:recipes/misc/network/cells/spatial_components" | "compressium:recipes/building_blocks/dirt_3" | "biomeswevegone:recipes/building_blocks/jacaranda_slab" | "connectedglass:recipes/misc/borderless_glass_pink_pane2" | "create:recipes/building_blocks/cut_tuff_brick_wall" | "biomeswevegone:recipes/misc/green_dye_from_bwg_tag" | "immersiveengineering:recipes/misc/crafting/stairs_hempcrete" | "minecraft:recipes/decorations/polished_deepslate_wall" | "create:recipes/building_blocks/granite_from_stone_types_granite_stonecutting" | "sophisticatedstorage:recipes/misc/storage_stack_upgrade_tier_1_plus_from_backpack_stack_upgrade_starter_tier" | "immersiveengineering:recipes/misc/crafting/steel_post" | "create:recipes/building_blocks/crafting/copper/waxed_weathered_copper_tiles_from_honeycomb" | "biomeswevegone:recipes/decorations/red_wool_from_rose__petal_block" | "create:clockwork_bearing" | "mekanism:mekasuit" | "minecraft:recipes/decorations/orange_bed" | "mekanism:alloy_upgrading" | "mekanism:fluid_tank" | "minecraft:recipes/decorations/fletching_table" | "minecraft:recipes/food/cooked_chicken_from_campfire_cooking" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_purple_from_slab" | "minecraft:recipes/decorations/brown_bed" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_red" | "connectedglass:recipes/misc/borderless_glass_magenta_pane2" | "compressium:recipes/building_blocks/copper_8_uncraft" | "minecraft:recipes/food/cooked_mutton_from_smoking" | "connectedglass:recipes/misc/borderless_glass_magenta_pane1" | "woodwevegot:recipes/redstone/holly_trapped_chest" | "minecraft:recipes/building_blocks/deepslate_bricks" | "connectedglass:recipes/misc/borderless_glass_magenta_pane3" | "biomeswevegone:recipes/building_blocks/maple_bookshelf" | "create:recipes/building_blocks/weathered_copper_shingle_slab_from_weathered_copper_shingles_stonecutting" | "compressium:recipes/building_blocks/snow_8_uncraft" | "compressium:recipes/building_blocks/iron_3_uncraft" | "biomeswevegone:recipes/decorations/holly_sign" | "immersiveengineering:tools/skyhook_distance" | "biomeswevegone:recipes/building_blocks/stripped_baobab_wood" | "minecraft:recipes/building_blocks/polished_diorite_stairs" | "create:recipes/building_blocks/cut_diorite_brick_wall" | "minecraft:recipes/building_blocks/dye_brown_bed" | "ae2:main/facade" | "connectedglass:recipes/misc/vanilla_brown_stained_glass_pane" | "create:recipes/building_blocks/cut_ochrum_wall" | "compressium:recipes/building_blocks/netherite_1_uncraft" | "buddingcrystals:recipes/misc/budding_lapis_lazuli" | "sophisticatedstorage:recipes/misc/cherry_chest_from_quark_cherry_chest" | "sophisticatedbackpacks:recipes/misc/deposit_upgrade" | "minecraft:recipes/misc/gold_ingot_from_gold_block" | "minecraft:recipes/building_blocks/light_blue_stained_glass" | "ae2:recipes/misc/network/cables/glass_lime" | "fulleng:recipes/misc/terminals/part_conversion_monitor_from_block" | "biomeswevegone:recipes/redstone/blue_enchanted_trapdoor" | "create:recipes/misc/crafting/kinetics/elevator_pulley" | "utilitarian:recipes/misc/utility/acacia_logs_to_boats" | "immersiveengineering:recipes/misc/crafting/coke_to_coal_coke" | "create:recipes/misc/crafting/kinetics/portable_fluid_interface" | "immersiveengineering:recipes/misc/crafting/waterwheel_segment" | "create:recipes/misc/crafting/kinetics/wrench" | "immersiveengineering:recipes/misc/crafting/wooden_barrel" | "minecraft:recipes/misc/lapis_lazuli_from_blasting_lapis_ore" | "create:recipes/misc/crafting/kinetics/rose_quartz_lamp" | "create:recipes/misc/crafting/kinetics/steam_whistle" | "sophisticatedstorage:recipes/misc/netherite_shulker_from_netherite_chest" | "minecraft:recipes/decorations/purple_bed" | "biomeswevegone:recipes/food/cooked_white_puffball_cap_from_campfire" | "repurposed_structures:villages" | "mekanism:personal_radiation" | "create:recipes/building_blocks/crafting/kinetics/pink_seat_from_other_seat" | "biomeswevegone:recipes/redstone/florus_button" | "create:recipes/building_blocks/oxidized_copper_shingle_slab_from_oxidized_copper_shingles_stonecutting" | "compressium:recipes/building_blocks/quartz_7" | "biomeswevegone:recipes/decorations/pine_crafting_table" | "compressium:recipes/building_blocks/quartz_8" | "compressium:recipes/building_blocks/quartz_9" | "compressium:recipes/building_blocks/quartz_3" | "minecraft:recipes/decorations/light_gray_glazed_terracotta" | "compressium:recipes/building_blocks/quartz_4" | "compressium:recipes/building_blocks/quartz_5" | "immersiveengineering:recipes/misc/stonecutting/slab_hempcrete_brick" | "compressium:recipes/building_blocks/quartz_6" | "minecraft:recipes/building_blocks/mossy_stone_bricks_from_vine" | "compressium:recipes/building_blocks/quartz_1" | "minecraft:recipes/redstone/birch_button" | "compressium:recipes/building_blocks/quartz_2" | "minecraft:recipes/building_blocks/quartz_slab" | "advanced_ae:recipes/misc/quantum_alloy_stairs" | "ae2:recipes/misc/tools/certus_quartz_pickaxe" | "minecraft:recipes/building_blocks/jungle_wood" | "naturalist:husbandry/ride_giraffe_with_map" | "minecraft:recipes/combat/netherite_chestplate_smithing" | "create:recipes/building_blocks/cut_diorite_brick_stairs" | "biomeswevegone:recipes/building_blocks/skyris_stairs" | "minecraft:recipes/decorations/purple_glazed_terracotta" | "minecraft:story/deflect_arrow" | "yungscavebiomes:recipes/building_blocks/brittle_sandstone" | "biomeswevegone:recipes/transportation/sakura_chest_boat" | "create:sturdy_sheet" | "utilitarian:recipes/misc/utility/crimson_logs_to_doors" | "ae2:recipes/misc/tools/paintballs_purple" | "minecraft:recipes/tools/golden_axe" | "minecraft:husbandry/leash_all_frog_variants" | "naturalist:recipes/naturalist/smooth_limestone" | "biomeswevegone:recipes/redstone/maple_door" | "immersiveengineering:recipes/misc/smelting/ingot_steel_from_dust" | "domum_ornamentum:recipes/tools/mossy_cobblestone_extra" | "create:recipes/building_blocks/cut_limestone_slab_from_stone_types_limestone_stonecutting" | "create:recipes/building_blocks/cut_andesite_brick_slab" | "create:recipes/building_blocks/cut_veridium_brick_slab_from_stone_types_veridium_stonecutting" | "biomeswevegone:recipes/redstone/baobab_trapdoor" | "immersiveengineering:recipes/misc/stonecutting/concrete_chiseled" | "minecraft:recipes/building_blocks/deepslate_tile_stairs_from_deepslate_bricks_stonecutting" | "minecraft:recipes/decorations/orange_banner" | "immersiveengineering:recipes/misc/crafting/conveyor_extract_covered" | "biomeswevegone:recipes/building_blocks/palo_verde_wood" | "woodwevegot:recipes/decorations/ebony_barrel" | "immersiveengineering:recipes/misc/crafting/stairs_hempcrete_brick" | "advanced_ae:recipes/misc/magnet_card" | "immersiveengineering:recipes/misc/crafting/sheetmetal_uranium" | "ae2:recipes/misc/misc/deconstruction_certus_quartz_bricks" | "compressium:recipes/building_blocks/diorite_3_uncraft" | "minecraft:recipes/decorations/oak_sign" | "megacells:recipes/misc/cells/standard/fluid_storage_cell_256m_with_housing" | "biomeswevegone:recipes/building_blocks/pink_sandstone_slab" | "comforts:rope_and_nail" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_gray_to_slab" | "minecraft:recipes/building_blocks/red_concrete_powder" | "advanced_ae:recipes/misc/quantum_leggings" | "ae2:recipes/misc/blasting/silicon_from_certus_quartz_dust" | "connectedglass:recipes/misc/scratched_glass_light_blue_pane3" | "create:recipes/misc/crafting/kinetics/gantry_shaft" | "sophisticatedstorage:recipes/misc/crafting_upgrade" | "connectedglass:recipes/misc/scratched_glass_light_blue_pane1" | "connectedglass:recipes/misc/scratched_glass_light_blue_pane2" | "immersiveengineering:recipes/misc/crafting/chute_aluminum" | "minecraft:recipes/tools/golden_pickaxe" | "biomeswevegone:recipes/food/cooked_oddion_bulb_from_campfire" | "immersiveengineering:recipes/misc/crafting/clinker_brick_to_slab" | "advanced_ae:recipes/misc/quantum_alloy_block_wall" | "immersiveengineering:multiblocks/mb_excavator" | "immersiveengineering:recipes/misc/crafting/stairs_concrete_brick" | "minecraft:recipes/building_blocks/chiseled_pink_sandstone_from_pink_sandstone_stonecutting" | "biomeswevegone:recipes/redstone/cika_fence_gate" | "biomeswevegone:recipes/transportation/willow_boat" | "create:recipes/building_blocks/polished_cut_andesite_stairs_from_stone_types_andesite_stonecutting" | "minecraft:recipes/brewing/magma_cream" | "compressium:recipes/building_blocks/netherrack_1_uncraft" | "create:recipes/building_blocks/cut_scoria_stairs" | "immersiveengineering:recipes/misc/crafting/blueprint_bannerpatterns" | "immersiveengineering:recipes/misc/crafting/balloon" | "biomeswevegone:recipes/building_blocks/cut_black_sandstone_slab" | "create:recipes/building_blocks/cut_granite_brick_slab_from_stone_types_granite_stonecutting" | "create:recipes/building_blocks/small_ochrum_brick_slab_from_stone_types_ochrum_stonecutting" | "immersiveengineering:recipes/misc/crafting/storage_steel_to_ingot_steel" | "minecraft:nether/brew_potion" | "comforts:sleeping_bag_cyan" | "compressium:recipes/building_blocks/emerald_6_uncraft" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_magenta" | "minecraft:recipes/building_blocks/polished_deepslate_slab" | "create:recipes/misc/crafting/appliances/copper_backtank" | "ae2:recipes/misc/network/blocks/cell_workbench" | "create:recipes/building_blocks/dark_oak_window" | "ae2:recipes/misc/block_cutter/slabs/sky_stone_brick_slab" | "sophisticatedstorage:recipes/misc/light_blue_shulker_box_to_sophisticated" | "biomeswevegone:recipes/building_blocks/mossy_stone_stairs" | "immersiveengineering:recipes/misc/crafting/steel_scaffolding_wooden_top_from_slab" | "biomeswevegone:biomeswevegone/root" | "minecraft:recipes/building_blocks/quartz_bricks" | "minecraft:recipes/decorations/deepslate_tile_wall_from_deepslate_tiles_stonecutting" | "mekanism:basic_control_circuit" | "sophisticatedstorage:recipes/misc/advanced_magnet_upgrade" | "megacells:recipes/misc/crafting/decompression_module" | "biomeswevegone:recipes/redstone/zelkova_fence_gate" | "minecraft:recipes/decorations/purple_stained_glass_pane_from_glass_pane" | "immersiveengineering:recipes/misc/crafting/treated_wood_horizontal_from_packaged" | "mekanism:robit" | "sophisticatedstorage:recipes/misc/storage_advanced_void_upgrade_from_backpack_advanced_void_upgrade" | "create:recipes/building_blocks/polished_cut_crimsite_wall" | "create:recipes/building_blocks/crafting/copper/waxed_oxidized_copper_tile_slab_from_honeycomb" | "ae2:recipes/misc/tools/fluix_sword" | "minecraft:end/dragon_egg" | "aquaculture:recipes/aquaculture/heavy_hook" | "immersiveengineering:recipes/misc/smelting/copper_ingot_from_dust" | "justhammers:recipes/tools/netherite_reinforced_impact_hammer" | "immersiveengineering:recipes/misc/smelting/ingot_aluminum2" | "minecraft:husbandry/fishy_business" | "ae2:recipes/misc/decorative/light_detector" | "minecraft:recipes/building_blocks/black_sandstone_slab_from_black_sandstone_stonecutting" | "minecraft:recipes/building_blocks/lapis_block" | "biomeswevegone:recipes/building_blocks/maple_slab" | "sophisticatedstorage:recipes/misc/backpack_stack_upgrade_tier_4_from_storage_stack_upgrade_tier_5" | "immersiveengineering:recipes/misc/smelting/ingot_aluminum3" | "create:recipes/building_blocks/polished_cut_calcite_slab" | "connectedglass:recipes/misc/vanilla_white_stained_glass_pane" | "minecraft:recipes/food/cooked_cod_from_smoking" | "biomeswevegone:recipes/transportation/palm_chest_boat" | "create:recipes/misc/crafting/kinetics/mechanical_press" | "minecraft:nether/explore_nether" | "immersiveengineering:recipes/misc/crafting/sheetmetal_electrum_to_slab" | "ae2:recipes/misc/network/cells/item_storage_cell_64k" | "ae2:recipes/misc/tools/paintballs_orange" | "immersiveengineering:recipes/misc/crafting/minecart_woodencrate" | "create:recipes/building_blocks/cut_dripstone_slab_from_stone_types_dripstone_stonecutting" | "create:recipes/building_blocks/crafting/copper/waxed_copper_tile_stairs_from_honeycomb" | "aquaculture:recipes/decorations/birch_fish_mount" | "minecraft:recipes/building_blocks/prismarine" | "ae2:recipes/misc/network/upgrade_wireless_crafting_terminal" | "biomeswevegone:recipes/decorations/skyris_sign" | "minecraft:recipes/building_blocks/polished_diorite" | "create:recipes/decorations/brass_ladder_from_ingots_brass_stonecutting" | "create:recipes/building_blocks/cut_asurine_brick_wall_from_stone_types_asurine_stonecutting" | "create:recipes/misc/crafting/kinetics/rope_pulley" | "immersiveengineering:recipes/misc/crafting/concrete_leaded" | "minecraft:recipes/misc/brown_dye" | "minecraft:recipes/building_blocks/raw_iron_block" | "create:recipes/building_blocks/crafting/copper/waxed_weathered_copper_shingles_from_honeycomb" | "create:recipes/building_blocks/polished_cut_veridium_from_stone_types_veridium_stonecutting" | "sophisticatedstorage:recipes/misc/limited_iron_barrel_3_from_limited_copper_barrel_3" | "connectedglass:recipes/misc/borderless_glass_orange2" | "dankstorage:recipes/tools/3_to_4" | "connectedglass:recipes/misc/borderless_glass_orange1" | "sophisticatedstorage:recipes/misc/basic_to_diamond_tier_upgrade" | "immersiveengineering:recipes/misc/crafting/ingot_aluminum_to_nugget_aluminum" | "minecraft:recipes/building_blocks/mud_brick_slab_from_mud_bricks_stonecutting" | "woodwevegot:recipes/decorations/sakura_chest" | "create:recipes/building_blocks/cut_limestone_brick_stairs_from_stone_types_limestone_stonecutting" | "sophisticatedstorage:recipes/misc/acacia_barrel" | "biomeswevegone:recipes/food/blooming_oddion" | "megacells:recipes/misc/cells/standard/item_storage_cell_16m_with_housing" | "ae2:recipes/misc/network/cables/glass_brown" | "ae2:recipes/misc/network/wireless_terminal" | "connectedglass:recipes/misc/borderless_glass1" | "create:recipes/building_blocks/exposed_copper_tile_slab" | "biomeswevegone:recipes/decorations/redwood_crafting_table" | "create:recipes/building_blocks/crafting/kinetics/green_seat_from_other_seat" | "create:recipes/building_blocks/polished_cut_tuff_from_stone_types_tuff_stonecutting" | "connectedglass:recipes/misc/tinted_borderless_glass_cyan2" | "immersiveengineering:recipes/misc/crafting/cokebrick_from_slab" | "megacells:recipes/misc/cells/standard/item_storage_cell_64m" | "friendsandfoes:husbandry/shear_a_moobloom" | "create:recipes/building_blocks/cut_andesite_slab_from_stone_types_andesite_stonecutting" | "megacells:recipes/misc/network/mega_pattern_provider_part" | "ae2wtlib:recipes/magnet_card" | "ae2:recipes/misc/tools/portable_fluid_cell_4k" | "utilitarian:recipes/misc/utility/mangrove_logs_to_slabs" | "biomeswevegone:recipes/redstone/ironwood_trapdoor" | "biomeswevegone:recipes/redstone/zelkova_trapdoor" | "create:recipes/building_blocks/small_andesite_brick_slab_from_stone_types_andesite_stonecutting" | "create:recipes/building_blocks/cut_ochrum_stairs_from_stone_types_ochrum_stonecutting" | "create:extendo_grip" | "create:recipes/building_blocks/cut_scoria_brick_stairs" | "minecraft:recipes/decorations/white_allium_petal_block" | "immersiveengineering:recipes/misc/stonecutting/stairs_clinker_brick" | "minecraft:recipes/building_blocks/end_stone_brick_slab_from_end_stone_stonecutting" | "create:recipes/building_blocks/polished_cut_crimsite_slab_from_stone_types_crimsite_stonecutting" | "create:recipes/building_blocks/cut_diorite_slab_from_stone_types_diorite_stonecutting" | "minecraft:recipes/decorations/blue_stained_glass_pane_from_glass_pane" | "immersiveengineering:recipes/misc/crafting/nugget_lead_to_ingot_lead" | "minecraft:recipes/misc/netherite_scrap_from_blasting" | "create:glass_pipe" | "minecraft:recipes/combat/diamond_sword" | "minecraft:recipes/decorations/cyan_stained_glass_pane" | "fulleng:recipes/misc/terminals/block_terminal_from_part" | "create:recipes/combat/crafting/appliances/netherite_diving_helmet_from_netherite" | "minecraft:recipes/misc/white_dye" | "minecraft:recipes/building_blocks/stripped_warped_hyphae" | "minecraft:recipes/decorations/jukebox" | "ae2:recipes/misc/block_cutter/stairs/smooth_sky_stone_stairs" | "compressium:recipes/building_blocks/sand_5_uncraft" | "biomeswevegone:recipes/food/cooked_oddion_bulb_from_smelting" | "minecraft:recipes/misc/silence_armor_trim_smithing_template_smithing_trim" | "create:recipes/building_blocks/cut_scoria_brick_wall" | "biomeswevegone:recipes/redstone/blue_enchanted_button" | "biomeswevegone:recipes/building_blocks/jacaranda_wood" | "immersiveengineering:recipes/misc/crafting/axe_steel" | "immersiveengineering:recipes/misc/crafting/storage_aluminum_from_slab" | "biomeswevegone:recipes/food/blueberry_pie" | "immersiveengineering:recipes/misc/crafting/nugget_copper_to_copper_ingot" | "minecraft:recipes/decorations/black_sandstone_wall_from_black_sandstone_stonecutting" | "minecraft:recipes/misc/gold_nugget" | "utilitarian:recipes/misc/utility/iron_block_from_smelting" | "ae2:recipes/misc/network/blocks/pattern_providers_interface_part" | "utilitarian:recipes/misc/no_soliciting/soliciting_carpets/black_trapped_soliciting_carpet" | "ae2:recipes/misc/network/blocks/quantum_link" | "immersiveengineering:recipes/misc/smelting/ingot_lead3" | "minecraft:recipes/building_blocks/smooth_sandstone_slab_from_smooth_sandstone_stonecutting" | "immersiveengineering:recipes/misc/crafting/turret_gun" | "minecraft:nether/all_effects" | "woodwevegot:recipes/decorations/sakura_ladder" | "create:recipes/building_blocks/small_deepslate_brick_slab" | "ae2:recipes/misc/decorative/certus_quartz_bricks" | "create:recipes/building_blocks/polished_cut_veridium_slab" | "immersiveengineering:recipes/misc/crafting/drillhead_steel" | "compressium:recipes/building_blocks/coal_6_uncraft" | "immersiveengineering:recipes/misc/crafting/sheetmetal_uranium_from_slab" | "create:recipes/building_blocks/crafting/copper/waxed_exposed_copper_shingle_stairs_from_honeycomb" | "immersiveengineering:recipes/misc/smelting/ingot_lead2" | "buddingcrystals:recipes/misc/budding_netherite" | "biomeswevegone:recipes/redstone/cypress_pressure_plate" | "biomeswevegone:recipes/building_blocks/green_enchanted_wood" | "sophisticatedstorage:recipes/misc/diamond_shulker_box" | "advanced_ae:recipes/misc/quantummultithreader" | "biomeswevegone:recipes/misc/red_dye_from_bwg_tag" | "mekanismtools:not_enough_shielding" | "immersiveengineering:recipes/misc/crafting/sheetmetal_constantan_to_slab" | "ae2:recipes/misc/tools/paintballs_lumen_white" | "justhammers:recipes/tools/destructor_core" | "mekanism:chemical_tank" | "create:recipes/building_blocks/cut_veridium_brick_wall" | "create:recipes/building_blocks/cut_scorchia_from_stone_types_scorchia_stonecutting" | "minecraft:recipes/decorations/white_glazed_terracotta" | "biomeswevegone:recipes/transportation/pine_chest_boat" | "minecraft:recipes/combat/iron_helmet" | "minecraft:recipes/tools/golden_shovel" | "create:recipes/building_blocks/small_scoria_brick_slab" | "biomeswevegone:recipes/building_blocks/white_sand" | "aquaculture:recipes/misc/neptunium_ingot_from_neptunium_block" | "minecraft:recipes/building_blocks/dye_magenta_carpet" | "create:recipes/building_blocks/oxidized_copper_shingle_stairs" | "ae2:recipes/misc/shaped/stairs/sky_stone_block" | "megacells:recipes/misc/crafting/greater_energy_card_upgraded" | "connectedglass:recipes/misc/vanilla_lime_stained_glass" | "buddingcrystals:recipes/misc/budding_nether_quartz" | "minecraft:recipes/combat/diamond_chestplate" | "create:recipes/misc/crafting/kinetics/smart_chute" | "immersiveengineering:recipes/misc/crafting/railgun" | "create:recipes/building_blocks/polished_cut_calcite_stairs_from_stone_types_calcite_stonecutting" | "immersiveengineering:recipes/misc/crafting/ingot_constantan_to_storage_constantan" | "minecraft:story/mine_stone" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_slab_from_waxed_oxidized_cut_copper_stonecutting" | "minecraft:recipes/decorations/furnace" | "minecraft:recipes/food/beetroot_soup" | "minecraft:recipes/building_blocks/andesite_stairs" | "biomeswevegone:recipes/redstone/jacaranda_door" | "connectedglass:recipes/misc/borderless_glass_black2" | "create:recipes/misc/crafting/kinetics/mechanical_arm" | "connectedglass:recipes/misc/borderless_glass_black1" | "immersiveengineering:recipes/misc/crafting/torch" | "minecraft:recipes/redstone/redstone_torch" | "biomeswevegone:recipes/building_blocks/white_mangrove_planks" | "minecraft:recipes/food/golden_apple" | "minecraft:recipes/misc/gold_ingot_from_blasting_raw_gold" | "biomeswevegone:recipes/building_blocks/cika_wood" | "minecraft:recipes/building_blocks/green_concrete_powder" | "create:recipes/building_blocks/cut_limestone_brick_wall_from_stone_types_limestone_stonecutting" | "minecraft:recipes/building_blocks/mossy_stone_from_vine" | "create:recipes/misc/blasting/nickel_ingot_compat_thermal" | "ae2:recipes/misc/misc/fluixpearl" | "create:recipes/misc/blasting/copper_ingot_from_crushed" | "mekanism:breathing_assistance" | "minecraft:recipes/building_blocks/orange_stained_glass" | "megacells:recipes/misc/crafting/1m_crafting_storage" | "minecraft:recipes/building_blocks/dacite_slab_from_dacite_stonecutting" | "ae2:recipes/misc/tools/portable_fluid_cell_1k" | "megacells:recipes/misc/cells/standard/item_storage_cell_1m_with_housing" | "immersiveengineering:recipes/misc/crafting/storage_silver_from_slab" | "immersiveengineering:recipes/misc/smelting/ingot_aluminum" | "easy_mob_farm:recipes/mob_farm_template/tier0_mob_farm_template" | "create:recipes/misc/crafting/kinetics/super_glue" | "minecraft:adventure/two_birds_one_arrow" | "minecraft:recipes/decorations/end_crystal" | "mekanism:item_transport" | "create:recipes/building_blocks/cut_scorchia_wall_from_stone_types_scorchia_stonecutting" | "immersiveengineering:recipes/misc/smelting/nugget_steel_recycle_sword_from_blasting" | "ae2:recipes/misc/network/crafting/256k_cpu_crafting_storage" | "biomeswevegone:recipes/decorations/zelkova_hanging_sign" | "biomeswevegone:recipes/building_blocks/skyris_bookshelf" | "immersiveengineering:tools/upgrade_railgun" | "compressium:recipes/building_blocks/redstone_5_uncraft" | "create:recipes/building_blocks/exposed_copper_shingle_slab" | "create:recipes/building_blocks/cut_crimsite_slab" | "naturalist:recipes/naturalist/limestone_brick_stairs" | "immersiveengineering:recipes/misc/crafting/storage_constantan_to_slab" | "minecraft:recipes/redstone/birch_door" | "sophisticatedstorage:recipes/misc/dark_oak_barrel" | "create:recipes/misc/crafting/logistics/pulse_extender" | "create:root" | "create:recipes/building_blocks/crimsite_from_stone_types_crimsite_stonecutting" | "biomeswevegone:recipes/redstone/redwood_trapdoor" | "biomeswevegone:recipes/decorations/baobab_hanging_sign" | "create:train_crash_backwards" | "create:recipes/building_blocks/exposed_copper_tile_stairs" | "minecraft:recipes/decorations/snow" | "minecraft:recipes/decorations/soul_lantern" | "minecraft:recipes/misc/sentry_armor_trim_smithing_template" | "minecraft:recipes/building_blocks/oxidized_cut_copper_from_oxidized_copper_stonecutting" | "minecraft:recipes/decorations/cherry_fence" | "minecraft:recipes/decorations/birch_fence" | "minecraft:recipes/decorations/sandstone_wall_from_sandstone_stonecutting" | "create:recipes/misc/crafting/kinetics/andesite_door" | "immersiveengineering:recipes/misc/crafting/storage_lead_from_slab" | "create:recipes/building_blocks/cut_dripstone_brick_wall_from_stone_types_dripstone_stonecutting" | "sophisticatedbackpacks:recipes/misc/advanced_refill_upgrade" | "minecraft:recipes/building_blocks/stone_brick_stairs" | "ae2:recipes/misc/network/cells/spatial_components_1" | "create:recipes/building_blocks/cut_scorchia_brick_wall_from_stone_types_scorchia_stonecutting" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_orange_to_slab" | "ae2:recipes/misc/network/cells/spatial_components_0" | "minecraft:recipes/combat/golden_boots" | "immersiveengineering:recipes/misc/crafting/wooden_grip" | "compressium:recipes/building_blocks/gold_4_uncraft" | "sophisticatedstorage:recipes/misc/advanced_magnet_upgrade_from_basic" | "minecraft:recipes/tools/wooden_axe" | "ae2:recipes/misc/network/cells/item_storage_components_cell_1k_part" | "woodwevegot:recipes/decorations/mahogany_barrel" | "compressium:recipes/building_blocks/snow_2_uncraft" | "immersiveengineering:recipes/misc/crafting/nugget_aluminum_to_ingot_aluminum" | "create:recipes/building_blocks/polished_cut_tuff_slab_from_stone_types_tuff_stonecutting" | "minecraft:recipes/misc/gold_ingot_from_smelting_gold_ore" | "biomeswevegone:recipes/transportation/jacaranda_chest_boat" | "minecraft:recipes/building_blocks/stone_bricks_from_stone_stonecutting" | "immersiveengineering:recipes/misc/crafting/transformer" | "create:copper" | "minecraft:recipes/building_blocks/chiseled_sandstone" | "biomeswevegone:recipes/building_blocks/florus_stairs" | "create:recipes/building_blocks/cut_limestone_slab" | "biomeswevegone:recipes/building_blocks/smooth_white_sandstone" | "create:recipes/building_blocks/small_scoria_brick_slab_from_stone_types_scoria_stonecutting" | "domum_ornamentum:recipes/tools/yellow_brick_extra" | "ae2:recipes/misc/network/cables/dense_smart_light_gray" | "easy_mob_farm:crafting/mob_farm_template/tier1_mob_farm_template" | "immersiveengineering:recipes/misc/crafting/storage_uranium_to_ingot_uranium" | "sophisticatedstorage:recipes/misc/chipped/botanist_workbench_upgrade" | "apotheosis:spawner/players" | "mekanism:laser_death" | "create:recipes/misc/smelting/glass_from_framed_glass" | "advanced_ae:recipes/misc/quantum_storage_component" | "immersiveengineering:recipes/misc/crafting/stairs_alu_scaffolding_grate_top" | "chunkloaders:recipes/misc/single_chunk_loader" | "justhammers:recipes/tools/netherite_reinforced_hammer" | "create:potato_cannon" | "create:recipes/misc/crafting/kinetics/spout" | "compressium:recipes/building_blocks/dirt_6_uncraft" | "minecraft:recipes/building_blocks/stone_slab" | "minecraft:recipes/decorations/black_carpet" | "immersiveengineering:recipes/misc/crafting/toolupgrade_buzzsaw_spareblades" | "utilitarian:recipes/misc/utility/spruce_logs_to_slabs" | "ae2:recipes/misc/network/cells/spatial_storage_cell_16_cubed" | "domum_ornamentum:recipes/decorations/gray_floating_carpet" | "minecraft:recipes/misc/gold_nugget_from_blasting" | "biomeswevegone:recipes/decorations/cika_crafting_table" | "create:recipes/building_blocks/cut_deepslate_from_stone_types_deepslate_stonecutting" | "compressium:recipes/building_blocks/endstone_3_uncraft" | "biomeswevegone:recipes/building_blocks/maple_wood" | "minecraft:recipes/decorations/yellow_stained_glass_pane" | "minecraft:recipes/building_blocks/blue_concrete_powder" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_slab_from_honeycomb" | "minecraft:recipes/building_blocks/granite_slab_from_granite_stonecutting" | "ae2:recipes/misc/network/cables/dense_covered_fluix" | "immersiveengineering:recipes/misc/crafting/coke_to_slab" | "biomeswevegone:recipes/building_blocks/pine_stairs" | "connectedglass:recipes/misc/vanilla_glass" | "sophisticatedstorage:recipes/misc/limited_copper_barrel_4" | "ae2wtlib:recipes/wireless_universal_terminal/upgrade_pattern_access" | "minecraft:recipes/building_blocks/crimson_planks" | "create:recipes/building_blocks/cut_veridium_brick_wall_from_stone_types_veridium_stonecutting" | "sophisticatedstorage:recipes/misc/bamboo_limited_barrel_1" | "sophisticatedstorage:recipes/misc/limited_copper_barrel_2" | "minecraft:recipes/decorations/red_rock_brick_wall_from_red_rock_bricks_stonecutting" | "sophisticatedstorage:recipes/misc/bamboo_limited_barrel_2" | "sophisticatedstorage:recipes/misc/limited_copper_barrel_3" | "create:chute" | "naturalist:recipes/food/cooked_bass" | "sophisticatedstorage:recipes/misc/bamboo_limited_barrel_3" | "sophisticatedstorage:recipes/misc/bamboo_limited_barrel_4" | "sophisticatedstorage:recipes/misc/limited_copper_barrel_1" | "create:recipes/building_blocks/polished_cut_scoria_from_stone_types_scoria_stonecutting" | "create:recipes/building_blocks/small_tuff_brick_slab_recycling" | "megacells:recipes/misc/cells/cell_component_16m" | "progressivebosses:recipes/misc/nether_star" | "minecraft:recipes/building_blocks/cut_sandstone" | "minecraft:recipes/building_blocks/smooth_red_sandstone" | "minecraft:recipes/building_blocks/black_terracotta" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_pink_to_slab" | "minecraft:recipes/decorations/blackstone_wall" | "minecraft:recipes/misc/cyan_dye_from_pitcher_plant" | "sophisticatedstorage:recipes/misc/copper_to_iron_tier_upgrade" | "sophisticatedstorage:recipes/misc/gold_shulker_from_gold_chest" | "ae2:recipes/misc/network/cables/covered_brown" | "minecraft:recipes/building_blocks/weathered_cut_copper_slab_from_weathered_cut_copper_stonecutting" | "immersiveengineering:main/place_dynamo" | "create:chained_drain" | "minecraft:recipes/decorations/purple_candle" | "sophisticatedstorage:recipes/misc/smelting_upgrade" | "create:recipes/building_blocks/crafting/kinetics/blue_seat" | "create:recipes/building_blocks/cut_diorite_brick_slab_from_stone_types_diorite_stonecutting" | "minecraft:recipes/decorations/pink_glazed_terracotta" | "minecraft:recipes/misc/coal" | "minecraft:recipes/transportation/spruce_chest_boat" | "sophisticatedstorage:recipes/misc/pink_shulker_box_to_sophisticated" | "sophisticatedbackpacks:recipes/misc/magnet_upgrade" | "biomeswevegone:recipes/redstone/aspen_trapdoor" | "minecraft:recipes/food/cooked_rabbit" | "biomeswevegone:recipes/decorations/witch_hazel_sign" | "minecraft:recipes/combat/leather_chestplate" | "biomeswevegone:recipes/building_blocks/zelkova_stairs" | "ae2:recipes/misc/network/cells/item_storage_cell_256k" | "compressium:recipes/building_blocks/quartz_6_uncraft" | "create:recipes/misc/crafting/appliances/crafting_blueprint" | "immersiveengineering:recipes/misc/crafting/wall_clinker_brick" | "minecraft:recipes/misc/magenta_dye_from_blue_red_pink" | "minecraft:recipes/decorations/yellow_candle" | "ae2:recipes/misc/tools/paintballs_lumen_lime" | "sophisticatedstorage:recipes/misc/jukebox_upgrade" | "utilitarian:recipes/misc/utility/dark_oak_logs_to_boats" | "create:recipes/building_blocks/polished_cut_crimsite_wall_from_stone_types_crimsite_stonecutting" | "immersiveengineering:recipes/misc/crafting/sheetmetal_constantan_from_slab" | "mekanism:moving_blocks" | "aquaculture:recipes/misc/iron_nugget_from_smelting" | "minecraft:nether/obtain_blaze_rod" | "immersiveengineering:recipes/misc/crafting/metal_ladder_steel" | "create:crushing_wheel" | "woodwevegot:recipes/redstone/fir_trapped_chest" | "ae2:recipes/misc/network/cables/dense_smart_white" | "create:recipes/building_blocks/cut_crimsite_bricks_from_stone_types_crimsite_stonecutting" | "create:recipes/misc/crafting/kinetics/placard" | "apotheosis:enchanting/30ench" | "chunkloaders:recipes/misc/single_to_basic_chunk_loader" | "compressium:recipes/building_blocks/lapis_9_uncraft" | "immersiveengineering:recipes/misc/smelting/ingot_nickel_from_dust_from_blasting" | "compressium:recipes/building_blocks/clay_5_uncraft" | "immersiveengineering:recipes/misc/crafting/fertilizer" | "biomeswevegone:recipes/building_blocks/fir_bookshelf" | "compressium:recipes/building_blocks/obsidian_6_uncraft" | "compressium:recipes/building_blocks/redsand_5_uncraft" | "create:recipes/building_blocks/cut_crimsite_brick_stairs" | "create:recipes/building_blocks/small_tuff_brick_wall" | "immersiveengineering:recipes/misc/crafting/generator" | "woodwevegot:recipes/redstone/baobab_trapped_chest" | "compressium:recipes/building_blocks/gravel_4_uncraft" | "biomeswevegone:recipes/building_blocks/florus_wood" | "sophisticatedstorage:recipes/misc/decoration_table" | "buddingcrystals:recipes/misc/budding_aluminum" | "biomeswevegone:recipes/building_blocks/stripped_white_mangrove_wood" | "create:recipes/misc/crafting/kinetics/water_wheel" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_brown" | "immersiveengineering:recipes/misc/crafting/sheetmetal_lead_from_slab" | "create:recipes/building_blocks/cut_granite_slab_from_stone_types_granite_stonecutting" | "connectedglass:recipes/misc/vanilla_light_gray_stained_glass_pane" | "biomeswevegone:recipes/decorations/white_mangrove_fence" | "create:recipes/misc/blasting/silver_ingot_compat_oreganized" | "minecraft:adventure/shoot_arrow" | "create:recipes/building_blocks/polished_cut_limestone_stairs_from_stone_types_limestone_stonecutting" | "immersiveengineering:recipes/misc/crafting/clinker_brick_from_slab" | "compressium:recipes/building_blocks/coal_2" | "compressium:recipes/building_blocks/coal_1" | "minecraft:recipes/building_blocks/polished_blackstone_stairs" | "create:recipes/building_blocks/cut_limestone_brick_slab_recycling" | "biomeswevegone:recipes/building_blocks/white_mangrove_slab" | "compressium:recipes/building_blocks/coal_6" | "immersiveengineering:recipes/misc/crafting/alu_scaffolding_wooden_top_from_grate_top" | "compressium:recipes/building_blocks/coal_5" | "compressium:recipes/building_blocks/coal_4" | "biomeswevegone:recipes/building_blocks/rocky_stone" | "compressium:recipes/building_blocks/coal_3" | "compressium:recipes/building_blocks/coal_9" | "sophisticatedstorage:recipes/misc/gold_to_netherite_tier_upgrade" | "compressium:recipes/building_blocks/coal_8" | "compressium:recipes/building_blocks/coal_7" | "immersiveengineering:recipes/misc/crafting/connector_hv" | "create:recipes/misc/smelting/lead_ingot_compat_thermal" | "biomeswevegone:recipes/building_blocks/mossy_stone_slab" | "create:recipes/building_blocks/cut_scoria_slab_from_stone_types_scoria_stonecutting" | "create:recipes/building_blocks/oxidized_copper_shingle_slab" | "compressium:recipes/building_blocks/andesite_3_uncraft" | "utilitarian:recipes/misc/no_soliciting/soliciting_carpets/green_trapped_soliciting_carpet" | "create:recipes/building_blocks/polished_cut_crimsite_slab_recycling" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_slab" | "minecraft:recipes/building_blocks/chiseled_red_sandstone" | "create:recipes/building_blocks/crafting/kinetics/magenta_seat" | "minecraft:recipes/decorations/light_gray_stained_glass_pane_from_glass_pane" | "mekanism:infused_alloy" | "ae2:recipes/misc/tools/portable_fluid_cell_256k" | "immersiveengineering:recipes/misc/crafting/redstone_acid" | "minecraft:adventure/arbalistic" | "connectedglass:recipes/misc/vanilla_red_stained_glass" | "minecraft:recipes/decorations/pink_candle" | "ae2:recipes/misc/network/cables/smart_gray" | "compressium:recipes/building_blocks/stone_9_uncraft" | "naturalist:recipes/naturalist/spectral_arrow_from_glow_goop" | "immersiveengineering:recipes/misc/crafting/steel_scaffolding_grate_top_from_slab" | "biomeswevegone:recipes/redstone/willow_fence_gate" | "minecraft:recipes/building_blocks/deepslate_brick_stairs" | "create:recipes/building_blocks/small_dripstone_brick_stairs_from_stone_types_dripstone_stonecutting" | "minecraft:recipes/decorations/light_blue_bed" | "biomeswevegone:recipes/misc/pink_dye_from_bwg_tag" | "sophisticatedstorage:recipes/misc/storage_compacting_upgrade_from_backpack_compacting_upgrade" | "justhammers:recipes/tools/netherite_destructor_hammer" | "minecraft:recipes/building_blocks/pink_stained_glass" | "ae2:recipes/misc/network/wireless_part" | "compressium:recipes/building_blocks/diamond_1_uncraft" | "repurposed_structures:strongholds" | "repurposed_structures:root" | "minecraft:recipes/decorations/purple_stained_glass_pane" | "create:recipes/misc/crafting/kinetics/large_cogwheel_from_little" | "minecraft:recipes/building_blocks/black_stained_glass" | "minecraft:recipes/building_blocks/brick_stairs_from_bricks_stonecutting" | "compressium:recipes/building_blocks/endstone_4_uncraft" | "minecraft:recipes/building_blocks/polished_blackstone_brick_stairs_from_polished_blackstone_stonecutting" | "utilitarian:recipes/misc/utility/acacia_logs_to_trapdoors" | "create:hand_crank_000" | "immersiveengineering:recipes/misc/crafting/chute_iron" | "repurposed_structures:igloos" | "immersiveengineering:recipes/misc/crafting/stairs_concrete" | "ae2:recipes/misc/network/cables/covered_fluix_clean" | "minecraft:nether/charge_respawn_anchor" | "naturescompass:natures_compass" | "minecraft:recipes/building_blocks/bamboo_planks" | "minecraft:recipes/building_blocks/cracked_polished_blackstone_bricks" | "chunkloaders:recipes/misc/advanced_chunk_loader" | "minecraft:recipes/building_blocks/gray_stained_glass" | "compressium:recipes/building_blocks/redstone_4_uncraft" | "domum_ornamentum:recipes/tools/cactus_extra" | "biomeswevegone:recipes/building_blocks/stripped_sakura_wood" | "immersiveengineering:recipes/misc/crafting/steel_scaffolding_standard" | "biomeswevegone:recipes/transportation/pine_boat" | "create:mechanical_mixer" | "minecraft:recipes/building_blocks/chiseled_windswept_sandstone_from_windswept_sandstone_stonecutting" | "utilitarian:recipes/misc/utility/warped_logs_to_stairs" | "sophisticatedstorage:recipes/misc/iron_shulker_box" | "minecraft:recipes/decorations/crafting_table" | "immersiveengineering:recipes/misc/crafting/stairs_steel_scaffolding_grate_top" | "create:recipes/misc/crafting/kinetics/portable_storage_interface" | "yungscavebiomes:lost_caves" | "biomeswevegone:recipes/decorations/blue_enchanted_sign" | "create:super_glue" | "yungscavebiomes:recipes/building_blocks/cut_ancient_sandstone_slab_from_stonecutting" | "biomeswevegone:recipes/building_blocks/witch_hazel_stairs" | "biomeswevegone:recipes/redstone/white_mangrove_pressure_plate" | "minecraft:recipes/building_blocks/cut_copper_stairs_from_copper_block_stonecutting" | "minecraft:recipes/misc/map" | "ae2:recipes/misc/network/cables/dense_covered_light_gray" | "minecraft:recipes/decorations/chest" | "minecraft:story/shiny_gear" | "sophisticatedstorage:recipes/misc/paintbrush" | "minecraft:recipes/building_blocks/cobbled_deepslate_slab" | "biomeswevegone:recipes/building_blocks/smooth_blue_sandstone" | "create:recipes/building_blocks/cut_scorchia_wall" | "megacells:recipes/misc/network/cell_dock" | "aquaculture:recipes/tools/golden_fishing_rod" | "compressium:recipes/building_blocks/diorite_4_uncraft" | "ae2:recipes/misc/network/parts/terminals" | "mekanism:plenisher" | "create:recipes/misc/blasting/ingot_tin_compat_ic2" | "immersiveengineering:recipes/misc/crafting/slag_brick_from_slab" | "minecraft:recipes/tools/shears" | "minecraft:recipes/misc/stick" | "minecraft:recipes/redstone/crimson_pressure_plate" | "biomeswevegone:recipes/transportation/ebony_chest_boat" | "lootr:1cart" | "create:funnel" | "ae2:recipes/misc/misc/tiny_tnt" | "minecraft:recipes/redstone/polished_blackstone_button" | "sophisticatedstorage:recipes/misc/storage_filter_upgrade_from_backpack_filter_upgrade" | "connectedglass:recipes/misc/tinted_borderless_glass1" | "connectedglass:recipes/misc/tinted_borderless_glass_orange2" | "woodwevegot:recipes/decorations/florus_barrel" | "immersiveengineering:recipes/misc/crafting/gunpart_barrel" | "connectedglass:recipes/misc/vanilla_glass_pane" | "create:recipes/misc/crafting/materials/andesite_alloy_block" | "create:recipes/building_blocks/cut_andesite_slab" | "immersiveengineering:main/make_steel" | "biomeswevegone:recipes/building_blocks/white_mangrove_wood" | "connectedglass:recipes/misc/borderless_glass_light_blue2" | "minecraft:recipes/brewing/golden_carrot" | "compressium:recipes/building_blocks/stone_8_uncraft" | "apotheosis:enchanting/upgrade_hellshelf" | "sophisticatedstorage:recipes/misc/blasting_upgrade_from_smelting_upgrade" | "connectedglass:recipes/misc/borderless_glass_light_blue1" | "create:recipes/misc/crafting/kinetics/steam_engine" | "minecraft:recipes/building_blocks/pink_terracotta" | "ae2:recipes/misc/network/crafting/1k_cpu_crafting_storage" | "ae2:recipes/misc/network/cells/fluid_storage_cell_16k" | "minecraft:recipes/building_blocks/mossy_cobblestone_stairs_from_mossy_cobblestone_stonecutting" | "minecraft:adventure/summon_iron_golem" | "compressium:recipes/building_blocks/granite_9_uncraft" | "minecraft:recipes/transportation/jungle_chest_boat" | "create:recipes/building_blocks/weathered_copper_shingle_stairs" | "naturalist:recipes/food/cooked_lizard_tail" | "create:recipes/building_blocks/cut_limestone_stairs_from_stone_types_limestone_stonecutting" | "naturalist:recipes/food/cooked_egg" | "aquaculture:recipes/misc/gold_nugget_from_smelting" | "create:recipes/building_blocks/weathered_copper_shingle_slab" | "immersiveengineering:recipes/misc/crafting/blastbrick_from_slab" | "ae2:recipes/misc/network/parts/panels_monitor" | "ae2:recipes/misc/tools/fluix_upgrade_smithing_template" | "immersiveengineering:recipes/misc/crafting/raw_aluminum_to_raw_block_aluminum" | "minecraft:recipes/building_blocks/dye_pink_bed" | "create:recipes/building_blocks/crafting/copper/waxed_exposed_copper_shingle_slab_from_honeycomb" | "create:recipes/building_blocks/cut_dripstone_bricks_from_stone_types_dripstone_stonecutting" | "immersiveengineering:tools/craft_revolver" | "woodwevegot:recipes/redstone/ebony_trapped_chest" | "repurposed_structures:city_nether" | "minecraft:recipes/tools/spyglass" | "immersiveengineering:recipes/misc/crafting/workbench" | "minecraft:recipes/building_blocks/cut_black_sandstone_slab_from_cut_black_sandstone_stonecutting" | "minecraft:recipes/misc/storage_output_from_input" | "minecraft:recipes/redstone/lectern" | "minecraft:recipes/building_blocks/cut_pink_sandstone_slab_from_pink_sandstone_stonecutting" | "create:recipes/building_blocks/cut_crimsite_brick_slab_recycling" | "minecraft:recipes/building_blocks/stone_stairs_from_stone_stonecutting" | "buddingcrystals:recipes/misc/budding_uranium" | "connectedglass:recipes/misc/clear_glass_orange2" | "justhammers:recipes/tools/netherite_hammer" | "connectedglass:recipes/misc/clear_glass_orange1" | "minecraft:recipes/misc/red_dye_from_rose_bush" | "minecraft:recipes/misc/magenta_dye_from_purple_and_pink" | "connectedglass:recipes/misc/scratched_glass_blue_pane1" | "easy_mob_farm:recipes/mob_farm/desert_farm" | "minecraft:recipes/decorations/mossy_stone_brick_wall" | "friendsandfoes:adventure/activate_zombie_horse_trap" | "biomeswevegone:recipes/redstone/jacaranda_trapdoor" | "create:recipes/building_blocks/polished_cut_asurine_stairs_from_stone_types_asurine_stonecutting" | "sophisticatedbackpacks:recipes/misc/filter_upgrade" | "biomeswevegone:recipes/building_blocks/rainbow_eucalyptus_wood" | "sophisticatedstorage:recipes/misc/iron_barrel_from_copper_barrel" | "connectedglass:recipes/misc/scratched_glass_blue_pane3" | "connectedglass:recipes/misc/scratched_glass_blue_pane2" | "woodwevegot:recipes/decorations/zelkova_chest" | "biomeswevegone:recipes/building_blocks/ironwood_bookshelf" | "sophisticatedstorage:recipes/misc/storage_pickup_upgrade_from_backpack_pickup_upgrade" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_light_blue_to_slab" | "mekanism:polonium" | "create:recipes/building_blocks/horizontal_framed_glass_from_glass_colorless_stonecutting" | "minecraft:adventure/sleep_in_bed" | "create:recipes/building_blocks/ochrum_pillar_from_stone_types_ochrum_stonecutting" | "minecraft:recipes/food/cooked_rabbit_from_campfire_cooking" | "minecraft:recipes/building_blocks/cobblestone_slab_from_cobblestone_stonecutting" | "create:recipes/building_blocks/cut_scorchia_brick_slab" | "ae2:recipes/misc/network/cables/covered_red" | "immersiveengineering:recipes/misc/crafting/coil_hv" | "create:recipes/building_blocks/cut_scoria_bricks_from_stone_types_scoria_stonecutting" | "minecraft:recipes/building_blocks/cut_blue_sandstone_slab_from_cut_blue_sandstone_stonecutting" | "easy_mob_farm:recipes/mob_farm/animal_plains_farm" | "minecraft:recipes/building_blocks/prismarine_slab_from_prismarine_stonecutting" | "create:recipes/building_blocks/small_scorchia_brick_slab_from_stone_types_scorchia_stonecutting" | "minecraft:recipes/decorations/birch_sign" | "minecraft:recipes/transportation/cherry_boat" | "minecraft:recipes/building_blocks/chiseled_red_rock_brick_slab_from_chiseled_red_rock_bricks_stonecutting" | "biomeswevegone:recipes/redstone/white_mangrove_door" | "repurposed_structures:mineshafts" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_gray" | "minecraft:recipes/tools/diamond_pickaxe" | "friendsandfoes:nether/kill_wildfire" | "minecraft:recipes/redstone/lightning_rod" | "minecraft:adventure/kill_all_mobs" | "compressium:recipes/building_blocks/granite_3_uncraft" | "minecraft:recipes/decorations/brown_glazed_terracotta" | "immersiveengineering:recipes/misc/stonecutting/concrete_pillar" | "ae2:recipes/misc/network/cables/smart_purple" | "ae2:recipes/misc/network/cells/fluid_storage_cell_256k" | "mekanism:root" | "minecraft:recipes/building_blocks/birch_wood" | "biomeswevegone:recipes/decorations/purple_wool_from_allium_petal_block" | "create:recipes/building_blocks/oxidized_copper_tile_slab_from_oxidized_copper_tiles_stonecutting" | "woodwevegot:recipes/decorations/skyris_ladder" | "compressium:recipes/building_blocks/gold_9_uncraft" | "biomeswevegone:biomeswevegone/husbandry/just_like_grandmas" | "create:recipes/misc/blasting/ingot_silver_compat_immersiveengineering" | "woodwevegot:recipes/decorations/rainbow_eucalyptus_barrel" | "minecraft:recipes/decorations/crimson_sign" | "createoreexcavation:recipes/misc/vein_atlas" | "biomeswevegone:recipes/building_blocks/windswept_sandstone_pillar" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_light_gray" | "create:recipes/building_blocks/crafting/kinetics/light_blue_seat" | "woodwevegot:recipes/redstone/green_enchanted_trapped_chest" | "minecraft:adventure/voluntary_exile" | "immersiveengineering:recipes/misc/smelting/ingot_steel_from_dust_from_blasting" | "domum_ornamentum:recipes/decorations/green_floating_carpet" | "minecraft:recipes/decorations/granite_wall_from_granite_stonecutting" | "minecraft:recipes/building_blocks/polished_blackstone_brick_stairs_from_blackstone_stonecutting" | "biomeswevegone:recipes/building_blocks/aspen_stairs" | "immersiveengineering:recipes/misc/crafting/wirecoil_steel" | "sophisticatedstorage:recipes/misc/storage_advanced_magnet_upgrade_from_backpack_advanced_magnet_upgrade" | "woodwevegot:recipes/decorations/holly_ladder" | "advanced_ae:recipes/misc/step_assist_card" | "minecraft:recipes/building_blocks/polished_blackstone_bricks_from_blackstone_stonecutting" | "create:recipes/misc/smelting/ingot_aluminum_compat_immersiveengineering" | "create:recipes/building_blocks/polished_cut_ochrum_stairs_from_stone_types_ochrum_stonecutting" | "create:recipes/building_blocks/polished_cut_diorite_wall" | "compressium:recipes/building_blocks/stone_2_uncraft" | "create:recipes/misc/crafting/appliances/schedule_clear" | "utilitarian:recipes/misc/no_soliciting/soliciting_carpets/yellow_trapped_soliciting_carpet" | "create:recipes/misc/crafting/kinetics/gearbox" | "minecraft:recipes/building_blocks/cherry_planks" | "immersiveengineering:recipes/misc/crafting/toolupgrade_railgun_capacitors" | "immersiveengineering:recipes/misc/crafting/wire_aluminum" | "connectedglass:recipes/misc/clear_glass_brown_pane1" | "ae2:recipes/misc/misc/deconstruction_cut_certus_quartz_block" | "immersiveengineering:recipes/misc/smelting/ingot_nickel_from_blasting" | "create:recipes/building_blocks/polished_cut_scoria_slab" | "biomeswevegone:recipes/building_blocks/zelkova_bookshelf" | "minecraft:recipes/building_blocks/dye_cyan_bed" | "immersiveengineering:recipes/misc/crafting/connector_mv_relay" | "connectedglass:recipes/misc/vanilla_lime_stained_glass_pane" | "create:recipes/building_blocks/polished_cut_tuff_stairs_from_stone_types_tuff_stonecutting" | "minecraft:recipes/combat/golden_chestplate" | "minecraft:recipes/building_blocks/stripped_dark_oak_wood" | "sophisticatedstorage:recipes/misc/diamond_shulker_from_diamond_chest" | "sophisticatedbackpacks:recipes/misc/feeding_upgrade" | "minecraft:recipes/building_blocks/dye_yellow_wool" | "immersiveengineering:tools/craft_powerpack" | "ae2:recipes/misc/network/cables/smart_lime" | "immersiveengineering:recipes/misc/crafting/copper_ingot_to_nugget_copper" | "create:recipes/misc/crafting/logistics/brass_tunnel" | "create:recipes/misc/crafting/logistics/pulse_repeater" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_purple" | "create:extendo_grip_dual" | "woodwevegot:recipes/redstone/willow_trapped_chest" | "biomeswevegone:recipes/building_blocks/blue_sandstone_stairs" | "minecraft:recipes/decorations/white_sandstone_wall_from_white_sandstone_stonecutting" | "minecraft:recipes/building_blocks/iron_block" | "compressium:recipes/building_blocks/netherite_6_uncraft" | "ae2:recipes/misc/network/cables/dense_covered_brown" | "immersiveengineering:recipes/misc/crafting/storage_electrum_from_slab" | "minecraft:recipes/misc/red_dye_from_poppy" | "yungscavebiomes:recipes/building_blocks/layered_red_sandstone_from_stonecutting" | "biomeswevegone:recipes/redstone/skyris_button" | "create:recipes/misc/smelting/bread" | "immersiveengineering:recipes/misc/crafting/sheetmetal_lead_to_slab" | "mekanism:advanced_qio_drive" | "minecraft:recipes/building_blocks/smooth_red_sandstone_stairs" | "connectedglass:recipes/misc/clear_glass_brown_pane3" | "connectedglass:recipes/misc/clear_glass_brown_pane2" | "minecraft:recipes/building_blocks/clay" | "create:recipes/building_blocks/small_granite_brick_stairs" | "create:mechanical_crafter" | "create:recipes/misc/crafting/kinetics/furnace_minecart_from_contraption_cart" | "ae2:recipes/misc/network/cells/fluid_storage_cell_1k_storage" | "create:recipes/misc/crafting/kinetics/green_valve_handle_from_other_valve_handle" | "domum_ornamentum:recipes/tools/pink_brick_extra" | "sophisticatedbackpacks:recipes/misc/advanced_compacting_upgrade" | "create:recipes/misc/blasting/iron_ingot_from_crushed" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_orange" | "biomeswevegone:recipes/redstone/green_enchanted_button" | "sophisticatedstorage:recipes/misc/basic_to_copper_tier_upgrade" | "biomeswevegone:recipes/building_blocks/aspen_bookshelf" | "create:recipes/building_blocks/small_dripstone_brick_slab" | "ae2:recipes/misc/tools/certus_quartz_sword" | "minecraft:recipes/decorations/birch_hanging_sign" | "minecraft:recipes/transportation/mangrove_chest_boat" | "sophisticatedstorage:recipes/misc/storage_output" | "minecraft:recipes/decorations/deepslate_tile_wall_from_deepslate_bricks_stonecutting" | "create:recipes/building_blocks/cut_asurine_brick_slab" | "connectedglass:recipes/misc/clear_glass_red2" | "minecraft:recipes/decorations/gray_carpet" | "ae2:recipes/misc/tools/paintballs_red" | "minecraft:recipes/decorations/deepslate_tile_wall" | "minecraft:recipes/redstone/tripwire_hook" | "connectedglass:recipes/misc/clear_glass_cyan2" | "connectedglass:recipes/misc/clear_glass_cyan1" | "connectedglass:recipes/misc/clear_glass_red1" | "create:recipes/misc/crafting/kinetics/wooden_bracket" | "compressium:recipes/building_blocks/soulsand_5_uncraft" | "create:recipes/misc/crafting/kinetics/weighted_ejector" | "woodwevegot:recipes/decorations/witch_hazel_barrel" | "immersiveengineering:recipes/misc/crafting/armor_steel_helmet" | "megacells:recipes/misc/cells/standard/fluid_storage_cell_4m_with_housing" | "comforts:sleeping_bag_brown" | "minecraft:recipes/redstone/birch_fence_gate" | "create:recipes/misc/smelting/zinc_ingot_from_raw_ore" | "minecraft:recipes/redstone/stone_button" | "ae2:recipes/misc/network/cables/dense_smart_lime" | "woodwevegot:recipes/decorations/jacaranda_barrel" | "immersiveengineering:recipes/misc/crafting/stairs_alu_scaffolding_wooden_top" | "betterdungeons:small_dungeon" | "minecraft:recipes/building_blocks/packed_mud" | "woodwevegot:recipes/decorations/cypress_barrel" | "create:recipes/building_blocks/cut_dripstone_brick_stairs" | "ae2:recipes/misc/network/parts/terminals_crafting" | "woodwevegot:recipes/decorations/willow_ladder" | "domum_ornamentum:recipes/tools/architectscutter" | "create:spout" | "domum_ornamentum:recipes/tools/beige_stone_bricks" | "minecraft:recipes/building_blocks/smooth_sandstone_slab" | "ae2:recipes/misc/network/wireless_crafting_terminal" | "advanced_ae:recipes/misc/sprint_speed_card" | "minecraft:recipes/building_blocks/blue_terracotta" | "connectedglass:recipes/misc/clear_glass_light_gray_pane1" | "connectedglass:recipes/misc/clear_glass_light_gray_pane2" | "connectedglass:recipes/misc/clear_glass_light_gray_pane3" | "minecraft:recipes/building_blocks/stone" | "ae2:recipes/misc/network/cables/dense_smart_from_smart" | "biomeswevegone:recipes/decorations/blue_enchanted_hanging_sign" | "minecraft:recipes/decorations/green_carpet" | "biomeswevegone:recipes/building_blocks/ebony_stairs" | "minecraft:recipes/building_blocks/light_blue_terracotta" | "immersiveengineering:recipes/misc/crafting/plate_lead_hammering" | "biomeswevegone:recipes/redstone/rainbow_eucalyptus_door" | "minecraft:recipes/building_blocks/chiseled_white_sandstone_from_white_sandstone_stonecutting" | "minecraft:recipes/transportation/bamboo_raft" | "woodwevegot:recipes/decorations/palm_chest" | "ae2:recipes/misc/network/parts/panels_semi_dark_monitor_alt" | "compressium:recipes/building_blocks/copper_9_uncraft" | "minecraft:recipes/building_blocks/cut_red_sandstone" | "create:recipes/building_blocks/small_crimsite_brick_slab_recycling" | "sophisticatedbackpacks:recipes/misc/battery_upgrade" | "minecraft:recipes/building_blocks/white_sandstone_slab_from_white_sandstone_stonecutting" | "create:recipes/building_blocks/small_rose_quartz_tiles_from_polished_rose_quartz_stonecutting" | "minecraft:recipes/building_blocks/mossy_stone_brick_slab" | "solcarrot:recipes/food_book" | "immersiveengineering:recipes/misc/stonecutting/slab_concrete_brick" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_magenta_to_slab" | "minecraft:recipes/decorations/purple_carpet" | "domum_ornamentum:recipes/decorations/orange_floating_carpet" | "minecraft:recipes/building_blocks/cut_copper" | "biomeswevegone:recipes/redstone/palm_door" | "immersiveengineering:recipes/misc/crafting/electric_lantern" | "minecraft:recipes/redstone/stone_pressure_plate" | "apotheosis:enchanting/enchanter" | "minecraft:recipes/building_blocks/polished_blackstone_slab" | "yungscavebiomes:recipes/building_blocks/ancient_sandstone_slab" | "aquaculture:recipes/misc/bonemeal_from_fish_bones" | "immersiveengineering:recipes/misc/stonecutting/concrete_pillar2" | "ae2:recipes/misc/tools/portable_fluid_cell_16k" | "create:recipes/building_blocks/polished_cut_granite_wall" | "minecraft:recipes/misc/netherite_ingot" | "create:recipes/building_blocks/small_granite_brick_stairs_from_stone_types_granite_stonecutting" | "create:recipes/building_blocks/cut_ochrum_brick_slab_recycling" | "buddingcrystals:recipes/misc/budding_uraninite" | "minecraft:recipes/building_blocks/dye_lime_bed" | "sophisticatedstorage:recipes/misc/backpack_filter_upgrade_from_storage_filter_upgrade" | "immersiveengineering:recipes/misc/crafting/fluid_pump" | "biomeswevegone:recipes/building_blocks/ironwood_stairs" | "ae2:recipes/misc/network/cables/dense_smart_blue" | "immersiveengineering:recipes/misc/smelting/nugget_steel_recycle_axe_from_blasting" | "sophisticatedstorage:recipes/misc/basic_to_iron_tier_from_basic_to_copper_tier" | "minecraft:adventure/spyglass_at_dragon" | "create:recipes/building_blocks/cut_ochrum_slab_from_stone_types_ochrum_stonecutting" | "biomeswevegone:recipes/redstone/witch_hazel_door" | "ae2:recipes/misc/decorative/quartz_vibrant_glass" | "advanced_ae:recipes/misc/quantum_chestplate_item_reset" | "immersiveengineering:tools/secret_ravenholm" | "ae2:recipes/misc/network/cables/dense_covered_pink" | "utilitarian:recipes/misc/utility/birch_logs_to_trapdoors" | "sophisticatedbackpacks:recipes/misc/advanced_jukebox_upgrade" | "biomeswevegone:recipes/building_blocks/palm_bookshelf" | "connectedglass:recipes/misc/vanilla_light_blue_stained_glass_pane" | "sophisticatedbackpacks:recipes/misc/advanced_deposit_upgrade" | "immersiveengineering:recipes/misc/smelting/nugget_steel_recycle_pick" | "sophisticatedstorage:recipes/misc/dark_oak_chest_from_quark_dark_oak_chest" | "connectedglass:recipes/misc/borderless_glass_white2" | "create:recipes/misc/crafting/kinetics/large_water_wheel" | "create:recipes/building_blocks/deepslate_from_stone_types_deepslate_stonecutting" | "connectedglass:recipes/misc/borderless_glass_white1" | "ae2:recipes/misc/network/cables/smart_blue" | "minecraft:adventure/trade_at_world_height" | "sophisticatedstorage:recipes/misc/auto_smoking_upgrade" | "ae2:recipes/misc/network/cells/item_storage_components_cell_64k_part" | "create:recipes/misc/crafting/kinetics/speedometerfrom_conversion" | "sophisticatedstorage:recipes/misc/jungle_chest" | "minecraft:recipes/decorations/red_sandstone_wall_from_red_sandstone_stonecutting" | "minecraft:recipes/food/cookie" | "connectedglass:recipes/misc/borderless_glass_yellow_pane1" | "megacells:recipes/misc/crafting/sky_steel_ingot_from_sky_steel_block" | "comforts:hammock_brown" | "minecraft:recipes/decorations/light_blue_stained_glass_pane_from_glass_pane" | "woodwevegot:recipes/decorations/mahogany_chest" | "minecraft:recipes/building_blocks/acacia_stairs" | "create:recipes/building_blocks/small_asurine_brick_slab_recycling" | "create:recipes/building_blocks/small_diorite_brick_slab_from_stone_types_diorite_stonecutting" | "biomeswevegone:recipes/decorations/ironwood_hanging_sign" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_stairs_from_waxed_exposed_copper_stonecutting" | "minecraft:recipes/misc/budding_amethyst" | "compressium:recipes/building_blocks/emerald_1_uncraft" | "create:recipes/building_blocks/small_veridium_brick_stairs" | "connectedglass:recipes/misc/borderless_glass_yellow_pane3" | "minecraft:recipes/misc/fire_charge" | "connectedglass:recipes/misc/borderless_glass_yellow_pane2" | "minecraft:recipes/decorations/soul_torch" | "immersiveengineering:tools/secret_bttf" | "justhammers:recipes/tools/stone_destructor_hammer" | "create:recipes/misc/crafting/materials/andesite_alloy" | "minecraft:recipes/building_blocks/yellow_terracotta" | "biomeswevegone:recipes/redstone/witch_hazel_trapdoor" | "biomeswevegone:recipes/building_blocks/ebony_bookshelf" | "minecraft:recipes/misc/writable_book" | "sophisticatedstorage:recipes/misc/feeding_upgrade" | "utilitarian:recipes/misc/no_soliciting/soliciting_carpets/brown_trapped_soliciting_carpet" | "utilitarian:recipes/misc/no_soliciting/soliciting_carpets/light_blue_trapped_soliciting_carpet" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_light_gray_to_slab" | "create:recipes/building_blocks/polished_cut_granite_stairs" | "immersiveengineering:recipes/misc/crafting/fiberboard" | "advanced_ae:recipes/misc/lava_immunity_card" | "minecraft:recipes/building_blocks/smooth_white_sandstone_stairs_from_white_sandstone_stonecutting" | "minecraft:recipes/decorations/candle" | "justhammers:recipes/tools/iron_reinforced_hammer" | "create:recipes/combat/crafting/appliances/netherite_backtank_from_netherite" | "biomeswevegone:recipes/redstone/redwood_pressure_plate" | "minecraft:recipes/food/bread" | "immersiveengineering:recipes/misc/crafting/metal_ladder_alu" | "sophisticatedstorage:recipes/misc/stack_upgrade_tier_1" | "sophisticatedstorage:recipes/misc/stack_upgrade_tier_2" | "immersiveengineering:recipes/misc/smelting/ingot_silver_from_dust" | "repurposed_structures:witch_huts" | "minecraft:nether/obtain_ancient_debris" | "minecraft:recipes/misc/bone_meal_from_bone_block" | "create:recipes/building_blocks/cut_tuff_stairs_from_stone_types_tuff_stonecutting" | "compressium:recipes/building_blocks/netherite_2_uncraft" | "ae2:recipes/misc/decorative/fluix_block" | "minecraft:recipes/decorations/magenta_candle" | "compressium:recipes/building_blocks/diamond_2_uncraft" | "create:recipes/building_blocks/cut_veridium_wall_from_stone_types_veridium_stonecutting" | "minecraft:recipes/building_blocks/exposed_cut_copper_stairs_from_exposed_copper_stonecutting" | "compressium:recipes/building_blocks/granite_4_uncraft" | "sophisticatedstorage:recipes/misc/storage_stonecutter_upgrade_from_backpack_stonecutter_upgrade" | "minecraft:nether/create_full_beacon" | "ae2:recipes/misc/tools/paintballs_lumen_gray" | "sophisticatedstorage:recipes/misc/stack_upgrade_tier_3" | "create:recipes/building_blocks/tuff_from_stone_types_tuff_stonecutting" | "immersiveengineering:recipes/misc/crafting/windmill_blade" | "sophisticatedstorage:recipes/misc/stack_upgrade_tier_4" | "mekanism:waste_removal" | "minecraft:recipes/building_blocks/diorite" | "sophisticatedstorage:recipes/misc/stack_upgrade_tier_5" | "immersiveengineering:recipes/misc/crafting/blastbrick_reinforced" | "minecraft:recipes/building_blocks/dye_white_bed" | "create:recipes/building_blocks/small_calcite_brick_stairs_from_stone_types_calcite_stonecutting" | "minecraft:recipes/decorations/spruce_hanging_sign" | "megacells:recipes/misc/cells/portable/portable_fluid_cell_1m" | "minecraft:recipes/building_blocks/polished_granite_from_granite_stonecutting" | "biomeswevegone:recipes/building_blocks/willow_planks" | "create:recipes/building_blocks/cut_calcite_bricks_from_stone_types_calcite_stonecutting" | "create:recipes/building_blocks/cut_veridium_stairs_from_stone_types_veridium_stonecutting" | "sophisticatedstorage:recipes/misc/advanced_filter_upgrade" | "ae2:recipes/misc/tools/paintballs_light_blue" | "minecraft:recipes/building_blocks/oxidized_cut_copper_slab_from_oxidized_copper_stonecutting" | "minecraft:recipes/building_blocks/red_rock_bricks_from_red_rock_stonecutting" | "easy_mob_farm:recipes/upgrade/enchancement/loot_enhancement" | "create:recipes/misc/crafting/logistics/brass_funnel" | "minecraft:recipes/building_blocks/birch_slab" | "minecraft:recipes/building_blocks/dacite_cobblestone_slab_from_dacite_cobblestone_stonecutting" | "minecraft:recipes/misc/raw_gold" | "create:cart_pickup" | "sophisticatedstorage:recipes/misc/mangrove_chest_from_quark_mangrove_chest" | "connectedglass:recipes/misc/clear_glass_light_gray1" | "utilitarian:recipes/misc/utility/jungle_logs_to_trapdoors" | "create:potato_cannon_collide" | "connectedglass:recipes/misc/clear_glass_light_gray2" | "immersiveengineering:recipes/misc/crafting/conveyor_dropper" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_slab_from_honeycomb" | "sophisticatedstorage:recipes/misc/stack_upgrade_tier_1_plus" | "create:recipes/building_blocks/copper_tiles_from_ingots_copper_stonecutting" | "minecraft:recipes/decorations/oak_hanging_sign" | "minecraft:recipes/misc/shulker_box_from_vanilla_shulker_box" | "minecraft:recipes/building_blocks/dye_lime_carpet" | "minecraft:recipes/building_blocks/polished_blackstone_stairs_from_blackstone_stonecutting" | "create:recipes/building_blocks/small_veridium_brick_wall_from_stone_types_veridium_stonecutting" | "create:recipes/building_blocks/cut_veridium_brick_stairs_from_stone_types_veridium_stonecutting" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_stairs" | "minecraft:recipes/redstone/redstone_from_smelting_redstone_ore" | "minecraft:recipes/building_blocks/hay_block" | "minecraft:recipes/misc/leather_horse_armor" | "immersiveengineering:recipes/misc/crafting/toolupgrade_powerpack_tesla" | "compressium:recipes/building_blocks/diorite_9_uncraft" | "create:recipes/building_blocks/crafting/copper/waxed_copper_shingle_slab_from_honeycomb" | "ae2:recipes/misc/block_cutter/walls/fluix_wall" | "create:recipes/building_blocks/weathered_copper_shingle_stairs_from_weathered_copper_shingles_stonecutting" | "minecraft:recipes/building_blocks/granite" | "immersiveengineering:tools/upgrade_powerpack" | "minecraft:recipes/building_blocks/cut_sandstone_slab_from_cut_sandstone_stonecutting" | "immersiveengineering:recipes/misc/crafting/clinker_brick_sill" | "create:recipes/building_blocks/cut_granite_brick_slab" | "connectedglass:recipes/misc/vanilla_pink_stained_glass_pane" | "create:recipes/building_blocks/polished_cut_limestone_slab_recycling" | "sophisticatedstorage:recipes/misc/limited_diamond_barrel_1" | "biomeswevegone:recipes/redstone/skyris_door" | "biomeswevegone:recipes/building_blocks/ironwood_slab" | "sophisticatedstorage:recipes/misc/limited_diamond_barrel_2" | "minecraft:recipes/misc/emerald_from_smelting_deepslate_emerald_ore" | "sophisticatedstorage:recipes/misc/limited_diamond_barrel_3" | "immersiveengineering:recipes/misc/crafting/ingot_nickel_to_nugget_nickel" | "sophisticatedstorage:recipes/misc/limited_diamond_barrel_4" | "minecraft:recipes/transportation/oak_chest_boat" | "biomeswevegone:recipes/decorations/blue_sandstone_wall" | "minecraft:recipes/redstone/target" | "immersiveengineering:multiblocks/mb_dieselgen" | "immersiveengineering:recipes/misc/crafting/gunpart_drum" | "compressium:recipes/building_blocks/andesite_4_uncraft" | "immersiveengineering:recipes/misc/crafting/circuit_table" | "repurposed_structures:ancient_cities" | "ae2:recipes/misc/block_cutter/slabs/sky_stone_slab" | "minecraft:recipes/redstone/crimson_door" | "create:recipes/misc/smelting/lead_ingot_compat_oreganized" | "buddingcrystals:recipes/misc/budding_bronze" | "minecraft:recipes/misc/copper_ingot_from_waxed_copper_block" | "minecraft:recipes/building_blocks/windswept_sandstone_slab_from_windswept_sandstone_stonecutting" | "immersiveengineering:recipes/misc/smelting/slag_glass" | "minecraft:recipes/redstone/acacia_door" | "create:recipes/misc/crafting/appliances/copper_diving_helmet" | "immersiveengineering:recipes/misc/crafting/storage_constantan_from_slab" | "sophisticatedstorage:recipes/misc/compacting_upgrade" | "minecraft:recipes/misc/tide_armor_trim_smithing_template" | "naturalist:recipes/naturalist/limestone" | "ae2:recipes/misc/network/blocks/interfaces_interface" | "ae2:recipes/misc/network/parts/quartz_fiber_part" | "minecraft:recipes/decorations/spruce_fence" | "compressium:recipes/building_blocks/quartz_5_uncraft" | "minecraft:recipes/tools/diamond_hoe" | "domum_ornamentum:recipes/decorations/cyan_floating_carpet" | "minecraft:recipes/transportation/activator_rail" | "minecraft:recipes/building_blocks/dark_oak_stairs" | "minecraft:recipes/tools/diamond_shovel" | "minecraft:recipes/building_blocks/polished_granite_slab_from_polished_granite_stonecutting" | "compressium:recipes/building_blocks/gravel_5_uncraft" | "minecraft:husbandry/safely_harvest_honey" | "sophisticatedbackpacks:recipes/misc/netherite_backpack" | "create:recipes/building_blocks/polished_cut_ochrum_slab_from_stone_types_ochrum_stonecutting" | "minecraft:recipes/building_blocks/granite_slab" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_from_honeycomb" | "sophisticatedstorage:recipes/misc/stonecutter_upgrade" | "ae2:recipes/misc/network/parts/panels_dark_monitor" | "immersiveengineering:recipes/misc/smelting/ingot_nickel2" | "minecraft:recipes/decorations/dacite_wall_from_dacite_stonecutting" | "immersiveengineering:recipes/misc/smelting/ingot_nickel3" | "minecraft:adventure/spyglass_at_ghast" | "minecraft:adventure/trim_with_any_armor_pattern" | "minecraft:nether/uneasy_alliance" | "immersiveengineering:recipes/misc/crafting/storage_nickel_to_slab" | "biomeswevegone:recipes/redstone/ebony_fence_gate" | "advanced_ae:recipes/misc/quantum_alloy_slab" | "compressium:recipes/building_blocks/emerald_5_uncraft" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_light_blue_from_slab" | "utilitarian:recipes/misc/utility/green_dye" | "minecraft:recipes/building_blocks/polished_blackstone_brick_stairs_from_polished_blackstone_bricks_stonecutting" | "connectedglass:recipes/misc/borderless_glass_orange_pane3" | "biomeswevegone:recipes/building_blocks/jacaranda_stairs" | "connectedglass:recipes/misc/borderless_glass_orange_pane2" | "biomeswevegone:recipes/building_blocks/rainbow_eucalyptus_planks" | "connectedglass:recipes/misc/borderless_glass_orange_pane1" | "immersiveengineering:recipes/misc/crafting/craftingtable" | "minecraft:recipes/redstone/redstone_from_blasting_redstone_ore" | "create:recipes/building_blocks/small_limestone_brick_slab" | "sophisticatedstorage:recipes/misc/crimson_chest" | "dankstorage:recipes/tools/6_to_7" | "create:recipes/building_blocks/cut_ochrum_brick_slab_from_stone_types_ochrum_stonecutting" | "utilitarian:recipes/misc/no_soliciting/soliciting_carpets/blue_soliciting_carpet" | "compressium:recipes/building_blocks/endstone_9_uncraft" | "domum_ornamentum:recipes/tools/roan_stone_bricks" | "woodwevegot:recipes/decorations/cika_barrel" | "woodwevegot:recipes/decorations/blue_enchanted_chest" | "biomeswevegone:recipes/building_blocks/cypress_stairs" | "compressium:recipes/building_blocks/sand_6_uncraft" | "create:long_train" | "immersiveengineering:recipes/misc/crafting/treated_wood_vertical_from_horizontal" | "create:recipes/misc/blasting/ingot_tin_compat_mekanism" | "minecraft:recipes/decorations/blue_sandstone_wall_from_blue_sandstone_stonecutting" | "create:recipes/building_blocks/cut_granite_from_stone_types_granite_stonecutting" | "minecraft:recipes/building_blocks/polished_diorite_stairs_from_diorite_stonecutting" | "immersiveengineering:recipes/misc/crafting/wire_electrum" | "woodwevegot:recipes/decorations/fir_ladder" | "biomeswevegone:recipes/food/cooked_yucca_fruit_from_camfire" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_tier_3" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_tier_4" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_tier_1" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_tier_2" | "create:recipes/building_blocks/cut_scorchia_brick_stairs_from_stone_types_scorchia_stonecutting" | "immersiveengineering:recipes/misc/smelting/ingot_electrum_from_dust_from_blasting" | "minecraft:recipes/building_blocks/dye_black_carpet" | "biomeswevegone:recipes/building_blocks/ironwood_wood" | "immersiveengineering:recipes/misc/crafting/storage_nickel_to_ingot_nickel" | "ae2:recipes/misc/misc/deconstruction_smooth_certus_quartz_block" | "minecraft:recipes/building_blocks/waxed_copper_block_from_honeycomb" | "connectedglass:recipes/misc/scratched_glass_orange2" | "minecraft:recipes/building_blocks/weathered_cut_copper" | "connectedglass:recipes/misc/scratched_glass_orange1" | "create:recipes/building_blocks/cut_scorchia_slab_from_stone_types_scorchia_stonecutting" | "ae2:recipes/misc/decorative/chiseled_quartz_block" | "compressium:recipes/building_blocks/coal_5_uncraft" | "minecraft:recipes/redstone/warped_trapdoor" | "create:recipes/misc/crafting/kinetics/mechanical_plough" | "ae2:recipes/misc/shaped/slabs/smooth_sky_stone_block" | "create:recipes/misc/smelting/tin_ingot_compat_thermal" | "sophisticatedstorage:recipes/misc/dark_oak_limited_barrel_2" | "immersiveengineering:recipes/misc/crafting/raw_block_nickel_to_raw_nickel" | "sophisticatedstorage:recipes/misc/dark_oak_limited_barrel_1" | "immersiveengineering:recipes/misc/stonecutting/concrete_brick" | "sophisticatedstorage:recipes/misc/dark_oak_limited_barrel_4" | "immersiveengineering:recipes/misc/crafting/raw_block_silver_to_raw_silver" | "sophisticatedstorage:recipes/misc/dark_oak_limited_barrel_3" | "utilitarian:recipes/misc/utility/cherry_logs_to_slabs" | "minecraft:recipes/building_blocks/dye_brown_wool" | "minecraft:recipes/redstone/light_weighted_pressure_plate" | "immersiveengineering:recipes/misc/crafting/strip_curtain" | "sophisticatedstorage:recipes/misc/storage_magnet_upgrade_from_backpack_magnet_upgrade" | "yungscavebiomes:frosted_caves" | "minecraft:adventure/throw_trident" | "create:recipes/building_blocks/cut_limestone_brick_slab_from_stone_types_limestone_stonecutting" | "immersiveengineering:recipes/misc/crafting/insulating_glass_to_slab" | "create:recipes/misc/crafting/kinetics/belt_connector" | "minecraft:recipes/building_blocks/mossy_cobblestone_slab" | "biomeswevegone:recipes/decorations/green_enchanted_sign" | "domum_ornamentum:recipes/tools/light_gray_brick_extra" | "connectedglass:recipes/misc/borderless_glass_brown_pane2" | "minecraft:recipes/misc/conduit" | "connectedglass:recipes/misc/borderless_glass_brown_pane3" | "create:recipes/building_blocks/spruce_window" | "biomeswevegone:recipes/building_blocks/stripped_cypress_wood" | "connectedglass:recipes/misc/borderless_glass_brown_pane1" | "create:recipes/building_blocks/cut_asurine_slab" | "mekanism:hydrogen_powered_flight" | "naturalist:recipes/naturalist/smooth_limestone_stairs" | "easy_mob_farm:recipes/upgrade/slot/small_slot_upgrade" | "ae2:main/presses" | "minecraft:recipes/building_blocks/prismarine_stairs_from_prismarine_stonecutting" | "minecraft:recipes/building_blocks/polished_andesite_stairs_from_polished_andesite_stonecutting" | "minecraft:recipes/decorations/green_candle" | "ae2:recipes/misc/network/cables/dense_covered_yellow" | "immersiveengineering:recipes/misc/crafting/toolupgrade_shield_flash" | "minecraft:recipes/pamhc2foodcore/smelting_roastedsunflowerseedsitem" | "sophisticatedstorage:recipes/misc/smoking_upgrade" | "biomeswevegone:recipes/redstone/florus_pressure_plate" | "advanced_ae:recipes/misc/regeneration_card" | "compressium:recipes/building_blocks/clay_4_uncraft" | "minecraft:recipes/building_blocks/polished_deepslate_stairs_from_cobbled_deepslate_stonecutting" | "connectedglass:recipes/misc/clear_glass_brown1" | "connectedglass:recipes/misc/clear_glass_brown2" | "biomeswevegone:recipes/building_blocks/sandy_dirt" | "sophisticatedbackpacks:recipes/misc/blasting_upgrade_from_smelting_upgrade" | "immersiveengineering:recipes/misc/smelting/ingot_constantan_from_dust" | "connectedglass:recipes/misc/clear_glass_black_pane1" | "connectedglass:recipes/misc/clear_glass_black_pane2" | "connectedglass:recipes/misc/clear_glass_black_pane3" | "biomeswevegone:recipes/decorations/florus_fence" | "mekanism:ultimate_control_circuit" | "biomeswevegone:recipes/redstone/mahogany_door" | "sophisticatedstorage:recipes/misc/backpack_auto_smelting_upgrade_from_storage_auto_smelting_upgrade" | "minecraft:recipes/decorations/bamboo_fence" | "biomeswevegone:recipes/transportation/zelkova_chest_boat" | "ae2:recipes/misc/network/cells/fluid_cell_housing" | "create:recipes/misc/crafting/logistics/content_observer" | "biomeswevegone:recipes/decorations/palm_fence" | "minecraft:recipes/building_blocks/polished_granite_slab" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_from_waxed_weathered_copper_stonecutting" | "utilitarian:recipes/misc/no_soliciting/soliciting_carpets/brown_soliciting_carpet" | "minecraft:recipes/redstone/repeater" | "minecraft:recipes/tools/compass" | "create:recipes/misc/crafting/kinetics/fluid_pipe_vertical" | "biomeswevegone:recipes/building_blocks/smooth_white_sandstone_stairs" | "immersiveengineering:recipes/misc/crafting/sawdust" | "minecraft:adventure/ol_betsy" | "biomeswevegone:recipes/building_blocks/cut_windswept_sandstone_slab" | "minecraft:recipes/building_blocks/quartz_block" | "compressium:recipes/building_blocks/snow_3" | "sophisticatedstorage:recipes/misc/backpack_feeding_upgrade_from_storage_feeding_upgrade" | "compressium:recipes/building_blocks/snow_4" | "compressium:recipes/building_blocks/snow_5" | "minecraft:recipes/decorations/gray_candle" | "ae2:recipes/misc/network/blocks/quantum_ring" | "compressium:recipes/building_blocks/snow_6" | "minecraft:recipes/building_blocks/mossy_cobblestone_from_vine" | "compressium:recipes/building_blocks/snow_7" | "compressium:recipes/building_blocks/snow_8" | "biomeswevegone:recipes/building_blocks/dacite_pillar" | "compressium:recipes/building_blocks/snow_9" | "connectedglass:recipes/misc/clear_glass_light_blue_pane2" | "ae2:recipes/misc/network/cables/dense_smart_brown" | "connectedglass:recipes/misc/clear_glass_light_blue_pane1" | "create:recipes/building_blocks/cut_crimsite_brick_slab" | "utilitarian:recipes/misc/no_soliciting/soliciting_carpets/cyan_soliciting_carpet" | "connectedglass:recipes/misc/clear_glass_light_blue_pane3" | "compressium:recipes/building_blocks/iron_2_uncraft" | "compressium:recipes/building_blocks/stone_3_uncraft" | "apotheosis:enchanting/bookshelf" | "ae2:recipes/misc/network/blocks/crystal_processing_growth_accelerator" | "megacells:recipes/misc/crafting/mega_crafting_unit" | "utilitarian:recipes/misc/no_soliciting/soliciting_carpets/green_soliciting_carpet" | "minecraft:recipes/pamhc2foodcore/smelting_cookedgroundchickenitem" | "apotheosis:spawner/nearbyents" | "minecraft:recipes/decorations/cyan_bed" | "utilitarian:recipes/misc/utility/birch_logs_to_pressure_plates" | "sophisticatedstorage:recipes/misc/spruce_limited_barrel_2" | "explorerscompass:explorers_compass" | "sophisticatedstorage:recipes/misc/spruce_limited_barrel_1" | "create:recipes/building_blocks/polished_cut_dripstone_wall" | "sophisticatedstorage:recipes/misc/spruce_limited_barrel_4" | "sophisticatedstorage:recipes/misc/spruce_limited_barrel_3" | "minecraft:nether/netherite_armor" | "minecraft:recipes/building_blocks/birch_stairs" | "minecraft:recipes/building_blocks/jungle_stairs" | "biomeswevegone:recipes/building_blocks/baobab_bookshelf" | "minecraft:recipes/building_blocks/purpur_pillar" | "minecraft:recipes/food/pumpkin_pie" | "minecraft:recipes/decorations/end_rod" | "minecraft:recipes/misc/host_armor_trim_smithing_template_smithing_trim" | "justhammers:recipes/tools/gold_reinforced_impact_hammer" | "create:recipes/building_blocks/small_veridium_brick_slab_recycling" | "immersiveengineering:recipes/misc/smelting/ingot_nickel" | "create:recipes/building_blocks/cut_calcite_stairs" | "compressium:recipes/building_blocks/gold_5_uncraft" | "compressium:recipes/building_blocks/snow_1_uncraft" | "create:recipes/building_blocks/polished_cut_ochrum_wall" | "minecraft:husbandry/breed_an_animal" | "create:recipes/building_blocks/polished_cut_deepslate_wall_from_stone_types_deepslate_stonecutting" | "minecraft:recipes/combat/netherite_helmet_smithing" | "minecraft:husbandry/complete_catalogue" | "minecraft:recipes/decorations/gray_stained_glass_pane_from_glass_pane" | "immersiveengineering:recipes/misc/crafting/alu_scaffolding_wooden_top_from_slab" | "minecraft:recipes/building_blocks/stripped_spruce_wood" | "create:recipes/building_blocks/small_tuff_brick_slab_from_stone_types_tuff_stonecutting" | "immersiveengineering:recipes/misc/smelting/nugget_steel_recycle_steel_boots_from_blasting" | "biomeswevegone:recipes/redstone/maple_trapdoor" | "minecraft:recipes/decorations/brown_stained_glass_pane" | "immersiveengineering:recipes/misc/crafting/toolupgrade_drill_damage" | "create:recipes/misc/crafting/kinetics/mechanical_pump" | "ae2:recipes/misc/decorative/sky_stone_small_brick_from_stonecutting" | "biomeswevegone:recipes/building_blocks/blue_enchanted_stairs" | "compressium:recipes/building_blocks/snow_1" | "compressium:recipes/building_blocks/snow_2" | "woodwevegot:recipes/decorations/blue_enchanted_ladder" | "biomeswevegone:biomeswevegone/husbandry/granny_smith" | "connectedglass:recipes/misc/borderless_glass_lime_pane2" | "connectedglass:recipes/misc/borderless_glass_lime_pane1" | "biomeswevegone:biomeswevegone/husbandry/hot_diggity_not_dog" | "create:recipes/building_blocks/deepslate_pillar_from_stone_types_deepslate_stonecutting" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_stairs_from_honeycomb" | "connectedglass:recipes/misc/borderless_glass_lime_pane3" | "minecraft:recipes/building_blocks/mossy_cobblestone_stairs" | "ae2:recipes/misc/network/cables/smart_fluix" | "immersiveengineering:multiblocks/mb_fermenter" | "create:recipes/misc/crafting/logistics/display_link" | "ae2:main/charged_quartz" | "ae2:recipes/misc/tools/fluix_shovel" | "biomeswevegone:recipes/building_blocks/pink_sandstone_stairs" | "biomeswevegone:recipes/transportation/rainbow_eucalyptus_boat" | "biomeswevegone:recipes/building_blocks/smooth_pink_sandstone_stairs" | "immersiveengineering:recipes/misc/crafting/slag_brick_to_slab" | "comforts:sleeping_bag_light_blue" | "minecraft:recipes/building_blocks/stripped_cherry_wood" | "biomeswevegone:recipes/building_blocks/willow_bookshelf" | "minecraft:recipes/decorations/gray_glazed_terracotta" | "minecraft:recipes/misc/light_blue_dye_from_blue_orchid" | "biomeswevegone:recipes/building_blocks/white_sandstone_slab" | "minecraft:recipes/building_blocks/red_nether_brick_slab_from_red_nether_bricks_stonecutting" | "sophisticatedstorage:recipes/misc/controller" | "immersiveengineering:recipes/misc/crafting/capacitor_lv" | "minecraft:recipes/building_blocks/exposed_cut_copper_stairs" | "minecraft:recipes/building_blocks/lime_concrete_powder" | "create:recipes/building_blocks/crimson_window" | "create:recipes/building_blocks/cut_granite_brick_stairs_from_stone_types_granite_stonecutting" | "justhammers:recipes/tools/stone_impact_hammer" | "trashcans:recipes/misc/ultimate_trash_can" | "minecraft:recipes/building_blocks/copper_block" | "minecraft:recipes/building_blocks/dark_prismarine_stairs_from_dark_prismarine_stonecutting" | "create:train_portal" | "minecraft:recipes/redstone/spruce_button" | "sophisticatedbackpacks:recipes/misc/xp_pump_upgrade" | "biomeswevegone:recipes/decorations/fir_hanging_sign" | "minecraft:recipes/misc/popped_chorus_fruit" | "biomeswevegone:recipes/building_blocks/aspen_slab" | "minecraft:nether/distract_piglin" | "sophisticatedstorage:recipes/misc/storage_stack_upgrade_tier_2_from_backpack_stack_upgrade_tier_1" | "biomeswevegone:recipes/building_blocks/smooth_purple_sandstone" | "merequester:recipes/requester_terminal" | "compressium:recipes/building_blocks/coal_1_uncraft" | "minecraft:recipes/misc/flower_banner_pattern" | "ae2:recipes/misc/smelting/smooth_sky_stone_block" | "ae2:recipes/misc/tools/paintballs_lime" | "megacells:recipes/misc/cells/standard/fluid_storage_cell_1m" | "immersiveengineering:tools/craft_buzzsaw" | "connectedglass:recipes/misc/clear_glass_blue_pane3" | "ae2:recipes/misc/network/cables/dense_covered_red" | "connectedglass:recipes/misc/clear_glass_blue_pane2" | "buddingcrystals:recipes/misc/budding_refinedglowstone" | "minecraft:recipes/building_blocks/sandstone_stairs" | "sophisticatedbackpacks:recipes/misc/void_upgrade" | "minecraft:recipes/redstone/dark_oak_door" | "comforts:hammock_purple" | "minecraft:recipes/misc/coal_from_smelting_deepslate_coal_ore" | "create:mechanical_pump_0" | "create:brass" | "create:recipes/building_blocks/polished_cut_limestone_from_stone_types_limestone_stonecutting" | "minecraft:recipes/food/dried_kelp_from_smoking" | "minecraft:recipes/redstone/hopper" | "create:recipes/misc/crafting/kinetics/mechanical_harvester" | "repurposed_structures:bastion_underground" | "immersiveengineering:recipes/misc/smelting/concrete_brick_cracked" | "create:recipes/building_blocks/polished_cut_veridium_stairs_from_stone_types_veridium_stonecutting" | "apotheosis:enchanting/quanta100" | "biomeswevegone:recipes/decorations/mahogany_crafting_table" | "woodwevegot:recipes/decorations/rainbow_eucalyptus_ladder" | "immersiveengineering:recipes/misc/crafting/shield" | "lootr:1shulker" | "minecraft:recipes/redstone/calibrated_sculk_sensor" | "create:recipes/building_blocks/cut_dripstone_stairs_from_stone_types_dripstone_stonecutting" | "immersiveengineering:recipes/misc/crafting/capacitor_mv" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_from_waxed_oxidized_copper_stonecutting" | "connectedglass:recipes/misc/clear_glass_blue_pane1" | "minecraft:recipes/misc/netherite_drill_smithing" | "minecraft:recipes/building_blocks/oxidized_cut_copper_stairs_from_oxidized_copper_stonecutting" | "minecraft:recipes/misc/lime_dye" | "immersiveengineering:recipes/misc/smelting/ingot_uranium_from_dust_from_blasting" | "create:recipes/misc/crafting/materials/zinc_ingot_from_compacting" | "minecraft:recipes/misc/gold_ingot_from_smelting_raw_gold" | "yungscavebiomes:the_snack_that_bites_back" | "advanced_ae:recipes/misc/advpatpro2" | "immersiveengineering:recipes/misc/crafting/toolupgrade_shield_magnet" | "immersiveengineering:recipes/misc/stonecutting/slab_slag_brick" | "minecraft:recipes/building_blocks/smooth_basalt" | "create:recipes/building_blocks/small_andesite_brick_stairs_from_stone_types_andesite_stonecutting" | "immersiveengineering:recipes/misc/smelting/nugget_steel_recycle_shovel" | "create:recipes/misc/crafting/palettes/scorchia" | "minecraft:recipes/misc/shaper_armor_trim_smithing_template" | "create:recipes/building_blocks/small_dripstone_bricks_from_stone_types_dripstone_stonecutting" | "megacells:recipes/building_blocks/crafting/sky_steel_block" | "immersiveengineering:recipes/misc/crafting/treated_wood_packaged_from_slab" | "sophisticatedstorage:recipes/misc/bamboo_chest_from_quark_bamboo_chest" | "create:recipes/misc/smoking/bread" | "minecraft:recipes/building_blocks/tinted_glass" | "minecraft:recipes/building_blocks/dye_blue_wool" | "sophisticatedbackpacks:recipes/misc/smelting_upgrade" | "immersiveengineering:recipes/misc/smelting/ingot_aluminum_from_dust_from_blasting" | "advanced_ae:recipes/misc/throughput_monitor_configurator" | "create:recipes/building_blocks/polished_cut_scoria_stairs" | "biomeswevegone:recipes/decorations/pink_sandstone_wall" | "megacells:recipes/misc/cells/standard/fluid_storage_cell_16m" | "minecraft:recipes/redstone/comparator" | "minecraft:recipes/redstone/mangrove_pressure_plate" | "immersiveengineering:recipes/misc/crafting/capacitor_hv" | "immersiveengineering:recipes/misc/crafting/wall_slag_brick" | "create:recipes/building_blocks/polished_cut_granite_from_stone_types_granite_stonecutting" | "immersiveengineering:recipes/misc/crafting/sheetmetal_iron" | "minecraft:recipes/decorations/deepslate_brick_wall_from_cobbled_deepslate_stonecutting" | "create:recipes/building_blocks/small_asurine_brick_stairs_from_stone_types_asurine_stonecutting" | "immersiveengineering:recipes/misc/crafting/thermoelectric_generator" | "create:recipes/misc/crafting/appliances/tree_fertilizer" | "minecraft:recipes/building_blocks/red_stained_glass" | "trashcans:recipes/misc/liquid_trash_can" | "minecraft:adventure/very_very_frightening" | "ae2:recipes/misc/decorative/certus_quartz_bricks_from_stonecutting" | "minecraft:story/lava_bucket" | "compressium:recipes/building_blocks/emerald_1" | "biomeswevegone:recipes/transportation/ironwood_chest_boat" | "utilitarian:recipes/misc/utility/logs_to_bowls" | "minecraft:recipes/building_blocks/quartz_stairs" | "create:recipes/building_blocks/cut_crimsite_wall" | "woodwevegot:recipes/decorations/baobab_ladder" | "create:recipes/building_blocks/polished_cut_crimsite_stairs_from_stone_types_crimsite_stonecutting" | "ae2:recipes/misc/materials/carddistribution" | "compressium:recipes/building_blocks/emerald_8" | "minecraft:recipes/misc/copper_ingot_from_blasting_raw_copper" | "compressium:recipes/building_blocks/emerald_9" | "immersiveengineering:recipes/misc/crafting/string" | "compressium:recipes/building_blocks/emerald_6" | "compressium:recipes/building_blocks/emerald_7" | "megacells:recipes/misc/cells/portable/portable_item_cell_256m" | "sophisticatedstorage:recipes/misc/mangrove_limited_barrel_4" | "connectedglass:recipes/misc/tinted_borderless_glass_magenta2" | "compressium:recipes/building_blocks/emerald_4" | "sophisticatedstorage:recipes/misc/mangrove_limited_barrel_3" | "connectedglass:recipes/misc/scratched_glass_black1" | "compressium:recipes/building_blocks/emerald_5" | "biomeswevegone:recipes/building_blocks/fir_stairs" | "sophisticatedstorage:recipes/misc/mangrove_limited_barrel_2" | "minecraft:recipes/pamhc2foodcore/smoking_cookedgroundrabbititem" | "ae2:main/crafting_cpu" | "compressium:recipes/building_blocks/emerald_2" | "sophisticatedstorage:recipes/misc/mangrove_limited_barrel_1" | "compressium:recipes/building_blocks/emerald_3" | "connectedglass:recipes/misc/scratched_glass_black2" | "minecraft:recipes/decorations/black_bed" | "create:recipes/building_blocks/small_deepslate_brick_slab_from_stone_types_deepslate_stonecutting" | "create:recipes/building_blocks/layered_scoria_from_stone_types_scoria_stonecutting" | "minecraft:husbandry/ride_a_boat_with_a_goat" | "ae2:recipes/misc/network/cables/covered_light_blue" | "create:recipes/building_blocks/crafting/kinetics/red_seat_from_other_seat" | "aquaculture:recipes/misc/brown_mushroom_from_fish" | "lootr:social" | "ae2:recipes/misc/decorative/cut_quartz_block_from_stonecutting" | "mekanism:qio_exporter" | "easy_mob_farm:crafting/mob_farm_template/tier0_mob_farm_template" | "immersiveengineering:recipes/misc/crafting/sheetmetal_electrum_from_slab" | "sophisticatedstorage:recipes/misc/blasting_upgrade" | "connectedglass:recipes/misc/scratched_glass1" | "minecraft:recipes/building_blocks/polished_deepslate_from_cobbled_deepslate_stonecutting" | "biomeswevegone:recipes/building_blocks/red_rock_brick_stairs" | "sophisticatedbackpacks:recipes/misc/backpack" | "ae2:recipes/misc/block_cutter/slabs/smooth_sky_stone_slab" | "mekanism:injection_chamber" | "create:recipes/building_blocks/cut_granite_brick_slab_recycling" | "minecraft:recipes/food/cooked_beef_from_smoking" | "utilitarian:recipes/misc/utility/acacia_logs_to_pressure_plates" | "create:recipes/building_blocks/polished_cut_dripstone_slab_recycling" | "minecraft:recipes/decorations/pink_stained_glass_pane" | "fulleng:recipes/misc/terminals/part_terminal_from_block" | "megacells:recipes/misc/cells/portable/portable_item_cell_16m" | "biomeswevegone:recipes/building_blocks/smooth_purple_sandstone_stairs" | "connectedglass:recipes/misc/vanilla_cyan_stained_glass_pane" | "minecraft:nether/all_potions" | "minecraft:recipes/misc/emerald_from_blasting_emerald_ore" | "compressium:recipes/building_blocks/obsidian_7_uncraft" | "compressium:recipes/building_blocks/dirt_1_uncraft" | "minecraft:recipes/misc/diamond_from_smelting_deepslate_diamond_ore" | "create:recipes/building_blocks/cut_andesite_bricks_from_stone_types_andesite_stonecutting" | "minecraft:recipes/combat/netherite_boots_smithing" | "minecraft:recipes/misc/light_blue_dye_from_blue_white_dye" | "naturalist:recipes/naturalist/string_from_cattail_fluff" | "minecraft:recipes/building_blocks/mossy_red_rock_brick_stairs_from_mossy_red_rock_bricks_stonecutting" | "ae2:main/network3" | "create:recipes/building_blocks/cut_dripstone_wall_from_stone_types_dripstone_stonecutting" | "ae2:main/network2" | "ae2:recipes/misc/shaped/stairs/cut_quartz_block" | "ae2:main/network1" | "minecraft:recipes/building_blocks/orange_concrete_powder" | "minecraft:recipes/food/cooked_porkchop" | "minecraft:recipes/building_blocks/oak_slab" | "mekanism:network_reader" | "apotheosis:spawner/spawncount" | "ae2:recipes/misc/block_cutter/slabs/cut_quartz_slab" | "minecraft:husbandry/tame_an_animal" | "create:recipes/building_blocks/crafting/kinetics/orange_seat_from_other_seat" | "ae2:recipes/misc/network/parts/monitors_storage" | "repurposed_structures:shipwrecks" | "minecraft:recipes/building_blocks/chiseled_polished_blackstone" | "minecraft:recipes/building_blocks/raw_copper_block" | "minecraft:recipes/building_blocks/granite_stairs" | "sophisticatedstorage:recipes/misc/storage_input" | "minecraft:recipes/decorations/cyan_glazed_terracotta" | "create:recipes/building_blocks/small_andesite_bricks_from_stone_types_andesite_stonecutting" | "connectedglass:recipes/misc/borderless_glass_blue_pane1" | "utilitarian:recipes/misc/no_soliciting/soliciting_carpets/light_gray_soliciting_carpet" | "minecraft:recipes/building_blocks/dye_red_bed" | "biomeswevegone:recipes/building_blocks/smooth_black_sandstone_stairs" | "connectedglass:recipes/misc/borderless_glass_blue_pane3" | "biomeswevegone:recipes/decorations/black_sandstone_wall" | "connectedglass:recipes/misc/borderless_glass_blue_pane2" | "minecraft:recipes/building_blocks/dye_black_bed" | "minecraft:recipes/tools/brush" | "dimstorage:dimensional_tablet" | "biomeswevegone:recipes/building_blocks/pine_wood" | "biomeswevegone:recipes/transportation/green_enchanted_chest_boat" | "minecraft:recipes/decorations/cyan_candle" | "minecraft:recipes/building_blocks/diorite_stairs_from_diorite_stonecutting" | "compressium:recipes/building_blocks/obsidian_4_uncraft" | "sophisticatedstorage:recipes/misc/copper_to_netherite_tier_upgrade" | "minecraft:recipes/building_blocks/stripped_acacia_wood" | "biomeswevegone:recipes/food/cooked_oddion_bulb_from_smoker" | "minecraft:recipes/misc/leather" | "create:recipes/building_blocks/cut_dripstone_from_stone_types_dripstone_stonecutting" | "create:recipes/misc/crafting/curiosities/minecart_coupling" | "create:recipes/building_blocks/cut_veridium_from_stone_types_veridium_stonecutting" | "biomeswevegone:recipes/decorations/blue_enchanted_fence" | "minecraft:recipes/building_blocks/windswept_sandstone_stairs_from_windswept_sandstone_stonecutting" | "minecraft:recipes/decorations/light_gray_bed" | "create:recipes/building_blocks/acacia_window_pane" | "immersiveengineering:tools/craft_chemthrower" | "minecraft:recipes/building_blocks/blackstone_stairs" | "ae2:recipes/misc/tools/paintballs_lumen_black" | "minecraft:recipes/building_blocks/dacite_brick_stairs_from_dacite_bricks_stonecutting" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_magenta_from_slab" | "connectedglass:recipes/misc/scratched_glass_blue2" | "create:windmill_maxed" | "compressium:recipes/building_blocks/redsand_7_uncraft" | "connectedglass:recipes/misc/scratched_glass_blue1" | "create:recipes/misc/crafting/kinetics/deployer" | "domum_ornamentum:recipes/tools/wheat_extra" | "connectedglass:recipes/misc/vanilla_orange_stained_glass" | "compressium:recipes/building_blocks/lapis_1_uncraft" | "create:recipes/building_blocks/polished_cut_tuff_wall_from_stone_types_tuff_stonecutting" | "create:recipes/misc/crafting/appliances/copper_diving_boots" | "create:recipes/building_blocks/cut_limestone_wall_from_stone_types_limestone_stonecutting" | "buddingcrystals:recipes/misc/budding_glowstone" | "minecraft:recipes/transportation/bamboo_chest_raft" | "minecraft:recipes/decorations/cyan_banner" | "ae2:recipes/misc/decorative/certus_quartz_pillar" | "immersiveengineering:recipes/misc/crafting/toolupgrade_drill_fortune" | "utilitarian:recipes/misc/utility/gold_block_from_blasting" | "minecraft:recipes/decorations/red_banner" | "minecraft:recipes/building_blocks/raw_gold_block" | "minecraft:recipes/building_blocks/dye_red_wool" | "minecraft:recipes/combat/iron_boots" | "immersiveengineering:recipes/misc/smelting/ingot_electrum_from_dust" | "minecraft:recipes/building_blocks/birch_planks" | "sophisticatedstorage:recipes/misc/gold_barrel" | "biomeswevegone:recipes/redstone/rainbow_eucalyptus_button" | "ae2:recipes/misc/network/cells/item_storage_components_cell_16k_part" | "restrictedportals:end" | "biomeswevegone:recipes/building_blocks/redwood_slab" | "comforts:sleeping_bag_white" | "ae2:main/storage_bus" | "woodwevegot:recipes/decorations/redwood_chest" | "dimstorage:root" | "ae2:recipes/misc/block_cutter/slabs/quartz_brick_slab" | "easy_mob_farm:recipes/mob_farm/monster_plains_cave_farm" | "create:recipes/building_blocks/acacia_window" | "biomeswevegone:recipes/building_blocks/cypress_bookshelf" | "create:recipes/misc/smelting/glass_from_tiled_glass" | "create:track_0" | "minecraft:recipes/building_blocks/polished_blackstone_slab_from_blackstone_stonecutting" | "minecraft:recipes/misc/gold_ingot_from_blasting_deepslate_gold_ore" | "minecraft:recipes/redstone/spruce_pressure_plate" | "minecraft:recipes/building_blocks/granite_stairs_from_granite_stonecutting" | "minecraft:recipes/building_blocks/prismarine_brick_stairs_from_prismarine_stonecutting" | "minecraft:recipes/misc/gold_ingot_from_blasting_gold_ore" | "mekanism:configuration_copying" | "mekanism:plutonium" | "minecraft:recipes/decorations/magenta_glazed_terracotta" | "ae2:recipes/misc/network/blocks/energy_energy_cell" | "ae2:recipes/misc/tools/certus_quartz_spade" | "woodwevegot:recipes/decorations/mahogany_ladder" | "mekanism:liquifier" | "create:recipes/misc/crafting/kinetics/clutch" | "compressium:recipes/building_blocks/granite_2_uncraft" | "create:recipes/building_blocks/polished_cut_deepslate_stairs" | "compressium:recipes/building_blocks/sand_4_uncraft" | "ae2wtlib:recipes/wireless_universal_terminal/upgrade_pattern_encoding" | "minecraft:recipes/building_blocks/polished_granite_stairs_from_polished_granite_stonecutting" | "immersiveengineering:recipes/misc/smelting/iron_ingot_from_dust_from_blasting" | "ae2:recipes/misc/network/parts/energy_acceptor" | "biomeswevegone:recipes/transportation/willow_chest_boat" | "sophisticatedbackpacks:recipes/misc/refill_upgrade" | "mekanism:portable_qio_dashboard" | "biomeswevegone:recipes/building_blocks/stripped_florus_wood" | "biomeswevegone:recipes/misc/black_dye_from_bwg_tag" | "utilitarian:recipes/misc/utility/dark_oak_logs_to_stairs" | "minecraft:recipes/building_blocks/mud_brick_stairs" | "immersiveengineering:recipes/misc/crafting/alu_scaffolding_grate_top_from_standard" | "ae2:recipes/misc/network/parts/cable_anchor" | "apotheosis:spawner/light" | "minecraft:recipes/building_blocks/dye_blue_carpet" | "compressium:recipes/building_blocks/redstone_3_uncraft" | "ae2wtlib:recipes/wireless_universal_terminal/ce" | "create:recipes/building_blocks/cut_dripstone_stairs" | "biomeswevegone:recipes/decorations/white_mangrove_hanging_sign" | "sophisticatedstorage:recipes/misc/advanced_void_upgrade" | "create:recipes/building_blocks/copper_tile_stairs" | "megacells:recipes/misc/crafting/greater_energy_card" | "minecraft:recipes/building_blocks/dye_light_gray_wool" | "create:recipes/misc/crafting/curiosities/cake" | "ae2:recipes/misc/network/crafting/16k_cpu_crafting_storage" | "minecraft:recipes/decorations/magenta_banner" | "minecraft:recipes/building_blocks/mossy_red_rock_bricks_from_vine" | "minecraft:recipes/tools/stone_pickaxe" | "create:recipes/building_blocks/cut_deepslate_stairs_from_stone_types_deepslate_stonecutting" | "compressium:recipes/building_blocks/diorite_2_uncraft" | "create:recipes/building_blocks/polished_cut_scorchia_stairs_from_stone_types_scorchia_stonecutting" | "immersiveengineering:main/secret_luckofthedraw" | "create:recipes/misc/crafting/kinetics/depot" | "ae2wtlib:recipes/wireless_universal_terminal/ca" | "minecraft:recipes/decorations/deepslate_brick_wall" | "immersiveengineering:recipes/misc/smelting/nugget_steel_recycle_steel_leggings_from_blasting" | "yungscavebiomes:recipes/building_blocks/layered_sandstone" | "immersiveengineering:recipes/misc/crafting/drill" | "sophisticatedstorage:recipes/misc/limited_iron_barrel_2_from_limited_copper_barrel_2" | "minecraft:recipes/misc/black_dye" | "immersiveengineering:recipes/misc/crafting/light_engineering" | "minecraft:recipes/building_blocks/light_gray_stained_glass" | "biomeswevegone:recipes/redstone/zelkova_pressure_plate" | "minecraft:recipes/food/honey_bottle" | "immersiveengineering:recipes/misc/crafting/armor_faraday_leggings" | "biomeswevegone:recipes/redstone/pine_door" | "compressium:recipes/building_blocks/endstone_5_uncraft" | "compressium:recipes/building_blocks/redstone_9_uncraft" | "compressium:recipes/building_blocks/clay_5" | "compressium:recipes/building_blocks/clay_6" | "compressium:recipes/building_blocks/clay_7" | "create:recipes/building_blocks/layered_calcite_from_stone_types_calcite_stonecutting" | "compressium:recipes/building_blocks/clay_8" | "advanced_ae:recipes/misc/strength_card" | "compressium:recipes/building_blocks/clay_9" | "minecraft:recipes/misc/light_gray_dye_from_gray_white_dye" | "minecraft:recipes/building_blocks/chiseled_blue_sandstone_from_blue_sandstone_stonecutting" | "create:recipes/building_blocks/small_crimsite_brick_wall" | "minecraft:recipes/decorations/acacia_sign" | "immersiveengineering:recipes/misc/crafting/sawblade" | "ae2:recipes/misc/network/cables/covered_purple" | "ae2:recipes/misc/shaped/stairs/quartz_pillar" | "minecraft:recipes/building_blocks/brick_slab" | "create:recipes/combat/crafting/appliances/netherite_backtank" | "biomeswevegone:recipes/food/allium_oddion_soup" | "minecraft:recipes/misc/iron_ingot_from_smelting_iron_ore" | "ae2:recipes/misc/network/cells/spatial_storage_cell_2_cubed_storage" | "biomeswevegone:recipes/building_blocks/cut_pink_sandstone_slab" | "biomeswevegone:recipes/building_blocks/chiseled_purple_sandstone" | "minecraft:recipes/decorations/lantern" | "sophisticatedstorage:recipes/misc/cherry_chest" | "lootr:50loot" | "minecraft:recipes/decorations/cherry_sign" | "create:recipes/building_blocks/cut_scorchia_brick_slab_recycling" | "immersiveengineering:recipes/misc/crafting/plate_aluminum_hammering" | "connectedglass:recipes/misc/scratched_glass_white_pane1" | "connectedglass:recipes/misc/scratched_glass_white_pane2" | "ae2:recipes/misc/network/blocks/storage_chest" | "connectedglass:recipes/misc/scratched_glass_white_pane3" | "create:recipes/misc/crafting/kinetics/minecart_from_contraption_cart" | "sophisticatedstorage:recipes/misc/diamond_chest" | "biomeswevegone:recipes/redstone/redwood_fence_gate" | "mekanismtools:loved_by_piglins" | "biomeswevegone:recipes/food/white_puffball_stew" | "megacells:recipes/misc/cells/standard/fluid_storage_cell_4m" | "sophisticatedstorage:recipes/misc/backpack_pickup_upgrade_from_storage_pickup_upgrade" | "easy_mob_farm:recipes/upgrade/slot/big_slot_upgrade" | "biomeswevegone:recipes/redstone/maple_pressure_plate" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_tier_1_from_starter" | "sophisticatedbackpacks:recipes/misc/stonecutter_upgrade" | "fulleng:recipes/misc/terminals/part_pattern_encoding_terminal_from_block" | "ae2:recipes/misc/tools/paintballs_brown" | "immersiveengineering:recipes/misc/crafting/conveyor_vertical_covered" | "immersiveengineering:tools/secret_birthdayparty" | "minecraft:recipes/building_blocks/cobbled_deepslate_slab_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/building_blocks/smooth_black_sandstone_slab_from_black_sandstone_stonecutting" | "biomeswevegone:recipes/decorations/willow_crafting_table" | "megacells:recipes/misc/cells/portable/portable_fluid_cell_4m" | "create:recipes/building_blocks/cut_diorite_brick_slab_recycling" | "create:recipes/building_blocks/ornate_iron_window" | "create:recipes/misc/crafting/kinetics/attribute_filter" | "minecraft:recipes/misc/orange_dye_from_red_yellow" | "create:recipes/building_blocks/cut_crimsite_slab_recycling" | "compressium:recipes/building_blocks/clay_1" | "immersiveengineering:recipes/misc/crafting/plate_nickel_hammering" | "compressium:recipes/building_blocks/clay_2" | "compressium:recipes/building_blocks/clay_3" | "compressium:recipes/building_blocks/clay_4" | "immersiveengineering:recipes/misc/crafting/blastbrick_reinforced_to_slab" | "compressium:recipes/building_blocks/gold_2_uncraft" | "immersiveengineering:recipes/misc/crafting/conveyor_basic_covered" | "minecraft:adventure/fall_from_world_height" | "minecraft:recipes/misc/gold_ingot_from_blasting_nether_gold_ore" | "create:fist_bump" | "minecraft:recipes/building_blocks/dye_orange_bed" | "biomeswevegone:recipes/decorations/rainbow_eucalyptus_hanging_sign" | "minecraft:recipes/food/rabbit_stew_from_brown_mushroom" | "connectedglass:recipes/misc/clear_glass_cyan_pane3" | "connectedglass:recipes/misc/clear_glass_cyan_pane2" | "connectedglass:recipes/misc/clear_glass_cyan_pane1" | "immersiveengineering:recipes/misc/crafting/storage_lead_to_slab" | "create:recipes/building_blocks/crafting/copper/waxed_oxidized_copper_shingle_stairs_from_honeycomb" | "minecraft:recipes/building_blocks/magenta_concrete_powder" | "minecraft:recipes/decorations/blue_bed" | "immersiveengineering:recipes/misc/crafting/raw_block_uranium_to_raw_uranium" | "sophisticatedstorage:recipes/misc/copper_to_diamond_tier_upgrade" | "minecraft:recipes/decorations/green_bed" | "create:recipes/building_blocks/cut_scorchia_brick_stairs" | "immersiveengineering:recipes/misc/crafting/ingot_steel_to_storage_steel" | "sophisticatedstorage:recipes/misc/spruce_barrel_from_vanilla_barrel" | "compressium:recipes/building_blocks/quartz_8_uncraft" | "minecraft:recipes/building_blocks/cut_sandstone_from_sandstone_stonecutting" | "utilitarian:recipes/misc/utility/gold_block_from_smelting" | "hangglider:recipes/tools/glider_wing" | "megacells:recipes/misc/crafting/mega_crafting_accelerator" | "create:recipes/building_blocks/crafting/copper/waxed_weathered_copper_tile_slab_from_honeycomb" | "minecraft:recipes/decorations/campfire" | "advanced_ae:recipes/misc/throughput_monitor" | "compressium:recipes/building_blocks/snow_9_uncraft" | "compressium:recipes/building_blocks/clay_3_uncraft" | "minecraft:recipes/decorations/lime_stained_glass_pane" | "sophisticatedstorage:recipes/misc/backpack_stack_upgrade_tier_3_from_storage_stack_upgrade_tier_4" | "minecraft:recipes/misc/snout_armor_trim_smithing_template" | "minecraft:recipes/transportation/hopper_minecart" | "minecraft:recipes/building_blocks/deepslate_tile_slab_from_cobbled_deepslate_stonecutting" | "sophisticatedstorage:recipes/misc/advanced_jukebox_upgrade" | "biomeswevegone:recipes/food/golden_apple_from_green_apple" | "sophisticatedstorage:recipes/misc/black_shulker_box_to_sophisticated" | "advanced_ae:recipes/misc/hp_buffer_card" | "repurposed_structures:city_overworld" | "ae2:recipes/misc/block_cutter/walls/quartz_pillar_wall" | "create:recipes/building_blocks/cut_ochrum_brick_wall" | "buildinggadgets2:recipes/misc/gadget_cut_paste" | "immersiveengineering:recipes/misc/smelting/nugget_steel_recycle_shovel_from_blasting" | "apotheosis:enchanting/60ench" | "biomeswevegone:recipes/building_blocks/aspen_wood" | "sophisticatedbackpacks:recipes/misc/chipped/botanist_workbench_upgrade" | "advanced_ae:recipes/misc/quantumaccel" | "minecraft:recipes/building_blocks/terracotta" | "minecraft:recipes/misc/red_dye_from_beetroot" | "biomeswevegone:recipes/decorations/zelkova_fence" | "ae2:recipes/misc/tools/paintballs_lumen_green" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_green" | "create:display_link" | "biomeswevegone:recipes/building_blocks/holly_wood" | "biomeswevegone:recipes/decorations/cika_fence" | "biomeswevegone:recipes/building_blocks/cut_blue_sandstone_slab" | "create:recipes/building_blocks/scoria_pillar_from_stone_types_scoria_stonecutting" | "minecraft:recipes/redstone/jungle_trapdoor" | "minecraft:recipes/tools/wooden_hoe" | "create:recipes/building_blocks/polished_cut_scorchia_from_stone_types_scorchia_stonecutting" | "sophisticatedbackpacks:recipes/misc/pickup_upgrade" | "utilitarian:recipes/misc/no_soliciting/soliciting_carpets/lime_trapped_soliciting_carpet" | "immersiveengineering:recipes/misc/crafting/toolupgrade_revolver_electro" | "compressium:recipes/building_blocks/redstone_8" | "compressium:recipes/building_blocks/redstone_9" | "compressium:recipes/building_blocks/redstone_6" | "compressium:recipes/building_blocks/redstone_7" | "sophisticatedstorage:recipes/misc/dark_oak_chest" | "minecraft:recipes/building_blocks/chiseled_purple_sandstone_from_purple_sandstone_stonecutting" | "minecraft:recipes/building_blocks/chiseled_sandstone_from_sandstone_stonecutting" | "compressium:recipes/building_blocks/redstone_4" | "naturalist:husbandry/feed_bear_honeycomb" | "minecraft:recipes/building_blocks/polished_deepslate_slab_from_polished_deepslate_stonecutting" | "compressium:recipes/building_blocks/redstone_5" | "ae2wtlib:recipes/wireless_universal_terminal/upgrade_crafting" | "compressium:recipes/building_blocks/redstone_2" | "easy_mob_farm:recipes/upgrade/enchancement/experience_enhancement" | "ae2wtlib:recipes/wireless_universal_terminal/ae" | "compressium:recipes/building_blocks/redstone_3" | "immersiveengineering:recipes/misc/crafting/blueprint_bullets" | "minecraft:recipes/decorations/granite_wall" | "compressium:recipes/building_blocks/iron_1_uncraft" | "ae2:recipes/misc/network/cables/glass_fluix" | "create:recipes/building_blocks/copper_tile_slab_from_copper_tiles_stonecutting" | "minecraft:recipes/building_blocks/mossy_red_rock_bricks_from_moss_block" | "megacells:recipes/misc/network/mega_pattern_provider" | "mekanism:energy_transport" | "compressium:recipes/building_blocks/copper_3_uncraft" | "immersiveengineering:recipes/misc/crafting/armor_faraday_boots" | "minecraft:recipes/building_blocks/orange_terracotta" | "compressium:recipes/building_blocks/redstone_1" | "minecraft:recipes/misc/silence_armor_trim_smithing_template" | "sophisticatedstorage:recipes/misc/oak_chest" | "create:recipes/misc/crafting/schematics/schematicannon" | "biomeswevegone:recipes/building_blocks/pine_slab" | "minecraft:recipes/food/cooked_chicken_from_smoking" | "minecraft:recipes/redstone/oak_fence_gate" | "connectedglass:recipes/misc/borderless_glass_red2" | "compressium:recipes/building_blocks/cobblestone_6_uncraft" | "domum_ornamentum:recipes/tools/blue_brick_extra" | "create:recipes/building_blocks/cut_deepslate_brick_slab_recycling" | "connectedglass:recipes/misc/borderless_glass_red1" | "create:recipes/misc/crafting/kinetics/metal_girder" | "minecraft:husbandry/bred_all_animals" | "immersiveengineering:recipes/misc/crafting/lead_white" | "woodwevegot:recipes/decorations/palm_ladder" | "immersiveengineering:recipes/misc/crafting/rs_engineering" | "biomeswevegone:recipes/redstone/palm_button" | "create:recipes/building_blocks/cut_asurine_brick_stairs" | "domum_ornamentum:recipes/tools/cobblestone_extra" | "betterdeserttemples:temple_entry" | "create:recipes/building_blocks/cut_diorite_stairs" | "create:recipes/building_blocks/cut_tuff_slab" | "biomeswevegone:recipes/redstone/aspen_button" | "compressium:recipes/building_blocks/stone_7_uncraft" | "create:saw_processing" | "ae2:recipes/misc/network/cables/covered_yellow" | "minecraft:recipes/misc/charcoal" | "minecraft:recipes/building_blocks/stone_brick_slab" | "sophisticatedstorage:recipes/misc/acacia_limited_barrel_4" | "immersiveengineering:recipes/misc/crafting/electromagnet" | "sophisticatedstorage:recipes/misc/acacia_limited_barrel_3" | "minecraft:recipes/redstone/cherry_pressure_plate" | "minecraft:recipes/redstone/warped_pressure_plate" | "immersiveengineering:recipes/misc/crafting/armor_faraday_helmet" | "mekanism:pump" | "compressium:recipes/building_blocks/soulsand_2_uncraft" | "utilitarian:recipes/misc/no_soliciting/no_soliciting_banner" | "minecraft:recipes/building_blocks/polished_granite_slab_from_granite_stonecutting" | "ae2:recipes/misc/block_cutter/walls/sky_stone_small_brick_wall" | "minecraft:recipes/building_blocks/polished_andesite_from_andesite_stonecutting" | "ae2:recipes/misc/tools/nether_quartz_pickaxe" | "compressium:recipes/building_blocks/andesite_1_uncraft" | "minecraft:recipes/tools/iron_shovel" | "biomeswevegone:recipes/building_blocks/cattail_thatch_slab" | "mekanism:teleporter" | "create:recipes/building_blocks/cut_asurine_slab_from_stone_types_asurine_stonecutting" | "biomeswevegone:recipes/building_blocks/skyris_slab" | "sophisticatedstorage:recipes/misc/acacia_limited_barrel_2" | "ae2:recipes/misc/network/cells/spatial_storage_cell_16_cubed_storage" | "sophisticatedstorage:recipes/misc/acacia_limited_barrel_1" | "immersiveengineering:recipes/misc/smelting/nugget_aluminum_recycle_faraday_helmet_from_blasting" | "sophisticatedbackpacks:recipes/misc/jukebox_upgrade" | "create:recipes/misc/crafting/kinetics/lime_valve_handle_from_other_valve_handle" | "minecraft:recipes/food/cooked_salmon_from_campfire_cooking" | "create:recipes/misc/crafting/materials/brass_block_from_compacting" | "biomeswevegone:recipes/building_blocks/baobab_slab" | "minecraft:recipes/decorations/item_frame" | "minecraft:recipes/building_blocks/waxed_cut_copper_slab" | "utilitarian:recipes/misc/utility/spruce_logs_to_trapdoors" | "compressium:recipes/building_blocks/cobblestone_3_uncraft" | "minecraft:recipes/building_blocks/cut_copper_slab" | "immersiveengineering:tools/upgrade_drill" | "immersiveengineering:recipes/misc/crafting/hempcrete_from_slab" | "minecraft:recipes/building_blocks/red_rock_slab_from_red_rock_stonecutting" | "create:recipes/building_blocks/cut_andesite_brick_wall" | "minecraft:recipes/decorations/dacite_cobblestone_wall_from_dacite_cobblestone_stonecutting" | "create:recipes/building_blocks/cut_veridium_stairs" | "mekanism:radiation_prevention" | "create:recipes/building_blocks/cut_crimsite_from_stone_types_crimsite_stonecutting" | "utilitarian:recipes/misc/no_soliciting/soliciting_carpets/white_soliciting_carpet" | "create:recipes/building_blocks/jungle_window_pane" | "sophisticatedstorage:recipes/misc/magenta_shulker_box_to_sophisticated" | "create:recipes/building_blocks/crimson_window_pane" | "minecraft:recipes/pamhc2foodcore/campfire_cookedgroundmuttonitem" | "create:recipes/misc/crafting/kinetics/shaft" | "utilitarian:recipes/misc/no_soliciting/soliciting_carpets/orange_trapped_soliciting_carpet" | "create:recipes/building_blocks/small_ochrum_brick_slab" | "minecraft:recipes/redstone/bamboo_pressure_plate" | "advanced_ae:recipes/misc/water_breathing_card" | "naturescompass:natures_compass_log" | "minecraft:recipes/building_blocks/cut_red_sandstone_slab" | "lootr:25loot" | "minecraft:recipes/misc/coast_armor_trim_smithing_template" | "minecraft:recipes/misc/ward_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/combat/diamond_helmet" | "aquaculture:recipes/misc/neptinium_ingot_from_blasting" | "create:recipes/misc/crafting/kinetics/white_valve_handle_from_other_valve_handle" | "sophisticatedstorage:recipes/misc/chipped/mason_table_upgrade" | "ae2:recipes/misc/network/cells/item_cell_housing" | "immersiveengineering:recipes/misc/smelting/lead_red" | "lootr:1barrel" | "ae2:recipes/misc/network/cables/smart_pink" | "biomeswevegone:recipes/decorations/ironwood_sign" | "biomeswevegone:recipes/decorations/florus_crafting_table" | "biomeswevegone:recipes/redstone/skyris_trapdoor" | "minecraft:adventure/walk_on_powder_snow_with_leather_boots" | "minecraft:recipes/decorations/mossy_stone_wall_from_mossy_stone_stonecutting" | "compressium:recipes/building_blocks/netherrack_3_uncraft" | "create:deployer" | "easy_mob_farm:recipes/mob_farm_template/tier3_mob_farm_template" | "minecraft:recipes/misc/raiser_armor_trim_smithing_template" | "minecraft:recipes/building_blocks/chiseled_nether_bricks_from_nether_bricks_stonecutting" | "ae2:recipes/misc/network/cables/smart_orange" | "sophisticatedbackpacks:recipes/misc/advanced_pump_upgrade" | "immersiveengineering:recipes/misc/crafting/coil_mv" | "connectedglass:recipes/misc/borderless_glass_blue2" | "compressium:recipes/building_blocks/iron_8_uncraft" | "connectedglass:recipes/misc/borderless_glass_blue1" | "create:recipes/building_blocks/small_calcite_brick_stairs" | "create:recipes/building_blocks/polished_cut_asurine_wall" | "megacells:recipes/misc/crafting/compression_card" | "connectedglass:recipes/misc/vanilla_yellow_stained_glass" | "biomeswevegone:recipes/redstone/florus_fence_gate" | "minecraft:recipes/building_blocks/cut_purple_sandstone_from_purple_sandstone_stonecutting" | "compressium:recipes/building_blocks/diamond_6_uncraft" | "domum_ornamentum:recipes/decorations/yellow_floating_carpet" | "create:recipes/misc/crafting/kinetics/gearboxfrom_conversion" | "create:recipes/building_blocks/crafting/copper/waxed_oxidized_copper_shingles_from_honeycomb" | "create:recipes/building_blocks/framed_glass_from_glass_colorless_stonecutting" | "biomeswevegone:recipes/building_blocks/smooth_windswept_sandstone" | "hangglider:recipes/tools/reinforced_hang_glider" | "minecraft:recipes/building_blocks/chiseled_stone_bricks_from_stone_bricks_stonecutting" | "biomeswevegone:recipes/misc/cyan_dye_from_bwg_tag" | "create:recipes/misc/crafting/kinetics/hand_crank" | "simplemagnets:recipes/misc/advanced_demagnetization_coil" | "minecraft:recipes/building_blocks/smooth_windswept_sandstone_stairs_from_windswept_sandstone_stonecutting" | "minecraft:recipes/decorations/pink_bed" | "create:recipes/building_blocks/cut_asurine_wall_from_stone_types_asurine_stonecutting" | "create:recipes/building_blocks/small_calcite_brick_slab_recycling" | "compressium:recipes/building_blocks/endstone_8_uncraft" | "compressium:recipes/building_blocks/lapis_4_uncraft" | "minecraft:recipes/misc/coal_from_blasting_deepslate_coal_ore" | "immersiveengineering:recipes/misc/crafting/coil_lv" | "ae2:recipes/misc/network/wireless_access_point" | "immersiveengineering:recipes/misc/crafting/concrete_pillar" | "create:recipes/building_blocks/copper_tile_slab" | "buildinggadgets2:recipes/misc/gadget_destruction" | "connectedglass:recipes/misc/vanilla_purple_stained_glass_pane" | "merequester:recipes/requester" | "comforts:sleeping_bag_purple" | "minecraft:recipes/decorations/cracked_red_rock_brick_wall_from_cracked_red_rock_bricks_stonecutting" | "utilitarian:recipes/misc/utility/oak_logs_to_stairs" | "biomeswevegone:recipes/redstone/willow_button" | "betterdungeons:zombie_dungeon" | "create:recipes/building_blocks/cut_tuff_brick_stairs" | "ae2:recipes/misc/block_cutter/walls/cut_quartz_wall" | "ae2:recipes/misc/network/cells/item_storage_cell_1k_storage" | "connectedglass:recipes/misc/clear_glass_gray1" | "connectedglass:recipes/misc/clear_glass_gray2" | "ae2:recipes/misc/network/cables/glass_yellow" | "minecraft:recipes/building_blocks/cyan_stained_glass" | "minecraft:recipes/tools/netherite_axe_smithing" | "biomeswevegone:biomeswevegone/husbandry/johnny_appleseed" | "ae2:recipes/misc/network/blocks/interfaces_interface_alt" | "minecraft:recipes/decorations/jungle_sign" | "sophisticatedstorage:recipes/misc/storage_feeding_upgrade_from_backpack_feeding_upgrade" | "biomeswevegone:recipes/building_blocks/baobab_wood" | "domum_ornamentum:recipes/tools/green_cactus_extra" | "connectedglass:recipes/misc/tinted_borderless_glass_yellow2" | "ae2wtlib:recipes/wireless_pattern_access_terminal" | "minecraft:recipes/building_blocks/andesite" | "biomeswevegone:recipes/building_blocks/cika_stairs" | "sophisticatedstorage:recipes/misc/backpack_stonecutter_upgrade_from_storage_stonecutter_upgrade" | "minecraft:recipes/building_blocks/cut_sandstone_slab_from_sandstone_stonecutting" | "immersiveengineering:recipes/misc/crafting/alloybrick" | "biomeswevegone:recipes/decorations/jacaranda_hanging_sign" | "minecraft:recipes/building_blocks/exposed_cut_copper_from_exposed_copper_stonecutting" | "comforts:sleeping_bag_green" | "ae2:recipes/misc/decorative/chiseled_quartz_block_from_stonecutting" | "minecraft:recipes/decorations/pink_allium_petal_block" | "immersiveengineering:recipes/misc/crafting/storage_aluminum_to_slab" | "minecraft:recipes/building_blocks/rocky_stone_stairs_from_rocky_stone_stonecutting" | "compressium:recipes/building_blocks/stone_4_uncraft" | "ae2:recipes/misc/tools/paintballs_lumen_yellow" | "restrictedportals:nether" | "minecraft:recipes/building_blocks/blackstone_slab" | "minecraft:husbandry/feed_snifflet" | "minecraft:recipes/building_blocks/sandstone_slab_from_sandstone_stonecutting" | "create:recipes/misc/crafting/kinetics/copper_valve_handle" | "connectedglass:recipes/misc/clear_glass_white_pane3" | "connectedglass:recipes/misc/clear_glass_white_pane2" | "connectedglass:recipes/misc/clear_glass_white_pane1" | "mekanism:qio_drive_array" | "create:recipes/building_blocks/cut_tuff_brick_slab_from_stone_types_tuff_stonecutting" | "create:recipes/building_blocks/small_deepslate_brick_stairs" | "immersiveengineering:recipes/misc/crafting/screwdriver" | "ae2:recipes/misc/misc/deconstruction_chiseled_certus_quartz" | "minecraft:story/form_obsidian" | "mekanism:metallurgic_infuser" | "minecraft:recipes/building_blocks/chiseled_red_rock_brick_stairs_from_chiseled_red_rock_bricks_stonecutting" | "compressium:recipes/building_blocks/netherite_3_uncraft" | "minecraft:recipes/building_blocks/smooth_blue_sandstone_stairs_from_blue_sandstone_stonecutting" | "create:recipes/building_blocks/layered_scorchia_from_stone_types_scorchia_stonecutting" | "minecraft:recipes/misc/netherite_ingot_from_netherite_block" | "create:recipes/building_blocks/small_crimsite_brick_stairs" | "create:haunted_bell" | "create:recipes/building_blocks/cut_dripstone_brick_slab_recycling" | "compressium:recipes/building_blocks/copper_1_uncraft" | "minecraft:end/enter_end_gateway" | "immersiveengineering:multiblocks/mb_arcfurnace" | "immersiveengineering:recipes/misc/crafting/storage_lead_to_ingot_lead" | "minecraft:recipes/building_blocks/bamboo_slab" | "create:recipes/building_blocks/cut_scoria_slab_recycling" | "biomeswevegone:recipes/transportation/mahogany_boat" | "create:recipes/building_blocks/cut_calcite_wall_from_stone_types_calcite_stonecutting" | "advanced_ae:recipes/misc/quantumcore" | "minecraft:recipes/building_blocks/polished_blackstone_slab_from_polished_blackstone_stonecutting" | "immersiveengineering:recipes/misc/smelting/nugget_aluminum_recycle_faraday_chestplate_from_blasting" | "aquaculture:recipes/decorations/dark_oak_fish_mount" | "easy_mob_farm:recipes/mob_farm/iron_golem_farm" | "compressium:recipes/building_blocks/redsand_6" | "compressium:recipes/building_blocks/redsand_5" | "dankstorage:recipes/tools/4_to_5" | "compressium:recipes/building_blocks/redsand_8" | "compressium:recipes/building_blocks/redsand_7" | "compressium:recipes/building_blocks/redsand_2" | "compressium:recipes/building_blocks/redsand_1" | "repurposed_structures:outposts" | "immersiveengineering:main/craft_hammer" | "compressium:recipes/building_blocks/redsand_4" | "compressium:recipes/building_blocks/redsand_3" | "compressium:recipes/building_blocks/snow_7_uncraft" | "compressium:recipes/building_blocks/redsand_9" | "connectedglass:recipes/misc/vanilla_green_stained_glass_pane" | "minecraft:nether/loot_bastion" | "immersiveengineering:recipes/misc/crafting/steel_scaffolding_grate_top_to_slab" | "ae2:recipes/misc/tools/paintballs_blue" | "minecraft:recipes/redstone/oak_door" | "apotheosis:enchanting/max_stable" | "create:recipes/misc/campfire_cooking/bread" | "megacells:recipes/misc/crafting/mega_crafting_monitor" | "biomeswevegone:recipes/building_blocks/cracked_red_rock_brick_stairs" | "minecraft:recipes/building_blocks/dye_yellow_carpet" | "woodwevegot:recipes/redstone/rainbow_eucalyptus_trapped_chest" | "connectedglass:recipes/misc/borderless_glass_light_gray2" | "ae2:recipes/misc/network/blocks/pattern_providers_interface_alt" | "biomeswevegone:recipes/building_blocks/holly_slab" | "connectedglass:recipes/misc/borderless_glass_light_gray1" | "immersiveengineering:recipes/misc/crafting/steel_slope" | "biomeswevegone:recipes/redstone/white_mangrove_trapdoor" | "create:recipes/building_blocks/copycat_panel_from_ingots_zinc_stonecutting" | "utilitarian:recipes/misc/utility/copper_block_from_smelting" | "minecraft:recipes/misc/iron_ingot_from_iron_block" | "compressium:recipes/building_blocks/gravel_9_uncraft" | "create:recipes/building_blocks/cut_diorite_slab" | "connectedglass:recipes/misc/borderless_glass_cyan_pane2" | "immersiveengineering:recipes/misc/crafting/stick_aluminum" | "connectedglass:recipes/misc/borderless_glass_cyan_pane1" | "biomeswevegone:recipes/building_blocks/holly_planks" | "minecraft:recipes/redstone/jungle_door" | "create:recipes/building_blocks/horizontal_framed_glass_pane" | "create:recipes/building_blocks/small_deepslate_bricks_from_stone_types_deepslate_stonecutting" | "create:recipes/building_blocks/granite_pillar_from_stone_types_granite_stonecutting" | "biomeswevegone:recipes/decorations/mahogany_fence" | "immersiveengineering:recipes/misc/crafting/component_steel" | "create:recipes/building_blocks/polished_cut_crimsite_slab" | "create:recipes/misc/smelting/zinc_ingot_from_crushed" | "minecraft:recipes/decorations/end_stone_brick_wall_from_end_stone_stonecutting" | "immersiveengineering:recipes/misc/crafting/steel_scaffolding_standard_from_wooden_top" | "apotheosis:spawner/modifier" | "minecraft:recipes/building_blocks/polished_blackstone_brick_slab_from_blackstone_stonecutting" | "sophisticatedbackpacks:recipes/misc/auto_blasting_upgrade" | "immersiveengineering:recipes/misc/smelting/gold_ingot_from_dust" | "minecraft:recipes/pamhc2foodcore/campfire_roastedsunflowerseedsitem" | "create:recipes/misc/crafting/kinetics/propeller" | "create:recipes/building_blocks/crafting/copper/waxed_oxidized_copper_tile_stairs_from_honeycomb" | "ae2:recipes/misc/shaped/walls/smooth_sky_stone_block" | "immersiveengineering:recipes/misc/crafting/furnace_heater" | "ae2:recipes/misc/network/parts/terminals_pattern_access" | "apotheosis:spawner/noai" | "create:recipes/building_blocks/cut_andesite_slab_recycling" | "utilitarian:recipes/misc/angel_block_rot" | "compressium:recipes/building_blocks/coal_4_uncraft" | "biomeswevegone:recipes/building_blocks/black_sand" | "minecraft:recipes/decorations/light_gray_candle" | "megacells:recipes/misc/cells/cell_component_256m" | "biomeswevegone:recipes/building_blocks/redwood_wood" | "create:recipes/building_blocks/calcite_pillar_from_stone_types_calcite_stonecutting" | "minecraft:recipes/building_blocks/melon" | "domum_ornamentum:recipes/decorations/red_floating_carpet" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_slab_from_waxed_exposed_cut_copper_stonecutting" | "connectedglass:recipes/misc/borderless_glass_cyan_pane3" | "mekanism:steel_ingot" | "immersiveengineering:recipes/misc/crafting/raw_silver_to_raw_block_silver" | "minecraft:recipes/building_blocks/polished_andesite_slab" | "create:recipes/building_blocks/polished_cut_ochrum_slab_recycling" | "yungscavebiomes:recipes/building_blocks/ancient_sandstone" | "progressivebosses:recipes/combat/trident" | "ae2:recipes/misc/block_cutter/slabs/smooth_quartz_slab" | "biomeswevegone:recipes/building_blocks/stripped_maple_wood" | "biomeswevegone:recipes/transportation/baobab_boat" | "ae2:main/spatial_ioport" | "biomeswevegone:recipes/building_blocks/dacite_stairs" | "create:recipes/misc/crafting/materials/experience_nugget_from_block" | "immersiveengineering:tools/upgrade_revolver" | "create:recipes/misc/crafting/kinetics/orange_valve_handle_from_other_valve_handle" | "create:recipes/building_blocks/polished_cut_granite_wall_from_stone_types_granite_stonecutting" | "connectedglass:recipes/misc/vanilla_tinted_glass" | "buddingcrystals:recipes/misc/crystal_catalyst" | "ae2:main/compass" | "create:recipes/building_blocks/cut_veridium_brick_stairs" | "create:recipes/building_blocks/diorite_from_stone_types_diorite_stonecutting" | "advanced_ae:recipes/misc/quantumstorage256" | "minecraft:recipes/decorations/yellow_stained_glass_pane_from_glass_pane" | "biomeswevegone:recipes/redstone/aspen_fence_gate" | "utilitarian:recipes/misc/utility/oak_logs_to_pressure_plates" | "connectedglass:recipes/misc/clear_glass_red_pane3" | "ae2:recipes/misc/materials/advancedcard" | "ae2:main/glass_cable" | "create:recipes/building_blocks/cut_diorite_brick_wall_from_stone_types_diorite_stonecutting" | "create:recipes/building_blocks/small_scorchia_brick_stairs" | "connectedglass:recipes/misc/clear_glass_red_pane1" | "connectedglass:recipes/misc/clear_glass_red_pane2" | "apotheosis:enchanting/max_rectified" | "create:recipes/misc/crafting/kinetics/gray_valve_handle_from_other_valve_handle" | "create:mechanical_press" | "compressium:recipes/building_blocks/redstone_1_uncraft" | "biomeswevegone:recipes/redstone/rainbow_eucalyptus_pressure_plate" | "compressium:recipes/building_blocks/stone_5_uncraft" | "biomeswevegone:recipes/decorations/maple_sign" | "minecraft:recipes/combat/golden_sword" | "minecraft:end/elytra" | "create:recipes/misc/crafting/kinetics/turntable" | "minecraft:recipes/decorations/mangrove_sign" | "minecraft:recipes/tools/wooden_shovel" | "biomeswevegone:recipes/transportation/aspen_boat" | "biomeswevegone:recipes/transportation/maple_chest_boat" | "minecraft:recipes/decorations/bamboo_mosaic" | "minecraft:recipes/building_blocks/purpur_stairs" | "easy_mob_farm:recipes/mob_farm/ocean_farm" | "sophisticatedstorage:recipes/misc/hopper_upgrade" | "ae2:recipes/misc/tools/paintballs_lumen_magenta" | "minecraft:recipes/redstone/redstone_lamp" | "minecraft:recipes/building_blocks/mossy_cobblestone_slab_from_mossy_cobblestone_stonecutting" | "minecraft:recipes/building_blocks/polished_blackstone_brick_slab_from_polished_blackstone_bricks_stonecutting" | "minecraft:recipes/decorations/crimson_fence" | "minecraft:recipes/redstone/dispenser" | "create:recipes/building_blocks/polished_cut_limestone_stairs" | "create:recipes/misc/crafting/appliances/clipboard_clear" | "compressium:recipes/building_blocks/gold_3_uncraft" | "immersiveengineering:recipes/misc/crafting/redstone_breaker" | "mekanismtools:better_than_netherite" | "compressium:recipes/building_blocks/endstone_7_uncraft" | "create:recipes/building_blocks/polished_cut_andesite_from_stone_types_andesite_stonecutting" | "minecraft:recipes/building_blocks/cut_red_sandstone_slab_from_red_sandstone_stonecutting" | "minecraft:recipes/building_blocks/purpur_pillar_from_purpur_block_stonecutting" | "utilitarian:recipes/misc/utility/acacia_logs_to_doors" | "create:recipes/building_blocks/polished_cut_ochrum_stairs" | "immersiveengineering:recipes/misc/smelting/ingot_lead_from_blasting2" | "minecraft:recipes/building_blocks/cobblestone_slab" | "connectedglass:recipes/misc/scratched_glass_brown_pane1" | "mekanism:stopping_lasers" | "biomeswevegone:recipes/decorations/sakura_fence" | "connectedglass:recipes/misc/scratched_glass_brown_pane2" | "connectedglass:recipes/misc/scratched_glass_brown_pane3" | "minecraft:recipes/building_blocks/cut_blue_sandstone_from_blue_sandstone_stonecutting" | "biomeswevegone:recipes/redstone/witch_hazel_fence_gate" | "create:recipes/misc/crafting/kinetics/encased_chain_drive" | "immersiveengineering:multiblocks/craft_duroplast" | "minecraft:recipes/building_blocks/stripped_crimson_hyphae" | "immersiveengineering:recipes/misc/stonecutting/concrete_quarter" | "immersiveengineering:recipes/misc/smelting/nugget_aluminum_recycle_faraday_leggings_from_blasting" | "create:recipes/misc/crafting/kinetics/mechanical_drill" | "biomeswevegone:recipes/redstone/willow_door" | "naturescompass:natures_compass_sapling" | "biomeswevegone:recipes/building_blocks/cut_purple_sandstone_slab" | "immersiveengineering:recipes/misc/crafting/steel_scaffolding_grate_top_from_standard" | "connectedglass:recipes/misc/scratched_glass_purple_pane1" | "connectedglass:recipes/misc/scratched_glass_purple_pane2" | "minecraft:recipes/building_blocks/magenta_terracotta" | "connectedglass:recipes/misc/scratched_glass_purple_pane3" | "minecraft:recipes/misc/brick" | "gravitationalmodulatingunittweaks:recipes/misc/module_gravitational_modulating_additional_unit" | "ae2:recipes/misc/tools/portable_item_cell_256k" | "apotheosis:spawner/redstone" | "biomeswevegone:recipes/building_blocks/holly_stairs" | "sophisticatedstorage:recipes/misc/green_shulker_box_to_sophisticated" | "megacells:recipes/misc/cells/portable/portable_fluid_cell_64m" | "ae2:recipes/misc/network/cables/covered_green" | "create:recipes/building_blocks/cut_crimsite_stairs" | "biomeswevegone:recipes/building_blocks/dacite_tile" | "immersiveengineering:recipes/misc/crafting/alu_scaffolding_wooden_top_to_slab" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_black" | "sophisticatedstorage:recipes/misc/oak_chest_from_vanilla_chest" | "apotheosis:spawner/mindelay" | "create:recipes/building_blocks/polished_cut_veridium_stairs" | "utilitarian:recipes/misc/utility/bamboo_logs_to_slabs" | "immersiveengineering:recipes/misc/stonecutting/wall_slag_brick" | "sophisticatedstorage:recipes/misc/backpack_auto_blasting_upgrade_from_storage_auto_blasting_upgrade" | "biomeswevegone:recipes/transportation/skyris_boat" | "minecraft:recipes/building_blocks/gold_block" | "biomeswevegone:recipes/redstone/redwood_button" | "create:recipes/building_blocks/cut_andesite_brick_slab_recycling" | "create:recipes/misc/smelting/ingot_uranium_compat_mekanism" | "biomeswevegone:recipes/redstone/pine_fence_gate" | "create:recipes/building_blocks/layered_dripstone_from_stone_types_dripstone_stonecutting" | "minecraft:recipes/building_blocks/exposed_cut_copper_stairs_from_exposed_cut_copper_stonecutting" | "minecraft:recipes/misc/yellow_dye_from_sunflower" | "minecraft:recipes/brewing/cauldron" | "compressium:recipes/building_blocks/clay_1_uncraft" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_slab" | "minecraft:recipes/decorations/armor_stand" | "biomeswevegone:recipes/building_blocks/sakura_stairs" | "create:recipes/building_blocks/cut_andesite_wall_from_stone_types_andesite_stonecutting" | "create:recipes/building_blocks/polished_cut_scoria_slab_from_stone_types_scoria_stonecutting" | "create:recipes/misc/crafting/kinetics/track_observer" | "create:recipes/decorations/andesite_bars_from_andesite_alloy_stonecutting" | "comforts:sleeping_bag_orange" | "immersiveengineering:recipes/misc/smelting/ingot_lead_from_blasting3" | "easy_mob_farm:recipes/mob_farm/swamp_farm" | "create:recipes/misc/crafting/kinetics/sail_framefrom_conversion" | "create:recipes/misc/crafting/kinetics/sticker" | "minecraft:recipes/transportation/acacia_boat" | "minecraft:recipes/redstone/iron_trapdoor" | "immersiveengineering:recipes/misc/crafting/manual" | "minecraft:adventure/root" | "buddingcrystals:recipes/misc/budding_silver" | "ae2:recipes/misc/materials/formationcore" | "minecraft:recipes/building_blocks/end_stone_brick_stairs" | "compressium:recipes/building_blocks/lapis_2_uncraft" | "minecraft:recipes/building_blocks/smooth_pink_sandstone_stairs_from_pink_sandstone_stonecutting" | "aquaculture:recipes/decorations/acacia_fish_mount" | "ae2:recipes/misc/network/cables/dense_covered_gray" | "minecraft:recipes/decorations/white_allium" | "utilitarian:recipes/misc/utility/bamboo_logs_to_stairs" | "utilitarian:recipes/misc/utility/jungle_logs_to_boats" | "minecraft:recipes/decorations/jungle_fence" | "ae2:recipes/misc/block_cutter/walls/quartz_wall" | "minecraft:recipes/misc/tide_armor_trim_smithing_template_smithing_trim" | "biomeswevegone:recipes/building_blocks/cut_windswept_sandstone" | "immersiveengineering:recipes/misc/crafting/alu_scaffolding_standard_to_slab" | "connectedglass:recipes/misc/scratched_glass_lime_pane2" | "connectedglass:recipes/misc/scratched_glass_lime_pane1" | "immersiveengineering:recipes/misc/crafting/component_iron" | "immersiveengineering:recipes/misc/smelting/ingot_uranium_from_dust" | "mekanism:environmental_radiation" | "biomeswevegone:recipes/building_blocks/skyris_wood" | "compressium:recipes/building_blocks/sand_3_uncraft" | "minecraft:recipes/decorations/mud_brick_wall_from_mud_bricks_stonecutting" | "biomeswevegone:recipes/building_blocks/cypress_slab" | "minecraft:recipes/building_blocks/chiseled_quartz_block_from_quartz_block_stonecutting" | "yungscavebiomes:recipes/building_blocks/layered_sandstone_from_stonecutting" | "biomeswevegone:recipes/building_blocks/redwood_planks" | "minecraft:recipes/misc/ender_eye" | "immersiveengineering:recipes/misc/crafting/sample_drill" | "immersiveengineering:recipes/misc/crafting/electrum_mix" | "minecraft:recipes/redstone/redstone_block" | "ae2:main/spatial_explorer" | "mekanism:materials" | "minecraft:recipes/decorations/dark_oak_hanging_sign" | "connectedglass:recipes/misc/scratched_glass_lime_pane3" | "biomeswevegone:recipes/decorations/foragers_table" | "ae2:recipes/misc/shaped/stairs/smooth_quartz_block" | "minecraft:recipes/decorations/windswept_sandstone_wall_from_windswept_sandstone_stonecutting" | "ae2:recipes/misc/shaped/walls/sky_stone_block" | "mekanismgenerators:wind_generator" | "immersiveengineering:recipes/misc/crafting/toolupgrade_revolver_bayonet" | "create:recipes/misc/crafting/kinetics/smart_fluid_pipe" | "ae2:recipes/misc/decorative/sky_stone_brick_from_stonecutting" | "create:recipes/building_blocks/polished_cut_tuff_slab_recycling" | "compressium:recipes/building_blocks/diorite_1_uncraft" | "minecraft:recipes/building_blocks/red_rock_brick_slab_from_red_rock_bricks_stonecutting" | "minecraft:recipes/building_blocks/cyan_terracotta" | "create:recipes/misc/crafting/materials/raw_zinc" | "woodwevegot:recipes/redstone/aspen_trapped_chest" | "minecraft:recipes/decorations/nether_brick_wall_from_nether_bricks_stonecutting" | "ae2:recipes/misc/network/blocks/energy_energy_acceptor" | "minecraft:recipes/decorations/red_stained_glass_pane_from_glass_pane" | "ae2:recipes/misc/shaped/stairs/fluix_block" | "biomeswevegone:recipes/transportation/fir_boat" | "biomeswevegone:recipes/building_blocks/green_enchanted_slab" | "biomeswevegone:recipes/decorations/willow_sign" | "eccentrictome:recipes/tools/tome" | "ae2:recipes/misc/network/blocks/io_condenser" | "minecraft:story/follow_ender_eye" | "immersiveengineering:main/craft_batcher" | "minecraft:recipes/building_blocks/weathered_cut_copper_from_weathered_copper_stonecutting" | "domum_ornamentum:recipes/decorations/brown_floating_carpet" | "biomeswevegone:recipes/building_blocks/stripped_green_enchanted_wood" | "create:recipes/misc/smelting/ingot_lead_compat_immersiveengineering" | "mekanism:fluid_transport" | "immersiveengineering:recipes/misc/crafting/raw_nickel_to_raw_block_nickel" | "ae2:recipes/misc/network/cables/dense_smart_light_blue" | "mekanism:running_free" | "compressium:recipes/building_blocks/cobblestone_4_uncraft" | "create:recipes/building_blocks/cut_ochrum_brick_stairs_from_stone_types_ochrum_stonecutting" | "biomeswevegone:recipes/decorations/jacaranda_crafting_table" | "ae2:recipes/misc/decorative/sky_stone_small_brick" | "connectedglass:recipes/misc/tinted_borderless_glass_lime2" | "immersiveengineering:recipes/misc/crafting/sheetmetal_copper_from_slab" | "megacells:recipes/misc/cells/cell_component_4m" | "immersiveengineering:tools/tools_root" | "minecraft:recipes/decorations/deepslate_tile_wall_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/misc/iron_ingot_from_blasting_raw_iron" | "minecraft:recipes/building_blocks/mossy_stone_stairs_from_mossy_stone_stonecutting" | "create:recipes/building_blocks/small_limestone_bricks_from_stone_types_limestone_stonecutting" | "create:recipes/misc/crafting/materials/brass_ingot_from_compacting" | "immersiveengineering:recipes/misc/crafting/plate_constantan_hammering" | "immersiveengineering:recipes/misc/crafting/steel_scaffolding_wooden_top_to_slab" | "minecraft:recipes/pamhc2foodcore/smoking_cookedgroundbeefitem" | "create:steam_engine" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_blue_to_slab" | "minecraft:recipes/misc/blue_dye_from_cornflower" | "minecraft:recipes/redstone/slime_block" | "biomeswevegone:recipes/building_blocks/windswept_sandstone_slab" | "create:recipes/building_blocks/small_asurine_brick_slab" | "immersiveengineering:recipes/misc/crafting/sheetmetal_iron_to_slab" | "create:recipes/building_blocks/polished_cut_scorchia_wall" | "create:recipes/building_blocks/small_scorchia_brick_wall_from_stone_types_scorchia_stonecutting" | "immersiveengineering:recipes/misc/smelting/ingot_lead" | "ae2:recipes/misc/block_cutter/stairs/sky_stone_stairs" | "create:recipes/building_blocks/cut_granite_brick_stairs" | "connectedglass:recipes/misc/clear_glass_magenta_pane1" | "minecraft:recipes/decorations/bamboo_hanging_sign" | "connectedglass:recipes/misc/clear_glass_magenta_pane2" | "yungscavebiomes:recipes/building_blocks/layered_red_sandstone" | "create:recipes/building_blocks/small_andesite_brick_wall_from_stone_types_andesite_stonecutting" | "ae2:recipes/misc/network/cables/glass_cyan" | "connectedglass:recipes/misc/clear_glass_magenta_pane3" | "create:recipes/building_blocks/crafting/copper/waxed_copper_tiles_from_honeycomb" | "minecraft:recipes/building_blocks/acacia_wood" | "sophisticatedbackpacks:recipes/misc/pump_upgrade" | "create:recipes/building_blocks/ornate_iron_window_pane" | "ae2:main/growth_accelerator" | "yungscavebiomes:recipes/building_blocks/chiseled_ancient_sandstone" | "minecraft:recipes/decorations/polished_blackstone_brick_wall" | "ae2:recipes/misc/shaped/walls/sky_stone_small_brick" | "biomeswevegone:biomeswevegone/adventure/root" | "create:recipes/building_blocks/scorchia_pillar_from_stone_types_scorchia_stonecutting" | "betterdungeons:skeleton_dungeon" | "immersiveengineering:recipes/misc/smelting/ingot_silver_from_blasting2" | "immersiveengineering:recipes/misc/smelting/ingot_silver_from_blasting3" | "minecraft:recipes/building_blocks/dacite_tile_stairs_from_dacite_tile_stonecutting" | "create:recipes/building_blocks/small_asurine_brick_stairs" | "minecraft:recipes/combat/wooden_sword" | "ae2:recipes/misc/tools/paintballs_magenta" | "minecraft:recipes/decorations/gray_banner" | "minecraft:recipes/building_blocks/oak_planks" | "biomeswevegone:recipes/decorations/palm_hanging_sign" | "ae2:recipes/misc/network/cells/spatial_storage_cell_128_cubed_storage" | "minecraft:recipes/decorations/light_blue_carpet" | "sophisticatedstorage:recipes/misc/backpack_smelting_upgrade_from_storage_smelting_upgrade" | "create:recipes/building_blocks/cut_scoria_wall" | "woodwevegot:recipes/decorations/white_mangrove_barrel" | "utilitarian:recipes/misc/utility/oak_logs_to_boats" | "minecraft:recipes/building_blocks/dye_blue_bed" | "ae2:recipes/misc/network/parts/energy_level_emitter" | "sophisticatedstorage:recipes/misc/copper_barrel" | "ae2:recipes/misc/block_cutter/stairs/chiseled_quartz_stairs" | "biomeswevegone:recipes/building_blocks/cut_white_sandstone" | "minecraft:recipes/building_blocks/quartz_slab_from_stonecutting" | "immersiveengineering:recipes/misc/crafting/hempcrete_pillar" | "aquaculture:recipes/aquaculture/diamond_hook" | "sophisticatedstorage:recipes/misc/chipped/carpenters_table_upgrade" | "biomeswevegone:recipes/redstone/zelkova_button" | "compressium:recipes/building_blocks/emerald_7_uncraft" | "minecraft:recipes/building_blocks/black_concrete_powder" | "immersiveengineering:recipes/misc/crafting/wire_steel" | "ae2:recipes/misc/network/blocks/spatial_io_pylon" | "create:recipes/building_blocks/cut_veridium_slab" | "immersiveengineering:recipes/misc/crafting/stairs_treated_wood_packaged" | "compressium:recipes/building_blocks/coal_2_uncraft" | "minecraft:recipes/combat/crossbow" | "minecraft:recipes/building_blocks/mud_bricks" | "biomeswevegone:recipes/building_blocks/cypress_wood" | "create:recipes/building_blocks/cut_granite_brick_wall" | "minecraft:recipes/food/cooked_porkchop_from_smoking" | "buddingcrystals:recipes/misc/budding_emerald" | "minecraft:recipes/building_blocks/cracked_deepslate_bricks" | "minecraft:recipes/building_blocks/cut_black_sandstone_from_black_sandstone_stonecutting" | "create:recipes/misc/crafting/kinetics/train_trapdoor" | "immersiveengineering:recipes/misc/smelting/ingot_lead_from_dust" | "biomeswevegone:recipes/building_blocks/ebony_wood" | "minecraft:recipes/building_blocks/chiseled_nether_bricks" | "minecraft:recipes/building_blocks/warped_planks" | "minecraft:recipes/building_blocks/exposed_cut_copper_slab" | "immersiveengineering:recipes/misc/crafting/ingot_uranium_to_storage_uranium" | "biomeswevegone:recipes/transportation/redwood_boat" | "betterdungeons:root" | "woodwevegot:recipes/decorations/maple_barrel" | "minecraft:recipes/decorations/warped_fence" | "aquaculture:recipes/food/sushi" | "minecraft:recipes/building_blocks/cut_white_sandstone_slab_from_cut_white_sandstone_stonecutting" | "minecraft:recipes/decorations/black_glazed_terracotta" | "create:millstone" | "create:recipes/building_blocks/crafting/kinetics/green_seat" | "biomeswevegone:recipes/redstone/holly_pressure_plate" | "create:recipes/building_blocks/cut_diorite_brick_stairs_from_stone_types_diorite_stonecutting" | "friendsandfoes:nether/obtain_wildfire_crown" | "biomeswevegone:recipes/building_blocks/packed_black_ice" | "mekanism:full_canteen" | "minecraft:recipes/building_blocks/weathered_cut_copper_stairs" | "ae2:recipes/misc/network/cables/dense_smart_purple" | "biomeswevegone:recipes/building_blocks/cypress_planks" | "biomeswevegone:recipes/transportation/white_mangrove_boat" | "utilitarian:recipes/misc/no_soliciting/soliciting_carpets/red_trapped_soliciting_carpet" | "minecraft:recipes/misc/gray_dye" | "create:train_whistle" | "biomeswevegone:recipes/decorations/palm_sign" | "minecraft:recipes/pamhc2foodcore/campfire_cookedgroundchickenitem" | "sophisticatedstorage:recipes/misc/limited_iron_barrel_4_from_limited_copper_barrel_4" | "create:recipes/building_blocks/cut_limestone_wall" | "minecraft:recipes/redstone/bamboo_button" | "create:recipes/misc/blasting/ingot_silver_compat_ic2" | "buddingcrystals:recipes/misc/budding_lead" | "minecraft:recipes/decorations/light_gray_carpet" | "immersiveengineering:multiblocks/liquid_concrete" | "create:recipes/building_blocks/cut_diorite_slab_recycling" | "sophisticatedstorage:recipes/misc/netherite_barrel" | "minecraft:recipes/decorations/barrel" | "immersiveengineering:recipes/misc/stonecutting/concrete_sheet" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_lime_to_slab" | "immersiveengineering:recipes/misc/crafting/conveyor_extract" | "ae2:recipes/misc/tools/paintballs_gray" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_yellow_from_slab" | "minecraft:recipes/decorations/dacite_brick_wall_from_dacite_bricks_stonecutting" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_light_gray_from_slab" | "minecraft:recipes/misc/rib_armor_trim_smithing_template" | "create:recipes/building_blocks/polished_cut_diorite_stairs" | "megacells:recipes/misc/cells/cell_component_1m" | "minecraft:recipes/combat/leather_boots" | "biomeswevegone:recipes/redstone/fir_button" | "minecraft:recipes/misc/red_dye_from_tulip" | "sophisticatedstorage:recipes/misc/backpack_auto_smoking_upgrade_from_storage_auto_smoking_upgrade" | "minecraft:husbandry/axolotl_in_a_bucket" | "minecraft:recipes/decorations/cobblestone_wall_from_cobblestone_stonecutting" | "immersiveengineering:recipes/misc/crafting/raw_lead_to_raw_block_lead" | "immersiveengineering:recipes/misc/crafting/clinker_brick_quoin" | "immersiveengineering:recipes/misc/crafting/treated_fence" | "minecraft:recipes/misc/orange_dye_from_orange_tulip" | "minecraft:recipes/decorations/grindstone" | "sophisticatedbackpacks:recipes/misc/anvil_upgrade" | "minecraft:recipes/building_blocks/diamond_block" | "woodwevegot:recipes/decorations/sakura_barrel" | "ae2:recipes/misc/network/parts/terminals_pattern_encoding" | "minecraft:recipes/decorations/yellow_carpet" | "minecraft:recipes/building_blocks/stripped_oak_wood" | "biomeswevegone:recipes/building_blocks/cut_black_sandstone" | "biomeswevegone:recipes/redstone/sakura_pressure_plate" | "immersiveengineering:tools/craft_railgun" | "create:recipes/building_blocks/cut_calcite_wall" | "biomeswevegone:recipes/building_blocks/dacite_bricks" | "minecraft:nether/ride_strider_in_overworld_lava" | "comforts:hammock_pink" | "create:recipes/building_blocks/polished_cut_andesite_slab_recycling" | "create:recipes/misc/smelting/ingot_nickel_compat_immersiveengineering" | "immersiveengineering:recipes/misc/crafting/sheetmetal_iron_from_slab" | "sophisticatedstorage:recipes/misc/acacia_chest_from_quark_acacia_chest" | "biomeswevegone:recipes/redstone/cypress_button" | "biomeswevegone:recipes/building_blocks/chiseled_pink_sandstone" | "utilitarian:recipes/misc/no_soliciting/soliciting_carpets/lime_soliciting_carpet" | "compressium:recipes/building_blocks/netherite_5_uncraft" | "create:recipes/building_blocks/cut_dripstone_brick_slab_from_stone_types_dripstone_stonecutting" | "domum_ornamentum:recipes/tools/sand_stone_bricks" | "woodwevegot:recipes/decorations/zelkova_barrel" | "sophisticatedstorage:recipes/misc/iron_chest" | "create:recipes/building_blocks/crafting/kinetics/purple_seat" | "minecraft:recipes/decorations/blue_banner" | "create:recipes/building_blocks/polished_cut_andesite_wall" | "create:recipes/building_blocks/weathered_copper_tile_slab" | "ae2:recipes/misc/network/cables/glass_magenta" | "minecraft:recipes/building_blocks/cut_blue_sandstone_slab_from_blue_sandstone_stonecutting" | "biomeswevegone:recipes/decorations/mossy_red_rock_brick_wall" | "biomeswevegone:recipes/building_blocks/mahogany_planks" | "connectedglass:recipes/misc/scratched_glass_black_pane2" | "minecraft:recipes/building_blocks/deepslate_tile_slab_from_polished_deepslate_stonecutting" | "connectedglass:recipes/misc/scratched_glass_black_pane1" | "connectedglass:recipes/misc/scratched_glass_black_pane3" | "advanced_ae:recipes/misc/swim_speed_card" | "create:recipes/building_blocks/polished_cut_granite_slab" | "biomeswevegone:recipes/decorations/fir_sign" | "minecraft:recipes/building_blocks/dark_prismarine_slab_from_dark_prismarine_stonecutting" | "yungscavebiomes:recipes/building_blocks/cut_ancient_sandstone" | "minecraft:recipes/building_blocks/polished_andesite_stairs_from_andesite_stonecutting" | "minecraft:recipes/decorations/lime_banner" | "minecraft:recipes/decorations/white_bed" | "ae2:recipes/misc/network/cables/dense_smart_fluix" | "advanced_ae:recipes/misc/quantum_base_card" | "immersiveengineering:recipes/misc/crafting/toolupgrade_revolver_magazine" | "compressium:recipes/building_blocks/emerald_8_uncraft" | "create:recipes/misc/crafting/kinetics/copper_valve_handle_from_others" | "biomeswevegone:recipes/redstone/jacaranda_fence_gate" | "minecraft:recipes/decorations/deepslate_brick_wall_from_polished_deepslate_stonecutting" | "biomeswevegone:recipes/transportation/cypress_boat" | "biomeswevegone:recipes/building_blocks/pink_sandstone" | "immersiveengineering:recipes/misc/smelting/ingot_silver3" | "immersiveengineering:recipes/misc/smelting/ingot_silver2" | "minecraft:recipes/misc/lapis_lazuli_from_blasting_deepslate_lapis_ore" | "create:recipes/building_blocks/polished_cut_scoria_stairs_from_stone_types_scoria_stonecutting" | "create:recipes/building_blocks/weathered_copper_tile_slab_from_weathered_copper_tiles_stonecutting" | "utilitarian:recipes/misc/utility/oak_logs_to_doors" | "minecraft:recipes/decorations/nether_brick_wall" | "ae2:recipes/misc/network/cables/covered_pink" | "minecraft:recipes/misc/ward_armor_trim_smithing_template" | "mekanism:dictionary" | "biomeswevegone:recipes/redstone/ironwood_door" | "megacells:recipes/misc/cells/standard/item_storage_cell_1m" | "create:recipes/misc/crafting/appliances/linked_controller" | "minecraft:recipes/misc/copper_ingot_from_smelting_deepslate_copper_ore" | "create:recipes/building_blocks/small_ochrum_brick_stairs" | "immersiveengineering:recipes/misc/crafting/ingot_lead_to_nugget_lead" | "create:recipes/building_blocks/cut_andesite_brick_slab_from_stone_types_andesite_stonecutting" | "minecraft:recipes/building_blocks/cut_pink_sandstone_from_pink_sandstone_stonecutting" | "minecraft:recipes/building_blocks/black_sandstone_stairs_from_black_sandstone_stonecutting" | "ae2:recipes/misc/tools/portable_item_cell_64k" | "minecraft:recipes/misc/firework_rocket_simple" | "minecraft:recipes/misc/gold_ingot_from_smelting_deepslate_gold_ore" | "utilitarian:recipes/misc/utility/mangrove_logs_to_doors" | "minecraft:nether/summon_wither" | "compressium:recipes/building_blocks/granite_1_uncraft" | "create:recipes/building_blocks/small_scoria_brick_slab_recycling" | "ae2:recipes/misc/shaped/stairs/quartz_block" | "create:compacting" | "biomeswevegone:recipes/building_blocks/aspen_planks" | "create:recipes/building_blocks/cut_crimsite_brick_wall" | "chunkloaders:recipes/misc/basic_chunk_loader" | "create:recipes/misc/crafting/kinetics/nozzle" | "minecraft:recipes/redstone/redstone_from_blasting_deepslate_redstone_ore" | "create:recipes/misc/crafting/kinetics/radial_chassis" | "mekanism:qio_importer" | "megacells:recipes/misc/cells/standard/item_storage_cell_4m" | "ae2:recipes/misc/tools/certus_quartz_hoe" | "create:recipes/building_blocks/polished_cut_ochrum_slab" | "immersiveengineering:recipes/misc/crafting/breaker_switch" | "naturalist:recipes/naturalist/limestone_stairs" | "ae2:recipes/misc/network/cables/dense_smart_orange" | "compressium:recipes/building_blocks/netherrack_2_uncraft" | "minecraft:recipes/building_blocks/red_nether_brick_slab" | "mekanism:stabilizing_chunks" | "minecraft:recipes/building_blocks/cobblestone_stairs" | "compressium:recipes/building_blocks/obsidian_5_uncraft" | "create:recipes/building_blocks/small_crimsite_brick_stairs_from_stone_types_crimsite_stonecutting" | "minecraft:recipes/misc/copper_ingot_from_blasting_copper_ore" | "minecraft:recipes/building_blocks/dye_green_carpet" | "minecraft:recipes/building_blocks/mossy_stone_brick_stairs_from_mossy_stone_brick_stonecutting" | "create:recipes/building_blocks/cut_ochrum_slab" | "biomeswevegone:recipes/transportation/cika_boat" | "ae2:recipes/misc/network/cells/item_storage_cell_16k" | "naturalist:recipes/food/cooked_venison" | "megacells:recipes/misc/crafting/mega_energy_cell" | "create:burner" | "minecraft:recipes/building_blocks/polished_diorite_slab_from_diorite_stonecutting" | "immersiveengineering:recipes/misc/crafting/connector_hv_relay" | "naturalist:recipes/naturalist/glow_goop" | "woodwevegot:recipes/redstone/palm_trapped_chest" | "minecraft:recipes/decorations/pink_banner" | "connectedglass:recipes/misc/clear_glass_black1" | "biomeswevegone:recipes/misc/white_dye_from_bwg_tag" | "yungscavebiomes:recipes/building_blocks/smooth_ancient_sandstone_slab_from_smooth_stonecutting" | "connectedglass:recipes/misc/clear_glass_black2" | "create:recipes/misc/smelting/nickel_ingot_compat_thermal" | "minecraft:recipes/pamhc2foodcore/smelting_cookedgroundrabbititem" | "mekanismtools:alternate_tools" | "minecraft:recipes/building_blocks/prismarine_brick_slab" | "minecraft:recipes/building_blocks/waxed_exposed_copper_from_honeycomb" | "minecraft:recipes/misc/magenta_dye_from_blue_red_white_dye" | "sophisticatedstorage:recipes/misc/light_gray_shulker_box_to_sophisticated" | "immersiveengineering:recipes/misc/crafting/buzzsaw" | "ae2:recipes/misc/network/cables/covered_light_gray" | "ae2:recipes/misc/network/cables/smart_brown" | "compressium:recipes/building_blocks/gold_9" | "minecraft:recipes/building_blocks/purple_concrete_powder" | "compressium:recipes/building_blocks/gold_8" | "compressium:recipes/building_blocks/gold_7" | "compressium:recipes/building_blocks/gold_6" | "create:recipes/building_blocks/cut_granite_wall" | "justhammers:recipes/tools/diamond_impact_hammer" | "aquaculture:recipes/aquaculture/light_hook" | "minecraft:recipes/building_blocks/prismarine_slab" | "minecraft:recipes/decorations/orange_carpet" | "immersiveengineering:recipes/misc/crafting/hempcrete_brick_from_slab" | "minecraft:adventure/read_power_of_chiseled_bookshelf" | "create:recipes/misc/crafting/kinetics/mechanical_piston" | "progressivebosses:recipes/misc/corrupted_soul_sand" | "compressium:recipes/building_blocks/gravel_8_uncraft" | "minecraft:recipes/redstone/cherry_door" | "immersiveengineering:tools/upgrade_buzzsaw" | "buddingcrystals:recipes/misc/budding_salt" | "minecraft:recipes/building_blocks/cut_copper_stairs" | "immersiveengineering:recipes/misc/crafting/glider" | "advanced_ae:recipes/misc/quantum_alloy_from_block" | "fulleng:recipes/misc/terminals/block_pattern_encoding_terminal_from_part" | "minecraft:recipes/misc/storage_input_from_io" | "minecraft:recipes/decorations/warped_hanging_sign" | "domum_ornamentum:recipes/decorations/black_floating_carpet" | "compressium:recipes/building_blocks/gold_1" | "create:recipes/misc/crafting/kinetics/sticky_mechanical_piston" | "create:shifting_gears" | "biomeswevegone:recipes/building_blocks/palm_planks" | "domum_ornamentum:recipes/tools/brown_bricks" | "compressium:recipes/building_blocks/coal_3_uncraft" | "create:recipes/building_blocks/exposed_copper_shingle_slab_from_exposed_copper_shingles_stonecutting" | "sophisticatedstorage:recipes/misc/limited_netherite_barrel_4" | "aquaculture:recipes/misc/red_mushroom_from_fish" | "buddingcrystals:recipes/misc/budding_gold" | "sophisticatedstorage:recipes/misc/limited_netherite_barrel_3" | "compressium:recipes/building_blocks/gold_5" | "sophisticatedstorage:recipes/misc/limited_netherite_barrel_2" | "compressium:recipes/building_blocks/gold_4" | "create:recipes/misc/crafting/kinetics/encased_fan" | "sophisticatedstorage:recipes/misc/limited_netherite_barrel_1" | "connectedglass:recipes/misc/vanilla_purple_stained_glass" | "compressium:recipes/building_blocks/gold_3" | "compressium:recipes/building_blocks/gold_2" | "sophisticatedstorage:recipes/misc/storage_smelting_upgrade_from_backpack_smelting_upgrade" | "create:recipes/building_blocks/cut_scoria_wall_from_stone_types_scoria_stonecutting" | "ae2:recipes/misc/materials/cardredstone" | "minecraft:recipes/building_blocks/dacite_cobblestone_stairs_from_dacite_cobblestone_stonecutting" | "mekanism:painting_machine" | "immersiveengineering:recipes/misc/crafting/logic_unit" | "create:recipes/building_blocks/cut_dripstone_wall" | "create:recipes/misc/crafting/appliances/attribute_filter_clear" | "ae2:recipes/misc/network/parts/toggle_bus" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_pink_from_slab" | "ae2:recipes/misc/tools/nether_quartz_hoe" | "compressium:recipes/building_blocks/diamond_5_uncraft" | "minecraft:recipes/combat/spectral_arrow" | "minecraft:recipes/decorations/white_stained_glass_pane" | "immersiveengineering:recipes/misc/crafting/hempcrete_brick" | "aquaculture:recipes/building_blocks/planks_from_driftwood" | "apotheosis:enchanting/deepshelf" | "immersiveengineering:recipes/misc/crafting/connector_structural" | "biomeswevegone:recipes/misc/purple_dye_from_bwg_tag" | "immersiveengineering:recipes/misc/crafting/plate_gold_hammering" | "ae2:recipes/misc/shaped/stairs/sky_stone_brick" | "immersiveengineering:recipes/misc/crafting/fluid_placer" | "create:recipes/building_blocks/cut_diorite_from_stone_types_diorite_stonecutting" | "minecraft:recipes/decorations/ender_chest" | "immersiveengineering:recipes/misc/crafting/sheetmetal_gold_to_slab" | "minecraft:recipes/decorations/dark_oak_sign" | "immersiveengineering:recipes/misc/stonecutting/slab_concrete_leaded" | "biomeswevegone:recipes/decorations/willow_fence" | "create:recipes/misc/crafting/materials/experience_block" | "biomeswevegone:recipes/redstone/willow_trapdoor" | "compressium:recipes/building_blocks/redsand_6_uncraft" | "immersiveengineering:recipes/misc/stonecutting/stairs_concrete_brick" | "connectedglass:recipes/misc/tinted_borderless_glass_black2" | "biomeswevegone:recipes/building_blocks/mahogany_wood" | "create:recipes/building_blocks/veridium_pillar_from_stone_types_veridium_stonecutting" | "megacells:recipes/misc/cells/cell_component_64m" | "minecraft:story/mine_diamond" | "immersiveengineering:recipes/misc/crafting/empty_shell" | "minecraft:recipes/building_blocks/cut_copper_stairs_from_cut_copper_stonecutting" | "minecraft:recipes/building_blocks/polished_granite_stairs_from_granite_stonecutting" | "woodwevegot:recipes/redstone/zelkova_trapped_chest" | "biomeswevegone:recipes/transportation/ebony_boat" | "easy_mob_farm:recipes/upgrade/enchancement/pollen_trap_enhancement" | "create:track_crafting_factory" | "create:recipes/misc/crafting/kinetics/framed_glass_door" | "create:belt" | "biomeswevegone:recipes/redstone/baobab_pressure_plate" | "create:recipes/building_blocks/polished_cut_dripstone_stairs" | "minecraft:recipes/building_blocks/cyan_concrete_powder" | "biomeswevegone:recipes/redstone/baobab_door" | "biomeswevegone:recipes/building_blocks/cracked_red_rock_brick_slab" | "domum_ornamentum:recipes/decorations/light_gray_floating_carpet" | "immersiveengineering:recipes/misc/crafting/concrete_from_slab" | "ae2:recipes/misc/network/blocks/energy_vibration_chamber" | "ae2:recipes/misc/tools/misctools_entropy_manipulator" | "create:recipes/misc/crafting/materials/electron_tube" | "minecraft:recipes/misc/pink_dye_from_peony" | "create:recipes/misc/crafting/kinetics/goggles" | "sophisticatedbackpacks:recipes/misc/iron_backpack_from_copper" | "create:recipes/misc/crafting/materials/andesite_alloy_from_block" | "biomeswevegone:recipes/building_blocks/mahogany_slab" | "minecraft:recipes/misc/coal_from_smelting_coal_ore" | "create:recipes/misc/crafting/kinetics/copper_door" | "minecraft:nether/find_fortress" | "create:recipes/building_blocks/cut_tuff_brick_slab_recycling" | "minecraft:recipes/building_blocks/polished_blackstone_bricks" | "minecraft:recipes/building_blocks/dacite_bricks_from_dacite_stonecutting" | "biomeswevegone:recipes/decorations/redwood_sign" | "ae2:main/network_tool" | "create:recipes/building_blocks/polished_cut_dripstone_from_stone_types_dripstone_stonecutting" | "create:recipes/decorations/copper_bars_from_ingots_copper_stonecutting" | "ae2:recipes/misc/network/cables/smart_light_blue" | "sophisticatedstorage:recipes/misc/cherry_limited_barrel_1" | "minecraft:recipes/decorations/red_sandstone_wall" | "sophisticatedstorage:recipes/misc/cherry_limited_barrel_3" | "immersiveengineering:recipes/misc/crafting/storage_steel_from_slab" | "sophisticatedstorage:recipes/misc/cherry_limited_barrel_2" | "buddingcrystals:recipes/misc/budding_hopgraphite" | "immersiveengineering:recipes/misc/crafting/steel_scaffolding_standard_to_slab" | "sophisticatedstorage:recipes/misc/cherry_limited_barrel_4" | "minecraft:recipes/misc/nether_brick" | "biomeswevegone:recipes/decorations/redwood_fence" | "create:recipes/building_blocks/cut_scorchia_brick_wall" | "create:recipes/building_blocks/small_crimsite_bricks_from_stone_types_crimsite_stonecutting" | "immersiveengineering:recipes/misc/crafting/concrete_brick_to_slab" | "compressium:recipes/building_blocks/copper_2_uncraft" | "utilitarian:recipes/misc/angel_block" | "create:recipes/building_blocks/cut_scorchia_stairs" | "immersiveengineering:recipes/misc/crafting/ingot_silver_to_storage_silver" | "minecraft:recipes/tools/stone_shovel" | "ae2:recipes/misc/materials/annihilationcore" | "create:recipes/misc/smelting/ingot_silver_compat_immersiveengineering" | "naturalist:recipes/naturalist/cut_limestone_wall" | "compressium:recipes/building_blocks/quartz_7_uncraft" | "mekanism:basic_qio_drive" | "create:lava_wheel_00000" | "naturalist:recipes/naturalist/limestone_wall" | "create:recipes/misc/blasting/ingot_lead_compat_immersiveengineering" | "create:recipes/misc/crafting/kinetics/whisk" | "immersiveengineering:recipes/misc/smelting/nugget_steel_recycle_sword" | "naturalist:recipes/naturalist/bug_net" | "minecraft:recipes/building_blocks/brown_terracotta" | "create:recipes/misc/crafting/kinetics/display_board" | "ae2:recipes/misc/shaped/slabs/cut_quartz_block" | "dankstorage:recipes/tools/dock" | "immersiveengineering:recipes/misc/crafting/cokebrick_to_slab" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_cyan_to_slab" | "create:recipes/building_blocks/jungle_window" | "biomeswevegone:recipes/decorations/witch_hazel_crafting_table" | "immersiveengineering:recipes/misc/crafting/wirecoil_structure_steel" | "minecraft:recipes/building_blocks/polished_deepslate_stairs" | "immersiveengineering:recipes/misc/crafting/ingot_electrum_to_storage_electrum" | "compressium:recipes/building_blocks/andesite_2_uncraft" | "create:recipes/building_blocks/small_asurine_brick_wall_from_stone_types_asurine_stonecutting" | "minecraft:recipes/decorations/shulker_box" | "biomeswevegone:recipes/food/green_apple_pie" | "biomeswevegone:recipes/decorations/ironwood_crafting_table" | "minecraft:recipes/building_blocks/polished_basalt" | "minecraft:recipes/building_blocks/oak_wood" | "immersiveengineering:tools/secret_drillbreak" | "biomeswevegone:recipes/building_blocks/dacite_cobblestone_slab" | "connectedglass:recipes/misc/tinted_borderless_glass_light_blue2" | "minecraft:recipes/building_blocks/smooth_quartz_stairs" | "biomeswevegone:recipes/decorations/baobab_sign" | "minecraft:recipes/misc/slime_ball" | "minecraft:recipes/misc/raiser_armor_trim_smithing_template_smithing_trim" | "create:recipes/building_blocks/layered_andesite_from_stone_types_andesite_stonecutting" | "create:recipes/misc/smelting/ingot_aluminium_compat_ic2" | "utilitarian:recipes/misc/no_soliciting/soliciting_carpets/yellow_soliciting_carpet" | "mekanism:automated_crafting" | "biomeswevegone:recipes/building_blocks/jacaranda_planks" | "ae2:recipes/misc/blasting/sky_stone_block" | "ae2wtlib:recipes/quantum_bridge_card" | "ae2:recipes/misc/network/cables/covered_white" | "create:recipes/building_blocks/polished_cut_calcite_slab_recycling" | "minecraft:recipes/building_blocks/dye_green_wool" | "minecraft:recipes/decorations/cherry_hanging_sign" | "ae2:recipes/misc/network/crafting/molecular_assembler" | "minecraft:recipes/building_blocks/jungle_slab" | "create:recipes/building_blocks/polished_cut_scorchia_slab_from_stone_types_scorchia_stonecutting" | "minecraft:recipes/decorations/light_blue_candle" | "immersiveengineering:recipes/misc/crafting/conveyor_splitter_covered" | "minecraft:recipes/building_blocks/smooth_black_sandstone_stairs_from_black_sandstone_stonecutting" | "create:recipes/misc/smelting/ingot_tin_compat_ic2" | "ae2:recipes/misc/network/crafting/4k_cpu_crafting_storage" | "utilitarian:recipes/misc/no_soliciting/soliciting_carpets/light_gray_trapped_soliciting_carpet" | "utilitarian:recipes/misc/utility/jungle_logs_to_doors" | "create:recipes/building_blocks/framed_glass_pane" | "create:recipes/building_blocks/polished_cut_asurine_slab_recycling" | "create:recipes/building_blocks/polished_cut_scoria_wall" | "utilitarian:recipes/misc/no_soliciting/soliciting_carpets/gray_trapped_soliciting_carpet" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_white" | "minecraft:recipes/building_blocks/mossy_stone_brick_slab_from_mossy_stone_brick_stonecutting" | "biomeswevegone:recipes/decorations/green_enchanted_crafting_table" | "minecraft:recipes/food/cooked_beef" | "sophisticatedstorage:recipes/misc/jungle_chest_from_quark_jungle_chest" | "connectedglass:recipes/misc/clear_glass_purple_pane3" | "connectedglass:recipes/misc/clear_glass_purple_pane2" | "connectedglass:recipes/misc/clear_glass_purple_pane1" | "apotheosis:spawner/conditions" | "utilitarian:recipes/misc/utility/birch_logs_to_doors" | "connectedglass:recipes/misc/borderless_glass_white_pane1" | "minecraft:recipes/transportation/powered_rail" | "connectedglass:recipes/misc/borderless_glass_white_pane2" | "connectedglass:recipes/misc/vanilla_magenta_stained_glass" | "biomeswevegone:biomeswevegone/adventure/inside_quicksand" | "minecraft:recipes/decorations/red_bed" | "connectedglass:recipes/misc/borderless_glass_white_pane3" | "minecraft:recipes/misc/iron_ingot_from_nuggets" | "biomeswevegone:recipes/building_blocks/windswept_sandstone_stairs" | "minecraft:recipes/transportation/jungle_boat" | "create:recipes/misc/crafting/kinetics/piston_extension_pole" | "yungscavebiomes:recipes/building_blocks/brittle_ancient_sandstone" | "biomeswevegone:recipes/building_blocks/stripped_cika_wood" | "immersiveengineering:recipes/misc/crafting/dynamo" | "ae2:recipes/misc/network/cables/dense_smart_gray" | "minecraft:recipes/redstone/heavy_weighted_pressure_plate" | "utilitarian:recipes/misc/no_soliciting/soliciting_carpets/pink_trapped_soliciting_carpet" | "biomeswevegone:recipes/redstone/cypress_door" | "mekanism:portable_teleporter" | "minecraft:recipes/building_blocks/cut_red_sandstone_slab_from_cut_red_sandstone_stonecutting" | "woodwevegot:recipes/decorations/florus_ladder" | "minecraft:story/enter_the_end" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_pink" | "connectedglass:recipes/misc/tinted_borderless_glass_pink2" | "minecraft:recipes/transportation/warped_fungus_on_a_stick" | "comforts:hammock_orange" | "minecraft:recipes/building_blocks/stripped_jungle_wood" | "create:recipes/building_blocks/polished_cut_calcite_from_stone_types_calcite_stonecutting" | "minecraft:recipes/building_blocks/stone_stairs" | "create:recipes/building_blocks/oak_window_pane" | "biomeswevegone:recipes/redstone/skyris_pressure_plate" | "mekanism:teleportation_core" | "biomeswevegone:recipes/building_blocks/ebony_slab" | "create:recipes/misc/smelting/iron_ingot_from_crushed" | "minecraft:recipes/building_blocks/purpur_slab_from_purpur_block_stonecutting" | "create:recipes/building_blocks/spruce_window_pane" | "minecraft:recipes/transportation/rail" | "minecraft:recipes/building_blocks/deepslate_brick_slab_from_deepslate_bricks_stonecutting" | "create:recipes/building_blocks/small_diorite_brick_slab" | "immersiveengineering:recipes/misc/crafting/ingot_lead_to_storage_lead" | "biomeswevegone:recipes/building_blocks/smooth_pink_sandstone_slab" | "compressium:recipes/building_blocks/soulsand_3_uncraft" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_black_to_slab" | "sophisticatedstorage:recipes/misc/backpack_advanced_jukebox_upgrade_from_storage_advanced_jukebox_upgrade" | "ae2:recipes/misc/shaped/walls/quartz_pillar" | "connectedglass:recipes/misc/vanilla_blue_stained_glass" | "repurposed_structures:fortress_jungle" | "woodwevegot:recipes/decorations/witch_hazel_ladder" | "ae2:recipes/misc/network/blocks/crank" | "create:recipes/misc/blasting/ingot_aluminium_compat_ic2" | "compressium:recipes/building_blocks/lapis_3_uncraft" | "minecraft:recipes/building_blocks/bone_block" | "advanced_ae:recipes/misc/portable_workbench_card" | "biomeswevegone:recipes/redstone/florus_trapdoor" | "sophisticatedbackpacks:recipes/misc/advanced_restock_upgrade" | "minecraft:recipes/building_blocks/waxed_cut_copper_stairs_from_honeycomb" | "minecraft:recipes/redstone/lever" | "create:recipes/decorations/andesite_scaffolding_from_andesite_alloy_stonecutting" | "immersiveengineering:main/chorus_cloche" | "minecraft:nether/obtain_crying_obsidian" | "minecraft:recipes/misc/magenta_dye_from_lilac" | "create:recipes/misc/crafting/materials/zinc_ingot_from_decompacting" | "mekanism:sawmill" | "compressium:recipes/building_blocks/andesite_6_uncraft" | "immersiveengineering:recipes/misc/stonecutting/stairs_concrete" | "immersiveengineering:recipes/misc/crafting/blueprint_molds" | "woodwevegot:recipes/decorations/willow_barrel" | "create:recipes/building_blocks/polished_cut_limestone_wall_from_stone_types_limestone_stonecutting" | "ae2:recipes/misc/block_cutter/stairs/quartz_pillar_stairs" | "minecraft:recipes/misc/pink_dye_from_pink_petals" | "biomeswevegone:recipes/building_blocks/chiseled_white_sandstone" | "biomeswevegone:recipes/decorations/aspen_hanging_sign" | "minecraft:recipes/decorations/rocky_stone_wall_from_rocky_stone_stonecutting" | "minecraft:husbandry/froglights" | "biomeswevegone:recipes/decorations/witch_hazel_hanging_sign" | "create:recipes/building_blocks/small_scorchia_bricks_from_stone_types_scorchia_stonecutting" | "minecraft:recipes/misc/melon_seeds" | "minecraft:recipes/building_blocks/magma_block" | "megacells:recipes/misc/crafting/bulk_cell_component" | "create:recipes/building_blocks/cut_crimsite_brick_wall_from_stone_types_crimsite_stonecutting" | "compressium:recipes/building_blocks/soulsand_7_uncraft" | "easy_mob_farm:recipes/upgrade/filter/no_flowers_filter" | "immersiveengineering:recipes/misc/stonecutting/stairs_slag_brick" | "immersiveengineering:recipes/misc/smelting/ingot_aluminum_from_blasting2" | "sophisticatedbackpacks:recipes/misc/smoking_upgrade" | "minecraft:recipes/building_blocks/smooth_red_sandstone_stairs_from_smooth_red_sandstone_stonecutting" | "create:recipes/building_blocks/cut_diorite_stairs_from_stone_types_diorite_stonecutting" | "connectedglass:recipes/misc/tinted_borderless_glass_red2" | "biomeswevegone:recipes/redstone/aspen_pressure_plate" | "biomeswevegone:recipes/decorations/ebony_hanging_sign" | "immersiveengineering:recipes/misc/smelting/ingot_aluminum_from_blasting3" | "lootr:1chest" | "sophisticatedbackpacks:recipes/misc/advanced_void_upgrade" | "immersiveengineering:recipes/misc/stonecutting/slag_brick" | "immersiveengineering:recipes/misc/crafting/chute_copper" | "minecraft:recipes/building_blocks/lime_terracotta" | "create:recipes/building_blocks/small_tuff_brick_stairs_from_stone_types_tuff_stonecutting" | "minecraft:recipes/building_blocks/smooth_quartz_slab_from_smooth_quartz_stonecutting" | "create:recipes/building_blocks/cut_scoria_brick_slab_recycling" | "biomeswevegone:recipes/decorations/mahogany_hanging_sign" | "minecraft:recipes/food/cake" | "utilitarian:recipes/misc/utility/warped_logs_to_slabs" | "minecraft:recipes/combat/iron_leggings" | "biomeswevegone:recipes/decorations/zelkova_crafting_table" | "minecraft:recipes/building_blocks/light_gray_terracotta" | "create:recipes/misc/crafting/kinetics/mechanical_crafter" | "mekanism:modification_station" | "create:ejector_maxed" | "mekanism:digital_miner" | "create:recipes/building_blocks/cut_scoria_brick_wall_from_stone_types_scoria_stonecutting" | "compressium:recipes/building_blocks/gravel_7_uncraft" | "biomeswevegone:recipes/building_blocks/stripped_palm_wood" | "create:recipes/building_blocks/cut_limestone_bricks_from_stone_types_limestone_stonecutting" | "domum_ornamentum:recipes/tools/blue_cobblestone_extra" | "biomeswevegone:recipes/decorations/jacaranda_fence" | "minecraft:recipes/decorations/gray_bed" | "create:recipes/misc/crafting/materials/brass_ingot_from_decompacting" | "biomeswevegone:recipes/redstone/redwood_door" | "immersiveengineering:recipes/misc/crafting/razor_wire" | "minecraft:recipes/misc/emerald_from_smelting_emerald_ore" | "minecraft:recipes/building_blocks/coarse_dirt" | "domum_ornamentum:recipes/tools/green_brick_extra" | "comforts:sleeping_bag_pink" | "biomeswevegone:recipes/building_blocks/stripped_blue_enchanted_wood" | "woodwevegot:recipes/redstone/sakura_trapped_chest" | "create:recipes/misc/crafting/kinetics/speedometer" | "utilitarian:recipes/misc/utility/spruce_logs_to_pressure_plates" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_slab_from_waxed_weathered_cut_copper_stonecutting" | "compressium:recipes/building_blocks/clay_8_uncraft" | "compressium:recipes/building_blocks/emerald_3_uncraft" | "minecraft:recipes/building_blocks/light_gray_concrete_powder" | "immersiveengineering:recipes/misc/crafting/plate_iron_hammering" | "mekanism:radiation_poisoning" | "aquaculture:recipes/aquaculture/worm_farm" | "create:recipes/building_blocks/small_diorite_brick_wall" | "compressium:recipes/building_blocks/soulsand_1_uncraft" | "immersiveengineering:recipes/misc/crafting/ingot_aluminum_to_storage_aluminum" | "minecraft:recipes/building_blocks/end_stone_brick_stairs_from_end_stone_brick_stonecutting" | "woodwevegot:recipes/decorations/cika_chest" | "comforts:hammock_magenta" | "compressium:recipes/building_blocks/cobblestone_8_uncraft" | "ae2:main/charger" | "aquaculture:recipes/aquaculture/tackle_box" | "minecraft:recipes/combat/leather_leggings" | "biomeswevegone:recipes/decorations/blue_enchanted_crafting_table" | "create:recipes/building_blocks/cut_veridium_bricks_from_stone_types_veridium_stonecutting" | "minecraft:recipes/building_blocks/pink_concrete_powder" | "minecraft:recipes/building_blocks/sandstone_slab" | "immersiveengineering:recipes/misc/crafting/gunpowder_from_dusts" | "immersiveengineering:recipes/misc/crafting/floodlight" | "ae2:recipes/misc/network/cables/glass_green" | "restrictedportals:root" | "immersiveengineering:recipes/misc/crafting/conveyor_vertical" | "immersiveengineering:recipes/misc/smelting/ingot_nickel_from_dust" | "minecraft:recipes/redstone/crimson_button" | "compressium:recipes/building_blocks/copper_5_uncraft" | "minecraft:story/obtain_armor" | "create:recipes/building_blocks/polished_cut_veridium_wall_from_stone_types_veridium_stonecutting" | "immersiveengineering:recipes/misc/crafting/shovel_steel" | "create:recipes/building_blocks/polished_cut_andesite_stairs" | "create:diving_suit" | "mekanism:purification_chamber" | "sophisticatedstorage:recipes/misc/shulker_from_chest" | "biomeswevegone:recipes/transportation/holly_boat" | "minecraft:recipes/combat/diamond_leggings" | "minecraft:recipes/decorations/gray_stained_glass_pane" | "megacells:recipes/misc/cells/standard/item_storage_cell_16m" | "fulleng:recipes/misc/terminals/part_storage_monitor_from_block" | "create:recipes/building_blocks/small_diorite_bricks_from_stone_types_diorite_stonecutting" | "minecraft:recipes/food/dried_kelp_from_smelting" | "woodwevegot:recipes/decorations/pine_chest" | "easy_mob_farm:recipes/mob_farm/nether_fortress_farm" | "create:recipes/misc/smelting/gold_ingot_from_crushed" | "compressium:recipes/building_blocks/iron_6_uncraft" | "connectedglass:recipes/misc/clear_glass_lime_pane2" | "create:hose_pulley_lava" | "connectedglass:recipes/misc/clear_glass_lime_pane1" | "connectedglass:recipes/misc/scratched_glass_gray_pane3" | "sophisticatedstorage:recipes/misc/basic_tier_upgrade" | "connectedglass:recipes/misc/scratched_glass_gray_pane1" | "connectedglass:recipes/misc/clear_glass_lime_pane3" | "connectedglass:recipes/misc/scratched_glass_gray_pane2" | "create:recipes/building_blocks/layered_diorite_from_stone_types_diorite_stonecutting" | "biomeswevegone:recipes/decorations/skyris_fence" | "sophisticatedstorage:recipes/misc/iron_to_gold_tier_upgrade" | "biomeswevegone:recipes/decorations/chiseled_red_rock_brick_wall" | "sophisticatedstorage:recipes/misc/limited_iron_barrel_1" | "aquaculture:recipes/tools/iron_fishing_rod" | "sophisticatedstorage:recipes/misc/limited_iron_barrel_2" | "compressium:recipes/building_blocks/netherite_4_uncraft" | "sophisticatedstorage:recipes/misc/limited_iron_barrel_3" | "sophisticatedstorage:recipes/misc/limited_iron_barrel_4" | "advanced_ae:recipes/misc/quantumstructure" | "sophisticatedstorage:recipes/misc/smoking_upgrade_from_smelting_upgrade" | "minecraft:recipes/building_blocks/cherry_slab" | "sophisticatedstorage:recipes/misc/compression_upgrade" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_stairs_from_waxed_weathered_copper_stonecutting" | "ae2:recipes/misc/network/cables/smart_white" | "create:recipes/building_blocks/small_ochrum_brick_stairs_from_stone_types_ochrum_stonecutting" | "sophisticatedbackpacks:recipes/misc/everlasting_upgrade" | "minecraft:end/kill_dragon" | "minecraft:recipes/building_blocks/polished_blackstone_brick_stairs" | "create:recipes/building_blocks/polished_cut_deepslate_slab" | "advanced_ae:recipes/misc/quantum_helmet" | "create:recipes/misc/smelting/scoria" | "minecraft:recipes/decorations/orange_candle" | "create:recipes/building_blocks/asurine_pillar_from_stone_types_asurine_stonecutting" | "compressium:recipes/building_blocks/snow_5_uncraft" | "minecraft:recipes/decorations/stone_brick_wall" | "create:encased_fan" | "utilitarian:recipes/misc/no_soliciting/soliciting_carpets/cyan_trapped_soliciting_carpet" | "biomeswevegone:recipes/building_blocks/baobab_planks" | "create:recipes/building_blocks/cut_diorite_wall_from_stone_types_diorite_stonecutting" | "ae2:recipes/misc/shaped/slabs/chiseled_quartz_block" | "minecraft:recipes/redstone/dark_oak_fence_gate" | "minecraft:recipes/building_blocks/waxed_weathered_copper_from_honeycomb" | "minecraft:recipes/misc/iron_nugget_from_smelting" | "minecraft:recipes/decorations/prismarine_wall_from_prismarine_stonecutting" | "minecraft:recipes/building_blocks/dye_light_gray_bed" | "biomeswevegone:recipes/building_blocks/packed_borealis_ice" | "woodwevegot:recipes/decorations/willow_chest" | "immersiveengineering:recipes/misc/crafting/constantan_mix" | "create:recipes/building_blocks/copper_shingle_slab" | "create:recipes/misc/crafting/kinetics/cuckoo_clock" | "immersiveengineering:recipes/misc/crafting/wire_copper" | "immersiveengineering:recipes/misc/crafting/nugget_uranium_to_ingot_uranium" | "connectedglass:recipes/misc/scratched_glass_green1" | "connectedglass:recipes/misc/scratched_glass_green2" | "minecraft:recipes/misc/copper_ingot_from_smelting_copper_ore" | "immersiveengineering:recipes/misc/crafting/empty_casing" | "ae2:recipes/misc/block_cutter/stairs/quartz_brick_stairs" | "minecraft:recipes/misc/blue_dye" | "mekanism:chemical_crystallizer" | "create:recipes/building_blocks/cut_ochrum_wall_from_stone_types_ochrum_stonecutting" | "immersiveengineering:recipes/misc/crafting/maintenance_kit" | "utilitarian:recipes/misc/fluid_hopper" | "utilitarian:recipes/misc/utility/warped_logs_to_trapdoors" | "minecraft:recipes/food/baked_potato_from_campfire_cooking" | "create:recipes/building_blocks/cut_deepslate_stairs" | "biomeswevegone:recipes/redstone/ironwood_fence_gate" | "create:recipes/misc/crafting/kinetics/analog_lever" | "yungscavebiomes:recipes/building_blocks/cut_ancient_sandstone_from_stonecutting" | "ae2netanalyser:recipes/misc/analyser" | "create:recipes/building_blocks/crafting/kinetics/blue_seat_from_other_seat" | "biomeswevegone:recipes/building_blocks/stripped_skyris_wood" | "apotheosis:enchanting/hellshelf" | "minecraft:recipes/misc/cyan_dye" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_red_from_slab" | "connectedglass:recipes/misc/tinted_borderless_glass_purple2" | "minecraft:recipes/building_blocks/cut_pink_sandstone_slab_from_cut_pink_sandstone_stonecutting" | "immersiveengineering:recipes/misc/stonecutting/hempcrete_pillar" | "compressium:recipes/building_blocks/redstone_8_uncraft" | "create:recipes/building_blocks/limestone_from_stone_types_limestone_stonecutting" | "minecraft:recipes/building_blocks/cut_white_sandstone_slab_from_white_sandstone_stonecutting" | "minecraft:husbandry/make_a_sign_glow" | "create:andesite_alloy" | "minecraft:recipes/building_blocks/dye_lime_wool" | "create:recipes/building_blocks/crafting/copper/waxed_oxidized_copper_tiles_from_honeycomb" | "create:recipes/misc/blasting/silver_ingot_compat_thermal" | "minecraft:recipes/redstone/acacia_pressure_plate" | "biomeswevegone:recipes/decorations/white_mangrove_crafting_table" | "create:water_wheel" | "easy_mob_farm:root" | "minecraft:nether/create_beacon" | "minecraft:recipes/building_blocks/crimson_slab" | "minecraft:recipes/building_blocks/rocky_stone_slab_from_rocky_stone_stonecutting" | "woodwevegot:recipes/decorations/aspen_chest" | "ae2:recipes/misc/network/blocks/spatial_io_port" | "ae2:recipes/misc/tools/paintballs_lumen_pink" | "create:recipes/building_blocks/vertical_framed_glass_from_glass_colorless_stonecutting" | "ae2:recipes/misc/shaped/walls/quartz_bricks" | "minecraft:recipes/building_blocks/crimson_stairs" | "ae2:recipes/misc/network/cables/glass_light_blue" | "biomeswevegone:biomeswevegone/husbandry/berrily_alive" | "compressium:recipes/building_blocks/gold_1_uncraft" | "createoreexcavation:recipes/misc/vein_finder" | "minecraft:recipes/building_blocks/green_stained_glass" | "sophisticatedstorage:recipes/misc/crimson_barrel" | "ae2:recipes/misc/network/parts/annihilation_plane_alt" | "megacells:recipes/misc/cells/standard/fluid_storage_cell_16m_with_housing" | "minecraft:recipes/building_blocks/bamboo_mosaic_slab" | "compressium:recipes/building_blocks/iron_1" | "minecraft:recipes/decorations/yellow_glazed_terracotta" | "ae2:recipes/misc/network/cables/glass_black" | "compressium:recipes/building_blocks/iron_2" | "compressium:recipes/building_blocks/iron_3" | "immersiveengineering:recipes/misc/crafting/slag_brick" | "compressium:recipes/building_blocks/iron_4" | "compressium:recipes/building_blocks/iron_5" | "create:recipes/building_blocks/small_granite_brick_slab_recycling" | "compressium:recipes/building_blocks/iron_6" | "compressium:recipes/building_blocks/iron_7" | "biomeswevegone:recipes/building_blocks/stripped_ironwood_wood" | "compressium:recipes/building_blocks/iron_8" | "ae2:recipes/misc/network/blocks/pattern_providers_interface" | "compressium:recipes/building_blocks/iron_9" | "create:recipes/building_blocks/small_diorite_brick_wall_from_stone_types_diorite_stonecutting" | "ae2:recipes/misc/shaped/walls/smooth_quartz_block" | "sophisticatedstorage:recipes/misc/birch_limited_barrel_4" | "sophisticatedstorage:recipes/misc/birch_limited_barrel_3" | "create:recipes/misc/crafting/logistics/redstone_link" | "sophisticatedstorage:recipes/misc/birch_limited_barrel_2" | "minecraft:recipes/building_blocks/bookshelf" | "sophisticatedstorage:recipes/misc/birch_limited_barrel_1" | "ae2:recipes/misc/block_cutter/stairs/fluix_stairs" | "dankstorage:recipes/tools/5_to_6" | "naturalist:recipes/naturalist/cut_limestone_stairs" | "ae2:recipes/misc/network/parts/storage_bus" | "biomeswevegone:recipes/food/cooked_yucca_fruit_from_smelting" | "sophisticatedbackpacks:recipes/misc/auto_smelting_upgrade" | "ae2:recipes/misc/block_cutter/slabs/chiseled_quartz_slab" | "compressium:recipes/building_blocks/gold_7_uncraft" | "create:recipes/misc/crafting/kinetics/cart_assembler" | "immersiveengineering:recipes/misc/stonecutting/slab_clinker_brick" | "woodwevegot:recipes/decorations/holly_barrel" | "create:recipes/building_blocks/small_tuff_bricks_from_stone_types_tuff_stonecutting" | "minecraft:story/iron_tools" | "ae2:recipes/misc/tools/certus_quartz_axe" | "compressium:recipes/building_blocks/obsidian_2_uncraft" | "create:recipes/building_blocks/exposed_copper_shingle_stairs_from_exposed_copper_shingles_stonecutting" | "create:recipes/misc/smelting/glass_pane_from_vertical_framed_glass_pane" | "create:recipes/misc/crafting/kinetics/controller_rail" | "minecraft:recipes/decorations/polished_blackstone_brick_wall_from_blackstone_stonecutting" | "minecraft:recipes/combat/iron_chestplate" | "utilitarian:recipes/misc/utility/spruce_logs_to_doors" | "biomeswevegone:recipes/building_blocks/blue_stained_glass_from_blue_sand" | "create:recipes/building_blocks/small_deepslate_brick_stairs_from_stone_types_deepslate_stonecutting" | "minecraft:recipes/redstone/dark_oak_trapdoor" | "immersiveengineering:recipes/misc/crafting/toolupgrade_chemthrower_focus" | "sophisticatedstorage:recipes/misc/void_upgrade" | "minecraft:recipes/redstone/oak_trapdoor" | "create:recipes/building_blocks/tiled_glass_pane" | "biomeswevegone:recipes/redstone/fir_fence_gate" | "biomeswevegone:recipes/decorations/willow_hanging_sign" | "ae2:recipes/misc/network/cells/spatial_storage_cell_2_cubed" | "sophisticatedstorage:recipes/misc/packing_tape" | "compressium:recipes/building_blocks/diamond_4_uncraft" | "immersiveengineering:recipes/misc/smelting/nugget_aluminum_recycle_faraday_helmet" | "create:recipes/building_blocks/limestone_pillar_from_stone_types_limestone_stonecutting" | "sophisticatedbackpacks:recipes/misc/chipped/mason_table_upgrade" | "connectedglass:recipes/misc/scratched_glass_magenta_pane1" | "connectedglass:recipes/misc/scratched_glass_magenta_pane2" | "create:honey_drain" | "biomeswevegone:recipes/redstone/cika_door" | "biomeswevegone:recipes/decorations/cypress_sign" | "dimstorage:recipes/misc/dim_wall" | "connectedglass:recipes/misc/scratched_glass_gray1" | "domum_ornamentum:recipes/decorations/lime_floating_carpet" | "connectedglass:recipes/misc/scratched_glass_gray2" | "yungscavebiomes:recipes/building_blocks/chiseled_ancient_sandstone_from_stonecutting" | "connectedglass:recipes/misc/scratched_glass_light_gray2" | "connectedglass:recipes/misc/vanilla_black_stained_glass_pane" | "connectedglass:recipes/misc/scratched_glass_light_gray1" | "immersiveengineering:recipes/misc/crafting/connector_probe" | "utilitarian:recipes/misc/utility/iron_block_from_blasting" | "minecraft:recipes/building_blocks/deepslate_brick_stairs_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/misc/book" | "biomeswevegone:recipes/building_blocks/pink_stained_glass_from_pink_sand" | "minecraft:recipes/building_blocks/purpur_slab" | "create:recipes/building_blocks/small_deepslate_brick_wall_from_stone_types_deepslate_stonecutting" | "ae2:recipes/misc/misc/deconstruction_certus_quartz_block" | "biomeswevegone:recipes/decorations/rainbow_eucalyptus_sign" | "create:recipes/building_blocks/crafting/kinetics/brown_seat" | "compressium:recipes/building_blocks/lapis_6_uncraft" | "immersiveengineering:recipes/misc/crafting/storage_aluminum_to_ingot_aluminum" | "utilitarian:recipes/misc/utility/acacia_logs_to_slabs" | "minecraft:recipes/combat/stone_sword" | "minecraft:recipes/decorations/cobblestone_wall" | "domum_ornamentum:recipes/tools/magenta_brick_extra" | "minecraft:recipes/building_blocks/purple_sandstone_stairs_from_purple_sandstone_stonecutting" | "immersiveengineering:recipes/misc/crafting/nugget_electrum_to_ingot_electrum" | "minecraft:recipes/building_blocks/cut_black_sandstone_slab_from_black_sandstone_stonecutting" | "minecraft:recipes/misc/dune_armor_trim_smithing_template_smithing_trim" | "fulleng:recipes/misc/terminals/block_conversion_monitor_from_part" | "immersiveengineering:recipes/misc/crafting/sheetmetal_uranium_to_slab" | "ae2:recipes/misc/network/blocks/energy_energy_acceptor_alt" | "connectedglass:recipes/misc/scratched_glass_magenta_pane3" | "create:recipes/misc/smelting/ingot_lead_compat_mekanism" | "jamd:recipes/transportation/portal_block" | "minecraft:recipes/building_blocks/brown_stained_glass" | "sophisticatedstorage:recipes/misc/oak_limited_barrel_1" | "compressium:recipes/building_blocks/quartz_3_uncraft" | "sophisticatedstorage:recipes/misc/oak_limited_barrel_2" | "sophisticatedstorage:recipes/misc/oak_limited_barrel_3" | "sophisticatedstorage:recipes/misc/oak_limited_barrel_4" | "create:recipes/building_blocks/cut_asurine_from_stone_types_asurine_stonecutting" | "ae2:recipes/misc/block_cutter/walls/smooth_sky_stone_wall" | "minecraft:recipes/decorations/brown_carpet" | "mekanism:factory" | "naturalist:recipes/naturalist/cut_limestone_slab" | "immersiveengineering:recipes/misc/crafting/wirecoil_structure_rope" | "minecraft:recipes/decorations/red_stained_glass_pane" | "minecraft:recipes/food/dried_kelp_from_campfire_cooking" | "minecraft:recipes/combat/netherite_sword_smithing" | "apotheosis:enchanting/upgrade_endshelf" | "compressium:recipes/building_blocks/quartz_9_uncraft" | "minecraft:recipes/building_blocks/dacite_tile_from_dacite_bricks_stonecutting" | "immersiveengineering:recipes/misc/crafting/armor_steel_boots" | "create:pulley_maxed" | "compressium:recipes/building_blocks/clay_2_uncraft" | "create:recipes/building_blocks/veridium_from_stone_types_veridium_stonecutting" | "sophisticatedstorage:recipes/misc/spruce_chest" | "immersiveengineering:recipes/misc/crafting/stairs_steel_scaffolding_standard" | "dimstorage:recipes/misc/solid_dim_core" | "connectedglass:recipes/misc/clear_glass_pink_pane3" | "compressium:recipes/building_blocks/stone_6_uncraft" | "connectedglass:recipes/misc/clear_glass_pink_pane2" | "immersiveengineering:recipes/misc/crafting/pickaxe_steel" | "connectedglass:recipes/misc/clear_glass_pink_pane1" | "compressium:recipes/building_blocks/gravel_9" | "compressium:recipes/building_blocks/gravel_8" | "immersiveengineering:main/connect_wire" | "compressium:recipes/building_blocks/gravel_7" | "compressium:recipes/building_blocks/gravel_6" | "minecraft:recipes/misc/diamond" | "compressium:recipes/building_blocks/gravel_5" | "immersiveengineering:recipes/misc/crafting/gunpowder_barrel" | "minecraft:recipes/misc/gold_nugget_from_smelting" | "compressium:recipes/building_blocks/gravel_4" | "compressium:recipes/building_blocks/gravel_3" | "compressium:recipes/building_blocks/gravel_2" | "compressium:recipes/building_blocks/gravel_1" | "mekanism:alarm" | "minecraft:recipes/food/cooked_chicken" | "create:recipes/building_blocks/small_veridium_bricks_from_stone_types_veridium_stonecutting" | "ae2:recipes/misc/tools/misctools_charged_staff" | "biomeswevegone:recipes/building_blocks/blue_enchanted_slab" | "minecraft:recipes/misc/netherite_upgrade_smithing_template" | "ae2:recipes/misc/network/cells/fluid_storage_cell_4k_storage" | "compressium:recipes/building_blocks/granite_7_uncraft" | "advanced_ae:recipes/misc/quantum_helmet_item_reset" | "minecraft:recipes/tools/stone_axe" | "friendsandfoes:husbandry/tame_a_glare" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_green_from_slab" | "create:chocolate_bucket" | "create:recipes/building_blocks/asurine_from_stone_types_asurine_stonecutting" | "compressium:recipes/building_blocks/gravel_1_uncraft" | "biomeswevegone:recipes/decorations/skyris_hanging_sign" | "dimstorage:recipes/misc/dimensional_tank" | "comforts:sleeping_bag_light_gray" | "create:recipes/building_blocks/cut_deepslate_wall" | "create:recipes/building_blocks/small_veridium_brick_stairs_from_stone_types_veridium_stonecutting" | "minecraft:recipes/decorations/blue_candle" | "megacells:recipes/misc/cells/standard/fluid_storage_cell_256m" | "create:recipes/misc/blasting/zinc_ingot_from_raw_ore" | "create:recipes/misc/crafting/kinetics/mysterious_cuckoo_clock" | "aquaculture:recipes/aquaculture/note_hook" | "minecraft:nether/ride_strider" | "biomeswevegone:recipes/building_blocks/zelkova_wood" | "create:recipes/building_blocks/cut_granite_brick_wall_from_stone_types_granite_stonecutting" | "create:recipes/building_blocks/cut_asurine_stairs_from_stone_types_asurine_stonecutting" | "biomeswevegone:recipes/building_blocks/zelkova_planks" | "immersiveengineering:recipes/misc/crafting/storage_uranium_to_slab" | "compressium:recipes/building_blocks/sand_3" | "compressium:recipes/building_blocks/sand_2" | "biomeswevegone:recipes/building_blocks/ironwood_planks" | "compressium:recipes/building_blocks/sand_5" | "create:recipes/building_blocks/small_andesite_brick_stairs" | "compressium:recipes/building_blocks/sand_4" | "biomeswevegone:recipes/building_blocks/green_enchanted_stairs" | "compressium:recipes/building_blocks/sand_7" | "ae2:recipes/misc/block_cutter/slabs/fluix_slab" | "compressium:recipes/building_blocks/sand_6" | "sophisticatedbackpacks:recipes/misc/chipped/carpenters_table_upgrade" | "compressium:recipes/building_blocks/sand_9" | "compressium:recipes/building_blocks/sand_8" | "biomeswevegone:recipes/building_blocks/stripped_ebony_wood" | "minecraft:recipes/building_blocks/waxed_cut_copper_slab_from_honeycomb" | "minecraft:recipes/misc/iron_nugget" | "immersiveengineering:recipes/misc/crafting/sheetmetal_steel" | "friendsandfoes:adventure/the_magicians" | "minecraft:recipes/building_blocks/brown_concrete_powder" | "naturalist:husbandry/feed_hippo_melon" | "create:recipes/building_blocks/cut_calcite_slab_from_stone_types_calcite_stonecutting" | "compressium:recipes/building_blocks/redsand_3_uncraft" | "minecraft:end/levitate" | "create:recipes/misc/blasting/tin_ingot_compat_thermal" | "immersiveengineering:recipes/misc/crafting/treated_wallmount" | "mekanism:elite_control_circuit" | "apotheosis:enchanting/arcana50" | "immersiveengineering:recipes/misc/crafting/toolupgrade_railgun_scope" | "minecraft:recipes/building_blocks/blue_stained_glass" | "aquaculture:recipes/food/cooked_fish_fillet_from_campfire" | "create:self_deploying" | "compressium:recipes/building_blocks/sand_2_uncraft" | "compressium:recipes/building_blocks/obsidian_8_uncraft" | "immersiveengineering:recipes/misc/crafting/cokebrick" | "ae2:recipes/misc/decorative/certus_quartz_pillar_from_stonecutting" | "ae2:recipes/misc/materials/cardcrafting" | "utilitarian:recipes/misc/utility/cherry_logs_to_trapdoors" | "minecraft:recipes/building_blocks/cracked_stone_bricks" | "immersiveengineering:recipes/misc/crafting/metal_ladder_none" | "compressium:recipes/building_blocks/netherite_2" | "aeinfinitybooster:recipes/misc/infinity_card" | "compressium:recipes/building_blocks/netherite_3" | "compressium:recipes/building_blocks/netherite_1" | "connectedglass:recipes/misc/borderless_glass_gray2" | "immersiveengineering:recipes/misc/crafting/stairs_treated_wood_horizontal" | "immersiveengineering:main/mb_cokeoven" | "connectedglass:recipes/misc/borderless_glass_gray1" | "minecraft:recipes/building_blocks/cut_copper_slab_from_cut_copper_stonecutting" | "woodwevegot:recipes/decorations/witch_hazel_chest" | "minecraft:recipes/misc/iron_ingot_from_blasting_iron_ore" | "mekanism:reinforced_alloy" | "compressium:recipes/building_blocks/netherite_8" | "compressium:recipes/building_blocks/netherite_9" | "minecraft:recipes/misc/bucket" | "compressium:recipes/building_blocks/netherite_6" | "compressium:recipes/building_blocks/netherite_7" | "create:recipes/building_blocks/small_calcite_brick_slab_from_stone_types_calcite_stonecutting" | "ae2:main/qnb" | "compressium:recipes/building_blocks/netherite_4" | "minecraft:adventure/bullseye" | "create:recipes/building_blocks/cut_dripstone_brick_wall" | "minecraft:recipes/building_blocks/diorite_slab" | "compressium:recipes/building_blocks/netherite_5" | "minecraft:recipes/building_blocks/stone_brick_stairs_from_stone_bricks_stonecutting" | "create:recipes/building_blocks/polished_cut_veridium_slab_from_stone_types_veridium_stonecutting" | "justhammers:recipes/tools/gold_reinforced_hammer" | "biomeswevegone:recipes/decorations/ebony_fence" | "biomeswevegone:recipes/building_blocks/blue_sandstone" | "sophisticatedstorage:recipes/misc/advanced_compacting_upgrade" | "compressium:recipes/building_blocks/coal_9_uncraft" | "minecraft:recipes/decorations/orange_stained_glass_pane" | "justhammers:recipes/tools/reinforced_core" | "create:recipes/building_blocks/small_scoria_brick_stairs_from_stone_types_scoria_stonecutting" | "woodwevegot:recipes/decorations/blue_enchanted_barrel" | "create:recipes/misc/crafting/kinetics/track_station" | "minecraft:recipes/building_blocks/light_blue_concrete_powder" | "create:recipes/building_blocks/cut_diorite_wall" | "createoreexcavation:recipes/misc/diamond_drill" | "create:recipes/misc/crafting/kinetics/mechanical_roller" | "biomeswevegone:recipes/redstone/jacaranda_button" | "immersiveengineering:multiblocks/mb_squeezer" | "domum_ornamentum:recipes/decorations/white_floating_carpet" | "javd:recipes/transportation/portal_block" | "biomeswevegone:recipes/building_blocks/blue_enchanted_wood" | "minecraft:recipes/building_blocks/glass" | "biomeswevegone:recipes/building_blocks/purple_stained_glass_from_purple_sand" | "biomeswevegone:recipes/building_blocks/skyris_planks" | "minecraft:recipes/combat/bow" | "biomeswevegone:recipes/building_blocks/florus_planks" | "woodwevegot:recipes/decorations/fir_barrel" | "domum_ornamentum:recipes/tools/white_paper_extra" | "immersiveengineering:main/villager" | "connectedglass:recipes/misc/clear_glass_yellow1" | "sophisticatedstorage:recipes/misc/limited_gold_barrel_1" | "minecraft:recipes/building_blocks/acacia_slab" | "connectedglass:recipes/misc/clear_glass_yellow2" | "sophisticatedstorage:recipes/misc/limited_gold_barrel_2" | "minecraft:recipes/building_blocks/smooth_sandstone" | "sophisticatedstorage:recipes/misc/limited_gold_barrel_3" | "minecraft:recipes/building_blocks/oxidized_cut_copper" | "sophisticatedstorage:recipes/misc/limited_gold_barrel_4" | "ae2:recipes/misc/block_cutter/walls/smooth_quartz_wall" | "compressium:recipes/building_blocks/endstone_6_uncraft" | "createoreexcavation:recipes/misc/drill" | "create:recipes/building_blocks/cut_diorite_bricks_from_stone_types_diorite_stonecutting" | "biomeswevegone:recipes/decorations/mahogany_sign" | "immersiveengineering:recipes/misc/smelting/ingot_uranium3" | "biomeswevegone:recipes/decorations/cattail_thatch_carpet" | "immersiveengineering:recipes/misc/smelting/ingot_uranium2" | "utilitarian:recipes/misc/utility/mangrove_logs_to_boats" | "connectedglass:recipes/misc/clear_glass_pane3" | "immersiveengineering:recipes/misc/crafting/concrete_brick_from_slab" | "ae2:recipes/misc/network/cables/dense_smart_red" | "connectedglass:recipes/misc/clear_glass_pane1" | "ae2:main/fluix" | "ae2:recipes/misc/block_cutter/slabs/sky_stone_small_brick_slab" | "minecraft:recipes/transportation/minecart" | "minecraft:recipes/decorations/orange_glazed_terracotta" | "buddingcrystals:recipes/misc/budding_awakeneddraconium" | "create:andesite_casing" | "create:recipes/building_blocks/crafting/kinetics/gray_seat" | "ae2:recipes/misc/network/cables/covered_black" | "create:recipes/misc/crafting/materials/copper_nugget" | "minecraft:recipes/decorations/green_stained_glass_pane" | "minecraft:recipes/tools/iron_hoe" | "minecraft:recipes/decorations/rose" | "minecraft:recipes/building_blocks/deepslate_tile_stairs_from_polished_deepslate_stonecutting" | "advanced_ae:recipes/misc/flight_card" | "advanced_ae:recipes/misc/quantum_alloy_block" | "advanced_ae:recipes/misc/night_vision_card" | "ae2:recipes/misc/network/cables/glass_pink" | "immersiveengineering:recipes/misc/crafting/sheetmetal_silver" | "utilitarian:recipes/misc/utility/birch_logs_to_boats" | "sophisticatedstorage:recipes/misc/backpack_stack_upgrade_starter_tier_from_storage_stack_upgrade_tier_1_plus" | "ae2:recipes/misc/tools/network_memory_card" | "minecraft:recipes/misc/bowl" | "create:recipes/building_blocks/polished_cut_granite_stairs_from_stone_types_granite_stonecutting" | "biomeswevegone:recipes/decorations/sakura_crafting_table" | "sophisticatedstorage:recipes/misc/auto_blasting_upgrade" | "apotheosis:enchanting/100ench" | "compressium:recipes/building_blocks/diamond_1" | "biomeswevegone:recipes/transportation/cika_chest_boat" | "create:steam_engine_maxed" | "yungscavebiomes:frost_potion" | "woodwevegot:recipes/decorations/baobab_chest" | "compressium:recipes/building_blocks/diamond_3" | "minecraft:recipes/building_blocks/dye_orange_carpet" | "ae2:recipes/misc/tools/nether_quartz_sword" | "compressium:recipes/building_blocks/diamond_2" | "compressium:recipes/building_blocks/diamond_5" | "create:recipes/building_blocks/crafting/kinetics/white_seat_from_other_seat" | "compressium:recipes/building_blocks/diamond_4" | "compressium:recipes/building_blocks/diamond_7" | "compressium:recipes/building_blocks/diamond_6" | "minecraft:recipes/tools/clock" | "compressium:recipes/building_blocks/diamond_9" | "compressium:recipes/building_blocks/diamond_8" | "biomeswevegone:recipes/building_blocks/pine_planks" | "mekanism:diversion_item_transport" | "biomeswevegone:recipes/building_blocks/fir_slab" | "biomeswevegone:recipes/redstone/blue_enchanted_door" | "utilitarian:recipes/misc/utility/spruce_logs_to_boats" | "ae2:recipes/misc/network/cells/item_storage_cell_4k_storage" | "minecraft:story/enter_the_nether" | "utilitarian:recipes/misc/no_soliciting/soliciting_carpets/pink_soliciting_carpet" | "immersiveengineering:main/craft_pump" | "minecraft:recipes/decorations/red_glazed_terracotta" | "create:recipes/building_blocks/cut_crimsite_brick_slab_from_stone_types_crimsite_stonecutting" | "immersiveengineering:recipes/misc/crafting/alu_scaffolding_standard_from_wooden_top" | "minecraft:adventure/whos_the_pillager_now" | "create:recipes/building_blocks/small_asurine_bricks_from_stone_types_asurine_stonecutting" | "compressium:recipes/building_blocks/dirt_9_uncraft" | "immersiveengineering:recipes/misc/crafting/conveyor_dropper_covered" | "create:recipes/building_blocks/cut_crimsite_brick_stairs_from_stone_types_crimsite_stonecutting" | "minecraft:recipes/food/baked_potato" | "create:recipes/misc/crafting/kinetics/filter" | "sophisticatedstorage:recipes/misc/storage_void_upgrade_from_backpack_void_upgrade" | "create:recipes/building_blocks/cut_andesite_stairs" | "utilitarian:recipes/misc/utility/jungle_logs_to_pressure_plates" | "connectedglass:recipes/misc/scratched_glass_cyan_pane3" | "create:recipes/building_blocks/cut_limestone_brick_stairs" | "immersiveengineering:recipes/misc/crafting/strip_mv" | "connectedglass:recipes/misc/scratched_glass_cyan_pane1" | "connectedglass:recipes/misc/scratched_glass_cyan_pane2" | "biomeswevegone:recipes/building_blocks/stripped_palo_verde_wood" | "create:recipes/misc/crafting/kinetics/white_sail" | "mekanismtools:alternate_armor" | "compressium:recipes/building_blocks/redstone_2_uncraft" | "create:recipes/building_blocks/crafting/copper/waxed_weathered_copper_shingle_slab_from_honeycomb" | "create:recipes/misc/crafting/tree_fertilizer" | "minecraft:recipes/decorations/green_banner" | "biomeswevegone:recipes/redstone/cika_pressure_plate" | "create:recipes/misc/smelting/silver_ingot_compat_oreganized" | "woodwevegot:recipes/decorations/ebony_ladder" | "minecraft:recipes/misc/gold_ingot_from_nuggets" | "sophisticatedstorage:recipes/misc/gold_shulker_box" | "sophisticatedstorage:recipes/misc/storage_link" | "biomeswevegone:recipes/decorations/maple_fence" | "utilitarian:recipes/misc/utility/dark_oak_logs_to_slabs" | "utilitarian:recipes/misc/utility/bamboo_logs_to_trapdoors" | "repurposed_structures:monuments" | "comforts:hammock_gray" | "immersiveengineering:recipes/misc/stonecutting/hempcrete_brick" | "create:recipes/building_blocks/cut_scorchia_bricks_from_stone_types_scorchia_stonecutting" | "minecraft:recipes/misc/pink_dye_from_pink_tulip" | "minecraft:recipes/building_blocks/mangrove_stairs" | "sophisticatedbackpacks:recipes/misc/auto_smoking_upgrade" | "biomeswevegone:recipes/building_blocks/pine_bookshelf" | "immersiveengineering:recipes/misc/crafting/strip_lv" | "create:recipes/building_blocks/polished_cut_crimsite_from_stone_types_crimsite_stonecutting" | "immersiveengineering:recipes/misc/crafting/concrete_brick" | "woodwevegot:recipes/decorations/redwood_barrel" | "sophisticatedstorage:recipes/misc/storage_crafting_upgrade_from_backpack_crafting_upgrade" | "create:recipes/building_blocks/cut_deepslate_brick_wall" | "minecraft:recipes/decorations/spruce_sign" | "sophisticatedstorage:recipes/misc/iron_to_diamond_tier_upgrade" | "minecraft:recipes/misc/wayfinder_armor_trim_smithing_template" | "create:recipes/building_blocks/layered_granite_from_stone_types_granite_stonecutting" | "sophisticatedbackpacks:recipes/misc/diamond_backpack" | "create:recipes/building_blocks/cut_calcite_brick_wall" | "utilitarian:recipes/misc/no_soliciting/soliciting_carpets/purple_soliciting_carpet" | "naturalist:recipes/naturalist/limestone_bricks" | "sophisticatedstorage:recipes/misc/pickup_upgrade" | "sophisticatedstorage:recipes/misc/backpack_stack_upgrade_tier_2_from_storage_stack_upgrade_tier_3" | "easy_mob_farm:crafting/mob_farm_template/tier2_mob_farm_template" | "ae2:main/crafting_terminal" | "create:anvil_plough" | "ae2:main/ioport" | "advanced_ae:recipes/misc/reach_card" | "minecraft:recipes/building_blocks/bricks" | "minecraft:recipes/combat/netherite_leggings_smithing" | "sophisticatedstorage:recipes/misc/oak_barrel" | "woodwevegot:recipes/decorations/ironwood_barrel" | "buddingcrystals:recipes/misc/budding_iron" | "biomeswevegone:recipes/transportation/maple_boat" | "minecraft:recipes/building_blocks/smooth_pink_sandstone_slab_from_pink_sandstone_stonecutting" | "minecraft:recipes/decorations/painting" | "create:stressometer" | "immersiveengineering:recipes/misc/crafting/stick_steel" | "minecraft:recipes/building_blocks/waxed_cut_copper" | "ae2:recipes/misc/tools/fluix_hoe" | "biomeswevegone:recipes/building_blocks/white_mangrove_stairs" | "minecraft:recipes/building_blocks/red_terracotta" | "minecraft:recipes/combat/arrow" | "ae2:recipes/misc/network/cables/dense_covered_purple" | "ae2:recipes/misc/network/blocks/spatial_anchor" | "aquaculture:recipes/aquaculture/gold_hook" | "justhammers:recipes/tools/gold_destructor_hammer" | "biomeswevegone:recipes/building_blocks/witch_hazel_slab" | "create:recipes/building_blocks/small_diorite_brick_slab_recycling" | "sophisticatedbackpacks:recipes/misc/chipped/alchemy_bench_upgrade" | "advanced_ae:recipes/misc/advpatpropart" | "immersiveengineering:recipes/misc/crafting/wirecoil_electrum" | "repurposed_structures:temples" | "create:recipes/building_blocks/crafting/kinetics/red_seat" | "create:recipes/building_blocks/polished_cut_veridium_slab_recycling" | "minecraft:recipes/building_blocks/polished_deepslate_stairs_from_polished_deepslate_stonecutting" | "minecraft:recipes/misc/vex_armor_trim_smithing_template_smithing_trim" | "immersiveengineering:recipes/misc/crafting/concrete_tile_to_slab" | "immersiveengineering:recipes/misc/crafting/drillhead_iron" | "immersiveengineering:multiblocks/mb_refinery" | "minecraft:recipes/combat/golden_helmet" | "immersiveengineering:recipes/misc/crafting/hempcrete_to_slab" | "minecraft:recipes/redstone/acacia_trapdoor" | "create:recipes/misc/smelting/glass_pane_from_framed_glass_pane" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_from_waxed_exposed_copper_stonecutting" | "create:recipes/building_blocks/crafting/kinetics/light_gray_seat" | "immersiveengineering:recipes/misc/crafting/lantern" | "create:recipes/building_blocks/crafting/copper/waxed_exposed_copper_tiles_from_honeycomb" | "immersiveengineering:recipes/misc/smelting/nugget_steel_recycle_axe" | "create:recipes/building_blocks/cut_ochrum_stairs" | "ae2:recipes/misc/network/blocks/energy_dense_energy_cell" | "minecraft:recipes/building_blocks/brick_slab_from_bricks_stonecutting" | "create:recipes/building_blocks/polished_cut_andesite_slab" | "biomeswevegone:recipes/decorations/aspen_sign" | "hangglider:recipes/tools/hang_glider" | "biomeswevegone:recipes/transportation/sakura_boat" | "utilitarian:recipes/misc/utility/bamboo_logs_to_doors" | "create:train" | "immersiveengineering:recipes/misc/crafting/sheetmetal_lead" | "minecraft:recipes/food/cooked_salmon" | "minecraft:recipes/building_blocks/cherry_stairs" | "biomeswevegone:recipes/decorations/maple_hanging_sign" | "woodwevegot:recipes/decorations/aspen_ladder" | "biomeswevegone:recipes/redstone/green_enchanted_door" | "create:recipes/building_blocks/small_andesite_brick_wall" | "create:recipes/building_blocks/small_tuff_brick_stairs" | "ae2:recipes/misc/network/cables/smart_red" | "immersiveengineering:recipes/misc/crafting/rockcutter" | "biomeswevegone:recipes/building_blocks/stripped_zelkova_wood" | "ae2:recipes/misc/block_cutter/slabs/quartz_pillar_slab" | "immersiveengineering:recipes/misc/crafting/ingot_constantan_to_nugget_constantan" | "yungscavebiomes:recipes/building_blocks/cut_ancient_sandstone_slab" | "immersiveengineering:recipes/misc/crafting/concrete_leaded_from_slab" | "connectedglass:recipes/misc/vanilla_orange_stained_glass_pane" | "easy_mob_farm:recipes/mob_farm_template/tier1_mob_farm_template" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_red_to_slab" | "connectedglass:recipes/misc/tinted_borderless_glass_gray2" | "biomeswevegone:recipes/decorations/baobab_crafting_table" | "immersiveengineering:recipes/misc/crafting/sheetmetal_electrum" | "biomeswevegone:recipes/building_blocks/stripped_pine_wood" | "immersiveengineering:recipes/misc/crafting/stairs_concrete_tile" | "aquaculture:recipes/decorations/oak_fish_mount" | "create:recipes/building_blocks/cut_deepslate_slab_from_stone_types_deepslate_stonecutting" | "domum_ornamentum:recipes/building_blocks/blockbarreldeco_onside" | "biomeswevegone:recipes/building_blocks/zelkova_slab" | "minecraft:recipes/decorations/composter" | "biomeswevegone:recipes/building_blocks/witch_hazel_bookshelf" | "ae2:recipes/misc/decorative/sky_stone_brick" | "create:recipes/building_blocks/cut_ochrum_brick_slab" | "minecraft:recipes/building_blocks/red_nether_brick_stairs_from_red_nether_bricks_stonecutting" | "create:recipes/building_blocks/crafting/kinetics/orange_seat" | "create:recipes/building_blocks/dripstone_block_from_stone_types_dripstone_stonecutting" | "sophisticatedstorage:recipes/misc/upgrade_base" | "biomeswevegone:recipes/building_blocks/rocky_stone_stairs" | "create:recipes/building_blocks/cut_scorchia_slab" | "create:recipes/building_blocks/weathered_copper_tile_stairs" | "biomeswevegone:recipes/building_blocks/witch_hazel_planks" | "ae2:recipes/misc/block_cutter/walls/sky_stone_brick_wall" | "create:recipes/building_blocks/cut_calcite_brick_stairs" | "immersiveengineering:recipes/misc/crafting/sheetmetal_gold_from_slab" | "yungscavebiomes:recipes/building_blocks/cut_ancient_sandstone_slab_from_cut_stonecutting" | "minecraft:recipes/building_blocks/end_stone_bricks" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_starter_tier" | "immersiveengineering:recipes/misc/crafting/concrete_to_slab" | "create:recipes/building_blocks/crafting/copper/waxed_exposed_copper_shingles_from_honeycomb" | "minecraft:recipes/decorations/glow_item_frame" | "minecraft:recipes/decorations/mossy_red_rock_brick_wall_from_mossy_red_rock_bricks_stonecutting" | "minecraft:husbandry/silk_touch_nest" | "minecraft:recipes/building_blocks/dark_prismarine_stairs" | "minecraft:recipes/building_blocks/dye_cyan_wool" | "ae2:recipes/misc/tools/portable_item_cell_16k" | "minecraft:recipes/decorations/andesite_wall_from_andesite_stonecutting" | "utilitarian:recipes/food/utility/charcoal_from_campfire" | "minecraft:recipes/building_blocks/waxed_cut_copper_from_honeycomb" | "minecraft:recipes/building_blocks/nether_brick_stairs" | "dimstorage:recipes/misc/dim_core" | "sophisticatedstorage:recipes/misc/purple_shulker_box_to_sophisticated" | "biomeswevegone:recipes/redstone/maple_button" | "create:train_roadkill" | "sophisticatedbackpacks:recipes/misc/chipped/glassblower_upgrade" | "immersiveengineering:recipes/misc/smelting/nugget_aluminum_recycle_faraday_leggings" | "create:recipes/building_blocks/cut_crimsite_stairs_from_stone_types_crimsite_stonecutting" | "compressium:recipes/building_blocks/emerald_9_uncraft" | "comforts:sleeping_bag_magenta" | "immersiveengineering:recipes/misc/stonecutting/concrete_chiseled2" | "create:recipes/misc/crafting/kinetics/black_valve_handle_from_other_valve_handle" | "connectedglass:recipes/misc/borderless_glass_yellow1" | "connectedglass:recipes/misc/borderless_glass_yellow2" | "minecraft:recipes/building_blocks/smooth_red_sandstone_slab" | "utilitarian:recipes/misc/utility/cherry_logs_to_pressure_plates" | "create:recipes/building_blocks/oxidized_copper_tile_stairs_from_oxidized_copper_tiles_stonecutting" | "biomeswevegone:recipes/building_blocks/cut_purple_sandstone" | "sophisticatedstorage:recipes/misc/backpack_advanced_void_upgrade_from_storage_advanced_void_upgrade" | "sophisticatedstorage:recipes/misc/backpack_jukebox_upgrade_from_storage_jukebox_upgrade" | "ae2:recipes/misc/shaped/walls/quartz_block" | "minecraft:story/smelt_iron" | "create:brass_casing" | "minecraft:recipes/misc/orange_dye_from_torchflower" | "sophisticatedstorage:recipes/misc/storage_stack_upgrade_tier_4_from_backpack_stack_upgrade_tier_3" | "justhammers:recipes/tools/iron_reinforced_impact_hammer" | "create:recipes/misc/smelting/ingot_tin_compat_mekanism" | "immersiveengineering:recipes/misc/crafting/toolupgrade_shield_shock" | "apotheosis:spawner/spawnrange" | "minecraft:recipes/tools/fishing_rod" | "minecraft:recipes/decorations/smoker" | "immersiveengineering:recipes/misc/crafting/transformer_hv" | "biomeswevegone:recipes/building_blocks/cut_blue_sandstone" | "create:wrench_goggles" | "connectedglass:recipes/misc/scratched_glass_magenta2" | "connectedglass:recipes/misc/scratched_glass_magenta1" | "create:recipes/building_blocks/copper_tile_stairs_from_copper_tiles_stonecutting" | "toolbelt:recipes/pouch" | "minecraft:recipes/building_blocks/chiseled_deepslate_from_cobbled_deepslate_stonecutting" | "immersiveengineering:recipes/misc/crafting/alu_slope" | "create:recipes/building_blocks/layered_tuff_from_stone_types_tuff_stonecutting" | "apotheosis:enchanting/80ench" | "minecraft:recipes/building_blocks/chiseled_stone_bricks" | "minecraft:recipes/building_blocks/nether_brick_slab" | "create:recipes/building_blocks/cut_granite_slab" | "minecraft:recipes/misc/pumpkin_seeds" | "biomeswevegone:recipes/building_blocks/cut_pink_sandstone" | "minecraft:recipes/building_blocks/smooth_windswept_sandstone_slab_from_windswept_sandstone_stonecutting" | "immersiveengineering:recipes/misc/crafting/sheetmetal_copper_to_slab" | "biomeswevegone:recipes/building_blocks/sakura_bookshelf" | "create:recipes/misc/crafting/kinetics/mechanical_bearing" | "immersiveengineering:recipes/misc/crafting/nugget_constantan_to_ingot_constantan" | "comforts:sleeping_bag_black" | "create:cross_streams" | "minecraft:recipes/decorations/mud_brick_wall" | "minecraft:recipes/building_blocks/red_sandstone" | "minecraft:recipes/building_blocks/cut_purple_sandstone_slab_from_cut_purple_sandstone_stonecutting" | "minecraft:husbandry/tadpole_in_a_bucket" | "utilitarian:recipes/misc/utility/mangrove_logs_to_trapdoors" | "minecraft:recipes/redstone/dark_oak_button" | "biomeswevegone:recipes/redstone/palm_fence_gate" | "biomeswevegone:biomeswevegone/adventure/oh_the_biomes_weve_gone" | "create:recipes/misc/blasting/ingot_osmium_compat_mekanism" | "ae2:recipes/misc/smelting/silicon_from_certus_quartz_dust" | "minecraft:husbandry/wax_off" | "create:recipes/building_blocks/crafting/copper/waxed_exposed_copper_tile_stairs_from_honeycomb" | "buddingcrystals:recipes/misc/budding_redstone" | "biomeswevegone:recipes/building_blocks/white_sandstone_stairs" | "sophisticatedstorage:recipes/misc/copper_chest" | "ae2:recipes/misc/decorative/quartz_block" | "minecraft:recipes/decorations/beehive" | "sophisticatedstorage:recipes/misc/crimson_limited_barrel_4" | "minecraft:recipes/misc/rib_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/tools/netherite_hoe_smithing" | "minecraft:recipes/decorations/lime_candle" | "sophisticatedstorage:recipes/misc/storage_auto_blasting_upgrade_from_backpack_auto_blasting_upgrade" | "minecraft:recipes/building_blocks/emerald_block" | "easy_mob_farm:recipes/upgrade/enchancement/luck_enhancement" | "minecraft:recipes/food/cooked_rabbit_from_smoking" | "immersiveengineering:recipes/misc/crafting/stick_iron" | "sophisticatedbackpacks:recipes/misc/chipped/tinkering_table_upgrade" | "create:recipes/misc/crafting/kinetics/train_door" | "connectedglass:recipes/misc/clear_glass_lime1" | "ae2:recipes/misc/shaped/slabs/quartz_block" | "minecraft:recipes/building_blocks/nether_wart_block" | "woodwevegot:recipes/decorations/ebony_chest" | "connectedglass:recipes/misc/clear_glass_lime2" | "sophisticatedstorage:recipes/misc/storage_stack_upgrade_tier_5_from_backpack_stack_upgrade_tier_4" | "create:recipes/building_blocks/cut_deepslate_slab_recycling" | "minecraft:recipes/redstone/trapped_chest" | "minecraft:recipes/building_blocks/dye_pink_wool" | "compressium:recipes/building_blocks/copper_9" | "immersiveengineering:recipes/misc/crafting/sheetmetal_gold" | "ae2:recipes/misc/network/cells/fluid_storage_cell_256k_storage" | "ae2:recipes/misc/network/cables/dense_covered_black" | "immersiveengineering:recipes/misc/smelting/copper_ingot_from_dust_from_blasting" | "compressium:recipes/building_blocks/copper_5" | "minecraft:recipes/decorations/cobbled_deepslate_wall_from_cobbled_deepslate_stonecutting" | "create:recipes/building_blocks/andesite_from_stone_types_andesite_stonecutting" | "compressium:recipes/building_blocks/copper_6" | "compressium:recipes/building_blocks/copper_7" | "immersiveengineering:recipes/misc/crafting/storage_nickel_from_slab" | "compressium:recipes/building_blocks/copper_8" | "biomeswevegone:recipes/building_blocks/palm_wood" | "compressium:recipes/building_blocks/copper_1" | "compressium:recipes/building_blocks/copper_2" | "compressium:recipes/building_blocks/copper_3" | "compressium:recipes/building_blocks/copper_4" | "jamd:recipes/transportation/end_portal_block" | "compressium:recipes/building_blocks/lapis_5_uncraft" | "ae2:recipes/misc/tools/nether_quartz_cutting_knife" | "biomeswevegone:recipes/decorations/witch_hazel_fence" | "sophisticatedbackpacks:recipes/misc/advanced_magnet_upgrade_from_basic" | "minecraft:recipes/pamhc2foodcore/smelting_cookedgroundbeefitem" | "immersiveengineering:recipes/misc/crafting/sheetmetal_constantan" | "ae2:recipes/misc/network/blocks/crystal_processing_charger" | "compressium:recipes/building_blocks/redsand_8_uncraft" | "minecraft:recipes/building_blocks/stripped_birch_wood" | "sophisticatedstorage:recipes/misc/crimson_limited_barrel_1" | "sophisticatedstorage:recipes/misc/warped_limited_barrel_1" | "create:recipes/misc/crafting/schematics/schematic_and_quill" | "create:windmill" | "create:recipes/building_blocks/cut_andesite_from_stone_types_andesite_stonecutting" | "biomeswevegone:recipes/building_blocks/fir_wood" | "sophisticatedstorage:recipes/misc/crimson_limited_barrel_3" | "sophisticatedstorage:recipes/misc/crimson_limited_barrel_2" | "create:rose_quartz" | "create:recipes/misc/smelting/ingot_uranium_compat_ic2" | "sophisticatedstorage:recipes/misc/warped_limited_barrel_4" | "minecraft:recipes/pamhc2foodcore/campfire_cookedgroundbeefitem" | "sophisticatedstorage:recipes/misc/warped_limited_barrel_3" | "ae2:recipes/misc/tools/fluix_axe" | "sophisticatedstorage:recipes/misc/warped_limited_barrel_2" | "minecraft:recipes/building_blocks/sponge" | "minecraft:recipes/building_blocks/smooth_red_sandstone_slab_from_smooth_red_sandstone_stonecutting" | "immersiveengineering:recipes/misc/crafting/hoe_steel" | "create:recipes/building_blocks/cut_veridium_wall" | "ae2:recipes/misc/network/cables/dense_covered_cyan" | "ae2:recipes/misc/shaped/stairs/chiseled_quartz_block" | "minecraft:recipes/building_blocks/prismarine_brick_stairs" | "minecraft:recipes/decorations/prismarine_wall" | "compressium:recipes/building_blocks/gold_6_uncraft" | "comforts:sleeping_bag_red" | "create:recipes/building_blocks/cut_deepslate_wall_from_stone_types_deepslate_stonecutting" | "aquaculture:recipes/decorations/spruce_fish_mount" | "sophisticatedstorage:recipes/misc/diamond_barrel" | "create:recipes/misc/crafting/schematics/empty_schematic" | "mekanism:chemical_transport" | "apotheosis:enchanting/max_stats" | "sophisticatedstorage:recipes/misc/limited_iron_barrel_1_from_limited_copper_barrel_1" | "minecraft:recipes/redstone/warped_fence_gate" | "create:recipes/building_blocks/cut_veridium_brick_slab_recycling" | "minecraft:recipes/transportation/acacia_chest_boat" | "biomeswevegone:recipes/transportation/mahogany_chest_boat" | "easy_mob_farm:recipes/mob_catcher/enduring_capture_net" | "easy_mob_farm:recipes/mob_farm/jungle_farm" | "minecraft:recipes/decorations/white_candle" | "biomeswevegone:recipes/decorations/baobab_fence" | "dankstorage:recipes/tools/1_to_2" | "minecraft:recipes/combat/turtle_helmet" | "minecraft:recipes/building_blocks/mud_brick_stairs_from_mud_bricks_stonecutting" | "create:recipes/misc/smelting/glass_pane_from_horizontal_framed_glass_pane" | "biomeswevegone:recipes/building_blocks/cattail_thatch_stairs" | "minecraft:recipes/building_blocks/oak_stairs" | "minecraft:recipes/building_blocks/polished_andesite_slab_from_andesite_stonecutting" | "utilitarian:recipes/misc/utility/mangrove_logs_to_stairs" | "ae2:recipes/misc/network/crystal_resonance_generator" | "biomeswevegone:recipes/redstone/palm_trapdoor" | "create:recipes/building_blocks/copper_shingles_from_ingots_copper_stonecutting" | "biomeswevegone:recipes/building_blocks/white_sandstone" | "sophisticatedstorage:recipes/misc/storage_io" | "woodwevegot:recipes/redstone/maple_trapped_chest" | "immersiveengineering:recipes/misc/crafting/sorter" | "connectedglass:recipes/misc/scratched_glass_orange_pane1" | "sophisticatedbackpacks:recipes/misc/smithing_upgrade" | "sophisticatedstorage:recipes/misc/birch_chest_from_quark_birch_chest" | "minecraft:end/dragon_breath" | "biomeswevegone:recipes/redstone/fir_trapdoor" | "create:recipes/misc/blasting/silver_ingot_compat_galosphere" | "create:recipes/building_blocks/crafting/kinetics/cyan_seat_from_other_seat" | "connectedglass:recipes/misc/scratched_glass_brown2" | "connectedglass:recipes/misc/scratched_glass_brown1" | "create:recipes/misc/crafting/kinetics/fluid_pipe" | "connectedglass:recipes/misc/scratched_glass_orange_pane3" | "connectedglass:recipes/misc/scratched_glass_orange_pane2" | "create:recipes/misc/crafting/kinetics/blue_valve_handle_from_other_valve_handle" | "minecraft:recipes/building_blocks/white_concrete_powder" | "create:recipes/building_blocks/polished_cut_crimsite_stairs" | "create:recipes/building_blocks/small_crimsite_brick_wall_from_stone_types_crimsite_stonecutting" | "immersiveengineering:recipes/misc/smelting/ingot_silver_from_blasting" | "ae2:recipes/misc/network/cables/glass_light_gray" | "minecraft:recipes/misc/music_disc_5" | "create:recipes/building_blocks/cut_dripstone_slab" | "advanced_ae:recipes/misc/quantum_chest" | "minecraft:recipes/misc/netherite_scrap" | "utilitarian:recipes/misc/utility/glow_ink_sac" | "minecraft:story/enchant_item" | "biomeswevegone:recipes/building_blocks/cut_white_sandstone_slab" | "create:recipes/building_blocks/layered_crimsite_from_stone_types_crimsite_stonecutting" | "connectedglass:recipes/misc/borderless_glass_light_gray_pane3" | "connectedglass:recipes/misc/borderless_glass_light_gray_pane2" | "minecraft:recipes/building_blocks/lime_stained_glass" | "create:recipes/misc/crafting/kinetics/stressometerfrom_conversion" | "connectedglass:recipes/misc/borderless_glass_light_gray_pane1" | "biomeswevegone:recipes/redstone/fir_pressure_plate" | "create:recipes/building_blocks/polished_cut_tuff_wall" | "immersiveengineering:recipes/misc/crafting/plate_copper_hammering" | "biomeswevegone:recipes/building_blocks/smooth_pink_sandstone" | "buddingcrystals:recipes/misc/budding_electrum" | "minecraft:recipes/building_blocks/quartz_pillar_from_quartz_block_stonecutting" | "create:recipes/building_blocks/cut_tuff_stairs" | "create:recipes/building_blocks/cut_tuff_wall" | "minecraft:recipes/redstone/cherry_trapdoor" | "ae2:recipes/misc/tools/network_tool" | "biomeswevegone:recipes/redstone/witch_hazel_button" | "create:recipes/misc/crafting/kinetics/brass_hand" | "minecraft:recipes/decorations/chain" | "utilitarian:recipes/misc/snad/red_snad" | "create:stressometer_maxed" | "minecraft:recipes/decorations/yellow_bed" | "create:recipes/building_blocks/layered_ochrum_from_stone_types_ochrum_stonecutting" | "create:recipes/building_blocks/cut_scoria_from_stone_types_scoria_stonecutting" | "minecraft:recipes/decorations/oak_fence" | "mekanism:laser" | "woodwevegot:recipes/decorations/ironwood_chest" | "immersiveengineering:recipes/misc/crafting/heavy_engineering" | "create:recipes/building_blocks/ochrum_from_stone_types_ochrum_stonecutting" | "create:recipes/building_blocks/cut_limestone_stairs" | "sophisticatedstorage:recipes/misc/warped_chest_from_quark_warped_chest" | "minecraft:recipes/redstone/cherry_button" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_stairs" | "minecraft:recipes/misc/coal_from_blasting_coal_ore" | "minecraft:recipes/redstone/mangrove_door" | "create:display_board_0" | "compressium:recipes/building_blocks/quartz_4_uncraft" | "minecraft:recipes/redstone/redstone_from_smelting_deepslate_redstone_ore" | "create:steam_whistle" | "apotheosis:enchanting/seashelf" | "apotheosis:enchanting/arcana100" | "minecraft:recipes/food/cooked_porkchop_from_campfire_cooking" | "ae2:recipes/misc/network/cells/item_storage_cell_4k" | "biomeswevegone:recipes/building_blocks/stripped_aspen_wood" | "utilitarian:recipes/misc/no_soliciting/soliciting_carpets/white_trapped_soliciting_carpet" | "compressium:recipes/building_blocks/gravel_6_uncraft" | "minecraft:recipes/building_blocks/chiseled_bookshelf" | "immersiveengineering:recipes/misc/crafting/toolupgrade_powerpack_induction" | "create:recipes/misc/crafting/appliances/clipboard" | "create:recipes/building_blocks/crafting/kinetics/black_seat_from_other_seat" | "connectedglass:recipes/misc/borderless_glass_black_pane2" | "connectedglass:recipes/misc/borderless_glass_black_pane1" | "connectedglass:recipes/misc/borderless_glass_black_pane3" | "sophisticatedstorage:recipes/misc/gold_chest" | "immersiveengineering:multiblocks/craft_sheetmetal" | "immersiveengineering:recipes/misc/smelting/nugget_steel_recycle_steel_chestplate" | "sophisticatedstorage:recipes/misc/backpack_advanced_magnet_upgrade_from_storage_advanced_magnet_upgrade" | "advanced_ae:recipes/misc/luck_card" | "ae2:recipes/misc/tools/paintballs_lumen_purple" | "minecraft:recipes/decorations/light_blue_stained_glass_pane" | "utilitarian:recipes/misc/no_soliciting/soliciting_carpets/blue_trapped_soliciting_carpet" | "connectedglass:recipes/misc/clear_glass_green_pane3" | "connectedglass:recipes/misc/clear_glass_green_pane2" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_yellow" | "create:recipes/building_blocks/cut_asurine_brick_slab_from_stone_types_asurine_stonecutting" | "connectedglass:recipes/misc/clear_glass_green_pane1" | "create:crafter_lazy_000" | "minecraft:adventure/spyglass_at_parrot" | "minecraft:recipes/building_blocks/nether_brick_stairs_from_nether_bricks_stonecutting" | "biomeswevegone:recipes/transportation/florus_boat" | "create:recipes/building_blocks/copper_shingle_stairs" | "ae2:recipes/misc/network/parts/export_bus" | "create:recipes/building_blocks/small_scorchia_brick_stairs_from_stone_types_scorchia_stonecutting" | "create:recipes/misc/crafting/kinetics/linear_chassis" | "create:recipes/building_blocks/cut_tuff_brick_stairs_from_stone_types_tuff_stonecutting" | "minecraft:recipes/building_blocks/oxidized_cut_copper_stairs" | "immersiveengineering:recipes/misc/crafting/cushion" | "mekanismgenerators:solar_generator" | "friendsandfoes:adventure/it_bites" | "biomeswevegone:recipes/building_blocks/witch_hazel_wood" | "immersiveengineering:recipes/misc/smelting/ingot_nickel_from_blasting3" | "ae2:recipes/misc/network/blocks/interfaces_interface_part" | "immersiveengineering:recipes/misc/smelting/ingot_nickel_from_blasting2" | "minecraft:recipes/building_blocks/spruce_wood" | "create:recipes/misc/blasting/ingot_uranium_compat_immersiveengineering" | "naturalist:recipes/naturalist/teddy_bear" | "create:recipes/misc/crafting/kinetics/track_signal" | "ae2:recipes/misc/network/cables/smart_light_gray" | "minecraft:recipes/misc/yellow_dye_from_dandelion" | "ae2:recipes/misc/tools/paintballs_lumen_light_gray" | "minecraft:recipes/decorations/end_stone_brick_wall" | "connectedglass:recipes/misc/scratched_glass_light_blue1" | "connectedglass:recipes/misc/scratched_glass_light_blue2" | "create:recipes/misc/crafting/kinetics/gantry_carriage" | "domum_ornamentum:recipes/tools/purple_brick_extra" | "utilitarian:recipes/misc/utility/spruce_logs_to_stairs" | "compressium:recipes/building_blocks/diamond_3_uncraft" | "sophisticatedstorage:recipes/misc/cherry_barrel" | "immersiveengineering:recipes/misc/crafting/nugget_silver_to_ingot_silver" | "biomeswevegone:recipes/decorations/cracked_red_rock_brick_wall" | "biomeswevegone:recipes/building_blocks/birch_planks_from_palo_verde_logs" | "biomeswevegone:recipes/building_blocks/redwood_stairs" | "immersiveengineering:recipes/misc/crafting/radiator" | "create:recipes/misc/crafting/kinetics/secondary_linear_chassisfrom_conversion" | "connectedglass:recipes/misc/scratched_glass_red_pane3" | "compressium:recipes/building_blocks/andesite_5_uncraft" | "minecraft:recipes/decorations/mangrove_hanging_sign" | "minecraft:recipes/building_blocks/deepslate_bricks_from_polished_deepslate_stonecutting" | "minecraft:recipes/decorations/black_banner" | "connectedglass:recipes/misc/vanilla_black_stained_glass" | "create:recipes/building_blocks/small_granite_brick_wall_from_stone_types_granite_stonecutting" | "minecraft:recipes/misc/black_dye_from_wither_rose" | "connectedglass:recipes/misc/scratched_glass_red_pane2" | "connectedglass:recipes/misc/scratched_glass_red_pane1" | "minecraft:recipes/misc/bone_meal" | "immersiveengineering:recipes/misc/smelting/hempcrete_brick_cracked" | "create:speed_controller" | "compressium:recipes/building_blocks/dirt_3_uncraft" | "immersiveengineering:recipes/misc/crafting/conveyor_basic" | "woodwevegot:recipes/decorations/florus_chest" | "easy_mob_farm:recipes/upgrade/enchancement/honey_extractor_enhancement" | "create:recipes/misc/blasting/ingot_uranium_compat_ic2" | "create:recipes/building_blocks/tuff_pillar_from_stone_types_tuff_stonecutting" | "create:recipes/building_blocks/diorite_pillar_from_stone_types_diorite_stonecutting" | "minecraft:recipes/building_blocks/prismarine_brick_slab_from_prismarine_stonecutting" | "biomeswevegone:recipes/building_blocks/white_stained_glass_from_white_sand" | "minecraft:recipes/building_blocks/sandstone_stairs_from_sandstone_stonecutting" | "ae2:recipes/misc/tools/paintballs_cyan" | "immersiveengineering:recipes/misc/crafting/storage_uranium_from_slab" | "minecraft:adventure/totem_of_undying" | "minecraft:recipes/decorations/cobbled_deepslate_wall" | "immersiveengineering:recipes/misc/crafting/blastbrick_reinforced_from_slab" | "minecraft:recipes/building_blocks/prismarine_bricks" | "immersiveengineering:recipes/misc/crafting/minecart_woodenbarrel" | "biomeswevegone:biomeswevegone/adventure/little_house_on_the_prairie" | "domum_ornamentum:recipes/tools/cyan_brick_extra" | "biomeswevegone:recipes/building_blocks/stripped_willow_wood" | "woodwevegot:recipes/decorations/green_enchanted_ladder" | "minecraft:recipes/decorations/polished_deepslate_wall_from_cobbled_deepslate_stonecutting" | "immersiveengineering:recipes/misc/crafting/minecart_metalbarrel" | "simplemagnets:recipes/misc/basicmagnet" | "fulleng:recipes/misc/terminals/block_pattern_access_terminal_from_part" | "biomeswevegone:recipes/food/cooked_white_puffball_cap" | "lootr:root" | "justhammers:recipes/tools/stone_reinforced_impact_hammer" | "easy_mob_farm:recipes/upgrade/enchancement/sheep_enhancement" | "minecraft:recipes/decorations/diorite_wall" | "megacells:recipes/misc/cells/standard/item_storage_cell_4m_with_housing" | "ae2:recipes/misc/tools/paintballs_lumen_orange" | "compressium:recipes/building_blocks/dirt_8_uncraft" | "immersiveengineering:recipes/misc/crafting/concrete_leaded_to_slab" | "create:recipes/building_blocks/cut_calcite_brick_slab_from_stone_types_calcite_stonecutting" | "immersiveengineering:recipes/misc/crafting/alloybrick_from_slab" | "biomeswevegone:recipes/building_blocks/stripped_redwood_wood" | "utilitarian:recipes/misc/utility/crimson_logs_to_stairs" | "minecraft:recipes/decorations/stonecutter" | "biomeswevegone:recipes/building_blocks/maple_stairs" | "immersiveengineering:recipes/misc/crafting/voltmeter" | "biomeswevegone:recipes/building_blocks/purple_sand" | "biomeswevegone:recipes/building_blocks/willow_slab" | "sophisticatedbackpacks:recipes/misc/compacting_upgrade" | "biomeswevegone:recipes/transportation/florus_chest_boat" | "sophisticatedstorage:recipes/misc/storage_advanced_jukebox_upgrade_from_backpack_advanced_jukebox_upgrade" | "biomeswevegone:recipes/building_blocks/smooth_blue_sandstone_slab" | "buddingcrystals:recipes/misc/budding_copper" | "minecraft:recipes/decorations/light_blue_banner" | "ae2:recipes/misc/tools/nether_quartz_spade" | "biomeswevegone:recipes/decorations/sakura_hanging_sign" | "naturalist:recipes/food/cooked_duck" | "naturalist:recipes/naturalist/smooth_limestone_slab" | "minecraft:recipes/decorations/smithing_table" | "compressium:recipes/building_blocks/copper_4_uncraft" | "immersiveengineering:recipes/misc/crafting/ingot_electrum_to_nugget_electrum" | "minecraft:recipes/building_blocks/cut_sandstone_slab" | "immersiveengineering:main/kill_illager" | "minecraft:recipes/misc/sugar_from_honey_bottle" | "minecraft:recipes/building_blocks/dye_red_carpet" | "ae2:recipes/misc/decorative/quartz_fixture_from_anchors" | "minecraft:husbandry/allay_deliver_cake_to_note_block" | "connectedglass:recipes/misc/scratched_glass_pink_pane3" | "connectedglass:recipes/misc/scratched_glass_pink_pane2" | "sophisticatedstorage:recipes/misc/backpack_compacting_upgrade_from_storage_compacting_upgrade" | "create:recipes/building_blocks/cut_limestone_brick_wall" | "aquaculture:recipes/aquaculture/double_hook" | "minecraft:recipes/building_blocks/weathered_cut_copper_slab_from_weathered_copper_stonecutting" | "create:recipes/building_blocks/oxidized_copper_tile_stairs" | "immersiveengineering:recipes/misc/crafting/plate_uranium_hammering" | "minecraft:recipes/decorations/orange_stained_glass_pane_from_glass_pane" | "immersiveengineering:recipes/misc/crafting/blueprint_components" | "minecraft:recipes/transportation/tnt_minecart" | "connectedglass:recipes/misc/scratched_glass_pink_pane1" | "immersiveengineering:recipes/misc/crafting/hempcrete" | "compressium:recipes/building_blocks/obsidian_3_uncraft" | "immersiveengineering:recipes/misc/crafting/sheetmetal_copper" | "immersiveengineering:recipes/misc/smelting/nugget_steel_recycle_pick_from_blasting" | "ae2:recipes/misc/tools/certus_quartz_wrench" | "naturalist:recipes/naturalist/limestone_slab" | "biomeswevegone:recipes/brewing/aloe_vera_juice" | "compressium:recipes/building_blocks/soulsand_6_uncraft" | "compressium:recipes/building_blocks/sand_1" | "aquaculture:recipes/food/turtle_soup" | "ae2:recipes/misc/tools/nether_quartz_wrench" | "create:crusher_maxed_0000" | "biomeswevegone:recipes/decorations/purple_sandstone_wall" | "create:recipes/misc/smelting/copper_ingot_from_crushed" | "sophisticatedstorage:recipes/misc/gold_to_diamond_tier_upgrade" | "create:recipes/building_blocks/small_limestone_brick_wall_from_stone_types_limestone_stonecutting" | "immersiveengineering:recipes/misc/crafting/steel_fence" | "utilitarian:recipes/misc/utility/cherry_logs_to_doors" | "minecraft:recipes/building_blocks/oxidized_cut_copper_stairs_from_oxidized_cut_copper_stonecutting" | "ae2:recipes/misc/network/cables/covered_magenta" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_purple_to_slab" | "minecraft:recipes/building_blocks/dye_green_bed" | "sophisticatedstorage:recipes/misc/backpack_stack_upgrade_tier_1_from_storage_stack_upgrade_tier_2" | "ae2wtlib:recipes/wireless_pattern_encoding_terminal" | "biomeswevegone:recipes/building_blocks/chiseled_windswept_sandstone" | "mekanism:ultimate_qio_drive" | "apotheosis:enchanting/quanta50" | "create:recipes/building_blocks/polished_cut_dripstone_wall_from_stone_types_dripstone_stonecutting" | "minecraft:recipes/decorations/brown_candle" | "domum_ornamentum:recipes/tools/black_brick_extra" | "minecraft:recipes/building_blocks/quartz_pillar" | "immersiveengineering:recipes/misc/crafting/chemthrower" | "minecraft:husbandry/wax_on" | "utilitarian:recipes/misc/no_soliciting/soliciting_carpets/magenta_trapped_soliciting_carpet" | "minecraft:recipes/building_blocks/purple_terracotta" | "immersiveengineering:recipes/misc/crafting/connector_bundled" | "create:recipes/misc/crafting/logistics/powered_latch" | "naturalist:recipes/naturalist/limestone_brick_wall" | "biomeswevegone:recipes/building_blocks/dacite_slab" | "minecraft:adventure/play_jukebox_in_meadows" | "immersiveengineering:recipes/misc/crafting/sheetmetal_nickel_from_slab" | "dankstorage:recipes/tools/dank_2" | "dankstorage:recipes/tools/dank_3" | "ae2:recipes/misc/network/cables/smart_magenta" | "dankstorage:recipes/tools/dank_1" | "dankstorage:recipes/tools/dank_6" | "dankstorage:recipes/tools/dank_7" | "create:recipes/building_blocks/polished_cut_dripstone_stairs_from_stone_types_dripstone_stonecutting" | "dankstorage:recipes/tools/dank_4" | "dankstorage:recipes/tools/dank_5" | "connectedglass:recipes/misc/clear_glass_pink2" | "mekanism:elite_qio_drive" | "connectedglass:recipes/misc/clear_glass_pink1" | "immersiveengineering:recipes/misc/crafting/windmill_sail" | "minecraft:recipes/misc/green_dye" | "minecraft:recipes/decorations/magenta_bed" | "create:recipes/building_blocks/polished_cut_granite_slab_recycling" | "minecraft:recipes/redstone/honey_block" | "minecraft:recipes/building_blocks/dark_prismarine" | "minecraft:adventure/hero_of_the_village" | "create:recipes/building_blocks/polished_cut_limestone_wall" | "minecraft:recipes/redstone/redstone" | "minecraft:recipes/building_blocks/smooth_stone" | "create:recipes/building_blocks/small_scorchia_brick_slab_recycling" | "megacells:recipes/misc/cells/standard/item_storage_cell_256m_with_housing" | "create:recipes/misc/crafting/logistics/andesite_tunnel" | "connectedglass:recipes/misc/vanilla_blue_stained_glass_pane" | "biomeswevegone:recipes/decorations/white_wool_from_white_allium_petal_block" | "minecraft:recipes/misc/coast_armor_trim_smithing_template_smithing_trim" | "compressium:recipes/building_blocks/dirt_2_uncraft" | "minecraft:recipes/building_blocks/dye_pink_carpet" | "connectedglass:recipes/misc/vanilla_gray_stained_glass" | "immersiveengineering:recipes/misc/crafting/concrete_tile" | "explorerscompass:explorers_compass_cobweb" | "buddingcrystals:recipes/misc/budding_brass" | "minecraft:recipes/building_blocks/packed_ice" | "minecraft:recipes/transportation/spruce_boat" | "ae2:recipes/misc/block_cutter/stairs/sky_stone_small_brick_stairs" | "friendsandfoes:adventure/summon_copper_golem" | "minecraft:recipes/building_blocks/quartz_stairs_from_quartz_block_stonecutting" | "biomeswevegone:recipes/misc/cattail_thatch" | "ae2:recipes/misc/network/cables/dense_covered_blue" | "ae2:recipes/misc/block_cutter/slabs/quartz_slab" | "biomeswevegone:recipes/building_blocks/rainbow_eucalyptus_bookshelf" | "minecraft:recipes/building_blocks/deepslate_tiles" | "create:recipes/building_blocks/crimsite_pillar_from_stone_types_crimsite_stonecutting" | "minecraft:recipes/building_blocks/warped_hyphae" | "minecraft:recipes/redstone/jungle_button" | "sophisticatedstorage:recipes/misc/acacia_chest" | "utilitarian:recipes/misc/utility/crimson_logs_to_pressure_plates" | "immersiveengineering:recipes/misc/crafting/revolver" | "immersiveengineering:recipes/misc/crafting/sheetmetal_steel_from_slab" | "biomeswevegone:recipes/building_blocks/smooth_black_sandstone_slab" | "minecraft:recipes/redstone/note_block" | "compressium:recipes/building_blocks/snow_6_uncraft" | "mekanism:qio_dashboard" | "compressium:recipes/building_blocks/andesite_1" | "easy_mob_farm:recipes/mob_catcher/ironbound_containment_cage" | "compressium:recipes/building_blocks/andesite_2" | "minecraft:recipes/decorations/green_stained_glass_pane_from_glass_pane" | "compressium:recipes/building_blocks/andesite_3" | "compressium:recipes/building_blocks/andesite_4" | "create:recipes/building_blocks/crafting/kinetics/lime_seat_from_other_seat" | "immersiveengineering:recipes/misc/stonecutting/hempcrete_chiseled" | "immersiveengineering:multiblocks/mb_silo" | "compressium:recipes/building_blocks/andesite_5" | "compressium:recipes/building_blocks/andesite_6" | "compressium:recipes/building_blocks/andesite_7" | "create:hose_pulley" | "compressium:recipes/building_blocks/andesite_8" | "advanced_ae:recipes/misc/walk_speed_card" | "compressium:recipes/building_blocks/andesite_9" | "minecraft:recipes/decorations/crimson_hanging_sign" | "woodwevegot:recipes/decorations/jacaranda_chest" | "immersiveengineering:recipes/misc/crafting/blastbrick" | "minecraft:recipes/decorations/lime_bed" | "compressium:recipes/building_blocks/netherrack_7" | "immersiveengineering:recipes/misc/crafting/blastfurnace_preheater" | "compressium:recipes/building_blocks/netherrack_8" | "create:recipes/building_blocks/polished_cut_granite_slab_from_stone_types_granite_stonecutting" | "immersiveengineering:recipes/misc/crafting/fluid_pipe" | "create:recipes/misc/crafting/kinetics/empty_blaze_burner" | "mekanism:logistical_sorter" | "biomeswevegone:recipes/building_blocks/chiseled_black_sandstone" | "compressium:recipes/building_blocks/netherrack_9" | "biomeswevegone:recipes/decorations/cypress_crafting_table" | "immersiveengineering:recipes/misc/crafting/raw_block_lead_to_raw_lead" | "connectedglass:recipes/misc/vanilla_light_blue_stained_glass" | "minecraft:recipes/building_blocks/smooth_stone_slab" | "biomeswevegone:recipes/redstone/holly_button" | "minecraft:recipes/decorations/chiseled_red_rock_brick_wall_from_chiseled_red_rock_bricks_stonecutting" | "immersiveengineering:recipes/misc/crafting/storage_electrum_to_slab" | "ae2:recipes/misc/network/wireless_booster" | "create:recipes/building_blocks/crafting/kinetics/cyan_seat" | "create:recipes/building_blocks/small_asurine_brick_wall" | "mekanism:configurator" | "yungscavebiomes:recipes/building_blocks/smooth_ancient_sandstone" | "connectedglass:recipes/misc/borderless_glass_purple1" | "connectedglass:recipes/misc/borderless_glass_purple2" | "sophisticatedstorage:recipes/misc/backpack_advanced_feeding_upgrade_from_storage_advanced_feeding_upgrade" | "compressium:recipes/building_blocks/netherrack_1" | "minecraft:recipes/misc/beacon" | "create:recipes/misc/crafting/kinetics/millstone" | "compressium:recipes/building_blocks/netherrack_2" | "woodwevegot:recipes/decorations/skyris_chest" | "compressium:recipes/building_blocks/netherrack_3" | "biomeswevegone:recipes/decorations/ebony_crafting_table" | "compressium:recipes/building_blocks/netherrack_4" | "sophisticatedbackpacks:recipes/misc/advanced_magnet_upgrade" | "compressium:recipes/building_blocks/netherrack_5" | "compressium:recipes/building_blocks/netherrack_6" | "minecraft:recipes/building_blocks/red_nether_bricks" | "ae2:recipes/misc/network/cables/dense_covered_white" | "immersiveengineering:recipes/misc/crafting/toolupgrade_drill_lube" | "justhammers:recipes/tools/netherite_impact_hammer" | "minecraft:recipes/decorations/cyan_carpet" | "dimstorage:recipes/misc/dimensional_tablet" | "minecraft:husbandry/root" | "create:recipes/building_blocks/cut_granite_bricks_from_stone_types_granite_stonecutting" | "minecraft:recipes/transportation/birch_boat" | "minecraft:recipes/building_blocks/cut_copper_from_copper_block_stonecutting" | "compressium:recipes/building_blocks/redsand_9_uncraft" | "immersiveengineering:recipes/misc/crafting/ingot_nickel_to_storage_nickel" | "minecraft:recipes/building_blocks/cobbled_deepslate_stairs_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/building_blocks/blue_sandstone_slab_from_blue_sandstone_stonecutting" | "compressium:recipes/building_blocks/clay_9_uncraft" | "ae2:recipes/misc/network/cables/dense_covered_orange" | "ae2:recipes/misc/network/cables/dense_covered_green" | "ae2:recipes/misc/tools/paintballs_yellow" | "utilitarian:recipes/misc/utility/crimson_logs_to_slabs" | "ae2:recipes/misc/network/cells/item_storage_cell_1k" | "buddingcrystals:recipes/misc/budding_diamond" | "create:recipes/building_blocks/crafting/kinetics/purple_seat_from_other_seat" | "immersiveengineering:recipes/misc/smelting/nugget_steel_recycle_steel_chestplate_from_blasting" | "woodwevegot:recipes/decorations/pine_barrel" | "advanced_ae:recipes/misc/smalladvpatpro" | "minecraft:recipes/redstone/crimson_trapdoor" | "minecraft:recipes/building_blocks/cherry_wood" | "minecraft:recipes/decorations/green_glazed_terracotta" | "minecraft:recipes/decorations/bamboo_sign" | "immersiveengineering:recipes/misc/crafting/wirecoil_electrum_ins" | "create:recipes/misc/blasting/lead_ingot_compat_thermal" | "advanced_ae:recipes/misc/evasion_card" | "create:recipes/building_blocks/cut_ochrum_brick_stairs" | "ae2:recipes/misc/tools/matter_cannon" | "compressium:recipes/building_blocks/stone_4" | "compressium:recipes/building_blocks/stone_3" | "minecraft:recipes/building_blocks/blue_ice" | "biomeswevegone:recipes/building_blocks/rocky_stone_slab" | "compressium:recipes/building_blocks/stone_2" | "compressium:recipes/building_blocks/stone_1" | "ae2:recipes/misc/network/cables/dense_smart_pink" | "minecraft:adventure/trade" | "minecraft:recipes/building_blocks/deepslate" | "compressium:recipes/building_blocks/stone_8" | "compressium:recipes/building_blocks/stone_7" | "compressium:recipes/building_blocks/stone_6" | "compressium:recipes/building_blocks/stone_5" | "minecraft:recipes/decorations/white_carpet" | "ae2:main/pattern_encoding_terminal" | "minecraft:recipes/transportation/cherry_chest_boat" | "biomeswevegone:recipes/building_blocks/black_stained_glass_from_black_sand" | "compressium:recipes/building_blocks/stone_9" | "minecraft:recipes/building_blocks/red_sandstone_slab" | "minecraft:recipes/building_blocks/dark_prismarine_slab" | "minecraft:recipes/decorations/pink_stained_glass_pane_from_glass_pane" | "create:recipes/building_blocks/cut_scoria_slab" | "create:recipes/misc/smelting/glass_pane_from_tiled_glass_pane" | "create:recipes/building_blocks/cut_tuff_brick_wall_from_stone_types_tuff_stonecutting" | "minecraft:recipes/building_blocks/jack_o_lantern" | "minecraft:recipes/transportation/birch_chest_boat" | "minecraft:recipes/decorations/glass_pane" | "betterdeserttemples:root" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_cyan_from_slab" | "immersiveengineering:recipes/misc/stonecutting/wall_clinker_brick" | "minecraft:recipes/decorations/purple_banner" | "buddingcrystals:recipes/misc/budding_constantan" | "apotheosis:spawner/maxdelay" | "minecraft:recipes/building_blocks/magenta_stained_glass" | "sophisticatedstorage:recipes/misc/backpack_smoking_upgrade_from_storage_smoking_upgrade" | "create:recipes/misc/crafting/schematics/schematic_table" | "connectedglass:recipes/misc/scratched_glass_light_gray_pane1" | "connectedglass:recipes/misc/scratched_glass_light_gray_pane2" | "connectedglass:recipes/misc/scratched_glass_light_gray_pane3" | "aquaculture:recipes/aquaculture/fishing_line" | "minecraft:recipes/transportation/oak_boat" | "biomeswevegone:recipes/building_blocks/palm_slab" | "sophisticatedstorage:recipes/misc/backpack_advanced_filter_upgrade_from_storage_advanced_filter_upgrade" | "ae2:recipes/misc/network/parts/monitors_conversion" | "create:recipes/decorations/brass_scaffolding_from_ingots_brass_stonecutting" | "immersiveengineering:recipes/misc/stonecutting/concrete_tile" | "ae2:recipes/misc/network/cables/dense_covered_magenta" | "domum_ornamentum:recipes/tools/cream_bricks" | "easy_mob_farm:recipes/upgrade/enchancement/speed_enhancement" | "advanced_ae:recipes/misc/quantum_boots_item_reset" | "create:recipes/building_blocks/polished_cut_scorchia_stairs" | "justhammers:recipes/tools/diamond_hammer" | "ae2:main/storage_cell" | "create:recipes/building_blocks/polished_cut_asurine_wall_from_stone_types_asurine_stonecutting" | "utilitarian:recipes/misc/utility/cherry_logs_to_stairs" | "repurposed_structures:ruined_portal_end" | "biomeswevegone:recipes/transportation/baobab_chest_boat" | "minecraft:recipes/building_blocks/bamboo_mosaic_stairs" | "create:recipes/building_blocks/small_granite_brick_wall" | "minecraft:recipes/building_blocks/smooth_stone_slab_from_smooth_stone_stonecutting" | "sophisticatedstorage:recipes/misc/warped_barrel" | "mekanism:upgraded_mekasuit" | "biomeswevegone:recipes/decorations/aspen_fence" | "connectedglass:recipes/misc/borderless_glass_green2" | "mekanism:quantum_entangloporter" | "biomeswevegone:recipes/building_blocks/palm_stairs" | "immersiveengineering:recipes/misc/crafting/coke_from_slab" | "minecraft:recipes/decorations/deepslate_tile_wall_from_polished_deepslate_stonecutting" | "minecraft:recipes/building_blocks/deepslate_brick_stairs_from_deepslate_bricks_stonecutting" | "biomeswevegone:recipes/decorations/pink_wool_from_pink_allium_petal_block" | "biomeswevegone:recipes/building_blocks/dacite_brick_stairs" | "biomeswevegone:recipes/redstone/jacaranda_pressure_plate" | "ae2:recipes/misc/network/cables/covered_gray" | "minecraft:recipes/misc/paper" | "aquaculture:recipes/misc/tin_can_to_iron_nugget_from_blasting" | "minecraft:recipes/pamhc2foodcore/campfire_cookedgroundfishitem" | "biomeswevegone:recipes/building_blocks/sakura_planks" | "create:recipes/building_blocks/polished_cut_tuff_stairs" | "create:backtank" | "minecraft:recipes/redstone/warped_button" | "biomeswevegone:recipes/decorations/cypress_hanging_sign" | "advanced_ae:recipes/misc/smallappupgrade" | "minecraft:husbandry/kill_axolotl_target" | "minecraft:recipes/decorations/stone_brick_wall_from_stone_bricks_stonecutting" | "minecraft:recipes/building_blocks/red_nether_brick_stairs" | "biomeswevegone:recipes/redstone/green_enchanted_fence_gate" | "create:recipes/misc/crafting/kinetics/brass_door" | "immersiveengineering:recipes/misc/crafting/chute_steel" | "create:recipes/building_blocks/small_scoria_brick_wall_from_stone_types_scoria_stonecutting" | "ae2:recipes/misc/network/crafting/patterns_blank" | "ae2:recipes/misc/network/cells/fluid_storage_cell_4k" | "minecraft:recipes/building_blocks/warped_stairs" | "create:recipes/building_blocks/small_scorchia_brick_wall" | "minecraft:recipes/building_blocks/white_stained_glass" | "ae2:recipes/misc/network/cables/dense_covered_lime" | "sophisticatedstorage:recipes/misc/backpack_crafting_upgrade_from_storage_crafting_upgrade" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_lime_from_slab" | "mekanism:cleaning_gauges" | "minecraft:recipes/decorations/blue_glazed_terracotta" | "connectedglass:recipes/misc/borderless_glass_purple_pane2" | "connectedglass:recipes/misc/borderless_glass_purple_pane3" | "immersiveengineering:recipes/misc/crafting/skyhook" | "minecraft:recipes/building_blocks/mossy_cobblestone_from_moss_block" | "botanypots:husbandry/get_hopper_pot" | "minecraft:recipes/building_blocks/andesite_slab_from_andesite_stonecutting" | "minecraft:recipes/redstone/acacia_fence_gate" | "minecraft:recipes/building_blocks/coal_block" | "immersiveengineering:recipes/misc/crafting/toolupgrade_drill_capacity" | "compressium:recipes/building_blocks/cobblestone_7_uncraft" | "connectedglass:recipes/misc/borderless_glass_purple_pane1" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_stairs_from_honeycomb" | "immersiveengineering:recipes/misc/crafting/raw_uranium_to_raw_block_uranium" | "utilitarian:recipes/misc/no_soliciting/soliciting_carpets/purple_trapped_soliciting_carpet" | "sophisticatedstorage:recipes/misc/copper_to_gold_tier_upgrade" | "mekanism:qio_redstone_adapter" | "minecraft:recipes/building_blocks/spruce_slab" | "minecraft:recipes/decorations/polished_blackstone_wall_from_blackstone_stonecutting" | "biomeswevegone:recipes/building_blocks/fir_planks" | "buildinggadgets2:recipes/misc/template_manager" | "create:recipes/building_blocks/cut_asurine_brick_slab_recycling" | "biomeswevegone:recipes/building_blocks/smooth_windswept_sandstone_slab" | "ae2:recipes/misc/shaped/walls/chiseled_quartz_block" | "minecraft:recipes/tools/lead" | "minecraft:recipes/decorations/warped_sign" | "ae2:recipes/misc/network/cells/view_cell_storage" | "immersiveengineering:recipes/misc/crafting/toolbox" | "minecraft:recipes/decorations/white_stained_glass_pane_from_glass_pane" | "create:recipes/misc/crafting/kinetics/windmill_bearing" | "advanced_ae:recipes/misc/quantum_alloy_block_stair" | "compressium:recipes/building_blocks/obsidian_3" | "connectedglass:recipes/misc/borderless_glass_green_pane3" | "compressium:recipes/building_blocks/obsidian_4" | "minecraft:recipes/building_blocks/waxed_cut_copper_slab_from_waxed_copper_block_stonecutting" | "immersiveengineering:recipes/misc/crafting/treated_wood_horizontal_to_slab" | "compressium:recipes/building_blocks/obsidian_5" | "compressium:recipes/building_blocks/obsidian_6" | "sophisticatedstorage:recipes/misc/chipped/tinkering_table_upgrade" | "compressium:recipes/building_blocks/obsidian_7" | "compressium:recipes/building_blocks/obsidian_8" | "compressium:recipes/building_blocks/obsidian_9" | "create:recipes/building_blocks/polished_cut_ochrum_from_stone_types_ochrum_stonecutting" | "sophisticatedstorage:recipes/misc/birch_chest" | "biomeswevegone:recipes/redstone/sakura_door" | "compressium:recipes/building_blocks/obsidian_1" | "compressium:recipes/building_blocks/redsand_4_uncraft" | "connectedglass:recipes/misc/borderless_glass_green_pane1" | "compressium:recipes/building_blocks/obsidian_2" | "connectedglass:recipes/misc/borderless_glass_green_pane2" | "create:recipes/building_blocks/cut_asurine_bricks_from_stone_types_asurine_stonecutting" | "sophisticatedbackpacks:recipes/misc/advanced_filter_upgrade" | "biomeswevegone:recipes/building_blocks/purple_sandstone" | "minecraft:recipes/redstone/bamboo_door" | "minecraft:recipes/decorations/lodestone" | "minecraft:recipes/misc/shaper_armor_trim_smithing_template_smithing_trim" | "sophisticatedstorage:recipes/misc/stack_upgrade_tier_2_from_tier_1_plus" | "create:recipes/building_blocks/cut_calcite_brick_slab_recycling" | "create:recipes/building_blocks/cut_tuff_slab_recycling" | "create:recipes/misc/crafting/materials/sand_paper" | "connectedglass:recipes/misc/borderless_glass_green1" | "sophisticatedstorage:recipes/misc/oak_chest_from_quark_oak_chest" | "immersiveengineering:recipes/misc/crafting/wirecoil_copper" | "compressium:recipes/building_blocks/sand_1_uncraft" | "create:recipes/building_blocks/layered_limestone_from_stone_types_limestone_stonecutting" | "ae2:recipes/misc/network/cells/fluid_storage_cell_1k" | "minecraft:recipes/building_blocks/white_sandstone_stairs_from_white_sandstone_stonecutting" | "create:recipes/building_blocks/polished_cut_calcite_wall_from_stone_types_calcite_stonecutting" | "minecraft:recipes/redstone/oak_button" | "utilitarian:recipes/misc/no_soliciting/soliciting_carpets/red_soliciting_carpet" | "connectedglass:recipes/misc/tinted_borderless_glass_light_gray2" | "create:recipes/misc/crafting/kinetics/basin" | "create:belt_funnel_kiss" | "immersiveengineering:recipes/misc/crafting/concrete_tile_from_slab" | "minecraft:recipes/decorations/rose_petal_block" | "minecraft:adventure/honey_block_slide" | "create:recipes/building_blocks/dark_oak_window_pane" | "minecraft:recipes/redstone/dark_oak_pressure_plate" | "minecraft:recipes/building_blocks/smooth_quartz_stairs_from_smooth_quartz_stonecutting" | "biomeswevegone:recipes/building_blocks/jacaranda_bookshelf" | "minecraft:recipes/misc/vex_armor_trim_smithing_template" | "minecraft:recipes/pamhc2foodcore/smelting_cookedgroundfishitem" | "compressium:recipes/building_blocks/cobblestone_2_uncraft" | "compressium:recipes/building_blocks/lapis_9" | "create:recipes/building_blocks/cut_calcite_slab" | "immersiveengineering:multiblocks/multiblocks_root" | "create:recipes/building_blocks/small_asurine_brick_slab_from_stone_types_asurine_stonecutting" | "minecraft:recipes/misc/iron_ingot_from_smelting_deepslate_iron_ore" | "compressium:recipes/building_blocks/lapis_1" | "minecraft:recipes/decorations/nether_brick_fence" | "minecraft:recipes/building_blocks/chiseled_polished_blackstone_from_blackstone_stonecutting" | "compressium:recipes/building_blocks/lapis_2" | "ae2:recipes/misc/tools/nether_quartz_axe" | "compressium:recipes/building_blocks/lapis_3" | "immersiveengineering:main/main_root" | "compressium:recipes/building_blocks/lapis_4" | "compressium:recipes/building_blocks/lapis_5" | "biomeswevegone:recipes/decorations/white_sandstone_wall" | "minecraft:recipes/misc/magenta_dye_from_allium" | "compressium:recipes/building_blocks/lapis_6" | "compressium:recipes/building_blocks/lapis_7" | "minecraft:recipes/misc/wayfinder_armor_trim_smithing_template_smithing_trim" | "compressium:recipes/building_blocks/lapis_8" | "biomeswevegone:recipes/redstone/aspen_door" | "minecraft:recipes/decorations/decorated_pot_simple" | "advanced_ae:recipes/misc/stock_export_bus" | "minecraft:recipes/building_blocks/cracked_deepslate_tiles" | "compressium:recipes/building_blocks/netherrack_9_uncraft" | "create:recipes/building_blocks/crafting/copper/waxed_weathered_copper_shingle_stairs_from_honeycomb" | "biomeswevegone:recipes/building_blocks/mahogany_stairs" | "sophisticatedbackpacks:recipes/misc/inception_upgrade" | "easy_mob_farm:recipes/mob_farm/bee_hive_farm" | "simplemagnets:recipes/misc/basic_demagnetization_coil" | "minecraft:recipes/building_blocks/exposed_cut_copper" | "biomeswevegone:recipes/transportation/cypress_chest_boat" | "create:linked_controller" | "minecraft:recipes/building_blocks/weathered_cut_copper_slab" | "minecraft:recipes/decorations/stone_brick_walls_from_stone_stonecutting" | "ae2:recipes/misc/misc/deconstruction_certus_quartz_pillar" | "create:arm_many_targets" | "immersiveengineering:main/craft_heater" | "compressium:recipes/building_blocks/netherrack_4_uncraft" | "aquaculture:recipes/aquaculture/iron_hook" | "create:recipes/building_blocks/polished_cut_diorite_wall_from_stone_types_diorite_stonecutting" | "create:recipes/misc/smelting/silver_ingot_compat_iceandfire" | "minecraft:recipes/redstone/daylight_detector" | "minecraft:recipes/misc/diamond_from_blasting_deepslate_diamond_ore" | "create:recipes/misc/crafting/materials/copper_ingot" | "create:recipes/building_blocks/small_calcite_brick_slab" | "biomeswevegone:recipes/decorations/sakura_sign" | "megacells:recipes/misc/network/mega_pattern_provider_block" | "biomeswevegone:recipes/building_blocks/willow_wood" | "minecraft:recipes/building_blocks/dye_purple_bed" | "minecraft:recipes/redstone/jungle_fence_gate" | "create:recipes/misc/crafting/materials/zinc_block_from_compacting" | "biomeswevegone:recipes/building_blocks/smooth_blue_sandstone_stairs" | "minecraft:recipes/building_blocks/dye_light_gray_carpet" | "create:recipes/misc/crafting/kinetics/large_cogwheel" | "ae2:main/portable_cell" | "minecraft:recipes/redstone/warped_door" | "friendsandfoes:adventure/kill_iceologer" | "ae2:recipes/misc/network/parts/formation_plane_alt" | "sophisticatedbackpacks:recipes/misc/blasting_upgrade" | "immersiveengineering:recipes/misc/stonecutting/stairs_hempcrete" | "minecraft:recipes/decorations/dark_oak_fence" | "biomeswevegone:recipes/redstone/ironwood_button" | "minecraft:recipes/combat/diamond_boots" | "create:recipes/misc/crafting/logistics/andesite_funnel" | "biomeswevegone:recipes/decorations/holly_crafting_table" | "create:recipes/building_blocks/crafting/kinetics/light_blue_seat_from_other_seat" | "compressium:recipes/building_blocks/iron_7_uncraft" | "biomeswevegone:recipes/building_blocks/dacite_cobblestone_stairs" | "ae2:recipes/misc/shaped/slabs/smooth_quartz_block" | "biomeswevegone:recipes/decorations/jacaranda_sign" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_gray_from_slab" | "create:recipes/misc/crafting/kinetics/yellow_valve_handle_from_other_valve_handle" | "megacells:recipes/misc/crafting/256m_crafting_storage" | "utilitarian:recipes/misc/utility/crimson_logs_to_trapdoors" | "ae2:recipes/misc/decorative/quartz_glass" | "create:recipes/misc/crafting/kinetics/fluid_valve" | "biomeswevegone:recipes/transportation/blue_enchanted_boat" | "biomeswevegone:recipes/building_blocks/stripped_jacaranda_wood" | "create:recipes/building_blocks/polished_cut_asurine_stairs" | "sophisticatedstorage:recipes/misc/blue_shulker_box_to_sophisticated" | "create:recipes/building_blocks/small_dripstone_brick_stairs" | "ae2:recipes/misc/network/cables/dense_smart_cyan" | "domum_ornamentum:recipes/tools/white_brick_extra" | "create:red_signal" | "immersiveengineering:recipes/misc/crafting/stick_treated" | "minecraft:recipes/combat/iron_sword" | "woodwevegot:recipes/decorations/green_enchanted_barrel" | "create:recipes/building_blocks/polished_cut_limestone_slab_from_stone_types_limestone_stonecutting" | "minecraft:recipes/redstone/observer" | "minecraft:recipes/misc/light_gray_dye_from_white_tulip" | "biomeswevegone:recipes/building_blocks/red_rock_brick_slab" | "ae2:recipes/misc/materials/cardvoid" | "minecraft:recipes/tools/iron_pickaxe" | "domum_ornamentum:recipes/decorations/pink_floating_carpet" | "minecraft:recipes/building_blocks/polished_granite_stairs" | "connectedglass:recipes/misc/scratched_glass_lime2" | "mekanism:energy_cube" | "minecraft:recipes/building_blocks/dark_oak_slab" | "ae2:recipes/misc/misc/deconstruction_fluix_block" | "minecraft:recipes/transportation/mangrove_boat" | "create:recipes/misc/crafting/kinetics/light_blue_valve_handle_from_other_valve_handle" | "connectedglass:recipes/misc/scratched_glass_lime1" | "utilitarian:recipes/misc/snad/snad" | "create:recipes/building_blocks/cut_limestone_from_stone_types_limestone_stonecutting" | "minecraft:recipes/decorations/torch" | "connectedglass:recipes/misc/vanilla_green_stained_glass" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_stairs_from_waxed_weathered_cut_copper_stonecutting" | "biomeswevegone:recipes/decorations/florus_sign" | "megacells:recipes/misc/cells/mega_item_cell_housing" | "ae2:recipes/misc/tools/portable_fluid_cell_64k" | "ae2:recipes/misc/network/crafting/64k_cpu_crafting_storage" | "biomeswevegone:recipes/redstone/mahogany_pressure_plate" | "minecraft:recipes/building_blocks/stone_brick_slab_from_stone_stonecutting" | "megacells:recipes/misc/cells/standard/bulk_item_cell" | "biomeswevegone:recipes/transportation/witch_hazel_boat" | "biomeswevegone:recipes/decorations/pine_hanging_sign" | "minecraft:recipes/building_blocks/smooth_sandstone_stairs_from_smooth_sandstone_stonecutting" | "woodwevegot:recipes/decorations/skyris_barrel" | "sophisticatedstorage:recipes/misc/storage_tool" | "biomeswevegone:recipes/building_blocks/stripped_rainbow_eucalyptus_wood" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_stairs_from_honeycomb" | "woodwevegot:recipes/decorations/zelkova_ladder" | "ae2:recipes/misc/tools/paintballs_lumen_brown" | "ae2:recipes/misc/network/cells/spatial_storage_cell_128_cubed" | "biomeswevegone:recipes/transportation/blue_enchanted_chest_boat" | "minecraft:recipes/building_blocks/dark_oak_planks" | "minecraft:recipes/transportation/detector_rail" | "yungscavebiomes:recipes/building_blocks/brittle_red_sandstone" | "minecraft:recipes/decorations/dacite_tile_wall_from_dacite_tile_stonecutting" | "biomeswevegone:recipes/building_blocks/stripped_witch_hazel_wood" | "ae2:recipes/misc/network/blocks/controller" | "immersiveengineering:recipes/misc/crafting/treated_scaffold" | "minecraft:recipes/combat/shield" | "ae2:recipes/misc/tools/paintballs_light_gray" | "utilitarian:recipes/misc/no_soliciting/soliciting_carpets/gray_soliciting_carpet" | "create:recipes/building_blocks/small_dripstone_brick_slab_recycling" | "minecraft:recipes/building_blocks/red_sandstone_stairs" | "immersiveengineering:recipes/misc/smelting/ingot_constantan_from_dust_from_blasting" | "create:recipes/misc/crafting/logistics/stockpile_switch" | "create:recipes/building_blocks/birch_window_pane" | "aquaculture:recipes/aquaculture/nether_star_hook" | "create:recipes/building_blocks/small_diorite_brick_stairs_from_stone_types_diorite_stonecutting" | "immersiveengineering:recipes/misc/crafting/sheetmetal_silver_from_slab" | "immersiveengineering:main/craft_extract_conveyor" | "biomeswevegone:recipes/transportation/jacaranda_boat" | "minecraft:recipes/building_blocks/deepslate_brick_slab_from_polished_deepslate_stonecutting" | "sophisticatedstorage:recipes/misc/chipped/alchemy_bench_upgrade" | "immersiveengineering:recipes/misc/crafting/ingot_steel_to_nugget_steel" | "woodwevegot:recipes/redstone/jacaranda_trapped_chest" | "sophisticatedstorage:recipes/misc/copper_shulker_box" | "compressium:recipes/building_blocks/dirt_7_uncraft" | "create:recipes/building_blocks/polished_cut_deepslate_stairs_from_stone_types_deepslate_stonecutting" | "create:recipes/building_blocks/polished_cut_scoria_wall_from_stone_types_scoria_stonecutting" | "justhammers:recipes/tools/reinforced_impact_core" | "biomeswevegone:recipes/building_blocks/blue_sand" | "create:recipes/building_blocks/polished_cut_andesite_slab_from_stone_types_andesite_stonecutting" | "create:recipes/decorations/copper_ladder_from_ingots_copper_stonecutting" | "minecraft:recipes/misc/dune_armor_trim_smithing_template" | "immersiveengineering:recipes/misc/smelting/ingot_uranium" | "minecraft:recipes/decorations/magenta_carpet" | "create:recipes/building_blocks/polished_cut_calcite_wall" | "minecraft:recipes/misc/creeper_banner_pattern" | "buddingcrystals:recipes/misc/budding_osmium" | "ae2:recipes/misc/network/cells/item_storage_cell_256k_storage" | "biomeswevegone:recipes/building_blocks/chiseled_red_rock_brick_slab" | "naturalist:recipes/food/cooked_catfish" | "immersiveengineering:recipes/misc/smelting/nugget_steel_recycle_steel_helmet_from_blasting" | "ae2:recipes/misc/network/parts/toggle_bus_inverted_alt" | "domum_ornamentum:recipes/tools/cream_stone_bricks" | "create:recipes/misc/crafting/materials/red_sand_paper" | "biomeswevegone:recipes/decorations/skyris_crafting_table" | "sophisticatedstorage:recipes/misc/iron_chest_from_copper_chest" | "biomeswevegone:recipes/redstone/ebony_pressure_plate" | "immersiveengineering:main/craft_treatedwood" | "create:recipes/misc/crafting/kinetics/controls" | "ae2:recipes/misc/network/cables/glass_purple" | "sophisticatedstorage:recipes/misc/storage_link_from_controller" | "minecraft:recipes/building_blocks/andesite_stairs_from_andesite_stonecutting" | "minecraft:recipes/decorations/iron_bars" | "immersiveengineering:recipes/misc/stonecutting/concrete_brick2" | "ae2:recipes/misc/block_cutter/stairs/cut_quartz_stairs" | "create:recipes/building_blocks/cut_andesite_brick_wall_from_stone_types_andesite_stonecutting" | "immersiveengineering:recipes/misc/crafting/alu_post" | "minecraft:recipes/misc/copper_ingot" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_green_to_slab" | "ae2:recipes/misc/network/cables/smart_cyan" | "create:recipes/building_blocks/cut_veridium_slab_from_stone_types_veridium_stonecutting" | "create:recipes/misc/blasting/ingot_aluminum_compat_immersiveengineering" | "create:recipes/building_blocks/cut_crimsite_slab_from_stone_types_crimsite_stonecutting" | "biomeswevegone:recipes/decorations/green_enchanted_fence" | "ae2:recipes/misc/network/cables/covered_lime" | "ae2:recipes/misc/network/parts/tunnels_me" | "minecraft:recipes/building_blocks/dye_purple_wool" | "biomeswevegone:recipes/decorations/rainbow_eucalyptus_crafting_table" | "naturalist:recipes/naturalist/limestone_brick_slab" | "minecraft:recipes/transportation/chest_minecart" | "minecraft:recipes/building_blocks/spruce_planks" | "biomeswevegone:recipes/building_blocks/black_sandstone_stairs" | "woodwevegot:recipes/redstone/ironwood_trapped_chest" | "aquaculture:recipes/misc/jellyfish_to_slimeball" | "biomeswevegone:recipes/transportation/witch_hazel_chest_boat" | "dimstorage:dimensional_chest" | "minecraft:recipes/building_blocks/netherite_block" | "create:recipes/building_blocks/cut_granite_slab_recycling" | "immersiveengineering:recipes/misc/crafting/nugget_steel_to_ingot_steel" | "minecraft:recipes/building_blocks/polished_diorite_slab" | "immersiveengineering:recipes/misc/smelting/ingot_lead_from_blasting" | "create:train_crash" | "minecraft:recipes/decorations/red_carpet" | "woodwevegot:recipes/redstone/redwood_trapped_chest" | "ae2:recipes/misc/tools/paintballs_black" | "minecraft:recipes/misc/wild_armor_trim_smithing_template" | "connectedglass:recipes/misc/borderless_glass_pink2" | "immersiveengineering:recipes/misc/smelting/ingot_hop_graphite" | "connectedglass:recipes/misc/borderless_glass_pink1" | "create:long_travel" | "ae2:recipes/misc/network/cables/covered_orange" | "minecraft:recipes/transportation/dark_oak_chest_boat" | "ae2:recipes/misc/tools/certus_quartz_cutting_knife" | "comforts:hammock_red" | "compressium:recipes/building_blocks/dirt_4_uncraft" | "biomeswevegone:recipes/redstone/sakura_fence_gate" | "create:recipes/misc/crafting/kinetics/sequenced_gearshift" | "woodwevegot:recipes/redstone/florus_trapped_chest" | "minecraft:recipes/building_blocks/stone_brick_stairs_from_stone_stonecutting" | "sophisticatedstorage:recipes/misc/advanced_pickup_upgrade" | "biomeswevegone:recipes/decorations/dacite_tile_wall" | "immersiveengineering:recipes/misc/crafting/alu_scaffolding_standard_from_slab" | "minecraft:recipes/building_blocks/deepslate_tile_slab_from_deepslate_tiles_stonecutting" | "minecraft:recipes/building_blocks/mud_brick_slab" | "utilitarian:recipes/misc/utility/mangrove_logs_to_pressure_plates" | "minecraft:adventure/lightning_rod_with_villager_no_fire" | "immersiveengineering:recipes/misc/crafting/alloybrick_to_slab" | "minecraft:recipes/misc/host_armor_trim_smithing_template" | "fulleng:recipes/misc/terminals/block_storage_monitor_from_part" | "create:recipes/building_blocks/cut_ochrum_from_stone_types_ochrum_stonecutting" | "biomeswevegone:recipes/redstone/sakura_trapdoor" | "sophisticatedstorage:recipes/misc/birch_barrel" | "sophisticatedstorage:recipes/misc/copper_shulker_from_copper_chest" | "biomeswevegone:recipes/building_blocks/mossy_red_rock_brick_slab" | "ae2:main/recursive" | "sophisticatedbackpacks:recipes/misc/advanced_tool_swapper_upgrade" | "biomeswevegone:recipes/decorations/florus_hanging_sign" | "minecraft:recipes/brewing/glistering_melon_slice" | "biomeswevegone:recipes/building_blocks/dacite_tile_stairs" | "megacells:recipes/misc/cells/mega_fluid_cell_housing" | "immersiveengineering:recipes/misc/crafting/plate_electrum_hammering" | "minecraft:recipes/misc/light_gray_dye_from_azure_bluet" | "immersiveengineering:recipes/misc/crafting/tesla_coil" | "minecraft:recipes/building_blocks/cracked_nether_bricks" | "minecraft:recipes/building_blocks/polished_deepslate_slab_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/building_blocks/waxed_cut_copper_stairs_from_waxed_cut_copper_stonecutting" | "megacells:recipes/misc/cells/portable/portable_fluid_cell_256m" | "biomeswevegone:recipes/redstone/cypress_fence_gate" | "apotheosis:spawner/playerrange" | "biomeswevegone:recipes/decorations/fir_crafting_table" | "minecraft:recipes/misc/wild_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/building_blocks/smooth_quartz" | "ae2:recipes/misc/network/cables/dense_smart_black" | "sophisticatedstorage:recipes/misc/yellow_shulker_box_to_sophisticated" | "sophisticatedstorage:recipes/misc/jungle_barrel" | "woodwevegot:recipes/decorations/maple_chest" | "connectedglass:recipes/misc/tinted_borderless_glass_brown2" | "create:recipes/building_blocks/polished_cut_limestone_slab" | "naturalist:recipes/naturalist/cut_limestone" | "create:recipes/building_blocks/small_scoria_brick_wall" | "create:recipes/building_blocks/crafting/kinetics/pink_seat" | "biomeswevegone:recipes/building_blocks/willow_stairs" | "minecraft:recipes/decorations/blue_stained_glass_pane" | "create:recipes/building_blocks/mangrove_window_pane" | "immersiveengineering:recipes/misc/crafting/connector_redstone" | "create:recipes/building_blocks/polished_cut_calcite_slab_from_stone_types_calcite_stonecutting" | "immersiveengineering:recipes/misc/crafting/steel_scaffolding_wooden_top_from_grate_top" | "apotheosis:enchanting/enchanting_stats" | "minecraft:recipes/building_blocks/smooth_blue_sandstone_slab_from_blue_sandstone_stonecutting" | "domum_ornamentum:recipes/decorations/light_blue_floating_carpet" | "connectedglass:recipes/misc/borderless_glass_red_pane3" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_slab_from_waxed_exposed_copper_stonecutting" | "connectedglass:recipes/misc/borderless_glass_red_pane2" | "connectedglass:recipes/misc/borderless_glass_red_pane1" | "ae2:recipes/misc/network/cables/covered_blue" | "minecraft:adventure/craft_decorated_pot_using_only_sherds" | "ae2:recipes/misc/network/cells/view_cell" | "woodwevegot:recipes/redstone/mahogany_trapped_chest" | "sophisticatedstorage:recipes/misc/basic_to_gold_tier_upgrade" | "minecraft:recipes/decorations/polished_deepslate_wall_from_polished_deepslate_stonecutting" | "minecraft:recipes/food/cooked_salmon_from_smoking" | "minecraft:recipes/tools/netherite_shovel_smithing" | "minecraft:recipes/brewing/glass_bottle" | "immersiveengineering:tools/craft_wolfpack" | "aquaculture:recipes/aquaculture/redstone_hook" | "justhammers:recipes/tools/iron_hammer" | "create:mechanical_arm" | "minecraft:recipes/decorations/acacia_hanging_sign" | "minecraft:recipes/building_blocks/dye_gray_carpet" | "sophisticatedstorage:recipes/misc/advanced_hopper_upgrade" | "immersiveengineering:recipes/misc/crafting/plate_steel_hammering" | "create:recipes/misc/crafting/materials/brass_nugget_from_decompacting" | "create:recipes/misc/crafting/kinetics/item_drain" | "minecraft:recipes/building_blocks/cut_windswept_sandstone_slab_from_cut_windswept_sandstone_stonecutting" | "create:recipes/building_blocks/small_diorite_brick_stairs" | "biomeswevegone:recipes/redstone/florus_door" | "compressium:recipes/building_blocks/granite_8_uncraft" | "create:recipes/building_blocks/rose_quartz_block_from_rose_quartz_stonecutting" | "ae2:recipes/misc/network/cables/glass_orange" | "minecraft:recipes/decorations/red_nether_brick_wall_from_red_nether_bricks_stonecutting" | "minecraft:recipes/misc/lime_dye_from_smelting" | "compressium:recipes/building_blocks/stone_1_uncraft" | "create:recipes/building_blocks/cut_asurine_wall" | "minecraft:recipes/building_blocks/blackstone_slab_from_blackstone_stonecutting" | "connectedglass:recipes/misc/vanilla_light_gray_stained_glass" | "create:recipes/building_blocks/crafting/copper/waxed_oxidized_copper_shingle_slab_from_honeycomb" | "minecraft:recipes/redstone/cherry_fence_gate" | "connectedglass:recipes/misc/scratched_glass_pane3" | "ae2:recipes/misc/network/cables/covered_fluix" | "connectedglass:recipes/misc/scratched_glass_pane1" | "biomeswevegone:recipes/building_blocks/blue_enchanted_planks" | "minecraft:recipes/building_blocks/dacite_tile_slab_from_dacite_tile_stonecutting" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_stairs" | "create:recipes/misc/crafting/kinetics/mechanical_mixer" | "minecraft:recipes/building_blocks/chiseled_red_sandstone_from_red_sandstone_stonecutting" | "compressium:recipes/building_blocks/redsand_1_uncraft" | "biomeswevegone:recipes/redstone/white_mangrove_button" | "biomeswevegone:recipes/decorations/cypress_fence" | "create:recipes/building_blocks/copycat_step_from_ingots_zinc_stonecutting" | "minecraft:recipes/building_blocks/jungle_planks" | "minecraft:recipes/decorations/allium_petal_block" | "biomeswevegone:recipes/decorations/green_enchanted_hanging_sign" | "minecraft:recipes/building_blocks/chiseled_quartz_block" | "create:recipes/building_blocks/small_tuff_brick_slab" | "ae2:recipes/misc/network/cables/dense_smart_green" | "connectedglass:recipes/misc/vanilla_cyan_stained_glass" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_white_to_slab" | "dimstorage:dimensional_tank" | "minecraft:recipes/redstone/bamboo_trapdoor" | "sophisticatedstorage:recipes/misc/basic_to_netherite_tier_upgrade" | "create:recipes/misc/crafting/kinetics/framed_glass_trapdoor" | "comforts:sleeping_bag_gray" | "utilitarian:recipes/misc/redstone_clock" | "sophisticatedstorage:recipes/misc/basic_to_iron_tier_upgrade" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_lime" | "advanced_ae:recipes/misc/flight_drift_card" | "utilitarian:recipes/misc/utility/cherry_logs_to_boats" | "create:recipes/building_blocks/polished_cut_deepslate_wall" | "create:recipes/building_blocks/crafting/kinetics/black_seat" | "create:recipes/building_blocks/cut_diorite_brick_slab" | "create:recipes/decorations/andesite_ladder_from_andesite_alloy_stonecutting" | "immersiveengineering:recipes/misc/smelting/nugget_steel_recycle_steel_boots" | "create:recipes/combat/crafting/appliances/netherite_diving_boots_from_netherite" | "create:recipes/building_blocks/small_limestone_brick_stairs_from_stone_types_limestone_stonecutting" | "biomeswevegone:recipes/building_blocks/stripped_holly_wood" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_slab_from_waxed_weathered_copper_stonecutting" | "create:recipes/misc/crafting/logistics/redstone_contact" | "explorerscompass:explorers_compass_cracked_stone_bricks" | "biomeswevegone:recipes/food/cooked_white_puffball_cap_from_smoker" | "ae2:recipes/misc/tools/network_color_applicator" | "create:recipes/misc/crafting/kinetics/red_valve_handle_from_other_valve_handle" | "friendsandfoes:adventure/kill_illusioner" | "minecraft:recipes/building_blocks/dye_light_blue_wool" | "sophisticatedstorage:recipes/misc/advanced_feeding_upgrade" | "sophisticatedstorage:recipes/misc/mangrove_chest" | "woodwevegot:recipes/decorations/white_mangrove_chest" | "minecraft:recipes/redstone/sticky_piston" | "biomeswevegone:recipes/building_blocks/white_mangrove_bookshelf" | "biomeswevegone:recipes/redstone/mahogany_button" | "mekanism:advanced_control_circuit" | "minecraft:recipes/building_blocks/oxidized_cut_copper_slab" | "connectedglass:recipes/misc/clear_glass_magenta1" | "sophisticatedbackpacks:recipes/misc/smoking_upgrade_from_smelting_upgrade" | "ae2:recipes/misc/tools/fluix_pickaxe" | "connectedglass:recipes/misc/clear_glass_magenta2" | "immersiveengineering:recipes/misc/crafting/sword_steel" | "minecraft:recipes/building_blocks/cut_white_sandstone_from_white_sandstone_stonecutting" | "sophisticatedstorage:recipes/misc/cyan_shulker_box_to_sophisticated" | "biomeswevegone:recipes/transportation/palm_boat" | "ae2:recipes/misc/shaped/slabs/sky_stone_brick" | "sophisticatedstorage:recipes/misc/storage_blasting_upgrade_from_backpack_blasting_upgrade" | "minecraft:recipes/brewing/fermented_spider_eye" | "minecraft:recipes/misc/iron_ingot_from_smelting_raw_iron" | "woodwevegot:recipes/decorations/redwood_ladder" | "mekanism:steel_casing" | "ae2:recipes/misc/network/cables/smart_fluix_clean" | "minecraft:recipes/building_blocks/deepslate_brick_slab_from_cobbled_deepslate_stonecutting" | "immersiveengineering:recipes/misc/crafting/sheetmetal_nickel_to_slab" | "utilitarian:recipes/misc/snad/drit" | "connectedglass:recipes/misc/clear_glass_white1" | "minecraft:recipes/misc/purple_dye" | "connectedglass:recipes/misc/tinted_borderless_glass_white2" | "utilitarian:recipes/misc/utility/warped_logs_to_pressure_plates" | "immersiveengineering:recipes/misc/smelting/gold_ingot_from_dust_from_blasting" | "immersiveengineering:recipes/misc/crafting/concrete" | "create:recipes/building_blocks/cut_deepslate_brick_stairs_from_stone_types_deepslate_stonecutting" | "connectedglass:recipes/misc/clear_glass_white2" | "aquaculture:recipes/misc/gold_nugget_from_blasting" | "mekanism:auto_collection" | "domum_ornamentum:recipes/tools/paper_extra" | "minecraft:recipes/building_blocks/waxed_cut_copper_from_waxed_copper_block_stonecutting" | "utilitarian:recipes/misc/utility/jungle_logs_to_stairs" | "compressium:recipes/building_blocks/diorite_8_uncraft" | "minecraft:adventure/kill_mob_near_sculk_catalyst" | "create:recipes/building_blocks/polished_cut_scorchia_wall_from_stone_types_scorchia_stonecutting" | "minecraft:recipes/building_blocks/chiseled_black_sandstone_from_black_sandstone_stonecutting" | "minecraft:recipes/building_blocks/dried_kelp_block" | "minecraft:recipes/building_blocks/end_stone_brick_slab_from_end_stone_brick_stonecutting" | "minecraft:recipes/building_blocks/smooth_white_sandstone_slab_from_white_sandstone_stonecutting" | "minecraft:recipes/building_blocks/quartz_bricks_from_quartz_block_stonecutting" | "create:recipes/building_blocks/cut_calcite_from_stone_types_calcite_stonecutting" | "create:recipes/building_blocks/cut_scorchia_slab_recycling" | "biomeswevegone:recipes/decorations/pine_sign" | "connectedglass:recipes/misc/vanilla_red_stained_glass_pane" | "woodwevegot:recipes/redstone/cypress_trapped_chest" | "minecraft:recipes/building_blocks/cracked_red_rock_brick_slab_from_cracked_red_rock_bricks_stonecutting" | "biomeswevegone:recipes/transportation/skyris_chest_boat" | "utilitarian:recipes/misc/utility/acacia_logs_to_stairs" | "create:recipes/building_blocks/small_deepslate_brick_slab_recycling" | "yungscavebiomes:recipes/building_blocks/ancient_sandstone_stairs_from_stonecutting" | "minecraft:recipes/building_blocks/waxed_oxidized_copper_from_honeycomb" | "compressium:recipes/building_blocks/coal_7_uncraft" | "mekanism:restrictive_item_transport" | "advanced_ae:recipes/misc/jump_height_card" | "create:recipes/building_blocks/small_andesite_brick_slab" | "megacells:recipes/misc/cells/standard/fluid_storage_cell_1m_with_housing" | "create:recipes/building_blocks/exposed_copper_tile_slab_from_exposed_copper_tiles_stonecutting" | "immersiveengineering:recipes/misc/crafting/reinforced_crate" | "aquaculture:recipes/aquaculture/bobber" | "minecraft:recipes/decorations/mangrove_fence" | "minecraft:recipes/building_blocks/dye_white_carpet" | "minecraft:recipes/building_blocks/white_terracotta" | "create:recipes/misc/crafting/kinetics/fluid_tank" | "minecraft:recipes/food/cooked_mutton" | "minecraft:recipes/pamhc2foodcore/smoking_cookedgroundchickenitem" | "minecraft:recipes/misc/white_dye_from_lily_of_the_valley" | "ae2:recipes/misc/network/cells/fluid_storage_cell_64k" | "create:recipes/misc/crafting/materials/andesite_alloy_from_zinc" | "domum_ornamentum:recipes/tools/green_cobblestone_extra" | "minecraft:recipes/building_blocks/deepslate_tile_stairs" | "minecraft:recipes/building_blocks/polished_blackstone_bricks_from_polished_blackstone_stonecutting" | "biomeswevegone:recipes/redstone/palm_pressure_plate" | "minecraft:recipes/building_blocks/cut_purple_sandstone_slab_from_purple_sandstone_stonecutting" | "justhammers:recipes/tools/diamond_reinforced_impact_hammer" | "trashcans:recipes/misc/item_trash_can" | "create:recipes/building_blocks/cut_granite_wall_from_stone_types_granite_stonecutting" | "create:recipes/building_blocks/calcite_from_stone_types_calcite_stonecutting" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_black_from_slab" | "minecraft:recipes/building_blocks/mossy_stone_slab_from_mossy_stone_stonecutting" | "repurposed_structures:pyramids" | "comforts:hammock_black" | "biomeswevegone:recipes/building_blocks/redwood_bookshelf" | "woodwevegot:recipes/decorations/palm_barrel" | "ae2:recipes/misc/misc/chests_smooth_sky_stone" | "biomeswevegone:recipes/building_blocks/rainbow_eucalyptus_slab" | "minecraft:recipes/building_blocks/dye_light_blue_bed" | "minecraft:recipes/decorations/lime_carpet" | "biomeswevegone:recipes/building_blocks/red_rock_slab" | "minecraft:adventure/sniper_duel" | "woodwevegot:recipes/decorations/maple_ladder" | "create:track_signal" | "minecraft:recipes/building_blocks/polished_andesite_stairs" | "advanced_ae:recipes/misc/pick_craft_card" | "create:recipes/decorations/copper_scaffolding_from_ingots_copper_stonecutting" | "megacells:recipes/misc/cells/standard/fluid_storage_cell_64m" | "minecraft:recipes/transportation/furnace_minecart" | "biomeswevegone:recipes/building_blocks/red_rock_bricks" | "minecraft:recipes/building_blocks/stone_brick_slab_from_stone_bricks_stonecutting" | "minecraft:nether/root" | "biomeswevegone:recipes/transportation/redwood_chest_boat" | "biomeswevegone:recipes/building_blocks/florus_bookshelf" | "mekanism:disassembler" | "immersiveengineering:main/secret_friedbird" | "minecraft:recipes/pamhc2foodcore/smoking_roastedsunflowerseedsitem" | "ae2:recipes/misc/shaped/slabs/quartz_bricks" | "biomeswevegone:recipes/redstone/baobab_fence_gate" | "minecraft:recipes/misc/spire_armor_trim_smithing_template" | "biomeswevegone:recipes/building_blocks/chiseled_red_rock_brick_stairs" | "minecraft:recipes/building_blocks/stone_slab_from_stone_stonecutting" | "biomeswevegone:recipes/decorations/rocky_stone_wall" | "immersiveengineering:recipes/misc/crafting/alu_wallmount" | "create:recipes/misc/crafting/kinetics/track_observer_from_other_plates" | "yungscavebiomes:recipes/building_blocks/layered_ancient_sandstone_from_stonecutting" | "immersiveengineering:recipes/misc/crafting/powerpack" | "mekanism:sps" | "create:recipes/misc/crafting/materials/small_rose_quartz_tilesfrom_conversion" | "create:musical_arm" | "apotheosis:spawner/ultimate_spawner" | "advanced_ae:recipes/misc/quantum_alloy_block_slab" | "advanced_ae:recipes/misc/reactionchamber" | "compressium:recipes/building_blocks/gravel_2_uncraft" | "minecraft:recipes/tools/flint_and_steel" | "minecraft:recipes/building_blocks/dye_purple_carpet" | "minecraft:recipes/building_blocks/nether_bricks" | "sophisticatedstorage:recipes/misc/iron_to_netherite_tier_upgrade" | "create:recipes/building_blocks/andesite_pillar_from_stone_types_andesite_stonecutting" | "minecraft:recipes/decorations/end_stone_brick_wall_from_end_stone_brick_stonecutting" | "friendsandfoes:adventure/complete_hide_and_seek_game" | "create:recipes/building_blocks/scorchia_from_stone_types_scorchia_stonecutting" | "minecraft:recipes/misc/sugar_from_sugar_cane" | "ae2:recipes/misc/network/cells/item_storage_components_cell_256k_part" | "minecraft:recipes/building_blocks/dye_magenta_bed" | "minecraft:recipes/pamhc2foodcore/smoking_cookedgroundfishitem" | "compressium:recipes/building_blocks/copper_6_uncraft" | "megacells:recipes/misc/cells/portable/portable_item_cell_64m" | "sophisticatedstorage:recipes/misc/magnet_upgrade" | "advanced_ae:recipes/misc/recharging_card" | "minecraft:recipes/decorations/respawn_anchor" | "biomeswevegone:recipes/transportation/white_mangrove_chest_boat" | "immersiveengineering:recipes/misc/crafting/survey_tools" | "minecraft:recipes/pamhc2foodcore/campfire_cookedgroundrabbititem" | "connectedglass:recipes/misc/scratched_glass_purple1" | "connectedglass:recipes/misc/scratched_glass_purple2" | "immersiveengineering:recipes/misc/stonecutting/stairs_concrete_leaded" | "create:recipes/building_blocks/cut_calcite_brick_stairs_from_stone_types_calcite_stonecutting" | "connectedglass:recipes/misc/scratched_glass_pink2" | "minecraft:recipes/building_blocks/cut_windswept_sandstone_slab_from_windswept_sandstone_stonecutting" | "connectedglass:recipes/misc/scratched_glass_pink1" | "aquaculture:recipes/misc/gold_nugget_from_gold_fish" | "ae2:recipes/misc/network/cables/glass_gray" | "hangglider:recipes/tools/glider_framework" | "minecraft:recipes/decorations/white_banner" | "connectedglass:recipes/misc/vanilla_magenta_stained_glass_pane" | "toolbelt:recipes/belt" | "biomeswevegone:recipes/decorations/pine_fence" | "obsidianboat:obsidianboat" | "aquaculture:recipes/food/cooked_fish_fillet_from_smoking" | "immersiveengineering:main/craft_router" | "minecraft:recipes/decorations/mossy_cobblestone_wall" | "connectedglass:recipes/misc/borderless_glass_lime2" | "connectedglass:recipes/misc/borderless_glass_lime1" | "create:recipes/building_blocks/cut_veridium_slab_recycling" | "mekanism:sna" | "biomeswevegone:recipes/transportation/zelkova_boat" | "minecraft:nether/get_wither_skull" | "sophisticatedstorage:recipes/misc/bamboo_chest" | "immersiveengineering:recipes/misc/crafting/insulating_glass_from_slab" | "sophisticatedstorage:recipes/misc/chipped/glassblower_upgrade" | "minecraft:recipes/building_blocks/dye_magenta_wool" | "compressium:recipes/building_blocks/netherrack_5_uncraft" | "create:recipes/building_blocks/polished_cut_scorchia_slab" | "minecraft:recipes/decorations/diorite_wall_from_diorite_stonecutting" | "connectedglass:recipes/misc/vanilla_gray_stained_glass_pane" | "justhammers:recipes/tools/stone_hammer" | "trashcans:trash_can" | "compressium:recipes/building_blocks/diamond_8_uncraft" | "friendsandfoes:misc/yellow_dye_from_buttercup" | "biomeswevegone:recipes/decorations/windswept_sandstone_wall" | "connectedglass:recipes/misc/tinted_borderless_glass_green2" | "create:recipes/misc/crafting/kinetics/magenta_valve_handle_from_other_valve_handle" | "friendsandfoes:recipes/redstone/copper_button" | "advanced_ae:recipes/misc/advpartenc" | "biomeswevegone:recipes/misc/orange_dye_from_bwg_tag" | "biomeswevegone:recipes/redstone/maple_fence_gate" | "create:recipes/building_blocks/small_granite_brick_slab_from_stone_types_granite_stonecutting" | "minecraft:recipes/tools/wooden_pickaxe" | "immersiveengineering:recipes/misc/crafting/speedloader" | "mekanism:atomic_alloy" | "minecraft:recipes/building_blocks/cobbled_deepslate_stairs" | "minecraft:recipes/building_blocks/mossy_stone_brick_stairs" | "create:recipes/misc/crafting/kinetics/cyan_valve_handle_from_other_valve_handle" | "sophisticatedstorage:recipes/misc/storage_advanced_pickup_upgrade_from_backpack_advanced_pickup_upgrade" | "create:recipes/building_blocks/polished_cut_tuff_slab" | "biomeswevegone:recipes/building_blocks/purple_sandstone_slab" | "lootr:10loot" | "biomeswevegone:recipes/building_blocks/cika_planks" | "compressium:recipes/building_blocks/obsidian_1_uncraft" | "create:recipes/building_blocks/cut_tuff_brick_slab" | "minecraft:recipes/building_blocks/dark_oak_wood" | "aquaculture:recipes/tools/diamond_fishing_rod" | "yungscavebiomes:recipes/building_blocks/smooth_ancient_sandstone_stairs" | "minecraft:recipes/building_blocks/chiseled_polished_blackstone_from_polished_blackstone_stonecutting" | "yungscavebiomes:recipes/building_blocks/ancient_sandstone_wall_from_stonecutting" | "minecraft:recipes/building_blocks/polished_blackstone" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_orange_from_slab" | "minecraft:recipes/misc/diamond_from_smelting_diamond_ore" | "ae2:recipes/misc/network/cables/glass_fluix_clean" | "compressium:recipes/building_blocks/emerald_2_uncraft" | "connectedglass:recipes/misc/vanilla_brown_stained_glass" | "utilitarian:recipes/misc/utility/birch_logs_to_stairs" | "create:recipes/building_blocks/cut_andesite_wall" | "immersiveengineering:recipes/misc/crafting/treated_wood_packaged_to_slab" | "yungscavebiomes:root" | "create:recipes/building_blocks/polished_cut_diorite_stairs_from_stone_types_diorite_stonecutting" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_blue_from_slab" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_yellow_to_slab" | "minecraft:recipes/food/baked_potato_from_smoking" | "immersiveengineering:recipes/misc/crafting/blastbrick_to_slab" | "create:recipes/building_blocks/small_limestone_brick_slab_from_stone_types_limestone_stonecutting" | "create:recipes/building_blocks/cut_dripstone_slab_recycling" | "create:recipes/building_blocks/cut_andesite_stairs_from_stone_types_andesite_stonecutting" | "biomeswevegone:recipes/decorations/ironwood_fence" | "biomeswevegone:recipes/redstone/blue_enchanted_fence_gate" | "minecraft:recipes/building_blocks/smooth_sandstone_stairs" | "create:recipes/building_blocks/cut_scoria_brick_stairs_from_stone_types_scoria_stonecutting" | "create:recipes/misc/smelting/ingot_silver_compat_ic2" | "megacells:recipes/misc/network/mega_interface_part" | "minecraft:recipes/decorations/black_stained_glass_pane_from_glass_pane" | "fulleng:recipes/ae2.main/terminals/block_requester_terminal_from_part" | "create:recipes/misc/crafting/kinetics/linear_chassisfrom_conversion" | "mekanism:playing_with_fire" | "create:recipes/building_blocks/small_scoria_brick_stairs" | "advanced_ae:recipes/misc/smalladvpatpro2" | "dimstorage:recipes/misc/dimensional_chest" | "compressium:recipes/building_blocks/lapis_7_uncraft" | "ae2:recipes/misc/tools/paintballs_pink" | "sophisticatedstorage:recipes/misc/backpack_advanced_pickup_upgrade_from_storage_advanced_pickup_upgrade" | "minecraft:recipes/decorations/red_candle" | "minecraft:recipes/misc/lapis_lazuli" | "easy_mob_farm:recipes/mob_catcher/void_binding_chain" | "minecraft:story/upgrade_tools" | "sophisticatedstorage:recipes/misc/mangrove_barrel" | "obsidianboat:recipes/transportation/obsidian_boat" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_stairs_from_waxed_exposed_cut_copper_stonecutting" | "ae2:recipes/misc/network/cells/fluid_storage_cell_64k_storage" | "biomeswevegone:recipes/building_blocks/sakura_wood" | "create:recipes/building_blocks/cut_deepslate_brick_slab" | "ae2:recipes/misc/materials/cardspeed" | "create:recipes/building_blocks/cut_crimsite_wall_from_stone_types_crimsite_stonecutting" | "minecraft:recipes/misc/eye_armor_trim_smithing_template" | "compressium:recipes/building_blocks/netherrack_8_uncraft" | "progressivebosses:max_diff_wither" | "immersiveengineering:recipes/misc/crafting/fluorescent_tube" | "immersiveengineering:recipes/misc/crafting/steel_wallmount" | "sophisticatedstorage:recipes/misc/white_shulker_box_to_sophisticated" | "create:recipes/misc/crafting/kinetics/crafter_slot_cover" | "create:diving_suit_lava" | "ae2:recipes/misc/network/cables/glass_red" | "biomeswevegone:recipes/redstone/cika_trapdoor" | "minecraft:recipes/misc/sentry_armor_trim_smithing_template_smithing_trim" | "connectedglass:recipes/misc/borderless_glass_magenta2" | "create:arm_blaze_burner" | "minecraft:recipes/building_blocks/waxed_cut_copper_slab_from_waxed_cut_copper_stonecutting" | "create:cuckoo_clock" | "ae2:recipes/misc/block_cutter/walls/chiseled_quartz_wall" | "connectedglass:recipes/misc/borderless_glass_magenta1" | "megacells:recipes/misc/network/mega_interface_block" | "create:recipes/misc/smelting/silver_ingot_compat_thermal" | "easy_mob_farm:recipes/upgrade/enchancement/sword_enhancement" | "easy_mob_farm:crafting/mob_farm_template/tier3_mob_farm_template" | "apotheosis:enchanting/endshelf" | "minecraft:husbandry/tactical_fishing" | "create:recipes/building_blocks/cut_granite_stairs_from_stone_types_granite_stonecutting" | "easy_mob_farm:recipes/mob_farm_template/tier2_mob_farm_template" | "create:recipes/misc/crafting/logistics/powered_toggle_latch" | "biomeswevegone:recipes/transportation/green_enchanted_boat" | "create:recipes/building_blocks/polished_cut_andesite_wall_from_stone_types_andesite_stonecutting" | "easy_mob_farm:recipes/mob_farm/lucky_drop_farm" | "minecraft:adventure/salvage_sherd" | "advanced_ae:recipes/misc/auto_stock_card" | "buddingcrystals:recipes/misc/budding_steel" | "immersiveengineering:recipes/misc/stonecutting/slab_concrete" | "buildinggadgets2:recipes/misc/gadget_building" | "aquaculture:recipes/food/cooked_fish_fillet" | "immersiveengineering:main/chute_bonk" | "immersiveengineering:recipes/misc/stonecutting/slab_concrete_tile" | "immersiveengineering:recipes/misc/crafting/hammer" | "compressium:recipes/building_blocks/emerald_4_uncraft" | "create:recipes/building_blocks/cut_calcite_stairs_from_stone_types_calcite_stonecutting" | "comforts:hammock_cyan" | "minecraft:story/cure_zombie_villager" | "create:recipes/building_blocks/small_calcite_bricks_from_stone_types_calcite_stonecutting" | "create:recipes/building_blocks/crafting/copper/waxed_copper_shingle_stairs_from_honeycomb" | "create:recipes/building_blocks/small_granite_bricks_from_stone_types_granite_stonecutting" | "compressium:recipes/building_blocks/quartz_1_uncraft" | "create:recipes/building_blocks/crafting/copper/waxed_weathered_copper_tile_stairs_from_honeycomb" | "immersiveengineering:recipes/misc/crafting/alu_fence" | "minecraft:recipes/redstone/mangrove_trapdoor" | "compressium:recipes/building_blocks/cobblestone_1_uncraft" | "immersiveengineering:recipes/misc/crafting/plate_silver_hammering" | "minecraft:recipes/tools/recovery_compass" | "create:recipes/building_blocks/oxidized_copper_shingle_stairs_from_oxidized_copper_shingles_stonecutting" | "connectedglass:recipes/misc/borderless_glass_gray_pane1" | "buddingcrystals:recipes/misc/budding_zinc" | "connectedglass:recipes/misc/borderless_glass_gray_pane2" | "sophisticatedbackpacks:recipes/misc/upgrade_base" | "biomeswevegone:recipes/redstone/holly_trapdoor" | "minecraft:recipes/redstone/oak_pressure_plate" | "ae2:recipes/misc/network/cells/item_storage_cell_64k_storage" | "ae2:recipes/misc/network/cables/dense_covered_fluix_clean" | "connectedglass:recipes/misc/borderless_glass_pane1" | "biomeswevegone:recipes/building_blocks/mossy_red_rock_brick_stairs" | "biomeswevegone:recipes/building_blocks/sakura_slab" | "biomeswevegone:recipes/redstone/ebony_door" | "create:recipes/building_blocks/small_dripstone_brick_slab_from_stone_types_dripstone_stonecutting" | "megacells:recipes/misc/crafting/4m_crafting_storage" | "mekanismtools:paxel" | "connectedglass:recipes/misc/borderless_glass_pane3" | "connectedglass:recipes/misc/borderless_glass_gray_pane3" | "immersiveengineering:main/buy_oremap" | "minecraft:recipes/building_blocks/polished_blackstone_stairs_from_polished_blackstone_stonecutting" | "create:recipes/misc/crafting/kinetics/schedule" | "woodwevegot:recipes/redstone/skyris_trapped_chest" | "sophisticatedstorage:recipes/misc/gray_shulker_box_to_sophisticated" | "minecraft:recipes/redstone/dropper" | "create:recipes/building_blocks/cut_andesite_brick_stairs_from_stone_types_andesite_stonecutting" | "ae2:recipes/misc/block_cutter/walls/quartz_brick_wall" | "create:drain" | "advanced_ae:recipes/misc/quantumdataentangler" | "jamd:recipes/transportation/nether_portal_block" | "comforts:hammock_light_blue" | "ae2:recipes/misc/network/blocks/storage_drive" | "minecraft:end/find_end_city" | "biomeswevegone:recipes/redstone/cypress_trapdoor" | "compressium:recipes/building_blocks/granite_5_uncraft" | "create:recipes/building_blocks/oxidized_copper_tile_slab" | "advanced_ae:recipes/misc/attack_speed_card" | "minecraft:recipes/redstone/mangrove_fence_gate" | "advanced_ae:recipes/misc/quantum_boots" | "connectedglass:recipes/misc/scratched_glass_red1" | "create:recipes/misc/blasting/ingot_uranium_compat_mekanism" | "connectedglass:recipes/misc/clear_glass_blue2" | "compressium:recipes/building_blocks/andesite_8_uncraft" | "create:recipes/building_blocks/polished_cut_scoria_slab_recycling" | "connectedglass:recipes/misc/clear_glass_blue1" | "advanced_ae:recipes/misc/import_export_bus" | "utilitarian:recipes/misc/utility/bamboo_logs_to_pressure_plates" | "create:recipes/building_blocks/cut_deepslate_brick_slab_from_stone_types_deepslate_stonecutting" | "create:recipes/building_blocks/mangrove_window" | "create:recipes/building_blocks/warped_window_pane" | "create:recipes/building_blocks/cut_veridium_brick_slab" | "create:recipes/building_blocks/polished_cut_veridium_wall" | "immersiveengineering:recipes/misc/crafting/metal_barrel" | "minecraft:recipes/building_blocks/dye_light_blue_carpet" | "minecraft:recipes/building_blocks/mossy_stone_from_moss_block" | "biomeswevegone:recipes/misc/blue_dye_from_bwg_tag" | "minecraft:recipes/building_blocks/polished_andesite" | "immersiveengineering:recipes/misc/crafting/treated_wood_packaged_from_vertical" | "immersiveengineering:recipes/misc/smelting/nugget_aluminum_recycle_faraday_boots_from_blasting" | "aeinfinitybooster:recipes/misc/dimension_card" | "minecraft:recipes/decorations/lime_glazed_terracotta" | "sophisticatedstorage:recipes/misc/storage_auto_smelting_upgrade_from_backpack_auto_smelting_upgrade" | "connectedglass:recipes/misc/scratched_glass_red2" | "biomeswevegone:recipes/transportation/rainbow_eucalyptus_chest_boat" | "minecraft:recipes/building_blocks/purpur_block" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_white_from_slab" | "mekanism:personal_storage" | "create:recipes/building_blocks/small_andesite_brick_slab_recycling" | "domum_ornamentum:recipes/tools/light_blue_brick_extra" | "domum_ornamentum:recipes/tools/beige_bricks" | "mekanism:radiation_poisoning_death" | "ae2:recipes/misc/materials/basiccard" | "compressium:recipes/building_blocks/soulsand_9_uncraft" | "biomeswevegone:recipes/food/cooked_yucca_fruit_from_smoker" | "sophisticatedstorage:recipes/misc/brown_shulker_box_to_sophisticated" | "immersiveengineering:recipes/misc/crafting/tinted_glass_lead_wire" | "ae2:recipes/misc/tools/portable_item_cell_1k" | "create:recipes/misc/crafting/kinetics/cogwheel" | "create:recipes/building_blocks/cut_tuff_slab_from_stone_types_tuff_stonecutting" | "biomeswevegone:recipes/decorations/maple_crafting_table" | "ae2:recipes/misc/shaped/stairs/quartz_bricks" | "woodwevegot:recipes/decorations/white_mangrove_ladder" | "minecraft:recipes/building_blocks/exposed_cut_copper_slab_from_exposed_cut_copper_stonecutting" | "minecraft:recipes/transportation/carrot_on_a_stick" | "immersiveengineering:recipes/misc/smelting/nugget_steel_recycle_steel_helmet" | "mekanism:simple_mass_storage" | "biomeswevegone:recipes/building_blocks/stripped_fir_wood" | "woodwevegot:recipes/redstone/cika_trapped_chest" | "minecraft:recipes/building_blocks/polished_granite" | "create:recipes/building_blocks/small_dripstone_brick_wall" | "immersiveengineering:recipes/misc/crafting/treated_post" | "ae2:recipes/misc/tools/portable_item_cell_4k" | "apotheosis:enchanting/upgrade_seashelf" | "immersiveengineering:recipes/misc/crafting/wirecoil_redstone" | "minecraft:recipes/redstone/birch_trapdoor" | "create:recipes/building_blocks/cut_ochrum_bricks_from_stone_types_ochrum_stonecutting" | "compressium:recipes/building_blocks/netherite_8_uncraft" | "connectedglass:recipes/misc/clear_glass_green2" | "connectedglass:recipes/misc/clear_glass_green1" | "minecraft:recipes/redstone/spruce_trapdoor" | "compressium:recipes/building_blocks/sand_7_uncraft" | "minecraft:recipes/building_blocks/muddy_mangrove_roots" | "minecraft:recipes/building_blocks/red_sandstone_slab_from_red_sandstone_stonecutting" | "minecraft:recipes/misc/quartz" | "create:recipes/building_blocks/crafting/kinetics/magenta_seat_from_other_seat" | "create:recipes/building_blocks/polished_cut_asurine_from_stone_types_asurine_stonecutting" | "ae2:recipes/misc/shaped/slabs/fluix_block" | "biomeswevegone:recipes/redstone/white_mangrove_fence_gate" | "minecraft:end/respawn_dragon" | "minecraft:recipes/decorations/polished_blackstone_brick_wall_from_polished_blackstone_bricks_stonecutting" | "minecraft:recipes/decorations/soul_campfire" | "sophisticatedbackpacks:recipes/misc/copper_backpack" | "sophisticatedstorage:recipes/misc/filter_upgrade" | "comforts:hammock_green" | "buddingcrystals:recipes/misc/budding_refinedobsidian" | "biomeswevegone:recipes/transportation/ironwood_boat" | "create:recipes/building_blocks/cut_deepslate_slab" | "compressium:recipes/building_blocks/diorite_5_uncraft" | "biomeswevegone:recipes/building_blocks/black_sandstone" | "sophisticatedstorage:recipes/misc/storage_jukebox_upgrade_from_backpack_jukebox_upgrade" | "minecraft:recipes/building_blocks/warped_slab" | "compressium:recipes/building_blocks/soulsand_9" | "advanced_ae:recipes/misc/quantum_leggings_item_reset" | "minecraft:recipes/food/cooked_mutton_from_campfire_cooking" | "sophisticatedstorage:recipes/misc/iron_shulker_box_from_copper_shulker_box" | "compressium:recipes/building_blocks/soulsand_7" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_cyan" | "compressium:recipes/building_blocks/soulsand_8" | "create:recipes/misc/smelting/ingot_uranium_compat_immersiveengineering" | "woodwevegot:recipes/redstone/white_mangrove_trapped_chest" | "yungscavebiomes:mine_enchanted_ice" | "immersiveengineering:recipes/misc/crafting/fluid_sorter" | "create:recipes/building_blocks/polished_cut_dripstone_slab" | "compressium:recipes/building_blocks/soulsand_1" | "compressium:recipes/building_blocks/soulsand_2" | "compressium:recipes/building_blocks/diorite_7_uncraft" | "compressium:recipes/building_blocks/soulsand_5" | "immersiveengineering:recipes/misc/smelting/ingot_hop_graphite_from_blasting" | "mekanism:heat_transport" | "compressium:recipes/building_blocks/soulsand_6" | "compressium:recipes/building_blocks/soulsand_3" | "compressium:recipes/building_blocks/soulsand_4" | "minecraft:recipes/redstone/spruce_door" | "utilitarian:recipes/misc/utility/warped_logs_to_doors" | "biomeswevegone:recipes/misc/yellow_dye_from_bwg_tag" | "sophisticatedstorage:recipes/misc/storage_stack_upgrade_tier_3_from_backpack_stack_upgrade_tier_2" | "yungscavebiomes:recipes/building_blocks/smooth_ancient_sandstone_slab" | "minecraft:recipes/building_blocks/crimson_hyphae" | "minecraft:recipes/building_blocks/dye_orange_wool" | "minecraft:recipes/building_blocks/yellow_concrete_powder" | "minecraft:recipes/redstone/spruce_fence_gate" | "biomeswevegone:recipes/building_blocks/ebony_planks" | "connectedglass:recipes/misc/clear_glass_yellow_pane1" | "connectedglass:recipes/misc/clear_glass_yellow_pane2" | "ae2:recipes/misc/network/cables/dense_smart_magenta" | "connectedglass:recipes/misc/clear_glass_yellow_pane3" | "sophisticatedstorage:recipes/misc/jungle_limited_barrel_3" | "utilitarian:recipes/misc/no_soliciting/soliciting_carpets/light_blue_soliciting_carpet" | "sophisticatedstorage:recipes/misc/jungle_limited_barrel_2" | "compressium:recipes/building_blocks/lapis_8_uncraft" | "minecraft:recipes/building_blocks/purple_stained_glass" | "sophisticatedstorage:recipes/misc/jungle_limited_barrel_1" | "biomeswevegone:recipes/building_blocks/chiseled_blue_sandstone" | "immersiveengineering:main/buy_shaderbag" | "compressium:recipes/building_blocks/granite_8" | "compressium:recipes/building_blocks/granite_9" | "minecraft:recipes/building_blocks/chiseled_stone_bricks_stone_from_stonecutting" | "biomeswevegone:recipes/building_blocks/purple_sandstone_stairs" | "compressium:recipes/building_blocks/granite_4" | "compressium:recipes/building_blocks/granite_5" | "compressium:recipes/building_blocks/granite_6" | "ae2:recipes/misc/block_cutter/stairs/sky_stone_brick_stairs" | "immersiveengineering:recipes/misc/crafting/grit_sand" | "immersiveengineering:recipes/misc/stonecutting/stairs_hempcrete_brick" | "compressium:recipes/building_blocks/granite_7" | "connectedglass:recipes/misc/clear_glass_gray_pane3" | "compressium:recipes/building_blocks/granite_1" | "compressium:recipes/building_blocks/granite_2" | "connectedglass:recipes/misc/clear_glass_gray_pane1" | "create:recipes/misc/crafting/appliances/dough" | "compressium:recipes/building_blocks/granite_3" | "connectedglass:recipes/misc/clear_glass_gray_pane2" | "create:recipes/building_blocks/weathered_copper_tile_stairs_from_weathered_copper_tiles_stonecutting" | "create:recipes/building_blocks/crafting/kinetics/light_gray_seat_from_other_seat" | "ae2:recipes/misc/network/cables/smart_green" | "create:recipes/building_blocks/cut_limestone_slab_recycling" | "sophisticatedstorage:recipes/misc/jungle_limited_barrel_4" | "betterdungeons:all_dungeons" | "minecraft:recipes/decorations/blue_carpet" | "minecraft:recipes/misc/snout_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/building_blocks/dye_white_wool" | "immersiveengineering:recipes/misc/crafting/ersatz_leather" | "sophisticatedstorage:recipes/misc/chipped/loom_table_upgrade" | "minecraft:recipes/decorations/light_blue_glazed_terracotta" | "ae2:recipes/misc/network/cables/covered_cyan" | "create:recipes/misc/blasting/gold_ingot_from_crushed" | "biomeswevegone:recipes/redstone/holly_door" | "ae2:recipes/misc/network/cables/glass_white" | "create:recipes/building_blocks/polished_cut_diorite_from_stone_types_diorite_stonecutting" | "connectedglass:recipes/misc/scratched_glass_green_pane1" | "minecraft:recipes/building_blocks/smooth_purple_sandstone_stairs_from_purple_sandstone_stonecutting" | "create:recipes/misc/crafting/kinetics/contraption_controls" | "connectedglass:recipes/misc/scratched_glass_green_pane2" | "create:recipes/building_blocks/polished_cut_asurine_slab_from_stone_types_asurine_stonecutting" | "compressium:recipes/building_blocks/redstone_7_uncraft" | "create:recipes/building_blocks/small_ochrum_brick_wall_from_stone_types_ochrum_stonecutting" | "connectedglass:recipes/misc/scratched_glass_green_pane3" | "minecraft:recipes/building_blocks/prismarine_stairs" | "create:recipes/misc/crafting/kinetics/flywheel" | "minecraft:recipes/building_blocks/blue_sandstone_stairs_from_blue_sandstone_stonecutting" | "minecraft:recipes/building_blocks/polished_blackstone_from_blackstone_stonecutting" | "immersiveengineering:recipes/misc/crafting/storage_constantan_to_ingot_constantan" | "create:recipes/misc/crafting/kinetics/hose_pulley" | "immersiveengineering:recipes/misc/crafting/windmill" | "immersiveengineering:tools/craft_drill" | "yungscavebiomes:recipes/building_blocks/smooth_ancient_sandstone_stairs_from_smooth_stonecutting" | "create:recipes/misc/crafting/curiosities/brown_toolbox" | "immersiveengineering:recipes/misc/stonecutting/stairs_concrete_tile" | "minecraft:recipes/building_blocks/deepslate_tiles_from_polished_deepslate_stonecutting" | "comforts:hammock_lime" | "minecraft:recipes/decorations/polished_blackstone_wall_from_polished_blackstone_stonecutting" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_slab_from_honeycomb" | "minecraft:recipes/building_blocks/deepslate_tiles_from_deepslate_bricks_stonecutting" | "biomeswevegone:recipes/building_blocks/mahogany_bookshelf" | "minecraft:recipes/building_blocks/dripstone_block" | "minecraft:recipes/building_blocks/mangrove_wood" | "ae2:recipes/misc/network/parts/panels_semi_dark_monitor" | "immersiveengineering:recipes/misc/smelting/ingot_silver" | "create:recipes/building_blocks/small_ochrum_brick_wall" | "immersiveengineering:recipes/misc/crafting/sheetmetal_silver_to_slab" | "advanced_ae:recipes/misc/quantum_alloy_wall" | "minecraft:adventure/avoid_vibration" | "create:recipes/building_blocks/small_tuff_brick_wall_from_stone_types_tuff_stonecutting" | "create:contraption_actors" | "minecraft:recipes/misc/gold_ingot_from_smelting_nether_gold_ore" | "create:recipes/building_blocks/polished_cut_diorite_slab_from_stone_types_diorite_stonecutting" | "biomeswevegone:recipes/building_blocks/rainbow_eucalyptus_stairs" | "create:recipes/building_blocks/crafting/kinetics/white_seat" | "immersiveengineering:multiblocks/mb_tank" | "ae2:recipes/misc/network/crafting/cpu_crafting_monitor" | "immersiveengineering:recipes/misc/smelting/ingot_aluminum_from_dust" | "create:recipes/building_blocks/cut_calcite_brick_slab" | "minecraft:recipes/building_blocks/yellow_stained_glass" | "minecraft:recipes/misc/spire_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/decorations/acacia_fence" | "biomeswevegone:recipes/decorations/dacite_cobblestone_wall" | "create:recipes/building_blocks/polished_cut_deepslate_from_stone_types_deepslate_stonecutting" | "create:recipes/combat/crafting/appliances/netherite_diving_helmet" | "connectedglass:recipes/misc/clear_glass_light_blue2" | "connectedglass:recipes/misc/clear_glass_light_blue1" | "betterdeserttemples:temple_clear" | "compressium:recipes/building_blocks/diorite_3" | "progressivebosses:max_diff_dragon" | "compressium:recipes/building_blocks/diorite_2" | "compressium:recipes/building_blocks/diorite_1" | "create:recipes/building_blocks/rose_quartz_tiles_from_polished_rose_quartz_stonecutting" | "minecraft:recipes/misc/iron_ingot_from_blasting_deepslate_iron_ore" | "minecraft:recipes/building_blocks/dye_brown_carpet" | "minecraft:recipes/building_blocks/pink_sandstone_stairs_from_pink_sandstone_stonecutting" | "create:recipes/building_blocks/small_limestone_brick_slab_recycling" | "biomeswevegone:recipes/redstone/ironwood_pressure_plate" | "minecraft:recipes/redstone/mangrove_button" | "minecraft:nether/return_to_sender" | "biomeswevegone:recipes/misc/magenta_dye_from_bwg_tag" | "minecraft:recipes/building_blocks/sandstone" | "compressium:recipes/building_blocks/coal_8_uncraft" | "create:recipes/building_blocks/crafting/copper/waxed_copper_shingles_from_honeycomb" | "apotheosis:enchanting/sculkshelf" | "sophisticatedstorage:recipes/misc/warped_chest" | "easy_mob_farm:recipes/mob_catcher/mystic_binding_crystal" | "compressium:recipes/building_blocks/diorite_9" | "compressium:recipes/building_blocks/diorite_8" | "compressium:recipes/building_blocks/diorite_7" | "connectedglass:recipes/misc/borderless_glass_brown2" | "compressium:recipes/building_blocks/diorite_6" | "connectedglass:recipes/misc/borderless_glass_brown1" | "compressium:recipes/building_blocks/diorite_5" | "megacells:recipes/misc/cells/standard/item_storage_cell_256m" | "connectedglass:recipes/misc/vanilla_white_stained_glass" | "compressium:recipes/building_blocks/diorite_4" | "minecraft:recipes/misc/crafting_table" | "compressium:recipes/building_blocks/granite_6_uncraft" | "connectedglass:recipes/misc/tinted_borderless_glass_blue2" | "biomeswevegone:recipes/decorations/red_rock_wall" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_brown_from_slab" | "ae2:recipes/misc/network/cables/dense_smart_yellow" | "create:recipes/building_blocks/cut_scoria_brick_slab_from_stone_types_scoria_stonecutting" | "immersiveengineering:recipes/misc/crafting/ingot_silver_to_nugget_silver" | "minecraft:recipes/building_blocks/polished_basalt_from_basalt_stonecutting" | "create:recipes/building_blocks/small_scorchia_brick_slab" | "immersiveengineering:recipes/misc/crafting/earmuffs" | "ae2:recipes/misc/decorative/cut_quartz_block" | "create:recipes/building_blocks/polished_cut_diorite_slab_recycling" | "ae2:recipes/misc/shaped/stairs/sky_stone_small_brick" | "ae2:recipes/misc/block_cutter/stairs/quartz_stairs" | "create:recipes/building_blocks/polished_cut_deepslate_slab_from_stone_types_deepslate_stonecutting" | "immersiveengineering:recipes/misc/smelting/nugget_aluminum_recycle_faraday_boots" | "minecraft:recipes/building_blocks/white_wool_from_string" | "compressium:recipes/building_blocks/endstone_1_uncraft" | "fulleng:recipes/misc/terminals/block_crafting_terminal_from_part" | "sophisticatedstorage:recipes/misc/lime_shulker_box_to_sophisticated" | "biomeswevegone:recipes/redstone/ebony_button" | "minecraft:recipes/decorations/yellow_banner" | "megacells:recipes/misc/network/mega_interface" | "minecraft:recipes/decorations/brown_stained_glass_pane_from_glass_pane" | "utilitarian:recipes/misc/snad/soul_snad" | "minecraft:husbandry/obtain_sniffer_egg" | "biomeswevegone:recipes/building_blocks/pink_sand" | "yungscavebiomes:recipes/building_blocks/layered_ancient_sandstone" | "trashcans:ultimate_trash_can" | "biomeswevegone:recipes/building_blocks/green_enchanted_planks" | "minecraft:recipes/building_blocks/deepslate_brick_slab" | "minecraft:recipes/building_blocks/polished_diorite_stairs_from_polished_diorite_stonecutting" | "minecraft:recipes/decorations/brick_wall_from_bricks_stonecutting" | "ae2:recipes/misc/block_cutter/walls/sky_stone_wall" | "apotheosis:enchanting/quanta0" | "minecraft:recipes/building_blocks/exposed_cut_copper_slab_from_exposed_copper_stonecutting" | "ae2:recipes/misc/shaped/walls/fluix_block" | "immersiveengineering:recipes/misc/smelting/ingot_aluminum_from_blasting" | "justhammers:recipes/tools/iron_destructor_hammer" | "ae2:recipes/misc/network/cells/item_storage_components_cell_4k_part" | "create:recipes/building_blocks/cut_scoria_stairs_from_stone_types_scoria_stonecutting" | "utilitarian:recipes/misc/no_soliciting/soliciting_carpets/black_soliciting_carpet" | "ae2:recipes/misc/materials/cardinverter" | "minecraft:recipes/redstone/polished_blackstone_pressure_plate" | "friendsandfoes:husbandry/beehive" | "immersiveengineering:recipes/misc/crafting/alu_scaffolding_standard" | "immersiveengineering:recipes/misc/crafting/gunpart_hammer" | "create:recipes/building_blocks/small_deepslate_brick_wall" | "comforts:hammock_blue" | "domum_ornamentum:recipes/tools/brown_brick_extra" | "minecraft:recipes/food/cooked_cod_from_campfire_cooking" | "biomeswevegone:recipes/redstone/mahogany_trapdoor" | "create:recipes/building_blocks/cut_asurine_brick_stairs_from_stone_types_asurine_stonecutting" | "minecraft:recipes/decorations/magenta_stained_glass_pane_from_glass_pane" | "biomeswevegone:recipes/decorations/redwood_hanging_sign" | "immersiveengineering:recipes/misc/crafting/nugget_nickel_to_ingot_nickel" | "ae2:recipes/misc/materials/cardcapacity" | "minecraft:recipes/misc/pink_dye_from_red_white_dye" | "comforts:hammock_white" | "immersiveengineering:recipes/misc/smelting/nugget_aluminum_recycle_faraday_chestplate" | "create:recipes/building_blocks/small_veridium_brick_slab_from_stone_types_veridium_stonecutting" | "advanced_ae:recipes/misc/smalladvpatpropart" | "immersiveengineering:recipes/misc/smelting/nugget_steel_recycle_steel_leggings" | "minecraft:recipes/brewing/blaze_powder" | "minecraft:recipes/redstone/jungle_pressure_plate" | "minecraft:end/root" | "ae2:recipes/misc/materials/cardenergy" | "create:recipes/misc/crafting/kinetics/clockwork_bearing" | "biomeswevegone:recipes/building_blocks/green_enchanted_bookshelf" | "biomeswevegone:recipes/redstone/zelkova_door" | "sophisticatedstorage:recipes/misc/iron_shulker_from_iron_chest" | "sophisticatedbackpacks:recipes/misc/chipped/loom_table_upgrade" | "minecraft:recipes/misc/diamond_from_blasting_diamond_ore" | "minecraft:recipes/building_blocks/polished_blackstone_brick_slab_from_polished_blackstone_stonecutting" | "create:recipes/building_blocks/dripstone_pillar_from_stone_types_dripstone_stonecutting" | "minecraft:recipes/decorations/moss_carpet" | "create:recipes/misc/blasting/ingot_nickel_compat_immersiveengineering" | "immersiveengineering:recipes/misc/crafting/current_transformer" | "immersiveengineering:recipes/misc/smelting/iron_ingot_from_dust" | "minecraft:recipes/building_blocks/polished_diorite_slab_from_polished_diorite_stonecutting" | "domum_ornamentum:recipes/tools/gray_brick_extra" | "advanced_ae:recipes/misc/auto_feed_card" | "minecraft:recipes/decorations/cyan_stained_glass_pane_from_glass_pane" | "biomeswevegone:recipes/building_blocks/smooth_white_sandstone_slab" | "woodwevegot:recipes/decorations/baobab_barrel" | "minecraft:recipes/decorations/blackstone_wall_from_blackstone_stonecutting" | "connectedglass:recipes/misc/scratched_glass_yellow_pane1" | "domum_ornamentum:recipes/decorations/blue_floating_carpet" | "immersiveengineering:recipes/misc/crafting/firework" | "minecraft:recipes/redstone/crimson_fence_gate" | "connectedglass:recipes/misc/scratched_glass_yellow_pane3" | "connectedglass:recipes/misc/scratched_glass_yellow_pane2" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper" | "create:recipes/building_blocks/cut_calcite_brick_wall_from_stone_types_calcite_stonecutting" | "mekanismgenerators:heat_generator" | "ae2:recipes/misc/network/parts/formation_plane" | "create:copper_casing" | "biomeswevegone:recipes/redstone/green_enchanted_pressure_plate" | "ae2:recipes/misc/network/cables/smart_yellow" | "biomeswevegone:recipes/building_blocks/dacite_brick_slab" | "minecraft:recipes/building_blocks/amethyst_block" | "create:recipes/misc/crafting/kinetics/vertical_gearbox" | "botanypots:husbandry/get_basic_pot" | "compressium:recipes/building_blocks/clay_7_uncraft" | "connectedglass:recipes/misc/scratched_glass_white1" | "immersiveengineering:recipes/misc/crafting/wire_lead" | "woodwevegot:recipes/decorations/green_enchanted_chest" | "biomeswevegone:recipes/building_blocks/red_rock_stairs" | "minecraft:husbandry/obtain_netherite_hoe" | "minecraft:recipes/building_blocks/gray_concrete_powder" | "minecraft:recipes/decorations/light_gray_banner" | "create:foods" | "compressium:recipes/building_blocks/netherrack_6_uncraft" | "megacells:recipes/misc/cells/portable/portable_item_cell_4m" | "biomeswevegone:recipes/redstone/pine_pressure_plate" | "comforts:hammock_light_gray" | "connectedglass:recipes/misc/scratched_glass_white2" | "minecraft:recipes/tools/iron_axe" | "compressium:recipes/building_blocks/sand_9_uncraft" | "easy_mob_farm:recipes/upgrade/enchancement/honey_harvester_frame_enhancement" | "minecraft:recipes/building_blocks/glowstone" | "minecraft:recipes/building_blocks/sea_lantern" | "ae2:main/p2p" | "create:recipes/building_blocks/oak_window" | "sophisticatedstorage:recipes/misc/iron_barrel" | "mekanism:nucleosynthesizer" | "create:recipes/misc/crafting/curiosities/peculiar_bell" | "utilitarian:recipes/misc/no_soliciting/restraining_order" | "immersiveengineering:main/place_windmill" | "create:recipes/building_blocks/polished_cut_diorite_slab" | "utilitarian:recipes/misc/utility/copper_block_from_blasting" | "minecraft:recipes/decorations/cartography_table" | "create:recipes/misc/blasting/zinc_ingot_from_crushed" | "minecraft:recipes/building_blocks/mossy_red_rock_brick_slab_from_mossy_red_rock_bricks_stonecutting" | "create:recipes/building_blocks/small_limestone_brick_wall" | "connectedglass:recipes/misc/borderless_glass_cyan1" | "compressium:recipes/building_blocks/obsidian_9_uncraft" | "woodwevegot:recipes/decorations/cika_ladder" | "minecraft:recipes/building_blocks/deepslate_tile_slab" | "biomeswevegone:recipes/building_blocks/blue_enchanted_bookshelf" | "immersiveengineering:recipes/misc/smelting/ingot_uranium_from_blasting3" | "minecraft:recipes/building_blocks/polished_diorite_from_diorite_stonecutting" | "advanced_ae:recipes/misc/quantumunit" | "immersiveengineering:recipes/misc/smelting/ingot_uranium_from_blasting2" | "repurposed_structures:mansions" | "compressium:recipes/building_blocks/iron_5_uncraft" | "create:recipes/building_blocks/small_calcite_brick_wall" | "domum_ornamentum:recipes/building_blocks/blockbarreldeco_standing" | "minecraft:recipes/building_blocks/chiseled_deepslate" | "connectedglass:recipes/misc/borderless_glass_cyan2" | "utilitarian:recipes/misc/utility/dark_oak_logs_to_trapdoors" | "minecraft:recipes/building_blocks/nether_brick_slab_from_nether_bricks_stonecutting" | "create:recipes/misc/crafting/kinetics/nixie_tube" | "minecraft:recipes/misc/iron_nugget_from_blasting" | "sophisticatedbackpacks:recipes/misc/restock_upgrade" | "biomeswevegone:recipes/redstone/mahogany_fence_gate" | "immersiveengineering:recipes/misc/smelting/ingot_uranium_from_blasting" | "minecraft:adventure/kill_a_mob" | "biomeswevegone:recipes/decorations/fir_fence" | "immersiveengineering:recipes/misc/crafting/sheetmetal_aluminum_from_slab" | "buddingcrystals:recipes/misc/budding_draconium" | "connectedglass:recipes/misc/clear_glass_orange_pane1" | "connectedglass:recipes/misc/clear_glass_orange_pane2" | "create:pipe_organ" | "connectedglass:recipes/misc/clear_glass_orange_pane3" | "sophisticatedbackpacks:recipes/misc/gold_backpack" | "minecraft:husbandry/plant_any_sniffer_seed" | "biomeswevegone:recipes/redstone/fir_door" | "domum_ornamentum:recipes/tools/sand_bricks" | "compressium:recipes/building_blocks/redsand_2_uncraft" | "create:recipes/building_blocks/crafting/kinetics/brown_seat_from_other_seat" | "biomeswevegone:recipes/decorations/holly_fence" | "minecraft:recipes/building_blocks/deepslate_bricks_from_cobbled_deepslate_stonecutting" | "create:recipes/misc/crafting/materials/rose_quartz_tilesfrom_conversion" | "minecraft:adventure/adventuring_time" | "compressium:recipes/building_blocks/snow_4_uncraft" | "minecraft:recipes/building_blocks/dye_cyan_carpet" | "biomeswevegone:recipes/building_blocks/windswept_sandstone" | "justhammers:recipes/tools/impact_core" | "biomeswevegone:biomeswevegone/husbandry/root" | "immersiveengineering:recipes/misc/crafting/storage_silver_to_slab" | "create:recipes/building_blocks/polished_cut_asurine_slab" | "immersiveengineering:recipes/misc/crafting/hemp_fabric" | "create:recipes/building_blocks/polished_cut_ochrum_wall_from_stone_types_ochrum_stonecutting" | "utilitarian:recipes/misc/utility/jungle_logs_to_slabs" | "compressium:recipes/building_blocks/cobblestone_1" | "compressium:recipes/building_blocks/cobblestone_2" | "compressium:recipes/building_blocks/cobblestone_3" | "minecraft:recipes/decorations/pink_allium" | "connectedglass:recipes/misc/vanilla_pink_stained_glass" | "compressium:recipes/building_blocks/cobblestone_4" | "create:recipes/building_blocks/cut_dripstone_brick_slab" | "compressium:recipes/building_blocks/cobblestone_5" | "biomeswevegone:recipes/building_blocks/black_sandstone_slab" | "biomeswevegone:recipes/building_blocks/chiseled_red_rock_bricks" | "compressium:recipes/building_blocks/cobblestone_6" | "compressium:recipes/building_blocks/cobblestone_7" | "mekanism:enricher" | "compressium:recipes/building_blocks/cobblestone_8" | "biomeswevegone:recipes/decorations/cika_sign" | "biomeswevegone:recipes/redstone/witch_hazel_pressure_plate" | "compressium:recipes/building_blocks/cobblestone_9" | "create:recipes/building_blocks/cut_deepslate_bricks_from_stone_types_deepslate_stonecutting" | "sophisticatedstorage:recipes/misc/bamboo_barrel" | "justhammers:recipes/tools/stone_reinforced_hammer" | "utilitarian:recipes/misc/tps_meter" | "immersiveengineering:recipes/misc/crafting/sheetmetal_aluminum" | "minecraft:husbandry/plant_seed" | "immersiveengineering:recipes/misc/crafting/wirecutter" | "minecraft:nether/find_bastion" | "biomeswevegone:recipes/redstone/green_enchanted_trapdoor" | "create:recipes/building_blocks/crafting/kinetics/lime_seat" | "biomeswevegone:recipes/building_blocks/stripped_mahogany_wood" | "minecraft:recipes/building_blocks/polished_andesite_slab_from_polished_andesite_stonecutting" | "utilitarian:recipes/misc/utility/oak_logs_to_trapdoors" | "biomeswevegone:recipes/redstone/blue_enchanted_pressure_plate" | "megacells:recipes/misc/cells/standard/fluid_storage_cell_64m_with_housing" | "immersiveengineering:main/place_conveyor" | "sophisticatedstorage:recipes/misc/crimson_chest_from_quark_crimson_chest" | "woodwevegot:recipes/redstone/blue_enchanted_trapped_chest" | "minecraft:recipes/decorations/flower_pot" | "minecraft:recipes/misc/raw_iron" | "minecraft:recipes/decorations/red_rock_wall_from_red_rock_stonecutting" | "minecraft:recipes/building_blocks/red_rock_stairs_from_red_rock_stonecutting" | "create:recipes/building_blocks/cut_ochrum_brick_wall_from_stone_types_ochrum_stonecutting" | "ae2:recipes/misc/network/cables/smart_black" | "create:recipes/building_blocks/cut_scoria_brick_slab" | "compressium:recipes/building_blocks/diamond_9_uncraft" | "biomeswevegone:recipes/decorations/aspen_crafting_table" | "create:recipes/misc/smelting/silver_ingot_compat_galosphere" | "sophisticatedbackpacks:recipes/misc/tool_swapper_upgrade" | "minecraft:recipes/building_blocks/deepslate_tile_slab_from_deepslate_bricks_stonecutting" | "immersiveengineering:recipes/misc/crafting/treated_wood_horizontal_from_slab" | "create:recipes/building_blocks/layered_asurine_from_stone_types_asurine_stonecutting" | "minecraft:recipes/misc/stick_from_bamboo_item" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper" | "connectedglass:recipes/misc/scratched_glass_yellow1" | "connectedglass:recipes/misc/scratched_glass_yellow2" | "minecraft:recipes/redstone/bamboo_fence_gate" | "minecraft:recipes/decorations/sandstone_wall" | "lootr:100loot" | "create:recipes/misc/crafting/kinetics/purple_valve_handle_from_other_valve_handle" | "ae2:recipes/misc/shaped/slabs/sky_stone_block" | "create:recipes/misc/smelting/glass_from_vertical_framed_glass" | "create:fan_processing" | "immersiveengineering:recipes/misc/crafting/stairs_clinker_brick" | "immersiveengineering:recipes/misc/crafting/stairs_steel_scaffolding_wooden_top" | "megacells:recipes/misc/cells/portable/portable_item_cell_1m" | "minecraft:recipes/decorations/andesite_wall" | "minecraft:recipes/building_blocks/andesite_slab" | "biomeswevegone:recipes/decorations/rainbow_eucalyptus_fence" | "minecraft:recipes/misc/light_gray_dye_from_oxeye_daisy" | "biomeswevegone:recipes/redstone/rainbow_eucalyptus_fence_gate" | "create:water_supply" | "utilitarian:recipes/misc/utility/birch_logs_to_slabs" | "create:recipes/misc/crafting/kinetics/metal_bracket" | "immersiveengineering:recipes/misc/crafting/stairs_treated_wood_vertical" | "ae2:recipes/misc/network/blocks/inscribers" | "ae2:recipes/misc/tools/paintballs_white" | "minecraft:recipes/misc/light_gray_dye_from_black_white_dye" | "minecraft:recipes/building_blocks/waxed_cut_copper_stairs_from_waxed_copper_block_stonecutting" | "create:recipes/building_blocks/cut_ochrum_slab_recycling" | "simplemagnets:recipes/misc/advancedmagnet" | "minecraft:recipes/building_blocks/cobblestone_stairs_from_cobblestone_stonecutting" | "immersiveengineering:recipes/misc/crafting/connector_lv_relay" | "utilitarian:recipes/misc/utility/oak_logs_to_slabs" | "woodwevegot:recipes/redstone/pine_trapped_chest" | "comforts:sleeping_bag_lime" | "create:recipes/building_blocks/small_veridium_brick_wall" | "sophisticatedbackpacks:recipes/misc/auto_smoking_upgrade_from_auto_smelting_upgrade" | "create:recipes/building_blocks/layered_veridium_from_stone_types_veridium_stonecutting" | "immersiveengineering:recipes/misc/crafting/crate" | "mekanism:installer" | "minecraft:recipes/misc/wheat" | "compressium:recipes/building_blocks/gold_8_uncraft" | "sophisticatedstorage:recipes/misc/netherite_chest" | "buddingcrystals:recipes/misc/budding_fluorite" | "biomeswevegone:recipes/decorations/ebony_sign" | "create:recipes/building_blocks/polished_cut_dripstone_slab_from_stone_types_dripstone_stonecutting" | "create:recipes/building_blocks/warped_window" | "create:recipes/misc/crafting/kinetics/adjustable_chain_gearshift" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_brown_to_slab" | "mekanism:machine_security" | "minecraft:recipes/food/rabbit_stew_from_red_mushroom" | "minecraft:recipes/redstone/birch_pressure_plate" | "sophisticatedstorage:recipes/misc/spruce_barrel" | "compressium:recipes/building_blocks/iron_4_uncraft" | "minecraft:recipes/building_blocks/purpur_stairs_from_purpur_block_stonecutting" | "minecraft:recipes/tools/golden_hoe" | "minecraft:recipes/building_blocks/cut_red_sandstone_from_red_sandstone_stonecutting" | "minecraft:recipes/building_blocks/diorite_slab_from_diorite_stonecutting" | "yungscavebiomes:sandstorm_end" | "create:recipes/misc/smelting/glass_from_horizontal_framed_glass" | "domum_ornamentum:recipes/tools/brown_stone_bricks" | "easy_mob_farm:recipes/upgrade/enchancement/egg_collector_enhancement" | "create:recipes/building_blocks/polished_cut_deepslate_slab_recycling" | "immersiveengineering:recipes/misc/crafting/toolupgrade_chemthrower_multitank" | "yungscavebiomes:recipes/building_blocks/ancient_sandstone_wall" | "ae2:recipes/misc/network/crafting/cpu_crafting_accelerator" | "minecraft:recipes/decorations/pink_carpet" | "create:portable_storage_interface" | "immersiveengineering:recipes/misc/crafting/armor_steel_chestplate" | "sophisticatedstorage:recipes/misc/auto_smelting_upgrade" | "immersiveengineering:recipes/misc/crafting/coal_coke_to_coke" | "immersiveengineering:recipes/misc/smelting/ingot_lead_from_dust_from_blasting" | "comforts:hammock_yellow" | "immersiveengineering:recipes/misc/crafting/armor_steel_leggings" | "create:conductor" | "immersiveengineering:multiblocks/mb_crusher" | "trashcans:recipes/misc/energy_trash_can" | "biomeswevegone:recipes/building_blocks/blue_sandstone_slab" | "ae2:main/root" | "biomeswevegone:recipes/redstone/pine_trapdoor" | "immersiveengineering:recipes/misc/crafting/paper_from_sawdust" | "minecraft:recipes/building_blocks/dacite_stairs_from_dacite_stonecutting" | "create:recipes/misc/blasting/ingot_lead_compat_mekanism" | "minecraft:recipes/building_blocks/cut_copper_slab_from_copper_block_stonecutting" | "sophisticatedstorage:recipes/misc/diamond_to_netherite_tier_upgrade" | "ae2:recipes/misc/shaped/not_so_mysterious_cube" | "domum_ornamentum:recipes/tools/lime_brick_extra" | "fulleng:recipes/misc/terminals/part_pattern_access_terminal_from_block" | "minecraft:recipes/food/mushroom_stew" | "immersiveengineering:recipes/misc/crafting/ingot_uranium_to_nugget_uranium" | "immersiveengineering:recipes/misc/crafting/cloche" | "ae2:recipes/misc/network/blocks/io_port" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_slab" | "immersiveengineering:recipes/misc/crafting/storage_silver_to_ingot_silver" | "create:recipes/misc/blasting/zinc_ingot_from_ore" | "ae2:recipes/misc/network/parts/level_emitter" | "immersiveengineering:recipes/misc/stonecutting/concrete_three_quarter" | "immersiveengineering:recipes/misc/crafting/item_batcher" | "utilitarian:recipes/misc/no_soliciting/soliciting_carpets/orange_soliciting_carpet" | "minecraft:husbandry/balanced_diet" | "create:recipes/building_blocks/cut_dripstone_brick_stairs_from_stone_types_dripstone_stonecutting" | "minecraft:recipes/building_blocks/gray_terracotta" | "domum_ornamentum:recipes/tools/red_brick_extra" | "mekanism:stone_generator" | "aquaculture:recipes/misc/neptunium_ingot_from_nuggets" | "minecraft:recipes/food/cooked_cod" | "buddingcrystals:recipes/misc/budding_tin" | "justhammers:recipes/tools/iron_impact_hammer" | "minecraft:recipes/tools/netherite_pickaxe_smithing" | "compressium:recipes/building_blocks/snow_3_uncraft" | "ae2:recipes/misc/network/parts/toggle_bus_alt" | "mekanism:seismic_vibrations" | "minecraft:nether/fast_travel" | "mekanism:infusing_efficiency" | "minecraft:recipes/building_blocks/bamboo_stairs" | "ae2:recipes/misc/network/cables/dense_covered_light_blue" | "minecraft:recipes/building_blocks/dacite_brick_slab_from_dacite_bricks_stonecutting" | "minecraft:recipes/building_blocks/dye_yellow_bed" | "megacells:recipes/misc/crafting/64m_crafting_storage" | "sophisticatedstorage:recipes/misc/backpack_blasting_upgrade_from_storage_blasting_upgrade" | "sophisticatedstorage:recipes/misc/orange_shulker_box_to_sophisticated" | "immersiveengineering:recipes/misc/crafting/toolupgrade_drill_waterproof" | "mekanism:robit_aesthetics" | "create:recipes/misc/crafting/materials/zinc_nugget_from_decompacting" | "biomeswevegone:recipes/building_blocks/smooth_windswept_sandstone_stairs" | "sophisticatedbackpacks:recipes/misc/auto_blasting_upgrade_from_auto_smelting_upgrade" | "minecraft:recipes/building_blocks/bamboo_block" | "create:recipes/building_blocks/copper_shingle_slab_from_copper_shingles_stonecutting" | "create:precision_mechanism" | "friendsandfoes:nether/find_citadel" | "minecraft:recipes/building_blocks/deepslate_tiles_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/building_blocks/dye_gray_wool" | "ae2:recipes/misc/network/crafting/cpu_crafting_unit" | "woodwevegot:recipes/decorations/holly_chest" | "mekanism:yellow_cake" | "immersiveengineering:recipes/misc/crafting/raw_block_aluminum_to_raw_aluminum" | "immersiveengineering:recipes/misc/crafting/sheetmetal_steel_to_slab" | "immersiveengineering:recipes/misc/crafting/sheetmetal_nickel" | "biomeswevegone:recipes/building_blocks/dacite" | "biomeswevegone:recipes/decorations/palm_crafting_table" | "yungscavebiomes:poke_the_cactus" | "minecraft:recipes/decorations/mossy_cobblestone_wall_from_mossy_cobblestone_stonecutting" | "immersiveengineering:recipes/misc/crafting/stairs_slag_brick" | "fulleng:recipes/misc/terminals/part_crafting_terminal_from_block" | "minecraft:recipes/redstone/tnt" | "minecraft:recipes/decorations/black_stained_glass_pane" | "create:recipes/building_blocks/cut_tuff_bricks_from_stone_types_tuff_stonecutting" | "compressium:recipes/building_blocks/quartz_2_uncraft" | "create:recipes/building_blocks/crafting/copper/waxed_exposed_copper_tile_slab_from_honeycomb" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_slab_from_waxed_oxidized_copper_stonecutting" | "immersiveengineering:recipes/misc/crafting/charging_station" | "fulleng:recipes/ae2.main/terminals/part_requester_terminal_from_block" | "create:recipes/building_blocks/small_scoria_bricks_from_stone_types_scoria_stonecutting" | "sophisticatedstorage:recipes/misc/storage_advanced_feeding_upgrade_from_backpack_advanced_feeding_upgrade" | "comforts:sleeping_bag_blue" | "minecraft:recipes/building_blocks/purple_sandstone_slab_from_purple_sandstone_stonecutting" | "sophisticatedstorage:recipes/misc/storage_advanced_filter_upgrade_from_backpack_advanced_filter_upgrade" | "minecraft:recipes/building_blocks/dye_gray_bed" | "compressium:recipes/building_blocks/sand_8_uncraft" | "sophisticatedstorage:recipes/misc/auto_blasting_upgrade_from_auto_smelting_upgrade" | "advanced_ae:recipes/misc/largeappupgrade" | "ae2:recipes/misc/shaped/stairs/smooth_sky_stone_block" | "create:recipes/building_blocks/small_limestone_brick_stairs" | "immersiveengineering:recipes/misc/crafting/turret_chem" | "advanced_ae:recipes/misc/quantumcrafter" | "woodwevegot:recipes/decorations/cypress_chest" | "biomeswevegone:recipes/redstone/sakura_button" | "justhammers:recipes/tools/gold_impact_hammer" | "minecraft:recipes/decorations/enchanting_table" | "woodwevegot:recipes/decorations/ironwood_ladder" | "compressium:recipes/building_blocks/cobblestone_9_uncraft" | "immersiveengineering:recipes/misc/crafting/watermill" | "create:recipes/misc/blasting/lead_ingot_compat_oreganized" | "sophisticatedstorage:recipes/misc/storage_advanced_compacting_upgrade_from_backpack_advanced_compacting_upgrade" | "create:recipes/misc/crafting/materials/rose_quartz" | "biomeswevegone:recipes/building_blocks/smooth_purple_sandstone_slab" | "create:train_casing_00" | "biomeswevegone:recipes/redstone/cika_button" | "minecraft:recipes/building_blocks/weathered_cut_copper_stairs_from_weathered_cut_copper_stonecutting" | "minecraft:recipes/building_blocks/oxidized_cut_copper_slab_from_oxidized_cut_copper_stonecutting" | "woodwevegot:recipes/decorations/pine_ladder" | "minecraft:recipes/tools/stone_hoe" | "minecraft:recipes/food/dried_kelp" | "woodwevegot:recipes/redstone/witch_hazel_trapped_chest" | "sophisticatedstorage:recipes/misc/backpack_void_upgrade_from_storage_void_upgrade" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_blue" | "aquaculture:recipes/misc/iron_nugget_from_blasting" | "immersiveengineering:main/craft_workbench" | "compressium:recipes/building_blocks/andesite_7_uncraft" | "woodwevegot:recipes/decorations/cypress_ladder" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_light_blue" | "minecraft:nether/use_lodestone" | "immersiveengineering:main/mb_blastfurnace" | "create:recipes/building_blocks/cut_calcite_slab_recycling" | "minecraft:recipes/decorations/jungle_hanging_sign" | "minecraft:recipes/building_blocks/spruce_stairs" | "create:recipes/misc/blasting/silver_ingot_compat_iceandfire" | "sophisticatedbackpacks:recipes/misc/tank_upgrade" | "minecraft:recipes/building_blocks/mangrove_slab" | "sophisticatedbackpacks:recipes/misc/crafting_upgrade" | "woodwevegot:recipes/decorations/aspen_barrel" | "minecraft:recipes/building_blocks/red_sandstone_stairs_from_red_sandstone_stonecutting" | "ae2:recipes/misc/shaped/walls/cut_quartz_block" | "create:recipes/building_blocks/layered_deepslate_from_stone_types_deepslate_stonecutting" | "minecraft:recipes/building_blocks/red_rock_brick_stairs_from_red_rock_bricks_stonecutting" | "biomeswevegone:recipes/decorations/white_mangrove_sign" | "betterdungeons:spider_dungeon" | "minecraft:recipes/decorations/anvil" | "sophisticatedstorage:recipes/misc/red_shulker_box_to_sophisticated" | "minecraft:recipes/decorations/black_candle" | "immersiveengineering:recipes/misc/crafting/conveyor_redstone" | "compressium:recipes/building_blocks/clay_6_uncraft" | "ae2:recipes/misc/tools/paintballs_lumen_red" | "create:recipes/building_blocks/small_crimsite_brick_slab_from_stone_types_crimsite_stonecutting" | "create:recipes/misc/crafting/kinetics/item_vault" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_from_honeycomb" | "justhammers:recipes/tools/diamond_destructor_hammer" | "immersiveengineering:recipes/misc/crafting/jerrycan" | "immersiveengineering:recipes/misc/crafting/toolupgrade_powerpack_antenna" | "biomeswevegone:recipes/redstone/pine_button" | "naturalist:recipes/naturalist/smooth_limestone_wall" | "buildinggadgets2:recipes/misc/gadget_exchanging" | "create:recipes/misc/crafting/materials/raw_zinc_block" | "create:recipes/building_blocks/exposed_copper_shingle_stairs" | "biomeswevegone:recipes/building_blocks/dacite_tile_slab" | "create:recipes/building_blocks/crafting/kinetics/gray_seat_from_other_seat" | "minecraft:recipes/decorations/mossy_stone_brick_wall_from_mossy_stone_brick_stonecutting" | "connectedglass:recipes/misc/scratched_glass_cyan2" | "connectedglass:recipes/misc/scratched_glass_cyan1" | "immersiveengineering:recipes/misc/crafting/stairs_alu_scaffolding_standard" | "immersiveengineering:recipes/misc/smelting/ingot_silver_from_dust_from_blasting" | "minecraft:recipes/decorations/pink_sandstone_wall_from_pink_sandstone_stonecutting" | "minecraft:recipes/decorations/loom" | "minecraft:recipes/building_blocks/deepslate_brick_stairs_from_polished_deepslate_stonecutting" | "create:recipes/building_blocks/exposed_copper_tile_stairs_from_exposed_copper_tiles_stonecutting" | "biomeswevegone:recipes/building_blocks/maple_planks" | "ae2:recipes/misc/materials/cardfuzzy" | "minecraft:recipes/tools/diamond_axe" | "minecraft:recipes/building_blocks/smooth_purple_sandstone_slab_from_purple_sandstone_stonecutting" | "compressium:recipes/building_blocks/netherite_9_uncraft" | "minecraft:recipes/building_blocks/end_stone_bricks_from_end_stone_stonecutting" | "sophisticatedstorage:recipes/misc/storage_auto_smoking_upgrade_from_backpack_auto_smoking_upgrade" | "compressium:recipes/building_blocks/copper_7_uncraft" | "minecraft:recipes/building_blocks/end_stone_brick_stairs_from_end_stone_stonecutting" | "create:recipes/misc/crafting/appliances/filter_clear" | "biomeswevegone:recipes/transportation/fir_chest_boat" | "minecraft:recipes/misc/emerald_from_blasting_deepslate_emerald_ore" | "immersiveengineering:main/craft_drop_conveyor" | "minecraft:recipes/decorations/scaffolding" | "ae2:recipes/misc/tools/paintballs_lumen_light_blue" | "yungscavebiomes:recipes/building_blocks/ancient_sandstone_stairs" | "create:recipes/building_blocks/polished_cut_calcite_stairs" | "apotheosis:spawner/root" | "buddingcrystals:recipes/misc/budding_prismarine" | "immersiveengineering:recipes/misc/crafting/treated_wood_vertical_to_slab" | "minecraft:recipes/building_blocks/cut_windswept_sandstone_from_windswept_sandstone_stonecutting" | "apotheosis:spawner/capturing" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper" | "utilitarian:recipes/misc/utility/dark_oak_logs_to_doors" | "justhammers:recipes/tools/gold_hammer" | "compressium:recipes/building_blocks/diorite_6_uncraft" | "minecraft:recipes/building_blocks/diorite_stairs" | "minecraft:recipes/building_blocks/green_terracotta" | "comforts:sleeping_bag_yellow" | "buildinggadgets2:recipes/misc/gadget_copy_paste" | "create:recipes/building_blocks/cut_granite_stairs" | "create:recipes/building_blocks/small_granite_brick_slab" | "easy_mob_farm:recipes/upgrade/filter/no_meat_filter" | "ae2:recipes/misc/network/cells/fluid_storage_cell_16k_storage" | "create:recipes/building_blocks/small_dripstone_brick_wall_from_stone_types_dripstone_stonecutting" | "biomeswevegone:recipes/redstone/ebony_trapdoor" | "create:recipes/misc/crafting/kinetics/pink_valve_handle_from_other_valve_handle" | "minecraft:recipes/misc/raw_copper" | "ae2:main/controller" | "sophisticatedstorage:recipes/misc/auto_smoking_upgrade_from_auto_smelting_upgrade" | "create:recipes/building_blocks/copper_shingle_stairs_from_copper_shingles_stonecutting" | "immersiveengineering:multiblocks/mb_metalpress" | "create:recipes/building_blocks/small_crimsite_brick_slab" | "create:recipes/misc/crafting/kinetics/gearshift" | "immersiveengineering:recipes/misc/crafting/minecart_reinforcedcrate" | "minecraft:recipes/building_blocks/mossy_stone_bricks_from_moss_block" | "connectedglass:recipes/misc/clear_glass1" | "compressium:recipes/building_blocks/soulsand_8_uncraft" | "minecraft:recipes/misc/skull_banner_pattern" | "aquaculture:recipes/misc/tin_can_to_iron_nugget" | "minecraft:recipes/decorations/allium" | "immersiveengineering:recipes/misc/crafting/wirecoil_copper_ins" | "minecraft:story/root" | "connectedglass:recipes/misc/clear_glass_purple1" | "connectedglass:recipes/misc/clear_glass_purple2" | "minecraft:recipes/building_blocks/dye_black_wool" | "create:recipes/building_blocks/tiled_glass_from_glass_colorless_stonecutting" | "compressium:recipes/building_blocks/gravel_3_uncraft" | "ae2:recipes/misc/tools/paintballs_lumen_cyan" | "immersiveengineering:recipes/misc/crafting/treated_wood_vertical_from_slab" | "domum_ornamentum:recipes/tools/purple_cobblestone_extra" | "create:recipes/building_blocks/cut_limestone_brick_slab" | "minecraft:recipes/brewing/brewing_stand" | "minecraft:recipes/root" | "biomeswevegone:recipes/transportation/aspen_chest_boat" | "minecraft:recipes/pamhc2foodcore/smelting_cookedgroundmuttonitem" | "create:recipes/building_blocks/crafting/kinetics/yellow_seat" | "minecraft:recipes/misc/quartz_from_blasting" | "minecraft:recipes/building_blocks/acacia_planks" | "create:recipes/building_blocks/industrial_iron_block_from_ingots_iron_stonecutting" | "compressium:recipes/building_blocks/endstone_2_uncraft" | "ae2:recipes/misc/misc/chests_sky_stone" | "domum_ornamentum:recipes/tools/orange_brick_extra" | "immersiveengineering:recipes/misc/crafting/sheetmetal_aluminum_to_slab" | "create:recipes/misc/crafting/appliances/slime_ball" | "ae2:recipes/misc/shaped/slabs/quartz_pillar" | "biomeswevegone:recipes/building_blocks/baobab_stairs" | "compressium:recipes/building_blocks/redstone_6_uncraft" | "dankstorage:recipes/tools/2_to_3" | "minecraft:recipes/building_blocks/pink_sandstone_slab_from_pink_sandstone_stonecutting" | "immersiveengineering:recipes/misc/crafting/hempcrete_brick_to_slab" | "minecraft:recipes/building_blocks/cracked_red_rock_brick_stairs_from_cracked_red_rock_bricks_stonecutting" | "minecraft:recipes/redstone/iron_door" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_from_honeycomb" | "immersiveengineering:recipes/misc/crafting/alu_scaffolding_grate_top_to_slab" | "domum_ornamentum:recipes/decorations/magenta_floating_carpet" | "minecraft:recipes/misc/copper_ingot_from_smelting_raw_copper" | "create:recipes/building_blocks/cut_tuff_wall_from_stone_types_tuff_stonecutting" | "minecraft:recipes/building_blocks/snow_block" | "immersiveengineering:recipes/misc/crafting/alu_scaffolding_grate_top_from_slab" | "immersiveengineering:recipes/misc/crafting/conveyor_splitter" | "repurposed_structures:ruins" | "minecraft:recipes/building_blocks/blackstone_stairs_from_blackstone_stonecutting" | "biomeswevegone:recipes/decorations/cika_hanging_sign" | "biomeswevegone:recipes/decorations/dacite_wall" | "create:recipes/building_blocks/cut_asurine_slab_recycling" | "minecraft:recipes/decorations/polished_blackstone_wall" | "create:recipes/building_blocks/cut_asurine_stairs" | "minecraft:recipes/transportation/dark_oak_boat" | "create:recipes/building_blocks/cut_asurine_brick_wall" | "minecraft:recipes/decorations/honeycomb_block" | "minecraft:recipes/building_blocks/waxed_cut_copper_stairs" | "sophisticatedstorage:recipes/misc/backpack_advanced_compacting_upgrade_from_storage_advanced_compacting_upgrade" | "utilitarian:recipes/misc/utility/dark_oak_logs_to_pressure_plates" | "mekanismgenerators:burn_the_gas" | "domum_ornamentum:recipes/decorations/purple_floating_carpet" | "woodwevegot:recipes/decorations/rainbow_eucalyptus_chest" | "aquaculture:recipes/decorations/jungle_fish_mount" | "biomeswevegone:recipes/building_blocks/cika_bookshelf" | "minecraft:recipes/misc/mojang_banner_pattern" | "create:recipes/building_blocks/crafting/copper/waxed_copper_tile_slab_from_honeycomb" | "minecraft:recipes/combat/golden_leggings" | "minecraft:recipes/redstone/piston" | "minecraft:recipes/misc/lapis_lazuli_from_smelting_lapis_ore" | "woodwevegot:recipes/decorations/fir_chest" | "biomeswevegone:recipes/decorations/mossy_stone_wall" | "woodwevegot:recipes/decorations/jacaranda_ladder" | "sophisticatedbackpacks:recipes/misc/advanced_pickup_upgrade" | "minecraft:recipes/food/cooked_beef_from_campfire_cooking" | "minecraft:recipes/pamhc2foodcore/smoking_cookedgroundmuttonitem" | "ae2:recipes/misc/network/cells/item_storage_cell_16k_storage" | "sophisticatedbackpacks:recipes/misc/iron_backpack" | "sophisticatedstorage:recipes/misc/storage_smoking_upgrade_from_backpack_smoking_upgrade" | "minecraft:recipes/decorations/polished_blackstone_brick_wall_from_polished_blackstone_stonecutting" | "biomeswevegone:recipes/decorations/dacite_brick_wall" | "immersiveengineering:recipes/misc/crafting/storage_electrum_to_ingot_electrum" | "immersiveengineering:recipes/misc/crafting/steel_scaffolding_standard_from_slab" | "biomeswevegone:biomeswevegone/husbandry/forager" | "megacells:recipes/misc/cells/standard/item_storage_cell_64m_with_housing" | "ae2:recipes/misc/tools/paintballs_green" | "biomeswevegone:recipes/building_blocks/holly_bookshelf" | "create:recipes/building_blocks/vertical_framed_glass_pane" | "megacells:recipes/misc/cells/portable/portable_fluid_cell_16m" | "mekanism:antimatter" | "compressium:recipes/building_blocks/dirt_5_uncraft" | "biomeswevegone:recipes/transportation/holly_chest_boat" | "minecraft:recipes/decorations/light_gray_stained_glass_pane" | "create:recipes/building_blocks/polished_cut_scorchia_slab_recycling" | "utilitarian:recipes/misc/utility/bamboo_logs_to_boats";
    type RecipeId = "prefab:phasic_block" | "mekanism:pigment_mixing/light_blue_red_to_magenta" | "ae2:matter_cannon/nuggets/yttrium" | "create:milling/charcoal" | "pamhc2trees:lemon_sapling" | "powah:crafting/energized_steel_block" | "immersiveengineering:crusher/ore_redstone" | "mekanism:pigment_extracting/stained_glass/brown" | "immersiveengineering:crafting/hempcrete_from_slab" | "create:milling/compat/environmental/violet" | "mekanism:enriching/conversion/mud/packed_to_bricks" | "minecraft:stonecutter" | "mekanism:compat/ilikewoodxbyg/torch/witch_hazel" | "immersiveengineering:crafting/gunpowder_from_dusts" | "minecraft:bone_block" | "botanypots:botanypots/crafting/brown_concrete_botany_pot" | "ae2:inscriber/certus_quartz_dust" | "pamhc2foodextended:applecideritem" | "pamhc2crops:stick_x4_cattail_x2" | "create:cut_granite_wall" | "minecraft:deepslate_brick_stairs_from_cobbled_deepslate_stonecutting" | "ae2:network/cells/item_storage_cell_256k_storage" | "connectedglass:scratched_glass_magenta_pane1" | "create:oak_window" | "connectedglass:scratched_glass_magenta_pane3" | "jaopca:mekanism.ore_to_clump.draconium" | "connectedglass:scratched_glass_magenta_pane2" | "mekanism:chemical_tank/basic" | "create:cut_diorite_from_stone_types_diorite_stonecutting" | "sophisticatedbackpacks:void_upgrade" | "utilitarian:utility/oak_logs_to_stairs" | "create:brass_ladder_from_ingots_brass_stonecutting" | "minecraft:dacite_tile_stairs_from_dacite_tile_stonecutting" | "pamhc2foodextended:deviledeggitem" | "minecraft:cobblestone_wall" | "minecraft:raw_copper" | "mekanism:compat/byg/sawing/boat/rainbow_eucalyptus" | "mekanism:crushing/deepslate/cracked_bricks_to_tile" | "immersiveengineering:crafting/storage_steel_from_slab" | "mekanism:module_base" | "create:splashing/endergetic/petrified_end_corrock_block" | "create:crushing/compat/elementaryores/ore_lapis_end" | "immersiveengineering:blueprint/bullet_flare_yellow" | "immersiveengineering:stonecutting/hempcrete_pillar" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/willow/painting/orange" | "mekanism:compat/ilikewood/bed/oak/painting/orange" | "minecraft:map_extending" | "minecraft:spruce_sign" | "create:cutting/compat/regions_unexplored/joshua_wood" | "torchmaster:feral_flare_lantern" | "minecraft:cut_copper_slab_from_copper_block_stonecutting" | "botanypots:minecraft/soil/netherrack" | "mekanism:compat/biomesoplenty/pigment_extracting/light_blue" | "create:crushing/raw_silver" | "sophisticatedbackpacks:advanced_refill_upgrade" | "sophisticatedstorage:copper_to_iron_tier_upgrade" | "mekanism:metallurgic_infusing/blackstone_to_gilded_blackstone" | "minecraft:glow_item_frame" | "immersiveengineering:metalpress/bullet_casing" | "minecraft:copper_block" | "create:cutting/spruce_wood" | "mekanism:compat/byg/sandstone_to_sand/white" | "immersiveengineering:crusher/red_sandstone" | "farmingforblockheads:chicken_nest" | "mekanism:pigment_extracting/terracotta/pink" | "jaopca:storage_blocks.to_material.wood" | "pamhc2foodextended:ricepuddingitem" | "minecraft:green_stained_glass" | "create:cutting/crimson_hyphae" | "mekanism:compat/ilikewood/bed/oak/black" | "immersiveengineering:crafting/sheetmetal_colored_light_gray_from_slab" | "mekanism:compat/ilikewoodxbyg/bed/lament/orange" | "create:small_veridium_brick_slab_recycling" | "minecraft:sandstone_slab_from_sandstone_stonecutting" | "pamhc2foodextended:succotashitem" | "immersiveengineering:crafting/sheetmetal_gold" | "mekanism:compat/ilikewoodxbyg/bed/ether/red" | "immersiveengineering:crafting/hammercrushing_ardite" | "draconicevolution:compress/medium_chaos_frag" | "immersiveengineering:crafting/windmill_blade" | "mekanism:processing/redstone/from_ore" | "immersiveengineering:metalpress/gear_zinc" | "biomeswevegone:willow_wood" | "minecraft:cut_sandstone_slab" | "mekanism:compat/byg/enriching/travertine/slabs_to_polished_slabs" | "biomeswevegone:ironwood_stairs" | "utilitarian:utility/gold_block_from_blasting" | "mekanism:energy_tablet" | "mekanism:compat/ilikewoodxbyg/ladder/redwood" | "biomeswevegone:green_enchanted_pressure_plate" | "mekanism:compat/byg/sawing/boat/willow" | "create:cutting/compat/blue_skies/dusk_log" | "advanced_ae:advpartenc" | "immersiveengineering:crafting/concrete_from_slab" | "mekanism:compat/ilikewoodxbyg/bed/nightshade/black" | "powah:crafting/ender_gate_spirited_2" | "apotheosis:salvaging/rare_material" | "minecraft:mojang_banner_pattern" | "create:cutting/compat/regions_unexplored/cobalt_wood" | "draconicevolution:modules/item_wyvern_damage" | "ae2:matter_cannon/nuggets/indium" | "pamhc2foodextended:saucedlambkebabitem" | "connectedglass:vanilla_light_gray_stained_glass" | "jaopca:mekanism.raw_storage_block_to_shard.zinc" | "biomeswevegone:mahogany_boat" | "minecraft:golden_hoe" | "create:cutting/stripped_warped_stem" | "mekanism:factory/basic/infusing" | "ae2:tools/misctools_charged_staff" | "utilitarian:utility/mangrove_logs_to_trapdoors" | "pamhc2foodextended:pearjellytoastitem" | "cookingforblockheads:light_gray_kitchen_floor" | "pamhc2foodextended:blackberryyogurtitem" | "aquaculture:gold_nugget_from_smelting" | "minecraft:dye_green_bed" | "pamhc2foodextended:roastpotatoesitem" | "immersiveengineering:arcfurnace/raw_ore_uranium" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/palm/yellow" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/redwood/red" | "create:crafting/kinetics/cyan_seat_from_other_seat" | "mekanism:enriching/conversion/blackstone/bricks_to_chiseled_bricks" | "mekanism:processing/copper/shard/from_raw_ore" | "mekanism:crushing/biofuel/hay_block" | "create:cutting/compat/biomesoplenty/stripped_umbran_log" | "pamhc2foodextended:eggplantparmitem" | "jaopca:mekanism.ore_to_clump.silver" | "mekanism:processing/uranium/raw_storage_blocks/from_raw" | "mekanism:pigment_extracting/terracotta/white" | "mekanism:processing/refined_glowstone/ingot_to_dust" | "mekanism:compat/byg/enriching/red_rock/slabs_to_brick_slabs" | "mekanism:compat/ilikewoodxbyg/bed/ether/cyan" | "prefab:double_compressed_obsidian" | "farmingforblockheads:market" | "mekanism:compat/ilikewood/bed/cherry/painting/light_blue" | "mekanism:compat/ilikewoodxbyg/bed/jacaranda/painting/green" | "immersiveengineering:crusher/raw_block_platinum" | "minecraft:purpur_block" | "mekanism:compat/ilikewoodxbiomesoplenty/ladder/mahogany" | "megacells:crafting/greater_energy_card" | "pamhc2foodcore:chocolateicecreamitem" | "immersiveengineering:crusher/ore_nickel" | "botanypots:immersiveengineering/crop/hemp" | "minecraft:polished_blackstone_slab" | "mekanism:painting/concrete_powder/cyan" | "create:cutting/compat/botania/dreamwood_log" | "pamhc2foodextended:cheeseontoastitem" | "mekanism:compat/ilikewood/bed/mangrove/painting/light_gray" | "botanytrees:minecraft/dark_oak" | "immersiveengineering:sawmill/mangrove_stairs" | "minecraft:gray_concrete_powder" | "powah:crafting/magmator_blazing" | "mekanism:compat/byg/sawing/pressure_plate/embur" | "mekanism:compat/biomesoplenty/sawing/door/dead" | "aquaculture:neptunium_ingot_from_blasting" | "immersiveengineering:sawmill/mangrove_log" | "mekanism:compat/ilikewood/crafting_table/spruce" | "create:crafting/kinetics/mechanical_roller" | "minecraft:redstone_from_blasting_redstone_ore" | "pamhc2foodextended:stuffedmushroomitem" | "ae2:tools/paintballs_light_blue" | "botanypots:pamhc2crops/crop/garlic" | "biomeswevegone:cracked_red_rock_brick_wall" | "mekanism:compat/ilikewoodxbyg/bed/pine/painting/blue" | "mekanism:rotary/hydrofluoric_acid" | "mekanism:crushing/biofuel/cornflower" | "create:cutting/compat/twilightforest/stripped_mangrove_wood" | "comforts:hammock_to_green" | "mekanism:compat/ilikewoodxbyg/barrel/embur" | "mekanism:crushing/biofuel/mangrove_leaves" | "minecraft:waxed_weathered_cut_copper_stairs_from_waxed_weathered_cut_copper_stonecutting" | "pamhc2foodextended:coleslawburgeritem" | "immersiveengineering:crafting/chute_steel" | "mekanism:qio_drive_supermassive" | "create:cutting/compat/byg/green_enchanted_log" | "mekanism:compat/ilikewoodxbyg/bed/palm/painting/red" | "crafting_on_a_stick:damaged_anvil" | "mekanism:injecting/concrete/gray" | "biomeswevegone:maple_planks" | "mekanism:compat/ilikewoodxbyg/bed/blue_enchanted/gray" | "mekanism:painting/concrete_powder/yellow" | "immersiveengineering:smelting/nugget_aluminum_recycle_faraday_chestplate_from_blasting" | "mekanism:compat/ilikewoodxbiomesoplenty/crafting_table/cherry" | "mekanism:crushing/deepslate/polished_slabs_to_brick" | "ae2:matter_cannon/nuggets/bismuth" | "pamhc2foodextended:hotsauceitem" | "immersiveengineering:mineral/auricupride" | "create:item_application/brass_casing_from_log" | "botanypots:pamhc2crops/crop/raspberry" | "create:splashing/light_gray_concrete_powder" | "create:cutting/compat/tconstruct/greenheart_log" | "pamhc2foodextended:chocovoxelsitem" | "pamhc2foodextended:breadfruitjellyitem" | "sophisticatedstorage:birch_barrel" | "mekanism:compat/ilikewoodxbyg/bed/bulbis/painting/magenta" | "apotheosis:salvaging/epic_material" | "immersiveengineering:crafting/blastbrick" | "mekanism:transmitter/mechanical_pipe/elite" | "mekanism:compat/ilikewoodxbyg/torch/aspen" | "create:cutting/compat/regions_unexplored/blue_bioshroom_stem" | "mekanism:fluid_tank/elite" | "create:smelting/ingot_silver_compat_ic2" | "create:crafting/kinetics/chute" | "pamhc2foodextended:honeysoyribsitem" | "botanytrees:minecraft/birch" | "create:brass_scaffolding_from_ingots_brass_stonecutting" | "create:crafting/kinetics/cyan_valve_handle_from_other_valve_handle" | "create:crafting/materials/small_rose_quartz_tilesfrom_conversion" | "mekanism:compat/ilikewood/torch/spruce" | "mekanism:processing/osmium/clump/from_raw_block" | "prefab:quartz_crete_stairs_smooth_up_right" | "compressium:quartz_8_uncraft" | "pamhc2trees:candlenut_sapling" | "biomeswevegone:dacite_cobblestone_wall" | "mekanism:sawing/log/mangrove" | "botanypots:botanypots/crafting/red_concrete_hopper_botany_pot" | "create:polished_cut_asurine_stairs" | "pamhc2foodextended:cookedtofishitem_smoker" | "mekanism:compat/ilikewood/bed/acacia/white" | "botanytrees:biomeswevegone/yellow_birch" | "mekanism:compat/ilikewood/bed/dark_oak/gray" | "create:crafting/kinetics/fluid_tank" | "create:cutting/compat/blue_skies/stripped_maple_log" | "create:smoking/bread" | "pamhc2foodextended:pecanpieitem" | "immersiveengineering:crusher/raw_block_silver" | "biomeswevegone:chiseled_red_rock_brick_slab" | "create:cutting/compat/blue_skies/starlit_log" | "pamhc2foodcore:friesitem" | "minecraft:orange_stained_glass_pane_from_glass_pane" | "mekanism:dosimeter" | "mekanism:crushing/biofuel/melon_slice" | "connectedglass:clear_glass_light_blue2" | "connectedglass:clear_glass_light_blue1" | "pamhc2foodextended:juniperberryjuiceitem" | "mekanism:sawing/hanging_sign/cherry" | "mekanism:compat/ilikewood/post/bamboo" | "sophisticatedstorage:storage_output" | "mekanism:compat/byg/sawing/boat/maple" | "mekanism:painting/concrete/orange" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/dead/painting/green" | "create:cutting/compat/blue_skies/maple_log" | "mekanism:compat/ilikewoodxbyg/lectern/cherry" | "mekanism:pigment_extracting/stained_glass_pane/green" | "botanypots:botanypots/crafting/orange_glazed_terracotta_compact_hopper_botany_pot" | "mekanism:painting/bed/light_gray" | "megacells:cells/portable/portable_fluid_cell_4m" | "minecraft:iron_ingot_from_nuggets" | "minecraft:golden_pickaxe" | "create:cutting/compat/byg/stripped_lament_log" | "jaopca:storage_blocks.to_material.hop_graphite" | "create:filling/compat/regions_unexplored/silt_grass_block" | "apotheosis:fletching/broadhead_arrow" | "create:deploying/waxed_copper_tile_stairs_from_adding_wax" | "yungscavebiomes:layered_ancient_sandstone" | "pamhc2crops:papyrusseeditem" | "create:filling/builders_tea" | "create:milling/compat/botania/yellow_petal" | "minecraft:redstone_torch" | "powah:crafting/nitro_crystal_block" | "immersiveengineering:crafting/storage_lead_from_slab" | "pamhc2foodcore:tool_grinder" | "botanypots:minecraft/crop/sugar_cane" | "apotheosis:reforging_table" | "pamhc2foodextended:greengrapejellysandwichitem" | "create:small_tuff_brick_stairs" | "mekanism:sawing/bed/red" | "sophisticatedstorage:backpack_stack_upgrade_starter_tier_from_storage_stack_upgrade_tier_1_plus" | "create:crafting/kinetics/deployer" | "mekanism:pigment_extracting/stained_glass_pane/white" | "minecraft:gray_bed" | "create:crafting/materials/andesite_alloy" | "pamhc2foodcore:melonjuiceitem" | "minecraft:white_terracotta" | "pamhc2crops:cottonseeditem" | "pamhc2foodextended:rambutansmoothieitem" | "mekanism:supercharged_coil" | "minecraft:armor_stand" | "create_sa:copper_exoskeleton_recipe" | "minecraft:pink_stained_glass_pane" | "mekanism:compat/ilikewoodxbyg/bed/imparius/cyan" | "pamhc2foodcore:glowberryjuiceitem" | "fulleng:block_requester_terminal_from_part" | "compressium:clay_5_uncraft" | "pamhc2crops:asparagusseeditem" | "minecraft:blue_dye_from_cornflower" | "mekanism:compat/ilikewoodxbyg/chest/witch_hazel" | "mekanism:compat/ilikewoodxbiomesoplenty/crafting_table/palm" | "immersiveengineering:blueprint/banner_windmill" | "sophisticatedbackpacks:chipped/alchemy_bench_upgrade" | "ae2:network/parts/panels_monitor" | "prefab:compressed_glowstone_to_glowstone" | "pamhc2crops:roastedgarlicitem_forge" | "minecraft:brown_banner" | "mekanism:processing/osmium/shard/from_crystal" | "minecraft:warped_hyphae" | "megacells:cells/portable/portable_fluid_cell_1m" | "mekanism:induction/cell/basic" | "create:cutting/compat/biomesoplenty/redwood_wood" | "botanytrees:pamhc2trees/soursop_sapling" | "mekanism:rotary/sulfuric_acid" | "create:cutting/compat/regions_unexplored/stripped_mauve_log" | "immersiveengineering:cloche/nether_wart" | "pamhc2crops:roastedleekitem_smoker" | "sophisticatedstorage:storage_smoking_upgrade_from_backpack_smoking_upgrade" | "minecraft:chiseled_red_rock_brick_slab_from_chiseled_red_rock_bricks_stonecutting" | "create:crimsite_pillar_from_stone_types_crimsite_stonecutting" | "botanypots:minecraft/soil/deepslate_gold_ore" | "ae2:shaped/stairs/chiseled_quartz_block" | "comforts:sleeping_bag_to_yellow" | "createaddition:compat/immersiveengineering/item_application/kiln_brick" | "draconicevolution:tools/wyvern_chestpiece" | "mekanism:compat/ilikewood/bed/mangrove/brown" | "mekanism:compat/ilikewoodxbyg/bed/jacaranda/painting/white" | "prefab:bunch_of_beets_from_crate" | "revampedwolf:iron_wolf_armor" | "minecraft:green_bed" | "mekanism:compat/ilikewoodxbyg/bed/redwood/orange" | "minecraft:red_sandstone_slab_from_red_sandstone_stonecutting" | "pamhc2foodextended:tatertotsitem" | "immersiveengineering:crusher/ore_coal" | "create:small_deepslate_brick_wall_from_stone_types_deepslate_stonecutting" | "mekanism:processing/gold/ore/deepslate_from_raw" | "prefab:nether_gate" | "ae2:tools/paintballs_red" | "botanypots:minecraft/soil/dried_kelp" | "connectedglass:borderless_glass_magenta_pane2" | "connectedglass:borderless_glass_magenta_pane3" | "minecraft:cut_black_sandstone_slab_from_black_sandstone_stonecutting" | "minecraft:prismarine_brick_slab_from_prismarine_stonecutting" | "minecraft:chiseled_purple_sandstone_from_purple_sandstone_stonecutting" | "mekanism:pigment_extracting/terracotta/light_gray" | "create:crushing/silver_ore" | "connectedglass:borderless_glass_magenta_pane1" | "minecraft:mossy_red_rock_brick_wall_from_mossy_red_rock_bricks_stonecutting" | "minecraft:waxed_oxidized_cut_copper_stairs_from_waxed_oxidized_cut_copper_stonecutting" | "create:cutting/stripped_acacia_log" | "minecraft:gray_banner" | "minecraft:warped_stairs" | "biomeswevegone:cypress_crafting_table" | "compressium:snow_2_uncraft" | "botanypots:minecraft/soil/nether_quartz_ore" | "pamhc2trees:roastedwalnuttitem_smoker" | "create:splashing/orange_concrete_powder" | "create:crushing/compat/silentgems/peridot_ore" | "ae2:network/cells/fluid_storage_cell_16k_storage" | "ae2:tools/paintballs_gray" | "prefab:triple_compressed_stone_from_double_compressed_stone" | "pamhc2crops:roastedleekitem_forge" | "minecraft:smooth_sandstone_slab" | "prefab:lanterns_to_string_of_lanterns" | "mekanism:compat/ilikewoodxbyg/composter/embur" | "pamhc2crops:jicamaseeditem" | "mekanism:compat/ilikewoodxbyg/bed/sythian/black" | "pamhc2foodextended:lemonlimesodaitem" | "pamhc2foodextended:manjuuitem" | "mekanism:compat/ilikewoodxbyg/bed/jacaranda/painting/light_blue" | "immersiveengineering:smelting/ingot_electrum_from_dust" | "mekanism:compat/byg/sawing/door/rainbow_eucalyptus" | "minecraft:rail" | "botanytrees:pamhc2trees/paperbark_sapling" | "immersiveengineering:crafting/sword_steel" | "powah:crafting/ender_gate_hardened_2" | "mekanism:transmitter/pressurized_tube/advanced" | "apotheosis:spawner/baby" | "create:cutting/compat/ars_nouveau/red_archwood_wood" | "ae2:network/cells/fluid_storage_cell_256k" | "cookingforblockheads:dye_white_oven" | "create:milling/compat/biomesoplenty/rose" | "pamhc2foodextended:phoitem" | "yungscavebiomes:brittle_red_sandstone" | "mekanism:processing/bronze/ingot/from_infusing" | "mekanism:crushing/biofuel/beetroot_seeds" | "mekanism:processing/emerald/to_deepslate_ore" | "botanypots:botanypots/crafting/magenta_concrete_botany_pot" | "botanytrees:biomeswevegone/white_mangrove" | "mekanism:compat/ilikewood/bed/dark_oak/brown" | "immersiveengineering:crafting/toolbox" | "sophisticatedstorage:spruce_limited_barrel_3" | "easy_mob_farm:mob_farm/bee_hive_farm/tier3_bee_hive_farm" | "sophisticatedstorage:spruce_limited_barrel_2" | "sophisticatedstorage:spruce_limited_barrel_1" | "pamhc2foodextended:sweetberryjellysandwichitem" | "biomeswevegone:baobab_boat" | "draconicevolution:machines/draconium_chest" | "sophisticatedstorage:spruce_limited_barrel_4" | "mekanism:compat/ilikewoodxbyg/bed/willow/pink" | "immersiveengineering:crafting/sheetmetal_colored_magenta_from_slab" | "immersiveengineering:metalpress/rod_tungsten" | "minecraft:polished_blackstone_from_blackstone_stonecutting" | "mekanism:compat/ilikewoodxbyg/chest/cherry" | "mekanism:compat/ilikewoodxbyg/composter/cika" | "mekanism:compat/ilikewoodxbyg/bed/pine/green" | "mekanism:pigment_extracting/stained_glass/light_blue" | "sophisticatedstorage:storage_dye" | "mekanism:processing/gold/slurry/dirty/from_ore" | "pamhc2foodextended:lycheejellysandwichitem" | "pamhc2trees:peach_sapling" | "createaddition:rolling/aluminum_plate" | "mekanism:compat/byg/crushing/soapstone/from_polished" | "mekanism:module_vein_mining_unit" | "mekanismgenerators:solar_panel" | "minecraft:crimson_planks" | "minecraft:smooth_red_sandstone" | "mekanism:compat/ilikewoodxbiomesoplenty/panel/palm" | "powah:crafting/energizing_rod_starter" | "mekanism:compat/ilikewoodxbyg/bed/embur/gray" | "ae2:network/cells/item_storage_cell_16k_storage" | "mekanism:processing/uranium/ingot/from_raw_smelting" | "pamhc2foodextended:guavajellyitem" | "mekanismtools:bronze/armor/helmet" | "biomeswevegone:redwood_fence_gate" | "pamhc2foodextended:sunflowerbroccolisaladitem" | "minecraft:iron_nugget_from_blasting" | "mekanism:sawing/pressure_plate/spruce" | "powah:crafting/ender_cell_niotic_2" | "create:cutting/mangrove_wood" | "create:cutting/compat/regions_unexplored/stripped_blue_bioshroom_hyphae" | "pamhc2foodextended:cantaloupeyogurtitem" | "create:milling/azure_bluet" | "mekanism:compat/ilikewoodxbyg/wall/fir" | "sophisticatedstorage:backpack_feeding_upgrade_from_storage_feeding_upgrade" | "mekanism:induction/cell/advanced" | "ae2:matter_cannon/nuggets/cerium" | "minecraft:green_stained_glass_pane" | "minecraft:black_concrete_powder" | "mekanism:compat/ilikewoodxbyg/chest/cika" | "jaopca:create.material_to_plate.silver" | "mekanism:compat/ilikewoodxbyg/ladder/maple" | "biomeswevegone:blue_sandstone_stairs" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/cherry/painting/pink" | "pamhc2foodextended:gritsitem" | "connectedglass:scratched_glass_black2" | "connectedglass:scratched_glass_black1" | "mekanism:compat/ilikewoodxbyg/composter/cherry" | "mekanismgenerators:generator/heat" | "minecraft:quartz_pillar" | "biomeswevegone:green_enchanted_hanging_sign" | "minecraft:smooth_white_sandstone_stairs_from_white_sandstone_stonecutting" | "create:deploying/waxed_copper_shingles_from_adding_wax" | "ae2:tools/certus_quartz_pickaxe" | "minecraft:dye_red_wool" | "cookingforblockheads:kitchen_corner" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/mahogany/painting/yellow" | "aquaculture:stone_fillet_knife" | "mekanism:compat/ilikewoodxbyg/bed/palm/brown" | "compressium:soulsand_7_uncraft" | "mekanism:compat/ilikewoodxbyg/bed/nightshade/painting/cyan" | "compressium:diamond_7_uncraft" | "sophisticatedstorage:gold_to_netherite_tier_upgrade" | "minecraft:blue_dye" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/cherry/light_gray" | "draconicevolution:compress/draconium_ingot" | "minecraft:polished_diorite_slab_from_polished_diorite_stonecutting" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/hellbark/painting/black" | "mekanism:compat/ilikewood/bed/cherry/orange" | "create:cutting/compat/regions_unexplored/blackwood_wood" | "ae2:matter_cannon/nuggets/bromine" | "mekanismgenerators:rotary/tritium" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/fir/pink" | "mekanism:crushing/stone/bricks_to_cracked_bricks" | "createoreexcavation:sample_drill" | "create:cutting/compat/regions_unexplored/magnolia_wood" | "mekanism:painting/bed/cyan" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/dead/black" | "mekanism:compat/ilikewoodxbyg/item_frame/aspen" | "minecraft:wooden_axe" | "connectedglass:borderless_glass_light_gray2" | "pamhc2foodcore:glowberryjellytoastitem" | "advanced_ae:quantum_storage_component" | "connectedglass:borderless_glass_light_gray1" | "powah:crafting/energy_cell_basic" | "immersiveengineering:crafting/sheetmetal_colored_red_from_slab" | "immersiveengineering:crafting/blastbrick_reinforced" | "mekanism:processing/uranium/dust/from_dirty_dust" | "ae2:decorative/light_detector" | "create:small_limestone_brick_slab_from_stone_types_limestone_stonecutting" | "create:smelting/ingot_silver_compat_immersiveengineering" | "create:oak_window_pane" | "minecraft:stone_stairs_from_stone_stonecutting" | "mekanism:compat/ilikewoodxbiomesoplenty/crafting_table/redwood" | "create:polished_cut_ochrum_stairs_from_stone_types_ochrum_stonecutting" | "mekanism:sawing/hanging_sign/warped" | "mekanism:compat/ilikewoodxbyg/bed/sythian/painting/white" | "mekanism:chemical_infuser" | "jaopca:create.material_to_plate.zinc" | "immersiveengineering:blueprint/mold_unpacking" | "mekanism:metallurgic_infusing/sand_to_dirt" | "minecraft:dried_kelp" | "apotheosis:spawner/no_ai" | "create:andesite_from_stone_types_andesite_stonecutting" | "minecraft:iron_bars" | "elevatorid:elevator_orange" | "mekanism:compat/ilikewoodxbyg/bed/jacaranda/painting/purple" | "pamhc2foodextended:driedsoupitem" | "pamhc2foodextended:mochicakeitem" | "pamhc2crops:bakedwaterchestnutitem_smoker" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/jacaranda/orange" | "immersiveengineering:crafting/sheetmetal_uranium" | "mekanism:compat/ilikewoodxbyg/bed/green_enchanted/painting/black" | "mekanism:compat/byg/pigment_extracting/purple" | "create_sa:copper_pickaxe_recipe" | "mekanism:sawing/log/acacia" | "mekanism:compat/ilikewoodxbyg/bed/aspen/light_blue" | "mekanism:compat/ilikewoodxbyg/bed/jacaranda/light_blue" | "pamhc2foodextended:gooseberryjuiceitem" | "pamhc2foodextended:juniperberrypieitem" | "prefab:bundle_of_timber_to_logs" | "mekanism:compat/ilikewoodxbyg/bed/zelkova/painting/pink" | "pamhc2foodextended:papayayogurtitem" | "mekanism:compat/ilikewoodxbyg/chest/blue_enchanted" | "create:splashing/purple_concrete_powder" | "mekanism:crushing/biofuel/spruce_sapling" | "mekanism:pigment_extracting/concrete_powder/yellow" | "mekanism:compat/ilikewoodxbyg/bed/baobab/painting/cyan" | "mekanism:compat/ilikewood/bed/spruce/painting/light_blue" | "biomeswevegone:willow_fence_gate" | "utilitarian:utility/spruce_logs_to_pressure_plates" | "compressium:sand_5_uncraft" | "create:crafting/curiosities/minecart_coupling" | "botanytrees:pamhc2trees/chestnut_sapling" | "create:cut_deepslate_brick_slab" | "jaopca:mekanism.material_to_dust.fluix" | "mekanism:crushing/dewax/exposed_cut_copper_stairs" | "pamhc2foodextended:creamedbroccolisoupitem" | "create:cut_granite_stairs_from_stone_types_granite_stonecutting" | "pamhc2foodextended:fishfingersandcustarditem" | "botanytrees:biomeswevegone/fir" | "prefab:compressed_obsidian_from_double_compressed_obsidian" | "create:crushing/compat/byg/emeraldite_ore" | "mekanism:compat/ilikewoodxbiomesoplenty/item_frame/mahogany" | "minecraft:mud_brick_wall_from_mud_bricks_stonecutting" | "create:milling/wheat" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/cherry/painting/red" | "create:polished_cut_diorite_slab_from_stone_types_diorite_stonecutting" | "mekanism:compat/ilikewood/bed/acacia/painting/pink" | "create:compacting/honey" | "megacells:cells/standard/mana_storage_cell_256m_with_housing" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/magic/painting/cyan" | "pamhc2foodextended:fishdinneritem" | "create:milling/compat/botania/light_gray_petal" | "jaopca:mekanism.ore_to_dust.nickel" | "mekanism:compat/byg/sawing/fence_gate/cika" | "pamhc2foodextended:porkrindsitem" | "create:cutting/compat/blue_skies/stripped_starlit_wood" | "ae2:misc/chests_sky_stone" | "create_sa:vault_component_recipe" | "create:milling/grass" | "mekanism:processing/lategame/plutonium" | "create:splashing/ic2/crushed_raw_uranium" | "mekanism:compat/ilikewoodxbyg/bed/pine/painting/brown" | "botanypots:botanypots/crafting/light_gray_concrete_hopper_botany_pot" | "jaopca:mekanism.material_to_dust.zinc" | "immersiveengineering:crafting/sheetmetal_colored_white_to_slab" | "pamhc2foodextended:meatfeastpizzaitem" | "jaopca:storage_blocks.to_material.sulfur" | "elevatorid:redye_orange" | "mekanismgenerators:reactor/logic_adapter" | "minecraft:smoking_roastedsunflowerseedsitem" | "minecraft:deepslate_tile_stairs_from_deepslate_tiles_stonecutting" | "immersiveengineering:crafting/ingot_aluminum_to_nugget_aluminum" | "pamhc2foodextended:pineapplepieitem" | "immersiveengineering:thermoelectric/snow" | "mekanism:compat/ilikewoodxbyg/bed/white_mangrove/painting/cyan" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/hellbark/yellow" | "pamhc2foodextended:mangosmoothieitem" | "powah:energizing/uraninite_from_ore_dense" | "botanypots:botanypots/crafting/light_blue_glazed_terracotta_botany_pot" | "mekanism:compat/ilikewoodxbyg/bed/ebony/painting/cyan" | "megacells:cells/cell_component_1m" | "mekanism:metallurgic_infusing/mossy/stone_brick_slab" | "mekanism:compat/ilikewood/bed/jungle/yellow" | "botanypots:minecraft/crop/melon" | "minecraft:torch" | "mekanism:compat/ilikewoodxbyg/bed/cypress/painting/black" | "ae2:matter_cannon/nuggets/titanium" | "pamhc2foodextended:pineappleupsidedowncakeitem" | "botanypots:minecraft/crop/pumpkin" | "create:crafting/kinetics/black_seat" | "mekanism:painting/wool/purple" | "create:cutting/compat/biomesoplenty/stripped_jacaranda_log" | "create:milling/allium" | "createoreexcavation:drilling/nether_gold" | "pamhc2foodextended:peachcobbleritem" | "prefab:grass_slab_reverse" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/mahogany/painting/gray" | "immersiveengineering:stonecutting/concrete_three_quarter" | "createaddition:charging/weathered_copper_shingles" | "pamhc2foodextended:hamandpineapplepizzaitem" | "immersiveengineering:crafting/jerrycan" | "mekanism:compat/byg/enriching/dacite/brick_stairs_to_tile_stairs" | "create:crafting/copper/waxed_oxidized_copper_shingles_from_honeycomb" | "immersiveengineering:crafting/toolupgrade_shield_flash" | "create:cutting/compat/twilightforest/canopy_wood" | "pamhc2foodextended:dragonfruityogurtitem" | "mekanism:compat/ilikewoodxbyg/torch/bulbis" | "sophisticatedstorage:iron_barrel" | "minecraft:cherry_slab" | "create:cutting/stripped_warped_hyphae" | "biomeswevegone:maple_boat" | "mekanism:processing/uranium/sulfuric_acid" | "mekanism:compat/biomesoplenty/sawing/chest_boat/fir" | "mekanism:compat/byg/sawing/log/cika" | "mekanism:compat/ilikewoodxbyg/bed/witch_hazel/light_gray" | "create:milling/clay" | "immersiveengineering:smelting/ingot_steel_from_dust_from_blasting" | "pamhc2foodextended:misopasteitem" | "megacells:cells/cell_component_4m" | "mekanism:painting/candle/black" | "comforts:sleeping_bag_brown" | "immersiveengineering:crafting/toolupgrade_powerpack_magnet" | "immersiveengineering:crafting/cloche" | "cookingforblockheads:dye_blue_oven" | "domum_ornamentum:panel_vertical_bars" | "mekanism:bin/basic" | "mekanism:compat/ilikewoodxbyg/lectern/maple" | "sophisticatedstorage:stack_upgrade_tier_1" | "minecraft:orange_bed" | "mekanism:qio_drive_base" | "sophisticatedstorage:stack_upgrade_tier_2" | "sophisticatedstorage:stack_upgrade_tier_3" | "draconicevolution:modules/item_draconic_proj_accuracy" | "create:milling/compat/atmospheric/hot_monkey_brush" | "mekanism:painting/glass_pane/purple" | "sophisticatedstorage:stack_upgrade_tier_4" | "ae2:network/cells/item_storage_cell_16k" | "sophisticatedstorage:stack_upgrade_tier_5" | "sophisticatedstorage:orange_shulker_box_to_sophisticated" | "create:filling/glowstone" | "mekanism:compat/ilikewoodxbyg/wall/aspen" | "immersiveengineering:arcfurnace/ore_nickel" | "biomeswevegone:black_sandstone_slab" | "create:cutting/compat/atmospheric/stripped_morado_wood" | "mekanism:sawing/hanging_sign/jungle" | "draconicevolution:tools/dislocator" | "mekanism:compat/byg/sawing/door/ether" | "biomeswevegone:palm_bookshelf" | "minecraft:red_stained_glass_pane" | "mekanism:compat/ilikewoodxbyg/bed/embur/painting/white" | "create:cutting/compat/byg/stripped_green_enchanted_wood" | "create:splashing/gravel" | "pamhc2foodextended:fiestacornsaladitem" | "mekanism:compat/ilikewoodxbiomesoplenty/soul_torch/fir" | "mekanism:compat/ilikewoodxbyg/bed/mahogany/orange" | "create:crafting/kinetics/andesite_door" | "create:cutting/compat/biomesoplenty/stripped_fir_log" | "biomeswevegone:stripped_aspen_wood" | "mekanism:compat/byg/sawing/fence_gate/green_enchanted" | "easy_mob_farm:upgrade/enhancement/luck_enhancement" | "mekanism:processing/osmium/nugget/from_ingot" | "mekanism:sawing/chest_boat/jungle" | "immersiveengineering:crusher/ingot_silver" | "immersiveengineering:sawmill/stripped_spruce_log" | "minecraft:dark_oak_planks" | "aquaculture:neptunium_hoe" | "minecraft:granite_wall" | "mekanism:compat/ilikewoodxbyg/lectern/jacaranda" | "create:crushing/raw_lead_block" | "biomeswevegone:cut_black_sandstone_slab" | "create:cutting/compat/regions_unexplored/willow_wood" | "mekanism:pigment_extracting/wool/green" | "biomeswevegone:blue_enchanted_door" | "mekanism:compat/ilikewood/bed/spruce/black" | "mekanism:compat/ilikewood/bed/oak/magenta" | "mekanism:pigment_extracting/candle/yellow" | "pamhc2trees:spiderweb_sapling" | "mekanism:compat/ilikewoodxbyg/barrel/maple" | "minecraft:mossy_cobblestone_slab_from_mossy_cobblestone_stonecutting" | "minecraft:warped_fence" | "immersiveengineering:mineral/cooled_lava_tube" | "createaddition:compat/tconstruct/hepatizon" | "mekanism:pigment_extracting/dye/light_blue" | "sophisticatedstorage:storage_stonecutter_upgrade_from_backpack_stonecutter_upgrade" | "pamhc2crops:cloudberryseeditem" | "connectedglass:borderless_glass_lime_pane1" | "mekanismtools:bronze/shield" | "biomeswevegone:fir_crafting_table" | "connectedglass:borderless_glass_lime_pane3" | "botanypots:minecraft/crop/kelp" | "connectedglass:borderless_glass_lime_pane2" | "mekanism:compat/ilikewoodxbyg/bed/zelkova/painting/green" | "pamhc2crops:yuccaseeditem" | "apotheosis:filtering_shelf" | "apotheosis:reforging/uncommon" | "mekanism:compat/ilikewoodxbyg/bed/aspen/cyan" | "mekanism:crushing/biofuel/moss_block" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/hellbark/painting/yellow" | "immersiveengineering:crafting/armor_steel_helmet" | "mekanism:sawing/trapdoor/birch" | "mekanism:infusion_conversion/gold/from_dust" | "easy_mob_farm:mob_farm/monster_plains_cave/tier2_monster_plains_cave_farm" | "minecraft:loom" | "mekanism:crushing/biofuel/rose_bush" | "mekanism:energy_conversion/redstone_block" | "pamhc2foodcore:batteritem_x2" | "create:smelting/copper_ingot_from_crushed" | "pamhc2foodextended:coffeeconlecheitem" | "mekanism:crushing/mud_bricks_to_packed" | "pamhc2foodextended:vanillaconchasbreaditem" | "biomeswevegone:aspen_hanging_sign" | "mekanism:compat/byg/sawing/door/baobab" | "domum_ornamentum:red_brick_extra" | "sophisticatedstorage:limited_iron_barrel_2_from_limited_copper_barrel_2" | "create:small_calcite_brick_stairs" | "create:cutting/cherry_wood" | "easy_mob_farm:mob_farm/ocean_farm/tier1_ocean_farm" | "mekanism:compat/ilikewoodxbiomesoplenty/ladder/umbran" | "easy_mob_farm:mob_farm/iron_golem_farm/tier3_iron_golem_farm" | "compressium:netherrack_7_uncraft" | "biomeswevegone:sakura_fence" | "mekanism:compat/ilikewoodxbyg/bed/green_enchanted/painting/magenta" | "sophisticatedstorage:storage_crafting_upgrade_from_backpack_crafting_upgrade" | "friendsandfoes:copper_button" | "botanypots:snad/soil/soul_snad" | "mekanism:compat/ilikewoodxbyg/bed/green_enchanted/green" | "draconicevolution:modules/module_core" | "biomeswevegone:pine_slab" | "immersiveengineering:sawmill/mangrove_slab" | "mekanism:compat/ilikewoodxbyg/post/willow" | "mekanism:crushing/biofuel/kelp" | "biomeswevegone:green_enchanted_trapdoor" | "mekanism:processing/bronze/ingot/from_block" | "mekanism:compat/ilikewoodxbyg/bed/aspen/purple" | "pamhc2foodextended:springrollitem" | "immersiveengineering:sawmill/crimson_log" | "immersiveengineering:metalpress/rod_constantan" | "minecraft:polished_blackstone" | "immersiveengineering:crafting/toolupgrade_drill_damage" | "utilitarian:utility/spruce_logs_to_stairs" | "sophisticatedstorage:storage_advanced_void_upgrade_from_backpack_advanced_void_upgrade" | "biomeswevegone:holly_planks" | "mekanism:rotary/hydrogen_chloride" | "mekanismgenerators:saturating_condenser" | "mekanism:compat/ilikewoodxbyg/bed/redwood/light_blue" | "mekanism:compat/ilikewoodxbyg/bed/maple/painting/pink" | "mekanism:compat/ilikewoodxbyg/crafting_table/bulbis" | "compressium:netherite_5_uncraft" | "sophisticatedstorage:light_blue_shulker_box_to_sophisticated" | "mekanism:compat/ilikewoodxbyg/bed/skyris/painting/orange" | "mekanism:compat/ilikewoodxbyg/ladder/embur" | "botanypots:minecraft/crop/sweet_berry_bush" | "jaopca:mekanism.raw_material_to_clump.nickel" | "biomeswevegone:stripped_ironwood_wood" | "botanytrees:pamhc2trees/maple_sapling" | "botanypots:pamhc2crops/crop/juniperberry" | "biomeswevegone:aspen_wood" | "buddingcrystals:budding_electrum" | "minecraft:dye_purple_carpet" | "jaopca:mekanism.ore_to_dirty_slurry.zinc" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/umbran/painting/green" | "biomeswevegone:redwood_sign" | "compressium:clay_1" | "compressium:clay_2" | "compressium:clay_3" | "compressium:clay_4" | "compressium:clay_5" | "megacells:cells/portable/portable_item_cell_64m" | "compressium:clay_6" | "compressium:clay_7" | "compressium:clay_8" | "mekanism:compat/ilikewoodxbyg/panel/cypress" | "compressium:clay_9" | "ae2:tools/nether_quartz_pickaxe" | "botanypots:pamhc2crops/crop/spiceleaf" | "biomeswevegone:yellow_dye_from_bwg_tag" | "compressium:lapis_3_uncraft" | "mekanism:compat/byg/sawing/log/holly" | "pamhc2foodextended:cactusfruitjellysandwichitem" | "mekanism:compat/ilikewoodxbyg/bed/lament/painting/red" | "minecraft:deepslate_brick_slab" | "domum_ornamentum:side_framed_horizontal" | "ae2wtlib:pattern_access/wireless_pattern_access_terminal" | "pamhc2foodextended:curryitem" | "minecraft:polished_blackstone_brick_stairs_from_blackstone_stonecutting" | "naturalist:cut_shellstone_slab_from_stonecutting" | "powah:energizing/blazing_crystal_2" | "powah:crafting/thermo_generator_niotic" | "jaopca:storage_blocks.to_material.prismarine" | "mekanism:compat/ilikewoodxbyg/post/zelkova" | "pamhc2foodextended:tamarindjellytoastitem" | "apotheosis:spawner/spawn_range" | "immersiveengineering:crafting/storage_steel_to_slab" | "mekanism:compat/ilikewoodxbyg/bed/fir/painting/black" | "mekanism:compat/ilikewoodxbyg/bed/pine/painting/lime" | "immersiveengineering:metalpress/rod_cobalt" | "create:milling/compat/byg/cyan_rose" | "utilitarian:utility/acacia_logs_to_boats" | "apotheosis:augmenting_table" | "storagenetwork:request_expanded" | "compressium:quartz_1_uncraft" | "ae2:tools/paintballs_purple" | "mekanism:crushing/deepslate/from_chiseled" | "sophisticatedbackpacks:compacting_upgrade" | "create:milling/compat/byg/fairy_slipper" | "mekanism:compat/ilikewoodxbyg/bed/imparius/yellow" | "mekanism:compat/ilikewoodxbyg/bed/imparius/magenta" | "botanypots:botanypots/crafting/magenta_glazed_terracotta_botany_pot" | "create:cut_crimsite_from_stone_types_crimsite_stonecutting" | "mekanism:compat/biomesoplenty/sawing/fence_gate/umbran" | "mekanism:compat/ilikewood/bed/jungle/gray" | "create:layered_granite_from_stone_types_granite_stonecutting" | "megacells:cells/standard/fluid_storage_cell_256m" | "biomeswevegone:palm_sign" | "immersiveengineering:mineral/ancient_debris" | "minecraft:acacia_sign" | "minecraft:chest_minecart" | "mekanism:compat/ilikewood/composter/bamboo" | "immersiveengineering:crafting/sheetmetal_gold_from_slab" | "mekanism:compat/ilikewoodxbyg/bed/fir/orange" | "pamhc2foodextended:biscuititem" | "create:crafting/logistics/brass_funnel" | "minecraft:baked_potato_from_campfire_cooking" | "mekanism:compat/ilikewoodxbiomesoplenty/composter/willow" | "pamhc2foodextended:blackberryjellytoastitem" | "biomeswevegone:blue_enchanted_fence" | "create:compacting/ice" | "mekanism:pigment_extracting/wool/white" | "pamhc2foodextended:steakandchipsitem" | "immersiveengineering:metalpress/plate_silver" | "minecraft:deepslate_bricks_from_polished_deepslate_stonecutting" | "pamhc2foodextended:persimmonsmoothieitem" | "mekanism:compat/ilikewood/chest/acacia" | "immersiveengineering:sawmill/cherry_wood" | "mekanism:enriching/conversion/deepslate/from_cobbled" | "pamhc2foodextended:hotandsoursoupitem" | "mekanism:compat/ilikewood/bed/birch/painting/black" | "create:crushing/amethyst_block" | "pamhc2foodextended:dandelionteaitem" | "immersiveengineering:mixer_potion_list" | "mekanism:compat/farmersdelight/sawing/cod_slice" | "compressium:cobblestone_5_uncraft" | "mekanism:compat/ilikewoodxbyg/post/cherry" | "mekanism:compat/biomesoplenty/pigment_extracting/yellow" | "createaddition:liquid_burning/compat/thermal/heavy_oil" | "ae2:misc/deconstruction_certus_quartz_bricks" | "minecraft:rose_petal_block" | "immersiveengineering:crafting/ingot_steel_to_storage_steel" | "create:crafting/logistics/display_link" | "biomeswevegone:red_rock_slab" | "yungscavebiomes:ancient_sandstone_wall_from_stonecutting" | "jaopca:mekanism.clean_slurry_to_crystal.zinc" | "megacells:cells/portable/portable_mana_cell_256m" | "mekanism:compat/ilikewood/bed/jungle/red" | "megacells:cells/standard/fluid_storage_cell_64m" | "woodwevegot:aspen_barrel" | "sophisticatedstorage:chipped/loom_table_upgrade" | "draconicevolution:modules/item_draconic_shield_recovery" | "minecraft:red_stained_glass_pane_from_glass_pane" | "minecraft:waxed_cut_copper_stairs_from_waxed_copper_block_stonecutting" | "botanytrees:pamhc2trees/peppercorn_sapling" | "create:splashing/thermal/crushed_raw_nickel" | "mekanism:compat/ilikewood/bed/oak/orange" | "create:crushing/osmium_ore" | "advanced_ae:largeappupgrade" | "mekanism:compat/ae2/decorative/sky_stone/enriching/brick_stairs_to_small_brick_stairs" | "create:milling/compat/regions_unexplored/hibiscus" | "mekanism:processing/osmium/ore/from_raw" | "minecraft:polished_diorite_stairs_from_polished_diorite_stonecutting" | "botanypots:botanypots/crafting/red_glazed_terracotta_hopper_botany_pot" | "sophisticatedbackpacks:advanced_restock_upgrade" | "create:framed_glass_from_glass_colorless_stonecutting" | "mekanism:compat/byg/metallurgic_infusing/red_rock/red_rock_brick" | "mekanism:enriching/conversion/andesite/stairs_to_polished_stairs" | "minecraft:warped_sign" | "mekanism:compat/ilikewoodxbyg/composter/maple" | "mekanism:compat/byg/sawing/log/jacaranda" | "sophisticatedstorage:cyan_shulker_box_to_sophisticated" | "immersiveengineering:crafting/concrete_pillar" | "prefab:double_compressed_stone_to_compressed_stone" | "mekanism:combining/dye/magenta" | "mekanism:crushing/blackstone/polished_stairs_to_stairs" | "pamhc2foodcore:chocolatebaconitem" | "createaddition:crafting/rolling_mill" | "mekanism:compat/byg/sawing/fence_gate/rainbow_eucalyptus" | "biomeswevegone:stripped_rainbow_eucalyptus_wood" | "minecraft:bamboo_sign" | "utilitarian:no_soliciting/soliciting_carpets/pink_soliciting_carpet" | "pamhc2foodextended:peachsmoothieitem" | "mekanism:compat/ilikewood/torch/mangrove" | "mekanism:processing/lapis_lazuli/to_ore" | "pamhc2trees:roastedhazelnutitem_forge" | "mekanism:crushing/blackstone/chiseled_bricks_to_bricks" | "jaopca:mekanism.raw_material_to_dirty_slurry.zinc" | "create:crafting/kinetics/spout" | "yungscavebiomes:ancient_sandstone" | "mekanism:fuelwood_heater" | "botanytrees:pamhc2trees/papaya_sapling" | "mekanism:pigment_extracting/carpet/cyan" | "pamhc2foodcore:applesauceitem" | "create:haunting/soul_torch" | "sophisticatedstorage:iron_chest" | "aquaculture:gold_fillet_knife" | "create:splashing/blue_concrete_powder" | "pamhc2foodextended:plumpieitem" | "botanypots:pamhc2crops/crop/calabash" | "create:copper_scaffolding_from_ingots_copper_stonecutting" | "mekanism:compat/ilikewood/bed/acacia/yellow" | "ae2:network/cables/dense_smart_cyan" | "biomeswevegone:skyris_planks" | "botanypots:minecraft/soil/dark_oak_wood" | "minecraft:lime_glazed_terracotta" | "create:cut_scoria_brick_slab_recycling" | "prefab:quartz_crete" | "pamhc2foodextended:grapefruitjellysandwichitem" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/magic/light_blue" | "create:cutting/compat/byg/fir_log" | "buddingcrystals:crystal_catalyst" | "create:cut_calcite_brick_wall" | "immersiveengineering:crafting/sheetmetal_colored_orange_from_slab" | "mekanism:compat/biomesoplenty/sawing/trapdoor/willow" | "mekanism:compat/ilikewoodxbyg/bed/zelkova/painting/white" | "friendsandfoes:waxed_exposed_lightning_rod_from_honeycomb" | "jaopca:mekanism.ore_to_dirty_slurry.draconium" | "apotheosis:sigil_of_enhancement" | "create:crushing/compat/silentgems/citrine_ore" | "mekanism:nucleosynthesizing/heart_of_the_sea" | "botanypots:botanypots/crafting/gray_concrete_hopper_botany_pot" | "mekanism:enriching/enriched/carbon" | "create:milling/compat/regions_unexplored/blue_lupine" | "create:crafting/kinetics/framed_glass_trapdoor" | "createoreexcavation:ore_vein_type/nether_gold" | "prefab:aqua_base" | "create:cut_asurine_brick_wall_from_stone_types_asurine_stonecutting" | "sophisticatedstorage:oak_barrel" | "mekanism:compat/byg/sawing/fence_gate/zelkova" | "mekanism:compat/ilikewoodxbyg/bed/sythian/painting/green" | "domum_ornamentum:beige_stone_bricks" | "create:crushing/compat/druidcraft/amber_ore" | "pamhc2foodextended:papayajuiceitem" | "pamhc2foodextended:cornflakesitem" | "botanypots:botanypots/crafting/orange_concrete_hopper_botany_pot" | "createoreexcavation:ore_vein_type/netherite" | "jaopca:mekanism.material_to_default_ore.silver" | "create:milling/compat/byg/allium_flower_bush" | "mekanism:painting/bed/purple" | "mekanism:compat/ilikewoodxbyg/bed/fir/painting/light_gray" | "farmingforblockheads:green_fertilizer" | "botanytrees:pamhc2trees/pinenut_sapling" | "biomeswevegone:rainbow_eucalyptus_bookshelf" | "pamhc2foodextended:breadfruitjellysandwichitem" | "mekanism:injecting/brick_to_clay_ball" | "create:cutting/compat/blue_skies/stripped_lunar_wood" | "immersiveengineering:smelting/ingot_constantan_from_dust" | "mekanism:processing/gold/crystal/from_slurry" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/jacaranda/painting/lime" | "mekanism:processing/lead/slurry/dirty/from_raw_ore" | "create:milling/lilac" | "mekanism:sawing/boat/oak" | "createaddition:charging/exposed_copper" | "sophisticatedstorage:upgrade_base" | "minecraft:iron_block" | "immersiveengineering:cloche/cactus" | "mekanism:compat/ilikewoodxbyg/bed/redwood/painting/blue" | "minecraft:dark_oak_door" | "mekanism:module_frost_walker_unit" | "mekanism:pigment_extracting/dye/gray" | "mekanism:compat/byg/crushing/dacite/tile_to_brick" | "create:cutting/compat/the_vault/stripped_chromatic_log" | "mekanism:sawing/log/crimson" | "connectedglass:borderless_glass_gray_pane1" | "connectedglass:borderless_glass_gray_pane2" | "connectedglass:borderless_glass_gray_pane3" | "draconicevolution:decompress/draconium_nugget" | "mekanism:pigment_extracting/carpet/red" | "mekanism:processing/copper/crystal/from_slurry" | "ae2:matter_cannon/nuggets/technetium" | "create:cutting/compat/regions_unexplored/stripped_maple_log" | "domum_ornamentum:center_light" | "biomeswevegone:dacite_slab" | "immersiveengineering:crafting/insulating_glass_from_slab" | "jaopca:mekanism.ore_to_dirty_slurry.aluminum" | "mekanism:compat/ilikewood/bed/cherry/pink" | "pamhc2foodcore:caramelitem" | "utilitarian:utility/acacia_logs_to_stairs" | "mekanism:crushing/cobblestone_to_gravel" | "create:exposed_copper_tile_stairs_from_exposed_copper_tiles_stonecutting" | "megacells:cells/standard/mana_storage_cell_1m_with_housing" | "mekanism:painting/banner/orange" | "mekanism:compat/ilikewood/bed/acacia/pink" | "draconicevolution:modules/item_wyvern_aqua_adapt" | "create:cutting/compat/twilightforest/transformation_wood" | "biomeswevegone:stripped_palo_verde_wood" | "create:milling/compat/byg/amaranth" | "create:cutting/compat/environmental/cherry_log" | "immersiveengineering:fertilizer/slag" | "create:crafting/materials/rose_quartz" | "create:crushing/compat/neapolitan/ice" | "compressium:andesite_5_uncraft" | "minecraft:copper_ingot_from_blasting_deepslate_copper_ore" | "comforts:hammock_to_gray" | "mekanism:bin_insert" | "pamhc2foodextended:cookedtofeakitem_smoker" | "pamhc2foodextended:croissantitem" | "buddingcrystals:budding_hopgraphite" | "megacells:crafting/mega_energy_cell" | "ae2:matter_cannon/nuggets/phosphorus" | "ae2:matter_cannon/nuggets/electrum" | "mekanismgenerators:generator/solar" | "immersiveengineering:metalpress/gear_platinum" | "minecraft:golden_boots" | "waystones:mossy_waystone" | "minecraft:pink_dye_from_red_white_dye" | "mekanism:compat/ilikewoodxbyg/bed/zelkova/gray" | "minecraft:cut_black_sandstone_slab_from_cut_black_sandstone_stonecutting" | "create:cutting/compat/regions_unexplored/stripped_joshua_wood" | "justhammers:netherite_impact_hammer" | "immersiveengineering:arcfurnace/dust_gold" | "mekanism:structural_glass" | "mekanism:compat/ilikewood/bed/birch/painting/brown" | "immersiveengineering:smelting/nugget_aluminum_recycle_faraday_boots_from_blasting" | "botanypots:minecraft/crop/crimson_fungus" | "pamhc2crops:bakedtaroitem_campfire" | "pamhc2foodextended:cashewchickenitem" | "pamhc2foodextended:cottagepieitem" | "immersiveengineering:metalpress/wire_electrum" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/magic/magenta" | "sophisticatedstorage:storage_advanced_feeding_upgrade_from_backpack_advanced_feeding_upgrade" | "waystones:waystone" | "minecraft:cherry_planks" | "naturalist:smooth_shellstone_slab" | "botanypots:pamhc2crops/crop/barrelcactus" | "minecraft:nether_brick_wall_from_nether_bricks_stonecutting" | "minecraft:oxidized_cut_copper_slab_from_oxidized_cut_copper_stonecutting" | "pamhc2crops:coffeebeanseeditem" | "minecraft:silence_armor_trim_smithing_template" | "pamhc2crops:slimeball_aloe" | "minecraft:smooth_red_sandstone_slab_from_smooth_red_sandstone_stonecutting" | "biomeswevegone:chiseled_pink_sandstone" | "domum_ornamentum:post_heavy" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/jacaranda/painting/orange" | "create:crushing/nether_gold_ore" | "dimstorage:dimensional_tablet" | "immersiveengineering:arcfurnace/netherite_scrap" | "mekanism:sawing/ladder" | "immersiveengineering:crafting/sheetmetal_constantan_from_slab" | "mekanism:pigment_extracting/concrete/pink" | "mekanism:compat/ilikewoodxbyg/bed/baobab/pink" | "mekanism:compat/ilikewood/bed/warped/painting/black" | "mekanism:crushing/biofuel/shroomlight" | "immersiveengineering:crafting/rs_engineering" | "ae2:inscriber/logic_processor_press" | "mekanism:compat/farmersdelight/sawing/salmon_slice" | "pamhc2foodextended:mixedflowerssaladitem" | "mekanism:compat/ilikewoodxbiomesoplenty/wall/palm" | "mekanism:crushing/biofuel/orange_tulip" | "create:filling/honeyed_apple" | "utilitarian:utility/birch_slab_to_block" | "minecraft:budding_amethyst" | "pamhc2foodextended:elderberryjuiceitem" | "create:crushing/deepslate_zinc_ore" | "mekanism:enriching/charcoal" | "mekanism:enriching/deoxidizing/weathered_copper" | "ae2:network/cables/smart_red" | "createaddition:crafting/modular_accumulator_gold" | "minecraft:light_blue_concrete_powder" | "pamhc2foodextended:tamarindsmoothieitem" | "mekanism:processing/refined_glowstone/ingot/from_dust" | "immersiveengineering:crafting/storage_uranium_to_slab" | "minecraft:granite_stairs" | "prefab:compressed_obsidian_to_obsidian" | "mekanism:compat/farmersdelight/sawing/chicken_cuts" | "create:small_deepslate_brick_slab" | "create:haunting/infested_chiseled_stone_bricks" | "mekanism:crushing/deepslate/tile_to_cracked_tile" | "create:oxidized_copper_tile_stairs_from_oxidized_copper_tiles_stonecutting" | "mekanism:processing/uranium/shard/from_raw_block" | "botanypots:pamhc2crops/crop/guarana" | "mekanism:factory/basic/smelting" | "mekanism:compat/byg/sawing/trapdoor/cika" | "mekanism:compat/ilikewoodxbyg/ladder/witch_hazel" | "advanced_ae:smalladvpatpropart" | "mekanism:crushing/biofuel/sweet_berries" | "mekanism:compat/ilikewoodxbyg/crafting_table/nightshade" | "mekanism:compat/biomesoplenty/sawing/pressure_plate/redwood" | "compressium:emerald_2_uncraft" | "minecraft:smooth_blue_sandstone_stairs_from_blue_sandstone_stonecutting" | "compressium:cobblestone_8_uncraft" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/umbran/painting/light_blue" | "createaddition:mixing/netherrack" | "sophisticatedstorage:crafting_upgrade" | "compressium:redsand_8_uncraft" | "create:cutting/compat/tconstruct/skyroot_wood" | "mekanism:compat/ilikewood/bed/jungle/pink" | "elevatorid:redye_magenta" | "mekanism:compat/byg/sawing/door/fir" | "minecraft:dye_orange_wool" | "mekanism:rotary/superheated_sodium" | "mekanism:compat/ilikewood/bed/crimson/brown" | "immersiveengineering:crafting/storage_nickel_to_slab" | "mekanism:processing/copper/slurry/clean" | "immersiveengineering:smelting/nugget_aluminum_recycle_faraday_leggings_from_blasting" | "mekanism:compat/byg/crushing/scoria/slabs_to_cobblestone_slabs" | "immersiveengineering:smelting/nugget_steel_recycle_steel_chestplate_from_blasting" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/jacaranda/painting/blue" | "mekanism:compat/ilikewood/bed/dark_oak/painting/brown" | "create:cutting/compat/biomesoplenty/magic_log" | "mekanism:compat/ilikewoodxbyg/chest/sythian" | "pamhc2foodextended:chickencelerycasseroleitem" | "botanypots:minecraft/soil/mycelium" | "pamhc2foodcore:cookingoilitem_x2_nuts" | "immersiveengineering:arcfurnace/ore_silver" | "mekanism:compat/ilikewoodxbyg/bed/mahogany/red" | "prefab:ender_gateway" | "mekanism:compat/ilikewoodxbiomesoplenty/panel/hellbark" | "toolbelt:pouch_upgrade_1_via_sewing" | "immersiveengineering:crusher/amethyst" | "create:cutting/compat/atmospheric/yucca_log" | "minecraft:cyan_banner" | "ae2:network/cables/smart_fluix" | "connectedglass:vanilla_red_stained_glass_pane" | "create:veridium_from_stone_types_veridium_stonecutting" | "create:crafting/materials/copper_nugget" | "mekanism:enriching/dye/large_red" | "pamhc2crops:guaranaseeditem" | "mekanism:compat/ilikewoodxbyg/bed/redwood/painting/lime" | "pamhc2foodextended:neapolitanicecreamitem" | "mekanism:crushing/quartz/chiseled_to_pillar" | "create:crafting/kinetics/gray_seat" | "jaopca:immersiveengineering.material_to_dust.draconium_awakened" | "utilitarian:utility/cherry_slab_to_block" | "biomeswevegone:holly_chest_boat" | "create:crafting/materials/zinc_ingot_from_decompacting" | "minecraft:dye_yellow_wool" | "minecraft:magenta_carpet" | "create:crafting/kinetics/contraption_controls" | "draconicevolution:modules/item_chaotic_proj_accuracy" | "mekanism:crushing/dewax/weathered_cut_copper" | "create:cutting/compat/regions_unexplored/stripped_baobab_log" | "mekanism:painting/glass/brown" | "mekanism:enriching/dye/large_yellow" | "mekanism:painting/wool/brown" | "mekanism:compat/ilikewood/bed/crimson/red" | "create:small_diorite_brick_wall" | "pamhc2foodextended:pinacoladaitem" | "biomeswevegone:green_enchanted_chest_boat" | "mekanism:compat/byg/pigment_extracting/light_blue" | "sophisticatedstorage:mangrove_chest" | "aeinfinitybooster:dimension_card" | "minecraft:lectern" | "create:cutting/compat/byg/redwood_log" | "mekanism:crushing/dewax/exposed_cut_copper" | "pamhc2foodextended:deluxecheeseburgeritem" | "create:cut_andesite_brick_wall" | "immersiveengineering:metalpress/gear_constantan" | "mekanism:compat/ilikewoodxbyg/bed/embur/painting/green" | "sophisticatedstorage:bamboo_chest_from_quark_bamboo_chest" | "compressium:obsidian_7_uncraft" | "mekanism:compat/ilikewood/bed/warped/yellow" | "minecraft:smooth_stone_slab" | "mekanism:compat/ilikewoodxbyg/bed/jacaranda/purple" | "pamhc2foodcore:jellybeansitem" | "mekanism:crushing/biofuel/baked_potato" | "create:milling/beetroot" | "mekanism:compat/biomesoplenty/pigment_extracting/red" | "create:crushing/raw_aluminum_block" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/fir/painting/purple" | "immersiveengineering:crafting/sheetmetal_silver_from_slab" | "megacells:cells/standard/chemical_storage_cell_64m" | "immersiveengineering:metalpress/gear_brass" | "pamhc2foodextended:spaghettidinneritem" | "mekanism:module_farming_unit" | "minecraft:mossy_cobblestone_from_vine" | "aquaculture:heavy_hook" | "botanypots:pamhc2crops/crop/wolfberry" | "fulleng:terminals/block_terminal_from_part" | "mekanism:sps_casing" | "pamhc2foodextended:chocolatecoconutbaritem" | "mekanism:processing/fluorite/from_block" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/dead/painting/white" | "immersiveengineering:crafting/metal_barrel" | "mekanism:compat/byg/sawing/chest_boat/aspen" | "pamhc2foodextended:honeybunitem" | "create:cutting/compat/tconstruct/bloodshroom_wood" | "connectedglass:scratched_glass_pink2" | "mekanism:compat/ilikewoodxbyg/bed/witch_hazel/painting/cyan" | "connectedglass:scratched_glass_pink1" | "utilitarian:snad/soul_snad" | "create:small_andesite_brick_wall" | "justhammers:reinforced_core" | "create:crafting/kinetics/adjustable_chain_gearshift" | "advanced_ae:import_export_bus" | "compressium:copper_5_uncraft" | "immersiveengineering:crafting/ingot_lead_to_nugget_lead" | "compressium:gravel_1_uncraft" | "pamhc2foodextended:grapejellysandwichitem" | "biomeswevegone:fir_door" | "powah:crafting/magmator_basic" | "create:smelting/glass_from_framed_glass" | "aquaculture:turtle_soup" | "mekanism:compat/ilikewoodxbyg/wall/embur" | "createaddition:crafting/portable_energy_interface" | "justhammers:gold_destructor_hammer" | "ae2:shaped/walls/quartz_block" | "mekanism:nuggets/refined_glowstone" | "immersiveengineering:crafting/connector_hv" | "mekanism:injecting/oxidizing/oxidized_cut_copper_slab" | "ae2:network/blocks/energy_energy_acceptor_alt" | "mekanism:compat/ilikewood/bed/bamboo/painting/light_gray" | "woodwevegot:ironwood_ladder" | "minecraft:dark_prismarine_slab_from_dark_prismarine_stonecutting" | "mekanismgenerators:fission_reactor/casing" | "buddingcrystals:budding_fluix" | "create:cutting/compat/twilightforest/stripped_time_log" | "mekanism:compat/ilikewood/bed/spruce/brown" | "aquaculture:fishing_line" | "immersiveengineering:crafting/storage_steel_to_ingot_steel" | "comforts:hammock_to_red" | "create:oxidized_copper_shingle_stairs" | "minecraft:smelting_cookedgroundchickenitem" | "create:pressing/compat/betterendforge/pink_moss_path" | "mekanism:compat/ilikewood/bed/mangrove/painting/cyan" | "createaddition:crushing/diamond" | "create_sa:dead_horn_coral_revive" | "aquaculture:neptunium_nugget" | "powah:crafting/cable_nitro_2" | "immersiveengineering:crafting/storage_nickel_from_slab" | "minecraft:pink_concrete_powder" | "ae2:tools/nether_quartz_cutting_knife" | "jaopca:storage_blocks.to_material.salt" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/umbran/painting/white" | "pamhc2crops:bakedjicamaitem_smoker" | "immersiveengineering:crafting/alu_fence" | "mekanism:compat/ilikewoodxbyg/bed/blue_enchanted/pink" | "minecraft:andesite_wall" | "botanypots:pamhc2crops/crop/cabbage" | "minecraft:smooth_pink_sandstone_stairs_from_pink_sandstone_stonecutting" | "minecraft:raiser_armor_trim_smithing_template_smithing_trim" | "megacells:cells/standard/chemical_storage_cell_1m" | "utilitarian:utility/jungle_logs_to_stairs" | "mekanism:compat/ilikewoodxbyg/bed/embur/painting/light_gray" | "mekanism:compat/ilikewoodxbyg/torch/white_mangrove" | "powah:crafting/capacitor_basic_tiny" | "mekanismtools:refined_obsidian/tools/sword" | "pamhc2crops:bakedrutabagaitem_campfire" | "prefab:compressed_quartz_crete_to_quartz_crete" | "createoreexcavation:drilling/glowstone" | "mekanism:compat/ilikewoodxbyg/bed/maple/painting/magenta" | "biomeswevegone:cut_white_sandstone" | "immersiveengineering:metalpress/gear_steel" | "immersiveengineering:blueprint/component_electronic" | "mekanism:compat/ilikewood/wall/spruce" | "mekanism:pigment_extracting/flower/large_cyan" | "create:cutting/compat/autumnity/maple_wood" | "biomeswevegone:cypress_button" | "utilitarian:utility/spruce_logs_to_boats" | "immersiveengineering:crafting/connector_lv" | "mekanism:compat/byg/crushing/scoria/walls_to_cobblestone_walls" | "botanypots:minecraft/pot_interaction/till_coarse_dirt_to_dirt" | "mekanism:enriching/conversion/mossy/cobblestone" | "mekanism:compat/ilikewoodxbyg/bed/blue_enchanted/painting/black" | "create:milling/compat/environmental/red_hibiscus" | "create:weathered_copper_tile_stairs" | "connectedglass:clear_glass_lime2" | "draconicevolution:tools/advanced_magnet" | "connectedglass:clear_glass_lime1" | "mekanism:compat/ilikewoodxbyg/bed/fir/lime" | "draconicevolution:components/draconium_core" | "create:crafting/kinetics/smart_fluid_pipe" | "ae2:blasting/silicon_from_certus_quartz_dust" | "pamhc2crops:cauliflowerseeditem" | "compressium:gravel_8_uncraft" | "botanypots:botanypots/crafting/pink_terracotta_botany_pot" | "mekanism:compat/ilikewoodxbyg/bed/nightshade/painting/brown" | "pamhc2foodextended:strawberryjellytoastitem" | "botanytrees:biomeswevegone/ebony" | "create:polished_cut_veridium_from_stone_types_veridium_stonecutting" | "biomeswevegone:pink_dye_from_bwg_tag" | "mekanism:compat/ilikewoodxbyg/bed/imparius/painting/light_blue" | "connectedglass:vanilla_green_stained_glass" | "create:filling/compat/vampirism/cursed_grass" | "comforts:sleeping_bag_purple" | "minecraft:brown_glazed_terracotta" | "mekanism:compat/ilikewoodxbiomesoplenty/torch/redwood" | "create_sa:copper_chestplate_recipe" | "mekanism:sawing/bed/light_blue" | "powah:crafting/ender_gate_hardened" | "mekanism:bin/advanced" | "create:cut_scoria_wall" | "botanypots:botanypots/crafting/light_blue_concrete_compact_hopper_botany_pot" | "minecraft:warped_trapdoor" | "mekanism:compat/byg/sawing/door/lament" | "ae2:network/parts/annihilation_plane_alt2" | "immersiveengineering:arcfurnace/ore_lead" | "create:crafting/kinetics/fluid_pipe_vertical" | "ae2:network/cells/spatial_components" | "create:crafting/kinetics/lime_valve_handle_from_other_valve_handle" | "create:crafting/kinetics/mechanical_arm" | "create:cutting/compat/byg/fir_wood" | "naturalist:cut_shellstone" | "storagenetwork:inventory" | "botanypots:botanypots/crafting/blue_concrete_compact_hopper_botany_pot" | "mekanism:processing/refined_glowstone/ingot/from_block" | "mekanism:pigment_extracting/banner/gray" | "create:milling/compat/byg/peach_leather_flower" | "pamhc2foodextended:persimmonjellytoastitem" | "create:cut_diorite_bricks_from_stone_types_diorite_stonecutting" | "yungscavebiomes:glass_from_ancient_sand" | "elevatorid:redye_white" | "mekanism:compat/ilikewoodxbiomesoplenty/soul_torch/redwood" | "mekanism:compat/ilikewoodxbyg/bed/cypress/black" | "mekanism:compat/ilikewoodxbyg/soul_torch/cypress" | "botanytrees:biomeswevegone/yellow_sakura" | "mekanism:compat/biomesoplenty/sawing/hanging_sign/willow" | "mekanism:processing/gold/slurry/clean" | "mekanism:compat/ilikewoodxbyg/bed/cypress/painting/pink" | "create:cut_diorite_stairs" | "utilitarian:utility/oak_slab_to_block" | "mekanism:compat/ae2/decorative/certus_quartz/crushing/pillar_slab_to_slab" | "mekanism:compat/ilikewood/bed/mangrove/painting/orange" | "create:crushing/deepslate_lapis_ore" | "mekanism:compat/ilikewoodxbyg/bed/fir/blue" | "ae2:decorative/certus_quartz_bricks" | "immersiveengineering:crafting/breaker_switch" | "biomeswevegone:windswept_sandstone_wall" | "mekanism:compat/byg/sawing/chest_boat/jacaranda" | "minecraft:light_gray_dye_from_azure_bluet" | "easy_mob_farm:upgrade/filter/no_meat_filter" | "mekanism:compat/ilikewoodxbyg/lectern/willow" | "botanypots:minecraft/soil/andesite" | "mekanism:compat/byg/dye/yellow" | "powah:crafting/furnator_niotic" | "minecraft:magenta_candle" | "mekanism:compat/ilikewoodxbyg/bed/willow/gray" | "create:milling/compat/byg/crocus" | "connectedglass:scratched_glass_orange1" | "create:pressing/compat/betterendforge/end_myclium_path" | "mekanism:processing/tin/ingot/from_ore_blasting" | "sophisticatedstorage:limited_gold_barrel_1" | "sophisticatedstorage:limited_gold_barrel_2" | "sophisticatedstorage:limited_gold_barrel_3" | "sophisticatedstorage:limited_gold_barrel_4" | "connectedglass:scratched_glass_orange2" | "create:crushing/compat/silentgems/moldavite_ore" | "jaopca:mekanism.dust_to_material.prismarine" | "pamhc2crops:artichokeseeditem" | "easy_mob_farm:mob_farm/animal_plains_farm/tier3_animal_plains_farm" | "create:crushing/compat/galosphere/amethyst" | "pamhc2foodextended:grapejellyitem" | "jaopca:storage_blocks.to_material.fluix" | "mekanism:compat/biomesoplenty/sawing/boat/palm" | "mekanism:processing/uranium/nugget/from_ingot" | "create:splashing/stained_glass" | "sophisticatedbackpacks:advanced_tool_swapper_upgrade" | "create:cutting/compat/biomesoplenty/umbran_log" | "mekanism:dye_base" | "immersiveengineering:arcfurnace/dust_brass" | "powah:energizing/niotic_crystal" | "create:crafting/kinetics/large_water_wheel" | "mekanism:processing/iron/clump/from_raw_ore" | "immersiveengineering:crafting/connector_mv" | "create:polished_cut_limestone_stairs_from_stone_types_limestone_stonecutting" | "immersiveengineering:metalpress/gear_silver" | "mekanism:compat/ilikewoodxbiomesoplenty/ladder/magic" | "draconicevolution:tools/p2p_dislocator_unbound" | "createaddition:compat/immersiveengineering/item_application/reinforced_blast_brick" | "draconicevolution:components/awakened_core" | "create:milling/compat/regions_unexplored/light_gray_snowbelle" | "mekanism:compat/ilikewoodxbyg/bed/embur/brown" | "botanypots:pamhc2crops/crop/nopales" | "create:smelting/lead_ingot_compat_oreganized" | "biomeswevegone:cut_purple_sandstone" | "minecraft:note_block" | "mekanism:compat/ae2/decorative/certus_quartz/enriching/chiseled_block_to_block" | "botanypots:pamhc2crops/crop/cauliflower" | "mekanism:enriching/conversion/deepslate/chiseled_to_cracked_tile" | "immersiveengineering:metalpress/wire_manyullyn" | "mekanism:compat/ilikewoodxbyg/bed/green_enchanted/painting/pink" | "mekanism:compat/ilikewoodxbyg/barrel/bulbis" | "botanypots:minecraft/crop/cocoa_beans" | "create:cutting/compat/regions_unexplored/stripped_blackwood_log" | "woodwevegot:baobab_chest" | "ae2:tools/nether_quartz_axe" | "minecraft:weathered_cut_copper_slab_from_weathered_copper_stonecutting" | "minecraft:end_crystal" | "prefab:bundle_of_timber" | "minecraft:shulker_box" | "jaopca:mekanism.material_to_dust.constantan" | "sophisticatedstorage:advanced_feeding_upgrade" | "mekanism:compat/ilikewood/bed/cherry/painting/black" | "apotheosis:library" | "ae2:network/cables/covered_blue" | "minecraft:white_carpet" | "mekanism:compat/ilikewood/bed/jungle/brown" | "biomeswevegone:stripped_fir_wood" | "mekanism:injecting/coral/tube_coral_block" | "minecraft:mossy_cobblestone_stairs_from_mossy_cobblestone_stonecutting" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/mahogany/painting/pink" | "pamhc2foodextended:batteredsausageitem" | "create:cutting/compat/regions_unexplored/green_bioshroom_hyphae" | "advanced_ae:reach_card" | "biomeswevegone:baobab_chest_boat" | "create:blasting/nickel_ingot_compat_thermal" | "mekanism:painting/glass_pane/red" | "pamhc2foodextended:rawtofaconitem" | "dimstorage:dim_wall" | "sophisticatedstorage:iron_to_diamond_tier_upgrade" | "minecraft:magenta_stained_glass" | "botanypots:pamhc2crops/crop/sweetpotato" | "draconicevolution:machines/grinder" | "mekanism:compat/ilikewoodxbyg/soul_torch/aspen" | "minecraft:iron_trapdoor" | "pamhc2crops:roastedrhubarbitem_campfire" | "pamhc2foodextended:raisinsitem" | "aquaculture:jellyfish_to_slimeball" | "mekanism:pigment_extracting/concrete_powder/white" | "mekanism:combining/dye/black_to_light_gray" | "mekanism:compat/byg/enriching/ether/to_carved" | "draconicevolution:tools/draconic_sword" | "createaddition:rolling/brass_ingot" | "minecraft:acacia_pressure_plate" | "biomeswevegone:palm_trapdoor" | "create:cutting/compat/byg/stripped_maple_wood" | "apotheosis:enchanting/potion_charm_enchanting" | "mekanism:compat/ae2/decorative/sky_stone/crushing/brick_wall_to_smooth_wall" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/dead/painting/lime" | "pamhc2foodextended:picklesitem" | "createaddition:charging/copper_shingle_stairs" | "minecraft:deepslate_brick_stairs_from_deepslate_bricks_stonecutting" | "botanypots:botanypots/crafting/yellow_concrete_botany_pot" | "mekanism:compat/ilikewood/bed/birch/painting/cyan" | "easy_mob_farm:mob_farm/nether_fortress_farm/tier3_nether_fortress_farm" | "create:filling/compat/farmersdelight/milk_bottle" | "compressium:redstone_3_uncraft" | "mekanism:compat/byg/sawing/chest_boat/willow" | "create:cut_asurine_brick_stairs" | "mekanism:compat/ilikewoodxbyg/bed/skyris/orange" | "minecraft:shulker_box_from_vanilla_shulker_box" | "easy_mob_farm:mob_farm/jungle_farm/tier1_jungle_farm" | "minecraft:polished_andesite_slab_from_polished_andesite_stonecutting" | "create:crushing/compat/simplefarming/oat" | "ae2:network/cables/covered_lime" | "biomeswevegone:white_mangrove_button" | "immersiveengineering:smelting/ingot_aluminum_from_blasting2" | "mekanism:compat/ilikewood/bed/jungle/light_blue" | "mekanism:compat/ilikewoodxbyg/torch/baobab" | "mekanism:painting/wool/blue" | "immersiveengineering:smelting/ingot_aluminum_from_blasting3" | "create:crafting/kinetics/gearshift" | "mekanism:compat/ilikewoodxbyg/bed/zelkova/painting/yellow" | "mekanism:compat/ilikewoodxbiomesoplenty/composter/hellbark" | "mekanism:compat/byg/pigment_extracting/green" | "utilitarian:no_soliciting/soliciting_carpets/cyan_soliciting_carpet" | "mekanism:compat/ilikewoodxbyg/bed/imparius/painting/purple" | "create:crushing/crimsite" | "utilitarian:utility/dark_oak_logs_to_doors" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/hellbark/painting/brown" | "biomeswevegone:pine_sign" | "buddingcrystals:budding_bronze" | "botanypots:pamhc2crops/crop/millet" | "minecraft:chiseled_pink_sandstone_from_pink_sandstone_stonecutting" | "mekanism:compat/byg/crushing/travertine/polished_slabs_to_slabs" | "apotheosis:rectifier" | "create:cutting/compat/ars_nouveau/green_archwood_log" | "mekanism:compat/ilikewoodxbyg/bed/holly/green" | "powah:crafting/player_tranmitter_blazing" | "minecraft:lime_banner" | "pamhc2foodextended:beansontoastitem" | "aquaculture:tackle_box" | "yungscavebiomes:brittle_ancient_sandstone" | "minecraft:deepslate_brick_wall_from_cobbled_deepslate_stonecutting" | "cookingforblockheads:dye_magenta_oven" | "create:polished_cut_andesite_wall" | "minecraft:cut_copper_from_copper_block_stonecutting" | "create:cutting/compat/biomesoplenty/fir_log" | "create:cutting/compat/biomesoplenty/stripped_hellbark_log" | "draconicevolution:entity_detector" | "biomeswevegone:cika_slab" | "immersiveengineering:crafting/plate_silver_hammering" | "mekanism:compat/ilikewoodxbyg/wall/redwood" | "biomeswevegone:skyris_fence_gate" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/dead/painting/blue" | "minecraft:dacite_bricks_from_dacite_stonecutting" | "mekanism:crushing/prismarine/shard_from_slabs" | "botanypots:minecraft/pot_interaction/till_farmland" | "compressium:redsand_1_uncraft" | "immersiveengineering:crafting/storage_constantan_to_slab" | "revampedwolf:leather_wolf_armor" | "create:cutting/compat/upgrade_aquatic/stripped_river_wood" | "compressium:stone_8" | "compressium:stone_7" | "compressium:stone_6" | "compressium:stone_5" | "compressium:stone_4" | "compressium:stone_3" | "compressium:stone_2" | "compressium:stone_1" | "storagenetwork:operation_upgrade" | "mekanism:compat/ae2/decorative/certus_quartz/enriching/block_to_pillar" | "create_jetpack:jetpack" | "storagenetwork:collector_remote" | "mekanism:enriching/clay_ball" | "mekanism:compat/ilikewood/bed/warped/painting/cyan" | "immersiveengineering:crafting/turntable" | "minecraft:crimson_sign" | "mekanism:painting/wool/lime" | "create:crafting/copper/waxed_copper_shingles_from_honeycomb" | "minecraft:stone_brick_slab" | "mekanism:gas_conversion/sulfur_to_sulfuric_acid" | "mekanism:compat/ilikewoodxbyg/bed/green_enchanted/painting/purple" | "create:cutting/compat/byg/palo_verde_wood" | "biomeswevegone:florus_planks" | "mekanism:compat/ilikewoodxbyg/bed/jacaranda/green" | "pamhc2trees:hazelnut_sapling" | "compressium:stone_9" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/willow/green" | "create:small_andesite_brick_stairs" | "ae2:network/cables/glass_lime" | "create:cutting/compat/regions_unexplored/baobab_wood" | "pamhc2foodextended:cactussoupitem" | "create:milling/compat/ae2/sky_stone_block" | "minecraft:stone_slab_from_stone_stonecutting" | "immersiveengineering:mixer/herbicide" | "mekanism:compat/byg/crushing/travertine/chiseled_to_polished" | "mekanism:enriching/dye/blue" | "minecraft:gray_glazed_terracotta" | "woodwevegot:white_mangrove_barrel" | "immersiveengineering:crafting/treated_wood_packaged_to_slab" | "botanypots:pamhc2crops/crop/spinach" | "create:cut_calcite_wall" | "ae2:misc/deconstruction_chiseled_certus_quartz" | "ae2:matter_cannon/nuggets/boron" | "friendsandfoes:warped_beehive" | "immersiveengineering:crusher/slag" | "create:crimson_window_pane" | "mekanism:compat/byg/metallurgic_infusing/mossy_stone/stone_slab" | "mekanism:compat/ilikewood/bed/acacia/painting/gray" | "mekanism:compat/ilikewood/bed/warped/light_blue" | "create:cutting/birch_log" | "easy_mob_farm:mob_farm/swamp_farm/tier1_swamp_farm" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/dead/red" | "comforts:sleeping_bag_to_light_blue" | "mekanism:compat/byg/sawing/pressure_plate/cika" | "immersiveengineering:arcfurnace/dust_steel" | "create:cutting/compat/biomesoplenty/stripped_mahogany_log" | "draconicevolution:tools/wyvern_hoe" | "pamhc2foodextended:mangojellytoastitem" | "pamhc2trees:roastedcashewitem_forge" | "create:cut_dripstone_bricks_from_stone_types_dripstone_stonecutting" | "jaopca:mekanism.clean_slurry_to_crystal.draconium" | "minecraft:honey_bottle" | "create:milling/compat/botania/gray_petal" | "biomeswevegone:ebony_door" | "mekanism:processing/quartz/to_dust" | "immersiveengineering:crafting/stairs_concrete_brick" | "mekanism:compat/ilikewoodxbyg/crafting_table/holly" | "pamhc2foodcore:applepopsicleitem" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/fir/painting/light_gray" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/magic/painting/red" | "advanced_ae:quantum_processor_print" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/umbran/purple" | "mekanism:compat/ilikewood/bed/crimson/purple" | "connectedglass:scratched_glass_yellow_pane3" | "connectedglass:scratched_glass_yellow_pane2" | "connectedglass:scratched_glass_yellow_pane1" | "ae2:tools/portable_item_cell_1k" | "mekanism:compat/ilikewoodxbyg/chest/willow" | "mekanism:crushing/biofuel/blue_orchid" | "create:crafting/kinetics/gantry_shaft" | "mekanism:painting/dye/orange" | "immersiveengineering:crafting/wall_clinker_brick" | "pamhc2foodextended:grilledskewersitem" | "ae2:network/cables/glass_blue" | "pamhc2foodextended:ricecakeitem" | "minecraft:lapis_lazuli" | "draconicevolution:modules/item_wyvern_proj_accuracy" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/mahogany/black" | "domum_ornamentum:shingle_flat" | "ae2:tools/portable_item_cell_4k" | "aquaculture:redstone_hook" | "mekanism:processing/osmium/ingot/from_dust_blasting" | "mekanism:sawing/chest_boat/cherry" | "createaddition:pressing/zinc_ingot" | "mekanism:compat/ilikewoodxbyg/composter/willow" | "pamhc2foodcore:groundrabbititem" | "minecraft:quartz_block" | "mekanism:enriching/dye/small_pink" | "mekanism:enriching/dye/lime" | "create:cut_limestone_brick_stairs_from_stone_types_limestone_stonecutting" | "domum_ornamentum:brown_floating_carpet" | "immersiveengineering:crafting/maintenance_kit" | "create:cutting/compat/ars_nouveau/purple_archwood_log" | "prefab:pallet_of_bricks_to_pile_of_bricks" | "sophisticatedstorage:stack_upgrade_tier_1_plus" | "mekanism:compat/byg/sawing/boat/green_enchanted" | "woodwevegot:cypress_barrel" | "compressium:snow_9_uncraft" | "create:milling/compat/byg/green_tulip" | "mekanismtools:osmium/shield" | "biomeswevegone:white_mangrove_boat" | "mekanism:compat/ilikewoodxbyg/crafting_table/skyris" | "mekanism:compat/ilikewoodxbyg/torch/fir" | "create:deploying/waxed_oxidized_copper_tiles_from_adding_wax" | "easy_mob_farm:mob_farm_template/tier3_mob_farm_template" | "utilitarian:no_soliciting/restraining_order" | "mekanism:compat/ilikewoodxbyg/bed/lament/cyan" | "mekanism:combining/dye/orange" | "ae2:matter_cannon/nuggets/cesium" | "create:splashing/crushed_raw_gold" | "mekanism:compat/ae2/decorative/certus_quartz/enriching/pillar_slab_to_chiseled_slab" | "mekanism:compat/ilikewoodxbiomesoplenty/crafting_table/willow" | "minecraft:coast_armor_trim_smithing_template" | "minecraft:dune_armor_trim_smithing_template" | "pamhc2foodextended:walnutbutteritem" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/fir/painting/lime" | "create:cut_veridium_stairs" | "sophisticatedstorage:iron_shulker_box" | "minecraft:polished_blackstone_stairs_from_blackstone_stonecutting" | "immersiveengineering:crusher/ingot_aluminum" | "mekanism:compat/byg/dye/cyan" | "mekanism:compat/ilikewoodxbyg/barrel/sythian" | "sophisticatedstorage:backpack_magnet_upgrade_from_storage_magnet_upgrade" | "pamhc2foodextended:chickentendersitem" | "cookingforblockheads:toaster" | "pamhc2foodextended:zucchinibakeitem" | "mekanism:infusion_conversion/carbon/from_coal" | "mekanism:compat/ilikewoodxbyg/torch/redwood" | "fulleng:terminals/part_pattern_encoding_terminal_from_block" | "sophisticatedstorage:storage_magnet_upgrade_from_backpack_magnet_upgrade" | "mekanism:compat/byg/crushing/travertine/polished_stairs_to_stairs" | "mekanism:compat/ilikewoodxbyg/bed/cypress/painting/light_gray" | "mekanism:painting/glass_pane/light_gray" | "compressium:diorite_5_uncraft" | "appliedcooking:kitchen_station" | "mekanism:compat/ilikewoodxbyg/bed/white_mangrove/painting/light_gray" | "botanypots:botanypots/crafting/cyan_terracotta_hopper_botany_pot" | "create:crafting/kinetics/orange_seat_from_other_seat" | "minecraft:white_candle" | "minecraft:polished_blackstone_brick_wall_from_polished_blackstone_bricks_stonecutting" | "pamhc2foodextended:spinachpieitem" | "pamhc2foodextended:guacamoleitem" | "mekanism:compat/ilikewood/bed/crimson/painting/brown" | "fuelgoeshere:test2" | "fuelgoeshere:test3" | "minecraft:cobbled_deepslate_wall_from_cobbled_deepslate_stonecutting" | "create:small_asurine_brick_stairs" | "sophisticatedstorage:black_shulker_box_to_sophisticated" | "comforts:hammock_to_white" | "prefab:sickle_netherite" | "immersiveengineering:crafting/watermill" | "storagenetwork:storage_kabel" | "mekanism:crushing/polished_or_smooth_basalt_to_basalt" | "immersiveengineering:sawmill/cherry_log" | "sophisticatedstorage:storage_chipped_alchemy_bench_upgrade_from_backpack_chipped_alchemy_bench_upgrade" | "minecraft:golden_carrot" | "minecraft:campfire_cookedgroundrabbititem" | "ae2:network/cells/fluid_cell_housing" | "megacells:crafting/sky_steel_ingot_from_sky_steel_block" | "botanypots:botanypots/crafting/blue_terracotta_botany_pot" | "mekanism:compat/byg/combining/blue_quartz_ore_from_dust" | "apotheosis:spawner/spawn_range_inverted" | "naturalist:cooked_lizard_tail" | "mekanism:compat/ilikewoodxbyg/bed/aspen/painting/blue" | "create:cutting/compat/biomesoplenty/stripped_dead_wood" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/fir/painting/blue" | "mekanism:compat/ilikewoodxbyg/lectern/palm" | "create:crafting/kinetics/attribute_filter" | "mekanism:combining/wax/waxed_exposed_cut_copper" | "immersiveengineering:crafting/stairs_treated_wood_vertical" | "immersiveengineering:smelting/ingot_lead3" | "immersiveengineering:smelting/ingot_lead2" | "create:cutting/compat/blue_skies/frostbright_log" | "pamhc2foodextended:pearyogurtitem" | "mekanism:painting_machine" | "pamhc2foodextended:tortillachipsitem" | "ae2:network/blocks/io_port" | "mekanism:processing/emerald/to_ore" | "mekanism:compat/ilikewood/bed/dark_oak/painting/orange" | "mekanism:injecting/coral/bubble_coral_block" | "powah:crafting/cable_blazing" | "mekanism:compat/ilikewoodxbyg/bed/aspen/brown" | "minecraft:cherry_sign" | "mekanism:injecting/oxidizing/exposed_cut_copper" | "sophisticatedstorage:backpack_void_upgrade_from_storage_void_upgrade" | "create:crushing/deepslate_gold_ore" | "mekanism:compat/byg/crushing/red_rock/chiseled_slabs_to_brick_slabs" | "biomeswevegone:white_mangrove_fence_gate" | "mekanism:compat/ilikewoodxbyg/barrel/baobab" | "mekanism:compat/ilikewoodxbyg/bed/palm/purple" | "mekanism:compat/ilikewood/bed/dark_oak/red" | "biomeswevegone:cut_pink_sandstone_slab" | "compressium:gold_3_uncraft" | "mekanism:compat/ilikewoodxbyg/ladder/zelkova" | "mekanismtools:osmium/armor/boots" | "minecraft:purple_sandstone_stairs_from_purple_sandstone_stonecutting" | "pamhc2crops:hotteaitem_forge" | "mekanism:pigment_extracting/concrete/orange" | "minecraft:exposed_cut_copper_stairs" | "create:crafting/copper/waxed_exposed_copper_shingle_stairs_from_honeycomb" | "create:polished_cut_calcite_stairs_from_stone_types_calcite_stonecutting" | "mekanism:compat/biomesoplenty/sawing/log/dead" | "mekanism:compat/ilikewoodxbyg/bed/ebony/painting/orange" | "jaopca:immersiveengineering.ore_to_ingot.draconium" | "mekanism:enriching/conversion/quartz/from_smooth_quartz" | "sophisticatedstorage:storage_advanced_jukebox_upgrade_from_backpack_advanced_jukebox_upgrade" | "biomeswevegone:redwood_planks" | "minecraft:stripped_mangrove_wood" | "advanced_ae:smalladvpatpro" | "mekanismtools:bronze/armor/boots" | "mekanism:compat/ilikewoodxbyg/bed/skyris/painting/black" | "pamhc2foodextended:chocolatestrawberryitem" | "minecraft:light_weighted_pressure_plate" | "mekanism:compat/ilikewoodxbyg/bed/holly/pink" | "minecraft:dye_green_wool" | "mekanism:compat/ilikewoodxbyg/bed/aspen/painting/lime" | "pamhc2foodcore:scrambledeggitem" | "create:crafting/appliances/netherite_diving_helmet" | "create:cut_crimsite_stairs_from_stone_types_crimsite_stonecutting" | "create_sa:rose_quartz_shovel_recipe" | "create:cutting/compat/regions_unexplored/brimwood_log" | "immersiveengineering:smelting/ingot_hop_graphite_from_blasting" | "sophisticatedbackpacks:diamond_backpack" | "mekanism:scuba_tank" | "minecraft:pink_banner" | "create:polished_cut_granite_stairs_from_stone_types_granite_stonecutting" | "yungscavebiomes:smooth_ancient_sandstone_slab_from_smooth_stonecutting" | "pamhc2foodextended:padthaiitem" | "minecraft:copper_ingot_from_waxed_copper_block" | "immersiveengineering:crafting/empty_shell" | "ae2:block_cutter/slabs/sky_stone_small_brick_slab" | "mekanism:compat/ilikewoodxbyg/bed/palm/painting/light_blue" | "domum_ornamentum:roan_stone_bricks" | "create:cut_deepslate_slab_recycling" | "create:cutting/compat/twilightforest/canopy_log" | "mekanism:pigment_extracting/stained_glass/black" | "mekanism:compat/ilikewoodxbyg/bed/ebony/painting/black" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/magic/painting/yellow" | "mekanism:compat/ilikewoodxbyg/bed/ebony/magenta" | "toolbelt:pouch" | "powah:crafting/energizing_rod_basic" | "woodwevegot:mahogany_trapped_chest" | "pamhc2foodextended:celeryandpeanutbutteritem" | "comforts:sleeping_bag_to_cyan" | "mekanism:compat/ilikewoodxbyg/bed/holly/painting/blue" | "create:splashing/ice" | "immersiveengineering:crafting/stick_aluminum" | "mekanism:processing/lead/crystal/from_slurry" | "biomeswevegone:green_enchanted_door" | "pamhc2foodextended:pawpawjellyitem" | "mekanism:compat/byg/enriching/soapstone/brick_to_tile" | "create:splashing/endergetic/petrified_nether_corrock" | "pamhc2foodextended:blackberrycobbleritem" | "minecraft:cut_copper_slab_from_cut_copper_stonecutting" | "pamhc2foodcore:chorusdonutitem" | "mekanism:gas_conversion/osmium_from_block" | "mekanism:compat/ilikewoodxbyg/bed/skyris/painting/magenta" | "minecraft:cut_black_sandstone_from_black_sandstone_stonecutting" | "sophisticatedstorage:auto_smoking_upgrade_from_auto_smelting_upgrade" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/willow/painting/brown" | "mekanism:upgrade/gas" | "mekanism:compat/ilikewood/bed/oak/painting/brown" | "sophisticatedstorage:bamboo_chest" | "mekanism:compat/ilikewood/bed/mangrove/orange" | "mekanism:painting/concrete_powder/brown" | "immersiveengineering:thermoelectric/magma" | "easy_mob_farm:upgrade/enhancement/honey_extractor_enhancement" | "mekanism:compat/byg/enriching/soapstone/walls_to_polished_walls" | "create:small_calcite_bricks_from_stone_types_calcite_stonecutting" | "create:copper_shingle_stairs" | "apotheosis:salvaging/leather_horse_armor" | "mekanism:compat/ilikewoodxbyg/bed/zelkova/painting/gray" | "mekanism:compat/ilikewoodxbyg/lectern/green_enchanted" | "immersiveengineering:metalpress/rod_bronze" | "create:milling/compat/regions_unexplored/white_snowbelle" | "crafting_on_a_stick:cartography_table" | "biomeswevegone:jacaranda_hanging_sign" | "botanypots:botanypots/crafting/green_glazed_terracotta_compact_hopper_botany_pot" | "compressium:granite_5_uncraft" | "minecraft:copper_ingot_from_smelting_copper_ore" | "pamhc2foodextended:pizzasliceitem_anchovypepperonipizzaitem" | "ae2:matter_cannon/nuggets/sodium" | "mekanism:painting/glass/light_blue" | "create:haunting/glow_berries" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/magic/brown" | "aquaculture:neptunium_ingot_from_nuggets" | "create:small_granite_bricks_from_stone_types_granite_stonecutting" | "minecraft:iron_pickaxe" | "ae2:shaped/not_so_mysterious_cube" | "naturalist:smooth_shellstone_slab_from_stonecutting" | "powah:crafting/reactor_niotic" | "pamhc2foodextended:greengrapejellyitem" | "biomeswevegone:willow_bookshelf" | "minecraft:spruce_button" | "create:cut_andesite_from_stone_types_andesite_stonecutting" | "ae2:network/cables/glass_orange" | "mekanism:compat/ilikewoodxbyg/bed/jacaranda/white" | "ae2:materials/cardinverter" | "powah:crafting/ender_gate_spirited" | "ae2:network/cells/fluid_storage_cell_256k_storage" | "pamhc2foodextended:garlicbreaditem" | "mekanism:chemical_dissolution_chamber" | "create:crushing/asurine" | "minecraft:deepslate_tiles" | "mekanism:compat/ilikewood/bed/bamboo/painting/yellow" | "mekanism:sawing/boat/birch" | "minecraft:cut_pink_sandstone_slab_from_cut_pink_sandstone_stonecutting" | "justhammers:gold_reinforced_impact_hammer" | "immersiveengineering:sawmill/birch_door" | "immersiveengineering:blueprint/banner_wolf" | "immersiveengineering:crafting/nugget_copper_to_copper_ingot" | "botanypots:minecraft/soil/deepslate_iron_ore" | "minecraft:nether_brick_stairs_from_nether_bricks_stonecutting" | "apotheosis:treasure_shelf" | "comforts:hammock_orange" | "pamhc2foodextended:candycornitem" | "mekanism:chemical_oxidizer" | "mekanismgenerators:fission_reactor/logic_adapter" | "prefab:grass_wall" | "mekanism:processing/tin/ingot/from_raw_smelting" | "biomeswevegone:cypress_door" | "mekanism:compat/ilikewoodxbyg/bed/holly/painting/lime" | "draconicevolution:modules/item_wyvern_proj_velocity" | "powah:crafting/blank_card_2" | "mekanism:painting/terracotta/pink" | "mekanism:compat/ilikewood/bed/acacia/green" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/fir/gray" | "immersiveengineering:cloche/pink_tulip" | "immersiveengineering:crafting/ingot_nickel_to_storage_nickel" | "immersiveengineering:crafting/sheetmetal_colored_brown_to_slab" | "apotheosis:spawner/no_ai_inverted" | "immersiveengineering:arc_recycling_list" | "utilitarian:utility/birch_logs_to_slabs" | "create:cutting/compat/blue_skies/lunar_log" | "mekanism:compat/ilikewood/bed/crimson/painting/blue" | "ae2:network/cables/covered_fluix_clean" | "mekanism:compat/ilikewoodxbyg/bed/cika/magenta" | "woodwevegot:zelkova_trapped_chest" | "mekanism:compat/byg/enriching/mossy_stone/stairs" | "minecraft:yellow_dye_from_dandelion" | "biomeswevegone:blue_sandstone" | "mekanism:compat/ilikewoodxbyg/bed/cika/brown" | "mekanism:compat/byg/sawing/log/green_enchanted" | "minecraft:sentry_armor_trim_smithing_template_smithing_trim" | "mekanism:compat/byg/sawing/door/witch_hazel" | "mekanism:compat/ilikewoodxbyg/bed/holly/painting/green" | "immersiveengineering:crusher/ingot_nickel" | "draconicevolution:machines/wyvern_io_crystal" | "mekanism:enriching/conversion/diorite/stairs_to_polished_stairs" | "create:crafting/kinetics/item_drain" | "create:deepslate_pillar_from_stone_types_deepslate_stonecutting" | "minecraft:eye_armor_trim_smithing_template" | "create:cut_tuff_brick_wall" | "sophisticatedstorage:crimson_chest" | "create:crafting/appliances/crafting_blueprint" | "mekanism:sawing/hanging_sign/dark_oak" | "botanypots:farmingforblockheads/soil/fertilized_farmland_rich_stable" | "ae2:tools/network_memory_card" | "sophisticatedstorage:barrel_material" | "create_sa:blazing_sword_recipe" | "mekanism:compat/byg/dye/red" | "ae2:network/cells/spatial_storage_cell_128_cubed" | "pamhc2foodextended:loxbagelsandwichitem" | "minecraft:polished_blackstone_brick_slab_from_blackstone_stonecutting" | "botanypots:pamhc2crops/crop/bellpepper" | "mekanism:compat/ilikewoodxbyg/bed/palm/painting/pink" | "biomeswevegone:blue_enchanted_boat" | "pamhc2foodextended:mettbrotchenitem" | "mekanism:compat/ilikewood/bed/bamboo/painting/gray" | "biomeswevegone:holly_fence_gate" | "mekanism:combining/dye/gray_to_light_gray" | "biomeswevegone:blue_enchanted_trapdoor" | "powah:crafting/player_tranmitter_spirited" | "biomeswevegone:mahogany_stairs" | "mekanism:compat/ilikewoodxbyg/torch/embur" | "minecraft:mangrove_button" | "mekanism:compat/ilikewoodxbyg/bed/nightshade/red" | "elevatorid:elevator_gray" | "biomeswevegone:pine_crafting_table" | "mekanism:compat/ilikewoodxbiomesoplenty/barrel/hellbark" | "mekanism:compat/ilikewoodxbyg/bed/palm/blue" | "mekanism:module_jetpack_unit" | "powah:crafting/energy_hopper_blazing" | "minecraft:yellow_bed" | "minecraft:nether_brick_slab_from_nether_bricks_stonecutting" | "justhammers:stone_reinforced_hammer" | "compressium:coal_3_uncraft" | "mekanism:pigment_extracting/stained_glass/cyan" | "minecraft:waxed_cut_copper_slab_from_waxed_cut_copper_stonecutting" | "create:cutting/compat/regions_unexplored/ashen_wood" | "mekanism:compat/ilikewoodxbyg/bed/cherry/painting/purple" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/palm/lime" | "immersiveengineering:cloche/rose_bush" | "immersiveengineering:crafting/alu_slope" | "pamhc2foodextended:grapesodaitem" | "create:cutting/compat/blue_skies/crystallized_wood" | "mekanism:sawing/bed/lime" | "pamhc2foodextended:sausageitem" | "sophisticatedstorage:birch_chest" | "create:layered_crimsite_from_stone_types_crimsite_stonecutting" | "ae2:network/cables/covered_fluix" | "minecraft:purple_candle" | "mekanism:compat/byg/sawing/boat/mahogany" | "create:cutting/compat/byg/stripped_ether_log" | "jaopca:mekanism.raw_material_to_shard.zinc" | "pamhc2foodextended:peasandceleryitem" | "pamhc2foodextended:cinnamonappleoatmealitem" | "mekanism:compat/byg/sawing/trapdoor/jacaranda" | "wstweaks:wither_skeleton_skull" | "mekanism:compat/byg/sawing/fence_gate/mahogany" | "mekanism:compat/ilikewoodxbyg/bed/maple/painting/purple" | "cookingforblockheads:preservation_chamber" | "pamhc2foodcore:melonpieitem" | "advanced_ae:skysteel" | "mekanism:compat/byg/sawing/trapdoor/pine" | "megacells:cells/standard/chemical_storage_cell_64m_with_housing" | "create:crushing/raw_tin_block" | "aquaculture:birch_fish_mount" | "create:small_tuff_brick_slab" | "domum_ornamentum:panel_vertically_squiggly_striped" | "buildinggadgets2:template_manager" | "mekanism:crushing/biofuel/pink_petals" | "botanypots:botanypots/crafting/light_gray_terracotta_hopper_botany_pot" | "minecraft:cobblestone_stairs" | "immersiveengineering:crafting/heavy_engineering" | "create:milling/compat/buzzier_bees/pink_clover" | "create:cut_dripstone_slab_from_stone_types_dripstone_stonecutting" | "mekanism:processing/tin/clump/from_shard" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/dead/blue" | "mekanism:compat/ilikewoodxbyg/post/witch_hazel" | "immersiveengineering:crafting/hammercrushing_osmium" | "create:cut_scorchia_brick_wall" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/fir/purple" | "immersiveengineering:crafting/dynamo" | "mekanism:compat/byg/sawing/chest_boat/mahogany" | "mekanism:compat/ilikewoodxbyg/barrel/aspen" | "mekanism:compat/ilikewoodxbyg/bed/palm/lime" | "mekanism:crushing/biofuel/cherry_leaves" | "pamhc2foodcore:baconandeggsitem" | "minecraft:smooth_purple_sandstone_slab_from_purple_sandstone_stonecutting" | "mekanism:compat/ilikewoodxbyg/wall/zelkova" | "create:cutting/compat/atmospheric/stripped_kousa_wood" | "immersiveengineering:crafting/wirecoil_electrum_ins" | "pamhc2crops:roastedgarlicitem_smoker" | "draconicevolution:compress/draconium_block" | "create:polished_cut_scoria_slab_recycling" | "mekanism:compat/ilikewoodxbyg/bed/holly/white" | "immersiveengineering:metalpress/wire_invar" | "pamhc2trees:persimmon_sapling" | "create:cut_crimsite_bricks_from_stone_types_crimsite_stonecutting" | "create:mechanical_crafting/crushing_wheel" | "mekanism:processing/refined_obsidian/ingot/from_dust" | "create:cutting/compat/biomesoplenty/redwood_log" | "mekanism:compat/ilikewoodxbyg/bed/redwood/painting/orange" | "minecraft:sentry_armor_trim_smithing_template" | "pamhc2foodextended:honeysandwichitem" | "sophisticatedstorage:iron_chest_from_copper_chest" | "mekanism:compat/ilikewood/bed/birch/white" | "create:splashing/magenta_concrete_powder" | "megacells:crafting/64m_crafting_storage" | "mekanism:compat/ilikewood/bed/bamboo/magenta" | "pamhc2trees:acorn_sapling" | "botanytrees:biomeswevegone/skyris" | "pamhc2foodextended:banananutbreaditem" | "mekanism:compat/byg/sawing/pressure_plate/sythian" | "create:milling/compat/environmental/red_lotus_flower" | "woodwevegot:baobab_trapped_chest" | "waystones:warp_dust" | "create:cut_veridium_brick_wall_from_stone_types_veridium_stonecutting" | "createaddition:pressing/steel_ingot" | "mekanism:pigment_extracting/stained_glass_pane/cyan" | "powah:crafting/battery_starter" | "ae2:shaped/slabs/sky_stone_block" | "compressium:netherite_1_uncraft" | "mekanism:processing/quartz/from_dust" | "create:deploying/waxed_exposed_copper_shingle_slab_from_adding_wax" | "botanytrees:pamhc2trees/starfruit_sapling" | "elevatorid:redye_blue" | "mekanism:compat/ilikewood/lectern/oak" | "mekanism:compat/ilikewood/soul_torch/acacia" | "create:crafting/kinetics/yellow_valve_handle_from_other_valve_handle" | "minecraft:repeater" | "mekanism:compat/byg/sawing/fence_gate/ebony" | "biomeswevegone:pine_bookshelf" | "powah:crafting/crystal_nitro" | "mekanismtools:refined_glowstone/armor/leggings" | "minecraft:iron_leggings" | "create:emptying/compat/alexsmobs/lava_bottle" | "naturalist:teddy_bear" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/dead/lime" | "create:rose_quartz_block_from_rose_quartz_stonecutting" | "toolbelt:belt" | "mekanism:compat/ilikewood/bed/birch/painting/magenta" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/redwood/painting/black" | "mekanism:compat/ilikewoodxbyg/bed/zelkova/painting/red" | "mekanism:crushing/dewax/oxidized_cut_copper" | "jaopca:storage_blocks.to_storage_block.hop_graphite" | "compressium:clay_2_uncraft" | "minecraft:book_cloning" | "botanypots:minecraft/crop/warped_fungus" | "mekanism:compat/ilikewoodxbyg/bed/zelkova/white" | "powah:crafting/dielectric_rod_2" | "minecraft:smooth_windswept_sandstone_stairs_from_windswept_sandstone_stonecutting" | "pamhc2crops:taroseeditem" | "botanypots:botanypots/crafting/cyan_concrete_hopper_botany_pot" | "botanypots:pamhc2crops/crop/coffeebean" | "biomeswevegone:rainbow_eucalyptus_button" | "pamhc2crops:chiaseeditem" | "create:cutting/compat/twilightforest/transformation_log" | "mekanism:isotopic_centrifuge" | "immersiveengineering:crafting/ingot_uranium_to_storage_uranium" | "mekanism:rotary/sulfur_trioxide" | "immersiveengineering:sawmill/acacia_log" | "jaopca:immersiveengineering.material_to_plate_hammer.zinc" | "immersiveengineering:crafting/coal_coke_to_coke" | "create:cut_andesite_wall_from_stone_types_andesite_stonecutting" | "woodwevegot:ebony_trapped_chest" | "minecraft:mushroom_stew" | "utilitarian:utility/crimson_logs_to_doors" | "mekanism:compat/ilikewood/bed/cherry/gray" | "mekanism:crushing/biofuel/big_dripleaf" | "mekanism:metallurgic_infusing/mossy/cobblestone" | "mekanism:processing/iron/dust/from_raw_block" | "pamhc2foodextended:jackfruitjuiceitem" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/mahogany/light_blue" | "mekanism:pigment_extracting/concrete_powder/green" | "mekanism:compat/byg/crushing/soapstone/brick_stairs_to_polished_stairs" | "pamhc2trees:lime_sapling" | "domum_ornamentum:light_blue_floating_carpet" | "minecraft:pink_sandstone_slab_from_pink_sandstone_stonecutting" | "ae2:block_cutter/stairs/quartz_brick_stairs" | "megacells:cells/standard/item_storage_cell_256m_with_housing" | "pamhc2foodextended:honeyglazedcarrotsitem" | "mekanism:pigment_extracting/dye/pink" | "mekanism:compat/ilikewoodxbyg/barrel/zelkova" | "ae2:shaped/stairs/fluix_block" | "sophisticatedstorage:advanced_jukebox_upgrade" | "pamhc2foodextended:suaderoitem" | "pamhc2crops:torch_cattail" | "create:cutting/compat/regions_unexplored/dead_wood" | "botanypots:botanypots/crafting/red_glazed_terracotta_compact_hopper_botany_pot" | "ae2:block_cutter/slabs/quartz_slab" | "create:copper_tile_stairs_from_copper_tiles_stonecutting" | "mekanism:compat/ilikewood/bed/acacia/gray" | "create:cutting/compat/integrateddynamics/menril_wood_stripped" | "pamhc2foodextended:guavajellytoastitem" | "create:cutting/compat/regions_unexplored/stripped_yellow_bioshroom_stem" | "minecraft:prismarine_brick_slab" | "mekanism:factory/elite/enriching" | "pamhc2foodextended:gardensoupitem" | "mekanism:pigment_extracting/candle/light_gray" | "biomeswevegone:stripped_witch_hazel_wood" | "minecraft:mossy_red_rock_bricks_from_moss_block" | "mekanism:compat/ilikewoodxbyg/bed/white_mangrove/painting/white" | "createaddition:filling/chocolate_cake" | "create:cutting/compat/byg/fungal_imparius_hyphae" | "mekanism:module_hydraulic_propulsion_unit" | "mekanism:compat/ilikewood/composter/cherry" | "minecraft:lapis_lazuli_from_blasting_deepslate_lapis_ore" | "immersiveengineering:crafting/sheetmetal_colored_yellow_to_slab" | "pamhc2crops:cantaloupeseeditem" | "immersiveengineering:crusher/ore_uranium" | "pamhc2foodextended:pearjuiceitem" | "jaopca:mekanism.raw_storage_block_to_dirty_slurry.zinc" | "ae2:network/cells/item_storage_components_cell_256k_part" | "biomeswevegone:zelkova_planks" | "minecraft:polished_andesite_from_andesite_stonecutting" | "create:cut_granite_slab_recycling" | "minecraft:mud_brick_slab_from_mud_bricks_stonecutting" | "elevatorid:redye_lime" | "mekanism:processing/diamond/from_dust" | "create:deploying/waxed_oxidized_copper_shingle_stairs_from_adding_wax" | "createaddition:filling/treated_wood_planks" | "create:cutting/compat/blue_skies/stripped_lunar_log" | "biomeswevegone:mossy_red_rock_brick_slab" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/redwood/white" | "minecraft:smooth_stone_slab_from_smooth_stone_stonecutting" | "create:cut_calcite_bricks_from_stone_types_calcite_stonecutting" | "mekanism:sawing/melon" | "mekanism:pigment_extracting/concrete/gray" | "minecraft:clock" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/palm/blue" | "create:crafting/appliances/netherite_diving_helmet_from_netherite" | "immersiveengineering:arcfurnace/raw_block_aluminum" | "immersiveengineering:crafting/raw_aluminum_to_raw_block_aluminum" | "botanytrees:pamhc2trees/cashew_sapling" | "comforts:sleeping_bag_light_gray" | "mekanism:compat/ilikewoodxbyg/composter/aspen" | "create:cutting/compat/ars_nouveau/stripped_red_archwood_wood" | "mekanism:compat/biomesoplenty/sawing/door/jacaranda" | "mekanism:compat/ilikewoodxbyg/bed/mahogany/light_gray" | "mekanism:pigment_extracting/wool/cyan" | "create:milling/compat/byg/protea_flower" | "create:filling/compat/neapolitan/milk_bottle" | "minecraft:blue_ice" | "ae2:block_cutter/stairs/quartz_stairs" | "biomeswevegone:mahogany_wood" | "apotheosis:salvaging/mythic_gem_dust" | "pamhc2foodextended:papayapieitem" | "pamhc2foodextended:pinkelitem" | "mekanism:compat/byg/sawing/trapdoor/blue_enchanted" | "minecraft:diamond_leggings" | "minecraft:purple_stained_glass" | "mekanism:painting/terracotta/brown" | "sophisticatedstorage:iron_shulker_from_iron_chest" | "powah:crafting/energy_cell_niotic" | "draconicevolution:compress/chaos_shard" | "pamhc2crops:agaveseeditem" | "mekanism:compat/ilikewoodxbyg/bed/sythian/brown" | "draconicevolution:machines/wyvern_wireless_crystal" | "mekanism:pigment_extracting/concrete_powder/red" | "mekanism:nucleosynthesizing/lapis_block" | "create:polished_cut_deepslate_slab_from_stone_types_deepslate_stonecutting" | "minecraft:polished_andesite_slab_from_andesite_stonecutting" | "minecraft:dye_black_bed" | "compressium:clay_8_uncraft" | "botanypots:botanypots/crafting/pink_glazed_terracotta_botany_pot" | "woodwevegot:cypress_chest" | "create:cutting/compat/byg/stripped_baobab_wood" | "create:milling/sunflower" | "minecraft:mossy_stone_bricks_from_moss_block" | "botanypots:pamhc2crops/crop/waterchestnut" | "botanytrees:pamhc2trees/tamarind_sapling" | "biomeswevegone:rainbow_eucalyptus_fence_gate" | "mekanism:pigment_extracting/terracotta/purple" | "mekanism:combining/wax/waxed_oxidized_copper" | "create:cutting/compat/upgrade_aquatic/stripped_river_log" | "mekanism:processing/steel/ingot/from_dust_smelting" | "compressium:lapis_6_uncraft" | "minecraft:mossy_stone_wall_from_mossy_stone_stonecutting" | "mekanism:crushing/biofuel/glow_lichen" | "mekanism:oxidizing/sulfur_dioxide" | "utilitarian:no_soliciting/soliciting_carpets/cyan_trapped_soliciting_carpet" | "pamhc2foodextended:friedfeastitem" | "create:cutting/compat/twilightforest/time_wood" | "mekanism:compat/byg/crushing/dacite/walls_to_cobblestone_walls" | "pamhc2trees:fig_sapling" | "mekanism:compat/ilikewoodxbyg/lectern/aspen" | "mekanism:processing/lategame/polonium_pellet/from_reaction" | "immersiveengineering:crafting/sheetmetal_constantan" | "pamhc2foodextended:orangejellysandwichitem" | "mekanism:compat/ilikewoodxbyg/bed/imparius/painting/brown" | "compressium:gravel_7" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/willow/painting/light_blue" | "compressium:gravel_8" | "compressium:gravel_9" | "immersiveengineering:arcfurnace/raw_block_cobalt" | "pamhc2trees:roastedpistachiotitem_smoker" | "createaddition:rolling/copper_ingot" | "powah:crafting/dielectric_rod_h" | "utilitarian:no_soliciting/soliciting_carpets/purple_trapped_soliciting_carpet" | "create:crafting/kinetics/mechanical_piston" | "pamhc2crops:elderberryseeditem" | "create:splashing/oreganized/crushed_raw_silver" | "biomeswevegone:holly_slab" | "draconicevolution:tools/chaotic_chestpiece" | "connectedglass:scratched_glass1" | "apotheosis:salvaging/mythic_material" | "mekanism:compat/ilikewoodxbyg/bed/sythian/painting/orange" | "mekanism:pigment_extracting/banner/light_blue" | "mekanism:processing/netherite/dirty_scrap_to_scrap" | "minecraft:wooden_shovel" | "yungscavebiomes:ancient_sandstone_slab" | "createoreexcavation:vein_atlas" | "compressium:stone_6_uncraft" | "mekanism:compat/ilikewoodxbyg/bed/cypress/lime" | "immersiveengineering:arcfurnace/ore_platinum" | "immersiveengineering:bottling/mud" | "compressium:granite_1_uncraft" | "mekanism:compat/ilikewoodxbyg/post/green_enchanted" | "powah:crafting/ender_gate_niotic_2" | "minecraft:bamboo_trapdoor" | "create:cutting/compat/biomesoplenty/dead_log" | "powah:crafting/blank_card" | "create:deploying/waxed_copper_block_from_adding_wax" | "create:item_application/railway_casing" | "pamhc2foodextended:creamofmushroomitem" | "biomeswevegone:cika_stairs" | "minecraft:waxed_copper_block_from_honeycomb" | "mekanism:compat/ilikewoodxbyg/bed/witch_hazel/purple" | "pamhc2foodcore:caramelmuffinitem" | "prefab:compressed_glowstone_from_glowstone" | "create:copper_bars_from_ingots_copper_stonecutting" | "minecraft:warped_fungus_on_a_stick" | "biomeswevegone:ironwood_crafting_table" | "create:pressing/aether_dirt_path_from_grass" | "mekanism:compat/ilikewoodxbyg/bed/maple/painting/red" | "minecraft:white_sandstone_slab_from_white_sandstone_stonecutting" | "minecraft:gold_ingot_from_smelting_raw_gold" | "pamhc2crops:kaleseeditem" | "sophisticatedbackpacks:smithing_upgrade" | "mekanism:compat/byg/enriching/soapstone/brick_stairs_to_tile_stairs" | "compressium:snow_5_uncraft" | "botanytrees:biomeswevegone/cypress" | "mekanism:compat/byg/sawing/pressure_plate/aspen" | "create:cutting/compat/regions_unexplored/pine_wood" | "minecraft:cooked_cod_from_smoking" | "mekanism:compat/ilikewoodxbiomesoplenty/post/cherry" | "draconicevolution:modules/item_chaotic_energy" | "yungscavebiomes:layered_ancient_sandstone_from_stonecutting" | "compressium:gravel_3" | "compressium:gravel_4" | "mekanism:hazmat_mask" | "compressium:gravel_5" | "mekanism:painting/glass_pane/magenta" | "ae2:charger/charged_certus_quartz_crystal" | "compressium:gravel_6" | "mekanism:compat/ilikewoodxbyg/bed/cypress/purple" | "immersiveengineering:crafting/storage_silver_to_slab" | "compressium:gravel_1" | "pamhc2foodextended:pemmicanitem" | "compressium:gravel_2" | "compressium:copper_6" | "compressium:copper_5" | "compressium:copper_8" | "compressium:copper_7" | "biomeswevegone:willow_planks" | "compressium:copper_9" | "pamhc2crops:sugar_x2_agave" | "immersiveengineering:mineral/laterite" | "mekanism:compat/byg/enriching/red_rock/stairs_to_brick_stairs" | "botanypots:minecraft/crop/lily_pad" | "biomeswevegone:redwood_slab" | "mekanism:compat/ilikewood/bed/crimson/lime" | "create:crushing/compat/byg/blue_nether_quartz_ore" | "naturalist:glow_goop_from_campfire_cooking" | "mekanism:compat/ilikewoodxbyg/bed/pine/blue" | "fulleng:terminals/part_crafting_terminal_from_block" | "mekanism:injecting/oxidizing/exposed_cut_copper_slab" | "mekanism:compat/biomesoplenty/sandstone_to_sand/black" | "mekanism:compat/ae2/decorative/certus_quartz/enriching/wall_to_pillar_wall" | "compressium:copper_2" | "compressium:copper_1" | "compressium:copper_4" | "compressium:copper_3" | "minecraft:copper_ingot" | "create:cut_veridium_brick_stairs" | "immersiveengineering:cloche/cornflower" | "pamhc2foodextended:heartybreakfastitem" | "minecraft:waxed_weathered_cut_copper_slab" | "woodwevegot:holly_trapped_chest" | "immersiveengineering:blueprint/bullet_wolfpack" | "create:haunting/glow_ink_sac" | "minecraft:end_stone_brick_wall" | "pamhc2foodcore:cookingoilitem_x2_vegetables" | "biomeswevegone:sakura_slab" | "mekanism:compat/ilikewoodxbyg/bed/cypress/blue" | "mekanism:compat/ilikewood/bed/spruce/painting/gray" | "biomeswevegone:ironwood_slab" | "immersiveengineering:smelting/nugget_steel_recycle_pick" | "mekanism:compat/ilikewood/panel/birch" | "jamd:end_portal_block" | "pamhc2foodextended:plumsmoothieitem" | "immersiveengineering:cloche/wither_rose" | "cookingforblockheads:dye_lime_oven" | "pamhc2trees:almond_sapling" | "mekanism:compat/ilikewoodxbyg/panel/willow" | "apotheosis:spawner/min_delay_inverted" | "create:cutting/compat/byg/rainbow_eucalyptus_wood" | "minecraft:waxed_oxidized_cut_copper_stairs_from_honeycomb" | "biomeswevegone:blue_enchanted_hanging_sign" | "mekanism:module_elytra_unit" | "biomeswevegone:aspen_button" | "ae2:network/cables/dense_smart_red" | "mekanism:sawing/fence_gate/mangrove" | "ae2:inscriber/calculation_processor_print" | "minecraft:oak_sign" | "connectedglass:borderless_glass_blue1" | "create:milling/compat/botania/black_petal" | "ae2:matter_cannon/nuggets/iridium" | "mekanism:compat/ilikewoodxbyg/bed/maple/orange" | "mekanism:compat/ilikewoodxbyg/bed/witch_hazel/red" | "mekanism:energy_cube/advanced" | "connectedglass:borderless_glass_blue2" | "pamhc2foodextended:tiropitaitem" | "mekanism:compat/byg/sawing/pressure_plate/redwood" | "mekanism:sawing/trapdoor/acacia" | "sophisticatedstorage:gold_barrel" | "pamhc2foodextended:vindalooitem" | "mekanism:compat/ilikewoodxbiomesoplenty/chest/magic" | "buddingcrystals:budding_steel" | "immersiveengineering:crafting/storage_electrum_to_ingot_electrum" | "biomeswevegone:stripped_redwood_wood" | "pamhc2foodextended:mangopieitem" | "mekanism:osmium_compressor" | "mekanism:compat/ilikewoodxbiomesoplenty/composter/dead" | "immersiveengineering:stonecutting/slab_concrete_tile" | "immersiveengineering:crafting/alloybrick" | "mekanism:compat/ilikewood/wall/dark_oak" | "biomeswevegone:skyris_chest_boat" | "mekanism:compat/ilikewood/bed/crimson/painting/lime" | "immersiveengineering:crafting/sheetmetal_colored_magenta" | "create:cutting/compat/botania/livingwood" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/jacaranda/brown" | "utilitarian:no_soliciting/soliciting_carpets/blue_soliciting_carpet" | "sophisticatedstorage:storage_smelting_upgrade_from_backpack_smelting_upgrade" | "minecraft:shield_decoration" | "connectedglass:tinted_borderless_glass_cyan2" | "mekanism:compat/ilikewood/torch/oak" | "create:cutting/compat/tconstruct/stripped_bloodshroom_log" | "ae2:tools/network_tool" | "create:cut_ochrum_brick_slab_from_stone_types_ochrum_stonecutting" | "mekanism:security_desk" | "create:small_diorite_brick_slab_from_stone_types_diorite_stonecutting" | "create:cut_limestone_brick_slab_from_stone_types_limestone_stonecutting" | "pamhc2foodextended:breadfruitjellytoastitem" | "sophisticatedstorage:stack_upgrade_tier_2_from_tier_1_plus" | "mekanism:storage_blocks/bronze" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/willow/white" | "connectedglass:clear_glass_yellow_pane1" | "connectedglass:clear_glass_yellow_pane2" | "create:cutting/compat/biomesoplenty/willow_wood" | "connectedglass:clear_glass_yellow_pane3" | "immersiveengineering:crafting/storage_uranium_to_ingot_uranium" | "create:small_tuff_bricks_from_stone_types_tuff_stonecutting" | "naturalist:cooked_bass" | "minecraft:birch_planks" | "sophisticatedstorage:acacia_chest_from_quark_acacia_chest" | "pamhc2foodextended:mulberryjuiceitem" | "create:small_calcite_brick_slab" | "create:cutting/compat/regions_unexplored/stripped_baobab_wood" | "mekanism:injecting/concrete/black" | "mekanism:compat/ilikewood/bed/bamboo/brown" | "mekanism:processing/iron/dust/from_ingot" | "mekanism:compat/ilikewoodxbyg/bed/ether/painting/yellow" | "mekanism:compat/ilikewood/bed/birch/green" | "mekanism:compat/ilikewoodxbyg/bed/zelkova/red" | "mekanism:compat/ilikewoodxbyg/bed/baobab/yellow" | "create:diorite_pillar_from_stone_types_diorite_stonecutting" | "mekanism:processing/lead/ore/from_raw" | "mekanism:compat/ilikewoodxbiomesoplenty/post/jacaranda" | "create:emptying/compat/neapolitan/milk_bottle" | "comforts:sleeping_bag_magenta" | "pamhc2foodextended:relishitem" | "create:small_veridium_brick_wall_from_stone_types_veridium_stonecutting" | "minecraft:dye_magenta_carpet" | "mekanism:compat/ilikewood/bed/crimson/blue" | "ae2:matter_cannon/nuggets/rhodium" | "mekanism:compat/biomesoplenty/sawing/door/fir" | "mekanism:compat/ilikewoodxbiomesoplenty/wall/dead" | "create:polished_cut_andesite_from_stone_types_andesite_stonecutting" | "mekanism:compat/ilikewoodxbyg/bed/baobab/painting/light_blue" | "domum_ornamentum:panel_horizontally_striped" | "prefab:sickle_wood" | "minecraft:weathered_cut_copper_stairs_from_weathered_cut_copper_stonecutting" | "immersiveengineering:crafting/sheetmetal_colored_green" | "apotheosis:cobweb" | "minecraft:waxed_weathered_cut_copper_stairs_from_waxed_weathered_copper_stonecutting" | "create:cutting/compat/autumnity/stripped_maple_wood" | "mekanism:compat/ilikewood/post/jungle" | "sophisticatedbackpacks:tank_upgrade" | "mekanism:compat/ilikewoodxbiomesoplenty/item_frame/hellbark" | "create:crushing/compat/silentgems/iolite_ore" | "createoreexcavation:extractor/water" | "woodwevegot:baobab_ladder" | "minecraft:brown_bed" | "immersiveengineering:crafting/stairs_alu_scaffolding_grate_top" | "sophisticatedstorage:acacia_limited_barrel_1" | "sophisticatedstorage:acacia_limited_barrel_3" | "sophisticatedstorage:acacia_limited_barrel_2" | "powah:crafting/capacitor_nitro" | "sophisticatedstorage:acacia_limited_barrel_4" | "pamhc2foodcore:creamitem" | "create:crushing/ochrum_recycling" | "pamhc2foodextended:soursopjellyitem" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/hellbark/light_gray" | "pamhc2foodextended:gooseberryjellytoastitem" | "jaopca:mekanism.material_to_deepslate_ore.silver" | "immersiveengineering:cloche/white_tulip" | "mekanism:compat/ilikewoodxbyg/bed/maple/cyan" | "mekanism:crushing/prismarine/shard_from_brick_stairs" | "mekanism:storage_blocks/fluorite" | "compressium:snow_6_uncraft" | "mekanism:compat/ilikewoodxbyg/bed/holly/magenta" | "pamhc2trees:roastedpistachioitem_campfire" | "powah:crafting/furnator_basic" | "jaopca:mekanism.raw_storage_block_to_clump.zinc" | "minecraft:jack_o_lantern" | "mekanism:processing/lategame/plutonium_pellet/from_reaction" | "minecraft:tripwire_hook" | "mekanism:sawing/door/oak" | "mekanism:crushing/biofuel/nether_sprouts" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/cherry/cyan" | "create:cut_calcite_stairs_from_stone_types_calcite_stonecutting" | "compressium:sand_2_uncraft" | "create:cutting/compat/byg/stripped_cypress_wood" | "ae2:network/crafting/patterns_blank" | "create:crafting/appliances/copper_backtank" | "advanced_ae:auto_feed_card" | "mekanism:compat/ilikewood/bed/mangrove/black" | "mekanism:crushing/biofuel/small_dripleaf" | "mekanismtools:steel/shield" | "mekanism:compat/byg/crushing/travertine/polished_walls_to_walls" | "mekanism:compat/ilikewoodxbyg/bed/imparius/painting/lime" | "mekanism:compat/byg/sawing/pressure_plate/zelkova" | "utilitarian:utility/bamboo_slab_to_block" | "immersiveengineering:smelting/nugget_steel_recycle_sword" | "mekanism:compat/ilikewoodxbyg/bed/zelkova/green" | "mekanism:processing/lapis_lazuli/to_dust" | "immersiveengineering:crafting/ingot_silver_to_storage_silver" | "mekanism:compat/ilikewood/bed/birch/gray" | "mekanism:processing/diamond/to_deepslate_ore" | "pamhc2foodextended:festivalbreaditem" | "mekanism:combining/wax/waxed_cut_copper_slab" | "woodwevegot:ironwood_chest" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/fir/magenta" | "create:crafting/appliances/netherite_backtank_from_netherite" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/redwood/light_blue" | "immersiveengineering:mineral/nether_silt" | "minecraft:waxed_weathered_cut_copper_from_honeycomb" | "comforts:sleeping_bag_red" | "compressium:clay_9_uncraft" | "mekanism:processing/lapis_lazuli/to_deepslate_ore" | "minecraft:purple_sandstone_wall_from_purple_sandstone_stonecutting" | "pamhc2foodcore:potroastitem" | "botanypots:botanypots/crafting/lime_terracotta_hopper_botany_pot" | "create:copper_shingles_from_ingots_copper_stonecutting" | "mekanism:compat/ilikewoodxbyg/bed/imparius/painting/blue" | "mekanism:compat/ilikewoodxbyg/wall/white_mangrove" | "pamhc2foodextended:beanburritoitem" | "utilitarian:utility/mangrove_logs_to_boats" | "sophisticatedstorage:jukebox_upgrade" | "mekanism:compat/ilikewoodxbyg/ladder/nightshade" | "immersiveengineering:crafting/stairs_slag_brick" | "biomeswevegone:willow_fence" | "mekanism:compat/ilikewoodxbyg/bed/blue_enchanted/painting/cyan" | "powah:crafting/energy_discharger_starter" | "pamhc2foodcore:sweetberryjellytoastitem" | "mekanism:compat/byg/crushing/red_rock/brick_slabs_to_cracked_brick_slabs" | "immersiveengineering:crafting/wire_electrum" | "pamhc2foodextended:peanutbutteritem" | "sophisticatedstorage:auto_smoking_upgrade" | "minecraft:cut_pink_sandstone_from_pink_sandstone_stonecutting" | "minecraft:waxed_oxidized_cut_copper_slab" | "immersiveengineering:cloche/peony" | "pamhc2trees:passionfruit_sapling" | "biomeswevegone:smooth_blue_sandstone_slab" | "mekanism:compat/biomesoplenty/sawing/boat/fir" | "sophisticatedstorage:backpack_chipped_glassblower_upgrade_from_storage_chipped_glassblower_upgrade" | "mekanism:compat/ilikewoodxbyg/ladder/aspen" | "mekanism:processing/coal/to_ore" | "ae2:entropy/cool/lava_obsidian" | "create:crafting/kinetics/piston_extension_pole" | "pamhc2foodextended:maplesausageitem" | "jaopca:mekanism.material_to_default_ore.aluminum" | "create:cut_crimsite_wall" | "botanytrees:biomeswevegone/redwood" | "minecraft:lime_dye_from_smelting" | "mekanism:compat/ilikewood/composter/warped" | "sophisticatedstorage:yellow_shulker_box_to_sophisticated" | "mekanism:compat/ilikewoodxbyg/panel/aspen" | "create:cut_limestone_slab" | "buddingcrystals:budding_brass" | "minecraft:weathered_cut_copper_stairs" | "compressium:redstone_6_uncraft" | "jaopca:immersiveengineering.material_to_dust.quartz" | "ae2:transform/entangled_singularity" | "pamhc2trees:roastedwalnutitem_forge" | "immersiveengineering:crafting/concrete_brick_from_slab" | "mekanism:compat/ilikewoodxbyg/bed/willow/painting/cyan" | "megacells:cells/portable/portable_item_cell_16m" | "create_sa:grapplin_whisk_recipe" | "botanypots:pamhc2crops/crop/cotton" | "fulleng:part_requester_terminal_from_block" | "mekanismtools:osmium/nugget_from_smelting" | "utilitarian:utility/oak_logs_to_slabs" | "create:cutting/compat/upgrade_aquatic/river_log" | "biomeswevegone:windswept_sandstone_pillar" | "create:milling/sugar_cane" | "botanypots:minecraft/crop/moss" | "mekanism:compat/ilikewoodxbyg/bed/pine/painting/black" | "create:smelting/tin_ingot_compat_thermal" | "cookingforblockheads:light_blue_kitchen_floor" | "mekanism:compat/ilikewoodxbyg/bed/maple/painting/brown" | "minecraft:shield" | "mekanism:reaction/wood_gasification/wooden_slabs" | "minecraft:blackstone_slab" | "biomeswevegone:willow_boat" | "mekanism:compat/ilikewood/bed/oak/painting/blue" | "mekanism:compat/byg/enriching/red_rock/cracked_brick_stairs_to_brick_stairs" | "mekanism:compat/byg/enriching/red_rock/chiseled_slabs_to_brick_slabs" | "prefab:triple_compressed_stone_to_double_compressed_stone" | "biomeswevegone:palm_crafting_table" | "create:small_dripstone_bricks_from_stone_types_dripstone_stonecutting" | "mekanism:processing/uranium/storage_blocks/from_ingots" | "create:cut_crimsite_wall_from_stone_types_crimsite_stonecutting" | "minecraft:quartz_bricks" | "minecraft:map_cloning" | "mekanism:compat/ilikewoodxbyg/bed/willow/white" | "immersiveengineering:crafting/wirecoil_redstone" | "mekanism:compat/ilikewood/bed/acacia/painting/orange" | "mekanism:crushing/biofuel/allium" | "create:crafting/kinetics/brown_valve_handle_from_other_valve_handle" | "jaopca:immersiveengineering.ore_to_dust_crusher.draconium" | "create:cut_deepslate_brick_slab_recycling" | "createaddition:crafting/spool" | "minecraft:acacia_stairs" | "mekanism:compat/ilikewoodxbyg/bed/blue_enchanted/green" | "waystones:warp_plate" | "pamhc2foodextended:ediblerootitem" | "ae2:block_cutter/walls/sky_stone_brick_wall" | "minecraft:raw_gold_block" | "minecraft:birch_door" | "immersiveengineering:blueprint/bullet_flare_red" | "sophisticatedstorage:backpack_advanced_pickup_upgrade_from_storage_advanced_pickup_upgrade" | "immersiveengineering:crafting/alu_scaffolding_standard_from_slab" | "botanypots:minecraft/crop/cactus" | "biomeswevegone:aspen_chest_boat" | "botanypots:botanypots/crafting/red_concrete_botany_pot" | "powah:crafting/blazing_crystal_block" | "megacells:cells/standard/chemical_storage_cell_4m" | "immersiveengineering:cloche/orange_tulip" | "biomeswevegone:stripped_skyris_wood" | "mekanism:compat/ilikewoodxbyg/bed/mahogany/painting/cyan" | "mekanism:processing/lapis_lazuli/from_ore" | "ae2:shaped/slabs/sky_stone_small_brick" | "biomeswevegone:white_mangrove_bookshelf" | "mekanism:compat/byg/enriching/dacite/to_brick" | "obsidianboat:obsidian_boat" | "biomeswevegone:ebony_fence_gate" | "immersiveengineering:stonecutting/hempcrete_chiseled" | "compressium:diorite_8_uncraft" | "minecraft:birch_fence_gate" | "botanypots:pamhc2crops/crop/mustardseeds" | "mekanism:enriching/dye/brown" | "minecraft:gold_ingot_from_blasting_nether_gold_ore" | "mekanism:processing/iron/shard/from_raw_block" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/redwood/cyan" | "botanypots:pamhc2crops/crop/blackberry" | "create:pressing/compat/vampirism/cursed_earth_path" | "create:small_scorchia_brick_wall_from_stone_types_scorchia_stonecutting" | "biomeswevegone:baobab_wood" | "mekanism:compat/biomesoplenty/dye/orange" | "mekanism:compat/ilikewoodxbyg/bed/green_enchanted/magenta" | "ae2:matter_cannon/nuggets/calcium" | "immersiveengineering:sawmill/spruce_wood" | "sophisticatedbackpacks:auto_smoking_upgrade" | "prefab:boundary_block" | "mekanism:compat/ilikewoodxbyg/post/holly" | "compressium:lapis_7_uncraft" | "minecraft:mud_brick_wall" | "megacells:cells/standard/fluid_storage_cell_16m" | "create:cut_deepslate_from_stone_types_deepslate_stonecutting" | "immersiveengineering:alloysmelter/rose_gold" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/umbran/orange" | "botanypots:minecraft/crop/nether_wart" | "pamhc2foodcore:sweetberryyogurtitem" | "minecraft:prismarine_wall_from_prismarine_stonecutting" | "wstweaks:blaze_blade" | "biomeswevegone:pine_fence" | "create:cutting/compat/forbidden_arcanus/aurum_wood" | "ae2wtlib:wireless_universal_terminal/upgrade_pattern_encoding" | "mekanism:painting/dye/gray" | "mekanism:compat/ilikewood/bed/cherry/light_blue" | "create:cutting/compat/botania/glimmering_stripped_livingwood" | "mekanism:crushing/chiseled_nether_bricks_to_nether_bricks" | "create:cutting/compat/byg/stripped_jacaranda_log" | "minecraft:redstone_block" | "mekanism:compat/ilikewoodxbiomesoplenty/soul_torch/umbran" | "mekanism:compat/ilikewoodxbyg/bed/imparius/painting/magenta" | "mekanism:compat/ilikewood/bed/acacia/painting/green" | "minecraft:honeycomb_block" | "mekanism:compat/ilikewood/barrel/jungle" | "pamhc2foodextended:pineapplejellytoastitem" | "cookingforblockheads:recipe_book_smelting" | "mekanism:injecting/concrete/purple" | "mekanism:compat/ilikewood/bed/warped/brown" | "immersiveengineering:crafting/storage_lead_to_ingot_lead" | "mekanism:compat/ilikewood/panel/bamboo" | "compressium:granite_2_uncraft" | "createaddition:liquid_burning/gasoline" | "botanypots:pamhc2crops/crop/nettles" | "create:vertical_framed_glass_from_glass_colorless_stonecutting" | "mekanism:compat/ilikewoodxbyg/bed/zelkova/orange" | "domum_ornamentum:orange_floating_carpet" | "mekanism:processing/bronze/dust/from_ingot" | "minecraft:dye_pink_bed" | "mekanism:compat/biomesoplenty/sawing/door/magic" | "create:crafting/materials/electron_tube" | "botanytrees:biomeswevegone/red_birch" | "pamhc2foodextended:etonmessitem" | "buddingcrystals:budding_redstone" | "immersiveengineering:crafting/fluid_placer" | "createoreexcavation:extractor" | "pamhc2foodextended:lemonsmoothieitem" | "pamhc2foodextended:mangoyogurtitem" | "mekanism:compat/ilikewoodxbyg/bed/baobab/gray" | "pamhc2foodextended:cactusfruitjellyitem" | "create:cutting/compat/regions_unexplored/silver_birch_wood" | "prefab:farm_advanced" | "connectedglass:vanilla_black_stained_glass" | "create:cutting/compat/ars_nouveau/blue_archwood_wood" | "mekanism:compat/ilikewoodxbyg/bed/nightshade/light_gray" | "mekanism:compat/ilikewoodxbyg/bed/white_mangrove/light_gray" | "create:cut_granite_stairs" | "minecraft:dye_cyan_carpet" | "mekanism:compat/ilikewood/bed/bamboo/painting/red" | "jaopca:mekanism.ore_to_clump.nickel" | "mekanism:compat/byg/enriching/dacite/stairs_to_brick_stairs" | "create:cut_scoria_brick_slab" | "utilitarian:utility/cherry_logs_to_slabs" | "botanypots:minecraft/crop/sea_pickle" | "mekanism:compat/ilikewoodxbyg/bed/lament/brown" | "create:filling/redstone" | "sophisticatedstorage:storage_chipped_botanist_workbench_upgrade_from_backpack_chipped_botanist_workbench_upgrade" | "minecraft:oxidized_cut_copper_stairs" | "sophisticatedstorage:storage_link_from_controller" | "mekanism:compat/ilikewoodxbyg/bed/ether/yellow" | "immersiveengineering:crafting/wirecoil_electrum" | "immersiveengineering:metalpress/electrode" | "mekanism:compat/ilikewoodxbyg/bed/sythian/purple" | "minecraft:mangrove_trapdoor" | "minecraft:diamond_boots" | "pamhc2crops:radishseeditem" | "pamhc2crops:water_barrelcactus" | "pamhc2foodcore:freshwater_x8" | "minecraft:stick" | "woodwevegot:pine_trapped_chest" | "immersiveengineering:metalpress/wire_nickel" | "mekanism:compat/ilikewoodxbyg/bed/sythian/pink" | "create:cut_limestone_slab_recycling" | "botanypots:botanypots/crafting/magenta_terracotta_compact_hopper_botany_pot" | "sophisticatedstorage:brown_shulker_box_to_sophisticated" | "create:crafting/kinetics/red_seat" | "create:deploying/waxed_copper_shingle_slab_from_adding_wax" | "ae2:network/parts/quartz_fiber_part" | "immersiveengineering:crafting/constantan_mix" | "mekanism:jetpack" | "mekanism:compat/ilikewoodxbyg/crafting_table/redwood" | "immersiveengineering:sawmill/spruce_stairs" | "pamhc2foodextended:hamsweetpicklesandwichitem" | "mekanism:compat/ilikewoodxbyg/crafting_table/lament" | "biomeswevegone:ebony_crafting_table" | "pamhc2foodextended:limepieitem" | "immersiveengineering:metalpress/gear_lead" | "connectedglass:borderless_glass_light_gray_pane3" | "connectedglass:borderless_glass_light_gray_pane2" | "create:crafting/kinetics/track_observer_from_other_plates" | "create:cutting/compat/regions_unexplored/joshua_log" | "connectedglass:borderless_glass_light_gray_pane1" | "minecraft:dried_kelp_from_campfire_cooking" | "create:cut_ochrum_stairs_from_stone_types_ochrum_stonecutting" | "mekanism:compat/ilikewood/bed/warped/painting/red" | "immersiveengineering:sawmill/stripped_oak_log" | "mekanism:configurator" | "pamhc2foodextended:cantonesenoodlesitem" | "mekanism:painting/glass_pane/green" | "create:cutting/stripped_mangrove_log" | "pamhc2foodextended:cornonthecobitem" | "create:pressing/gold_ingot" | "mekanism:compat/ilikewoodxbyg/bed/mahogany/blue" | "mekanism:compat/ilikewoodxbyg/bed/white_mangrove/orange" | "create:crafting/kinetics/light_gray_seat_from_other_seat" | "biomeswevegone:zelkova_fence" | "botanytrees:biomeswevegone/brown_zelkova" | "mekanism:sawing/hanging_sign/bamboo" | "sophisticatedstorage:iron_to_gold_tier_upgrade" | "mekanism:compat/byg/pigment_extracting/red" | "create:cutting/compat/regions_unexplored/palm_wood" | "ae2:network/cables/dense_covered_light_blue" | "mekanism:processing/iron/clump/from_ore" | "pamhc2foodextended:rootbeersodaitem" | "mekanism:compat/ilikewoodxbyg/bed/redwood/painting/light_gray" | "createaddition:compat/tconstruct/blaze_blood" | "create:pressing/peat_dirt_path" | "pamhc2crops:roastedrhubarbitem_forge" | "connectedglass:tinted_borderless_glass_red2" | "connectedglass:scratched_glass_gray2" | "sophisticatedstorage:basic_to_netherite_tier_upgrade" | "connectedglass:scratched_glass_gray1" | "minecraft:brown_stained_glass_pane" | "immersiveengineering:crafting/strip_curtain" | "biomeswevegone:red_rock_stairs" | "minecraft:black_terracotta" | "immersiveengineering:crafting/voltmeter" | "mekanism:compat/ilikewoodxbyg/bed/mahogany/lime" | "mekanism:painting/glass_pane/white" | "botanytrees:pamhc2trees/pistachio_sapling" | "botanypots:botanypots/crafting/green_terracotta_hopper_botany_pot" | "mekanism:compat/byg/sawing/door/ebony" | "mekanism:compat/ilikewoodxbyg/ladder/imparius" | "create:splashing/endergetic/petrified_overworld_corrock" | "create:crafting/kinetics/pink_valve_handle_from_other_valve_handle" | "minecraft:spruce_slab" | "pamhc2foodcore:doughitem_x2" | "sophisticatedstorage:jungle_chest" | "pamhc2foodextended:cinnamonrollitem" | "pamhc2foodcore:chorusmuffinitem" | "merequester:requester_terminal" | "ae2:shaped/stairs/smooth_sky_stone_block" | "create:compacting/andesite_from_flint" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/redwood/painting/pink" | "mekanism:compat/ilikewoodxbyg/bed/willow/green" | "mekanism:enriching/conversion/diorite/slab_to_polished_slab" | "mekanism:compat/ilikewoodxbyg/post/blue_enchanted" | "powah:crafting/crystal_blazing" | "mekanism:compat/ilikewood/bed/birch/yellow" | "immersiveengineering:crafting/stairs_steel_scaffolding_standard" | "mekanism:compat/byg/enriching/soapstone/brick_slabs_to_tile_slabs" | "mekanism:compat/ilikewood/bed/cherry/magenta" | "minecraft:pumpkin_pie" | "create:crushing/compat/exnihilosequentia/dust" | "botanypots:pamhc2crops/crop/cantaloupe" | "mekanism:sawing/bed/blue" | "mekanism:compat/ilikewood/bed/spruce/painting/white" | "immersiveengineering:crafting/stairs_steel_scaffolding_wooden_top" | "mekanism:induction/provider/basic" | "mekanism:painting/banner/white" | "ae2:block_cutter/walls/fluix_wall" | "mekanism:compat/ilikewood/bed/spruce/light_blue" | "storagenetwork:exchange" | "mekanism:compat/ilikewoodxbyg/bed/willow/painting/yellow" | "mekanism:nucleosynthesizing/respawn_anchor" | "mekanism:enriching/conversion/deepslate/polished_slabs_to_tile" | "mekanism:sawing/log/birch" | "waystones:blue_sharestone" | "sophisticatedbackpacks:chipped/tinkering_table_upgrade" | "immersiveengineering:smelting/ingot_electrum_from_dust_from_blasting" | "minecraft:dacite_tile_wall_from_dacite_tile_stonecutting" | "create:crushing/deepslate_diamond_ore" | "biomeswevegone:witch_hazel_slab" | "mekanism:compat/ilikewood/bed/mangrove/light_gray" | "minecraft:gold_ingot_from_smelting_nether_gold_ore" | "create:cut_deepslate_stairs_from_stone_types_deepslate_stonecutting" | "pamhc2foodextended:cranberryjellytoastitem" | "pamhc2foodextended:rootbeerfloatitem" | "biomeswevegone:ebony_boat" | "sophisticatedstorage:smoking_upgrade_from_smelting_upgrade" | "naturalist:cut_shellstone_stairs" | "minecraft:smoking_cookedgroundchickenitem" | "mekanism:compat/ilikewoodxbyg/composter/cypress" | "mekanism:injecting/concrete/light_blue" | "connectedglass:borderless_glass_green_pane1" | "mekanism:compat/byg/sawing/pressure_plate/pine" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/dead/light_blue" | "mekanism:induction/provider/ultimate" | "connectedglass:borderless_glass_green_pane3" | "mekanism:compat/ilikewoodxbyg/chest/imparius" | "connectedglass:borderless_glass_green_pane2" | "mekanismtools:stone_paxel" | "ae2:misc/deconstruction_fluix_block" | "mekanism:sawing/pumpkin" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/hellbark/painting/gray" | "biomeswevegone:smooth_purple_sandstone_slab" | "create:small_ochrum_bricks_from_stone_types_ochrum_stonecutting" | "compressium:copper_1_uncraft" | "mekanism:compat/ilikewoodxbyg/torch/zelkova" | "biomeswevegone:cypress_trapdoor" | "createaddition:pressing/aluminum_ingot" | "mekanism:compat/ilikewoodxbyg/bed/blue_enchanted/white" | "easy_mob_farm:mob_farm/iron_golem_farm/tier2_iron_golem_farm" | "mekanismtools:bronze/tools/axe" | "mekanism:compat/ilikewood/bed/acacia/painting/white" | "minecraft:lapis_lazuli_from_blasting_lapis_ore" | "woodwevegot:willow_trapped_chest" | "minecraft:rib_armor_trim_smithing_template" | "easy_mob_farm:mob_farm/jungle_farm/tier2_jungle_farm" | "dankstorage:6_to_7" | "minecraft:cooked_chicken_from_campfire_cooking" | "create:emptying/compat/farmersdelight/milk_bottle" | "easy_mob_farm:mob_farm/bee_hive_farm/tier2_bee_hive_farm" | "mekanism:compat/ilikewoodxbyg/bed/cherry/pink" | "mekanism:compat/ilikewoodxbyg/bed/green_enchanted/painting/brown" | "prefab:potatoes_from_bunch" | "draconicevolution:modules/item_draconic_proj_damage" | "mekanism:compat/ilikewoodxbyg/bed/green_enchanted/yellow" | "immersiveengineering:crusher/ore_emerald" | "ae2:inscriber/logic_processor_print" | "botanypots:botanypots/crafting/lime_concrete_hopper_botany_pot" | "create:cutting/compat/quark/blossom_log" | "pamhc2foodextended:passionfruitpieitem" | "immersiveengineering:arcfurnace/dust_constantan" | "biomeswevegone:cooked_white_puffball_cap_from_campfire" | "minecraft:quartz_pillar_from_quartz_block_stonecutting" | "draconicevolution:modules/item_draconic_shield_capacity" | "pamhc2foodextended:dateyogurtitem" | "mekanism:transmitter/pressurized_tube/elite" | "connectedglass:vanilla_pink_stained_glass" | "crafting_on_a_stick:uncraft_cartography_table" | "mekanism:compat/ilikewood/bed/cherry/painting/red" | "minecraft:mossy_cobblestone_wall_from_mossy_cobblestone_stonecutting" | "minecraft:observer" | "pamhc2foodextended:cornmealitem" | "minecraft:cooked_cod_from_campfire_cooking" | "mekanism:crushing/biofuel/lily_pad" | "create:cutting/compat/byg/stripped_baobab_log" | "apotheosis:soul_touched_deepshelf" | "mekanism:compat/ilikewood/bed/warped/painting/light_blue" | "create:cutting/compat/blue_skies/bluebright_wood" | "create_sa:brass_chestplate_recipe" | "pamhc2foodextended:beetburgeritem" | "minecraft:dye_purple_bed" | "biomeswevegone:zelkova_chest_boat" | "create:cutting/compat/endergetic/poise_stem" | "mekanism:compat/ilikewoodxbyg/bed/green_enchanted/painting/light_gray" | "mekanismgenerators:generator/gas_burning" | "create:milling/bone_meal" | "create:mixing/andesite_alloy" | "minecraft:pink_dye_from_peony" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/redwood/green" | "create:cutting/compat/byg/holly_wood" | "storagenetwork:speed_upgrade" | "create:cutting/compat/regions_unexplored/blue_bioshroom_hyphae" | "sophisticatedbackpacks:chipped/botanist_workbench_upgrade" | "create:compacting/chocolate" | "powah:crafting/battery_niotic" | "advanced_ae:damagedbudding" | "immersiveengineering:crafting/raw_hammercrushing_copper" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/mahogany/gray" | "connectedglass:clear_glass_white_pane1" | "connectedglass:clear_glass_white_pane2" | "connectedglass:clear_glass_white_pane3" | "mekanism:compat/ilikewoodxbiomesoplenty/panel/mahogany" | "pamhc2foodextended:pralinesitem" | "create:cutting/compat/regions_unexplored/stripped_kapok_wood" | "mekanism:compat/ilikewoodxbyg/bed/witch_hazel/black" | "minecraft:chiseled_deepslate" | "mekanism:injecting/oxidizing/oxidized_cut_copper" | "minecraft:soul_torch" | "minecraft:mossy_stone_stairs_from_mossy_stone_stonecutting" | "create:crushing/gilded_blackstone" | "create:milling/compat/byg/iris" | "domum_ornamentum:purple_floating_carpet" | "powah:crafting/player_tranmitter_hardened" | "storagenetwork:import_kabel" | "pamhc2foodextended:gourmetbeefburgeritem" | "mekanism:hazmat_gown" | "pamhc2crops:barrelcactusseeditem" | "create:crushing/compat/elementaryores/ore_ghast_nether" | "createaddition:compat/jeed/shocking" | "create:cut_tuff_wall" | "pamhc2foodextended:greengrapejuiceitem" | "mekanism:combining/rooted_dirt" | "immersiveengineering:crafting/drill" | "create:crafting/kinetics/super_glue" | "mekanism:compat/ilikewood/barrel/bamboo" | "minecraft:weathered_cut_copper_from_weathered_copper_stonecutting" | "sophisticatedstorage:backpack_auto_blasting_upgrade_from_storage_auto_blasting_upgrade" | "mekanism:compat/ilikewoodxbyg/bed/sythian/painting/light_blue" | "minecraft:gray_dye" | "mekanism:compat/ilikewood/item_frame/mangrove" | "biomeswevegone:birch_planks_from_palo_verde_logs" | "immersiveengineering:sawmill/jungle_wood" | "domum_ornamentum:vanilla_doors_compat_full" | "minecraft:slime_ball" | "create:crafting/kinetics/black_seat_from_other_seat" | "biomeswevegone:ironwood_bookshelf" | "mekanism:compat/ilikewoodxbyg/soul_torch/maple" | "ae2:network/parts/energy_acceptor" | "create:splashing/atmospheric/arid_sand" | "create:cutting/compat/atmospheric/morado_wood" | "jamd:portal_block" | "mekanism:compat/ilikewoodxbyg/bed/lament/painting/blue" | "ae2:network/cables/smart_light_blue" | "connectedglass:tinted_borderless_glass1" | "biomeswevegone:pink_sandstone_wall" | "utilitarian:no_soliciting/soliciting_carpets/white_trapped_soliciting_carpet" | "mekanism:processing/lead/ingot/from_raw_blasting" | "mekanism:compat/ilikewood/bed/crimson/black" | "pamhc2foodextended:cornishpastyitem" | "immersiveengineering:sawmill/birch_log" | "mekanism:compat/ilikewoodxbyg/composter/nightshade" | "mekanism:compat/ilikewoodxbyg/bed/ether/painting/pink" | "compressium:diamond_3_uncraft" | "naturalist:pumpkin_pie" | "draconicevolution:components/chaotic_energy_core" | "create:calcite_from_stone_types_calcite_stonecutting" | "mekanism:painting/wool/magenta" | "mekanism:compat/byg/sawing/pressure_plate/rainbow_eucalyptus" | "create:cutting/compat/regions_unexplored/larch_wood" | "create:cut_limestone_brick_slab_recycling" | "mekanism:painting/bed/black" | "minecraft:end_stone_brick_slab_from_end_stone_brick_stonecutting" | "minecraft:iron_sword" | "sophisticatedstorage:copper_barrel" | "ae2:network/blocks/interfaces_interface_alt" | "apotheosis:sigil_of_withdrawal" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/redwood/purple" | "create:milling/saddle" | "biomeswevegone:ebony_button" | "pamhc2foodextended:rawtofuttonitem" | "mekanism:compat/ilikewood/bed/spruce/painting/yellow" | "create:splashing/thermal/crushed_raw_tin" | "immersiveengineering:crusher/prismarine_brick" | "biomeswevegone:maple_pressure_plate" | "mekanism:compat/ilikewoodxbyg/bed/skyris/blue" | "create:splashing/oreganized/crushed_raw_lead" | "connectedglass:scratched_glass_lime_pane3" | "connectedglass:scratched_glass_lime_pane2" | "connectedglass:scratched_glass_lime_pane1" | "create:small_ochrum_brick_slab_from_stone_types_ochrum_stonecutting" | "minecraft:chiseled_sandstone_from_sandstone_stonecutting" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/magic/cyan" | "botanytrees:pamhc2trees/olive_sapling" | "ae2:shaped/walls/sky_stone_brick" | "comforts:hammock_red" | "create:cutting/compat/silentgear/netherwood_wood" | "biomeswevegone:skyris_door" | "mekanism:compat/ilikewoodxbyg/bed/skyris/painting/red" | "pamhc2foodextended:mixedsaladitem" | "create:milling/compat/environmental/magenta_hibiscus" | "ae2:matter_cannon/nuggets/carbon" | "pamhc2crops:ryeseeditem" | "mekanism:compat/ilikewood/bed/spruce/painting/pink" | "immersiveengineering:sawmill/jungle_stairs" | "minecraft:cut_copper_stairs_from_cut_copper_stonecutting" | "wstweaks:lava_blade" | "mekanism:compat/ilikewood/bed/spruce/red" | "mekanism:injecting/coral/bubble_coral" | "minecraft:bamboo_pressure_plate" | "powah:crafting/cable_basic" | "mekanism:painting/banner/green" | "mekanism:compat/ilikewood/bed/bamboo/light_gray" | "immersiveengineering:blueprint/circuit_board" | "pamhc2foodextended:starfruitjellyitem" | "biomeswevegone:redwood_hanging_sign" | "create:crafting/appliances/netherite_backtank" | "botanypots:minecraft/crop/spore_blossom" | "create:crafting/kinetics/metal_girder" | "mekanism:compat/ilikewood/bed/bamboo/red" | "create:crafting/kinetics/millstone" | "mekanism:crushing/deepslate/tile_slabs_to_cobbled" | "mekanism:pigment_extracting/banner/black" | "pamhc2foodextended:ranchfriedchickenitem" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/cherry/purple" | "mekanism:compat/ilikewoodxbyg/bed/skyris/red" | "draconicevolution:modules/item_wyvern_shield_capacity" | "compressium:andesite_8_uncraft" | "pamhc2crops:cabbageseeditem" | "mekanism:factory/ultimate/sawing" | "immersiveengineering:mineral/ancient_seabed" | "minecraft:sticky_piston" | "mekanism:compat/ilikewoodxbyg/bed/lament/painting/lime" | "sophisticatedstorage:spruce_chest" | "immersiveengineering:metalpress/plate_electrum" | "mekanism:processing/tin/shard/from_crystal" | "mekanism:compat/byg/crushing/travertine/chiseled_stairs_to_polished_stairs" | "minecraft:exposed_cut_copper_slab_from_exposed_copper_stonecutting" | "create:milling/compat/botania/magenta_petal" | "mekanism:compat/ilikewoodxbyg/bed/cherry/painting/cyan" | "naturalist:cooked_venison_from_campfire_cooking" | "powah:crafting/ender_gate_starter_2" | "mekanism:compat/ae2/decorative/sky_stone/crushing/smooth_slab_to_slab" | "jaopca:create.crushed_to_material_smelting.draconium" | "sophisticatedstorage:storage_stack_upgrade_tier_5_from_backpack_stack_upgrade_tier_4" | "immersiveengineering:crafting/toolupgrade_shield_shock" | "mekanism:compat/ilikewoodxbyg/bed/cypress/painting/purple" | "mekanism:compat/ilikewoodxbyg/bed/aspen/black" | "mekanism:crushing/biofuel/wheat" | "mekanism:compat/ilikewoodxbyg/post/redwood" | "mekanism:compat/ilikewoodxbyg/bed/skyris/lime" | "megacells:cells/standard/chemical_storage_cell_256m" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/cherry/painting/white" | "pamhc2crops:bottle_x2_calabash_x2" | "immersiveengineering:stonecutting/stairs_hempcrete_brick" | "sophisticatedbackpacks:stack_upgrade_starter_tier" | "ae2:matter_cannon/nuggets/cobalt" | "minecraft:cut_windswept_sandstone_from_windswept_sandstone_stonecutting" | "biomeswevegone:holly_pressure_plate" | "botanytrees:pamhc2trees/rambutan_sapling" | "utilitarian:no_soliciting/soliciting_carpets/red_soliciting_carpet" | "ftbquests:loot_crate_opener" | "mekanism:compat/ilikewood/composter/dark_oak" | "create:exposed_copper_tile_slab_from_exposed_copper_tiles_stonecutting" | "elevatorid:elevator_pink" | "mekanism:pigment_extracting/stained_glass_pane/purple" | "immersiveengineering:sawmill/crimson_wood" | "pamhc2foodextended:gingersnapsitem" | "mekanism:compat/ilikewoodxbiomesoplenty/chest/redwood" | "pamhc2foodextended:hushpuppiesitem" | "jaopca:storage_blocks.to_storage_block.fluix" | "botanypots:botanypots/crafting/blue_terracotta_hopper_botany_pot" | "create:cut_dripstone_wall" | "mekanism:compat/ilikewoodxbyg/panel/cherry" | "mekanism:compat/ilikewoodxbyg/bed/embur/painting/purple" | "mekanism:compat/byg/dye/light_blue" | "dimstorage:dimensional_tank" | "mekanism:pigment_extracting/wool/magenta" | "create:cutting/compat/byg/mahogany_log" | "prefab:paper_lantern" | "pamhc2crops:peanutseeditem" | "minecraft:cut_red_sandstone" | "sophisticatedstorage:packing_tape" | "mekanism:control_circuit/ultimate" | "mekanism:crushing/biofuel/acacia_sapling" | "mekanism:module_radiation_shielding_unit" | "mekanism:crushing/biofuel/warped_fungus" | "mekanism:compat/ilikewoodxbyg/bed/witch_hazel/painting/light_blue" | "megacells:cells/cell_component_256m" | "immersiveengineering:metalpress/plate_uranium" | "minecraft:smooth_pink_sandstone_slab_from_pink_sandstone_stonecutting" | "immersiveengineering:blueprint/bullet_casull" | "pamhc2trees:roastedwalnutitem_campfire" | "botanypots:botanypots/crafting/green_terracotta_compact_hopper_botany_pot" | "create:crafting/copper/waxed_exposed_copper_shingles_from_honeycomb" | "create:milling/compat/botania/brown_petal" | "create:cut_limestone_brick_stairs" | "mekanism:painting/glass_pane/cyan" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/willow/painting/cyan" | "powah:crafting/furnator_starter" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/willow/painting/black" | "create:cutting/compat/regions_unexplored/dead_log" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/cherry/painting/magenta" | "minecraft:deepslate_brick_stairs_from_polished_deepslate_stonecutting" | "compressium:redstone_7_uncraft" | "create:item_application/copper_casing_from_log" | "create:crushing/raw_quicksilver" | "immersiveengineering:smelting/nugget_steel_recycle_axe" | "immersiveengineering:metalpress/plate_lead" | "connectedglass:scratched_glass_light_gray_pane2" | "connectedglass:scratched_glass_light_gray_pane1" | "connectedglass:scratched_glass_light_gray_pane3" | "powah:crafting/cable_spirited_2" | "draconicevolution:tools/chaotic_pickaxe" | "create_sa:zinc_leggings_recipe" | "minecraft:cobblestone_wall_from_cobblestone_stonecutting" | "ae2:network/cells/item_cell_housing" | "sophisticatedstorage:purple_shulker_box_to_sophisticated" | "botanypots:botanypots/crafting/black_glazed_terracotta_botany_pot" | "compressium:obsidian_1_uncraft" | "mekanism:painting/wool/black" | "domum_ornamentum:light_gray_brick_extra" | "create:crafting/copper/waxed_copper_tile_slab_from_honeycomb" | "immersiveengineering:smelting/ingot_lead_from_dust_from_blasting" | "ae2:shaped/walls/smooth_sky_stone_block" | "mekanism:compat/ilikewood/ladder/oak" | "jaopca:mekanism.raw_storage_block_to_dirty_slurry.silver" | "comforts:hammock_to_magenta" | "minecraft:yellow_dye_from_sunflower" | "create:milling/compat/byg/purple_amaranth" | "botanypots:botanypots/crafting/white_terracotta_botany_pot" | "megacells:cells/standard/chemical_storage_cell_16m" | "immersiveengineering:crafting/copper_ingot_to_nugget_copper" | "create:small_crimsite_bricks_from_stone_types_crimsite_stonecutting" | "utilitarian:fluid_hopper" | "create:cutting/compat/regions_unexplored/socotra_wood" | "minecraft:oak_slab" | "mekanism:sawing/boat/acacia" | "create:milling/compat/atmospheric/scalding_monkey_brush" | "create_sa:zinc_pickaxe_recipe" | "pamhc2foodextended:blackpepperitem" | "botanypots:minecraft/soil/lapis_ore" | "sophisticatedstorage:storage_link" | "mekanism:module_locomotive_boosting_unit" | "create:tiled_glass_from_glass_colorless_stonecutting" | "mekanism:compat/ilikewoodxbyg/bed/holly/light_blue" | "immersiveengineering:crusher/ingot_tungsten" | "pamhc2foodextended:durianjuiceitem" | "create:milling/sea_pickle" | "create:smelting/silver_ingot_compat_thermal" | "mekanismtools:refined_glowstone/tools/sword" | "immersiveengineering:crafting/concrete" | "mekanism:painting/banner/light_gray" | "mekanism:paper" | "biomeswevegone:palm_wood" | "mekanismtools:lapis_lazuli/tools/sword" | "pamhc2foodextended:gravyitem" | "megacells:cells/standard/fluid_storage_cell_4m" | "mekanismtools:steel/tools/axe" | "mekanism:storage_blocks/refined_obsidian" | "cookingforblockheads:dye_brown_oven" | "mekanism:compat/ilikewood/bed/warped/black" | "immersiveengineering:crafting/fluorescent_tube" | "immersiveengineering:blueprint/bullet_buckshot" | "draconicevolution:modules/item_draconic_proj_velocity" | "mekanism:compat/ilikewoodxbyg/bed/holly/painting/light_gray" | "pamhc2trees:cinnamon_sapling" | "pamhc2foodextended:cookedtofaconitem_forge" | "ae2:transform/chipped_budding_quartz" | "mekanism:enriching/conversion/purpur_pillar_from_block" | "mekanism:painting/concrete/blue" | "create:crafting/kinetics/mechanical_plough" | "mekanism:transmitter/universal_cable/ultimate" | "create:milling/compat/biomesoplenty/violet" | "create:framed_glass_pane" | "botanypots:minecraft/crop/red_tulip" | "mekanism:painting/candle/purple" | "chunkloaders:single_to_basic_chunk_loader" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/magic/orange" | "mekanism:meka_tool" | "mekanism:compat/ilikewoodxbyg/bed/skyris/painting/blue" | "create:crushing/compat/silentgems/ruby_ore" | "minecraft:oxidized_cut_copper_stairs_from_oxidized_cut_copper_stonecutting" | "mekanism:pigment_extracting/flower/small_yellow" | "mekanism:pigment_extracting/dye/red" | "mekanism:compat/ilikewood/bed/acacia/painting/red" | "mekanism:pigment_extracting/flower/large_yellow" | "mekanism:compat/ilikewoodxbyg/bed/embur/pink" | "immersiveengineering:crafting/toolupgrade_revolver_magazine" | "mekanism:compat/ilikewoodxbyg/soul_torch/palm" | "biomeswevegone:cyan_dye_from_bwg_tag" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/cherry/painting/orange" | "mekanism:compat/byg/sawing/chest_boat/maple" | "mekanism:compat/ilikewoodxbyg/bed/nightshade/painting/light_gray" | "mekanism:sawing/trapdoor/dark_oak" | "megacells:cells/standard/fluid_storage_cell_1m" | "immersiveengineering:alloysmelter/bronze" | "create:crafting/logistics/andesite_tunnel" | "draconicevolution:machines/awakened_crafting_injector" | "pamhc2foodextended:dragonfruitsmoothieitem" | "immersiveengineering:crafting/stick_steel" | "biomeswevegone:sakura_planks" | "domum_ornamentum:orange_brick_extra" | "create:splashing/crushed_raw_iron" | "minecraft:chiseled_black_sandstone_from_black_sandstone_stonecutting" | "mekanism:compat/ilikewoodxbiomesoplenty/torch/fir" | "sophisticatedstorage:gold_shulker_from_gold_chest" | "ae2:network/crystal_resonance_generator" | "pamhc2foodextended:cinnamonbreaditem" | "mekanism:compat/ae2/decorative/certus_quartz/enriching/pillar_wall_to_chiseled_wall" | "create:milling/compat/upgrade_aquatic/flowering_rush" | "minecraft:dye_black_carpet" | "ae2:matter_cannon/nuggets/lithium" | "biomeswevegone:pine_stairs" | "immersiveengineering:sawmill/oak_door" | "draconicevolution:components/draconium_ingot_from_ore" | "mekanism:compat/biomesoplenty/sawing/pressure_plate/umbran" | "mekanism:compat/ilikewoodxbyg/composter/pine" | "minecraft:polished_blackstone_brick_wall_from_blackstone_stonecutting" | "mekanism:crushing/biofuel/carrot" | "mekanism:compat/ilikewood/bed/oak/painting/lime" | "botanypots:minecraft/pot_interaction/till_rooted_dirt_to_dirt" | "mekanism:painting/concrete/lime" | "draconicevolution:tools/draconic_staff" | "megacells:inscriber/accumulation_processor" | "create:cut_asurine_slab_recycling" | "pamhc2foodextended:greeneggsandhamitem" | "minecraft:magma_block" | "create:cut_limestone_wall_from_stone_types_limestone_stonecutting" | "draconicevolution:fluid_gate" | "mekanism:compat/byg/sawing/boat/fir" | "mekanism:compat/byg/sawing/door/skyris" | "pamhc2foodextended:potatoesobrienitem" | "easy_mob_farm:upgrade/slot/big_slot_upgrade" | "mekanism:compat/ilikewoodxbyg/bed/cika/painting/pink" | "pamhc2foodextended:apricotpieitem" | "mekanism:compat/ilikewoodxbyg/barrel/skyris" | "minecraft:deepslate_tile_slab_from_deepslate_tiles_stonecutting" | "mekanism:compat/ilikewoodxbyg/bed/pine/purple" | "biomeswevegone:cooked_oddion_bulb_from_campfire" | "mekanism:compat/ilikewoodxbyg/bed/skyris/painting/lime" | "mekanism:pigment_extracting/stained_glass/yellow" | "mekanism:compat/ilikewoodxbyg/barrel/palm" | "mekanism:compat/ilikewoodxbyg/bed/ebony/lime" | "mekanism:compat/ilikewoodxbyg/bed/redwood/cyan" | "mekanism:processing/tin/ingot/from_block" | "mekanism:sawing/fence_gate/spruce" | "pamhc2foodextended:papayajellytoastitem" | "minecraft:dacite_cobblestone_stairs_from_dacite_cobblestone_stonecutting" | "create:cutting/compat/byg/blue_enchanted_wood" | "pamhc2foodextended:strawberryjuiceitem" | "create:deploying/waxed_exposed_cut_copper_from_adding_wax" | "advanced_ae:quantum_alloy_block_wall" | "ae2:matter_cannon/nuggets/osmium" | "mekanism:pigment_extracting/flower/black" | "immersiveengineering:crafting/sheetmetal_colored_cyan" | "create:sequenced_assembly/track" | "immersiveengineering:stonecutting/concrete_chiseled2" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/jacaranda/light_blue" | "create:mixing/tea" | "naturalist:shellstone_stairs_from_stonecutting" | "powah:crafting/manual" | "create:cut_deepslate_wall" | "create:milling/compat/buzzier_bees/white_clover" | "sophisticatedstorage:backpack_chipped_loom_table_upgrade_from_storage_chipped_loom_table_upgrade" | "immersiveengineering:crafting/alu_scaffolding_standard_to_slab" | "mekanism:compat/ilikewood/lectern/spruce" | "create:cutting/compat/twilightforest/stripped_dark_wood" | "mekanism:compat/byg/enriching/scoria/stairs_to_brick_stairs" | "mekanism:compat/ae2/decorative/sky_stone/enriching/smooth_slab_to_brick_slab" | "mekanism:compat/byg/sawing/door/bulbis" | "yungscavebiomes:ancient_sandstone_stairs" | "pamhc2foodextended:meatpieitem" | "create_sa:copper_magnet_recipe" | "immersiveengineering:fermenter/honey" | "pamhc2foodextended:lycheesmoothieitem" | "ae2:network/cables/dense_smart_purple" | "minecraft:blaze_powder" | "pamhc2crops:bakedsweetpotatoitem_campfire" | "minecraft:chain" | "create:cutting/compat/byg/imparius_hyphae" | "domum_ornamentum:blue_floating_carpet" | "mekanism:processing/gold/dust/from_raw_ore" | "biomeswevegone:blue_enchanted_crafting_table" | "pamhc2foodextended:cookedtofuttonitem_smoker" | "pamhc2foodcore:honeypieitem" | "mekanism:infusion_conversion/redstone/from_enriched" | "minecraft:oak_fence" | "woodwevegot:witch_hazel_barrel" | "mekanism:compat/byg/sawing/trapdoor/rainbow_eucalyptus" | "create:polished_cut_calcite_wall_from_stone_types_calcite_stonecutting" | "create:blasting/lead_ingot_compat_thermal" | "buddingcrystals:budding_salt" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/cherry/painting/green" | "mekanism:compat/ilikewoodxbyg/barrel/lament" | "ae2:decorative/sky_stone_small_brick_from_stonecutting" | "waystones:brown_sharestone" | "pamhc2foodcore:potatochipsitem" | "mekanism:compat/ilikewood/bed/jungle/painting/blue" | "mekanism:enriching/conversion/stone/cracked_bricks_to_bricks" | "mekanism:compat/ilikewoodxbyg/bed/fir/painting/orange" | "advanced_ae:quantum_infused_dust" | "mekanism:compat/ilikewoodxbyg/bed/ebony/blue" | "immersiveengineering:crafting/fertilizer" | "mekanism:compat/ilikewoodxbyg/bed/aspen/painting/magenta" | "immersiveengineering:crafting/generator" | "create:cutting/compat/endergetic/stripped_poise_stem" | "draconicevolution:modules/item_wyvern_junk_filter" | "create:cutting/compat/regions_unexplored/stripped_cobalt_wood" | "create:cutting/compat/regions_unexplored/brimwood_wood" | "buildinggadgets2:gadget_destruction" | "woodwevegot:ebony_ladder" | "minecraft:deepslate" | "ae2:matter_cannon/nuggets/palladium" | "immersiveengineering:smelting/ingot_silver_from_blasting3" | "aquaculture:neptunium_pickaxe" | "immersiveengineering:smelting/ingot_silver_from_blasting2" | "ae2:inscriber/calculation_processor" | "draconicevolution:modules/item_wyvern_hill_step" | "pamhc2trees:jackfruit_sapling" | "mekanism:crushing/red_sandstone_to_sand" | "connectedglass:scratched_glass_light_gray1" | "ftbquests:task_screen_configurator" | "mekanism:processing/uranium/dust/from_ingot" | "connectedglass:scratched_glass_light_gray2" | "create:milling/compat/environmental/blue_delphinium" | "immersiveengineering:crafting/tesla_coil" | "immersiveengineering:crafting/wooden_barrel" | "mekanism:compat/ilikewoodxbyg/wall/pine" | "draconicevolution:modules/item_draconium_damage" | "pamhc2foodcore:tool_saucepan" | "biomeswevegone:white_mangrove_door" | "mekanism:painting/glass/lime" | "connectedglass:clear_glass_blue1" | "ae2:tools/certus_quartz_spade" | "biomeswevegone:red_dye_from_bwg_tag" | "connectedglass:clear_glass_blue2" | "mekanism:compat/ilikewood/lectern/birch" | "chunkloaders:advanced_chunk_loader" | "pamhc2crops:hotcoffeeitem_smoker" | "minecraft:prismarine_slab_from_prismarine_stonecutting" | "biomeswevegone:maple_fence" | "pamhc2foodextended:soursopjellytoastitem" | "ae2:network/cables/dense_covered_black" | "immersiveengineering:crafting/armor_faraday_helmet" | "botanytrees:pamhc2trees/apricot_sapling" | "minecraft:deepslate_tile_wall_from_deepslate_bricks_stonecutting" | "minecraft:green_terracotta" | "megacells:crafting/mega_crafting_monitor" | "minecraft:white_stained_glass" | "mekanism:compat/ilikewoodxbyg/bed/imparius/brown" | "immersiveengineering:metalpress/gear_ardite" | "createaddition:rolling/steel_plate" | "mekanism:enriching/conversion/deepslate/cobbled_slabs_to_polished" | "mekanism:compat/ilikewood/crafting_table/warped" | "draconicevolution:machines/basic_crafting_injector" | "create:cut_diorite_brick_stairs_from_stone_types_diorite_stonecutting" | "mekanism:sawing/sign" | "mekanism:enriching/dye/small_red" | "minecraft:purpur_stairs" | "biomeswevegone:cika_pressure_plate" | "mekanism:module_excavation_escalation_unit" | "mekanism:painting/glass/purple" | "ae2:misc/fluixpearl" | "immersiveengineering:crafting/conveyor_extract_covered" | "botanytrees:pamhc2trees/grapefruit_sapling" | "botanypots:pamhc2crops/crop/broccoli" | "connectedglass:scratched_glass_pink_pane3" | "connectedglass:scratched_glass_pink_pane2" | "compressium:obsidian_4_uncraft" | "connectedglass:scratched_glass_pink_pane1" | "create:cut_limestone_stairs_from_stone_types_limestone_stonecutting" | "draconicevolution:machines/reactor_prt_out_rotor" | "mekanism:module_gyroscopic_stabilization_unit" | "mekanism:compat/ilikewoodxbiomesoplenty/post/willow" | "buildinggadgets2:gadget_building" | "botanypots:pamhc2crops/crop/sisal" | "immersiveengineering:crafting/clinker_brick_quoin" | "create:cutting/compat/atmospheric/stripped_aspen_log" | "minecraft:ward_armor_trim_smithing_template" | "mekanism:compat/ilikewood/bed/acacia/light_blue" | "immersiveengineering:smelting/nugget_aluminum_recycle_faraday_helmet_from_blasting" | "mekanism:solar_neutron_activator" | "sophisticatedbackpacks:auto_blasting_upgrade" | "jaopca:immersiveengineering.dust_to_material.hop_graphite" | "pamhc2foodextended:groundcinnamonitem" | "immersiveengineering:arcfurnace/dust_iron" | "botanypots:botanypots/crafting/lime_glazed_terracotta_botany_pot" | "ae2:tools/paintballs_lumen_pink" | "mekanism:chemical_infusing/hydrogen_chloride" | "create:crushing/compat/exnihilosequentia/netherrack" | "biomeswevegone:palm_planks" | "compressium:emerald_2" | "compressium:emerald_3" | "compressium:emerald_4" | "mekanism:painting/glass/blue" | "mekanism:compat/ilikewoodxbyg/bed/cherry/painting/magenta" | "compressium:emerald_5" | "compressium:emerald_6" | "mekanism:combining/wax/waxed_exposed_cut_copper_stairs" | "compressium:emerald_7" | "minecraft:quartz_from_blasting" | "compressium:emerald_8" | "compressium:emerald_9" | "mekanism:compat/byg/sawing/trapdoor/imparius" | "domum_ornamentum:vanilla_trapdoors_compat_porthole" | "powah:crafting/energy_discharger_blazing" | "mekanism:compat/ilikewood/bed/dark_oak/painting/blue" | "compressium:emerald_1" | "mekanism:enriching/conversion/mossy/cobblestone_stairs" | "apotheosis:spawner/ignore_players_inverted" | "immersiveengineering:crafting/plate_aluminum_hammering" | "immersiveengineering:mixer/concrete" | "createaddition:filling/honey_cake" | "buddingcrystals:budding_refinedglowstone" | "botanypots:pamhc2crops/crop/witersquash" | "crafting_on_a_stick:loom" | "pamhc2foodextended:veggiestripsitem" | "pamhc2foodextended:peanutchocolatebaritem" | "minecraft:gold_nugget" | "create:cut_ochrum_slab_from_stone_types_ochrum_stonecutting" | "mekanism:compat/ilikewoodxbyg/bed/holly/painting/white" | "mekanism:compat/ilikewoodxbyg/barrel/redwood" | "mekanism:compat/ilikewoodxbyg/bed/ether/magenta" | "create:small_dripstone_brick_slab" | "biomeswevegone:rocky_stone" | "immersiveengineering:crafting/alu_scaffolding_grate_top_to_slab" | "immersiveengineering:crafting/stairs_concrete_leaded" | "compressium:coal_1" | "create:crafting/kinetics/stressometerfrom_conversion" | "compressium:coal_2" | "createaddition:compat/immersiveengineering/constantan" | "pamhc2foodcore:groundchickenitem" | "domum_ornamentum:vanilla_doors_compat_port_manteau" | "minecraft:waxed_oxidized_cut_copper" | "compressium:coal_5" | "compressium:coal_6" | "compressium:coal_3" | "compressium:coal_4" | "mekanism:processing/osmium/ingot/from_raw_smelting" | "mekanism:compat/ilikewoodxbyg/bed/embur/painting/blue" | "buddingcrystals:budding_glowstone" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/hellbark/painting/light_gray" | "create:small_calcite_brick_wall_from_stone_types_calcite_stonecutting" | "mekanism:compat/biomesoplenty/sawing/log/redwood" | "immersiveengineering:metalpress/plate_nickel" | "create:milling/compat/regions_unexplored/yellow_lupine" | "prefab:quartz_crete_smooth" | "pamhc2crops:cactus_x2_cactus_plants" | "compressium:coal_9" | "compressium:coal_7" | "compressium:coal_8" | "naturalist:cooked_catfish_from_campfire_cooking" | "create:cut_scoria_bricks_from_stone_types_scoria_stonecutting" | "sophisticatedstorage:gold_chest" | "minecraft:rocky_stone_stairs_from_rocky_stone_stonecutting" | "biomeswevegone:pink_stained_glass_from_pink_sand" | "jaopca:storage_blocks.to_material.ender_pearl" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/mahogany/brown" | "minecraft:light_blue_stained_glass_pane_from_glass_pane" | "minecraft:magenta_dye_from_lilac" | "domum_ornamentum:paper_extra" | "mekanism:compat/ilikewoodxbyg/bed/pine/lime" | "biomeswevegone:chiseled_black_sandstone" | "ae2:materials/carddistribution" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/palm/painting/blue" | "immersiveengineering:crusher/ore_lead" | "apotheosis:spawner/max_delay_inverted" | "pamhc2foodcore:groundmuttonitem" | "mekanism:gas_conversion/osmium_from_ingot" | "minecraft:blue_stained_glass_pane_from_glass_pane" | "immersiveengineering:metalpress/wire_uranium" | "botanypots:botanypots/crafting/green_glazed_terracotta_hopper_botany_pot" | "mekanism:compat/ilikewoodxbyg/bed/cika/painting/black" | "mekanism:enriching/deoxidizing/exposed_cut_copper_stairs" | "minecraft:red_sandstone_wall_from_red_sandstone_stonecutting" | "powah:crafting/uraninite_block" | "compressium:redsand_4_uncraft" | "minecraft:fletching_table" | "minecraft:dye_lime_bed" | "pamhc2foodcore:icecreamitem" | "connectedglass:vanilla_purple_stained_glass" | "pamhc2foodextended:dhalitem" | "minecraft:spyglass" | "pamhc2foodextended:carrotjuiceitem" | "yungscavebiomes:smooth_ancient_sandstone" | "create:smelting/glass_from_horizontal_framed_glass" | "biomeswevegone:witch_hazel_sign" | "mekanism:crushing/biofuel/brown_mushroom" | "biomeswevegone:cooked_oddion_bulb_from_smoker" | "biomeswevegone:florus_wood" | "mekanism:painting/carpet/blue" | "minecraft:pink_stained_glass" | "botanypots:minecraft/soil/dripstone" | "sophisticatedstorage:smelting_upgrade" | "storagenetwork:single_upgrade" | "minecraft:end_stone_brick_wall_from_end_stone_brick_stonecutting" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/cherry/painting/gray" | "create:cutting/jungle_wood" | "immersiveengineering:sawmill/acacia_door" | "connectedglass:borderless_glass_orange1" | "mekanism:compat/ilikewood/bed/cherry/painting/orange" | "connectedglass:borderless_glass_orange2" | "mekanism:compat/ilikewood/bed/dark_oak/light_gray" | "domum_ornamentum:dark_brick_stair" | "minecraft:black_sandstone_wall_from_black_sandstone_stonecutting" | "immersiveengineering:crafting/hammercrushing_silver" | "mekanism:painting/terracotta/orange" | "minecraft:raiser_armor_trim_smithing_template" | "domum_ornamentum:vanilla_trapdoors_compat_vertically_squiggly_striped" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/palm/painting/lime" | "immersiveengineering:crafting/raw_hammercrushing_ardite" | "create:cutting/compat/twilightforest/sorting_wood" | "create:crushing/amethyst_cluster" | "create:polished_cut_dripstone_from_stone_types_dripstone_stonecutting" | "jaopca:mekanism.material_to_dust.certus_quartz" | "minecraft:bread" | "create:crafting/appliances/copper_diving_helmet" | "mekanism:chemical_washer" | "botanytrees:biomeswevegone/yellow_spruce" | "biomeswevegone:green_enchanted_button" | "create:cutting/compat/atmospheric/morado_log" | "botanypots:minecraft/soil/soul_soil" | "mekanism:compat/ilikewoodxbyg/lectern/embur" | "mekanism:painting/carpet/purple" | "create_sa:block_picker_recipe" | "biomeswevegone:windswept_sandstone" | "biomeswevegone:cattail_thatch_stairs" | "mekanism:compat/ilikewoodxbyg/crafting_table/mahogany" | "immersiveengineering:sawmill/treated_wood_packaged_slab" | "create:blasting/silver_ingot_compat_oreganized" | "immersiveengineering:cloche/potato" | "connectedglass:vanilla_purple_stained_glass_pane" | "mekanism:compat/biomesoplenty/sawing/fence_gate/magic" | "draconicevolution:compress/awakened_draconium_ingot" | "immersiveengineering:fermenter/melon_slice" | "mekanism:compat/byg/crushing/soapstone/tile_to_brick" | "minecraft:bamboo_slab" | "mekanism:compat/byg/crushing/dacite/tile_stairs_to_brick_stairs" | "create:filling/compat/alexsmobs/lava_bottle" | "prefab:double_compressed_dirt_to_compressed_dirt" | "minecraft:black_banner" | "create:cutting/compat/byg/stripped_zelkova_wood" | "mekanism:compat/byg/pigment_extracting/pink" | "biomeswevegone:skyris_trapdoor" | "ae2:smelting/smooth_sky_stone_block" | "mekanism:compat/ilikewoodxbyg/barrel/blue_enchanted" | "mekanism:pigment_extracting/concrete/light_blue" | "immersiveengineering:thermoelectric/ice" | "mekanism:compat/ilikewoodxbyg/bed/ebony/light_blue" | "domum_ornamentum:white_floating_carpet" | "botanypots:minecraft/fertilizer/bonemeal" | "mekanism:compat/ilikewoodxbyg/bed/fir/magenta" | "botanypots:botanypots/crafting/gray_glazed_terracotta_botany_pot" | "pamhc2foodextended:bamboosteamedriceitem" | "botanypots:minecraft/crop/horn_coral" | "mekanism:nucleosynthesizing/end_crystal" | "sophisticatedstorage:auto_blasting_upgrade" | "mekanism:compat/ilikewood/bed/dark_oak/painting/lime" | "create:splashing/red_sand" | "mekanism:compat/ilikewoodxbyg/item_frame/palm" | "pamhc2foodextended:rawtofickenitem" | "compressium:coal_7_uncraft" | "create:emptying/builders_tea" | "pamhc2crops:bakedparsnipitem_smoker" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/redwood/painting/orange" | "pamhc2foodextended:mangojuiceitem" | "mekanism:painting/carpet/lime" | "mekanism:compat/ilikewood/bed/birch/pink" | "biomeswevegone:blue_enchanted_bookshelf" | "mekanism:compat/ilikewoodxbyg/bed/green_enchanted/gray" | "create:calcite_pillar_from_stone_types_calcite_stonecutting" | "mekanism:compat/byg/dye/white" | "pamhc2trees:roastedalmonditem_smoker" | "mekanism:compat/ilikewoodxbyg/bed/willow/painting/white" | "hangglider:glider_wing" | "create:crushing/deepslate_emerald_ore" | "powah:crafting/ender_cell_nitro" | "minecraft:cooked_chicken" | "immersiveengineering:metalpress/gear_aluminum" | "pamhc2crops:rutabagaseeditem" | "compressium:diorite_9_uncraft" | "ae2:decorative/sky_stone_brick" | "create:cutting/compat/byg/ebony_log" | "mekanism:compat/byg/sandstone_to_sand/pink" | "mekanism:compat/ilikewood/bed/dark_oak/painting/light_blue" | "pamhc2foodextended:summersquashwithradishitem" | "easy_mob_farm:mob_farm/monster_plains_cave/tier0_monster_plains_cave_farm" | "woodwevegot:rainbow_eucalyptus_ladder" | "create_sa:sponge_pressing" | "mekanism:painting/concrete_powder/red" | "mekanism:pigment_extracting/dye/purple" | "biomeswevegone:sakura_pressure_plate" | "mekanism:transmitter/mechanical_pipe/advanced" | "pamhc2foodextended:guisoitem" | "advanced_ae:flawedbudding" | "pamhc2foodcore:basicchickensandwichitem" | "sophisticatedstorage:netherite_shulker_from_netherite_chest" | "minecraft:polished_diorite_stairs_from_diorite_stonecutting" | "create:cut_scoria_stairs_from_stone_types_scoria_stonecutting" | "biomeswevegone:fir_planks" | "mekanism:processing/lead/dirty_dust/from_clump" | "jaopca:mekanism.raw_storage_block_to_dirty_slurry.nickel" | "waystones:return_scroll" | "pamhc2foodextended:orangesodaitem" | "create:cutting/stripped_cherry_log" | "mekanism:enriching/conversion/mud/to_clay" | "sophisticatedstorage:crimson_barrel" | "sophisticatedbackpacks:smelting_upgrade" | "powah:crafting/dielectric_rod" | "compressium:andesite_9_uncraft" | "pamhc2crops:onionseeditem" | "create:crafting/kinetics/propeller" | "create:cutting/compat/biomesoplenty/stripped_palm_wood" | "immersiveengineering:smelting/copper_ingot_from_dust_from_blasting" | "pamhc2foodextended:starfruitjuiceitem" | "ae2:shaped/stairs/sky_stone_brick" | "mekanism:compat/ilikewoodxbyg/bed/pine/painting/light_blue" | "biomeswevegone:rocky_stone_wall" | "buddingcrystals:budding_copper" | "mekanism:compat/ilikewood/post/mangrove" | "immersiveengineering:crafting/fluid_pipe" | "minecraft:dark_prismarine" | "easy_mob_farm:mob_catcher/ironbound_containment_cage" | "utilitarian:no_soliciting/soliciting_carpets/orange_trapped_soliciting_carpet" | "sophisticatedstorage:birch_limited_barrel_1" | "sophisticatedstorage:birch_limited_barrel_4" | "mekanism:pressure_disperser" | "sophisticatedstorage:birch_limited_barrel_2" | "sophisticatedstorage:birch_limited_barrel_3" | "compressium:diamond_4_uncraft" | "createaddition:mechanical_crafting/alternator" | "pamhc2crops:sunchokeseeditem" | "sophisticatedstorage:storage_advanced_pickup_upgrade_from_backpack_advanced_pickup_upgrade" | "mekanism:sawing/bed/magenta" | "mekanism:compat/ilikewoodxbyg/soul_torch/embur" | "immersiveengineering:metalpress/rod_osmium" | "minecraft:waxed_oxidized_cut_copper_slab_from_waxed_oxidized_cut_copper_stonecutting" | "pamhc2crops:blueberryseeditem" | "ae2:smelting/silicon_from_certus_quartz_dust" | "mekanism:compat/ilikewoodxbyg/panel/witch_hazel" | "pamhc2foodextended:cookedtofickenitem_forge" | "create:cutting/compat/regions_unexplored/stripped_larch_log" | "mekanism:compat/biomesoplenty/sawing/log/hellbark" | "hangglider:glider_framework" | "pamhc2crops:tealeafseeditem" | "create:cut_ochrum_slab_recycling" | "domum_ornamentum:vanilla_doors_compat_waffle" | "immersiveengineering:crafting/sheetmetal_colored_white" | "pamhc2foodextended:gourmetmuttonpattyitem" | "create:milling/compat/byg/compat/byg/white_sage" | "mekanism:compat/ilikewood/bed/dark_oak/painting/red" | "create:cutting/compat/nethers_exoticism/stripped_ramboutan_wood" | "minecraft:jungle_slab" | "domum_ornamentum:vanilla_trapdoors_compat_boss" | "biomeswevegone:jacaranda_crafting_table" | "create:milling/compat/botania/lime_petal" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/redwood/painting/gray" | "create:blasting/ingot_aluminum_compat_immersiveengineering" | "chunkloaders:basic_chunk_loader" | "megacells:crafting/radioactive_cell_component" | "create:milling/compat/regions_unexplored/felicia_daisy" | "createaddition:charging/weathered_copper" | "domum_ornamentum:pink_brick_extra" | "minecraft:granite" | "mekanism:compat/biomesoplenty/sawing/door/palm" | "minecraft:black_dye_from_wither_rose" | "immersiveengineering:crafting/speedloader" | "mekanism:compat/byg/sawing/trapdoor/maple" | "connectedglass:vanilla_magenta_stained_glass" | "biomeswevegone:zelkova_trapdoor" | "mekanism:processing/gold/clump/from_raw_block" | "botanypots:botanypots/crafting/red_glazed_terracotta_botany_pot" | "jaopca:storage_blocks.to_material.obsidian" | "immersiveengineering:crafting/drillhead_steel" | "immersiveengineering:sawmill/treated_wood_horizontal_stairs" | "create:cutting/compat/byg/fungal_imparius_stem" | "botanypots:pamhc2crops/crop/elderberry" | "create:crafting/kinetics/brown_seat_from_other_seat" | "botanytrees:minecraft/spruce" | "biomeswevegone:willow_chest_boat" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/hellbark/painting/pink" | "pamhc2trees:papaya_sapling" | "mekanism:processing/gold/slurry/dirty/from_raw_ore" | "create:crushing/compat/simplefarming/rye" | "mekanism:processing/copper/clump/from_raw_block" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/willow/light_gray" | "mekanism:compat/ilikewoodxbiomesoplenty/torch/palm" | "pamhc2trees:roastedpinenuttitem_smoker" | "create:crafting/kinetics/copper_door" | "botanypots:botanypots/crafting/green_glazed_terracotta_botany_pot" | "create:crafting/copper/waxed_oxidized_copper_tiles_from_honeycomb" | "pamhc2crops:soybeanseeditem" | "create:andesite_bars_from_andesite_alloy_stonecutting" | "mekanism:compat/ilikewoodxbyg/bed/palm/painting/orange" | "mekanism:crushing/biofuel/pumpkin" | "ae2:tools/paintballs_brown" | "minecraft:cobbled_deepslate_wall" | "mekanism:painting/candle/blue" | "minecraft:purpur_slab_from_purpur_block_stonecutting" | "ae2:matter_cannon/nuggets/germanium" | "mekanismtools:refined_glowstone/nugget_from_smelting" | "mekanism:compat/ilikewoodxbyg/bed/willow/yellow" | "mekanism:compat/biomesoplenty/sawing/trapdoor/fir" | "mekanism:compat/ilikewood/ladder/acacia" | "create:cutting/compat/regions_unexplored/stripped_cypress_wood" | "create:polished_cut_crimsite_wall" | "create:cutting/compat/byg/lament_wood" | "botanypots:minecraft/crop/wither_rose" | "sophisticatedstorage:bamboo_limited_barrel_1" | "create:mangrove_window_pane" | "pamhc2foodextended:herbbutterparsnipsitem" | "minecraft:purple_carpet" | "create:pressing/compat/infernalexp/warped_nylium_path" | "botanytrees:pamhc2trees/mango_sapling" | "mekanism:compat/ilikewood/bed/crimson/painting/orange" | "mekanism:pigment_extracting/terracotta/red" | "createoreexcavation:crushing/redstone_crushing" | "woodwevegot:jacaranda_chest" | "easy_mob_farm:upgrade/filter/no_flowers_filter" | "sophisticatedstorage:chipped/mason_table_upgrade" | "sophisticatedstorage:bamboo_limited_barrel_4" | "mekanism:painting/dye/pink" | "mekanism:processing/copper/clump/from_raw_ore" | "immersiveengineering:crafting/revolver" | "sophisticatedstorage:bamboo_limited_barrel_2" | "sophisticatedstorage:bamboo_limited_barrel_3" | "cookingforblockheads:sink" | "friendsandfoes:waxed_weathered_copper_button_from_honeycomb" | "pamhc2foodextended:rambutanjellysandwichitem" | "minecraft:ender_eye" | "botanypots:pamhc2crops/crop/mulberry" | "mekanism:processing/bronze/ingot/from_dust_smelting" | "create:crushing/obsidian" | "apotheosis:enchanting/improved_scrap_tome" | "compressium:stone_3_uncraft" | "mekanism:compat/ilikewood/bed/cherry/painting/brown" | "mekanism:compat/ilikewood/bed/warped/painting/brown" | "create:cut_scoria_brick_wall_from_stone_types_scoria_stonecutting" | "sophisticatedbackpacks:battery_upgrade" | "mekanism:compat/ilikewoodxbyg/torch/maple" | "create:cutting/compat/byg/stripped_holly_log" | "mekanism:compat/byg/sawing/boat/cika" | "pamhc2foodcore:melonsmoothieitem" | "pamhc2foodextended:cranberryjuiceitem" | "pamhc2foodextended:peanutbuttercupitem" | "immersiveengineering:crafting/conveyor_dropper" | "create:smelting/ingot_uranium_compat_mekanism" | "create:cutting/compat/byg/witch_hazel_wood" | "create:cutting/compat/twilightforest/stripped_transformation_log" | "minecraft:exposed_cut_copper_stairs_from_exposed_cut_copper_stonecutting" | "sophisticatedbackpacks:smoking_upgrade" | "mekanism:compat/ae2/decorative/sky_stone/enriching/wall_to_smooth_wall" | "mekanism:metallurgic_infusing/netherrack_to_crimson_nylium" | "mekanism:compat/ilikewoodxbyg/bed/baobab/painting/orange" | "create:splashing/ic2/crushed_raw_tin" | "mekanism:compat/ilikewoodxbyg/bed/bulbis/blue" | "create:small_scoria_bricks_from_stone_types_scoria_stonecutting" | "pamhc2crops:oatsseeditem" | "domum_ornamentum:down_gated" | "pamhc2foodextended:steakfajitaitem" | "compressium:redstone_9_uncraft" | "fuelgoeshere:test" | "mekanism:fluid_tank/ultimate" | "create:pressing/silt_dirt_path" | "mekanism:processing/osmium/ingot/from_ore_blasting" | "utilitarian:utility/bamboo_logs_to_stairs" | "pamhc2foodextended:dragonfruitjellysandwichitem" | "mekanism:compat/ilikewoodxbyg/bed/palm/painting/gray" | "pamhc2foodcore:softpretzelitem" | "mekanism:compat/ilikewood/bed/crimson/painting/black" | "biomeswevegone:aspen_trapdoor" | "compressium:obsidian_3_uncraft" | "minecraft:purple_sandstone_slab_from_purple_sandstone_stonecutting" | "mekanism:compat/ilikewood/item_frame/oak" | "minecraft:gold_nugget_from_smelting" | "minecraft:chiseled_quartz_block_from_quartz_block_stonecutting" | "create:milling/compat/atmospheric/yucca_flower" | "waystones:light_gray_sharestone" | "mekanism:painting/dye/brown" | "sophisticatedstorage:diamond_barrel" | "mekanism:pigment_extracting/terracotta/green" | "biomeswevegone:witch_hazel_button" | "mekanism:pigment_extracting/wool/purple" | "pamhc2foodcore:hotdogitem" | "mekanism:crushing/stone/to_cobblestone" | "botanypots:minecraft/soil/nether_gold_ore" | "immersiveengineering:smelting/ingot_uranium3" | "immersiveengineering:smelting/ingot_uranium2" | "sophisticatedstorage:backpack_advanced_feeding_upgrade_from_storage_advanced_feeding_upgrade" | "mekanism:compat/byg/dye/green" | "mekanism:compat/ilikewoodxbyg/bed/cherry/gray" | "mekanism:compat/ilikewoodxbyg/bed/willow/painting/green" | "pamhc2foodextended:pumpkinoatsconesitem" | "botanypots:botanypots/crafting/orange_glazed_terracotta_hopper_botany_pot" | "pamhc2foodextended:pomegranatejellyitem" | "woodwevegot:green_enchanted_chest" | "draconicevolution:modules/item_wyvern_proj_grav_comp" | "create:cut_veridium_from_stone_types_veridium_stonecutting" | "ae2:decorative/cut_quartz_block_from_stonecutting" | "immersiveengineering:smelting/nugget_steel_recycle_shovel_from_blasting" | "immersiveengineering:blastfurnace/fuel_charcoal_block" | "mekanism:compat/biomesoplenty/sawing/pressure_plate/dead" | "minecraft:cut_white_sandstone_from_white_sandstone_stonecutting" | "minecraft:weathered_cut_copper_slab_from_weathered_cut_copper_stonecutting" | "create:cutting/compat/twilightforest/time_log" | "create:small_andesite_brick_slab_from_stone_types_andesite_stonecutting" | "immersiveengineering:arcfurnace/raw_block_platinum" | "pamhc2foodcore:applejellyitem" | "ae2:shaped/slabs/cut_quartz_block" | "fulleng:terminals/block_pattern_access_terminal_from_part" | "woodwevegot:green_enchanted_barrel" | "create:small_scorchia_brick_slab" | "create:crushing/emerald_ore" | "ae2:network/cells/item_storage_components_cell_1k_part" | "immersiveengineering:crafting/steel_scaffolding_wooden_top_from_grate_top" | "apotheosis:reforging/epic" | "utilitarian:utility/warped_logs_to_trapdoors" | "immersiveengineering:crafting/sheetmetal_colored_blue_from_slab" | "mekanismtools:refined_obsidian/armor/boots" | "create:cutting/compat/environmental/stripped_willow_log" | "mekanism:sawing/pressure_plate/jungle" | "powah:energizing/uranium_to_uraninite" | "mekanism:compat/ilikewoodxbyg/bed/bulbis/lime" | "botanytrees:biomeswevegone/brown_birch" | "sophisticatedstorage:limited_copper_barrel_1" | "sophisticatedstorage:limited_copper_barrel_2" | "sophisticatedstorage:limited_copper_barrel_3" | "sophisticatedstorage:limited_copper_barrel_4" | "pamhc2foodextended:wafflesitem" | "ae2:shaped/walls/smooth_quartz_block" | "mekanism:injecting/oxidizing/weathered_copper" | "mekanism:compat/ilikewoodxbyg/bed/cherry/painting/black" | "minecraft:shulker_box_coloring" | "create:cutting/compat/ecologics/stripped_coconut_log" | "pamhc2foodcore:pumpkinyogurtitem" | "mekanism:compat/ilikewood/bed/bamboo/painting/pink" | "mekanism:compat/ilikewoodxbyg/bed/cika/black" | "pamhc2foodextended:grapefruitjellyitem" | "apotheosis:stoneshelf" | "create:milling/compat/atmospheric/gilia" | "minecraft:white_glazed_terracotta" | "create:cutting/compat/goodending/stripped_cypress_wood" | "connectedglass:clear_glass_blue_pane3" | "mekanism:rotary_condensentrator" | "mekanism:crushing/biofuel/dried_kelp_block" | "create:cut_asurine_from_stone_types_asurine_stonecutting" | "immersiveengineering:metalpress/gear_uranium" | "ae2:block_cutter/slabs/smooth_quartz_slab" | "connectedglass:clear_glass_blue_pane2" | "connectedglass:clear_glass_blue_pane1" | "comforts:hammock_to_yellow" | "megacells:cells/portable/portable_item_cell_256m" | "minecraft:acacia_wood" | "compressium:redsand_5_uncraft" | "draconicevolution:modules/item_wyvern_flight" | "biomeswevegone:maple_door" | "mekanism:compat/ilikewoodxbyg/bed/embur/painting/lime" | "create:acacia_window_pane" | "create:cut_granite_brick_slab_from_stone_types_granite_stonecutting" | "pamhc2foodextended:dragonfruitpieitem" | "biomeswevegone:aspen_crafting_table" | "create:cutting/compat/byg/stripped_rainbow_eucalyptus_log" | "woodwevegot:white_mangrove_chest" | "create:cut_diorite_brick_wall" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/dead/painting/light_gray" | "create:sequenced_assembly/precision_mechanism" | "mekanism:compat/ilikewoodxbyg/bed/ebony/purple" | "comforts:sleeping_bag_to_lime" | "pamhc2crops:arrowrootseeditem" | "immersiveengineering:metalpress/plate_copper" | "apotheosis:potion_charm" | "mekanism:compat/ilikewoodxbyg/bed/lament/purple" | "mekanism:compat/ilikewoodxbyg/bed/cika/painting/yellow" | "pamhc2foodextended:datejellyitem" | "mekanism:compat/ilikewoodxbyg/bed/holly/painting/cyan" | "pamhc2foodextended:grapefruitjuiceitem" | "aquaculture:red_mushroom_from_red_shrooma" | "create:cut_scorchia_wall" | "mekanism:compat/ilikewood/torch/birch" | "ae2:network/cables/dense_smart_green" | "create:polished_cut_deepslate_wall" | "mekanism:compat/ilikewoodxbyg/item_frame/bulbis" | "create:milling/calcite" | "sophisticatedstorage:backpack_advanced_magnet_upgrade_from_storage_advanced_magnet_upgrade" | "cookingforblockheads:dye_black_oven" | "pamhc2foodextended:poachedpearitem" | "create:crafting/kinetics/light_gray_seat" | "mekanism:enriching/deoxidizing/cut_copper_stairs" | "pamhc2foodextended:cookedtofickenitem_campfire" | "mekanism:compat/ilikewood/wall/crimson" | "powah:crafting/dielectric_paste" | "pamhc2foodcore:beefpotpieitem" | "immersiveengineering:crusher/ingot_invar" | "minecraft:waxed_cut_copper_slab" | "create:haunting/lapis_recycling" | "mekanism:combining/wax/waxed_exposed_copper" | "mekanism:compat/ilikewoodxbyg/composter/green_enchanted" | "mekanism:compat/ilikewoodxbyg/ladder/jacaranda" | "mekanism:compat/ilikewoodxbyg/bed/baobab/painting/lime" | "utilitarian:no_soliciting/soliciting_carpets/light_gray_soliciting_carpet" | "pamhc2crops:hotnettleteaitem_campfire" | "mekanism:compat/ilikewood/bed/bamboo/painting/orange" | "botanypots:botanypots/crafting/cyan_concrete_compact_hopper_botany_pot" | "cookingforblockheads:crafting_book" | "prefab:compressed_quartz_crete_from_quartz_crete" | "immersiveengineering:crafting/hammercrushing_cobalt" | "mekanism:fluid_tank/basic" | "comforts:sleeping_bag_to_blue" | "create:cutting/compat/ars_nouveau/stripped_red_archwood_log" | "minecraft:nether_brick_stairs" | "pamhc2crops:cornseeditem" | "mekanism:compat/ilikewoodxbyg/bed/lament/white" | "jaopca:immersiveengineering.plate_to_wire.lead" | "naturalist:glow_goop" | "create:cutting/compat/windswept/stripped_chestnut_wood" | "create:deploying/waxed_oxidized_copper_tile_slab_from_adding_wax" | "pamhc2foodextended:orangesmoothieitem" | "minecraft:recovery_compass" | "biomeswevegone:witch_hazel_planks" | "mekanism:compat/ilikewood/bed/birch/painting/yellow" | "mekanism:dimensional_stabilizer" | "domum_ornamentum:post_turned" | "fulleng:terminals/block_crafting_terminal_from_part" | "pamhc2foodextended:marzipanitem" | "mekanism:compat/ilikewoodxbyg/post/cypress" | "immersiveengineering:crafting/sheetmetal_iron_from_slab" | "mekanism:compat/biomesoplenty/dye/gray" | "mekanism:compat/byg/enriching/soapstone/polished_walls_to_brick_walls" | "ae2:network/cables/covered_red" | "mekanism:compat/ilikewoodxbyg/bed/jacaranda/painting/red" | "jaopca:create.material_to_plate.constantan" | "biomeswevegone:jacaranda_fence_gate" | "ae2:tools/paintballs_lumen_black" | "advanced_ae:chippedbudding" | "create:crafting/kinetics/black_valve_handle_from_other_valve_handle" | "connectedglass:clear_glass_brown_pane3" | "connectedglass:clear_glass_brown_pane1" | "connectedglass:clear_glass_brown_pane2" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/willow/painting/purple" | "ae2:materials/cardfuzzy" | "powah:crafting/energy_discharger_hardened" | "naturalist:cut_shellstone_wall_from_stonecutting" | "create:pressing/compat/environmental/podzol_path" | "minecraft:smooth_purple_sandstone_stairs_from_purple_sandstone_stonecutting" | "mekanism:compat/ilikewoodxbyg/bed/ether/painting/magenta" | "compressium:dirt_6_uncraft" | "ae2:shaped/walls/chiseled_quartz_block" | "woodwevegot:white_mangrove_ladder" | "mekanism:compat/ilikewoodxbyg/bed/embur/painting/light_blue" | "pamhc2foodextended:honeylemonlambitem" | "mekanism:compat/ilikewood/bed/bamboo/cyan" | "ae2:network/parts/annihilation_plane_alt" | "pamhc2foodextended:pokebowlitem" | "ae2:network/blocks/energy_energy_cell" | "immersiveengineering:crusher/raw_ore_lead" | "biomeswevegone:fir_boat" | "mekanism:processing/steel/ingot/from_dust_blasting" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/redwood/painting/brown" | "botanypots:farmingforblockheads/soil/fertilized_farmland_healthy" | "immersiveengineering:cloche/crimson_fungus" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/mahogany/pink" | "mekanism:compat/ilikewoodxbyg/post/mahogany" | "mekanism:factory/basic/purifying" | "immersiveengineering:crusher/blue_dye" | "pamhc2foodextended:okracreoleitem" | "minecraft:white_dye" | "pamhc2foodextended:zestyzucchiniitem" | "create:crafting/kinetics/linear_chassisfrom_conversion" | "biomeswevegone:ebony_fence" | "mekanism:crushing/biofuel/tall_grass" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/jacaranda/painting/light_gray" | "aquaculture:note_hook" | "minecraft:wild_armor_trim_smithing_template_smithing_trim" | "sophisticatedstorage:controller" | "create:polished_cut_granite_slab" | "mekanism:crushing/biofuel/azalea_leaves" | "create:polished_cut_veridium_stairs" | "mekanism:compat/byg/crushing/ether/carved_slabs_to_slabs" | "create:cutting/compat/byg/skyris_log" | "create:cutting/compat/nethers_exoticism/stripped_jabuticaba_log" | "mekanism:compat/ilikewood/crafting_table/jungle" | "create:milling/compat/environmental/pink_delphinium" | "immersiveengineering:arcfurnace/raw_ore_silver" | "apotheosis:enchanting/ender_library" | "compressium:copper_4_uncraft" | "minecraft:tinted_glass" | "mekanism:compat/ilikewoodxbyg/bed/palm/painting/blue" | "utilitarian:no_soliciting/soliciting_carpets/gray_trapped_soliciting_carpet" | "mekanism:nucleosynthesizing/enchanted_golden_apple" | "mekanism:compat/ilikewoodxbyg/bed/ebony/painting/lime" | "create:crafting/kinetics/yellow_seat_from_other_seat" | "arseng:mega_source_cell_housing" | "pamhc2foodextended:peanutbuttercookiesitem" | "create:cut_ochrum_from_stone_types_ochrum_stonecutting" | "woodwevegot:fir_chest" | "minecraft:cut_copper_stairs_from_copper_block_stonecutting" | "mekanism:factory/elite/injecting" | "create:granite_from_stone_types_granite_stonecutting" | "connectedglass:clear_glass_light_gray_pane3" | "connectedglass:clear_glass_light_gray_pane1" | "mekanism:compat/ilikewoodxbyg/panel/ether" | "connectedglass:clear_glass_light_gray_pane2" | "biomeswevegone:zelkova_bookshelf" | "minecraft:dried_kelp_block" | "minecraft:quartz" | "create:cutting/compat/byg/stripped_ether_wood" | "apotheosis:sigil_of_rebirth" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/hellbark/lime" | "minecraft:rocky_stone_slab_from_rocky_stone_stonecutting" | "mekanismtools:refined_obsidian/tools/shovel" | "create:cutting/compat/ars_nouveau/stripped_green_archwood_wood" | "create:deploying/waxed_weathered_copper_shingle_slab_from_adding_wax" | "immersiveengineering:smelting/ingot_steel_from_dust" | "mekanism:compat/ilikewood/bed/birch/purple" | "mekanismtools:bronze/armor/chestplate" | "botanypots:minecraft/crop/bubble_coral_fan" | "create:polished_cut_dripstone_slab_from_stone_types_dripstone_stonecutting" | "create:industrial_iron_block_from_ingots_iron_stonecutting" | "mekanism:compat/ilikewood/bed/crimson/painting/pink" | "draconicevolution:modules/item_chaotic_shield_capacity" | "pamhc2trees:roastedpinenutitem_campfire" | "pamhc2foodextended:eggsaladitem" | "powah:crafting/reactor_spirited" | "pamhc2foodcore:melondonutitem" | "connectedglass:scratched_glass_blue_pane2" | "connectedglass:scratched_glass_blue_pane1" | "connectedglass:scratched_glass_blue_pane3" | "pamhc2trees:roastedalmonditem_campfire" | "mekanism:compat/ilikewoodxbiomesoplenty/barrel/mahogany" | "botanytrees:biomeswevegone/rainbow_eucalyptus" | "pamhc2foodextended:baklavaitem" | "botanypots:minecraft/soil/diorite" | "mekanism:processing/tin/ingot/from_ore_smelting" | "ae2:network/blocks/energy_energy_acceptor" | "buddingcrystals:budding_uraninite" | "immersiveengineering:squeezer/hemp_seeds" | "pamhc2foodextended:pizzasliceitem_meatfeastpizzaitem" | "mekanism:compat/ilikewood/bed/cherry/black" | "minecraft:blue_carpet" | "mekanism:compat/farmersdelight/sawing/raw_cod_slice" | "mekanism:processing/tin/shard/from_ore" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/redwood/painting/red" | "mekanism:compat/ilikewoodxbyg/bed/ebony/painting/blue" | "create:cut_dripstone_brick_slab" | "mekanism:sawing/log/oak" | "compressium:emerald_1_uncraft" | "mekanism:infusion_conversion/carbon/from_charcoal" | "mekanism:compat/ilikewoodxbyg/bed/palm/painting/lime" | "immersiveengineering:crafting/shield" | "create:small_limestone_brick_stairs_from_stone_types_limestone_stonecutting" | "mekanism:robit" | "mekanism:compat/ae2/decorative/sky_stone/enriching/slab_to_smooth_slab" | "pamhc2foodextended:grapefruitpieitem" | "botanypots:minecraft/crop/large_fern" | "powah:crafting/ender_gate_niotic" | "ae2:network/crafting/cpu_crafting_monitor" | "justhammers:netherite_hammer" | "create:deploying/waxed_weathered_cut_copper_from_adding_wax" | "botanypots:minecraft/soil/snow_block" | "mekanism:compat/ilikewood/torch/cherry" | "compressium:redstone_2_uncraft" | "minecraft:cooked_chicken_from_smoking" | "minecraft:cut_red_sandstone_from_red_sandstone_stonecutting" | "minecraft:waxed_weathered_cut_copper_slab_from_waxed_weathered_copper_stonecutting" | "draconicevolution:machines/reactor_core" | "mekanism:compat/ilikewoodxbyg/bed/bulbis/white" | "create:cutting/compat/architects_palette/twisted_log" | "biomeswevegone:green_enchanted_fence_gate" | "prefab:swift_blade_osmium" | "pamhc2foodextended:elderberryjellyitem" | "mekanism:compat/byg/crushing/dacite/slabs_to_cobblestone_slabs" | "woodwevegot:green_enchanted_ladder" | "minecraft:mangrove_chest_boat" | "minecraft:iron_hoe" | "immersiveengineering:smelting/ingot_silver3" | "naturalist:shellstone_brick_slab_from_stonecutting" | "immersiveengineering:smelting/ingot_silver2" | "mekanismgenerators:generator/wind" | "woodwevegot:ebony_barrel" | "pamhc2foodextended:bananayogurtitem" | "pamhc2foodextended:lemondrizzlecakeitem" | "mekanism:processing/osmium/ingot/from_ore_smelting" | "create:crushing/golden_horse_armor" | "immersiveengineering:crafting/raw_block_aluminum_to_raw_aluminum" | "mekanism:compat/byg/pigment_extracting/large_pink" | "draconicevolution:disenchanter" | "mekanism:compat/ilikewood/bed/mangrove/painting/magenta" | "minecraft:jungle_trapdoor" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/dead/painting/purple" | "biomeswevegone:ebony_hanging_sign" | "elevatorid:elevator_light_gray" | "biomeswevegone:cooked_oddion_bulb_from_smelting" | "apotheosis:spawner/redstone_control" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/palm/white" | "sophisticatedbackpacks:filter_upgrade" | "mekanism:compat/ilikewood/ladder/crimson" | "immersiveengineering:mineral/amethyst_crevasse" | "ae2:network/cables/dense_covered_purple" | "create:deploying/waxed_exposed_copper_tile_slab_from_adding_wax" | "create:polished_cut_scorchia_stairs_from_stone_types_scorchia_stonecutting" | "create:cutting/compat/regions_unexplored/blackwood_log" | "apotheosis:spawner/player_range" | "ae2:network/cables/dense_smart_blue" | "mekanism:compat/ilikewoodxbyg/bed/pine/painting/cyan" | "mekanism:painting/terracotta/light_blue" | "compressium:lapis_9_uncraft" | "mekanism:enriching/salt" | "create:deploying/waxed_weathered_cut_copper_slab_from_adding_wax" | "woodwevegot:mahogany_chest" | "biomeswevegone:rainbow_eucalyptus_boat" | "mekanism:crushing/stone/chiseled_bricks_to_bricks" | "immersiveengineering:metalpress/wire_cobalt" | "pamhc2trees:grapefruit_sapling" | "minecraft:orange_carpet" | "immersiveengineering:blueprint/component_electronic_adv" | "mekanism:compat/ilikewoodxbyg/bed/green_enchanted/pink" | "mekanism:processing/iron/shard/from_raw_ore" | "mekanism:processing/osmium/shard/from_ore" | "create:campfire_cooking/bread" | "mekanism:compat/ilikewoodxbyg/bed/ether/painting/orange" | "pamhc2foodextended:briochebunitem" | "create:cutting/compat/quark/azalea_wood" | "create:cutting/compat/tconstruct/skyroot_log" | "immersiveengineering:arcfurnace/raw_block_osmium" | "mekanism:compat/ilikewoodxbyg/bed/maple/painting/black" | "minecraft:mangrove_slab" | "advanced_ae:quantum_boots" | "connectedglass:scratched_glass_purple_pane3" | "botanypots:minecraft/crop/poppy" | "connectedglass:scratched_glass_purple_pane1" | "create:crushing/compat/thermal/niter_ore" | "connectedglass:scratched_glass_purple_pane2" | "pamhc2crops:bellpepperseeditem" | "pamhc2foodextended:hoisinsauceitem" | "pamhc2foodcore:potatosoupitem" | "draconicevolution:components/draconic_energy_core" | "connectedglass:borderless_glass_pink_pane3" | "pamhc2foodextended:maplesyruppancakesitem" | "elevatorid:redye_light_blue" | "mekanism:metallurgic_infusing/alloy/infused" | "create:cut_diorite_slab_recycling" | "connectedglass:borderless_glass_pink_pane2" | "connectedglass:borderless_glass_pink_pane1" | "botanypots:botanypots/crafting/brown_terracotta_botany_pot" | "immersiveengineering:crusher/ingot_platinum" | "create:cutting/compat/blue_skies/stripped_frostbright_log" | "mekanism:compat/biomesoplenty/sawing/boat/dead" | "create_sa:iron_boots_haunting" | "mekanism:enriching/dye/large_pink" | "mekanism:compat/ilikewood/bed/acacia/painting/yellow" | "immersiveengineering:crafting/conveyor_vertical_covered" | "mekanism:compat/byg/sawing/chest_boat/skyris" | "minecraft:netherite_sword_smithing" | "createaddition:compat/immersiveengineering/crushing/coal_coke" | "mekanism:compat/byg/sawing/fence_gate/jacaranda" | "ae2:network/cables/dense_smart_lime" | "mekanism:compat/ilikewoodxbiomesoplenty/item_frame/palm" | "mekanismtools:refined_obsidian/armor/chestplate" | "create:cutting/compat/ecologics/flowering_azalea_wood" | "immersiveengineering:crusher/raw_ore_aluminum" | "create:blasting/iron_ingot_from_crushed" | "megacells:cells/mega_item_cell_housing" | "pamhc2foodextended:kiwijellysandwichitem" | "utilitarian:utility/dark_oak_logs_to_pressure_plates" | "botanypots:botanypots/crafting/yellow_terracotta_botany_pot" | "prefab:bunch_of_carrots" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/willow/yellow" | "mekanism:compat/ilikewoodxbyg/item_frame/mahogany" | "immersiveengineering:crafting/torch" | "dankstorage:4_to_5" | "pamhc2foodextended:peachpieitem" | "pamhc2foodextended:raspberrysmoothieitem" | "mekanism:compat/ilikewoodxbyg/ladder/sythian" | "immersiveengineering:metalpress/rod_invar" | "mekanism:compat/ilikewoodxbyg/bed/cherry/painting/gray" | "minecraft:magenta_concrete_powder" | "minecraft:red_dye_from_poppy" | "sophisticatedstorage:oak_chest_from_vanilla_chest" | "minecraft:light_blue_candle" | "mekanism:compat/ilikewoodxbyg/crafting_table/jacaranda" | "mekanism:crushing/biofuel/oxeye_daisy" | "mekanism:compat/ilikewood/crafting_table/crimson" | "botanytrees:biomeswevegone/indigo_jacaranda" | "minecraft:iron_ingot_from_blasting_deepslate_iron_ore" | "apotheosis:spawner/ignore_players" | "mekanism:painting/concrete/black" | "pamhc2crops:roastedmushroomitem_campfire" | "minecraft:deepslate_tile_wall_from_deepslate_tiles_stonecutting" | "mekanism:compat/byg/sawing/door/cika" | "ae2:inscriber/calculation_processor_press" | "pamhc2foodextended:vegetarianlettucewrapitem" | "mekanism:processing/lead/dust/from_ore" | "immersiveengineering:stonecutting/slab_concrete" | "immersiveengineering:blueprint/component_iron" | "ae2:matter_cannon/nuggets/sulfur" | "create:polished_cut_scoria_slab_from_stone_types_scoria_stonecutting" | "compressium:cobblestone_4_uncraft" | "powah:crafting/magmator_spirited" | "sophisticatedbackpacks:magnet_upgrade" | "prefab:ton_of_timber_to_heap" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/mahogany/painting/black" | "botanypots:pamhc2crops/crop/artichoke" | "pamhc2foodcore:gummycreepersitem" | "biomeswevegone:purple_sandstone_slab" | "immersiveengineering:crafting/slag_brick" | "justhammers:stone_hammer" | "botanypots:minecraft/crop/twisting_vines" | "minecraft:yellow_banner" | "immersiveengineering:sawmill/dark_oak_log" | "ae2:inscriber/fluix_dust" | "create:cutting/compat/byg/stripped_lament_wood" | "jaopca:mekanism.material_to_dust.electrum" | "minecraft:purpur_stairs_from_purpur_block_stonecutting" | "mekanism:compat/byg/sawing/log/skyris" | "mekanism:compat/ilikewoodxbyg/bed/fir/painting/magenta" | "compressium:netherite_4_uncraft" | "botanypots:botanypots/crafting/red_concrete_compact_hopper_botany_pot" | "create:milling/compat/environmental/dianthus" | "create:milling/compat/regions_unexplored/daisy" | "create:crafting/kinetics/mysterious_cuckoo_clock" | "minecraft:dye_gray_bed" | "minecraft:firework_star_fade" | "create:cutting/compat/windswept/chestnut_wood" | "mekanism:compat/biomesoplenty/sawing/chest_boat/magic" | "create:crafting/logistics/pulse_repeater" | "create:small_scoria_brick_slab_recycling" | "minecraft:dye_light_gray_bed" | "create:milling/compat/byg/lazarus_bellflower" | "minecraft:smooth_basalt" | "mekanism:compat/ilikewoodxbyg/bed/zelkova/yellow" | "create:small_granite_brick_wall_from_stone_types_granite_stonecutting" | "mekanism:compat/ilikewoodxbiomesoplenty/soul_torch/willow" | "pamhc2foodextended:plumyogurtitem" | "create:small_granite_brick_slab" | "mekanism:compat/ilikewoodxbyg/bed/imparius/painting/black" | "pamhc2foodextended:orangeyogurtitem" | "immersiveengineering:crafting/treated_wood_vertical_to_slab" | "buddingcrystals:budding_nether_quartz" | "advanced_ae:quantum_alloy_block" | "minecraft:blue_candle" | "mekanism:compat/ilikewoodxbyg/bed/cypress/light_blue" | "ae2:network/cables/dense_covered_pink" | "pamhc2crops:aloeseeditem" | "ae2:network/cables/glass_brown" | "create:milling/compat/regions_unexplored/red_snowbelle" | "pamhc2foodextended:strawberryrhubarbpieitem" | "jaopca:mekanism.raw_material_to_dust.zinc" | "botanypots:botanypots/crafting/cyan_glazed_terracotta_compact_hopper_botany_pot" | "pamhc2foodcore:basiccheeseburgeritem" | "minecraft:flower_banner_pattern" | "mekanism:enriching/enriched/tin" | "botanypots:botanypots/crafting/pink_terracotta_compact_hopper_botany_pot" | "domum_ornamentum:vanilla_wall_compat" | "compressium:andesite_6_uncraft" | "pamhc2foodextended:cornchipsitem" | "mekanism:compat/ilikewoodxbyg/item_frame/fir" | "ae2:network/parts/cable_anchor" | "biomeswevegone:blue_sandstone_slab" | "minecraft:polished_blackstone_brick_slab_from_polished_blackstone_bricks_stonecutting" | "compressium:andesite_1_uncraft" | "ae2:entropy/cool/flowing_water_snowball" | "mekanism:compat/byg/sawing/chest_boat/fir" | "mekanism:compat/ilikewood/bed/mangrove/painting/black" | "create:cutting/compat/byg/stripped_pine_wood" | "pamhc2foodextended:eggnogitem" | "mekanism:painting/wool/pink" | "mekanism:compat/ae2/decorative/sky_stone/enriching/brick_wall_to_small_brick_wall" | "mekanism:electric_bow" | "apotheosis:salvaging/ancient_gem_dust" | "mekanism:compat/ilikewoodxbyg/ladder/bulbis" | "easy_mob_farm:mob_farm/ocean_farm/tier2_ocean_farm" | "ae2:matter_cannon/nuggets/ruthenium" | "create:small_diorite_brick_slab" | "create_sa:obsidian_haunting" | "utilitarian:utility/dark_oak_logs_to_boats" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/dead/pink" | "immersiveengineering:crafting/sawdust" | "mekanism:sawing/stick" | "mekanism:compat/ilikewood/composter/acacia" | "create:cut_ochrum_brick_stairs_from_stone_types_ochrum_stonecutting" | "create:smelting/zinc_ingot_from_raw_ore" | "naturalist:smooth_shellstone_wall" | "mekanism:compat/ilikewoodxbyg/bed/pine/painting/orange" | "createoreexcavation:drilling/fluorite" | "ae2:matter_cannon/nuggets/tantalum" | "minecraft:purple_banner" | "ae2:transform/damaged_budding_quartz" | "biomeswevegone:willow_door" | "immersiveengineering:thermoelectric/packed_ice" | "connectedglass:borderless_glass_lime1" | "create:jungle_window_pane" | "connectedglass:borderless_glass_lime2" | "create:deepslate_from_stone_types_deepslate_stonecutting" | "mekanism:compat/byg/crushing/ether/from_carved" | "pamhc2foodextended:pumpkinspicelatteitem" | "connectedglass:vanilla_glass_pane" | "immersiveengineering:metalpress/gear_tungsten" | "pamhc2foodextended:sunflowerwheatrollsitem" | "immersiveengineering:stonecutting/stairs_clinker_brick" | "minecraft:wooden_hoe" | "createoreexcavation:diamond_drill" | "mekanism:compat/ilikewoodxbyg/bed/baobab/painting/blue" | "create:cutting/compat/byg/ebony_wood" | "ae2:entropy/cool/water_ice" | "mekanism:compat/byg/sawing/log/bulbis" | "mekanism:compat/ilikewoodxbyg/bed/skyris/magenta" | "create:small_limestone_bricks_from_stone_types_limestone_stonecutting" | "ae2:network/blocks/crystal_processing_charger" | "immersiveengineering:crafting/hempcrete_pillar" | "pamhc2foodextended:cactusfruitsmoothieitem" | "sophisticatedstorage:spruce_barrel_from_vanilla_barrel" | "powah:crafting/solar_panel_basic" | "aquaculture:fish_fillet" | "mekanism:compat/ilikewoodxbyg/bed/bulbis/green" | "mekanism:processing/copper/clump/from_shard" | "aquaculture:worm_farm" | "compressium:lapis_4_uncraft" | "biomeswevegone:redwood_boat" | "prefab:dirt_slab" | "naturalist:cake" | "mekanism:energized_smelter" | "sophisticatedstorage:birch_chest_from_quark_birch_chest" | "minecraft:blackstone_stairs_from_blackstone_stonecutting" | "mekanism:processing/gold/ingot/from_dust_blasting" | "immersiveengineering:smelting/ingot_uranium" | "aeinfinitybooster:infinity_card" | "mekanism:pigment_extracting/carpet/blue" | "mekanism:compat/byg/pigment_extracting/light_gray" | "minecraft:white_banner" | "pamhc2foodextended:grapepieitem" | "biomeswevegone:holly_sign" | "utilitarian:utility/bamboo_logs_to_pressure_plates" | "woodwevegot:fir_trapped_chest" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/mahogany/painting/red" | "pamhc2foodcore:glazedcarrotsitem" | "mekanism:painting/glass_pane/light_blue" | "botanytrees:pamhc2trees/plum_sapling" | "create:cutting/compat/blue_skies/maple_wood" | "mekanism:module_gravitational_modulating_unit" | "create:sequenced_assembly/sturdy_sheet" | "mekanism:crushing/biofuel/pumpkin_seeds" | "mekanism:painting/glass_pane/orange" | "cookingforblockheads:hanging_corner" | "create:milling/compat/environmental/bluebell" | "prefab:coil_of_lanterns_to_string_of_lanterns" | "create_sa:copper_shovel_recipe" | "domum_ornamentum:black_floating_carpet" | "minecraft:diorite_stairs_from_diorite_stonecutting" | "mekanism:compat/ilikewoodxbiomesoplenty/composter/mahogany" | "biomeswevegone:rocky_stone_slab" | "comforts:rope_and_nail_shapeless" | "mekanism:compat/ilikewoodxbyg/bed/blue_enchanted/painting/purple" | "create:cutting/compat/regions_unexplored/silver_birch_log" | "mekanism:upgrade/filter" | "apotheosis:enchanting/infused_seashelf" | "mekanism:upgrade/anchor" | "botanytrees:biomeswevegone/blue_spruce" | "create:small_limestone_brick_stairs" | "minecraft:green_glazed_terracotta" | "comforts:sleeping_bag_to_white" | "create:crafting/kinetics/copper_valve_handle" | "create:deploying/waxed_oxidized_cut_copper_stairs_from_adding_wax" | "immersiveengineering:metalpress/plate_platinum" | "compressium:cobblestone_9_uncraft" | "create:small_scorchia_brick_stairs_from_stone_types_scorchia_stonecutting" | "mekanism:pigment_extracting/concrete/magenta" | "mekanism:compat/ilikewood/bed/warped/magenta" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/jacaranda/black" | "biomeswevegone:aspen_fence" | "create:milling/compat/byg/california_poppy" | "woodwevegot:skyris_barrel" | "immersiveengineering:smelting/ingot_uranium_from_dust" | "mekanism:pigment_extracting/stained_glass/orange" | "create:crushing/compat/aether/zanite_ore" | "mekanism:compat/ilikewoodxbiomesoplenty/lectern/magic" | "botanypots:botanypots/crafting/gray_glazed_terracotta_compact_hopper_botany_pot" | "immersiveengineering:smelting/copper_ingot_from_dust" | "mekanism:compat/ilikewoodxbyg/bed/mahogany/painting/red" | "immersiveengineering:crafting/stick_treated" | "prefab:clutch_of_eggs_from_crate" | "create_sa:portable_drill_recipe" | "create:cutting/compat/windswept/stripped_holly_wood" | "mekanism:compat/ilikewoodxbiomesoplenty/panel/redwood" | "jaopca:mekanism.dirty_dust_to_dust.nickel" | "mekanism:compat/ilikewoodxbyg/bed/jacaranda/gray" | "minecraft:tipped_arrow" | "mekanism:compat/ilikewoodxbyg/bed/sythian/cyan" | "mekanism:compat/ilikewoodxbyg/torch/mahogany" | "immersiveengineering:smelting/ingot_hop_graphite" | "mekanism:enriching/conversion/andesite/slab_to_polished_slab" | "pamhc2foodextended:vegemiteontoastitem" | "pamhc2foodextended:yorkshirepuddingitem" | "minecraft:light_blue_carpet" | "immersiveengineering:cloche/poppy" | "create:cutting/compat/regions_unexplored/redwood_log" | "pamhc2foodcore:sweetberrymuffinitem" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/jacaranda/magenta" | "mekanism:compat/biomesoplenty/sawing/chest_boat/dead" | "powah:crafting/reactor_blazing" | "mekanism:sawing/boat/jungle" | "minecraft:gold_ingot_from_smelting_deepslate_gold_ore" | "mekanism:compat/biomesoplenty/sawing/log/fir" | "utilitarian:utility/birch_logs_to_stairs" | "immersiveengineering:crafting/pickaxe_steel" | "mekanism:pigment_extracting/carpet/lime" | "biomeswevegone:stripped_palm_wood" | "draconicevolution:awakened_draconium_block" | "mekanism:compat/ilikewoodxbyg/bed/witch_hazel/gray" | "create:layered_andesite_from_stone_types_andesite_stonecutting" | "mekanism:compat/ilikewood/post/acacia" | "immersiveengineering:crafting/hempcrete_brick_to_slab" | "apotheosis:spawner/ignore_conditions" | "create:cut_ochrum_brick_wall_from_stone_types_ochrum_stonecutting" | "create:polished_cut_ochrum_slab_from_stone_types_ochrum_stonecutting" | "mekanism:compat/ilikewoodxbyg/bed/imparius/red" | "draconicevolution:tools/wyvern_axe" | "mekanism:compat/ae2/decorative/certus_quartz/crushing/stairs_to_chiseled_stairs" | "mekanism:crushing/biofuel/glow_berries" | "create:polished_cut_calcite_from_stone_types_calcite_stonecutting" | "immersiveengineering:crafting/blueprint_components" | "mekanism:compat/ilikewoodxbyg/bed/lament/green" | "mekanism:compat/ilikewood/bed/jungle/painting/lime" | "mekanism:compat/ilikewoodxbyg/bed/jacaranda/painting/orange" | "mekanism:compat/ilikewood/bed/crimson/pink" | "mekanism:compat/ilikewoodxbiomesoplenty/torch/willow" | "pamhc2trees:plum_sapling" | "create:cutting/compat/environmental/willow_log" | "mekanism:factory/elite/combining" | "mekanism:combining/wax/waxed_weathered_cut_copper" | "immersiveengineering:crafting/sheetmetal_colored_purple_to_slab" | "mekanism:compat/byg/crushing/scoria/brick_stairs_to_stairs" | "pamhc2foodcore:glowberryjellyitem" | "immersiveengineering:crusher/raw_ore_silver" | "create:cutting/compat/byg/holly_log" | "minecraft:warped_button" | "pamhc2foodextended:elderberryyogurtitem" | "ae2:tools/paintballs_blue" | "pamhc2crops:wolfberryseeditem" | "pamhc2foodextended:kiwijuiceitem" | "easy_mob_farm:mob_farm/iron_golem_farm/tier1_iron_golem_farm" | "mekanism:compat/biomesoplenty/sawing/door/mahogany" | "mekanism:compat/ilikewoodxbyg/bed/bulbis/painting/pink" | "create:cut_crimsite_stairs" | "ae2:tools/paintballs_lime" | "create:small_deepslate_brick_stairs_from_stone_types_deepslate_stonecutting" | "utilitarian:no_soliciting/soliciting_carpets/light_blue_trapped_soliciting_carpet" | "create:crafting/kinetics/sequenced_gearshift" | "minecraft:armor_dye" | "pamhc2foodextended:rambutanjellytoastitem" | "mekanism:enriching/conversion/cracked_nether_bricks_to_nether_bricks" | "pamhc2foodextended:chipsanddipitem" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/redwood/painting/purple" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/jacaranda/painting/magenta" | "pamhc2foodcore:hotchocolateitem" | "create:cut_scorchia_stairs" | "minecraft:smoking_cookedgroundfishitem" | "minecraft:detector_rail" | "pamhc2foodextended:saltandpepperitem" | "mekanism:combining/wax/waxed_weathered_copper" | "utilitarian:utility/paper" | "compressium:netherite_3" | "mekanism:compat/ilikewoodxbyg/bed/jacaranda/painting/lime" | "compressium:netherite_2" | "pamhc2crops:roastedmushroomitem_forge" | "compressium:netherite_1" | "botanypots:minecraft/crop/white_tulip" | "immersiveengineering:bottling/copper_aging2" | "compressium:netherite_9" | "immersiveengineering:bottling/copper_aging3" | "compressium:netherite_8" | "compressium:netherite_7" | "compressium:netherite_6" | "compressium:netherite_5" | "immersiveengineering:smelting/nugget_steel_recycle_steel_helmet" | "compressium:netherite_4" | "mekanism:compat/ilikewoodxbyg/bed/aspen/painting/yellow" | "create:splashing/mekanism/crushed_raw_uranium" | "powah:crafting/battery_basic" | "mekanism:compat/ilikewoodxbyg/bed/aspen/painting/green" | "biomeswevegone:cooked_white_puffball_cap" | "pamhc2foodcore:fishsticksitem" | "utilitarian:no_soliciting/soliciting_carpets/yellow_soliciting_carpet" | "draconicevolution:modules/item_wyvern_undying" | "jaopca:immersiveengineering.ore_to_dust_hammer.draconium" | "create:crafting/logistics/stockpile_switch" | "storagenetwork:request" | "mekanism:compat/ae2/decorative/certus_quartz/enriching/chiseled_slab_to_slab" | "powah:crafting/player_tranmitter_basic" | "pamhc2foodextended:tortillaitem" | "immersiveengineering:crafting/toolupgrade_drill_fortune" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/redwood/painting/cyan" | "biomeswevegone:smooth_windswept_sandstone_stairs" | "mekanism:enriching/dye/light_gray" | "jaopca:mekanism.ore_to_dust.zinc" | "sophisticatedstorage:warped_chest" | "mekanism:compat/ilikewood/bed/crimson/magenta" | "mekanism:compat/ilikewood/bed/spruce/magenta" | "botanypots:botanypots/crafting/lime_concrete_botany_pot" | "ae2:network/cables/dense_covered_white" | "immersiveengineering:crafting/sheetmetal_colored_light_blue_from_slab" | "domum_ornamentum:brown_bricks" | "botanypots:minecraft/soil/tropical_fish_bucket" | "mekanism:compat/ilikewoodxbyg/bed/maple/white" | "immersiveengineering:crafting/toolupgrade_shield_magnet" | "mekanismtools:osmium/tools/pickaxe" | "mekanism:factory/ultimate/crushing" | "mekanism:sawing/door/crimson" | "create_sa:brain_tube_coral_revive" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/magic/painting/black" | "create:cutting/compat/regions_unexplored/green_bioshroom_stem" | "mekanism:pigment_extracting/candle/pink" | "mekanism:metallurgic_infusing/alloy/reinforced" | "elevatorid:elevator_purple" | "ae2:decorative/quartz_fixture" | "immersiveengineering:stonecutting/concrete_chiseled" | "create:polished_cut_limestone_slab_from_stone_types_limestone_stonecutting" | "minecraft:black_glazed_terracotta" | "create:pressing/compat/byg/lush_grass_path" | "minecraft:carrot_on_a_stick" | "mekanism:injecting/coral/brain_coral_fan" | "create:cutting/compat/byg/pine_wood" | "ae2:network/blocks/quantum_ring" | "mekanism:pigment_extracting/wool/pink" | "immersiveengineering:arcfurnace/ore_ardite" | "immersiveengineering:generator_fuel/creosote" | "mekanism:compat/ilikewood/ladder/cherry" | "mekanism:transmitter/universal_cable/elite" | "biomeswevegone:white_mangrove_sign" | "pamhc2foodextended:szechuaneggplantitem" | "pamhc2crops:cattailseeditem" | "create:cut_tuff_brick_slab_from_stone_types_tuff_stonecutting" | "mekanism:processing/copper/shard/from_ore" | "mekanism:compat/farmersdelight/sawing/raw_mutton_chops" | "botanytrees:minecraft/azalea" | "immersiveengineering:crafting/cokebrick_to_slab" | "ae2:misc/deconstruction_cut_certus_quartz_block" | "create:cutting/compat/quark/ancient_wood" | "pamhc2foodextended:lambkebabitem" | "createaddition:rolling/steel_ingot" | "mekanism:processing/tin/clump/from_ore" | "powah:crafting/cable_niotic" | "biomeswevegone:green_enchanted_boat" | "create:crushing/compat/elementaryores/ore_diamond_end" | "powah:crafting/dielectric_casing" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/palm/painting/brown" | "immersiveengineering:blueprint/banner_bevels" | "mekanism:compat/ilikewood/bed/jungle/painting/green" | "biomeswevegone:florus_bookshelf" | "create:splashing/gray_concrete_powder" | "mekanism:compat/byg/crushing/soapstone/brick_slabs_to_polished_slabs" | "pamhc2foodextended:bakedhamitem" | "pamhc2foodextended:kohlundpinkelitem" | "mekanism:enriching/conversion/granite/slab_to_polished_slab" | "mekanism:module_nutritional_injection_unit" | "create:cutting/compat/botania/dreamwood" | "mekanism:compat/ilikewood/bed/bamboo/green" | "immersiveengineering:crusher/white_dye" | "domum_ornamentum:four_light" | "botanypots:botanypots/crafting/green_concrete_compact_hopper_botany_pot" | "immersiveengineering:crusher/ingot_uranium" | "mekanism:sawing/hanging_sign/spruce" | "immersiveengineering:crafting/connector_probe" | "mekanism:crushing/dewax/oxidized_cut_copper_stairs" | "mekanism:compat/ilikewoodxbyg/bed/maple/red" | "mekanism:processing/osmium/raw/from_raw_block" | "immersiveengineering:crafting/hammercrushing_uranium" | "mekanism:painting/banner/black" | "prefab:town_hall" | "immersiveengineering:blueprint/bullet_explosive" | "botanypots:botanypots/crafting/purple_concrete_botany_pot" | "minecraft:polished_granite_stairs_from_polished_granite_stonecutting" | "mekanism:infusion_conversion/diamond/from_enriched" | "biomeswevegone:florus_pressure_plate" | "pamhc2foodextended:chickenkatsuitem" | "create:small_diorite_brick_slab_recycling" | "create:milling/compat/byg/cyan_tulip" | "minecraft:arrow" | "pamhc2foodextended:lemonmeringueitem" | "mekanism:compat/ilikewoodxbiomesoplenty/chest/dead" | "mekanism:compat/ilikewoodxbyg/bed/cherry/cyan" | "minecraft:chiseled_red_rock_brick_wall_from_chiseled_red_rock_bricks_stonecutting" | "compressium:soulsand_8_uncraft" | "pamhc2foodextended:cornedbeefandcabbageitem" | "prefab:coil_of_lanterns_from_string_of_lanterns" | "pamhc2foodcore:baconcheeseburgeritem" | "pamhc2foodextended:soymilkitem" | "create:cut_granite_brick_wall_from_stone_types_granite_stonecutting" | "biomeswevegone:redwood_bookshelf" | "mekanism:compat/ilikewoodxbyg/bed/aspen/lime" | "mekanism:compat/ilikewoodxbyg/bed/jacaranda/painting/blue" | "biomeswevegone:stripped_ebony_wood" | "create:smelting/ingot_aluminium_compat_ic2" | "pamhc2crops:bread_grain" | "immersiveengineering:crafting/sheetmetal_colored_blue" | "mekanism:compat/ilikewoodxbyg/item_frame/cika" | "megacells:cells/portable/portable_mana_cell_1m" | "jaopca:immersiveengineering.material_to_dust.certus_quartz" | "advanced_ae:quantumaccel" | "mekanism:sawing/bed/pink" | "mekanism:compat/ilikewoodxbyg/lectern/lament" | "prefab:grass_slab" | "create:cutting/compat/ars_nouveau/stripped_blue_archwood_wood" | "pamhc2crops:scallionseeditem" | "mekanism:pigment_extracting/dye/blue" | "createoreexcavation:ore_vein_type/water" | "botanypots:minecraft/crop/glow_berry_bush" | "mekanism:compat/ilikewoodxbyg/ladder/baobab" | "sophisticatedstorage:hopper_upgrade" | "create_sa:brass_jetpack_recipe" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/willow/painting/red" | "sophisticatedstorage:netherite_barrel" | "immersiveengineering:crafting/treated_wood_packaged_from_vertical" | "immersiveengineering:crafting/ingot_constantan_to_nugget_constantan" | "biomeswevegone:palm_stairs" | "create:cutting/compat/biomesoplenty/hellbark_log" | "pamhc2foodextended:papayajellyitem" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/hellbark/blue" | "minecraft:respawn_anchor" | "create:cutting/compat/byg/skyris_wood" | "megacells:cells/portable/portable_mana_cell_4m" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/umbran/red" | "mekanism:pigment_extracting/concrete/cyan" | "immersiveengineering:blueprint/mold_bullet_casing" | "mekanism:compat/ilikewoodxbyg/bed/aspen/blue" | "mekanism:compat/ae2/decorative/sky_stone/enriching/smooth_wall_to_brick_wall" | "pamhc2foodextended:gooseberrypieitem" | "createaddition:charging/cut_copper_slab" | "createaddition:crafting/electrum_amulet" | "create:milling/compat/byg/pink_allium_flower_bush" | "mekanism:reaction/coal_gasification/blocks_coals" | "megacells:cells/standard/item_storage_cell_1m" | "biomeswevegone:stripped_blue_enchanted_wood" | "pamhc2trees:roastedpistachioitem_forge" | "comforts:hammock_to_blue" | "mekanism:compat/ilikewoodxbyg/panel/zelkova" | "biomeswevegone:blue_enchanted_wood" | "create:milling/compat/byg/richea" | "create:milling/compat/regions_unexplored/light_blue_snowbelle" | "botanytrees:minecraft/mangrove" | "prefab:crate_of_carrots" | "create:cutting/compat/byg/stripped_skyris_wood" | "minecraft:snow_block" | "ae2:network/cables/covered_light_blue" | "mekanism:compat/byg/sawing/trapdoor/ether" | "minecraft:sandstone_stairs" | "ae2:tools/paintballs_lumen_orange" | "create:crushing/compat/aether/ambrosium_ore" | "create:haunting/infested_cracked_stone_bricks" | "create:copper_tile_stairs" | "minecraft:coarse_dirt" | "create:crafting/kinetics/white_seat" | "mekanism:compat/ilikewoodxbyg/bed/ebony/white" | "biomeswevegone:jacaranda_slab" | "torchmaster:frozen_pearl" | "mekanism:compat/ilikewoodxbyg/bed/ebony/green" | "compressium:diamond_1_uncraft" | "mekanism:module_geiger_unit" | "minecraft:fermented_spider_eye" | "ae2:network/parts/panels_dark_monitor" | "draconicevolution:tools/wyvern_bow" | "minecraft:light_gray_glazed_terracotta" | "create:blasting/ingot_osmium_compat_mekanism" | "botanypots:minecraft/crop/bamboo" | "pamhc2foodextended:mochaicecreamitem" | "connectedglass:tinted_borderless_glass_brown2" | "create:cutting/compat/biomesoplenty/mahogany_log" | "pamhc2trees:roastedpecanitem_forge" | "mekanism:pigment_extracting/stained_glass/red" | "create:cutting/compat/ecologics/flowering_azalea_log" | "biomeswevegone:stripped_jacaranda_wood" | "pamhc2foodextended:breadfruityogurtitem" | "minecraft:cobbled_deepslate_slab" | "create:crafting/appliances/dough" | "immersiveengineering:arcfurnace/raw_block_copper" | "create:cutting/compat/biomesoplenty/stripped_redwood_wood" | "minecraft:iron_door" | "minecraft:purple_stained_glass_pane" | "mekanism:compat/byg/enriching/ether/slabs_to_carved_slabs" | "compressium:redsand_9" | "botanypots:botanypots/crafting/blue_terracotta_compact_hopper_botany_pot" | "immersiveengineering:cloche/brown_mushroom" | "ae2:tools/paintballs_lumen_gray" | "domum_ornamentum:vanilla_trapdoors_compat_full" | "immersiveengineering:arcfurnace/raw_block_tungsten" | "minecraft:chiseled_quartz_block" | "create:crafting/materials/rose_quartz_tilesfrom_conversion" | "pamhc2foodextended:durianpieitem" | "mekanism:sawing/jukebox" | "prefab:modern_buildings_improved" | "mekanism:compat/ilikewoodxbyg/bed/cika/yellow" | "draconicevolution:tools/crystal_binder" | "compressium:redsand_8" | "powah:crafting/ender_cell_starter" | "compressium:redsand_7" | "compressium:redsand_6" | "compressium:redsand_5" | "compressium:redsand_4" | "compressium:redsand_3" | "compressium:redsand_2" | "compressium:redsand_1" | "pamhc2foodextended:saltedcaramelitem" | "mekanism:enriching/dye/black" | "create:cutting/compat/the_vault/stripped_overgrown_wooden_log" | "botanypots:botanypots/crafting/terracotta_compact_hopper_botany_pot" | "create:cut_crimsite_brick_stairs_from_stone_types_crimsite_stonecutting" | "ae2:network/cables/glass_white" | "comforts:hammock_to_lime" | "sophisticatedstorage:light_gray_shulker_box_to_sophisticated" | "prefab:bunch_of_potatoes" | "biomeswevegone:fir_chest_boat" | "mekanism:nucleosynthesizing/dragon_egg" | "powah:crafting/binding_card" | "botanytrees:biomeswevegone/pine" | "megacells:cells/standard/item_storage_cell_4m" | "immersiveengineering:sawmill/treated_wood_horizontal_slab" | "mekanism:compat/ilikewoodxbyg/bed/embur/painting/yellow" | "minecraft:smooth_quartz_stairs" | "create:crushing/raw_uranium" | "create:blasting/ingot_uranium_compat_mekanism" | "create:milling/compat/regions_unexplored/purple_lupine" | "pamhc2foodcore:glowberryyogurtitem" | "createaddition:mixing/biomass_from_honeycomb" | "mekanism:sawing/fence_gate/warped" | "mekanism:compat/ilikewoodxbyg/bed/maple/green" | "domum_ornamentum:yellow_brick_extra" | "pamhc2foodextended:zucchinifriesitem" | "botanypots:pamhc2crops/crop/flax" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/magic/painting/blue" | "mekanism:compat/ilikewood/lectern/cherry" | "connectedglass:vanilla_black_stained_glass_pane" | "create:cutting/compat/regions_unexplored/pink_bioshroom_hyphae" | "create:smelting/ingot_lead_compat_mekanism" | "fulleng:terminals/block_storage_monitor_from_part" | "mekanism:compat/byg/enriching/travertine/walls_to_polished_walls" | "minecraft:orange_candle" | "immersiveengineering:crafting/sheetmetal_lead" | "mekanism:compat/ilikewood/bed/spruce/cyan" | "mekanism:enriching/conversion/gravel_to_flint" | "mekanism:processing/osmium/clump/from_ore" | "mekanism:enriching/deoxidizing/copper_block" | "biomeswevegone:baobab_fence_gate" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/fir/painting/light_blue" | "crafting_on_a_stick:uncraft_stonecutter" | "buddingcrystals:budding_emerald" | "megacells:cells/portable/portable_mana_cell_64m" | "minecraft:stone_brick_wall" | "ae2:decorative/smooth_quartz_block" | "mekanism:compat/ilikewoodxbyg/bed/ether/orange" | "pamhc2crops:greengrapeseeditem" | "compressium:snow_1_uncraft" | "sophisticatedstorage:decoration_table" | "easy_mob_farm:upgrade/enhancement/experience_enhancement" | "create_sa:vault_recipe" | "minecraft:light_blue_dye_from_blue_white_dye" | "mekanism:painting/dye/red" | "mekanism:compat/ae2/decorative/sky_stone/crushing/small_brick_slab_to_brick_slab" | "mekanism:compat/ilikewoodxbyg/bed/white_mangrove/painting/yellow" | "minecraft:cyan_dye" | "botanypots:minecraft/soil/podzol" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/jacaranda/painting/gray" | "create:cutting/compat/ars_nouveau/stripped_blue_archwood_log" | "mekanism:crushing/biofuel/grass" | "mekanism:induction/cell/elite" | "compressium:clay_4_uncraft" | "create:crafting/kinetics/gray_seat_from_other_seat" | "create:cutting/compat/biomesoplenty/palm_wood" | "minecraft:gold_block" | "minecraft:spruce_boat" | "minecraft:cherry_wood" | "immersiveengineering:crafting/sheetmetal_colored_lime" | "connectedglass:scratched_glass_cyan1" | "mekanism:injecting/coral/tube_coral" | "connectedglass:scratched_glass_cyan2" | "immersiveengineering:crafting/sheetmetal_colored_yellow" | "pamhc2foodextended:gyudonitem" | "mekanism:pigment_extracting/dye/lime" | "create:cutting/compat/byg/nightshade_log" | "mekanism:compat/ilikewood/panel/warped" | "pamhc2trees:gooseberry_sapling" | "pamhc2foodcore:chocolatecakeitem" | "mekanism:compat/ilikewoodxbyg/bed/zelkova/painting/light_blue" | "mekanism:pigment_extracting/concrete/white" | "mekanism:compat/biomesoplenty/sawing/log/mahogany" | "minecraft:copper_ingot_from_blasting_raw_copper" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/magic/painting/lime" | "pamhc2foodextended:meringuecookieitem" | "botanypots:botanypots/crafting/blue_concrete_hopper_botany_pot" | "sophisticatedstorage:compacting_upgrade" | "pamhc2foodextended:mangochutneyitem" | "create:cutting/compat/regions_unexplored/stripped_blue_bioshroom_stem" | "mekanism:sawing/pressure_plate/warped" | "immersiveengineering:crusher/raw_ore_cobalt" | "mekanism:compat/ilikewood/bed/spruce/painting/black" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/palm/painting/magenta" | "mekanism:pigment_extracting/dye/black" | "create:cut_tuff_brick_slab_recycling" | "botanypots:minecraft/soil/granite" | "mekanism:painting/dye/black" | "friendsandfoes:bamboo_beehive" | "powah:crafting/energy_discharger_spirited" | "create:ornate_iron_window_pane" | "pamhc2foodextended:breadfruitjuiceitem" | "minecraft:raw_iron" | "minecraft:iron_nugget" | "immersiveengineering:cloche/dandelion" | "pamhc2foodcore:melonjellyitem" | "pamhc2foodextended:blackberrypieitem" | "minecraft:waxed_oxidized_cut_copper_from_honeycomb" | "pamhc2foodextended:candiedwalnutsitem" | "minecraft:bamboo_fence_gate" | "mekanism:compat/byg/crushing/ether/slabs_to_cobblestone_slabs" | "immersiveengineering:crafting/wirecoil_structure_rope" | "pamhc2foodextended:chocolatepeanutbaritem" | "mekanism:module_attack_amplification_unit" | "mekanism:compat/biomesoplenty/sawing/log/palm" | "biomeswevegone:pine_planks" | "mekanism:compat/ilikewoodxbyg/bed/willow/painting/blue" | "mekanism:energy_cube/ultimate" | "immersiveengineering:crafting/sheetmetal_colored_purple_from_slab" | "mekanismtools:iron_nugget_from_blasting" | "sophisticatedbackpacks:advanced_magnet_upgrade_from_basic" | "comforts:hammock_purple" | "create:cut_veridium_wall" | "mekanism:compat/byg/sawing/log/rainbow_eucalyptus" | "create:crafting/kinetics/magenta_seat_from_other_seat" | "mekanismtools:gold_nugget_from_blasting" | "create:cutting/compat/integrateddynamics/menril_log" | "mekanism:compat/ilikewood/bed/bamboo/yellow" | "powah:crafting/reactor_basic" | "biomeswevegone:green_enchanted_wood" | "mekanism:teleporter_frame" | "mekanism:compat/ilikewoodxbiomesoplenty/post/magic" | "mekanism:painting/candle/yellow" | "mekanism:compat/ilikewoodxbyg/bed/redwood/light_gray" | "easy_mob_farm:upgrade/enhancement/loot_enhancement" | "minecraft:dye_light_gray_wool" | "mekanism:compat/ilikewood/post/warped" | "minecraft:writable_book" | "botanypots:botanypots/crafting/lime_glazed_terracotta_hopper_botany_pot" | "create:cut_dripstone_brick_wall_from_stone_types_dripstone_stonecutting" | "pamhc2trees:dragonfruit_sapling" | "biomeswevegone:pink_sand" | "immersiveengineering:crusher/ingot_rose_gold" | "domum_ornamentum:blockbarreldeco_onside" | "minecraft:diamond_pickaxe" | "pamhc2foodextended:gooseberrysmoothieitem" | "mekanism:crushing/biofuel/moss_carpet" | "create:splashing/ic2/crushed_raw_aluminum" | "mekanism:superheating_element" | "create:crushing/deepslate_redstone_ore" | "mekanism:compat/ilikewoodxbyg/bed/blue_enchanted/painting/light_blue" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/jacaranda/painting/black" | "create:milling/compat/botania/pink_petal" | "create:small_deepslate_brick_slab_recycling" | "biomeswevegone:chiseled_red_rock_brick_wall" | "mekanism:compat/ilikewoodxbyg/bed/witch_hazel/painting/magenta" | "pamhc2foodextended:apricotjellytoastitem" | "immersiveengineering:crafting/ingot_electrum_to_nugget_electrum" | "pamhc2foodcore:bakedvegetablemedlyitem" | "mekanism:compat/ilikewood/bed/birch/light_blue" | "immersiveengineering:crafting/raw_block_lead_to_raw_lead" | "draconicevolution:modules/item_draconic_shield_capacity_uncraft" | "compressium:soulsand_6_uncraft" | "sophisticatedstorage:green_shulker_box_to_sophisticated" | "cookingforblockheads:gray_kitchen_floor" | "pamhc2foodextended:raspberryjellyitem" | "immersiveengineering:crafting/electric_lantern" | "immersiveengineering:smelting/nugget_steel_recycle_sword_from_blasting" | "mekanism:compat/byg/sawing/log/baobab" | "mekanism:processing/iron/clump/from_shard" | "mekanism:compat/ilikewoodxbyg/bed/palm/painting/magenta" | "mekanism:compat/biomesoplenty/sawing/log/umbran" | "botanypots:minecraft/soil/rooted_dirt" | "mekanism:enriching/conversion/granite/to_polished" | "biomeswevegone:maple_trapdoor" | "mekanism:chemical_infusing/sulfur_trioxide" | "mekanism:pigment_extracting/carpet/purple" | "mekanism:qio_exporter" | "mekanism:compat/ilikewoodxbyg/post/baobab" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/cherry/painting/yellow" | "utilitarian:no_soliciting/soliciting_carpets/brown_trapped_soliciting_carpet" | "pamhc2foodextended:blueberryjellysandwichitem" | "draconicevolution:modules/item_draconium_jump" | "ae2:network/blocks/interfaces_interface" | "ae2:network/cables/smart_magenta" | "mekanism:compat/ilikewoodxbyg/soul_torch/willow" | "mekanism:injecting/concrete/yellow" | "pamhc2foodextended:melonjellysandwichitem" | "botanypots:farmingforblockheads/soil/fertilized_farmland_healthy_stable" | "mekanism:injecting/coral/fire_coral" | "create:warped_window_pane" | "create:crafting/schematics/schematic_table" | "connectedglass:scratched_glass_magenta2" | "connectedglass:scratched_glass_magenta1" | "create:crafting/copper/waxed_weathered_copper_tile_stairs_from_honeycomb" | "mekanism:sawing/pressure_plate/birch" | "immersiveengineering:crafting/fluid_pump" | "naturalist:cut_shellstone_wall" | "jaopca:mekanism.dirty_to_clean_slurry.aluminum" | "immersiveengineering:smelting/nugget_steel_recycle_shovel" | "mekanism:network_reader" | "mekanism:compat/ilikewoodxbiomesoplenty/composter/fir" | "mekanism:infusion_conversion/carbon/from_charcoal_block" | "mekanism:pigment_extracting/carpet/yellow" | "minecraft:wooden_pickaxe" | "mekanism:compat/ilikewoodxbyg/bed/imparius/black" | "create:small_asurine_brick_slab" | "powah:crafting/spirited_crystal_block" | "pamhc2foodcore:mashedpotatoesitem" | "pamhc2foodextended:redvelvetcupcakeitem" | "domum_ornamentum:panel_slot" | "ae2:network/blocks/pattern_providers_interface" | "pamhc2foodextended:theatreboxitem" | "botanypots:minecraft/soil/hay_bale" | "create:cut_granite_brick_stairs" | "botanypots:botanypots/crafting/green_terracotta_botany_pot" | "mekanism:sawing/log/dark_oak" | "mekanism:compat/ilikewoodxbyg/bed/lament/painting/pink" | "woodwevegot:willow_ladder" | "minecraft:diamond_from_blasting_diamond_ore" | "aquaculture:tin_can_to_iron_nugget" | "createaddition:compat/immersiveengineering/item_application/leaded_concrete" | "mekanismtools:refined_glowstone/armor/boots" | "biomeswevegone:mahogany_trapdoor" | "create:crushing/tin_ore" | "compressium:redsand_2_uncraft" | "mekanism:compat/farmersdelight/sawing/minced_beef" | "minecraft:end_stone_brick_stairs" | "create:small_andesite_brick_wall_from_stone_types_andesite_stonecutting" | "sophisticatedstorage:storage_advanced_magnet_upgrade_from_backpack_advanced_magnet_upgrade" | "mekanism:compat/ilikewoodxbyg/torch/nightshade" | "create:cut_asurine_brick_stairs_from_stone_types_asurine_stonecutting" | "minecraft:stripped_crimson_hyphae" | "buddingcrystals:budding_draconium" | "botanypots:botanypots/crafting/gray_concrete_compact_hopper_botany_pot" | "biomeswevegone:dacite_brick_slab" | "mekanism:pigment_extracting/dye/yellow" | "draconicevolution:modules/item_chaotic_energy_link" | "minecraft:smooth_sandstone_stairs_from_smooth_sandstone_stonecutting" | "immersiveengineering:sawmill/dark_oak_slab" | "pamhc2foodextended:lavendershortbreaditem" | "sophisticatedstorage:limited_iron_barrel_3_from_limited_copper_barrel_3" | "immersiveengineering:smelting/nugget_steel_recycle_steel_helmet_from_blasting" | "create:cutting/compat/byg/stripped_bulbis_stem" | "mekanism:compat/ilikewoodxbyg/composter/white_mangrove" | "minecraft:mangrove_fence" | "minecraft:polished_deepslate_from_cobbled_deepslate_stonecutting" | "cookingforblockheads:orange_kitchen_floor" | "draconicevolution:modules/item_chaotic_damage" | "powah:energizing/uraninite_from_ore_poor" | "mekanism:compat/byg/crushing/scoria/from_cracked_bricks" | "minecraft:light_gray_bed" | "mekanism:pigment_extracting/banner/brown" | "mekanism:factory/basic/injecting" | "immersiveengineering:crusher/ingot_osmium" | "immersiveengineering:blueprint/graphite_electrode" | "advanced_ae:eaeadvpatpro" | "compressium:clay_1_uncraft" | "create:cutting/compat/regions_unexplored/larch_log" | "immersiveengineering:cloche/torchflower" | "minecraft:storage_output_from_input" | "biomeswevegone:aspen_door" | "create:cutting/compat/goodending/stripped_muddy_oak_wood" | "pamhc2foodcore:chorusyogurtitem" | "pamhc2foodextended:juniperberryjellyitem" | "mekanism:compat/biomesoplenty/sawing/hanging_sign/palm" | "mekanism:compat/ilikewoodxbiomesoplenty/panel/dead" | "connectedglass:tinted_borderless_glass_orange2" | "woodwevegot:jacaranda_trapped_chest" | "pamhc2foodcore:muttonpotpieitem" | "mekanism:compat/byg/sawing/boat/pine" | "minecraft:spruce_chest_boat" | "utilitarian:utility/acacia_logs_to_slabs" | "create:milling/compat/regions_unexplored/green_snowbelle" | "mekanismtools:refined_obsidian/tools/axe" | "immersiveengineering:crafting/gunpart_drum" | "naturalist:cooked_venison" | "mekanism:processing/gold/slurry/dirty/from_raw_block" | "immersiveengineering:crafting/paper_from_sawdust" | "mekanism:compat/ilikewoodxbyg/bed/willow/painting/lime" | "pamhc2foodextended:kalechipsitem" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/palm/painting/light_blue" | "ae2:shaped/slabs/quartz_block" | "immersiveengineering:arcfurnace/dust_lead" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/magic/light_gray" | "immersiveengineering:crafting/alu_wallmount" | "powah:crafting/reactor_hardened" | "mekanism:crushing/biofuel/jungle_sapling" | "botanypots:botanypots/crafting/lime_terracotta_compact_hopper_botany_pot" | "mekanism:enriching/deoxidizing/exposed_cut_copper_slab" | "minecraft:snow" | "biomeswevegone:red_rock_wall" | "megacells:cells/standard/mana_storage_cell_16m_with_housing" | "immersiveengineering:sawmill/stripped_crimson_log" | "create:cut_crimsite_brick_slab_recycling" | "sophisticatedstorage:storage_chipped_loom_table_upgrade_from_backpack_chipped_loom_table_upgrade" | "immersiveengineering:crafting/stairs_clinker_brick" | "minecraft:blackstone_wall_from_blackstone_stonecutting" | "biomeswevegone:stripped_sakura_wood" | "mekanism:crushing/stone/from_cracked_bricks" | "create:milling/compat/regions_unexplored/cactus_flower" | "pamhc2foodextended:dragonfruitjellyitem" | "ae2:network/cables/glass_cyan" | "immersiveengineering:smelting/nugget_steel_recycle_steel_boots_from_blasting" | "immersiveengineering:crafting/stick_iron" | "mekanism:compat/ilikewoodxbyg/bed/aspen/magenta" | "minecraft:emerald_from_smelting_emerald_ore" | "create:crafting/appliances/copper_diving_boots" | "pamhc2foodextended:pineapplejellyitem" | "waystones:lime_sharestone" | "pamhc2foodextended:pearjellyitem" | "draconicevolution:modules/item_wyvern_mining_stability" | "mekanism:enriching/hdpe_sheet" | "create:crushing/wool" | "pamhc2foodextended:orangejellyitem" | "elevatorid:elevator_brown" | "mekanism:compat/ilikewood/item_frame/birch" | "create:crimson_window" | "mekanism:upgrade/stone_generator" | "pamhc2foodextended:huckleberryyogurtitem" | "immersiveengineering:blastfurnace/steel_block" | "createaddition:pressing/uranium_ingot" | "mekanism:compat/ilikewoodxbyg/bed/holly/red" | "powah:crafting/ender_cell_hardened_2" | "mekanismgenerators:separator/heavy_water" | "ae2:matter_cannon/nuggets/uranium" | "minecraft:white_concrete_powder" | "mekanism:compat/ilikewoodxbyg/crafting_table/ebony" | "botanypots:botanypots/crafting/white_concrete_botany_pot" | "minecraft:yellow_terracotta" | "botanytrees:pamhc2trees/durian_sapling" | "mekanism:compat/ilikewoodxbyg/chest/aspen" | "immersiveengineering:crafting/alloybrick_from_slab" | "create:cutting/mangrove_log" | "pamhc2foodextended:dragonfruitjellytoastitem" | "pamhc2foodextended:breakfastburritoitem" | "botanypots:botanypots/crafting/light_blue_terracotta_botany_pot" | "powah:crafting/cable_blazing_2" | "sophisticatedbackpacks:blasting_upgrade" | "minecraft:cherry_boat" | "minecraft:chiseled_nether_bricks_from_nether_bricks_stonecutting" | "mekanism:compat/ilikewoodxbyg/bed/bulbis/painting/brown" | "mekanism:processing/osmium/slurry/dirty/from_raw_block" | "create:small_andesite_brick_stairs_from_stone_types_andesite_stonecutting" | "aquaculture:cooked_fish_fillet_from_campfire" | "create:deploying/waxed_weathered_copper_shingles_from_adding_wax" | "mekanism:module_inhalation_purification_unit" | "biomeswevegone:blue_dye_from_bwg_tag" | "create:milling/compat/regions_unexplored/yellow_snowbelle" | "ae2:matter_cannon/nuggets/zirconium" | "pamhc2foodextended:grilledcheesevegemitetoastitem" | "pamhc2foodextended:mulberryjellyitem" | "mekanism:compat/ilikewoodxbyg/bed/jacaranda/light_gray" | "pamhc2foodextended:springsaladitem" | "immersiveengineering:metalpress/gear_invar" | "biomeswevegone:palm_boat" | "ae2:network/cables/glass_green" | "create:crushing/compat/silentgems/sapphire_ore" | "create:cut_deepslate_wall_from_stone_types_deepslate_stonecutting" | "mekanism:compat/ilikewood/bed/spruce/painting/cyan" | "pamhc2foodextended:figpieitem" | "minecraft:barrel" | "mekanism:compat/ilikewoodxbyg/bed/nightshade/pink" | "pamhc2foodextended:corndogitem" | "create:crushing/compat/elementaryores/ore_emerald_end" | "create:tuff_pillar_from_stone_types_tuff_stonecutting" | "mekanism:compat/byg/sawing/pressure_plate/mahogany" | "aquaculture:golden_fishing_rod" | "botanypots:botanypots/crafting/purple_terracotta_compact_hopper_botany_pot" | "immersiveengineering:crusher/raw_block_tungsten" | "compressium:netherite_2_uncraft" | "megacells:crafting/bulk_cell_component" | "mekanism:enriching/deoxidizing/exposed_copper" | "mekanism:painting/wool/gray" | "mekanism:pigment_extracting/concrete_powder/orange" | "biomeswevegone:cut_blue_sandstone_slab" | "mekanism:crushing/blackstone/bricks_to_cracked_bricks" | "compressium:dirt_1_uncraft" | "minecraft:dye_gray_carpet" | "mekanism:compat/ilikewood/bed/warped/gray" | "pamhc2foodextended:fajitaburritoitem" | "minecraft:shaper_armor_trim_smithing_template" | "elevatorid:elevator_yellow" | "mekanism:control_circuit/elite" | "mekanism:compat/ilikewoodxbyg/bed/fir/painting/yellow" | "minecraft:cauldron" | "compressium:copper_2_uncraft" | "create:cutting/compat/byg/stripped_blue_enchanted_wood" | "immersiveengineering:crusher/black_dye" | "mekanism:compat/byg/dye/lime" | "mekanism:pigment_extracting/wool/gray" | "mekanism:compat/byg/sawing/log/embur" | "immersiveengineering:smelting/nugget_steel_recycle_steel_chestplate" | "minecraft:waxed_weathered_cut_copper_slab_from_honeycomb" | "ae2:block_cutter/walls/smooth_sky_stone_wall" | "create:cutting/compat/regions_unexplored/stripped_brimwood_log" | "pamhc2foodextended:museliitem" | "ae2:network/cables/dense_covered_magenta" | "mekanism:compat/ilikewoodxbyg/bed/lament/lime" | "mekanism:processing/gold/shard/from_raw_block" | "utilitarian:utility/oak_logs_to_trapdoors" | "mekanism:compat/ilikewoodxbiomesoplenty/composter/palm" | "megacells:cells/portable/portable_chemical_cell_256m" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/dead/gray" | "botanypots:pamhc2crops/crop/strawberry" | "megacells:cells/portable/portable_source_cell_16m" | "create:cutting/compat/byg/cypress_log" | "minecraft:gold_ingot_from_smelting_gold_ore" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/cherry/green" | "mekanism:compat/ilikewoodxbyg/bed/bulbis/painting/yellow" | "pamhc2foodextended:almondbutteritem" | "mekanism:crushing/dewax/oxidized_cut_copper_slab" | "megacells:network/mega_interface_part" | "pamhc2crops:parsnipseeditem" | "woodwevegot:blue_enchanted_ladder" | "mekanism:compat/ilikewoodxbyg/bed/white_mangrove/painting/black" | "mekanism:compat/ilikewoodxbyg/chest/pine" | "mekanism:compat/ilikewoodxbyg/bed/ether/painting/cyan" | "pamhc2foodextended:coleslawitem" | "botanypots:botanypots/crafting/terracotta_botany_pot" | "biomeswevegone:jacaranda_planks" | "mekanism:enriching/deoxidizing/weathered_cut_copper_stairs" | "draconicevolution:modules/item_draconic_undying" | "minecraft:chest" | "mekanismgenerators:fission_reactor/port" | "botanypots:minecraft/soil/diamond_ore" | "minecraft:gray_stained_glass" | "immersiveengineering:crafting/sheetmetal_colored_gray_from_slab" | "biomeswevegone:fir_hanging_sign" | "pamhc2foodextended:haggisitem" | "jaopca:mekanism.material_to_dust.aluminum" | "createaddition:charging/exposed_cut_copper_stairs" | "mekanism:compat/ilikewoodxbyg/post/sythian" | "create:cutting/compat/byg/bulbis_stem" | "pamhc2foodextended:pomegranatejellysandwichitem" | "botanytrees:pamhc2trees/pawpaw_sapling" | "minecraft:red_bed" | "create:cutting/compat/twilightforest/stripped_mining_wood" | "cookingforblockheads:yellow_kitchen_floor" | "mekanism:factory/elite/compressing" | "ae2:network/cells/item_storage_cell_4k" | "connectedglass:vanilla_gray_stained_glass_pane" | "minecraft:deepslate_bricks_from_cobbled_deepslate_stonecutting" | "justhammers:stone_destructor_hammer" | "immersiveengineering:smelting/ingot_aluminum_from_blasting" | "create:compacting/granite_from_flint" | "ae2:network/wireless_part" | "mekanism:compat/ilikewoodxbyg/bed/ether/painting/white" | "biomeswevegone:cut_windswept_sandstone" | "biomeswevegone:jacaranda_bookshelf" | "create:copper_ladder_from_ingots_copper_stonecutting" | "sophisticatedstorage:dark_oak_barrel" | "mekanismgenerators:turbine/blade" | "botanypots:minecraft/crop/hanging_roots" | "mekanism:enriching/enriched/gold" | "mekanism:enriching/deoxidizing/exposed_cut_copper" | "mekanism:compat/ilikewoodxbyg/bed/redwood/painting/brown" | "create:cutting/stripped_birch_log" | "immersiveengineering:mineral/mephitic_quarzite" | "mekanism:pigment_extracting/candle/red" | "mekanism:compat/ilikewoodxbyg/bed/ebony/painting/purple" | "minecraft:iron_boots" | "minecraft:golden_chestplate" | "mekanism:crushing/biofuel/cocoa_beans" | "mekanism:compat/ilikewoodxbiomesoplenty/chest/hellbark" | "comforts:sleeping_bag_to_green" | "waystones:green_sharestone" | "minecraft:netherite_ingot" | "pamhc2foodextended:potatocakesitem" | "mekanism:compat/farmersdelight/sawing/raw_bacon" | "naturalist:bug_net" | "create_sa:brass_leggings_recipe" | "mekanism:pigment_extracting/concrete/purple" | "botanypots:botanypots/crafting/white_terracotta_compact_hopper_botany_pot" | "domum_ornamentum:beige_bricks" | "mekanism:compat/byg/dye/blue" | "ae2:network/cells/item_storage_cell_1k" | "utilitarian:utility/jungle_slab_to_block" | "biomeswevegone:redwood_chest_boat" | "mekanism:compat/ilikewoodxbyg/post/aspen" | "ae2:tools/nether_quartz_hoe" | "mekanism:compat/ilikewoodxbyg/wall/willow" | "biomeswevegone:jacaranda_sign" | "sophisticatedstorage:backpack_stack_upgrade_tier_3_from_storage_stack_upgrade_tier_4" | "minecraft:light_blue_terracotta" | "mekanism:compat/ilikewood/soul_torch/dark_oak" | "powah:crafting/energy_hopper_basic" | "create:cutting/compat/botania/glimmering_livingwood_log" | "minecraft:spruce_stairs" | "create:deploying/waxed_cut_copper_from_adding_wax" | "pamhc2foodextended:chocolatechippancakesitem" | "immersiveengineering:squeezer/beetroot_seeds" | "mekanism:processing/gold/shard/from_ore" | "mekanism:compat/ilikewoodxbyg/bed/aspen/orange" | "mekanism:factory/advanced/enriching" | "pamhc2crops:bakedtaroitem_smoker" | "mekanism:compat/ilikewood/bed/jungle/painting/white" | "elevatorid:elevator_cyan" | "minecraft:light_gray_dye_from_white_tulip" | "mekanism:compat/byg/sawing/fence_gate/cherry" | "create:cutting/compat/blue_skies/bluebright_log" | "immersiveengineering:crafting/wirecoil_copper" | "mekanism:compat/ilikewoodxbiomesoplenty/soul_torch/jacaranda" | "botanypots:pamhc2crops/crop/radish" | "pamhc2foodextended:fivespiceitem" | "botanypots:botanypots/crafting/pink_concrete_hopper_botany_pot" | "mekanism:compat/ilikewoodxbyg/bed/baobab/light_gray" | "create:cutting/compat/quark/azalea_log" | "create:polished_cut_scoria_wall" | "create:cut_dripstone_wall_from_stone_types_dripstone_stonecutting" | "mekanism:compat/byg/enriching/red_rock/cracked_brick_walls_to_brick_walls" | "immersiveengineering:crafting/conveyor_extract" | "jaopca:immersiveengineering.material_to_dust.lapis" | "mekanism:compat/ilikewoodxbyg/bed/blue_enchanted/brown" | "create:cutting/compat/twilightforest/twilight_oak_log" | "sophisticatedbackpacks:deposit_upgrade" | "mekanism:bin/elite" | "minecraft:dacite_brick_slab_from_dacite_bricks_stonecutting" | "mekanismtools:bronze/tools/pickaxe" | "mekanism:compat/ilikewoodxbyg/bed/aspen/red" | "create:copycat_panel_from_ingots_zinc_stonecutting" | "minecraft:cooked_rabbit_from_campfire_cooking" | "advanced_ae:evasion_card" | "immersiveengineering:arcfurnace/dust_aluminum" | "mekanism:processing/copper/ore/from_raw" | "mekanism:compat/ilikewood/panel/dark_oak" | "mekanism:crafting_formula" | "mekanism:compat/ilikewood/soul_torch/spruce" | "sophisticatedstorage:storage_filter_upgrade_from_backpack_filter_upgrade" | "immersiveengineering:metalpress/rod_rose_gold" | "mekanism:compat/ilikewoodxbyg/bed/cherry/painting/pink" | "mekanism:compat/byg/enriching/red_rock/to_cracked_bricks" | "mekanism:compat/ilikewoodxbiomesoplenty/bed/fir/painting/cyan" | "create:crushing/raw_nickel_block" | "immersiveengineering:metalpress/plate_zinc" | "easy_mob_farm:mob_farm/animal_plains_farm/tier2_animal_plains_farm" | "create:small_limestone_brick_wall_from_stone_types_limestone_stonecutting" | "domum_ornamentum:cro