/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.alchemy;

import javax.annotation.concurrent.Immutable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedcore.upgrades.alchemy.AlchemyCondition;

@Immutable
public record AlchemyFilterAttribute(ItemStack filter, AlchemyCondition condition, float value) {
    public AlchemyFilterAttribute(ItemStack filter, AlchemyCondition condition) {
        this(filter, condition, -1.0f);
    }

    public AlchemyFilterAttribute setFilter(ItemStack filter) {
        CopyBuilder builder = new CopyBuilder(this);
        builder.filter(filter);
        return builder.build();
    }

    public AlchemyFilterAttribute setConditionAndValue(AlchemyCondition condition, float value) {
        CopyBuilder builder = new CopyBuilder(this);
        builder.condition(condition);
        builder.value(value);
        return builder.build();
    }

    public AlchemyFilterAttribute setValue(float value) {
        CopyBuilder builder = new CopyBuilder(this);
        builder.value(value);
        return builder.build();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("filter", (Tag)this.filter.serializeNBT());
        tag.m_128359_("condition", this.condition.m_7912_());
        tag.m_128350_("value", this.value);
        return tag;
    }

    public static AlchemyFilterAttribute deserializeNBT(CompoundTag tag) {
        ItemStack filter = ItemStack.m_41712_((CompoundTag)tag.m_128469_("filter"));
        AlchemyCondition condition = AlchemyCondition.fromName(tag.m_128461_("condition"));
        float value = tag.m_128457_("value");
        return new AlchemyFilterAttribute(filter, condition, value);
    }

    private static class CopyBuilder {
        private float value;
        private ItemStack filter;
        private AlchemyCondition condition;

        private CopyBuilder(AlchemyFilterAttribute attribute) {
            this.filter = attribute.filter;
            this.condition = attribute.condition;
            this.value = attribute.value;
        }

        public CopyBuilder filter(ItemStack filter) {
            this.filter = filter;
            return this;
        }

        public CopyBuilder condition(AlchemyCondition condition) {
            this.condition = condition;
            return this;
        }

        public CopyBuilder value(float value) {
            this.value = value;
            return this;
        }

        public AlchemyFilterAttribute build() {
            return new AlchemyFilterAttribute(this.filter, this.condition, this.value);
        }
    }
}

