/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.items;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.client.ItemStackRenderer;
import net.mehvahdjukaar.moonlight.api.client.model.BakedQuadBuilder;
import net.mehvahdjukaar.moonlight.api.client.util.VertexUtil;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class AltimeterItemRenderer
extends ItemStackRenderer {
    private static final Map<ResourceKey<Level>, Pair<TextureAtlasSprite, Int2ObjectMap<BakedModel>>> MODEL_CACHE = new HashMap<ResourceKey<Level>, Pair<TextureAtlasSprite, Int2ObjectMap<BakedModel>>>();

    public void m_108829_(ItemStack stack, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        ResourceKey dimension = level == null ? Level.f_46428_ : level.m_46472_();
        Pair<TextureAtlasSprite, Int2ObjectMap<BakedModel>> pair = MODEL_CACHE.getOrDefault(dimension, MODEL_CACHE.get(Level.f_46428_));
        if (pair == null) {
            Supplementaries.error();
            return;
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)pair.getFirst();
        int textureH = sprite.m_245424_().m_245330_();
        double stripDepth = AltimeterItemRenderer.calculateDepthIndex(level, textureH);
        int mult = ClientConfigs.Items.DEPTH_METER_STEP_MULT.get();
        int index = (int)Math.round(stripDepth * (double)mult);
        BakedModel model = (BakedModel)((Int2ObjectMap)pair.getSecond()).computeIfAbsent(index, i -> new AltimeterModel((float)index / (float)mult, textureH, sprite));
        Minecraft.m_91087_().m_91291_().m_115143_(Items.f_42415_.m_7968_(), transformType, false, poseStack, buffer, packedLight, packedOverlay, model);
        poseStack.m_85849_();
    }

    private static double calculateDepthIndex(@Nullable ClientLevel level, int textureH) {
        int min = level == null ? -64 : level.m_141937_();
        int max = level == null ? 312 : level.m_151558_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        double depth = player == null ? 64.0 : player.m_20182_().f_82480_;
        double normDepth = Mth.m_14008_((double)((depth - (double)min) / (double)(max - min)), (double)0.0, (double)1.0);
        return normDepth * (double)(textureH - 6);
    }

    public static void onReload() {
        MODEL_CACHE.clear();
        ArrayList<ResourceLocation> resourceLocations = new ArrayList<ResourceLocation>((Collection)ClientConfigs.Items.DEPTH_METER_DIMENSIONS.get());
        resourceLocations.add(Level.f_46428_.m_135782_());
        for (ResourceLocation d : resourceLocations) {
            ResourceKey res = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)d);
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(Supplementaries.res("item/altimeter/" + d.toString().replace(":", "_")));
            if (sprite == null) continue;
            MODEL_CACHE.put((ResourceKey<Level>)res, (Pair<TextureAtlasSprite, Int2ObjectMap<BakedModel>>)Pair.of((Object)sprite, (Object)new Int2ObjectOpenHashMap()));
        }
    }

    private static class AltimeterModel
    implements BakedModel {
        private final List<BakedQuad> quads = new ArrayList<BakedQuad>();
        private final ItemOverrides overrides;
        private final ItemTransforms transforms;

        AltimeterModel(float depth, int textureH, TextureAtlasSprite sprite) {
            int h = 5;
            float invDepth = (float)textureH - depth - (float)h;
            float shrink = sprite.m_118417_();
            BakedQuadBuilder builder = BakedQuadBuilder.create((TextureAtlasSprite)sprite);
            builder.setAutoDirection();
            builder.setAutoBuild(this.quads::add);
            PoseStack ps = new PoseStack();
            float u0 = 0.0f;
            float u1 = 0.25f;
            float u3 = 0.25f;
            float u4 = 0.5f;
            for (int j = 0; j < 2; ++j) {
                ps.m_252880_(0.0f, 0.0f, 0.46875f);
                AltimeterModel.addScaledQuad(builder, ps, shrink, false, 0.375f, 0.375f, 0.625f, 0.6875f, u0, invDepth / (float)textureH, u1, (invDepth + (float)h) / (float)textureH);
                AltimeterModel.addScaledQuad(builder, ps, shrink, true, 0.375f, 0.6875f, 0.625f, 0.75f, u3, (invDepth - 1.0f) / (float)textureH, u4, invDepth / (float)textureH);
                ps.m_85841_(-1.0f, 1.0f, -1.0f);
                ps.m_252880_(-1.0f, 0.0f, -0.53125f);
                u0 = 0.25f;
                u1 = 0.0f;
                u3 = 0.5f;
                u4 = 0.25f;
            }
            BakedModel copy = ClientHelper.getModel((ModelManager)Minecraft.m_91087_().m_91304_(), (ResourceLocation)ClientRegistry.ALTIMETER_TEMPLATE);
            this.quads.addAll(copy.m_213637_(null, null, RandomSource.m_216327_()));
            this.overrides = copy.m_7343_();
            this.transforms = copy.m_7442_();
        }

        public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction direction, RandomSource random) {
            return direction == null ? this.quads : List.of();
        }

        public boolean m_7541_() {
            return false;
        }

        public boolean m_7539_() {
            return false;
        }

        public boolean m_7547_() {
            return false;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return null;
        }

        public ItemTransforms m_7442_() {
            return this.transforms;
        }

        public ItemOverrides m_7343_() {
            return this.overrides;
        }

        private static void addScaledQuad(BakedQuadBuilder builder, PoseStack ps, float shrink, boolean top, float x0, float y0, float x1, float y1, float u0, float v0, float u1, float v1) {
            float ix0 = shrink * (x0 - 0.5f) * 2.0f;
            float ix1 = shrink * (x1 - 0.5f) * 2.0f;
            float iy0 = top ? 0.0f : shrink * (y0 - 0.5f) * 2.0f;
            float iy1 = !top ? 0.0f : shrink * (y1 - 0.5f) * 2.0f;
            VertexUtil.addQuad((VertexConsumer)builder, (PoseStack)ps, (float)(x0 + ix0), (float)(y0 + iy0), (float)(x1 + ix1), (float)(y1 + iy1), (float)u0, (float)v0, (float)u1, (float)v1, (int)255, (int)255, (int)255, (int)255, (int)0, (int)0);
        }
    }
}

