/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.util;

import com.buuz135.functionalstorage.block.config.FunctionalStorageConfig;
import com.buuz135.functionalstorage.block.tile.FluidDrawerTile;
import com.buuz135.functionalstorage.block.tile.ItemControllableDrawerTile;
import com.buuz135.functionalstorage.block.tile.StorageControllerExtensionTile;
import com.buuz135.functionalstorage.block.tile.StorageControllerTile;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class ConnectedDrawers
implements INBTSerializable<CompoundTag> {
    private StorageControllerTile controllerTile;
    private List<Long> connectedDrawers;
    private List<IItemHandler> itemHandlers;
    private List<IFluidHandler> fluidHandlers;
    private Level level;
    private int extensions;
    private VoxelShape cachedVoxelShape;

    public ConnectedDrawers(Level level, StorageControllerTile controllerTile) {
        this.controllerTile = controllerTile;
        this.connectedDrawers = new ArrayList<Long>();
        this.itemHandlers = new ArrayList<IItemHandler>();
        this.fluidHandlers = new ArrayList<IFluidHandler>();
        this.level = level;
        this.extensions = 0;
        this.cachedVoxelShape = null;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void rebuild() {
        this.itemHandlers = new ArrayList<IItemHandler>();
        this.fluidHandlers = new ArrayList<IFluidHandler>();
        this.extensions = 0;
        if (this.level != null && !this.level.m_5776_()) {
            int extraRange = this.controllerTile.getStorageMultiplier();
            if (extraRange == 1) {
                extraRange = 0;
            }
            AABB area = new AABB(this.controllerTile.m_58899_()).m_82400_((double)(FunctionalStorageConfig.DRAWER_CONTROLLER_LINKING_RANGE + extraRange));
            this.connectedDrawers.removeIf(aLong -> !area.m_82390_(Vec3.m_82512_((Vec3i)BlockPos.m_122022_((long)aLong))));
            this.connectedDrawers.sort(Comparator.comparingDouble(value -> BlockPos.m_122022_((long)value).m_123331_((Vec3i)this.controllerTile.m_58899_())));
            for (Long connectedDrawer : this.connectedDrawers) {
                BlockPos pos = BlockPos.m_122022_((long)connectedDrawer);
                BlockEntity entity = this.level.m_7702_(pos);
                if (entity instanceof StorageControllerTile) continue;
                if (entity instanceof StorageControllerExtensionTile) {
                    ++this.extensions;
                    continue;
                }
                if (entity instanceof ItemControllableDrawerTile) {
                    ItemControllableDrawerTile itemControllableDrawerTile = (ItemControllableDrawerTile)entity;
                    this.itemHandlers.add(itemControllableDrawerTile.getStorage());
                }
                if (!(entity instanceof FluidDrawerTile)) continue;
                FluidDrawerTile fluidDrawerTile = (FluidDrawerTile)entity;
                this.fluidHandlers.add(fluidDrawerTile.getFluidHandler());
            }
        }
        this.controllerTile.inventoryHandler.invalidateSlots();
        this.controllerTile.fluidHandler.invalidateSlots();
    }

    public void rebuildShapes() {
        ArrayList<VoxelShape> mergedShapes;
        this.cachedVoxelShape = Shapes.m_83064_((AABB)new AABB(this.controllerTile.m_58899_()));
        List<VoxelShape> currentShapes = this.connectedDrawers.stream().map(connectedDrawer -> Shapes.m_83064_((AABB)new AABB(BlockPos.m_122022_((long)connectedDrawer)))).toList();
        do {
            mergedShapes = new ArrayList<VoxelShape>();
            for (int i = 0; i < currentShapes.size(); i += 2) {
                VoxelShape shape1;
                VoxelShape mergedShape = shape1 = currentShapes.get(i);
                if (i + 1 < currentShapes.size()) {
                    VoxelShape shape2 = currentShapes.get(i + 1);
                    mergedShape = Shapes.m_83148_((VoxelShape)shape1, (VoxelShape)shape2, (BooleanOp)BooleanOp.f_82695_);
                }
                mergedShapes.add(mergedShape);
            }
        } while ((currentShapes = mergedShapes).size() > 1);
        if (currentShapes.size() == 1) {
            this.cachedVoxelShape = Shapes.m_83148_((VoxelShape)this.cachedVoxelShape, (VoxelShape)currentShapes.get(0), (BooleanOp)BooleanOp.f_82695_);
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        for (int i = 0; i < this.connectedDrawers.size(); ++i) {
            compoundTag.m_128356_("" + i, this.connectedDrawers.get(i).longValue());
        }
        return compoundTag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.connectedDrawers = new ArrayList<Long>();
        for (String allKey : nbt.m_128431_()) {
            this.connectedDrawers.add(nbt.m_128454_(allKey));
        }
        this.rebuild();
        if (this.controllerTile.m_58904_() != null && this.controllerTile.isClient()) {
            this.rebuildShapes();
        }
    }

    public List<Long> getConnectedDrawers() {
        return this.connectedDrawers;
    }

    public List<IItemHandler> getItemHandlers() {
        return this.itemHandlers;
    }

    public List<IFluidHandler> getFluidHandlers() {
        return this.fluidHandlers;
    }

    public int getExtensions() {
        return this.extensions;
    }

    public VoxelShape getCachedVoxelShape() {
        return this.cachedVoxelShape;
    }
}

