/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.world;

import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.blocks.CometSpawner;
import com.brandon3055.draconicevolution.blocks.DraconiumOre;
import com.brandon3055.draconicevolution.init.DEContent;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class EnderCometFeature
extends Feature<NoneFeatureConfiguration> {
    public EnderCometFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        if (!DEConfig.enderCometEnabled) {
            return false;
        }
        this.m_5974_((LevelWriter)context.m_159774_(), context.m_159777_(), ((CometSpawner)((Object)DEContent.COMET_SPAWNER.get())).m_49966_());
        return true;
    }

    public static void buildComet(Level level, BlockPos spawn, RandomSource rand) {
        double rotation = rand.m_188502_();
        double xmod = Math.sin(rotation);
        double zmod = Math.cos(rotation);
        int size = 4 + rand.m_188503_(6);
        int distMod = 200;
        BlockPos tail = spawn.m_7918_((int)(xmod * (double)distMod), 40 + rand.m_188503_(40), (int)(zmod * (double)distMod));
        EnderCometFeature.generateCore(level, rand, spawn, size);
        EnderCometFeature.generateTrail(level, rand, spawn, tail, size);
    }

    private static void generateCore(Level level, RandomSource rand, BlockPos spawn, int size) {
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)spawn.m_7918_(-size, -size, -size), (BlockPos)spawn.m_7918_(size, size, size))) {
            if (pos.m_123331_((Vec3i)spawn) > (double)(size * size)) continue;
            float genP = rand.m_188501_();
            if (0.1f > genP) {
                level.m_46597_(pos, ((DraconiumOre)((Object)DEContent.END_DRACONIUM_ORE.get())).m_49966_());
                continue;
            }
            if (0.4f > genP) {
                level.m_46597_(pos, Blocks.f_50080_.m_49966_());
                continue;
            }
            level.m_46597_(pos, Blocks.f_50080_.m_49966_());
        }
    }

    private static void generateTrail(Level level, RandomSource rand, BlockPos spawn, BlockPos tail, int size) {
        int xDiff = tail.m_123341_() - spawn.m_123341_();
        int yDiff = tail.m_123342_() - spawn.m_123342_();
        int zDiff = tail.m_123343_() - spawn.m_123343_();
        for (int p = 0; p < 100; p += 2) {
            int cX = spawn.m_123341_() + (int)((float)p / 100.0f * (float)xDiff);
            int cY = spawn.m_123342_() + (int)((float)p / 100.0f * (float)yDiff);
            int cZ = spawn.m_123343_() + (int)((float)p / 100.0f * (float)zDiff);
            float pc = (float)p / 100.0f;
            int density = 500 - (int)(pc * 550.0f);
            if (density < 20) {
                density = 20;
            }
            EnderCometFeature.generateTrailSphere(level, cX, cY, cZ, size + 3 - (int)(pc * (float)(size - 2)), density, rand);
            density = 1000 - (int)(pc * 10000.0f);
            EnderCometFeature.generateTrailSphere(level, cX, cY, cZ, size + 3 - (int)(pc * (float)(size - 2)), density, rand);
        }
    }

    public static void generateTrailSphere(Level level, int xi, int yi, int zi, int r, int density, RandomSource rand) {
        if (density <= 0) {
            return;
        }
        if (density > 10000) {
            density = 10000;
        }
        for (int x = xi - r; x <= xi + r; ++x) {
            for (int z = zi - r; z <= zi + r; ++z) {
                for (int y = yi - r; y <= yi + r; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (density < rand.m_188503_(10000) || !level.m_46859_(pos) || (int)EnderCometFeature.getDistance(x, y, z, xi, yi, zi) != r) continue;
                    if (0.9f >= rand.m_188501_()) {
                        level.m_46597_(pos, Blocks.f_50259_.m_49966_());
                        continue;
                    }
                    if (rand.m_188499_()) {
                        level.m_46597_(pos, Blocks.f_50080_.m_49966_());
                        continue;
                    }
                    level.m_46597_(pos, ((DraconiumOre)((Object)DEContent.END_DRACONIUM_ORE.get())).m_49966_());
                }
            }
        }
    }

    public static double getDistance(int x1, int y1, int z1, int x2, int y2, int z2) {
        int dx = x1 - x2;
        int dy = y1 - y2;
        int dz = z1 - z2;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }
}

