/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.api.IDraconicMelee;
import com.brandon3055.draconicevolution.api.IReaperItem;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.lib.ModularOPStorage;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostImpl;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.init.ModuleCfg;
import com.brandon3055.draconicevolution.init.TechProperties;
import com.brandon3055.draconicevolution.items.equipment.DETier;
import com.brandon3055.draconicevolution.items.equipment.IModularMiningTool;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModularAxe
extends AxeItem
implements IReaperItem,
IModularMiningTool,
IDraconicMelee {
    private final TechLevel techLevel;
    private final DETier itemTier;

    public ModularAxe(DETier tier, TechProperties props) {
        super((Tier)tier, 0.0f, 0.0f, (Item.Properties)props);
        this.techLevel = props.getTechLevel();
        this.itemTier = (DETier)this.m_43314_();
    }

    @Override
    public TechLevel getTechLevel() {
        return this.techLevel;
    }

    @Override
    public DETier getItemTier() {
        return this.itemTier;
    }

    @Override
    public double getSwingSpeedMultiplier() {
        return EquipCfg.axeSwingSpeedMultiplier;
    }

    @Override
    public double getDamageMultiplier() {
        return EquipCfg.axeDamageMultiplier;
    }

    @Override
    public ModuleHostImpl createHost(ItemStack stack) {
        ModuleHostImpl host = new ModuleHostImpl(this.techLevel, ModuleCfg.toolWidth(this.techLevel), ModuleCfg.toolHeight(this.techLevel), "axe", ModuleCfg.removeInvalidModules, new ModuleCategory[0]);
        host.addCategories(ModuleCategory.MELEE_WEAPON);
        host.addCategories(ModuleCategory.TOOL_AXE);
        return host;
    }

    @Override
    @Nullable
    public ModularOPStorage createOPStorage(ItemStack stack, ModuleHostImpl host) {
        return new ModularOPStorage(host, EquipCfg.getBaseToolEnergy(this.techLevel), EquipCfg.getBaseToolTransfer(this.techLevel));
    }

    @Override
    public float m_8102_(ItemStack stack, BlockState state) {
        return IModularMiningTool.super.m_8102_(stack, state);
    }

    @Override
    public float getBaseEfficiency() {
        return this.m_43314_().m_6624_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        this.addModularItemInformation(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public int getReaperLevel(ItemStack stack) {
        return this.techLevel.index;
    }

    public boolean m_142522_(ItemStack stack) {
        return this.damageBarVisible(stack);
    }

    public int m_142158_(ItemStack stack) {
        return this.damageBarWidth(stack);
    }

    public int m_142159_(ItemStack stack) {
        return this.damageBarColour(stack);
    }

    public boolean m_41386_(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268724_);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (entity.m_32059_() >= 0 && entity.f_31986_ != Short.MAX_VALUE) {
            entity.m_32064_();
        }
        return super.onEntityItemUpdate(stack, entity);
    }

    public boolean m_8120_(ItemStack p_41456_) {
        return true;
    }
}

