/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.datagen;

import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.init.DEModules;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ItemModelGenerator
extends ItemModelProvider {
    public ItemModelGenerator(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator.getPackOutput(), "draconicevolution", existingFileHelper);
    }

    protected void registerModels() {
        this.blockItem(DEContent.GENERATOR, this.modLoc("block/generator/generator"));
        this.blockItem(DEContent.GRINDER, this.modLoc("block/grinder/grinder"));
        this.blockItem(DEContent.ENERGY_PYLON, this.modLoc("block/energy_pylon_input"));
        this.blockItem(DEContent.CRAFTING_CORE, this.modLoc("block/crafting/fusion_crafting_core"));
        this.blockItem(DEContent.BASIC_CRAFTING_INJECTOR, this.modLoc("block/crafting/crafting_injector_draconium"));
        this.blockItem(DEContent.WYVERN_CRAFTING_INJECTOR, this.modLoc("block/crafting/crafting_injector_wyvern"));
        this.blockItem(DEContent.AWAKENED_CRAFTING_INJECTOR, this.modLoc("block/crafting/crafting_injector_draconic"));
        this.blockItem(DEContent.CHAOTIC_CRAFTING_INJECTOR, this.modLoc("block/crafting/crafting_injector_chaotic"));
        this.blockItem(DEContent.FLUID_GATE);
        this.blockItem(DEContent.FLUX_GATE);
        this.blockItem(DEContent.POTENTIOMETER);
        this.blockItem(DEContent.DISENCHANTER);
        this.blockItem(DEContent.ENERGY_TRANSFUSER, this.modLoc("block/energy_transfuser"));
        this.blockItem(DEContent.DISLOCATOR_PEDESTAL);
        this.blockItem(DEContent.DISLOCATOR_RECEPTACLE, this.modLoc("block/dislocator_receptacle_inactive"));
        this.blockItem(DEContent.CREATIVE_OP_CAPACITOR);
        this.blockItem(DEContent.ENTITY_DETECTOR);
        this.blockItem(DEContent.ENTITY_DETECTOR_ADVANCED);
        this.blockItem(DEContent.STABILIZED_SPAWNER);
        this.blockItem(DEContent.CELESTIAL_MANIPULATOR);
        this.blockItem(DEContent.DRACONIUM_CHEST);
        this.blockItem(DEContent.PARTICLE_GENERATOR);
        this.dummyBlock(DEContent.PLACED_ITEM);
        this.blockItem(DEContent.PORTAL);
        this.blockItem(DEContent.CHAOS_CRYSTAL);
        this.blockItem(DEContent.ENERGY_CORE);
        this.blockItem(DEContent.ENERGY_CORE_STABILIZER);
        this.blockItem(DEContent.STRUCTURE_BLOCK);
        this.blockItem(DEContent.REACTOR_CORE);
        this.blockItem(DEContent.REACTOR_STABILIZER);
        this.blockItem(DEContent.REACTOR_INJECTOR);
        this.blockItem(DEContent.RAIN_SENSOR);
        this.blockItem(DEContent.DISLOCATION_INHIBITOR);
        this.blockItem(DEContent.OVERWORLD_DRACONIUM_ORE);
        this.blockItem(DEContent.NETHER_DRACONIUM_ORE);
        this.blockItem(DEContent.END_DRACONIUM_ORE);
        this.blockItem(DEContent.DEEPSLATE_DRACONIUM_ORE);
        this.blockItem(DEContent.DRACONIUM_BLOCK);
        this.blockItem(DEContent.AWAKENED_DRACONIUM_BLOCK);
        this.blockItem(DEContent.INFUSED_OBSIDIAN);
        this.dummyBlock(DEContent.BASIC_IO_CRYSTAL);
        this.dummyBlock(DEContent.WYVERN_IO_CRYSTAL);
        this.dummyBlock(DEContent.DRACONIC_IO_CRYSTAL);
        this.dummyBlock(DEContent.BASIC_RELAY_CRYSTAL);
        this.dummyBlock(DEContent.WYVERN_RELAY_CRYSTAL);
        this.dummyBlock(DEContent.DRACONIC_RELAY_CRYSTAL);
        this.dummyBlock(DEContent.BASIC_WIRELESS_CRYSTAL);
        this.dummyBlock(DEContent.WYVERN_WIRELESS_CRYSTAL);
        this.dummyBlock(DEContent.DRACONIC_WIRELESS_CRYSTAL);
        this.simpleItem(DEContent.DUST_DRACONIUM, "item/components");
        this.simpleItem(DEContent.DUST_DRACONIUM_AWAKENED, "item/components");
        this.simpleItem(DEContent.INGOT_DRACONIUM, "item/components");
        this.simpleItem(DEContent.INGOT_DRACONIUM_AWAKENED, "item/components");
        this.simpleItem(DEContent.NUGGET_DRACONIUM, "item/components");
        this.simpleItem(DEContent.NUGGET_DRACONIUM_AWAKENED, "item/components");
        this.simpleItem(DEContent.CORE_DRACONIUM, "item/components");
        this.simpleItem(DEContent.CORE_WYVERN, "item/components");
        this.simpleItem(DEContent.CORE_AWAKENED, "item/components");
        this.simpleItem(DEContent.CORE_CHAOTIC, "item/components");
        this.simpleItem(DEContent.ENERGY_CORE_WYVERN, "item/components");
        this.simpleItem(DEContent.ENERGY_CORE_DRACONIC, "item/components");
        this.simpleItem(DEContent.ENERGY_CORE_CHAOTIC, "item/components");
        this.simpleItem(DEContent.DRAGON_HEART, "item/components");
        this.simpleItem(DEContent.MODULE_CORE, "item/components");
        this.dummyItem(DEContent.CHAOS_SHARD);
        this.dummyItem(DEContent.CHAOS_FRAG_SMALL);
        this.dummyItem(DEContent.CHAOS_FRAG_MEDIUM);
        this.dummyItem(DEContent.CHAOS_FRAG_LARGE);
        this.dummyItem(DEContent.REACTOR_PRT_STAB_FRAME);
        this.dummyItem(DEContent.REACTOR_PRT_IN_ROTOR);
        this.dummyItem(DEContent.REACTOR_PRT_OUT_ROTOR);
        this.dummyItem(DEContent.REACTOR_PRT_ROTOR_FULL);
        this.dummyItem(DEContent.REACTOR_PRT_FOCUS_RING);
        this.dummyBlock(DEContent.DRACONIUM_CHEST);
        this.dummyBlock(DEContent.REACTOR_CORE);
        this.dummyBlock(DEContent.REACTOR_STABILIZER);
        this.dummyBlock(DEContent.REACTOR_INJECTOR);
        this.dummyItem(DEContent.MOB_SOUL);
        this.simpleItem(DEContent.MAGNET);
        this.simpleItem(DEContent.MAGNET_ADVANCED);
        this.simpleItem(DEContent.DISLOCATOR);
        this.simpleItem(DEContent.DISLOCATOR_ADVANCED);
        this.simpleItem(DEContent.DISLOCATOR_P2P, this.modLoc("item/bound_dislocator"));
        this.simpleItem(DEContent.DISLOCATOR_P2P_UNBOUND, this.modLoc("item/un_bound_dislocator"));
        this.simpleItem(DEContent.DISLOCATOR_PLAYER, this.modLoc("item/bound_dislocator"));
        this.simpleItem(DEContent.DISLOCATOR_PLAYER_UNBOUND, this.modLoc("item/bound_dislocator"));
        this.simpleItem(DEContent.CRYSTAL_BINDER);
        this.simpleItem(DEContent.INFO_TABLET);
        DEModules.MODULES.getEntries().stream().filter(e -> e.getId().m_135827_().equals("draconicevolution")).forEach(module -> {
            String name = Objects.requireNonNull(module.getId()).m_135815_();
            ResourceLocation baseTexture = new ResourceLocation("draconicevolution", "item/module/" + ((Module)module.get()).getModuleTechLevel().name().toLowerCase(Locale.ENGLISH));
            ResourceLocation overlay = new ResourceLocation("draconicevolution", "module/" + name);
            this.multiLayerItem(((Module)module.get()).getItem(), baseTexture, overlay);
        });
        this.simpleItem(DEContent.CAPACITOR_WYVERN, "item/tools");
        this.simpleItem(DEContent.CAPACITOR_DRACONIC, "item/tools");
        this.simpleItem(DEContent.CAPACITOR_CHAOTIC, "item/tools");
        this.simpleItem(DEContent.CAPACITOR_CREATIVE, "item/tools");
        this.simpleItem(DEContent.SHOVEL_WYVERN, "item/tools");
        this.simpleItem(DEContent.SHOVEL_DRACONIC, "item/tools");
        this.simpleItem(DEContent.SHOVEL_CHAOTIC, "item/tools");
        this.simpleItem(DEContent.PICKAXE_WYVERN, "item/tools");
        this.simpleItem(DEContent.PICKAXE_DRACONIC, "item/tools");
        this.simpleItem(DEContent.PICKAXE_CHAOTIC, "item/tools");
        this.simpleItem(DEContent.HOE_WYVERN, "item/tools");
        this.simpleItem(DEContent.HOE_DRACONIC, "item/tools");
        this.simpleItem(DEContent.HOE_CHAOTIC, "item/tools");
        this.simpleItem(DEContent.AXE_WYVERN, "item/tools");
        this.simpleItem(DEContent.AXE_DRACONIC, "item/tools");
        this.simpleItem(DEContent.AXE_CHAOTIC, "item/tools");
        this.simpleItem(DEContent.BOW_WYVERN, "item/tools");
        this.simpleItem(DEContent.BOW_DRACONIC, "item/tools");
        this.simpleItem(DEContent.BOW_CHAOTIC, "item/tools");
        this.simpleItem(DEContent.SWORD_WYVERN, "item/tools");
        this.simpleItem(DEContent.SWORD_DRACONIC, "item/tools");
        this.simpleItem(DEContent.SWORD_CHAOTIC, "item/tools");
        this.simpleItem(DEContent.STAFF_DRACONIC, "item/tools");
        this.simpleItem(DEContent.STAFF_CHAOTIC, "item/tools");
        this.simpleItem(DEContent.CHESTPIECE_WYVERN, "item/tools");
        this.simpleItem(DEContent.CHESTPIECE_DRACONIC, "item/tools");
        this.simpleItem(DEContent.CHESTPIECE_CHAOTIC, "item/tools");
    }

    private void simpleItem(RegistryObject<? extends Item> item) {
        this.simpleItem(item, "item");
    }

    private void simpleItem(RegistryObject<? extends Item> item, String textureFolder) {
        ResourceLocation reg = item.getId();
        this.simpleItem(item, new ResourceLocation(reg.m_135827_(), textureFolder + "/" + reg.m_135815_()));
    }

    private void simpleItem(RegistryObject<? extends Item> item, ResourceLocation texture) {
        ResourceLocation reg = item.getId();
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(reg.m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", texture);
    }

    private void multiLayerItem(RegistryObject<? extends Item> item, ResourceLocation texture, ResourceLocation overlay) {
        ResourceLocation reg = item.getId();
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(reg.m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", texture)).texture("layer1", overlay);
    }

    private void multiLayerItem(Item item, ResourceLocation texture, ResourceLocation overlay) {
        ResourceLocation reg = ForgeRegistries.ITEMS.getKey((Object)item);
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(reg.m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", texture)).texture("layer1", overlay);
    }

    private void blockItem(RegistryObject<? extends Block> block) {
        if (block == null) {
            return;
        }
        ResourceLocation reg = block.getId();
        this.blockItem(block, new ResourceLocation(reg.m_135827_(), "block/" + reg.m_135815_()));
    }

    private void blockItem(RegistryObject<? extends Block> block, ResourceLocation blockModel) {
        if (block == null) {
            return;
        }
        ResourceLocation reg = block.getId();
        ((ItemModelBuilder)this.getBuilder(reg.m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(blockModel));
    }

    private void dummyBlock(RegistryObject<? extends Block> block) {
        ((ItemModelBuilder)this.getBuilder(block.getId().m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/generated"));
    }

    private void dummyItem(RegistryObject<? extends Item> item) {
        ((ItemModelBuilder)this.getBuilder(item.getId().m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/generated"));
    }

    public String m_6055_() {
        return "Draconic Evolution Item Models";
    }
}

