/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import codechicken.lib.render.buffer.TransformingVertexConsumer;
import codechicken.lib.vec.Quat;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.draconicevolution.blocks.tileentity.TileFusionCraftingCore;
import com.brandon3055.draconicevolution.client.AtlasTextureHelper;
import com.brandon3055.draconicevolution.client.render.EffectLib;
import com.brandon3055.draconicevolution.client.render.tile.fxhandlers.FusionTileFXHandler;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class RenderTileFusionCraftingCore
implements BlockEntityRenderer<TileFusionCraftingCore> {
    private static Random rand = new Random();
    private RenderType particleType = RenderType.m_173209_((String)"particle_type", (VertexFormat)DefaultVertexFormat.f_85820_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172835_)).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TextureAtlas.f_118260_, false, false)).m_110687_(RenderStateShard.f_110114_).m_110691_(false));

    public RenderTileFusionCraftingCore(BlockEntityRendererProvider.Context context) {
    }

    public void render(TileFusionCraftingCore te, float partialTicks, PoseStack mStack, MultiBufferSource getter, int packetLight, int packetOverlay) {
        this.renderContent(te, partialTicks, mStack, getter, packetLight, packetOverlay);
        FusionTileFXHandler handler = (FusionTileFXHandler)te.fxHandler;
        if (handler.renderActive()) {
            this.renderEffects(te, handler, partialTicks, mStack, getter, packetLight, packetOverlay);
        }
    }

    private void renderContent(TileFusionCraftingCore te, float partialTicks, PoseStack mStack, MultiBufferSource getter, int packetLight, int packetOverlay) {
        ItemStack stack = !te.getOutputStack().m_41619_() && !te.isCrafting() ? te.getOutputStack() : te.getCatalystStack();
        Minecraft mc = Minecraft.m_91087_();
        if (!stack.m_41619_()) {
            mStack.m_85836_();
            mStack.m_85837_(0.5, 0.5, 0.5);
            mStack.m_85841_(0.5f, 0.5f, 0.5f);
            mStack.m_252781_(Axis.f_252436_.m_252977_(((float)TimeKeeper.getClientTick() + partialTicks) * 0.8f));
            mc.m_91291_().m_269128_(stack, ItemDisplayContext.FIXED, packetLight, packetOverlay, mStack, getter, te.m_58904_(), te.posSeed());
            mStack.m_85849_();
        }
    }

    private void renderEffects(TileFusionCraftingCore core, FusionTileFXHandler handler, float partialTicks, PoseStack mStack, MultiBufferSource getter, int packetLight, int packetOverlay) {
        Minecraft mc = Minecraft.m_91087_();
        Camera renderInfo = mc.f_91063_.m_109153_();
        mStack.m_85837_(0.5, 0.5, 0.5);
        ParticleStatus pStatus = (ParticleStatus)mc.f_91066_.m_231929_().m_231551_();
        double particleSetting = pStatus == ParticleStatus.ALL ? 1.0 : (pStatus == ParticleStatus.DECREASED ? 0.6666666666666666 : 0.3333333333333333);
        int maxParticles = (int)(1000.0 * particleSetting);
        List<FusionTileFXHandler.IngredFX> ingredFXList = handler.getIngredients(partialTicks);
        int i = 0;
        for (FusionTileFXHandler.IngredFX ingred : ingredFXList) {
            this.renderIngredientEffect(renderInfo, mStack, getter, partialTicks, i++, ingred, maxParticles / ingredFXList.size());
            if (ingred.arcPos == null) continue;
            EffectLib.renderLightningP2PRotate(mStack, getter, ingred.pos, ingred.arcPos, 8, TimeKeeper.getClientTick() / 2, 0.06f, 0.04f, false, 0.0f, 6488253);
        }
        Rotation cameraRotation = new Rotation(new Quat(renderInfo.m_253121_()));
        TransformingVertexConsumer builder = new TransformingVertexConsumer(getter.m_6299_(this.particleType), mStack);
        if (handler.injectTime > 0.0f) {
            rand.setSeed(3055L);
            double anim = handler.getRotationAnim(partialTicks);
            int chargePCount = 64;
            float pScale = 0.0625f;
            for (i = 0; i < chargePCount; ++i) {
                anim += rand.nextGaussian();
                float scale = Mth.m_14036_((float)(handler.injectTime * (float)chargePCount - (float)i), (float)0.0f, (float)1.0f) * pScale * (0.7f + rand.nextFloat() * 0.3f);
                if (scale <= 0.0f) break;
                float rotX = (float)((double)rand.nextFloat() * Math.PI * 2.0 + anim / 10.0);
                float rotY = (float)((double)rand.nextFloat() * Math.PI * 2.0 + anim / 15.0);
                double radius = 0.35 * MathUtils.clampMap((double)core.craftAnimProgress.get(), (double)0.95f, (double)1.0, (double)1.0, (double)0.0);
                double x = radius * (double)Mth.m_14089_((float)rotX) * (double)Mth.m_14031_((float)rotY);
                double y = radius * (double)Mth.m_14031_((float)rotX) * (double)Mth.m_14031_((float)rotY);
                double z = radius * (double)Mth.m_14089_((float)rotY);
                EffectLib.drawParticle(cameraRotation, (VertexConsumer)builder, AtlasTextureHelper.MIXED_PARTICLE[(TimeKeeper.getClientTick() + rand.nextInt(6423)) % AtlasTextureHelper.MIXED_PARTICLE.length], 1.0f, 0.0f, 0.0f, x, y, z, scale, 240);
            }
        }
        if (handler.chargeState > 0.0f) {
            double y;
            for (i = 0; i < 4; ++i) {
                float loopOffset = (float)i / 4.0f * ((float)Math.PI * 2) + (float)TimeKeeper.getClientTick() / 100.0f;
                for (int j = 0; j < 8; ++j) {
                    float rot = (float)j / 64.0f * (float)Math.PI * 2.0f + (float)TimeKeeper.getClientTick() / 10.0f + loopOffset;
                    if ((float)j > handler.chargeState * 8.0f) continue;
                    double x = Mth.m_14031_((float)rot) * 2.0f;
                    double z = Mth.m_14089_((float)rot) * 2.0f;
                    y = Mth.m_14089_((float)(rot + loopOffset)) * 1.0f;
                    float scale = 0.1f * ((float)j / 8.0f);
                    EffectLib.drawParticle(cameraRotation, (VertexConsumer)builder, AtlasTextureHelper.ENERGY_PARTICLE[(TimeKeeper.getClientTick() + j) % AtlasTextureHelper.ENERGY_PARTICLE.length], 0.41568628f, 0.050980393f, 0.6784314f, x, y, z, scale, 240);
                }
            }
            if (handler.injectTime > 0.0f && TimeKeeper.getClientTick() % 5 == 0) {
                int pos = rand.nextInt(4);
                for (i = 0; i < 4; ++i) {
                    if (i != pos) continue;
                    float loopOffset = (float)i / 4.0f * ((float)Math.PI * 2) + (float)TimeKeeper.getClientTick() / 100.0f;
                    float rot = 0.68722343f + (float)TimeKeeper.getClientTick() / 10.0f + loopOffset;
                    double x = Mth.m_14031_((float)rot) * 2.0f;
                    double z = Mth.m_14089_((float)rot) * 2.0f;
                    y = Mth.m_14089_((float)(rot + loopOffset)) * 1.0f;
                    EffectLib.renderLightningP2PRotate(mStack, getter, new Vector3(x, y, z), Vector3.ZERO, 8, TimeKeeper.getClientTick() / 2, 0.06f, 0.04f, false, 0.0f, 6488253);
                }
            }
        }
    }

    private void renderIngredientEffect(Camera renderInfo, PoseStack mStack, MultiBufferSource getter, float partialTicks, long randSeed, FusionTileFXHandler.IngredFX ingred, int totalParticles) {
        Rotation cameraRotation = new Rotation(new Quat(renderInfo.m_253121_()));
        TransformingVertexConsumer builder = new TransformingVertexConsumer(getter.m_6299_(this.particleType), mStack);
        rand.setSeed(randSeed);
        double anim = ingred.getChargeAnim(partialTicks);
        int chargePCount = Math.min(64, totalParticles / 3);
        float pScale = 0.025f;
        for (int i = 0; i < chargePCount; ++i) {
            anim += rand.nextGaussian();
            float scale = Mth.m_14036_((float)(ingred.getCharge() * ingred.dieOut * (float)chargePCount - (float)i), (float)0.0f, (float)1.0f) * pScale * (0.7f + rand.nextFloat() * 0.3f);
            if (scale <= 0.0f) break;
            float rotX = (float)((double)rand.nextFloat() * Math.PI * 2.0 + anim / 10.0);
            float rotY = (float)((double)rand.nextFloat() * Math.PI * 2.0 + anim / 15.0);
            double radius = 0.25;
            double x = ingred.pos.x + radius * (double)Mth.m_14089_((float)rotX) * (double)Mth.m_14031_((float)rotY);
            double y = ingred.pos.y + radius * (double)Mth.m_14031_((float)rotX) * (double)Mth.m_14031_((float)rotY);
            double z = ingred.pos.z + radius * (double)Mth.m_14089_((float)rotY);
            EffectLib.drawParticle(cameraRotation, (VertexConsumer)builder, AtlasTextureHelper.ENERGY_PARTICLE[(TimeKeeper.getClientTick() + rand.nextInt(6423)) % AtlasTextureHelper.ENERGY_PARTICLE.length], 0.0f, 0.8f + rand.nextFloat() * 0.2f, 1.0f, x, y, z, scale, 240);
        }
        int itemPCount = Math.min(48, totalParticles / 3);
        rand.setSeed(randSeed);
        anim = ingred.getChargeAnim(partialTicks);
        pScale = 0.0125f;
        Vector3 pos = new Vector3();
        for (int i = 0; i < itemPCount; ++i) {
            int seed = (int)Math.floor((anim += rand.nextDouble() * 69420.0) / 20.0);
            MathUtils.setRandSeed((long)seed);
            float pulse = (float)anim / 20.0f % 1.0f;
            float scale = Mth.m_14036_((float)(ingred.coreAnim * ingred.dieOut * (float)itemPCount - (float)i), (float)0.0f, (float)1.0f);
            if (scale <= 0.0f) break;
            scale = (float)((double)scale * (1.0 - Math.sin((double)pulse * Math.PI * 2.0)));
            pos.set((double)MathUtils.nextFloat(), (double)MathUtils.nextFloat(), (double)MathUtils.nextFloat());
            pos.subtract(0.5);
            pos.normalize();
            pos.multiply((double)MathUtils.nextFloat() * 0.1875);
            pos.add(ingred.pos);
            EffectLib.drawParticle(cameraRotation, (VertexConsumer)builder, AtlasTextureHelper.SPELL_PARTICLE[(rand.nextInt(AtlasTextureHelper.SPELL_PARTICLE.length) + TimeKeeper.getClientTick()) % AtlasTextureHelper.SPELL_PARTICLE.length], 0.7f, 0.0f, 0.0f, pos.x, pos.y, pos.z, scale * pScale, 240);
        }
        double randOffset = 0.125;
        rand.setSeed(randSeed);
        anim = ingred.beamAnim;
        pScale = 0.025f;
        int beamPCount = Math.min(32, totalParticles / 3);
        if (ingred.beamAnim > 0.0f) {
            for (int i = 0; i < beamPCount; ++i) {
                anim += rand.nextDouble() * 64.0;
                float scale = Mth.m_14036_((float)(Math.min(1.0f, ingred.beamAnim / 60.0f) * ingred.dieOut * (float)beamPCount - (float)i), (float)0.0f, (float)1.0f) * pScale * (0.7f + rand.nextFloat() * 0.3f);
                if (scale <= 0.0f) break;
                Vector3 start = ingred.pos.copy().add((0.5 - rand.nextDouble()) * (randOffset * 2.0), (0.5 - rand.nextDouble()) * (randOffset * 2.0), (0.5 - rand.nextDouble()) * (randOffset * 2.0));
                Vector3 end = new Vector3((0.5 - rand.nextDouble()) * (randOffset * 2.0), (0.5 - rand.nextDouble()) * (randOffset * 2.0), (0.5 - rand.nextDouble()) * (randOffset * 2.0));
                pos = MathUtils.interpolateVec3((Vector3)start, (Vector3)end, (double)(anim / 10.0 % 1.0));
                EffectLib.drawParticle(cameraRotation, (VertexConsumer)builder, AtlasTextureHelper.SPARK_PARTICLE[(rand.nextInt(AtlasTextureHelper.SPARK_PARTICLE.length) + TimeKeeper.getClientTick()) % AtlasTextureHelper.SPARK_PARTICLE.length], 0.7f + (float)anim / 10.0f % 1.0f * 0.3f, 0.0f, 0.0f, pos.x, pos.y, pos.z, scale, 240);
            }
        }
    }
}

