/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.effect;

import codechicken.lib.math.MathHelper;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.BCProfiler;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.energy.ICrystalLink;
import com.brandon3055.draconicevolution.api.energy.IENetEffectTile;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXBase;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class CrystalFXBeam<T extends BlockEntity>
extends CrystalFXBase<T> {
    private final Vec3D linkTarget;
    private final boolean terminateSource;
    private final boolean terminateTarget;
    private long lSeed = 0L;
    private boolean bolt = false;
    private float powerLevel = 0.0f;
    private static final ParticleRenderType BASIC_HANDLER = new FXHandler(new ResourceLocation("draconicevolution", "textures/particle/energy_beam_basic.png"));
    private static final ParticleRenderType WYVERN_HANDLER = new FXHandler(new ResourceLocation("draconicevolution", "textures/particle/energy_beam_wyvern.png"));
    private static final ParticleRenderType DRACONIC_HANDLER = new FXHandler(new ResourceLocation("draconicevolution", "textures/particle/energy_beam_draconic.png"));

    public CrystalFXBeam(Level worldIn, T tile, ICrystalLink linkTarget) {
        super((ClientLevel)worldIn, tile);
        this.f_107224_ = worldIn.f_46441_.m_188503_(1024);
        this.setPosition(((ICrystalLink)tile).getBeamLinkPos(((BlockEntity)linkTarget).m_58899_()));
        this.terminateSource = ((ICrystalLink)tile).renderBeamTermination();
        this.linkTarget = linkTarget.getBeamLinkPos(tile.m_58899_());
        this.terminateTarget = linkTarget.renderBeamTermination();
        this.m_107259_(new AABB(this.f_107212_, this.f_107213_, this.f_107214_, this.linkTarget.x, this.linkTarget.y, this.linkTarget.z));
    }

    @Override
    public void m_5989_() {
        super.m_5989_();
        BCProfiler.TICK.start("crystal_beam_fx_update");
        if (this.ticksTillDeath-- <= 0) {
            this.m_107274_();
        }
        float[] r = new float[]{0.0f, 0.8f, 1.0f};
        float[] g = new float[]{0.8f, 0.1f, 0.7f};
        float[] b = new float[]{1.0f, 1.0f, 0.2f};
        this.f_107227_ = r[((IENetEffectTile)this.tile).getTier()];
        this.f_107228_ = g[((IENetEffectTile)this.tile).getTier()];
        this.f_107229_ = b[((IENetEffectTile)this.tile).getTier()];
        this.powerLevel = (float)MathHelper.approachExp((double)this.powerLevel, (double)this.fxState, (double)0.05);
        BCProfiler.TICK.stop();
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        Vector3f[] renderVector;
        float viewZ;
        float viewY;
        float viewX;
        float green;
        if (this.powerLevel <= 0.0f && !ClientEventHandler.playerHoldingWrench) {
            return;
        }
        BCProfiler.RENDER.start("crystal_beam_fx");
        float scale = 0.1f * this.powerLevel;
        if (ClientEventHandler.playerHoldingWrench) {
            scale = 0.1f;
        }
        Vec3 viewVec = renderInfo.m_90583_();
        Vector3 source = new Vector3(this.f_107212_ - viewVec.f_82479_, this.f_107213_ - viewVec.f_82480_, this.f_107214_ - viewVec.f_82481_);
        Vector3 target = this.linkTarget.toVector3().subtract(viewVec.f_82479_, viewVec.f_82480_, viewVec.f_82481_);
        Vector3 dirVec = source.copy().subtract(target).normalize();
        Vector3 planeA = dirVec.copy().perpendicular().normalize();
        Vector3 planeB = dirVec.copy().crossProduct(planeA);
        Vector3 planeC = planeB.copy().rotate(0.7853981633974351, dirVec).normalize();
        Vector3 planeD = planeB.copy().rotate(-0.7853981633974351, dirVec).normalize();
        planeA.multiply((double)scale);
        planeB.multiply((double)scale);
        planeC.multiply((double)scale);
        planeD.multiply((double)scale);
        float dist = 0.2f * (float)Utils.getDistance((Vec3D)new Vec3D(source), (Vec3D)new Vec3D(target));
        float anim = ((float)ClientEventHandler.elapsedTicks + partialTicks) / -15.0f;
        float red = 1.0f;
        float f = green = ((IENetEffectTile)this.tile).getTier() == 1 ? 0.3f : 1.0f;
        if (ClientEventHandler.playerHoldingWrench) {
            green = 0.0f;
            red = 0.0f;
        }
        Vector3 p1 = source.copy().add(planeA);
        Vector3 p2 = target.copy().add(planeA);
        Vector3 p3 = source.copy().subtract(planeA);
        Vector3 p4 = target.copy().subtract(planeA);
        this.bufferQuad(buffer, p1, p2, p3, p4, anim, dist, red, green);
        p1 = source.copy().add(planeB);
        p2 = target.copy().add(planeB);
        p3 = source.copy().subtract(planeB);
        p4 = target.copy().subtract(planeB);
        this.bufferQuad(buffer, p1, p2, p3, p4, anim, dist, red, green);
        p1 = source.copy().add(planeC);
        p2 = target.copy().add(planeC);
        p3 = source.copy().subtract(planeC);
        p4 = target.copy().subtract(planeC);
        this.bufferQuad(buffer, p1, p2, p3, p4, anim, dist, red, green);
        p1 = source.copy().add(planeD);
        p2 = target.copy().add(planeD);
        p3 = source.copy().subtract(planeD);
        p4 = target.copy().subtract(planeD);
        this.bufferQuad(buffer, p1, p2, p3, p4, anim, dist, red, green);
        scale *= 2.0f;
        float minU = 0.0f;
        float maxU = 0.53f;
        float minV = 0.0f;
        float maxV = 0.53f;
        if (this.terminateSource) {
            viewX = (float)(this.f_107212_ - viewVec.m_7096_());
            viewY = (float)(this.f_107213_ - viewVec.m_7098_());
            viewZ = (float)(this.f_107214_ - viewVec.m_7094_());
            renderVector = this.getRenderVectors(renderInfo, viewX, viewY, viewZ, scale);
            buffer.m_5483_((double)renderVector[0].x(), (double)renderVector[0].y(), (double)renderVector[0].z()).m_85950_(red, green, 1.0f, 1.0f).m_7421_(maxU, maxV).m_7120_(240, 240).m_5752_();
            buffer.m_5483_((double)renderVector[1].x(), (double)renderVector[1].y(), (double)renderVector[1].z()).m_85950_(red, green, 1.0f, 1.0f).m_7421_(maxU, minV).m_7120_(240, 240).m_5752_();
            buffer.m_5483_((double)renderVector[2].x(), (double)renderVector[2].y(), (double)renderVector[2].z()).m_85950_(red, green, 1.0f, 1.0f).m_7421_(minU, minV).m_7120_(240, 240).m_5752_();
            buffer.m_5483_((double)renderVector[3].x(), (double)renderVector[3].y(), (double)renderVector[3].z()).m_85950_(red, green, 1.0f, 1.0f).m_7421_(minU, maxV).m_7120_(240, 240).m_5752_();
        }
        if (this.terminateTarget) {
            viewX = (float)(this.linkTarget.x - viewVec.m_7096_());
            viewY = (float)(this.linkTarget.y - viewVec.m_7098_());
            viewZ = (float)(this.linkTarget.z - viewVec.m_7094_());
            renderVector = this.getRenderVectors(renderInfo, viewX, viewY, viewZ, scale);
            buffer.m_5483_((double)renderVector[0].x(), (double)renderVector[0].y(), (double)renderVector[0].z()).m_85950_(red, green, 1.0f, 1.0f).m_7421_(maxU, maxV).m_7120_(240, 240).m_5752_();
            buffer.m_5483_((double)renderVector[1].x(), (double)renderVector[1].y(), (double)renderVector[1].z()).m_85950_(red, green, 1.0f, 1.0f).m_7421_(maxU, minV).m_7120_(240, 240).m_5752_();
            buffer.m_5483_((double)renderVector[2].x(), (double)renderVector[2].y(), (double)renderVector[2].z()).m_85950_(red, green, 1.0f, 1.0f).m_7421_(minU, minV).m_7120_(240, 240).m_5752_();
            buffer.m_5483_((double)renderVector[3].x(), (double)renderVector[3].y(), (double)renderVector[3].z()).m_85950_(red, green, 1.0f, 1.0f).m_7421_(minU, maxV).m_7120_(240, 240).m_5752_();
        }
        BCProfiler.RENDER.stop();
    }

    private void bufferQuad(VertexConsumer buffer, Vector3 p1, Vector3 p2, Vector3 p3, Vector3 p4, float anim, float dist, float red, float green) {
        BCProfiler.RENDER.start("buffer_quad");
        buffer.m_5483_(p1.x, p1.y, p1.z).m_85950_(red, green, 1.0f, 1.0f).m_7421_(0.5f, anim).m_7120_(240, 240).m_5752_();
        buffer.m_5483_(p2.x, p2.y, p2.z).m_85950_(red, green, 1.0f, 1.0f).m_7421_(0.5f, dist + anim).m_7120_(240, 240).m_5752_();
        buffer.m_5483_(p4.x, p4.y, p4.z).m_85950_(red, green, 1.0f, 1.0f).m_7421_(1.0f, dist + anim).m_7120_(240, 240).m_5752_();
        buffer.m_5483_(p3.x, p3.y, p3.z).m_85950_(red, green, 1.0f, 1.0f).m_7421_(1.0f, anim).m_7120_(240, 240).m_5752_();
        BCProfiler.RENDER.stop();
    }

    public ParticleRenderType m_7556_() {
        return ((IENetEffectTile)this.tile).getTier() == 0 ? BASIC_HANDLER : (((IENetEffectTile)this.tile).getTier() == 1 ? WYVERN_HANDLER : DRACONIC_HANDLER);
    }

    public static class FXHandler
    implements ParticleRenderType {
        private static final ResourceLocation highlightTexture = new ResourceLocation("draconicevolution", "textures/particle/energy_beam_highlight.png");
        private ResourceLocation texture;
        private float green;

        public FXHandler(ResourceLocation texture) {
            this.texture = texture;
            this.green = texture.m_135815_().contains("energy_beam_wyvern") ? 0.3f : 1.0f;
        }

        public void m_6505_(BufferBuilder builder, TextureManager textureManager) {
            RenderSystem.setShader(GameRenderer::m_172835_);
            RenderSystem.disableCull();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            if (ClientEventHandler.playerHoldingWrench) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)highlightTexture);
            } else {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
            }
            builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85820_);
        }

        public void m_6294_(Tesselator tessellator) {
            tessellator.m_85914_();
        }
    }
}

