/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui;

import codechicken.lib.gui.modular.ModularGui;
import codechicken.lib.gui.modular.ModularGuiContainer;
import codechicken.lib.gui.modular.elements.GuiButton;
import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.elements.GuiManipulable;
import codechicken.lib.gui.modular.elements.GuiRectangle;
import codechicken.lib.gui.modular.elements.GuiSlider;
import codechicken.lib.gui.modular.elements.GuiSlots;
import codechicken.lib.gui.modular.elements.GuiText;
import codechicken.lib.gui.modular.elements.GuiTexture;
import codechicken.lib.gui.modular.lib.Constraints;
import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.gui.modular.lib.SliderState;
import codechicken.lib.gui.modular.lib.container.ContainerGuiProvider;
import codechicken.lib.gui.modular.lib.container.ContainerScreenAccess;
import codechicken.lib.gui.modular.lib.container.SlotGroup;
import codechicken.lib.gui.modular.lib.geometry.Align;
import codechicken.lib.gui.modular.lib.geometry.Axis;
import codechicken.lib.gui.modular.lib.geometry.ConstrainedGeometry;
import codechicken.lib.gui.modular.lib.geometry.Constraint;
import codechicken.lib.gui.modular.lib.geometry.Direction;
import codechicken.lib.gui.modular.lib.geometry.GeoParam;
import codechicken.lib.gui.modular.lib.geometry.GeoRef;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.brandonscore.client.BCGuiTextures;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.gui.modulargui.templates.ButtonRow;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorComponent;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import com.brandon3055.draconicevolution.client.DEGuiTextures;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileReactorCore;
import com.brandon3055.draconicevolution.inventory.ReactorMenu;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class ReactorGui
extends ContainerGuiProvider<ReactorMenu> {
    private static final GuiToolkit TOOLKIT = new GuiToolkit("gui.draconicevolution.reactor");
    public static final int GUI_WIDTH = 248;
    public static final int GUI_HEIGHT = 222;
    public TileReactorComponent component = null;
    private static boolean compPanelExtended = false;

    public GuiElement<?> createRootElement(ModularGui gui) {
        GuiManipulable root = new GuiManipulable((GuiParent)gui).addMoveHandle(3).enableCursors(true);
        GuiTexture bg = new GuiTexture((GuiParent)root.getContentElement(), DEGuiTextures.themedGetter("reactor"));
        Constraints.bind((ConstrainedGeometry)bg, (ConstrainedGeometry)root.getContentElement());
        return root;
    }

    public void buildGui(ModularGui gui, ContainerScreenAccess<ReactorMenu> screenAccess) {
        gui.initStandardGui(248, 222);
        ReactorMenu menu = (ReactorMenu)screenAccess.m_6262_();
        final TileReactorCore tile = (TileReactorCore)menu.tile;
        GuiElement root = gui.getRoot();
        TOOLKIT.createHeading((GuiParent)root, gui.getGuiTitle(), true);
        GuiSlots.Player playInv = GuiSlots.player((GuiParent)root, screenAccess, (SlotGroup)menu.main, (SlotGroup)menu.hotBar);
        playInv.stream().forEach(e -> e.setSlotTexture(slot -> BCGuiTextures.getThemed((String)"slot")));
        playInv.container().setEnabled(() -> tile.reactorState.get() == TileReactorCore.ReactorState.COLD);
        Constraints.placeInside((ConstrainedGeometry)playInv.container(), (ConstrainedGeometry)root, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_LEFT, (double)12.0, (double)-8.0);
        ButtonRow buttonRow = new ButtonRow((GuiParent)root, Direction.LEFT);
        buttonRow.addButton(arg_0 -> ((GuiToolkit)TOOLKIT).createThemeButton(arg_0));
        Constraints.placeInside((ConstrainedGeometry)buttonRow, (ConstrainedGeometry)playInv.container(), (Constraints.LayoutPos)Constraints.LayoutPos.TOP_RIGHT, (double)2.0, (double)-12.0);
        GuiSlots input = (GuiSlots)((GuiSlots)((GuiSlots)new GuiSlots((GuiParent)root, screenAccess, menu.input, 3).setEnabled(() -> tile.reactorState.get() == TileReactorCore.ReactorState.COLD)).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)playInv.container().get(GeoParam.TOP), (double)9.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.midPoint((GeoRef)playInv.container().get(GeoParam.RIGHT), (GeoRef)root.get(GeoParam.RIGHT), (double)-29.0));
        Constraints.placeOutside((ConstrainedGeometry)((GuiText)TOOLKIT.createHeading((GuiParent)input, (Component)TOOLKIT.translate("fuel_in", new Object[0])).setSize(32.0, 8.0)).setScroll(false), (ConstrainedGeometry)input, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_CENTER, (double)0.0, (double)-1.0);
        GuiSlots output = (GuiSlots)new GuiSlots((GuiParent)root, screenAccess, menu.output, 3).setEnabled(() -> tile.reactorState.get() == TileReactorCore.ReactorState.COLD);
        Constraints.placeOutside((ConstrainedGeometry)output, (ConstrainedGeometry)input, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)13.0);
        Constraints.placeOutside((ConstrainedGeometry)((GuiText)TOOLKIT.createHeading((GuiParent)output, (Component)TOOLKIT.translate("chaos_out", new Object[0])).setSize(32.0, 8.0)).setScroll(false), (ConstrainedGeometry)output, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_CENTER, (double)0.0, (double)-1.0);
        GuiButton chargeButton = ((GuiButton)TOOLKIT.createFlat3DButton((GuiParent)root, () -> TOOLKIT.translate("charge", new Object[0])).setEnabled(tile::canCharge)).onPress(tile::chargeReactor);
        Constraints.size((ConstrainedGeometry)chargeButton, (double)64.0, (double)14.0);
        Constraints.placeOutside((ConstrainedGeometry)chargeButton, (ConstrainedGeometry)playInv.container(), (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_RIGHT, (double)3.0, (double)-14.0);
        GuiButton activateButton = ((GuiButton)TOOLKIT.createFlat3DButton((GuiParent)root, () -> TOOLKIT.translate("activate", new Object[0])).setEnabled(tile::canActivate)).onPress(tile::activateReactor);
        Constraints.size((ConstrainedGeometry)activateButton, (double)64.0, (double)14.0);
        Constraints.placeOutside((ConstrainedGeometry)activateButton, (ConstrainedGeometry)chargeButton, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_CENTER, (double)0.0, (double)-3.0);
        GuiButton shutdownButton = ((GuiButton)TOOLKIT.createFlat3DButton((GuiParent)root, () -> TOOLKIT.translate("shutdown", new Object[0])).setEnabled(tile::canStop)).onPress(tile::shutdownReactor);
        Constraints.bind((ConstrainedGeometry)shutdownButton, (ConstrainedGeometry)chargeButton);
        GuiButton sasButton = (GuiButton)((GuiButton)TOOLKIT.createFlat3DButton((GuiParent)root, () -> TOOLKIT.translate("sas", new Object[0])).setEnabled(() -> tile.reactorState.get() != TileReactorCore.ReactorState.COLD && tile.reactorState.get() != TileReactorCore.ReactorState.BEYOND_HOPE)).onPress(tile::toggleFailSafe).setToggleMode(() -> ((ManagedBool)tile.failSafeMode).get()).setTooltip(new Component[]{TOOLKIT.translate("sas.info", new Object[0])});
        Constraints.size((ConstrainedGeometry)sasButton, (double)64.0, (double)14.0);
        Constraints.placeOutside((ConstrainedGeometry)sasButton, (ConstrainedGeometry)activateButton, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_CENTER, (double)0.0, (double)-3.0);
        GuiButton rsButton = (GuiButton)((GuiButton)((GuiButton)((GuiButton)TOOLKIT.createFlat3DButton((GuiParent)root, () -> TOOLKIT.translate("rs_mode", new Object[0])).setEnabled(() -> tile.reactorState.get() != TileReactorCore.ReactorState.COLD && this.component != null && tile.reactorState.get() != TileReactorCore.ReactorState.BEYOND_HOPE)).onPress(() -> {
            compPanelExtended = !compPanelExtended;
        }).setToggleMode(() -> compPanelExtended).setTooltip(new Component[]{TOOLKIT.translate("rs_mode.info", new Object[0])})).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)playInv.container().get(GeoParam.TOP)))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)chargeButton.get(GeoParam.LEFT)));
        rsButton.getLabel().setWrap(true);
        Constraints.size((ConstrainedGeometry)rsButton, (double)64.0, (double)24.0);
        GuiRectangle statusPanel = ((GuiRectangle)new GuiRectangle((GuiParent)root).setEnabled(() -> tile.reactorState.get() != TileReactorCore.ReactorState.COLD)).fill(-16777216).border(GuiToolkit.Palette.BG::border).border(-1);
        Constraints.bind((ConstrainedGeometry)statusPanel, (ConstrainedGeometry)playInv.container());
        GuiText last = (GuiText)((GuiText)((GuiText)new GuiText((GuiParent)statusPanel, (Component)TOOLKIT.translate("core_volume", new Object[0])).setEnabled(() -> tile.reactorState.get() != TileReactorCore.ReactorState.COLD && tile.reactorState.get() != TileReactorCore.ReactorState.BEYOND_HOPE)).setAlignment(Align.LEFT).setShadow(false).setTextColour(49407).setTooltip(new Component[]{TOOLKIT.translate("core_volume.info", new Object[0])})).setTooltipDelay(2);
        Constraints.size((ConstrainedGeometry)last, (double)160.0, (double)9.0);
        Constraints.placeInside((ConstrainedGeometry)last, (ConstrainedGeometry)statusPanel, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_LEFT, (double)3.0, (double)1.0);
        last = (GuiText)((GuiText)((GuiText)new GuiText((GuiParent)statusPanel).setEnabled(() -> tile.reactorState.get() != TileReactorCore.ReactorState.COLD && tile.reactorState.get() != TileReactorCore.ReactorState.BEYOND_HOPE)).setTextSupplier(() -> Component.m_237113_((String)(MathUtils.round((double)((tile.reactableFuel.get() + tile.convertedFuel.get()) / 1296.0), (double)100.0) + " m^3"))).setAlignment(Align.LEFT).setShadow(false).setTextColour(0xB0B0B0).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)last.get(GeoParam.BOTTOM), (double)0.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)statusPanel.get(GeoParam.LEFT), (double)6.0));
        Constraints.size((ConstrainedGeometry)last, (double)160.0, (double)9.0);
        last = (GuiText)((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)statusPanel, (Component)TOOLKIT.translate("gen_rate", new Object[0])).setEnabled(() -> tile.reactorState.get() != TileReactorCore.ReactorState.COLD && tile.reactorState.get() != TileReactorCore.ReactorState.BEYOND_HOPE)).setAlignment(Align.LEFT).setShadow(false).setTextColour(49407).setTooltip(new Component[]{TOOLKIT.translate("gen_rate.info", new Object[0])})).setTooltipDelay(2)).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)last.get(GeoParam.BOTTOM), (double)0.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)statusPanel.get(GeoParam.LEFT), (double)3.0));
        Constraints.size((ConstrainedGeometry)last, (double)160.0, (double)9.0);
        last = (GuiText)((GuiText)((GuiText)new GuiText((GuiParent)statusPanel).setEnabled(() -> tile.reactorState.get() != TileReactorCore.ReactorState.COLD && tile.reactorState.get() != TileReactorCore.ReactorState.BEYOND_HOPE)).setTextSupplier(() -> Component.m_237113_((String)(Utils.addCommas((int)((int)tile.generationRate.get())) + " OP/t"))).setAlignment(Align.LEFT).setShadow(false).setTextColour(0xB0B0B0).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)last.get(GeoParam.BOTTOM), (double)0.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)statusPanel.get(GeoParam.LEFT), (double)6.0));
        Constraints.size((ConstrainedGeometry)last, (double)160.0, (double)9.0);
        last = (GuiText)((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)statusPanel, (Component)TOOLKIT.translate("field_rate", new Object[0])).setEnabled(() -> tile.reactorState.get() != TileReactorCore.ReactorState.COLD && tile.reactorState.get() != TileReactorCore.ReactorState.BEYOND_HOPE)).setAlignment(Align.LEFT).setShadow(false).setTextColour(49407).setTooltip(new Component[]{TOOLKIT.translate("field_rate.info", new Object[0])})).setTooltipDelay(2)).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)last.get(GeoParam.BOTTOM), (double)0.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)statusPanel.get(GeoParam.LEFT), (double)3.0));
        Constraints.size((ConstrainedGeometry)last, (double)160.0, (double)9.0);
        last = (GuiText)((GuiText)((GuiText)new GuiText((GuiParent)statusPanel).setEnabled(() -> tile.reactorState.get() != TileReactorCore.ReactorState.COLD && tile.reactorState.get() != TileReactorCore.ReactorState.BEYOND_HOPE)).setTextSupplier(() -> {
            double inputRate = (double)tile.fieldDrain.get() / (1.0 - tile.shieldCharge.get() / tile.maxShieldCharge.get());
            return Component.m_237113_((String)(Utils.addCommas((int)((int)Math.min(inputRate, 2.147483647E9))) + " OP/t"));
        }).setAlignment(Align.LEFT).setShadow(false).setTextColour(0xB0B0B0).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)last.get(GeoParam.BOTTOM), (double)0.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)statusPanel.get(GeoParam.LEFT), (double)6.0));
        Constraints.size((ConstrainedGeometry)last, (double)160.0, (double)9.0);
        last = (GuiText)((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)statusPanel, (Component)TOOLKIT.translate("convert_rate", new Object[0])).setEnabled(() -> tile.reactorState.get() != TileReactorCore.ReactorState.COLD && tile.reactorState.get() != TileReactorCore.ReactorState.BEYOND_HOPE)).setAlignment(Align.LEFT).setShadow(false).setTextColour(49407).setTooltip(new Component[]{TOOLKIT.translate("convert_rate.info", new Object[0])})).setTooltipDelay(2)).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)last.get(GeoParam.BOTTOM), (double)0.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)statusPanel.get(GeoParam.LEFT), (double)3.0));
        Constraints.size((ConstrainedGeometry)last, (double)160.0, (double)9.0);
        last = (GuiText)((GuiText)((GuiText)new GuiText((GuiParent)statusPanel).setEnabled(() -> tile.reactorState.get() != TileReactorCore.ReactorState.COLD && tile.reactorState.get() != TileReactorCore.ReactorState.BEYOND_HOPE)).setTextSupplier(() -> Component.m_237113_((String)(Utils.addCommas((int)((int)Math.round(tile.fuelUseRate.get() * 1000000.0))) + " nb/t"))).setAlignment(Align.LEFT).setShadow(false).setTextColour(0xB0B0B0).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)last.get(GeoParam.BOTTOM), (double)0.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)statusPanel.get(GeoParam.LEFT), (double)6.0));
        Constraints.size((ConstrainedGeometry)last, (double)160.0, (double)9.0);
        GuiText goBoom = ((GuiText)new GuiText((GuiParent)statusPanel, (Component)TOOLKIT.translate("go_boom_now", new Object[0])).setEnabled(() -> tile.reactorState.get() == TileReactorCore.ReactorState.BEYOND_HOPE)).setAlignment(Align.LEFT).setWrap(true).setShadow(false).setTextColour(0xB0B0B0);
        Constraints.size((ConstrainedGeometry)goBoom, (double)155.0, (double)77.0);
        Constraints.center((ConstrainedGeometry)goBoom, (ConstrainedGeometry)statusPanel);
        GuiText eta = ((GuiText)new GuiText((GuiParent)statusPanel, (Component)Component.m_237113_((String)"ETA")).setEnabled(() -> tile.reactorState.get() == TileReactorCore.ReactorState.BEYOND_HOPE)).setTextSupplier(() -> Component.m_237113_((String)("Estimated Time Until Detonation\n\n" + String.valueOf(ChatFormatting.UNDERLINE) + (String)(tile.explosionCountdown.get() >= 0 ? tile.explosionCountdown.get() / 20 + "s" : "Calculating..")))).setAlignment(Align.LEFT).setWrap(true).setShadow(false).setTextColour(0xFF0000);
        Constraints.size((ConstrainedGeometry)eta, (double)68.0, (double)80.0);
        Constraints.placeOutside((ConstrainedGeometry)eta, (ConstrainedGeometry)statusPanel, (Constraints.LayoutPos)Constraints.LayoutPos.MIDDLE_RIGHT, (double)5.0, (double)0.0);
        GuiTexture tempBg = (GuiTexture)((GuiTexture)new GuiTexture((GuiParent)root, DEGuiTextures.get("reactor/temp_gauge")).setTooltipDelay(5)).setTooltip(() -> this.getTempStats(tile));
        Constraints.size((ConstrainedGeometry)tempBg, (double)18.0, (double)114.0);
        Constraints.placeInside((ConstrainedGeometry)tempBg, (ConstrainedGeometry)root, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_LEFT, (double)8.0, (double)6.0);
        GuiSlider tempIndicator = new GuiSlider((GuiParent)root, Axis.Y).setSliderState((SliderState)new IndicatorState(() -> tile.temperature.get() / 10000.0));
        Constraints.bind((ConstrainedGeometry)tempIndicator, (ConstrainedGeometry)tempBg, (double)1.0, (double)1.0, (double)-1.0, (double)1.0);
        Constraints.bind((ConstrainedGeometry)new GuiTexture((GuiParent)tempIndicator.getSlider(), DEGuiTextures.get("reactor/pointer")), (ConstrainedGeometry)tempIndicator.getSlider());
        GuiTexture shieldBg = (GuiTexture)((GuiTexture)new GuiTexture((GuiParent)root, DEGuiTextures.get("reactor/shield_gauge")).setTooltipDelay(5)).setTooltip(() -> this.getShieldStats(tile));
        Constraints.size((ConstrainedGeometry)shieldBg, (double)18.0, (double)114.0);
        Constraints.placeOutside((ConstrainedGeometry)shieldBg, (ConstrainedGeometry)tempBg, (Constraints.LayoutPos)Constraints.LayoutPos.MIDDLE_RIGHT, (double)6.0, (double)0.0);
        GuiSlider shieldIndicator = new GuiSlider((GuiParent)root, Axis.Y).setSliderState((SliderState)new IndicatorState(() -> tile.shieldCharge.get() / Math.max(tile.maxShieldCharge.get(), 1.0)));
        Constraints.bind((ConstrainedGeometry)shieldIndicator, (ConstrainedGeometry)shieldBg, (double)1.0, (double)1.0, (double)-1.0, (double)1.0);
        Constraints.bind((ConstrainedGeometry)new GuiTexture((GuiParent)shieldIndicator.getSlider(), DEGuiTextures.get("reactor/pointer")), (ConstrainedGeometry)shieldIndicator.getSlider());
        GuiTexture fuelBg = (GuiTexture)((GuiTexture)new GuiTexture((GuiParent)root, DEGuiTextures.get("reactor/fuel_gauge")).setTooltipDelay(5)).setTooltip(() -> this.getFuelStats(tile));
        Constraints.size((ConstrainedGeometry)fuelBg, (double)18.0, (double)114.0);
        Constraints.placeInside((ConstrainedGeometry)fuelBg, (ConstrainedGeometry)root, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_RIGHT, (double)-8.0, (double)6.0);
        GuiSlider fuelIndicator = new GuiSlider((GuiParent)root, Axis.Y).setSliderState((SliderState)new IndicatorState(() -> tile.convertedFuel.get() / Math.max(tile.reactableFuel.get() + tile.convertedFuel.get(), 1.0)));
        Constraints.bind((ConstrainedGeometry)fuelIndicator, (ConstrainedGeometry)fuelBg, (double)1.0, (double)1.0, (double)-1.0, (double)1.0);
        Constraints.bind((ConstrainedGeometry)new GuiTexture((GuiParent)fuelIndicator.getSlider(), DEGuiTextures.get("reactor/pointer")), (ConstrainedGeometry)fuelIndicator.getSlider());
        GuiTexture satBg = (GuiTexture)((GuiTexture)new GuiTexture((GuiParent)root, DEGuiTextures.get("reactor/sat_gauge")).setTooltipDelay(5)).setTooltip(() -> this.getSaturationStats(tile));
        Constraints.size((ConstrainedGeometry)satBg, (double)18.0, (double)114.0);
        Constraints.placeOutside((ConstrainedGeometry)satBg, (ConstrainedGeometry)fuelBg, (Constraints.LayoutPos)Constraints.LayoutPos.MIDDLE_LEFT, (double)-6.0, (double)0.0);
        GuiSlider satIndicator = new GuiSlider((GuiParent)root, Axis.Y).setSliderState((SliderState)new IndicatorState(() -> (double)tile.saturation.get() / (double)Math.max(tile.maxSaturation.get(), 1L)));
        Constraints.bind((ConstrainedGeometry)satIndicator, (ConstrainedGeometry)satBg, (double)1.0, (double)1.0, (double)-1.0, (double)1.0);
        Constraints.bind((ConstrainedGeometry)new GuiTexture((GuiParent)satIndicator.getSlider(), DEGuiTextures.get("reactor/pointer")), (ConstrainedGeometry)satIndicator.getSlider());
        GuiTexture coreBg = new GuiTexture((GuiParent)root, DEGuiTextures.get("reactor/core")){

            public double getBackgroundDepth() {
                return 100.0;
            }

            public void renderBackground(GuiRender render, double mouseX, double mouseY, float partialTicks) {
                super.renderBackground(render, mouseX, mouseY, partialTicks);
                render.pose().m_85836_();
                render.pose().m_85837_(this.xCenter(), this.yCenter(), 100.0);
                RenderTileReactorCore.renderGUI(render, tile);
                render.pose().m_85849_();
            }
        };
        Constraints.size((ConstrainedGeometry)coreBg, (double)128.0, (double)128.0);
        Constraints.placeInside((ConstrainedGeometry)coreBg, (ConstrainedGeometry)root, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_CENTER, (double)0.0, (double)10.0);
        GuiText statusText = new GuiText((GuiParent)root).setShadow(() -> tile.reactorState.get() != TileReactorCore.ReactorState.BEYOND_HOPE).setTextSupplier(() -> {
            Object s = ((TileReactorCore.ReactorState)tile.reactorState.get()).localize();
            if (tile.reactorState.get() == TileReactorCore.ReactorState.BEYOND_HOPE && TimeKeeper.getClientTick() % 10 > 5) {
                s = String.valueOf(ChatFormatting.DARK_RED) + "**" + (String)s + "**";
            } else if (tile.reactorState.get() == TileReactorCore.ReactorState.BEYOND_HOPE) {
                s = String.valueOf(ChatFormatting.DARK_RED) + "--" + (String)s + "--";
            }
            return TOOLKIT.translate("status", new Object[0]).m_130940_(ChatFormatting.GOLD).m_130946_(": " + (String)s);
        }).setAlignment(Align.LEFT);
        Constraints.size((ConstrainedGeometry)statusText, (double)160.0, (double)12.0);
        Constraints.placeInside((ConstrainedGeometry)statusText, (ConstrainedGeometry)statusPanel, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_LEFT, (double)-5.0, (double)-12.0);
        GuiRectangle rsPanel = ((GuiRectangle)((GuiRectangle)new GuiRectangle((GuiParent)root).setEnabled(() -> compPanelExtended)).jeiExclude()).fill(-8355712).border(-16777216);
        Constraints.size((ConstrainedGeometry)rsPanel, (double)80.0, (double)(TileReactorComponent.RSMode.values().length * 13 + 3));
        Constraints.placeInside((ConstrainedGeometry)rsPanel, (ConstrainedGeometry)root, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_RIGHT, (double)80.0, (double)-3.0);
        double y = 1.0;
        for (TileReactorComponent.RSMode mode : TileReactorComponent.RSMode.values()) {
            GuiButton btn = (GuiButton)TOOLKIT.createFlat3DButton((GuiParent)rsPanel, () -> TOOLKIT.translate("rs_mode_" + mode.name().toLowerCase(Locale.ENGLISH), new Object[0])).onPress(() -> {
                if (this.component != null) {
                    this.component.setRSMode(menu.player, mode);
                }
            }).setToggleMode(() -> this.component != null && this.component.rsMode.get() == mode).setTooltip(new Component[]{TOOLKIT.translate("rs_mode_" + mode.name().toLowerCase(Locale.ENGLISH) + ".info", new Object[0])});
            Constraints.size((ConstrainedGeometry)btn, (double)76.0, (double)12.0);
            Constraints.placeInside((ConstrainedGeometry)btn, (ConstrainedGeometry)rsPanel, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_CENTER, (double)0.0, (double)(1.0 + y));
            y += btn.ySize() + 1.0;
        }
    }

    public List<Component> getTempStats(TileReactorCore tile) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)TOOLKIT.translate("reaction_temp", new Object[0]));
        list.add((Component)Component.m_237113_((String)(MathUtils.round((double)tile.temperature.get(), (double)10.0) + "C")));
        return list;
    }

    public List<Component> getShieldStats(TileReactorCore tile) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)TOOLKIT.translate("field_strength", new Object[0]));
        if (tile.maxShieldCharge.get() > 0.0) {
            list.add((Component)Component.m_237113_((String)(MathUtils.round((double)(tile.shieldCharge.get() / tile.maxShieldCharge.get() * 100.0), (double)100.0) + "%")));
        }
        list.add((Component)Component.m_237113_((String)(Utils.addCommas((int)((int)tile.shieldCharge.get())) + " / " + Utils.addCommas((int)((int)tile.maxShieldCharge.get())))));
        return list;
    }

    public List<Component> getSaturationStats(TileReactorCore tile) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)TOOLKIT.translate("energy_saturation", new Object[0]));
        if (tile.maxSaturation.get() > 0L) {
            list.add((Component)Component.m_237113_((String)(MathUtils.round((double)((double)tile.saturation.get() / (double)tile.maxSaturation.get() * 100.0), (double)100.0) + "%")));
        }
        list.add((Component)Component.m_237113_((String)(Utils.addCommas((long)tile.saturation.get()) + " / " + Utils.addCommas((long)tile.maxSaturation.get()))));
        return list;
    }

    public List<Component> getFuelStats(TileReactorCore tile) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)TOOLKIT.translate("fuel_conversion", new Object[0]));
        if (tile.reactableFuel.get() + tile.convertedFuel.get() > 0.0) {
            list.add((Component)Component.m_237113_((String)(MathUtils.round((double)(tile.convertedFuel.get() / (tile.reactableFuel.get() + tile.convertedFuel.get()) * 100.0), (double)100.0) + "%")));
        }
        list.add((Component)Component.m_237113_((String)(MathUtils.round((double)tile.convertedFuel.get(), (double)100.0) + " / " + MathUtils.round((double)(tile.convertedFuel.get() + tile.reactableFuel.get()), (double)100.0))));
        return list;
    }

    public static class IndicatorState
    implements SliderState {
        private final Supplier<Double> pos;

        public IndicatorState(Supplier<Double> pos) {
            this.pos = pos;
        }

        public double sliderRatio() {
            return 0.06779661016949153;
        }

        public double getPos() {
            return MathHelper.clip((double)(1.0 - this.pos.get()), (double)0.0, (double)1.0);
        }

        public void setPos(double pos) {
        }
    }

    public static class Screen
    extends ModularGuiContainer<ReactorMenu> {
        public Screen(ReactorMenu menu, Inventory inv, Component title) {
            super((AbstractContainerMenu)menu, inv, (ContainerGuiProvider)new ReactorGui());
            this.getModularGui().setGuiTitle((Component)Component.m_237115_((String)"gui.draconicevolution.reactor.title"));
        }
    }
}

